<?php
session_start();
include("../include/dbconnect.php");
include("../include/functions.php");


if ($_POST['action'] == "tf_load") {

    $m_stock_code = clean_data($_POST['m_stock_code']);
    $target_qty = clean_data($_POST['target_qty']);


    $comp_id = $_SESSION["comp_id"];

    try {
        $item_query = "SELECT
        d.lineitem,
	$target_qty*((d.qty/m.pack_qty)) qty,
	d.rate,
	d.stock_code,
	i.description stock_name,
	d.itemtot
FROM
	tf m
	LEFT JOIN tfdet d ON m.comp_id = d.comp_id 
	AND m.year_id = d.year_id 
	AND m.voucher_id = d.voucher_id
	LEFT JOIN item i ON d.stock_code = i.stock_code

WHERE m.stock_code = '$m_stock_code' ORDER BY d.lineitem/1";
        $item_result = $dbcon->prepare($item_query);
        $item_result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }



// Create empty array to hold query results
    $someArray = [];
// Loop through query and push results into $someArray;

    while ($item_row = $item_result->fetch(PDO::FETCH_ASSOC)) {


        $q_tot += round($item_row['qty']);

        $itemtot += round($item_row['itemtot']);


        //$total = $item_row['qty'] * $item_row['rate'];

        array_push($someArray, [
            'voucher_date' => format_date_yyyy($item_row['voucher_date']),

            'q_tot' => $q_tot,

            'item_tot' => $itemtot,


            'lineitem' => $item_row['lineitem'],
            'stock_code' => $item_row['stock_code'],
            'stock_name' => $item_row['stock_name'],
            'partuculars' => $item_row['partuculars'],
            'qty' => round($item_row['qty'],4),
            'rate' => round($item_row['rate']),
            'itemtot' => round($item_row['itemtot']),


        ]);
    }

// Convert the Array to a JSON String and echo it
    $someJSON = json_encode($someArray);
    echo $someJSON;
}
?>