<?php
header("Content-Type:application/json");
include("../include/dbconnect.php");



try
{
    $v_query =  "SELECT
                 i.stock_code,
                 i.description,
                 i.ur_description,
                 i.cat_id,
                 i.s_rate,
                 i.mol,
                 i.mol_qty,
                 i.msrp,
                 i.pack_size,
                 i.p_rate,
                 i.party_stock_code
       
                 FROM item i 
                 order by i.stock_code";
    $v_result = $dbcon->prepare($v_query);
    $v_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$someArray = [];
// Loop through query and push results into $someArray;

while ($item_row = $v_result->fetch(PDO::FETCH_OBJ)) {

    array_push($someArray, [

        'stock_code'   => $item_row->stock_code,
        'description'   => $item_row->description,
        'ur_description'   => $item_row->ur_description,
        'cat_id'   => $item_row->cat_id,
        's_rate'   => $item_row->s_rate,
        'mol'   => $item_row->mol,
        'mol_qty'   => $item_row->mol_qty,
        'msrp'   => $item_row->msrp,
        'pack_size'   => $item_row->pack_size,
        'p_rate'   => $item_row->p_rate,
        'party_stock_code'   => $item_row->party_stock_code

    ]);


}

// Convert the Array to a JSON String and echo it
$someJSON = json_encode($someArray);
echo $someJSON;





?>