<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}

$comp_id = clean_data($_SESSION["comp_id"]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $row->acct_name;?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="images/icons/favicon.ico">
    <link rel="apple-touch-icon" href="images/icons/favicon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.png">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.png">
    <!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/jquery-tablesorter/themes/blue/style-custom.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-news-ticker/jquery.news-ticker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style3/pink-blue.css" id="theme-change" class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
</head>
<body>

<div>

    <a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP-->



    <!--BEGIN TOPBAR-->
    <?php include ('header.php'); ?>
    <!--END TOPBAR-->


    <div id="wrapper">
        <!--BEGIN SIDEBAR MENU-->
        <?php include('left.php'); ?>
        <!--END SIDEBAR MENU-->


        <!--BEGIN PAGE WRAPPER-->
        <div id="page-wrapper">
            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
                <div class="page-header pull-left">
                    <div class="page-title">ADD NEW ITEM</div>
                </div>
                <ol class="breadcrumb page-breadcrumb pull-right">
                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.html">Home</a>&nbsp;&nbsp;<i
                                class="fa fa-angle-right"></i>&nbsp;&nbsp;
                    </li>
                    <li><a href="#">Tables</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>
                    <li class="active">Basic Tables</li>
                </ol>
                <div class="clearfix"></div>
            </div>
            <!--END TITLE & BREADCRUMB PAGE-->


            <!--BEGIN CONTENT-->
            <div class="page-content">


                <form class="" name="item_form" id="item_form" method="post" action="process/code_process.php" enctype="multipart/form-data">


                    <div class="form-group">
                        <label class="col-sm-2 control-label">Fabric Code</label>


                        <?php
                        try
                        {
                            $col_query =  "SELECT v.stock_code FROM v_select_fabric_stock v
					         ORDER BY v.stock_code ASC ";

                            $col_result = $dbcon->prepare($col_query);
                            $col_result->execute(array());
                        }
                        catch(PDOException $e)
                        {
                            echo "Error : ". $e->getMessage();
                        }

                        ?>

                        <select class="form-control" name="fabric_code" id="fabric_code">
                            <option></option>
                            <?php
                            while($col_row = $col_result->fetch(PDO::FETCH_OBJ))
                            {
                                echo '<option  value="' . $col_row->stock_code . '">' . $col_row->stock_code . '</option>';

                            }
                            ?>

                        </select>

                    </div>



                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Fabric Name</label>
                        <input type="text" class="form-control" name="fb_name" id="fb_name" readonly>
                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Fabric Style</label>
                        <input type="text" class="form-control" name="fb_style" id="fb_style" readonly>
                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Fabric Color</label>
                        <input type="text" class="form-control" name="fb_color" id="fb_color" readonly>
                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Estimated Amount</label>
                        <input type="text" class="form-control" name="fabric_cost" id="fabric_cost" readonly>
                    </div>

                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Total Qty</label>
                        <input type="text" class="form-control" name="tot_qty" id="tot_qty" readonly>
                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Per Unit</label>
                        <input type="text" class="form-control" name="per_unit" id="per_unit" readonly>
                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Estimated Retail Value</label>
                        <input type="text" class="form-control" name="retail_value" id="retail_value" readonly>
                    </div>























                    <div class="form-group">
                        <label class="col-sm-2 control-label">Collection</label>


                        <?php
                        try
                        {
                            $col_query =  "SELECT col.col_id, col.description col_name FROM code_collection col
					         ORDER BY col.col_id ASC ";

                            $col_result = $dbcon->prepare($col_query);
                            $col_result->execute(array());
                        }
                        catch(PDOException $e)
                        {
                            echo "Error : ". $e->getMessage();
                        }

                        ?>

                        <select class="form-control" name="stockcol_id" id="stockcol_id" required>
                            <option></option>
                            <?php
                            while($col_row = $col_result->fetch(PDO::FETCH_OBJ))
                            {
                                echo '<option  value="' . $col_row->col_id . '">' . $col_row->col_name . '</option>';

                            }
                            ?>

                        </select>

                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Category</label>

                        <?php
                        try
                        {
                            $cat_query =  "SELECT ct.cat_id, ct.description cat_name FROM code_cat ct
					         ORDER BY ct.cat_id ASC ";

                            $cat_result = $dbcon->prepare($cat_query);
                            $cat_result->execute(array());
                        }
                        catch(PDOException $e)
                        {
                            echo "Error : ". $e->getMessage();
                        }

                        ?>

                        <select class="form-control" name="stockcat_id" id="stockcat_id" required>
                            <option></option>
                            <?php
                            while($cat_row = $cat_result->fetch(PDO::FETCH_OBJ))
                            {
                                echo '<option  value="' . $cat_row->cat_id . '">' . $cat_row->cat_name . '</option>';

                            }
                            ?>

                        </select>

                    </div>


                    <div class="form-group">
                        <label class="col-sm-2 control-label">Type</label>


                        <?php
                        try
                        {
                            $type_query =  "SELECT type_id, type_name FROM type ORDER BY type_id";

                            $type_result = $dbcon->prepare($type_query);
                            $type_result->execute(array());
                        }
                        catch(PDOException $e)
                        {
                            echo "Error : ". $e->getMessage();
                        }

                        ?>
                        <select class="form-control" name="type_id" id="type_id" required>
                            <option></option>
                            <?php
                            $co_query = mysql_query(" ");
                            while($type_row = $type_result->fetch(PDO::FETCH_ASSOC))
                            {
                                echo '<option value="'.$type_row["type_id"].'">'.$type_row["type_name"].'</option>';
                            }
                            ?>
                        </select>

                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Color</label>

                        <?php
                        try
                        {
                            $color_query =  "SELECT color_id, description FROM color ORDER BY color_id";

                            $color_result = $dbcon->prepare($color_query);
                            $color_result->execute(array());
                        }
                        catch(PDOException $e)
                        {
                            echo "Error : ". $e->getMessage();
                        }
                        ?>
                        <select class="form-control" name="code_color" id="code_color" required>
                            <option></option>
                            <?php

                            while($color_row = $color_result->fetch(PDO::FETCH_ASSOC))
                            {
                                echo '<option value="'.$color_row["color_id"].'">'.$color_row["description"].'</option>';
                            }
                            ?>
                        </select>

                    </div>



                    <div class="form-group">
                        <label class="col-sm-2 control-label">Season</label>

                        <?php
                        try
                        {
                            $season_query =  "SELECT season_id, description FROM season_cat ORDER BY season_id";

                            $season_result = $dbcon->prepare($season_query);
                            $season_result->execute(array());
                        }
                        catch(PDOException $e)
                        {
                            echo "Error : ". $e->getMessage();
                        }
                        ?>
                        <select class="form-control" name="season_id" id="season_id" required>
                            <option></option>
                            <?php
                            $co_query = mysql_query(" ");
                            while($season_row = $season_result->fetch(PDO::FETCH_ASSOC))
                            {
                                echo '<option value="'.$season_row["season_id"].'">'.$season_row["description"].'</option>';
                            }
                            ?>
                        </select>

                    </div>

                    <!--<div class="form-group">
                        <label class="col-sm-2 control-label">Color</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="code_color" id="code_color">
                                <option value="BL">Black</option>
                                <option value="GR">Green</option>
                                <option value="WH">White</option>
                            </select>
                        </div>
                    </div>-->



                    <!--<div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Small Qty</label>
                        <div class="col-sm-5">
                            <input type="hidden" class="form-control" name="hd_small" id="hd_small" value="08" >
                            <input type="text" class="form-control tot_qty" name="small" id="small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" >
                        </div>
                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Medium Qty</label>
                        <div class="col-sm-5">
                            <input type="hidden" class="form-control" name="hd_medium" id="hd_medium" value="09" >
                            <input type="text" class="form-control tot_qty" name="medium" id="medium" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" >
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Large Qty</label>
                        <div class="col-sm-5">
                            <input type="hidden" class="form-control" name="hd_lg" id="hd_lg" value="10" >
                            <input type="text" class="form-control tot_qty" name="large" id="large" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" >
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">XLarge Qty</label>
                        <div class="col-sm-5">
                            <input type="hidden" class="form-control" name="hd_xlg" id="hd_xlg" value="11" >
                            <input type="text" class="form-control tot_qty" name="xlarge" id="xlarge" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" >
                        </div>
                    </div>-->

                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Small Qty</label>

                        <input type="hidden" class="form-control" name="hd_small" id="hd_small" value="08" >
                        <input type="text" class="form-control tot_qty" name="small" id="small" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" required data-parsley-type="number" >

                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Medium Qty</label>

                        <input type="hidden" class="form-control" name="hd_medium" id="hd_medium" value="09" >
                        <input type="text" class="form-control tot_qty" name="medium" id="medium" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" required data-parsley-type="number" >

                    </div>

                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Large Qty</label>

                        <input type="hidden" class="form-control" name="hd_lg" id="hd_lg" value="10" >
                        <input type="text" class="form-control tot_qty" name="large" id="large" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" required data-parsley-type="number" >

                    </div>

                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">XLarge Qty</label>

                        <input type="hidden" class="form-control" name="hd_xlg" id="hd_xlg" value="11" >
                        <input type="text" class="form-control tot_qty" name="xlarge" id="xlarge" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" required data-parsley-type="number" >

                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Description</label>

                        <input type="text" class="form-control" name="description" id="stock_description" >

                    </div>





                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Name of Article</label>

                        <input type="text" class="form-control" name="article_name" id="article_name" autocomplete="on">

                    </div>





                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Opening Rate</label>

                        <input type="text" class="form-control" name="o_rate" id="o_rate" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" required data-parsley-type="number" >

                    </div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Front Image</label>

                        <input type="file"  name="front_img" id="front_img" >

                    </div>

                    <div class="gallery" id="images_preview_front"></div>


                    <div class="form-group">
                        <label for="country" class="col-sm-2 control-label">Back Image</label>

                        <input type="file"  name="back_img" id="back_img" >

                    </div>


                    <div class="gallery" id="images_preview_back"></div>


                    <div class="form-group">
                        <div class="col-sm-offset-2 col-sm-10">

                            <button type="submit" class="btn btn-success" ><span class="glyphicon glyphicon-floppy-disk"></span> Save</button>
                        </div>
                    </div>


                </form>




            </div>
        </div>
    </div>

    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/jquery-ui.js"></script>
    <!--loading bootstrap js-->
    <script src="vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
    <script src="js/html5shiv.js"></script>
    <script src="js/respond.min.js"></script>
    <script src="vendors/metisMenu/jquery.metisMenu.js"></script>
    <script src="vendors/slimScroll/jquery.slimscroll.js"></script>
    <script src="vendors/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendors/iCheck/icheck.min.js"></script>
    <script src="vendors/iCheck/custom.min.js"></script>
    <script src="vendors/jquery-news-ticker/jquery.news-ticker.js"></script>
    <script src="js/jquery.menu.js"></script>
    <script src="vendors/jquery-pace/pace.min.js"></script>
    <script src="vendors/holder/holder.js"></script>
    <script src="vendors/responsive-tabs/responsive-tabs.js"></script>
    <!--LOADING SCRIPTS FOR PAGE-->
    <script src="vendors/jquery-tablesorter/jquery.tablesorter.js"></script>
    <script src="js/table-advanced.js"></script>
    <!--CORE JAVASCRIPT-->
    <script src="js/main.js"></script>


    <!----------------------------START JAVA SCRIPT---------------------------->
    <script type="text/javascript">


        $(document).ready(function(){
            $('form').parsley();
        });




        $("#fabric_code").change(function () {
            var fabric_code = $('#fabric_code').val();



            var action = 'gen_id';


            var dataString = 'fabric_code=' + fabric_code + '&action=' + action;
            $.ajax({
                type: "POST",
                url: "ajax/get_fabric_detail",
                data: dataString,
                success: function (data, status) {



                    // PARSE json data
                    var user = JSON.parse(data);
                    // Assing existing values to the modal popup fields
                    $("#fb_name").val(user.fabric_cat_name);

                    $("#fb_style").val(user.detail);

                    $("#fb_color").val(user.color_name);
                    $("#fabric_cost").val(user.amt);
                    $("#tot_qty").val(user.per_unit);


                    var total_amt = $("#fabric_cost").val();

                    var tot_qty = $("#tot_qty").val();

                    var per_unit = $('#per_unit').val(total_amt/tot_qty);

                    var company_margin_p = 100;
                    var margin_rate_p = 70;
                    var tax_rate_p = 95;

                    var per_unit = $('#per_unit').val();

                    var comp_margin_value =  per_unit * (1+company_margin_p/100);

                    var margin_value = comp_margin_value * 100/margin_rate_p;

                    var retail_value = margin_value * 100/tax_rate_p;


                    alert(retail_value);

                    var tot_qty = $("#retail_value").val(retail_value);








                }
            });


        });



































    </script>














</body>
</html>