<?php


$cur_date_time =  date('Y-m-d h:i:s');

//function for date format 7-01-15
function format_date($dDate)
{

    return substr($dDate, 8, 2) . '-' . substr($dDate, 5, 2) . '-' . substr($dDate, 2, 2);
}




function format_date_yyyy($dDate)
{
    return substr($dDate, 8, 2) . '-' . substr($dDate, 5, 2) . '-' . substr($dDate, 0, 4);
}


function format_date_trim_time($dDate)
{
    return substr($dDate, 0, 10);
}

function format_date_time($dDate)
{
    return substr($dDate, 8, 2) . '-' . substr($dDate, 5, 2) . '-' . substr($dDate, 2, 2) . ' ' . substr($dDate, 11);
}

//clean white spaces and special characters from vlaues
function clean_data($data)
{
    $data = trim($data);
    $data = htmlspecialchars($data);
    $data = stripslashes($data);
    //$data = mysql_real_escape_string($data);
    $data = strip_tags($data);

    return $data;
}

//find value in table
function find_value($cTable, $f, $cAnd)
{
    include("dbconnect.php");
    try {

        $q = "SELECT $f f FROM $cTable WHERE 1 = 1 $cAnd";
        //echo $q;

        $result = $dbcon->prepare($q);
        $result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }



    $value = "";
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $value = $row['f'];
    }


    return $value;
}

//function for table name
function TableName($table)
{
    $un = $_SESSION["un"];
    if (empty($un)) {
        $un = "";
    }
    return $un . $table;
}


//function create for musql master table
function  find_m_table($voucher_type)
{
    switch ($voucher_type) {
        case 'SO';
            $t_m = TableName('sl_order');    //sale order master table

            break;

        case 'SL';
            $t_m = TableName('sl_invoice');    // sale invoice master table
            break;

        case 'DC';
            $t_m = TableName('sl_dc');        // dc master table
            break;

        case 'OG';
            $t_m = TableName('sl_gp');        // gate pass master table
            break;

        case 'PO';
            $t_m = TableName('pl_order');    // purchase order master table
            break;

        case 'IG';
            $t_m = TableName('pl_gp');        // purchase gate pass master table
            break;

        case 'PL';
            $t_m = TableName('pl_invoice');    // puchase invoice master table
            break;

        case 'FG';
            $t_m = TableName('stk_con');    // stock production master table
            break;

        case 'PP';
            $t_m = TableName('pl_pay');        // purchase payment master table
            break;

        case 'SR';
            $t_m = TableName('sl_pay');        // sale receipts master table
            break;

        case 'PJ';
            $t_m = TableName('pl_jv');        // purchase journal master table
            break;

        case 'SJ';
            $t_m = TableName('sl_jv');        // sale journal master table
            break;

        case 'RT';
            $t_m = TableName('sl_return');        // sale journal master table
            break;

        case 'AD';
            $t_m = TableName('sl_audit');        // sale journal master table
            break;

        case 'CS';
            $t_m = TableName('sl_stock_return');        // sale journal master table
            break;
    }

    return $t_m;
}

//function create for musql detail table
function  find_d_table($voucher_type)
{
    switch ($voucher_type) {
        case 'SO';

            $t_d = TableName('sl_orderdet');    //sale order detail table
            break;

        case 'SL';
            $t_d = TableName('sl_invoicedet');    // sale invoice detail table
            break;

        case 'DC';
            $t_d = TableName('sl_dcdet');        // dc detail table
            break;

        case 'OG';
            $t_d = TableName('sl_gpdet');        //sale gate pass detail table
            break;

        case 'PO';
            $t_d = TableName('pl_orderdet');    // purchase order detail table
            break;

        case 'IG';
            $t_d = TableName('pl_gpdet');        // purchase gate pass detail table
            break;

        case 'PL';
            $t_d = TableName('pl_invoicedet');    // purchase invoice detail table
            break;

        case 'FG';
            $t_d = TableName('stk_condet');        // stock production detail table
            break;


        case 'PP';
            $t_d = TableName('pl_paydet');        // stock production detail table
            break;

        case 'SR';
            $t_d = TableName('sl_paydet');        // sale receipts detail table
            break;

        case 'PJ';
            $t_d = TableName('pl_jvdet');        //purchase journal detail table
            break;

        case 'SJ';
            $t_d = TableName('sl_jvdet');        //sale journal detail table
            break;
        case 'RT';
            $t_d = TableName('sl_returndet');        //sale journal detail table
            break;

        case 'AD';
            $t_d = TableName('sl_auditdet');        //sale journal detail table
            break;

        case 'CS';
            $t_d = TableName('sl_stock_returndet');        //sale journal detail table
            break;
    }

    return $t_d;
}

function format_number($total, $n)

{



    if ($total == 0 or !isset($total)) {

        return '&nbsp';
    } else {

        return number_format($total, $n);
    }
}

function format_number_pdf($total, $n)

{


    if ($total == 0 or !isset($total)) {

        return '';
    } else {

        return number_format($total, $n);
    }
}


function format_number_drcr($total, $n)

{



    if ($total == 0 or !isset($total)) {

        return '';
    } else {

        if ($total < 0) {

            $total = number_format(abs($total), $n) . ' Cr';
        } else if ($total > 0) {
            $total = number_format($total, $n) . ' Dr';
        }

        return $total;
    }
}


/***********START FUNCTION FOR AVG RATE***************/
function find_avg_rate($v_date, $stock_code)
{
    require('dbconnect.php');

    $total = 0;


    try {

        $qd = "SELECT avg(d.rate) total
	 	  from pl_invoice v
  		left join pl_invoicedet d on v.comp_id = d.comp_id and v.year_id = d.year_id and v.voucher_id=d.voucher_id
        	where ifnull(v.bill_date,v.voucher_date)<='$v_date' and d.stock_code='$stock_code'";

        /*
        $qd = "SELECT sum(d.db_amt-d.cr_amt)/sum(d.db_qty-d.cr_qty) total
	 	        from v_p_vouchers d
                where d.voucher_date<='$v_date' and d.stock_code='$stock_code'";
*/

        $resultd = $dbcon->prepare($qd);
        $resultd->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
    $rowd = $resultd->fetch(PDO::FETCH_ASSOC);
    if (isset($rowd["total"])) $total = $rowd["total"];

    return $total;
}
/***********END FUNCTION FOR AVG RATE***************/

/***********START FUNCTION FOR AVG RATE***************/
function update_avg_rates($comp_id, $year_id, $voucher_id, $posted, $from_date, $to_date, $missing, $stock_code)
{
    require('dbconnect.php');

    try {
    $qc = "SELECT c.comp_id
		 	  from company c
		 	  ORDER BY c.comp_id";

    $result_qc = $dbcon->prepare($qc);
        $result_qc->execute(array());
} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}


    while ($row_qc = $result_qc->fetch(PDO::FETCH_OBJ)) {

        $g_comp_id = $row_qc->comp_id;


        $total = 0;
        $and = "";
        //$and .= " and v.comp_id = 'KT'";
        $and .= " and v.voucher_date BETWEEN '$from_date'  AND '$to_date'";
        //echo $missing;

        //    $missing=='N';
        if ($missing == 'Y') {
            $and .= " and v.stock_code in(SELECT DISTINCT d.stock_code 
			FROM
			sl_invoice m
			LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id 
			WHERE ifnull(d.avg_rate,0)=0)";
        }

        if (!empty($voucher_id)) {
            $and .= " and v.stock_code in(select v.stock_code from v_stk v where v.voucher_id = concat('SL','$voucher_id'))";
        }

        if (!empty($stock_code)) {
            $and .= " and v.stock_code in(select v.stock_code from v_stk v where v.stock_code = '$stock_code')";
        }


        try {

            $q = "SELECT v.*, ifnull(o.o_qty,0) o_qty, ifnull(o.o_amt,0) o_amt
		 	  from v_stk v
		 	  left join (select stock_code, sum(db_qty-cr_qty) o_qty, sum(db_amt-cr_amt) o_amt from v_stk where voucher_date<'$from_date' group by stock_code) o on v.stock_code=o.stock_code
		 	  where 1=1 $and and 1=1
	 	      ORDER BY v.stock_code,v.voucher_date, v.voucher_order, v.voucher_id";
            echo $q;
            //exit ();
            $result_q = $dbcon->prepare($q);
            $result_q->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        $stock_code = '';
        while ($row_qd = $result_q->fetch(PDO::FETCH_OBJ)) {


            if ($stock_code <> $row_qd->stock_code) {

                $stock_code = $row_qd->stock_code;
                $bal_qty = $row_qd->o_qty;
                $bal_amt = $row_qd->o_amt;

                $bal_rate = 0;
                if ($bal_qty <> 0)
                    $bal_rate = round($bal_amt / $bal_qty, 2);

                $ser = 0;
            }

            $ser += 1;
            $comp_id = $row_qd->comp_id;
            $year_id = $row_qd->year_id;
            $voucher_id = substr($row_qd->voucher_id, -6);

            $lineitem = $row_qd->lineitem;

            $update_query = "SELECT count(*) from company where 1=2";

            if ($row_qd->db_qty <> 0) {
                $bal_qty += $row_qd->db_qty;
                $bal_amt += $row_qd->db_amt;

                if ($bal_qty <= 0) {
                    $bal_rate = 0;
                } else {
                    $bal_rate = round($bal_amt / $bal_qty, 2);
                }

                if (substr($row_qd->voucher_id, 0, 2) == 'RT') {
                    $update_query = "UPDATE sl_returndet SET avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                }
            } else {

                if ($bal_qty > 0) {
                    $bal_qty -= $row_qd->cr_qty;
                    $bal_amt -= $row_qd->cr_qty * $bal_rate;
                }

                if (substr($row_qd->voucher_id, 0, 2) == 'SL') {
                    $update_query = "UPDATE sl_invoicedet SET avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                } else if (substr($row_qd->voucher_id, 0, 2) == 'DC') {
                    $update_query = "UPDATE sl_dcdet SET avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                } else if (substr($row_qd->voucher_id, 0, 2) == 'ST') {
                    $update_query = "UPDATE stk_transdet SET rate = '$bal_rate', itemtot=qty*'$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                } else if (substr($row_qd->voucher_id, 0, 2) == 'CO') {
                    $update_query = "UPDATE mo_issue_det SET rate = '$bal_rate', itemtot = qty * '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                } else if (substr($row_qd->voucher_id, 0, 2) == 'RT') {
                    $update_query = "UPDATE sl_returndet SET avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                }
                //                  echo $update_query;

            }

            try {
                $results = $dbcon->prepare($update_query);
                $results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
}
/***********END FUNCTION FOR AVG RATE***************/

/***********START FUNCTION FOR AVG RATE  - Backup 1***************/
function update_avg_rates_backup_1($comp_id, $year_id, $voucher_id, $posted, $from_date, $to_date, $missing, $stock_code)
{
    require('dbconnect.php');

    //echo '2'.$missing;

    //echo '2'.$stock_code;

    $total = 0;
    //	$missing='N';
    $and = "";
    //    $and .= " and v.comp_id = '$comp_id'";
    $and .= " and v.voucher_date BETWEEN '$from_date'  AND '$to_date'";

    //$and .= " and v.year_id = '$year_id'";
    // $and .=" and v.stock_code >= '0072' and v.stock_code <= '0072' ";

    /* Running slow
            $and .=" and v.stock_code in(SELECT DISTINCT d.stock_code
                FROM
                sl_invoice m
                LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id
                union all
                SELECT DISTINCT d.stock_code
                FROM
                mo_issue m
                LEFT JOIN mo_issue_det d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id and m.ser_no=d.ser_no
                WHERE  1=1 $and)";
    */

    if ($missing <> 'N') {
        $and .= " and v.stock_code in(SELECT DISTINCT d.stock_code 
			FROM
			sl_invoice m
			LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id 
			WHERE ifnull(d.avg_rate,0)=0)";
    }

    if (!empty($voucher_id)) {
        $and .= " and v.stock_code in(select v.stock_code from v_stk v where v.voucher_id = concat('SL','$voucher_id'))";
    }

    if (!empty($stock_code)) {
        $and .= " and v.stock_code in(select v.stock_code from v_stk v where v.stock_code = '$stock_code')";
    }


    try {

        $q = "SELECT distinct v.stock_code, o.bal_qty, o.bal_amt
		 	  from v_stk v
		 	  left join (select stock_code, sum(db_qty-cr_qty) bal_qty, sum(db_amt-cr_amt) bal_amt from v_stk where voucher_date<'$from_date' group by stock_code) o on v.stock_code=o.stock_code
		 	  where 1=1 $and and 1=1
	 	      ORDER BY v.stock_code ";
        //echo $q;
        //exit ();
        $result_q = $dbcon->prepare($q);
        $result_q->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }


    while ($row_q = $result_q->fetch(PDO::FETCH_OBJ)) {
        $stock_code = $row_q->stock_code;
        $bal_qty = $row_q->bal_qty;
        $bal_amt = $row_q->bal_amt;

        $bal_rate = 0;
        if ($bal_qty <> 0)
            $bal_rate = round($bal_amt / $bal_qty, 0);

        try {
            $qd = "SELECT v.*
        	 	  from v_stk v
	 	          where 1 = 1 $and and v.stock_code='$stock_code'
                  ORDER BY v.bill_date, v.voucher_order, v.voucher_id
                  ";
            echo $qd;
            $result_qd = $dbcon->prepare($qd);
            $result_qd->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }


        //        $bal_qty=0;
        //        $bal_amt=0;
        //        $bal_rate=0;

        $ser = 0;
        while ($row_qd = $result_qd->fetch(PDO::FETCH_OBJ)) {
            $ser += 1;
            $comp_id = $row_qd->comp_id;
            $year_id = $row_qd->year_id;
            $voucher_id = substr($row_qd->voucher_id, -6);

            $lineitem = $row_qd->lineitem;

            if ($row_qd->db_qty <> 0) {
                $bal_qty += $row_qd->db_qty;
                $bal_amt += $row_qd->db_amt;

                if ($bal_qty <= 0) {
                    $bal_rate = 0;
                } else {
                    $bal_rate = round($bal_amt / $bal_qty, 0);
                }
            } else {

                if ($bal_qty > 0) {
                    $bal_qty -= $row_qd->cr_qty;
                    $bal_amt -= $row_qd->cr_qty * $bal_rate;
                }
                $update_query = "SELECT count(*) from company where 1=2";
                if (substr($row_qd->voucher_id, 0, 2) == 'SL') {
                    $update_query = "UPDATE sl_invoicedet SET avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                } else if (substr($row_qd->voucher_id, 0, 2) == 'ST') {
                    $update_query = "UPDATE stk_transdet SET avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                } else if (substr($row_qd->voucher_id, 0, 2) == 'MO') {
                    $update_query = "UPDATE mo_issue_det SET rate = '$bal_rate', itemtot = qty * '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                }
                //echo $update_query;



                try {

                    //echo  $ser.'.'.$row_qd->voucher_id;
                    //echo  $ser.'.'.substr($row_qd->voucher_id,0,2);
                    //echo "<br>";
                    $results = $dbcon->prepare($update_query);
                    $results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }
            }
        }
    }
}
/***********END FUNCTION FOR AVG RATE - Backup 1***************/

/***********START FUNCTION FOR AVG RATE***************/
function update_avg_rates_type_id($comp_id, $year_id, $voucher_id, $posted, $from_date, $to_date, $missing, $type_id)
{
    require('dbconnect.php');

    $total = 0;
    $and = "";
    $and .= " and v.voucher_date BETWEEN '$from_date'  AND '$to_date'";

    if ($missing == 'N') {
        $and .= " and v.type_id in(SELECT DISTINCT d.type_id 
			FROM
			sl_invoice m
			LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id 
			WHERE  1=1 $and)";
    } else {
        $and .= " and v.type_id in(SELECT DISTINCT d.type_id 
			FROM
			sl_invoice m
			LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id 
			WHERE ifnull(d.type_avg_rate,0)=0)";
    }

    if (!empty($voucher_id)) {
        $and .= " and v.type_id in(select v.type_id from v_stk v where v.voucher_id = concat('SL','$voucher_id'))";
    }

    /*
    if (!empty(type_id)) {
        $and .= " and v.type_id in(select v.type_id from v_stk v where v.type_id = '$type_id')";
    }
*/

    try {

        $q = "SELECT distinct v.type_id, o.bal_qty, o.bal_amt
		 	  from v_stk v
		 	  left join (select type_id, sum(db_qty-cr_qty) bal_qty, sum(db_amt-cr_amt) bal_amt from v_stk where voucher_date<'$from_date' group by type_id) o on v.type_id=o.type_id
		 	  where 1=1 $and and 1=1
	 	      ORDER BY v.stock_code ";
        //echo $q;

        $result_q = $dbcon->prepare($q);
        $result_q->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }


    while ($row_q = $result_q->fetch(PDO::FETCH_OBJ)) {
        $type_id = $row_q->type_id;
        $bal_qty = $row_q->bal_qty;
        $bal_amt = $row_q->bal_amt;

        $bal_rate = 0;
        if ($bal_qty <> 0)
            $bal_rate = round($bal_amt / $bal_qty, 2);

        try {
            $qd = "SELECT v.*
        	 	  from v_stk v
	 	          where 1 = 1 $and and v.type_id='$type_id'
                  ORDER BY v.bill_date, v.voucher_order, v.voucher_id
                  ";
            //echo $qd;
            $result_qd = $dbcon->prepare($qd);
            $result_qd->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }


        //        $bal_qty=0;
        //        $bal_amt=0;
        //        $bal_rate=0;

        $ser = 0;
        while ($row_qd = $result_qd->fetch(PDO::FETCH_OBJ)) {
            $ser += 1;
            $comp_id = $row_qd->comp_id;
            $year_id = $row_qd->year_id;
            $voucher_id = substr($row_qd->voucher_id, -6);

            $lineitem = $row_qd->lineitem;

            if ($row_qd->db_qty <> 0) {
                $bal_qty += $row_qd->db_qty;
                $bal_amt += $row_qd->db_amt;

                if ($bal_qty <= 0) {
                    $bal_rate = 0;
                } else {
                    $bal_rate = round($bal_amt / $bal_qty, 2);
                }
            } else {

                if ($bal_qty > 0) {
                    $bal_qty -= $row_qd->cr_qty;
                    $bal_amt -= $row_qd->cr_qty * $bal_rate;
                }
                $update_query = "SELECT count(*) from company where 1=2";
                if (substr($row_qd->voucher_id, 0, 2) == 'SL') {
                    $update_query = "UPDATE sl_invoicedet SET type_avg_rate = '$bal_rate'
                    WHERE  comp_id = '$comp_id' AND year_id = '$year_id'  and voucher_id  = '$voucher_id' and lineitem = '$lineitem'";
                }
                //echo $update_query;


                try {

                    $results = $dbcon->prepare($update_query);
                    $results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }
            }
        }
    }
}
/***********END FUNCTION FOR AVG RATE***************/








function unformat_date($cDate)
{


    if ($cDate == '')
        $cDate = '00-00-0000';
    $d = (substr($cDate, 6, 4) . "-" . substr($cDate, 3, 2) . "-" . substr($cDate, 0, 2));
    return $d;
}










//function backup tables send to email

function backup_tables($tables = '*')
{
    global $strUN, $email;

    #  $link = mysql_connect($host,$user,$pass);
    #  mysql_select_db($name,$link);
    #  $handle = fopen('db-backup-'.time().'.sql','w+');
    $tables = '*';
    $email = 'Y';
    if ($tables == '*') {
        $tables = array();
        $result = mysql_query('SHOW TABLES');
        while ($row = mysql_fetch_row($result)) {

            if (substr($row[0], -12) <> "user_profile")

                if (substr($row[0], 0, strlen($strUN)) == $strUN)
                    $tables[] = $row[0];
        }
    } else {
        $tables = is_array($tables) ? $tables : explode(',', $tables);
    }

    $return = ' ';
    //cycle through
    foreach ($tables as $table) {
        $result = mysql_query('SELECT * FROM ' . $table);
        $num_fields = mysql_num_fields($result);

        $return .= 'DROP TABLE IF EXISTS ' . $table . ';';
        $row2 = mysql_fetch_row(mysql_query('SHOW CREATE TABLE ' . $table));
        $return .= "\n\n" . $row2[1] . ";\n\n";

        for ($i = 0; $i < $num_fields; $i++) {
            while ($row = mysql_fetch_row($result)) {
                $return .= 'INSERT INTO ' . $table . ' VALUES(';
                for ($j = 0; $j < $num_fields; $j++) {
                    $row[$j] = addslashes($row[$j]);
                    $row[$j] = ereg_replace("\n", "\\n", $row[$j]);
                    if (isset($row[$j])) {
                        $return .= '"' . $row[$j] . '"';
                    } else {
                        $return .= '""';
                    }
                    if ($j < ($num_fields - 1)) {
                        $return .= ',';
                    }
                }
                $return .= ");\n";
            }
        }
        $return .= "\n\n\n";
    }


    //save file


    #uncompress(�test.gz�,�test2.php�);


    if ($email == 'Y') {

        #$attach_filepath='db-backup-'.time().'.sql';
        $attach_filepath = 'db-backup.sql';

        $handle = fopen($attach_filepath, 'w+');
        fwrite($handle, $return);
        fclose($handle);

        //compress($attach_filepath,'db-backup.gz');
        #$attach_filepath='db-backup.gz';

        $email_id = find_value('system', "email", "");
        send_email($email_id, $attach_filepath);

        $attach_filepath = 'data/db-backup.sql';
        //compress($attach_filepath,'data/db-backup-'.time().'.gz');

    } else {

        $attach_filepath = 'data/db-backup.sql';

        $handle = fopen($attach_filepath, 'w+');
        fwrite($handle, $return);
        fclose($handle);

        //compress($attach_filepath,'data/db-backup-'.time().'.gz');

    }
}

function send_email($email_id, $attach_filepath)
{
    global $strUN;

    $to = "$email_id";
    //define the subject of the email
    $subject = $strUN . 'Database Backup';
    //create a boundary string. It must be unique
    //so we use the MD5 algorithm to generate a random hash
    $random_hash = md5(date('r', time()));
    //define the headers we want passed. Note that they are separated with \r\n
    $headers = "From: support@clicksoft.com.pk\r\nReply-To: support@clicksoft.com.pk";
    //add boundary string and mime type specification
    $headers .= "\r\nContent-Type: multipart/mixed; boundary=\"PHP-mixed-" . $random_hash . "\"";
    //read the atachment file contents into a string,
    //encode it with MIME base64,
    //and split it into smaller chunks
    $attachment = chunk_split(base64_encode(file_get_contents($attach_filepath)));
    //define the body of the message.
    ob_start(); //Turn on output buffering
?>
    --PHP-mixed-<?php echo $random_hash; ?>
    Content-Type: multipart/alternative; boundary="PHP-alt-<?php echo $random_hash; ?>"

    --PHP-alt-<?php echo $random_hash; ?>
    Content-Type: text/plain; charset="iso-8859-1"
    Content-Transfer-Encoding: 7bit


    --PHP-alt-<?php echo $random_hash; ?>
    Content-Type: text/html; charset="iso-8859-1"
    Content-Transfer-Encoding: 7bit

    <h2>Hello Sir,</h2>
    <p>Database Backup File Attached</p>

    --PHP-alt-<?php echo $random_hash; ?>--

    --PHP-mixed-<?php echo $random_hash; ?>
    Content-Type: text/html; name=<?php echo $attach_filepath ?>
    Content-Transfer-Encoding: base64
    Content-Disposition: attachment

    <?php echo $attachment; ?>
    --PHP-mixed-<?php echo $random_hash; ?>--

<?php
    //copy current buffer contents into $message variable and delete current output buffer
    $message = ob_get_clean();
    //send the email
    $mail_sent = @mail($to, $subject, $message, $headers);
    //if the message is sent successfully print "Mail sent". Otherwise print "Mail failed"
    echo $mail_sent ? "Mail sent" : "Mail failed";
}

function compress($srcName, $dstName)
{
    $fp = fopen($srcName, "r");
    $data = fread($fp, filesize($srcName));
    fclose($fp);

    $zp = gzopen($dstName, "w9");
    gzwrite($zp, $data);
    gzclose($zp);
}

function uncompress($srcName, $dstName)
{
    $string = implode("", gzfile($srcName));
    $fp = fopen($dstName, "w");
    fwrite($fp, $string, strlen($string));
    fclose($fp);
}



//function for diff two dates find days
function dateDiff($start, $end)
{
    $start_ts = strtotime($start);
    $end_ts = strtotime($end);
    $diff = $end_ts - $start_ts;
    return round($diff / 86400);
}







/*function timeAgo($time_ago){
	$cur_time 	= time();

	$time_elapsed 	= $cur_time - $time_ago;
	$seconds 	= $time_elapsed ;
	$minutes 	= round($time_elapsed / 60 );
	$hours 		= round($time_elapsed / 3600);
	$days 		= round($time_elapsed / 86400 );
	$weeks 		= round($time_elapsed / 604800);
	$months 	= round($time_elapsed / 2600640 );
	$years 		= round($time_elapsed / 31207680 );
// Seconds
	if($seconds <= 60){
		echo "$seconds seconds ago";
	}
//Minutes
	else if($minutes <=60){
		if($minutes==1){
			echo "one minute ago";
		}
		else{
			echo "$minutes minutes ago";
		}
	}
//Hours
	else if($hours <=24){
		if($hours==1){
			echo "an hour ago";
		}else{
			echo "$hours hours ago";
		}
	}
//Days
	else if($days <= 7){
		if($days==1){
			echo "yesterday";
		}else{
			echo "$days days ago";
		}
	}
//Weeks
	else if($weeks <= 4.3){
		if($weeks==1){
			echo "a week ago";
		}else{
			echo "$weeks weeks ago";
		}
	}
//Months
	else if($months <=12){
		if($months==1){
			echo "a month ago";
		}else{
			echo "$months months ago";
		}
	}
//Years
	else{
		if($years==1){
			echo "one year ago";
		}else{
			echo "$years years ago";
		}
	}
}*/



function timeAgo($datetime)
{
    $time_ago   = strtotime($datetime);
    $cur_time   = time();
    $time_elapsed   = $cur_time - $time_ago;
    $seconds    = $time_elapsed;
    $minutes    = round($time_elapsed / 60);
    $hours      = round($time_elapsed / 3600);
    $days       = round($time_elapsed / 86400);
    $weeks      = round($time_elapsed / 604800);
    $months     = round($time_elapsed / 2600640);
    $years      = round($time_elapsed / 31207680);
    // Seconds
    if ($seconds <= 60) {
        return "Just now";
    }
    //Minutes
    else if ($minutes <= 60) {
        if ($minutes == 1) {
            return "One minute ago";
        } else {
            return "$minutes minutes ago";
        }
    }
    //Hours
    else if ($hours <= 24) {
        if ($hours == 1) {
            return "an Hour ago";
        } else {
            return "$hours Hours ago";
        }
    }
    //Days
    else if ($days <= 7) {
        if ($days == 1) {
            return "Yesterday";
        } else {
            return "$days days ago";
        }
    }
    //Weeks
    else if ($weeks <= 4.3) {
        if ($weeks == 1) {
            return "a Week ago";
        } else {
            return "$weeks weeks ago";
        }
    }
    //Months
    else if ($months <= 12) {
        if ($months == 1) {
            return "a Month ago";
        } else {
            return "$months months ago";
        }
    }
    //Years
    else {
        if ($years == 1) {
            return "One year ago";
        } else {
            return "$years years ago";
        }
    }
}




function backup_db()
{
    //declare database variables
    /*$db_host = "localhost";
	$db_user = "root";
	$db_pass = "";
	$db_name = "sk";


	try
	{
		$dbcon = new PDO("mysql:host={$db_host};dbname={$db_name}",$db_user, $db_pass);
		$dbcon->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}

	catch (PDOException $e)
	{
		echo "Error: " . $e->getMessage();
	}
	/* Store All Table name in an Array */
    /*$allTables = array();


	$result = $dbcon->query('SHOW TABLES');







	//$result = mysql_query('SHOW TABLES');
	while($row_db = $dbcon->rowCount($result)){
		$allTables[] = $row[0];
	}

	foreach($allTables as $table){
		$result = $dbcon->query('SELECT * FROM '.$table);
		$num_fields = columnCount($result);

		$return.= 'DROP TABLE IF EXISTS '.$table.';';
		$row2 = rowCount(query('SHOW CREATE TABLE '.$table));
		$return.= "\n\n".$row2[1].";\n\n";

		for ($i = 0; $i < $num_fields; $i++) {
			while($row = rowCount($result)){
				$return.= 'INSERT INTO '.$table.' VALUES(';
				for($j=0; $j<$num_fields; $j++){
					$row[$j] = addslashes($row[$j]);
					$row[$j] = str_replace("\n","\\n",$row[$j]);
					if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; }
					else { $return.= '""'; }
					if ($j<($num_fields-1)) { $return.= ','; }
				}
				$return.= ");\n";
			}
		}
		$return.="\n\n";
	}

// Create Backup Folder
	$folder = 'DB_Backup/';
	if (!is_dir($folder))
		mkdir($folder, 0777, true);
	chmod($folder, 0777);

	$date = date('m-d-Y-H-i-s', time());
	$filename = $folder."db-backup-".$date;

	$handle = fopen($filename.'.sql','w+');
	fwrite($handle,$return);
	fclose($handle);*/
}








function replace_dashes($string)
{
    $string = str_replace("-", " ", $string);
    return $string;
}





/*
* function to encode string
* accepts a string
* returns encoded string
*/
function safe_encode($string)
{
    return strtr(base64_encode($string), '+/=', '-_-');
}

/*
* function to decode the encoded string
* accepts encoded string
* returns the original string
*/
function safe_decode($string)
{
    return base64_decode(strtr($string, '-_-', '+/='));
}






/*******************START BALANSE SHEET FUNCTION**********************/
function profitloss($query, $tab)
{
    include("include/dbconnect.php");

    $total = 0;

    try {
        $q_result = $dbcon->prepare($query);
        $q_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
        $acct_name = $row["acct_name"];
        $total += $row["total"];
        $bold = '';
        print("<TR>\n");
        print("<TD style=font-family:verdana,tohama; style=font-size:11px; style=color=black>$bold\n");
        print $row["acct_name"];
        print("</TD>\n");

        print("$tab\n");

        print("<TD align = right style=font-family:verdana,tohama; style=font-size:11px; style=color=black>\n");
        print format_number($row["total"], 0);
        print("</TD>\n");

        print("</TR>\n");
    }


    $_SESSION['total'] = $total;
}
/*******************END BALANSE SHEET FUNCTION**********************/





/*******************START CHANRT OF ACCOUNT DELETE VISIBLE**********************/
function count_child($po_no, $t)
{
    include("dbconnect.php");

    $total = 0;
    try {

        $q = "SELECT count(*) total FROM $t WHERE acct_id =  '$po_no' ";
        $result = $dbcon->prepare($q);
        $result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }


    $rowd = $result->fetch(PDO::FETCH_ASSOC);
    if (isset($rowd["total"])) {
        $total = $rowd["total"];
    }

    return $total;
}

function count_child_level($po_no, $tabledet)
{
    include("dbconnect.php");
    $total = 0;
    try {

        $q = "SELECT count(*) total FROM $tabledet WHERE acct_id <>  '$po_no' and substring(acct_id,1,length('$po_no'))='$po_no'";
        $result = $dbcon->prepare($q);
        $result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }


    $rowd = $result->fetch(PDO::FETCH_ASSOC);
    if (isset($rowd["total"])) {
        $total = $rowd["total"];
    }

    return $total;
}

/******************END CHANRT OF ACCOUNT DELETE VISIBLE**********************/









class NumbersToWords
{

    public static $hyphen      = '-';
    public static $conjunction = ' ';
    public static $separator   = ', ';
    public static $negative    = 'negative ';
    public static $decimal     = ' point ';
    public static $dictionary  = array(
        0                   => 'zero',
        1                   => 'one',
        2                   => 'two',
        3                   => 'three',
        4                   => 'four',
        5                   => 'five',
        6                   => 'six',
        7                   => 'seven',
        8                   => 'eight',
        9                   => 'nine',
        10                  => 'ten',
        11                  => 'eleven',
        12                  => 'twelve',
        13                  => 'thirteen',
        14                  => 'fourteen',
        15                  => 'fifteen',
        16                  => 'sixteen',
        17                  => 'seventeen',
        18                  => 'eighteen',
        19                  => 'nineteen',
        20                  => 'twenty',
        30                  => 'thirty',
        40                  => 'fourty',
        50                  => 'fifty',
        60                  => 'sixty',
        70                  => 'seventy',
        80                  => 'eighty',
        90                  => 'ninety',
        100                 => 'hundred',
        1000                => 'thousand',
        1000000             => 'million',
        1000000000          => 'billion',
        1000000000000       => 'trillion',
        1000000000000000    => 'quadrillion',
        1000000000000000000 => 'quintillion'
    );
    public static function convert($number)
    {
        if (!is_numeric($number)) return false;
        $string = '';
        switch (true) {
            case $number < 21:
                $string = self::$dictionary[$number];
                break;
            case $number < 100:
                $tens   = ((int) ($number / 10)) * 10;
                $units  = $number % 10;
                $string = self::$dictionary[$tens];
                if ($units) {
                    $string .= self::$hyphen . self::$dictionary[$units];
                }
                break;
            case $number < 1000:
                $hundreds  = $number / 100;
                $remainder = $number % 100;
                $string = self::$dictionary[$hundreds] . ' ' . self::$dictionary[100];
                if ($remainder) {
                    $string .= self::$conjunction . self::convert($remainder);
                }
                break;
            default:
                $baseUnit = pow(1000, floor(log($number, 1000)));
                $numBaseUnits = (int) ($number / $baseUnit);
                $remainder = $number % $baseUnit;
                $string = self::convert($numBaseUnits) . ' ' . self::$dictionary[$baseUnit];
                if ($remainder) {
                    $string .= $remainder < 100 ? self::$conjunction : self::$separator;
                    $string .= self::convert($remainder);
                }
                break;
        }
        return $string;
    }
} //end class



/**************************START SALE INVOICE POST TO GL ACCOUNT**********************/

function repost_sl($comp_id, $year_id, $voucher_id, $posted, $from_date, $to_date) {
    include("dbconnect.php");

    if ($posted == 'on' || $posted == "'on'") {
        $voucher_id = 'SL' . $voucher_id;
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$voucher_id'";
            //            echo $vd_query;
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $voucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {
        update_sl_invoice_amt($comp_id, $year_id, $voucher_id);

        try {
            $vd_query = " call sp_repost_sl('$comp_id', '$year_id', '$voucher_id', '$from_date', '$to_date')";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }

    /************************START LAST RATE UPDATE*********************/
    $and = "";
    $and .= " and m.comp_id = '$comp_id'";
    $and .= " and m.year_id = '$year_id'";
    $and .= " and m.voucher_id = '$voucher_id'";


    try {
        $sl_detail_query = "SELECT  
            					    m.comp_id,
           					        m.year_id,
									m.voucher_id,
 									vd.rate,
									vd.stock_code
								FROM
								sl_invoice m 
								LEFT JOIN sl_invoicedet vd ON m.voucher_id = vd.voucher_id AND m.comp_id = vd.comp_id AND m.year_id = vd.year_id
 								WHERE 1=1
 							$and ORDER BY m.comp_id, m.year_id, m.voucher_date";

        #echo $sl_detail_query;

        $sl_detail_result = $dbcon->prepare($sl_detail_query);
        $sl_detail_result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {
        $avg_rate = $d_row->avg_rate;
        $s_rate = $d_row->rate;
        $stock_code = $d_row->stock_code;

        $login_page = find_value('system', 'login_page', '');

        if ($login_page != 'mli') {
            try {

                $s_query = "UPDATE item SET s_rate = '$s_rate'
 							WHERE  stock_code  = '$stock_code'";
                $results = $dbcon->prepare($s_query);
                $results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
    /************************END LAST RATE UPDATE*********************/


    return true;
}

/**************************START SALE INVOICE POST TO GL ACCOUNT**********************/

function repost_dc($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    //    echo $comp_id.$year_id.$voucher_id.$posted;
    //    exit ();

    $voucher_type = 'SL';

    $glvoucher_id = $voucher_type . $voucher_id;

    if ($posted == 'on') {

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {

        try {
            $vd_query = " call sp_repost_dc('$comp_id', '$year_id', '$voucher_id')";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }
}




function repost_pl($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $voucher_type = 'PL';

    $glvoucher_id = $voucher_type . $voucher_id;

    if ($posted == 'on') {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {
        //update_avg_rates($comp_id, $year_id, $voucher_id, $posted);

        try {
            $vd_query = " call sp_repost_pl('$comp_id', '$year_id', '$voucher_id')";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }



        /************************START LAST RATE UPDATE*********************/
        $and = "";
        $and .= " and m.comp_id = '$comp_id'";
        $and .= " and m.year_id = '$year_id'";
        $and .= " and m.voucher_id = '$voucher_id'";


        try {
            $sl_detail_query = "SELECT  
            					    m.comp_id,
           					        m.year_id,
									m.voucher_id,
 									vd.rate,
									vd.stock_code
								FROM
								pl_invoice m 
								LEFT JOIN pl_invoicedet vd ON m.voucher_id = vd.voucher_id AND m.comp_id = vd.comp_id AND m.year_id = vd.year_id
 								WHERE 1=1
 							$and ORDER BY m.comp_id, m.year_id, m.voucher_date";

            #echo $sl_detail_query;

            $sl_detail_result = $dbcon->prepare($sl_detail_query);
            $sl_detail_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {

            $p_rate = $d_row->rate;
            $stock_code = $d_row->stock_code;




            try {

                $s_query = "UPDATE item SET p_rate = '$p_rate'
			WHERE  stock_code  = '$stock_code'";

                $results = $dbcon->prepare($s_query);
                $results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
        /************************END LAST RATE UPDATE*********************/
    }
}

function repost_im($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $voucher_type = 'IM';

    $glvoucher_id = $voucher_type . $voucher_id;

    if ($posted == 'on') {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {
        //update_avg_rates($comp_id, $year_id, $voucher_id, $posted);

        try {
            $vd_query = " call sp_repost_im('$comp_id', '$year_id', '$voucher_id')";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }
}


function repost_mo($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");

    try {
        $vd_query = " call sp_repost_mo('$comp_id', '$year_id', '$voucher_id')";
        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}





function post_sl($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');
    $voucher_type = 'SL';

    //    $year_id='17';
    /*
    $year_id='17';
*/
    //  $voucher_id='120589';

    $glvoucher_id = $voucher_type . $voucher_id;





    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where comp_id = '$comp_id' and year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_del_query = "DELETE FROM voucher where comp_id = '$comp_id' and year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }








    $and = "";
    $and .= " and m.comp_id = '$comp_id'";
    $and .= " and m.year_id = '$year_id'";

    //$and .= " and m.voucher_date between '2018-01-02' and '2018-01-10' ";

    if (!empty($voucher_id)) {
        $and .= " and m.voucher_id = '$voucher_id'";
    }

    try {
        $sl_detail_query = "SELECT  
            					    m.comp_id,
            					    m.year_id,
									m.voucher_id,
									if(m.bill_no='',m.voucher_id, m.bill_no) bill_no,
									m.voucher_date,
								    m.acct_id,
									m.acct_id_cs_1 acct_id_cs,
									concat(p.acct_name,'/',d.description) acct_name,
                                    if(m.bill_no='',concat('Inv#',m.voucher_id), concat('Bill#',m.bill_no)) particulars,
									m.adv_amt,
									m.net_amt,
									m.stax,
									m.disc_amt,
									d.avg_rate

								FROM
								sl_invoice m 
								LEFT JOIN (select comp_id, year_id, voucher_id, f_sl_invoice_products(comp_id, year_id, voucher_id) description, sum(qty*avg_rate) avg_rate from sl_invoicedet d
								group by comp_id, year_id, voucher_id) d ON m.voucher_id = d.voucher_id AND m.comp_id = d.comp_id AND m.year_id = d.year_id
								LEFT JOIN v_party p ON m.acct_id = p.acct_id
								WHERE 1=1
	 							$and ORDER BY m.comp_id, m.year_id, m.voucher_id";

        //echo $sl_detail_query;

        $sl_detail_result = $dbcon->prepare($sl_detail_query);
        $sl_detail_result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {

        $comp_id = $d_row->comp_id;
        $year_id = $d_row->year_id;
        $voucherId = $d_row->voucher_id;
        $bill_no = $d_row->bill_no;
        $voucher_date = $d_row->voucher_date;
        $acct_id = $d_row->acct_id;
        $acct_name = $d_row->acct_name;
        $net_amt = $d_row->net_amt;
        $stax = $d_row->stax;
        $disc_amt = $d_row->disc_amt;
        $advance_amount = $d_row->adv_amt;
        $avg_rate = $d_row->avg_rate;
        $acct_id_cs = $d_row->acct_id_cs;


        $glvoucher_id = $voucher_type . $voucherId;

        try {
            $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES('$glvoucher_id', '$voucher_date', 'on', '$comp_id', '$year_id')";
            $results = $dbcon->prepare($s_query);
            $dbcon->exec("set foreign_key_checks=0");
            $results->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }



        $lineitem = 0;

        $lineitem += 1;

        // $particulars = $d_row->particulars;
        $particulars = str_replace("'", "\\'", $d_row->acct_name);
        try {
            $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit,comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$acct_id', '$particulars', '$net_amt','$comp_id','$year_id')";
            $repostdet_results = $dbcon->prepare($q_repostdet);
            $dbcon->exec("set foreign_key_checks=0");
            $repostdet_results->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        //sale account id


        $amt = $net_amt + $disc_amt;
        $sale_acct_id = '3010000001';

        $lineitem2 = $lineitem . '.';
        #            $lineitem .= '.';
        $particulars .= '/' . str_replace("'", "\\'", $d_row->acct_name);
        try {
            $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem2', '$sale_acct_id', '$particulars', '$amt','$comp_id','$year_id')";
            $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
            $dbcon->exec("set foreign_key_checks=0");
            $repostdet_credit_results->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        if ($disc_amt != 0) {

            $lineitem2 = $lineitem . '..';
            #                $lineitem += 1;
            $disc_id = find_value('system', 'disc_id_sl', "");
            if (!empty(find_value('nom', 'acct_id', " and acct_id='$disc_id'"))) {
                try {
                    $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem2', '$disc_id', '$particulars', '$disc_amt','$comp_id','$year_id')";
                    $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_credit_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }
            }
        }


        // GL Sales Tax Entries


        if ($stax != 0) {
            $stax_id = find_value('system', 'stax_id', "");
            $stax_id_sl = find_value('system', 'stax_id_sl', "");
            if (!empty(find_value('nom', 'acct_id', " and acct_id='$stax_id'")) && !empty(find_value('nom', 'acct_id', " and acct_id='$stax_id_sl'"))) {
                $lineitem += 1;
                try {
                    $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$stax_id_sl', '$particulars', '$stax','$comp_id','$year_id')";
                    $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_credit_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }

                $lineitem2 = $lineitem . '.';
                try {
                    $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem2', '$stax_id', '$particulars', '$stax','$comp_id','$year_id')";
                    $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_credit_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }
            }
        }


        // GL Stock Entries

        $cogs = find_value('system', 'cogs_id', "");
        $stk_acct_id = find_value('system', 'stock_id', "");
        if ($avg_rate <> 0 && !empty(find_value('nom', 'acct_id', " and acct_id='$cogs' and length(acct_id)=10")) && !empty(find_value('nom', 'acct_id', " and acct_id='$stk_acct_id' and length(acct_id)=10"))) {

            //$particulars= $d_row->acct_name;
            $particulars = '/' . str_replace("'", "//", $d_row->acct_name);
            $acct_id_cs = $d_row->acct_id_cs;

            $lineitem += 1;


            try {
                $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit, comp_id,year_id, acct_id_cs)
        VALUES('$glvoucher_id', '$lineitem', '$cogs', '$particulars', '$avg_rate','$comp_id','$year_id','$acct_id_cs')";

                $repostdet_results = $dbcon->prepare($q_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            $lineitem2 = $lineitem . '.';

            try {
                $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit, comp_id, year_id)
        VALUES('$glvoucher_id', '$lineitem2', '$stk_acct_id', '$particulars', '$avg_rate','$comp_id','$year_id')";
                $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_credit_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }


        if ($advance_amount > 0) {

            $lineitem += 1;

            $debtors = find_value('company', 'debtors', " AND comp_id = '$comp_id'");


            $cash_gl_acct_id = '2710000001';
            if ($comp_id == 'KT') {
                $cash_gl_acct_id = $debtors;
            }
            if ($comp_id == 'IT') {
                $cash_gl_acct_id = $debtors;
            }
            if ($comp_id == 'BT') {
                $cash_gl_acct_id = $debtors;
            }


            $particulars = 'Received From Sale/';
            if ($advance_amount < $net_amt)
                $particulars = 'Adv Received From ' . number_format($net_amt) . ' Sale/';

            $particulars .= $acct_name;
            $particulars .= '/Bill No ' . $bill_no;

            try {
                $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit,comp_id,year_id)
    VALUES('$glvoucher_id', '$lineitem', '$cash_gl_acct_id', '$particulars', '$advance_amount','$comp_id','$year_id')";
                $repostdet_results = $dbcon->prepare($q_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            $lineitem .= '.';
            try {
                $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, credit,comp_id,year_id)
    VALUES('$glvoucher_id', '$lineitem', '$acct_id', '$advance_amount','$comp_id','$year_id')";
                $repostdet_results = $dbcon->prepare($q_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }


        //update slinvoice voucher id
        try {

            $edit_detail_query = "UPDATE sl_invoice  SET posted = 'on' WHERE voucher_id = '$voucherId' AND comp_id = '$comp_id' AND year_id = '$year_id'";
            $result_edit_detail = $dbcon->prepare($edit_detail_query);
            $dbcon->exec("set foreign_key_checks=0");
            $result_edit_detail->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        $login_page = find_value('system', 'login_page', '');
        if ($login_page == 'kt') {
            update_avg_rates($comp_id, $year_id, $voucherId, $posted);
        }



        if ($posted == "'on'") {


            try {
                $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
                $vd_result = $dbcon->prepare($vd_query);
                $vd_result->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }






            try {
                $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
                $vd_result = $dbcon->prepare($vd_query);
                $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }




        /************************START LAST RATE UPDATE*********************/


        //         try {
        //             $sl_detail_query = "SELECT  
        //             					    m.comp_id,
        //             					    m.year_id,
        // 									m.voucher_id,
        // 									vd.rate,
        // 									vd.stock_code
        // 								FROM
        // 								sl_invoice m 
        // 								LEFT JOIN sl_invoicedet vd ON m.voucher_id = vd.voucher_id AND m.comp_id = vd.comp_id AND m.year_id = vd.year_id
        // 								WHERE 1=1
        // 	 							$and ORDER BY m.comp_id, m.year_id, m.voucher_date";

        // #echo $sl_detail_query;

        //             $sl_detail_result = $dbcon->prepare($sl_detail_query);
        //             $sl_detail_result->execute(array());
        //         } catch (PDOException $e) {
        //             echo "Error : " . $e->getMessage();
        //         }

        //         while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {
        //             $avg_rate = $d_row->avg_rate;
        //             $s_rate = $d_row->rate;
        //             $stock_code = $d_row->stock_code;

        //             $login_page = find_value('system','login_page', '');

        //             if($login_page != 'mli') {
        //                 try {

        //                     $s_query = "UPDATE item SET s_rate = '$s_rate'
        // 							WHERE  stock_code  = '$stock_code'";
        //                     $results = $dbcon->prepare($s_query);
        //                     $results->execute(array());
        //                 } catch (PDOException $e) {
        //                     echo "Error : " . $e->getMessage();
        //                 }
        //             }

        //         }
        /************************END LAST RATE UPDATE*********************/
    }
}
/**************************END SALE INVOICE POST TO GL ACCOUNT**********************/




/**************************START SALE RETURN POST TO GL ACCOUNT**********************/
function repost_rt($comp_id, $year_id, $voucher_id, $posted, $from_date, $to_date)
{
    include("dbconnect.php");
    include("dbconnect.php");



    $voucher_type = 'RT';

    $glvoucher_id = $voucher_type . $voucher_id;

    if ($posted == 'on') {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {

        try {
            $vd_query = " call sp_repost_rt('$comp_id', '$year_id', '$voucher_id', '$from_date', '$to_date')";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }
}
/**************************END SALE RETURN POST TO GL ACCOUNT**********************/

/**************************START SALE RETURN POST TO GL ACCOUNT**********************/
function repost_pr($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $voucher_type = 'PR';

    $glvoucher_id = $voucher_type . $voucher_id;

    if ($posted == 'on') {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {
        //update_avg_rates($comp_id, $year_id, $voucher_id, $posted);

        try {
            $vd_query = " call sp_repost_pr('$comp_id', '$year_id', '$voucher_id')";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }
}
/**************************END SALE RETURN POST TO GL ACCOUNT**********************/




/**************************START PURCHASE POST TO GL ACCOUNT**********************/
function post_pl($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');
    $voucher_type = 'PL';



    $glvoucher_id = $voucher_type . $voucher_id;
    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }





        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where year_id = '$year_id' and substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_del_query = "DELETE FROM voucher where year_id = '$year_id' and substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }


    if ($posted == "''") {



        $and = "";
        //$and .= " and m.comp_id = '$comp_id'";
        //$and .= " and m.year_id = '$year_id'";

        if (!empty($voucher_id)) {
            $and .= " and m.voucher_id = '$voucher_id'";
        }


        try {
            $sl_detail_query = "SELECT 
                                    m.comp_id, 
                                    m.year_id,
									m.voucher_id,
									m.voucher_date,
									m.bill_no,
									m.acct_id,
									p.acct_name,
									m.net_amt,
									m.adv_amt,
									m.disc_amt,
									d.rate,
									d.stock_code
							FROM
								pl_invoice m 
								LEFT JOIN pl_invoicedet d ON m.voucher_id = d.voucher_id AND m.comp_id = d.comp_id AND m.year_id = d.year_id
								LEFT JOIN v_party p ON m.acct_id = p.acct_id
								LEFT JOIN nom n ON m.acct_id = n.acct_id
								 WHERE  1 = 1 and n.acct_id is not null
	 						$and ORDER BY m.comp_id, m.year_id, m.voucher_id";


            $sl_detail_result = $dbcon->prepare($sl_detail_query);
            $sl_detail_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {


            $comp_id = $d_row->comp_id;
            $year_id = $d_row->year_id;
            $voucherId = $d_row->voucher_id;
            $voucher_date = $d_row->voucher_date;
            $bill_no = $d_row->bill_no;
            $acct_id = $d_row->acct_id;
            $acct_name = $d_row->acct_name;
            $net_amt = $d_row->net_amt;
            $disc_amt = $d_row->disc_amt;
            $advance_amount = $d_row->adv_amt;
            $p_rate = $d_row->rate;
            $stock_code = $d_row->stock_code;



            /************************START LAST RATE UPDATE*********************/
            try {

                $s_query = "UPDATE item SET p_rate = '$p_rate'
			WHERE  stock_code  = '$stock_code'";

                $results = $dbcon->prepare($s_query);
                $results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            /************************END LAST RATE UPDATE*********************/







            if (empty($bill_no))
                $bill_no = $d_row->voucher_id;


            $glvoucher_id = $voucher_type . $voucherId;

            try {
                $vd_del_query = "DELETE FROM voucherdet WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vd_del_result = $dbcon->prepare($vd_del_query);
                $vd_del_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $vm_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vm_result = $dbcon->prepare($vm_query);
                $vm_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES(?, ?,?, ?, ?)";
                $results = $dbcon->prepare($s_query);
                $results->execute(array($glvoucher_id, $voucher_date, 'on', $comp_id, $year_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            $stk_acct_id = '2210000001';

            $particulars = str_replace("'", "\\'", $d_row->acct_name);

            $lineitem = 0;
            $lineitem += 1;

            try {
                $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit, comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$stk_acct_id', '$particulars', '$net_amt','$comp_id','$year_id')";

                $repostdet_results = $dbcon->prepare($q_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            $lineitem += 1;

            $particulars = "Bill#" . $bill_no;

            try {
                $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$acct_id', '$particulars', '$net_amt','$comp_id','$year_id')";
                $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_credit_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            if ($advance_amount <> 0) {

                $lineitem += 1;


                $cash_gl_acct_id = '2710000001';

                $particulars = "Paid against Purchase";


                try {
                    $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit,comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$acct_id', '$particulars', '$advance_amount','$comp_id','$year_id')";
                    $repostdet_results = $dbcon->prepare($q_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }

                $lineitem += 1;
                try {
                    $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit,comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$cash_gl_acct_id', '$particulars', '$advance_amount','$comp_id','$year_id')";
                    $repostdet_results = $dbcon->prepare($q_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }
            }


            try {

                $edit_detail_query = "UPDATE pl_invoice  SET posted = 'on' WHERE voucher_id = '$voucherId' AND comp_id = '$comp_id' AND year_id = '$year_id'";
                $result_edit_detail = $dbcon->prepare($edit_detail_query);
                $result_edit_detail->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
}
/**************************END PURCHASE POST TO GL ACCOUNT**********************/



/**************************START PURCHASE return POST TO GL ACCOUNT**********************/
function post_purchase_return($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');
    $voucher_type = 'PR';



    $glvoucher_id = $voucher_type . $voucher_id;
    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }





        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where year_id = '$year_id' and substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_del_query = "DELETE FROM voucher where year_id = '$year_id' and substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }


    if ($posted == "''") {


        $and = "";
        #    	$and .= " and m.year_id = '$year_id'";
        #    $and = " and m.comp_id = '$comp_id'";

        if (!empty($voucher_id)) {
            $and .= " and m.voucher_id = '$voucher_id'";
        }


        try {
            $sl_detail_query = "SELECT 
                                    m.comp_id, 
                                    m.year_id,
									m.voucher_id,
									m.voucher_date,
									m.bill_no,
									m.acct_id,
									p.acct_name,
									m.net_amt,
									m.adv_amt,
									m.disc_amt,
									m.net_payable
							FROM
								pl_return m 
								LEFT JOIN pl_returndet d ON m.voucher_id = d.voucher_id AND m.comp_id = d.comp_id AND m.year_id = d.year_id
								LEFT JOIN v_party p ON m.acct_id = p.acct_id
								LEFT JOIN nom n ON m.acct_id = n.acct_id
								 WHERE  1 = 1 and n.acct_id is not null
	 						$and ORDER BY m.comp_id, m.year_id, m.voucher_id";


            $sl_detail_result = $dbcon->prepare($sl_detail_query);
            $sl_detail_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {


            $comp_id = $d_row->comp_id;
            $year_id = $d_row->year_id;
            $voucherId = $d_row->voucher_id;
            $voucher_date = $d_row->voucher_date;
            $bill_no = $d_row->bill_no;
            $acct_id = $d_row->acct_id;
            $acct_name = $d_row->acct_name;
            $net_amt = $d_row->net_payable;
            $disc_amt = $d_row->disc_amt;
            $advance_amount = $d_row->adv_amt;
            $p_rate = $d_row->rate;
            $stock_code = $d_row->stock_code;


            if (empty($bill_no))
                $bill_no = $d_row->voucher_id;


            $glvoucher_id = $voucher_type . $voucherId;

            try {
                $vd_del_query = "DELETE FROM voucherdet WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vd_del_result = $dbcon->prepare($vd_del_query);
                $vd_del_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $vm_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vm_result = $dbcon->prepare($vm_query);
                $vm_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES(?, ?,?, ?, ?)";
                $results = $dbcon->prepare($s_query);
                $results->execute(array($glvoucher_id, $voucher_date, 'on', $comp_id, $year_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }






            $particulars = "Bill#" . $bill_no;

            $lineitem = 0;
            $lineitem += 1;

            try {
                $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit, comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$acct_id', '$particulars', '$net_amt','$comp_id','$year_id')";

                $repostdet_results = $dbcon->prepare($q_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            $stk_acct_id = '2210000001';
            $lineitem += 1;
            $particulars = str_replace("'", "\\'", $d_row->acct_name);


            try {
                $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$stk_acct_id ', '$particulars', '$net_amt','$comp_id','$year_id')";
                $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_credit_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }



            try {

                $edit_detail_query = "UPDATE pl_return  SET posted = 'on' WHERE voucher_id = '$voucherId' AND comp_id = '$comp_id' AND year_id = '$year_id'";
                $result_edit_detail = $dbcon->prepare($edit_detail_query);
                $result_edit_detail->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
}
/**************************END PURCHASE RETURN POST TO GL ACCOUNT**********************/









/**************************START PURCHASE return POST TO GL ACCOUNT**********************/
function post_sale_return($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');
    $voucher_type = 'RT';



    $glvoucher_id = $voucher_type . $voucher_id;
    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }





        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where year_id = '$year_id' and substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_del_query = "DELETE FROM voucher where year_id = '$year_id' and substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }


    if ($posted == "''") {


        $and = "";
        #    	$and .= " and m.year_id = '$year_id'";
        #    $and = " and m.comp_id = '$comp_id'";

        if (!empty($voucher_id)) {
            $and .= " and m.voucher_id = '$voucher_id'";
        }


        try {
            $sl_detail_query = "SELECT 
                                    m.comp_id, 
                                    m.year_id,
									m.voucher_id,
									m.voucher_date,
									m.bill_no,
									m.acct_id,
									p.acct_name,
									m.net_amt,
									m.adv_amt,
									m.disc_amt,
									m.net_payable
							FROM
								sl_return m 
								LEFT JOIN sl_returndet d ON m.voucher_id = d.voucher_id AND m.comp_id = d.comp_id AND m.year_id = d.year_id
								LEFT JOIN v_party p ON m.acct_id = p.acct_id
								LEFT JOIN nom n ON m.acct_id = n.acct_id
								 WHERE  1 = 1 and n.acct_id is not null
	 						$and ORDER BY m.comp_id, m.year_id, m.voucher_id";


            $sl_detail_result = $dbcon->prepare($sl_detail_query);
            $sl_detail_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {


            $comp_id = $d_row->comp_id;
            $year_id = $d_row->year_id;
            $voucherId = $d_row->voucher_id;
            $voucher_date = $d_row->voucher_date;
            $bill_no = $d_row->bill_no;
            $acct_id = $d_row->acct_id;
            $acct_name = $d_row->acct_name;
            $net_amt = $d_row->net_payable;
            $disc_amt = $d_row->disc_amt;
            $advance_amount = $d_row->adv_amt;
            $p_rate = $d_row->rate;
            $stock_code = $d_row->stock_code;


            if (empty($bill_no))
                $bill_no = $d_row->voucher_id;


            $glvoucher_id = $voucher_type . $voucherId;

            try {
                $vd_del_query = "DELETE FROM voucherdet WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vd_del_result = $dbcon->prepare($vd_del_query);
                $vd_del_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $vm_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vm_result = $dbcon->prepare($vm_query);
                $vm_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES(?, ?,?, ?, ?)";
                $results = $dbcon->prepare($s_query);
                $results->execute(array($glvoucher_id, $voucher_date, 'on', $comp_id, $year_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }






            $particulars = "Bill#" . $bill_no;


            $lineitem = 0;
            $lineitem += 1;

            $stk_acct_id = '3010000001';
            $particulars = str_replace("'", "\\'", $d_row->acct_name);

            try {
                $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit, comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', ' $stk_acct_id ', '$particulars', '$net_amt','$comp_id','$year_id')";

                $repostdet_results = $dbcon->prepare($q_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }



            $lineitem += 1;
            $particulars = 'Sale Return/Credit Note';


            try {
                $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, credit, comp_id, year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$acct_id ', '$particulars', '$net_amt','$comp_id','$year_id')";
                $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                $dbcon->exec("set foreign_key_checks=0");
                $repostdet_credit_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }



            try {

                $edit_detail_query = "UPDATE sl_return  SET posted = 'on' WHERE voucher_id = '$voucherId' AND comp_id = '$comp_id' AND year_id = '$year_id'";
                $result_edit_detail = $dbcon->prepare($edit_detail_query);
                $result_edit_detail->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
}
/**************************END SALE RETURN POST TO GL ACCOUNT**********************/






/**************************START SALE RECEIPT POST TO GL ACCOUNT**********************/
function post_sr($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');
    $voucher_type = 'SR';

    //    $year_id='17';
    /*
        $voucher_id='00001';
        $year_id='17';
    */

    $glvoucher_id = $voucher_type . $voucher_id;
    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where comp_id = '$comp_id' and year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }


    if ($posted == "''") {


        $and = "";
        $and .= " and m.comp_id = '$comp_id'";
        $and .= " and m.year_id = '$year_id'";

        if (!empty($voucher_id)) {
            $and .= " and m.voucher_id = '$voucher_id'";
        }

        try {
            $query = "SELECT
      
	m.comp_id,
	m.year_id,
	m.voucher_id,
	m.voucher_date
FROM
	sl_receipt m
WHERE 1 = 1 $and";

            $m_result = $dbcon->prepare($query);
            $m_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }


        while ($m_row = $m_result->fetch(PDO::FETCH_OBJ)) {

            $m_comp_id = $m_row->comp_id;
            $m_year_id = $m_row->year_id;
            $m_voucher_id = $m_row->voucher_id;
            $voucher_date = $m_row->voucher_date;
            $glvoucher_id = $voucher_type . $m_voucher_id;


            try {
                $vd_del_query = "DELETE FROM voucherdet WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vd_del_result = $dbcon->prepare($vd_del_query);
                $vd_del_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }

            try {
                $vm_query = "DELETE FROM voucher WHERE comp_id = ? AND year_id = ? AND voucher_id = ?";
                $vm_result = $dbcon->prepare($vm_query);
                $vm_result->execute(array($comp_id, $year_id, $glvoucher_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES(?, ?,?, ?, ?)";
                $results = $dbcon->prepare($s_query);
                $dbcon->exec("set foreign_key_checks=0");
                $results->execute(array($glvoucher_id, $voucher_date, 'on', $comp_id, $year_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $query = "SELECT
      
	m.comp_id,
	m.year_id,
	m.voucher_id,
	m.voucher_date,
	d.lineitem,
	d.party_id,
	d.acct_id,
	d.amount,
	n.acct_name party_name,
    n2.acct_name,
	d.bill_no,
	d.disc_amt
FROM
	sl_receipt m
LEFT JOIN sl_receiptdet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id AND m.voucher_id = d.voucher_id 
LEFT JOIN nom n ON n.acct_id = d.party_id
LEFT JOIN nom n2 ON n2.acct_id = d.acct_id

WHERE 1 = 1 and m.comp_id = '$m_comp_id' AND m.year_id = '$m_year_id' AND m.voucher_id = '$m_voucher_id' $and";


                $d_result = $dbcon->prepare($query);
                $d_result->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }

            $lineitem = 0;
            while ($d_row = $d_result->fetch(PDO::FETCH_OBJ)) {

                $comp_id = $d_row->comp_id;
                $year_id = $d_row->year_id;
                $voucherId = $d_row->voucher_id;
                $voucher_date = $d_row->voucher_date;
                $party_id = $d_row->party_id;
                $c_acct_id = $d_row->acct_id;
                $amount = $d_row->amount;
                $disc_amt = $d_row->disc_amt;
                $party_name = $d_row->party_name;
                $bill_no = $d_row->bill_no;
                //$lineitem = $d_row->lineitem;








                $particulars = $d_row->acct_name;

                if (!empty($bill_no))
                    $particulars .= '/Bill#' . $bill_no;



                $lineitem += 1;

                try {
                    $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, debit,comp_id,year_id, particulars) 
				VALUES('$glvoucher_id', '$lineitem', '$c_acct_id',  '$amount','$comp_id','$year_id', '$particulars')";
                    $repostdet_results = $dbcon->prepare($q_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }


                $lineitem2 = $lineitem . '.';

                try {
                    $q_credit_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, credit, comp_id, year_id, particulars) 
				VALUES('$glvoucher_id', '$lineitem2', '$party_id', '$amount', '$comp_id','$year_id', '$particulars')";
                    $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                    $dbcon->exec("set foreign_key_checks=0");
                    $repostdet_credit_results->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }

                if ($disc_amt != 0) {



                    $disc_id = find_value('system', 'disc_id_sl', "");
                    if (!empty(find_value('nom', 'acct_id', " and acct_id='$disc_id'"))) {


                        $particulars = 'Discount On Sales Invoice/';
                        $particulars .= $party_name;
                        $particulars .= '/Bill No ' . $bill_no;

                        $lineitem2 = $lineitem . '..';

                        try {
                            $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars, debit,comp_id,year_id)
    VALUES('$glvoucher_id', '$lineitem2', '$disc_id', '$particulars', '$disc_amt','$comp_id','$year_id')";
                            $repostdet_results = $dbcon->prepare($q_repostdet);
                            $dbcon->exec("set foreign_key_checks=0");
                            $repostdet_results->execute(array());
                        } catch (PDOException $e) {
                            echo "Error : " . $e->getMessage();
                        }




                        $lineitem2 = $lineitem . '...';
                        try {
                            $q_repostdet = "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, particulars,  credit,comp_id,year_id)
    VALUES('$glvoucher_id', '$lineitem2', '$party_id', '$particulars', '$disc_amt','$comp_id','$year_id')";
                            $repostdet_results = $dbcon->prepare($q_repostdet);
                            $dbcon->exec("set foreign_key_checks=0");
                            $repostdet_results->execute(array());
                        } catch (PDOException $e) {
                            echo "Error : " . $e->getMessage();
                        }
                    }
                }
            }
        }


        //update sl

    }
}
/**************************END SALE RECEIPT POST TO GL ACCOUNT**********************/




/**************************START SALE INVOICE POST TO GL ACCOUNT**********************/
function post_st($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');
    $voucher_type = 'ST';

    //    $year_id='17';
    /*
        $voucher_id='101119';
        $year_id='17';
    */

    $glvoucher_id = $voucher_type . $voucher_id;





    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE comp_id = '$comp_id' and year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE comp_id = ? and year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($comp_id, $year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where comp_id = '$comp_id' and year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_del_query = "DELETE FROM voucher where comp_id = '$comp_id' and year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }


    /*************************************START TO COMP ID DELETE ***************************/
    if (!empty($voucher_id)) {
        try {
            $vd_query = "DELETE FROM voucherdet  WHERE   year_id = '$year_id' and voucher_id =  '$glvoucher_id'";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_query = "DELETE FROM voucher WHERE  year_id = ? and voucher_id = ?";
            $vd_result = $dbcon->prepare($vd_query);
            $vd_result->execute(array($year_id, $glvoucher_id));
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    } else {


        try {
            $vd_del_query = "DELETE FROM voucherdet where  year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        try {
            $vd_del_query = "DELETE FROM voucher where  year_id = '$year_id' and  substring(voucher_id,1,2)='$voucher_type'";
            $vd_del_result = $dbcon->prepare($vd_del_query);
            $vd_del_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }
    }
    /*************************************END TO COMP ID DELETE ***************************/





    if ($posted == "''") {


        $and = "";
        $and .= " and m.comp_id = '$comp_id'";
        $and .= " and m.year_id = '$year_id'";

        if (!empty($voucher_id)) {
            $and .= " and m.voucher_id = '$voucher_id'";
        }

        try {
            $sl_detail_query = "SELECT  
            					    m.comp_id,
            					    m.year_id,
									m.voucher_id,
									m.bill_no,
									m.voucher_date,
									m.acct_id,
									p.acct_name,
									m.adv_amt,
									m.net_amt,
							        m.disc_amt,
							        m.to_comp_id,
							        c.acct_id from_acct_id,
							        c2.acct_id to_acct_id							    
								FROM
								stk_trans m 
								LEFT JOIN company c ON m.comp_id = c.comp_id
								LEFT JOIN company c2 ON m.to_comp_id = c2.comp_id
								LEFT JOIN v_party p ON m.acct_id = p.acct_id
								WHERE 1=1
	 							$and ORDER BY m.comp_id, m.year_id, m.voucher_id";

            #echo $sl_detail_query;

            $sl_detail_result = $dbcon->prepare($sl_detail_query);
            $sl_detail_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }

        while ($d_row = $sl_detail_result->fetch(PDO::FETCH_OBJ)) {

            $comp_id = $d_row->comp_id;
            $year_id = $d_row->year_id;
            $voucherId = $d_row->voucher_id;
            $bill_no = $d_row->bill_no;
            $voucher_date = $d_row->voucher_date;
            $acct_id = $d_row->acct_id;
            $acct_name = $d_row->acct_name;
            $net_amt = $d_row->net_amt;

            $disc_amt = $d_row->disc_amt;
            $to_acct_id = $d_row->to_acct_id;
            $to_comp_id = $d_row->to_comp_id;
            $from_acct_id = $d_row->from_acct_id;



            $glvoucher_id = $voucher_type . $voucherId;


            try {
                $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES(?, ?,?, ?, ?)";
                $results = $dbcon->prepare($s_query);
                $results->execute(array($glvoucher_id, $voucher_date, 'on', $comp_id, $year_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }



            /************************START DEBIT ENTERY POST TO GL DETAIL TABLE*********************/
            $lineitem = 0;
            $lineitem += 1;


            //Find STOCK TRANSFER ID
            $stk_t_acct_id = find_value('system', 'stock_id', "");

            try {
                $q_repostdet =  "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, debit,comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$to_acct_id', '$net_amt','$comp_id','$year_id')";
                $repostdet_results = $dbcon->prepare($q_repostdet);
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
            /************************END DEBIT ENTERY POST TO GL DETAIL TABLE*********************/





            /************************START CREDIT ENTERY POST TO DETAIL TABLE*********************/

            $lineitem += 1;


            $stk_acct_id = find_value('system', 'stock_id', "");

            try {
                $q_credit_repostdet =  "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, credit,comp_id,year_id) 
				VALUES('$glvoucher_id', '$lineitem', '$stk_acct_id', '$net_amt','$comp_id','$year_id')";
                $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                $repostdet_credit_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
            /************************END CREDIT ENTERY POST TO DETAIL TABLE*********************/




            /************************START TO STATION ENTERIES*********************/

            try {
                $vd_del_query = "DELETE FROM voucherdet where comp_id = '$to_comp_id' and year_id = '$year_id' and voucher_id='$glvoucher_id'";
                $vd_del_result = $dbcon->prepare($vd_del_query);
                $vd_del_result->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }

            try {
                $vd_del_query = "DELETE FROM voucher where comp_id = '$to_comp_id' and year_id = '$year_id' and voucher_id='$glvoucher_id'";
                $vd_del_result = $dbcon->prepare($vd_del_query);
                $vd_del_result->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }


            try {
                $s_query = "INSERT INTO voucher (voucher_id, voucher_date, posted, comp_id,year_id)
				VALUES(?, ?,?, ?, ?)";
                $results = $dbcon->prepare($s_query);
                $results->execute(array($glvoucher_id, $voucher_date, 'on', $to_comp_id, $year_id));
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }



            $lineitem = 0;
            $lineitem += 1;




            try {
                $q_repostdet =  "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, debit,comp_id,year_id)
                            VALUES('$glvoucher_id', '$lineitem', '$stk_acct_id', '$net_amt','$to_comp_id','$year_id')";
                $repostdet_results = $dbcon->prepare($q_repostdet);
                $repostdet_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }






            $lineitem += 1;


            $stk_acct_id = find_value('system', 'stock_id', "");

            try {
                $q_credit_repostdet =  "INSERT INTO voucherdet (voucher_id, lineitem, acct_id, credit,comp_id,year_id)
                            VALUES('$glvoucher_id', '$lineitem', '$from_acct_id', '$net_amt','$to_comp_id','$year_id')";
                $repostdet_credit_results = $dbcon->prepare($q_credit_repostdet);
                $repostdet_credit_results->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }






























            //update slinvoice voucher id
            try {

                $edit_detail_query = "UPDATE stk_trans  SET posted = 'on' WHERE voucher_id = '$voucherId' AND comp_id = '$comp_id' AND year_id = '$year_id'";
                $result_edit_detail = $dbcon->prepare($edit_detail_query);
                $dbcon->exec("set foreign_key_checks=0");
                $result_edit_detail->execute(array());
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
}
/**************************END SALE INVOICE POST TO GL ACCOUNT**********************/



























/*****************START LOGIN LOGOUT FUNCTION**************/
function login_page()
{
    $login_page = find_value('system', 'login_page', '');
    ob_start();
    session_unset();
    session_destroy();
    header("location:" . $login_page);
}
/*****************END LOGIN LOGOUT FUNCTION*****************/







/*****************START REMOVE SINGE AND DOUBLE QUOTES FUNCTION**************/
function string_sanitize($s)
{
    $result = preg_replace("/[^a-zA-Z0-9]+/", "", html_entity_decode($s, ENT_QUOTES));
    return $result;
}
/*****************END REMOVE SINGE AND DOUBLE QUOTES FUNCTION**************/


function timer()
{
    $time = explode(' ', microtime());
    return $time[0] + $time[1];
}





function differenceInHours($startdate, $enddate)
{
    $starttimestamp = strtotime($startdate);
    $endtimestamp = strtotime($enddate);
    $difference = abs($endtimestamp - $starttimestamp) / 3600;
    return $difference;
}



function timeDiff($firstTime, $lastTime)
{

    $firstTime = strtotime($firstTime);
    $lastTime = strtotime($lastTime);

    $timeDiff = $lastTime - $firstTime;

    return $timeDiff;
}

function update_invoice_amt($comp_id, $year_id, $voucher_id, $menu_id)
{
    include("dbconnect.php");
    $table = find_value("menu", 'menu_table', " and menu_id = '$menu_id'");
    $tabledet = $table . 'det';

    $dc_amt =  find_value("$table", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("$table", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("$table", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $service =  find_value("$table", 'service', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");


    $net_amt = find_value("(SELECT sum(itemtot) total FROM $tabledet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt + $service - $disc_amt;
    $net_payable = $net_amt - $adv_amt;

    $stax = find_value("(SELECT sum(stax) total FROM $tabledet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    try {
        $update_query = "UPDATE $table SET net_amt = '$net_amt', net_payable = '$net_payable', stax = '$stax' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}


function update_sl_invoice_amt($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");

    $dc_amt =  find_value("sl_invoice", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("sl_invoice", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("sl_invoice", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    //$service =  find_value("sl_invoice", 'service', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");


    $net_amt = find_value("(SELECT sum(itemtot) total FROM sl_invoicedet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt  - $disc_amt;
    $net_payable = $net_amt - $adv_amt;

    $stax = find_value("(SELECT sum(stax) total FROM sl_invoicedet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    try {
        $update_query = "UPDATE sl_invoice SET net_amt = '$net_amt', net_payable = '$net_payable', stax = '$stax' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}

function update_sl_return_amt($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");

    $dc_amt =  find_value("sl_return", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("sl_return", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("sl_return", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $service =  find_value("sl_return", 'service', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");


    $net_amt = find_value("(SELECT sum(itemtot) total FROM sl_returndet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt + $service - $disc_amt;
    $net_payable = $net_amt - $adv_amt;

    $stax = find_value("(SELECT sum(stax) total FROM sl_returndet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    try {
        $update_query = "UPDATE sl_return SET net_amt = '$net_amt', net_payable = '$net_payable', stax = '$stax' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}

function update_pl_invoice_amt($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");

    $dc_amt =  find_value("pl_invoice", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("pl_invoice", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("pl_invoice", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $labour_charges =  find_value("pl_invoice", 'labour_charges', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");

    $net_amt = find_value("(SELECT sum(itemtot) total FROM pl_invoicedet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt - $disc_amt - $labour_charges;
    $net_payable = $net_amt - $adv_amt;

    try {
        $update_query = "UPDATE pl_invoice SET net_amt = '$net_amt', net_payable = '$net_payable' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}



function update_pl_grn_amt($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");

    $dc_amt =  find_value("pl_grn", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("pl_grn", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("pl_grn", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");

    $net_amt = find_value("(SELECT sum(itemtot) total FROM pl_grndet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt - $disc_amt - $labour_charges;
    $net_payable = $net_amt - $adv_amt;

    try {
        $update_query = "UPDATE pl_grn SET net_amt = '$net_amt', net_payable = '$net_payable' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}



function update_sl_bilty_invoice_amt($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");




    $dc_amt =  find_value("sl_dc", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("sl_dc", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("sl_dc", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $service =  find_value("sl_dc", 'service', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");


    $net_amt = find_value("(SELECT sum(itemtot) total FROM sl_dcdet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt;
    $net_payable = $net_amt;



    try {
        $update_query = "UPDATE sl_dc SET net_amt = '$net_amt', net_payable = '$net_payable' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    echo $update_query;
}




/**************************START PAYMENTS RECEIPT POSTING**********************/
function post_p_r($comp_id, $year_id, $voucher_id, $posted)
{
    include("dbconnect.php");

    $month = date('m');



    if ($posted == "'on'") {


        $and = "";
        //        $and .= " and m.comp_id = '$comp_id'";
        $and .= " and m.year_id = '$year_id'";

        if (!empty($voucher_id)) {
            $and .= " and m.voucher_id = '$voucher_id'";
        }

        try {
            $query = "SELECT
      
	m.acct_id,
	m.comp_id,
	m.year_id,
	m.voucher_id,
	m.lineitem,
	n.acct_name,
	m.debit,
	m.credit,
	m.chq_no,
	m.chq_date,
	m.chq_clr_date,
	m.mode_id,
	m.sms_no,
	m.acct_id_cs
FROM
	voucherdet m
	LEFT join nom n ON m.acct_id = n.acct_id
WHERE 1 = 1 and substr(m.lineitem,-1) <> '.' $and";

            $m_result = $dbcon->prepare($query);
            $m_result->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }






        while ($m_row = $m_result->fetch(PDO::FETCH_OBJ)) {

            $comp_id =  $m_row->comp_id;
            $year_id =  $m_row->year_id;
            $voucher_id =  $m_row->voucher_id;
            $acct_id =  $m_row->acct_id;

            $debit = 'debit';
            $credit = 'credit';
            $debit_amount = $m_row->debit;
            if (substr($voucher_id, 1, 1) == 'R') {
                $debit = 'credit';
                $credit = 'debit';
                $debit_amount = $m_row->credit;
            }

            $v_no =  $m_row->v_no;
            $acct_name =  $m_row->acct_name;
            $chq_no =  $m_row->chq_no;
            $chq_date =  $m_row->chq_date;
            $clr_date =  $m_row->chq_clr_date;
            $pay_mode =  $m_row->mode_id;
            $sms_no =  $m_row->sms_no;
            $acct_id_cs =  $m_row->acct_id_cs;
            $lineitem =  $m_row->lineitem;


            /*

            try
            {
                $edit_credit_query =  "UPDATE voucherdet SET 
		acct_id = ?, v_no = ?, particulars = ?, $debit = ?,
			chq_no = ?, chq_date = ?, chq_clr_date = ?, mode_id = ?,  sms_no = ?, acct_id_cs = ?
		WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' AND lineitem = '$lineitem'";

                $result_edit_credit = $dbcon->prepare($edit_credit_query);
                $result_edit_credit->execute(array($credit_acct_name, $v_no, $acct_name, $debit_amount, $chq_no,
                    $chq_date, $clr_date, $pay_mode, $sms_no, $acct_id_cs));
            }
            catch(PDOException $e)
            {
                echo "Error : ". $e->getMessage();
            }*/






            try {
                $edit_credit_query =  "UPDATE voucherdet SET particulars = '$acct_name'
			WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' AND lineitem = '$lineitem.'";

                $result_edit_credit = $dbcon->prepare($edit_credit_query);
                $result_edit_credit->execute();
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
        }
    }
}
/**************************END PAYMENTS RECEIPT POSTING**********************/







function update_pl_order_amt($comp_id, $year_id, $voucher_id)
{
    include("dbconnect.php");

    $dc_amt =  find_value("pl_order", 'dc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $disc_amt =  find_value("pl_order", 'disc_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");
    $adv_amt =  find_value("pl_order", 'adv_amt', " AND comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id'");


    $net_amt = find_value("(SELECT sum(itemtot) total FROM pl_orderdet WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id') v ", 'total', '');
    $net_amt = $net_amt + $dc_amt - $disc_amt;
    $net_payable = $net_amt - $adv_amt;

    try {
        $update_query = "UPDATE pl_order SET net_amt = '$net_amt', net_payable = '$net_payable' WHERE comp_id = '$comp_id' AND year_id = '$year_id' AND voucher_id = '$voucher_id' ";
        $update_result = $dbcon->prepare($update_query);
        $update_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }
}


function isSiteAvailible($url)
{
    // Check, if a valid url is provided
    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        return false;
    }

    // Initialize cURL
    $curlInit = curl_init($url);

    // Set options
    curl_setopt($curlInit, CURLOPT_URL, $url);
    curl_setopt($curlInit, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($curlInit, CURLOPT_HEADER, true);
    curl_setopt($curlInit, CURLOPT_NOBODY, true);
    curl_setopt($curlInit, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($curlInit, CURLOPT_RETURNTRANSFER, true);




    // Get response
    $response = curl_exec($curlInit);

    // Close a cURL session
    curl_close($curlInit);

    return $response ? true : false;
}





function getAll($query)
{
    include("dbconnect.php");
    $result = $dbcon->prepare($query);
    $ret = $result->execute();
    if (!$ret) {
        echo 'PDO::errorInfo():';
        echo '<br />';
        echo 'error SQL: ' . $query;
        die();
        return false;
    } else {
        $result->setFetchMode(PDO::FETCH_ASSOC);
        $reponse = $result->fetchAll();
        return $reponse;
    }
}









/******************************START LOG DATA**********************/


function f_log_data($voucher_id, $menu_id, $total_amt, $action, $voucher_type, $acct_id, $qty, $items  ) {




    //session_start();
    include("dbconnect.php");

   /* include("../geoplugin/geoplugin.class.php");


    $geoplugin = new geoPlugin();
    $geoplugin->locate();
    $countryName = $geoplugin->countryName;
    $city = $geoplugin->city;
    $country_code = $geoplugin->countryCode;*/



    $uip = $_SERVER['REMOTE_ADDR'];
    // $uip = $geoplugin->ip;
    $user_browser = $_SERVER['HTTP_USER_AGENT'];
    $comp_id = $_SESSION["comp_id"];
    $year_id = $_SESSION["year_id"];
    $emp_id = ($_SESSION["VALID_USER_ID"]);

    $menu_name = find_value("menu", "menu_name", " and  menu_id = '$menu_id'");
    $datetime = date('Y-m-d H:i:s');




    try {
        $s_query = "INSERT log_data (menu_id, menu_name, voucher_id, voucher_type, total_amt, action, user_ip, user_window, 
        country_name, country_code, city, comp_id, year_id, created_by, created_at, acct_id, qty, items)
VALUES ('$menu_id', '$menu_name', '$voucher_id', '$voucher_type', '$total_amt', '$action', '$uip', '$user_browser', '$countryName', 
'$country_code', '$city', '$comp_id', '$year_id', '$emp_id', '$datetime', '$acct_id', '$qty', '$items')";
        $results = $dbcon->prepare($s_query);
        $results->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }









}
/******************************END LOG DATA**********************/



/****************************************Start Whats App SMS***************************************/

function f_whats_app_api_chat($to, $message)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.ultramsg.com/instance10452/messages/chat",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYHOST => 0,
        CURLOPT_SSL_VERIFYPEER => 0,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "token=ncp7ygzt3zcuav15&to=" . $to . "&body=" . $message . "&priority=10&referenceId=",
        CURLOPT_HTTPHEADER => array(
            "content-type: application/x-www-form-urlencoded"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
}
/****************************************Start Whats App SMS***************************************/




/****************************************Start Whats App IMAGE***************************************/

function f_whats_app_api_image($to, $img_url, $img_cap)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.ultramsg.com/instance10452/messages/image",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYHOST => 0,
        CURLOPT_SSL_VERIFYPEER => 0,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "token=ncp7ygzt3zcuav15&to='.$to.'&image='.$img_url.'&caption='.$img_cap.'&referenceId=&nocache=",
        CURLOPT_HTTPHEADER => array(
            "content-type: application/x-www-form-urlencoded"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

}
/****************************************Start Whats App IMAGE ***************************************/




function update_avg_rates_sl($comp_id, $year_id,$posted,$from_date,$to_date){
    require('dbconnect.php');

    $total = 0;
    $and = "";
    $and .= " and m.comp_id =  '$comp_id'";
    $and .= " and m.year_id =  '$year_id'";
    $and .= " and m.voucher_date BETWEEN '$from_date'  AND '$to_date'";
    //echo $missing;



    try {

        $q = "SELECT d.stock_code, d.rate cost_rate, m.voucher_id
		 	  from pl_invoice m
		 	  LEFT JOIN pl_invoicedet d ON m.comp_id = d.comp_id and m.year_id = d.year_id and m.voucher_id = d.voucher_id
		 	  where 1=1 $and and d.rate is not null
	 	      ORDER BY d.stock_code";
        //echo $q;
        //exit ();
        $result_q = $dbcon->prepare($q);
        $result_q->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }






    $stock_code = '';
    while ($row_qd = $result_q->fetch(PDO::FETCH_OBJ)) {

        $stock_code = $row_qd->stock_code;
        $cost_rate = $row_qd->cost_rate;
        $pl_voucher_id = $row_qd->voucher_id;


        $update_query = "UPDATE sl_invoice m LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id and m.year_id = d.year_id and m.voucher_id = d.voucher_id 
    SET d.avg_rate = '$cost_rate'
                    WHERE 1 = 1 $and  and  stock_code = '$stock_code' and m.inv_no = '$pl_voucher_id'";
        try {
            $results = $dbcon->prepare($update_query);
            $results->execute(array());
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }




    }
}


?>