<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Rates Update | Kafeel Traders</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="Thu, 19 Nov 1900 08:52:00 GMT">
    <link rel="shortcut icon" href="images/icons/favicon.html">
    <link rel="apple-touch-icon" href="images/icons/favicon-2.html">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.html">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.html"><!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet"
          href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet"
          href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/select2/select2-madmin.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-select/bootstrap-select.min.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-notific8/jquery.notific8.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-daterangepicker/daterangepicker-bs3.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-datepicker/css/datepicker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" class="default-style">
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" id="theme-change"
          class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
    <link href="vendors/bootstrap-editable/css/bootstrap-editable.css" rel="stylesheet" type="text/css" />
    <link type="text/css" rel="stylesheet" href="vendors/paper-css-master/paper.css">
</head>
<body class="sidebar-icons">

<div>

    <a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP-->







    <div id="wrapper">
        <!--BEGIN SIDEBAR MENU-->
        <?php include('left.php'); ?>
        <!--END SIDEBAR MENU-->


        <!--BEGIN PAGE WRAPPER-->
        <div id="page-wrapper">
            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
                <div class="page-header pull-left">
                    <div class="page-title">Item Rate Update</div>
                </div>
                <ol class="breadcrumb page-breadcrumb pull-right">
                    <li><i class="fa fa-home"></i>&nbsp;<a href="index">Home</a>&nbsp;&nbsp;<i
                            class="fa fa-angle-right"></i>&nbsp;&nbsp;
                    </li>
                    <li class="active">Item Rate Update</li>
                </ol>
                <div class="clearfix"></div>
            </div>
            <!--END TITLE & BREADCRUMB PAGE-->


            <!--BEGIN CONTENT-->
            <div class="page-content">


                <div class="row">
                    <div class="col-12">
                        <div class="panel">
                            <div class="panel-header">

                            </div>
                            <div class="panel-body">




                                                <div class="form-row">


                                                    <div class="form-group col-lg-3">
                                                        <label>Item Filter</label>
                                                        <select class="form-control acct_id"  name="item_filter" id="item_filter" style="width:250px;">

                                                            <option value="IN" selected>Include</option>
                                                            <option value="NOT IN">Exclude</option>


                                                        </select>
                                                    </div>

                                                    <div class="form-group col-lg-3">
                                                        <label>Items</label>
                                                        <select class="select2-multi-value form-control acct_id"  name="stock_code[]" id="stock_code" style="width:100%;" multiple="true">

                                                            <option value="All" selected>All Items</option>
                                                            <?php

                                                            try {
                                                                $p_query =  "SELECT i.stock_code, i.description FROM item i  ORDER BY i.stock_code ASC ";

                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }



                                                            while ($comp_row = $p_result->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->stock_code . '">' . $comp_row->description . '</option>';
                                                            }
                                                            ?>

                                                            <option></option>
                                                        </select>
                                                    </div>


                                                    <div class="form-group col-lg-3">
                                                        <label>Category</label>
                                                        <select class="select2-multi-value form-control acct_id"  name="cat_id[]" id="cat_id" style="width:100%;" multiple="true">

                                                            <option value="All" selected>All Category</option>
                                                            <?php

                                                            try {
                                                                $p_query =  "SELECT c.cat_id, c.cat_name FROM prod_cat c  ORDER BY c.cat_id asc ";

                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }



                                                            while ($comp_row = $p_result->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->cat_id . '">' . $comp_row->cat_name . '</option>';
                                                            }
                                                            ?>


                                                        </select>
                                                    </div>

                                                    <div class="form-group col-lg-3">
                                                        <label class="" for="selectcompany">Company</label><br>
                                                        <select class="form-control acct_id" name="comp_id" id="comp_id" style="width:100%;">
                                                            <option value="All" selected>All</option>
                                                            <?php
                                                            $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
                                                            $comp_id = clean_data($_SESSION["comp_id"]);

                                                            try {
                                                                $comp_sql = "SELECT c.comp_id acct_id, c.comp_name acct_name FROM company c 
                                                        LEFT JOIN users_comp uc on c.comp_id = uc.comp_id
                                                        WHERE uc.emp_id = '$emp_id' and uc.inactive<>'Y' ORDER BY c.comp_id";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            }
                                                            catch(PDOException $e)
                                                            {
                                                                echo "Error : ". $e->getMessage();
                                                            }

                                                            while($row = $q->fetch(PDO::FETCH_OBJ)) {
                                                                $selected = '';
                                                                if ($comp_id == $row->acct_id)
                                                                    $selected = 'selected';
                                                                echo '<option  value="' . $row->acct_id . '">' . $row->acct_name . '</option>';
                                                            }
                                                            ?>

                                                        </select>
                                                    </div>



                                                    <!--   <div class="form-group col-md-2">
                                                           <br>
                                                           <button class="btn btn-light btn-lg font-15 mt-1 w-75 btn-lg ml-5" style="width: 205px;" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                                               Advance
                                                           </button>
                                                       </div>
        -->
                                                </div>







                                    <br clear="all">

                                                <p>

                                                    <button type="button" class="btn btn-success btn-lg font-15" id="runreport" style="width: 205px;">Load Items</button </p>
                                                <!-- <button type="button" class="btn btn-info ml-1" id="runpdf" style="width: 130px; margin-top: 10px;">PDF</button>
                                                <input type="hidden" name="file_name" id="file_name" value="<?php /*echo $file_name */?>" class="btn btn-success">
                                                <input type="hidden" name="rep_id" id="rep_id" value="<?php /*echo $rep_id */?>" class="btn btn-success">-->
                                                </p>



                                </div>

                            </div>
                        </div>
                    </div>






                <div id="view"></div>





                <!-----------------------------------------Start Send Whats App Image------------------------------------->

                <?php

                $find_item_rate = find_value("item_rate", "stock_code", "");

                if($find_item_rate != '')
                {

                $date = date('Y-m-d H:i');
                $f_date = date("d-m-Y H:i a", strtotime($date));
                ?>

                <div class="page-content A5 html-content-wa" id="html-content-holder"  >
                    <div class="sheet padding-10mm" id="advanced-tablee">
                        <table border="0" style="width: 100%" >
                            <tr>

                                <td style="width: 100%; font-size: 42px; text-align: center; font-weight: bold; ">
                                    <span >KAFEEL TRADERS</span>

                                </td>
                            </tr>

                            <tr>

                                <td style="width: 100%; font-size: 30px; text-align: center; font-weight: bold; ">
                                    <span >Rates Update</span>

                                </td>
                            </tr>
                            <tr>

                                <td style="width: 100%; font-size: 20px; text-align: center; font-weight: bold; ">
                                    <span >Approved By: Kafeel sab.</span>

                                </td>
                            </tr>



                        </table>

                        <br clear="all">


                        <table  class="table table-bordered">
                            <tr>
                                <th style="width: 20%; border: 0px solid #000000; font-size: 14px;">
                                    Date
                                </th>
                                <td style="width: 20%; border: 0px solid #000000; font-size: 14px;">
                                    <?php echo $f_date;?>
                                </td>


                            </tr>
                        </table>



                        <table  class="table table-bordered"  >
                            <thead>

                            <tr >

                                <th style="width: 10%;" >Sr</th>
                                <th style="width: 20%;" >Item Code </th>
                                <th style="width: 50%;" >Item Name</th>

                                <th style="text-align: right; width: 20%;" >Rate</th>

                            </tr>
                            </thead>


                            <tbody>
                            <?php
                            //sale invoice detail query
                            $and = '';




                            try {
                                $sl_d_query =  "SELECT
                                                ir.stock_code,
                                                i.description,
                                                   ir.s_rate
                                            
                                                FROM item_rate ir
                                                 LEFT JOIN item i ON i.stock_code = ir.stock_code
                                                WHERE 1=1  ORDER BY i.stock_code";

                                $sl_d_result = $dbcon->prepare($sl_d_query);
                                $sl_d_result->execute(array());
                            } catch (PDOException $e) {
                                echo "Error : " . $e->getMessage();
                            }

                            $srno = 0;

                            while ($d_row = $sl_d_result->fetch(PDO::FETCH_OBJ)) {
                                $srno += 1;

                                ?>
                                <tr >
                                    <td > <?php echo $srno; ?></span></td>
                                    <td > <?php echo $d_row->stock_code; ?></span></td>
                                    <td > <?php echo $d_row->description; ?></span></td>
                                    <td style="text-align: right;  "><?php echo format_number($d_row->s_rate,0); ?></td>
                                </tr>
                                <?php
                            }
                            ?>

                            </tbody>
                        </table>

                    </div>
                </div>
                <?php } ?>

                <!-----------------------------------------End Send Whats App Image------------------------------------->


            </div>







































            </div>
        </div>
    </div>

    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/jquery-ui.js"></script><!--loading bootstrap js-->
    <script src="vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
    <script src="js/html5shiv.js"></script>
    <script src="js/respond.min.js"></script>
    <script src="vendors/metisMenu/jquery.metisMenu.js"></script>
    <script src="vendors/slimScroll/jquery.slimscroll.js"></script>
    <script src="vendors/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendors/iCheck/icheck.min.js"></script>
    <script src="vendors/iCheck/custom.min.js"></script>
    <script src="vendors/jquery-notific8/jquery.notific8.min.js"></script>
    <script src="vendors/jquery-highcharts/highcharts.js"></script>
    <script src="js/jquery.menu.js"></script>
    <script src="vendors/jquery-pace/pace.min.js"></script>
    <script src="vendors/holder/holder.js"></script>
    <script src="vendors/responsive-tabs/responsive-tabs.js"></script>
    <script src="vendors/jquery-news-ticker/jquery.newsTicker.min.js"></script>
    <script src="vendors/moment/moment.js"></script>
    <script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="vendors/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="js/main.js"></script><!--LOADING SCRIPTS FOR PAGE-->
    <script src="vendors/select2/select2.min.js"></script>
    <script src="vendors/bootstrap-select/bootstrap-select.min.js"></script>
    <script src="vendors/bootstrap-editable/js/bootstrap-editable.min.js"></script>

    <script src="vendors/DataTables/media/js/jquery.dataTables.js"></script>
    <!-- BOOT BOX ALERT -->
    <script src="js/bootbox.min.js" type="text/javascript"></script>
<script src="vendors/html2canvas.min.js"></script>
    <!----------------------------START JAVA SCRIPT---------------------------->
    <script type="text/javascript">





        $(window).on('load', function () {

            var from_date = $('#fromdate').val();
            var to_date = $('#todate').val();
            var comp_id =  $('#comp_id').val();
            var item_filter =  $('#item_filter').val();
            var stock_code =  $('#stock_code').val();
            var cat_id =  $('#cat_id').val();
            var brand_id =  $('#type_id').val();
            var disc_type =  $('#disc_type').val();
            var discount =  $('#discount').val();
            var status =  $('#status').val();




            var datastring = 'from_date=' + from_date +
                '&to_date=' + to_date +
                '&comp_id=' + comp_id +
                '&item_filter=' + item_filter +
                '&stock_code=' + stock_code +
                '&cat_id=' + cat_id  +
                '&brand_id=' + brand_id  +
                '&disc_type=' + disc_type  +
                '&discount=' + discount  +
                '&status=' + status  +
                '&action=search';


            $.ajax({
                type: "POST",
                url: "item_rate_process.php",
                data: datastring,
                beforeSend: function () {
                    $("#view").html('<div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> Loading.... <img src="images/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                },
                success: function (result) {
                    //alert(result)
                    $('#view').html(result);
                }
            });

        });








        $(document).ready(function() {

            //dropdown with search
            $(".acct_id").select2();


            $('#fromdate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                orientation: 'bottom'

            });

            $('#todate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                orientation: 'bottom'
            });








            $('#runreport').click(function()
            {

                var from_date = $('#fromdate').val();
                var to_date = $('#todate').val();
                var comp_id =  $('#comp_id').val();
                var item_filter =  $('#item_filter').val();
                var stock_code =  $('#stock_code').val();
                var cat_id =  $('#cat_id').val();
                var brand_id =  $('#type_id').val();
                var disc_type =  $('#disc_type').val();
                var discount =  $('#discount').val();
                var status =  $('#status').val();




                var datastring = 'from_date=' + from_date +
                    '&to_date=' + to_date +
                    '&comp_id=' + comp_id +
                    '&item_filter=' + item_filter +
                    '&stock_code=' + stock_code +
                    '&cat_id=' + cat_id  +
                    '&brand_id=' + brand_id  +
                    '&disc_type=' + disc_type  +
                    '&discount=' + discount  +
                    '&status=' + status  +
                    '&action=search';


                $.ajax({
                    type: "POST",
                    url: "item_rate_process.php",
                    data: datastring,
                    beforeSend: function () {
                        $("#view").html('<div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> Loading.... <img src="images/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                    },
                    success: function (result) {
                        //alert(result)
                        $('#view').html(result);
                    }
                });

            });
        });



        $('#check_all').click(function(e){
            var table= $(e.target).closest('table');
            $('td input:checkbox',table).attr('checked',e.target.checked);
        });












        function screenshot(){
            $('.html-content-wa').show();
            html2canvas(document.querySelector("#advanced-tablee")).then(canvas => {
                //document.body.appendChild(canvas);

                // Get base64URL
                var base64URL = canvas.toDataURL('image/jpeg').replace('image/jpeg', 'image/octet-stream');
                var v_id = '<?php echo $stock_code;?>';
                var f_comp_id = '<?php echo $comp_id;?>';



                var dataString = 'base64URL=' + base64URL +
                    '&v_id=' + v_id +
                    '&f_comp_id=' + f_comp_id;

                $.ajax({
                    url: 'wa_img_item_rate.php',
                    type: 'post',
                    data: {image: base64URL, v_id: v_id, f_comp_id: f_comp_id},
                    success: function(data){
                        //alert(data);

                        console.log('Upload successfully');
                        $('.html-content-wa').hide();
                    }
                });
            });
        }




           $(window).on('load', function () {

                   screenshot();


           })
















    </script>









</body>
</html>