CREATE OR REPLACE VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,if((convert(substr(1,6) using latin1) = `s`.`creditor_id`),'S','C') AS `party_type` from (`nom` `n` join `system` `s`) where ((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`)) and (length(`n`.`ACCT_ID`) = 10));

CREATE OR REPLACE VIEW `v_p_vouchers`  AS  select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt` from (((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,(`d`.`qty` * `d`.`avg_rate`) AS `cost_amt` from (((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,NULL AS `cost_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) ;



CREATE  OR REPLACE VIEW `v_vouchers`  AS  select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`voucher_date` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where (`v`.`POSTED` = 'on') ;

CREATE OR REPLACE VIEW `v_stk`  AS  select `m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) ;
