-- phpMyAdmin SQL Dump
-- version 4.0.10.18
-- https://www.phpmyadmin.net
--
-- Host: localhost:3306
-- Generation Time: Mar 30, 2017 at 12:45 PM
-- Server version: 5.6.35-cll-lve
-- PHP Version: 5.6.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cnlxidtp_click_mli`
--

-- --------------------------------------------------------

--
-- Table structure for table `acct_type`
--

CREATE TABLE IF NOT EXISTS `acct_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `debit_name` varchar(20) DEFAULT NULL,
  `credit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `am_condet`
--

CREATE TABLE IF NOT EXISTS `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `announcement`
--

CREATE TABLE IF NOT EXISTS `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `app_mod`
--

CREATE TABLE IF NOT EXISTS `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `app_mod`
--

INSERT INTO `app_mod` (`acct_id`, `acct_name`, `grp_name`, `action`, `unpost`, `table_name`, `cvoucher_type`) VALUES
('AC_CP', 'Cash Payment', 'Accounts', 26, 35, '', 'CP'),
('AC_BP', 'Bank Payment', 'Accounts', 26, 35, '', 'BP'),
('AC_CR', 'Cash Receipt', 'Accounts', 26, 35, '', 'CR'),
('AC_BR', 'Bank Receipt', 'Accounts', 26, 35, '', 'BR'),
('AC_JV', 'Journal Voucher', 'Accounts', 35, 35, '', 'JV'),
('AC_CD', 'Outstanding Clearing Dates', 'Accounts', 223, 0, '', ''),
('PL_PO', 'Order', 'Purchases', 226, 53, 't_pl_order', ''),
('PL_GP', 'Inward Gate Pass', 'Purchases', 226, 235, 't_pl_gp', ''),
('PL_INV', 'Invoice', 'Purchases', 226, 235, 't_pl_invoice', ''),
('PL_PAY', 'Payments', 'Purchases', 203, 204, 't_pl_pay', ''),
('PL_JV', 'JV', 'Purchases', 216, 212, 'pl_jv', ''),
('SL_GP', 'Inward Gate Pass', 'Sales', 226, 235, 't_sl_gp', ''),
('SL_INV', 'Invoice', 'Sales', 226, 235, 't_sl_invoice', ''),
('SL_RTN', 'Return', 'Sales', 226, 235, 't_sl_return', ''),
('SL_PAY', 'Payments', 'Sales', 203, 204, 't_sl_pay', ''),
('SL_JV', 'JV', 'Sales', 216, 212, 'sl_jv', ''),
('SL_OB', 'Outstanding Bilties', 'Sales', 221, 260, '', ''),
('STK_PROD', 'Production', 'Stock', 226, 53, 't_stk_con', 'Y'),
('STK_CON', 'Consumption', 'Stock', 226, 235, 't_stk_con', 'N'),
('MF_NOM', 'Chart of Accounts', 'Master Files', 164, 0, '', ''),
('MF_PARTY', 'Parties', 'Master Files', 66, 0, '', ''),
('MF_ITEM', 'Items', 'Master Files', 64, 0, '', ''),
('MF_UNIT', 'Units', 'Master Files', 106, 0, '', ''),
('IM_BOE', 'Bill of Entry', 'Imports', 226, 235, 't_im_boe', '');

-- --------------------------------------------------------

--
-- Table structure for table `app_rep`
--

CREATE TABLE IF NOT EXISTS `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `app_rep`
--

INSERT INTO `app_rep` (`acct_id`, `acct_name`, `grp_name`, `action`, `cvoucher_type`) VALUES
('AC_10', 'Daybook', 'Accounts', 144, ''),
('AC_20', 'Ledger', 'Accounts', 91, ''),
('AC_31', 'Trial - Balance', 'Accounts', 163, ''),
('AC_32', 'Trial - Control', 'Accounts', 149, ''),
('AC_33', 'Trial - Subsidary', 'Accounts', 149, ''),
('AC_40', 'Profit & Loss', 'Accounts', 190, ''),
('AC_50', 'Profit & Loss (Level 2)', 'Accounts', 191, ''),
('PL_10', 'Purchase Daybook', 'Purchases', 187, 'PL'),
('PL_20', 'Payment Daybook', 'Purchases', 187, 'PP'),
('PL_30', 'Detail Ledger', 'Purchases', 405, 'S'),
('PL_40', 'Trial', 'Purchases', 194, 'S'),
('PL_50', 'Summary', 'Purchases', 188, 'S'),
('SL_10', 'Sale Daybook', 'Sales', 187, 'SL'),
('SL_20', 'Sale Receipts', 'Sales', 187, 'SR'),
('SL_30', 'Detail Ledger', 'Sales', 405, 'C'),
('SL_40', 'Trial', 'Sales', 194, 'C'),
('SL_50', 'Summary', 'Sales', 188, 'C'),
('SL_60', 'Empty Stock Report', 'Sales', 406, ''),
('SL_70', 'Empty Stock Report Rate Wise', 'Sales', 407, ''),
('SL_80', 'Outstanding Bills', 'Sales', 189, ''),
('SL_90', 'SPO Outstanding', 'Sales', 195, ''),
('STK_10', 'Ledger', 'Stocks', 401, ''),
('STK_20', 'Summary', 'Stocks', 402, ''),
('STK_30', 'Summary - Value', 'Stocks', 403, '');

-- --------------------------------------------------------

--
-- Table structure for table `bill_type`
--

CREATE TABLE IF NOT EXISTS `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bill_type`
--

INSERT INTO `bill_type` (`acct_id`, `acct_name`, `comp_id`) VALUES
('0001', 'Normal', NULL),
('0002', 'Exchange', NULL),
('0003', 'VIP', NULL),
('0004', 'Sale Return', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `brands`
--

CREATE TABLE IF NOT EXISTS `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `brands`
--

INSERT INTO `brands` (`acct_id`, `acct_name`) VALUES
('0001', 'APC'),
('0002', 'MGE UPS Systems'),
('0003', 'Stulz Air Conditioning'),
('0004', 'Bergvik Flooring'),
('0005', 'APC / MGE UPS Systems'),
('0006', 'APC / MGE');

-- --------------------------------------------------------

--
-- Table structure for table `city`
--

CREATE TABLE IF NOT EXISTS `city` (
  `CITY_ID` varchar(2) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`CITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `city`
--

INSERT INTO `city` (`CITY_ID`, `CITY_NAME`, `ACCT_ID`) VALUES
('10', 'LAHORE', '3801101001');

-- --------------------------------------------------------

--
-- Table structure for table `closing_dates`
--

CREATE TABLE IF NOT EXISTS `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL,
  PRIMARY KEY (`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `closing_dates`
--

INSERT INTO `closing_dates` (`VOUCHER_TYPE`, `DATE_CLOSING`) VALUES
('BP', '2003-12-31 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `code_cat`
--

CREATE TABLE IF NOT EXISTS `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `code_cat`
--

INSERT INTO `code_cat` (`cat_id`, `description`) VALUES
('00', 'KURTA'),
('01', 'SHALWAR'),
('02', 'TROUSER'),
('03', 'KHUSSA\r\n'),
('04', 'WAIST COAT\r\n'),
('05', 'NIGHT SUIT'),
('06', 'FULL SUIT'),
('07', 'COAT'),
('08', 'FOOTWEAR\r\n'),
('09', 'SHIRT\r\n'),
('10', 'SHERWANI\r\n'),
('11', 'TURBON\r\n'),
('12', 'SUITING\r\n'),
('13', 'CAP'),
('14', 'ACCESSORIES'),
('15', 'SHAWL');

-- --------------------------------------------------------

--
-- Table structure for table `code_collection`
--

CREATE TABLE IF NOT EXISTS `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `code_collection`
--

INSERT INTO `code_collection` (`col_id`, `description`) VALUES
('SK', 'MEN'),
('SG', 'GOLD'),
('SD', 'DESIGNER\r\n');

-- --------------------------------------------------------

--
-- Table structure for table `color`
--

CREATE TABLE IF NOT EXISTS `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `color`
--

INSERT INTO `color` (`color_id`, `description`) VALUES
('PU', 'PURPLE'),
('OW', 'OFF WHITE'),
('BL', 'BLACK'),
('SN', 'SKIN'),
('GO', 'GOLDEN'),
('BR', 'BROWN'),
('MD', 'MUD'),
('SG', 'SEA GREEN'),
('MR', 'MAROON'),
('MV', 'MOUVE'),
('GR', 'GREEN'),
('MU', 'MUSTARD'),
('WH', 'WHITE'),
('GY', 'GREY'),
('DG', 'DARK GREEN'),
('LG', 'LIGHT GREEN'),
('BU', 'BLUE'),
('GB', 'GREEN BLUE'),
('OR', 'ORANGE'),
('PH', 'PEACH'),
('RS', 'RUST'),
('DB', 'DARK BLUE'),
('LY', 'LIGHT GREY'),
('SB', 'SKY BLUE'),
('FN', 'FORN'),
('CB', 'CHOCOLATE BROWN'),
('NB', 'NAVY BLUE'),
('YB', 'GREY BLACK'),
('GS', 'GREY SHINING'),
('FR', 'FEROOZI'),
('RD', 'RED'),
('LR', 'LIGHT BROWN'),
('LB', 'LIGHT BLUE'),
('CM', 'CAMEL'),
('CH', 'CHOCOLATE'),
('BG', 'BLACK GREY'),
('AR', 'ARMY'),
('MT', 'MULTI COLOUR');

-- --------------------------------------------------------

--
-- Table structure for table `company`
--

CREATE TABLE IF NOT EXISTS `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `company`
--

INSERT INTO `company` (`COMP_ID`, `COMP_NAME`, `ADD_LINE1`, `PHONE`, `EMAIL`, `URL`, `FAX`, `DESCRIPTION`, `STAX_NO`, `PRODUCTION`, `ACCT_ID`, `ADD_LINE2`, `COUNTRY`, `ZIP_CODE`, `ACCT_ID_PL`, `SHORT_NAME`, `CUR_NAME`, `DISC_DR`, `DISC_CR`, `STOCK_ACCT_ID`, `SALES_ACCT_ID`, `G_ACCT_ID_SL`, `DEBTORS`, `COGS`, `COMP_TYPE`, `TRACK_ORD`, `GRP_BS`, `country_flag`, `G_ACCT_ID_DR`, `G_ACCT_ID_DISC`, `G_ACCT_ID_RT`, `outlet_percentage`, `outlet_margin`) VALUES
('01', 'AMMAR GRINDING MILLS', 'PLOT NO. 75-APHASE-111 HATTAR INDUSTRIAL ESTATE, HARIPUR', 'Phone# 042-5423523, Fax # 042-5423634', '', '', '', '', '', 'Y', '0600030001', '', '', '', NULL, 'KT', 'UGX', NULL, NULL, '2210000001', '3010000001', '0700010001', NULL, '0100011000', 'A', '401', 'N', '', '0600030001', '0700020001', '0700030001', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `container_size`
--

CREATE TABLE IF NOT EXISTS `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `container_size`
--

INSERT INTO `container_size` (`container_id`, `container_name`) VALUES
('0001', '16 Feet'),
('0002', '20 Feet'),
('0003', '22 Feet'),
('0004', '24 Feet'),
('0005', '40 Feet'),
('0006', '50 Feet');

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE IF NOT EXISTS `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` (`CUR_ID`, `CUR_NAME`) VALUES
('PK', 'PKR');

-- --------------------------------------------------------

--
-- Table structure for table `dc_type`
--

CREATE TABLE IF NOT EXISTS `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dc_type`
--

INSERT INTO `dc_type` (`TYPE_ID`, `TYPE_NAME`) VALUES
('01', 'Sale');

-- --------------------------------------------------------

--
-- Table structure for table `discount`
--

CREATE TABLE IF NOT EXISTS `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `discount_percentage`
--

CREATE TABLE IF NOT EXISTS `discount_percentage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `discount_voucher`
--

CREATE TABLE IF NOT EXISTS `discount_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `division`
--

CREATE TABLE IF NOT EXISTS `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `division`
--

INSERT INTO `division` (`DIV_ID`, `DIV_NAME`) VALUES
('10', 'TEXTILE');

-- --------------------------------------------------------

--
-- Table structure for table `expense`
--

CREATE TABLE IF NOT EXISTS `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `expense`
--

INSERT INTO `expense` (`EXP_ID`, `EXP_NAME`) VALUES
('01', 'L/C EXPENSES');

-- --------------------------------------------------------

--
-- Table structure for table `fin_years`
--

CREATE TABLE IF NOT EXISTS `fin_years` (
  `year_id` varchar(2) DEFAULT NULL,
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fin_years`
--

INSERT INTO `fin_years` (`year_id`, `year_name`, `date_from`, `date_to`) VALUES
('16', '16-17', '2016-07-01', '2017-06-30');

-- --------------------------------------------------------

--
-- Table structure for table `grn`
--

CREATE TABLE IF NOT EXISTS `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `grndet`
--

CREATE TABLE IF NOT EXISTS `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `grn_return`
--

CREATE TABLE IF NOT EXISTS `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `grn_returndet`
--

CREATE TABLE IF NOT EXISTS `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `im_boe`
--

CREATE TABLE IF NOT EXISTS `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `im_boedet`
--

CREATE TABLE IF NOT EXISTS `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_no`
--

CREATE TABLE IF NOT EXISTS `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `invoice_no`
--

INSERT INTO `invoice_no` (`v_id`, `v_type`, `comp_id`) VALUES
(1, 'SL', '06'),
(2, 'SL', '06');

-- --------------------------------------------------------

--
-- Table structure for table `item`
--

CREATE TABLE IF NOT EXISTS `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=212 ;

--
-- Dumping data for table `item`
--

INSERT INTO `item` (`id`, `stock_code`, `description`, `o_qty`, `specs`, `unit`, `o_rate`, `staxp`, `gl_acct_id`, `sedp`, `cat_id`, `s_rate`, `inactive`, `fedp`, `post_date`, `size`, `color`, `col_id`, `discp`, `article_name`, `vender_party`, `v_cloth_yard`, `v_cloth_rate`, `v_cloth_amount`, `match_yard`, `match_rate`, `match_amount`, `stitching_party`, `stitching_yard`, `stitching_rate`, `stitching_amount`, `dying_unit`, `dying_rate`, `dying_amount`, `emb_party`, `emb_yard`, `emb_rate`, `emb_amount`, `an_emb_party`, `an_emb_yard`, `an_emb_rate`, `an_emb_amount`, `leather_yard`, `leather_rate`, `leather_amount`, `back_cloth_yard`, `back_cloth_rate`, `back_cloth_amount`, `shoe_box_unit`, `shoe_box_rate`, `shoe_box_amount`, `inside_tags_unit`, `inside_tags_rate`, `inside_tags_amount`, `hanger_unit`, `hanger_rate`, `hanger_amount`, `cover_packing_unit`, `cover_packing_rate`, `cover_packing_amount`, `stone_unit`, `stone_rate`, `stone_amount`, `zip_unit`, `zip_rate`, `zip_amount`, `button_unit`, `button_rate`, `button_amount`, `tag_unit`, `tag_rate`, `tag_amount`, `ext_unit`, `ext_rate`, `ext_amount`, `other_unit`, `other_rate`, `other_amount`, `season_id`, `type_id`, `p_rate`) VALUES
(205, '0001', 'Summer Wear', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00'),
(206, '0002', 'Classic Cotton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00'),
(207, '0003', 'Cotton Top Elastic Brief', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00'),
(208, '0003', 'Cotton Top Elastic Brief', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00'),
(209, '0004', 'Comfee Cotton B cup', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00'),
(210, '0005', 'Flora Bra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00'),
(211, '0006', 'Tender Dream', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '0.00');

-- --------------------------------------------------------

--
-- Table structure for table `item_description`
--

CREATE TABLE IF NOT EXISTS `item_description` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `location`
--

CREATE TABLE IF NOT EXISTS `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `location`
--

INSERT INTO `location` (`loc_id`, `loc_name`, `address`, `ph_no`, `stax_no`, `ntn_no`, `add_line1`, `add_line2`, `city`, `stk_sl`, `stk_pl`) VALUES
('01', 'HEAD OFFICE', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on'),
('02', 'EQUATOR', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on'),
('03', 'Wapda Town', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on'),
('04', 'Studio Mir - Gujranwala', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on'),
('05', 'Dreams - M.M.Alam', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on');

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE IF NOT EXISTS `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `locations`
--

INSERT INTO `locations` (`LOC_ID`, `LOC_NAME`) VALUES
('01', 'Main Store');

-- --------------------------------------------------------

--
-- Table structure for table `lots`
--

CREATE TABLE IF NOT EXISTS `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `menu`
--

CREATE TABLE IF NOT EXISTS `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `menu`
--

INSERT INTO `menu` (`menu_id`, `menu_name`, `menu_cmd`) VALUES
('1', 'Sale', NULL),
('1.1', 'Invoice', 'show_sale_invoice?voucher_type=SL&posted='''''),
('1.2', 'Order', 'show_sale_invoice?voucher_type=SO&posted='''''),
('1.3', 'Sale Delivery Challan', 'show_sale_invoice?voucher_type=DC&posted='''''),
('1.4', 'Outword Gate pass', 'show_sale_invoice?voucher_type=OG&posted='''''),
('1.5', 'Receipts', 'show_payments?voucher_type=SR&posted='''''),
('1.6', 'Journal', 'show_pay_jv?voucher_type=SJ&posted='''''),
('1.7', 'Sale Invoice', 'sl_inv?voucher_type=SL'),
('2', 'Purchase', NULL),
('2.1', 'Invoice', 'show_sale_invoice?voucher_type=PL&posted='''''),
('2.2', 'Order', 'show_sale_invoice?voucher_type=PO&posted='''''),
('2.3', 'Inward Gate pass', 'show_sale_invoice?voucher_type=IG&posted='''''),
('2.4', 'Payments', 'show_payments?voucher_type=PP&posted='''''),
('2.5', 'Journal', 'show_pay_jv?voucher_type=PJ&posted='''''),
('3', 'Accounts', NULL),
('3.1', 'Payments', NULL),
('4', 'Stock', NULL),
('4.1', 'Production', 'show_production?voucher_type=FG&posted='''''),
('4.2', 'Consumption', NULL),
('5', 'Master File', NULL),
('5.1', 'Items', 'items'),
('5.2', 'Chart Of Accounts', 'chart_of_accounts'),
('6', 'Reports Summary', NULL),
('6.1', 'Sale Summary', 'rpt_sale_summary?stock_summary=SL'),
('6.2', 'Stock Summary', 'rpt_sale_summary?stock_summary=FG'),
('6.3', 'Outword Gate pass Summary', 'rpt_sale_summary?stock_summary=OG'),
('6.4', 'Sale Order Summary', 'rpt_sale_summary?stock_summary=SO'),
('6.5', 'Purchase Summary', 'rpt_sale_summary?stock_summary=PL'),
('6.6', 'Purchase Order Summary', 'rpt_sale_summary?stock_summary=PO'),
('6.7', 'Purchase InwordGatepass Summary', 'rpt_sale_summary?stock_summary=IG'),
('7', 'Reports Detail', NULL),
('7.1', 'Sale Report', 'rpt_sale?detail=SL'),
('7.2', 'Sale Order', 'rpt_sale?detail=SO'),
('7.3', 'Outword Gatepass', 'rpt_sale?detail=OG'),
('7.4', 'WareHouse Stock', 'rpt_sale?detail=FG'),
('7.5', 'Purchase Invoice', 'rpt_sale?detail=PL'),
('7.6', 'Inword Gatepass', 'rpt_sale?detail=IG'),
('7.7', 'Stock Ledger', 'stock_ledger'),
('8', 'Reports Accounts', NULL),
('8.1', 'Ledgers', 'ledger'),
('8.2', 'Day Book', 'daybook'),
('9', 'Reports', NULL),
('9.1', 'Sale Report', 'rpt_sale'),
('9.2', 'Gatepass Outword Report', 'rpt_gpout'),
('9.3', 'Current Stock', 'rpt_current_stock');

-- --------------------------------------------------------

--
-- Table structure for table `ms_sale`
--

CREATE TABLE IF NOT EXISTS `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `nom`
--

CREATE TABLE IF NOT EXISTS `nom` (
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_NAME` char(50) NOT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `ACCT_TYPE` varchar(4) DEFAULT NULL,
  `FS_TYPE` varchar(1) DEFAULT NULL,
  `SUB` varchar(1) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `TEST_NAME` char(50) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `nom`
--

INSERT INTO `nom` (`ACCT_ID`, `ACCT_NAME`, `O_BAL`, `ACCT_TYPE`, `FS_TYPE`, `SUB`, `EMP_ID`, `TEST_NAME`, `COMP_ID`, `DATE_FROM`, `DATE_TO`) VALUES
('01', 'CAPITAL & LIABILITIES', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('010001', 'PAID UP CAPITAL', NULL, '3101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('0100010001', 'Haji Imam Din', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('0100010002', 'Haji Nizam Din', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('0100010003', 'Kafeel Ahmad(City Police Station)', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('0100010009', 'OPENING BALANCES', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('0100010010', 'Drawings', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('0100010020', 'Suspense A/c', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('13', 'CREDITORS & OTHER PAYABLES', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('131000', 'TRADE CREDITORS CONTROL A/C', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000423', 'Azhar Corporation(Pvt) Ltd', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000424', 'Bahoo Flour Mills', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000425', 'Chashma Ghee Mills Dasti Khata', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000426', 'Chashma Ghee Mills Ghee', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000427', 'Haji Allaudin, Tank Adda', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000428', 'Haji Muhammad Guhlam', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000429', 'Hifzat Soap', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000430', 'Kafeel Trader Sugar Khtta', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000431', 'Khwaja Muhammad Imran', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000432', 'Latif Ghee', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000433', 'Muhammad Gul, Zafarabad', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000434', 'Mushtiq Cuhnoti Cheeni Borker', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000435', 'Next Cola Meezan', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000436', 'Sheikh Shafique', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000437', 'Sultan Ghee', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000438', 'Tayyab Traders Sugar', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000439', 'Waheed Salt Dealer', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000440', 'Waqas Rice Mills', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000441', 'Zam Rice Khata', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000442', 'Zam \\ Bahoo Rice Khata', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('1310000443', 'Zaqat', NULL, '2802', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('20', 'ASSETS', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('201000', 'FIXED ASSETS', NULL, '1101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('201500', 'Loans & Advances', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000001', 'Aslam Sheikh, Police Line', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000002', 'Auto Raksha  Usman', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000003', 'BaNK ALF', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000004', 'Babu Darver', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000005', 'Baloch Sahab, Bank Alfalah', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000006', 'Cant Ghar Khtta', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000007', 'Chashma Ghee Mills (Pvt) Limited', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000008', 'Dildar Munshi', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000009', 'Gohar Zaman, Driver', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000010', 'Gulzar MCB', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000011', 'Habib Mushtaq Panter', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000012', 'Haji Aslam Rose Hotel', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000013', 'Haji Jan Mohammad', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000014', 'Haji Saad Ullah, Ramak', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000015', 'Hasnain Kotex', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000016', 'Jahangir Ahmad', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000017', 'Jamshed Bhai Bank Alfalah', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000018', 'Kifayat Munshi', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000019', 'MAMA MAALI', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000020', 'Mansoor Ahmed, Paharpur', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000021', 'Maqbool HBL', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000022', 'Maqbool UBL', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000023', 'Markup Khaata Alf', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000024', 'Muhammad Aqeel Darya Khan', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000025', 'Muhammad Aslam Lahori', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000026', 'Muhammad Ilyas, Tijarat Ganj', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000027', 'Muhammad Khaleel, Madina Colony', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000028', 'Najeeb Paracha Rawalpindi', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000029', 'Nisar Accountant', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000030', 'Rabani Driver', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000031', 'SUZKI PIKUP .PY 0963', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000032', 'Sad Rossal', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000033', 'Waqir Najam Din', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2015000034', 'Wasi Header Zadi Chahshma Gee Mii', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('202000', 'VEHICLES', NULL, '1901', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2020000001', 'SUZKI PIKUP .PY 0963', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('22', 'STOCKS', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('221000', 'STOCKS IN TRADE', NULL, '1903', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2210000001', 'STOCKS IN TRADE', NULL, '1903', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2210000002', 'STOCK TRANSFERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('26', 'SUNDRY DEBTORS', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('261000', 'TRADE DEBTORS CONTROL A/C', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000001', 'Asghar Lucknow Bakers', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000002', 'Aabid Jhok Qureshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000003', 'Aas Muhammad, Nawab Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000004', 'Abdul Bari, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000005', 'Abdul Ghaffar, Mohallah Khattaki', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000006', 'Abdul Ghani Pansar, Raheem Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000007', 'Abdul Hafeez, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000008', 'Abdul Hanan, Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000009', 'Abdur Raheem, Soda Water Factory', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000010', 'Abdur Rauf, Degree College', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000011', 'Abdur Razaq, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000012', 'Abdur Rehman, Hayat Bochra', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000013', 'Abdur Rehman Mosa Khar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000014', 'Abdur Rehman Saddar Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000015', 'Abdu Sattar, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000016', 'Abid & Tauseef, Chah Syed Munawar Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000017', 'Abudlraziq Quarshi Drabn', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000018', 'Adnan Tirjat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000019', 'Ahmed Ali, Sheikh Yousaf Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000020', 'Ahmed Jan, Kulachi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000021', 'Ahmed Pansar Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000022', 'Ahmed Shah Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000023', 'Al Asad Muryali Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000024', 'Alhabib Kariyana Bannu Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000025', 'Al Hamd Karyana, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000026', 'Al Hamd Kayana, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000027', 'Al Hassan Karyana, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000028', 'Ali Super Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000029', 'Allah Baksh Baloch, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000030', 'Allah Daad Khan, Kiri Shamozai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000031', 'Allah Nawaz Clerk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000032', 'Al Rehmat, Fateh Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000033', 'Aman Ullah Mohalla Deewan Sahab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000034', 'Aman Ullah Pahor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000035', 'Ameer Nawaz Eidgah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000036', 'Ameer Nawaz, Saddar Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000037', 'Amjad Gul Karyana, Bannu Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000038', 'Anwar Masood Diyal Road', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000039', 'Aqal Khan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000040', 'Arif Uncal Mahallah Gosi Wala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000041', 'Army Welfare Shop', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000042', 'Arshad, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000043', 'Asad, Bank Alfalah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000044', 'Ashraf Tayyab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000045', 'Asif Loading Clerk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000046', 'Aslam Munshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000047', 'Asmat Ullah Paandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000048', 'Atiq Ahmed, Chaman Chowk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000049', 'Atta Ullah Khan, Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000050', 'Ayaz Deen Pur', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000051', 'Ayaz Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000052', 'Ayub Baloch', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000053', 'Ayub Khan Tank Ada', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000054', 'Azhair  C/o Zafir Wapda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000055', 'Aziz Khan Triman', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000056', 'Aziz Naswar, Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000057', 'Aziz Ur Rehman, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000058', 'Babar Sewayan Chaman Chowk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000059', 'Baloch Hotel, Nawab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000060', 'Basheer Hussain', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000061', 'Basit-Cook', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000062', 'Bhai Shahid Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000063', 'Bismillah General Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000064', 'Bismillah Hotel, Bannu Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000065', 'Bismillah Karyana Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000066', 'Chaudhry Ikram, Bazar Kalan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000067', 'Chaudhry Islam, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000068', 'Chaudhry Mehr Deen', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000069', 'Chaudhry Yameen, Paharpur', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000070', 'City Super Store, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000071', 'C/o Haji Atiq', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000072', 'Diler Milk Powder', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000073', 'Doctor Ramzan, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000074', 'Doest Muhmmad Khan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000075', 'Dotani Super Store, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000076', 'Faheem, Chah Syed Munawar Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000077', 'Faisal Goga Khel, Bazar Kalan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000078', 'Faiz Ullah, SABZI MANDI', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000079', 'Falak Shar Parova', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000080', 'Fareed Bahi Madina Colny', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000081', 'Fauji Ahmed Nawaz', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000082', 'Fayaz Ahmed, Ghala Mandi, Hayat Sugar Dealer', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000083', 'Fazar Ur Rehman, Bakhri Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000084', 'Fida Hussain, Bannu Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000085', 'Gentry Palace', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000086', 'Ghar Kharcha Haji Imamdin', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000087', 'Ghar Kharcha Haji Nizam Din', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000088', 'Ghulam Baqir Shahani, Meeran', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000089', 'Ghulam Hussain, Hotel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000090', 'Ghulam Muhammad, City Police', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000091', 'Ghulam Muhammad GM, Ghala Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000092', 'Ghulam Nabi, Draban', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000093', 'Ghulam Rasool, Police Line', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000094', 'Green Hotel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000095', 'Gul Habib, Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000096', 'Gulshan Bakers, Factory', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000097', 'Gulshan Bakers Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000098', 'Gulshan Bakers, Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000099', 'Gulshan Baker Tank Ada', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000100', 'Gul Zaman Kulchi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000101', 'Habib Ramzan, Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000102', 'Habib Ullah Kundi, Draban', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000103', 'Hafiz Muhammad Rafique, Ghala Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000104', 'Haji Abdullah, Gaba Karyana Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000105', 'Haji Abdullah, Muzamil Karyana', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000106', 'Haji Abdullah, Sheikh Yousaf Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000107', 'Haji Abdur Rasheed, Chashma Chowk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000108', 'Haji Abdur Rauf, Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000109', 'Haji Abdur Rehman, Commisionary Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000110', 'Haji Abdur Rehman Tirjat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000111', 'Haji Abdu Salam, Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000112', 'Haji Aleem Ud Din, Commisionary Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000113', 'Haji Allah Mehr Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000114', 'Haji Allaudin, Basti Tareen Abad', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000115', 'Haji Anwar, Bachri', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000116', 'Haji Azam, Marah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000117', 'Haji Aziz, Ghala Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000118', 'Haji Azmat Tank Ada', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000119', 'Haji Babu Aslam', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000120', 'Haji Ehsan Atta Dealer', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000121', 'Haji Ehsan Kaka Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000122', 'Haji Ellahi Bakhsh, Bazar Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000123', 'Haji Faheem', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000124', 'Haji Faiz Muhammad, Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000125', 'Haji Ghulam Fareed, Bakhri Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000126', 'Haji Ghulam Qadir Goga Khel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000127', 'Haji Ghulam Rabani, Nawab Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000128', 'Haji Ghulam Subhani', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000129', 'Haji Gul Anwar Pulaow Wala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000130', 'Haji Imam Din Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000131', 'Haji Ishfaq Madina Market', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000132', 'Haji Ishfaq Police Lines', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000133', 'Haji Jafir Poara', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000134', 'Haji Khan C/o Sami Bahoo Mill', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000135', 'Haji Kheeri', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000136', 'Haji Lal Rang Saaz, Shoaib', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000137', 'Haji Mani Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000138', 'Haji Mubeen, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000139', 'Haji Muhammad Ibrahim, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000140', 'Haji Muhammad Ramzan, Baloch Nagar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000141', 'Haji Mushtaq, Bachri', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000142', 'Haji Saad Rossal', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000143', 'Haji Saad Ullah, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000144', 'Haji Sadiq Ghee Dealer', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000145', 'Haji Sadiq Malang, Bazar Kalan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000146', 'Haji Sadiq Pakwan, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000147', 'Haji Saleem, Lala Sweets', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000148', 'Haji Saleem, Pak Milan Halwa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000149', 'Haji Sardar Ali, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000150', 'Haji Shahjehan, Sheikh Yousaf Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000151', 'Haji Shaukat Mohallah Dewan Sahab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000152', 'Haji Sher Khan, Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000153', 'Haji Sher Muhammad', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000154', 'Haji Tea Soter', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000155', 'Haji Wahid Bakhsh, Bazar Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000156', 'Haji Yaqoob Number Daar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000157', 'Haji Younas Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000158', 'Haji Zahoor, Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000159', 'Hakim Khan Qursahi Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000160', 'Hameed Ullah, Commissionary Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000161', 'Hameed Ullah, Lunda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000162', 'Haq Nawaz, Draban Chungi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000163', 'Hashim Khan, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000164', 'Hashmat Khan, Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000165', 'Hassan Bakers, Sheikh Yousaf Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000166', 'Hassan Khan, HBL', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000167', 'Ibrahim  Mohallah Dewan Shaib', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000168', 'Ibrahim Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000169', 'Ideal Hotel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000170', 'Ijaz Mohallah Hayat Ullah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000171', 'Ikram, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000172', 'Imperial Bakers Rafique', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000173', 'Imran Bakhar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000174', 'Inayat Dilawar, Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000175', 'Inayat Hotel Jhok', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000176', 'Inayat Ullah, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000177', 'Inayat Ullah, Ubhaya Pul', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000178', 'Iqra Bakers Nawab Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000179', 'Irfan Ahmed, Kotli Imam', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000180', 'Irfan  Chotat BAZAR', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000181', 'Irfan Munshi, Mohallah Deewan Sahab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000182', 'Islam Ud Din Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000183', 'Islam Ud Din Mohallah Deewan Sahab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000184', 'Ismail Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000185', 'Jabir Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000186', 'Jamal Karyana Nawab Ada', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000187', 'Jamil Ahmad S/o Haji Ibrahim Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000188', 'Jamil Bahi C/o Usman Munshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000189', 'Jamil & Javed Mohallah Deewan Sahab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000190', 'Jamil Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000191', 'Jamil NCN Cable', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000192', 'Javed Khan Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000193', 'Javed Ustaad', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000194', 'Jeelani Halwai Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000195', 'Kabul Karyana, Mission Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000196', 'Kala Khan, Jhok Qureshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000197', 'Karachi Hotel, Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000198', 'Kashaf Bakers', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000199', 'Khair Wali, Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000200', 'Khaleel Ahmed, Tauseef Abad', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000201', 'Khaleel Meezan Ghee', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000202', 'Khalid, Chaman Chowk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000203', 'Khalid Halwai, Maqbool Sweets, Ghas Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000204', 'Khalid Khan, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000205', 'Khalid, Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000206', 'Khalil Hotel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000207', 'Khizar Hayat KULCHI', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000208', 'KHUDA BAKSH TIBBI QASRANI', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000209', 'Lal Badshah, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000210', 'Lal Behram, Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000211', 'Lal Shah Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000212', 'Liauqat Ali, Pezu', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000213', 'Maani Super Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000214', 'Maaz Karyna', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000215', 'Madina Tea Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000216', 'Madni Gur Dealer', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000217', 'M Ali G Soter', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000218', 'Malik Allah Nawaz, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000219', 'Malik Ellahi Bakhsh, Bazar Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000220', 'Malik Gul Muhammad, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000221', 'Malik Mithu, Bakhri Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000222', 'Malik Mushtaq, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000223', 'Malik Riaz, Baloch Nagar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000224', 'Malik Sami Ullah Chashma Sugar Mills', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000225', 'Mama Qayyum, TTC College', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000226', 'Mama Yaseen & Sons, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000227', 'Mamoon Peshwar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000228', 'Manzoor Hussain, Chairman', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000229', 'Maqbooal Khan Mara', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000230', 'Maqbool Sweet House', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000231', 'Marhaba Sweets, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000232', 'Master  Mohllah Shibshah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000233', 'Master Nadir Bhittani, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000234', 'Matloob Bakers', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000235', 'Mazhar Hameed, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000236', 'Meer Daad, Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000237', 'Meer Zaman, Sadar Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000238', 'Meer Zaman Sadar Bazar 2', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000239', 'Mehdi Hassan, Chah Syed Munawar Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000240', 'Metro Shop', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000241', 'Mohammad Imran Parova', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000242', 'Mohmmad Aslam Near Ghas Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000243', 'Molvi Hotel, Ghala Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000244', 'Moon Light Bakers, Bazar Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000245', 'Moti Mahal', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000246', 'Mubeen Cannt.', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000247', 'Muhammad Afzal Bhakkar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000248', 'Muhammad Arif, Kachi Paind Khan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000249', 'Muhammad Arif Khan, Khansama', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000250', 'Muhammad Arshad, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000251', 'Muhammad Aslam, Bachri', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000252', 'Muhammad Aslam, Eidgah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000253', 'Muhammad Aslam Noor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000254', 'Muhammad Ayub, Nawab Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000255', 'Muhammad Bilal, Diyal Road', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000256', 'Muhammad Faheem, Sadar Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000257', 'Muhammad Farhan, Eidgah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000258', 'Muhammad Farid Basti Nad Ali Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000259', 'Muhammad Hashim Pakwan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000260', 'Muhammad Hussain, Shorkot', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000261', 'Muhammad Ibrahim, Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000262', 'Muhammad Ilyas, Atta Dealer', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000263', 'Muhammad Irfan, Mission Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000264', 'Muhammad Irfan Mithai Wala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000265', 'Muhammad Irfan Parpur', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000266', 'Muhammad Islam, Tank', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000267', 'Muhammad Khalid, Mujahid Nagar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000268', 'Muhammad Luqman, Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000269', 'Muhammad Nawaz, Chodhwan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000270', 'Muhammad Nawaz, Lunda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000271', 'Muhammad Qadeer, Fateh Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000272', 'Muhammad Ramzan Bismillah Kryana', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000273', 'Muhammad Ramzan, CRBC', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000274', 'Muhammad Shahid & Saleem', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000275', 'Muhammad Shakeel, Imamia Gate', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000276', 'Muhammad Shakeel, Mohallah Gosaiyan Wala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000277', 'Muhammad Shakeel, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000278', 'Muhammad Shakeel, Nawab Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000279', 'Muhammad Shehzad', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000280', 'Muhammad Shoaib, Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000281', 'Muhammad Suleman, Mahra', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000282', 'Muhammad Suleman, Parosi Haji Imam Din', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000283', 'Muhammad Tariq, Mahra', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000284', 'Muhammad Yaqoob, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000285', 'Muhammad Zafar, Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000286', 'Muhibullah- Lunda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000287', 'Muhmmad Imran Pathan, Madina Colony', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000288', 'Mukhtiyar Ahmad Darban', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000289', 'Mukhtiyar Ahmed, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000290', 'Mukhtiyar Hussain, Kotla Saidan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000291', 'Multan Bakers, Chotta Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000292', 'Muneer Ahmed, Kiri Alizai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000293', 'Muneer Ahmed, Naiwela', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000294', 'Muneer Ahmed, New Sabzi Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000295', 'Muneer Halwai', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000296', 'Muneer Halwai, Bazar Topanwala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000297', 'MUZAFIR KHAN MURYALI', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000298', 'Muzamil, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000299', 'Nadeem Bakers', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000300', 'Nadeem Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000301', 'Nasar Ullah Khan Mara', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000302', 'Nasar Ullah, Kotli Imam', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000303', 'Naseeb Fath Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000304', 'Naseer, Mohallah Hazrat Bilal', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000305', 'Nasir Hussain Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000306', 'Naveed Tea Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000307', 'Nawaz Rice Qureshi Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000308', 'Nazir Ubhaya Pul', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000309', 'New Gulshan Kashmir', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000310', 'Niazi Bakers Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000311', 'Nisar Karore', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000312', 'Noman Karyana', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000313', 'Noor Kariyana Sabzi Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000314', 'Other Debtors', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000315', 'Pasham Gul', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000316', 'Peer Zada, Bakhri Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000317', 'Qari Irfan Madrsaa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000318', 'Qari Saeed, Saddar Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000319', 'Qayyum Karki Shop', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000320', 'Qayyum Nawaz, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000321', 'Qureshi Mor Other Debtors', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000322', 'Rahat International Haj Umra', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000323', 'Rahat Kashmir Bakers', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000324', 'Rahat Washing Free Packet', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000325', 'Ramzan Kat Mallana', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000326', 'Ramzan, New Sabzi Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000327', 'Rana Abdu Sattar, Chah Munshi Wala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000328', 'Rana Amjad Ali, Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000329', 'Rana Faheem Mohallh Gosiyn Wala', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000330', 'Rana Sagheer Mujahid Nagar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000331', 'Rana Tahir Paroa Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000332', 'Rasheed Draban', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000333', 'Rasheed, Maqbool Sweets', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000334', 'Rasheed Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000335', 'Rasool Wali, Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000336', 'Rauf Malanra', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000337', 'Raza Ullah Mara', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000338', 'Rehmat Ullah Ramak', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000339', 'Riaz General Store', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000340', 'Riaz Jhok Qureshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000341', 'Rizwan Atta Dealer, Ghala Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000342', 'Rizwan Mujad Neger', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000343', 'Saad Ullah Jhok Qureshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000344', 'Sabir Rice Jhok Qureshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000345', 'Saeed Daraban', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000346', 'Saeed & Wahid Bakhsh, Ubhaya Pul', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000347', 'Saif Ullah, Ubhaya Pul', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000348', 'Saif Ur Rehman', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000349', 'Saif Ur Rehman Nawab Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000350', 'Sana Ullah Mohallah Ship Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000351', 'Sana Ullah Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000352', 'Saqib Saleem Mohallah Allaudin', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000353', 'Sardar Naimat Kundi, Lunda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000354', 'Sarwar Khan Kundi Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000355', 'Seth Aman Ullah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000356', 'Seth Shareef', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000357', 'Shabeer Azad', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000358', 'Shafi Jhok Qureshi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000359', 'Shahid Ahmed, Chah Syed Munawar Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000360', 'Shahid & Fazal', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000361', 'Shahid Khan, Shobrah Hotel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000362', 'Shah Jee Palay Daar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000363', 'Shahnawaz Pakwan, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000364', 'Shahnawaz, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000365', 'Shakeel Ahmed Muslim Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000366', 'Shamsher, Dajal', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000367', 'Shaukat Shah, Chah Syed Munawar Shah', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000368', 'Shehzad Imtiaz, Basti Kanchkan Wali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000369', 'Sheikh Abdullah Quraishi Morr', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000370', 'Sheikh Abdul Latif, Maddi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000371', 'Sheikh Hadi, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000372', 'Sheikh Irfan, Bazar Kalan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000373', 'Sheikh Qamar, Mission Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000374', 'Sheikh Shaukat, Mission Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000375', 'Siddique Cloth', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000376', 'Siddique, Fateh Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000377', 'Sidra Genral Store Mahsood Market', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000378', 'Sohail Ahmed Clerk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000379', 'Sohail Parwana', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000380', 'Suba Khan Purni Sabzi Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000381', 'Sufi Allah Nawaz, Baloch Nagar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000382', 'Sufi Ramzan, Flying Coach Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000383', 'Sufi Saleem, Hussania Chowk', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000384', 'Suleman, Bakhri Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000385', 'Surat Khan Tank Ada', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000386', 'Taj & Saleem', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000387', 'Tanveer Ahmed, Ghala Mandi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000388', 'Tanveer Ahmed Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000389', 'Tariq Factory Worker', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000390', 'Tayyab Chota Baazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000391', 'Tijarat Ganj Other Debtors', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000392', 'Umar Hayat Pehlwan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000393', 'Umar Hayat Son of Hayat Sugar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000394', 'United Karyana Sheikh Yousaf Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000395', 'Uzair Karyana Bannu Adaa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000396', 'Wahab, Goga Khel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000397', 'Wahab Mara', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000398', 'Wajahat Hussain, Misgran Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000399', 'Waqas Khan, Madi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000400', 'Wazir Ikram Baloch', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000401', 'Yaqoob, Ubhaya Pul', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000402', 'Yaseen Gulzar, Bazar Kalan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000403', 'Yaseen Khan, Tijarat Ganj', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000404', 'Younis Goga Khel', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000405', 'Yousaf Cheeni Delair', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000406', 'Yousaf Lunda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000407', 'Yousaf-Mahra', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000408', 'Zahir Shah, Paroa', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000409', 'Zahoor Din Chota Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000410', 'Zaki Karyana', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000411', 'Zeshan Clark Cgm', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000412', 'Ziaudin, Bazar Kalan', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000413', 'Zia Ul Haq, Shorkot', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000414', 'Zia Ur Rehman, Kulachi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000415', 'Zubair Tayyab', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000416', 'ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¿ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¿ÃƒÆ’Ã¢â‚¬Å', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000417', 'ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¿ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¿ÃƒÆ’Ã¢â‚¬Å', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000418', 'Grand Total', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000419', 'Cash KT', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000420', 'Cash-IT', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000421', 'Hayat ASI', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000422', 'Cash-BT', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000447', 'Irshad Jhok Qureshi Mor', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000448', 'Haji Aman Ullah, Muryali', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000449', 'Murtaza, New  Bannu Chungi', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000450', '(cancelled)', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000451', 'Abdur Rehman, Bagi Qamar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000453', 'Zam Zam Karyana, Tank Adda', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000454', 'Gulshan Bakers, Town Hall', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000455', 'Haji Gul Anwar, Muslim Bazar', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('2610000456', 'Muhammad Javed Advocate', NULL, '1902', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('27', 'CASH & BANK BALANCES', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('271000', 'CASH', NULL, '1999', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('272000', 'BANK BALANCES', NULL, '1999', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('30', 'REVENUE', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('301000', 'SALES', NULL, '4101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3010000001', 'Sales-KT', NULL, '4101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3010000002', 'Sales-BT', NULL, '4101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3010000003', 'Sales-IT', NULL, '4101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('301010', 'DISCOUNT ALLOWED', NULL, '4101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3010100001', 'Discount Expense', NULL, NULL, NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('302000', 'COST OF SALES', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000001', 'Purchase Cost', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000005', 'Freight Inwards', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL);
INSERT INTO `nom` (`ACCT_ID`, `ACCT_NAME`, `O_BAL`, `ACCT_TYPE`, `FS_TYPE`, `SUB`, `EMP_ID`, `TEST_NAME`, `COMP_ID`, `DATE_FROM`, `DATE_TO`) VALUES
('3020000010', 'Freight Inward Tijarat Ganj', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000020', 'Freight Inwards  Quarshi Mor', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000100', 'Loading/ Unloading', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000110', 'Loading/Unloading-IT', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000120', 'Loading/unloading B-T', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('3020000210', 'Muhammad Irfan Parpur', NULL, '5101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('40', 'ADMINISTRATIVE EXPENSES', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('401000', 'SHOP EXPENSES', NULL, '6101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('4010000001', 'Shop Expense', NULL, '6101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('4010000010', 'Shop Expense Qureshi Mor', NULL, '6101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('4010000020', 'Shop Expense, Tijarat Ganj', NULL, '6101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('402000', 'DOMESTIC EXPENSES', NULL, '6101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('4020000010', 'Cant Ghar Khtta', NULL, '6101', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('50', 'SELLING EXPENCES', NULL, '0', NULL, NULL, 'click', NULL, 'KT', NULL, NULL),
('501000', 'FREIGHT ON SALE', NULL, '6201', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('5010000001', 'FREIGHT OUTWARDS', NULL, '6201', NULL, NULL, NULL, NULL, 'KT', NULL, NULL),
('60', 'INCOME', NULL, '8101', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('601000', 'Other Income', NULL, '8101', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('6010000001', 'Other Income', NULL, '8101', NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `nom_copy`
--

CREATE TABLE IF NOT EXISTS `nom_copy` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT 'HO'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `nom_copy`
--

INSERT INTO `nom_copy` (`acct_id`, `acct_name`, `acct_type`, `user_id`, `type_id`, `comp_id`) VALUES
('01', 'CAPITAL & LIABILITIES', '0', '', '', 'HO');

-- --------------------------------------------------------

--
-- Table structure for table `nom_lc`
--

CREATE TABLE IF NOT EXISTS `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `nom_old`
--

CREATE TABLE IF NOT EXISTS `nom_old` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '01',
  PRIMARY KEY (`comp_id`,`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `nom_old`
--

INSERT INTO `nom_old` (`acct_id`, `acct_name`, `acct_type`, `user_id`, `type_id`, `comp_id`) VALUES
('01', 'Expenses', '0', '', '', '01'),
('010001', 'DIRECT EXPENSES', '31', '', '5', '01'),
('0100010001', 'COST OF GOOD SOLD', NULL, '', NULL, '01'),
('010002', 'INDIRECT EXPENSES', '31', '', '61', '01'),
('0100020001', 'ENTERTAINMENT EXPENSES', NULL, '', '', '01'),
('0100020002', 'TRAVELLING EXPENSES', '', '', NULL, '01'),
('0100020003', 'STATIONARY', '', '', NULL, '01'),
('0100020004', 'ADVERTISEMENT EXP', '', '', NULL, '01'),
('0100020005', 'GROCERY EXP', '', '', NULL, '01'),
('0100020006', 'OFFICE EXPENSES', '', '', NULL, '01'),
('0100020007', 'REPAIR AND MAINTAINANCE\r\n', '', '', NULL, '01'),
('0100020008', 'RENT WAREHOUSE', '', '', NULL, '01'),
('0100020009', 'FLAGSHIP OUTLET EXPENSES', NULL, '', NULL, '01'),
('0100020010', 'KARIM BLOCK OUTLET EXPENSES', NULL, '', NULL, '01'),
('010003', 'OPENING BALANCES', NULL, '', NULL, '01'),
('0100030001', 'OPENING BALANCES', NULL, '', NULL, '01'),
('010010', 'STAFF SALARIES', NULL, '', NULL, '01'),
('0100100001', 'STAFF SALARIES', NULL, '', NULL, '01'),
('02', 'EQUITY', NULL, '', NULL, '01'),
('020001', 'PROPRITERS CAPITAL', NULL, '', NULL, '01'),
('0200010001', 'PROPRITERS CAPITAL', NULL, '', NULL, '01'),
('0200010002', 'OPENING BALANCE ADJUSTMENT ACOOUNT', NULL, '', NULL, '01'),
('03', 'Short Term Liabilites', '', '', NULL, '01'),
('030007', 'Accrued Salaries', '', '', NULL, '01'),
('0300070001', 'SALARY PAYABLE KAMRAN', '', '', NULL, '01'),
('0300070002', 'SALARY PAYABLE - NADISH', NULL, '', NULL, '01'),
('0300070003', 'SALARY PAYABLE - KHURRAM', NULL, '', NULL, '01'),
('0300070004', 'SALARY PAYABLE - JAVED', NULL, '', NULL, '01'),
('0300070005', 'SALARY PAYABLE - FAROOQ', NULL, '', NULL, '01'),
('0300070006', 'SALARY PAYABLE - SHUJA BAHI (TAX ADVISOR)', NULL, '', NULL, '01'),
('0300070007', 'SALARY PAYABLE - VICTOR', NULL, '', NULL, '01'),
('0300070008', 'SALARY PAYABLE - MOHSIN', NULL, '', NULL, '01'),
('0300070009', 'SALARY PAYABLE - FAISAL', NULL, '', NULL, '01'),
('0300070010', 'SALARY PAYABLE - TALAH', NULL, '', NULL, '01'),
('0300070011', 'SALARY PAYABLE - SIKANDAR', NULL, '', NULL, '01'),
('0300070012', 'SALARY PAYABLE - SONIL', NULL, '', NULL, '01'),
('0300070013', 'SALARY PAYABLE - ALI RAZA', NULL, '', NULL, '01'),
('10', 'LIABILITIES', '', '', '', '01'),
('100001', 'VENDOR FINISHED GOODS', NULL, '', NULL, '01'),
('1000010001', 'VENDOR SHOES - KASHIF PAYABLE', NULL, '', NULL, '01'),
('1000010002', 'MR MAJEED (KURTA)', NULL, '', NULL, '01'),
('1000010003', 'MR TAHIR (WAIST COAT)', NULL, '', NULL, '01'),
('1000010004', 'MR ARIF (EMBROIDARY)', NULL, '', NULL, '01'),
('1000010005', 'MR MUSHTAQ (HSY)', NULL, '', NULL, '01'),
('1000010006', 'HUMD INTERNATIONAL PVT LTD', NULL, '', NULL, '01'),
('100002', 'VENDOR RAW MATERIAL', NULL, '', NULL, '01'),
('1000020001', 'HAMZA AKHTAR', NULL, '', NULL, '01'),
('1000020002', 'HAJI KHAN', NULL, '', NULL, '01'),
('1000020003', 'WAZIR AHMED', NULL, '', NULL, '01'),
('1000020004', 'ZAKIR', NULL, '', NULL, '01'),
('1000020005', 'LONDON', NULL, '', NULL, '01'),
('1000020006', 'DARWESH KHAN', NULL, '', NULL, '01'),
('1000020007', 'AL-REHMAT', NULL, '', NULL, '01'),
('1000020008', 'SHADMAN', NULL, '', NULL, '01'),
('20', 'STOCK', NULL, '', NULL, '01'),
('200001', 'STOCK IN TRADE', NULL, '', NULL, '01'),
('2000010001', 'STOCK IN TRADE (RM)', NULL, '', NULL, '01'),
('2000010002', 'STOCK IN TRADE (FG)', NULL, '', NULL, '01'),
('27', 'CURRENT ASSETS', '', '', NULL, '01'),
('271000', 'CASH ACCOUNTS', '', '', NULL, '01'),
('2710000001', 'CASH IN HAND', '19', '', NULL, '01'),
('2710000002', 'ELECTRONICS', '', '', NULL, '01'),
('2710000003', 'FURNITURE', '', '', NULL, '01'),
('272000', 'BANK BALANCES', '', '', NULL, '01'),
('2720000001', 'HABIB BANK', '', '', NULL, '01'),
('2720000002', 'FAYSAL BANK', '', '', NULL, '01'),
('273000', 'OUTLET', '', '', NULL, '01'),
('2730000001', 'HEAD OFFICE', '', '', NULL, '01'),
('2730000002', 'STUDIO MEER', NULL, '', NULL, '01'),
('2730000003', 'DREAMS', NULL, '', NULL, '01'),
('2730000004', 'EQUATOR(KB)', NULL, '', NULL, '01'),
('2730000005', 'EQUATOR(LR)', NULL, '', NULL, '01'),
('2730000006', 'SATELLITE TOWN', NULL, '', NULL, '01'),
('2730000007', 'FLAGSHIP STORE', NULL, '', NULL, '01'),
('2730000008', 'OUTLET(KB)', NULL, '', NULL, '01'),
('2730000009', 'BWP ', NULL, '', NULL, '01'),
('2730000012', 'KAREEM BLOCK', NULL, '', NULL, '01'),
('41', 'TURNOVER', NULL, '', NULL, '01'),
('410001', 'SALE', NULL, '', '4', '01'),
('4100010001', 'SALES - HEAD OFFICE', NULL, '', NULL, '01'),
('4100010002', 'SALE - STUDIO MEER', NULL, '', NULL, '01'),
('4100010003', 'SALES - DREAMS', NULL, '', NULL, '01'),
('4100010004', 'SALES - EQUATOR(KB)', NULL, '', NULL, '01'),
('4100010005', 'SALES - EQUATOR(LR)', NULL, '', NULL, '01'),
('4100010006', 'SALES - SATELLITE TOWN', NULL, '', NULL, '01'),
('4100010007', 'SALES - FLAGSHIP STORE', NULL, '', NULL, '01'),
('4100010008', 'SALES - OUTLET(KB)', NULL, '', NULL, '01'),
('4100010009', 'SALES - BWP', NULL, '', NULL, '01'),
('4100010012', 'SALES - KAREEM BLOCK', '', '', '', '01'),
('410002', 'DISCOUNT', NULL, '', NULL, '01'),
('4100020001', 'DISCOUNT - HEAD OFFICE', NULL, '', NULL, '01'),
('4100020002', 'DISCOUNT - STUDIO MEER', NULL, '', NULL, '01'),
('4100020003', 'DISCOUNT - DREAMS', NULL, '', NULL, '01'),
('4100020004', 'DISCOUNT - EQUATOR(KB)', NULL, '', NULL, '01'),
('4100020005', 'DISCOUNT - EQUATOR(LR)', NULL, '', NULL, '01'),
('4100020006', 'DISCOUNT - SATELLITE TOWN', NULL, '', NULL, '01'),
('4100020007', 'DISCOUNT - FLAGSHIP STORE', NULL, '', NULL, '01'),
('4100020008', 'DISCOUNT - OUTLET(KB)', NULL, '', NULL, '01'),
('4100020009', 'DISCOUNT - BWP', NULL, '', NULL, '01'),
('4100020012', 'DISCOUNT - KAREEM BLOCK', '', '', '', '01'),
('410003', 'SALES RETURN', NULL, '', NULL, '01'),
('4100030001', 'RETURN - HEAD OFFICE', NULL, '', NULL, '01'),
('4100030002', 'RETURN - STUDIO MEER', NULL, '', NULL, '01'),
('4100030003', 'RETURN - DREAMS', NULL, '', NULL, '01'),
('4100030004', 'RETURN - EQUATOR(KB)', NULL, '', NULL, '01'),
('4100030005', 'RETURN - EQUATOR(LR)', NULL, '', NULL, '01'),
('4100030006', 'RETURN - SATELLITE TOWN', NULL, '', NULL, '01'),
('4100030007', 'RETURN - FLAGSHIP STORE', NULL, '', NULL, '01'),
('4100030008', 'RETURN - OUTLET(KB)', NULL, '', NULL, '01'),
('4100030009', 'RETURN - BWP', NULL, '', NULL, '01'),
('4100030012', 'RETURN - KAREEM BLOCK', '', '', '', '01'),
('410004', 'CREDIT NOTES', NULL, '', NULL, '01'),
('4100040001', 'CREDIT NOTES - HEAD OFFICE', NULL, '', NULL, '01'),
('4100040002', 'CREDIT NOTES - STUDIO MEER', NULL, '', NULL, '01'),
('4100040003', 'CREDIT NOTES - DREAMS', NULL, '', NULL, '01'),
('4100040004', 'CREDIT NOTES - EQUATOR(KB)', NULL, '', NULL, '01'),
('4100040005', 'CREDIT NOTES - EQUATOR(LR)', NULL, '', NULL, '01'),
('4100040006', 'CREDIT NOTES - SATELLITE TOWN', NULL, '', NULL, '01'),
('4100040007', 'CREDIT NOTES - FLAGSHIP STORE', NULL, '', NULL, '01'),
('4100040008', 'CREDIT NOTES - OUTLET(KB)', NULL, '', NULL, '01'),
('4100040009', 'CREDIT NOTES - BWP', NULL, '', NULL, '01'),
('4100040012', 'CREDIT NOTES - KAREEM BLOCK', '', '', '', '01'),
('410005', 'DEBIT NOTES', NULL, '', NULL, '01'),
('4100050001', 'DEBIT NOTES - HEAD OFFICE', NULL, '', NULL, '01'),
('4100050002', 'DEBIT NOTES - STUDIO MEER', NULL, '', NULL, '01'),
('4100050003', 'DEBIT NOTES - DREAMS', NULL, '', NULL, '01'),
('4100050004', 'DEBIT NOTES - EQUATOR(KB)', NULL, '', NULL, '01'),
('4100050005', 'DEBIT NOTES - EQUATOR(LR)', NULL, '', NULL, '01'),
('4100050006', 'DEBIT NOTES - SATELLITE TOWN', NULL, '', NULL, '01'),
('4100050007', 'DEBIT NOTES - FLAGSHIP STORE', NULL, '', NULL, '01'),
('4100050008', 'DEBIT NOTES - OUTLET(KB)', NULL, '', NULL, '01'),
('4100050009', 'DEBIT NOTES - BWP', NULL, '', NULL, '01'),
('4100050012', 'DEBIT NOTES - KAREEM BLOCK', '', '', '', '01'),
('99', 'COST CENTRES', NULL, '', NULL, '01'),
('990001', 'STAFF', NULL, '', NULL, '01'),
('9900010001', 'ALI SHAN', NULL, '', NULL, '01'),
('9900010002', 'HUSNAIN', NULL, '', NULL, '01'),
('9900010003', 'MUSA', NULL, '', NULL, '01'),
('27', 'CURRENT ASSETS', '', '', '', '02'),
('271000', 'CASH ACCOUNTS', '', '', '', '02'),
('2710000001', 'CASH IN HAND', '', '', '', '02'),
('27', 'CURRENT ASSETS', '', '', '', '05'),
('271000', 'CASH ACCOUNTS', '', '', '', '05'),
('2710000001', 'CASH IN HAND', '', '', '', '05'),
('20', 'STOCK', NULL, '', NULL, '06'),
('200001', 'STOCK IN TRADE', NULL, '', NULL, '06'),
('2000010001', 'STOCK IN TRADE (RM)', NULL, '', NULL, '06'),
('2000010002', 'STOCK IN TRADE (FG)', NULL, '', NULL, '06'),
('27', 'CURRENT ASSETS', '', '', '', '06'),
('271000', 'CASH ACCOUNTS', '', '', '', '06'),
('2710000001', 'CASH IN HAND', '', '', '', '06'),
('01', 'Expenses', NULL, '', NULL, '07'),
('010002', 'INDIRECT EXPENSES', NULL, '', NULL, '07'),
('0100020009', 'FLAGSHIP OUTLET EXPENSES', NULL, '', NULL, '07'),
('27', 'CURRENT ASSETS', NULL, '', NULL, '07'),
('271000', 'CASH ACCOUNTS', NULL, '', NULL, '07'),
('2710000001', 'CASH IN HAND', NULL, '', NULL, '07'),
('01', 'Expenses', NULL, '', NULL, '08'),
('010002', 'INDIRECT EXPENSES', NULL, '', NULL, '08'),
('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', NULL, '', NULL, '08'),
('27', 'CURRENT ASSETS', NULL, '', NULL, '08'),
('271000', 'CASH ACCOUNTS', NULL, '', NULL, '08'),
('2710000001', 'CASH IN HAND', NULL, '', NULL, '08'),
('27', 'CURRENT ASSETS', '', '', '', '10'),
('271000', 'CASH ACCOUNTS', '', '', '', '10'),
('2710000001', 'CASH IN HAND', '', '', '', '10'),
('01', 'Expenses', '', '', '', '12'),
('010002', 'INDIRECT EXPENSES', '', '', '', '12'),
('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', '', '', '', '12'),
('27', 'CURRENT ASSETS', '', '', '', '12'),
('271000', 'CASH ACCOUNTS', '', '', '', '12'),
('2710000001', 'CASH IN HAND', '', '', '', '12'),
('01', 'Expenses', '', '', '', '13'),
('010002', 'INDIRECT EXPENSES', '', '', '', '13'),
('0100020009', 'FLAGSHIP OUTLET EXPENSES', '', '', '', '13'),
('27', 'CURRENT ASSETS', '', '', '', '13'),
('271000', 'CASH ACCOUNTS', '', '', '', '13'),
('2710000001', 'CASH IN HAND', '', '', '', '13');

-- --------------------------------------------------------

--
-- Table structure for table `o_batch`
--

CREATE TABLE IF NOT EXISTS `o_batch` (
  `PROD_ID` varchar(4) NOT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `BAL_QTY` decimal(10,0) DEFAULT NULL,
  `O_QTY` decimal(10,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `o_batch`
--

INSERT INTO `o_batch` (`PROD_ID`, `EXP_DATE`, `BATCH_NO`, `BAL_QTY`, `O_QTY`) VALUES
('0420', '2017-04-30 00:00:00', 'TOS-1525', NULL, '1200');

-- --------------------------------------------------------

--
-- Table structure for table `o_voucher`
--

CREATE TABLE IF NOT EXISTS `o_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime NOT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `POSTED` varchar(1) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `o_voucherdet`
--

CREATE TABLE IF NOT EXISTS `o_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(13,2) DEFAULT NULL,
  `CREDIT` decimal(13,2) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `o_voucherdet_e`
--

CREATE TABLE IF NOT EXISTS `o_voucherdet_e` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `BPV_ID` varchar(20) DEFAULT NULL,
  `TENDER_NO` varchar(50) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `party`
--

CREATE TABLE IF NOT EXISTS `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `party_add`
--

CREATE TABLE IF NOT EXISTS `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `party_product`
--

CREATE TABLE IF NOT EXISTS `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `party_product`
--

INSERT INTO `party_product` (`PARTY_ID`, `PROD_ID`, `UNIT_RATE`, `DISCP`, `S_DISCP`, `P_RATE`, `LINEITEM`) VALUES
('0001', '0357', '46.000', NULL, NULL, NULL, '3');

-- --------------------------------------------------------

--
-- Table structure for table `party_type`
--

CREATE TABLE IF NOT EXISTS `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `party_type`
--

INSERT INTO `party_type` (`acct_id`, `acct_name`) VALUES
('C', 'Customer'),
('S', 'Supplier'),
('T', 'Trader'),
('I', 'Import'),
('P', 'Production'),
('A', 'Cash'),
('O', 'Other'),
('V', 'Vender');

-- --------------------------------------------------------

--
-- Table structure for table `pay_mode`
--

CREATE TABLE IF NOT EXISTS `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_dc`
--

CREATE TABLE IF NOT EXISTS `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_dcdet`
--

CREATE TABLE IF NOT EXISTS `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_gp`
--

CREATE TABLE IF NOT EXISTS `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_gpdet`
--

CREATE TABLE IF NOT EXISTS `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_grn`
--

CREATE TABLE IF NOT EXISTS `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_grndet`
--

CREATE TABLE IF NOT EXISTS `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_invoice`
--

CREATE TABLE IF NOT EXISTS `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_invoicedet`
--

CREATE TABLE IF NOT EXISTS `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_invoicedetapp`
--

CREATE TABLE IF NOT EXISTS `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_invoice_adv`
--

CREATE TABLE IF NOT EXISTS `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_jv`
--

CREATE TABLE IF NOT EXISTS `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_jvdet`
--

CREATE TABLE IF NOT EXISTS `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_jvdet_inst`
--

CREATE TABLE IF NOT EXISTS `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_order`
--

CREATE TABLE IF NOT EXISTS `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `po_no` varchar(30) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `disc_amt` decimal(15,2) DEFAULT NULL,
  `dc_amt` decimal(15,2) DEFAULT NULL,
  `loc_id` char(2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `sp_id` varchar(7) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `service` char(2) DEFAULT NULL,
  `ut` char(2) DEFAULT NULL,
  `adv_amt` decimal(15,2) DEFAULT NULL,
  `net_amt` decimal(15,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_orderdet`
--

CREATE TABLE IF NOT EXISTS `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` decimal(6,3) DEFAULT NULL,
  `stax` decimal(15,2) DEFAULT NULL,
  `stax_rate` decimal(15,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `sed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_pay`
--

CREATE TABLE IF NOT EXISTS `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_paydet`
--

CREATE TABLE IF NOT EXISTS `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_paydet_inst`
--

CREATE TABLE IF NOT EXISTS `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_payment`
--

CREATE TABLE IF NOT EXISTS `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_paymentdet`
--

CREATE TABLE IF NOT EXISTS `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_po`
--

CREATE TABLE IF NOT EXISTS `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_podet`
--

CREATE TABLE IF NOT EXISTS `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_receipt`
--

CREATE TABLE IF NOT EXISTS `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_receiptdet`
--

CREATE TABLE IF NOT EXISTS `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_receiptdet_acct`
--

CREATE TABLE IF NOT EXISTS `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_receiptdet_inv`
--

CREATE TABLE IF NOT EXISTS `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_receiptdet_po`
--

CREATE TABLE IF NOT EXISTS `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_ship`
--

CREATE TABLE IF NOT EXISTS `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_shipdet`
--

CREATE TABLE IF NOT EXISTS `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `pl_ship_inv`
--

CREATE TABLE IF NOT EXISTS `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `po`
--

CREATE TABLE IF NOT EXISTS `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `podet`
--

CREATE TABLE IF NOT EXISTS `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `po_type`
--

CREATE TABLE IF NOT EXISTS `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `po_type`
--

INSERT INTO `po_type` (`TYPE_ID`, `TYPE_NAME`) VALUES
('01', 'Ex Works');

-- --------------------------------------------------------

--
-- Table structure for table `process`
--

CREATE TABLE IF NOT EXISTS `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `process`
--

INSERT INTO `process` (`PROCESS_ID`, `PROCESS_NAME`) VALUES
('1', 'Mixing');

-- --------------------------------------------------------

--
-- Table structure for table `prod`
--

CREATE TABLE IF NOT EXISTS `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `proddet`
--

CREATE TABLE IF NOT EXISTS `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `prod_batch`
--

CREATE TABLE IF NOT EXISTS `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `prod_cat`
--

CREATE TABLE IF NOT EXISTS `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `prod_cat`
--

INSERT INTO `prod_cat` (`CAT_ID`, `CAT_NAME`, `ACCT_ID_CS`, `ACCT_ID`, `GRP_ID`) VALUES
('01', 'Ghee', NULL, NULL, NULL),
('02', 'ABC', NULL, NULL, NULL),
('03', 'Detergents', NULL, NULL, NULL),
('04', 'Grains', NULL, NULL, NULL),
('05', 'Others', NULL, NULL, NULL),
('06', 'Spices', NULL, NULL, NULL),
('07', 'Sugar', NULL, NULL, NULL),
('08', 'Rice', NULL, NULL, NULL),
('09', 'Oil', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `prod_comp`
--

CREATE TABLE IF NOT EXISTS `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `prod_grp`
--

CREATE TABLE IF NOT EXISTS `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `prod_grp`
--

INSERT INTO `prod_grp` (`GRP_ID`, `GRP_NAME`) VALUES
('01', 'Group Name');

-- --------------------------------------------------------

--
-- Table structure for table `prod_rm_date`
--

CREATE TABLE IF NOT EXISTS `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `prod_type`
--

CREATE TABLE IF NOT EXISTS `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `prod_type`
--

INSERT INTO `prod_type` (`TYPE_ID`, `TYPE_NAME`, `ACCT_ID`, `ACCT_ID_PL`, `ACCT_ID_COGS`) VALUES
('01', 'Franchise Group', '0700100001', '0500030003', '0800010101');

-- --------------------------------------------------------

--
-- Table structure for table `regions`
--

CREATE TABLE IF NOT EXISTS `regions` (
  `REG_ID` varchar(4) NOT NULL,
  `REG_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`REG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `regions`
--

INSERT INTO `regions` (`REG_ID`, `REG_NAME`) VALUES
('1', 'Punjab (Province)');

-- --------------------------------------------------------

--
-- Table structure for table `replanishment`
--

CREATE TABLE IF NOT EXISTS `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `replanishment`
--

INSERT INTO `replanishment` (`stock_code`, `qty`, `comp_id`) VALUES
('SD03001BL08', '2', '12'),
('SD03001BL09', '2', '12'),
('SD03001BL10', '2', '12'),
('SD03001BL11', '1', '12'),
('SD03002BL08', '2', '12'),
('SD03002BL09', '2', '12'),
('SD03002BL10', '2', '12'),
('SD03002BL11', '1', '12'),
('SD03003BL08', '2', '12'),
('SD03003BL09', '2', '12'),
('SD03003BL10', '2', '12'),
('SD03003BL11', '1', '12'),
('SD03004BL08', '2', '12'),
('SD03004BL09', '2', '12'),
('SD03004BL10', '2', '12'),
('SD03004BL11', '1', '12'),
('SD03005OW08', '2', '12'),
('SD03005OW09', '2', '12'),
('SD03005OW10', '2', '12'),
('SD03005OW11', '1', '12'),
('SD03006GO08', '2', '12'),
('SD03006GO09', '2', '12'),
('SD03006GO10', '2', '12'),
('SD03006GO11', '1', '12'),
('SD03007BL08', '2', '12'),
('SD03007BL09', '2', '12'),
('SD03007BL10', '2', '12'),
('SD03007BL11', '1', '12'),
('SD04001BG08', '2', '12'),
('SD04001BG09', '2', '12'),
('SD04001BG10', '2', '12'),
('SD04001BG11', '1', '12'),
('SD04002YB08', '2', '12'),
('SD04002YB09', '2', '12'),
('SD04002YB10', '2', '12'),
('SD04002YB11', '1', '12'),
('SD07001SB08', '2', '12'),
('SD07001SB09', '2', '12'),
('SD07001SB10', '2', '12'),
('SD07001SB11', '1', '12'),
('SD07002BU08', '2', '12'),
('SD07002BU09', '2', '12'),
('SD07002BU10', '2', '12'),
('SD07002BU11', '1', '12'),
('SD07003LR08', '2', '12'),
('SD07003LR09', '2', '12'),
('SD07003LR10', '2', '12'),
('SD07003LR11', '1', '12'),
('SD07004MR08', '2', '12'),
('SD07004MR09', '2', '12'),
('SD07004MR10', '2', '12'),
('SD07004MR11', '1', '12'),
('SD10001BL08', '2', '12'),
('SD10001BL09', '2', '12'),
('SD10001BL10', '2', '12'),
('SD10001BL11', '1', '12'),
('SD10002BL08', '2', '12'),
('SD10002BL09', '2', '12'),
('SD10002BL10', '2', '12'),
('SD10002BL11', '1', '12'),
('SD10003BL08', '2', '12'),
('SD10003BL09', '2', '12'),
('SD10003BL10', '2', '12'),
('SD10003BL11', '1', '12'),
('SD10004BL08', '2', '12'),
('SD10004BL09', '2', '12'),
('SD10004BL10', '2', '12'),
('SD10004BL11', '1', '12'),
('SD10005OW08', '2', '12'),
('SD10005OW09', '2', '12'),
('SD10005OW10', '2', '12'),
('SD10005OW11', '1', '12'),
('SD10006GO08', '2', '12'),
('SD10006GO09', '2', '12'),
('SD10006GO10', '2', '12'),
('SD10006GO11', '1', '12'),
('SD10007BL08', '2', '12'),
('SD10007BL09', '2', '12'),
('SD10007BL10', '2', '12'),
('SD10007BL11', '1', '12'),
('SD10008BU08', '2', '12'),
('SD10008BU09', '2', '12'),
('SD10008BU10', '2', '12'),
('SD10008BU11', '1', '12'),
('SD10009MR08', '2', '12'),
('SD10009MR09', '2', '12'),
('SD10009MR10', '2', '12'),
('SD10009MR11', '1', '12'),
('SD11001GO08', '2', '12'),
('SD11001GO09', '2', '12'),
('SD11001GO10', '2', '12'),
('SD11001GO11', '1', '12'),
('SD11002RD08', '2', '12'),
('SD11002RD09', '2', '12'),
('SD11002RD10', '2', '12'),
('SD11002RD11', '1', '12'),
('SD11003WH08', '2', '12'),
('SD11003WH09', '2', '12'),
('SD11003WH10', '2', '12'),
('SD11003WH11', '1', '12'),
('SD12001BL08', '2', '12'),
('SD12001BL09', '2', '12'),
('SD12001BL10', '2', '12'),
('SD12001BL11', '1', '12'),
('SD12002BU08', '2', '12'),
('SD12002BU09', '2', '12'),
('SD12002BU10', '2', '12'),
('SD12002BU11', '1', '12'),
('SD12003BL08', '2', '12'),
('SD12003BL09', '2', '12'),
('SD12003BL10', '2', '12'),
('SD12003BL11', '1', '12'),
('SD12004BU08', '2', '12'),
('SD12004BU09', '2', '12'),
('SD12004BU10', '2', '12'),
('SD12004BU11', '1', '12'),
('SD12005BL08', '2', '12'),
('SD12005BL09', '2', '12'),
('SD12005BL10', '2', '12'),
('SD12005BL11', '1', '12'),
('SG00001PU08', '2', '12'),
('SG00001PU09', '2', '12'),
('SG00001PU10', '2', '12'),
('SG00001PU11', '1', '12'),
('SG00002OW08', '2', '12'),
('SG00002OW09', '2', '12'),
('SG00002OW10', '2', '12'),
('SG00002OW11', '1', '12'),
('SG00003BL08', '2', '12'),
('SG00003BL09', '2', '12'),
('SG00003BL10', '2', '12'),
('SG00003BL11', '1', '12'),
('SG00004SN08', '2', '12'),
('SG00004SN09', '2', '12'),
('SG00004SN10', '2', '12'),
('SG00004SN11', '1', '12'),
('SG00005BU08', '2', '12'),
('SG00005BU09', '2', '12'),
('SG00005BU10', '2', '12'),
('SG00005BU11', '1', '12'),
('SG00006GO08', '2', '12'),
('SG00006GO09', '2', '12'),
('SG00006GO10', '2', '12'),
('SG00006GO11', '1', '12'),
('SG00007BR08', '2', '12'),
('SG00007BR09', '2', '12'),
('SG00007BR10', '2', '12'),
('SG00007BR11', '1', '12'),
('SG00008BU08', '2', '12'),
('SG00008BU09', '2', '12'),
('SG00008BU10', '2', '12'),
('SG00008BU11', '1', '12'),
('SG00009BU08', '2', '12'),
('SG00009BU09', '2', '12'),
('SG00009BU10', '2', '12'),
('SG00009BU11', '1', '12'),
('SG00010MS08', '2', '12'),
('SG00010MS09', '2', '12'),
('SG00010MS10', '2', '12'),
('SG00010MS11', '1', '12'),
('SG00011BR08', '2', '12'),
('SG00011BR09', '2', '12'),
('SG00011BR10', '2', '12'),
('SG00011BR11', '1', '12'),
('SG00012KH08', '2', '12'),
('SG00012KH09', '2', '12'),
('SG00012KH10', '2', '12'),
('SG00012KH11', '1', '12'),
('SG00013MR08', '2', '12'),
('SG00013MR09', '2', '12'),
('SG00013MR10', '2', '12'),
('SG00013MR11', '1', '12'),
('SG00014BL08', '2', '12'),
('SG00014BL09', '2', '12'),
('SG00014BL10', '2', '12'),
('SG00014BL11', '1', '12'),
('SG00015SB08', '2', '12'),
('SG00015SB09', '2', '12'),
('SG00015SB10', '2', '12'),
('SG00015SB11', '1', '12'),
('SG00016WH08', '2', '12'),
('SG00016WH09', '2', '12'),
('SG00016WH10', '2', '12'),
('SG00016WH11', '1', '12'),
('SG00017WH08', '2', '12'),
('SG00017WH09', '2', '12'),
('SG00017WH10', '2', '12'),
('SG00017WH11', '1', '12'),
('SG00018WH08', '2', '12'),
('SG00018WH09', '2', '12'),
('SG00018WH10', '2', '12'),
('SG00018WH11', '1', '12'),
('SG00019CB08', '2', '12'),
('SG00019CB09', '2', '12'),
('SG00019CB10', '2', '12'),
('SG00019CB11', '1', '12'),
('SG00020MR08', '2', '12'),
('SG00020MR09', '2', '12'),
('SG00020MR10', '2', '12'),
('SG00020MR11', '1', '12'),
('SG00021BL08', '2', '12'),
('SG00021BL09', '2', '12'),
('SG00021BL10', '2', '12'),
('SG00021BL11', '1', '12'),
('SG00022BR08', '2', '12'),
('SG00022BR09', '2', '12'),
('SG00022BR10', '2', '12'),
('SG00022BR11', '1', '12'),
('SG02097GO08', '2', '12'),
('SG02097GO09', '2', '12'),
('SG02097GO10', '2', '12'),
('SG02097GO11', '1', '12'),
('SG03001MD08', '2', '12'),
('SG03001MD09', '2', '12'),
('SG03001MD10', '2', '12'),
('SG03001MD11', '1', '12'),
('SG03001OW08', '2', '12'),
('SG03001OW09', '2', '12'),
('SG03001OW10', '2', '12'),
('SG03001OW11', '1', '12'),
('SG03002MD08', '2', '12'),
('SG03002MD09', '2', '12'),
('SG03002MD10', '2', '12'),
('SG03002MD11', '1', '12'),
('SG03002OW08', '2', '12'),
('SG03002OW09', '2', '12'),
('SG03002OW10', '2', '12'),
('SG03002OW11', '1', '12'),
('SG04001SG08', '2', '12'),
('SG04001SG09', '2', '12'),
('SG04001SG10', '2', '12'),
('SG04001SG11', '1', '12'),
('SG04002MR08', '2', '12'),
('SG04002MR09', '2', '12'),
('SG04002MR10', '2', '12'),
('SG04002MR11', '1', '12'),
('SG04002MV08', '2', '12'),
('SG04002MV09', '2', '12'),
('SG04002MV10', '2', '12'),
('SG04002MV11', '1', '12'),
('SG04003MR08', '2', '12'),
('SG04003MR09', '2', '12'),
('SG04003MR10', '2', '12'),
('SG04003MR11', '1', '12'),
('SG04004PK08', '2', '12'),
('SG04004PK09', '2', '12'),
('SG04004PK10', '2', '12'),
('SG04004PK11', '1', '12'),
('SG04005PR08', '2', '12'),
('SG04005PR09', '2', '12'),
('SG04005PR10', '2', '12'),
('SG04005PR11', '1', '12'),
('SK00001BR08', '2', '12'),
('SK00001BR09', '2', '12'),
('SK00001BR10', '2', '12'),
('SK00001BR11', '1', '12'),
('SK00001GR08', '2', '12'),
('SK00001GR09', '2', '12'),
('SK00001GR10', '2', '12'),
('SK00001GR11', '1', '12'),
('SK00002MU08', '2', '12'),
('SK00002MU09', '2', '12'),
('SK00002MU10', '2', '12'),
('SK00002MU11', '1', '12'),
('SK00003BL08', '2', '12'),
('SK00003BL09', '2', '12'),
('SK00003BL10', '2', '12'),
('SK00003BL11', '1', '12'),
('SK00003WH08', '2', '12'),
('SK00003WH09', '2', '12'),
('SK00003WH10', '2', '12'),
('SK00003WH11', '1', '12'),
('SK00004BL08', '2', '12'),
('SK00004BL09', '2', '12'),
('SK00004BL10', '2', '12'),
('SK00004BL11', '1', '12'),
('SK00005WH08', '2', '12'),
('SK00005WH09', '2', '12'),
('SK00005WH10', '2', '12'),
('SK00005WH11', '1', '12'),
('SK00006GR08', '2', '12'),
('SK00006GR09', '2', '12'),
('SK00006GR10', '2', '12'),
('SK00006GR11', '1', '12'),
('SK00006GY08', '2', '12'),
('SK00006GY09', '2', '12'),
('SK00006GY10', '2', '12'),
('SK00006GY11', '1', '12'),
('SK00007GY08', '2', '12'),
('SK00007GY09', '2', '12'),
('SK00007GY10', '2', '12'),
('SK00007GY11', '1', '12'),
('SK00008PL08', '2', '12'),
('SK00008PL09', '2', '12'),
('SK00008PL10', '2', '12'),
('SK00008PL11', '1', '12'),
('SK00009BR08', '2', '12'),
('SK00009BR09', '2', '12'),
('SK00009BR10', '2', '12'),
('SK00009BR11', '1', '12'),
('SK00010GR08', '2', '12'),
('SK00010GR09', '2', '12'),
('SK00010GR10', '2', '12'),
('SK00010GR11', '1', '12'),
('SK00011DG08', '2', '12'),
('SK00011DG09', '2', '12'),
('SK00011DG10', '2', '12'),
('SK00011DG11', '1', '12'),
('SK00011LG08', '2', '12'),
('SK00011LG09', '2', '12'),
('SK00011LG10', '2', '12'),
('SK00011LG11', '1', '12'),
('SK00012BR08', '2', '12'),
('SK00012BR09', '2', '12'),
('SK00012BR10', '2', '12'),
('SK00012BR11', '1', '12'),
('SK00012GY08', '2', '12'),
('SK00012GY09', '2', '12'),
('SK00012GY10', '2', '12'),
('SK00012GY11', '1', '12'),
('SK00013MH08', '2', '12'),
('SK00013MH09', '2', '12'),
('SK00013MH10', '2', '12'),
('SK00013MH11', '1', '12'),
('SK00017BL08', '2', '12'),
('SK00017BL09', '2', '12'),
('SK00017BL10', '2', '12'),
('SK00017BL11', '1', '12'),
('SK00017BU08', '2', '12'),
('SK00017BU09', '2', '12'),
('SK00017BU10', '2', '12'),
('SK00017BU11', '1', '12'),
('SK00018BR08', '2', '12'),
('SK00018BR09', '2', '12'),
('SK00018BR10', '2', '12'),
('SK00018BR11', '1', '12'),
('SK00018BU08', '2', '12'),
('SK00018BU09', '2', '12'),
('SK00018BU10', '2', '12'),
('SK00018BU11', '1', '12'),
('SK00018GB08', '2', '12'),
('SK00018GB09', '2', '12'),
('SK00018GB10', '2', '12'),
('SK00018GB11', '1', '12'),
('SK00019BR08', '2', '12'),
('SK00019BR09', '2', '12'),
('SK00019BR10', '2', '12'),
('SK00019BR11', '1', '12'),
('SK00020PR08', '2', '12'),
('SK00020PR09', '2', '12'),
('SK00020PR10', '2', '12'),
('SK00020PR11', '1', '12'),
('SK00021WH08', '2', '12'),
('SK00021WH09', '2', '12'),
('SK00021WH10', '2', '12'),
('SK00021WH11', '1', '12'),
('SK00022GY08', '2', '12'),
('SK00022GY09', '2', '12'),
('SK00022GY10', '2', '12'),
('SK00022GY11', '1', '12'),
('SK00022MR08', '2', '12'),
('SK00022MR09', '2', '12'),
('SK00022MR10', '2', '12'),
('SK00022MR11', '1', '12'),
('SK00023BU08', '2', '12'),
('SK00023BU09', '2', '12'),
('SK00023BU10', '2', '12'),
('SK00023BU11', '1', '12'),
('SK00023GR08', '2', '12'),
('SK00023GR09', '2', '12'),
('SK00023GR10', '2', '12'),
('SK00023GR11', '1', '12'),
('SK00025BU08', '2', '12'),
('SK00025BU09', '2', '12'),
('SK00025BU10', '2', '12'),
('SK00025BU11', '1', '12'),
('SK00025MV08', '2', '12'),
('SK00025MV09', '2', '12'),
('SK00025MV10', '2', '12'),
('SK00025MV11', '1', '12'),
('SK00025PU08', '2', '12'),
('SK00025PU09', '2', '12'),
('SK00025PU10', '2', '12'),
('SK00025PU11', '1', '12'),
('SK00026BD08', '2', '12'),
('SK00026BD09', '2', '12'),
('SK00026BD10', '2', '12'),
('SK00026BD11', '1', '12'),
('SK00026FE08', '2', '12'),
('SK00026FE09', '2', '12'),
('SK00026FE10', '2', '12'),
('SK00026FE11', '1', '12'),
('SK00026NE08', '2', '12'),
('SK00026NE09', '2', '12'),
('SK00026NE10', '2', '12'),
('SK00026NE11', '1', '12'),
('SK00027CR08', '2', '12'),
('SK00027CR09', '2', '12'),
('SK00027CR10', '2', '12'),
('SK00027CR11', '1', '12'),
('SK00027FE08', '2', '12'),
('SK00027FE09', '2', '12'),
('SK00027FE10', '2', '12'),
('SK00027FE11', '1', '12'),
('SK00027LV08', '2', '12'),
('SK00027LV09', '2', '12'),
('SK00027LV10', '2', '12'),
('SK00027LV11', '1', '12'),
('SK00030BU08', '2', '12'),
('SK00030BU09', '2', '12'),
('SK00030BU10', '2', '12'),
('SK00030BU11', '1', '12'),
('SK00033BU08', '2', '12'),
('SK00033BU09', '2', '12'),
('SK00033BU10', '2', '12'),
('SK00033BU11', '1', '12'),
('SK00033WH08', '2', '12'),
('SK00033WH09', '2', '12'),
('SK00033WH10', '2', '12'),
('SK00033WH11', '1', '12'),
('SK00034WH08', '2', '12'),
('SK00034WH09', '2', '12'),
('SK00034WH10', '2', '12'),
('SK00034WH11', '1', '12'),
('SK00035BL08', '2', '12'),
('SK00035BL09', '2', '12'),
('SK00035BL10', '2', '12'),
('SK00035BL11', '1', '12'),
('SK00036GO08', '2', '12'),
('SK00036GO09', '2', '12'),
('SK00036GO10', '2', '12'),
('SK00036GO11', '1', '12'),
('SK00036GR08', '2', '12'),
('SK00036GR09', '2', '12'),
('SK00036GR10', '2', '12'),
('SK00036GR11', '1', '12'),
('SK00036GY08', '2', '12'),
('SK00036GY09', '2', '12'),
('SK00036GY10', '2', '12'),
('SK00036GY11', '1', '12'),
('SK00037BL08', '2', '12'),
('SK00037BL09', '2', '12'),
('SK00037BL10', '2', '12'),
('SK00037BL11', '1', '12'),
('SK00038GO08', '2', '12'),
('SK00038GO09', '2', '12'),
('SK00038GO10', '2', '12'),
('SK00038GO11', '1', '12'),
('SK00039GY08', '2', '12'),
('SK00039GY09', '2', '12'),
('SK00039GY10', '2', '12'),
('SK00039GY11', '1', '12'),
('SK00040GR08', '2', '12'),
('SK00040GR09', '2', '12'),
('SK00040GR10', '2', '12'),
('SK00040GR11', '1', '12'),
('SK00041PU08', '2', '12'),
('SK00041PU09', '2', '12'),
('SK00041PU10', '2', '12'),
('SK00041PU11', '1', '12'),
('SK00042BU08', '2', '12'),
('SK00042BU09', '2', '12'),
('SK00042BU10', '2', '12'),
('SK00042BU11', '1', '12'),
('SK00049GY08', '2', '12'),
('SK00049GY09', '2', '12'),
('SK00049GY10', '2', '12'),
('SK00049GY11', '1', '12'),
('SK00055OR08', '2', '12'),
('SK00055OR09', '2', '12'),
('SK00055OR10', '2', '12'),
('SK00055OR11', '1', '12'),
('SK00056MR08', '2', '12'),
('SK00056MR09', '2', '12'),
('SK00056MR10', '2', '12'),
('SK00056MR11', '1', '12'),
('SK00059GR08', '2', '12'),
('SK00059GR09', '2', '12'),
('SK00059GR10', '2', '12'),
('SK00059GR11', '1', '12'),
('SK00060WH08', '2', '12'),
('SK00060WH09', '2', '12'),
('SK00060WH10', '2', '12'),
('SK00060WH11', '1', '12'),
('SK00062BL08', '2', '12'),
('SK00062BL09', '2', '12'),
('SK00062BL10', '2', '12'),
('SK00062BL11', '1', '12'),
('SK00063BL08', '2', '12'),
('SK00063BL09', '2', '12'),
('SK00063BL10', '2', '12'),
('SK00063BL11', '1', '12'),
('SK00064BL08', '2', '12'),
('SK00064BL09', '2', '12'),
('SK00064BL10', '2', '12'),
('SK00064BL11', '1', '12'),
('SK00070BL08', '2', '12'),
('SK00070BL09', '2', '12'),
('SK00070BL10', '2', '12'),
('SK00070BL11', '1', '12'),
('SK00071GY08', '2', '12'),
('SK00071GY09', '2', '12'),
('SK00071GY10', '2', '12'),
('SK00071GY11', '1', '12'),
('SK00072BU08', '2', '12'),
('SK00072BU09', '2', '12'),
('SK00072BU10', '2', '12'),
('SK00072BU11', '1', '12'),
('SK00073PH08', '2', '12'),
('SK00073PH09', '2', '12'),
('SK00073PH10', '2', '12'),
('SK00073PH11', '1', '12'),
('SK00074BU08', '2', '12'),
('SK00074BU09', '2', '12'),
('SK00074BU10', '2', '12'),
('SK00074BU11', '1', '12'),
('SK00075BL08', '2', '12'),
('SK00075BL09', '2', '12'),
('SK00075BL10', '2', '12'),
('SK00075BL11', '1', '12'),
('SK00076BR08', '2', '12'),
('SK00076BR09', '2', '12'),
('SK00076BR10', '2', '12'),
('SK00076BR11', '1', '12'),
('SK00077WH08', '2', '12'),
('SK00077WH09', '2', '12'),
('SK00077WH10', '2', '12'),
('SK00077WH11', '1', '12'),
('SK00079WH08', '2', '12'),
('SK00079WH09', '2', '12'),
('SK00079WH10', '2', '12'),
('SK00079WH11', '1', '12'),
('SK00082PU08', '2', '12'),
('SK00082PU09', '2', '12'),
('SK00082PU10', '2', '12'),
('SK00082PU11', '1', '12'),
('SK00083LG08', '2', '12'),
('SK00083LG09', '2', '12'),
('SK00083LG10', '2', '12'),
('SK00083LG11', '1', '12'),
('SK00086GR08', '2', '12'),
('SK00086GR09', '2', '12'),
('SK00086GR10', '2', '12'),
('SK00086GR11', '1', '12'),
('SK00087OR08', '2', '12'),
('SK00087OR09', '2', '12'),
('SK00087OR10', '2', '12'),
('SK00087OR11', '1', '12'),
('SK00088PR08', '2', '12'),
('SK00088PR09', '2', '12'),
('SK00088PR10', '2', '12'),
('SK00088PR11', '1', '12'),
('SK00089WH08', '2', '12'),
('SK00089WH09', '2', '12'),
('SK00089WH10', '2', '12'),
('SK00089WH11', '1', '12'),
('SK00090BL08', '2', '12'),
('SK00090BL09', '2', '12'),
('SK00090BL10', '2', '12'),
('SK00090BL11', '1', '12'),
('SK00092OF08', '2', '12'),
('SK00092OF09', '2', '12'),
('SK00092OF10', '2', '12'),
('SK00092OF11', '1', '12'),
('SK00093WH08', '2', '12'),
('SK00093WH09', '2', '12'),
('SK00093WH10', '2', '12'),
('SK00093WH11', '1', '12'),
('SK00094BR08', '2', '12'),
('SK00094BR09', '2', '12'),
('SK00094BR10', '2', '12'),
('SK00094BR11', '1', '12'),
('SK00095WH08', '2', '12'),
('SK00095WH09', '2', '12'),
('SK00095WH10', '2', '12'),
('SK00095WH11', '1', '12'),
('SK00096WH08', '2', '12'),
('SK00096WH09', '2', '12'),
('SK00096WH10', '2', '12'),
('SK00096WH11', '1', '12'),
('SK00097RS08', '2', '12'),
('SK00097RS09', '2', '12'),
('SK00097RS10', '2', '12'),
('SK00097RS11', '1', '12'),
('SK00098DB08', '2', '12'),
('SK00098DB09', '2', '12'),
('SK00098DB10', '2', '12'),
('SK00098DB11', '1', '12'),
('SK00099OW08', '2', '12'),
('SK00099OW09', '2', '12'),
('SK00099OW10', '2', '12'),
('SK00099OW11', '1', '12'),
('SK00100GR08', '2', '12'),
('SK00100GR09', '2', '12'),
('SK00100GR10', '2', '12'),
('SK00100GR11', '1', '12'),
('SK00101LG08', '2', '12'),
('SK00101LG09', '2', '12'),
('SK00101LG10', '2', '12'),
('SK00101LG11', '1', '12'),
('SK00102SB08', '2', '12'),
('SK00102SB09', '2', '12'),
('SK00102SB10', '2', '12'),
('SK00102SB11', '1', '12'),
('SK00103FN08', '2', '12'),
('SK00103FN09', '2', '12'),
('SK00103FN10', '2', '12'),
('SK00103FN11', '1', '12'),
('SK00105CB08', '2', '12'),
('SK00105CB09', '2', '12'),
('SK00105CB10', '2', '12'),
('SK00105CB11', '1', '12'),
('SK00107NB08', '2', '12'),
('SK00107NB09', '2', '12'),
('SK00107NB10', '2', '12'),
('SK00107NB11', '1', '12'),
('SK00109WH08', '2', '12'),
('SK00109WH09', '2', '12'),
('SK00109WH10', '2', '12'),
('SK00109WH11', '1', '12'),
('SK00110GO08', '2', '12'),
('SK00110GO09', '2', '12'),
('SK00110GO10', '2', '12'),
('SK00110GO11', '1', '12'),
('SK00112PU08', '2', '12'),
('SK00112PU09', '2', '12'),
('SK00112PU10', '2', '12'),
('SK00112PU11', '1', '12'),
('SK00113GY08', '2', '12'),
('SK00113GY09', '2', '12'),
('SK00113GY10', '2', '12'),
('SK00113GY11', '1', '12'),
('SK00114BR08', '2', '12'),
('SK00114BR09', '2', '12'),
('SK00114BR10', '2', '12'),
('SK00114BR11', '1', '12'),
('SK00115BL08', '2', '12'),
('SK00115BL09', '2', '12'),
('SK00115BL10', '2', '12'),
('SK00115BL11', '1', '12'),
('SK00116GY08', '2', '12'),
('SK00116GY09', '2', '12'),
('SK00116GY10', '2', '12'),
('SK00116GY11', '1', '12'),
('SK00117BL08', '2', '12'),
('SK00117BL09', '2', '12'),
('SK00117BL10', '2', '12'),
('SK00117BL11', '1', '12'),
('SK00118BL08', '2', '12'),
('SK00118BL09', '2', '12'),
('SK00118BL10', '2', '12'),
('SK00118BL11', '1', '12'),
('SK00119BL08', '2', '12'),
('SK00119BL09', '2', '12'),
('SK00119BL10', '2', '12'),
('SK00119BL11', '1', '12'),
('SK00120MR08', '2', '12'),
('SK00120MR09', '2', '12'),
('SK00120MR10', '2', '12'),
('SK00120MR11', '1', '12'),
('SK00121BL08', '2', '12'),
('SK00121BL09', '2', '12'),
('SK00121BL10', '2', '12'),
('SK00121BL11', '1', '12'),
('SK00122WH08', '0', '12'),
('SK00122WH09', '0', '12'),
('SK00122WH10', '0', '12'),
('SK00122WH11', '0', '12'),
('SD03001BL08', '2', '05'),
('SD03001BL09', '2', '05'),
('SD03001BL10', '2', '05'),
('SD03001BL11', '1', '05'),
('SD03002BL08', '2', '05'),
('SD03002BL09', '2', '05'),
('SD03002BL10', '2', '05'),
('SD03002BL11', '1', '05'),
('SD03003BL08', '2', '05'),
('SD03003BL09', '2', '05'),
('SD03003BL10', '2', '05'),
('SD03003BL11', '1', '05'),
('SD03004BL08', '2', '05'),
('SD03004BL09', '2', '05'),
('SD03004BL10', '2', '05'),
('SD03004BL11', '1', '05'),
('SD03005OW08', '2', '05'),
('SD03005OW09', '2', '05'),
('SD03005OW10', '2', '05'),
('SD03005OW11', '1', '05'),
('SD03006GO08', '2', '05'),
('SD03006GO09', '2', '05'),
('SD03006GO10', '2', '05'),
('SD03006GO11', '1', '05'),
('SD03007BL08', '2', '05'),
('SD03007BL09', '2', '05'),
('SD03007BL10', '2', '05'),
('SD03007BL11', '1', '05'),
('SD04001BG08', '2', '05'),
('SD04001BG09', '2', '05'),
('SD04001BG10', '2', '05'),
('SD04001BG11', '1', '05'),
('SD04002YB08', '2', '05'),
('SD04002YB09', '2', '05'),
('SD04002YB10', '2', '05'),
('SD04002YB11', '1', '05'),
('SD07001SB08', '2', '05'),
('SD07001SB09', '2', '05'),
('SD07001SB10', '2', '05'),
('SD07001SB11', '1', '05'),
('SD07002BU08', '2', '05'),
('SD07002BU09', '2', '05'),
('SD07002BU10', '2', '05'),
('SD07002BU11', '1', '05'),
('SD07003LR08', '2', '05'),
('SD07003LR09', '2', '05'),
('SD07003LR10', '2', '05'),
('SD07003LR11', '1', '05'),
('SD07004MR08', '2', '05'),
('SD07004MR09', '2', '05'),
('SD07004MR10', '2', '05'),
('SD07004MR11', '1', '05'),
('SD10001BL08', '2', '05'),
('SD10001BL09', '2', '05'),
('SD10001BL10', '2', '05'),
('SD10001BL11', '1', '05'),
('SD10002BL08', '2', '05'),
('SD10002BL09', '2', '05'),
('SD10002BL10', '2', '05'),
('SD10002BL11', '1', '05'),
('SD10003BL08', '2', '05'),
('SD10003BL09', '2', '05'),
('SD10003BL10', '2', '05'),
('SD10003BL11', '1', '05'),
('SD10004BL08', '2', '05'),
('SD10004BL09', '2', '05'),
('SD10004BL10', '2', '05'),
('SD10004BL11', '1', '05'),
('SD10005OW08', '2', '05'),
('SD10005OW09', '2', '05'),
('SD10005OW10', '2', '05'),
('SD10005OW11', '1', '05'),
('SD10006GO08', '2', '05'),
('SD10006GO09', '2', '05'),
('SD10006GO10', '2', '05'),
('SD10006GO11', '1', '05'),
('SD10007BL08', '2', '05'),
('SD10007BL09', '2', '05'),
('SD10007BL10', '2', '05'),
('SD10007BL11', '1', '05'),
('SD10008BU08', '2', '05'),
('SD10008BU09', '2', '05'),
('SD10008BU10', '2', '05'),
('SD10008BU11', '1', '05'),
('SD10009MR08', '2', '05'),
('SD10009MR09', '2', '05'),
('SD10009MR10', '2', '05'),
('SD10009MR11', '1', '05'),
('SD11001GO08', '2', '05'),
('SD11001GO09', '2', '05'),
('SD11001GO10', '2', '05'),
('SD11001GO11', '1', '05'),
('SD11002RD08', '2', '05'),
('SD11002RD09', '2', '05'),
('SD11002RD10', '2', '05'),
('SD11002RD11', '1', '05'),
('SD11003WH08', '2', '05'),
('SD11003WH09', '2', '05'),
('SD11003WH10', '2', '05'),
('SD11003WH11', '1', '05'),
('SD12001BL08', '2', '05'),
('SD12001BL09', '2', '05'),
('SD12001BL10', '2', '05'),
('SD12001BL11', '1', '05'),
('SD12002BU08', '2', '05'),
('SD12002BU09', '2', '05'),
('SD12002BU10', '2', '05'),
('SD12002BU11', '1', '05'),
('SD12003BL08', '2', '05'),
('SD12003BL09', '2', '05'),
('SD12003BL10', '2', '05'),
('SD12003BL11', '1', '05'),
('SD12004BU08', '2', '05'),
('SD12004BU09', '2', '05'),
('SD12004BU10', '2', '05'),
('SD12004BU11', '1', '05'),
('SD12005BL08', '2', '05'),
('SD12005BL09', '2', '05'),
('SD12005BL10', '2', '05'),
('SD12005BL11', '1', '05'),
('SG00001PU08', '2', '05'),
('SG00001PU09', '2', '05'),
('SG00001PU10', '2', '05'),
('SG00001PU11', '1', '05'),
('SG00002OW08', '2', '05'),
('SG00002OW09', '2', '05'),
('SG00002OW10', '2', '05'),
('SG00002OW11', '1', '05'),
('SG00003BL08', '2', '05'),
('SG00003BL09', '2', '05'),
('SG00003BL10', '2', '05'),
('SG00003BL11', '1', '05'),
('SG00004SN08', '2', '05'),
('SG00004SN09', '2', '05'),
('SG00004SN10', '2', '05'),
('SG00004SN11', '1', '05'),
('SG00005BU08', '2', '05'),
('SG00005BU09', '2', '05'),
('SG00005BU10', '2', '05'),
('SG00005BU11', '1', '05'),
('SG00006GO08', '2', '05'),
('SG00006GO09', '2', '05'),
('SG00006GO10', '2', '05'),
('SG00006GO11', '1', '05'),
('SG00007BR08', '2', '05'),
('SG00007BR09', '2', '05'),
('SG00007BR10', '2', '05'),
('SG00007BR11', '1', '05'),
('SG00008BU08', '2', '05'),
('SG00008BU09', '2', '05'),
('SG00008BU10', '2', '05'),
('SG00008BU11', '1', '05'),
('SG00009BU08', '2', '05'),
('SG00009BU09', '2', '05'),
('SG00009BU10', '2', '05'),
('SG00009BU11', '1', '05'),
('SG00010MS08', '2', '05'),
('SG00010MS09', '2', '05'),
('SG00010MS10', '2', '05'),
('SG00010MS11', '1', '05'),
('SG00011BR08', '2', '05'),
('SG00011BR09', '2', '05'),
('SG00011BR10', '2', '05'),
('SG00011BR11', '1', '05'),
('SG00012KH08', '2', '05'),
('SG00012KH09', '2', '05'),
('SG00012KH10', '2', '05'),
('SG00012KH11', '1', '05'),
('SG00013MR08', '2', '05'),
('SG00013MR09', '2', '05'),
('SG00013MR10', '2', '05'),
('SG00013MR11', '1', '05'),
('SG00014BL08', '2', '05'),
('SG00014BL09', '2', '05'),
('SG00014BL10', '2', '05'),
('SG00014BL11', '1', '05'),
('SG00015SB08', '2', '05'),
('SG00015SB09', '2', '05'),
('SG00015SB10', '2', '05'),
('SG00015SB11', '1', '05'),
('SG00016WH08', '2', '05'),
('SG00016WH09', '2', '05'),
('SG00016WH10', '2', '05'),
('SG00016WH11', '1', '05'),
('SG00017WH08', '2', '05'),
('SG00017WH09', '2', '05'),
('SG00017WH10', '2', '05'),
('SG00017WH11', '1', '05'),
('SG00018WH08', '2', '05'),
('SG00018WH09', '2', '05'),
('SG00018WH10', '2', '05'),
('SG00018WH11', '1', '05'),
('SG00019CB08', '2', '05'),
('SG00019CB09', '2', '05'),
('SG00019CB10', '2', '05'),
('SG00019CB11', '1', '05'),
('SG00020MR08', '2', '05'),
('SG00020MR09', '2', '05'),
('SG00020MR10', '2', '05'),
('SG00020MR11', '1', '05'),
('SG00021BL08', '2', '05'),
('SG00021BL09', '2', '05'),
('SG00021BL10', '2', '05'),
('SG00021BL11', '1', '05'),
('SG00022BR08', '2', '05'),
('SG00022BR09', '2', '05'),
('SG00022BR10', '2', '05'),
('SG00022BR11', '1', '05'),
('SG02097GO08', '2', '05'),
('SG02097GO09', '2', '05'),
('SG02097GO10', '2', '05'),
('SG02097GO11', '1', '05'),
('SG03001MD08', '2', '05'),
('SG03001MD09', '2', '05'),
('SG03001MD10', '2', '05'),
('SG03001MD11', '1', '05'),
('SG03001OW08', '2', '05'),
('SG03001OW09', '2', '05'),
('SG03001OW10', '2', '05'),
('SG03001OW11', '1', '05'),
('SG03002MD08', '2', '05'),
('SG03002MD09', '2', '05'),
('SG03002MD10', '2', '05'),
('SG03002MD11', '1', '05'),
('SG03002OW08', '2', '05'),
('SG03002OW09', '2', '05'),
('SG03002OW10', '2', '05'),
('SG03002OW11', '1', '05'),
('SG04001SG08', '2', '05'),
('SG04001SG09', '2', '05'),
('SG04001SG10', '2', '05'),
('SG04001SG11', '1', '05'),
('SG04002MR08', '2', '05'),
('SG04002MR09', '2', '05'),
('SG04002MR10', '2', '05'),
('SG04002MR11', '1', '05'),
('SG04002MV08', '2', '05'),
('SG04002MV09', '2', '05'),
('SG04002MV10', '2', '05'),
('SG04002MV11', '1', '05'),
('SG04003MR08', '2', '05'),
('SG04003MR09', '2', '05'),
('SG04003MR10', '2', '05'),
('SG04003MR11', '1', '05'),
('SG04004PK08', '2', '05'),
('SG04004PK09', '2', '05'),
('SG04004PK10', '2', '05'),
('SG04004PK11', '1', '05'),
('SG04005PR08', '2', '05'),
('SG04005PR09', '2', '05'),
('SG04005PR10', '2', '05'),
('SG04005PR11', '1', '05'),
('SK00001BR08', '2', '05'),
('SK00001BR09', '2', '05'),
('SK00001BR10', '2', '05'),
('SK00001BR11', '1', '05'),
('SK00001GR08', '2', '05'),
('SK00001GR09', '2', '05'),
('SK00001GR10', '2', '05'),
('SK00001GR11', '1', '05'),
('SK00002MU08', '2', '05'),
('SK00002MU09', '2', '05'),
('SK00002MU10', '2', '05'),
('SK00002MU11', '1', '05'),
('SK00003BL08', '2', '05'),
('SK00003BL09', '2', '05'),
('SK00003BL10', '2', '05'),
('SK00003BL11', '1', '05'),
('SK00003WH08', '2', '05'),
('SK00003WH09', '2', '05'),
('SK00003WH10', '2', '05'),
('SK00003WH11', '1', '05'),
('SK00004BL08', '2', '05'),
('SK00004BL09', '2', '05'),
('SK00004BL10', '2', '05'),
('SK00004BL11', '1', '05'),
('SK00005WH08', '2', '05'),
('SK00005WH09', '2', '05'),
('SK00005WH10', '2', '05'),
('SK00005WH11', '1', '05'),
('SK00006GR08', '2', '05'),
('SK00006GR09', '2', '05'),
('SK00006GR10', '2', '05'),
('SK00006GR11', '1', '05'),
('SK00006GY08', '2', '05'),
('SK00006GY09', '2', '05'),
('SK00006GY10', '2', '05'),
('SK00006GY11', '1', '05'),
('SK00007GY08', '2', '05'),
('SK00007GY09', '2', '05'),
('SK00007GY10', '2', '05'),
('SK00007GY11', '1', '05'),
('SK00008PL08', '2', '05'),
('SK00008PL09', '2', '05'),
('SK00008PL10', '2', '05'),
('SK00008PL11', '1', '05'),
('SK00009BR08', '2', '05'),
('SK00009BR09', '2', '05'),
('SK00009BR10', '2', '05'),
('SK00009BR11', '1', '05'),
('SK00010GR08', '2', '05'),
('SK00010GR09', '2', '05'),
('SK00010GR10', '2', '05'),
('SK00010GR11', '1', '05'),
('SK00011DG08', '2', '05'),
('SK00011DG09', '2', '05'),
('SK00011DG10', '2', '05'),
('SK00011DG11', '1', '05'),
('SK00011LG08', '2', '05'),
('SK00011LG09', '2', '05'),
('SK00011LG10', '2', '05'),
('SK00011LG11', '1', '05'),
('SK00012BR08', '2', '05'),
('SK00012BR09', '2', '05'),
('SK00012BR10', '2', '05'),
('SK00012BR11', '1', '05'),
('SK00012GY08', '2', '05'),
('SK00012GY09', '2', '05'),
('SK00012GY10', '2', '05'),
('SK00012GY11', '1', '05'),
('SK00013MH08', '2', '05'),
('SK00013MH09', '2', '05'),
('SK00013MH10', '2', '05'),
('SK00013MH11', '1', '05'),
('SK00017BL08', '2', '05'),
('SK00017BL09', '2', '05'),
('SK00017BL10', '2', '05'),
('SK00017BL11', '1', '05'),
('SK00017BU08', '2', '05'),
('SK00017BU09', '2', '05'),
('SK00017BU10', '2', '05'),
('SK00017BU11', '1', '05'),
('SK00018BR08', '2', '05'),
('SK00018BR09', '2', '05'),
('SK00018BR10', '2', '05'),
('SK00018BR11', '1', '05'),
('SK00018BU08', '2', '05'),
('SK00018BU09', '2', '05'),
('SK00018BU10', '2', '05'),
('SK00018BU11', '1', '05'),
('SK00018GB08', '2', '05'),
('SK00018GB09', '2', '05'),
('SK00018GB10', '2', '05'),
('SK00018GB11', '1', '05'),
('SK00019BR08', '2', '05'),
('SK00019BR09', '2', '05'),
('SK00019BR10', '2', '05'),
('SK00019BR11', '1', '05'),
('SK00020PR08', '2', '05'),
('SK00020PR09', '2', '05'),
('SK00020PR10', '2', '05'),
('SK00020PR11', '1', '05'),
('SK00021WH08', '2', '05'),
('SK00021WH09', '2', '05'),
('SK00021WH10', '2', '05'),
('SK00021WH11', '1', '05'),
('SK00022GY08', '2', '05'),
('SK00022GY09', '2', '05'),
('SK00022GY10', '2', '05'),
('SK00022GY11', '1', '05'),
('SK00022MR08', '2', '05'),
('SK00022MR09', '2', '05'),
('SK00022MR10', '2', '05'),
('SK00022MR11', '1', '05'),
('SK00023BU08', '2', '05'),
('SK00023BU09', '2', '05'),
('SK00023BU10', '2', '05'),
('SK00023BU11', '1', '05'),
('SK00023GR08', '2', '05'),
('SK00023GR09', '2', '05'),
('SK00023GR10', '2', '05'),
('SK00023GR11', '1', '05'),
('SK00025BU08', '2', '05'),
('SK00025BU09', '2', '05'),
('SK00025BU10', '2', '05'),
('SK00025BU11', '1', '05'),
('SK00025MV08', '2', '05'),
('SK00025MV09', '2', '05'),
('SK00025MV10', '2', '05'),
('SK00025MV11', '1', '05'),
('SK00025PU08', '2', '05'),
('SK00025PU09', '2', '05'),
('SK00025PU10', '2', '05'),
('SK00025PU11', '1', '05'),
('SK00026BD08', '2', '05'),
('SK00026BD09', '2', '05'),
('SK00026BD10', '2', '05'),
('SK00026BD11', '1', '05'),
('SK00026FE08', '2', '05'),
('SK00026FE09', '2', '05'),
('SK00026FE10', '2', '05'),
('SK00026FE11', '1', '05'),
('SK00026NE08', '2', '05'),
('SK00026NE09', '2', '05'),
('SK00026NE10', '2', '05'),
('SK00026NE11', '1', '05'),
('SK00027CR08', '2', '05'),
('SK00027CR09', '2', '05'),
('SK00027CR10', '2', '05'),
('SK00027CR11', '1', '05'),
('SK00027FE08', '2', '05'),
('SK00027FE09', '2', '05'),
('SK00027FE10', '2', '05'),
('SK00027FE11', '1', '05'),
('SK00027LV08', '2', '05'),
('SK00027LV09', '2', '05'),
('SK00027LV10', '2', '05'),
('SK00027LV11', '1', '05'),
('SK00030BU08', '2', '05'),
('SK00030BU09', '2', '05'),
('SK00030BU10', '2', '05'),
('SK00030BU11', '1', '05'),
('SK00033BU08', '2', '05'),
('SK00033BU09', '2', '05'),
('SK00033BU10', '2', '05'),
('SK00033BU11', '1', '05'),
('SK00033WH08', '2', '05'),
('SK00033WH09', '2', '05'),
('SK00033WH10', '2', '05'),
('SK00033WH11', '1', '05'),
('SK00034WH08', '2', '05'),
('SK00034WH09', '2', '05'),
('SK00034WH10', '2', '05'),
('SK00034WH11', '1', '05'),
('SK00035BL08', '2', '05'),
('SK00035BL09', '2', '05'),
('SK00035BL10', '2', '05'),
('SK00035BL11', '1', '05'),
('SK00036GO08', '2', '05'),
('SK00036GO09', '2', '05'),
('SK00036GO10', '2', '05'),
('SK00036GO11', '1', '05'),
('SK00036GR08', '2', '05'),
('SK00036GR09', '2', '05'),
('SK00036GR10', '2', '05'),
('SK00036GR11', '1', '05'),
('SK00036GY08', '2', '05'),
('SK00036GY09', '2', '05'),
('SK00036GY10', '2', '05'),
('SK00036GY11', '1', '05'),
('SK00037BL08', '2', '05'),
('SK00037BL09', '2', '05'),
('SK00037BL10', '2', '05'),
('SK00037BL11', '1', '05'),
('SK00038GO08', '2', '05'),
('SK00038GO09', '2', '05'),
('SK00038GO10', '2', '05'),
('SK00038GO11', '1', '05'),
('SK00039GY08', '2', '05'),
('SK00039GY09', '2', '05'),
('SK00039GY10', '2', '05'),
('SK00039GY11', '1', '05'),
('SK00040GR08', '2', '05'),
('SK00040GR09', '2', '05'),
('SK00040GR10', '2', '05'),
('SK00040GR11', '1', '05'),
('SK00041PU08', '2', '05'),
('SK00041PU09', '2', '05'),
('SK00041PU10', '2', '05'),
('SK00041PU11', '1', '05'),
('SK00042BU08', '2', '05'),
('SK00042BU09', '2', '05'),
('SK00042BU10', '2', '05'),
('SK00042BU11', '1', '05'),
('SK00049GY08', '2', '05'),
('SK00049GY09', '2', '05'),
('SK00049GY10', '2', '05'),
('SK00049GY11', '1', '05'),
('SK00055OR08', '2', '05'),
('SK00055OR09', '2', '05'),
('SK00055OR10', '2', '05'),
('SK00055OR11', '1', '05'),
('SK00056MR08', '2', '05'),
('SK00056MR09', '2', '05'),
('SK00056MR10', '2', '05'),
('SK00056MR11', '1', '05'),
('SK00059GR08', '2', '05'),
('SK00059GR09', '2', '05'),
('SK00059GR10', '2', '05'),
('SK00059GR11', '1', '05'),
('SK00060WH08', '2', '05'),
('SK00060WH09', '2', '05'),
('SK00060WH10', '2', '05'),
('SK00060WH11', '1', '05'),
('SK00062BL08', '2', '05'),
('SK00062BL09', '2', '05'),
('SK00062BL10', '2', '05'),
('SK00062BL11', '1', '05'),
('SK00063BL08', '2', '05'),
('SK00063BL09', '2', '05'),
('SK00063BL10', '2', '05'),
('SK00063BL11', '1', '05'),
('SK00064BL08', '2', '05'),
('SK00064BL09', '2', '05'),
('SK00064BL10', '2', '05'),
('SK00064BL11', '1', '05'),
('SK00070BL08', '2', '05'),
('SK00070BL09', '2', '05'),
('SK00070BL10', '2', '05'),
('SK00070BL11', '1', '05'),
('SK00071GY08', '2', '05'),
('SK00071GY09', '2', '05'),
('SK00071GY10', '2', '05'),
('SK00071GY11', '1', '05'),
('SK00072BU08', '2', '05'),
('SK00072BU09', '2', '05'),
('SK00072BU10', '2', '05'),
('SK00072BU11', '1', '05'),
('SK00073PH08', '2', '05'),
('SK00073PH09', '2', '05'),
('SK00073PH10', '2', '05'),
('SK00073PH11', '1', '05'),
('SK00074BU08', '2', '05'),
('SK00074BU09', '2', '05'),
('SK00074BU10', '2', '05'),
('SK00074BU11', '1', '05'),
('SK00075BL08', '2', '05'),
('SK00075BL09', '2', '05'),
('SK00075BL10', '2', '05'),
('SK00075BL11', '1', '05'),
('SK00076BR08', '2', '05'),
('SK00076BR09', '2', '05'),
('SK00076BR10', '2', '05'),
('SK00076BR11', '1', '05'),
('SK00077WH08', '2', '05'),
('SK00077WH09', '2', '05'),
('SK00077WH10', '2', '05'),
('SK00077WH11', '1', '05'),
('SK00079WH08', '2', '05'),
('SK00079WH09', '2', '05'),
('SK00079WH10', '2', '05'),
('SK00079WH11', '1', '05'),
('SK00082PU08', '2', '05'),
('SK00082PU09', '2', '05'),
('SK00082PU10', '2', '05'),
('SK00082PU11', '1', '05'),
('SK00083LG08', '2', '05'),
('SK00083LG09', '2', '05'),
('SK00083LG10', '2', '05'),
('SK00083LG11', '1', '05'),
('SK00086GR08', '2', '05'),
('SK00086GR09', '2', '05'),
('SK00086GR10', '2', '05'),
('SK00086GR11', '1', '05'),
('SK00087OR08', '2', '05'),
('SK00087OR09', '2', '05'),
('SK00087OR10', '2', '05'),
('SK00087OR11', '1', '05'),
('SK00088PR08', '2', '05'),
('SK00088PR09', '2', '05'),
('SK00088PR10', '2', '05'),
('SK00088PR11', '1', '05'),
('SK00089WH08', '2', '05'),
('SK00089WH09', '2', '05'),
('SK00089WH10', '2', '05'),
('SK00089WH11', '1', '05'),
('SK00090BL08', '2', '05'),
('SK00090BL09', '2', '05'),
('SK00090BL10', '2', '05'),
('SK00090BL11', '1', '05'),
('SK00092OF08', '2', '05'),
('SK00092OF09', '2', '05'),
('SK00092OF10', '2', '05'),
('SK00092OF11', '1', '05'),
('SK00093WH08', '2', '05'),
('SK00093WH09', '2', '05'),
('SK00093WH10', '2', '05'),
('SK00093WH11', '1', '05'),
('SK00094BR08', '2', '05'),
('SK00094BR09', '2', '05'),
('SK00094BR10', '2', '05'),
('SK00094BR11', '1', '05'),
('SK00095WH08', '2', '05'),
('SK00095WH09', '2', '05'),
('SK00095WH10', '2', '05'),
('SK00095WH11', '1', '05'),
('SK00096WH08', '2', '05'),
('SK00096WH09', '2', '05'),
('SK00096WH10', '2', '05'),
('SK00096WH11', '1', '05'),
('SK00097RS08', '2', '05'),
('SK00097RS09', '2', '05'),
('SK00097RS10', '2', '05'),
('SK00097RS11', '1', '05'),
('SK00098DB08', '2', '05'),
('SK00098DB09', '2', '05'),
('SK00098DB10', '2', '05'),
('SK00098DB11', '1', '05'),
('SK00099OW08', '2', '05'),
('SK00099OW09', '2', '05'),
('SK00099OW10', '2', '05'),
('SK00099OW11', '1', '05'),
('SK00100GR08', '2', '05'),
('SK00100GR09', '2', '05'),
('SK00100GR10', '2', '05'),
('SK00100GR11', '1', '05'),
('SK00101LG08', '2', '05'),
('SK00101LG09', '2', '05'),
('SK00101LG10', '2', '05'),
('SK00101LG11', '1', '05'),
('SK00102SB08', '2', '05'),
('SK00102SB09', '2', '05'),
('SK00102SB10', '2', '05'),
('SK00102SB11', '1', '05'),
('SK00103FN08', '2', '05'),
('SK00103FN09', '2', '05'),
('SK00103FN10', '2', '05'),
('SK00103FN11', '1', '05'),
('SK00105CB08', '2', '05'),
('SK00105CB09', '2', '05'),
('SK00105CB10', '2', '05'),
('SK00105CB11', '1', '05'),
('SK00107NB08', '2', '05'),
('SK00107NB09', '2', '05'),
('SK00107NB10', '2', '05'),
('SK00107NB11', '1', '05'),
('SK00109WH08', '2', '05'),
('SK00109WH09', '2', '05'),
('SK00109WH10', '2', '05'),
('SK00109WH11', '1', '05'),
('SK00110GO08', '2', '05'),
('SK00110GO09', '2', '05'),
('SK00110GO10', '2', '05'),
('SK00110GO11', '1', '05'),
('SK00112PU08', '2', '05'),
('SK00112PU09', '2', '05'),
('SK00112PU10', '2', '05'),
('SK00112PU11', '1', '05'),
('SK00113GY08', '2', '05'),
('SK00113GY09', '2', '05'),
('SK00113GY10', '2', '05'),
('SK00113GY11', '1', '05'),
('SK00114BR08', '2', '05'),
('SK00114BR09', '2', '05'),
('SK00114BR10', '2', '05'),
('SK00114BR11', '1', '05'),
('SK00115BL08', '2', '05'),
('SK00115BL09', '2', '05'),
('SK00115BL10', '2', '05'),
('SK00115BL11', '1', '05'),
('SK00116GY08', '2', '05'),
('SK00116GY09', '2', '05'),
('SK00116GY10', '2', '05'),
('SK00116GY11', '1', '05'),
('SK00117BL08', '2', '05'),
('SK00117BL09', '2', '05'),
('SK00117BL10', '2', '05'),
('SK00117BL11', '1', '05'),
('SK00118BL08', '2', '05'),
('SK00118BL09', '2', '05'),
('SK00118BL10', '2', '05'),
('SK00118BL11', '1', '05'),
('SK00119BL08', '2', '05'),
('SK00119BL09', '2', '05'),
('SK00119BL10', '2', '05'),
('SK00119BL11', '1', '05'),
('SK00120MR08', '2', '05'),
('SK00120MR09', '2', '05'),
('SK00120MR10', '2', '05'),
('SK00120MR11', '1', '05'),
('SK00121BL08', '2', '05'),
('SK00121BL09', '2', '05'),
('SK00121BL10', '2', '05'),
('SK00121BL11', '1', '05'),
('SK00122WH08', '0', '05'),
('SK00122WH09', '0', '05'),
('SK00122WH10', '0', '05'),
('SK00122WH11', '0', '05');

-- --------------------------------------------------------

--
-- Table structure for table `report`
--

CREATE TABLE IF NOT EXISTS `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `report`
--

INSERT INTO `report` (`date_from`, `date_to`) VALUES
('2010-11-25', '2015-11-25');

-- --------------------------------------------------------

--
-- Table structure for table `reports`
--

CREATE TABLE IF NOT EXISTS `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `reports_all`
--

CREATE TABLE IF NOT EXISTS `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `reports_all`
--

INSERT INTO `reports_all` (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`) VALUES
('accountsummary', 'Account Summary', '1', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `report_brands`
--

CREATE TABLE IF NOT EXISTS `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `report_brands`
--

INSERT INTO `report_brands` (`BRAND_ID_1`, `BRAND_ID_2`, `BRAND_ID_3`, `BRAND_ID_4`, `BRAND_ID_5`) VALUES
('1301', '1202', '1103', '1102', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `report_cat`
--

CREATE TABLE IF NOT EXISTS `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `report_comp`
--

CREATE TABLE IF NOT EXISTS `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `report_comp`
--

INSERT INTO `report_comp` (`COMP_ID`) VALUES
('01');

-- --------------------------------------------------------

--
-- Table structure for table `report_cs`
--

CREATE TABLE IF NOT EXISTS `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `report_div`
--

CREATE TABLE IF NOT EXISTS `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `report_party`
--

CREATE TABLE IF NOT EXISTS `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `report_party`
--

INSERT INTO `report_party` (`PARTY_ID`) VALUES
('0063');

-- --------------------------------------------------------

--
-- Table structure for table `report_sp`
--

CREATE TABLE IF NOT EXISTS `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `season_cat`
--

CREATE TABLE IF NOT EXISTS `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `season_cat`
--

INSERT INTO `season_cat` (`season_id`, `description`) VALUES
('010101', 'WINTER'),
('010102', 'SUMMER');

-- --------------------------------------------------------

--
-- Table structure for table `size`
--

CREATE TABLE IF NOT EXISTS `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `size`
--

INSERT INTO `size` (`size_id`, `size`) VALUES
('08', 'S'),
('09', 'M'),
('10', 'L'),
('11', 'XL');

-- --------------------------------------------------------

--
-- Table structure for table `sl_am_con`
--

CREATE TABLE IF NOT EXISTS `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_am_condet`
--

CREATE TABLE IF NOT EXISTS `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_cont`
--

CREATE TABLE IF NOT EXISTS `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_contdet`
--

CREATE TABLE IF NOT EXISTS `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_contmaint`
--

CREATE TABLE IF NOT EXISTS `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_contpay`
--

CREATE TABLE IF NOT EXISTS `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dc`
--

CREATE TABLE IF NOT EXISTS `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) DEFAULT NULL,
  `person` varchar(30) DEFAULT NULL,
  `tpt_mode` varchar(30) DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dcdet`
--

CREATE TABLE IF NOT EXISTS `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `ser_no` varchar(30) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dcdet_copy`
--

CREATE TABLE IF NOT EXISTS `sl_dcdet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dcdet_ser`
--

CREATE TABLE IF NOT EXISTS `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dc_rtn`
--

CREATE TABLE IF NOT EXISTS `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dc_rtndet`
--

CREATE TABLE IF NOT EXISTS `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_dc_rtndet_ser`
--

CREATE TABLE IF NOT EXISTS `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_gp`
--

CREATE TABLE IF NOT EXISTS `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_gp` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_gpdet`
--

CREATE TABLE IF NOT EXISTS `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(11,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_gpdet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_invoice`
--

CREATE TABLE IF NOT EXISTS `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sl_invoice`
--

INSERT INTO `sl_invoice` (`voucher_id`, `voucher_date`, `acct_id`, `disc_amt`, `dc_amt`, `net_amt`, `po_no`, `po_date`, `dc_no`, `dc_date`, `igp_no`, `igp_date`, `bill_no`, `bill_date`, `inv_no`, `inv_date`, `bilty_no`, `adda_name`, `loc_id`, `particulars`, `post_date`, `ut`, `sp_id`, `po_id`, `discp`, `project`, `service`, `adv_amt`, `brand_id`, `address`, `sms_no`, `comp_id`, `year_id`, `posted`, `customer_name`, `customer_phone`, `customer_cash`, `return_cash`, `bill_type`, `discount_voucher_no`, `return_status`, `exchange_status`) VALUES
('1', '2017-03-28', '', NULL, NULL, '6869.00', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, '01', NULL, '2017-03-28 11:44:19', '', '', '', NULL, '', '', NULL, '', '', NULL, '01', '16', NULL, '', '', '0', '0', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sl_invoicedet`
--

CREATE TABLE IF NOT EXISTS `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sl_invoicedet`
--

INSERT INTO `sl_invoicedet` (`voucher_id`, `lineitem`, `stock_code`, `particulars`, `qty`, `rate`, `itemtot`, `user_id`, `gp_qty`, `rej_qty`, `staxp`, `short_qty`, `avg_rate`, `stax_rate`, `stax`, `sed`, `sedp`, `fedp`, `fed`, `comp_id`, `year_id`, `discp`, `discount`, `sharing`) VALUES
('1', '1', '0001', '', '2.000', '190.00000', '380.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0'),
('1', '2', '0002', '', '4.000', '225.00000', '900.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0'),
('1', '3', '0003', '', '4.000', '412.00000', '840.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0'),
('1', '4', '0004', '', '4.000', '412.00000', '1648.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0'),
('1', '5', '0005', '', '1.000', '487.00000', '487.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0'),
('1', '6', '0006', '', '2.000', '637.00000', '1274.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0'),
('1', '7', '0003', '', '1.000', '500.00000', '500.00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '16', '0.000', NULL, '0');

-- --------------------------------------------------------

--
-- Table structure for table `sl_invoicedetapp`
--

CREATE TABLE IF NOT EXISTS `sl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_invoicedet_bon`
--

CREATE TABLE IF NOT EXISTS `sl_invoicedet_bon` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_invoice_rec`
--

CREATE TABLE IF NOT EXISTS `sl_invoice_rec` (
  `REC_ID` varchar(7) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_jv`
--

CREATE TABLE IF NOT EXISTS `sl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_jvdet`
--

CREATE TABLE IF NOT EXISTS `sl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_jvdet_inst`
--

CREATE TABLE IF NOT EXISTS `sl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_order`
--

CREATE TABLE IF NOT EXISTS `sl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `po_no` varchar(10) NOT NULL DEFAULT '',
  `po_date` date DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_orderdet`
--

CREATE TABLE IF NOT EXISTS `sl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_party_add`
--

CREATE TABLE IF NOT EXISTS `sl_party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_pay`
--

CREATE TABLE IF NOT EXISTS `sl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) DEFAULT '',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(10) DEFAULT '',
  `other_id_2` varchar(10) DEFAULT '',
  `other_id_3` varchar(10) DEFAULT '',
  `itax_id` varchar(10) DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_paydet`
--

CREATE TABLE IF NOT EXISTS `sl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_paydet_inst`
--

CREATE TABLE IF NOT EXISTS `sl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_payment`
--

CREATE TABLE IF NOT EXISTS `sl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) NOT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(100) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_paymentdet`
--

CREATE TABLE IF NOT EXISTS `sl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_po`
--

CREATE TABLE IF NOT EXISTS `sl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_podet`
--

CREATE TABLE IF NOT EXISTS `sl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `BONUS_QTY` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_product`
--

CREATE TABLE IF NOT EXISTS `sl_product` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `O_QTY` decimal(10,3) DEFAULT NULL,
  `O_RATE` decimal(10,2) DEFAULT NULL,
  `CAT_ID` varchar(6) NOT NULL,
  `TYPE_ID` varchar(10) NOT NULL,
  `BATCHWISE` varchar(1) NOT NULL,
  `REG_NO` varchar(10) DEFAULT NULL,
  `PACK_SIZE` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) NOT NULL,
  `P_RATE` decimal(10,2) DEFAULT NULL,
  `TYPE_GRP` varchar(1) NOT NULL,
  `PACK_RATE` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(10,3) NOT NULL,
  `ALL_CUST` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `GRP_ID` varchar(2) NOT NULL,
  `MOL_QTY` decimal(10,3) DEFAULT NULL,
  `MOL` varchar(1) DEFAULT NULL,
  `OLD_CODE` varchar(9) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PART_NO` varchar(30) DEFAULT NULL,
  `SAMPL_ID` varchar(4) DEFAULT NULL,
  `SAMPLE_ID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_products_log`
--

CREATE TABLE IF NOT EXISTS `sl_products_log` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `POST_DATE` datetime NOT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_product_brand`
--

CREATE TABLE IF NOT EXISTS `sl_product_brand` (
  `PROD_ID` varchar(4) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_product_rm`
--

CREATE TABLE IF NOT EXISTS `sl_product_rm` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(13,6) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `RM_ID` varchar(4) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sl_product_rm`
--

INSERT INTO `sl_product_rm` (`PROD_ID`, `PROD_FAC`, `LINEITEM`, `RM_ID`, `COMP_ID`) VALUES
('0356', '0.000310', '1', '0027', '01');

-- --------------------------------------------------------

--
-- Table structure for table `sl_quote`
--

CREATE TABLE IF NOT EXISTS `sl_quote` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(10,2) NOT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(5) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_quotedet`
--

CREATE TABLE IF NOT EXISTS `sl_quotedet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `UNIT_RATE` decimal(10,3) NOT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,0) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_receipt`
--

CREATE TABLE IF NOT EXISTS `sl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_receiptdet`
--

CREATE TABLE IF NOT EXISTS `sl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_receiptdet_acct`
--

CREATE TABLE IF NOT EXISTS `sl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_receiptdet_inv`
--

CREATE TABLE IF NOT EXISTS `sl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_return`
--

CREATE TABLE IF NOT EXISTS `sl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_return` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_returndet`
--

CREATE TABLE IF NOT EXISTS `sl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(10,0) NOT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_returndet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_sa`
--

CREATE TABLE IF NOT EXISTS `sl_sa` (
  `SA_ID` varchar(5) NOT NULL,
  `SA_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_sadet`
--

CREATE TABLE IF NOT EXISTS `sl_sadet` (
  `SA_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `AMOUNT` decimal(10,0) NOT NULL,
  `SP_ID` varchar(4) NOT NULL,
  `DIV_ID` varchar(2) NOT NULL,
  `CITY_ID` varchar(2) NOT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sl_wo`
--

CREATE TABLE IF NOT EXISTS `sl_wo` (
  `WO_ID` varchar(5) NOT NULL,
  `WO_DATE` datetime NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `WO_NAME` varchar(50) DEFAULT NULL,
  `DIV_ID` varchar(2) DEFAULT NULL,
  `CITY_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`WO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sp`
--

CREATE TABLE IF NOT EXISTS `sp` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sp`
--

INSERT INTO `sp` (`acct_id`, `acct_name`, `sms_no`, `comp_id`) VALUES
('0016', 'ALI SHAN', NULL, '01'),
('0002', 'Umer', NULL, '06'),
('0003', 'Awais', NULL, '06'),
('0004', 'Mohsin', NULL, '05'),
('0005', 'Sikandar', NULL, '05'),
('0006', 'Sikandar', NULL, '08'),
('0007', 'Faisal', NULL, '08'),
('0008', 'Talha', NULL, '08'),
('0009', 'Khurram', NULL, '07'),
('0010', 'Victor', NULL, '07'),
('0011', 'Usman', NULL, '02'),
('0012', 'Mohsin', NULL, '12'),
('0013', 'Faisal', NULL, '12'),
('0014', 'Ali Raza', NULL, '05'),
('0015', 'Victor', '', '13');

-- --------------------------------------------------------

--
-- Table structure for table `sp_party`
--

CREATE TABLE IF NOT EXISTS `sp_party` (
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `lineitem` varchar(4) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`sp_id`,`party_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `stk_cat`
--

CREATE TABLE IF NOT EXISTS `stk_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `stk_collection`
--

CREATE TABLE IF NOT EXISTS `stk_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `stk_collection`
--

INSERT INTO `stk_collection` (`col_id`, `description`) VALUES
('010101', 'Men'),
('010102', 'Gold');

-- --------------------------------------------------------

--
-- Table structure for table `stk_con`
--

CREATE TABLE IF NOT EXISTS `stk_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` bigint(10) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_con` (`voucher_id`,`bill_no`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `stk_condet`
--

CREATE TABLE IF NOT EXISTS `stk_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_condet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `system`
--

CREATE TABLE IF NOT EXISTS `system` (
  `comp_name` varchar(100) NOT NULL DEFAULT '',
  `cash_id` varchar(10) NOT NULL DEFAULT '',
  `bank_id` varchar(10) NOT NULL DEFAULT '',
  `creditor_id` varchar(10) DEFAULT '1601999',
  `stax_id` varchar(10) DEFAULT '2201001',
  `dc_id` varchar(10) DEFAULT '5302005',
  `disc_id` varchar(10) DEFAULT '5107001',
  `debtor_id` varchar(10) DEFAULT '4201999',
  `adv_id` varchar(10) DEFAULT '4201999',
  `db_id` varchar(10) DEFAULT '4201999',
  `ret_id` varchar(10) DEFAULT '4201999',
  `sec_id` varchar(10) DEFAULT '4201999',
  `stax_id_sl` varchar(10) DEFAULT '2201001',
  `dc_id_sl` varchar(10) DEFAULT '5302005',
  `disc_id_sl` varchar(10) DEFAULT '5107001',
  `adv_id_sl` varchar(10) DEFAULT '4201999',
  `db_id_sl` varchar(10) DEFAULT '4201999',
  `ret_id_sl` varchar(10) DEFAULT '4201999',
  `sec_id_sl` varchar(10) DEFAULT '4201999',
  `stock_id` varchar(10) DEFAULT '4201999',
  `turnover_id` varchar(10) DEFAULT '3010000001',
  `cogs_id` varchar(10) DEFAULT '3020000001',
  `sed_id` varchar(10) DEFAULT NULL,
  `sed_id_sl` varchar(10) DEFAULT NULL,
  `hide_taxes` char(1) DEFAULT NULL,
  `date_from` date DEFAULT '2009-07-01',
  `date_to` date DEFAULT '2010-06-30',
  `ait_id` varchar(10) DEFAULT NULL,
  `cdi_id` varchar(10) DEFAULT NULL,
  `date_close` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) DEFAULT 'support@clicksoft.org',
  `qty_decimal` int(11) DEFAULT '0',
  `fed_id` varchar(10) DEFAULT NULL,
  `fed_id_sl` varchar(10) DEFAULT NULL,
  `stock_transfer_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`comp_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `system`
--

INSERT INTO `system` (`comp_name`, `cash_id`, `bank_id`, `creditor_id`, `stax_id`, `dc_id`, `disc_id`, `debtor_id`, `adv_id`, `db_id`, `ret_id`, `sec_id`, `stax_id_sl`, `dc_id_sl`, `disc_id_sl`, `adv_id_sl`, `db_id_sl`, `ret_id_sl`, `sec_id_sl`, `stock_id`, `turnover_id`, `cogs_id`, `sed_id`, `sed_id_sl`, `hide_taxes`, `date_from`, `date_to`, `ait_id`, `cdi_id`, `date_close`, `email`, `qty_decimal`, `fed_id`, `fed_id_sl`, `stock_transfer_id`) VALUES
('KAFEEL GROUP', '261000', '261000', '1310000002', '3011000001', '5010000001', '2210000004', '2610000001', '1001001', '5010000001', '1001001', '1001001', '3011000001', '3020000010', '3020000002', '4201', '3020000010', '4201', '4201', '2210000001', '3010000001', '3020000001', '3011000005', '3011000005', '', '2011-07-01', '2012-06-30', '2530000002', '4060000005', '2000-12-31', 'accounts@rakcorporation.com,support@clicksoft.com.pk', 3, '3011000004', '3011000004', '2210000002');

-- --------------------------------------------------------

--
-- Table structure for table `tf`
--

CREATE TABLE IF NOT EXISTS `tf` (
  `INV_ID` varchar(5) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `PACK_SIZE` varchar(30) DEFAULT NULL,
  `PACK_QTY` decimal(10,2) DEFAULT NULL,
  `UNIT_QTY` decimal(10,2) DEFAULT NULL,
  `STD_WT` decimal(15,5) DEFAULT NULL,
  `UNIT_WT` decimal(15,5) DEFAULT NULL,
  `BATCH_MONTH` varchar(10) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `INACTIVE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tf`
--

INSERT INTO `tf` (`INV_ID`, `EMP_ID`, `PROD_ID`, `POSTED`, `COMP_ID`, `YEAR_ID`, `INV_DATE`, `PACK_SIZE`, `PACK_QTY`, `UNIT_QTY`, `STD_WT`, `UNIT_WT`, `BATCH_MONTH`, `EXP_DATE`, `INACTIVE`) VALUES
('00140', NULL, '0001', '', '', '', '2015-12-28 00:00:00', '1*1', '1.00', '222.00', '0.00000', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tfdet`
--

CREATE TABLE IF NOT EXISTS `tfdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(15,5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `DONT_INCLUDE` varchar(1) NOT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `LL_P` decimal(6,3) DEFAULT NULL,
  `LL_QTY` decimal(15,5) DEFAULT NULL,
  `QTY` decimal(15,5) DEFAULT NULL,
  `REQ_QTY` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tfdet`
--

INSERT INTO `tfdet` (`INV_ID`, `LINEITEM`, `EMP_ID`, `PROD_ID`, `PROD_FAC`, `POSTED`, `COMP_ID`, `YEAR_ID`, `DONT_INCLUDE`, `PROCESS_ID`, `LL_P`, `LL_QTY`, `QTY`, `REQ_QTY`) VALUES
('00141', '1', NULL, '0', NULL, '', '', '', '', NULL, NULL, NULL, '0.00000', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `trans`
--

CREATE TABLE IF NOT EXISTS `trans` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `trans`
--

INSERT INTO `trans` (`P_ID`, `P_DATE`, `COMP_ID`, `YEAR_ID`, `EMP_ID`, `LOC_ID`, `POSTED`, `PARTICULARS`) VALUES
('00001', '2015-08-08 00:00:00', '01', '15', 'inam', '01', 'N', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `transdet`
--

CREATE TABLE IF NOT EXISTS `transdet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `REMARKS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `transdet`
--

INSERT INTO `transdet` (`P_ID`, `LINEITEM`, `PROD_ID`, `QTY`, `RATE`, `PARTICULARS`, `ITEMTOT`, `COMP_ID`, `YEAR_ID`, `LOC_ID`, `BATCH_NO`, `REMARKS`) VALUES
('00001', '1', '0394', '332.000', NULL, '15D523', NULL, '01', '15', '02', NULL, 'Nearest Exipry Date 30-09-15');

-- --------------------------------------------------------

--
-- Table structure for table `tt`
--

CREATE TABLE IF NOT EXISTS `tt` (
  `v_id` int(11) NOT NULL AUTO_INCREMENT,
  `v_date` date DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `comp_name` varchar(100) DEFAULT NULL,
  `debit_amount` int(15) DEFAULT NULL,
  `credit_amount` int(15) DEFAULT NULL,
  `ref_no` varchar(250) DEFAULT NULL,
  `acct_type` varchar(250) DEFAULT NULL,
  `remarks` text,
  `opening_balance` int(15) DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `type`
--

CREATE TABLE IF NOT EXISTS `type` (
  `type_id` varchar(6) NOT NULL DEFAULT '',
  `type_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `type`
--

INSERT INTO `type` (`type_id`, `type_name`) VALUES
('0002', 'KHUSSA'),
('0003', 'SEMI FORMAL'),
('0004', 'FORMAL'),
('0005', 'CASUAL');

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

CREATE TABLE IF NOT EXISTS `units` (
  `unit` char(3) NOT NULL DEFAULT '',
  `unit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `units`
--

INSERT INTO `units` (`unit`, `unit_name`) VALUES
('Bag', 'Bags'),
('Bot', 'Bottle'),
('Bun', 'Bundle'),
('Coi', 'Coil'),
('Dru', 'Drum'),
('Dzn', 'Dzn'),
('Ft', 'Ft'),
('Gln', 'Gln'),
('Grm', 'Grams'),
('Kg', 'Kg'),
('Ltr', 'Liter'),
('Mtr', 'Mtr'),
('Nos', 'Nos'),
('Pai', 'Pairs'),
('Pcs', 'Pices'),
('Pkt', 'Pkt'),
('Qtr', 'Qtr'),
('Rft', 'Rft'),
('Rim', 'Rim'),
('Rol', 'Roll'),
('Set', 'Set'),
('Sqf', 'Sqft'),
('Tin', 'Tin'),
('Tro', 'Trolly'),
('Tru', 'Truck'),
('MT', 'M.Tons'),
('100', 'baggage'),
('Guz', 'GUZZ');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `EMP_ID` varchar(20) NOT NULL,
  `EMP_NAME` varchar(40) NOT NULL,
  `PASSWORD` varchar(20) DEFAULT NULL,
  `AUTH_ID` varchar(1) NOT NULL,
  `USE_FORM` varchar(1) DEFAULT NULL,
  `USE_REP` varchar(1) DEFAULT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `PK_BILL_NO_FROM` varchar(4) DEFAULT NULL,
  `PK_BILL_NO_TO` varchar(4) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `VOUCHER_TYPE` varchar(2) DEFAULT NULL,
  `POST` varchar(1) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `u_session_id` decimal(65,30) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`EMP_ID`, `EMP_NAME`, `PASSWORD`, `AUTH_ID`, `USE_FORM`, `USE_REP`, `LOGGED`, `COMP_ID`, `YEAR_ID`, `DATE_FROM`, `DATE_TO`, `CHASIS_NO`, `PK_BILL_NO_FROM`, `PK_BILL_NO_TO`, `USD`, `ACCT_ID`, `VOUCHER_TYPE`, `POST`, `SP_ID`, `u_session_id`) VALUES
('bt', 'BT', '123', '1', 'Y', 'Y', 'N', '01', '04', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '', '', '', '', 'N', '0007', '0.000000000000000000000000000000'),
('click', 'ClickSoft (Pvt) Ltd', '123', '9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL),
('it', 'IT', '123', '1', 'Y', 'Y', 'N', '01', '04', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '', '', '', '', 'N', '0007', '0.000000000000000000000000000000'),
('kt', 'Kafeel Trader', '123', '1', 'Y', 'Y', 'N', '01', '04', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '', '', '', '', 'N', '0007', '0.000000000000000000000000000000');

-- --------------------------------------------------------

--
-- Table structure for table `users_comp`
--

CREATE TABLE IF NOT EXISTS `users_comp` (
  `EMP_ID` varchar(20) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`,`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users_comp`
--

INSERT INTO `users_comp` (`EMP_ID`, `COMP_ID`, `LOGGED`) VALUES
('bt', 'BT', NULL),
('click', '01', NULL),
('click', 'BT', NULL),
('click', 'IT', NULL),
('it', 'IT', NULL),
('kt', 'BT', NULL),
('kt', 'IT', NULL),
('kt', 'KT', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users_menu`
--

CREATE TABLE IF NOT EXISTS `users_menu` (
  `emp_id` varchar(20) NOT NULL DEFAULT '',
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `inactive` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`emp_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `users_mod`
--

CREATE TABLE IF NOT EXISTS `users_mod` (
  `EMP_ID` varchar(6) NOT NULL,
  `VOUCHER_TYPE` varchar(20) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users_mod`
--

INSERT INTO `users_mod` (`EMP_ID`, `VOUCHER_TYPE`) VALUES
('Abid', 'PL_INVOICE');

-- --------------------------------------------------------

--
-- Table structure for table `users_rep`
--

CREATE TABLE IF NOT EXISTS `users_rep` (
  `EMP_ID` varchar(6) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`REP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users_rep`
--

INSERT INTO `users_rep` (`EMP_ID`, `REP_ID`) VALUES
('abid', '068');

-- --------------------------------------------------------

--
-- Table structure for table `user_mod`
--

CREATE TABLE IF NOT EXISTS `user_mod` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_CP',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `user_profile`
--

CREATE TABLE IF NOT EXISTS `user_profile` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `user_name` varchar(50) DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '123',
  `desig_id` varchar(30) DEFAULT '',
  `div_name` varchar(30) DEFAULT '',
  `sec_lvl` char(1) DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `user_profile`
--

INSERT INTO `user_profile` (`user_id`, `user_name`, `password`, `desig_id`, `div_name`, `sec_lvl`) VALUES
('HEAD OFFICE', 'HEAD OFFICE', '123', '', '', '0'),
('02-admin', 'EQUATOR', '123', '', '', '0'),
('03-admin', 'Wapda Town', '123', '', '', '0'),
('04-admin', 'Studio Mir - Gujranwala', '123', '', '', '0'),
('05-admin', 'Dreams - M.M.Alam', '123', '', '', '0');

-- --------------------------------------------------------

--
-- Table structure for table `user_rep`
--

CREATE TABLE IF NOT EXISTS `user_rep` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_10',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `vehicle_type`
--

CREATE TABLE IF NOT EXISTS `vehicle_type` (
  `vehicle_id` varchar(4) NOT NULL,
  `vehicle_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`vehicle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `vehicle_type`
--

INSERT INTO `vehicle_type` (`vehicle_id`, `vehicle_name`) VALUES
('0001', 'MAZDA'),
('0002', 'PICK UP');

-- --------------------------------------------------------

--
-- Table structure for table `voucher`
--

CREATE TABLE IF NOT EXISTS `voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime DEFAULT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `POSTED` char(2) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `UPD_DATE` datetime DEFAULT NULL,
  `UPD_EMP_ID` varchar(8) DEFAULT NULL,
  `ACCT_ID_CS_1` char(10) DEFAULT NULL,
  `ACCT_ID_CS_2` char(10) DEFAULT NULL,
  `BILTY_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `voucherdet`
--

CREATE TABLE IF NOT EXISTS `voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(65,30) DEFAULT NULL,
  `CREDIT` decimal(65,30) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ER` decimal(65,30) DEFAULT NULL,
  `UNIT_RATE` decimal(65,30) DEFAULT NULL,
  `TT_NO` varchar(30) DEFAULT NULL,
  `REG_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `voucher_id`
--

CREATE TABLE IF NOT EXISTS `voucher_id` (
  `v_id` int(11) DEFAULT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `voucher_id`
--

INSERT INTO `voucher_id` (`v_id`, `v_type`, `comp_id`) VALUES
(1, 'CP', '01'),
(2, 'CP', '01'),
(1, 'CP', ''),
(2, 'CP', ''),
(3, 'CP', '01'),
(1, 'CP', 'KT'),
(3, 'CP', ''),
(2, 'CP', 'KT'),
(3, 'CP', 'KT'),
(4, 'CP', 'KT'),
(5, 'CP', 'KT'),
(6, 'CP', 'KT'),
(7, 'CP', 'KT'),
(8, 'CP', 'KT'),
(9, 'CP', 'KT'),
(10, 'CP', 'KT'),
(11, 'CP', 'KT'),
(12, 'CP', 'KT'),
(13, 'CP', 'KT'),
(14, 'CP', 'KT'),
(1, 'JV', 'KT'),
(2, 'JV', 'KT'),
(3, 'JV', 'KT'),
(4, 'JV', 'KT'),
(1, 'SL', 'KT'),
(2, 'SL', 'KT'),
(3, 'SL', 'KT'),
(4, 'SL', 'KT'),
(5, 'SL', 'KT'),
(6, 'SL', 'KT'),
(7, 'SL', 'KT'),
(8, 'SL', 'KT'),
(9, 'SL', 'KT'),
(10, 'SL', 'KT'),
(11, 'SL', 'KT'),
(12, 'SL', 'KT'),
(13, 'SL', 'KT'),
(14, 'SL', 'KT'),
(15, 'SL', 'KT'),
(16, 'SL', 'KT'),
(17, 'SL', 'KT'),
(18, 'SL', 'KT'),
(19, 'SL', 'KT'),
(20, 'SL', 'KT'),
(21, 'SL', 'KT'),
(22, 'SL', 'KT'),
(23, 'SL', 'KT'),
(24, 'SL', 'KT'),
(25, 'SL', 'KT'),
(26, 'SL', 'KT'),
(27, 'SL', 'KT'),
(28, 'SL', 'KT'),
(29, 'SL', 'KT'),
(30, 'SL', 'KT'),
(31, 'SL', 'KT'),
(32, 'SL', 'KT'),
(33, 'SL', 'KT'),
(34, 'SL', 'KT'),
(35, 'SL', 'KT'),
(36, 'SL', 'KT'),
(37, 'SL', 'KT'),
(38, 'SL', 'KT'),
(40, 'SL', 'KT'),
(42, 'SL', 'KT'),
(43, 'SL', 'KT'),
(44, 'SL', 'KT'),
(45, 'SL', 'KT'),
(46, 'SL', 'KT'),
(47, 'SL', 'KT'),
(1, 'PL', 'KT'),
(2, 'PL', 'KT'),
(3, 'PL', 'KT'),
(4, 'PL', 'KT'),
(5, 'PL', 'KT'),
(6, 'PL', 'KT'),
(7, 'PL', 'KT'),
(8, 'PL', 'KT'),
(9, 'PL', 'KT'),
(10, 'PL', 'KT'),
(11, 'PL', 'KT'),
(12, 'PL', 'KT'),
(13, 'PL', 'KT'),
(1, 'ST', 'KT'),
(2, 'ST', 'KT'),
(3, 'ST', 'KT'),
(4, 'ST', 'KT'),
(5, 'ST', 'KT'),
(6, 'ST', 'KT'),
(7, 'ST', 'KT'),
(8, 'ST', 'KT'),
(9, 'ST', 'KT'),
(10, 'ST', 'KT'),
(11, 'ST', 'KT'),
(12, 'ST', 'KT'),
(13, 'ST', 'KT'),
(14, 'ST', 'KT'),
(15, 'ST', 'KT'),
(16, 'ST', 'KT'),
(17, 'ST', 'KT'),
(18, 'ST', 'KT'),
(19, 'ST', 'KT'),
(20, 'ST', 'KT'),
(21, 'ST', 'KT'),
(22, 'ST', 'KT'),
(23, 'ST', 'KT'),
(24, 'ST', 'KT'),
(25, 'ST', 'KT'),
(26, 'ST', 'KT'),
(27, 'ST', 'KT'),
(28, 'ST', 'KT'),
(29, 'ST', 'KT'),
(30, 'ST', 'KT'),
(31, 'ST', 'KT'),
(32, 'ST', 'KT'),
(33, 'ST', 'KT'),
(34, 'ST', 'KT'),
(35, 'ST', 'KT'),
(36, 'ST', 'KT'),
(37, 'ST', 'KT'),
(38, 'ST', 'KT'),
(39, 'ST', 'KT'),
(40, 'ST', 'KT'),
(41, 'ST', 'KT'),
(42, 'ST', 'KT'),
(43, 'ST', 'KT'),
(44, 'ST', 'KT'),
(14, 'PL', 'KT'),
(15, 'PL', 'KT'),
(16, 'PL', 'KT'),
(17, 'PL', 'KT'),
(18, 'PL', 'KT'),
(19, 'PL', 'KT'),
(48, 'SL', 'KT'),
(49, 'SL', 'KT'),
(45, 'ST', 'KT'),
(46, 'ST', 'KT'),
(47, 'ST', 'KT'),
(48, 'ST', 'KT'),
(49, 'ST', 'KT'),
(50, 'ST', 'KT'),
(51, 'ST', 'KT'),
(52, 'ST', 'KT'),
(53, 'ST', 'KT'),
(54, 'ST', 'KT'),
(55, 'ST', 'KT'),
(56, 'ST', 'KT'),
(57, 'ST', 'KT'),
(58, 'ST', 'KT'),
(59, 'ST', 'KT'),
(60, 'ST', 'KT'),
(15, 'CP', 'KT'),
(16, 'CP', 'KT'),
(5, 'JV', 'KT'),
(50, 'SL', 'KT'),
(17, 'CP', 'KT'),
(51, 'SL', 'KT'),
(6, 'JV', 'KT'),
(7, 'JV', 'KT'),
(8, 'JV', 'KT'),
(9, 'JV', 'KT'),
(20, 'PL', 'KT'),
(52, 'SL', 'KT'),
(53, 'SL', 'KT'),
(54, 'SL', 'KT'),
(21, 'PL', 'KT'),
(18, 'CP', 'KT'),
(55, 'SL', 'KT'),
(61, 'ST', 'KT'),
(56, 'SL', 'KT'),
(22, 'PL', 'KT'),
(62, 'ST', 'KT'),
(63, 'ST', 'KT'),
(57, 'SL', 'KT'),
(58, 'SL', 'KT'),
(59, 'SL', 'KT'),
(60, 'SL', 'KT'),
(61, 'SL', 'KT'),
(62, 'SL', 'KT'),
(63, 'SL', 'KT'),
(23, 'PL', 'KT'),
(24, 'PL', 'KT'),
(64, 'ST', 'KT'),
(1, 'SL', 'IT'),
(2, 'SL', 'IT'),
(25, 'PL', 'KT'),
(26, 'PL', 'KT'),
(27, 'PL', 'KT'),
(28, 'PL', 'KT'),
(29, 'PL', 'KT'),
(30, 'PL', 'KT'),
(31, 'PL', 'KT'),
(32, 'PL', 'KT'),
(33, 'PL', 'KT'),
(34, 'PL', 'KT'),
(35, 'PL', 'KT'),
(36, 'PL', 'KT'),
(37, 'PL', 'KT'),
(38, 'PL', 'KT'),
(39, 'PL', 'KT'),
(40, 'PL', 'KT'),
(41, 'PL', 'KT'),
(42, 'PL', 'KT'),
(43, 'PL', 'KT'),
(44, 'PL', 'KT'),
(45, 'PL', 'KT'),
(46, 'PL', 'KT'),
(47, 'PL', 'KT'),
(48, 'PL', 'KT'),
(49, 'PL', 'KT'),
(50, 'PL', 'KT'),
(51, 'PL', 'KT'),
(52, 'PL', 'KT'),
(53, 'PL', 'KT'),
(54, 'PL', 'KT'),
(55, 'PL', 'KT'),
(56, 'PL', 'KT'),
(57, 'PL', 'KT'),
(58, 'PL', 'KT'),
(59, 'PL', 'KT'),
(60, 'PL', 'KT'),
(61, 'PL', 'KT'),
(62, 'PL', 'KT'),
(63, 'PL', 'KT'),
(64, 'PL', 'KT'),
(65, 'PL', 'KT'),
(66, 'PL', 'KT'),
(67, 'PL', 'KT'),
(68, 'PL', 'KT'),
(69, 'PL', 'KT'),
(70, 'PL', 'KT'),
(71, 'PL', 'KT'),
(72, 'PL', 'KT'),
(73, 'PL', 'KT'),
(74, 'PL', 'KT'),
(75, 'PL', 'KT'),
(76, 'PL', 'KT'),
(77, 'PL', 'KT'),
(78, 'PL', 'KT'),
(79, 'PL', 'KT'),
(64, 'SL', 'KT'),
(80, 'PL', 'KT'),
(65, 'SL', 'KT'),
(66, 'SL', 'KT'),
(67, 'SL', 'KT'),
(68, 'SL', 'KT'),
(69, 'SL', 'KT'),
(70, 'SL', 'KT'),
(71, 'SL', 'KT'),
(72, 'SL', 'KT'),
(73, 'SL', 'KT'),
(74, 'SL', 'KT'),
(75, 'SL', 'KT'),
(76, 'SL', 'KT'),
(77, 'SL', 'KT'),
(78, 'SL', 'KT'),
(79, 'SL', 'KT'),
(80, 'SL', 'KT'),
(81, 'SL', 'KT'),
(82, 'SL', 'KT'),
(83, 'SL', 'KT'),
(84, 'SL', 'KT'),
(85, 'SL', 'KT'),
(86, 'SL', 'KT'),
(87, 'SL', 'KT'),
(81, 'PL', 'KT'),
(88, 'SL', 'KT'),
(89, 'SL', 'KT'),
(90, 'SL', 'KT'),
(91, 'SL', 'KT'),
(92, 'SL', 'KT'),
(93, 'SL', 'KT'),
(94, 'SL', 'KT'),
(82, 'PL', 'KT'),
(95, 'SL', 'KT'),
(96, 'SL', 'KT'),
(97, 'SL', 'KT'),
(98, 'SL', 'KT'),
(99, 'SL', 'KT'),
(100, 'SL', 'KT'),
(101, 'SL', 'KT'),
(102, 'SL', 'KT'),
(103, 'SL', 'KT'),
(104, 'SL', 'KT'),
(105, 'SL', 'KT'),
(106, 'SL', 'KT'),
(107, 'SL', 'KT'),
(108, 'SL', 'KT'),
(109, 'SL', 'KT'),
(110, 'SL', 'KT'),
(111, 'SL', 'KT'),
(112, 'SL', 'KT'),
(113, 'SL', 'KT'),
(114, 'SL', 'KT'),
(115, 'SL', 'KT'),
(116, 'SL', 'KT'),
(117, 'SL', 'KT'),
(118, 'SL', 'KT'),
(119, 'SL', 'KT'),
(83, 'PL', 'KT'),
(84, 'PL', 'KT'),
(85, 'PL', 'KT'),
(86, 'PL', 'KT'),
(87, 'PL', 'KT'),
(120, 'SL', 'KT'),
(88, 'PL', 'KT'),
(89, 'PL', 'KT'),
(90, 'PL', 'KT'),
(91, 'PL', 'KT'),
(10, 'JV', 'KT'),
(11, 'JV', 'KT'),
(12, 'JV', 'KT'),
(13, 'JV', 'KT'),
(14, 'JV', 'KT'),
(15, 'JV', 'KT'),
(16, 'JV', 'KT'),
(17, 'JV', 'KT'),
(18, 'JV', 'KT'),
(19, 'JV', 'KT'),
(20, 'JV', 'KT'),
(21, 'JV', 'KT'),
(22, 'JV', 'KT'),
(23, 'JV', 'KT'),
(24, 'JV', 'KT'),
(25, 'JV', 'KT'),
(26, 'JV', 'KT'),
(27, 'JV', 'KT'),
(28, 'JV', 'KT'),
(92, 'PL', 'KT'),
(93, 'PL', 'KT'),
(94, 'PL', 'KT'),
(95, 'PL', 'KT'),
(96, 'PL', 'KT'),
(97, 'PL', 'KT'),
(98, 'PL', 'KT'),
(99, 'PL', 'KT'),
(121, 'SL', 'KT'),
(122, 'SL', 'KT'),
(123, 'SL', 'KT'),
(29, 'JV', 'KT'),
(30, 'JV', 'KT'),
(31, 'JV', 'KT'),
(32, 'JV', 'KT'),
(33, 'JV', 'KT'),
(34, 'JV', 'KT'),
(124, 'SL', 'KT'),
(125, 'SL', 'KT'),
(126, 'SL', 'KT'),
(127, 'SL', 'KT'),
(100, 'PL', 'KT'),
(101, 'PL', 'KT'),
(102, 'PL', 'KT'),
(103, 'PL', 'KT'),
(104, 'PL', 'KT'),
(105, 'PL', 'KT'),
(106, 'PL', 'KT'),
(107, 'PL', 'KT'),
(108, 'PL', 'KT'),
(109, 'PL', 'KT'),
(110, 'PL', 'KT'),
(111, 'PL', 'KT'),
(112, 'PL', 'KT'),
(113, 'PL', 'KT'),
(35, 'JV', 'KT'),
(36, 'JV', 'KT'),
(37, 'JV', 'KT'),
(38, 'JV', 'KT'),
(39, 'JV', 'KT'),
(40, 'JV', 'KT'),
(41, 'JV', 'KT'),
(42, 'JV', 'KT'),
(43, 'JV', 'KT'),
(44, 'JV', 'KT'),
(45, 'JV', 'KT'),
(46, 'JV', 'KT'),
(47, 'JV', 'KT'),
(48, 'JV', 'KT'),
(49, 'JV', 'KT'),
(50, 'JV', 'KT'),
(51, 'JV', 'KT'),
(52, 'JV', 'KT'),
(128, 'SL', 'KT'),
(129, 'SL', 'KT'),
(53, 'JV', 'KT'),
(54, 'JV', 'KT'),
(55, 'JV', 'KT'),
(56, 'JV', 'KT'),
(114, 'PL', 'KT'),
(57, 'JV', 'KT'),
(115, 'PL', 'KT'),
(116, 'PL', 'KT'),
(117, 'PL', 'KT'),
(118, 'PL', 'KT'),
(119, 'PL', 'KT'),
(120, 'PL', 'KT'),
(121, 'PL', 'KT'),
(130, 'SL', 'KT'),
(131, 'SL', 'KT'),
(132, 'SL', 'KT'),
(133, 'SL', 'KT'),
(65, 'ST', 'KT'),
(66, 'ST', 'KT'),
(67, 'ST', 'KT'),
(68, 'ST', 'KT'),
(69, 'ST', 'KT'),
(134, 'SL', 'KT'),
(122, 'PL', 'KT'),
(19, 'CP', 'KT'),
(20, 'CP', 'KT'),
(21, 'CP', 'KT'),
(22, 'CP', 'KT'),
(23, 'CP', 'KT'),
(24, 'CP', 'KT'),
(25, 'CP', 'KT'),
(26, 'CP', 'KT'),
(27, 'CP', 'KT'),
(28, 'CP', 'KT'),
(29, 'CP', 'KT'),
(30, 'CP', 'KT'),
(31, 'CP', 'KT'),
(32, 'CP', 'KT'),
(33, 'CP', 'KT'),
(135, 'SL', 'KT'),
(34, 'CP', 'KT'),
(35, 'CP', 'KT'),
(36, 'CP', 'KT'),
(37, 'CP', 'KT'),
(38, 'CP', 'KT'),
(39, 'CP', 'KT'),
(40, 'CP', 'KT'),
(41, 'CP', 'KT'),
(42, 'CP', 'KT'),
(43, 'CP', 'KT'),
(44, 'CP', 'KT'),
(45, 'CP', 'KT'),
(46, 'CP', 'KT'),
(47, 'CP', 'KT'),
(48, 'CP', 'KT'),
(49, 'CP', 'KT'),
(50, 'CP', 'KT'),
(51, 'CP', 'KT'),
(52, 'CP', 'KT'),
(53, 'CP', 'KT'),
(54, 'CP', 'KT'),
(55, 'CP', 'KT'),
(56, 'CP', 'KT'),
(57, 'CP', 'KT'),
(58, 'CP', 'KT'),
(59, 'CP', 'KT'),
(60, 'CP', 'KT'),
(61, 'CP', 'KT'),
(62, 'CP', 'KT'),
(63, 'CP', 'KT'),
(64, 'CP', 'KT'),
(65, 'CP', 'KT'),
(66, 'CP', 'KT'),
(67, 'CP', 'KT'),
(68, 'CP', 'KT'),
(69, 'CP', 'KT'),
(70, 'CP', 'KT'),
(71, 'CP', 'KT'),
(72, 'CP', 'KT'),
(73, 'CP', 'KT'),
(74, 'CP', 'KT'),
(75, 'CP', 'KT'),
(76, 'CP', 'KT'),
(77, 'CP', 'KT'),
(78, 'CP', 'KT'),
(79, 'CP', 'KT'),
(80, 'CP', 'KT'),
(123, 'PL', 'KT'),
(124, 'PL', 'KT'),
(125, 'PL', 'KT'),
(126, 'PL', 'KT'),
(127, 'PL', 'KT'),
(128, 'PL', 'KT'),
(129, 'PL', 'KT'),
(130, 'PL', 'KT'),
(131, 'PL', 'KT'),
(132, 'PL', 'KT'),
(133, 'PL', 'KT'),
(134, 'PL', 'KT'),
(135, 'PL', 'KT'),
(136, 'PL', 'KT'),
(137, 'PL', 'KT'),
(138, 'PL', 'KT'),
(139, 'PL', 'KT'),
(140, 'PL', 'KT'),
(141, 'PL', 'KT'),
(142, 'PL', 'KT'),
(136, 'SL', 'KT'),
(137, 'SL', 'KT'),
(143, 'PL', 'KT'),
(144, 'PL', 'KT'),
(145, 'PL', 'KT'),
(146, 'PL', 'KT'),
(81, 'CP', 'KT'),
(82, 'CP', 'KT'),
(83, 'CP', 'KT'),
(84, 'CP', 'KT'),
(85, 'CP', 'KT'),
(86, 'CP', 'KT'),
(87, 'CP', 'KT'),
(88, 'CP', 'KT'),
(89, 'CP', 'KT'),
(90, 'CP', 'KT'),
(91, 'CP', 'KT'),
(92, 'CP', 'KT'),
(93, 'CP', 'KT'),
(94, 'CP', 'KT'),
(95, 'CP', 'KT'),
(96, 'CP', 'KT'),
(97, 'CP', 'KT'),
(98, 'CP', 'KT'),
(99, 'CP', 'KT'),
(100, 'CP', 'KT'),
(101, 'CP', 'KT'),
(102, 'CP', 'KT'),
(103, 'CP', 'KT'),
(104, 'CP', 'KT'),
(105, 'CP', 'KT'),
(106, 'CP', 'KT'),
(107, 'CP', 'KT'),
(108, 'CP', 'KT'),
(109, 'CP', 'KT'),
(110, 'CP', 'KT'),
(111, 'CP', 'KT'),
(112, 'CP', 'KT'),
(113, 'CP', 'KT'),
(114, 'CP', 'KT'),
(115, 'CP', 'KT'),
(116, 'CP', 'KT'),
(117, 'CP', 'KT'),
(118, 'CP', 'KT'),
(119, 'CP', 'KT'),
(120, 'CP', 'KT'),
(121, 'CP', 'KT'),
(122, 'CP', 'KT'),
(123, 'CP', 'KT'),
(124, 'CP', 'KT'),
(125, 'CP', 'KT'),
(147, 'PL', 'KT'),
(148, 'PL', 'KT'),
(149, 'PL', 'KT'),
(150, 'PL', 'KT'),
(151, 'PL', 'KT'),
(152, 'PL', 'KT'),
(153, 'PL', 'KT'),
(154, 'PL', 'KT'),
(155, 'PL', 'KT'),
(156, 'PL', 'KT'),
(157, 'PL', 'KT'),
(158, 'PL', 'KT'),
(159, 'PL', 'KT'),
(160, 'PL', 'KT'),
(161, 'PL', 'KT'),
(162, 'PL', 'KT'),
(163, 'PL', 'KT'),
(164, 'PL', 'KT'),
(165, 'PL', 'KT'),
(166, 'PL', 'KT'),
(167, 'PL', 'KT'),
(168, 'PL', 'KT'),
(169, 'PL', 'KT'),
(170, 'PL', 'KT'),
(171, 'PL', 'KT'),
(172, 'PL', 'KT'),
(173, 'PL', 'KT'),
(174, 'PL', 'KT'),
(175, 'PL', 'KT'),
(176, 'PL', 'KT'),
(177, 'PL', 'KT'),
(178, 'PL', 'KT'),
(179, 'PL', 'KT'),
(180, 'PL', 'KT'),
(181, 'PL', 'KT'),
(182, 'PL', 'KT'),
(183, 'PL', 'KT'),
(184, 'PL', 'KT'),
(185, 'PL', 'KT'),
(186, 'PL', 'KT'),
(187, 'PL', 'KT'),
(188, 'PL', 'KT'),
(189, 'PL', 'KT'),
(190, 'PL', 'KT'),
(191, 'PL', 'KT'),
(192, 'PL', 'KT'),
(193, 'PL', 'KT'),
(194, 'PL', 'KT'),
(195, 'PL', 'KT'),
(196, 'PL', 'KT'),
(197, 'PL', 'KT'),
(198, 'PL', 'KT'),
(199, 'PL', 'KT'),
(200, 'PL', 'KT'),
(201, 'PL', 'KT'),
(202, 'PL', 'KT'),
(203, 'PL', 'KT'),
(204, 'PL', 'KT'),
(205, 'PL', 'KT'),
(206, 'PL', 'KT'),
(207, 'PL', 'KT'),
(208, 'PL', 'KT'),
(209, 'PL', 'KT'),
(210, 'PL', 'KT'),
(211, 'PL', 'KT'),
(212, 'PL', 'KT'),
(213, 'PL', 'KT'),
(214, 'PL', 'KT'),
(215, 'PL', 'KT'),
(216, 'PL', 'KT'),
(217, 'PL', 'KT'),
(218, 'PL', 'KT'),
(219, 'PL', 'KT'),
(126, 'CP', 'KT'),
(127, 'CP', 'KT'),
(70, 'ST', 'KT'),
(128, 'CP', 'KT'),
(129, 'CP', 'KT'),
(130, 'CP', 'KT'),
(131, 'CP', 'KT'),
(220, 'PL', 'KT'),
(221, 'PL', 'KT'),
(222, 'PL', 'KT'),
(223, 'PL', 'KT'),
(224, 'PL', 'KT'),
(225, 'PL', 'KT'),
(226, 'PL', 'KT'),
(227, 'PL', 'KT'),
(228, 'PL', 'KT'),
(229, 'PL', 'KT'),
(230, 'PL', 'KT'),
(138, 'SL', 'KT'),
(231, 'PL', 'KT'),
(232, 'PL', 'KT'),
(71, 'ST', 'KT'),
(72, 'ST', 'KT'),
(73, 'ST', 'KT'),
(74, 'ST', 'KT'),
(75, 'ST', 'KT'),
(76, 'ST', 'KT'),
(77, 'ST', 'KT'),
(78, 'ST', 'KT'),
(79, 'ST', 'KT'),
(80, 'ST', 'KT'),
(81, 'ST', 'KT'),
(82, 'ST', 'KT'),
(139, 'SL', 'KT'),
(233, 'PL', 'KT'),
(234, 'PL', 'KT'),
(235, 'PL', 'KT'),
(236, 'PL', 'KT'),
(140, 'SL', 'KT'),
(237, 'PL', 'KT'),
(141, 'SL', 'KT'),
(142, 'SL', 'KT'),
(238, 'PL', 'KT'),
(83, 'ST', 'KT'),
(132, 'CP', 'KT'),
(133, 'CP', 'KT'),
(134, 'CP', 'KT'),
(135, 'CP', 'KT'),
(239, 'PL', 'KT'),
(240, 'PL', 'KT'),
(241, 'PL', 'KT'),
(242, 'PL', 'KT'),
(243, 'PL', 'KT'),
(244, 'PL', 'KT'),
(245, 'PL', 'KT'),
(246, 'PL', 'KT'),
(143, 'SL', 'KT'),
(144, 'SL', 'KT'),
(145, 'SL', 'KT'),
(146, 'SL', 'KT'),
(147, 'SL', 'KT'),
(148, 'SL', 'KT'),
(149, 'SL', 'KT'),
(150, 'SL', 'KT'),
(151, 'SL', 'KT'),
(152, 'SL', 'KT'),
(153, 'SL', 'KT'),
(154, 'SL', 'KT'),
(155, 'SL', 'KT'),
(84, 'ST', 'KT'),
(247, 'PL', 'KT'),
(248, 'PL', 'KT'),
(85, 'ST', 'KT'),
(249, 'PL', 'KT'),
(250, 'PL', 'KT'),
(251, 'PL', 'KT'),
(252, 'PL', 'KT'),
(253, 'PL', 'KT'),
(86, 'ST', 'KT'),
(254, 'PL', 'KT'),
(255, 'PL', 'KT'),
(156, 'SL', 'KT'),
(157, 'SL', 'KT'),
(158, 'SL', 'KT'),
(159, 'SL', 'KT'),
(256, 'PL', 'KT'),
(257, 'PL', 'KT'),
(258, 'PL', 'KT'),
(87, 'ST', 'KT'),
(1, 'SL', '01');

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_p_vouchers`
--
CREATE TABLE IF NOT EXISTS `v_p_vouchers` (
`comp_id` varchar(2)
,`year_id` varchar(2)
,`voucher_id` varchar(12)
,`voucher_date` date
,`party_id` varchar(7)
,`party_name` varchar(100)
,`lineitem` varchar(11)
,`stock_code` varchar(13)
,`stock_name` varchar(100)
,`rate` decimal(16,5)
,`db_qty` decimal(18,3)
,`db_amt` decimal(18,2)
,`cr_qty` decimal(18,3)
,`cr_amt` decimal(18,2)
);
-- --------------------------------------------------------

--
-- Stand-in structure for view `v_vouchers`
--
CREATE TABLE IF NOT EXISTS `v_vouchers` (
`comp_id` varchar(2)
,`voucher_id` varchar(22)
,`inv_no` binary(0)
,`description` binary(0)
,`voucher_date` datetime
,`lineitem` varchar(6)
,`acct_id` char(10)
,`acct_id_cs_1` char(10)
,`acct_id_cs_2` char(10)
,`debit` decimal(65,30)
,`credit` decimal(65,30)
,`acct_name` char(50)
,`particulars` varchar(200)
,`posted` char(2)
);
-- --------------------------------------------------------

--
-- Table structure for table `web_title`
--

CREATE TABLE IF NOT EXISTS `web_title` (
  `acct_id` int(11) NOT NULL AUTO_INCREMENT,
  `acct_name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `web_title`
--

INSERT INTO `web_title` (`acct_id`, `acct_name`) VALUES
(1, 'Moonlight Industries');

-- --------------------------------------------------------

--
-- Structure for view `v_p_vouchers`
--
DROP TABLE IF EXISTS `v_p_vouchers`;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_p_vouchers` AS select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`)));

-- --------------------------------------------------------

--
-- Structure for view `v_vouchers`
--
DROP TABLE IF EXISTS `v_vouchers`;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_vouchers` AS select `v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`CREDIT` < 0),-(`vd`.`CREDIT`),if((`vd`.`DEBIT` > 0),`vd`.`DEBIT`,0)) AS `debit`,if((`vd`.`DEBIT` < 0),-(`vd`.`DEBIT`),if((`vd`.`CREDIT` > 0),`vd`.`CREDIT`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from (((`voucher` `v` left join `voucherdet` `vd` on((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) left join `nom` `n2` on((`vd`.`ACCT_ID_CS` = `n2`.`ACCT_ID`))) where (`v`.`POSTED` = 'on');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
