DROP TABLE IF EXISTS acct_type;

CREATE TABLE `acct_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `debit_name` varchar(20) DEFAULT NULL,
  `credit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS am_condet;

CREATE TABLE `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS announcement;

CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS app_mod;

CREATE TABLE `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO app_mod VALUES("AC_CP","Cash Payment","Accounts","26","35","","CP");
INSERT INTO app_mod VALUES("AC_BP","Bank Payment","Accounts","26","35","","BP");
INSERT INTO app_mod VALUES("AC_CR","Cash Receipt","Accounts","26","35","","CR");
INSERT INTO app_mod VALUES("AC_BR","Bank Receipt","Accounts","26","35","","BR");
INSERT INTO app_mod VALUES("AC_JV","Journal Voucher","Accounts","35","35","","JV");
INSERT INTO app_mod VALUES("AC_CD","Outstanding Clearing Dates","Accounts","223","0","","");
INSERT INTO app_mod VALUES("PL_PO","Order","Purchases","226","53","t_pl_order","");
INSERT INTO app_mod VALUES("PL_GP","Inward Gate Pass","Purchases","226","235","t_pl_gp","");
INSERT INTO app_mod VALUES("PL_INV","Invoice","Purchases","226","235","t_pl_invoice","");
INSERT INTO app_mod VALUES("PL_PAY","Payments","Purchases","203","204","t_pl_pay","");
INSERT INTO app_mod VALUES("PL_JV","JV","Purchases","216","212","pl_jv","");
INSERT INTO app_mod VALUES("SL_GP","Inward Gate Pass","Sales","226","235","t_sl_gp","");
INSERT INTO app_mod VALUES("SL_INV","Invoice","Sales","226","235","t_sl_invoice","");
INSERT INTO app_mod VALUES("SL_RTN","Return","Sales","226","235","t_sl_return","");
INSERT INTO app_mod VALUES("SL_PAY","Payments","Sales","203","204","t_sl_pay","");
INSERT INTO app_mod VALUES("SL_JV","JV","Sales","216","212","sl_jv","");
INSERT INTO app_mod VALUES("SL_OB","Outstanding Bilties","Sales","221","260","","");
INSERT INTO app_mod VALUES("STK_PROD","Production","Stock","226","53","t_stk_con","Y");
INSERT INTO app_mod VALUES("STK_CON","Consumption","Stock","226","235","t_stk_con","N");
INSERT INTO app_mod VALUES("MF_NOM","Chart of Accounts","Master Files","164","0","","");
INSERT INTO app_mod VALUES("MF_PARTY","Parties","Master Files","66","0","","");
INSERT INTO app_mod VALUES("MF_ITEM","Items","Master Files","64","0","","");
INSERT INTO app_mod VALUES("MF_UNIT","Units","Master Files","106","0","","");
INSERT INTO app_mod VALUES("IM_BOE","Bill of Entry","Imports","226","235","t_im_boe","");


DROP TABLE IF EXISTS app_rep;

CREATE TABLE `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO app_rep VALUES("AC_10","Daybook","Accounts","144","");
INSERT INTO app_rep VALUES("AC_20","Ledger","Accounts","91","");
INSERT INTO app_rep VALUES("AC_31","Trial - Balance","Accounts","163","");
INSERT INTO app_rep VALUES("AC_32","Trial - Control","Accounts","149","");
INSERT INTO app_rep VALUES("AC_33","Trial - Subsidary","Accounts","149","");
INSERT INTO app_rep VALUES("AC_40","Profit & Loss","Accounts","190","");
INSERT INTO app_rep VALUES("AC_50","Profit & Loss (Level 2)","Accounts","191","");
INSERT INTO app_rep VALUES("PL_10","Purchase Daybook","Purchases","187","PL");
INSERT INTO app_rep VALUES("PL_20","Payment Daybook","Purchases","187","PP");
INSERT INTO app_rep VALUES("PL_30","Detail Ledger","Purchases","405","S");
INSERT INTO app_rep VALUES("PL_40","Trial","Purchases","194","S");
INSERT INTO app_rep VALUES("PL_50","Summary","Purchases","188","S");
INSERT INTO app_rep VALUES("SL_10","Sale Daybook","Sales","187","SL");
INSERT INTO app_rep VALUES("SL_20","Sale Receipts","Sales","187","SR");
INSERT INTO app_rep VALUES("SL_30","Detail Ledger","Sales","405","C");
INSERT INTO app_rep VALUES("SL_40","Trial","Sales","194","C");
INSERT INTO app_rep VALUES("SL_50","Summary","Sales","188","C");
INSERT INTO app_rep VALUES("SL_60","Empty Stock Report","Sales","406","");
INSERT INTO app_rep VALUES("SL_70","Empty Stock Report Rate Wise","Sales","407","");
INSERT INTO app_rep VALUES("SL_80","Outstanding Bills","Sales","189","");
INSERT INTO app_rep VALUES("SL_90","SPO Outstanding","Sales","195","");
INSERT INTO app_rep VALUES("STK_10","Ledger","Stocks","401","");
INSERT INTO app_rep VALUES("STK_20","Summary","Stocks","402","");
INSERT INTO app_rep VALUES("STK_30","Summary - Value","Stocks","403","");


DROP TABLE IF EXISTS bill_type;

CREATE TABLE `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO bill_type VALUES("0001","Normal","");
INSERT INTO bill_type VALUES("0002","Exchange","");
INSERT INTO bill_type VALUES("0003","VIP","");
INSERT INTO bill_type VALUES("0004","Sale Return","");


DROP TABLE IF EXISTS brands;

CREATE TABLE `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO brands VALUES("0001","APC");
INSERT INTO brands VALUES("0002","MGE UPS Systems");
INSERT INTO brands VALUES("0003","Stulz Air Conditioning");
INSERT INTO brands VALUES("0004","Bergvik Flooring");
INSERT INTO brands VALUES("0005","APC / MGE UPS Systems");
INSERT INTO brands VALUES("0006","APC / MGE");


DROP TABLE IF EXISTS city;

CREATE TABLE `city` (
  `CITY_ID` varchar(2) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`CITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO city VALUES("10","LAHORE","3801101001");


DROP TABLE IF EXISTS closing_dates;

CREATE TABLE `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL,
  PRIMARY KEY (`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO closing_dates VALUES("BP","2003-12-31 00:00:00");


DROP TABLE IF EXISTS code_cat;

CREATE TABLE `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO code_cat VALUES("00","KURTA");
INSERT INTO code_cat VALUES("01","SHALWAR");
INSERT INTO code_cat VALUES("02","TROUSER");
INSERT INTO code_cat VALUES("03","KHUSSA
\n");
INSERT INTO code_cat VALUES("04","WAIST COAT
\n");
INSERT INTO code_cat VALUES("05","NIGHT SUIT");
INSERT INTO code_cat VALUES("06","FULL SUIT");
INSERT INTO code_cat VALUES("07","COAT");
INSERT INTO code_cat VALUES("08","FOOTWEAR
\n");
INSERT INTO code_cat VALUES("09","SHIRT
\n");
INSERT INTO code_cat VALUES("10","SHERWANI
\n");
INSERT INTO code_cat VALUES("11","TURBON
\n");
INSERT INTO code_cat VALUES("12","SUITING
\n");
INSERT INTO code_cat VALUES("13","CAP");
INSERT INTO code_cat VALUES("14","ACCESSORIES");
INSERT INTO code_cat VALUES("15","SHAWL");


DROP TABLE IF EXISTS code_collection;

CREATE TABLE `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO code_collection VALUES("SK","MEN");
INSERT INTO code_collection VALUES("SG","GOLD");
INSERT INTO code_collection VALUES("SD","DESIGNER
\n");


DROP TABLE IF EXISTS color;

CREATE TABLE `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO color VALUES("PU","PURPLE");
INSERT INTO color VALUES("OW","OFF WHITE");
INSERT INTO color VALUES("BL","BLACK");
INSERT INTO color VALUES("SN","SKIN");
INSERT INTO color VALUES("GO","GOLDEN");
INSERT INTO color VALUES("BR","BROWN");
INSERT INTO color VALUES("MD","MUD");
INSERT INTO color VALUES("SG","SEA GREEN");
INSERT INTO color VALUES("MR","MAROON");
INSERT INTO color VALUES("MV","MOUVE");
INSERT INTO color VALUES("GR","GREEN");
INSERT INTO color VALUES("MU","MUSTARD");
INSERT INTO color VALUES("WH","WHITE");
INSERT INTO color VALUES("GY","GREY");
INSERT INTO color VALUES("DG","DARK GREEN");
INSERT INTO color VALUES("LG","LIGHT GREEN");
INSERT INTO color VALUES("BU","BLUE");
INSERT INTO color VALUES("GB","GREEN BLUE");
INSERT INTO color VALUES("OR","ORANGE");
INSERT INTO color VALUES("PH","PEACH");
INSERT INTO color VALUES("RS","RUST");
INSERT INTO color VALUES("DB","DARK BLUE");
INSERT INTO color VALUES("LY","LIGHT GREY");
INSERT INTO color VALUES("SB","SKY BLUE");
INSERT INTO color VALUES("FN","FORN");
INSERT INTO color VALUES("CB","CHOCOLATE BROWN");
INSERT INTO color VALUES("NB","NAVY BLUE");
INSERT INTO color VALUES("YB","GREY BLACK");
INSERT INTO color VALUES("GS","GREY SHINING");
INSERT INTO color VALUES("FR","FEROOZI");
INSERT INTO color VALUES("RD","RED");
INSERT INTO color VALUES("LR","LIGHT BROWN");
INSERT INTO color VALUES("LB","LIGHT BLUE");
INSERT INTO color VALUES("CM","CAMEL");
INSERT INTO color VALUES("CH","CHOCOLATE");
INSERT INTO color VALUES("BG","BLACK GREY");
INSERT INTO color VALUES("AR","ARMY");
INSERT INTO color VALUES("MT","MULTI COLOUR");


DROP TABLE IF EXISTS company;

CREATE TABLE `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO company VALUES("01","Bath & Kitchen","E-109/3, Main Boulevard, DHA, Lahore,","04236666726 / 04236621112","","","","","","Y","0600030001","","","","","BK","UGX","","","2210000001","3010000001","0700010001","","0100011000","A","401","N","","0600030001","0700020001","0700030001","","");
INSERT INTO company VALUES("02","Perfect Home","E-100/11 Executive Plaza Main Boulevard, DHA, Lahore","0423-7189246-47","","","","","","Y","","","","","","","","","","","","","","","","","","","","","","","");


DROP TABLE IF EXISTS container_size;

CREATE TABLE `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO container_size VALUES("0001","16 Feet");
INSERT INTO container_size VALUES("0002","20 Feet");
INSERT INTO container_size VALUES("0003","22 Feet");
INSERT INTO container_size VALUES("0004","24 Feet");
INSERT INTO container_size VALUES("0005","40 Feet");
INSERT INTO container_size VALUES("0006","50 Feet");


DROP TABLE IF EXISTS currency;

CREATE TABLE `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO currency VALUES("PK","PKR");


DROP TABLE IF EXISTS dc_type;

CREATE TABLE `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO dc_type VALUES("01","Sale");


DROP TABLE IF EXISTS discount;

CREATE TABLE `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS discount_percentage;

CREATE TABLE `discount_percentage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS discount_voucher;

CREATE TABLE `discount_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS division;

CREATE TABLE `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO division VALUES("10","TEXTILE");


DROP TABLE IF EXISTS expense;

CREATE TABLE `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO expense VALUES("01","L/C EXPENSES");


DROP TABLE IF EXISTS fin_years;

CREATE TABLE `fin_years` (
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  PRIMARY KEY (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO fin_years VALUES("17","2017","2017-01-01","2017-06-30");


DROP TABLE IF EXISTS grn;

CREATE TABLE `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grn_return;

CREATE TABLE `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grn_returndet;

CREATE TABLE `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grndet;

CREATE TABLE `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS im_boe;

CREATE TABLE `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS im_boedet;

CREATE TABLE `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS invoice_no;

CREATE TABLE `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO invoice_no VALUES("1","SL","06");
INSERT INTO invoice_no VALUES("2","SL","06");


DROP TABLE IF EXISTS item;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  `brand_id` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`),
  KEY `item_fk_brand_id` (`brand_id`),
  CONSTRAINT `item_fk_brand_id` FOREIGN KEY (`brand_id`) REFERENCES `prod_brand` (`BRAND_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=18529 DEFAULT CHARSET=latin1;

INSERT INTO item VALUES("17160","3450","SINK:SINK H/M 7645","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17161","3451","SINK:SINK H/M 7050","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17162","3452","SINK:SINK H/M 6045","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17163","3453","SINK:SINK H/M 8090","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17164","3454","SINK:SINK H/M 7050 24\'\'","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17165","3455","SINK:SINK H/M 9050","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17166","3456","SINK:SINK OL-320L","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17167","3457","SINK:SINK OL-S8916","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17168","3458","SINK:SINK OL-336","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17169","3459","SINK:SINK OL-H9818","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17170","3460","SINK:SINK OL-330","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17171","3461","SINK:SINK OL-S9916","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17172","3462","SINK:SINK OL-825","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17173","3463","SINK:SINK OL-367","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17174","3464","SINK:SINK OL-205","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17175","3465","SINK:SINK OL-0302","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17176","3466","SINK:SINK OL-8902","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17177","3467","SINK:SINK 9848BL","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17178","3468","SINK:SINK 11650","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17179","3469","SINK:SINK 518","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17180","3470","SINK:SINK 8349","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17181","3471","SINK:SINK 520","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17182","3472","SINK:SINK 7540","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17183","3473","SINK:SINK 8834","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17184","3474","SINK:SINK 6045 S","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17185","3475","SINK:SINK 7843","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17186","3476","SINK:SINK 8343","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17187","3477","SINK:SINK 11550A","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17188","3478","SINK:SINK 8044B","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17189","3479","SINK:SINK 4546","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17190","3480","SINK:SINK 8644","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17191","3481","SINK:SINK 7575","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17192","3482","SINK:SINK 6643T","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17193","3483","SINK:SINK CLARA","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17194","3484","SINK:SINK 1836 TEKA","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17195","3485","SINK:LOCAL GOOL","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17196","3486","SINK:SINK 9848","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17197","3487","SINK:SINK 7243","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17198","3488","SINK:SINK 9546","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17199","3489","SINK:SINK 4835","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17200","3490","SINK:SINK 6045 B","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17201","3491","SINK:SINK 3018","","","","","","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17348","3493","OVEN:MICRO OVEN","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17349","3494","OVEN:MICRO OVEN BH-201025 SS","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17350","3495","OVEN:MICRO OVEN BH-195125 BK","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17351","3496","OVEN:MICRO OVEN BOV-G17 SILVER","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17352","3497","OVEN:MICRO OVEN BOV-G17 BLCK","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17353","3498","OVEN:MICRO OVEN BMO-25E","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17354","3499","OVEN:MICRO OVEN TECNOGUS 23A5-RR","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17355","3500","OVEN:MICRO OVEN BH-97728","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17356","3501","OVEN:OVEN","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17357","3502","OVEN:OVEN OL-10G59E","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17358","3503","OVEN:OVEN F-107 SIX","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17359","3504","OVEN:OVEN BOV-07","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17360","3505","OVEN:OVEN BH-1925 SS","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17361","3506","OVEN:OVEN BM67T2-B1-17","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17362","3507","OVEN:OVEN LAGERMWIA","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17363","3508","OVEN:OVEN 1946 GL","","","","","","","","020017","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17379","3510","HOOD:HOOD","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17380","3511","HOOD:HOOD SIGNATURE 600(209) 24\'\'","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17381","3512","HOOD:HOOD SIGNATURE R209A(900)","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17382","3513","HOOD:HOOD SIGNATURE R210A(900)","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17383","3514","HOOD:HOOD SIGNATURE ST BK-44DC","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17384","3515","HOOD:HOOD SIGNATURE ST BK-44DC 24\'\'","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17385","3516","HOOD:HOOD SIGNATURE 404A- 24\'\'","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17386","3517","HOOD:HOOD SIGNATURE DC 52","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17387","3518","HOOD:HOOD FABER H-803","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17388","3519","HOOD:HOOD CANON HD-U3","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17389","3520","HOOD:HOOD BH-137-28\'\'","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17390","3521","HOOD:HOOD BH-51","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17391","3522","HOOD:HOOD BH-50","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17392","3523","HOOD:HOOD BH-32","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17393","3524","HOOD:HOOD PLT 802","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17394","3525","HOOD:HOOD BH-139","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17395","3526","HOOD:HOOD BH-204","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17396","3527","HOOD:HOOD BH-1360","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17397","3528","HOOD:HOOD BH-1370","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17398","3529","HOOD:CENTER HOOD BH2010","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17399","3530","HOOD:CENTER HOOD BH-2008","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17400","3531","HOOD:CENTER HOOD BH-2005","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17401","3532","HOOD:CENTER HOOD R-KE03","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17402","3533","HOOD:CENTER HOOD C-9010-2","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17403","3534","HOOD:HOOD 36\'\' SB","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17404","3535","HOOD:HOOD 36\'\' SBT","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17405","3536","HOOD:HOOD 36\'\' SS","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17406","3537","HOOD:HOOD 36\'\' CB","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17407","3538","HOOD:HOOD 36\'\' CS","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17408","3539","HOOD:HOOD 36\'\' OS","","","","","","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17410","3541","HOB:HOOB-KITCHEN MASTER 530","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17411","3542","HOB:HOOB-KITCHEN MASTER 560","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17412","3543","HOB:HOOB-KITCHEN MASTER 500","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17413","3544","HOB:HOOB-KITCHEN MASTER ","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17414","3545","HOB:HOOB CA-JW40","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17415","3546","HOB:HOOB CA-C212","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17416","3547","HOB:HOOB CA-8","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17417","3548","HOB:HOOB CA-24","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17418","3549","HOB:HOOB CA-BH945S1","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17419","3550","HOB:HOOB CA-CNBG-5","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17420","3551","HOB:HOOB CA-915G1","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17421","3552","HOB:HOOB CAK-25","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17422","3553","HOB:HOOB BH-04/1B","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17423","3554","HOB:HOOB BH-03/1B","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17424","3555","HOB:HOOB BH-07","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17425","3556","HOB:HOOB BH-11","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17426","3557","HOB:HOOB BH-82","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17427","3558","HOB:HOOB BH-B04","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17428","3559","HOB:HOOB BH-9A","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17429","3560","HOB:HOOB BH-10A","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17430","3561","HOB:HOOB BH-G2","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17431","3562","HOB:HOOB BH-G1","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17432","3563","HOB:HOOB BH-04/3B","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17433","3564","HOB:HOOB BH-S9","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17434","3565","HOB:HOOB BH-S4","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17435","3566","HOB:HOOB BH-68","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17436","3567","HOB:HOOB CH-G1022","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17437","3568","HOB:HOOB CH-G1021","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17438","3569","HOB:HOOB CH-G1013","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17439","3570","HOB:HOOB CH-G1012","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17440","3571","HOB:TAMPESD GLASS STOVER 014","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17441","3572","HOB:TAMPESD GLASS STOVER NEW","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17442","3573","HOB:HOOB 9328-1","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17443","3574","HOB:HOOB HM59056","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17444","3575","HOB:HOOB 016","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17445","3576","HOB:HOOB 018","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17446","3577","HOB:HOOB HM58005","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17447","3578","HOB:HOOB H87-5004G","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17448","3579","HOB:HOOB H87-5002G","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17449","3580","HOB:HOOB Z815","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17450","3581","HOB:HOOB NY-QM 5041","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17451","3582","HOB:HOOB Z-825","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17452","3583","HOB:HOOB HG72-01B","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17453","3584","HOB:HOOB HM-5113","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17454","3585","HOB:HOOB 10T","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17455","3586","HOB:HOOB 4T","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17456","3587","HOB:HOOB 01T","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17457","3588","HOB:HOOB 15T","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17458","3589","HOB:HOOB 13T","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17459","3590","HOB:HOOB 4063","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17460","3591","HOB:HOOB 11GT","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17461","3592","HOB:HOOB 4071","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17462","3593","HOB:HOOB 4026","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17463","3594","HOB:HOOB 4003","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17464","3595","HOB:HOOB 4062","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17465","3596","HOB:HOOB 4025","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17466","3597","HOB:HOOB YMA1","","","","","","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17473","3599","JACUZZI:TUB ITALYA WHITE","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17474","3600","JACUZZI:JACUZZI","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17475","3601","JACUZZI:JACUZZI:27x66 BATH TUB","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17476","3602","JACUZZI:JACUZZI:29x50 ITALIA","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17477","3603","JACUZZI:JACUZZI:9028","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17478","3604","JACUZZI:JACUZZI:A7150B","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17479","3605","JACUZZI:JACUZZI:BATH TUB","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17480","3606","JACUZZI:JACUZZI:BATH TUB OVAL","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17481","3607","JACUZZI:JACUZZI:BATH TUB PINK","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17482","3608","JACUZZI:JACUZZI:BATH TUB SIGMA","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17483","3609","JACUZZI:JACUZZI:GEMY 033","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17484","3610","JACUZZI:JACUZZI:BTG 06","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17485","3611","JACUZZI:JACUZZI:BTG 09","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17486","3612","JACUZZI:JACUZZI:BTG 10","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17487","3613","JACUZZI:JACUZZI:BTG 12","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17488","3614","JACUZZI:JACUZZI:BTG 14","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17489","3615","JACUZZI:JACUZZI:BTG 15","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17490","3616","JACUZZI:JACUZZI:BTG 16","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17491","3617","JACUZZI:JACUZZI:BTG 16 WITHOUT MOTOR","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17492","3618","JACUZZI:JACUZZI:BTG 07","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17493","3619","JACUZZI:JACUZZI:BTG 18","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17494","3620","JACUZZI:JACUZZI:BTG 18 SYSTEM","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17495","3621","JACUZZI:JACUZZI:BTG 20","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17496","3622","JACUZZI:JACUZZI:BTG 21","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17497","3623","JACUZZI:JACUZZI:BTG 22","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17498","3624","JACUZZI:JACUZZI:BTG 24","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17499","3625","JACUZZI:JACUZZI:BTG 26","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17500","3626","JACUZZI:JACUZZI:BTG 27","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17501","3627","JACUZZI:JACUZZI:BTG 30","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17502","3628","JACUZZI:JACUZZI:BTG 31","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17503","3629","JACUZZI:JACUZZI:BTG 33","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17504","3630","JACUZZI:JACUZZI:BTG 41","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17505","3631","JACUZZI:JACUZZI:BTG 43","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17506","3632","JACUZZI:JACUZZI:BTG 44","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17507","3633","JACUZZI:JACUZZI:BTG 47","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17508","3634","JACUZZI:JACUZZI:BTG 49","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17509","3635","JACUZZI:JACUZZI:BTG 51","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17510","3636","JACUZZI:JACUZZI:BTG 53","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17511","3637","JACUZZI:JACUZZI:BTG 56","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17512","3638","JACUZZI:JACUZZI:BTG 57","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17513","3639","JACUZZI:JACUZZI:BTG 64","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17514","3640","JACUZZI:JACUZZI:BTG 65","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17515","3641","JACUZZI:JACUZZI:CINDI WHITE","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17516","3642","JACUZZI:JACUZZI:DIAMOND WHITE","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17517","3643","JACUZZI:JACUZZI:EXTRA PANEL BTG 64","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17518","3644","JACUZZI:JACUZZI:GEMY DAMEGE","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17519","3645","JACUZZI:JACUZZI:GOLD 03","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17520","3646","JACUZZI:JACUZZI:GOLD 04","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17521","3647","JACUZZI:JACUZZI:GOLD 05","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17522","3648","JACUZZI:JACUZZI:GOLD 07","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17523","3649","JACUZZI:JACUZZI:GOLD 09","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17524","3650","JACUZZI:JACUZZI:GOLD 10","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17525","3651","JACUZZI:JACUZZI:GOLD 11","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17526","3652","JACUZZI:JACUZZI:GOLD 13","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17527","3653","JACUZZI:JACUZZI:GOLD 14","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17528","3654","JACUZZI:JACUZZI:GOLD 17","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17529","3655","JACUZZI:JACUZZI:GOLD 18","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17530","3656","JACUZZI:JACUZZI:GOLD 20","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17531","3657","JACUZZI:JACUZZI:GOLD 22","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17532","3658","JACUZZI:JACUZZI:GOLD 24","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17533","3659","JACUZZI:JACUZZI:GOLD 28","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17534","3660","JACUZZI:JACUZZI:GOLD 29","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17535","3661","JACUZZI:JACUZZI:GOLD 30","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17536","3662","JACUZZI:JACUZZI:MOTOR","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17537","3663","JACUZZI:JACUZZI:PANEL","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17538","3664","JACUZZI:JACUZZI:RED","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17539","3665","JACUZZI:JACUZZI:TUB 06","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17540","3666","JACUZZI:JACUZZI:TUB 09","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17541","3667","JACUZZI:JACUZZI:WHITE TUB","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17542","3668","JACUZZI:JACUZZI:YG 18","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17543","3669","JACUZZI:JACUZZI:YG 88","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17544","3670","JACUZZI:JACUZZI:GOLD 43","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17545","3671","JACUZZI:TUB92*62 RED","","","","","","","","010049","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","02");
INSERT INTO item VALUES("17600","3673","VANITY:VANITY 601","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17601","3674","VANITY:VANITY 701","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17602","3675","VANITY:VANITY 801","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17603","3676","VANITY:VANITY 70102","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17604","3677","VANITY:VANITY P-010","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17605","3678","VANITY:VANITY P-053","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17606","3679","VANITY:VANITY CA-538","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17607","3680","VANITY:VANITY CA-70272","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17608","3681","VANITY:VANITY SP5206-1500","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17609","3682","VANITY:VANITY RI-712-120","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17610","3683","VANITY:VANITY 6142","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17611","3684","VANITY:VANITY RI-704-70","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17612","3685","VANITY:VANITY 6140","","","","","","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17615","3686","SLAB:SLAB","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17616","3687","SLAB:SLAB 6149 24\'\' W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17617","3688","SLAB:SLAB 3070-28\'\' W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17618","3689","SLAB:SLAB 3080-32\'\' W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17619","3690","SLAB:SLAB 3090-36\'\' W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17620","3691","SLAB:SLAB 6140 W 24*12","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17621","3692","SLAB:SLAB 3100-40\'\' W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17622","3693","SLAB:SLAB 3120-48\'\' W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17623","3694","SLAB:SLAB SOQEAR 32\'\' 8046 W","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17624","3695","SLAB:SLAB 3090-36\'\' IVORY","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17625","3696","SLAB:SLAB 3100-40\'\' IVORY","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17626","3697","SLAB:BOWAL","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17627","3698","SLAB:BAWOL Y016","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17628","3699","SLAB:BAWOL 004","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17629","3700","SLAB:BAWOL 005","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17630","3701","SLAB:BAWOL U/C 1002","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17631","3702","SLAB:BAWOL U/C RI-019","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17632","3703","SLAB:BAWOL U/C F917","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17633","3704","SLAB:BAWOL U/C AS-206","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17634","3705","SLAB:BAWOL RB -39","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17635","3706","SLAB:BAWOL 068","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17636","3707","SLAB:BAWOL 073","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17637","3708","SLAB:BAWOL 580-A","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17638","3709","SLAB:BAWOL 5514","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17639","3710","SLAB:BAWOL 8619","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17640","3711","SLAB:BAWOL BK-30B","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17641","3712","SLAB:BAWOL BK-40B","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17642","3713","SLAB:BAWOL BK-50B","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17643","3714","SLAB:BAWOL BK-10B","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17644","3715","SLAB:BAWOL LX-306","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17645","3716","SLAB:BAWOL LX-058","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17646","3717","SLAB:BAWOL LX-052","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17647","3718","SLAB:BAWOL LX-055","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17648","3719","SLAB:BAWOL LX-031","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17649","3720","SLAB:BAWOL LX-091","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17650","3721","SLAB:BAWOL LX-057","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17651","3722","SLAB:BAWOL LX-027","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17652","3723","SLAB:BAWOL LX-054","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17653","3724","SLAB:BAWOL VG-713","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17654","3725","SLAB:BAWOL VG-706","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17655","3726","SLAB:BAWOL VG-022","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17656","3727","SLAB:BAWOL VG-664","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17657","3728","SLAB:BAWOL MJ-220","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17658","3729","SLAB:BAWOL MJ-302","","","","","","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17678","3730","COMMODE:COMMODE","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17679","3731","COMMODE:CAMMOD W/H K01","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17680","3732","COMMODE:CAMMOD W/H K03","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17681","3733","COMMODE:CAMMOD W/H K05","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17682","3734","COMMODE:CAMMOD W/H K011","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17683","3735","COMMODE:CAMMOD W/H K012","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17684","3736","COMMODE:CAMMOD W/H 010","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17685","3737","COMMODE:CAMMOD W/H VG 0714","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17686","3738","COMMODE:CAMMOD W/H BM-1203050","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17687","3739","COMMODE:CAMMOD W/H NW-303","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17688","3740","COMMODE:CAMMOD W/H ENG","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17689","3741","COMMODE:CAMMOD W/H RI-210","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17690","3742","COMMODE:CAMMOD 9095/A","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17691","3743","COMMODE:CAMMOD 9008/A","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17692","3744","COMMODE:CAMMOD 014","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17693","3745","COMMODE:CAMMOD VG-854 4\'\'","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17694","3746","COMMODE:CAMMOD VG-855 4\'\'","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17695","3747","COMMODE:CAMMOD VG-858 4\'\'","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17696","3748","COMMODE:CAMMOD VG-840B 4\'\'","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17697","3749","COMMODE:CAMMOD VG-840A 12\'\'","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17698","3750","COMMODE:CAMMOD 2PEC 2339","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17699","3751","COMMODE:CAMMOD LX-5011","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17700","3752","COMMODE:CAMMOD LX-154-5047","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17701","3753","COMMODE:CAMMOD LX-5019","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17702","3754","COMMODE:CAMMOD LX-5051","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17703","3755","COMMODE:CAMMOD LX-367-5027","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17704","3756","COMMODE:CAMMOD LX-5035","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17705","3757","COMMODE:CAMMOD 5054","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17706","3758","COMMODE:CAMMOD MC 2100","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17707","3759","COMMODE:CAMMOD MC 103","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17708","3760","COMMODE:CAMMOD 1205","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17709","3761","COMMODE:CAMMOD PORTA HD-02N","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17710","3762","COMMODE:W/C","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17711","3763","COMMODE:W/C 109","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17712","3764","COMMODE:W/C 10","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17713","3765","COMMODE:W/C 104","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17714","3766","COMMODE:W/C 101","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17715","3767","COMMODE:W/C 103","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17716","3768","COMMODE:W/C 105","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17717","3769","COMMODE:W/C 102","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17718","3770","COMMODE:W/C RLAQ-804","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17719","3771","COMMODE:W/C 608","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17720","3772","COMMODE:W/C 804","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17721","3773","COMMODE:W/C 722","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17722","3774","COMMODE:W/C 218-211","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17723","3775","COMMODE:W/C 0001","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17724","3776","COMMODE:URINAL","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17725","3777","COMMODE:URINAL RI 8925","","","","","","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("17741","3778","SHWER SET SONEX","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17742","3779","SHWERSET 4091/4093","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17743","3780","SSHWER SET 3111/3113","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17744","3781","SHWER SET 3141/3143","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17745","3782","SHWER SET 3151/3153","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17746","3783","SHWER SET 3131/3133","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17747","3784","SHWER SET 3171/3173","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17748","3785","SHWER SET 4051/4053","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17749","3786","SHWER SET 4061/4063","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17750","3787","SHWER SET 4071/4073","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17751","3788","SHWER SET 4081/4083","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17752","3789","SHWER SET 112/111","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17753","3790","SHWER SET 251/252","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17754","3791","SHWER SET 317/318","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17755","3792","SHWER SET 320/322","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17756","3793","SHWER SET 381/383","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17757","3794","SHWER SET 491/493","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17758","3795","SHWER SET 641/643","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17759","3796","SHWER SET 991/993","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17760","3797","RAIN SHWER","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17761","3798","RAIN SHWER 524","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17762","3799","RAIN SHWER 520","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17763","3800","T-ARM","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17764","3801","BATH MIXER SONEX","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17765","3802","BATH MIXER 3151","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17766","3803","BATH MIXER 4071","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17767","3804","BATH MIXER 661-C","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17768","3805","BATH MIXER 991","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17769","3806","BATH MIXER 441","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17770","3807","BATH MIXER 6031","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17771","3808","BATH MIXER 751","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17772","3809","BATH MIXER 3131","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17773","3810","BATH MIXER 691","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17774","3811","BASAIN MIXER SONEX","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17775","3812","BASIN MIXER 644","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17776","3813","BASIN MIXER 4093","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17777","3814","BASIN MIXER 4011","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17778","3815","BASIN MIXER 4073","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17779","3816","BASIN MIXER 673","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17780","3817","BASIN MIXER 4053","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17781","3818","BASIN MIXER 5073","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17782","3819","BASIN MIXER 633","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17783","3820","BASIN MIXER 623","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17784","3821","SINK MIXER SONEX","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17785","3822","SINK MIXER 316","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17786","3823","SINK MIXER 909","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17787","3824","SINK MIXER 907","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17788","3825","T-COCK","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17789","3826","MUSLIM SHWER SONEX","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17790","3827","JUTT SHWER 532","","","","","","","","020014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17791","3828","JUTT SHWER 518","","","","","","","","020014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","03");
INSERT INTO item VALUES("17792","3829","SHAWER SET GROHE","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17793","3830","SHAWER SET TENSO","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17794","3831","SHAWER SET CONCETO","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17795","3832","SHAWER SET LINEAR","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17796","3833","SHAWER SET STYLE CASMO","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17797","3834","SHAWER SET SAMRT CASMO","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17798","3835","SHAWER SET SMART","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17799","3836","SHAWER SET ECO","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17800","3837","SHAWER SET DIS CASMO","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17801","3838","SHAWER SET CUBE","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17802","3839","SHAWER SET ESSENCE","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17803","3840","SHAWER SET BLOOP","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17804","3841","SHAWER SET BAU EDGE","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17805","3842","BAHT MIXER GROHE","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17806","3843","BAHT MIXER EURO DISCASMO 33390002","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17807","3844","BAHT MIXER EURO SMARTCASMO 32831000","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17808","3845","BAHT MIXER BOULOOP 32815000","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17809","3846","BAHT MIXER BAU EDGE 32820000","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17810","3847","BAHT MIXER  EURO SAMRT 33344441","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17811","3848","BAHT MIXER EURO STYLE CASMO 33591002","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17812","3849","BASIN MIXER GROHE","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17813","3850","BASAIN MIXER BAUOEG","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17814","3851","BASAIN MIXER BOULOOP 32814000","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17815","3852","BASAIN MIXER EUROSTYL CASMO 33552002","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17816","3853","BASAIN MIXER CUBE","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17817","3854","BASAIN MIXER LINEAR","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17818","3855","BASAIN MIXER CONCETTO","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17819","3856","SINK MIXER EURO SMART 32482001","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17820","3857","SPOUT GROHE 13255000","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17821","3858","SPOUT GROHE 13252000","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17822","3859","T-COCK 220170000M","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17823","3860","SALDING RAD GROHE","","","","","","","","010113","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17824","3861","SALDING RAD 27368000","","","","","","","","010113","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17825","3862","SALDING RAD 28436","","","","","","","","010113","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17826","3863","SALDING RAD ","","","","","","","","010113","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17827","3864","HAND SHWER GROHE 27673000","","","","","","","","010042","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17828","3865","HAND SHWER GROHE 27675000","","","","","","","","010042","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17829","3866","MUSLIM SHWER GROHE","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17830","3867","MUSLIM SHWER GROHE MEAT 27812000","0.000","","","0.00","0","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17831","3868","MUSLIM SHWER GROHE WHITE","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17832","3869","RAIN SHWER EURO PLUS 124","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17833","3870","DAIL PLET GROHE ORGNAL","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17834","3871","DAIL PLET N.A EURO CUBE 19898000","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17835","3872","DAIL PLET N.A ESSENCE 19286000","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17836","3873","DAIL PLET EURO DISC 19549001","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17837","3874","DAIL PLET AUTO BAULOOP 29041000","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17838","3875","DAIL PLET N.A CHIARA 19156000","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17839","3876","DAIL PLET N.A EURO STYLE","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17840","3877","DAIL PLET DISC NAN AUTO GROHE","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17841","3878","DAIL PLET LINEAR NAN AUTO GROHE","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17842","3879","DAIL PLET CHIRA NAN AUTO GROHE","","","","","","","","020019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("17843","3880","GROHE BAHT MIXER CHI EURODISCOSMO","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17844","3881","GROHE BAHT MIXER CHI EURODISC","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17845","3882","GROHE BAHT MIXER CHI QUDERA","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17846","3883","GROHE BAHT MIXER CHI SMRT CASMO","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17847","3884","GROHE BAHT MIXER CHI EURO STYLE","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17848","3885","GROHE BAHT MIXER CHI SMRT ","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17849","3886","BASIN MIXER EURO DISC","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17850","3887","BASIN MIXER EURO SAMRT","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17851","3888","BASIN MIXER EURO SAMRT CASMO","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17852","3889","BASIN MIXER EURO DISC CASMO","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17853","3890","BASIN MIXER CUBE","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17854","3891","BASIN MIXER EURO STYEL","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17855","3892","BASIN MIXER CONCETTO","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17856","3893","BASIN MIXER QUADERA CHI","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17857","3894","SINK MIXER CHI ","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17858","3895","MUSLIM SHWER GROHE CHI","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17859","3896","MUSLIM SHWER MATT","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17860","3897","MUSLIM SHWER CP","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17861","3898","MUSLIM SHWER MATT ONLY HEAD","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17862","3899","MUSLIM SHWER ONLY HEAD","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17863","3900","HAND SHWER TEMPESTE","","","","","","","","010042","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17864","3901","AUTO BODY 33963000","","","","","","","","010114","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17865","3902","NON AUTO BODY ","","","","","","","","010114","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17866","3903","SLIDING ROD EUPHORIA","","","","","","","","010085","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17867","3904","SLIDING ROD XOXO","","","","","","","","010085","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17868","3905","DAIL PLET EURO SMART GROHE CHI","","","","","","","","010024","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","05");
INSERT INTO item VALUES("17869","3906","CLASSIC SET OCTION","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17870","3907","CLASSIC SET CANON","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17871","3908","SWANA SET","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17872","3909","PROPHET SET","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17873","3910","DOWAL SET","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17874","3911","CAPRICON SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17875","3912","SAHRA SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17876","3913","RADO-B SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17877","3914","BOLON SET CLASSIC","3.000","","","0.00","0","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17878","3915","JAZZ SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17879","3916","KAMAN SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17880","3917","NAYLON SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17881","3918","REMAX SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17882","3919","VECTRON SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17883","3920","DHOL SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17884","3921","KATER SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17885","3922","VICTORION SET CLASSIC","","","","","","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17886","3923","KASHMIR SINK MIXER  CLASSIC","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17887","3924","DELTA SINK MIXER CLASSIC","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17888","3925","KAMEO SINK MIXER CLASSIC","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17889","3926","OCEAN SINK MIXER CLASSIC","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17890","3927","BOLON SINK MIXER CLASSIC","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17891","3928","VANITY BAWOL MIXER CLASSIC","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17892","3929","DELTA BASIN MIXER CLASSIC","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17893","3930","RIVER BASIN MIXER CLASSIC","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17894","3931","VIGO BASIN MIXER CLASSIC","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17895","3932","NEW LEVER BASIN MIXER ","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17896","3933","COMMON BASIN MIXER ","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17897","3934","PROPHET LEVER BATH MIXER","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17898","3935","SINKAM BATH MIXER ","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17899","3936","RIVER KULLI BATH MIXER","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17900","3937","RIVER SOQEAR BATH MIXER","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17901","3938","COMMON BATH MIXER ","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17902","3939","T-COCK REVER ","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17903","3940","T-COCK PLUS","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17904","3941","T-COCK VIGO","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17905","3942","D-BIB COCK RIVER","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17906","3943","D-BIB COCK PLUS","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17907","3944","MUSLIM SHWER CLASSIC","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","06");
INSERT INTO item VALUES("17996","3945","PUSH WAIST S&C","","","","","","","","010068","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("17997","3946","PUSH WAIST USA","","","","","","","","010068","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("17998","3947","PUSH WAIST 4\'\'","","","","","","","","010068","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("17999","3948","PUSH WAIST 6\'\'","","","","","","","","010068","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18000","3949","PUSH WAIST 8\'\'","","","","","","","","010068","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18001","3950","BOTLE TRAP WWT","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18002","3951","BOTLE TRAP GROHE","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18003","3952","BOTLE TRAP SOQEUAR","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18004","3953","BOTLE TRAP JAGUAR","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18005","3954","BOTLE TRAP HAJVERY 12\'\'","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18006","3955","BOTLE TRAP USA","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18007","3956","BOTLE TRAP PURO","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18008","3957","BOTLE TRAP PIPE","","","","","","","","010010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18009","3958","SPOUT WWT","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18010","3959","SPOUT LEVER A-GROHE","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18011","3960","SPOUT JAGUAR","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18012","3961","SPOUT SOQEAR A-G","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18013","3962","SPOUT RAOUND A-G","","","","","","","","020018","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18014","3963","BIB COCK STYLISH","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18015","3964","BIB COCK JAGUAR","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18016","3965","BIB COCK MILLI","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18017","3966","BIB COCK 3/4","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18018","3967","BIB COCK NOZAL","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18019","3968","D-BIB COCK MALAYSIA","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18020","3969","D-BIB COCK JAGUAR","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18021","3970","D-BIB COCK CHI","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18022","3971","D-BIB COCK WWT","","","","","","","","010115","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18023","3972","T-COCK SQUARE GOLDEN CHI","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18024","3973","T-COCK SQUARE CHI","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18025","3974","T-COCK JAGUAR","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18026","3975","T-COCK GROHE CHI","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18027","3976","T-COCK WHIT 2384","","","","","","","","020016","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18028","3977","U-BEND","","","","","","","","010105","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18029","3978","MUSLIM SHOWER CHI","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18030","3979","MUSLIM SHOWER MALISHA","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18031","3980","MUSLIM SHOWER KROM GROHE CHI","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18032","3981","MUSLIM SHOWER WHIT  LOCKAL","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18033","3982","MUSLIM SHWER FORTE ONLY HEAD","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18034","3983","MUSLIM SHOWER BUTTEN","","","","","","","","010057","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18035","3984","HAND SHWER 065","","","","","","","","010042","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18036","3985","HAND SHWER 067","","","","","","","","010042","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18037","3986","FLOOR WAIST KABZA ","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18038","3987","FLOOR WAIST PUSH","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18039","3988","FLOOR WAIST PACHO ","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18040","3989","FLOOR WAIST PLAN NEW","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18041","3990","FLOOR WAIST HAVY PLAN ","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18042","3991","FLOOR WAIST CENTER HOLE ","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18043","3992","FLOOR WAIST HEAVY SHAIN","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18044","3993","FLOOR WAIST HEAVY MATT","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18045","3994","FLOOR WAIST 4*4","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18046","3995","SINK WAST 1 1/2","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18047","3996","BASIN WAST SS","","","","","","","","010030","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18048","3997","RAIN SHOWER SQUARE 16*16","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18049","3998","RAIN SHOWER ROUND 16*16","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18050","3999","RAIN SHOWER ROUND 16*16 SLIM","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18051","4000","RAIN SHOWER SOQEAR 16*16 SLIM","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18052","4001","RAIN SHOWER BRASS 8*8","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18053","4002","RAIN SHOWER SQUARE 8*8","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18054","4003","RAIN SHOWER SLIM 8*8","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18055","4004","RAIN SHOWER SLIM 12*12","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18056","4005","RAIN SHOWER ROUND 12*12","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18057","4006","RAIN SHOWER SQUARE 12*12","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18058","4007","RAIN SHOWER SQUARE 24*24","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18059","4008","RAIN SHOWER SQUARE 24*24 SLIM","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18060","4009","RAIN SHOWER RAWOND 20*20","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18061","4010","RAIN SHOWER SQUARE 20*20","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18062","4011","RAIN SHOWER SQUARE 20*20 SLIM","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18063","4012","RAIN SHWER CB-5518","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18064","4013","RAIN SHWER 516","","","","","","","","010072","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18065","4014","CONNECTOR PIPE","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18066","4015","MUSLIM SHWER CHAIN PIPE","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18067","4016","MUSLIM SHWER SPRING PIPE","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18068","4017","CONNECTOR PIPE 1 1/2 FT","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18069","4018","CONACTION PIPE 2FIT","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18070","4019","CONACTION PIPE 3FIT","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18071","4020","BASIN MIXER PIPE","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18072","4021","WAST PIPE CROM","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18073","4022","WAST PIPE PVC 1 1/2","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18074","4023","WAST PIPE SS","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18075","4024","HOCKY PIPE SS","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18076","4025","WAST PIPE PVC ","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18077","4026","HAND SHWER PIPE","","","","","","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18078","4027","MANIFIVE MIRREOR","","","","","","","","010056","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18079","4028","MANIFIVE MIRREOR LED","","","","","","","","010056","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18080","4029","THIMBLE WHITE","","","","","","","","010099","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18081","4030","THIMBLE BLACK","","","","","","","","010099","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18082","4031","THIMBLE GREES","","","","","","","","010099","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18083","4032","THIMBLE GREES JEL","","","","","","","","010099","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18084","4033","BOLT KIT CAMMOD W/H","","","","","","","","010099","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18085","4034","CP NOZAL 1\'\'","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18086","4035","CP NOZAL 2\'\'","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18087","4036","CP NOZAL 1 1/2\'\'","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18088","4037","CP NOZAL 3\'\'","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18089","4038","CP NOZAL 4\'\'","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18090","4039","CP NOZAL 6\'\'","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18091","4040","CP NEUT","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18092","4041","BEORING NIPPEL","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18093","4042","CAMMOD KIT W/H","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18094","4043","BOLT KIT BASIN","","","","","","","","010019","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18095","4044","TAFLAN TAPE","","","","","","","","010091","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18096","4045","RACK 123 CYJ","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18097","4046","RACK CONER  SS A013","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18098","4047","RACK 1005","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18099","4048","RACK 006 BK","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18100","4049","RACK A57 CONER","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18101","4050","ALUMINIUM SHELF 03","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18102","4051","ALUMINIUM SHELF 02","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18103","4052","ROSE PETAL SS","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18104","4053","TAWEL RACK D-21","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18105","4054","RACK USA","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18106","4055","RACK WESDA","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18107","4056","SINGAL CONER RACK","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18108","4057","RACK BK58","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18109","4058","RACK A160","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18110","4059","RACK B1106","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18111","4060","RACK B1103","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18112","4061","RACK B1104","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18113","4062","RACK 904","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18114","4063","RACK 698/737","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18115","4064","TAWEL RAD SS","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18116","4065","D-TAWEL RAD 7612","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18117","4066","D-TAWEL RAD 50D","","","","","","","","010071","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18118","4067","T-ARM 18\'\' WWT","","","","","","","","020015","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18119","4068","T-ARM 24\'\' JAGUER","","","","","","","","020015","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18120","4069","T-ARM 18\'\' JAGUER","","","","","","","","020015","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18121","4070","ARM 12\'\' WWT","","","","","","","","020015","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18122","4071","ARM 15\'\' WWT","","","","","","","","020015","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18123","4072","ARM 18\'\' WWT","","","","","","","","020015","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18124","4073","BASIN MIXER KM-2111 GOLD","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18125","4074","BASIN MIXER KM-2111 CP","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18126","4075","BASIN MIXER 501-B","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18127","4076","BASIN MIXER 9745","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18128","4077","BASIN MIXER 5084-WHITE","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18129","4078","BASIN MIXER 8276","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18130","4079","BASIN MIXER 8277","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18131","4080","BASIN MIXER 1137","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18132","4081","BASIN MIXER 0205 SK","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18133","4082","BASIN MIXER 0106 SK","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18134","4083","BASIN MIXER CA-1","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18135","4084","BASIN MIXER 2080","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18136","4085","BASIN MIXER 2090","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18137","4086","BASIN MIXER 1805","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18138","4087","BASIN MIXER CC3","","","","","","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18139","4088","SINK MIXER 8317","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18140","4089","SINK MIXER 16157","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18141","4090","SINK MIXER 1060 SK","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18142","4091","SINK MIXER 1002","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18143","4092","SINK MIXER 8319","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18144","4093","WALL MOUNTED MIXER","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18145","4094","SINK MIXER 7809","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18146","4095","SINK MIXER LT-0099","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18147","4096","SAPPRING SINK MIXER A/G","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18148","4097","SINK MIXER M30","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18149","4098","SINK MIXER 7109","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18150","4099","SINK MIXER 7113","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18151","4100","SINK MIXER CC1","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18152","4101","SINK MIXER CC2","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18153","4102","SINK MIXER 0179","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18154","4103","SINK MIXER 0178","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18155","4104","BATH MIXER CHI ","","","","","","","","010008","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18156","4105","SINK MIXER OULIN CS9605","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18157","4106","SINK MIXER 1734","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18158","4107","SINK MIXER W/H 013-1","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18159","4108","SINK MIXER W/H 6010","","","","","","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18160","4109","SHWER SET MALYSIA 9802","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18161","4110","SHWER SET MALYSIA 9819","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18162","4111","SHWER SET MALYSIA 9818","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18163","4112","SHWER SET MALYSIA 9722","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18164","4113","SHWER SET MALYSIA 9720","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18165","4114","SHWER SET MALYSIA 624","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18166","4115","SHWER SET MALYSIA 625","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18167","4116","SHWER SET MALYSIA 626","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18168","4117","SHWER SET MALYSIA 9723","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18169","4118","SHWER SET GOLDEN UNCOMPLET","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18170","4119","SHWER SET CTO CP","","","","","","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18171","4120","SOOP DISPANSER SS","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18172","4121","SOOP DISPANSER ","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18173","4122","SOOP DISPANSER GOOL","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18174","4123","SOOP DISPANSER SOQEAR","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18175","4124","SOOP DISPANSER A57 ","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18176","4125","KRB SOOP DISPANSER","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18177","4126","SOOP DISPANSER PVC SMAL","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18178","4127","SOOP DISPANSER A013","","","","","","","","010087","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18179","4128","HOOK 8205 SS","","","","","","","","010044","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18180","4129","HOOK 8105 SS","","","","","","","","010044","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18181","4130","HOOK 3011 SS","","","","","","","","010044","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18182","4131","HOOK FLOWER BIG","","","","","","","","010044","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18183","4132","HOOK 8045 SS","","","","","","","","010044","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18184","4133","GREY BAR","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18185","4134","HAND DARYER LIGHT","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18186","4135","HAND DARYER 010840","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18187","4136","HAND DARYER 9712154","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18188","4137","TANK SAGA CO13","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18189","4138","TANK SAGA CO12","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18190","4139","TANK VEGA 80009","","","","","","","","010116","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18191","4140","SET COVER ROUND WHIT","","","","","","","","010076","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18192","4141","SET COVER ROUND IVORY","","","","","","","","010076","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18193","4142","SET COVER SQUORE WHIT","","","","","","","","010076","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18194","4143","OIL HETER","","","","","","","","010076","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18195","4144","VAKUM CALENER","","","","","","","","010076","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","07");
INSERT INTO item VALUES("18251","4145","ACCESSORY SET  GOLD 1900 ","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18252","4146","ACCESSORY SET S&C SOQEAR","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18253","4147","ACCESSORY SET KOTO GOLDEN 8001","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18254","4148","ACCESSORY SET POMA TRAND","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18255","4149","ACCESSORY SET SOLO TRAND","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18256","4150","ACCESSORY SET DIMAND","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18257","4151","ACCESSORY SET CUBE","","","","","","","","020001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18258","4152","BRUSH HOLDER 304","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18259","4153","TAWER RING 304","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18260","4154","TAWER RAD 304","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18261","4155","PAPER HOLDER 304","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18262","4156","SOOP DISH 304","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18263","4157","SOOP DISH GALA","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18264","4158","BRUSH HOLDER GALA","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18265","4159","PAPER HOLDER GALA","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18266","4160","TAWER RING GALA","","","","","","","","010118","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18267","4161","TAWEL RAD SOQEAR S&C","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18268","4162","TAWEL RING SOQEAR S&C","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18269","4163","PAPER HOLDER SOQEAR S&C","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18270","4164","BURSH HOLDER SOQEAR S&C","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18271","4165","TAWEL RAD G CHI","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("18272","4166","TAWEL RING G CHI","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("18273","4167","PAPER HOLDER G CHI","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("18274","4168","SOAP DISH G CHI","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("18275","4169","BURSH HOLDER G CHI","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("18276","4170","COAT HOOK G CHI","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","04");
INSERT INTO item VALUES("18277","4171","TABLE SET KROM","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18278","4172","TABLE SET WHITE","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18279","4173","ACCESSORY SET TRAND VENAS","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18280","4174","ACCESSORY SET ACITKA","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18281","4175","ACCESSORY SET 23600","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18282","4176","ACCESSORY SET TRAND QUEN","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18283","4177","ACCESSORY SET 304 H","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18284","4178","PAPER HOLDER BK-03","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18285","4179","TABLE SET WHITE 2 PEC SOOP DISH OR BURSH HOLDER","0.000","","","0.00","0","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18286","4180","TABLE SET BLACK","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18287","4181","TABLE SET SKY BLUE","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18288","4182","TABLE SET GRAY","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18289","4183","TABLE SET GREEN LIGHT","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18290","4184","TABLE SET RED","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18291","4185","SOAP DISH MATT","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18292","4186","GLASS MATT","","","","","","","","020020","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18293","4187","TOWEL RING JAGUAR","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","08");
INSERT INTO item VALUES("18294","4188","SOAP DISH JAGUOR","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","08");
INSERT INTO item VALUES("18295","4189","BURSH HOLDER JAGUOR","","","","","","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","08");
INSERT INTO item VALUES("18296","4190","SOAP DISH SS","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18297","4191","SOAP DISH SS B1009","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18298","4192","SOAP DISH SS B1008","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18299","4193","SOAP DISH SS B100","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18300","4194","SOAP DISH SS B103","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18301","4195","SOAP DISH SS 786","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18302","4196","SOAP DISH SS 1005","","","","","","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18303","4197","PAPER HOLDER 151","","","","","","","","010065","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18304","4198","ACCESSORY SET 304","","","","","","","","010117","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18305","4199","BAWOL U/C CHI","1.000","","","4500.00","0","","","010084","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18306","4200","HOB:HOOB 5/B","1.000","","","1300.00","0","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18307","4201","HOB:HOOB 3/B","1.000","","","6500.00","0","","","020004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18308","4202","HOB:HOOB 1/B","0.000","","","0.00","0","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18309","4203","SINK 6043","0.000","","","0.00","0","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18310","4204","SINK 6035","0.000","","","0.00","0","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18311","4205","BE-15-101-01T-8X12 SB","1.000","","","45.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18312","4206","VANITY: 7 SHAP","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18313","4207","SOOP PLATE ONLY","0.000","","","0.00","0","","","010086","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18314","4208","VANITY:3112 44\'\' S/T","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18315","4209","VANITY:3112 48\'\'","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18316","4210","VANITY: SLOP 36\'\'","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18317","4211","VANITY:GOLL 40\'\'","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18318","4212","VANITY:24\'\' WT","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18319","4213","COMMODE:CAMMOD W/H VG 015","0.000","","","0.00","0","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18320","4214","DIVIDER:331","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18321","4215","SAIDE CABNAT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18322","4216","LONG PIPE","0.000","","","0.00","0","","","010066","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18323","4217","TUB MIXER EURO SMART","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18324","4218","VANITY PILER WHITE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18325","4219","COMMODE WALL HUNG","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18326","4220","VANITY: COSMTIC SHAP S.S","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18327","4221","TANK+PLATE GROHE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18328","4222","THIMBLE SET","0.000","","","0.00","0","","","010097","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18329","4223","SHOWER SET 741-743 SONIX","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18330","4224","T END PVC","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18331","4225","LAMINATED WOOD FLOOR MAT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18334","","","0.000","","","0.00","0","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18335","","","0.000","","","0.00","0","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18338","4226","JUMBOLON ROLL","0.000","","","0.00","0","","","030001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18339","4227","BASIN MIXER 5093 SONIX","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18340","4228","BASIN MIXER 3173","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18341","4229","SKIRTING","0.000","","","0.00","0","","","030001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18342","4230","REDUCER PVC","0.000","","","0.00","0","","","030001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18343","4231","SHOWER PANAL SN-36","0.000","","","0.00","0","","","010078","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18344","4232","SHOWER SET 4011-4013","0.000","","","0.00","0","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18345","4233","BASIN MIXER 3141","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18346","4234","SHOWER HEAD 523","0.000","","","0.00","0","","","010042","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18347","4235","WALLPAPER","1.000","","","0.00","0","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18348","4236","VANITY:VANITY 36\'\' S/T","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18349","4237","VANITY:PELER 14\'\'","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18350","4238","VANITY:PVC 36\'\' S.T","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18351","4239","VANITY:PVC 48\'\' WT","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18354","4241","COMMODE W/H 2606","0.000","","","0.00","0","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18355","4242","SONEX FLUSH TANK WHITE","0.000","","","0.00","0","","","010031","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18356","4243","D-BIB COCK SONIX 355","0.000","","","0.00","0","","","020002","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18357","4244","BASIN MIXER 423 SONIX","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18358","4245","SIX PIECES SET CP 2381-C","0.000","","","0.00","0","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18359","4246","SHOWER WALL 4091 CP","0.000","","","0.00","0","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18360","4247","SINK BOWL 8149","0.000","","","0.00","0","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18361","4248","SINK 5043","0.000","","","0.00","0","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18362","4249","SINK 8544","0.000","","","0.00","0","","","020010","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18363","4250","LODER UONIT PTI 022","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18364","4251","HOOB F-1","0.000","","","0.00","0","","","020005","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18365","4252","UNDER CONTER HD3","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18366","4253","UNDER CONTER HD18","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18367","4254","SLAB:BAWOL 053","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18368","4255","SLAB:BAWOL 6332","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18369","4256","VANITY PVC PELER 18\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18370","4257","VANITY 18X24","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18371","4258","VANITY U PVC","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18372","4259","MIRROR U LED","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18373","4260","MIRROR 36\'\' LED","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18374","4261","SHOWER SET 2807","0.000","","","0.00","0","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18375","4262","BASIN MIXER 2083","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18376","4263","BATH SET CP VENUS 2807","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18377","4264","BASIN HD 18","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18378","4265","SLAB:BAWOL HD 3","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18379","4266","VANITY: SINGL TAPER 47\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18380","4267","VANITY: DUBAL TAPER 46\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18381","4268","VANITY: NEW 44\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18382","4269","VANITY: SMALL 14X18","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18383","4270","SHOWER SET 761-927","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18384","4271","BASIN MIXER 927","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18385","4272","SHOWER SET 981-983","0.000","","","0.00","0","","","010080","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18386","4273","SINK BOWL 650","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18387","4274","SINK MIXER 941","0.000","","","0.00","0","","","020013","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18388","4275","BASIN MIXER 384","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18389","4276","BASIN MIXER 383","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18390","4277","BASIN MIXER 2805","0.000","","","0.00","0","","","010004","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18391","4278","VANITY: PVC 14X24","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18392","4279","UNDER CONTER 005","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18393","4280","TANK GROHE WITHE BOTTAN","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18394","4281","HOOD:HOOD BH-503","0.000","","","0.00","0","","","020006","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18395","4282","ACCESSORY SET  GROHE","0.000","","","0.00","0","","","010119","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18396","4283","COMMODE:CAMMOD W/H RI-205","0.000","","","0.00","0","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18397","4284","SINK MIXER 7110 SPPRING SMALL","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18398","4285","HAND SHOWER CHI","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18399","4286","DORI","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18400","4287","SHEET WOOD 4X8","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18401","4288","VANITY: 3100 40\' PVC","0.000","","","0.00","0","","","010110","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18402","4289","VANITY STAND PVC 16\'\'X18\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18403","4290","SINK MIXER 905 CP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18404","4291","TANK HD 2T","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18405","4292","BASIN HD 19","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18406","4293","BASIN STAND SMALL","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18407","4294","BLIND","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18408","4295","ROLLER BLIND","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18409","4296","COMMODE:CAMMOD LX-5015","0.000","","","0.00","0","","","010014","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18410","4297","SLAB:BAWOL 014 WHITE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18411","4298","SLAB:BAWOL LX-120","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18412","4299","BASIN PDASTIL LX-3500 B","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18415","4301","BASIN PDASTIL LX-3600","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18416","4302","QAWATER NEUT 1/2","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18417","4303","BIB COCK 415","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18418","4304","ABLUTION MIXER 333 SONIX","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18419","4305","ACCESSORY SET  3104","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18420","4306","T-COCK 220160000","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18421","4307","HANDAL","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18422","4308","BIK P-11 KITCHEN","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18423","4309","SHOWER SET CP FAISAL VENUS","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18424","4310","SLAB:BAWOL 6028 W","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18425","4311","T-COCK 2294 GROHE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18426","4312","T-COCK 2202500 GROHE 1/2","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18427","4313","SWANA SET NON BATH MIXER","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18428","4314","WIGO SET CLASSIC RAIN SHOWER 12X12","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18429","4315","2 D CLASSIC SET","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18430","4316","AIR FRISHNER","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18431","4317","MIRROR 18X24","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18432","4318","MIRROR 24X32","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18433","4319","ESPA PUMP 0.8 HP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18434","4320","JACUZZI:JACUZZI: ITALYA 03 54X51","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18435","4321","SHOWER SET SMART GROHE CHI","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18436","4322","COMMODE A/S 2086","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18437","4323","CONACTION PIPE 4FIT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18438","4324","CONACTION PIPE 1FIT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18439","4325","DAIL PLET AUTO SMART GROHE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18440","4326","COMMODE:CAMMOD W/H 733 lexta","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18441","4327","SET COVER 2006 IVORY","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18442","4328","UNDER CONTER L X 136","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18443","4329","SHOWER RAD 4FT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18444","4330","MOZAIQ SHEET S.S","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18445","4331","SHOWER SET 981-983 W/OUT 510 + 507","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18446","4332","DAIL PLET AUTO QUADERA","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18447","4333","DAIL PLET NON AUTO QUADERA","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18448","4334","SINK BOWL","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18449","4335","SHOWER PANAL CP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18450","4336","TANK LOCAL WHITE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18451","4337","BATH MIXER 761 CP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18452","4338","TOWEL RING 23600","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18453","4339","D-CORNER RACK","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18454","4340","BASIN MIXER 6013","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18455","4341","UPER CUNTER","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18456","4342","VANITY PVC 6FT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18457","4343","T END MDF","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18458","4344","VANITY PVC 16X24 W/MIRROR","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18459","4345","CP NOZZEL 1/2 X 3/4","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18460","4346","ART BOWEL:037","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18461","4347","VANITY PVC 5FT W/MIRROR TUCH","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18462","4348","VANITY PVC 4FT W/MIRROR TUCH","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18463","4349","VANITY PVC 18X24 W/MIRROR TUCH","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18464","4350","SINK MIXER 217","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18465","4351","HAND SHOWER 515 CP SONEX","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18466","4352","ACCESSORY SET JAGUAR","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18467","4353","RAIN SHOWER 897","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18468","4354","HAND SHOWER 517 CP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18469","4355","ART BOWEL:LEXTA 128","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18470","4356","ART BOWEL:2497","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18471","4357","ART BOWEL:1035","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18472","4358","GARD BAR 304","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18473","4359","SET COVER 5015 W","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18474","4360","BASIN MIXER 5007","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18475","4361","VANITY  W/MIRROR 36\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18476","4362","VANITY PILER WITH MIRROR","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18477","4363","SINK MIXER 901","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18478","4364","SET COVER 2055 W","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18479","4365","BATH MIXER 4091 WITH RAIN SHOWER 8X8","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18480","4366","BATH MIXER SMART GROHE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18481","4367","T COCK 1/2 X 3/8 GROHE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18482","4368","GLASS BOWL","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18483","4369","SINK MIXER CCA2 CHI","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18484","4370","VANITY 40\'\' NEW DESIGN","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18485","4371","SINK MIXER 411 SONEX","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18486","4372","SINK COCK 414 CP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18487","4373","BASIN MIXER 4013 CP","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18488","4374","BASIN MIXER DAIZY 173 SONIX","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18489","4375","CONCELED BODY W/BODY 81","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18490","4376","CONCELED BODY W/BODY 72","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18491","4377","CP NEUT 1/2 1/4","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18493","4378","DAIL PLET AUTO SMART COSMO","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18494","4379","BASIN MIXER BAU EDGE LONG","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18495","4380","SPOUT JAGUAR 13255","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18496","4381","JACUZZI:JACUZZI:GOLD 36","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18497","4382","MIRROR 3 1 1/2X66","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18498","4383","MIRROR 36X45 1/2","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18499","4384","MIRROR 34X53 1/2","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18500","4385","MIRROR 40X42","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18501","4386","MIRROR 30X36","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18502","4387","COMMODE 222 12\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18503","4388","VANITY PVC W/MIRROR NEW W/MIXER","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18504","4389","RACK S/S STAT","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18507","4390","BATH MIXER,TARM,RAIN SHOWER 4X4 3131","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18508","4391","SINK MIXER FAYSEL","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18509","4392","SINK BOWL 18X36","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18510","4393","BATH TUB 42X42","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18511","4394","JAMBO LON","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18512","4395","MIRROR 2\'\'X6\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18513","4396","VANITY 32\'\'","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18514","4397","VANITY 12X14","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18515","4398","JACUZZI:JACUZZI:29X63","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18516","4399","COMMODE 5023 WHITE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18517","4400","SINK MIXER LONG 927-L","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18518","4401","MIRROR 36x30","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18519","4402","VANITY:PVC 48\'\' ST","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18520","4403","MIRROR TUCH 30X48","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18521","4404","SINK BOWL DOUBLE","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18522","4405","SPRING MIXER LONG GRY","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18523","4406","MUSLIM SHOWER RAVI","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18524","4407","COMMODE W/H 2605","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18525","4408","COMMODE MARJAN","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18526","4409","COMMODE AROOBA","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18527","4410","SINK MIXER 7107","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");
INSERT INTO item VALUES("18528","4411","BIB COCK 1/2","0.000","","","0.00","0","","","990001","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","");


DROP TABLE IF EXISTS item_description;

CREATE TABLE `item_description` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS location;

CREATE TABLE `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO location VALUES("01","Main Store","245/1/1 Tufail Road, Lahore, Cantt.","Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com","03-00-2974-683-13","2974683-3","245/1/1 Tufail Road, Lahore.","","","on","on");
INSERT INTO location VALUES("02","Store","","","","","","","","","on");
INSERT INTO location VALUES("03","Display Center","","","","","","","","","on");


DROP TABLE IF EXISTS locations;

CREATE TABLE `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO locations VALUES("01","Main Store");


DROP TABLE IF EXISTS lots;

CREATE TABLE `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS menu;

CREATE TABLE `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO menu VALUES("1","Sale","");
INSERT INTO menu VALUES("1.1","Invoice","show_sale_invoice?voucher_type=SL&posted=\'\'");
INSERT INTO menu VALUES("1.2","Order","show_sale_invoice?voucher_type=SO&posted=\'\'");
INSERT INTO menu VALUES("1.3","Sale Delivery Challan","show_sale_invoice?voucher_type=DC&posted=\'\'");
INSERT INTO menu VALUES("1.4","Outword Gate pass","show_sale_invoice?voucher_type=OG&posted=\'\'");
INSERT INTO menu VALUES("1.5","Receipts","show_payments?voucher_type=SR&posted=\'\'");
INSERT INTO menu VALUES("1.6","Journal","show_pay_jv?voucher_type=SJ&posted=\'\'");
INSERT INTO menu VALUES("1.7","Sale Invoice","sl_inv?voucher_type=SL");
INSERT INTO menu VALUES("2","Purchase","");
INSERT INTO menu VALUES("2.1","Invoice","show_sale_invoice?voucher_type=PL&posted=\'\'");
INSERT INTO menu VALUES("2.2","Order","show_sale_invoice?voucher_type=PO&posted=\'\'");
INSERT INTO menu VALUES("2.3","Inward Gate pass","show_sale_invoice?voucher_type=IG&posted=\'\'");
INSERT INTO menu VALUES("2.4","Payments","show_payments?voucher_type=PP&posted=\'\'");
INSERT INTO menu VALUES("2.5","Journal","show_pay_jv?voucher_type=PJ&posted=\'\'");
INSERT INTO menu VALUES("3","Accounts","");
INSERT INTO menu VALUES("3.1","Payments","");
INSERT INTO menu VALUES("4","Stock","");
INSERT INTO menu VALUES("4.1","Production","show_production?voucher_type=FG&posted=\'\'");
INSERT INTO menu VALUES("4.2","Consumption","");
INSERT INTO menu VALUES("5","Master File","");
INSERT INTO menu VALUES("5.1","Items","items");
INSERT INTO menu VALUES("5.2","Chart Of Accounts","chart_of_accounts");
INSERT INTO menu VALUES("6","Reports Summary","");
INSERT INTO menu VALUES("6.1","Sale Summary","rpt_sale_summary?stock_summary=SL");
INSERT INTO menu VALUES("6.2","Stock Summary","rpt_sale_summary?stock_summary=FG");
INSERT INTO menu VALUES("6.3","Outword Gate pass Summary","rpt_sale_summary?stock_summary=OG");
INSERT INTO menu VALUES("6.4","Sale Order Summary","rpt_sale_summary?stock_summary=SO");
INSERT INTO menu VALUES("6.5","Purchase Summary","rpt_sale_summary?stock_summary=PL");
INSERT INTO menu VALUES("6.6","Purchase Order Summary","rpt_sale_summary?stock_summary=PO");
INSERT INTO menu VALUES("6.7","Purchase InwordGatepass Summary","rpt_sale_summary?stock_summary=IG");
INSERT INTO menu VALUES("7","Reports Detail","");
INSERT INTO menu VALUES("7.1","Sale Report","rpt_sale?detail=SL");
INSERT INTO menu VALUES("7.2","Sale Order","rpt_sale?detail=SO");
INSERT INTO menu VALUES("7.3","Outword Gatepass","rpt_sale?detail=OG");
INSERT INTO menu VALUES("7.4","WareHouse Stock","rpt_sale?detail=FG");
INSERT INTO menu VALUES("7.5","Purchase Invoice","rpt_sale?detail=PL");
INSERT INTO menu VALUES("7.6","Inword Gatepass","rpt_sale?detail=IG");
INSERT INTO menu VALUES("7.7","Stock Ledger","stock_ledger");
INSERT INTO menu VALUES("8","Reports Accounts","");
INSERT INTO menu VALUES("8.1","Ledgers","ledger");
INSERT INTO menu VALUES("8.2","Day Book","daybook");
INSERT INTO menu VALUES("9","Reports","");
INSERT INTO menu VALUES("9.1","Sale Report","rpt_sale");
INSERT INTO menu VALUES("9.2","Gatepass Outword Report","rpt_gpout");
INSERT INTO menu VALUES("9.3","Current Stock","rpt_current_stock");


DROP TABLE IF EXISTS ms_sale;

CREATE TABLE `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS nom;

CREATE TABLE `nom` (
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_NAME` char(50) NOT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `ACCT_TYPE` varchar(4) DEFAULT NULL,
  `FS_TYPE` varchar(1) DEFAULT NULL,
  `SUB` varchar(1) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `TEST_NAME` char(50) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO nom VALUES("01","CAPITAL & LIABILITIES","","0","","","click","","01","","");
INSERT INTO nom VALUES("010001","PAID UP CAPITAL","","3101","","","","","01","","");
INSERT INTO nom VALUES("0100010001","OPENING BALANCES","","","","","","","02","","");
INSERT INTO nom VALUES("010002","DRAWINGS","","","","","","","01","","");
INSERT INTO nom VALUES("0100020001","Happy Malik Sb","","","","","","","01","","");
INSERT INTO nom VALUES("0100020002","Waseem Sb","","","","","","","01","","");
INSERT INTO nom VALUES("0100020003","MOHSIN SB","","","","","","","01","","");
INSERT INTO nom VALUES("0100020004","FAROOQ SB","","","","","","","01","","");
INSERT INTO nom VALUES("0100020005","SHEIKH SALEEM","","","","","","","01","","");
INSERT INTO nom VALUES("0100020006","KHALID SB","","","","","","","01","","");
INSERT INTO nom VALUES("0100020007","NADEEM SB","","","","","","","01","","");
INSERT INTO nom VALUES("0100020008","SAJED SB","","","","","","","02","","");
INSERT INTO nom VALUES("0100020009","HASEEB WALPAPER","","","","","","","02","","");
INSERT INTO nom VALUES("0100020010","TAMOUR SB SHOW ROOM PERFACT HOME","","","","","","","02","","");
INSERT INTO nom VALUES("010003","Investments","","","","","","","01","","");
INSERT INTO nom VALUES("0100030001","Investment Account","","","","","","","01","","");
INSERT INTO nom VALUES("13","CREDITORS & OTHER PAYABLES","","0","","","click","","01","","");
INSERT INTO nom VALUES("131000","TRADE CREDITORS CONTROL A/C","","2802","","","","","01","","");
INSERT INTO nom VALUES("1310000001","Ashfaq Sons","","","","","","","01","","");
INSERT INTO nom VALUES("1310000002","Porta Acrylic Bath Tubs Lahore","","","","","","","01","","");
INSERT INTO nom VALUES("1310000003","TREND BATHROOM ACCESSORIES","","","","","","","01","","");
INSERT INTO nom VALUES("1310000004","URBAN CERAMICS","","","","","","","01","","");
INSERT INTO nom VALUES("1310000005","SABAAN","","","","","","","01","","");
INSERT INTO nom VALUES("1310000006","MAGOON TRADERS","","","","","","","01","","");
INSERT INTO nom VALUES("1310000007","MASTER","","","","","","","01","","");
INSERT INTO nom VALUES("1310000008","DIAMOND","","","","","","","01","","");
INSERT INTO nom VALUES("1310000009","A","","","","","","","01","","");
INSERT INTO nom VALUES("1310000010","STYLE BATH WARE","","","","","","","01","","");
INSERT INTO nom VALUES("1310000011","AL-HARMAIN PAINT CENTRE","","","","","","","01","","");
INSERT INTO nom VALUES("1310000012","SYMBOL INDUSTRIES (PVT) LTD","","","","","","","01","","");
INSERT INTO nom VALUES("1310000013","VEGA","","","","","","","01","","");
INSERT INTO nom VALUES("1310000014","JAVAID","","","","","","","01","","");
INSERT INTO nom VALUES("1310000015","MAHMOOD GUJRANWALA","","","","","","","01","","");
INSERT INTO nom VALUES("1310000017","GOROHE","","","","","","","01","","");
INSERT INTO nom VALUES("1310000018","KBS","","","","","","","01","","");
INSERT INTO nom VALUES("1310000019","SKY SANITORY","","","","","","","01","","");
INSERT INTO nom VALUES("1310000020","MIDAS","","","","","","","01","","");
INSERT INTO nom VALUES("1310000021","USAMA PRINTING","","","","","","","01","","");
INSERT INTO nom VALUES("1310000022","ALLAH WASAYA","","","","","","","01","","");
INSERT INTO nom VALUES("1310000023","RAVI TRADERS","","","","","","","01","","");
INSERT INTO nom VALUES("1310000024","SAMAAR SKIRTING","","","","","","","01","","");
INSERT INTO nom VALUES("1310000025","MIAN FAKHAR","","","","","","","01","","");
INSERT INTO nom VALUES("1310000026","USMAN","","","","","","","01","","");
INSERT INTO nom VALUES("1310000027","IMC","","","","","","","02","","");
INSERT INTO nom VALUES("1310000028","MAHMOOD SONS","","","","","","","02","","");
INSERT INTO nom VALUES("1310000029","KBS","","","","","","","02","","");
INSERT INTO nom VALUES("1310000030","MUHAMMADI STORE","","","","","","","02","","");
INSERT INTO nom VALUES("1310000031","ILYAS/SONS","","","","","","","02","","");
INSERT INTO nom VALUES("1310000032","WASEEM BROTHERS","","","","","","","02","","");
INSERT INTO nom VALUES("1310000033","BASRA BROTHERS","","","","","","","02","","");
INSERT INTO nom VALUES("1310000034","VIZDOM","","","","","","","02","","");
INSERT INTO nom VALUES("1310000035","SILLA CONCEPT\'S","","","","","","","02","","");
INSERT INTO nom VALUES("1310000036","CANON","","","","","","","01","","");
INSERT INTO nom VALUES("1310000037","AMJAD GUJRANWALA","","","","","","","01","","");
INSERT INTO nom VALUES("1310000038","GODI COMMODE","","","","","","","01","","");
INSERT INTO nom VALUES("1310000039","NATURE","","","","","","","01","","");
INSERT INTO nom VALUES("1310000040","ANSARI PLASTIC","","","","","","","02","","");
INSERT INTO nom VALUES("1310000041","ASIAN STANDERED","","","","","","","02","","");
INSERT INTO nom VALUES("1310000042","LEXTA","","","","","","","02","","");
INSERT INTO nom VALUES("1310000043","SHEN CHINEESE","","","","","","","02","","");
INSERT INTO nom VALUES("1310000044","MARACHI","","","","","","","01","","");
INSERT INTO nom VALUES("1310000045","INTERIO FLOORS","","","","","","","02","","");
INSERT INTO nom VALUES("1310000046","BEST HOME","","","","","","","01","","");
INSERT INTO nom VALUES("1310000047","BUTT TRADER","","","","","","","02","","");
INSERT INTO nom VALUES("19","EXPENSED PAYABLE AND ACCRUED","","","","","","","01","","");
INSERT INTO nom VALUES("191000","SALARIES PAYABLE","","","","","","","01","","");
INSERT INTO nom VALUES("1910000001","SALARY PAYABLE SHAHID SHEIKH","","","","","","","01","","");
INSERT INTO nom VALUES("1910000002","SALARY PAYABLE Sarosh Ch","","","","","","","01","","");
INSERT INTO nom VALUES("1910000003","SALARY PAYABLE Rashid","","","","","","","01","","");
INSERT INTO nom VALUES("1910000004","SALARY PAYABLE Salman SB","","","","","","","01","","");
INSERT INTO nom VALUES("1910000005","SALARY PAYABLE Hafiz Azeem","","","","","","","01","","");
INSERT INTO nom VALUES("1910000006","SALARY PAYABLE Yaseen","","","","","","","01","","");
INSERT INTO nom VALUES("1910000007","SALARY PAYABLE Awias","","","","","","","01","","");
INSERT INTO nom VALUES("1910000008","SALARY PAYABLE Bilawal","","","","","","","01","","");
INSERT INTO nom VALUES("1910000009","SALARY PAYABLE Atif","","","","","","","01","","");
INSERT INTO nom VALUES("1910000010","SALARY PAYABLE Mubashar","","","","","","","01","","");
INSERT INTO nom VALUES("1910000011","SALARY PAYABLE Driver happy sb","","","","","","","01","","");
INSERT INTO nom VALUES("1910000012","SALARY PAYABLE Driver waseem sb","","","","","","","01","","");
INSERT INTO nom VALUES("1910000013","SALARY PAYABLE Faisal Zia","","","","","","","01","","");
INSERT INTO nom VALUES("1910000014","SALARY PAYABLE Hameed","","","","","","","01","","");
INSERT INTO nom VALUES("1910000015","SALARY PAYABLE IBRAR","","","","","","","01","","");
INSERT INTO nom VALUES("1910000016","SALARY PAYABLE Arslan Paint","","","","","","","01","","");
INSERT INTO nom VALUES("1910000017","SALARY PAYABLE Ashraf Paint","","","","","","","01","","");
INSERT INTO nom VALUES("1910000018","SALARY PAYABLE Naveed paINT","","","","","","","01","","");
INSERT INTO nom VALUES("1910000019","SALARY PAYABLE FATEH MUHAMMAD","","","","","","","01","","");
INSERT INTO nom VALUES("1910000020","SALARY PAYABLE GULAM DESTAGIR","","","","","","","01","","");
INSERT INTO nom VALUES("1910000021","SALARY PAYABLE QUEEM","","","","","","","01","","");
INSERT INTO nom VALUES("1910000022","SALARY PAYABLE DILAWER","","","","","","","01","","");
INSERT INTO nom VALUES("1910000023","SALARY PAYABLE HADIR MIRROR","","","","","","","01","","");
INSERT INTO nom VALUES("1910000024","SALARY PAYABLE NADEEM","","","","","","","01","","");
INSERT INTO nom VALUES("1910000025","SALARY PAYABLE AHMAD MIRROR","","","","","","","01","","");
INSERT INTO nom VALUES("1910000026","SALARY PAYABLE TO USMAN TBC","","","","","","","01","","");
INSERT INTO nom VALUES("1910000027","SALARY PAYABLE NASIR","","","","","","","02","","");
INSERT INTO nom VALUES("1910000028","SALARY PAYABLE MURTAZA","","","","","","","02","","");
INSERT INTO nom VALUES("1910000029","SALARY PAYABLE TAYYAB","","","","","","","02","","");
INSERT INTO nom VALUES("1910000030","SALARY PAYABLE BABAR","","","","","","","02","","");
INSERT INTO nom VALUES("1910000031","SALARY PAYABLE WAQAS","","","","","","","01","","");
INSERT INTO nom VALUES("1910000032","SALARY PAYABLE JAMEEL","","","","","","","02","","");
INSERT INTO nom VALUES("1910000033","SALARY PAYABLE TANVEER","","","","","","","02","","");
INSERT INTO nom VALUES("1910000034","SALARY PAYABLE WALEED","","","","","","","02","","");
INSERT INTO nom VALUES("1910000035","SALARY PAYABLE AMJAD","","","","","","","02","","");
INSERT INTO nom VALUES("1910000036","SALARY PAYABLE AMMAR","","","","","","","01","","");
INSERT INTO nom VALUES("192000","Commission Payable","","","","","","","01","","");
INSERT INTO nom VALUES("1920000001","Commission Payable Sarosh","","","","","","","01","","");
INSERT INTO nom VALUES("1920000002","COMMISSION TO SHAHID SB","","","","","","","01","","");
INSERT INTO nom VALUES("1920000003","Commission Payable RASHID","","","","","","","01","","");
INSERT INTO nom VALUES("1920000004","Commission Payable WAQAR","","","","","","","01","","");
INSERT INTO nom VALUES("1920000005","Commission Payable WALEED","","","","","","","01","","");
INSERT INTO nom VALUES("1920000006","Commission Payable YASEEN","","","","","","","01","","");
INSERT INTO nom VALUES("1920000007","Commission Payable SALMAN sb","","","","","","","01","","");
INSERT INTO nom VALUES("20","ASSETS","","0","","","click","","01","","");
INSERT INTO nom VALUES("201000","FIXED ASSETS","","1101","","","","","01","","");
INSERT INTO nom VALUES("201500","Loans & Advances","","1901","","","","","01","","");
INSERT INTO nom VALUES("202000","VEHICLES","","1901","","","","","01","","");
INSERT INTO nom VALUES("22","STOCKS","","0","","","click","","01","","");
INSERT INTO nom VALUES("221000","STOCKS IN TRADE","","1903","","","","","01","","");
INSERT INTO nom VALUES("2210000001","Stock In Trade","","","","","","","01","","");
INSERT INTO nom VALUES("26","SUNDRY DEBTORS","","0","","","click","","01","","");
INSERT INTO nom VALUES("261000","TRADE DEBTORS CONTROL A/C","","1902","","","","","01","","");
INSERT INTO nom VALUES("2610000001","Walk-In-Customers","","","","","","","01","","");
INSERT INTO nom VALUES("2610000003","Gourmet","","1902","","","","","","","");
INSERT INTO nom VALUES("2610000027","SAYYAD BROTHER","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000028","KASHIF SB 245/G PHS# 5 DHA","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000029","MURTZA CUSTMER","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000030","200/1-B ST-NO #1 PHASE-5 DHA","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000031","36-D LAWRENCE ROAD LHR 03034291889","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000032","AHMAD SB","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000033","OLYMPIA BUILDERS","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000034","H-NO. 923/D PHS 6 DHA LHR","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000035","MR. ANEES SB 0321-4185133","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000036","904/K PHS#6 DHA 03228470847","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000037","547/D 0322454045","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000038","MALL OF SIALKOT","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000039","DISPLAY","","1902","","","","","02","","");
INSERT INTO nom VALUES("2610000040","SHOAIB KHAN SB","","","","","","","02","","");
INSERT INTO nom VALUES("2610000041","NADEEM SB CUSTOMER","","","","","","","02","","");
INSERT INTO nom VALUES("2610000042","CERAMICS","","","","","","","02","","");
INSERT INTO nom VALUES("2610000043","HOME TECH","","","","","","","02","","");
INSERT INTO nom VALUES("2610000044","KHALID SB ASKRI 10","","","","","","","02","","");
INSERT INTO nom VALUES("2610000045","347/Y PHS# 3","","","","","","","02","","");
INSERT INTO nom VALUES("2610000046","QAYUM SB DHA","","","","","","","02","","");
INSERT INTO nom VALUES("2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","","","","","","","02","","");
INSERT INTO nom VALUES("2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","","","","","","","02","","");
INSERT INTO nom VALUES("2610000049","HAJI HAKM SB 73 / C PH# 6","","","","","","","02","","");
INSERT INTO nom VALUES("2610000050","B PLAZA NADEEM KHAN","","","","","","","02","","");
INSERT INTO nom VALUES("2610000051","125/E DHA PHS#6 03429693431","","","","","","","02","","");
INSERT INTO nom VALUES("2610000052","DR. ASIM SB 03214864288","","","","","","","02","","");
INSERT INTO nom VALUES("2610000053","69/G MODAL TWON","","","","","","","02","","");
INSERT INTO nom VALUES("2610000054","228/B STAT LIFE","","","","","","","02","","");
INSERT INTO nom VALUES("2610000056","242/L PH# 5 DHA  MR.UMAR","","","","","","","02","","");
INSERT INTO nom VALUES("2610000057","ABDULLAH SB PH# 6 839/D DHA","","","","","","","02","","");
INSERT INTO nom VALUES("2610000058","AFTAB SB","","","","","","","02","","");
INSERT INTO nom VALUES("2610000059","H-NO 254-DD PHS# 4 03218487965","","","","","","","02","","");
INSERT INTO nom VALUES("2610000060","246/E-1 WAPDA TWON PHAS# 1","","","","","","","02","","");
INSERT INTO nom VALUES("2610000061","UMER KHALID SB 54/C PHAS# 5 DHA","","","","","","","02","","");
INSERT INTO nom VALUES("2610000062","H-NO 862/B PH# 5 DHA","","","","","","","02","","");
INSERT INTO nom VALUES("2610000063","H-NO 1070/N PH# 6 BUTT SB","","","","","","","02","","");
INSERT INTO nom VALUES("2610000064","PESHWAR MALL","","","","","","","02","","");
INSERT INTO nom VALUES("2610000065","H-NO 25/E 35210478","","","","","","","02","","");
INSERT INTO nom VALUES("2610000066","398/B PH# 5 DHA KASHIF SB","","","","","","","02","","");
INSERT INTO nom VALUES("2610000067","KHAZIR SB SOI GAS SUCITY","","","","","","","02","","");
INSERT INTO nom VALUES("2610000068","FAZAN SB 03339678883","","","","","","","02","","");
INSERT INTO nom VALUES("2610000069","69/9-J-3 JOHAR TWON LHR","","","","","","","02","","");
INSERT INTO nom VALUES("2610000070","102/CC PHS# 4 DHA SULTAN SB","","","","","","","02","","");
INSERT INTO nom VALUES("2610000071","FAROOQ SB 147/E DHA","","","","","","","02","","");
INSERT INTO nom VALUES("262000","Other Debtors","","","","","","","02","","");
INSERT INTO nom VALUES("2620000001","Bath & Kitchen","","","","","","","02","","");
INSERT INTO nom VALUES("2620000002","Perfect Homes","","","","","","","02","","");
INSERT INTO nom VALUES("263000","Other Receivables","","","","","","","02","","");
INSERT INTO nom VALUES("2630000001","Cash Reconciliation","","","","","","","02","","");
INSERT INTO nom VALUES("27","CASH & BANK BALANCES","","0","","","click","","01","","");
INSERT INTO nom VALUES("271000","CASH","","1999","","","","","01","","");
INSERT INTO nom VALUES("2710000001","Cash In Hand","","","","","","","01","","");
INSERT INTO nom VALUES("272000","BANK BALANCES","","1999","","","","","01","","");
INSERT INTO nom VALUES("2720000001","HABIB BANK","","","","","","","01","","");
INSERT INTO nom VALUES("2720000002","Bank Alfalah","","","","","","","02","","");
INSERT INTO nom VALUES("2720000003","CLEARING CHARGES","","","","","","","01","","");
INSERT INTO nom VALUES("30","REVENUE","","0","","","click","","01","","");
INSERT INTO nom VALUES("301000","SALES","","4101","","","","","01","","");
INSERT INTO nom VALUES("3010000001","Turnover","","","","","","","01","","");
INSERT INTO nom VALUES("3010000010","Discount Allowed","","","","","","","01","","");
INSERT INTO nom VALUES("3010000020","Sale Returns","","","","","","","02","","");
INSERT INTO nom VALUES("302000","COST OF SALES","","5101","","","","","01","","");
INSERT INTO nom VALUES("3020000001","Purchase Cost","","","","","","","01","","");
INSERT INTO nom VALUES("35","STAFF LOAN AND ADVANCES","","","","","","","01","","");
INSERT INTO nom VALUES("351000","STAFF LOAN","","","","","","","01","","");
INSERT INTO nom VALUES("3510000001","STAFF LOAN SAROSH","","","","","","","01","","");
INSERT INTO nom VALUES("3510000002","STAFF LOAN YASEEN","","","","","","","01","","");
INSERT INTO nom VALUES("3510000003","STAFF LOAN SALMAN","","","","","","","01","","");
INSERT INTO nom VALUES("3510000004","STAFF LOAN IBRAR","","","","","","","01","","");
INSERT INTO nom VALUES("3510000005","STAFF LOAN MOBASHER","","","","","","","01","","");
INSERT INTO nom VALUES("3510000006","STAFF LOAN WAQAR","","","","","","","01","","");
INSERT INTO nom VALUES("3510000007","STAFF LOAN WALEED","","","","","","","01","","");
INSERT INTO nom VALUES("3510000008","STAFF LOAN Hafiz Azeem","","","","","","","01","","");
INSERT INTO nom VALUES("3510000009","STAFF LOAN GULAM DESTAGIR","","","","","","","01","","");
INSERT INTO nom VALUES("3510000010","STAFF LOAN QUEEM","","","","","","","01","","");
INSERT INTO nom VALUES("3510000011","STAFF LOAN Ashraf Paint","","","","","","","01","","");
INSERT INTO nom VALUES("3510000012","STAFF LOAN Atif","","","","","","","01","","");
INSERT INTO nom VALUES("3510000013","STAFF LOAN Shahid Sheikh","","","","","","","01","","");
INSERT INTO nom VALUES("3510000014","STAFF LOAN Rashid","","","","","","","01","","");
INSERT INTO nom VALUES("3510000015","STAFF LOAN Awias","","","","","","","01","","");
INSERT INTO nom VALUES("40","ADMINISTRATIVE EXPENSES","","0","","","click","","01","","");
INSERT INTO nom VALUES("401000","SHOP EXPENSES","","6101","","","","","01","","");
INSERT INTO nom VALUES("4010000001","ENTERTAINMENT EXPENSES","","","","","","","01","","");
INSERT INTO nom VALUES("4010000002","PAINT EXPENSES","","","","","","","01","","");
INSERT INTO nom VALUES("4010000003","OTHER EXPENSES","","","","","","","01","","");
INSERT INTO nom VALUES("4010000004","Travelling Expenses","","","","","","","01","","");
INSERT INTO nom VALUES("4010000005","PARTY","","","","","","","01","","");
INSERT INTO nom VALUES("4010000006","Fuel Expenses","","","","","","","01","","");
INSERT INTO nom VALUES("4010000007","Stationary Expenses","","","","","","","01","","");
INSERT INTO nom VALUES("4010000008","Utility BILL","","","","","","","01","","");
INSERT INTO nom VALUES("4010000009","CHARITY PAID","","","","","","","01","","");
INSERT INTO nom VALUES("4010000010","LABOUR PAYABLE","","","","","","","01","","");
INSERT INTO nom VALUES("402000","DOMESTIC EXPENSES","","6101","","","","","01","","");
INSERT INTO nom VALUES("403000","SALARIES AND BENEFITS","","","","","","","01","","");
INSERT INTO nom VALUES("4030000001","STAFF SALARIES","","","","","","","01","","");
INSERT INTO nom VALUES("50","SELLING EXPENCES","","0","","","click","","01","","");
INSERT INTO nom VALUES("501000","FREIGHT ON SALE","","6201","","","","","01","","");
INSERT INTO nom VALUES("60","INCOME","","8101","","","","","01","","");
INSERT INTO nom VALUES("601000","Other Income","","8101","","","","","01","","");


DROP TABLE IF EXISTS nom_copy;

CREATE TABLE `nom_copy` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT 'HO'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO nom_copy VALUES("01","CAPITAL & LIABILITIES","0","","","HO");


DROP TABLE IF EXISTS nom_lc;

CREATE TABLE `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS nom_old;

CREATE TABLE `nom_old` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '01',
  PRIMARY KEY (`comp_id`,`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO nom_old VALUES("01","Expenses","0","","","01");
INSERT INTO nom_old VALUES("010001","DIRECT EXPENSES","31","","5","01");
INSERT INTO nom_old VALUES("0100010001","COST OF GOOD SOLD","","","","01");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","31","","61","01");
INSERT INTO nom_old VALUES("0100020001","ENTERTAINMENT EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020002","TRAVELLING EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020003","STATIONARY","","","","01");
INSERT INTO nom_old VALUES("0100020004","ADVERTISEMENT EXP","","","","01");
INSERT INTO nom_old VALUES("0100020005","GROCERY EXP","","","","01");
INSERT INTO nom_old VALUES("0100020006","OFFICE EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020007","REPAIR AND MAINTAINANCE
\n","","","","01");
INSERT INTO nom_old VALUES("0100020008","RENT WAREHOUSE","","","","01");
INSERT INTO nom_old VALUES("0100020009","FLAGSHIP OUTLET EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020010","KARIM BLOCK OUTLET EXPENSES","","","","01");
INSERT INTO nom_old VALUES("010003","OPENING BALANCES","","","","01");
INSERT INTO nom_old VALUES("0100030001","OPENING BALANCES","","","","01");
INSERT INTO nom_old VALUES("010010","STAFF SALARIES","","","","01");
INSERT INTO nom_old VALUES("0100100001","STAFF SALARIES","","","","01");
INSERT INTO nom_old VALUES("02","EQUITY","","","","01");
INSERT INTO nom_old VALUES("020001","PROPRITERS CAPITAL","","","","01");
INSERT INTO nom_old VALUES("0200010001","PROPRITERS CAPITAL","","","","01");
INSERT INTO nom_old VALUES("0200010002","OPENING BALANCE ADJUSTMENT ACOOUNT","","","","01");
INSERT INTO nom_old VALUES("03","Short Term Liabilites","","","","01");
INSERT INTO nom_old VALUES("030007","Accrued Salaries","","","","01");
INSERT INTO nom_old VALUES("0300070001","SALARY PAYABLE KAMRAN","","","","01");
INSERT INTO nom_old VALUES("0300070002","SALARY PAYABLE - NADISH","","","","01");
INSERT INTO nom_old VALUES("0300070003","SALARY PAYABLE - KHURRAM","","","","01");
INSERT INTO nom_old VALUES("0300070004","SALARY PAYABLE - JAVED","","","","01");
INSERT INTO nom_old VALUES("0300070005","SALARY PAYABLE - FAROOQ","","","","01");
INSERT INTO nom_old VALUES("0300070006","SALARY PAYABLE - SHUJA BAHI (TAX ADVISOR)","","","","01");
INSERT INTO nom_old VALUES("0300070007","SALARY PAYABLE - VICTOR","","","","01");
INSERT INTO nom_old VALUES("0300070008","SALARY PAYABLE - MOHSIN","","","","01");
INSERT INTO nom_old VALUES("0300070009","SALARY PAYABLE - FAISAL","","","","01");
INSERT INTO nom_old VALUES("0300070010","SALARY PAYABLE - TALAH","","","","01");
INSERT INTO nom_old VALUES("0300070011","SALARY PAYABLE - SIKANDAR","","","","01");
INSERT INTO nom_old VALUES("0300070012","SALARY PAYABLE - SONIL","","","","01");
INSERT INTO nom_old VALUES("0300070013","SALARY PAYABLE - ALI RAZA","","","","01");
INSERT INTO nom_old VALUES("10","LIABILITIES","","","","01");
INSERT INTO nom_old VALUES("100001","VENDOR FINISHED GOODS","","","","01");
INSERT INTO nom_old VALUES("1000010001","VENDOR SHOES - KASHIF PAYABLE","","","","01");
INSERT INTO nom_old VALUES("1000010002","MR MAJEED (KURTA)","","","","01");
INSERT INTO nom_old VALUES("1000010003","MR TAHIR (WAIST COAT)","","","","01");
INSERT INTO nom_old VALUES("1000010004","MR ARIF (EMBROIDARY)","","","","01");
INSERT INTO nom_old VALUES("1000010005","MR MUSHTAQ (HSY)","","","","01");
INSERT INTO nom_old VALUES("1000010006","HUMD INTERNATIONAL PVT LTD","","","","01");
INSERT INTO nom_old VALUES("100002","VENDOR RAW MATERIAL","","","","01");
INSERT INTO nom_old VALUES("1000020001","HAMZA AKHTAR","","","","01");
INSERT INTO nom_old VALUES("1000020002","HAJI KHAN","","","","01");
INSERT INTO nom_old VALUES("1000020003","WAZIR AHMED","","","","01");
INSERT INTO nom_old VALUES("1000020004","ZAKIR","","","","01");
INSERT INTO nom_old VALUES("1000020005","LONDON","","","","01");
INSERT INTO nom_old VALUES("1000020006","DARWESH KHAN","","","","01");
INSERT INTO nom_old VALUES("1000020007","AL-REHMAT","","","","01");
INSERT INTO nom_old VALUES("1000020008","SHADMAN","","","","01");
INSERT INTO nom_old VALUES("20","STOCK","","","","01");
INSERT INTO nom_old VALUES("200001","STOCK IN TRADE","","","","01");
INSERT INTO nom_old VALUES("2000010001","STOCK IN TRADE (RM)","","","","01");
INSERT INTO nom_old VALUES("2000010002","STOCK IN TRADE (FG)","","","","01");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","01");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","01");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","19","","","01");
INSERT INTO nom_old VALUES("2710000002","ELECTRONICS","","","","01");
INSERT INTO nom_old VALUES("2710000003","FURNITURE","","","","01");
INSERT INTO nom_old VALUES("272000","BANK BALANCES","","","","01");
INSERT INTO nom_old VALUES("2720000001","HABIB BANK","","","","01");
INSERT INTO nom_old VALUES("2720000002","FAYSAL BANK","","","","01");
INSERT INTO nom_old VALUES("273000","OUTLET","","","","01");
INSERT INTO nom_old VALUES("2730000001","HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("2730000002","STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("2730000003","DREAMS","","","","01");
INSERT INTO nom_old VALUES("2730000004","EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("2730000005","EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("2730000006","SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("2730000007","FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("2730000008","OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("2730000009","BWP ","","","","01");
INSERT INTO nom_old VALUES("2730000012","KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("41","TURNOVER","","","","01");
INSERT INTO nom_old VALUES("410001","SALE","","","4","01");
INSERT INTO nom_old VALUES("4100010001","SALES - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100010002","SALE - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100010003","SALES - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100010004","SALES - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100010005","SALES - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100010006","SALES - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100010007","SALES - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100010008","SALES - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100010009","SALES - BWP","","","","01");
INSERT INTO nom_old VALUES("4100010012","SALES - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410002","DISCOUNT","","","","01");
INSERT INTO nom_old VALUES("4100020001","DISCOUNT - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100020002","DISCOUNT - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100020003","DISCOUNT - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100020004","DISCOUNT - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100020005","DISCOUNT - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100020006","DISCOUNT - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100020007","DISCOUNT - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100020008","DISCOUNT - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100020009","DISCOUNT - BWP","","","","01");
INSERT INTO nom_old VALUES("4100020012","DISCOUNT - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410003","SALES RETURN","","","","01");
INSERT INTO nom_old VALUES("4100030001","RETURN - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100030002","RETURN - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100030003","RETURN - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100030004","RETURN - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100030005","RETURN - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100030006","RETURN - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100030007","RETURN - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100030008","RETURN - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100030009","RETURN - BWP","","","","01");
INSERT INTO nom_old VALUES("4100030012","RETURN - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410004","CREDIT NOTES","","","","01");
INSERT INTO nom_old VALUES("4100040001","CREDIT NOTES - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100040002","CREDIT NOTES - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100040003","CREDIT NOTES - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100040004","CREDIT NOTES - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100040005","CREDIT NOTES - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100040006","CREDIT NOTES - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100040007","CREDIT NOTES - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100040008","CREDIT NOTES - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100040009","CREDIT NOTES - BWP","","","","01");
INSERT INTO nom_old VALUES("4100040012","CREDIT NOTES - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410005","DEBIT NOTES","","","","01");
INSERT INTO nom_old VALUES("4100050001","DEBIT NOTES - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100050002","DEBIT NOTES - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100050003","DEBIT NOTES - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100050004","DEBIT NOTES - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100050005","DEBIT NOTES - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100050006","DEBIT NOTES - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100050007","DEBIT NOTES - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100050008","DEBIT NOTES - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100050009","DEBIT NOTES - BWP","","","","01");
INSERT INTO nom_old VALUES("4100050012","DEBIT NOTES - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("99","COST CENTRES","","","","01");
INSERT INTO nom_old VALUES("990001","STAFF","","","","01");
INSERT INTO nom_old VALUES("9900010001","ALI SHAN","","","","01");
INSERT INTO nom_old VALUES("9900010002","HUSNAIN","","","","01");
INSERT INTO nom_old VALUES("9900010003","MUSA","","","","01");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","02");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","02");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","02");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","05");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","05");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","05");
INSERT INTO nom_old VALUES("20","STOCK","","","","06");
INSERT INTO nom_old VALUES("200001","STOCK IN TRADE","","","","06");
INSERT INTO nom_old VALUES("2000010001","STOCK IN TRADE (RM)","","","","06");
INSERT INTO nom_old VALUES("2000010002","STOCK IN TRADE (FG)","","","","06");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","06");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","06");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","06");
INSERT INTO nom_old VALUES("01","Expenses","","","","07");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","07");
INSERT INTO nom_old VALUES("0100020009","FLAGSHIP OUTLET EXPENSES","","","","07");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","07");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","07");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","07");
INSERT INTO nom_old VALUES("01","Expenses","","","","08");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","08");
INSERT INTO nom_old VALUES("0100020009","KAREEM BLOCK OUTLET EXPENSES","","","","08");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","08");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","08");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","08");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","10");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","10");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","10");
INSERT INTO nom_old VALUES("01","Expenses","","","","12");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","12");
INSERT INTO nom_old VALUES("0100020009","KAREEM BLOCK OUTLET EXPENSES","","","","12");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","12");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","12");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","12");
INSERT INTO nom_old VALUES("01","Expenses","","","","13");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","13");
INSERT INTO nom_old VALUES("0100020009","FLAGSHIP OUTLET EXPENSES","","","","13");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","13");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","13");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","13");


DROP TABLE IF EXISTS o_batch;

CREATE TABLE `o_batch` (
  `PROD_ID` varchar(4) NOT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `BAL_QTY` decimal(10,0) DEFAULT NULL,
  `O_QTY` decimal(10,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO o_batch VALUES("0420","2017-04-30 00:00:00","TOS-1525","","1200");


DROP TABLE IF EXISTS o_voucher;

CREATE TABLE `o_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime NOT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `POSTED` varchar(1) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS o_voucherdet;

CREATE TABLE `o_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(13,2) DEFAULT NULL,
  `CREDIT` decimal(13,2) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS o_voucherdet_e;

CREATE TABLE `o_voucherdet_e` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `BPV_ID` varchar(20) DEFAULT NULL,
  `TENDER_NO` varchar(50) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS party;

CREATE TABLE `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO party VALUES("C0001","Walk-In-Customer","","","","","","undefined","","","","","","","","","2610000001","C","","","","","");
INSERT INTO party VALUES("S0002","Ashfaq Sons","","","","0","","undefined","","","","","","","","","1310000001","S","","","","","");
INSERT INTO party VALUES("S0003","Bath Tec","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0004","Porta Acrylic Bath Tubs Lahore","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0005","MAGOON TRADERS","","","","","","undefined","","","","","","","","","1310000006","S","","","","","");
INSERT INTO party VALUES("S0006","TREND BATHROOM ACCESSORIES","","","GUJRANWALA","","","undefined","","","","","","","","","1310000003","S","","","","","");
INSERT INTO party VALUES("S0007","SABAAN","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0008","URBAN CERAMICS","","","","","","undefined","","","","","","","","","1310000004","S","","","","","");
INSERT INTO party VALUES("S0009","SYMBOL INDUSTRIES (PVT.)LTD","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0010","MASTER","","","","","","undefined","","","","","","","","","1310000007","S","","","","","");
INSERT INTO party VALUES("S0011","DIAMOND","","","","","","undefined","","","","","","","","","1310000008","S","","","","","");
INSERT INTO party VALUES("S0012","A","","","","","","undefined","","","","","","","","","1310000009","S","","","","","");
INSERT INTO party VALUES("S0013","STYLE BATH WARE","","","","","","undefined","","","","","","","","","1310000005","S","","","","","");
INSERT INTO party VALUES("S0014","JAVAID","","","","","","undefined","","","","","","","","","1310000014","","","","null","","");
INSERT INTO party VALUES("S0015","MAHMOOD SONS","","","","","","undefined","","","","","","","","","1310000028","","","","null","","");
INSERT INTO party VALUES("S0016","NATURE","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0017","MA TRADERS","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0018","RAVI TRADERS","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0019","GORA TRADERS","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0020","PEARL DECOR","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0021","AL-HARMAIN PAINT CENTRE","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0022","KAPADIA INTERIOR","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0023","VEGA","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0024","BUTT SENTERY","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0025","TARIQ","","","","","","undefined","","","","","","","","","","S","","","Selet S","","");
INSERT INTO party VALUES("C0036","904/K PHS#6 DHA 03228470847","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("SS0027","PERFACT HOME","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0028","MAHMOOD GUJRANWALA","","","GUJRANWALA","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0029","KBS","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0003","Gourmet","","","","","","undefined","","","","","","","","","2610000003","C","","","Selet S","","");
INSERT INTO party VALUES("V0001","GOROHE","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0002","H.M.SONS PVT. LTD.","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0003","SKY SANITORY","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0004","MIDAS","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0005","USAMA PRINTING","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0006","ALLAH WASAYA","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0007","SAMAAR SKIRTING","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0008","MIAN FAKHAR","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0009","USMAN","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("C0027","SAYYAD BROTHER","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("V0010","BASRA BROTHERS","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0011","VIZDOM","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("C0028","KASHIF SB 245/G PHS# 5 DHA","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("V0012","SILLA CONCEPT\'S","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0013","Cash Purchase","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("C0029","FAROOQ KHAN SB - 03214008311","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0026","IMC","","","","","","undefined","","","","","","","","","1310000027","S","","","Selet S","","");
INSERT INTO party VALUES("C0030","200/1-B ST-NO #1 PHASE-5 DHA","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0031","36-D LAWRENCE ROAD LHR 03034291889","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0032","AHMAD SB","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0033","OLYMPIA BUILDERS","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0034","H-NO. 923/D PHS 6 DHA LHR","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0035","MR. ANEES SB 0321-4185133","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0037","547/D 0322454045","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0038","MALL OF SIALKOT","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("S0027","MUHAMMADI STORE","","","","","","undefined","","","","","","","","","","S","","","Selet S","","");
INSERT INTO party VALUES("P0001","DISPLAY","","","","","","undefined","","","","","","","","","","P","","","Selet S","","");
INSERT INTO party VALUES("C0039","SHOAIB KHAN SB","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0040","NADEEM SB CUSTOMER","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("V0014","CANON","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0015","AMJAD GUJRANWALA","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0016","GODI COMMODE","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0017","ANSARI PLASTIC","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0018","ASIAN STANDERED","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0019","LEXTA","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0020","SHEN CHINEESE","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");


DROP TABLE IF EXISTS party_add;

CREATE TABLE `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS party_product;

CREATE TABLE `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO party_product VALUES("0001","0357","46.000","","","","3");


DROP TABLE IF EXISTS party_type;

CREATE TABLE `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO party_type VALUES("C","Customer");
INSERT INTO party_type VALUES("S","Supplier");
INSERT INTO party_type VALUES("T","Trader");
INSERT INTO party_type VALUES("I","Import");
INSERT INTO party_type VALUES("P","Production");
INSERT INTO party_type VALUES("A","Cash");
INSERT INTO party_type VALUES("O","Other");
INSERT INTO party_type VALUES("V","Vender");


DROP TABLE IF EXISTS pay_mode;

CREATE TABLE `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_dc;

CREATE TABLE `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_dcdet;

CREATE TABLE `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_gp;

CREATE TABLE `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_gpdet;

CREATE TABLE `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_grn;

CREATE TABLE `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_grndet;

CREATE TABLE `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_invoice;

CREATE TABLE `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoice VALUES("060005","2017-06-03","1310000014","0.00","0.00","8100.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","8100.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060010","2017-06-06","1310000035","0.00","230.00","1330.00","","","","","","","","","","","","","01","","2017-06-19 17:06:48","","0001","","0.000","","","1330.00","","","","02","17","on","SILLA CONCEPT\'S","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060003","2017-06-02","1310000028","60379.00","0.00","26130.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","26130.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060004","2017-06-03","1310000014","0.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060011","2017-06-07","1310000028","685.00","0.00","19885.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","19885.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060002","2017-06-01","1310000028","2098.00","0.00","9550.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","9550.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060001","2017-06-01","1310000028","0.00","0.00","10193.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","10193.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060012","2017-06-07","1310000034","0.00","0.00","150.00","","","","","","","","","","","","","01","","2017-06-16 17:56:54","","0001","","0.000","","","150.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060014","2017-06-08","1310000027","0.00","0.00","17340.00","","","","","","","","","","","","","01","","2017-06-16 17:56:00","","0001","","0.000","","","17340.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060013","2017-06-08","1310000006","2164.00","0.00","10570.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","10570.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060015","2017-06-12","1310000014","0.00","0.00","6750.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","6750.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060017","2017-06-12","1310000006","2543.00","0.00","12415.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","12415.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070002","2017-06-02","1310000028","308.00","0.00","8470.00","","","","","","","","","","","","","01","","2017-07-03 17:50:27","","0001","","0.000","","","8470.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070007","2017-07-04","1310000014","0.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-07-05 11:53:27","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070004","2017-06-02","1310000039","0.00","0.00","79564.00","","","","","","","8848","","","","","","01","","2017-07-03 18:02:56","","0013","","0.000","","","79564.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070001","2017-07-03","1310000018","0.00","0.00","1800.00","","","","","","","","","","","","","01","","2017-07-04 16:41:27","","0001","","0.000","","","1800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070002","2017-06-30","1310000028","163.00","0.00","4630.00","","","","","","","","","","","","","01","","2017-07-04 16:40:42","","0001","","0.000","","","4630.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070006","2017-07-04","1310000006","0.00","0.00","3350.00","","","","","","","","","","","","","01","","2017-07-05 11:52:49","","0001","","0.000","","","3350.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060025","2017-06-14","1310000029","0.00","0.00","5500.00","","","","","","","","","","","","","01","","2017-06-17 11:29:21","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060024","2017-06-14","1310000033","0.00","0.00","36542.00","","","","","","","","","","","","","01","","2017-06-17 11:27:54","","0001","","0.000","","","36542.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060023","2017-06-13","1310000031","0.00","0.00","350.00","","","","","","","","","","","","","01","","2017-06-17 11:30:18","","0001","","0.000","","","350.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060022","2017-06-13","1310000","0.00","0.00","110.00","","","","","","","","","","","","","01","","2017-06-16 11:10:09","","0001","","0.000","","","110.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060021","2017-06-13","1310000028","250.00","0.00","1150.00","","","","","","","","","","","","","01","","2017-06-17 11:31:07","","0001","","0.000","","","1150.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060020","2017-06-13","1310000030","0.00","0.00","960.00","","","","","","","","","","","","","01","","2017-06-17 11:31:42","","0001","","0.000","","","960.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060019","2017-06-12","1310000","1109.00","0.00","5500.00","","","","","","","","","","","","","01","","2017-06-16 11:17:17","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060018","2017-06-12","1310000014","0.00","0.00","990.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","990.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070001","2017-06-01","1310000028","153.00","0.00","4190.00","","","","","","","","","","","","","01","","2017-07-03 16:52:48","","0013","","0.000","","","4190.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060016","2017-06-12","1310000028","259.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060006","2017-06-03","1310000018","0.00","0.00","14500.00","","","","","","","","","","","","","01","","2017-06-16 17:59:43","","0001","","0.000","","","14500.00","","","","02","17","on","","","0","0","","","","","14500");
INSERT INTO pl_invoice VALUES("060008","2017-06-05","1310000006","710.00","0.00","6390.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","6390.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060007","2017-06-05","1310000033","277.00","0.00","19770.00","","","","","","","","","","","","","01","","2017-06-16 18:00:30","","0001","","0.000","","","19770.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060009","2017-06-06","1310000034","0.00","0.00","3500.00","","","","","","","815","","","","","","01","","2017-06-16 17:56:54","","0001","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060026","2017-06-14","1310000034","25.00","0.00","14000.00","","","","","","","","","","","","","01","","2017-06-16 12:25:58","","0001","","0.000","","","14000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060027","2017-06-14","1310000006","2192.00","0.00","17330.00","","","","","","","","","","","","","01","","2017-06-16 12:47:23","","0001","","0.000","","","17330.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060030","2017-06-17","2610000042","0.00","0.00","950.00","","","","","","","","","","","","","01","","2017-06-19 11:07:41","","0001","","0.000","","","950.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060029","2017-06-17","1310000006","476.00","0.00","2324.00","","","","","","","","","","","","","01","","2017-06-19 10:43:46","","0001","","0.000","","","2324.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060028","2017-06-15","1310000034","0.00","0.00","21000.00","","","","","","","","","","","","","01","","2017-06-16 18:06:26","","0001","","0.000","","","21000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060031","2017-06-17","2610000043","0.00","0.00","3500.00","","","","","","","","","","","","","01","","2017-06-19 11:10:49","","0001","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060033","2017-06-21","1310000028","1824.00","0.00","8600.00","","","","","","","","","","","","","01","","2017-06-22 10:20:00","","0001","","0.000","","","8600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060034","2017-06-21","1310000006","3403.00","0.00","16000.00","","","","","","","","","","","","","01","","2017-06-22 10:27:07","","0001","","0.000","","","16000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060032","2017-06-20","1310000006","5804.00","0.00","28360.00","","","","","","","","","","","","","01","","2017-06-21 10:26:11","","0001","","0.000","","","28360.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060035","2017-06-22","1310000006","475.00","0.00","2700.00","","","","","","","","","","","","","01","","2017-06-23 10:33:09","","0001","","0.000","","","2700.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060036","2017-06-22","1310000006","4.00","0.00","56060.00","","","","","","","","","","","","","01","","2017-06-23 10:35:08","","0001","","0.000","","","56060.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060037","2017-06-22","1310000014","50.00","0.00","1000.00","","","","","","","","","","","","","01","","2017-06-23 10:36:01","","0001","","0.000","","","1000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("060038","2017-06-23","1310000028","59.00","0.00","1680.00","","","","","","","","","","","","","01","","2017-06-24 11:26:51","","0001","","0.000","","","1680.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070004","2017-06-30","1310000033","0.00","0.00","560.00","","","","","","","","","","","","","01","","2017-07-05 11:34:03","","0001","","0.000","","","560.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070008","2017-07-06","1310000028","747.00","0.00","20370.00","","","","","","","","","","","","","01","","2017-07-07 11:43:56","","0001","","0.000","","","20370.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070009","2017-07-06","1310000028","15690.00","0.00","3730.00","","","","","","","","","","","","","01","","2017-07-07 11:47:04","","0001","","0.000","","","3730.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070010","2017-07-07","1310000045","2.00","0.00","3390.00","","","","","","","if-l-07913","","","","","","01","","2017-07-08 11:28:49","","0001","","0.000","","","3390.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070011","2017-07-10","1310000047","0.00","0.00","13000.00","","","","","","","","","","","","","01","","2017-07-11 14:19:30","","0003","","0.000","","","13000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070012","2017-07-10","1310000014","0.00","0.00","14050.00","","","","","","","","","","","","","01","","2017-07-11 14:20:48","","0003","","0.000","","","14050.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice VALUES("070013","2017-07-11","1310000014","0.00","0.00","7350.00","","","","","","","","","","","","","01","","2017-07-12 11:20:23","","0003","","0.000","","","7350.00","","","","02","17","on","","","0","0","","","","","0");


DROP TABLE IF EXISTS pl_invoice_adv;

CREATE TABLE `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_invoice_copy;

CREATE TABLE `pl_invoice_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoice_copy VALUES("060025","2017-06-14","1310000029","0.00","0.00","5500.00","","","","","","","","","","","","","01","","2017-06-17 11:29:21","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060024","2017-06-14","1310000033","0.00","0.00","36542.00","","","","","","","","","","","","","01","","2017-06-17 11:27:54","","0001","","0.000","","","36542.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060023","2017-06-13","1310000031","0.00","0.00","350.00","","","","","","","","","","","","","01","","2017-06-17 11:30:18","","0001","","0.000","","","350.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060022","2017-06-13","1310000","0.00","0.00","110.00","","","","","","","","","","","","","01","","2017-06-16 11:10:09","","0001","","0.000","","","110.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060021","2017-06-13","1310000028","250.00","0.00","1150.00","","","","","","","","","","","","","01","","2017-06-17 11:31:07","","0001","","0.000","","","1150.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060020","2017-06-13","1310000030","0.00","0.00","960.00","","","","","","","","","","","","","01","","2017-06-17 11:31:42","","0001","","0.000","","","960.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060019","2017-06-12","1310000","1109.00","0.00","5500.00","","","","","","","","","","","","","01","","2017-06-16 11:17:17","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060018","2017-06-12","1310000014","0.00","0.00","990.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","990.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060017","2017-06-12","1310000006","2543.00","0.00","12415.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","12415.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060016","2017-06-12","1310000028","259.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060015","2017-06-12","1310000014","0.00","0.00","6750.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","6750.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060014","2017-06-08","1310000027","0.00","0.00","17340.00","","","","","","","","","","","","","01","","2017-06-16 17:56:00","","0001","","0.000","","","17340.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060013","2017-06-08","1310000006","2164.00","0.00","10570.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","10570.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060002","2017-06-01","1310000028","2098.00","0.00","9550.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","9550.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060001","2017-06-01","1310000028","0.00","0.00","10193.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","10193.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060012","2017-06-07","1310000034","0.00","0.00","150.00","","","","","","","","","","","","","01","","2017-06-16 17:56:54","","0001","","0.000","","","150.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060011","2017-06-07","1310000028","685.00","0.00","19885.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","19885.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060010","2017-06-06","1310000035","0.00","230.00","1330.00","","","","","","","","","","","","","01","","2017-06-19 17:06:48","","0001","","0.000","","","1330.00","","","","02","17","on","SILLA CONCEPT\'S","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060003","2017-06-02","1310000028","60379.00","0.00","26130.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","26130.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060004","2017-06-03","1310000014","0.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060005","2017-06-03","1310000014","0.00","0.00","8100.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","8100.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060006","2017-06-03","1310000018","0.00","0.00","14500.00","","","","","","","","","","","","","01","","2017-06-16 17:59:43","","0001","","0.000","","","14500.00","","","","02","17","on","","","0","0","","","","","14500");
INSERT INTO pl_invoice_copy VALUES("060007","2017-06-05","1310000033","277.00","0.00","19770.00","","","","","","","","","","","","","01","","2017-06-16 18:00:30","","0001","","0.000","","","19770.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060008","2017-06-05","1310000006","710.00","0.00","6390.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","6390.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060009","2017-06-06","1310000034","0.00","0.00","3500.00","","","","","","","815","","","","","","01","","2017-06-16 17:56:54","","0001","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060026","2017-06-14","1310000034","25.00","0.00","14000.00","","","","","","","","","","","","","01","","2017-06-16 12:25:58","","0001","","0.000","","","14000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060027","2017-06-14","1310000006","2192.00","0.00","17330.00","","","","","","","","","","","","","01","","2017-06-16 12:47:23","","0001","","0.000","","","17330.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060028","2017-06-15","1310000034","0.00","0.00","21000.00","","","","","","","","","","","","","01","","2017-06-16 18:06:26","","0001","","0.000","","","21000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060029","2017-06-17","1310000006","476.00","0.00","2324.00","","","","","","","","","","","","","01","","2017-06-19 10:43:46","","0001","","0.000","","","2324.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060030","2017-06-17","2610000042","0.00","0.00","950.00","","","","","","","","","","","","","01","","2017-06-19 11:07:41","","0001","","0.000","","","950.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060031","2017-06-17","2610000043","0.00","0.00","3500.00","","","","","","","","","","","","","01","","2017-06-19 11:10:49","","0001","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060032","2017-06-20","1310000006","5804.00","0.00","28360.00","","","","","","","","","","","","","01","","2017-06-21 10:26:11","","0001","","0.000","","","28360.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060033","2017-06-21","1310000028","1824.00","0.00","8600.00","","","","","","","","","","","","","01","","2017-06-22 10:20:00","","0001","","0.000","","","8600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060034","2017-06-21","1310000006","3403.00","0.00","16000.00","","","","","","","","","","","","","01","","2017-06-22 10:27:07","","0001","","0.000","","","16000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060035","2017-06-22","1310000006","475.00","0.00","2700.00","","","","","","","","","","","","","01","","2017-06-23 10:33:09","","0001","","0.000","","","2700.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060036","2017-06-22","1310000006","4.00","0.00","56060.00","","","","","","","","","","","","","01","","2017-06-23 10:35:08","","0001","","0.000","","","56060.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060037","2017-06-22","1310000014","50.00","0.00","1000.00","","","","","","","","","","","","","01","","2017-06-23 10:36:01","","0001","","0.000","","","1000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060038","2017-06-23","1310000028","59.00","0.00","1680.00","","","","","","","","","","","","","01","","2017-06-24 11:26:51","","0001","","0.000","","","1680.00","","","","02","17","on","","","0","0","","","","","0");


DROP TABLE IF EXISTS pl_invoicedet;

CREATE TABLE `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoicedet VALUES("070001","1","4371","","1.000","3087.00000","3087.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070001","2","4372","","1.000","1256.00000","1256.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070002","1","4373","","3.000","2926.00000","8778.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070009","2","4275","","1.000","3964.00000","3964.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070009","1","4276","","1.000","10272.00000","10272.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070006","1","4392","","1.000","3350.00000","3350.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070008","4","3976","","4.000","602.00000","2408.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070004","1","4225","","1.000","24670.00000","24670.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070004","2","4225","","1.000","6458.00000","6458.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070004","3","4225","","1.000","48436.00000","48436.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070001","1","4368","","1.000","1800.00000","1800.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("070002","1","3826","","1.000","1190.00000","1190.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070002","2","4353","","1.000","3603.00000","3603.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070008","3","4245","","1.000","4437.00000","4437.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070007","1","4247","","1.000","7500.00000","7500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070008","2","4400","","1.000","5412.00000","5412.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070008","1","4337","","1.000","8860.00000","8860.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060001","1","4242","","4.000","2548.00000","10193.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060002","1","3976","","1.000","708.00000","708.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060002","2","3976","","1.000","708.00000","708.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060002","3","4228","","1.000","3174.00000","3174.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060002","4","4243","","1.000","1641.00000","1641.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060002","5","4244","","1.000","4017.00000","4017.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060002","6","3826","","1.000","1400.00000","1400.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060003","1","3821","","4.000","5412.00000","21648.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060003","2","4245","","4.000","4437.00000","17748.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060003","3","3822","","2.000","3847.00000","7694.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060003","4","4246","","4.000","6357.00000","25429.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060003","5","3779","","1.000","13990.00000","13990.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060004","1","4247","","1.000","7500.00000","7500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060005","1","4248","","1.000","2520.00000","2520.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060005","2","4249","","1.000","5580.00000","5580.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060006","1","4250","","1.000","14500.00000","14500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060007","1","4261","","1.000","14150.00000","13443.00","","","","","","","","","","","","","02","17","5.000","708.00","0","708");
INSERT INTO pl_invoicedet VALUES("060007","2","3984","","1.000","1945.00000","1848.00","","","","","","","","","","","","","02","17","5.000","97.00","0","97");
INSERT INTO pl_invoicedet VALUES("060007","3","4214","","1.000","680.00000","646.00","","","","","","","","","","","","","02","17","5.000","34.00","0","34");
INSERT INTO pl_invoicedet VALUES("060007","4","4084","","1.000","4420.00000","4111.00","","","","","","","","","","","","","02","17","7.000","309.00","0","309");
INSERT INTO pl_invoicedet VALUES("060008","1","4253","","1.000","4150.00000","4150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060008","2","4265","","1.000","2950.00000","2950.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060009","1","4273","","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060010","1","4235","","1.000","1100.00000","1100.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060011","1","3826","510","1.000","1150.00000","1150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060011","2","4276","","1.000","10272.00000","10272.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060011","3","4275","","1.000","3964.00000","3964.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060011","4","4274","","1.000","5184.00000","5184.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060012","1","4029","","1.000","150.00000","150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060013","1","4271","","1.000","12734.00000","12734.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060014","1","4279","","1.000","17340.00000","17340.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060015","1","3975","","25.000","270.00000","6750.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060016","1","4243","","3.000","1396.00000","4189.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060016","2","3826","510","3.000","1190.00000","3570.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060017","1","4246","","1.000","14958.00000","14958.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060018","1","4029","","3.000","330.00000","990.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060019","1","4290","","1.000","6609.00000","6609.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060020","1","4036","","12.000","80.00000","960.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060021","1","3826","510","1.000","1400.00000","1400.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060022","1","4307","","2.000","55.00000","110.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060023","1","4308","","1.000","350.00000","350.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060024","1","4309","","1.000","14150.00000","13018.00","","","","","","","","","","","","","02","17","8.000","1132.00","0","1132");
INSERT INTO pl_invoicedet VALUES("060024","2","4309","","2.000","12785.00000","23524.00","","","","","","","","","","","","","02","17","8.000","2046.00","0","2046");
INSERT INTO pl_invoicedet VALUES("060025","1","4310","","1.000","5500.00000","5500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060026","1","4311","","17.000","825.00000","14025.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("","1","4292","","1.000","4136.00000","4136.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("","2","4291","","1.000","2464.00000","2464.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("","3","3975","","6.000","1140.00000","6840.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("","4","4293","","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("","5","4243","","2.000","1641.00000","3282.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060027","1","4292","","1.000","4136.00000","4136.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060027","2","4291","","1.000","2464.00000","2464.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060027","3","3975","","6.000","1140.00000","6840.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060027","4","4293","","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060027","5","4243","","2.000","1641.00000","3282.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060028","1","4312","","40.000","525.00000","21000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060029","1","3826","510","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060030","1","4316","","1.000","950.00000","950.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060031","1","4319","","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060032","1","4304","","6.000","4868.00000","29208.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060032","2","4303","","4.000","1239.00000","4956.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060033","1","4337","","1.000","10424.00000","10424.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060034","1","4331","","1.000","19403.00000","19403.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("060035","1","4340","","1.000","3175.00000","3175.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060036","1","4332","","2.000","14892.00000","29784.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060036","2","4333","","2.000","13140.00000","26280.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060037","1","4029","","3.000","350.00000","1050.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("060038","1","4351","","1.000","1739.00000","1739.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070004","1","4020","","2.000","280.00000","560.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070009","3","4274","","1.000","5184.00000","5184.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070010","1","4225","","27.000","125.00000","3392.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet VALUES("070011","1","4408","","1.000","5500.00000","5500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070011","2","4409","","1.000","5500.00000","5500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070011","3","4142","","2.000","1000.00000","2000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070012","1","4248","","5.000","2600.00000","13000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070012","2","4031","","3.000","350.00000","1050.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070013","1","3470","","1.000","6500.00000","6500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet VALUES("070013","2","4043","","1.000","850.00000","850.00","","","","","","","","","","","","","02","17","0.000","","0","0");


DROP TABLE IF EXISTS pl_invoicedet_copy;

CREATE TABLE `pl_invoicedet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoicedet_copy VALUES("060001","1","4242","","4.000","2548.00000","10193.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","1","3976","","1.000","708.00000","708.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","2","3976","","1.000","708.00000","708.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","3","4228","","1.000","3174.00000","3174.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","4","4243","","1.000","1641.00000","1641.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","5","4244","","1.000","4017.00000","4017.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","6","3826","","1.000","1400.00000","1400.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","1","3821","","4.000","5412.00000","21648.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","2","4245","","4.000","4437.00000","17748.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","3","3822","","2.000","3847.00000","7694.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","4","4246","","4.000","6357.00000","25429.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","5","3779","","1.000","13990.00000","13990.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060004","1","4247","","1.000","7500.00000","7500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060005","1","4248","","1.000","2520.00000","2520.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060005","2","4249","","1.000","5580.00000","5580.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060006","1","4250","","1.000","14500.00000","14500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060007","1","4261","","1.000","14150.00000","13443.00","","","","","","","","","","","","","02","17","5.000","708.00","0","708");
INSERT INTO pl_invoicedet_copy VALUES("060007","2","3984","","1.000","1945.00000","1848.00","","","","","","","","","","","","","02","17","5.000","97.00","0","97");
INSERT INTO pl_invoicedet_copy VALUES("060007","3","4214","","1.000","680.00000","646.00","","","","","","","","","","","","","02","17","5.000","34.00","0","34");
INSERT INTO pl_invoicedet_copy VALUES("060007","4","4084","","1.000","4420.00000","4111.00","","","","","","","","","","","","","02","17","7.000","309.00","0","309");
INSERT INTO pl_invoicedet_copy VALUES("060008","1","4253","","1.000","4150.00000","4150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060008","2","4265","","1.000","2950.00000","2950.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060009","1","4273","","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060010","1","4235","","1.000","1100.00000","1100.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","1","3826","510","1.000","1150.00000","1150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","2","4276","","1.000","10272.00000","10272.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","3","4275","","1.000","3964.00000","3964.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","4","4274","","1.000","5184.00000","5184.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060012","1","4029","","1.000","150.00000","150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060013","1","4271","","1.000","12734.00000","12734.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060014","1","4279","","1.000","17340.00000","17340.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060015","1","3975","","25.000","270.00000","6750.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060016","1","4243","","3.000","1396.00000","4189.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060016","2","3826","510","3.000","1190.00000","3570.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060017","1","4246","","1.000","14958.00000","14958.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060018","1","4029","","3.000","330.00000","990.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060019","1","4290","","1.000","6609.00000","6609.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060020","1","4036","","12.000","80.00000","960.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060021","1","3826","510","1.000","1400.00000","1400.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060022","1","4307","","2.000","55.00000","110.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060023","1","4308","","1.000","350.00000","350.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060024","1","4309","","1.000","14150.00000","13018.00","","","","","","","","","","","","","02","17","8.000","1132.00","0","1132");
INSERT INTO pl_invoicedet_copy VALUES("060024","2","4309","","2.000","12785.00000","23524.00","","","","","","","","","","","","","02","17","8.000","2046.00","0","2046");
INSERT INTO pl_invoicedet_copy VALUES("060025","1","4310","","1.000","5500.00000","5500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060026","1","4311","","17.000","825.00000","14025.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","1","4292","","1.000","4136.00000","4136.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","2","4291","","1.000","2464.00000","2464.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","3","3975","","6.000","1140.00000","6840.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","4","4293","","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","5","4243","","2.000","1641.00000","3282.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","1","4292","","1.000","4136.00000","4136.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","2","4291","","1.000","2464.00000","2464.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","3","3975","","6.000","1140.00000","6840.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","4","4293","","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","5","4243","","2.000","1641.00000","3282.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060028","1","4312","","40.000","525.00000","21000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060029","1","3826","510","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060030","1","4316","","1.000","950.00000","950.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060031","1","4319","","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060032","1","4304","","6.000","4868.00000","29208.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060032","2","4303","","4.000","1239.00000","4956.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060033","1","4337","","1.000","10424.00000","10424.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060034","1","4331","","1.000","19403.00000","19403.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060035","1","4340","","1.000","3175.00000","3175.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060036","1","4332","","2.000","14892.00000","29784.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060036","2","4333","","2.000","13140.00000","26280.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060037","1","4029","","3.000","350.00000","1050.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060038","1","4351","","1.000","1739.00000","1739.00","","","","","","","","","","","","","02","17","0.000","","0","0");


DROP TABLE IF EXISTS pl_invoicedetapp;

CREATE TABLE `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_jv;

CREATE TABLE `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_jvdet;

CREATE TABLE `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_jvdet_inst;

CREATE TABLE `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_order;

CREATE TABLE `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `po_no` varchar(30) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `disc_amt` decimal(15,2) DEFAULT NULL,
  `dc_amt` decimal(15,2) DEFAULT NULL,
  `loc_id` char(2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `sp_id` varchar(7) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `service` char(2) DEFAULT NULL,
  `ut` char(2) DEFAULT NULL,
  `adv_amt` decimal(15,2) DEFAULT NULL,
  `net_amt` decimal(15,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_orderdet;

CREATE TABLE `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` decimal(6,3) DEFAULT NULL,
  `stax` decimal(15,2) DEFAULT NULL,
  `stax_rate` decimal(15,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `sed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_pay;

CREATE TABLE `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_paydet;

CREATE TABLE `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_paydet_inst;

CREATE TABLE `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_payment;

CREATE TABLE `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_paymentdet;

CREATE TABLE `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_po;

CREATE TABLE `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_podet;

CREATE TABLE `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receipt;

CREATE TABLE `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet;

CREATE TABLE `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet_acct;

CREATE TABLE `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet_inv;

CREATE TABLE `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet_po;

CREATE TABLE `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_return;

CREATE TABLE `pl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_returndet;

CREATE TABLE `pl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_ship;

CREATE TABLE `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_ship_inv;

CREATE TABLE `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_shipdet;

CREATE TABLE `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS po;

CREATE TABLE `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS po_type;

CREATE TABLE `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO po_type VALUES("01","Ex Works");


DROP TABLE IF EXISTS podet;

CREATE TABLE `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS process;

CREATE TABLE `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO process VALUES("1","Mixing");


DROP TABLE IF EXISTS prod;

CREATE TABLE `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_batch;

CREATE TABLE `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_brand;

CREATE TABLE `prod_brand` (
  `BRAND_ID` varchar(6) NOT NULL,
  `BRAND_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`BRAND_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_brand VALUES("01","Local","","","");
INSERT INTO prod_brand VALUES("02","China","","","");
INSERT INTO prod_brand VALUES("03","SONEX","","","");
INSERT INTO prod_brand VALUES("04","GROHE","","","");
INSERT INTO prod_brand VALUES("05","GROHE CHI","","","");
INSERT INTO prod_brand VALUES("06","CLASSIC","","","");
INSERT INTO prod_brand VALUES("07","OTHERS","","","");
INSERT INTO prod_brand VALUES("08","JAGUAR","","","");


DROP TABLE IF EXISTS prod_cat;

CREATE TABLE `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_cat VALUES("01","BATH","","","");
INSERT INTO prod_cat VALUES("010001","ART BOWEL","","","");
INSERT INTO prod_cat VALUES("010002","BAR 71011","","","");
INSERT INTO prod_cat VALUES("010003","BASIN EXTENSION","","","");
INSERT INTO prod_cat VALUES("010004","BASIN MIXER","","","");
INSERT INTO prod_cat VALUES("010005","BASIN PADESTAL","","","");
INSERT INTO prod_cat VALUES("010006","BASIN WAST","","","");
INSERT INTO prod_cat VALUES("010007","BASKET","","","");
INSERT INTO prod_cat VALUES("010008","BATH MIXER","","","");
INSERT INTO prod_cat VALUES("010009","BATH WAST","","","");
INSERT INTO prod_cat VALUES("010010","BOTAL TRYP","","","");
INSERT INTO prod_cat VALUES("010011","BOX","","","");
INSERT INTO prod_cat VALUES("010012","BRUSH HOLDER","","","");
INSERT INTO prod_cat VALUES("010013","CABNET BOX","","","");
INSERT INTO prod_cat VALUES("010014","COMMODE","","","");
INSERT INTO prod_cat VALUES("010015","CP BUSH 3/8*1/2","","","");
INSERT INTO prod_cat VALUES("010016","CP CUP","","","");
INSERT INTO prod_cat VALUES("010017","CP CUP SMALL","","","");
INSERT INTO prod_cat VALUES("010018","CP NAT 1/4","","","");
INSERT INTO prod_cat VALUES("010019","CP NOZEL","","","");
INSERT INTO prod_cat VALUES("010020","CP PIPE 1 FT","","","");
INSERT INTO prod_cat VALUES("010021","CP PIPE 2 FT","","","");
INSERT INTO prod_cat VALUES("010022","CP PIPE 3 FT","","","");
INSERT INTO prod_cat VALUES("010023","CURTAIN","","","");
INSERT INTO prod_cat VALUES("010024","DIAL PLATE","","","");
INSERT INTO prod_cat VALUES("010025","DIVIDER","","","");
INSERT INTO prod_cat VALUES("010026","DUST BIN","","","");
INSERT INTO prod_cat VALUES("010027","ESPA PUMP","","","");
INSERT INTO prod_cat VALUES("010028","EXTENTION","","","");
INSERT INTO prod_cat VALUES("010029","FLEX DAMAGE","","","");
INSERT INTO prod_cat VALUES("010030","FLOOR WAST","","","");
INSERT INTO prod_cat VALUES("010031","FLUSH TANK","","","");
INSERT INTO prod_cat VALUES("010032","GEBERIT BEND 367.792.19.1","","","");
INSERT INTO prod_cat VALUES("010033","GEBERIT STRAIGHT PIPE 152.420.","","","");
INSERT INTO prod_cat VALUES("010034","GLASS DISH","","","");
INSERT INTO prod_cat VALUES("010035","GOLA","","","");
INSERT INTO prod_cat VALUES("010036","GRAB BAR HS-30118","","","");
INSERT INTO prod_cat VALUES("010037","GRAB BAR HS-30312","","","");
INSERT INTO prod_cat VALUES("010038","GRAY BAR 12\"","","","");
INSERT INTO prod_cat VALUES("010039","GRAY BAR 9\"","","","");
INSERT INTO prod_cat VALUES("010040","GYSER","","","");
INSERT INTO prod_cat VALUES("010041","HAND DRAYER","","","");
INSERT INTO prod_cat VALUES("010042","HAND SHOWER","","","");
INSERT INTO prod_cat VALUES("010043","HANDLE 905-192","","","");
INSERT INTO prod_cat VALUES("010044","HOOK","","","");
INSERT INTO prod_cat VALUES("010045","HOOK COAT","","","");
INSERT INTO prod_cat VALUES("010046","HOOK COAT GROHE","","","");
INSERT INTO prod_cat VALUES("010047","HOOK MUSLIM SHOWER","","","");
INSERT INTO prod_cat VALUES("010048","HOOK ZILVER","","","");
INSERT INTO prod_cat VALUES("010049","JACUZZI","","","");
INSERT INTO prod_cat VALUES("010050","JALI","","","");
INSERT INTO prod_cat VALUES("010051","JET SHOWER","","","");
INSERT INTO prod_cat VALUES("010052","JUMBO LON","","","");
INSERT INTO prod_cat VALUES("010053","KIT","","","");
INSERT INTO prod_cat VALUES("010054","L BRACKET 3\" 1715","","","");
INSERT INTO prod_cat VALUES("010055","LONG BOLT S.S","","","");
INSERT INTO prod_cat VALUES("010056","MIRROR","","","");
INSERT INTO prod_cat VALUES("010057","MUSLIM SHOWER","","","");
INSERT INTO prod_cat VALUES("010058","NALKA ROUND 0088 N.C","","","");
INSERT INTO prod_cat VALUES("010059","NAT","","","");
INSERT INTO prod_cat VALUES("010060","NECK MEDIUM","","","");
INSERT INTO prod_cat VALUES("010061","NIPLE BARREL","","","");
INSERT INTO prod_cat VALUES("010062","NIPLE CP 1/2 * 3/4","","","");
INSERT INTO prod_cat VALUES("010063","NOZEL COCK 1/2","","","");
INSERT INTO prod_cat VALUES("010064","OVER COUNTER","","","");
INSERT INTO prod_cat VALUES("010065","PAPER HOLDER","","","");
INSERT INTO prod_cat VALUES("010066","PIPE","","","");
INSERT INTO prod_cat VALUES("010067","POP WAST","","","");
INSERT INTO prod_cat VALUES("010068","PUSH WAST","","","");
INSERT INTO prod_cat VALUES("010069","PUSH WAST BRASS","","","");
INSERT INTO prod_cat VALUES("010070","PUSH WAST SMALL","","","");
INSERT INTO prod_cat VALUES("010071","RACK","","","");
INSERT INTO prod_cat VALUES("010072","RAIN SHOWER","","","");
INSERT INTO prod_cat VALUES("010073","ROSE PATEL BOX","","","");
INSERT INTO prod_cat VALUES("010074","SANGI 704","","","");
INSERT INTO prod_cat VALUES("010075","SCREW HOOK 12","","","");
INSERT INTO prod_cat VALUES("010076","SEAT COVER","","","");
INSERT INTO prod_cat VALUES("010077","SHOWER CABIN","","","");
INSERT INTO prod_cat VALUES("010078","SHOWER PANEL","","","");
INSERT INTO prod_cat VALUES("010079","SHOWER ROOM","","","");
INSERT INTO prod_cat VALUES("010080","SHOWER SET","","","");
INSERT INTO prod_cat VALUES("010081","SIDE BOX 705","","","");
INSERT INTO prod_cat VALUES("010082","SIDE PILLER COCK","","","");
INSERT INTO prod_cat VALUES("010083","SILICON","","","");
INSERT INTO prod_cat VALUES("010084","SLAB","","","");
INSERT INTO prod_cat VALUES("010085","SLIDING RAD","","","");
INSERT INTO prod_cat VALUES("010086","SOAP DISH","","","");
INSERT INTO prod_cat VALUES("010087","SOAP DSPENSER","","","");
INSERT INTO prod_cat VALUES("010088","SPOUT","","","");
INSERT INTO prod_cat VALUES("010089","STAND","","","");
INSERT INTO prod_cat VALUES("010090","STOPC 3704","","","");
INSERT INTO prod_cat VALUES("010091","TAFLON TAPE","","","");
INSERT INTO prod_cat VALUES("010092","TAFLON TAPE BIG","","","");
INSERT INTO prod_cat VALUES("010093","TANKI PLATE","","","");
INSERT INTO prod_cat VALUES("010094","TANKI PLATE DUAL 38506000","","","");
INSERT INTO prod_cat VALUES("010095","THIMBLE ALPHAIN","","","");
INSERT INTO prod_cat VALUES("010096","THIMBLE GREES","","","");
INSERT INTO prod_cat VALUES("010097","THIMBLE SET","","","");
INSERT INTO prod_cat VALUES("010098","THIMBLE UK","","","");
INSERT INTO prod_cat VALUES("010099","THIMBLE WHITE","","","");
INSERT INTO prod_cat VALUES("010100","THREAD GOLA","","","");
INSERT INTO prod_cat VALUES("010101","TILE","","","");
INSERT INTO prod_cat VALUES("010102","TOILET SHOWER BOD","","","");
INSERT INTO prod_cat VALUES("010103","TOWEL RAD","","","");
INSERT INTO prod_cat VALUES("010104","TOWEL RING","","","");
INSERT INTO prod_cat VALUES("010105","U BEND WWT","","","");
INSERT INTO prod_cat VALUES("010106","UNDER COUNTER","","","");
INSERT INTO prod_cat VALUES("010107","UPPER COUNTER","","","");
INSERT INTO prod_cat VALUES("010108","URINAL","","","");
INSERT INTO prod_cat VALUES("010109","URIRNAL PORTA","","","");
INSERT INTO prod_cat VALUES("010110","VANITY","","","");
INSERT INTO prod_cat VALUES("010111","W.C","","","");
INSERT INTO prod_cat VALUES("010112","WASHER CONNECTION","","","");
INSERT INTO prod_cat VALUES("010113","SALDING RAD","","","");
INSERT INTO prod_cat VALUES("010114","AUTO BODY","","","");
INSERT INTO prod_cat VALUES("010115","BIB COCK","","","");
INSERT INTO prod_cat VALUES("010116","GREY BAR","","","");
INSERT INTO prod_cat VALUES("010117","ACCESSORY SET 304","","","");
INSERT INTO prod_cat VALUES("010118","ACCESSORY SET GALA","","","");
INSERT INTO prod_cat VALUES("010119","ACCESSORY SET","","","");
INSERT INTO prod_cat VALUES("02","KITCHEN","","","");
INSERT INTO prod_cat VALUES("020001","ACCESSORY SET","","","");
INSERT INTO prod_cat VALUES("020002","BIB COCK","","","");
INSERT INTO prod_cat VALUES("020003","CONCELED BODY","","","");
INSERT INTO prod_cat VALUES("020004","COOKING RANGE","","","");
INSERT INTO prod_cat VALUES("020005","HOB","","","");
INSERT INTO prod_cat VALUES("020006","HOOD","","","");
INSERT INTO prod_cat VALUES("020007","KITCHEN ACCESSORY","","","");
INSERT INTO prod_cat VALUES("020008","LOSE ITEM","","","");
INSERT INTO prod_cat VALUES("020009","MICRO OVEN","","","");
INSERT INTO prod_cat VALUES("020010","SINK","","","");
INSERT INTO prod_cat VALUES("020011","SINK BASKET","","","");
INSERT INTO prod_cat VALUES("020012","SINK FITTING","","","");
INSERT INTO prod_cat VALUES("020013","SINK MIXER","","","");
INSERT INTO prod_cat VALUES("020014","SINK WAST","","","");
INSERT INTO prod_cat VALUES("020015","T-ARM","","","");
INSERT INTO prod_cat VALUES("020016","T-COCK","","","");
INSERT INTO prod_cat VALUES("020017","OVEN","","","");
INSERT INTO prod_cat VALUES("020018","SPOUT","","","");
INSERT INTO prod_cat VALUES("020019","DAIL PLET","","","");
INSERT INTO prod_cat VALUES("020020","TABLE SET","","","");
INSERT INTO prod_cat VALUES("03","FLOOR","","","");
INSERT INTO prod_cat VALUES("030001","WOOD FLOOR","","","");
INSERT INTO prod_cat VALUES("99","Others","","","");
INSERT INTO prod_cat VALUES("990001","Others","","","");


DROP TABLE IF EXISTS prod_comp;

CREATE TABLE `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_grp;

CREATE TABLE `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_grp VALUES("01","Group Name");


DROP TABLE IF EXISTS prod_rm_date;

CREATE TABLE `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_type;

CREATE TABLE `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_type VALUES("01","Franchise Group","0700100001","0500030003","0800010101");


DROP TABLE IF EXISTS proddet;

CREATE TABLE `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS regions;

CREATE TABLE `regions` (
  `REG_ID` varchar(4) NOT NULL,
  `REG_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`REG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO regions VALUES("1","Punjab (Province)");


DROP TABLE IF EXISTS replanishment;

CREATE TABLE `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO replanishment VALUES("SD03001BL08","2","12");
INSERT INTO replanishment VALUES("SD03001BL09","2","12");
INSERT INTO replanishment VALUES("SD03001BL10","2","12");
INSERT INTO replanishment VALUES("SD03001BL11","1","12");
INSERT INTO replanishment VALUES("SD03002BL08","2","12");
INSERT INTO replanishment VALUES("SD03002BL09","2","12");
INSERT INTO replanishment VALUES("SD03002BL10","2","12");
INSERT INTO replanishment VALUES("SD03002BL11","1","12");
INSERT INTO replanishment VALUES("SD03003BL08","2","12");
INSERT INTO replanishment VALUES("SD03003BL09","2","12");
INSERT INTO replanishment VALUES("SD03003BL10","2","12");
INSERT INTO replanishment VALUES("SD03003BL11","1","12");
INSERT INTO replanishment VALUES("SD03004BL08","2","12");
INSERT INTO replanishment VALUES("SD03004BL09","2","12");
INSERT INTO replanishment VALUES("SD03004BL10","2","12");
INSERT INTO replanishment VALUES("SD03004BL11","1","12");
INSERT INTO replanishment VALUES("SD03005OW08","2","12");
INSERT INTO replanishment VALUES("SD03005OW09","2","12");
INSERT INTO replanishment VALUES("SD03005OW10","2","12");
INSERT INTO replanishment VALUES("SD03005OW11","1","12");
INSERT INTO replanishment VALUES("SD03006GO08","2","12");
INSERT INTO replanishment VALUES("SD03006GO09","2","12");
INSERT INTO replanishment VALUES("SD03006GO10","2","12");
INSERT INTO replanishment VALUES("SD03006GO11","1","12");
INSERT INTO replanishment VALUES("SD03007BL08","2","12");
INSERT INTO replanishment VALUES("SD03007BL09","2","12");
INSERT INTO replanishment VALUES("SD03007BL10","2","12");
INSERT INTO replanishment VALUES("SD03007BL11","1","12");
INSERT INTO replanishment VALUES("SD04001BG08","2","12");
INSERT INTO replanishment VALUES("SD04001BG09","2","12");
INSERT INTO replanishment VALUES("SD04001BG10","2","12");
INSERT INTO replanishment VALUES("SD04001BG11","1","12");
INSERT INTO replanishment VALUES("SD04002YB08","2","12");
INSERT INTO replanishment VALUES("SD04002YB09","2","12");
INSERT INTO replanishment VALUES("SD04002YB10","2","12");
INSERT INTO replanishment VALUES("SD04002YB11","1","12");
INSERT INTO replanishment VALUES("SD07001SB08","2","12");
INSERT INTO replanishment VALUES("SD07001SB09","2","12");
INSERT INTO replanishment VALUES("SD07001SB10","2","12");
INSERT INTO replanishment VALUES("SD07001SB11","1","12");
INSERT INTO replanishment VALUES("SD07002BU08","2","12");
INSERT INTO replanishment VALUES("SD07002BU09","2","12");
INSERT INTO replanishment VALUES("SD07002BU10","2","12");
INSERT INTO replanishment VALUES("SD07002BU11","1","12");
INSERT INTO replanishment VALUES("SD07003LR08","2","12");
INSERT INTO replanishment VALUES("SD07003LR09","2","12");
INSERT INTO replanishment VALUES("SD07003LR10","2","12");
INSERT INTO replanishment VALUES("SD07003LR11","1","12");
INSERT INTO replanishment VALUES("SD07004MR08","2","12");
INSERT INTO replanishment VALUES("SD07004MR09","2","12");
INSERT INTO replanishment VALUES("SD07004MR10","2","12");
INSERT INTO replanishment VALUES("SD07004MR11","1","12");
INSERT INTO replanishment VALUES("SD10001BL08","2","12");
INSERT INTO replanishment VALUES("SD10001BL09","2","12");
INSERT INTO replanishment VALUES("SD10001BL10","2","12");
INSERT INTO replanishment VALUES("SD10001BL11","1","12");
INSERT INTO replanishment VALUES("SD10002BL08","2","12");
INSERT INTO replanishment VALUES("SD10002BL09","2","12");
INSERT INTO replanishment VALUES("SD10002BL10","2","12");
INSERT INTO replanishment VALUES("SD10002BL11","1","12");
INSERT INTO replanishment VALUES("SD10003BL08","2","12");
INSERT INTO replanishment VALUES("SD10003BL09","2","12");
INSERT INTO replanishment VALUES("SD10003BL10","2","12");
INSERT INTO replanishment VALUES("SD10003BL11","1","12");
INSERT INTO replanishment VALUES("SD10004BL08","2","12");
INSERT INTO replanishment VALUES("SD10004BL09","2","12");
INSERT INTO replanishment VALUES("SD10004BL10","2","12");
INSERT INTO replanishment VALUES("SD10004BL11","1","12");
INSERT INTO replanishment VALUES("SD10005OW08","2","12");
INSERT INTO replanishment VALUES("SD10005OW09","2","12");
INSERT INTO replanishment VALUES("SD10005OW10","2","12");
INSERT INTO replanishment VALUES("SD10005OW11","1","12");
INSERT INTO replanishment VALUES("SD10006GO08","2","12");
INSERT INTO replanishment VALUES("SD10006GO09","2","12");
INSERT INTO replanishment VALUES("SD10006GO10","2","12");
INSERT INTO replanishment VALUES("SD10006GO11","1","12");
INSERT INTO replanishment VALUES("SD10007BL08","2","12");
INSERT INTO replanishment VALUES("SD10007BL09","2","12");
INSERT INTO replanishment VALUES("SD10007BL10","2","12");
INSERT INTO replanishment VALUES("SD10007BL11","1","12");
INSERT INTO replanishment VALUES("SD10008BU08","2","12");
INSERT INTO replanishment VALUES("SD10008BU09","2","12");
INSERT INTO replanishment VALUES("SD10008BU10","2","12");
INSERT INTO replanishment VALUES("SD10008BU11","1","12");
INSERT INTO replanishment VALUES("SD10009MR08","2","12");
INSERT INTO replanishment VALUES("SD10009MR09","2","12");
INSERT INTO replanishment VALUES("SD10009MR10","2","12");
INSERT INTO replanishment VALUES("SD10009MR11","1","12");
INSERT INTO replanishment VALUES("SD11001GO08","2","12");
INSERT INTO replanishment VALUES("SD11001GO09","2","12");
INSERT INTO replanishment VALUES("SD11001GO10","2","12");
INSERT INTO replanishment VALUES("SD11001GO11","1","12");
INSERT INTO replanishment VALUES("SD11002RD08","2","12");
INSERT INTO replanishment VALUES("SD11002RD09","2","12");
INSERT INTO replanishment VALUES("SD11002RD10","2","12");
INSERT INTO replanishment VALUES("SD11002RD11","1","12");
INSERT INTO replanishment VALUES("SD11003WH08","2","12");
INSERT INTO replanishment VALUES("SD11003WH09","2","12");
INSERT INTO replanishment VALUES("SD11003WH10","2","12");
INSERT INTO replanishment VALUES("SD11003WH11","1","12");
INSERT INTO replanishment VALUES("SD12001BL08","2","12");
INSERT INTO replanishment VALUES("SD12001BL09","2","12");
INSERT INTO replanishment VALUES("SD12001BL10","2","12");
INSERT INTO replanishment VALUES("SD12001BL11","1","12");
INSERT INTO replanishment VALUES("SD12002BU08","2","12");
INSERT INTO replanishment VALUES("SD12002BU09","2","12");
INSERT INTO replanishment VALUES("SD12002BU10","2","12");
INSERT INTO replanishment VALUES("SD12002BU11","1","12");
INSERT INTO replanishment VALUES("SD12003BL08","2","12");
INSERT INTO replanishment VALUES("SD12003BL09","2","12");
INSERT INTO replanishment VALUES("SD12003BL10","2","12");
INSERT INTO replanishment VALUES("SD12003BL11","1","12");
INSERT INTO replanishment VALUES("SD12004BU08","2","12");
INSERT INTO replanishment VALUES("SD12004BU09","2","12");
INSERT INTO replanishment VALUES("SD12004BU10","2","12");
INSERT INTO replanishment VALUES("SD12004BU11","1","12");
INSERT INTO replanishment VALUES("SD12005BL08","2","12");
INSERT INTO replanishment VALUES("SD12005BL09","2","12");
INSERT INTO replanishment VALUES("SD12005BL10","2","12");
INSERT INTO replanishment VALUES("SD12005BL11","1","12");
INSERT INTO replanishment VALUES("SG00001PU08","2","12");
INSERT INTO replanishment VALUES("SG00001PU09","2","12");
INSERT INTO replanishment VALUES("SG00001PU10","2","12");
INSERT INTO replanishment VALUES("SG00001PU11","1","12");
INSERT INTO replanishment VALUES("SG00002OW08","2","12");
INSERT INTO replanishment VALUES("SG00002OW09","2","12");
INSERT INTO replanishment VALUES("SG00002OW10","2","12");
INSERT INTO replanishment VALUES("SG00002OW11","1","12");
INSERT INTO replanishment VALUES("SG00003BL08","2","12");
INSERT INTO replanishment VALUES("SG00003BL09","2","12");
INSERT INTO replanishment VALUES("SG00003BL10","2","12");
INSERT INTO replanishment VALUES("SG00003BL11","1","12");
INSERT INTO replanishment VALUES("SG00004SN08","2","12");
INSERT INTO replanishment VALUES("SG00004SN09","2","12");
INSERT INTO replanishment VALUES("SG00004SN10","2","12");
INSERT INTO replanishment VALUES("SG00004SN11","1","12");
INSERT INTO replanishment VALUES("SG00005BU08","2","12");
INSERT INTO replanishment VALUES("SG00005BU09","2","12");
INSERT INTO replanishment VALUES("SG00005BU10","2","12");
INSERT INTO replanishment VALUES("SG00005BU11","1","12");
INSERT INTO replanishment VALUES("SG00006GO08","2","12");
INSERT INTO replanishment VALUES("SG00006GO09","2","12");
INSERT INTO replanishment VALUES("SG00006GO10","2","12");
INSERT INTO replanishment VALUES("SG00006GO11","1","12");
INSERT INTO replanishment VALUES("SG00007BR08","2","12");
INSERT INTO replanishment VALUES("SG00007BR09","2","12");
INSERT INTO replanishment VALUES("SG00007BR10","2","12");
INSERT INTO replanishment VALUES("SG00007BR11","1","12");
INSERT INTO replanishment VALUES("SG00008BU08","2","12");
INSERT INTO replanishment VALUES("SG00008BU09","2","12");
INSERT INTO replanishment VALUES("SG00008BU10","2","12");
INSERT INTO replanishment VALUES("SG00008BU11","1","12");
INSERT INTO replanishment VALUES("SG00009BU08","2","12");
INSERT INTO replanishment VALUES("SG00009BU09","2","12");
INSERT INTO replanishment VALUES("SG00009BU10","2","12");
INSERT INTO replanishment VALUES("SG00009BU11","1","12");
INSERT INTO replanishment VALUES("SG00010MS08","2","12");
INSERT INTO replanishment VALUES("SG00010MS09","2","12");
INSERT INTO replanishment VALUES("SG00010MS10","2","12");
INSERT INTO replanishment VALUES("SG00010MS11","1","12");
INSERT INTO replanishment VALUES("SG00011BR08","2","12");
INSERT INTO replanishment VALUES("SG00011BR09","2","12");
INSERT INTO replanishment VALUES("SG00011BR10","2","12");
INSERT INTO replanishment VALUES("SG00011BR11","1","12");
INSERT INTO replanishment VALUES("SG00012KH08","2","12");
INSERT INTO replanishment VALUES("SG00012KH09","2","12");
INSERT INTO replanishment VALUES("SG00012KH10","2","12");
INSERT INTO replanishment VALUES("SG00012KH11","1","12");
INSERT INTO replanishment VALUES("SG00013MR08","2","12");
INSERT INTO replanishment VALUES("SG00013MR09","2","12");
INSERT INTO replanishment VALUES("SG00013MR10","2","12");
INSERT INTO replanishment VALUES("SG00013MR11","1","12");
INSERT INTO replanishment VALUES("SG00014BL08","2","12");
INSERT INTO replanishment VALUES("SG00014BL09","2","12");
INSERT INTO replanishment VALUES("SG00014BL10","2","12");
INSERT INTO replanishment VALUES("SG00014BL11","1","12");
INSERT INTO replanishment VALUES("SG00015SB08","2","12");
INSERT INTO replanishment VALUES("SG00015SB09","2","12");
INSERT INTO replanishment VALUES("SG00015SB10","2","12");
INSERT INTO replanishment VALUES("SG00015SB11","1","12");
INSERT INTO replanishment VALUES("SG00016WH08","2","12");
INSERT INTO replanishment VALUES("SG00016WH09","2","12");
INSERT INTO replanishment VALUES("SG00016WH10","2","12");
INSERT INTO replanishment VALUES("SG00016WH11","1","12");
INSERT INTO replanishment VALUES("SG00017WH08","2","12");
INSERT INTO replanishment VALUES("SG00017WH09","2","12");
INSERT INTO replanishment VALUES("SG00017WH10","2","12");
INSERT INTO replanishment VALUES("SG00017WH11","1","12");
INSERT INTO replanishment VALUES("SG00018WH08","2","12");
INSERT INTO replanishment VALUES("SG00018WH09","2","12");
INSERT INTO replanishment VALUES("SG00018WH10","2","12");
INSERT INTO replanishment VALUES("SG00018WH11","1","12");
INSERT INTO replanishment VALUES("SG00019CB08","2","12");
INSERT INTO replanishment VALUES("SG00019CB09","2","12");
INSERT INTO replanishment VALUES("SG00019CB10","2","12");
INSERT INTO replanishment VALUES("SG00019CB11","1","12");
INSERT INTO replanishment VALUES("SG00020MR08","2","12");
INSERT INTO replanishment VALUES("SG00020MR09","2","12");
INSERT INTO replanishment VALUES("SG00020MR10","2","12");
INSERT INTO replanishment VALUES("SG00020MR11","1","12");
INSERT INTO replanishment VALUES("SG00021BL08","2","12");
INSERT INTO replanishment VALUES("SG00021BL09","2","12");
INSERT INTO replanishment VALUES("SG00021BL10","2","12");
INSERT INTO replanishment VALUES("SG00021BL11","1","12");
INSERT INTO replanishment VALUES("SG00022BR08","2","12");
INSERT INTO replanishment VALUES("SG00022BR09","2","12");
INSERT INTO replanishment VALUES("SG00022BR10","2","12");
INSERT INTO replanishment VALUES("SG00022BR11","1","12");
INSERT INTO replanishment VALUES("SG02097GO08","2","12");
INSERT INTO replanishment VALUES("SG02097GO09","2","12");
INSERT INTO replanishment VALUES("SG02097GO10","2","12");
INSERT INTO replanishment VALUES("SG02097GO11","1","12");
INSERT INTO replanishment VALUES("SG03001MD08","2","12");
INSERT INTO replanishment VALUES("SG03001MD09","2","12");
INSERT INTO replanishment VALUES("SG03001MD10","2","12");
INSERT INTO replanishment VALUES("SG03001MD11","1","12");
INSERT INTO replanishment VALUES("SG03001OW08","2","12");
INSERT INTO replanishment VALUES("SG03001OW09","2","12");
INSERT INTO replanishment VALUES("SG03001OW10","2","12");
INSERT INTO replanishment VALUES("SG03001OW11","1","12");
INSERT INTO replanishment VALUES("SG03002MD08","2","12");
INSERT INTO replanishment VALUES("SG03002MD09","2","12");
INSERT INTO replanishment VALUES("SG03002MD10","2","12");
INSERT INTO replanishment VALUES("SG03002MD11","1","12");
INSERT INTO replanishment VALUES("SG03002OW08","2","12");
INSERT INTO replanishment VALUES("SG03002OW09","2","12");
INSERT INTO replanishment VALUES("SG03002OW10","2","12");
INSERT INTO replanishment VALUES("SG03002OW11","1","12");
INSERT INTO replanishment VALUES("SG04001SG08","2","12");
INSERT INTO replanishment VALUES("SG04001SG09","2","12");
INSERT INTO replanishment VALUES("SG04001SG10","2","12");
INSERT INTO replanishment VALUES("SG04001SG11","1","12");
INSERT INTO replanishment VALUES("SG04002MR08","2","12");
INSERT INTO replanishment VALUES("SG04002MR09","2","12");
INSERT INTO replanishment VALUES("SG04002MR10","2","12");
INSERT INTO replanishment VALUES("SG04002MR11","1","12");
INSERT INTO replanishment VALUES("SG04002MV08","2","12");
INSERT INTO replanishment VALUES("SG04002MV09","2","12");
INSERT INTO replanishment VALUES("SG04002MV10","2","12");
INSERT INTO replanishment VALUES("SG04002MV11","1","12");
INSERT INTO replanishment VALUES("SG04003MR08","2","12");
INSERT INTO replanishment VALUES("SG04003MR09","2","12");
INSERT INTO replanishment VALUES("SG04003MR10","2","12");
INSERT INTO replanishment VALUES("SG04003MR11","1","12");
INSERT INTO replanishment VALUES("SG04004PK08","2","12");
INSERT INTO replanishment VALUES("SG04004PK09","2","12");
INSERT INTO replanishment VALUES("SG04004PK10","2","12");
INSERT INTO replanishment VALUES("SG04004PK11","1","12");
INSERT INTO replanishment VALUES("SG04005PR08","2","12");
INSERT INTO replanishment VALUES("SG04005PR09","2","12");
INSERT INTO replanishment VALUES("SG04005PR10","2","12");
INSERT INTO replanishment VALUES("SG04005PR11","1","12");
INSERT INTO replanishment VALUES("SK00001BR08","2","12");
INSERT INTO replanishment VALUES("SK00001BR09","2","12");
INSERT INTO replanishment VALUES("SK00001BR10","2","12");
INSERT INTO replanishment VALUES("SK00001BR11","1","12");
INSERT INTO replanishment VALUES("SK00001GR08","2","12");
INSERT INTO replanishment VALUES("SK00001GR09","2","12");
INSERT INTO replanishment VALUES("SK00001GR10","2","12");
INSERT INTO replanishment VALUES("SK00001GR11","1","12");
INSERT INTO replanishment VALUES("SK00002MU08","2","12");
INSERT INTO replanishment VALUES("SK00002MU09","2","12");
INSERT INTO replanishment VALUES("SK00002MU10","2","12");
INSERT INTO replanishment VALUES("SK00002MU11","1","12");
INSERT INTO replanishment VALUES("SK00003BL08","2","12");
INSERT INTO replanishment VALUES("SK00003BL09","2","12");
INSERT INTO replanishment VALUES("SK00003BL10","2","12");
INSERT INTO replanishment VALUES("SK00003BL11","1","12");
INSERT INTO replanishment VALUES("SK00003WH08","2","12");
INSERT INTO replanishment VALUES("SK00003WH09","2","12");
INSERT INTO replanishment VALUES("SK00003WH10","2","12");
INSERT INTO replanishment VALUES("SK00003WH11","1","12");
INSERT INTO replanishment VALUES("SK00004BL08","2","12");
INSERT INTO replanishment VALUES("SK00004BL09","2","12");
INSERT INTO replanishment VALUES("SK00004BL10","2","12");
INSERT INTO replanishment VALUES("SK00004BL11","1","12");
INSERT INTO replanishment VALUES("SK00005WH08","2","12");
INSERT INTO replanishment VALUES("SK00005WH09","2","12");
INSERT INTO replanishment VALUES("SK00005WH10","2","12");
INSERT INTO replanishment VALUES("SK00005WH11","1","12");
INSERT INTO replanishment VALUES("SK00006GR08","2","12");
INSERT INTO replanishment VALUES("SK00006GR09","2","12");
INSERT INTO replanishment VALUES("SK00006GR10","2","12");
INSERT INTO replanishment VALUES("SK00006GR11","1","12");
INSERT INTO replanishment VALUES("SK00006GY08","2","12");
INSERT INTO replanishment VALUES("SK00006GY09","2","12");
INSERT INTO replanishment VALUES("SK00006GY10","2","12");
INSERT INTO replanishment VALUES("SK00006GY11","1","12");
INSERT INTO replanishment VALUES("SK00007GY08","2","12");
INSERT INTO replanishment VALUES("SK00007GY09","2","12");
INSERT INTO replanishment VALUES("SK00007GY10","2","12");
INSERT INTO replanishment VALUES("SK00007GY11","1","12");
INSERT INTO replanishment VALUES("SK00008PL08","2","12");
INSERT INTO replanishment VALUES("SK00008PL09","2","12");
INSERT INTO replanishment VALUES("SK00008PL10","2","12");
INSERT INTO replanishment VALUES("SK00008PL11","1","12");
INSERT INTO replanishment VALUES("SK00009BR08","2","12");
INSERT INTO replanishment VALUES("SK00009BR09","2","12");
INSERT INTO replanishment VALUES("SK00009BR10","2","12");
INSERT INTO replanishment VALUES("SK00009BR11","1","12");
INSERT INTO replanishment VALUES("SK00010GR08","2","12");
INSERT INTO replanishment VALUES("SK00010GR09","2","12");
INSERT INTO replanishment VALUES("SK00010GR10","2","12");
INSERT INTO replanishment VALUES("SK00010GR11","1","12");
INSERT INTO replanishment VALUES("SK00011DG08","2","12");
INSERT INTO replanishment VALUES("SK00011DG09","2","12");
INSERT INTO replanishment VALUES("SK00011DG10","2","12");
INSERT INTO replanishment VALUES("SK00011DG11","1","12");
INSERT INTO replanishment VALUES("SK00011LG08","2","12");
INSERT INTO replanishment VALUES("SK00011LG09","2","12");
INSERT INTO replanishment VALUES("SK00011LG10","2","12");
INSERT INTO replanishment VALUES("SK00011LG11","1","12");
INSERT INTO replanishment VALUES("SK00012BR08","2","12");
INSERT INTO replanishment VALUES("SK00012BR09","2","12");
INSERT INTO replanishment VALUES("SK00012BR10","2","12");
INSERT INTO replanishment VALUES("SK00012BR11","1","12");
INSERT INTO replanishment VALUES("SK00012GY08","2","12");
INSERT INTO replanishment VALUES("SK00012GY09","2","12");
INSERT INTO replanishment VALUES("SK00012GY10","2","12");
INSERT INTO replanishment VALUES("SK00012GY11","1","12");
INSERT INTO replanishment VALUES("SK00013MH08","2","12");
INSERT INTO replanishment VALUES("SK00013MH09","2","12");
INSERT INTO replanishment VALUES("SK00013MH10","2","12");
INSERT INTO replanishment VALUES("SK00013MH11","1","12");
INSERT INTO replanishment VALUES("SK00017BL08","2","12");
INSERT INTO replanishment VALUES("SK00017BL09","2","12");
INSERT INTO replanishment VALUES("SK00017BL10","2","12");
INSERT INTO replanishment VALUES("SK00017BL11","1","12");
INSERT INTO replanishment VALUES("SK00017BU08","2","12");
INSERT INTO replanishment VALUES("SK00017BU09","2","12");
INSERT INTO replanishment VALUES("SK00017BU10","2","12");
INSERT INTO replanishment VALUES("SK00017BU11","1","12");
INSERT INTO replanishment VALUES("SK00018BR08","2","12");
INSERT INTO replanishment VALUES("SK00018BR09","2","12");
INSERT INTO replanishment VALUES("SK00018BR10","2","12");
INSERT INTO replanishment VALUES("SK00018BR11","1","12");
INSERT INTO replanishment VALUES("SK00018BU08","2","12");
INSERT INTO replanishment VALUES("SK00018BU09","2","12");
INSERT INTO replanishment VALUES("SK00018BU10","2","12");
INSERT INTO replanishment VALUES("SK00018BU11","1","12");
INSERT INTO replanishment VALUES("SK00018GB08","2","12");
INSERT INTO replanishment VALUES("SK00018GB09","2","12");
INSERT INTO replanishment VALUES("SK00018GB10","2","12");
INSERT INTO replanishment VALUES("SK00018GB11","1","12");
INSERT INTO replanishment VALUES("SK00019BR08","2","12");
INSERT INTO replanishment VALUES("SK00019BR09","2","12");
INSERT INTO replanishment VALUES("SK00019BR10","2","12");
INSERT INTO replanishment VALUES("SK00019BR11","1","12");
INSERT INTO replanishment VALUES("SK00020PR08","2","12");
INSERT INTO replanishment VALUES("SK00020PR09","2","12");
INSERT INTO replanishment VALUES("SK00020PR10","2","12");
INSERT INTO replanishment VALUES("SK00020PR11","1","12");
INSERT INTO replanishment VALUES("SK00021WH08","2","12");
INSERT INTO replanishment VALUES("SK00021WH09","2","12");
INSERT INTO replanishment VALUES("SK00021WH10","2","12");
INSERT INTO replanishment VALUES("SK00021WH11","1","12");
INSERT INTO replanishment VALUES("SK00022GY08","2","12");
INSERT INTO replanishment VALUES("SK00022GY09","2","12");
INSERT INTO replanishment VALUES("SK00022GY10","2","12");
INSERT INTO replanishment VALUES("SK00022GY11","1","12");
INSERT INTO replanishment VALUES("SK00022MR08","2","12");
INSERT INTO replanishment VALUES("SK00022MR09","2","12");
INSERT INTO replanishment VALUES("SK00022MR10","2","12");
INSERT INTO replanishment VALUES("SK00022MR11","1","12");
INSERT INTO replanishment VALUES("SK00023BU08","2","12");
INSERT INTO replanishment VALUES("SK00023BU09","2","12");
INSERT INTO replanishment VALUES("SK00023BU10","2","12");
INSERT INTO replanishment VALUES("SK00023BU11","1","12");
INSERT INTO replanishment VALUES("SK00023GR08","2","12");
INSERT INTO replanishment VALUES("SK00023GR09","2","12");
INSERT INTO replanishment VALUES("SK00023GR10","2","12");
INSERT INTO replanishment VALUES("SK00023GR11","1","12");
INSERT INTO replanishment VALUES("SK00025BU08","2","12");
INSERT INTO replanishment VALUES("SK00025BU09","2","12");
INSERT INTO replanishment VALUES("SK00025BU10","2","12");
INSERT INTO replanishment VALUES("SK00025BU11","1","12");
INSERT INTO replanishment VALUES("SK00025MV08","2","12");
INSERT INTO replanishment VALUES("SK00025MV09","2","12");
INSERT INTO replanishment VALUES("SK00025MV10","2","12");
INSERT INTO replanishment VALUES("SK00025MV11","1","12");
INSERT INTO replanishment VALUES("SK00025PU08","2","12");
INSERT INTO replanishment VALUES("SK00025PU09","2","12");
INSERT INTO replanishment VALUES("SK00025PU10","2","12");
INSERT INTO replanishment VALUES("SK00025PU11","1","12");
INSERT INTO replanishment VALUES("SK00026BD08","2","12");
INSERT INTO replanishment VALUES("SK00026BD09","2","12");
INSERT INTO replanishment VALUES("SK00026BD10","2","12");
INSERT INTO replanishment VALUES("SK00026BD11","1","12");
INSERT INTO replanishment VALUES("SK00026FE08","2","12");
INSERT INTO replanishment VALUES("SK00026FE09","2","12");
INSERT INTO replanishment VALUES("SK00026FE10","2","12");
INSERT INTO replanishment VALUES("SK00026FE11","1","12");
INSERT INTO replanishment VALUES("SK00026NE08","2","12");
INSERT INTO replanishment VALUES("SK00026NE09","2","12");
INSERT INTO replanishment VALUES("SK00026NE10","2","12");
INSERT INTO replanishment VALUES("SK00026NE11","1","12");
INSERT INTO replanishment VALUES("SK00027CR08","2","12");
INSERT INTO replanishment VALUES("SK00027CR09","2","12");
INSERT INTO replanishment VALUES("SK00027CR10","2","12");
INSERT INTO replanishment VALUES("SK00027CR11","1","12");
INSERT INTO replanishment VALUES("SK00027FE08","2","12");
INSERT INTO replanishment VALUES("SK00027FE09","2","12");
INSERT INTO replanishment VALUES("SK00027FE10","2","12");
INSERT INTO replanishment VALUES("SK00027FE11","1","12");
INSERT INTO replanishment VALUES("SK00027LV08","2","12");
INSERT INTO replanishment VALUES("SK00027LV09","2","12");
INSERT INTO replanishment VALUES("SK00027LV10","2","12");
INSERT INTO replanishment VALUES("SK00027LV11","1","12");
INSERT INTO replanishment VALUES("SK00030BU08","2","12");
INSERT INTO replanishment VALUES("SK00030BU09","2","12");
INSERT INTO replanishment VALUES("SK00030BU10","2","12");
INSERT INTO replanishment VALUES("SK00030BU11","1","12");
INSERT INTO replanishment VALUES("SK00033BU08","2","12");
INSERT INTO replanishment VALUES("SK00033BU09","2","12");
INSERT INTO replanishment VALUES("SK00033BU10","2","12");
INSERT INTO replanishment VALUES("SK00033BU11","1","12");
INSERT INTO replanishment VALUES("SK00033WH08","2","12");
INSERT INTO replanishment VALUES("SK00033WH09","2","12");
INSERT INTO replanishment VALUES("SK00033WH10","2","12");
INSERT INTO replanishment VALUES("SK00033WH11","1","12");
INSERT INTO replanishment VALUES("SK00034WH08","2","12");
INSERT INTO replanishment VALUES("SK00034WH09","2","12");
INSERT INTO replanishment VALUES("SK00034WH10","2","12");
INSERT INTO replanishment VALUES("SK00034WH11","1","12");
INSERT INTO replanishment VALUES("SK00035BL08","2","12");
INSERT INTO replanishment VALUES("SK00035BL09","2","12");
INSERT INTO replanishment VALUES("SK00035BL10","2","12");
INSERT INTO replanishment VALUES("SK00035BL11","1","12");
INSERT INTO replanishment VALUES("SK00036GO08","2","12");
INSERT INTO replanishment VALUES("SK00036GO09","2","12");
INSERT INTO replanishment VALUES("SK00036GO10","2","12");
INSERT INTO replanishment VALUES("SK00036GO11","1","12");
INSERT INTO replanishment VALUES("SK00036GR08","2","12");
INSERT INTO replanishment VALUES("SK00036GR09","2","12");
INSERT INTO replanishment VALUES("SK00036GR10","2","12");
INSERT INTO replanishment VALUES("SK00036GR11","1","12");
INSERT INTO replanishment VALUES("SK00036GY08","2","12");
INSERT INTO replanishment VALUES("SK00036GY09","2","12");
INSERT INTO replanishment VALUES("SK00036GY10","2","12");
INSERT INTO replanishment VALUES("SK00036GY11","1","12");
INSERT INTO replanishment VALUES("SK00037BL08","2","12");
INSERT INTO replanishment VALUES("SK00037BL09","2","12");
INSERT INTO replanishment VALUES("SK00037BL10","2","12");
INSERT INTO replanishment VALUES("SK00037BL11","1","12");
INSERT INTO replanishment VALUES("SK00038GO08","2","12");
INSERT INTO replanishment VALUES("SK00038GO09","2","12");
INSERT INTO replanishment VALUES("SK00038GO10","2","12");
INSERT INTO replanishment VALUES("SK00038GO11","1","12");
INSERT INTO replanishment VALUES("SK00039GY08","2","12");
INSERT INTO replanishment VALUES("SK00039GY09","2","12");
INSERT INTO replanishment VALUES("SK00039GY10","2","12");
INSERT INTO replanishment VALUES("SK00039GY11","1","12");
INSERT INTO replanishment VALUES("SK00040GR08","2","12");
INSERT INTO replanishment VALUES("SK00040GR09","2","12");
INSERT INTO replanishment VALUES("SK00040GR10","2","12");
INSERT INTO replanishment VALUES("SK00040GR11","1","12");
INSERT INTO replanishment VALUES("SK00041PU08","2","12");
INSERT INTO replanishment VALUES("SK00041PU09","2","12");
INSERT INTO replanishment VALUES("SK00041PU10","2","12");
INSERT INTO replanishment VALUES("SK00041PU11","1","12");
INSERT INTO replanishment VALUES("SK00042BU08","2","12");
INSERT INTO replanishment VALUES("SK00042BU09","2","12");
INSERT INTO replanishment VALUES("SK00042BU10","2","12");
INSERT INTO replanishment VALUES("SK00042BU11","1","12");
INSERT INTO replanishment VALUES("SK00049GY08","2","12");
INSERT INTO replanishment VALUES("SK00049GY09","2","12");
INSERT INTO replanishment VALUES("SK00049GY10","2","12");
INSERT INTO replanishment VALUES("SK00049GY11","1","12");
INSERT INTO replanishment VALUES("SK00055OR08","2","12");
INSERT INTO replanishment VALUES("SK00055OR09","2","12");
INSERT INTO replanishment VALUES("SK00055OR10","2","12");
INSERT INTO replanishment VALUES("SK00055OR11","1","12");
INSERT INTO replanishment VALUES("SK00056MR08","2","12");
INSERT INTO replanishment VALUES("SK00056MR09","2","12");
INSERT INTO replanishment VALUES("SK00056MR10","2","12");
INSERT INTO replanishment VALUES("SK00056MR11","1","12");
INSERT INTO replanishment VALUES("SK00059GR08","2","12");
INSERT INTO replanishment VALUES("SK00059GR09","2","12");
INSERT INTO replanishment VALUES("SK00059GR10","2","12");
INSERT INTO replanishment VALUES("SK00059GR11","1","12");
INSERT INTO replanishment VALUES("SK00060WH08","2","12");
INSERT INTO replanishment VALUES("SK00060WH09","2","12");
INSERT INTO replanishment VALUES("SK00060WH10","2","12");
INSERT INTO replanishment VALUES("SK00060WH11","1","12");
INSERT INTO replanishment VALUES("SK00062BL08","2","12");
INSERT INTO replanishment VALUES("SK00062BL09","2","12");
INSERT INTO replanishment VALUES("SK00062BL10","2","12");
INSERT INTO replanishment VALUES("SK00062BL11","1","12");
INSERT INTO replanishment VALUES("SK00063BL08","2","12");
INSERT INTO replanishment VALUES("SK00063BL09","2","12");
INSERT INTO replanishment VALUES("SK00063BL10","2","12");
INSERT INTO replanishment VALUES("SK00063BL11","1","12");
INSERT INTO replanishment VALUES("SK00064BL08","2","12");
INSERT INTO replanishment VALUES("SK00064BL09","2","12");
INSERT INTO replanishment VALUES("SK00064BL10","2","12");
INSERT INTO replanishment VALUES("SK00064BL11","1","12");
INSERT INTO replanishment VALUES("SK00070BL08","2","12");
INSERT INTO replanishment VALUES("SK00070BL09","2","12");
INSERT INTO replanishment VALUES("SK00070BL10","2","12");
INSERT INTO replanishment VALUES("SK00070BL11","1","12");
INSERT INTO replanishment VALUES("SK00071GY08","2","12");
INSERT INTO replanishment VALUES("SK00071GY09","2","12");
INSERT INTO replanishment VALUES("SK00071GY10","2","12");
INSERT INTO replanishment VALUES("SK00071GY11","1","12");
INSERT INTO replanishment VALUES("SK00072BU08","2","12");
INSERT INTO replanishment VALUES("SK00072BU09","2","12");
INSERT INTO replanishment VALUES("SK00072BU10","2","12");
INSERT INTO replanishment VALUES("SK00072BU11","1","12");
INSERT INTO replanishment VALUES("SK00073PH08","2","12");
INSERT INTO replanishment VALUES("SK00073PH09","2","12");
INSERT INTO replanishment VALUES("SK00073PH10","2","12");
INSERT INTO replanishment VALUES("SK00073PH11","1","12");
INSERT INTO replanishment VALUES("SK00074BU08","2","12");
INSERT INTO replanishment VALUES("SK00074BU09","2","12");
INSERT INTO replanishment VALUES("SK00074BU10","2","12");
INSERT INTO replanishment VALUES("SK00074BU11","1","12");
INSERT INTO replanishment VALUES("SK00075BL08","2","12");
INSERT INTO replanishment VALUES("SK00075BL09","2","12");
INSERT INTO replanishment VALUES("SK00075BL10","2","12");
INSERT INTO replanishment VALUES("SK00075BL11","1","12");
INSERT INTO replanishment VALUES("SK00076BR08","2","12");
INSERT INTO replanishment VALUES("SK00076BR09","2","12");
INSERT INTO replanishment VALUES("SK00076BR10","2","12");
INSERT INTO replanishment VALUES("SK00076BR11","1","12");
INSERT INTO replanishment VALUES("SK00077WH08","2","12");
INSERT INTO replanishment VALUES("SK00077WH09","2","12");
INSERT INTO replanishment VALUES("SK00077WH10","2","12");
INSERT INTO replanishment VALUES("SK00077WH11","1","12");
INSERT INTO replanishment VALUES("SK00079WH08","2","12");
INSERT INTO replanishment VALUES("SK00079WH09","2","12");
INSERT INTO replanishment VALUES("SK00079WH10","2","12");
INSERT INTO replanishment VALUES("SK00079WH11","1","12");
INSERT INTO replanishment VALUES("SK00082PU08","2","12");
INSERT INTO replanishment VALUES("SK00082PU09","2","12");
INSERT INTO replanishment VALUES("SK00082PU10","2","12");
INSERT INTO replanishment VALUES("SK00082PU11","1","12");
INSERT INTO replanishment VALUES("SK00083LG08","2","12");
INSERT INTO replanishment VALUES("SK00083LG09","2","12");
INSERT INTO replanishment VALUES("SK00083LG10","2","12");
INSERT INTO replanishment VALUES("SK00083LG11","1","12");
INSERT INTO replanishment VALUES("SK00086GR08","2","12");
INSERT INTO replanishment VALUES("SK00086GR09","2","12");
INSERT INTO replanishment VALUES("SK00086GR10","2","12");
INSERT INTO replanishment VALUES("SK00086GR11","1","12");
INSERT INTO replanishment VALUES("SK00087OR08","2","12");
INSERT INTO replanishment VALUES("SK00087OR09","2","12");
INSERT INTO replanishment VALUES("SK00087OR10","2","12");
INSERT INTO replanishment VALUES("SK00087OR11","1","12");
INSERT INTO replanishment VALUES("SK00088PR08","2","12");
INSERT INTO replanishment VALUES("SK00088PR09","2","12");
INSERT INTO replanishment VALUES("SK00088PR10","2","12");
INSERT INTO replanishment VALUES("SK00088PR11","1","12");
INSERT INTO replanishment VALUES("SK00089WH08","2","12");
INSERT INTO replanishment VALUES("SK00089WH09","2","12");
INSERT INTO replanishment VALUES("SK00089WH10","2","12");
INSERT INTO replanishment VALUES("SK00089WH11","1","12");
INSERT INTO replanishment VALUES("SK00090BL08","2","12");
INSERT INTO replanishment VALUES("SK00090BL09","2","12");
INSERT INTO replanishment VALUES("SK00090BL10","2","12");
INSERT INTO replanishment VALUES("SK00090BL11","1","12");
INSERT INTO replanishment VALUES("SK00092OF08","2","12");
INSERT INTO replanishment VALUES("SK00092OF09","2","12");
INSERT INTO replanishment VALUES("SK00092OF10","2","12");
INSERT INTO replanishment VALUES("SK00092OF11","1","12");
INSERT INTO replanishment VALUES("SK00093WH08","2","12");
INSERT INTO replanishment VALUES("SK00093WH09","2","12");
INSERT INTO replanishment VALUES("SK00093WH10","2","12");
INSERT INTO replanishment VALUES("SK00093WH11","1","12");
INSERT INTO replanishment VALUES("SK00094BR08","2","12");
INSERT INTO replanishment VALUES("SK00094BR09","2","12");
INSERT INTO replanishment VALUES("SK00094BR10","2","12");
INSERT INTO replanishment VALUES("SK00094BR11","1","12");
INSERT INTO replanishment VALUES("SK00095WH08","2","12");
INSERT INTO replanishment VALUES("SK00095WH09","2","12");
INSERT INTO replanishment VALUES("SK00095WH10","2","12");
INSERT INTO replanishment VALUES("SK00095WH11","1","12");
INSERT INTO replanishment VALUES("SK00096WH08","2","12");
INSERT INTO replanishment VALUES("SK00096WH09","2","12");
INSERT INTO replanishment VALUES("SK00096WH10","2","12");
INSERT INTO replanishment VALUES("SK00096WH11","1","12");
INSERT INTO replanishment VALUES("SK00097RS08","2","12");
INSERT INTO replanishment VALUES("SK00097RS09","2","12");
INSERT INTO replanishment VALUES("SK00097RS10","2","12");
INSERT INTO replanishment VALUES("SK00097RS11","1","12");
INSERT INTO replanishment VALUES("SK00098DB08","2","12");
INSERT INTO replanishment VALUES("SK00098DB09","2","12");
INSERT INTO replanishment VALUES("SK00098DB10","2","12");
INSERT INTO replanishment VALUES("SK00098DB11","1","12");
INSERT INTO replanishment VALUES("SK00099OW08","2","12");
INSERT INTO replanishment VALUES("SK00099OW09","2","12");
INSERT INTO replanishment VALUES("SK00099OW10","2","12");
INSERT INTO replanishment VALUES("SK00099OW11","1","12");
INSERT INTO replanishment VALUES("SK00100GR08","2","12");
INSERT INTO replanishment VALUES("SK00100GR09","2","12");
INSERT INTO replanishment VALUES("SK00100GR10","2","12");
INSERT INTO replanishment VALUES("SK00100GR11","1","12");
INSERT INTO replanishment VALUES("SK00101LG08","2","12");
INSERT INTO replanishment VALUES("SK00101LG09","2","12");
INSERT INTO replanishment VALUES("SK00101LG10","2","12");
INSERT INTO replanishment VALUES("SK00101LG11","1","12");
INSERT INTO replanishment VALUES("SK00102SB08","2","12");
INSERT INTO replanishment VALUES("SK00102SB09","2","12");
INSERT INTO replanishment VALUES("SK00102SB10","2","12");
INSERT INTO replanishment VALUES("SK00102SB11","1","12");
INSERT INTO replanishment VALUES("SK00103FN08","2","12");
INSERT INTO replanishment VALUES("SK00103FN09","2","12");
INSERT INTO replanishment VALUES("SK00103FN10","2","12");
INSERT INTO replanishment VALUES("SK00103FN11","1","12");
INSERT INTO replanishment VALUES("SK00105CB08","2","12");
INSERT INTO replanishment VALUES("SK00105CB09","2","12");
INSERT INTO replanishment VALUES("SK00105CB10","2","12");
INSERT INTO replanishment VALUES("SK00105CB11","1","12");
INSERT INTO replanishment VALUES("SK00107NB08","2","12");
INSERT INTO replanishment VALUES("SK00107NB09","2","12");
INSERT INTO replanishment VALUES("SK00107NB10","2","12");
INSERT INTO replanishment VALUES("SK00107NB11","1","12");
INSERT INTO replanishment VALUES("SK00109WH08","2","12");
INSERT INTO replanishment VALUES("SK00109WH09","2","12");
INSERT INTO replanishment VALUES("SK00109WH10","2","12");
INSERT INTO replanishment VALUES("SK00109WH11","1","12");
INSERT INTO replanishment VALUES("SK00110GO08","2","12");
INSERT INTO replanishment VALUES("SK00110GO09","2","12");
INSERT INTO replanishment VALUES("SK00110GO10","2","12");
INSERT INTO replanishment VALUES("SK00110GO11","1","12");
INSERT INTO replanishment VALUES("SK00112PU08","2","12");
INSERT INTO replanishment VALUES("SK00112PU09","2","12");
INSERT INTO replanishment VALUES("SK00112PU10","2","12");
INSERT INTO replanishment VALUES("SK00112PU11","1","12");
INSERT INTO replanishment VALUES("SK00113GY08","2","12");
INSERT INTO replanishment VALUES("SK00113GY09","2","12");
INSERT INTO replanishment VALUES("SK00113GY10","2","12");
INSERT INTO replanishment VALUES("SK00113GY11","1","12");
INSERT INTO replanishment VALUES("SK00114BR08","2","12");
INSERT INTO replanishment VALUES("SK00114BR09","2","12");
INSERT INTO replanishment VALUES("SK00114BR10","2","12");
INSERT INTO replanishment VALUES("SK00114BR11","1","12");
INSERT INTO replanishment VALUES("SK00115BL08","2","12");
INSERT INTO replanishment VALUES("SK00115BL09","2","12");
INSERT INTO replanishment VALUES("SK00115BL10","2","12");
INSERT INTO replanishment VALUES("SK00115BL11","1","12");
INSERT INTO replanishment VALUES("SK00116GY08","2","12");
INSERT INTO replanishment VALUES("SK00116GY09","2","12");
INSERT INTO replanishment VALUES("SK00116GY10","2","12");
INSERT INTO replanishment VALUES("SK00116GY11","1","12");
INSERT INTO replanishment VALUES("SK00117BL08","2","12");
INSERT INTO replanishment VALUES("SK00117BL09","2","12");
INSERT INTO replanishment VALUES("SK00117BL10","2","12");
INSERT INTO replanishment VALUES("SK00117BL11","1","12");
INSERT INTO replanishment VALUES("SK00118BL08","2","12");
INSERT INTO replanishment VALUES("SK00118BL09","2","12");
INSERT INTO replanishment VALUES("SK00118BL10","2","12");
INSERT INTO replanishment VALUES("SK00118BL11","1","12");
INSERT INTO replanishment VALUES("SK00119BL08","2","12");
INSERT INTO replanishment VALUES("SK00119BL09","2","12");
INSERT INTO replanishment VALUES("SK00119BL10","2","12");
INSERT INTO replanishment VALUES("SK00119BL11","1","12");
INSERT INTO replanishment VALUES("SK00120MR08","2","12");
INSERT INTO replanishment VALUES("SK00120MR09","2","12");
INSERT INTO replanishment VALUES("SK00120MR10","2","12");
INSERT INTO replanishment VALUES("SK00120MR11","1","12");
INSERT INTO replanishment VALUES("SK00121BL08","2","12");
INSERT INTO replanishment VALUES("SK00121BL09","2","12");
INSERT INTO replanishment VALUES("SK00121BL10","2","12");
INSERT INTO replanishment VALUES("SK00121BL11","1","12");
INSERT INTO replanishment VALUES("SK00122WH08","0","12");
INSERT INTO replanishment VALUES("SK00122WH09","0","12");
INSERT INTO replanishment VALUES("SK00122WH10","0","12");
INSERT INTO replanishment VALUES("SK00122WH11","0","12");
INSERT INTO replanishment VALUES("SD03001BL08","2","05");
INSERT INTO replanishment VALUES("SD03001BL09","2","05");
INSERT INTO replanishment VALUES("SD03001BL10","2","05");
INSERT INTO replanishment VALUES("SD03001BL11","1","05");
INSERT INTO replanishment VALUES("SD03002BL08","2","05");
INSERT INTO replanishment VALUES("SD03002BL09","2","05");
INSERT INTO replanishment VALUES("SD03002BL10","2","05");
INSERT INTO replanishment VALUES("SD03002BL11","1","05");
INSERT INTO replanishment VALUES("SD03003BL08","2","05");
INSERT INTO replanishment VALUES("SD03003BL09","2","05");
INSERT INTO replanishment VALUES("SD03003BL10","2","05");
INSERT INTO replanishment VALUES("SD03003BL11","1","05");
INSERT INTO replanishment VALUES("SD03004BL08","2","05");
INSERT INTO replanishment VALUES("SD03004BL09","2","05");
INSERT INTO replanishment VALUES("SD03004BL10","2","05");
INSERT INTO replanishment VALUES("SD03004BL11","1","05");
INSERT INTO replanishment VALUES("SD03005OW08","2","05");
INSERT INTO replanishment VALUES("SD03005OW09","2","05");
INSERT INTO replanishment VALUES("SD03005OW10","2","05");
INSERT INTO replanishment VALUES("SD03005OW11","1","05");
INSERT INTO replanishment VALUES("SD03006GO08","2","05");
INSERT INTO replanishment VALUES("SD03006GO09","2","05");
INSERT INTO replanishment VALUES("SD03006GO10","2","05");
INSERT INTO replanishment VALUES("SD03006GO11","1","05");
INSERT INTO replanishment VALUES("SD03007BL08","2","05");
INSERT INTO replanishment VALUES("SD03007BL09","2","05");
INSERT INTO replanishment VALUES("SD03007BL10","2","05");
INSERT INTO replanishment VALUES("SD03007BL11","1","05");
INSERT INTO replanishment VALUES("SD04001BG08","2","05");
INSERT INTO replanishment VALUES("SD04001BG09","2","05");
INSERT INTO replanishment VALUES("SD04001BG10","2","05");
INSERT INTO replanishment VALUES("SD04001BG11","1","05");
INSERT INTO replanishment VALUES("SD04002YB08","2","05");
INSERT INTO replanishment VALUES("SD04002YB09","2","05");
INSERT INTO replanishment VALUES("SD04002YB10","2","05");
INSERT INTO replanishment VALUES("SD04002YB11","1","05");
INSERT INTO replanishment VALUES("SD07001SB08","2","05");
INSERT INTO replanishment VALUES("SD07001SB09","2","05");
INSERT INTO replanishment VALUES("SD07001SB10","2","05");
INSERT INTO replanishment VALUES("SD07001SB11","1","05");
INSERT INTO replanishment VALUES("SD07002BU08","2","05");
INSERT INTO replanishment VALUES("SD07002BU09","2","05");
INSERT INTO replanishment VALUES("SD07002BU10","2","05");
INSERT INTO replanishment VALUES("SD07002BU11","1","05");
INSERT INTO replanishment VALUES("SD07003LR08","2","05");
INSERT INTO replanishment VALUES("SD07003LR09","2","05");
INSERT INTO replanishment VALUES("SD07003LR10","2","05");
INSERT INTO replanishment VALUES("SD07003LR11","1","05");
INSERT INTO replanishment VALUES("SD07004MR08","2","05");
INSERT INTO replanishment VALUES("SD07004MR09","2","05");
INSERT INTO replanishment VALUES("SD07004MR10","2","05");
INSERT INTO replanishment VALUES("SD07004MR11","1","05");
INSERT INTO replanishment VALUES("SD10001BL08","2","05");
INSERT INTO replanishment VALUES("SD10001BL09","2","05");
INSERT INTO replanishment VALUES("SD10001BL10","2","05");
INSERT INTO replanishment VALUES("SD10001BL11","1","05");
INSERT INTO replanishment VALUES("SD10002BL08","2","05");
INSERT INTO replanishment VALUES("SD10002BL09","2","05");
INSERT INTO replanishment VALUES("SD10002BL10","2","05");
INSERT INTO replanishment VALUES("SD10002BL11","1","05");
INSERT INTO replanishment VALUES("SD10003BL08","2","05");
INSERT INTO replanishment VALUES("SD10003BL09","2","05");
INSERT INTO replanishment VALUES("SD10003BL10","2","05");
INSERT INTO replanishment VALUES("SD10003BL11","1","05");
INSERT INTO replanishment VALUES("SD10004BL08","2","05");
INSERT INTO replanishment VALUES("SD10004BL09","2","05");
INSERT INTO replanishment VALUES("SD10004BL10","2","05");
INSERT INTO replanishment VALUES("SD10004BL11","1","05");
INSERT INTO replanishment VALUES("SD10005OW08","2","05");
INSERT INTO replanishment VALUES("SD10005OW09","2","05");
INSERT INTO replanishment VALUES("SD10005OW10","2","05");
INSERT INTO replanishment VALUES("SD10005OW11","1","05");
INSERT INTO replanishment VALUES("SD10006GO08","2","05");
INSERT INTO replanishment VALUES("SD10006GO09","2","05");
INSERT INTO replanishment VALUES("SD10006GO10","2","05");
INSERT INTO replanishment VALUES("SD10006GO11","1","05");
INSERT INTO replanishment VALUES("SD10007BL08","2","05");
INSERT INTO replanishment VALUES("SD10007BL09","2","05");
INSERT INTO replanishment VALUES("SD10007BL10","2","05");
INSERT INTO replanishment VALUES("SD10007BL11","1","05");
INSERT INTO replanishment VALUES("SD10008BU08","2","05");
INSERT INTO replanishment VALUES("SD10008BU09","2","05");
INSERT INTO replanishment VALUES("SD10008BU10","2","05");
INSERT INTO replanishment VALUES("SD10008BU11","1","05");
INSERT INTO replanishment VALUES("SD10009MR08","2","05");
INSERT INTO replanishment VALUES("SD10009MR09","2","05");
INSERT INTO replanishment VALUES("SD10009MR10","2","05");
INSERT INTO replanishment VALUES("SD10009MR11","1","05");
INSERT INTO replanishment VALUES("SD11001GO08","2","05");
INSERT INTO replanishment VALUES("SD11001GO09","2","05");
INSERT INTO replanishment VALUES("SD11001GO10","2","05");
INSERT INTO replanishment VALUES("SD11001GO11","1","05");
INSERT INTO replanishment VALUES("SD11002RD08","2","05");
INSERT INTO replanishment VALUES("SD11002RD09","2","05");
INSERT INTO replanishment VALUES("SD11002RD10","2","05");
INSERT INTO replanishment VALUES("SD11002RD11","1","05");
INSERT INTO replanishment VALUES("SD11003WH08","2","05");
INSERT INTO replanishment VALUES("SD11003WH09","2","05");
INSERT INTO replanishment VALUES("SD11003WH10","2","05");
INSERT INTO replanishment VALUES("SD11003WH11","1","05");
INSERT INTO replanishment VALUES("SD12001BL08","2","05");
INSERT INTO replanishment VALUES("SD12001BL09","2","05");
INSERT INTO replanishment VALUES("SD12001BL10","2","05");
INSERT INTO replanishment VALUES("SD12001BL11","1","05");
INSERT INTO replanishment VALUES("SD12002BU08","2","05");
INSERT INTO replanishment VALUES("SD12002BU09","2","05");
INSERT INTO replanishment VALUES("SD12002BU10","2","05");
INSERT INTO replanishment VALUES("SD12002BU11","1","05");
INSERT INTO replanishment VALUES("SD12003BL08","2","05");
INSERT INTO replanishment VALUES("SD12003BL09","2","05");
INSERT INTO replanishment VALUES("SD12003BL10","2","05");
INSERT INTO replanishment VALUES("SD12003BL11","1","05");
INSERT INTO replanishment VALUES("SD12004BU08","2","05");
INSERT INTO replanishment VALUES("SD12004BU09","2","05");
INSERT INTO replanishment VALUES("SD12004BU10","2","05");
INSERT INTO replanishment VALUES("SD12004BU11","1","05");
INSERT INTO replanishment VALUES("SD12005BL08","2","05");
INSERT INTO replanishment VALUES("SD12005BL09","2","05");
INSERT INTO replanishment VALUES("SD12005BL10","2","05");
INSERT INTO replanishment VALUES("SD12005BL11","1","05");
INSERT INTO replanishment VALUES("SG00001PU08","2","05");
INSERT INTO replanishment VALUES("SG00001PU09","2","05");
INSERT INTO replanishment VALUES("SG00001PU10","2","05");
INSERT INTO replanishment VALUES("SG00001PU11","1","05");
INSERT INTO replanishment VALUES("SG00002OW08","2","05");
INSERT INTO replanishment VALUES("SG00002OW09","2","05");
INSERT INTO replanishment VALUES("SG00002OW10","2","05");
INSERT INTO replanishment VALUES("SG00002OW11","1","05");
INSERT INTO replanishment VALUES("SG00003BL08","2","05");
INSERT INTO replanishment VALUES("SG00003BL09","2","05");
INSERT INTO replanishment VALUES("SG00003BL10","2","05");
INSERT INTO replanishment VALUES("SG00003BL11","1","05");
INSERT INTO replanishment VALUES("SG00004SN08","2","05");
INSERT INTO replanishment VALUES("SG00004SN09","2","05");
INSERT INTO replanishment VALUES("SG00004SN10","2","05");
INSERT INTO replanishment VALUES("SG00004SN11","1","05");
INSERT INTO replanishment VALUES("SG00005BU08","2","05");
INSERT INTO replanishment VALUES("SG00005BU09","2","05");
INSERT INTO replanishment VALUES("SG00005BU10","2","05");
INSERT INTO replanishment VALUES("SG00005BU11","1","05");
INSERT INTO replanishment VALUES("SG00006GO08","2","05");
INSERT INTO replanishment VALUES("SG00006GO09","2","05");
INSERT INTO replanishment VALUES("SG00006GO10","2","05");
INSERT INTO replanishment VALUES("SG00006GO11","1","05");
INSERT INTO replanishment VALUES("SG00007BR08","2","05");
INSERT INTO replanishment VALUES("SG00007BR09","2","05");
INSERT INTO replanishment VALUES("SG00007BR10","2","05");
INSERT INTO replanishment VALUES("SG00007BR11","1","05");
INSERT INTO replanishment VALUES("SG00008BU08","2","05");
INSERT INTO replanishment VALUES("SG00008BU09","2","05");
INSERT INTO replanishment VALUES("SG00008BU10","2","05");
INSERT INTO replanishment VALUES("SG00008BU11","1","05");
INSERT INTO replanishment VALUES("SG00009BU08","2","05");
INSERT INTO replanishment VALUES("SG00009BU09","2","05");
INSERT INTO replanishment VALUES("SG00009BU10","2","05");
INSERT INTO replanishment VALUES("SG00009BU11","1","05");
INSERT INTO replanishment VALUES("SG00010MS08","2","05");
INSERT INTO replanishment VALUES("SG00010MS09","2","05");
INSERT INTO replanishment VALUES("SG00010MS10","2","05");
INSERT INTO replanishment VALUES("SG00010MS11","1","05");
INSERT INTO replanishment VALUES("SG00011BR08","2","05");
INSERT INTO replanishment VALUES("SG00011BR09","2","05");
INSERT INTO replanishment VALUES("SG00011BR10","2","05");
INSERT INTO replanishment VALUES("SG00011BR11","1","05");
INSERT INTO replanishment VALUES("SG00012KH08","2","05");
INSERT INTO replanishment VALUES("SG00012KH09","2","05");
INSERT INTO replanishment VALUES("SG00012KH10","2","05");
INSERT INTO replanishment VALUES("SG00012KH11","1","05");
INSERT INTO replanishment VALUES("SG00013MR08","2","05");
INSERT INTO replanishment VALUES("SG00013MR09","2","05");
INSERT INTO replanishment VALUES("SG00013MR10","2","05");
INSERT INTO replanishment VALUES("SG00013MR11","1","05");
INSERT INTO replanishment VALUES("SG00014BL08","2","05");
INSERT INTO replanishment VALUES("SG00014BL09","2","05");
INSERT INTO replanishment VALUES("SG00014BL10","2","05");
INSERT INTO replanishment VALUES("SG00014BL11","1","05");
INSERT INTO replanishment VALUES("SG00015SB08","2","05");
INSERT INTO replanishment VALUES("SG00015SB09","2","05");
INSERT INTO replanishment VALUES("SG00015SB10","2","05");
INSERT INTO replanishment VALUES("SG00015SB11","1","05");
INSERT INTO replanishment VALUES("SG00016WH08","2","05");
INSERT INTO replanishment VALUES("SG00016WH09","2","05");
INSERT INTO replanishment VALUES("SG00016WH10","2","05");
INSERT INTO replanishment VALUES("SG00016WH11","1","05");
INSERT INTO replanishment VALUES("SG00017WH08","2","05");
INSERT INTO replanishment VALUES("SG00017WH09","2","05");
INSERT INTO replanishment VALUES("SG00017WH10","2","05");
INSERT INTO replanishment VALUES("SG00017WH11","1","05");
INSERT INTO replanishment VALUES("SG00018WH08","2","05");
INSERT INTO replanishment VALUES("SG00018WH09","2","05");
INSERT INTO replanishment VALUES("SG00018WH10","2","05");
INSERT INTO replanishment VALUES("SG00018WH11","1","05");
INSERT INTO replanishment VALUES("SG00019CB08","2","05");
INSERT INTO replanishment VALUES("SG00019CB09","2","05");
INSERT INTO replanishment VALUES("SG00019CB10","2","05");
INSERT INTO replanishment VALUES("SG00019CB11","1","05");
INSERT INTO replanishment VALUES("SG00020MR08","2","05");
INSERT INTO replanishment VALUES("SG00020MR09","2","05");
INSERT INTO replanishment VALUES("SG00020MR10","2","05");
INSERT INTO replanishment VALUES("SG00020MR11","1","05");
INSERT INTO replanishment VALUES("SG00021BL08","2","05");
INSERT INTO replanishment VALUES("SG00021BL09","2","05");
INSERT INTO replanishment VALUES("SG00021BL10","2","05");
INSERT INTO replanishment VALUES("SG00021BL11","1","05");
INSERT INTO replanishment VALUES("SG00022BR08","2","05");
INSERT INTO replanishment VALUES("SG00022BR09","2","05");
INSERT INTO replanishment VALUES("SG00022BR10","2","05");
INSERT INTO replanishment VALUES("SG00022BR11","1","05");
INSERT INTO replanishment VALUES("SG02097GO08","2","05");
INSERT INTO replanishment VALUES("SG02097GO09","2","05");
INSERT INTO replanishment VALUES("SG02097GO10","2","05");
INSERT INTO replanishment VALUES("SG02097GO11","1","05");
INSERT INTO replanishment VALUES("SG03001MD08","2","05");
INSERT INTO replanishment VALUES("SG03001MD09","2","05");
INSERT INTO replanishment VALUES("SG03001MD10","2","05");
INSERT INTO replanishment VALUES("SG03001MD11","1","05");
INSERT INTO replanishment VALUES("SG03001OW08","2","05");
INSERT INTO replanishment VALUES("SG03001OW09","2","05");
INSERT INTO replanishment VALUES("SG03001OW10","2","05");
INSERT INTO replanishment VALUES("SG03001OW11","1","05");
INSERT INTO replanishment VALUES("SG03002MD08","2","05");
INSERT INTO replanishment VALUES("SG03002MD09","2","05");
INSERT INTO replanishment VALUES("SG03002MD10","2","05");
INSERT INTO replanishment VALUES("SG03002MD11","1","05");
INSERT INTO replanishment VALUES("SG03002OW08","2","05");
INSERT INTO replanishment VALUES("SG03002OW09","2","05");
INSERT INTO replanishment VALUES("SG03002OW10","2","05");
INSERT INTO replanishment VALUES("SG03002OW11","1","05");
INSERT INTO replanishment VALUES("SG04001SG08","2","05");
INSERT INTO replanishment VALUES("SG04001SG09","2","05");
INSERT INTO replanishment VALUES("SG04001SG10","2","05");
INSERT INTO replanishment VALUES("SG04001SG11","1","05");
INSERT INTO replanishment VALUES("SG04002MR08","2","05");
INSERT INTO replanishment VALUES("SG04002MR09","2","05");
INSERT INTO replanishment VALUES("SG04002MR10","2","05");
INSERT INTO replanishment VALUES("SG04002MR11","1","05");
INSERT INTO replanishment VALUES("SG04002MV08","2","05");
INSERT INTO replanishment VALUES("SG04002MV09","2","05");
INSERT INTO replanishment VALUES("SG04002MV10","2","05");
INSERT INTO replanishment VALUES("SG04002MV11","1","05");
INSERT INTO replanishment VALUES("SG04003MR08","2","05");
INSERT INTO replanishment VALUES("SG04003MR09","2","05");
INSERT INTO replanishment VALUES("SG04003MR10","2","05");
INSERT INTO replanishment VALUES("SG04003MR11","1","05");
INSERT INTO replanishment VALUES("SG04004PK08","2","05");
INSERT INTO replanishment VALUES("SG04004PK09","2","05");
INSERT INTO replanishment VALUES("SG04004PK10","2","05");
INSERT INTO replanishment VALUES("SG04004PK11","1","05");
INSERT INTO replanishment VALUES("SG04005PR08","2","05");
INSERT INTO replanishment VALUES("SG04005PR09","2","05");
INSERT INTO replanishment VALUES("SG04005PR10","2","05");
INSERT INTO replanishment VALUES("SG04005PR11","1","05");
INSERT INTO replanishment VALUES("SK00001BR08","2","05");
INSERT INTO replanishment VALUES("SK00001BR09","2","05");
INSERT INTO replanishment VALUES("SK00001BR10","2","05");
INSERT INTO replanishment VALUES("SK00001BR11","1","05");
INSERT INTO replanishment VALUES("SK00001GR08","2","05");
INSERT INTO replanishment VALUES("SK00001GR09","2","05");
INSERT INTO replanishment VALUES("SK00001GR10","2","05");
INSERT INTO replanishment VALUES("SK00001GR11","1","05");
INSERT INTO replanishment VALUES("SK00002MU08","2","05");
INSERT INTO replanishment VALUES("SK00002MU09","2","05");
INSERT INTO replanishment VALUES("SK00002MU10","2","05");
INSERT INTO replanishment VALUES("SK00002MU11","1","05");
INSERT INTO replanishment VALUES("SK00003BL08","2","05");
INSERT INTO replanishment VALUES("SK00003BL09","2","05");
INSERT INTO replanishment VALUES("SK00003BL10","2","05");
INSERT INTO replanishment VALUES("SK00003BL11","1","05");
INSERT INTO replanishment VALUES("SK00003WH08","2","05");
INSERT INTO replanishment VALUES("SK00003WH09","2","05");
INSERT INTO replanishment VALUES("SK00003WH10","2","05");
INSERT INTO replanishment VALUES("SK00003WH11","1","05");
INSERT INTO replanishment VALUES("SK00004BL08","2","05");
INSERT INTO replanishment VALUES("SK00004BL09","2","05");
INSERT INTO replanishment VALUES("SK00004BL10","2","05");
INSERT INTO replanishment VALUES("SK00004BL11","1","05");
INSERT INTO replanishment VALUES("SK00005WH08","2","05");
INSERT INTO replanishment VALUES("SK00005WH09","2","05");
INSERT INTO replanishment VALUES("SK00005WH10","2","05");
INSERT INTO replanishment VALUES("SK00005WH11","1","05");
INSERT INTO replanishment VALUES("SK00006GR08","2","05");
INSERT INTO replanishment VALUES("SK00006GR09","2","05");
INSERT INTO replanishment VALUES("SK00006GR10","2","05");
INSERT INTO replanishment VALUES("SK00006GR11","1","05");
INSERT INTO replanishment VALUES("SK00006GY08","2","05");
INSERT INTO replanishment VALUES("SK00006GY09","2","05");
INSERT INTO replanishment VALUES("SK00006GY10","2","05");
INSERT INTO replanishment VALUES("SK00006GY11","1","05");
INSERT INTO replanishment VALUES("SK00007GY08","2","05");
INSERT INTO replanishment VALUES("SK00007GY09","2","05");
INSERT INTO replanishment VALUES("SK00007GY10","2","05");
INSERT INTO replanishment VALUES("SK00007GY11","1","05");
INSERT INTO replanishment VALUES("SK00008PL08","2","05");
INSERT INTO replanishment VALUES("SK00008PL09","2","05");
INSERT INTO replanishment VALUES("SK00008PL10","2","05");
INSERT INTO replanishment VALUES("SK00008PL11","1","05");
INSERT INTO replanishment VALUES("SK00009BR08","2","05");
INSERT INTO replanishment VALUES("SK00009BR09","2","05");
INSERT INTO replanishment VALUES("SK00009BR10","2","05");
INSERT INTO replanishment VALUES("SK00009BR11","1","05");
INSERT INTO replanishment VALUES("SK00010GR08","2","05");
INSERT INTO replanishment VALUES("SK00010GR09","2","05");
INSERT INTO replanishment VALUES("SK00010GR10","2","05");
INSERT INTO replanishment VALUES("SK00010GR11","1","05");
INSERT INTO replanishment VALUES("SK00011DG08","2","05");
INSERT INTO replanishment VALUES("SK00011DG09","2","05");
INSERT INTO replanishment VALUES("SK00011DG10","2","05");
INSERT INTO replanishment VALUES("SK00011DG11","1","05");
INSERT INTO replanishment VALUES("SK00011LG08","2","05");
INSERT INTO replanishment VALUES("SK00011LG09","2","05");
INSERT INTO replanishment VALUES("SK00011LG10","2","05");
INSERT INTO replanishment VALUES("SK00011LG11","1","05");
INSERT INTO replanishment VALUES("SK00012BR08","2","05");
INSERT INTO replanishment VALUES("SK00012BR09","2","05");
INSERT INTO replanishment VALUES("SK00012BR10","2","05");
INSERT INTO replanishment VALUES("SK00012BR11","1","05");
INSERT INTO replanishment VALUES("SK00012GY08","2","05");
INSERT INTO replanishment VALUES("SK00012GY09","2","05");
INSERT INTO replanishment VALUES("SK00012GY10","2","05");
INSERT INTO replanishment VALUES("SK00012GY11","1","05");
INSERT INTO replanishment VALUES("SK00013MH08","2","05");
INSERT INTO replanishment VALUES("SK00013MH09","2","05");
INSERT INTO replanishment VALUES("SK00013MH10","2","05");
INSERT INTO replanishment VALUES("SK00013MH11","1","05");
INSERT INTO replanishment VALUES("SK00017BL08","2","05");
INSERT INTO replanishment VALUES("SK00017BL09","2","05");
INSERT INTO replanishment VALUES("SK00017BL10","2","05");
INSERT INTO replanishment VALUES("SK00017BL11","1","05");
INSERT INTO replanishment VALUES("SK00017BU08","2","05");
INSERT INTO replanishment VALUES("SK00017BU09","2","05");
INSERT INTO replanishment VALUES("SK00017BU10","2","05");
INSERT INTO replanishment VALUES("SK00017BU11","1","05");
INSERT INTO replanishment VALUES("SK00018BR08","2","05");
INSERT INTO replanishment VALUES("SK00018BR09","2","05");
INSERT INTO replanishment VALUES("SK00018BR10","2","05");
INSERT INTO replanishment VALUES("SK00018BR11","1","05");
INSERT INTO replanishment VALUES("SK00018BU08","2","05");
INSERT INTO replanishment VALUES("SK00018BU09","2","05");
INSERT INTO replanishment VALUES("SK00018BU10","2","05");
INSERT INTO replanishment VALUES("SK00018BU11","1","05");
INSERT INTO replanishment VALUES("SK00018GB08","2","05");
INSERT INTO replanishment VALUES("SK00018GB09","2","05");
INSERT INTO replanishment VALUES("SK00018GB10","2","05");
INSERT INTO replanishment VALUES("SK00018GB11","1","05");
INSERT INTO replanishment VALUES("SK00019BR08","2","05");
INSERT INTO replanishment VALUES("SK00019BR09","2","05");
INSERT INTO replanishment VALUES("SK00019BR10","2","05");
INSERT INTO replanishment VALUES("SK00019BR11","1","05");
INSERT INTO replanishment VALUES("SK00020PR08","2","05");
INSERT INTO replanishment VALUES("SK00020PR09","2","05");
INSERT INTO replanishment VALUES("SK00020PR10","2","05");
INSERT INTO replanishment VALUES("SK00020PR11","1","05");
INSERT INTO replanishment VALUES("SK00021WH08","2","05");
INSERT INTO replanishment VALUES("SK00021WH09","2","05");
INSERT INTO replanishment VALUES("SK00021WH10","2","05");
INSERT INTO replanishment VALUES("SK00021WH11","1","05");
INSERT INTO replanishment VALUES("SK00022GY08","2","05");
INSERT INTO replanishment VALUES("SK00022GY09","2","05");
INSERT INTO replanishment VALUES("SK00022GY10","2","05");
INSERT INTO replanishment VALUES("SK00022GY11","1","05");
INSERT INTO replanishment VALUES("SK00022MR08","2","05");
INSERT INTO replanishment VALUES("SK00022MR09","2","05");
INSERT INTO replanishment VALUES("SK00022MR10","2","05");
INSERT INTO replanishment VALUES("SK00022MR11","1","05");
INSERT INTO replanishment VALUES("SK00023BU08","2","05");
INSERT INTO replanishment VALUES("SK00023BU09","2","05");
INSERT INTO replanishment VALUES("SK00023BU10","2","05");
INSERT INTO replanishment VALUES("SK00023BU11","1","05");
INSERT INTO replanishment VALUES("SK00023GR08","2","05");
INSERT INTO replanishment VALUES("SK00023GR09","2","05");
INSERT INTO replanishment VALUES("SK00023GR10","2","05");
INSERT INTO replanishment VALUES("SK00023GR11","1","05");
INSERT INTO replanishment VALUES("SK00025BU08","2","05");
INSERT INTO replanishment VALUES("SK00025BU09","2","05");
INSERT INTO replanishment VALUES("SK00025BU10","2","05");
INSERT INTO replanishment VALUES("SK00025BU11","1","05");
INSERT INTO replanishment VALUES("SK00025MV08","2","05");
INSERT INTO replanishment VALUES("SK00025MV09","2","05");
INSERT INTO replanishment VALUES("SK00025MV10","2","05");
INSERT INTO replanishment VALUES("SK00025MV11","1","05");
INSERT INTO replanishment VALUES("SK00025PU08","2","05");
INSERT INTO replanishment VALUES("SK00025PU09","2","05");
INSERT INTO replanishment VALUES("SK00025PU10","2","05");
INSERT INTO replanishment VALUES("SK00025PU11","1","05");
INSERT INTO replanishment VALUES("SK00026BD08","2","05");
INSERT INTO replanishment VALUES("SK00026BD09","2","05");
INSERT INTO replanishment VALUES("SK00026BD10","2","05");
INSERT INTO replanishment VALUES("SK00026BD11","1","05");
INSERT INTO replanishment VALUES("SK00026FE08","2","05");
INSERT INTO replanishment VALUES("SK00026FE09","2","05");
INSERT INTO replanishment VALUES("SK00026FE10","2","05");
INSERT INTO replanishment VALUES("SK00026FE11","1","05");
INSERT INTO replanishment VALUES("SK00026NE08","2","05");
INSERT INTO replanishment VALUES("SK00026NE09","2","05");
INSERT INTO replanishment VALUES("SK00026NE10","2","05");
INSERT INTO replanishment VALUES("SK00026NE11","1","05");
INSERT INTO replanishment VALUES("SK00027CR08","2","05");
INSERT INTO replanishment VALUES("SK00027CR09","2","05");
INSERT INTO replanishment VALUES("SK00027CR10","2","05");
INSERT INTO replanishment VALUES("SK00027CR11","1","05");
INSERT INTO replanishment VALUES("SK00027FE08","2","05");
INSERT INTO replanishment VALUES("SK00027FE09","2","05");
INSERT INTO replanishment VALUES("SK00027FE10","2","05");
INSERT INTO replanishment VALUES("SK00027FE11","1","05");
INSERT INTO replanishment VALUES("SK00027LV08","2","05");
INSERT INTO replanishment VALUES("SK00027LV09","2","05");
INSERT INTO replanishment VALUES("SK00027LV10","2","05");
INSERT INTO replanishment VALUES("SK00027LV11","1","05");
INSERT INTO replanishment VALUES("SK00030BU08","2","05");
INSERT INTO replanishment VALUES("SK00030BU09","2","05");
INSERT INTO replanishment VALUES("SK00030BU10","2","05");
INSERT INTO replanishment VALUES("SK00030BU11","1","05");
INSERT INTO replanishment VALUES("SK00033BU08","2","05");
INSERT INTO replanishment VALUES("SK00033BU09","2","05");
INSERT INTO replanishment VALUES("SK00033BU10","2","05");
INSERT INTO replanishment VALUES("SK00033BU11","1","05");
INSERT INTO replanishment VALUES("SK00033WH08","2","05");
INSERT INTO replanishment VALUES("SK00033WH09","2","05");
INSERT INTO replanishment VALUES("SK00033WH10","2","05");
INSERT INTO replanishment VALUES("SK00033WH11","1","05");
INSERT INTO replanishment VALUES("SK00034WH08","2","05");
INSERT INTO replanishment VALUES("SK00034WH09","2","05");
INSERT INTO replanishment VALUES("SK00034WH10","2","05");
INSERT INTO replanishment VALUES("SK00034WH11","1","05");
INSERT INTO replanishment VALUES("SK00035BL08","2","05");
INSERT INTO replanishment VALUES("SK00035BL09","2","05");
INSERT INTO replanishment VALUES("SK00035BL10","2","05");
INSERT INTO replanishment VALUES("SK00035BL11","1","05");
INSERT INTO replanishment VALUES("SK00036GO08","2","05");
INSERT INTO replanishment VALUES("SK00036GO09","2","05");
INSERT INTO replanishment VALUES("SK00036GO10","2","05");
INSERT INTO replanishment VALUES("SK00036GO11","1","05");
INSERT INTO replanishment VALUES("SK00036GR08","2","05");
INSERT INTO replanishment VALUES("SK00036GR09","2","05");
INSERT INTO replanishment VALUES("SK00036GR10","2","05");
INSERT INTO replanishment VALUES("SK00036GR11","1","05");
INSERT INTO replanishment VALUES("SK00036GY08","2","05");
INSERT INTO replanishment VALUES("SK00036GY09","2","05");
INSERT INTO replanishment VALUES("SK00036GY10","2","05");
INSERT INTO replanishment VALUES("SK00036GY11","1","05");
INSERT INTO replanishment VALUES("SK00037BL08","2","05");
INSERT INTO replanishment VALUES("SK00037BL09","2","05");
INSERT INTO replanishment VALUES("SK00037BL10","2","05");
INSERT INTO replanishment VALUES("SK00037BL11","1","05");
INSERT INTO replanishment VALUES("SK00038GO08","2","05");
INSERT INTO replanishment VALUES("SK00038GO09","2","05");
INSERT INTO replanishment VALUES("SK00038GO10","2","05");
INSERT INTO replanishment VALUES("SK00038GO11","1","05");
INSERT INTO replanishment VALUES("SK00039GY08","2","05");
INSERT INTO replanishment VALUES("SK00039GY09","2","05");
INSERT INTO replanishment VALUES("SK00039GY10","2","05");
INSERT INTO replanishment VALUES("SK00039GY11","1","05");
INSERT INTO replanishment VALUES("SK00040GR08","2","05");
INSERT INTO replanishment VALUES("SK00040GR09","2","05");
INSERT INTO replanishment VALUES("SK00040GR10","2","05");
INSERT INTO replanishment VALUES("SK00040GR11","1","05");
INSERT INTO replanishment VALUES("SK00041PU08","2","05");
INSERT INTO replanishment VALUES("SK00041PU09","2","05");
INSERT INTO replanishment VALUES("SK00041PU10","2","05");
INSERT INTO replanishment VALUES("SK00041PU11","1","05");
INSERT INTO replanishment VALUES("SK00042BU08","2","05");
INSERT INTO replanishment VALUES("SK00042BU09","2","05");
INSERT INTO replanishment VALUES("SK00042BU10","2","05");
INSERT INTO replanishment VALUES("SK00042BU11","1","05");
INSERT INTO replanishment VALUES("SK00049GY08","2","05");
INSERT INTO replanishment VALUES("SK00049GY09","2","05");
INSERT INTO replanishment VALUES("SK00049GY10","2","05");
INSERT INTO replanishment VALUES("SK00049GY11","1","05");
INSERT INTO replanishment VALUES("SK00055OR08","2","05");
INSERT INTO replanishment VALUES("SK00055OR09","2","05");
INSERT INTO replanishment VALUES("SK00055OR10","2","05");
INSERT INTO replanishment VALUES("SK00055OR11","1","05");
INSERT INTO replanishment VALUES("SK00056MR08","2","05");
INSERT INTO replanishment VALUES("SK00056MR09","2","05");
INSERT INTO replanishment VALUES("SK00056MR10","2","05");
INSERT INTO replanishment VALUES("SK00056MR11","1","05");
INSERT INTO replanishment VALUES("SK00059GR08","2","05");
INSERT INTO replanishment VALUES("SK00059GR09","2","05");
INSERT INTO replanishment VALUES("SK00059GR10","2","05");
INSERT INTO replanishment VALUES("SK00059GR11","1","05");
INSERT INTO replanishment VALUES("SK00060WH08","2","05");
INSERT INTO replanishment VALUES("SK00060WH09","2","05");
INSERT INTO replanishment VALUES("SK00060WH10","2","05");
INSERT INTO replanishment VALUES("SK00060WH11","1","05");
INSERT INTO replanishment VALUES("SK00062BL08","2","05");
INSERT INTO replanishment VALUES("SK00062BL09","2","05");
INSERT INTO replanishment VALUES("SK00062BL10","2","05");
INSERT INTO replanishment VALUES("SK00062BL11","1","05");
INSERT INTO replanishment VALUES("SK00063BL08","2","05");
INSERT INTO replanishment VALUES("SK00063BL09","2","05");
INSERT INTO replanishment VALUES("SK00063BL10","2","05");
INSERT INTO replanishment VALUES("SK00063BL11","1","05");
INSERT INTO replanishment VALUES("SK00064BL08","2","05");
INSERT INTO replanishment VALUES("SK00064BL09","2","05");
INSERT INTO replanishment VALUES("SK00064BL10","2","05");
INSERT INTO replanishment VALUES("SK00064BL11","1","05");
INSERT INTO replanishment VALUES("SK00070BL08","2","05");
INSERT INTO replanishment VALUES("SK00070BL09","2","05");
INSERT INTO replanishment VALUES("SK00070BL10","2","05");
INSERT INTO replanishment VALUES("SK00070BL11","1","05");
INSERT INTO replanishment VALUES("SK00071GY08","2","05");
INSERT INTO replanishment VALUES("SK00071GY09","2","05");
INSERT INTO replanishment VALUES("SK00071GY10","2","05");
INSERT INTO replanishment VALUES("SK00071GY11","1","05");
INSERT INTO replanishment VALUES("SK00072BU08","2","05");
INSERT INTO replanishment VALUES("SK00072BU09","2","05");
INSERT INTO replanishment VALUES("SK00072BU10","2","05");
INSERT INTO replanishment VALUES("SK00072BU11","1","05");
INSERT INTO replanishment VALUES("SK00073PH08","2","05");
INSERT INTO replanishment VALUES("SK00073PH09","2","05");
INSERT INTO replanishment VALUES("SK00073PH10","2","05");
INSERT INTO replanishment VALUES("SK00073PH11","1","05");
INSERT INTO replanishment VALUES("SK00074BU08","2","05");
INSERT INTO replanishment VALUES("SK00074BU09","2","05");
INSERT INTO replanishment VALUES("SK00074BU10","2","05");
INSERT INTO replanishment VALUES("SK00074BU11","1","05");
INSERT INTO replanishment VALUES("SK00075BL08","2","05");
INSERT INTO replanishment VALUES("SK00075BL09","2","05");
INSERT INTO replanishment VALUES("SK00075BL10","2","05");
INSERT INTO replanishment VALUES("SK00075BL11","1","05");
INSERT INTO replanishment VALUES("SK00076BR08","2","05");
INSERT INTO replanishment VALUES("SK00076BR09","2","05");
INSERT INTO replanishment VALUES("SK00076BR10","2","05");
INSERT INTO replanishment VALUES("SK00076BR11","1","05");
INSERT INTO replanishment VALUES("SK00077WH08","2","05");
INSERT INTO replanishment VALUES("SK00077WH09","2","05");
INSERT INTO replanishment VALUES("SK00077WH10","2","05");
INSERT INTO replanishment VALUES("SK00077WH11","1","05");
INSERT INTO replanishment VALUES("SK00079WH08","2","05");
INSERT INTO replanishment VALUES("SK00079WH09","2","05");
INSERT INTO replanishment VALUES("SK00079WH10","2","05");
INSERT INTO replanishment VALUES("SK00079WH11","1","05");
INSERT INTO replanishment VALUES("SK00082PU08","2","05");
INSERT INTO replanishment VALUES("SK00082PU09","2","05");
INSERT INTO replanishment VALUES("SK00082PU10","2","05");
INSERT INTO replanishment VALUES("SK00082PU11","1","05");
INSERT INTO replanishment VALUES("SK00083LG08","2","05");
INSERT INTO replanishment VALUES("SK00083LG09","2","05");
INSERT INTO replanishment VALUES("SK00083LG10","2","05");
INSERT INTO replanishment VALUES("SK00083LG11","1","05");
INSERT INTO replanishment VALUES("SK00086GR08","2","05");
INSERT INTO replanishment VALUES("SK00086GR09","2","05");
INSERT INTO replanishment VALUES("SK00086GR10","2","05");
INSERT INTO replanishment VALUES("SK00086GR11","1","05");
INSERT INTO replanishment VALUES("SK00087OR08","2","05");
INSERT INTO replanishment VALUES("SK00087OR09","2","05");
INSERT INTO replanishment VALUES("SK00087OR10","2","05");
INSERT INTO replanishment VALUES("SK00087OR11","1","05");
INSERT INTO replanishment VALUES("SK00088PR08","2","05");
INSERT INTO replanishment VALUES("SK00088PR09","2","05");
INSERT INTO replanishment VALUES("SK00088PR10","2","05");
INSERT INTO replanishment VALUES("SK00088PR11","1","05");
INSERT INTO replanishment VALUES("SK00089WH08","2","05");
INSERT INTO replanishment VALUES("SK00089WH09","2","05");
INSERT INTO replanishment VALUES("SK00089WH10","2","05");
INSERT INTO replanishment VALUES("SK00089WH11","1","05");
INSERT INTO replanishment VALUES("SK00090BL08","2","05");
INSERT INTO replanishment VALUES("SK00090BL09","2","05");
INSERT INTO replanishment VALUES("SK00090BL10","2","05");
INSERT INTO replanishment VALUES("SK00090BL11","1","05");
INSERT INTO replanishment VALUES("SK00092OF08","2","05");
INSERT INTO replanishment VALUES("SK00092OF09","2","05");
INSERT INTO replanishment VALUES("SK00092OF10","2","05");
INSERT INTO replanishment VALUES("SK00092OF11","1","05");
INSERT INTO replanishment VALUES("SK00093WH08","2","05");
INSERT INTO replanishment VALUES("SK00093WH09","2","05");
INSERT INTO replanishment VALUES("SK00093WH10","2","05");
INSERT INTO replanishment VALUES("SK00093WH11","1","05");
INSERT INTO replanishment VALUES("SK00094BR08","2","05");
INSERT INTO replanishment VALUES("SK00094BR09","2","05");
INSERT INTO replanishment VALUES("SK00094BR10","2","05");
INSERT INTO replanishment VALUES("SK00094BR11","1","05");
INSERT INTO replanishment VALUES("SK00095WH08","2","05");
INSERT INTO replanishment VALUES("SK00095WH09","2","05");
INSERT INTO replanishment VALUES("SK00095WH10","2","05");
INSERT INTO replanishment VALUES("SK00095WH11","1","05");
INSERT INTO replanishment VALUES("SK00096WH08","2","05");
INSERT INTO replanishment VALUES("SK00096WH09","2","05");
INSERT INTO replanishment VALUES("SK00096WH10","2","05");
INSERT INTO replanishment VALUES("SK00096WH11","1","05");
INSERT INTO replanishment VALUES("SK00097RS08","2","05");
INSERT INTO replanishment VALUES("SK00097RS09","2","05");
INSERT INTO replanishment VALUES("SK00097RS10","2","05");
INSERT INTO replanishment VALUES("SK00097RS11","1","05");
INSERT INTO replanishment VALUES("SK00098DB08","2","05");
INSERT INTO replanishment VALUES("SK00098DB09","2","05");
INSERT INTO replanishment VALUES("SK00098DB10","2","05");
INSERT INTO replanishment VALUES("SK00098DB11","1","05");
INSERT INTO replanishment VALUES("SK00099OW08","2","05");
INSERT INTO replanishment VALUES("SK00099OW09","2","05");
INSERT INTO replanishment VALUES("SK00099OW10","2","05");
INSERT INTO replanishment VALUES("SK00099OW11","1","05");
INSERT INTO replanishment VALUES("SK00100GR08","2","05");
INSERT INTO replanishment VALUES("SK00100GR09","2","05");
INSERT INTO replanishment VALUES("SK00100GR10","2","05");
INSERT INTO replanishment VALUES("SK00100GR11","1","05");
INSERT INTO replanishment VALUES("SK00101LG08","2","05");
INSERT INTO replanishment VALUES("SK00101LG09","2","05");
INSERT INTO replanishment VALUES("SK00101LG10","2","05");
INSERT INTO replanishment VALUES("SK00101LG11","1","05");
INSERT INTO replanishment VALUES("SK00102SB08","2","05");
INSERT INTO replanishment VALUES("SK00102SB09","2","05");
INSERT INTO replanishment VALUES("SK00102SB10","2","05");
INSERT INTO replanishment VALUES("SK00102SB11","1","05");
INSERT INTO replanishment VALUES("SK00103FN08","2","05");
INSERT INTO replanishment VALUES("SK00103FN09","2","05");
INSERT INTO replanishment VALUES("SK00103FN10","2","05");
INSERT INTO replanishment VALUES("SK00103FN11","1","05");
INSERT INTO replanishment VALUES("SK00105CB08","2","05");
INSERT INTO replanishment VALUES("SK00105CB09","2","05");
INSERT INTO replanishment VALUES("SK00105CB10","2","05");
INSERT INTO replanishment VALUES("SK00105CB11","1","05");
INSERT INTO replanishment VALUES("SK00107NB08","2","05");
INSERT INTO replanishment VALUES("SK00107NB09","2","05");
INSERT INTO replanishment VALUES("SK00107NB10","2","05");
INSERT INTO replanishment VALUES("SK00107NB11","1","05");
INSERT INTO replanishment VALUES("SK00109WH08","2","05");
INSERT INTO replanishment VALUES("SK00109WH09","2","05");
INSERT INTO replanishment VALUES("SK00109WH10","2","05");
INSERT INTO replanishment VALUES("SK00109WH11","1","05");
INSERT INTO replanishment VALUES("SK00110GO08","2","05");
INSERT INTO replanishment VALUES("SK00110GO09","2","05");
INSERT INTO replanishment VALUES("SK00110GO10","2","05");
INSERT INTO replanishment VALUES("SK00110GO11","1","05");
INSERT INTO replanishment VALUES("SK00112PU08","2","05");
INSERT INTO replanishment VALUES("SK00112PU09","2","05");
INSERT INTO replanishment VALUES("SK00112PU10","2","05");
INSERT INTO replanishment VALUES("SK00112PU11","1","05");
INSERT INTO replanishment VALUES("SK00113GY08","2","05");
INSERT INTO replanishment VALUES("SK00113GY09","2","05");
INSERT INTO replanishment VALUES("SK00113GY10","2","05");
INSERT INTO replanishment VALUES("SK00113GY11","1","05");
INSERT INTO replanishment VALUES("SK00114BR08","2","05");
INSERT INTO replanishment VALUES("SK00114BR09","2","05");
INSERT INTO replanishment VALUES("SK00114BR10","2","05");
INSERT INTO replanishment VALUES("SK00114BR11","1","05");
INSERT INTO replanishment VALUES("SK00115BL08","2","05");
INSERT INTO replanishment VALUES("SK00115BL09","2","05");
INSERT INTO replanishment VALUES("SK00115BL10","2","05");
INSERT INTO replanishment VALUES("SK00115BL11","1","05");
INSERT INTO replanishment VALUES("SK00116GY08","2","05");
INSERT INTO replanishment VALUES("SK00116GY09","2","05");
INSERT INTO replanishment VALUES("SK00116GY10","2","05");
INSERT INTO replanishment VALUES("SK00116GY11","1","05");
INSERT INTO replanishment VALUES("SK00117BL08","2","05");
INSERT INTO replanishment VALUES("SK00117BL09","2","05");
INSERT INTO replanishment VALUES("SK00117BL10","2","05");
INSERT INTO replanishment VALUES("SK00117BL11","1","05");
INSERT INTO replanishment VALUES("SK00118BL08","2","05");
INSERT INTO replanishment VALUES("SK00118BL09","2","05");
INSERT INTO replanishment VALUES("SK00118BL10","2","05");
INSERT INTO replanishment VALUES("SK00118BL11","1","05");
INSERT INTO replanishment VALUES("SK00119BL08","2","05");
INSERT INTO replanishment VALUES("SK00119BL09","2","05");
INSERT INTO replanishment VALUES("SK00119BL10","2","05");
INSERT INTO replanishment VALUES("SK00119BL11","1","05");
INSERT INTO replanishment VALUES("SK00120MR08","2","05");
INSERT INTO replanishment VALUES("SK00120MR09","2","05");
INSERT INTO replanishment VALUES("SK00120MR10","2","05");
INSERT INTO replanishment VALUES("SK00120MR11","1","05");
INSERT INTO replanishment VALUES("SK00121BL08","2","05");
INSERT INTO replanishment VALUES("SK00121BL09","2","05");
INSERT INTO replanishment VALUES("SK00121BL10","2","05");
INSERT INTO replanishment VALUES("SK00121BL11","1","05");
INSERT INTO replanishment VALUES("SK00122WH08","0","05");
INSERT INTO replanishment VALUES("SK00122WH09","0","05");
INSERT INTO replanishment VALUES("SK00122WH10","0","05");
INSERT INTO replanishment VALUES("SK00122WH11","0","05");


DROP TABLE IF EXISTS report;

CREATE TABLE `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report VALUES("2010-11-25","2015-11-25");


DROP TABLE IF EXISTS report_brands;

CREATE TABLE `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report_brands VALUES("1301","1202","1103","1102","");


DROP TABLE IF EXISTS report_cat;

CREATE TABLE `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS report_comp;

CREATE TABLE `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report_comp VALUES("01");


DROP TABLE IF EXISTS report_cs;

CREATE TABLE `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS report_div;

CREATE TABLE `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS report_party;

CREATE TABLE `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report_party VALUES("0063");


DROP TABLE IF EXISTS report_sp;

CREATE TABLE `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS reports;

CREATE TABLE `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS reports_all;

CREATE TABLE `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO reports_all VALUES("accountsummary","Account Summary","1","N");


DROP TABLE IF EXISTS season_cat;

CREATE TABLE `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO season_cat VALUES("010101","WINTER");
INSERT INTO season_cat VALUES("010102","SUMMER");


DROP TABLE IF EXISTS size;

CREATE TABLE `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO size VALUES("08","S");
INSERT INTO size VALUES("09","M");
INSERT INTO size VALUES("10","L");
INSERT INTO size VALUES("11","XL");


DROP TABLE IF EXISTS sl_am_con;

CREATE TABLE `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_am_condet;

CREATE TABLE `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_cont;

CREATE TABLE `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_contdet;

CREATE TABLE `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_contmaint;

CREATE TABLE `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_contpay;

CREATE TABLE `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc;

CREATE TABLE `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc_rtn;

CREATE TABLE `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc_rtndet;

CREATE TABLE `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc_rtndet_ser;

CREATE TABLE `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dcdet;

CREATE TABLE `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dcdet_copy;

CREATE TABLE `sl_dcdet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dcdet_ser;

CREATE TABLE `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_gp;

CREATE TABLE `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_gp` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_gpdet;

CREATE TABLE `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(11,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_gpdet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_invoice;

CREATE TABLE `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_invoice VALUES("060010","2017-06-05","2610000001","300.00","0.00","3000.00","","","","","","","3362","","","","","","01","","2017-06-16 17:23:25","","0001","","0.000","","","3000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060008","2017-06-03","2610000001","350.00","0.00","54000.00","","","","","","","3360","","","","","","01","","2017-06-16 17:23:25","","0003","","0.000","","","54000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060006","2017-06-03","2610000001","0.00","0.00","13000.00","","","","","","","1097","","","","","","01","","2017-06-16 17:23:25","","0003","","0.000","","","13000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060004","2017-06-03","2610000001","1000.00","0.00","18000.00","","","","","","","1093","","","","","","01","","2017-06-16 17:23:25","","0001","","0.000","","","18000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070033","2017-07-07","2610000034","350.00","0.00","12200.00","","","","","","","1183","","","","","","01","","2017-07-07 17:35:15","","0003","","0.000","","","12200.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070018","2017-07-04","2610000063","2640.00","0.00","106000.00","","","","","","","1170","","","","","","01","","2017-07-05 11:02:51","","0003","","0.000","","","106000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070016","2017-07-04","2610000063","1613.00","0.00","250000.00","","","","","","","1168","","","","","","01","","2017-07-05 10:46:43","","0003","","0.000","","","250000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070017","2017-07-04","2610000063","3500.00","0.00","24000.00","","","","","","","1169","","","","","","01","","2017-07-05 10:56:45","","0003","","0.000","","","24000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070015","2017-07-04","2610000059","80.00","0.00","31000.00","","","","","","","1562","","","","","","01","","2017-07-04 19:13:34","","0001","","0.000","","","31000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070014","2017-07-04","2610000001","0.00","0.00","4950.00","","","","","","","1167","","","","","","01","","2017-07-07 14:32:03","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","4950");
INSERT INTO sl_invoice VALUES("070013","2017-07-04","2610000047","100.00","0.00","800.00","","","","","","","1163","","","","","","01","","2017-07-04 12:02:58","","0001","","0.000","","","800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070012","2017-07-04","2610000047","0.00","0.00","1800.00","","","","","","","1162","","","","","","01","","2017-07-04 11:58:09","","0001","","0.000","","","1800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070011","2017-07-03","2610000062","50.00","0.00","19000.00","","","","","","","1161","","","","","","01","","2017-07-04 11:41:32","","0003","","0.000","","","19000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070010","2017-07-03","2610000061","300.00","0.00","47000.00","","","","","","","1158","","","","","","01","","2017-07-04 11:33:05","","0003","","0.000","","","47000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070009","2017-07-03","2610000001","0.00","0.00","19000.00","","","","","","","1160","","","","","","01","","2017-07-03 15:26:54","","0003","","0.000","","","19000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070008","2017-07-03","2610000001","0.00","0.00","2500.00","","","","","","","1159","","","","","","01","","2017-07-03 15:10:00","","0003","","0.000","","","2500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070006","2017-07-01","2610000001","500.00","0.00","14000.00","","","","","","","1156","","","","","","01","","2017-07-03 10:08:07","","0003","","0.000","","","14000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070007","2017-07-01","2610000060","0.00","0.00","177000.00","","","","","","","1157","","","","","","01","","2017-07-03 10:12:55","","0003","","0.000","","","177000.00","","","","02","17","on","","03224796007","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070005","2017-07-01","2610000001","0.00","0.00","1500.00","","","","","","","1154","","","","","","01","","2017-07-01 15:43:14","","0003","","0.000","","","1500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070004","2017-07-01","2610000001","0.00","0.00","4000.00","","","","","","","1155","","","","","","01","","2017-07-01 15:41:43","","0003","","0.000","","","4000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070003","2017-07-01","2610000001","705.00","0.00","93000.00","","","","","","","1153","","","","","","01","","2017-07-01 13:54:01","","0001","","0.000","","","50000.00","","","","02","17","on","","","0","0","","","","","43000");
INSERT INTO sl_invoice VALUES("070001","2017-06-30","2610000001","0.00","0.00","1800.00","","","","","","","1150","","","","","","01","","2017-07-01 11:08:11","","0003","","0.000","","","1800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060103","2017-06-30","2610000001","0.00","0.00","6200.00","","","","","","","1151","","","","","","01","","2017-06-30 17:35:53","","0015","","0.000","","","6200.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060102","2017-06-30","2610000001","0.00","0.00","350.00","","","","","","","1149","","","","","","01","","2017-06-30 16:31:09","","0003","","0.000","","","350.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060101","2017-06-30","2610000001","0.00","0.00","3500.00","","","","","","","1148","","","","","","01","","2017-06-30 16:17:35","","0003","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060100","2017-06-30","2610000058","0.00","0.00","450000.00","","","","","","","1147","","","","","","01","","2017-07-01 11:20:20","","0001","","0.000","","","350000.00","","","","02","17","on","","","0","0","","","","","100000");
INSERT INTO sl_invoice VALUES("060095","2017-06-29","2610000035","0.00","0.00","22200.00","","","","","","","1142","","","","","","01","","2017-07-07 14:11:09","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","22200");
INSERT INTO sl_invoice VALUES("060094","2017-06-24","2610000035","0.00","0.00","400.00","","","","","","","1141","","","","","","01","","2017-06-30 11:27:59","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","400");
INSERT INTO sl_invoice VALUES("060093","2017-06-12","2610000056","0.00","0.00","650.00","","","","","","","3374","","","","","","01","","2017-06-23 16:16:34","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","650");
INSERT INTO sl_invoice VALUES("060092","2017-06-13","2610000057","0.00","0.00","10700.00","","","","","","","3380","","","","","","01","","2017-06-23 16:15:06","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","10700");
INSERT INTO sl_invoice VALUES("060091","2017-06-13","2610000027","0.00","0.00","10500.00","","","","","","","3383","","","","","","01","","2017-06-23 16:11:07","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","10500");
INSERT INTO sl_invoice VALUES("060090","2017-06-13","2610000056","0.00","0.00","10000.00","","","","","","","3385","","","","","","01","","2017-06-23 16:08:58","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","10000");
INSERT INTO sl_invoice VALUES("060089","2017-06-10","2610000030","0.00","0.00","154500.00","","","","","","","1139","","","","","","01","","2017-07-07 14:07:34","","0003","","0.000","","","68000.00","","","","02","17","on","","","0","0","","","","","86500");
INSERT INTO sl_invoice VALUES("060088","2017-06-03","2610000054","0.00","0.00","21600.00","","","","","","","1095","","","","","","01","","2017-06-23 15:54:06","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","21600");
INSERT INTO sl_invoice VALUES("060087","2017-06-23","2610000049","0.00","0.00","9600.00","","","","","","","1138","","","","","","01","","2017-06-23 15:49:39","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","9600");
INSERT INTO sl_invoice VALUES("060086","2017-05-27","2610000054","0.00","0.00","10000.00","","","","","","","1070","","","","","","01","","2017-06-23 15:30:58","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","10000");
INSERT INTO sl_invoice VALUES("060085","2017-05-25","2610000050","0.00","0.00","11650.00","","","","","","","1060","","","","","","01","","2017-06-23 15:28:41","","0003","","0.000","","","0.00","","","","02","17","","","","0","0","","","","","11650");
INSERT INTO sl_invoice VALUES("060084","2017-05-24","2610000056","0.00","0.00","12700.00","","","","","","","1057","","","","","","01","","2017-06-23 15:24:55","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","12700");
INSERT INTO sl_invoice VALUES("060083","2017-05-24","2610000050","0.00","0.00","6390.00","","","","","","","1056","","","","","","01","","2017-06-23 15:19:30","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","6390");
INSERT INTO sl_invoice VALUES("060082","2017-05-22","2610000001","0.00","0.00","950.00","","","","","","","1033","","","","","","01","","2017-06-23 15:08:37","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","950");
INSERT INTO sl_invoice VALUES("060081","2017-05-17","2610000054","0.00","500.00","28000.00","","","","","","","1018","","","","","","01","","2017-06-23 14:59:29","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","28000");
INSERT INTO sl_invoice VALUES("060080","2017-05-17","2610000053","0.00","0.00","1000.00","","","","","","","1015","","","","","","01","","2017-06-23 14:53:36","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","1000");
INSERT INTO sl_invoice VALUES("060011","2017-06-06","2610000027","0.00","0.00","150000.00","","","","","","","060011","","","","","","01","","2017-06-20 12:29:27","","0001","","0.000","","","0.00","","","","02","17","on","460/E-1 WAPDA TWON","","0","0","","","","","150000");
INSERT INTO sl_invoice VALUES("060009","2017-06-03","2610000001","150.00","0.00","27000.00","","","","","","","3361","","","","","","01","","2017-06-16 17:23:25","","0001","","0.000","","","27000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060079","2017-05-17","2610000052","0.00","0.00","38000.00","","","","","","","1014","","","","","","01","","2017-06-23 14:48:05","","0001","","0.000","","","20000.00","","","","02","17","on","","","0","0","","","","","18000");
INSERT INTO sl_invoice VALUES("060099","2017-06-30","2610000001","100.00","0.00","10000.00","","","","","","","1146","","","","","","01","","2017-06-30 15:41:21","","0003","","0.000","","","10000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060078","2017-05-16","2610000049","12500.00","0.00","219500.00","","","","","","","009","","","","","","01","","2017-06-29 13:03:32","","0001","","0.000","","","219500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060076","2017-06-23","2610000001","0.00","0.00","4800.00","","","","","","","1137","","","","","","01","","2017-06-23 15:13:12","","0001","","0.000","","","4800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060075","2017-05-12","2610000028","0.00","0.00","19000.00","","","","","","","1003","","","","","","01","","2017-06-23 13:56:49","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","19000");
INSERT INTO sl_invoice VALUES("060074","2017-05-12","2610000040","0.00","0.00","4800.00","","","","","","","1002","","","","","","01","","2017-06-23 13:53:59","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","4800");
INSERT INTO sl_invoice VALUES("060073","2017-05-08","2610000050","0.00","0.00","8700.00","","","","","","","3195","","","","","","01","","2017-06-23 12:57:41","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","8700");
INSERT INTO sl_invoice VALUES("060098","2017-06-30","2610000001","50.00","0.00","3700.00","","","","","","","1145","","","","","","01","","2017-06-30 16:10:39","","0001","","0.000","","","3700.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060072","2017-05-08","2610000028","0.00","0.00","124040.00","","","","","","","3193","","","","","","01","","2017-06-23 13:00:01","","0003","","0.000","","","51040.00","","","","02","17","on","","","0","0","","","","","73000");
INSERT INTO sl_invoice VALUES("060069","2017-06-20","2610000045","0.00","0.00","9000.00","","","","","","","1126","","","","","","01","","2017-06-22 16:35:15","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060070","2017-06-23","2610000049","0.00","1000.00","27500.00","","","","","","","1136","","","","","","01","","2017-06-30 11:51:47","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","27500");
INSERT INTO sl_invoice VALUES("060068","2017-06-22","2610000048","50.00","0.00","1600.00","","","","","","","1135","","","","","","01","","2017-06-22 14:05:07","","0001","","0.000","","","1600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060067","2017-06-22","2610000001","0.00","0.00","300.00","","","","","","","1134","","","","","","01","","2017-06-22 13:39:22","","0001","","0.000","","","300.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060066","2017-06-22","2610000001","400.00","0.00","18000.00","","","","","","","1133","","","","","","01","","2017-06-30 13:10:17","","0001","","0.000","","","18000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060096","2017-06-29","2610000045","0.00","0.00","5200.00","","","","","","","1143","","","","","","01","","2017-07-07 17:13:19","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","5200");
INSERT INTO sl_invoice VALUES("060064","2017-06-22","2610000048","370.00","0.00","6500.00","","","","","","","1132","","","","","","01","","2017-06-22 11:29:42","","0001","","0.000","","","6500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060063","2017-06-21","2610000001","0.00","0.00","5500.00","","","","","","","1131","","","","","","01","","2017-06-21 15:15:29","","0003","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060062","2017-06-21","2610000047","3450.00","0.00","55000.00","","","","","","","1130","","","","","","01","","2017-06-21 13:47:50","","0001","","0.000","","","55000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060061","2017-06-21","2610000047","39500.00","0.00","237000.00","","","","","","","1129","","","","","","01","","2017-06-21 14:32:05","","0001","","0.000","","","237000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060060","2017-06-21","2610000046","4434.00","0.00","16700.00","","","","","","","1128","","","","","","01","","2017-06-21 11:41:48","","0001","","0.000","","","16700.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060059","2017-06-20","2610000001","750.00","0.00","5500.00","","","","","","","1123","","","","","","01","","2017-06-30 13:07:53","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060057","2017-06-20","2610000001","60.00","0.00","300.00","","","","","","","1125","","","","","","01","","2017-06-20 14:41:44","","0003","","0.000","","","300.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060058","2017-06-20","2610000001","25.00","0.00","300.00","","","","","","","1127","","","","","","01","","2017-06-20 14:42:57","","0001","","0.000","","","300.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060056","2017-06-20","2610000001","1500.00","0.00","15000.00","","","","","","","1122","","","","","","01","","2017-06-30 13:06:03","","0003","","0.000","","","15000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060055","2017-06-20","2610000001","4000.00","0.00","45000.00","","","","","","","1120","","","","","","01","","2017-07-07 14:33:41","","0001","","0.000","","","45000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060054","2017-06-19","2610000001","0.00","0.00","2000.00","","","","","","","1119","","","","","","01","","2017-06-19 16:27:29","","0001","","0.000","","","2000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060097","2017-06-30","2610000001","0.00","0.00","1500.00","","","","","","","1144","","","","","","01","","2017-06-30 16:11:40","","0003","","0.000","","","1500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060052","2017-06-20","2610000045","860.00","0.00","9500.00","","","","","","","1118","","","","","","01","","2017-06-20 16:37:22","","0001","","0.000","","","8500.00","","","","02","17","on","","","0","0","","","","","1000");
INSERT INTO sl_invoice VALUES("060051","2017-06-19","2610000044","0.00","0.00","1000.00","","","","","","","1113","","","","","","01","","2017-06-19 12:38:23","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","1000");
INSERT INTO sl_invoice VALUES("060050","2017-06-20","2610000001","0.00","0.00","10950.00","","","","","","","1116","","","","","","01","","2017-06-20 14:32:10","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","10950");
INSERT INTO sl_invoice VALUES("060049","2017-06-20","2610000001","0.00","0.00","8275.00","","","","","","","1115","","","","","","01","","2017-06-20 14:31:17","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","8275");
INSERT INTO sl_invoice VALUES("060048","2017-06-17","2610000001","0.00","0.00","13000.00","","","","","","","1112","","","","","","01","","2017-06-17 17:23:36","","0003","","0.000","","","13000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060047","2017-06-17","2610000001","1500.00","0.00","15000.00","","","","","","","1111","","","","","","01","","2017-06-17 14:49:04","","0003","","0.000","","","15000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060046","2017-06-17","2610000001","0.00","0.00","45000.00","","","","","","","1110","","","","","","01","","2017-07-07 14:08:27","","0003","","0.000","","","14000.00","","","","02","17","on","","","0","0","","","","","31000");
INSERT INTO sl_invoice VALUES("060045","2017-06-17","2610000041","1500.00","0.00","19000.00","","","","","","","1109","","","","","","01","","2017-06-17 14:27:33","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","19000");
INSERT INTO sl_invoice VALUES("060043","2017-06-17","2610000001","0.00","0.00","3000.00","","","","","","","1107","","","","","","01","","2017-06-17 13:55:36","","0003","","0.000","","","3000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060044","2017-06-17","2610000001","500.00","0.00","4500.00","","","","","","","1108","","","","","","01","","2017-06-17 13:56:43","","0003","","0.000","","","4500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060040","2017-06-17","2610000001","66.00","0.00","94500.00","","","","","","","1557","","","","","","01","","2017-06-19 11:12:59","","0001","","0.000","","","94500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070002","2017-07-01","2610000059","1200.00","0.00","33000.00","","","","","","","1152","","","","","","01","","2017-07-01 12:23:12","","0003","","0.000","","","33000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060007","2017-06-03","2610000001","6900.00","0.00","148000.00","","","","","","","1099","","","","","","01","","2017-06-16 17:23:25","","0003","","0.000","","","148000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060005","2017-06-03","2610000001","5200.00","0.00","118000.00","","","","","","","1096","","","","","","01","","2017-06-16 17:23:25","","0003","","0.000","","","118000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060001","2017-06-01","2610000032","500.00","0.00","60000.00","","","","","","","1089","","","","","","01","","2017-06-16 17:37:02","","0001","","0.000","","","60000.00","","","","02","17","on","AHMAD SB","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060002","2017-06-01","2610000027","0.00","0.00","66500.00","","","","","","","1087","","","","","","01","","2017-06-16 17:33:49","","0001","","0.000","","","0.00","","","","02","17","on","WAPDA TWON","","0","0","","","","","66500");
INSERT INTO sl_invoice VALUES("060003","2017-06-01","2610000045","1800.00","0.00","25000.00","","","","","","","1088","","","","","","01","","2017-06-19 15:38:41","","0001","","0.000","","","25000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060012","2017-06-06","2610000027","0.00","0.00","36850.00","","","","","","","1094","","","","","","01","","2017-06-16 17:33:49","","0003","","0.000","","","36850.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060015","2017-06-07","2610000028","0.00","0.00","4500.00","","","","","","","060015","","","","","","01","","2017-07-07 14:32:51","","0003","","0.000","","","0.00","","","","02","17","on","245/G","","0","0","","","","","4500");
INSERT INTO sl_invoice VALUES("060027","2017-06-12","2610000001","0.00","0.00","47350.00","","","","","","","3377","","","","","","01","","2017-06-16 17:23:25","","0001","","0.000","","","47350.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060016","2017-06-07","2610000001","0.00","0.00","1850.00","","","","","","","060016","","","","","","01","","2017-06-20 12:42:32","","0003","","0.000","","","1850.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060018","2017-06-07","2610000029","11730.00","0.00","16800.00","","","","","","","3363","","","","","","01","","2017-06-29 13:51:00","","0001","","0.000","","","16800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060019","2017-06-08","2610000001","0.00","0.00","37400.00","","","","","","","3365","","","","","","01","","2017-06-16 17:23:25","","0001","","0.000","","","37400.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060020","2017-06-08","2610000029","7000.00","0.00","32900.00","","","","","","","3366","","","","","","01","","2017-06-29 12:00:12","","0001","","0.000","","","15000.00","","","","02","17","on","","","0","0","","","","","17900");
INSERT INTO sl_invoice VALUES("060021","2017-06-08","2610000030","4012.00","0.00","112000.00","","","","","","","3367","","","","","","01","","2017-06-29 12:10:26","","0001","","0.000","","","110000.00","","","","02","17","on","","","0","0","","","","","2000");
INSERT INTO sl_invoice VALUES("060026","2017-06-12","2610000001","40.00","0.00","37900.00","","","","","","","3376","","","","","","01","","2017-06-30 13:02:25","","0001","","0.000","","","30000.00","","","","02","17","on","","","0","0","","","","","7900");
INSERT INTO sl_invoice VALUES("060024","2017-06-10","2610000031","0.00","0.00","19000.00","","","","","","","3373","","","","","","01","","2017-06-16 17:40:51","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","19000");
INSERT INTO sl_invoice VALUES("060025","2017-06-12","2610000034","0.00","0.00","10500.00","","","","","","","3375","","","","","","01","","2017-06-16 17:42:41","","0001","","0.000","","","10500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060028","2017-06-12","2610000035","1000.00","0.00","30000.00","","","","","","","3378","","","","","","01","","2017-06-30 11:46:20","","0015","","0.000","","","30000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060035","2017-06-16","2610000001","250.00","500.00","14500.00","","","","","","","1101","","","","","","01","","2017-06-17 11:25:36","","0001","","0.000","","","14500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060030","2017-06-13","2610000001","0.00","0.00","28800.00","","","","","","","3382","","","","","","01","","2017-06-17 13:26:27","","0001","","0.000","","","28800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060031","2017-06-13","2610000001","15.00","1600.00","20400.00","","","","","","","3381","","","","","","01","","2017-06-17 13:25:54","","0001","","0.000","","","20400.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060032","2017-06-13","2610000001","23.00","0.00","2400.00","","","","","","","1558","","","","","","01","","2017-06-17 14:10:02","","0001","","0.000","","","2400.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060033","2017-06-14","2610000001","0.00","0.00","9000.00","","","","","","","1559","","","","","","01","","2017-06-16 12:14:41","","0001","","0.000","","","9000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("060034","2017-06-15","2610000001","0.00","0.00","11000.00","","","","","","","1560","","","","","","01","","2017-06-16 11:33:26","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","11000");
INSERT INTO sl_invoice VALUES("060042","2017-06-17","2610000040","0.00","0.00","2000.00","","","","","","","1106","","","","","","01","","2017-06-17 13:54:10","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","2000");
INSERT INTO sl_invoice VALUES("060036","2017-06-15","2610000038","20.00","0.00","34500.00","","","","","","","1102","","","","","","01","","2017-06-29 11:58:58","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","34500");
INSERT INTO sl_invoice VALUES("060037","2017-06-15","2610000038","100.00","0.00","18000.00","","","","","","","1103","","","","","","01","","2017-06-16 13:01:46","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","18000");
INSERT INTO sl_invoice VALUES("060038","2017-06-15","2610000038","0.00","0.00","32000.00","","","","","","","1104","","","","","","01","","2017-06-16 13:01:15","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","32000");
INSERT INTO sl_invoice VALUES("060041","2017-06-17","2610000001","0.00","0.00","2600.00","","","","","","","1105","","","","","","01","","2017-06-17 13:50:18","","0003","","0.000","","","2600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070020","2017-07-04","2610000001","0.00","0.00","8400.00","","","","","","","1165","","","","","","01","","2017-07-05 11:23:49","","0001","","0.000","","","8400.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070021","2017-07-04","2610000001","100.00","0.00","12000.00","","","","","","","1164","","","","","","01","","2017-07-05 11:31:50","","0001","","0.000","","","12000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070022","2017-07-05","2610000001","100.00","0.00","1100.00","","","","","","","1171","","","","","","01","","2017-07-06 12:34:26","","0003","","0.000","","","1100.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070023","2017-07-05","2610000001","4000.00","0.00","15000.00","","","","","","","1172","","","","","","01","","2017-07-06 12:38:43","","0003","","0.000","","","15000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070024","2017-07-05","2610000064","10800.00","0.00","160000.00","","","","","","","1173","","","","","","01","","2017-07-10 11:05:08","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","160000");
INSERT INTO sl_invoice VALUES("070025","2017-07-05","2610000065","0.00","0.00","31000.00","","","","","","","1174","","","","","","01","","2017-07-06 12:48:44","","0003","","0.000","","","5000.00","","","","02","17","on","","","0","0","","","","","26000");
INSERT INTO sl_invoice VALUES("070026","2017-07-05","2610000001","0.00","0.00","6000.00","","","","","","","1175","","","","","","01","","2017-07-06 12:56:57","","0003","","0.000","","","1000.00","","","","02","17","on","","","0","0","","","","","5000");
INSERT INTO sl_invoice VALUES("070028","2017-07-05","2610000066","0.00","0.00","55200.00","","","","","","","1177","","","","","","01","","2017-07-06 13:48:51","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","55200");
INSERT INTO sl_invoice VALUES("070027","2017-07-05","2610000066","1300.00","0.00","102800.00","","","","","","","1176","","","","","","01","","2017-07-10 15:25:46","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","102800");
INSERT INTO sl_invoice VALUES("070029","2017-07-06","2610000049","4500.00","0.00","100000.00","","","","","","","1178","","","","","","01","","2017-07-07 13:11:15","","0001","","0.000","","","100000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070030","2017-07-06","2610000067","3966.00","2710.00","40000.00","","","","","","","1179","","","","","","01","","2017-07-12 19:22:52","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","40000");
INSERT INTO sl_invoice VALUES("070031","2017-07-06","2610000052","0.00","0.00","15000.00","","","","","","","1180","","","","","","01","","2017-07-07 13:07:58","","0001","","0.000","","","15000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070032","2017-07-06","2610000052","0.00","0.00","9000.00","","","","","","","1181","","","","","","01","","2017-07-07 13:08:56","","0001","","0.000","","","9000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070034","2017-05-09","2610000056","0.00","0.00","54900.00","","","","","","","3353","","","","","","01","","2017-07-08 13:52:38","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","54900");
INSERT INTO sl_invoice VALUES("070035","2017-07-08","2610000068","0.00","0.00","42000.00","","","","","","","1185","","","","","","01","","2017-07-08 15:53:40","","0001","","0.000","","","42000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070036","2017-07-08","2610000069","0.00","0.00","9000.00","","","","","","","1186","","","","","","01","","2017-07-08 16:25:32","","0001","","0.000","","","9000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070037","2017-07-08","2610000044","0.00","0.00","1000.00","","","","","","","1188","","","","","","01","","2017-07-08 16:56:51","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","1000");
INSERT INTO sl_invoice VALUES("070038","2017-07-08","2610000001","3000.00","0.00","25500.00","","","","","","","1187","","","","","","01","","2017-07-08 17:42:30","","0001","","0.000","","","25500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070039","2017-07-08","2610000070","0.00","0.00","15000.00","","","","","","","1189","","","","","","01","","2017-07-08 17:44:55","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","15000");
INSERT INTO sl_invoice VALUES("070040","2017-07-08","2610000066","0.00","0.00","13000.00","","","","","","","1190","","","","","","01","","2017-07-10 15:13:20","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","13000");
INSERT INTO sl_invoice VALUES("070041","2017-07-10","2610000001","0.00","300.00","23300.00","","","","","","","1191","","","","","","01","","2017-07-10 11:25:28","","0003","","0.000","","","23300.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070042","2017-07-11","2610000066","0.00","0.00","3500.00","","","","","","","1192","","","","","","01","","2017-07-11 11:49:36","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","3500");
INSERT INTO sl_invoice VALUES("070043","2017-07-11","2610000001","0.00","0.00","15000.00","","","","","","","1193","","","","","","01","","2017-07-12 10:51:39","","0001","","0.000","","","15000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("070044","2017-07-11","2610000056","0.00","0.00","2000.00","","","","","","","1195","","","","","","01","","2017-07-11 19:07:34","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","2000");
INSERT INTO sl_invoice VALUES("070045","2017-07-11","2610000001","0.00","0.00","1800.00","","","","","","","1194","","","","","","01","","2017-07-12 10:55:17","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","1800");
INSERT INTO sl_invoice VALUES("070047","2017-07-12","2610000032","0.00","0.00","62280.00","","","","","","","1198","","","","","","01","","2017-07-12 15:31:29","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","62280");
INSERT INTO sl_invoice VALUES("070046","2017-07-12","2610000066","0.00","0.00","9100.00","","","","","","","1197","","","","","","01","","2017-07-12 14:17:08","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","9100");
INSERT INTO sl_invoice VALUES("070048","2017-07-12","2610000030","0.00","0.00","3250.00","","","","","","","1199","","","","","","01","","2017-07-12 15:34:06","","0003","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","3250");
INSERT INTO sl_invoice VALUES("070049","2017-07-12","2610000001","500.00","0.00","500.00","","","","","","","1200","","","","","","01","","2017-07-13 10:27:14","","0001","","0.000","","","500.00","","","","02","17","on","","","0","0","","","","","0");


DROP TABLE IF EXISTS sl_invoice_rec;

CREATE TABLE `sl_invoice_rec` (
  `REC_ID` varchar(7) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_invoicedet;

CREATE TABLE `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_invoicedet VALUES("060005","5","3822","","1.000","4500.00000","4500.00","","","","0","","3847.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060005","1","3493","","1.000","52000.00000","52000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060004","3","3477","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070049","1","4015","","1.000","800.00000","800.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070049","2","4156","","1.000","200.00000","200.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070048","1","3947","","5.000","650.00000","3250.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070047","4","4343","","24.000","60.00000","1440.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070047","3","4229","","144.000","60.00000","8640.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070047","2","4225","","360.000","95.00000","34200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070047","1","4225","","200.000","90.00000","18000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070046","5","3987","","10.000","425.00000","4250.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070046","4","3986","","6.000","275.00000","1650.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070046","3","3974","","1.000","300.00000","300.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070046","2","4336","","1.000","1100.00000","1100.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070030","4","4225","","27.000","128.00000","3456.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070046","1","3963","","6.000","300.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070045","1","4364","","1.000","1800.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070044","1","3895","","2.000","1000.00000","2000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070041","3","4409","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070043","2","4410","","1.000","7500.00000","7500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070042","1","3867","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070043","1","3470","","1.000","7500.00000","7500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070041","2","4408","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070040","1","4396","","1.000","13000.00000","13000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070039","1","4248","","5.000","3000.00000","15000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070041","1","3534","","1.000","9000.00000","9000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070038","3","4222","","10.000","1000.00000","10000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070038","1","3732","","1.000","10500.00000","10500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070036","1","4405","","1.000","9000.00000","9000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070037","1","4406","","1.000","1000.00000","1000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070038","2","4407","","1.000","8000.00000","8000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070035","4","3525","","1.000","9500.00000","9500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070035","3","4404","","1.000","6500.00000","6500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070035","1","4402","","1.000","20000.00000","20000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070035","2","4403","","1.000","6000.00000","6000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","7","4021","","5.000","200.00000","1000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","6","3950","","1.000","1000.00000","1000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","5","3947","","5.000","600.00000","3000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","4","4018","","3.000","300.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","3","4222","","3.000","1500.00000","4500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","2","3748","","3.000","12500.00000","37500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070034","1","3732","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070032","1","3733","","1.000","9000.00000","9000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070031","1","4322","","1.000","15000.00000","15000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070030","3","4230","","8.000","45.00000","360.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070030","2","4229","","64.000","45.00000","2880.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070030","1","4225","","270.000","128.00000","34560.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070029","1","3534","","1.000","25000.00000","25000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070029","6","4201","","1.000","3000.00000","3000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070029","5","3500","","1.000","54000.00000","54000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070029","4","3894","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070029","3","4273","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070029","2","4200","","1.000","15500.00000","15500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","12","4023","","2.000","200.00000","400.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","11","3947","","2.000","500.00000","1000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","9","4018","","1.000","300.00000","300.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","10","4321","","1.000","14000.00000","14000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","8","4031","","1.000","300.00000","300.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","7","4399","","1.000","9500.00000","9500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","6","4222","","1.000","1200.00000","1200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","4","4238","","1.000","17000.00000","17000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","5","3738","","1.000","8000.00000","8000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","3","3974","","3.000","300.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","2","3978","","1.000","800.00000","800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070028","1","3960","","1.000","1800.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","20","4325","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","19","4004","","1.000","2000.00000","2000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","18","4398","","1.000","43000.00000","43000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","17","3849","","1.000","2500.00000","2500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","16","3978","","1.000","800.00000","800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","15","3975","","3.000","300.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","11","4023","","1.000","200.00000","200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","12","4397","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","13","3732","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","14","4222","","1.000","1200.00000","1200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","10","3947","","1.000","500.00000","500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","1","3490","","1.000","3000.00000","3000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","2","4284","","1.000","5000.00000","5000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","3","3975","","2.000","300.00000","600.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","4","4396","","1.000","13000.00000","13000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","5","3849","","1.000","3000.00000","3000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","6","3975","","3.000","300.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","7","3978","","1.000","800.00000","800.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","8","3738","","1.000","8000.00000","8000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070027","9","4222","","1.000","1200.00000","1200.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070026","1","4395","","1.000","6000.00000","6000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070025","1","4393","","1.000","31000.00000","31000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070024","5","3493","","2.000","56000.00000","112000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070024","4","4334","","3.000","6000.00000","18000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070024","3","4334","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070024","2","4200","","2.000","14900.00000","29800.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070024","1","4202","","1.000","7500.00000","7500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070023","2","3950","","10.000","1200.00000","12000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070023","1","3947","","10.000","700.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070022","3","3986","","1.000","0.00000","0.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070022","2","3989","","3.000","0.00000","0.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070033","6","4401","","1.000","4000.00000","4000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070020","2","4363","","1.000","4500.00000","4500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070022","1","3986","","4.000","300.00000","1200.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070021","1","4392","","1.000","3600.00000","3600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070021","2","4247","","1.000","8500.00000","8500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070020","1","4391","","1.000","3900.00000","3900.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070033","5","4153","","2.000","450.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070033","1","4154","","5.000","450.00000","2250.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070033","2","4155","","4.000","450.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070033","4","4152","","4.000","450.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070033","3","4156","","4.000","450.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070018","5","4388","","1.000","25000.00000","25000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070018","4","4031","","3.000","300.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070018","3","4387","","3.000","15280.00000","45840.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070018","2","4029","","3.000","1500.00000","4500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070017","6","4317","","1.000","2000.00000","2000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070017","5","4386","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070017","3","4384","","1.000","5000.00000","5000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","12","4381","","1.000","54000.00000","54000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070017","2","4383","","1.000","4000.00000","4000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070017","4","4385","","1.000","5000.00000","5000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070017","1","4382","","1.000","8000.00000","8000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070018","1","3739","","3.000","10800.00000","32400.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","11","3647","","1.000","49000.00000","49000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","10","3894","","2.000","3000.00000","6000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","9","4284","","1.000","5000.00000","5000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","8","4306","","40.000","548.00000","21920.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","7","3866","","6.000","3430.00000","20580.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","6","4004","","5.000","2000.00000","10000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","4","3887","","3.000","6280.00000","18840.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","1","4325","","3.000","5915.00000","17745.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","3","4379","","3.000","8176.00000","24528.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","2","4378","","2.000","7000.00000","14000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070016","5","4380","","5.000","2000.00000","10000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070015","1","4216","","1.000","1800.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070015","2","3886","","2.000","14640.00000","29280.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070014","1","3989","","6.000","275.00000","1650.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070014","2","4017","","2.000","1200.00000","2400.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070014","3","4041","","6.000","150.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070013","1","4040","","10.000","10.00000","100.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070013","2","4377","","10.000","80.00000","800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070012","1","4021","","6.000","300.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070011","1","4375","","2.000","6350.00000","12700.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070011","2","4376","","1.000","6350.00000","6350.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070010","2","4221","","3.000","10300.00000","30900.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070010","1","4325","","2.000","8200.00000","16400.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070009","1","4370","","1.000","19000.00000","19000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070008","1","4369","","1.000","2500.00000","2500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070007","1","3621","","3.000","59000.00000","177000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070006","1","4368","","1.000","2500.00000","2500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070006","2","3752","","1.000","12000.00000","12000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070005","1","4327","","1.000","1500.00000","1500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070004","1","3813","","1.000","4000.00000","4000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","15","4036","","8.000","60.00000","480.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","14","4034","","8.000","50.00000","400.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","13","4367","","8.000","590.00000","4720.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","11","3887","","4.000","6360.00000","25440.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","10","3769","","1.000","12825.00000","12825.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","9","3974","","4.000","590.00000","2360.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","8","3950","","2.000","900.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","5","4002","","2.000","2500.00000","5000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","4","3977","","2.000","1000.00000","2000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","7","4367","","4.000","590.00000","2360.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","6","3887","","2.000","6360.00000","12720.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","12","3950","","4.000","900.00000","3600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070002","3","4018","","2.000","300.00000","600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070002","4","4365","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","1","4067","","2.000","1500.00000","3000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","2","4366","","2.000","7700.00000","15400.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060095","1","4198","","2.000","3500.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070003","3","4329","","2.000","800.00000","1600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070002","2","4031","","2.000","300.00000","600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060103","2","3826","","2.000","1200.00000","2400.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060092","1","3978","","2.000","1500.00000","3000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060092","2","3826","","2.000","1150.00000","2300.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060092","3","3976","","6.000","600.00000","3600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060092","4","4243","","2.000","900.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060093","1","3974","","2.000","325.00000","650.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060094","1","4043","","2.000","200.00000","400.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060095","2","4352","","1.000","4000.00000","4000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060091","1","3860","","3.000","3500.00000","10500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060090","2","4284","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060089","5","4349","","1.000","16500.00000","16500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060090","1","4350","","1.000","6500.00000","6500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060089","4","4348","","1.000","29500.00000","29500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060089","3","4348","","1.000","29500.00000","29500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060089","2","4347","","1.000","39500.00000","39500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060089","1","4347","","1.000","39500.00000","39500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060088","5","3826","","1.000","1000.00000","1000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060088","4","4156","","8.000","850.00000","6800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060088","3","4155","","6.000","800.00000","4800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060088","1","4154","","5.000","950.00000","4750.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060087","1","4346","","2.000","4800.00000","9600.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060088","2","4153","","5.000","850.00000","4250.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060085","1","4027","","2.000","2000.00000","4000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060085","2","3735","","1.000","7650.00000","7650.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060084","1","3472","","1.000","7000.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060086","1","4273","","1.000","7500.00000","7500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060086","2","4334","","1.000","2500.00000","2500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060084","3","3544","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060083","1","3699","","1.000","6390.00000","6390.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060005","4","3469","","1.000","7000.00000","7000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060005","3","3544","","1.000","15500.00000","15500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060084","2","3469","","1.000","2200.00000","2200.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060076","2","4345","","1.000","0.00000","0.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060081","4","3536","","1.000","13000.00000","13000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060082","1","3947","","1.000","650.00000","650.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060082","2","4023","","1.000","300.00000","300.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060081","3","3558","","1.000","7500.00000","7500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060081","1","3490","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060081","2","4088","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060080","1","4031","","1.000","300.00000","300.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060079","1","3753","","4.000","9500.00000","38000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060080","2","4018","","1.000","700.00000","700.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","11","3887","","4.000","6500.00000","26000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","10","3849","","3.000","5500.00000","16500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","8","3698","","1.000","9500.00000","9500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","9","4297","","1.000","9500.00000","9500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","7","4239","","1.000","10500.00000","10500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","6","4238","","1.000","20000.00000","20000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","5","4239","","1.000","30000.00000","30000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","4","4342","","1.000","45000.00000","45000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","3","3733","","5.000","9500.00000","47500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","2","3731","","1.000","8500.00000","8500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060099","1","4360","","1.000","4500.00000","4500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060078","1","4222","","6.000","1500.00000","9000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","1","4364","","1.000","1800.00000","1800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060099","2","4153","","2.000","600.00000","1200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060099","3","4053","","1.000","2200.00000","2200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060099","4","3826","","1.000","1500.00000","1500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060099","5","4155","","1.000","700.00000","700.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060101","1","4353","","1.000","3500.00000","3500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060100","1","4361","","20.000","19000.00000","380000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060100","2","4362","","5.000","14000.00000","70000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060076","1","3974","","12.000","400.00000","4800.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060075","1","4344","","1.000","19000.00000","19000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060074","2","4043","","1.000","150.00000","150.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060074","1","4293","","1.000","4650.00000","4650.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060073","4","4041","","6.000","250.00000","1500.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060073","3","3947","","6.000","700.00000","4200.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060073","2","4022","","5.000","150.00000","750.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060073","1","3995","","5.000","450.00000","2250.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060072","5","4088","","2.000","3500.00000","7000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060072","2","4325","","5.000","7030.00000","35150.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060102","1","4039","","2.000","175.00000","350.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060103","1","4363","","1.000","3800.00000","3800.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060069","1","3731","","1.000","9000.00000","9000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060072","4","3894","","1.000","6500.00000","6500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060072","3","3888","","7.000","7770.00000","54390.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060070","1","3676","","1.000","26500.00000","26500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060072","1","3866","","6.000","3500.00000","21000.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060097","1","4358","","1.000","1500.00000","1500.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060068","2","4039","","1.000","150.00000","150.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060068","1","4339","","1.000","1500.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060067","1","4021","","1.000","300.00000","300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060066","6","4179","","2.000","350.00000","700.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060066","5","4172","","5.000","1400.00000","7000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060066","4","4340","","1.000","3100.00000","3100.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060066","3","4254","","1.000","4500.00000","4500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060066","2","4339","","1.000","1600.00000","1600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060066","1","3966","","3.000","500.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060098","2","4022","","1.000","150.00000","150.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060096","2","4354","","1.000","2175.00000","2175.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060096","1","4353","","1.000","3025.00000","3025.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","8","4015","","2.000","600.00000","1200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","6","4034","","6.000","80.00000","480.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","7","4036","","2.000","95.00000","190.00","","","","0","","80.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","5","4018","","1.000","250.00000","250.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","1","3974","","5.000","400.00000","2000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","10","3866","","6.000","3300.00000","19800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060063","1","3585","","1.000","5500.00000","5500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","4","4031","","1.000","350.00000","350.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","3","3826","","1.000","1200.00000","1200.00","","","","0","","1290.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060064","2","3969","","1.000","1200.00000","1200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","12","3957","","6.000","200.00000","1200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","11","3947","","6.000","600.00000","3600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","9","4018","","1.000","250.00000","250.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","8","4336","","1.000","1500.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","7","4167","","6.000","800.00000","4800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","5","4165","","5.000","800.00000","4000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","6","4166","","1.000","800.00000","800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","4","4044","","60.000","15.00000","900.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","3","4335","","1.000","18000.00000","18000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","2","4035","","24.000","80.00000","1920.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060062","1","4036","","24.000","70.00000","1680.00","","","","0","","80.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","19","4034","","24.000","60.00000","1440.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","18","3986","","11.000","300.00000","3300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","11","4334","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","12","4334","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","13","4098","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","14","4088","","1.000","4500.00000","4500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","15","3963","","9.000","350.00000","3150.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","16","3966","","1.000","450.00000","450.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","17","3989","","21.000","300.00000","6300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","10","4334","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","9","4222","","6.000","1200.00000","7200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","8","3733","","6.000","9500.00000","57000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","5","4040","","2.000","80.00000","160.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","6","4004","","4.000","2500.00000","10000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","7","3974","","32.000","300.00000","9600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","2","4332","","2.000","13600.00000","27200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","3","4333","","2.000","11900.00000","23800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","4","3857","","2.000","4500.00000","9000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060060","1","4331","","1.000","21134.00000","21134.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060059","1","3977","","1.000","1200.00000","1200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060059","2","4069","","1.000","1800.00000","1800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060059","4","4002","","1.000","2500.00000","2500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060059","3","4329","","1.000","750.00000","750.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060058","1","3975","","1.000","325.00000","325.00","","","","0","","438.387","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060056","1","4321","","1.000","12000.00000","12000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060056","2","4282","","1.000","4500.00000","4500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060061","1","3893","","6.000","13900.00000","83400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060055","1","4328","","20.000","2450.00000","49000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060057","1","4040","","4.000","90.00000","360.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060054","1","4327","","1.000","2000.00000","2000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060098","1","4359","","2.000","1800.00000","3600.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060095","3","4357","","1.000","11200.00000","11200.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060052","6","4041","","1.000","250.00000","250.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060051","1","3826","","1.000","1000.00000","1000.00","","","","0","","1290.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060052","4","3957","","1.000","300.00000","300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060052","3","3953","","1.000","1500.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060052","2","4044","","12.000","25.00000","300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060050","1","3905","","1.000","6450.00000","6450.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060050","2","3857","","1.000","4500.00000","4500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060046","1","4320","","1.000","45000.00000","45000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060049","4","4323","","2.000","800.00000","1600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060049","1","4222","","3.000","1400.00000","4200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060048","1","4322","WITH THIMBAL GRESS","1.000","13000.00000","13000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060047","1","4321","","1.000","12000.00000","12000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060047","2","4282","","1.000","4500.00000","4500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060049","5","4324","","2.000","250.00000","500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060040","6","3913","","1.000","18650.00000","18650.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060040","5","4315","","1.000","14650.00000","14650.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060040","3","3908","","2.000","11528.00000","23056.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060040","4","4313","","1.000","7160.00000","7160.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060001","3","4239","","1.000","20000.00000","20000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060040","2","3906","","1.000","10900.00000","10900.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060005","2","3534","","1.000","25000.00000","25000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060040","1","4314","","1.000","20150.00000","20150.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060004","2","3490","","1.000","2500.00000","2500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060001","4","4028","14\'\' TUCH","1.000","4000.00000","4000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060001","1","4238","","1.000","16000.00000","16000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060004","1","4247","","1.000","9000.00000","9000.00","","","","0","","7500.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060001","2","4237","","1.000","10000.00000","10000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060001","5","4028","48\'\' TUCH","1.000","5500.00000","5500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060001","6","4028","36\'\' TUCH","1.000","5000.00000","5000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060002","1","3733","NOT PAY PYMENT","7.000","8000.00000","56000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060002","2","4222","","7.000","1500.00000","10500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","1","3826","","1.000","1300.00000","1300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","2","3969","","1.000","1300.00000","1300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","3","3974","","2.000","650.00000","1300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","4","3820","","1.000","5500.00000","5500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","5","3946","","1.000","700.00000","700.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","6","3953","","1.000","1200.00000","1200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","7","4228","","1.000","3000.00000","3000.00","","","","0","","3174.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","8","3986","","2.000","350.00000","700.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","9","4241","","1.000","11000.00000","11000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060003","10","4187","","1.000","800.00000","800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","3","4254","","1.000","4700.00000","4700.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060006","1","4251","","1.000","13000.00000","13000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060005","7","3974","","2.000","350.00000","700.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060005","6","4250","","1.000","18500.00000","18500.00","","","","0","","14500.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","2","4252","","1.000","2800.00000","2800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","1","3610","","1.000","45600.00000","45600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","4","4255","","1.000","8500.00000","8500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","5","4253","","1.000","3900.00000","3900.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","6","3733","","5.000","9000.00000","45000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","7","4031","","5.000","300.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","8","4018","","5.000","300.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","9","3490","","1.000","3000.00000","3000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","10","3474","","1.000","2400.00000","2400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","11","3585","","1.000","7000.00000","7000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","12","3566","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","13","3534","","1.000","12000.00000","12000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060007","14","3535","","1.000","9500.00000","9500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060008","1","4256","","1.000","10000.00000","10000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060008","2","4257","","1.000","2000.00000","2000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060008","3","3888","","1.000","7350.00000","7350.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060008","4","4258","","1.000","20000.00000","20000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060008","5","4259","","1.000","5000.00000","5000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060008","6","4260","","2.000","5000.00000","10000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060009","1","4261","","1.000","16400.00000","16400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060009","2","3987","","1.000","550.00000","550.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060009","3","3927","","1.000","3900.00000","3900.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060009","4","4248","","1.000","2800.00000","2800.00","","","","0","","2520.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060009","5","4262","","1.000","3500.00000","3500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060010","1","4083","","1.000","3000.00000","3000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060010","2","3986","","1.000","300.00000","300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060011","3","4268","","2.000","22000.00000","44000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060011","2","4267","","2.000","24000.00000","48000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060011","1","4266","","2.000","25000.00000","50000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060011","4","4269","","1.000","8000.00000","8000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060012","1","4270","","1.000","18850.00000","18850.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060012","2","3718","","3.000","5000.00000","15000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060012","3","3947","","3.000","700.00000","2100.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060015","1","4273","","1.000","4500.00000","4500.00","","","","0","","3500.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","6","4018","","6.000","250.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","5","4276","","1.000","6780.00000","6780.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","1","4014","","1.000","250.00000","250.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","2","4029","","1.000","200.00000","200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","4","4275","","1.000","5100.00000","5100.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","3","4274","","1.000","5400.00000","5400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060016","2","3974","","1.000","650.00000","650.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060016","1","3826","","1.000","1200.00000","1200.00","","","","0","","1400.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","8","4278","","1.000","10000.00000","10000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","7","3947","","1.000","600.00000","600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060018","6","4018","","1.000","200.00000","200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060020","4","4282","","1.000","3800.00000","3800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060020","3","4279","","1.000","18000.00000","18000.00","","","","0","","17340.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060020","1","4281","","1.000","13000.00000","13000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060020","2","4275","","1.000","5100.00000","5100.00","","","","0","","3964.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060012","4","4023","","3.000","300.00000","900.00","","","","0","","","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060019","1","4280","","2.000","18700.00000","37400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","5","4000","","2.000","3500.00000","7000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","4","4284","","2.000","5000.00000","10000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","3","4222","","6.000","1200.00000","7200.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","2","3741","","2.000","8000.00000","16000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","1","4283","","4.000","8000.00000","32000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","6","4285","","3.000","2500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","7","4034","","36.000","65.00000","2340.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","8","4035","","24.000","80.00000","1920.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","9","4039","","8.000","175.00000","1400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","10","4041","","6.000","150.00000","900.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","11","3989","","16.000","275.00000","4400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","12","4044","","36.000","12.00000","432.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","13","3964","","5.000","300.00000","1500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","14","3974","","36.000","325.00000","11700.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","15","3895","","6.000","750.00000","4500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","16","4286","","36.000","20.00000","720.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060021","17","4098","","1.000","6500.00000","6500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","5","4292","","1.000","4450.00000","4450.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070002","1","3745","","2.000","13000.00000","26000.00","","","","0","","","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","7","3987","","3.000","275.00000","825.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","3","4243","","3.000","1350.00000","4050.00","","","","0","","1457.500","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","4","4291","","1.000","2565.00000","2565.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060024","1","4288","","1.000","19000.00000","19000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","1","4311","","17.000","800.00000","13600.00","","","","0","","270.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060025","1","3534","","1.000","10500.00000","10500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","2","3826","","3.000","1300.00000","3900.00","","","","0","","1224.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","8","4023","","3.000","200.00000","600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","9","3947","","3.000","650.00000","1950.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","10","4044","","24.000","20.00000","480.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","11","4034","","12.000","60.00000","720.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","12","4036","","12.000","75.00000","900.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","13","3964","","2.000","300.00000","600.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060026","14","4293","","1.000","1800.00000","1800.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060027","1","4261","","1.000","13450.00000","13450.00","","","","0","","13443.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060027","2","4261","8X8 RAIN SHOWER","2.000","16950.00000","33900.00","","","","0","","13443.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060028","2","3813","","2.000","4000.00000","8000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060028","1","4290","","1.000","7000.00000","7000.00","","","","0","","6609.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060028","3","4254","","2.000","6000.00000","12000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060028","4","3691","","1.000","4000.00000","4000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","3","4294","34X45","14.000","105.00000","1470.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","2","4294","33X47","14.000","105.00000","1470.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060030","1","4235","","16.000","1800.00000","28800.00","","","","0","","1100.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060052","1","4035","","6.000","85.00000","510.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","1","4294","34X45","14.000","105.00000","1470.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","4","4294","70X37","19.000","105.00000","1995.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","5","4294","33X46","14.000","105.00000","1470.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","6","4294","34X45","14.000","105.00000","1470.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","7","4294","34X45","14.000","105.00000","1470.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060031","8","4295","99X92","64.000","125.00000","8000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060036","3","4304","","6.000","4380.00000","26280.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060032","2","3828","","1.000","1233.00000","1233.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060032","1","3826","510","1.000","1190.00000","1190.00","","","","0","","1224.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060034","1","3740","N-P","1.000","11000.00000","11000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060033","1","3692","","1.000","9000.00000","9000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060037","2","4305","","2.000","4500.00000","9000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060052","5","4325","","1.000","7500.00000","7500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060049","3","4041","","5.000","125.00000","625.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060036","2","4303","","4.000","1100.00000","4400.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060037","1","4023","","26.000","350.00000","9100.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060035","1","3762","","5.000","2500.00000","12500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060035","2","4024","","5.000","350.00000","1750.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060036","1","4302","","48.000","80.00000","3840.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060049","6","4020","","2.000","150.00000","300.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060038","1","4312","","40.000","800.00000","32000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060044","1","4318","","1.000","5000.00000","5000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060045","1","4319","","1.000","20500.00000","20500.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060043","1","4317","","1.000","3000.00000","3000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060042","1","4316","","1.000","2000.00000","2000.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060041","1","3826","510","2.000","1300.00000","2600.00","","","","0","","1253.333","","0.00","","","","","02","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("060049","2","3974","","3.000","350.00000","1050.00","","","","0","","0.000","","0.00","","","","","02","17","0.000","0.00","0","0","0","","");


DROP TABLE IF EXISTS sl_invoicedet_bon;

CREATE TABLE `sl_invoicedet_bon` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_invoicedetapp;

CREATE TABLE `sl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_jv;

CREATE TABLE `sl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_jvdet;

CREATE TABLE `sl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_jvdet_inst;

CREATE TABLE `sl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_order;

CREATE TABLE `sl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `po_no` varchar(10) NOT NULL DEFAULT '',
  `po_date` date DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_orderdet;

CREATE TABLE `sl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_party_add;

CREATE TABLE `sl_party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_pay;

CREATE TABLE `sl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) DEFAULT '',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(10) DEFAULT '',
  `other_id_2` varchar(10) DEFAULT '',
  `other_id_3` varchar(10) DEFAULT '',
  `itax_id` varchar(10) DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_paydet;

CREATE TABLE `sl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_paydet_inst;

CREATE TABLE `sl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_payment;

CREATE TABLE `sl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) NOT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(100) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_paymentdet;

CREATE TABLE `sl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_po;

CREATE TABLE `sl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_podet;

CREATE TABLE `sl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `BONUS_QTY` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_product;

CREATE TABLE `sl_product` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `O_QTY` decimal(10,3) DEFAULT NULL,
  `O_RATE` decimal(10,2) DEFAULT NULL,
  `CAT_ID` varchar(6) NOT NULL,
  `TYPE_ID` varchar(10) NOT NULL,
  `BATCHWISE` varchar(1) NOT NULL,
  `REG_NO` varchar(10) DEFAULT NULL,
  `PACK_SIZE` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) NOT NULL,
  `P_RATE` decimal(10,2) DEFAULT NULL,
  `TYPE_GRP` varchar(1) NOT NULL,
  `PACK_RATE` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(10,3) NOT NULL,
  `ALL_CUST` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `GRP_ID` varchar(2) NOT NULL,
  `MOL_QTY` decimal(10,3) DEFAULT NULL,
  `MOL` varchar(1) DEFAULT NULL,
  `OLD_CODE` varchar(9) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PART_NO` varchar(30) DEFAULT NULL,
  `SAMPL_ID` varchar(4) DEFAULT NULL,
  `SAMPLE_ID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_product_brand;

CREATE TABLE `sl_product_brand` (
  `PROD_ID` varchar(4) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_product_rm;

CREATE TABLE `sl_product_rm` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(13,6) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `RM_ID` varchar(4) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO sl_product_rm VALUES("0356","0.000310","1","0027","01");


DROP TABLE IF EXISTS sl_products_log;

CREATE TABLE `sl_products_log` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `POST_DATE` datetime NOT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_quote;

CREATE TABLE `sl_quote` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(10,2) NOT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(5) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_quotedet;

CREATE TABLE `sl_quotedet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `UNIT_RATE` decimal(10,3) NOT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,0) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receipt;

CREATE TABLE `sl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receiptdet;

CREATE TABLE `sl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receiptdet_acct;

CREATE TABLE `sl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receiptdet_inv;

CREATE TABLE `sl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_return;

CREATE TABLE `sl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_return VALUES("SL050001","2017-05-16","0026","0.00","0.00","4000.00","","","","","","","1774","","","","","","01","","2017-05-18 15:24:04","","0007","","0.000","","","0.00","","","","01","17","on","MUHAMMAD","03214420814","0","0","","","","","4000");
INSERT INTO sl_return VALUES("RT050001","2017-05-16","0026","0.00","0.00","2800.00","","","","","","","5575","","","","","","01","","2017-05-18 15:38:53","","0001","","0.000","","","0.00","","","","01","17","on","mr . 82k","","0","0","","","","","2800");
INSERT INTO sl_return VALUES("RT050002","2017-05-17","0026","0.00","0.00","4815.25","","","","","","","8835","","","","","","01","","2017-05-19 16:34:32","","0004","","0.000","","","0.00","","","","01","17","on","SARFRAZ SB","","0","0","","","","","4815");
INSERT INTO sl_return VALUES("RT050003","2017-05-22","0026","0.00","0.00","1300.00","","","","","","","8752","","","","","","01","","2017-05-27 17:31:31","","0002","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","1300");
INSERT INTO sl_return VALUES("RT050004","2017-05-22","0026","0.00","0.00","10125.00","","","","","","","8757","","","","","","01","","2017-05-27 17:45:37","","0002","","0.000","","","0.00","","","","01","17","on","TAHIR SB","","0","0","","","","","10125");
INSERT INTO sl_return VALUES("RT050005","2017-05-22","0026","0.00","0.00","4000.00","","","","","","","866","","","","","","01","","2017-05-29 10:03:37","","0001","","0.000","","","0.00","","","","01","17","on","262/L","","0","0","","","","","4000");
INSERT INTO sl_return VALUES("RT050006","2017-05-22","0026","0.00","0.00","3500.00","","","","","","","867","","","","","","01","","2017-05-29 10:08:14","","0006","","0.000","","","0.00","","","","01","17","on","AWAIS","","0","0","","","","","3500");
INSERT INTO sl_return VALUES("52","2017-05-24","0026","0.00","0.00","18500.00","","","","","","","8771","","","","","","01","","2017-05-29 11:57:20","","0002","","0.000","","","0.00","","","","01","17","","","","0","0","","","","","18500");
INSERT INTO sl_return VALUES("RT050007","2017-05-24","0026","0.00","0.00","8600.00","","","","","","","5457","","","","","","01","","2017-05-29 12:12:35","","0002","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","8600");
INSERT INTO sl_return VALUES("RT060001","2017-06-07","2610000001","0.00","0.00","18850.00","","","","","","","","","","","","","01","","2017-06-19 15:35:24","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","18850");
INSERT INTO sl_return VALUES("RT060002","2017-06-07","2610000001","2679.00","0.00","8221.00","","","","","","","3363","","","","","","01","","2017-06-30 12:35:25","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","8221");
INSERT INTO sl_return VALUES("RT060003","2017-06-10","2610000001","0.00","0.00","18000.00","","","","","","","3366","","","","","","01","","2017-06-19 15:32:56","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","18000");
INSERT INTO sl_return VALUES("RT060004","2017-06-12","2610000001","0.00","0.00","21000.00","","","","","","","1035","","","","","","01","","2017-06-19 15:17:09","","0001","","0.000","","","21000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060005","2017-06-12","2610000001","0.00","0.00","17500.00","","","","","","","1074","","","","","","01","","2017-06-19 15:17:32","","0001","","0.000","","","17500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060007","2017-06-13","2610000001","0.00","0.00","1800.00","","","","","","","3376","","","","","","01","","2017-07-01 12:51:19","","0001","","0.000","","","1800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060008","2017-06-13","2610000001","0.00","0.00","23000.00","","","","","","","1096","","","","","","01","","2017-06-19 15:16:14","","0001","","0.000","","","23000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060009","2017-06-13","2610000001","0.00","0.00","2100.00","","","","","","","1042","","","","","","01","","2017-06-19 15:16:35","","0001","","0.000","","","2100.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060010","2017-06-14","2610000001","0.00","0.00","14500.00","","","","","","","3357","","","","","","01","","2017-06-19 15:15:18","","0001","","0.000","","","3000.00","","","","02","17","on","","","0","0","","","","","11500");
INSERT INTO sl_return VALUES("RT060011","2017-06-19","2610000032","0.00","0.00","10000.00","","","","","","","1082","","","","","","01","","2017-06-20 14:37:46","","0001","","0.000","","","10000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060013","2017-06-20","2610000001","500.00","0.00","2000.00","","","","","","","1122","","","","","","01","","2017-06-30 12:11:25","","0003","","0.000","","","2000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060012","2017-06-20","2610000032","100.00","0.00","10000.00","","","","","","","1081","","","","","","01","","2017-06-20 12:37:37","","0001","","0.000","","","10000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060014","2017-06-20","2610000001","0.00","0.00","61950.00","","","","","","","1005","","","","","","01","","2017-06-20 16:53:20","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","61950");
INSERT INTO sl_return VALUES("RT060015","2017-06-20","2610000045","0.00","0.00","11000.00","","","","","","","1088","","","","","","01","","2017-06-21 10:30:56","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","11000");
INSERT INTO sl_return VALUES("RT060016","2017-06-22","2610000001","0.00","50.00","5600.00","","","","","","","","","","","","","01","","2017-07-01 12:18:34","","0003","","0.000","","","5600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060017","2017-07-06","2610000049","0.00","0.00","40000.00","","","","","","","009","","","","","","01","","2017-07-07 12:09:57","","0001","","0.000","","","12500.00","","","","02","17","on","","","0","0","","","","","27500");
INSERT INTO sl_return VALUES("RT060018","2017-06-29","2610000045","0.00","0.00","6000.00","","","","","","","1079","","","","","","01","","2017-07-07 16:19:17","","0001","","0.000","","","800.00","","","","02","17","on","","","0","0","","","","","5200");
INSERT INTO sl_return VALUES("RT060019","2017-06-29","2610000035","0.00","0.00","16000.00","","","","","","","3378","","","","","","01","","2017-07-01 11:17:32","","0015","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","16000");
INSERT INTO sl_return VALUES("RT070001","2017-06-01","2610000001","0.00","0.00","2000.00","","","","","","","10442","","","","","","01","","2017-07-03 16:57:26","","0007","","0.000","","","2000.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070002","2017-06-02","2610000001","0.00","0.00","8000.00","","","","","","","10446","","","","","","01","","2017-07-03 18:05:23","","0006","","0.000","","","8000.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070001","2017-07-06","2610000001","0.00","0.00","7800.00","","","","","","","1082","","","","","","01","","2017-07-07 12:12:24","","0003","","0.000","","","7800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070002","2017-07-06","2610000001","0.00","0.00","11000.00","","","","","","","1560","","","","","","01","","2017-07-07 17:00:01","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","11000");
INSERT INTO sl_return VALUES("RT070003","2017-07-07","2610000001","0.00","0.00","5000.00","","","","","","","3372","","","","","","01","","2017-07-07 17:43:56","","0001","","0.000","","","5000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070004","2017-07-08","2610000001","50.00","0.00","6000.00","","","","","","","1184","","","","","","01","","2017-07-08 16:29:14","","0001","","0.000","","","6000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070005","2017-07-08","2610000066","0.00","0.00","43000.00","","","","","","","1176","","","","","","01","","2017-07-10 17:01:38","","0003","","0.000","","","30000.00","","","","02","17","on","","","0","0","","","","","13000");
INSERT INTO sl_return VALUES("RT070006","2017-07-11","2610000001","0.00","0.00","5000.00","","","","","","","1089","","","","","","01","","2017-07-12 11:28:18","","0001","","0.000","","","5000.00","","","","02","17","on","","","0","0","","","","","0");


DROP TABLE IF EXISTS sl_returndet;

CREATE TABLE `sl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_returndet VALUES("SL050001","1","3931","BILL NO 5484","1.000","3100.00000","3100.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("SL050001","2","4165","","1.000","900.00000","900.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT050004","1","4219","","1.000","10125.00000","10125.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060001","1","4272","","1.000","18850.00000","18850.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT050002","1","4225","186","28.325","170.00000","4815.25","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050001","1","4104","BILL NO 5489","1.000","2800.00000","2800.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("52","3","3565","","1.000","3500.00000","3500.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("52","1","4004","","2.000","1500.00000","3000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050003","1","3987","","2.000","650.00000","1300.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050005","1","3697","GLASS ( BILL NO 866)","1.000","4000.00000","4000.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT050006","1","4013","BILL NO 868","2.000","1750.00000","3500.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("52","2","3698","","2.000","6000.00000","12000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050007","1","4206","","1.000","8600.00000","8600.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060003","1","4279","BILL NO 3372","1.000","18000.00000","18000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","1","4303","BILL NO 1184","1.000","1060.00000","1060.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070002","1","3731","","1.000","8000.00000","8000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060002","2","3894","","1.000","3900.00000","3900.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060002","1","4277","","2.000","3500.00000","7000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","3","3976","","1.000","610.00000","610.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060018","2","3984","","1.000","2500.00000","2500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060005","1","4238","BILL NO 3384","1.000","17500.00000","17500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060018","1","4004","BILL NO 1143","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060004","1","3888","BILL NO 3379","3.000","7000.00000","21000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070002","1","3740","","1.000","11000.00000","11000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060017","1","4342","BILL NO 1136","1.000","40000.00000","40000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060016","2","4341","","1.000","2850.00000","2850.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060013","1","4285","BILL NO 1123","1.000","2500.00000","2500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060016","1","4243","BILL NO 1133","2.000","1350.00000","2700.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060015","1","4241","BILL NO 1126","1.000","11000.00000","11000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060012","3","4067","","1.000","1500.00000","1500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060012","2","3953","","5.000","1200.00000","6000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060014","1","4330","BILL NO 1124","59.000","1050.00000","61950.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060012","1","3947","BILL NO 1121","4.000","650.00000","2600.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060007","1","4293","BILL NO 3386","1.000","1800.00000","1800.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060008","1","3493","BILL NO 3387","1.000","23000.00000","23000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070001","1","4339","","1.000","2000.00000","2000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060009","1","4031","BILL NO 3388","7.000","300.00000","2100.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060019","2","4355","","1.000","4000.00000","4000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060010","1","4258","BILL NO 3389","1.000","14500.00000","14500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060011","1","3745","BILL NO 1117","1.000","10000.00000","10000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060019","1","4356","BILL NO 1142","2.000","6000.00000","12000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070001","1","3740","BILL NO 1182","1.000","7800.00000","7800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070004","2","4304","","1.000","4380.00000","4380.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070003","1","4210","BILL NO","1.000","5000.00000","5000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070005","1","4398","BILL NO 1190","1.000","43000.00000","43000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070006","1","4260","BILL NO 1196","1.000","5000.00000","5000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");


DROP TABLE IF EXISTS sl_sa;

CREATE TABLE `sl_sa` (
  `SA_ID` varchar(5) NOT NULL,
  `SA_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_sadet;

CREATE TABLE `sl_sadet` (
  `SA_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `AMOUNT` decimal(10,0) NOT NULL,
  `SP_ID` varchar(4) NOT NULL,
  `DIV_ID` varchar(2) NOT NULL,
  `CITY_ID` varchar(2) NOT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_wo;

CREATE TABLE `sl_wo` (
  `WO_ID` varchar(5) NOT NULL,
  `WO_DATE` datetime NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `WO_NAME` varchar(50) DEFAULT NULL,
  `DIV_ID` varchar(2) DEFAULT NULL,
  `CITY_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`WO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sp;

CREATE TABLE `sp` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sp VALUES("0001","Shahid Sheikh","","");
INSERT INTO sp VALUES("0010","Faisal Zia","","");
INSERT INTO sp VALUES("0009","Atif","","");
INSERT INTO sp VALUES("0008","IBRAR","","");
INSERT INTO sp VALUES("0007","WALEED","","");
INSERT INTO sp VALUES("0006","WAQAS","","");
INSERT INTO sp VALUES("0005","Yaseen","","");
INSERT INTO sp VALUES("0004","Salman","","");
INSERT INTO sp VALUES("0003","Rashid","","");
INSERT INTO sp VALUES("0002","Sarosh Ch","","");
INSERT INTO sp VALUES("0011","Hafiz Azeem","","");
INSERT INTO sp VALUES("0012","Bilawal","","");
INSERT INTO sp VALUES("0013","Mubashar","","");
INSERT INTO sp VALUES("0014","HASEEB","","");
INSERT INTO sp VALUES("0015","MURTAZA","","");
INSERT INTO sp VALUES("0016","BABAR","","");


DROP TABLE IF EXISTS sp_party;

CREATE TABLE `sp_party` (
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `lineitem` varchar(4) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`sp_id`,`party_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS stk_cat;

CREATE TABLE `stk_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS stk_collection;

CREATE TABLE `stk_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO stk_collection VALUES("010101","Men");
INSERT INTO stk_collection VALUES("010102","Gold");


DROP TABLE IF EXISTS stk_con;

CREATE TABLE `stk_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` bigint(10) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_con` (`voucher_id`,`bill_no`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS stk_condet;

CREATE TABLE `stk_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_condet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS system;

CREATE TABLE `system` (
  `comp_name` varchar(100) NOT NULL DEFAULT '',
  `cash_id` varchar(10) NOT NULL DEFAULT '',
  `bank_id` varchar(10) NOT NULL DEFAULT '',
  `creditor_id` varchar(10) DEFAULT '1601999',
  `stax_id` varchar(10) DEFAULT '2201001',
  `dc_id` varchar(10) DEFAULT '5302005',
  `disc_id` varchar(10) DEFAULT '5107001',
  `debtor_id` varchar(10) DEFAULT '4201999',
  `adv_id` varchar(10) DEFAULT '4201999',
  `db_id` varchar(10) DEFAULT '4201999',
  `ret_id` varchar(10) DEFAULT '4201999',
  `sec_id` varchar(10) DEFAULT '4201999',
  `stax_id_sl` varchar(10) DEFAULT '2201001',
  `dc_id_sl` varchar(10) DEFAULT '5302005',
  `disc_id_sl` varchar(10) DEFAULT '5107001',
  `adv_id_sl` varchar(10) DEFAULT '4201999',
  `db_id_sl` varchar(10) DEFAULT '4201999',
  `ret_id_sl` varchar(10) DEFAULT '4201999',
  `sec_id_sl` varchar(10) DEFAULT '4201999',
  `stock_id` varchar(10) DEFAULT '4201999',
  `turnover_id` varchar(10) DEFAULT '3010000001',
  `cogs_id` varchar(10) DEFAULT '3020000001',
  `sed_id` varchar(10) DEFAULT NULL,
  `sed_id_sl` varchar(10) DEFAULT NULL,
  `hide_taxes` char(1) DEFAULT NULL,
  `date_from` date DEFAULT '2009-07-01',
  `date_to` date DEFAULT '2010-06-30',
  `ait_id` varchar(10) DEFAULT NULL,
  `cdi_id` varchar(10) DEFAULT NULL,
  `date_close` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) DEFAULT 'support@clicksoft.org',
  `qty_decimal` int(11) DEFAULT '0',
  `fed_id` varchar(10) DEFAULT NULL,
  `fed_id_sl` varchar(10) DEFAULT NULL,
  `stock_transfer_id` varchar(10) DEFAULT NULL,
  `login_page` varchar(30) NOT NULL,
  PRIMARY KEY (`comp_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO system VALUES("Bath & Kitchen Group","271000","272000","131000","3011000001","5010000001","2210000004","261000","1001001","5010000001","1001001","1001001","3011000001","3020000010","3020000002","4201","3020000010","4201","4201","2210000001","3010000001","3020000001","3011000005","3011000005","","2011-07-01","2012-06-30","2530000002","4060000005","2000-12-31","accounts@rakcorporation.com,support@clicksoft.com.pk","3","3011000004","3011000004","2210000002","bk");


DROP TABLE IF EXISTS tf;

CREATE TABLE `tf` (
  `INV_ID` varchar(5) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `PACK_SIZE` varchar(30) DEFAULT NULL,
  `PACK_QTY` decimal(10,2) DEFAULT NULL,
  `UNIT_QTY` decimal(10,2) DEFAULT NULL,
  `STD_WT` decimal(15,5) DEFAULT NULL,
  `UNIT_WT` decimal(15,5) DEFAULT NULL,
  `BATCH_MONTH` varchar(10) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `INACTIVE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO tf VALUES("00140","","0001","","","","2015-12-28 00:00:00","1*1","1.00","222.00","0.00000","","","","");


DROP TABLE IF EXISTS tfdet;

CREATE TABLE `tfdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(15,5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `DONT_INCLUDE` varchar(1) NOT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `LL_P` decimal(6,3) DEFAULT NULL,
  `LL_QTY` decimal(15,5) DEFAULT NULL,
  `QTY` decimal(15,5) DEFAULT NULL,
  `REQ_QTY` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO tfdet VALUES("00141","1","","0","","","","","","","","","0.00000","");


DROP TABLE IF EXISTS trans;

CREATE TABLE `trans` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO trans VALUES("00001","2015-08-08 00:00:00","01","15","inam","01","N","");


DROP TABLE IF EXISTS transdet;

CREATE TABLE `transdet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `REMARKS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO transdet VALUES("00001","1","0394","332.000","","15D523","","01","15","02","","Nearest Exipry Date 30-09-15");


DROP TABLE IF EXISTS tt;

CREATE TABLE `tt` (
  `v_id` int(11) NOT NULL AUTO_INCREMENT,
  `v_date` date DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `comp_name` varchar(100) DEFAULT NULL,
  `debit_amount` int(15) DEFAULT NULL,
  `credit_amount` int(15) DEFAULT NULL,
  `ref_no` varchar(250) DEFAULT NULL,
  `acct_type` varchar(250) DEFAULT NULL,
  `remarks` text,
  `opening_balance` int(15) DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS type;

CREATE TABLE `type` (
  `type_id` varchar(6) NOT NULL DEFAULT '',
  `type_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO type VALUES("0002","KHUSSA");
INSERT INTO type VALUES("0003","SEMI FORMAL");
INSERT INTO type VALUES("0004","FORMAL");
INSERT INTO type VALUES("0005","CASUAL");


DROP TABLE IF EXISTS units;

CREATE TABLE `units` (
  `unit` char(3) NOT NULL DEFAULT '',
  `unit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO units VALUES("Bag","Bags");
INSERT INTO units VALUES("Bot","Bottle");
INSERT INTO units VALUES("Bun","Bundle");
INSERT INTO units VALUES("Coi","Coil");
INSERT INTO units VALUES("Dru","Drum");
INSERT INTO units VALUES("Dzn","Dzn");
INSERT INTO units VALUES("Ft","Ft");
INSERT INTO units VALUES("Gln","Gln");
INSERT INTO units VALUES("Grm","Grams");
INSERT INTO units VALUES("Kg","Kg");
INSERT INTO units VALUES("Ltr","Liter");
INSERT INTO units VALUES("Mtr","Mtr");
INSERT INTO units VALUES("Nos","Nos");
INSERT INTO units VALUES("Pai","Pairs");
INSERT INTO units VALUES("Pcs","Pices");
INSERT INTO units VALUES("Pkt","Pkt");
INSERT INTO units VALUES("Qtr","Qtr");
INSERT INTO units VALUES("Rft","Rft");
INSERT INTO units VALUES("Rim","Rim");
INSERT INTO units VALUES("Rol","Roll");
INSERT INTO units VALUES("Set","Set");
INSERT INTO units VALUES("Sqf","Sqft");
INSERT INTO units VALUES("Tin","Tin");
INSERT INTO units VALUES("Tro","Trolly");
INSERT INTO units VALUES("Tru","Truck");
INSERT INTO units VALUES("MT","M.Tons");
INSERT INTO units VALUES("100","baggage");
INSERT INTO units VALUES("Guz","GUZZ");


DROP TABLE IF EXISTS user_mod;

CREATE TABLE `user_mod` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_CP',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS user_profile;

CREATE TABLE `user_profile` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `user_name` varchar(50) DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '123',
  `desig_id` varchar(30) DEFAULT '',
  `div_name` varchar(30) DEFAULT '',
  `sec_lvl` char(1) DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO user_profile VALUES("HEAD OFFICE","HEAD OFFICE","123","","","0");
INSERT INTO user_profile VALUES("02-admin","EQUATOR","123","","","0");
INSERT INTO user_profile VALUES("03-admin","Wapda Town","123","","","0");
INSERT INTO user_profile VALUES("04-admin","Studio Mir - Gujranwala","123","","","0");
INSERT INTO user_profile VALUES("05-admin","Dreams - M.M.Alam","123","","","0");


DROP TABLE IF EXISTS user_rep;

CREATE TABLE `user_rep` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_10',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `EMP_ID` varchar(20) NOT NULL,
  `EMP_NAME` varchar(40) NOT NULL,
  `PASSWORD` varchar(20) DEFAULT NULL,
  `AUTH_ID` varchar(1) NOT NULL,
  `USE_FORM` varchar(1) DEFAULT NULL,
  `USE_REP` varchar(1) DEFAULT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `PK_BILL_NO_FROM` varchar(4) DEFAULT NULL,
  `PK_BILL_NO_TO` varchar(4) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `VOUCHER_TYPE` varchar(2) DEFAULT NULL,
  `POST` varchar(1) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `u_session_id` decimal(65,30) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users VALUES("atif","Atif","123","1","","","","","","","","","","","","","","","","");
INSERT INTO users VALUES("bt","BT","123","1","Y","Y","N","01","04","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","","","","N","0007","0.000000000000000000000000000000");
INSERT INTO users VALUES("click","ClickSoft (Pvt) Ltd","m.","9","","","","","","","","","","","","","","","","");
INSERT INTO users VALUES("it","IT","123","1","Y","Y","N","01","04","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","","","","N","0007","0.000000000000000000000000000000");
INSERT INTO users VALUES("kt","Kafeel Trader","123","1","Y","Y","N","01","04","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","","","","N","0007","0.000000000000000000000000000000");


DROP TABLE IF EXISTS users_comp;

CREATE TABLE `users_comp` (
  `EMP_ID` varchar(20) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`,`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users_comp VALUES("atif","01","");
INSERT INTO users_comp VALUES("click","01","");
INSERT INTO users_comp VALUES("click","02","");


DROP TABLE IF EXISTS users_menu;

CREATE TABLE `users_menu` (
  `emp_id` varchar(20) NOT NULL DEFAULT '',
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `inactive` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`emp_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS users_mod;

CREATE TABLE `users_mod` (
  `EMP_ID` varchar(6) NOT NULL,
  `VOUCHER_TYPE` varchar(20) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users_mod VALUES("Abid","PL_INVOICE");


DROP TABLE IF EXISTS users_rep;

CREATE TABLE `users_rep` (
  `EMP_ID` varchar(6) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`REP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users_rep VALUES("abid","068");


DROP TABLE IF EXISTS v_p_vouchers;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_p_vouchers` AS select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,concat(`p`.`acct_name`,' / ',`l`.`loc_name`) AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('RT',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_return` `m` left join `sl_returndet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SD',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,NULL AS `lineitem`,NULL AS `stock_code`,'Discount' AS `stock_name`,NULL AS `rate`,0 AS `db_qty`,0 AS `db_amt`,NULL AS `cr_qty`,`m`.`disc_amt` AS `cr_amt` from (`sl_invoice` `m` left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) where (`m`.`disc_amt` <> 0) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`)));

INSERT INTO v_p_vouchers VALUES("02","17","PL060005","2017-06-03","1310000014","JAVAID / Main Store","1","4248","SINK 5043","2520.00000","1.000","2520.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060005","2017-06-03","1310000014","JAVAID / Main Store","2","4249","SINK 8544","5580.00000","1.000","5580.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060010","2017-06-06","1310000035","SILLA CONCEPT\'S / Main Store","1","4235","WALLPAPER","1100.00000","1.000","1100.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060003","2017-06-02","1310000028","MAHMOOD SONS / Main Store","1","3821","SINK MIXER SONEX","5412.00000","4.000","21648.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060003","2017-06-02","1310000028","MAHMOOD SONS / Main Store","2","4245","SIX PIECES SET CP 2381-C","4437.00000","4.000","17748.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060003","2017-06-02","1310000028","MAHMOOD SONS / Main Store","3","3822","SINK MIXER 316","3847.00000","2.000","7694.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060003","2017-06-02","1310000028","MAHMOOD SONS / Main Store","4","4246","SHOWER WALL 4091 CP","6357.00000","4.000","25429.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060003","2017-06-02","1310000028","MAHMOOD SONS / Main Store","5","3779","SHWERSET 4091/4093","13990.00000","1.000","13990.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060004","2017-06-03","1310000014","JAVAID / Main Store","1","4247","SINK BOWL 8149","7500.00000","1.000","7500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060011","2017-06-07","1310000028","MAHMOOD SONS / Main Store","1","3826","MUSLIM SHWER SONEX","1150.00000","1.000","1150.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060011","2017-06-07","1310000028","MAHMOOD SONS / Main Store","2","4276","BASIN MIXER 383","10272.00000","1.000","10272.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060011","2017-06-07","1310000028","MAHMOOD SONS / Main Store","3","4275","BASIN MIXER 384","3964.00000","1.000","3964.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060011","2017-06-07","1310000028","MAHMOOD SONS / Main Store","4","4274","SINK MIXER 941","5184.00000","1.000","5184.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060002","2017-06-01","1310000028","MAHMOOD SONS / Main Store","1","3976","T-COCK WHIT 2384","708.00000","1.000","708.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060002","2017-06-01","1310000028","MAHMOOD SONS / Main Store","2","3976","T-COCK WHIT 2384","708.00000","1.000","708.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060002","2017-06-01","1310000028","MAHMOOD SONS / Main Store","3","4228","BASIN MIXER 3173","3174.00000","1.000","3174.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060002","2017-06-01","1310000028","MAHMOOD SONS / Main Store","4","4243","D-BIB COCK SONIX 355","1641.00000","1.000","1641.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060002","2017-06-01","1310000028","MAHMOOD SONS / Main Store","5","4244","BASIN MIXER 423 SONIX","4017.00000","1.000","4017.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060002","2017-06-01","1310000028","MAHMOOD SONS / Main Store","6","3826","MUSLIM SHWER SONEX","1400.00000","1.000","1400.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060001","2017-06-01","1310000028","MAHMOOD SONS / Main Store","1","4242","SONEX FLUSH TANK WHITE","2548.00000","4.000","10193.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060012","2017-06-07","1310000034","VIZDOM / Main Store","1","4029","THIMBLE WHITE","150.00000","1.000","150.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060014","2017-06-08","1310000027","IMC / Main Store","1","4279","UNDER CONTER 005","17340.00000","1.000","17340.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060013","2017-06-08","1310000006","MAGOON TRADERS / Main Store","1","4271","BASIN MIXER 927","12734.00000","1.000","12734.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060015","2017-06-12","1310000014","JAVAID / Main Store","1","3975","T-COCK GROHE CHI","270.00000","25.000","6750.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060017","2017-06-12","1310000006","MAGOON TRADERS / Main Store","1","4246","SHOWER WALL 4091 CP","14958.00000","1.000","14958.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","PL070002","2017-06-02","1310000028","MAHMOOD SONS / Main Store","1","4373","BASIN MIXER 4013 CP","2926.00000","3.000","8778.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070007","2017-07-04","1310000014","JAVAID / Main Store","1","4247","SINK BOWL 8149","7500.00000","1.000","7500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","PL070004","2017-06-02","1310000039","NATURE / Main Store","1","4225","LAMINATED WOOD FLOOR MAT","24670.00000","1.000","24670.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","PL070004","2017-06-02","1310000039","NATURE / Main Store","2","4225","LAMINATED WOOD FLOOR MAT","6458.00000","1.000","6458.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","PL070004","2017-06-02","1310000039","NATURE / Main Store","3","4225","LAMINATED WOOD FLOOR MAT","48436.00000","1.000","48436.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070001","2017-07-03","1310000018","KBS / Main Store","1","4368","GLASS BOWL","1800.00000","1.000","1800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070002","2017-06-30","1310000028","MAHMOOD SONS / Main Store","1","3826","MUSLIM SHWER SONEX","1190.00000","1.000","1190.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070002","2017-06-30","1310000028","MAHMOOD SONS / Main Store","2","4353","RAIN SHOWER 897","3603.00000","1.000","3603.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070006","2017-07-04","1310000006","MAGOON TRADERS / Main Store","1","4392","SINK BOWL 18X36","3350.00000","1.000","3350.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060025","2017-06-14","1310000029","KBS / Main Store","1","4310","SLAB:BAWOL 6028 W","5500.00000","1.000","5500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060024","2017-06-14","1310000033","BASRA BROTHERS / Main Store","1","4309","SHOWER SET CP FAISAL VENUS","14150.00000","1.000","13018.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060024","2017-06-14","1310000033","BASRA BROTHERS / Main Store","2","4309","SHOWER SET CP FAISAL VENUS","12785.00000","2.000","23524.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060023","2017-06-13","1310000031","ILYAS/SONS / Main Store","1","4308","BIK P-11 KITCHEN","350.00000","1.000","350.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060022","2017-06-13","1310000","","1","4307","HANDAL","55.00000","2.000","110.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060021","2017-06-13","1310000028","MAHMOOD SONS / Main Store","1","3826","MUSLIM SHWER SONEX","1400.00000","1.000","1400.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060020","2017-06-13","1310000030","MUHAMMADI STORE / Main Store","1","4036","CP NOZAL 1 1/2\'\'","80.00000","12.000","960.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060019","2017-06-12","1310000","","1","4290","SINK MIXER 905 CP","6609.00000","1.000","6609.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060018","2017-06-12","1310000014","JAVAID / Main Store","1","4029","THIMBLE WHITE","330.00000","3.000","990.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","PL070001","2017-06-01","1310000028","MAHMOOD SONS / Main Store","1","4371","SINK MIXER 411 SONEX","3087.00000","1.000","3087.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","PL070001","2017-06-01","1310000028","MAHMOOD SONS / Main Store","2","4372","SINK COCK 414 CP","1256.00000","1.000","1256.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060016","2017-06-12","1310000028","MAHMOOD SONS / Main Store","1","4243","D-BIB COCK SONIX 355","1396.00000","3.000","4189.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060016","2017-06-12","1310000028","MAHMOOD SONS / Main Store","2","3826","MUSLIM SHWER SONEX","1190.00000","3.000","3570.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060006","2017-06-03","1310000018","KBS / Main Store","1","4250","LODER UONIT PTI 022","14500.00000","1.000","14500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060008","2017-06-05","1310000006","MAGOON TRADERS / Main Store","1","4253","UNDER CONTER HD18","4150.00000","1.000","4150.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060008","2017-06-05","1310000006","MAGOON TRADERS / Main Store","2","4265","SLAB:BAWOL HD 3","2950.00000","1.000","2950.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060007","2017-06-05","1310000033","BASRA BROTHERS / Main Store","1","4261","SHOWER SET 2807","14150.00000","1.000","13443.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060007","2017-06-05","1310000033","BASRA BROTHERS / Main Store","2","3984","HAND SHWER 065","1945.00000","1.000","1848.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060007","2017-06-05","1310000033","BASRA BROTHERS / Main Store","3","4214","DIVIDER:331","680.00000","1.000","646.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060007","2017-06-05","1310000033","BASRA BROTHERS / Main Store","4","4084","BASIN MIXER 2080","4420.00000","1.000","4111.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060009","2017-06-06","1310000034","VIZDOM / Main Store","1","4273","SINK BOWL 650","3500.00000","1.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060026","2017-06-14","1310000034","VIZDOM / Main Store","1","4311","T-COCK 2294 GROHE","825.00000","17.000","14025.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060027","2017-06-14","1310000006","MAGOON TRADERS / Main Store","1","4292","BASIN HD 19","4136.00000","1.000","4136.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060027","2017-06-14","1310000006","MAGOON TRADERS / Main Store","2","4291","TANK HD 2T","2464.00000","1.000","2464.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060027","2017-06-14","1310000006","MAGOON TRADERS / Main Store","3","3975","T-COCK GROHE CHI","1140.00000","6.000","6840.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060027","2017-06-14","1310000006","MAGOON TRADERS / Main Store","4","4293","BASIN STAND SMALL","1400.00000","2.000","2800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060027","2017-06-14","1310000006","MAGOON TRADERS / Main Store","5","4243","D-BIB COCK SONIX 355","1641.00000","2.000","3282.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060030","2017-06-17","2610000042","CERAMICS / Main Store","1","4316","AIR FRISHNER","950.00000","1.000","950.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060029","2017-06-17","1310000006","MAGOON TRADERS / Main Store","1","3826","MUSLIM SHWER SONEX","1400.00000","2.000","2800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060028","2017-06-15","1310000034","VIZDOM / Main Store","1","4312","T-COCK 2202500 GROHE 1/2","525.00000","40.000","21000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060031","2017-06-17","2610000043","HOME TECH / Main Store","1","4319","ESPA PUMP 0.8 HP","3500.00000","1.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060033","2017-06-21","1310000028","MAHMOOD SONS / Main Store","1","4337","BATH MIXER 761 CP","10424.00000","1.000","10424.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060034","2017-06-21","1310000006","MAGOON TRADERS / Main Store","1","4331","SHOWER SET 981-983 W/OUT 510 + 507","19403.00000","1.000","19403.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060032","2017-06-20","1310000006","MAGOON TRADERS / Main Store","1","4304","ABLUTION MIXER 333 SONIX","4868.00000","6.000","29208.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060032","2017-06-20","1310000006","MAGOON TRADERS / Main Store","2","4303","BIB COCK 415","1239.00000","4.000","4956.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060035","2017-06-22","1310000006","MAGOON TRADERS / Main Store","1","4340","BASIN MIXER 6013","3175.00000","1.000","3175.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060036","2017-06-22","1310000006","MAGOON TRADERS / Main Store","1","4332","DAIL PLET AUTO QUADERA","14892.00000","2.000","29784.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060036","2017-06-22","1310000006","MAGOON TRADERS / Main Store","2","4333","DAIL PLET NON AUTO QUADERA","13140.00000","2.000","26280.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060037","2017-06-22","1310000014","JAVAID / Main Store","1","4029","THIMBLE WHITE","350.00000","3.000","1050.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL060038","2017-06-23","1310000028","MAHMOOD SONS / Main Store","1","4351","HAND SHOWER 515 CP SONEX","1739.00000","1.000","1739.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070004","2017-06-30","1310000033","BASRA BROTHERS / Main Store","1","4020","BASIN MIXER PIPE","280.00000","2.000","560.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070008","2017-07-06","1310000028","MAHMOOD SONS / Main Store","1","4337","BATH MIXER 761 CP","8860.00000","1.000","8860.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070008","2017-07-06","1310000028","MAHMOOD SONS / Main Store","2","4400","SINK MIXER LONG 927-L","5412.00000","1.000","5412.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070008","2017-07-06","1310000028","MAHMOOD SONS / Main Store","3","4245","SIX PIECES SET CP 2381-C","4437.00000","1.000","4437.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070008","2017-07-06","1310000028","MAHMOOD SONS / Main Store","4","3976","T-COCK WHIT 2384","602.00000","4.000","2408.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070009","2017-07-06","1310000028","MAHMOOD SONS / Main Store","1","4276","BASIN MIXER 383","10272.00000","1.000","10272.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070009","2017-07-06","1310000028","MAHMOOD SONS / Main Store","2","4275","BASIN MIXER 384","3964.00000","1.000","3964.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070009","2017-07-06","1310000028","MAHMOOD SONS / Main Store","3","4274","SINK MIXER 941","5184.00000","1.000","5184.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070010","2017-07-07","1310000045","INTERIO FLOORS / Main Store","1","4225","LAMINATED WOOD FLOOR MAT","125.00000","27.000","3392.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070011","2017-07-10","1310000047","BUTT TRADER / Main Store","1","4408","COMMODE MARJAN","5500.00000","1.000","5500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070011","2017-07-10","1310000047","BUTT TRADER / Main Store","2","4409","COMMODE AROOBA","5500.00000","1.000","5500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070011","2017-07-10","1310000047","BUTT TRADER / Main Store","3","4142","SET COVER SQUORE WHIT","1000.00000","2.000","2000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070012","2017-07-10","1310000014","JAVAID / Main Store","1","4248","SINK 5043","2600.00000","5.000","13000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070012","2017-07-10","1310000014","JAVAID / Main Store","2","4031","THIMBLE GREES","350.00000","3.000","1050.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070013","2017-07-11","1310000014","JAVAID / Main Store","1","3470","SINK:SINK 8349","6500.00000","1.000","6500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","PL070013","2017-07-11","1310000014","JAVAID / Main Store","2","4043","BOLT KIT BASIN","850.00000","1.000","850.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060010","2017-06-05","2610000001","Walk-In-Customers","1","4083","BASIN MIXER CA-1","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060010","2017-06-05","2610000001","Walk-In-Customers","2","3986","FLOOR WAIST KABZA ","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060008","2017-06-03","2610000001","Walk-In-Customers","1","4256","VANITY PVC PELER 18\'\'","10000.00000","0.000","0.00","1.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060008","2017-06-03","2610000001","Walk-In-Customers","2","4257","VANITY 18X24","2000.00000","0.000","0.00","1.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060008","2017-06-03","2610000001","Walk-In-Customers","3","3888","BASIN MIXER EURO SAMRT CASMO","7350.00000","0.000","0.00","1.000","7350.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060008","2017-06-03","2610000001","Walk-In-Customers","4","4258","VANITY U PVC","20000.00000","0.000","0.00","1.000","20000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060008","2017-06-03","2610000001","Walk-In-Customers","5","4259","MIRROR U LED","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060008","2017-06-03","2610000001","Walk-In-Customers","6","4260","MIRROR 36\'\' LED","5000.00000","0.000","0.00","2.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060006","2017-06-03","2610000001","Walk-In-Customers","1","4251","HOOB F-1","13000.00000","0.000","0.00","1.000","13000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060004","2017-06-03","2610000001","Walk-In-Customers","1","4247","SINK BOWL 8149","9000.00000","0.000","0.00","1.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060004","2017-06-03","2610000001","Walk-In-Customers","2","3490","SINK:SINK 6045 B","2500.00000","0.000","0.00","1.000","2500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060004","2017-06-03","2610000001","Walk-In-Customers","3","3477","SINK:SINK 11550A","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","1","4154","TAWER RAD 304","450.00000","0.000","0.00","5.000","2250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","2","4155","PAPER HOLDER 304","450.00000","0.000","0.00","4.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","3","4156","SOOP DISH 304","450.00000","0.000","0.00","4.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","4","4152","BRUSH HOLDER 304","450.00000","0.000","0.00","4.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","5","4153","TAWER RING 304","450.00000","0.000","0.00","2.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","6","4401","MIRROR 36x30","4000.00000","0.000","0.00","1.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070018","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","1","3739","COMMODE:CAMMOD W/H NW-303","10800.00000","0.000","0.00","3.000","32400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070018","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","2","4029","THIMBLE WHITE","1500.00000","0.000","0.00","3.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070018","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","3","4387","COMMODE 222 12\'\'","15280.00000","0.000","0.00","3.000","45840.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070018","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","4","4031","THIMBLE GREES","300.00000","0.000","0.00","3.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070018","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","5","4388","VANITY PVC W/MIRROR NEW W/MIXER","25000.00000","0.000","0.00","1.000","25000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","1","4325","DAIL PLET AUTO SMART GROHE","5915.00000","0.000","0.00","3.000","17745.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","10","3894","SINK MIXER CHI ","3000.00000","0.000","0.00","2.000","6000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","11","3647","JACUZZI:JACUZZI:GOLD 05","49000.00000","0.000","0.00","1.000","49000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","12","4381","JACUZZI:JACUZZI:GOLD 36","54000.00000","0.000","0.00","1.000","54000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","2","4378","DAIL PLET AUTO SMART COSMO","7000.00000","0.000","0.00","2.000","14000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","3","4379","BASIN MIXER BAU EDGE LONG","8176.00000","0.000","0.00","3.000","24528.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","4","3887","BASIN MIXER EURO SAMRT","6280.00000","0.000","0.00","3.000","18840.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","5","4380","SPOUT JAGUAR 13255","2000.00000","0.000","0.00","5.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","6","4004","RAIN SHOWER SLIM 12*12","2000.00000","0.000","0.00","5.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","7","3866","MUSLIM SHWER GROHE","3430.00000","0.000","0.00","6.000","20580.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","8","4306","T-COCK 220160000","548.00000","0.000","0.00","40.000","21920.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","9","4284","SINK MIXER 7110 SPPRING SMALL","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","1","4382","MIRROR 3 1 1/2X66","8000.00000","0.000","0.00","1.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","2","4383","MIRROR 36X45 1/2","4000.00000","0.000","0.00","1.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","3","4384","MIRROR 34X53 1/2","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","4","4385","MIRROR 40X42","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","5","4386","MIRROR 30X36","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","6","4317","MIRROR 18X24","2000.00000","0.000","0.00","1.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070015","2017-07-04","2610000059","H-NO 254-DD PHS# 4 03218487965","1","4216","LONG PIPE","1800.00000","0.000","0.00","1.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070015","2017-07-04","2610000059","H-NO 254-DD PHS# 4 03218487965","2","3886","BASIN MIXER EURO DISC","14640.00000","0.000","0.00","2.000","29280.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070014","2017-07-04","2610000001","Walk-In-Customers","1","3989","FLOOR WAIST PLAN NEW","275.00000","0.000","0.00","6.000","1650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070014","2017-07-04","2610000001","Walk-In-Customers","2","4017","CONNECTOR PIPE 1 1/2 FT","1200.00000","0.000","0.00","2.000","2400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070014","2017-07-04","2610000001","Walk-In-Customers","3","4041","BEORING NIPPEL","150.00000","0.000","0.00","6.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070013","2017-07-04","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","1","4040","CP NEUT","10.00000","0.000","0.00","10.000","100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070013","2017-07-04","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","2","4377","CP NEUT 1/2 1/4","80.00000","0.000","0.00","10.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070012","2017-07-04","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","1","4021","WAST PIPE CROM","300.00000","0.000","0.00","6.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070011","2017-07-03","2610000062","H-NO 862/B PH# 5 DHA","1","4375","CONCELED BODY W/BODY 81","6350.00000","0.000","0.00","2.000","12700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070011","2017-07-03","2610000062","H-NO 862/B PH# 5 DHA","2","4376","CONCELED BODY W/BODY 72","6350.00000","0.000","0.00","1.000","6350.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070010","2017-07-03","2610000061","UMER KHALID SB 54/C PHAS# 5 DHA","1","4325","DAIL PLET AUTO SMART GROHE","8200.00000","0.000","0.00","2.000","16400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070010","2017-07-03","2610000061","UMER KHALID SB 54/C PHAS# 5 DHA","2","4221","TANK+PLATE GROHE","10300.00000","0.000","0.00","3.000","30900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070009","2017-07-03","2610000001","Walk-In-Customers","1","4370","VANITY 40\'\' NEW DESIGN","19000.00000","0.000","0.00","1.000","19000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070008","2017-07-03","2610000001","Walk-In-Customers","1","4369","SINK MIXER CCA2 CHI","2500.00000","0.000","0.00","1.000","2500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070006","2017-07-01","2610000001","Walk-In-Customers","1","4368","GLASS BOWL","2500.00000","0.000","0.00","1.000","2500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070006","2017-07-01","2610000001","Walk-In-Customers","2","3752","COMMODE:CAMMOD LX-154-5047","12000.00000","0.000","0.00","1.000","12000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070007","2017-07-01","2610000060","246/E-1 WAPDA TWON PHAS# 1","1","3621","JACUZZI:JACUZZI:BTG 20","59000.00000","0.000","0.00","3.000","177000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070005","2017-07-01","2610000001","Walk-In-Customers","1","4327","SET COVER 2006 IVORY","1500.00000","0.000","0.00","1.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070004","2017-07-01","2610000001","Walk-In-Customers","1","3813","BASIN MIXER 4093","4000.00000","0.000","0.00","1.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","1","4067","T-ARM 18\'\' WWT","1500.00000","0.000","0.00","2.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","10","3769","COMMODE:W/C 102","12825.00000","0.000","0.00","1.000","12825.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","11","3887","BASIN MIXER EURO SAMRT","6360.00000","0.000","0.00","4.000","25440.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","12","3950","BOTLE TRAP WWT","900.00000","0.000","0.00","4.000","3600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","13","4367","T COCK 1/2 X 3/8 GROHE","590.00000","0.000","0.00","8.000","4720.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","14","4034","CP NOZAL 1\'\'","50.00000","0.000","0.00","8.000","400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","15","4036","CP NOZAL 1 1/2\'\'","60.00000","0.000","0.00","8.000","480.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","2","4366","BATH MIXER SMART GROHE","7700.00000","0.000","0.00","2.000","15400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","3","4329","SHOWER RAD 4FT","800.00000","0.000","0.00","2.000","1600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","4","3977","U-BEND","1000.00000","0.000","0.00","2.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","5","4002","RAIN SHOWER SQUARE 8*8","2500.00000","0.000","0.00","2.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","6","3887","BASIN MIXER EURO SAMRT","6360.00000","0.000","0.00","2.000","12720.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","7","4367","T COCK 1/2 X 3/8 GROHE","590.00000","0.000","0.00","4.000","2360.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","8","3950","BOTLE TRAP WWT","900.00000","0.000","0.00","2.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070003","2017-07-01","2610000001","Walk-In-Customers","9","3974","T-COCK JAGUAR","590.00000","0.000","0.00","4.000","2360.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070001","2017-06-30","2610000001","Walk-In-Customers","1","4364","SET COVER 2055 W","1800.00000","0.000","0.00","1.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060103","2017-06-30","2610000001","Walk-In-Customers","1","4363","SINK MIXER 901","3800.00000","0.000","0.00","1.000","3800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060103","2017-06-30","2610000001","Walk-In-Customers","2","3826","MUSLIM SHWER SONEX","1200.00000","0.000","0.00","2.000","2400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060102","2017-06-30","2610000001","Walk-In-Customers","1","4039","CP NOZAL 6\'\'","175.00000","0.000","0.00","2.000","350.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060101","2017-06-30","2610000001","Walk-In-Customers","1","4353","RAIN SHOWER 897","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060100","2017-06-30","2610000058","AFTAB SB","1","4361","VANITY  W/MIRROR 36\'\'","19000.00000","0.000","0.00","20.000","380000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060100","2017-06-30","2610000058","AFTAB SB","2","4362","VANITY PILER WITH MIRROR","14000.00000","0.000","0.00","5.000","70000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060095","2017-06-29","2610000035","MR. ANEES SB 0321-4185133","1","4198","ACCESSORY SET 304","3500.00000","0.000","0.00","2.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060095","2017-06-29","2610000035","MR. ANEES SB 0321-4185133","2","4352","ACCESSORY SET JAGUAR","4000.00000","0.000","0.00","1.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060095","2017-06-29","2610000035","MR. ANEES SB 0321-4185133","3","4357","ART BOWEL:1035","11200.00000","0.000","0.00","1.000","11200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060094","2017-06-24","2610000035","MR. ANEES SB 0321-4185133","1","4043","BOLT KIT BASIN","200.00000","0.000","0.00","2.000","400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060093","2017-06-12","2610000056","242/L PH# 5 DHA  MR.UMAR","1","3974","T-COCK JAGUAR","325.00000","0.000","0.00","2.000","650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060092","2017-06-13","2610000057","ABDULLAH SB PH# 6 839/D DHA","1","3978","MUSLIM SHOWER CHI","1500.00000","0.000","0.00","2.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060092","2017-06-13","2610000057","ABDULLAH SB PH# 6 839/D DHA","2","3826","MUSLIM SHWER SONEX","1150.00000","0.000","0.00","2.000","2300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060092","2017-06-13","2610000057","ABDULLAH SB PH# 6 839/D DHA","3","3976","T-COCK WHIT 2384","600.00000","0.000","0.00","6.000","3600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060092","2017-06-13","2610000057","ABDULLAH SB PH# 6 839/D DHA","4","4243","D-BIB COCK SONIX 355","900.00000","0.000","0.00","2.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060091","2017-06-13","2610000027","SAYYAD BROTHER","1","3860","SALDING RAD GROHE","3500.00000","0.000","0.00","3.000","10500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060090","2017-06-13","2610000056","242/L PH# 5 DHA  MR.UMAR","1","4350","SINK MIXER 217","6500.00000","0.000","0.00","1.000","6500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060090","2017-06-13","2610000056","242/L PH# 5 DHA  MR.UMAR","2","4284","SINK MIXER 7110 SPPRING SMALL","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060089","2017-06-10","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","1","4347","VANITY PVC 5FT W/MIRROR TUCH","39500.00000","0.000","0.00","1.000","39500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060089","2017-06-10","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","2","4347","VANITY PVC 5FT W/MIRROR TUCH","39500.00000","0.000","0.00","1.000","39500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060089","2017-06-10","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","3","4348","VANITY PVC 4FT W/MIRROR TUCH","29500.00000","0.000","0.00","1.000","29500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060089","2017-06-10","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","4","4348","VANITY PVC 4FT W/MIRROR TUCH","29500.00000","0.000","0.00","1.000","29500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060089","2017-06-10","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","5","4349","VANITY PVC 18X24 W/MIRROR TUCH","16500.00000","0.000","0.00","1.000","16500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060088","2017-06-03","2610000054","228/B STAT LIFE","1","4154","TAWER RAD 304","950.00000","0.000","0.00","5.000","4750.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060088","2017-06-03","2610000054","228/B STAT LIFE","2","4153","TAWER RING 304","850.00000","0.000","0.00","5.000","4250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060088","2017-06-03","2610000054","228/B STAT LIFE","3","4155","PAPER HOLDER 304","800.00000","0.000","0.00","6.000","4800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060088","2017-06-03","2610000054","228/B STAT LIFE","4","4156","SOOP DISH 304","850.00000","0.000","0.00","8.000","6800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060088","2017-06-03","2610000054","228/B STAT LIFE","5","3826","MUSLIM SHWER SONEX","1000.00000","0.000","0.00","1.000","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060087","2017-06-23","2610000049","HAJI HAKM SB 73 / C PH# 6","1","4346","ART BOWEL:037","4800.00000","0.000","0.00","2.000","9600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060086","2017-05-27","2610000054","228/B STAT LIFE","1","4273","SINK BOWL 650","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060086","2017-05-27","2610000054","228/B STAT LIFE","2","4334","SINK BOWL","2500.00000","0.000","0.00","1.000","2500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060085","2017-05-25","2610000050","B PLAZA NADEEM KHAN","1","4027","MANIFIVE MIRREOR","2000.00000","0.000","0.00","2.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060085","2017-05-25","2610000050","B PLAZA NADEEM KHAN","2","3735","COMMODE:CAMMOD W/H K012","7650.00000","0.000","0.00","1.000","7650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060084","2017-05-24","2610000056","242/L PH# 5 DHA  MR.UMAR","1","3472","SINK:SINK 7540","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060084","2017-05-24","2610000056","242/L PH# 5 DHA  MR.UMAR","2","3469","SINK:SINK 518","2200.00000","0.000","0.00","1.000","2200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060084","2017-05-24","2610000056","242/L PH# 5 DHA  MR.UMAR","3","3544","HOB:HOOB-KITCHEN MASTER ","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060083","2017-05-24","2610000050","B PLAZA NADEEM KHAN","1","3699","SLAB:BAWOL 004","6390.00000","0.000","0.00","1.000","6390.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060082","2017-05-22","2610000001","Walk-In-Customers","1","3947","PUSH WAIST 4\'\'","650.00000","0.000","0.00","1.000","650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060082","2017-05-22","2610000001","Walk-In-Customers","2","4023","WAST PIPE SS","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060081","2017-05-17","2610000054","228/B STAT LIFE","1","3490","SINK:SINK 6045 B","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060081","2017-05-17","2610000054","228/B STAT LIFE","2","4088","SINK MIXER 8317","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060081","2017-05-17","2610000054","228/B STAT LIFE","3","3558","HOB:HOOB BH-B04","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060081","2017-05-17","2610000054","228/B STAT LIFE","4","3536","HOOD:HOOD 36\'\' SS","13000.00000","0.000","0.00","1.000","13000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060080","2017-05-17","2610000053","69/G MODAL TWON","1","4031","THIMBLE GREES","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060080","2017-05-17","2610000053","69/G MODAL TWON","2","4018","CONACTION PIPE 2FIT","700.00000","0.000","0.00","1.000","700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060011","2017-06-06","2610000027","SAYYAD BROTHER","1","4266","VANITY: SINGL TAPER 47\'\'","25000.00000","0.000","0.00","2.000","50000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060011","2017-06-06","2610000027","SAYYAD BROTHER","2","4267","VANITY: DUBAL TAPER 46\'\'","24000.00000","0.000","0.00","2.000","48000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060011","2017-06-06","2610000027","SAYYAD BROTHER","3","4268","VANITY: NEW 44\'\'","22000.00000","0.000","0.00","2.000","44000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060011","2017-06-06","2610000027","SAYYAD BROTHER","4","4269","VANITY: SMALL 14X18","8000.00000","0.000","0.00","1.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060009","2017-06-03","2610000001","Walk-In-Customers","1","4261","SHOWER SET 2807","16400.00000","0.000","0.00","1.000","16400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060009","2017-06-03","2610000001","Walk-In-Customers","2","3987","FLOOR WAIST PUSH","550.00000","0.000","0.00","1.000","550.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060009","2017-06-03","2610000001","Walk-In-Customers","3","3927","BOLON SINK MIXER CLASSIC","3900.00000","0.000","0.00","1.000","3900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060009","2017-06-03","2610000001","Walk-In-Customers","4","4248","SINK 5043","2800.00000","0.000","0.00","1.000","2800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060009","2017-06-03","2610000001","Walk-In-Customers","5","4262","BASIN MIXER 2083","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060079","2017-05-17","2610000052","DR. ASIM SB 03214864288","1","3753","COMMODE:CAMMOD LX-5019","9500.00000","0.000","0.00","4.000","38000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060099","2017-06-30","2610000001","Walk-In-Customers","1","4360","BASIN MIXER 5007","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060099","2017-06-30","2610000001","Walk-In-Customers","2","4153","TAWER RING 304","600.00000","0.000","0.00","2.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060099","2017-06-30","2610000001","Walk-In-Customers","3","4053","TAWEL RACK D-21","2200.00000","0.000","0.00","1.000","2200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060099","2017-06-30","2610000001","Walk-In-Customers","4","3826","MUSLIM SHWER SONEX","1500.00000","0.000","0.00","1.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060099","2017-06-30","2610000001","Walk-In-Customers","5","4155","PAPER HOLDER 304","700.00000","0.000","0.00","1.000","700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","1","4222","THIMBLE SET","1500.00000","0.000","0.00","6.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","10","3849","BASIN MIXER GROHE","5500.00000","0.000","0.00","3.000","16500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","11","3887","BASIN MIXER EURO SAMRT","6500.00000","0.000","0.00","4.000","26000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","2","3731","COMMODE:CAMMOD W/H K01","8500.00000","0.000","0.00","1.000","8500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","3","3733","COMMODE:CAMMOD W/H K05","9500.00000","0.000","0.00","5.000","47500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","4","4342","VANITY PVC 6FT","45000.00000","0.000","0.00","1.000","45000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","5","4239","VANITY:PVC 48\'\' WT","30000.00000","0.000","0.00","1.000","30000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","6","4238","VANITY:PVC 36\'\' S.T","20000.00000","0.000","0.00","1.000","20000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","7","4239","VANITY:PVC 48\'\' WT","10500.00000","0.000","0.00","1.000","10500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","8","3698","SLAB:BAWOL Y016","9500.00000","0.000","0.00","1.000","9500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","9","4297","SLAB:BAWOL 014 WHITE","9500.00000","0.000","0.00","1.000","9500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060076","2017-06-23","2610000001","Walk-In-Customers","1","3974","T-COCK JAGUAR","400.00000","0.000","0.00","12.000","4800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060076","2017-06-23","2610000001","Walk-In-Customers","2","4345","CP NOZZEL 1/2 X 3/4","0.00000","0.000","0.00","1.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060075","2017-05-12","2610000028","KASHIF SB 245/G PHS# 5 DHA","1","4344","VANITY PVC 16X24 W/MIRROR","19000.00000","0.000","0.00","1.000","19000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060074","2017-05-12","2610000040","SHOAIB KHAN SB","1","4293","BASIN STAND SMALL","4650.00000","0.000","0.00","1.000","4650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060074","2017-05-12","2610000040","SHOAIB KHAN SB","2","4043","BOLT KIT BASIN","150.00000","0.000","0.00","1.000","150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060073","2017-05-08","2610000050","B PLAZA NADEEM KHAN","1","3995","SINK WAST 1 1/2","450.00000","0.000","0.00","5.000","2250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060073","2017-05-08","2610000050","B PLAZA NADEEM KHAN","2","4022","WAST PIPE PVC 1 1/2","150.00000","0.000","0.00","5.000","750.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060073","2017-05-08","2610000050","B PLAZA NADEEM KHAN","3","3947","PUSH WAIST 4\'\'","700.00000","0.000","0.00","6.000","4200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060073","2017-05-08","2610000050","B PLAZA NADEEM KHAN","4","4041","BEORING NIPPEL","250.00000","0.000","0.00","6.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060098","2017-06-30","2610000001","Walk-In-Customers","1","4359","SET COVER 5015 W","1800.00000","0.000","0.00","2.000","3600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060098","2017-06-30","2610000001","Walk-In-Customers","2","4022","WAST PIPE PVC 1 1/2","150.00000","0.000","0.00","1.000","150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060072","2017-05-08","2610000028","KASHIF SB 245/G PHS# 5 DHA","1","3866","MUSLIM SHWER GROHE","3500.00000","0.000","0.00","6.000","21000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060072","2017-05-08","2610000028","KASHIF SB 245/G PHS# 5 DHA","2","4325","DAIL PLET AUTO SMART GROHE","7030.00000","0.000","0.00","5.000","35150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060072","2017-05-08","2610000028","KASHIF SB 245/G PHS# 5 DHA","3","3888","BASIN MIXER EURO SAMRT CASMO","7770.00000","0.000","0.00","7.000","54390.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060072","2017-05-08","2610000028","KASHIF SB 245/G PHS# 5 DHA","4","3894","SINK MIXER CHI ","6500.00000","0.000","0.00","1.000","6500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060072","2017-05-08","2610000028","KASHIF SB 245/G PHS# 5 DHA","5","4088","SINK MIXER 8317","3500.00000","0.000","0.00","2.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060069","2017-06-20","2610000045","347/Y PHS# 3","1","3731","COMMODE:CAMMOD W/H K01","9000.00000","0.000","0.00","1.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060070","2017-06-23","2610000049","HAJI HAKM SB 73 / C PH# 6","1","3676","VANITY:VANITY 70102","26500.00000","0.000","0.00","1.000","26500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060068","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","1","4339","D-CORNER RACK","1500.00000","0.000","0.00","1.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060068","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","2","4039","CP NOZAL 6\'\'","150.00000","0.000","0.00","1.000","150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060067","2017-06-22","2610000001","Walk-In-Customers","1","4021","WAST PIPE CROM","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060066","2017-06-22","2610000001","Walk-In-Customers","1","3966","BIB COCK 3/4","500.00000","0.000","0.00","3.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060066","2017-06-22","2610000001","Walk-In-Customers","2","4339","D-CORNER RACK","1600.00000","0.000","0.00","1.000","1600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060066","2017-06-22","2610000001","Walk-In-Customers","3","4254","SLAB:BAWOL 053","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060066","2017-06-22","2610000001","Walk-In-Customers","4","4340","BASIN MIXER 6013","3100.00000","0.000","0.00","1.000","3100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060066","2017-06-22","2610000001","Walk-In-Customers","5","4172","TABLE SET WHITE","1400.00000","0.000","0.00","5.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060066","2017-06-22","2610000001","Walk-In-Customers","6","4179","TABLE SET WHITE 2 PEC SOOP DISH OR BURSH HOLDER","350.00000","0.000","0.00","2.000","700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060096","2017-06-29","2610000045","347/Y PHS# 3","1","4353","RAIN SHOWER 897","3025.00000","0.000","0.00","1.000","3025.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060096","2017-06-29","2610000045","347/Y PHS# 3","2","4354","HAND SHOWER 517 CP","2175.00000","0.000","0.00","1.000","2175.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","1","3974","T-COCK JAGUAR","400.00000","0.000","0.00","5.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","2","3969","D-BIB COCK JAGUAR","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","3","3826","MUSLIM SHWER SONEX","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","4","4031","THIMBLE GREES","350.00000","0.000","0.00","1.000","350.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","5","4018","CONACTION PIPE 2FIT","250.00000","0.000","0.00","1.000","250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","6","4034","CP NOZAL 1\'\'","80.00000","0.000","0.00","6.000","480.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","7","4036","CP NOZAL 1 1/2\'\'","95.00000","0.000","0.00","2.000","190.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","8","4015","MUSLIM SHWER CHAIN PIPE","600.00000","0.000","0.00","2.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060063","2017-06-21","2610000001","Walk-In-Customers","1","3585","HOB:HOOB 10T","5500.00000","0.000","0.00","1.000","5500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","1","4036","CP NOZAL 1 1/2\'\'","70.00000","0.000","0.00","24.000","1680.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","10","3866","MUSLIM SHWER GROHE","3300.00000","0.000","0.00","6.000","19800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","11","3947","PUSH WAIST 4\'\'","600.00000","0.000","0.00","6.000","3600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","12","3957","BOTLE TRAP PIPE","200.00000","0.000","0.00","6.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","2","4035","CP NOZAL 2\'\'","80.00000","0.000","0.00","24.000","1920.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","3","4335","SHOWER PANAL CP","18000.00000","0.000","0.00","1.000","18000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","4","4044","TAFLAN TAPE","15.00000","0.000","0.00","60.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","5","4165","TAWEL RAD G CHI","800.00000","0.000","0.00","5.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","6","4166","TAWEL RING G CHI","800.00000","0.000","0.00","1.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","7","4167","PAPER HOLDER G CHI","800.00000","0.000","0.00","6.000","4800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","8","4336","TANK LOCAL WHITE","1500.00000","0.000","0.00","1.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","9","4018","CONACTION PIPE 2FIT","250.00000","0.000","0.00","1.000","250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","1","3893","BASIN MIXER QUADERA CHI","13900.00000","0.000","0.00","6.000","83400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","10","4334","SINK BOWL","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","11","4334","SINK BOWL","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","12","4334","SINK BOWL","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","13","4098","SINK MIXER 7109","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","14","4088","SINK MIXER 8317","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","15","3963","BIB COCK STYLISH","350.00000","0.000","0.00","9.000","3150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","16","3966","BIB COCK 3/4","450.00000","0.000","0.00","1.000","450.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","17","3989","FLOOR WAIST PLAN NEW","300.00000","0.000","0.00","21.000","6300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","18","3986","FLOOR WAIST KABZA ","300.00000","0.000","0.00","11.000","3300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","19","4034","CP NOZAL 1\'\'","60.00000","0.000","0.00","24.000","1440.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","2","4332","DAIL PLET AUTO QUADERA","13600.00000","0.000","0.00","2.000","27200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","3","4333","DAIL PLET NON AUTO QUADERA","11900.00000","0.000","0.00","2.000","23800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","4","3857","SPOUT GROHE 13255000","4500.00000","0.000","0.00","2.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","5","4040","CP NEUT","80.00000","0.000","0.00","2.000","160.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","6","4004","RAIN SHOWER SLIM 12*12","2500.00000","0.000","0.00","4.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","7","3974","T-COCK JAGUAR","300.00000","0.000","0.00","32.000","9600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","8","3733","COMMODE:CAMMOD W/H K05","9500.00000","0.000","0.00","6.000","57000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","9","4222","THIMBLE SET","1200.00000","0.000","0.00","6.000","7200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060060","2017-06-21","2610000046","QAYUM SB DHA","1","4331","SHOWER SET 981-983 W/OUT 510 + 507","21134.00000","0.000","0.00","1.000","21134.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060059","2017-06-20","2610000001","Walk-In-Customers","1","3977","U-BEND","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060059","2017-06-20","2610000001","Walk-In-Customers","2","4069","T-ARM 18\'\' JAGUER","1800.00000","0.000","0.00","1.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060059","2017-06-20","2610000001","Walk-In-Customers","3","4329","SHOWER RAD 4FT","750.00000","0.000","0.00","1.000","750.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060059","2017-06-20","2610000001","Walk-In-Customers","4","4002","RAIN SHOWER SQUARE 8*8","2500.00000","0.000","0.00","1.000","2500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060057","2017-06-20","2610000001","Walk-In-Customers","1","4040","CP NEUT","90.00000","0.000","0.00","4.000","360.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060058","2017-06-20","2610000001","Walk-In-Customers","1","3975","T-COCK GROHE CHI","325.00000","0.000","0.00","1.000","325.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060056","2017-06-20","2610000001","Walk-In-Customers","1","4321","SHOWER SET SMART GROHE CHI","12000.00000","0.000","0.00","1.000","12000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060056","2017-06-20","2610000001","Walk-In-Customers","2","4282","ACCESSORY SET  GROHE","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060055","2017-06-20","2610000001","Walk-In-Customers","1","4328","UNDER CONTER L X 136","2450.00000","0.000","0.00","20.000","49000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060054","2017-06-19","2610000001","Walk-In-Customers","1","4327","SET COVER 2006 IVORY","2000.00000","0.000","0.00","1.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060097","2017-06-30","2610000001","Walk-In-Customers","1","4358","GARD BAR 304","1500.00000","0.000","0.00","1.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060052","2017-06-20","2610000045","347/Y PHS# 3","1","4035","CP NOZAL 2\'\'","85.00000","0.000","0.00","6.000","510.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060052","2017-06-20","2610000045","347/Y PHS# 3","2","4044","TAFLAN TAPE","25.00000","0.000","0.00","12.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060052","2017-06-20","2610000045","347/Y PHS# 3","3","3953","BOTLE TRAP JAGUAR","1500.00000","0.000","0.00","1.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060052","2017-06-20","2610000045","347/Y PHS# 3","4","3957","BOTLE TRAP PIPE","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060052","2017-06-20","2610000045","347/Y PHS# 3","5","4325","DAIL PLET AUTO SMART GROHE","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060052","2017-06-20","2610000045","347/Y PHS# 3","6","4041","BEORING NIPPEL","250.00000","0.000","0.00","1.000","250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060051","2017-06-19","2610000044","KHALID SB ASKRI 10","1","3826","MUSLIM SHWER SONEX","1000.00000","0.000","0.00","1.000","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060050","2017-06-20","2610000001","Walk-In-Customers","1","3905","DAIL PLET EURO SMART GROHE CHI","6450.00000","0.000","0.00","1.000","6450.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060050","2017-06-20","2610000001","Walk-In-Customers","2","3857","SPOUT GROHE 13255000","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060049","2017-06-20","2610000001","Walk-In-Customers","1","4222","THIMBLE SET","1400.00000","0.000","0.00","3.000","4200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060049","2017-06-20","2610000001","Walk-In-Customers","2","3974","T-COCK JAGUAR","350.00000","0.000","0.00","3.000","1050.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060049","2017-06-20","2610000001","Walk-In-Customers","3","4041","BEORING NIPPEL","125.00000","0.000","0.00","5.000","625.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060049","2017-06-20","2610000001","Walk-In-Customers","4","4323","CONACTION PIPE 4FIT","800.00000","0.000","0.00","2.000","1600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060049","2017-06-20","2610000001","Walk-In-Customers","5","4324","CONACTION PIPE 1FIT","250.00000","0.000","0.00","2.000","500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060049","2017-06-20","2610000001","Walk-In-Customers","6","4020","BASIN MIXER PIPE","150.00000","0.000","0.00","2.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060048","2017-06-17","2610000001","Walk-In-Customers","1","4322","COMMODE A/S 2086","13000.00000","0.000","0.00","1.000","13000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060047","2017-06-17","2610000001","Walk-In-Customers","1","4321","SHOWER SET SMART GROHE CHI","12000.00000","0.000","0.00","1.000","12000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060047","2017-06-17","2610000001","Walk-In-Customers","2","4282","ACCESSORY SET  GROHE","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060046","2017-06-17","2610000001","Walk-In-Customers","1","4320","JACUZZI:JACUZZI: ITALYA 03 54X51","45000.00000","0.000","0.00","1.000","45000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060045","2017-06-17","2610000041","NADEEM SB CUSTOMER","1","4319","ESPA PUMP 0.8 HP","20500.00000","0.000","0.00","1.000","20500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060043","2017-06-17","2610000001","Walk-In-Customers","1","4317","MIRROR 18X24","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060044","2017-06-17","2610000001","Walk-In-Customers","1","4318","MIRROR 24X32","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060040","2017-06-17","2610000001","Walk-In-Customers","1","4314","WIGO SET CLASSIC RAIN SHOWER 12X12","20150.00000","0.000","0.00","1.000","20150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060040","2017-06-17","2610000001","Walk-In-Customers","2","3906","CLASSIC SET OCTION","10900.00000","0.000","0.00","1.000","10900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060040","2017-06-17","2610000001","Walk-In-Customers","3","3908","SWANA SET","11528.00000","0.000","0.00","2.000","23056.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060040","2017-06-17","2610000001","Walk-In-Customers","4","4313","SWANA SET NON BATH MIXER","7160.00000","0.000","0.00","1.000","7160.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060040","2017-06-17","2610000001","Walk-In-Customers","5","4315","2 D CLASSIC SET","14650.00000","0.000","0.00","1.000","14650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060040","2017-06-17","2610000001","Walk-In-Customers","6","3913","RADO-B SET CLASSIC","18650.00000","0.000","0.00","1.000","18650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070002","2017-07-01","2610000059","H-NO 254-DD PHS# 4 03218487965","1","3745","COMMODE:CAMMOD VG-854 4\'\'","13000.00000","0.000","0.00","2.000","26000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070002","2017-07-01","2610000059","H-NO 254-DD PHS# 4 03218487965","2","4031","THIMBLE GREES","300.00000","0.000","0.00","2.000","600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070002","2017-07-01","2610000059","H-NO 254-DD PHS# 4 03218487965","3","4018","CONACTION PIPE 2FIT","300.00000","0.000","0.00","2.000","600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070002","2017-07-01","2610000059","H-NO 254-DD PHS# 4 03218487965","4","4365","BATH MIXER 4091 WITH RAIN SHOWER 8X8","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","1","3610","JACUZZI:JACUZZI:BTG 06","45600.00000","0.000","0.00","1.000","45600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","10","3474","SINK:SINK 6045 S","2400.00000","0.000","0.00","1.000","2400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","11","3585","HOB:HOOB 10T","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","12","3566","HOB:HOOB BH-68","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","13","3534","HOOD:HOOD 36\'\' SB","12000.00000","0.000","0.00","1.000","12000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","14","3535","HOOD:HOOD 36\'\' SBT","9500.00000","0.000","0.00","1.000","9500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","2","4252","UNDER CONTER HD3","2800.00000","0.000","0.00","1.000","2800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","3","4254","SLAB:BAWOL 053","4700.00000","0.000","0.00","1.000","4700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","4","4255","SLAB:BAWOL 6332","8500.00000","0.000","0.00","1.000","8500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","5","4253","UNDER CONTER HD18","3900.00000","0.000","0.00","1.000","3900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","6","3733","COMMODE:CAMMOD W/H K05","9000.00000","0.000","0.00","5.000","45000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","7","4031","THIMBLE GREES","300.00000","0.000","0.00","5.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","8","4018","CONACTION PIPE 2FIT","300.00000","0.000","0.00","5.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060007","2017-06-03","2610000001","Walk-In-Customers","9","3490","SINK:SINK 6045 B","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","1","3493","OVEN:MICRO OVEN","52000.00000","0.000","0.00","1.000","52000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","2","3534","HOOD:HOOD 36\'\' SB","25000.00000","0.000","0.00","1.000","25000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","3","3544","HOB:HOOB-KITCHEN MASTER ","15500.00000","0.000","0.00","1.000","15500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","4","3469","SINK:SINK 518","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","5","3822","SINK MIXER 316","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","6","4250","LODER UONIT PTI 022","18500.00000","0.000","0.00","1.000","18500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060005","2017-06-03","2610000001","Walk-In-Customers","7","3974","T-COCK JAGUAR","350.00000","0.000","0.00","2.000","700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060001","2017-06-01","2610000032","AHMAD SB","1","4238","VANITY:PVC 36\'\' S.T","16000.00000","0.000","0.00","1.000","16000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060001","2017-06-01","2610000032","AHMAD SB","2","4237","VANITY:PELER 14\'\'","10000.00000","0.000","0.00","1.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060001","2017-06-01","2610000032","AHMAD SB","3","4239","VANITY:PVC 48\'\' WT","20000.00000","0.000","0.00","1.000","20000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060001","2017-06-01","2610000032","AHMAD SB","4","4028","MANIFIVE MIRREOR LED","4000.00000","0.000","0.00","1.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060001","2017-06-01","2610000032","AHMAD SB","5","4028","MANIFIVE MIRREOR LED","5500.00000","0.000","0.00","1.000","5500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060001","2017-06-01","2610000032","AHMAD SB","6","4028","MANIFIVE MIRREOR LED","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060002","2017-06-01","2610000027","SAYYAD BROTHER","1","3733","COMMODE:CAMMOD W/H K05","8000.00000","0.000","0.00","7.000","56000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060002","2017-06-01","2610000027","SAYYAD BROTHER","2","4222","THIMBLE SET","1500.00000","0.000","0.00","7.000","10500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","1","3826","MUSLIM SHWER SONEX","1300.00000","0.000","0.00","1.000","1300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","10","4187","TOWEL RING JAGUAR","800.00000","0.000","0.00","1.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","2","3969","D-BIB COCK JAGUAR","1300.00000","0.000","0.00","1.000","1300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","3","3974","T-COCK JAGUAR","650.00000","0.000","0.00","2.000","1300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","4","3820","BASIN MIXER 623","5500.00000","0.000","0.00","1.000","5500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","5","3946","PUSH WAIST USA","700.00000","0.000","0.00","1.000","700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","6","3953","BOTLE TRAP JAGUAR","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","7","4228","BASIN MIXER 3173","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","8","3986","FLOOR WAIST KABZA ","350.00000","0.000","0.00","2.000","700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060003","2017-06-01","2610000045","347/Y PHS# 3","9","4241","COMMODE W/H 2606","11000.00000","0.000","0.00","1.000","11000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060012","2017-06-06","2610000027","SAYYAD BROTHER","1","4270","SHOWER SET 761-927","18850.00000","0.000","0.00","1.000","18850.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060012","2017-06-06","2610000027","SAYYAD BROTHER","2","3718","SLAB:BAWOL LX-055","5000.00000","0.000","0.00","3.000","15000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060012","2017-06-06","2610000027","SAYYAD BROTHER","3","3947","PUSH WAIST 4\'\'","700.00000","0.000","0.00","3.000","2100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060012","2017-06-06","2610000027","SAYYAD BROTHER","4","4023","WAST PIPE SS","300.00000","0.000","0.00","3.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060015","2017-06-07","2610000028","KASHIF SB 245/G PHS# 5 DHA","1","4273","SINK BOWL 650","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060027","2017-06-12","2610000001","Walk-In-Customers","1","4261","SHOWER SET 2807","13450.00000","0.000","0.00","1.000","13450.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060027","2017-06-12","2610000001","Walk-In-Customers","2","4261","SHOWER SET 2807","16950.00000","0.000","0.00","2.000","33900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060016","2017-06-07","2610000001","Walk-In-Customers","1","3826","MUSLIM SHWER SONEX","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060016","2017-06-07","2610000001","Walk-In-Customers","2","3974","T-COCK JAGUAR","650.00000","0.000","0.00","1.000","650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","1","4014","CONNECTOR PIPE","250.00000","0.000","0.00","1.000","250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","2","4029","THIMBLE WHITE","200.00000","0.000","0.00","1.000","200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","3","4274","SINK MIXER 941","5400.00000","0.000","0.00","1.000","5400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","4","4275","BASIN MIXER 384","5100.00000","0.000","0.00","1.000","5100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","5","4276","BASIN MIXER 383","6780.00000","0.000","0.00","1.000","6780.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","6","4018","CONACTION PIPE 2FIT","200.00000","0.000","0.00","1.000","200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","7","3947","PUSH WAIST 4\'\'","600.00000","0.000","0.00","1.000","600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060018","2017-06-07","2610000029","MURTZA CUSTMER","8","4278","VANITY: PVC 14X24","10000.00000","0.000","0.00","1.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060019","2017-06-08","2610000001","Walk-In-Customers","1","4280","TANK GROHE WITHE BOTTAN","18700.00000","0.000","0.00","2.000","37400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060020","2017-06-08","2610000029","MURTZA CUSTMER","1","4281","HOOD:HOOD BH-503","13000.00000","0.000","0.00","1.000","13000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060020","2017-06-08","2610000029","MURTZA CUSTMER","2","4275","BASIN MIXER 384","5100.00000","0.000","0.00","1.000","5100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060020","2017-06-08","2610000029","MURTZA CUSTMER","3","4279","UNDER CONTER 005","18000.00000","0.000","0.00","1.000","18000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060020","2017-06-08","2610000029","MURTZA CUSTMER","4","4282","ACCESSORY SET  GROHE","3800.00000","0.000","0.00","1.000","3800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","1","4283","COMMODE:CAMMOD W/H RI-205","8000.00000","0.000","0.00","4.000","32000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","10","4041","BEORING NIPPEL","150.00000","0.000","0.00","6.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","11","3989","FLOOR WAIST PLAN NEW","275.00000","0.000","0.00","16.000","4400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","12","4044","TAFLAN TAPE","12.00000","0.000","0.00","36.000","432.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","13","3964","BIB COCK JAGUAR","300.00000","0.000","0.00","5.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","14","3974","T-COCK JAGUAR","325.00000","0.000","0.00","36.000","11700.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","15","3895","MUSLIM SHWER GROHE CHI","750.00000","0.000","0.00","6.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","16","4286","DORI","20.00000","0.000","0.00","36.000","720.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","17","4098","SINK MIXER 7109","6500.00000","0.000","0.00","1.000","6500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","2","3741","COMMODE:CAMMOD W/H RI-210","8000.00000","0.000","0.00","2.000","16000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","3","4222","THIMBLE SET","1200.00000","0.000","0.00","6.000","7200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","4","4284","SINK MIXER 7110 SPPRING SMALL","5000.00000","0.000","0.00","2.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","5","4000","RAIN SHOWER SOQEAR 16*16 SLIM","3500.00000","0.000","0.00","2.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","6","4285","HAND SHOWER CHI","2500.00000","0.000","0.00","3.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","7","4034","CP NOZAL 1\'\'","65.00000","0.000","0.00","36.000","2340.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","8","4035","CP NOZAL 2\'\'","80.00000","0.000","0.00","24.000","1920.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","9","4039","CP NOZAL 6\'\'","175.00000","0.000","0.00","8.000","1400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","1","4311","T-COCK 2294 GROHE","800.00000","0.000","0.00","17.000","13600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","10","4044","TAFLAN TAPE","20.00000","0.000","0.00","24.000","480.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","11","4034","CP NOZAL 1\'\'","60.00000","0.000","0.00","12.000","720.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","12","4036","CP NOZAL 1 1/2\'\'","75.00000","0.000","0.00","12.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","13","3964","BIB COCK JAGUAR","300.00000","0.000","0.00","2.000","600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","14","4293","BASIN STAND SMALL","1800.00000","0.000","0.00","1.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","2","3826","MUSLIM SHWER SONEX","1300.00000","0.000","0.00","3.000","3900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","3","4243","D-BIB COCK SONIX 355","1350.00000","0.000","0.00","3.000","4050.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","4","4291","TANK HD 2T","2565.00000","0.000","0.00","1.000","2565.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","5","4292","BASIN HD 19","4450.00000","0.000","0.00","1.000","4450.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","6","4018","CONACTION PIPE 2FIT","250.00000","0.000","0.00","6.000","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","7","3987","FLOOR WAIST PUSH","275.00000","0.000","0.00","3.000","825.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","8","4023","WAST PIPE SS","200.00000","0.000","0.00","3.000","600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060026","2017-06-12","2610000001","Walk-In-Customers","9","3947","PUSH WAIST 4\'\'","650.00000","0.000","0.00","3.000","1950.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060024","2017-06-10","2610000031","36-D LAWRENCE ROAD LHR 03034291889","1","4288","VANITY: 3100 40\' PVC","19000.00000","0.000","0.00","1.000","19000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060025","2017-06-12","2610000034","H-NO. 923/D PHS 6 DHA LHR","1","3534","HOOD:HOOD 36\'\' SB","10500.00000","0.000","0.00","1.000","10500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060028","2017-06-12","2610000035","MR. ANEES SB 0321-4185133","1","4290","SINK MIXER 905 CP","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060028","2017-06-12","2610000035","MR. ANEES SB 0321-4185133","2","3813","BASIN MIXER 4093","4000.00000","0.000","0.00","2.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060028","2017-06-12","2610000035","MR. ANEES SB 0321-4185133","3","4254","SLAB:BAWOL 053","6000.00000","0.000","0.00","2.000","12000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060028","2017-06-12","2610000035","MR. ANEES SB 0321-4185133","4","3691","SLAB:SLAB 6140 W 24*12","4000.00000","0.000","0.00","1.000","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060035","2017-06-16","2610000001","Walk-In-Customers","1","3762","COMMODE:W/C","2500.00000","0.000","0.00","5.000","12500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060035","2017-06-16","2610000001","Walk-In-Customers","2","4024","HOCKY PIPE SS","350.00000","0.000","0.00","5.000","1750.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060030","2017-06-13","2610000001","Walk-In-Customers","1","4235","WALLPAPER","1800.00000","0.000","0.00","16.000","28800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","1","4294","BLIND","105.00000","0.000","0.00","14.000","1470.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","2","4294","BLIND","105.00000","0.000","0.00","14.000","1470.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","3","4294","BLIND","105.00000","0.000","0.00","14.000","1470.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","4","4294","BLIND","105.00000","0.000","0.00","19.000","1995.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","5","4294","BLIND","105.00000","0.000","0.00","14.000","1470.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","6","4294","BLIND","105.00000","0.000","0.00","14.000","1470.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","7","4294","BLIND","105.00000","0.000","0.00","14.000","1470.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060031","2017-06-13","2610000001","Walk-In-Customers","8","4295","ROLLER BLIND","125.00000","0.000","0.00","64.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060032","2017-06-13","2610000001","Walk-In-Customers","1","3826","MUSLIM SHWER SONEX","1190.00000","0.000","0.00","1.000","1190.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060032","2017-06-13","2610000001","Walk-In-Customers","2","3828","JUTT SHWER 518","1233.00000","0.000","0.00","1.000","1233.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060033","2017-06-14","2610000001","Walk-In-Customers","1","3692","SLAB:SLAB 3100-40\'\' W","9000.00000","0.000","0.00","1.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060034","2017-06-15","2610000001","Walk-In-Customers","1","3740","COMMODE:CAMMOD W/H ENG","11000.00000","0.000","0.00","1.000","11000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060042","2017-06-17","2610000040","SHOAIB KHAN SB","1","4316","AIR FRISHNER","2000.00000","0.000","0.00","1.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060036","2017-06-15","2610000038","MALL OF SIALKOT","1","4302","QAWATER NEUT 1/2","80.00000","0.000","0.00","48.000","3840.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060036","2017-06-15","2610000038","MALL OF SIALKOT","2","4303","BIB COCK 415","1100.00000","0.000","0.00","4.000","4400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060036","2017-06-15","2610000038","MALL OF SIALKOT","3","4304","ABLUTION MIXER 333 SONIX","4380.00000","0.000","0.00","6.000","26280.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060037","2017-06-15","2610000038","MALL OF SIALKOT","1","4023","WAST PIPE SS","350.00000","0.000","0.00","26.000","9100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060037","2017-06-15","2610000038","MALL OF SIALKOT","2","4305","ACCESSORY SET  3104","4500.00000","0.000","0.00","2.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060038","2017-06-15","2610000038","MALL OF SIALKOT","1","4312","T-COCK 2202500 GROHE 1/2","800.00000","0.000","0.00","40.000","32000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL060041","2017-06-17","2610000001","Walk-In-Customers","1","3826","MUSLIM SHWER SONEX","1300.00000","0.000","0.00","2.000","2600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070020","2017-07-04","2610000001","Walk-In-Customers","1","4391","SINK MIXER FAYSEL","3900.00000","0.000","0.00","1.000","3900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070020","2017-07-04","2610000001","Walk-In-Customers","2","4363","SINK MIXER 901","4500.00000","0.000","0.00","1.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070021","2017-07-04","2610000001","Walk-In-Customers","1","4392","SINK BOWL 18X36","3600.00000","0.000","0.00","1.000","3600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070021","2017-07-04","2610000001","Walk-In-Customers","2","4247","SINK BOWL 8149","8500.00000","0.000","0.00","1.000","8500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070022","2017-07-05","2610000001","Walk-In-Customers","1","3986","FLOOR WAIST KABZA ","300.00000","0.000","0.00","4.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070022","2017-07-05","2610000001","Walk-In-Customers","2","3989","FLOOR WAIST PLAN NEW","0.00000","0.000","0.00","3.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070022","2017-07-05","2610000001","Walk-In-Customers","3","3986","FLOOR WAIST KABZA ","0.00000","0.000","0.00","1.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070023","2017-07-05","2610000001","Walk-In-Customers","1","3947","PUSH WAIST 4\'\'","700.00000","0.000","0.00","10.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070023","2017-07-05","2610000001","Walk-In-Customers","2","3950","BOTLE TRAP WWT","1200.00000","0.000","0.00","10.000","12000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070024","2017-07-05","2610000064","PESHWAR MALL","1","4202","HOB:HOOB 1/B","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070024","2017-07-05","2610000064","PESHWAR MALL","2","4200","HOB:HOOB 5/B","14900.00000","0.000","0.00","2.000","29800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070024","2017-07-05","2610000064","PESHWAR MALL","3","4334","SINK BOWL","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070024","2017-07-05","2610000064","PESHWAR MALL","4","4334","SINK BOWL","6000.00000","0.000","0.00","3.000","18000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070024","2017-07-05","2610000064","PESHWAR MALL","5","3493","OVEN:MICRO OVEN","56000.00000","0.000","0.00","2.000","112000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070025","2017-07-05","2610000065","H-NO 25/E 35210478","1","4393","BATH TUB 42X42","31000.00000","0.000","0.00","1.000","31000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070026","2017-07-05","2610000001","Walk-In-Customers","1","4395","MIRROR 2\'\'X6\'\'","6000.00000","0.000","0.00","1.000","6000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","1","3960","SPOUT JAGUAR","1800.00000","0.000","0.00","1.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","10","4321","SHOWER SET SMART GROHE CHI","14000.00000","0.000","0.00","1.000","14000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","11","3947","PUSH WAIST 4\'\'","500.00000","0.000","0.00","2.000","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","12","4023","WAST PIPE SS","200.00000","0.000","0.00","2.000","400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","2","3978","MUSLIM SHOWER CHI","800.00000","0.000","0.00","1.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","3","3974","T-COCK JAGUAR","300.00000","0.000","0.00","3.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","4","4238","VANITY:PVC 36\'\' S.T","17000.00000","0.000","0.00","1.000","17000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","5","3738","COMMODE:CAMMOD W/H BM-1203050","8000.00000","0.000","0.00","1.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","6","4222","THIMBLE SET","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","7","4399","COMMODE 5023 WHITE","9500.00000","0.000","0.00","1.000","9500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","8","4031","THIMBLE GREES","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070028","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","9","4018","CONACTION PIPE 2FIT","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","1","3490","SINK:SINK 6045 B","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","10","3947","PUSH WAIST 4\'\'","500.00000","0.000","0.00","1.000","500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","11","4023","WAST PIPE SS","200.00000","0.000","0.00","1.000","200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","12","4397","VANITY 12X14","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","13","3732","COMMODE:CAMMOD W/H K03","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","14","4222","THIMBLE SET","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","15","3975","T-COCK GROHE CHI","300.00000","0.000","0.00","3.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","16","3978","MUSLIM SHOWER CHI","800.00000","0.000","0.00","1.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","17","3849","BASIN MIXER GROHE","2500.00000","0.000","0.00","1.000","2500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","18","4398","JACUZZI:JACUZZI:29X63","43000.00000","0.000","0.00","1.000","43000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","19","4004","RAIN SHOWER SLIM 12*12","2000.00000","0.000","0.00","1.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","2","4284","SINK MIXER 7110 SPPRING SMALL","5000.00000","0.000","0.00","1.000","5000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","20","4325","DAIL PLET AUTO SMART GROHE","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","3","3975","T-COCK GROHE CHI","300.00000","0.000","0.00","2.000","600.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","4","4396","VANITY 32\'\'","13000.00000","0.000","0.00","1.000","13000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","5","3849","BASIN MIXER GROHE","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","6","3975","T-COCK GROHE CHI","300.00000","0.000","0.00","3.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","7","3978","MUSLIM SHOWER CHI","800.00000","0.000","0.00","1.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","8","3738","COMMODE:CAMMOD W/H BM-1203050","8000.00000","0.000","0.00","1.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","9","4222","THIMBLE SET","1200.00000","0.000","0.00","1.000","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","1","3534","HOOD:HOOD 36\'\' SB","25000.00000","0.000","0.00","1.000","25000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","2","4200","HOB:HOOB 5/B","15500.00000","0.000","0.00","1.000","15500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","3","4273","SINK BOWL 650","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","4","3894","SINK MIXER CHI ","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","5","3500","OVEN:MICRO OVEN BH-97728","54000.00000","0.000","0.00","1.000","54000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","6","4201","HOB:HOOB 3/B","3000.00000","0.000","0.00","1.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070030","2017-07-06","2610000067","KHAZIR SB SOI GAS SUCITY","1","4225","LAMINATED WOOD FLOOR MAT","128.00000","0.000","0.00","270.000","34560.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070030","2017-07-06","2610000067","KHAZIR SB SOI GAS SUCITY","2","4229","SKIRTING","45.00000","0.000","0.00","64.000","2880.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070030","2017-07-06","2610000067","KHAZIR SB SOI GAS SUCITY","3","4230","REDUCER PVC","45.00000","0.000","0.00","8.000","360.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070030","2017-07-06","2610000067","KHAZIR SB SOI GAS SUCITY","4","4225","LAMINATED WOOD FLOOR MAT","128.00000","0.000","0.00","27.000","3456.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070031","2017-07-06","2610000052","DR. ASIM SB 03214864288","1","4322","COMMODE A/S 2086","15000.00000","0.000","0.00","1.000","15000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070032","2017-07-06","2610000052","DR. ASIM SB 03214864288","1","3733","COMMODE:CAMMOD W/H K05","9000.00000","0.000","0.00","1.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","1","3732","COMMODE:CAMMOD W/H K03","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","2","3748","COMMODE:CAMMOD VG-840B 4\'\'","12500.00000","0.000","0.00","3.000","37500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","3","4222","THIMBLE SET","1500.00000","0.000","0.00","3.000","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","4","4018","CONACTION PIPE 2FIT","300.00000","0.000","0.00","3.000","900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","5","3947","PUSH WAIST 4\'\'","600.00000","0.000","0.00","5.000","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","6","3950","BOTLE TRAP WWT","1000.00000","0.000","0.00","1.000","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070034","2017-05-09","2610000056","242/L PH# 5 DHA  MR.UMAR","7","4021","WAST PIPE CROM","200.00000","0.000","0.00","5.000","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070035","2017-07-08","2610000068","FAZAN SB 03339678883","1","4402","VANITY:PVC 48\'\' ST","20000.00000","0.000","0.00","1.000","20000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070035","2017-07-08","2610000068","FAZAN SB 03339678883","2","4403","MIRROR TUCH 30X48","6000.00000","0.000","0.00","1.000","6000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070035","2017-07-08","2610000068","FAZAN SB 03339678883","3","4404","SINK BOWL DOUBLE","6500.00000","0.000","0.00","1.000","6500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070035","2017-07-08","2610000068","FAZAN SB 03339678883","4","3525","HOOD:HOOD BH-139","9500.00000","0.000","0.00","1.000","9500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070036","2017-07-08","2610000069","69/9-J-3 JOHAR TWON LHR","1","4405","SPRING MIXER LONG GRY","9000.00000","0.000","0.00","1.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070037","2017-07-08","2610000044","KHALID SB ASKRI 10","1","4406","MUSLIM SHOWER RAVI","1000.00000","0.000","0.00","1.000","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070038","2017-07-08","2610000001","Walk-In-Customers","1","3732","COMMODE:CAMMOD W/H K03","10500.00000","0.000","0.00","1.000","10500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070038","2017-07-08","2610000001","Walk-In-Customers","2","4407","COMMODE W/H 2605","8000.00000","0.000","0.00","1.000","8000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070038","2017-07-08","2610000001","Walk-In-Customers","3","4222","THIMBLE SET","1000.00000","0.000","0.00","10.000","10000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070039","2017-07-08","2610000070","102/CC PHS# 4 DHA SULTAN SB","1","4248","SINK 5043","3000.00000","0.000","0.00","5.000","15000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070040","2017-07-08","2610000066","398/B PH# 5 DHA KASHIF SB","1","4396","VANITY 32\'\'","13000.00000","0.000","0.00","1.000","13000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070041","2017-07-10","2610000001","Walk-In-Customers","1","3534","HOOD:HOOD 36\'\' SB","9000.00000","0.000","0.00","1.000","9000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070041","2017-07-10","2610000001","Walk-In-Customers","2","4408","COMMODE MARJAN","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070041","2017-07-10","2610000001","Walk-In-Customers","3","4409","COMMODE AROOBA","7000.00000","0.000","0.00","1.000","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070042","2017-07-11","2610000066","398/B PH# 5 DHA KASHIF SB","1","3867","MUSLIM SHWER GROHE MEAT 27812000","3500.00000","0.000","0.00","1.000","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070043","2017-07-11","2610000001","Walk-In-Customers","1","3470","SINK:SINK 8349","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070043","2017-07-11","2610000001","Walk-In-Customers","2","4410","SINK MIXER 7107","7500.00000","0.000","0.00","1.000","7500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070044","2017-07-11","2610000056","242/L PH# 5 DHA  MR.UMAR","1","3895","MUSLIM SHWER GROHE CHI","1000.00000","0.000","0.00","2.000","2000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070045","2017-07-11","2610000001","Walk-In-Customers","1","4364","SET COVER 2055 W","1800.00000","0.000","0.00","1.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070047","2017-07-12","2610000032","AHMAD SB","1","4225","LAMINATED WOOD FLOOR MAT","90.00000","0.000","0.00","200.000","18000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070047","2017-07-12","2610000032","AHMAD SB","2","4225","LAMINATED WOOD FLOOR MAT","95.00000","0.000","0.00","360.000","34200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070047","2017-07-12","2610000032","AHMAD SB","3","4229","SKIRTING","60.00000","0.000","0.00","144.000","8640.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070047","2017-07-12","2610000032","AHMAD SB","4","4343","T END MDF","60.00000","0.000","0.00","24.000","1440.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070046","2017-07-12","2610000066","398/B PH# 5 DHA KASHIF SB","1","3963","BIB COCK STYLISH","300.00000","0.000","0.00","6.000","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070046","2017-07-12","2610000066","398/B PH# 5 DHA KASHIF SB","2","4336","TANK LOCAL WHITE","1100.00000","0.000","0.00","1.000","1100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070046","2017-07-12","2610000066","398/B PH# 5 DHA KASHIF SB","3","3974","T-COCK JAGUAR","300.00000","0.000","0.00","1.000","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070046","2017-07-12","2610000066","398/B PH# 5 DHA KASHIF SB","4","3986","FLOOR WAIST KABZA ","275.00000","0.000","0.00","6.000","1650.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070046","2017-07-12","2610000066","398/B PH# 5 DHA KASHIF SB","5","3987","FLOOR WAIST PUSH","425.00000","0.000","0.00","10.000","4250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070048","2017-07-12","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","1","3947","PUSH WAIST 4\'\'","650.00000","0.000","0.00","5.000","3250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070049","2017-07-12","2610000001","Walk-In-Customers","1","4015","MUSLIM SHWER CHAIN PIPE","800.00000","0.000","0.00","1.000","800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SL070049","2017-07-12","2610000001","Walk-In-Customers","2","4156","SOOP DISH 304","200.00000","0.000","0.00","1.000","200.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTSL050001","2017-05-16","0026","","1","3931","VIGO BASIN MIXER CLASSIC","3100.00000","1.000","3100.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTSL050001","2017-05-16","0026","","2","4165","TAWEL RAD G CHI","900.00000","1.000","900.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050001","2017-05-16","0026","","1","4104","BATH MIXER CHI ","2800.00000","1.000","2800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050002","2017-05-17","0026","","1","4225","LAMINATED WOOD FLOOR MAT","170.00000","28.325","4815.25","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050003","2017-05-22","0026","","1","3987","FLOOR WAIST PUSH","650.00000","2.000","1300.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050004","2017-05-22","0026","","1","4219","COMMODE WALL HUNG","10125.00000","1.000","10125.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050005","2017-05-22","0026","","1","3697","SLAB:BOWAL","4000.00000","1.000","4000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050006","2017-05-22","0026","","1","4013","RAIN SHWER 516","1750.00000","2.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RT52","2017-05-24","0026","","1","4004","RAIN SHOWER SLIM 12*12","1500.00000","2.000","3000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RT52","2017-05-24","0026","","2","3698","SLAB:BAWOL Y016","6000.00000","2.000","12000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RT52","2017-05-24","0026","","3","3565","HOB:HOOB BH-S4","3500.00000","1.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050007","2017-05-24","0026","","1","4206","VANITY: 7 SHAP","8600.00000","1.000","8600.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060001","2017-06-07","2610000001","Walk-In-Customers","1","4272","SHOWER SET 981-983","18850.00000","1.000","18850.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060002","2017-06-07","2610000001","Walk-In-Customers","1","4277","BASIN MIXER 2805","3500.00000","2.000","7000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060002","2017-06-07","2610000001","Walk-In-Customers","2","3894","SINK MIXER CHI ","3900.00000","1.000","3900.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060003","2017-06-10","2610000001","Walk-In-Customers","1","4279","UNDER CONTER 005","18000.00000","1.000","18000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060004","2017-06-12","2610000001","Walk-In-Customers","1","3888","BASIN MIXER EURO SAMRT CASMO","7000.00000","3.000","21000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060005","2017-06-12","2610000001","Walk-In-Customers","1","4238","VANITY:PVC 36\'\' S.T","17500.00000","1.000","17500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060007","2017-06-13","2610000001","Walk-In-Customers","1","4293","BASIN STAND SMALL","1800.00000","1.000","1800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060008","2017-06-13","2610000001","Walk-In-Customers","1","3493","OVEN:MICRO OVEN","23000.00000","1.000","23000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060009","2017-06-13","2610000001","Walk-In-Customers","1","4031","THIMBLE GREES","300.00000","7.000","2100.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060010","2017-06-14","2610000001","Walk-In-Customers","1","4258","VANITY U PVC","14500.00000","1.000","14500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060011","2017-06-19","2610000032","AHMAD SB","1","3745","COMMODE:CAMMOD VG-854 4\'\'","10000.00000","1.000","10000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060013","2017-06-20","2610000001","Walk-In-Customers","1","4285","HAND SHOWER CHI","2500.00000","1.000","2500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060012","2017-06-20","2610000032","AHMAD SB","1","3947","PUSH WAIST 4\'\'","650.00000","4.000","2600.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060012","2017-06-20","2610000032","AHMAD SB","2","3953","BOTLE TRAP JAGUAR","1200.00000","5.000","6000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060012","2017-06-20","2610000032","AHMAD SB","3","4067","T-ARM 18\'\' WWT","1500.00000","1.000","1500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060014","2017-06-20","2610000001","Walk-In-Customers","1","4330","MOZAIQ SHEET S.S","1050.00000","59.000","61950.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060015","2017-06-20","2610000045","347/Y PHS# 3","1","4241","COMMODE W/H 2606","11000.00000","1.000","11000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060016","2017-06-22","2610000001","Walk-In-Customers","1","4243","D-BIB COCK SONIX 355","1350.00000","2.000","2700.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060016","2017-06-22","2610000001","Walk-In-Customers","2","4341","UPER CUNTER","2850.00000","1.000","2850.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060017","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","1","4342","VANITY PVC 6FT","40000.00000","1.000","40000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060018","2017-06-29","2610000045","347/Y PHS# 3","1","4004","RAIN SHOWER SLIM 12*12","3500.00000","1.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060018","2017-06-29","2610000045","347/Y PHS# 3","2","3984","HAND SHWER 065","2500.00000","1.000","2500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060019","2017-06-29","2610000035","MR. ANEES SB 0321-4185133","1","4356","ART BOWEL:2497","6000.00000","2.000","12000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060019","2017-06-29","2610000035","MR. ANEES SB 0321-4185133","2","4355","ART BOWEL:LEXTA 128","4000.00000","1.000","4000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070001","2017-06-01","2610000001","Walk-In-Customers","1","4339","D-CORNER RACK","2000.00000","1.000","2000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070002","2017-06-02","2610000001","Walk-In-Customers","1","3731","COMMODE:CAMMOD W/H K01","8000.00000","1.000","8000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070001","2017-07-06","2610000001","Walk-In-Customers","1","3740","COMMODE:CAMMOD W/H ENG","7800.00000","1.000","7800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070002","2017-07-06","2610000001","Walk-In-Customers","1","3740","COMMODE:CAMMOD W/H ENG","11000.00000","1.000","11000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070003","2017-07-07","2610000001","Walk-In-Customers","1","4210","VANITY: SLOP 36\'\'","5000.00000","1.000","5000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070004","2017-07-08","2610000001","Walk-In-Customers","1","4303","BIB COCK 415","1060.00000","1.000","1060.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070004","2017-07-08","2610000001","Walk-In-Customers","2","4304","ABLUTION MIXER 333 SONIX","4380.00000","1.000","4380.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070004","2017-07-08","2610000001","Walk-In-Customers","3","3976","T-COCK WHIT 2384","610.00000","1.000","610.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070005","2017-07-08","2610000066","398/B PH# 5 DHA KASHIF SB","1","4398","JACUZZI:JACUZZI:29X63","43000.00000","1.000","43000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070006","2017-07-11","2610000001","Walk-In-Customers","1","4260","MIRROR 36\'\' LED","5000.00000","1.000","5000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060010","2017-06-05","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060008","2017-06-03","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","350.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060004","2017-06-03","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070033","2017-07-07","2610000034","H-NO. 923/D PHS 6 DHA LHR","","","Discount","","0.000","0.00","","350.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070018","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","","","Discount","","0.000","0.00","","2640.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070016","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","","","Discount","","0.000","0.00","","1613.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070017","2017-07-04","2610000063","H-NO 1070/N PH# 6 BUTT SB","","","Discount","","0.000","0.00","","3500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070015","2017-07-04","2610000059","H-NO 254-DD PHS# 4 03218487965","","","Discount","","0.000","0.00","","80.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070013","2017-07-04","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","","","Discount","","0.000","0.00","","100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070011","2017-07-03","2610000062","H-NO 862/B PH# 5 DHA","","","Discount","","0.000","0.00","","50.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070010","2017-07-03","2610000061","UMER KHALID SB 54/C PHAS# 5 DHA","","","Discount","","0.000","0.00","","300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070006","2017-07-01","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070003","2017-07-01","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","705.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060009","2017-06-03","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","150.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060099","2017-06-30","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060078","2017-05-16","2610000049","HAJI HAKM SB 73 / C PH# 6","","","Discount","","0.000","0.00","","12500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060098","2017-06-30","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","50.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060068","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","","","Discount","","0.000","0.00","","50.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060066","2017-06-22","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","400.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060064","2017-06-22","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","","","Discount","","0.000","0.00","","370.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060062","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","","","Discount","","0.000","0.00","","3450.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060061","2017-06-21","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","","","Discount","","0.000","0.00","","39500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060060","2017-06-21","2610000046","QAYUM SB DHA","","","Discount","","0.000","0.00","","4434.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060059","2017-06-20","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","750.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060057","2017-06-20","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","60.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060058","2017-06-20","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","25.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060056","2017-06-20","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060055","2017-06-20","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060052","2017-06-20","2610000045","347/Y PHS# 3","","","Discount","","0.000","0.00","","860.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060047","2017-06-17","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060045","2017-06-17","2610000041","NADEEM SB CUSTOMER","","","Discount","","0.000","0.00","","1500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060044","2017-06-17","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060040","2017-06-17","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","66.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070002","2017-07-01","2610000059","H-NO 254-DD PHS# 4 03218487965","","","Discount","","0.000","0.00","","1200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060007","2017-06-03","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","6900.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060005","2017-06-03","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","5200.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060001","2017-06-01","2610000032","AHMAD SB","","","Discount","","0.000","0.00","","500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060003","2017-06-01","2610000045","347/Y PHS# 3","","","Discount","","0.000","0.00","","1800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060018","2017-06-07","2610000029","MURTZA CUSTMER","","","Discount","","0.000","0.00","","11730.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060020","2017-06-08","2610000029","MURTZA CUSTMER","","","Discount","","0.000","0.00","","7000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060021","2017-06-08","2610000030","200/1-B ST-NO #1 PHASE-5 DHA","","","Discount","","0.000","0.00","","4012.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060026","2017-06-12","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","40.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060028","2017-06-12","2610000035","MR. ANEES SB 0321-4185133","","","Discount","","0.000","0.00","","1000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060035","2017-06-16","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","250.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060031","2017-06-13","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","15.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060032","2017-06-13","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","23.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060036","2017-06-15","2610000038","MALL OF SIALKOT","","","Discount","","0.000","0.00","","20.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD060037","2017-06-15","2610000038","MALL OF SIALKOT","","","Discount","","0.000","0.00","","100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070021","2017-07-04","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070022","2017-07-05","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","100.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070023","2017-07-05","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","4000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070024","2017-07-05","2610000064","PESHWAR MALL","","","Discount","","0.000","0.00","","10800.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070027","2017-07-05","2610000066","398/B PH# 5 DHA KASHIF SB","","","Discount","","0.000","0.00","","1300.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070029","2017-07-06","2610000049","HAJI HAKM SB 73 / C PH# 6","","","Discount","","0.000","0.00","","4500.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070030","2017-07-06","2610000067","KHAZIR SB SOI GAS SUCITY","","","Discount","","0.000","0.00","","3966.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070038","2017-07-08","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","3000.00");
INSERT INTO v_p_vouchers VALUES("02","17","SD070049","2017-07-12","2610000001","Walk-In-Customers","","","Discount","","0.000","0.00","","500.00");


DROP TABLE IF EXISTS v_party;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,if((convert(substr(1,6) using latin1) = `s`.`creditor_id`),'S','C') AS `party_type` from (`nom` `n` join `system` `s`) where ((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`)) and (length(`n`.`ACCT_ID`) = 10));

INSERT INTO v_party VALUES("1310000001","Ashfaq Sons","C");
INSERT INTO v_party VALUES("1310000002","Porta Acrylic Bath Tubs Lahore","C");
INSERT INTO v_party VALUES("1310000003","TREND BATHROOM ACCESSORIES","C");
INSERT INTO v_party VALUES("1310000004","URBAN CERAMICS","C");
INSERT INTO v_party VALUES("1310000005","SABAAN","C");
INSERT INTO v_party VALUES("1310000006","MAGOON TRADERS","C");
INSERT INTO v_party VALUES("1310000007","MASTER","C");
INSERT INTO v_party VALUES("1310000008","DIAMOND","C");
INSERT INTO v_party VALUES("1310000009","A","C");
INSERT INTO v_party VALUES("1310000010","STYLE BATH WARE","C");
INSERT INTO v_party VALUES("1310000011","AL-HARMAIN PAINT CENTRE","C");
INSERT INTO v_party VALUES("1310000012","SYMBOL INDUSTRIES (PVT) LTD","C");
INSERT INTO v_party VALUES("1310000013","VEGA","C");
INSERT INTO v_party VALUES("1310000014","JAVAID","C");
INSERT INTO v_party VALUES("1310000015","MAHMOOD GUJRANWALA","C");
INSERT INTO v_party VALUES("1310000017","GOROHE","C");
INSERT INTO v_party VALUES("1310000018","KBS","C");
INSERT INTO v_party VALUES("1310000019","SKY SANITORY","C");
INSERT INTO v_party VALUES("1310000020","MIDAS","C");
INSERT INTO v_party VALUES("1310000021","USAMA PRINTING","C");
INSERT INTO v_party VALUES("1310000022","ALLAH WASAYA","C");
INSERT INTO v_party VALUES("1310000023","RAVI TRADERS","C");
INSERT INTO v_party VALUES("1310000024","SAMAAR SKIRTING","C");
INSERT INTO v_party VALUES("1310000025","MIAN FAKHAR","C");
INSERT INTO v_party VALUES("1310000026","USMAN","C");
INSERT INTO v_party VALUES("1310000027","IMC","C");
INSERT INTO v_party VALUES("1310000028","MAHMOOD SONS","C");
INSERT INTO v_party VALUES("1310000029","KBS","C");
INSERT INTO v_party VALUES("1310000030","MUHAMMADI STORE","C");
INSERT INTO v_party VALUES("1310000031","ILYAS/SONS","C");
INSERT INTO v_party VALUES("1310000032","WASEEM BROTHERS","C");
INSERT INTO v_party VALUES("1310000033","BASRA BROTHERS","C");
INSERT INTO v_party VALUES("1310000034","VIZDOM","C");
INSERT INTO v_party VALUES("1310000035","SILLA CONCEPT\'S","C");
INSERT INTO v_party VALUES("1310000036","CANON","C");
INSERT INTO v_party VALUES("1310000037","AMJAD GUJRANWALA","C");
INSERT INTO v_party VALUES("1310000038","GODI COMMODE","C");
INSERT INTO v_party VALUES("1310000039","NATURE","C");
INSERT INTO v_party VALUES("1310000040","ANSARI PLASTIC","C");
INSERT INTO v_party VALUES("1310000041","ASIAN STANDERED","C");
INSERT INTO v_party VALUES("1310000042","LEXTA","C");
INSERT INTO v_party VALUES("1310000043","SHEN CHINEESE","C");
INSERT INTO v_party VALUES("1310000044","MARACHI","C");
INSERT INTO v_party VALUES("1310000045","INTERIO FLOORS","C");
INSERT INTO v_party VALUES("1310000046","BEST HOME","C");
INSERT INTO v_party VALUES("1310000047","BUTT TRADER","C");
INSERT INTO v_party VALUES("2610000001","Walk-In-Customers","C");
INSERT INTO v_party VALUES("2610000003","Gourmet","C");
INSERT INTO v_party VALUES("2610000027","SAYYAD BROTHER","C");
INSERT INTO v_party VALUES("2610000028","KASHIF SB 245/G PHS# 5 DHA","C");
INSERT INTO v_party VALUES("2610000029","MURTZA CUSTMER","C");
INSERT INTO v_party VALUES("2610000030","200/1-B ST-NO #1 PHASE-5 DHA","C");
INSERT INTO v_party VALUES("2610000031","36-D LAWRENCE ROAD LHR 03034291889","C");
INSERT INTO v_party VALUES("2610000032","AHMAD SB","C");
INSERT INTO v_party VALUES("2610000033","OLYMPIA BUILDERS","C");
INSERT INTO v_party VALUES("2610000034","H-NO. 923/D PHS 6 DHA LHR","C");
INSERT INTO v_party VALUES("2610000035","MR. ANEES SB 0321-4185133","C");
INSERT INTO v_party VALUES("2610000036","904/K PHS#6 DHA 03228470847","C");
INSERT INTO v_party VALUES("2610000037","547/D 0322454045","C");
INSERT INTO v_party VALUES("2610000038","MALL OF SIALKOT","C");
INSERT INTO v_party VALUES("2610000039","DISPLAY","C");
INSERT INTO v_party VALUES("2610000040","SHOAIB KHAN SB","C");
INSERT INTO v_party VALUES("2610000041","NADEEM SB CUSTOMER","C");
INSERT INTO v_party VALUES("2610000042","CERAMICS","C");
INSERT INTO v_party VALUES("2610000043","HOME TECH","C");
INSERT INTO v_party VALUES("2610000044","KHALID SB ASKRI 10","C");
INSERT INTO v_party VALUES("2610000045","347/Y PHS# 3","C");
INSERT INTO v_party VALUES("2610000046","QAYUM SB DHA","C");
INSERT INTO v_party VALUES("2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA","C");
INSERT INTO v_party VALUES("2610000048","NASEEM AHMAD SOFTWARE DEVELOPER","C");
INSERT INTO v_party VALUES("2610000049","HAJI HAKM SB 73 / C PH# 6","C");
INSERT INTO v_party VALUES("2610000050","B PLAZA NADEEM KHAN","C");
INSERT INTO v_party VALUES("2610000051","125/E DHA PHS#6 03429693431","C");
INSERT INTO v_party VALUES("2610000052","DR. ASIM SB 03214864288","C");
INSERT INTO v_party VALUES("2610000053","69/G MODAL TWON","C");
INSERT INTO v_party VALUES("2610000054","228/B STAT LIFE","C");
INSERT INTO v_party VALUES("2610000056","242/L PH# 5 DHA  MR.UMAR","C");
INSERT INTO v_party VALUES("2610000057","ABDULLAH SB PH# 6 839/D DHA","C");
INSERT INTO v_party VALUES("2610000058","AFTAB SB","C");
INSERT INTO v_party VALUES("2610000059","H-NO 254-DD PHS# 4 03218487965","C");
INSERT INTO v_party VALUES("2610000060","246/E-1 WAPDA TWON PHAS# 1","C");
INSERT INTO v_party VALUES("2610000061","UMER KHALID SB 54/C PHAS# 5 DHA","C");
INSERT INTO v_party VALUES("2610000062","H-NO 862/B PH# 5 DHA","C");
INSERT INTO v_party VALUES("2610000063","H-NO 1070/N PH# 6 BUTT SB","C");
INSERT INTO v_party VALUES("2610000064","PESHWAR MALL","C");
INSERT INTO v_party VALUES("2610000065","H-NO 25/E 35210478","C");
INSERT INTO v_party VALUES("2610000066","398/B PH# 5 DHA KASHIF SB","C");
INSERT INTO v_party VALUES("2610000067","KHAZIR SB SOI GAS SUCITY","C");
INSERT INTO v_party VALUES("2610000068","FAZAN SB 03339678883","C");
INSERT INTO v_party VALUES("2610000069","69/9-J-3 JOHAR TWON LHR","C");
INSERT INTO v_party VALUES("2610000070","102/CC PHS# 4 DHA SULTAN SB","C");
INSERT INTO v_party VALUES("2610000071","FAROOQ SB 147/E DHA","C");


DROP TABLE IF EXISTS v_party_bal;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0);

INSERT INTO v_party_bal VALUES("0026","57640.25");
INSERT INTO v_party_bal VALUES("1310000","6719.00");
INSERT INTO v_party_bal VALUES("1310000006","173270.00");
INSERT INTO v_party_bal VALUES("1310000014","53290.00");
INSERT INTO v_party_bal VALUES("1310000018","16300.00");
INSERT INTO v_party_bal VALUES("1310000027","17340.00");
INSERT INTO v_party_bal VALUES("1310000028","208693.00");
INSERT INTO v_party_bal VALUES("1310000029","5500.00");
INSERT INTO v_party_bal VALUES("1310000030","960.00");
INSERT INTO v_party_bal VALUES("1310000031","350.00");
INSERT INTO v_party_bal VALUES("1310000033","57150.00");
INSERT INTO v_party_bal VALUES("1310000034","38675.00");
INSERT INTO v_party_bal VALUES("1310000035","1100.00");
INSERT INTO v_party_bal VALUES("1310000039","79564.00");
INSERT INTO v_party_bal VALUES("1310000045","3392.00");
INSERT INTO v_party_bal VALUES("1310000047","13000.00");
INSERT INTO v_party_bal VALUES("2610000001","-979943.00");
INSERT INTO v_party_bal VALUES("2610000027","-263850.00");
INSERT INTO v_party_bal VALUES("2610000028","-147540.00");
INSERT INTO v_party_bal VALUES("2610000029","-87160.00");
INSERT INTO v_party_bal VALUES("2610000030","-277774.00");
INSERT INTO v_party_bal VALUES("2610000031","-19000.00");
INSERT INTO v_party_bal VALUES("2610000032","-103180.00");
INSERT INTO v_party_bal VALUES("2610000034","-23400.00");
INSERT INTO v_party_bal VALUES("2610000035","-38600.00");
INSERT INTO v_party_bal VALUES("2610000038","-84740.00");
INSERT INTO v_party_bal VALUES("2610000040","-6800.00");
INSERT INTO v_party_bal VALUES("2610000041","-22000.00");
INSERT INTO v_party_bal VALUES("2610000042","950.00");
INSERT INTO v_party_bal VALUES("2610000043","3500.00");
INSERT INTO v_party_bal VALUES("2610000044","-2000.00");
INSERT INTO v_party_bal VALUES("2610000045","-37020.00");
INSERT INTO v_party_bal VALUES("2610000046","-25568.00");
INSERT INTO v_party_bal VALUES("2610000047","-380700.00");
INSERT INTO v_party_bal VALUES("2610000048","-8940.00");
INSERT INTO v_party_bal VALUES("2610000049","-349600.00");
INSERT INTO v_party_bal VALUES("2610000050","-26740.00");
INSERT INTO v_party_bal VALUES("2610000052","-62000.00");
INSERT INTO v_party_bal VALUES("2610000053","-1000.00");
INSERT INTO v_party_bal VALUES("2610000054","-59100.00");
INSERT INTO v_party_bal VALUES("2610000056","-80250.00");
INSERT INTO v_party_bal VALUES("2610000057","-10700.00");
INSERT INTO v_party_bal VALUES("2610000058","-450000.00");
INSERT INTO v_party_bal VALUES("2610000059","-66560.00");
INSERT INTO v_party_bal VALUES("2610000060","-177000.00");
INSERT INTO v_party_bal VALUES("2610000061","-47600.00");
INSERT INTO v_party_bal VALUES("2610000062","-19100.00");
INSERT INTO v_party_bal VALUES("2610000063","-395506.00");
INSERT INTO v_party_bal VALUES("2610000064","-181600.00");
INSERT INTO v_party_bal VALUES("2610000065","-31000.00");
INSERT INTO v_party_bal VALUES("2610000066","-143200.00");
INSERT INTO v_party_bal VALUES("2610000067","-45222.00");
INSERT INTO v_party_bal VALUES("2610000068","-42000.00");
INSERT INTO v_party_bal VALUES("2610000069","-9000.00");
INSERT INTO v_party_bal VALUES("2610000070","-15000.00");


DROP TABLE IF EXISTS v_voucherdet_pay;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_voucherdet_pay` AS select concat(`d`.`COMP_ID`,`d`.`VOUCHER_ID`,'/',`d`.`LINEITEM`) AS `voucher_id`,concat(`d`.`LINEITEM`,'.') AS `lineitem`,`d`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name` from (`voucherdet` `d` left join `nom` `n` on((`d`.`ACCT_ID` = `n`.`ACCT_ID`))) where (substr(`d`.`LINEITEM`,-(1)) <> '.');

INSERT INTO v_voucherdet_pay VALUES("01BP070001/1","1.","1310000023","RAVI TRADERS");
INSERT INTO v_voucherdet_pay VALUES("01BP070001/2","2.","2610000043","HOME TECH");
INSERT INTO v_voucherdet_pay VALUES("01BP070001/3","3.","1310000044","MARACHI");
INSERT INTO v_voucherdet_pay VALUES("01BP070001/4","4.","2720000003","CLEARING CHARGES");
INSERT INTO v_voucherdet_pay VALUES("01BR070001/1","1.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01BR070001/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01BR070001/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/1","1.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/10","10.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/11","11.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/12","12.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/13","13.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/14","14.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/15","15.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/16","16.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/17","17.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/18","18.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/19","19.","1310000017","GOROHE");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/2","2.","2610000042","CERAMICS");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/20","20.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/21","21.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/22","22.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/23","23.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/3","3.","1310000036","CANON");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/4","4.","1910000031","SALARY PAYABLE WAQAS");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/5","5.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/6","6.","0100020005","SHEIKH SALEEM");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/7","7.","0100020005","SHEIKH SALEEM");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/8","8.","1310000008","DIAMOND");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/9","9.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/1","1.","2610000043","HOME TECH");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/10","10.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/11","11.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/12","12.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/13","13.","1310000011","AL-HARMAIN PAINT CENTRE");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/14","14.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/15","15.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/16","16.","1310000018","KBS");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/17","17.","1310000018","KBS");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/18","18.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/19","19.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/2","2.","1310000037","AMJAD GUJRANWALA");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/20","20.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/21","21.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/22","22.","1910000031","SALARY PAYABLE WAQAS");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/23","23.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/24","24.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/25","25.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/26","26.","1910000002","SALARY PAYABLE Sarosh Ch");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/27","27.","1310000038","GODI COMMODE");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/28","28.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/3","3.","1910000014","SALARY PAYABLE Hameed");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/4","4.","1310000015","MAHMOOD GUJRANWALA");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/5","5.","0100020002","Waseem Sb");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/6","6.","1910000021","SALARY PAYABLE QUEEM");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/7","7.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/8","8.","1310000022","ALLAH WASAYA");
INSERT INTO v_voucherdet_pay VALUES("01CP070002/9","9.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/1","1.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/10","10.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/11","11.","1310000017","GOROHE");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/12","12.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/13","13.","0100020006","KHALID SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/14","14.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/15","15.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/16","16.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/17","17.","0100020002","Waseem Sb");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/18","18.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/19","19.","1310000017","GOROHE");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/2","2.","0100020004","FAROOQ SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/20","20.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/21","21.","0100020007","NADEEM SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/22","22.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/23","23.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/24","24.","1910000031","SALARY PAYABLE WAQAS");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/25","25.","1910000006","SALARY PAYABLE Yaseen");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/26","26.","1910000005","SALARY PAYABLE Hafiz Azeem");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/27","27.","1910000017","SALARY PAYABLE Ashraf Paint");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/28","28.","1910000002","SALARY PAYABLE Sarosh Ch");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/29","29.","1910000013","SALARY PAYABLE Faisal Zia");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/3","3.","0100020004","FAROOQ SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/30","30.","1310000002","Porta Acrylic Bath Tubs Lahore");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/31","31.","1310000040","ANSARI PLASTIC");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/32","32.","1310000041","ASIAN STANDERED");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/33","33.","1310000042","LEXTA");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/34","34.","1310000043","SHEN CHINEESE");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/35","35.","1910000034","SALARY PAYABLE WALEED");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/36","36.","1910000032","SALARY PAYABLE JAMEEL");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/37","37.","1910000033","SALARY PAYABLE TANVEER");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/38","38.","1910000035","SALARY PAYABLE AMJAD");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/4","4.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/5","5.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/6","6.","1310000003","TREND BATHROOM ACCESSORIES");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/7","7.","0100020004","FAROOQ SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/8","8.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070003/9","9.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/10","10.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/11","11.","1310000008","DIAMOND");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/12","12.","1310000017","GOROHE");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/13","13.","1310000017","GOROHE");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/14","14.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/15","15.","4010000008","Utility BILL");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/16","16.","0100020002","Waseem Sb");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/17","17.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/18","18.","1310000017","GOROHE");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/19","19.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/20","20.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/21","21.","1310000024","SAMAAR SKIRTING");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/22","22.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/23","23.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/24","24.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/25","25.","4010000008","Utility BILL");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/26","26.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/27","27.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/28","28.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/29","29.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/30","30.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/31","31.","1910000004","SALARY PAYABLE Salman SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/32","32.","0100020007","NADEEM SB");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/33","33.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/34","34.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/35","35.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/36","36.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/37","37.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/4","4.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/5","5.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/6","6.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/7","7.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01CP070004/9","9.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("01JV070001/1","1.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01JV070001/2","2.","0100010001","OPENING BALANCES");
INSERT INTO v_voucherdet_pay VALUES("01PL070001/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("01PL070001/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("01PL070001/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("01PL070001/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01PL070002/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("01PL070002/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("01PL070002/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("01PL070002/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01PL070003/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("01PL070003/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("01PL070003/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("01PL070003/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01PL070004/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("01PL070004/2","2.","1310000039","NATURE");
INSERT INTO v_voucherdet_pay VALUES("01PL070004/3","3.","1310000039","NATURE");
INSERT INTO v_voucherdet_pay VALUES("01PL070004/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01RT070001/1","1.","3010000001","Turnover");
INSERT INTO v_voucherdet_pay VALUES("01RT070001/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("01RT070002/1","1.","3010000001","Turnover");
INSERT INTO v_voucherdet_pay VALUES("01RT070002/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/10","10.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/11","11.","4010000010","LABOUR PAYABLE");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/12","12.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/13","13.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/3","3.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/4","4.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/5","5.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/7","7.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/8","8.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060001/9","9.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/2","2.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/3","3.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/5","5.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/6","6.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/7","7.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/8","8.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP060002/9","9.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/10","10.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/11","11.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/12","12.","1910000028","SALARY PAYABLE MURTAZA");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/13","13.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/14","14.","0100020008","SAJED SB");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/15","15.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/2","2.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/3","3.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/4","4.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/5","5.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/6","6.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/7","7.","1910000027","SALARY PAYABLE NASIR");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060003/9","9.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/1","1.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/10","10.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/11","11.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/2","2.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/4","4.","0100020007","NADEEM SB");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/5","5.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/8","8.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060004/9","9.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/3","3.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/4","4.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/5","5.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/7","7.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060005/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/10","10.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/11","11.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/12","12.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/13","13.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/14","14.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/15","15.","1910000027","SALARY PAYABLE NASIR");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/3","3.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/4","4.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/5","5.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060006/9","9.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/1","1.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/2","2.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/3","3.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/4","4.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/5","5.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/8","8.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060007/9","9.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/2","2.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/3","3.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/5","5.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060008/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/10","10.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/11","11.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/12","12.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/13","13.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/2","2.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/3","3.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/4","4.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/5","5.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/7","7.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/8","8.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060009/9","9.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060010/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060011/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060012/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060013/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/10","10.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/2","2.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/3","3.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/4","4.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/5","5.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/8","8.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060014/9","9.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/2","2.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/5","5.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/6","6.","4010000008","Utility BILL");
INSERT INTO v_voucherdet_pay VALUES("02CP060015/7","7.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060016/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/2","2.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/3","3.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/4","4.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/7","7.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/8","8.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP060017/9","9.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/1","1.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/2","2.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/3","3.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/4","4.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/5","5.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060018/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/2","2.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/3","3.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/4","4.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/5","5.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/6","6.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060019/8","8.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/10","10.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/2","2.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/3","3.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/4","4.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/5","5.","1910000030","SALARY PAYABLE BABAR");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/6","6.","1910000027","SALARY PAYABLE NASIR");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/7","7.","1910000028","SALARY PAYABLE MURTAZA");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/8","8.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP060020/9","9.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060021/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060021/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060021/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060021/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060021/5","5.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/2","2.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/3","3.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/5","5.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/6","6.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060022/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060023/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060023/2","2.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060023/3","3.","1910000027","SALARY PAYABLE NASIR");
INSERT INTO v_voucherdet_pay VALUES("02CP060023/4","4.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060023/5","5.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060023/6","6.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/10","10.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/11","11.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/2","2.","0100020002","Waseem Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/3","3.","0100020002","Waseem Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/4","4.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/5","5.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/6","6.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/7","7.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060024/9","9.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/2","2.","4010000007","Stationary Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/5","5.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/7","7.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/8","8.","0100020010","TAMOUR SB SHOW ROOM PERFACT HOME");
INSERT INTO v_voucherdet_pay VALUES("02CP060025/9","9.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/2","2.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/3","3.","1910000027","SALARY PAYABLE NASIR");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/4","4.","1910000028","SALARY PAYABLE MURTAZA");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/5","5.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/6","6.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060026/9","9.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/2","2.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/3","3.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/4","4.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/6","6.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP060027/7","7.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/2","2.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/3","3.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/4","4.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/5","5.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/6","6.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/7","7.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/8","8.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070001/9","9.","1910000030","SALARY PAYABLE BABAR");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/10","10.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/11","11.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/12","12.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/13","13.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/14","14.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/2","2.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/4","4.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/5","5.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/7","7.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/8","8.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070002/9","9.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/10","10.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/11","11.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/12","12.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/2","2.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/3","3.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/4","4.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/6","6.","0100020007","NADEEM SB");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/7","7.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070003/9","9.","1910000030","SALARY PAYABLE BABAR");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/10","10.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/11","11.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/12","12.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/4","4.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/6","6.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/7","7.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/8","8.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070004/9","9.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/3","3.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/4","4.","1910000030","SALARY PAYABLE BABAR");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/6","6.","1910000027","SALARY PAYABLE NASIR");
INSERT INTO v_voucherdet_pay VALUES("02CP070005/7","7.","1910000029","SALARY PAYABLE TAYYAB");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/1","1.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/10","10.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/11","11.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/12","12.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/13","13.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/14","14.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/15","15.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/16","16.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/17","17.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/18","18.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/19","19.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/2","2.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/3","3.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/4","4.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/5","5.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/6","6.","1910000028","SALARY PAYABLE MURTAZA");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/7","7.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/8","8.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP070006/9","9.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/12","12.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/13","13.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/14","14.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/2","2.","4010000007","Stationary Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/4","4.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/6","6.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/7","7.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/8","8.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CP070007/9","9.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/10","10.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/11","11.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/12","12.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/13","13.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/2","2.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/4","4.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/5","5.","0100020001","Happy Malik Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/7","7.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/8","8.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070008/9","9.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/10","10.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/2","2.","0100020002","Waseem Sb");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/3","3.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/4","4.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/6","6.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/7","7.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/8","8.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070009/9","9.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/10","10.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/2","2.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/3","3.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/4","4.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/5","5.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/6","6.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/7","7.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/8","8.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070010/9","9.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/2","2.","4010000007","Stationary Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/3","3.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/4","4.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/5","5.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/6","6.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/7","7.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/8","8.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP070011/9","9.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CP17/1","1.","4010000006","Fuel Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP17/2","2.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP17/3","3.","1910000003","SALARY PAYABLE Rashid");
INSERT INTO v_voucherdet_pay VALUES("02CP17/4","4.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP17/5","5.","4010000001","ENTERTAINMENT EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CP17/6","6.","4010000004","Travelling Expenses");
INSERT INTO v_voucherdet_pay VALUES("02CP17/7","7.","4010000009","CHARITY PAID");
INSERT INTO v_voucherdet_pay VALUES("02CP17/8","8.","1910000001","SALARY PAYABLE SHAHID SHEIKH");
INSERT INTO v_voucherdet_pay VALUES("02CR060001/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060002/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060002/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060003/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060004/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060005/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060005/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060006/1","1.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CR060006/2","2.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CR060007/1","1.","2610000030","200/1-B ST-NO #1 PHASE-5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02CR060008/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060008/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060008/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060008/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060008/6","6.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060009/1","1.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CR060010/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060011/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060011/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060011/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060011/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060012/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060012/2","2.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02CR060013/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR060013/2","2.","4010000003","OTHER EXPENSES");
INSERT INTO v_voucherdet_pay VALUES("02CR060014/1","1.","2620000001","Bath & Kitchen");
INSERT INTO v_voucherdet_pay VALUES("02CR060015/1","1.","2610000040","SHOAIB KHAN SB");
INSERT INTO v_voucherdet_pay VALUES("02CR060016/1","1.","2610000038","MALL OF SIALKOT");
INSERT INTO v_voucherdet_pay VALUES("02CR060016/2","2.","2610000038","MALL OF SIALKOT");
INSERT INTO v_voucherdet_pay VALUES("02CR060016/3","3.","2610000038","MALL OF SIALKOT");
INSERT INTO v_voucherdet_pay VALUES("02CR060017/1","1.","2610000058","AFTAB SB");
INSERT INTO v_voucherdet_pay VALUES("02CR060017/2","2.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02CR060018/1","1.","0100020009","HASEEB WALPAPER");
INSERT INTO v_voucherdet_pay VALUES("02CR060019/1","1.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02CR060019/2","2.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02CR070001/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR070002/1","1.","2610000041","NADEEM SB CUSTOMER");
INSERT INTO v_voucherdet_pay VALUES("02CR070003/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02CR070004/1","1.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02CR070004/2","2.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02CR070005/1","1.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02CR070005/2","2.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02CR070005/3","3.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02CR070006/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02CR070006/2","2.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02CR070006/3","3.","2610000054","228/B STAT LIFE");
INSERT INTO v_voucherdet_pay VALUES("02CR070006/4","4.","2610000054","228/B STAT LIFE");
INSERT INTO v_voucherdet_pay VALUES("02CR070006/5","5.","2610000054","228/B STAT LIFE");
INSERT INTO v_voucherdet_pay VALUES("02CR070007/1","1.","2610000070","102/CC PHS# 4 DHA SULTAN SB");
INSERT INTO v_voucherdet_pay VALUES("02CR070008/1","1.","2610000065","H-NO 25/E 35210478");
INSERT INTO v_voucherdet_pay VALUES("02CR070009/1","1.","2610000067","KHAZIR SB SOI GAS SUCITY");
INSERT INTO v_voucherdet_pay VALUES("02CR070009/2","2.","2610000064","PESHWAR MALL");
INSERT INTO v_voucherdet_pay VALUES("02JV060001/1","1.","0100010001","OPENING BALANCES");
INSERT INTO v_voucherdet_pay VALUES("02JV060001/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02JV060002/1","1.","2630000001","Cash Reconciliation");
INSERT INTO v_voucherdet_pay VALUES("02JV060002/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02JV060004/1","1.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02JV060004/2","2.","2630000001","Cash Reconciliation");
INSERT INTO v_voucherdet_pay VALUES("02JV060005/1","1.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02JV060005/2","2.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02JV060005/3","3.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02JV060005/4","4.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02JV060006/1","1.","0100010001","OPENING BALANCES");
INSERT INTO v_voucherdet_pay VALUES("02JV060006/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02JV060007/1","1.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02JV060007/2","2.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02JV060007/3","3.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02JV070001/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02JV070001/2","2.","0100010001","OPENING BALANCES");
INSERT INTO v_voucherdet_pay VALUES("02JV070002/1","1.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02JV070002/2","2.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02JV070003/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02JV070003/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02JV070004/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02JV070004/2","2.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02JV070004/3","3.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02PL060001/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060001/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060001/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060001/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060002/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060002/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060002/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060002/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060003/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060003/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060003/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060003/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060004/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060004/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060004/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060004/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060005/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060005/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060005/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060005/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060006/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060006/2","2.","1310000018","KBS");
INSERT INTO v_voucherdet_pay VALUES("02PL060006/3","3.","1310000018","KBS");
INSERT INTO v_voucherdet_pay VALUES("02PL060006/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060007/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060007/2","2.","1310000033","BASRA BROTHERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060007/3","3.","1310000033","BASRA BROTHERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060007/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060008/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060008/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060008/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060008/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060009/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060009/2","2.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060009/3","3.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060009/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060010/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060010/2","2.","1310000035","SILLA CONCEPT\'S");
INSERT INTO v_voucherdet_pay VALUES("02PL060010/3","3.","1310000035","SILLA CONCEPT\'S");
INSERT INTO v_voucherdet_pay VALUES("02PL060010/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060011/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060011/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060011/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060011/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060012/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060012/2","2.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060012/3","3.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060012/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060013/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060013/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060013/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060013/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060014/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060014/2","2.","1310000027","IMC");
INSERT INTO v_voucherdet_pay VALUES("02PL060014/3","3.","1310000027","IMC");
INSERT INTO v_voucherdet_pay VALUES("02PL060014/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060015/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060015/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060015/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060015/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060016/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060016/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060016/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060016/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060017/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060017/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060017/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060017/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060018/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060018/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060018/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060018/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060019/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060019/2","2.","1310000","");
INSERT INTO v_voucherdet_pay VALUES("02PL060019/3","3.","1310000","");
INSERT INTO v_voucherdet_pay VALUES("02PL060019/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060020/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060020/2","2.","1310000030","MUHAMMADI STORE");
INSERT INTO v_voucherdet_pay VALUES("02PL060020/3","3.","1310000030","MUHAMMADI STORE");
INSERT INTO v_voucherdet_pay VALUES("02PL060020/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060021/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060021/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060021/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060021/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060022/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060022/2","2.","1310000","");
INSERT INTO v_voucherdet_pay VALUES("02PL060022/3","3.","1310000","");
INSERT INTO v_voucherdet_pay VALUES("02PL060022/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060023/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060023/2","2.","1310000031","ILYAS/SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060023/3","3.","1310000031","ILYAS/SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060023/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060024/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060024/2","2.","1310000033","BASRA BROTHERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060024/3","3.","1310000033","BASRA BROTHERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060024/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060025/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060025/2","2.","1310000029","KBS");
INSERT INTO v_voucherdet_pay VALUES("02PL060025/3","3.","1310000029","KBS");
INSERT INTO v_voucherdet_pay VALUES("02PL060025/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060026/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060026/2","2.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060026/3","3.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060026/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060027/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060027/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060027/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060027/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060028/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060028/2","2.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060028/3","3.","1310000034","VIZDOM");
INSERT INTO v_voucherdet_pay VALUES("02PL060028/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060029/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060029/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060029/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060029/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060030/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060030/2","2.","2610000042","CERAMICS");
INSERT INTO v_voucherdet_pay VALUES("02PL060030/3","3.","2610000042","CERAMICS");
INSERT INTO v_voucherdet_pay VALUES("02PL060030/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060031/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060031/2","2.","2610000043","HOME TECH");
INSERT INTO v_voucherdet_pay VALUES("02PL060031/3","3.","2610000043","HOME TECH");
INSERT INTO v_voucherdet_pay VALUES("02PL060031/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060032/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060032/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060032/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060032/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060033/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060033/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060033/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060033/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060034/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060034/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060034/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060034/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060035/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060035/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060035/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060035/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060036/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060036/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060036/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL060036/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060037/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060037/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060037/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL060037/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL060038/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL060038/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060038/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL060038/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070001/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070001/2","2.","1310000018","KBS");
INSERT INTO v_voucherdet_pay VALUES("02PL070001/3","3.","1310000018","KBS");
INSERT INTO v_voucherdet_pay VALUES("02PL070001/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070002/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070002/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL070002/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL070002/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070004/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070004/2","2.","1310000033","BASRA BROTHERS");
INSERT INTO v_voucherdet_pay VALUES("02PL070004/3","3.","1310000033","BASRA BROTHERS");
INSERT INTO v_voucherdet_pay VALUES("02PL070004/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070005/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070005/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL070005/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL070005/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070006/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070006/2","2.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL070006/3","3.","1310000006","MAGOON TRADERS");
INSERT INTO v_voucherdet_pay VALUES("02PL070006/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070007/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070007/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL070007/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL070007/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070008/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070008/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL070008/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL070008/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070009/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070009/2","2.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL070009/3","3.","1310000028","MAHMOOD SONS");
INSERT INTO v_voucherdet_pay VALUES("02PL070009/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070010/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070010/2","2.","1310000045","INTERIO FLOORS");
INSERT INTO v_voucherdet_pay VALUES("02PL070010/3","3.","1310000045","INTERIO FLOORS");
INSERT INTO v_voucherdet_pay VALUES("02PL070010/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070011/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070011/2","2.","1310000047","BUTT TRADER");
INSERT INTO v_voucherdet_pay VALUES("02PL070011/3","3.","1310000047","BUTT TRADER");
INSERT INTO v_voucherdet_pay VALUES("02PL070011/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070012/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070012/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL070012/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL070012/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02PL070013/1","1.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02PL070013/2","2.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL070013/3","3.","1310000014","JAVAID");
INSERT INTO v_voucherdet_pay VALUES("02PL070013/4","4.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060001/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060001/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060001/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060001/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060002/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060002/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060002/3","3.","3010000010","Discount Allowed");
INSERT INTO v_voucherdet_pay VALUES("02RT060002/4","4.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060002/5","5.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060003/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060003/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060003/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060003/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060004/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060004/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060004/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060004/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060004/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060004/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060005/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060005/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060005/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060005/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060005/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060005/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060007/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060007/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060007/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060007/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060007/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060007/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060008/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060008/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060008/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060008/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060008/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060008/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060009/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060009/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060009/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060009/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060009/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060009/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060010/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060010/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060010/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060010/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060010/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060010/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060011/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060011/2","2.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02RT060011/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060011/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060011/5","5.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02RT060011/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/2","2.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/3","3.","3010000010","Discount Allowed");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/4","4.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/5","5.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/6","6.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02RT060012/7","7.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/3","3.","3010000010","Discount Allowed");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/4","4.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/5","5.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/6","6.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060013/7","7.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060014/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060014/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060014/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060014/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060015/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060015/2","2.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02RT060015/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060015/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060016/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060016/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060016/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060016/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060016/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT060016/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060017/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060017/2","2.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02RT060017/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060017/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060017/5","5.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02RT060017/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060018/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060018/2","2.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02RT060018/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060018/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT060018/5","5.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02RT060018/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT060019/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT060019/2","2.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02RT060019/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT060019/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070001/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT070001/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070001/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT070001/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070001/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070001/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT070002/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT070002/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070002/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT070002/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070003/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT070003/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070003/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT070003/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070003/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070003/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/3","3.","3010000010","Discount Allowed");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/4","4.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/5","5.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/6","6.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070004/7","7.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT070005/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT070005/2","2.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02RT070005/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT070005/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070005/5","5.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02RT070005/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02RT070006/1","1.","3010000020","Sale Returns");
INSERT INTO v_voucherdet_pay VALUES("02RT070006/2","2.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070006/3","3.","3020000001","Purchase Cost");
INSERT INTO v_voucherdet_pay VALUES("02RT070006/4","4.","2210000001","Stock In Trade");
INSERT INTO v_voucherdet_pay VALUES("02RT070006/5","5.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02RT070006/6","6.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060001/1","1.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02SL060001/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060001/4","4.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02SL060002/1","1.","2610000027","SAYYAD BROTHER");
INSERT INTO v_voucherdet_pay VALUES("02SL060003/1","1.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02SL060003/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060003/4","4.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02SL060004/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060004/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060004/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060005/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060005/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060005/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060006/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060006/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060006/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060007/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060007/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060007/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060008/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060008/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060008/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060009/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060009/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060009/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060010/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060010/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060010/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060011/1","1.","2610000027","SAYYAD BROTHER");
INSERT INTO v_voucherdet_pay VALUES("02SL060012/1","1.","2610000027","SAYYAD BROTHER");
INSERT INTO v_voucherdet_pay VALUES("02SL060012/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060012/3","3.","2610000027","SAYYAD BROTHER");
INSERT INTO v_voucherdet_pay VALUES("02SL060015/1","1.","2610000028","KASHIF SB 245/G PHS# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060016/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060016/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060016/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060018/1","1.","2610000029","MURTZA CUSTMER");
INSERT INTO v_voucherdet_pay VALUES("02SL060018/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060018/4","4.","2610000029","MURTZA CUSTMER");
INSERT INTO v_voucherdet_pay VALUES("02SL060019/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060019/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060019/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060020/1","1.","2610000029","MURTZA CUSTMER");
INSERT INTO v_voucherdet_pay VALUES("02SL060020/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060020/4","4.","2610000029","MURTZA CUSTMER");
INSERT INTO v_voucherdet_pay VALUES("02SL060021/1","1.","2610000030","200/1-B ST-NO #1 PHASE-5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060021/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060021/4","4.","2610000030","200/1-B ST-NO #1 PHASE-5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060024/1","1.","2610000031","36-D LAWRENCE ROAD LHR 03034291889");
INSERT INTO v_voucherdet_pay VALUES("02SL060025/1","1.","2610000034","H-NO. 923/D PHS 6 DHA LHR");
INSERT INTO v_voucherdet_pay VALUES("02SL060025/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060025/3","3.","2610000034","H-NO. 923/D PHS 6 DHA LHR");
INSERT INTO v_voucherdet_pay VALUES("02SL060026/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060026/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060026/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060027/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060027/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060027/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060028/1","1.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02SL060028/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060028/4","4.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02SL060030/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060030/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060030/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060031/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060031/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060031/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060032/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060032/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060032/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060033/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060033/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060033/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060034/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060035/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060035/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060035/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060036/1","1.","2610000038","MALL OF SIALKOT");
INSERT INTO v_voucherdet_pay VALUES("02SL060037/1","1.","2610000038","MALL OF SIALKOT");
INSERT INTO v_voucherdet_pay VALUES("02SL060038/1","1.","2610000038","MALL OF SIALKOT");
INSERT INTO v_voucherdet_pay VALUES("02SL060040/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060040/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060040/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060041/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060041/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060041/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060042/1","1.","2610000040","SHOAIB KHAN SB");
INSERT INTO v_voucherdet_pay VALUES("02SL060043/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060043/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060043/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060044/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060044/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060044/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060045/1","1.","2610000041","NADEEM SB CUSTOMER");
INSERT INTO v_voucherdet_pay VALUES("02SL060046/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060046/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060046/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060047/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060047/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060047/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060048/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060048/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060048/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060049/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060050/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060051/1","1.","2610000044","KHALID SB ASKRI 10");
INSERT INTO v_voucherdet_pay VALUES("02SL060052/1","1.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02SL060052/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060052/4","4.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02SL060054/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060054/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060054/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060055/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060055/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060055/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060056/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060056/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060056/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060057/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060057/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060057/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060058/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060058/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060058/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060059/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060059/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060059/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060060/1","1.","2610000046","QAYUM SB DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060060/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060060/4","4.","2610000046","QAYUM SB DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060061/1","1.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060061/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060061/4","4.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060062/1","1.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060062/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060062/4","4.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060063/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060063/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060063/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060064/1","1.","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER");
INSERT INTO v_voucherdet_pay VALUES("02SL060064/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060064/4","4.","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER");
INSERT INTO v_voucherdet_pay VALUES("02SL060066/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060066/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060066/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060067/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060067/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060067/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060068/1","1.","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER");
INSERT INTO v_voucherdet_pay VALUES("02SL060068/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060068/4","4.","2610000048","NASEEM AHMAD SOFTWARE DEVELOPER");
INSERT INTO v_voucherdet_pay VALUES("02SL060069/1","1.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02SL060070/1","1.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02SL060072/1","1.","2610000028","KASHIF SB 245/G PHS# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060072/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060072/3","3.","2610000028","KASHIF SB 245/G PHS# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060073/1","1.","2610000050","B PLAZA NADEEM KHAN");
INSERT INTO v_voucherdet_pay VALUES("02SL060074/1","1.","2610000040","SHOAIB KHAN SB");
INSERT INTO v_voucherdet_pay VALUES("02SL060075/1","1.","2610000028","KASHIF SB 245/G PHS# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060076/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060076/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060076/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060078/1","1.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02SL060078/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060078/4","4.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02SL060079/1","1.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02SL060079/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060079/3","3.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02SL060080/1","1.","2610000053","69/G MODAL TWON");
INSERT INTO v_voucherdet_pay VALUES("02SL060081/1","1.","2610000054","228/B STAT LIFE");
INSERT INTO v_voucherdet_pay VALUES("02SL060082/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060083/1","1.","2610000050","B PLAZA NADEEM KHAN");
INSERT INTO v_voucherdet_pay VALUES("02SL060084/1","1.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02SL060085/1","1.","2610000050","B PLAZA NADEEM KHAN");
INSERT INTO v_voucherdet_pay VALUES("02SL060086/1","1.","2610000054","228/B STAT LIFE");
INSERT INTO v_voucherdet_pay VALUES("02SL060087/1","1.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02SL060088/1","1.","2610000054","228/B STAT LIFE");
INSERT INTO v_voucherdet_pay VALUES("02SL060089/1","1.","2610000030","200/1-B ST-NO #1 PHASE-5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060089/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060089/3","3.","2610000030","200/1-B ST-NO #1 PHASE-5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060090/1","1.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02SL060091/1","1.","2610000027","SAYYAD BROTHER");
INSERT INTO v_voucherdet_pay VALUES("02SL060092/1","1.","2610000057","ABDULLAH SB PH# 6 839/D DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL060093/1","1.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02SL060094/1","1.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02SL060095/1","1.","2610000035","MR. ANEES SB 0321-4185133");
INSERT INTO v_voucherdet_pay VALUES("02SL060096/1","1.","2610000045","347/Y PHS# 3");
INSERT INTO v_voucherdet_pay VALUES("02SL060097/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060097/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060097/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060098/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060098/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060098/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060099/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060099/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060099/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060100/1","1.","2610000058","AFTAB SB");
INSERT INTO v_voucherdet_pay VALUES("02SL060100/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060100/3","3.","2610000058","AFTAB SB");
INSERT INTO v_voucherdet_pay VALUES("02SL060101/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060101/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060101/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060102/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060102/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060102/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060103/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL060103/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL060103/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070001/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070001/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070001/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070002/1","1.","2610000059","H-NO 254-DD PHS# 4 03218487965");
INSERT INTO v_voucherdet_pay VALUES("02SL070002/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070002/4","4.","2610000059","H-NO 254-DD PHS# 4 03218487965");
INSERT INTO v_voucherdet_pay VALUES("02SL070003/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070003/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070003/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070004/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070004/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070004/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070005/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070005/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070005/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070006/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070006/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070006/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070007/1","1.","2610000060","246/E-1 WAPDA TWON PHAS# 1");
INSERT INTO v_voucherdet_pay VALUES("02SL070007/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070007/3","3.","2610000060","246/E-1 WAPDA TWON PHAS# 1");
INSERT INTO v_voucherdet_pay VALUES("02SL070008/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070008/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070008/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070009/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070009/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070009/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070010/1","1.","2610000061","UMER KHALID SB 54/C PHAS# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070010/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070010/4","4.","2610000061","UMER KHALID SB 54/C PHAS# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070011/1","1.","2610000062","H-NO 862/B PH# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070011/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070011/4","4.","2610000062","H-NO 862/B PH# 5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070012/1","1.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070012/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070012/3","3.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070013/1","1.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070013/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070013/4","4.","2610000047","ARIF NAZIR SB 141-J PHAS 6 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070014/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070015/1","1.","2610000059","H-NO 254-DD PHS# 4 03218487965");
INSERT INTO v_voucherdet_pay VALUES("02SL070015/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070015/4","4.","2610000059","H-NO 254-DD PHS# 4 03218487965");
INSERT INTO v_voucherdet_pay VALUES("02SL070016/1","1.","2610000063","H-NO 1070/N PH# 6 BUTT SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070016/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070016/4","4.","2610000063","H-NO 1070/N PH# 6 BUTT SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070017/1","1.","2610000063","H-NO 1070/N PH# 6 BUTT SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070017/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070017/4","4.","2610000063","H-NO 1070/N PH# 6 BUTT SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070018/1","1.","2610000063","H-NO 1070/N PH# 6 BUTT SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070018/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070018/4","4.","2610000063","H-NO 1070/N PH# 6 BUTT SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070020/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070020/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070020/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070021/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070021/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070021/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070022/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070022/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070022/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070023/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070023/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070023/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070024/1","1.","2610000064","PESHWAR MALL");
INSERT INTO v_voucherdet_pay VALUES("02SL070025/1","1.","2610000065","H-NO 25/E 35210478");
INSERT INTO v_voucherdet_pay VALUES("02SL070025/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070025/3","3.","2610000065","H-NO 25/E 35210478");
INSERT INTO v_voucherdet_pay VALUES("02SL070026/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070026/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070026/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070027/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070028/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070029/1","1.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02SL070029/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070029/4","4.","2610000049","HAJI HAKM SB 73 / C PH# 6");
INSERT INTO v_voucherdet_pay VALUES("02SL070030/1","1.","2610000067","KHAZIR SB SOI GAS SUCITY");
INSERT INTO v_voucherdet_pay VALUES("02SL070031/1","1.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02SL070031/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070031/3","3.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02SL070032/1","1.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02SL070032/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070032/3","3.","2610000052","DR. ASIM SB 03214864288");
INSERT INTO v_voucherdet_pay VALUES("02SL070033/1","1.","2610000034","H-NO. 923/D PHS 6 DHA LHR");
INSERT INTO v_voucherdet_pay VALUES("02SL070033/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070033/4","4.","2610000034","H-NO. 923/D PHS 6 DHA LHR");
INSERT INTO v_voucherdet_pay VALUES("02SL070034/1","1.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02SL070035/1","1.","2610000068","FAZAN SB 03339678883");
INSERT INTO v_voucherdet_pay VALUES("02SL070035/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070035/3","3.","2610000068","FAZAN SB 03339678883");
INSERT INTO v_voucherdet_pay VALUES("02SL070036/1","1.","2610000069","69/9-J-3 JOHAR TWON LHR");
INSERT INTO v_voucherdet_pay VALUES("02SL070036/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070036/3","3.","2610000069","69/9-J-3 JOHAR TWON LHR");
INSERT INTO v_voucherdet_pay VALUES("02SL070037/1","1.","2610000044","KHALID SB ASKRI 10");
INSERT INTO v_voucherdet_pay VALUES("02SL070038/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070038/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070038/4","4.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070039/1","1.","2610000070","102/CC PHS# 4 DHA SULTAN SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070040/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070041/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070041/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070041/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070042/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070043/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070043/2","2.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070043/3","3.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070044/1","1.","2610000056","242/L PH# 5 DHA  MR.UMAR");
INSERT INTO v_voucherdet_pay VALUES("02SL070045/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070046/1","1.","2610000066","398/B PH# 5 DHA KASHIF SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070047/1","1.","2610000032","AHMAD SB");
INSERT INTO v_voucherdet_pay VALUES("02SL070048/1","1.","2610000030","200/1-B ST-NO #1 PHASE-5 DHA");
INSERT INTO v_voucherdet_pay VALUES("02SL070049/1","1.","2610000001","Walk-In-Customers");
INSERT INTO v_voucherdet_pay VALUES("02SL070049/3","3.","2710000001","Cash In Hand");
INSERT INTO v_voucherdet_pay VALUES("02SL070049/4","4.","2610000001","Walk-In-Customers");


DROP TABLE IF EXISTS v_vouchers;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_vouchers` AS select `v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`CREDIT` < 0),-(`vd`.`CREDIT`),if((`vd`.`DEBIT` > 0),`vd`.`DEBIT`,0)) AS `debit`,if((`vd`.`DEBIT` < 0),-(`vd`.`DEBIT`),if((`vd`.`CREDIT` > 0),`vd`.`CREDIT`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,concat(if((`vd`.`V_NO` <> ''),concat('Bill#',`vd`.`V_NO`,' / '),''),`vd`.`PARTICULARS`) AS `particulars`,`v`.`POSTED` AS `posted` from ((((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`) and (`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) left join `nom` `n2` on((`vd`.`ACCT_ID_CS` = `n2`.`ACCT_ID`))) left join `v_voucherdet_pay` `d` on(((`vd`.`VOUCHER_ID` = `d`.`voucher_id`) and (`vd`.`LINEITEM` = `d`.`lineitem`)))) where (`v`.`POSTED` = 'on');

INSERT INTO v_vouchers VALUES("01","01BP070001/1","","","2017-06-05 00:00:00","1","1310000023","","","100000.000000000000000000000000000000","0","RAVI TRADERS","CASH + CHEQUE PAID TO RAVI TRADERS CASH PURCHASE","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/1.","","","2017-06-05 00:00:00","1.","2720000001","","","0","100000.000000000000000000000000000000","HABIB BANK","RAVI TRADERS/CASH + CHEQUE PAID TO RAVI TRADERS CASH PURCHASE","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/2","","","2017-06-05 00:00:00","2","2610000043","","","100000.000000000000000000000000000000","0","HOME TECH","CHEQUE PAID TO BATH TECH","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/2.","","","2017-06-05 00:00:00","2.","2720000001","","","0","100000.000000000000000000000000000000","HABIB BANK","/CHEQUE PAID TO BATH TECH","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/3","","","2017-06-05 00:00:00","3","1310000044","","","100000.000000000000000000000000000000","0","MARACHI","2 CHEQUES PAID TO MARACHI","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/3.","","","2017-06-05 00:00:00","3.","2720000001","","","0","100000.000000000000000000000000000000","HABIB BANK","MARACHI/2 CHEQUES PAID TO MARACHI","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/4","","","2017-06-05 00:00:00","4","2720000003","","","1000.000000000000000000000000000000","0","CLEARING CHARGES","PAID CHEQUE CLEARING CHARGES","on");
INSERT INTO v_vouchers VALUES("01","01BP070001/4.","","","2017-06-05 00:00:00","4.","2720000001","","","0","1000.000000000000000000000000000000","HABIB BANK","CLEARING CHARGES/PAID CHEQUE CLEARING CHARGES","on");
INSERT INTO v_vouchers VALUES("01","01BR070001/1","","","2017-06-05 00:00:00","1","2710000001","","","0","78000.000000000000000000000000000000","Cash In Hand","CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers VALUES("01","01BR070001/1.","","","2017-06-05 00:00:00","1.","2720000001","","","78000.000000000000000000000000000000","0","HABIB BANK","Cash In Hand/CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers VALUES("01","01BR070001/2","","","2017-06-05 00:00:00","2","2710000001","","","0","53000.000000000000000000000000000000","Cash In Hand","CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers VALUES("01","01BR070001/2.","","","2017-06-05 00:00:00","2.","2720000001","","","53000.000000000000000000000000000000","0","HABIB BANK","Cash In Hand/CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers VALUES("01","01BR070001/3","","","2017-06-05 00:00:00","3","2610000001","","","0","1200.000000000000000000000000000000","Walk-In-Customers","DIRECT DEPOSITED IN HBL CC SALE","on");
INSERT INTO v_vouchers VALUES("01","01BR070001/3.","","","2017-06-05 00:00:00","3.","2720000001","","","1200.000000000000000000000000000000","0","HABIB BANK","Walk-In-Customers/DIRECT DEPOSITED IN HBL CC SALE","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/1","","","2017-06-01 00:00:00","1","4010000009","","","200.000000000000000000000000000000","0","CHARITY PAID","CHARITY PAID","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/1.","","","2017-06-01 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","CHARITY PAID/CHARITY PAID","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/10","","","2017-06-01 00:00:00","10","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","PAID FOR REPAIR ELECTRIC BOARD STAFF ROOM","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/10.","","","2017-06-01 00:00:00","10.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PAID FOR REPAIR ELECTRIC BOARD STAFF ROOM","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/11","","","2017-06-01 00:00:00","11","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT TO ASHFAQ ACCESSORY","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/11.","","","2017-06-01 00:00:00","11.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT TO ASHFAQ ACCESSORY","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/12","","","2017-06-01 00:00:00","12","4010000004","","","2300.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO IJAZ","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/12.","","","2017-06-01 00:00:00","12.","2710000001","","","0","2300.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO IJAZ","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/13","","","2017-06-01 00:00:00","13","4010000006","","","300.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO IJAZ","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/13.","","","2017-06-01 00:00:00","13.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO IJAZ","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/14","","","2017-06-01 00:00:00","14","4010000001","","","1000.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PAID TO SALMAN SB FOR AFTARI","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/14.","","","2017-06-01 00:00:00","14.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","ENTERTAINMENT EXPENSES/PAID TO SALMAN SB FOR AFTARI","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/15","","","2017-06-01 00:00:00","15","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","CASH PAID TO AMEEN FOR MIRRORS","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/15.","","","2017-06-01 00:00:00","15.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/CASH PAID TO AMEEN FOR MIRRORS","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/16","","","2017-06-01 00:00:00","16","4010000003","","","900.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASED SILICON","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/16.","","","2017-06-01 00:00:00","16.","2710000001","","","0","900.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PURCHASED SILICON","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/17","","","2017-06-01 00:00:00","17","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO WALEED","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/17.","","","2017-06-01 00:00:00","1