/*
Navicat MySQL Data Transfer

Source Server         : mysql
Source Server Version : 50625
Source Host           : localhost:3306
Source Database       : cnlxidtp_click_ke

Target Server Type    : MYSQL
Target Server Version : 50625
File Encoding         : 65001

Date: 2017-09-23 15:11:05
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `acct_type`
-- ----------------------------
DROP TABLE IF EXISTS `acct_type`;
CREATE TABLE `acct_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `debit_name` varchar(20) DEFAULT NULL,
  `credit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of acct_type
-- ----------------------------

-- ----------------------------
-- Table structure for `am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `am_condet`;
CREATE TABLE `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `announcement`
-- ----------------------------
DROP TABLE IF EXISTS `announcement`;
CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of announcement
-- ----------------------------

-- ----------------------------
-- Table structure for `app_mod`
-- ----------------------------
DROP TABLE IF EXISTS `app_mod`;
CREATE TABLE `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_mod
-- ----------------------------
INSERT INTO `app_mod` VALUES ('AC_CP', 'Cash Payment', 'Accounts', '26', '35', '', 'CP');
INSERT INTO `app_mod` VALUES ('AC_BP', 'Bank Payment', 'Accounts', '26', '35', '', 'BP');
INSERT INTO `app_mod` VALUES ('AC_CR', 'Cash Receipt', 'Accounts', '26', '35', '', 'CR');
INSERT INTO `app_mod` VALUES ('AC_BR', 'Bank Receipt', 'Accounts', '26', '35', '', 'BR');
INSERT INTO `app_mod` VALUES ('AC_JV', 'Journal Voucher', 'Accounts', '35', '35', '', 'JV');
INSERT INTO `app_mod` VALUES ('AC_CD', 'Outstanding Clearing Dates', 'Accounts', '223', '0', '', '');
INSERT INTO `app_mod` VALUES ('PL_PO', 'Order', 'Purchases', '226', '53', 't_pl_order', '');
INSERT INTO `app_mod` VALUES ('PL_GP', 'Inward Gate Pass', 'Purchases', '226', '235', 't_pl_gp', '');
INSERT INTO `app_mod` VALUES ('PL_INV', 'Invoice', 'Purchases', '226', '235', 't_pl_invoice', '');
INSERT INTO `app_mod` VALUES ('PL_PAY', 'Payments', 'Purchases', '203', '204', 't_pl_pay', '');
INSERT INTO `app_mod` VALUES ('PL_JV', 'JV', 'Purchases', '216', '212', 'pl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_GP', 'Inward Gate Pass', 'Sales', '226', '235', 't_sl_gp', '');
INSERT INTO `app_mod` VALUES ('SL_INV', 'Invoice', 'Sales', '226', '235', 't_sl_invoice', '');
INSERT INTO `app_mod` VALUES ('SL_RTN', 'Return', 'Sales', '226', '235', 't_sl_return', '');
INSERT INTO `app_mod` VALUES ('SL_PAY', 'Payments', 'Sales', '203', '204', 't_sl_pay', '');
INSERT INTO `app_mod` VALUES ('SL_JV', 'JV', 'Sales', '216', '212', 'sl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_OB', 'Outstanding Bilties', 'Sales', '221', '260', '', '');
INSERT INTO `app_mod` VALUES ('STK_PROD', 'Production', 'Stock', '226', '53', 't_stk_con', 'Y');
INSERT INTO `app_mod` VALUES ('STK_CON', 'Consumption', 'Stock', '226', '235', 't_stk_con', 'N');
INSERT INTO `app_mod` VALUES ('MF_NOM', 'Chart of Accounts', 'Master Files', '164', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_PARTY', 'Parties', 'Master Files', '66', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_ITEM', 'Items', 'Master Files', '64', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_UNIT', 'Units', 'Master Files', '106', '0', '', '');
INSERT INTO `app_mod` VALUES ('IM_BOE', 'Bill of Entry', 'Imports', '226', '235', 't_im_boe', '');

-- ----------------------------
-- Table structure for `app_rep`
-- ----------------------------
DROP TABLE IF EXISTS `app_rep`;
CREATE TABLE `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_rep
-- ----------------------------
INSERT INTO `app_rep` VALUES ('AC_10', 'Daybook', 'Accounts', '144', '');
INSERT INTO `app_rep` VALUES ('AC_20', 'Ledger', 'Accounts', '91', '');
INSERT INTO `app_rep` VALUES ('AC_31', 'Trial - Balance', 'Accounts', '163', '');
INSERT INTO `app_rep` VALUES ('AC_32', 'Trial - Control', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_33', 'Trial - Subsidary', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_40', 'Profit & Loss', 'Accounts', '190', '');
INSERT INTO `app_rep` VALUES ('AC_50', 'Profit & Loss (Level 2)', 'Accounts', '191', '');
INSERT INTO `app_rep` VALUES ('PL_10', 'Purchase Daybook', 'Purchases', '187', 'PL');
INSERT INTO `app_rep` VALUES ('PL_20', 'Payment Daybook', 'Purchases', '187', 'PP');
INSERT INTO `app_rep` VALUES ('PL_30', 'Detail Ledger', 'Purchases', '405', 'S');
INSERT INTO `app_rep` VALUES ('PL_40', 'Trial', 'Purchases', '194', 'S');
INSERT INTO `app_rep` VALUES ('PL_50', 'Summary', 'Purchases', '188', 'S');
INSERT INTO `app_rep` VALUES ('SL_10', 'Sale Daybook', 'Sales', '187', 'SL');
INSERT INTO `app_rep` VALUES ('SL_20', 'Sale Receipts', 'Sales', '187', 'SR');
INSERT INTO `app_rep` VALUES ('SL_30', 'Detail Ledger', 'Sales', '405', 'C');
INSERT INTO `app_rep` VALUES ('SL_40', 'Trial', 'Sales', '194', 'C');
INSERT INTO `app_rep` VALUES ('SL_50', 'Summary', 'Sales', '188', 'C');
INSERT INTO `app_rep` VALUES ('SL_60', 'Empty Stock Report', 'Sales', '406', '');
INSERT INTO `app_rep` VALUES ('SL_70', 'Empty Stock Report Rate Wise', 'Sales', '407', '');
INSERT INTO `app_rep` VALUES ('SL_80', 'Outstanding Bills', 'Sales', '189', '');
INSERT INTO `app_rep` VALUES ('SL_90', 'SPO Outstanding', 'Sales', '195', '');
INSERT INTO `app_rep` VALUES ('STK_10', 'Ledger', 'Stocks', '401', '');
INSERT INTO `app_rep` VALUES ('STK_20', 'Summary', 'Stocks', '402', '');
INSERT INTO `app_rep` VALUES ('STK_30', 'Summary - Value', 'Stocks', '403', '');

-- ----------------------------
-- Table structure for `bak_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `bak_voucher`;
CREATE TABLE `bak_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `voucher_date` date DEFAULT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `POSTED` char(2) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `UPD_DATE` datetime DEFAULT NULL,
  `UPD_EMP_ID` varchar(8) DEFAULT NULL,
  `ACCT_ID_CS_1` char(10) DEFAULT NULL,
  `ACCT_ID_CS_2` char(10) DEFAULT NULL,
  `BILTY_NO` varchar(10) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of bak_voucher
-- ----------------------------
INSERT INTO `bak_voucher` VALUES ('CP070001', '2017-07-23', '0000-00-00 00:00:00', '2610000422', '', 'click', 'on', '', '', 'BT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('CR070001', '2017-07-23', '0000-00-00 00:00:00', '2610000422', '', 'click', 'on', '', '', 'BT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070005', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'BT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070006', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'BT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070007', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'BT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('CP070001', '2017-07-21', '0000-00-00 00:00:00', '2610000420', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('CP070002', '2017-07-22', '0000-00-00 00:00:00', '2610000420', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('CR070001', '2017-07-21', '0000-00-00 00:00:00', '2610000420', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('CR070002', '2017-07-21', '0000-00-00 00:00:00', '2610000420', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('CR070003', '2017-07-22', '0000-00-00 00:00:00', '2610000420', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('JV070001', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('JV070002', '2017-07-23', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070001', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070002', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070003', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070004', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070005', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070006', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070007', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070008', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070009', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070010', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070011', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070012', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070013', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070014', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070015', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070016', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070017', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070018', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070019', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070020', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070021', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070022', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070023', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070024', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070025', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070026', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070027', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070028', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070029', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070030', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070031', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070032', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070033', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070034', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070037', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070038', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070039', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070040', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('SL070041', '2017-07-22', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070002', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070003', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070004', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070008', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'IT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070001', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070002', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070003', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070004', '2017-07-21', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070005', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070006', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070007', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('ST070008', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');
INSERT INTO `bak_voucher` VALUES ('STError : SQL', '2017-07-20', '0000-00-00 00:00:00', '', '', 'click', 'on', '', '', 'KT', '16', '', '0000-00-00 00:00:00', '', '', '', '');

-- ----------------------------
-- Table structure for `bak_voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `bak_voucherdet`;
CREATE TABLE `bak_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(65,30) DEFAULT NULL,
  `CREDIT` decimal(65,30) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ER` decimal(65,30) DEFAULT NULL,
  `UNIT_RATE` decimal(65,30) DEFAULT NULL,
  `TT_NO` varchar(30) DEFAULT NULL,
  `REG_NO` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of bak_voucherdet
-- ----------------------------

-- ----------------------------
-- Table structure for `bill_type`
-- ----------------------------
DROP TABLE IF EXISTS `bill_type`;
CREATE TABLE `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of bill_type
-- ----------------------------
INSERT INTO `bill_type` VALUES ('0001', 'Normal', null);
INSERT INTO `bill_type` VALUES ('0002', 'Exchange', null);
INSERT INTO `bill_type` VALUES ('0003', 'VIP', null);
INSERT INTO `bill_type` VALUES ('0004', 'Sale Return', null);

-- ----------------------------
-- Table structure for `brands`
-- ----------------------------
DROP TABLE IF EXISTS `brands`;
CREATE TABLE `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of brands
-- ----------------------------
INSERT INTO `brands` VALUES ('0001', 'APC');
INSERT INTO `brands` VALUES ('0002', 'MGE UPS Systems');
INSERT INTO `brands` VALUES ('0003', 'Stulz Air Conditioning');
INSERT INTO `brands` VALUES ('0004', 'Bergvik Flooring');
INSERT INTO `brands` VALUES ('0005', 'APC / MGE UPS Systems');
INSERT INTO `brands` VALUES ('0006', 'APC / MGE');

-- ----------------------------
-- Table structure for `city`
-- ----------------------------
DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
  `CITY_ID` varchar(2) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`CITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of city
-- ----------------------------
INSERT INTO `city` VALUES ('10', 'LAHORE', '3801101001');

-- ----------------------------
-- Table structure for `closing_dates`
-- ----------------------------
DROP TABLE IF EXISTS `closing_dates`;
CREATE TABLE `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL,
  PRIMARY KEY (`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of closing_dates
-- ----------------------------
INSERT INTO `closing_dates` VALUES ('BP', '2003-12-31 00:00:00');

-- ----------------------------
-- Table structure for `code_cat`
-- ----------------------------
DROP TABLE IF EXISTS `code_cat`;
CREATE TABLE `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_cat
-- ----------------------------
INSERT INTO `code_cat` VALUES ('00', 'KURTA');
INSERT INTO `code_cat` VALUES ('01', 'SHALWAR');
INSERT INTO `code_cat` VALUES ('02', 'TROUSER');
INSERT INTO `code_cat` VALUES ('03', 'KHUSSA\r\n');
INSERT INTO `code_cat` VALUES ('04', 'WAIST COAT\r\n');
INSERT INTO `code_cat` VALUES ('05', 'NIGHT SUIT');
INSERT INTO `code_cat` VALUES ('06', 'FULL SUIT');
INSERT INTO `code_cat` VALUES ('07', 'COAT');
INSERT INTO `code_cat` VALUES ('08', 'FOOTWEAR\r\n');
INSERT INTO `code_cat` VALUES ('09', 'SHIRT\r\n');
INSERT INTO `code_cat` VALUES ('10', 'SHERWANI\r\n');
INSERT INTO `code_cat` VALUES ('11', 'TURBON\r\n');
INSERT INTO `code_cat` VALUES ('12', 'SUITING\r\n');
INSERT INTO `code_cat` VALUES ('13', 'CAP');
INSERT INTO `code_cat` VALUES ('14', 'ACCESSORIES');
INSERT INTO `code_cat` VALUES ('15', 'SHAWL');

-- ----------------------------
-- Table structure for `code_collection`
-- ----------------------------
DROP TABLE IF EXISTS `code_collection`;
CREATE TABLE `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_collection
-- ----------------------------
INSERT INTO `code_collection` VALUES ('SK', 'MEN');
INSERT INTO `code_collection` VALUES ('SG', 'GOLD');
INSERT INTO `code_collection` VALUES ('SD', 'DESIGNER\r\n');

-- ----------------------------
-- Table structure for `color`
-- ----------------------------
DROP TABLE IF EXISTS `color`;
CREATE TABLE `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of color
-- ----------------------------
INSERT INTO `color` VALUES ('PU', 'PURPLE');
INSERT INTO `color` VALUES ('OW', 'OFF WHITE');
INSERT INTO `color` VALUES ('BL', 'BLACK');
INSERT INTO `color` VALUES ('SN', 'SKIN');
INSERT INTO `color` VALUES ('GO', 'GOLDEN');
INSERT INTO `color` VALUES ('BR', 'BROWN');
INSERT INTO `color` VALUES ('MD', 'MUD');
INSERT INTO `color` VALUES ('SG', 'SEA GREEN');
INSERT INTO `color` VALUES ('MR', 'MAROON');
INSERT INTO `color` VALUES ('MV', 'MOUVE');
INSERT INTO `color` VALUES ('GR', 'GREEN');
INSERT INTO `color` VALUES ('MU', 'MUSTARD');
INSERT INTO `color` VALUES ('WH', 'WHITE');
INSERT INTO `color` VALUES ('GY', 'GREY');
INSERT INTO `color` VALUES ('DG', 'DARK GREEN');
INSERT INTO `color` VALUES ('LG', 'LIGHT GREEN');
INSERT INTO `color` VALUES ('BU', 'BLUE');
INSERT INTO `color` VALUES ('GB', 'GREEN BLUE');
INSERT INTO `color` VALUES ('OR', 'ORANGE');
INSERT INTO `color` VALUES ('PH', 'PEACH');
INSERT INTO `color` VALUES ('RS', 'RUST');
INSERT INTO `color` VALUES ('DB', 'DARK BLUE');
INSERT INTO `color` VALUES ('LY', 'LIGHT GREY');
INSERT INTO `color` VALUES ('SB', 'SKY BLUE');
INSERT INTO `color` VALUES ('FN', 'FORN');
INSERT INTO `color` VALUES ('CB', 'CHOCOLATE BROWN');
INSERT INTO `color` VALUES ('NB', 'NAVY BLUE');
INSERT INTO `color` VALUES ('YB', 'GREY BLACK');
INSERT INTO `color` VALUES ('GS', 'GREY SHINING');
INSERT INTO `color` VALUES ('FR', 'FEROOZI');
INSERT INTO `color` VALUES ('RD', 'RED');
INSERT INTO `color` VALUES ('LR', 'LIGHT BROWN');
INSERT INTO `color` VALUES ('LB', 'LIGHT BLUE');
INSERT INTO `color` VALUES ('CM', 'CAMEL');
INSERT INTO `color` VALUES ('CH', 'CHOCOLATE');
INSERT INTO `color` VALUES ('BG', 'BLACK GREY');
INSERT INTO `color` VALUES ('AR', 'ARMY');
INSERT INTO `color` VALUES ('MT', 'MULTI COLOUR');

-- ----------------------------
-- Table structure for `company`
-- ----------------------------
DROP TABLE IF EXISTS `company`;
CREATE TABLE `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of company
-- ----------------------------
INSERT INTO `company` VALUES ('01', 'Kamraj Enterprises', '73 Jail Road, Taj Arcade.\r\nLahore, Pakistan\r\n73 Jail Road, Taj Arcade.\r\nLahore, Pakistan\r\n73 Jail Ro', '+92 42 35408279-82, 35408283', 'haseeb1528@gmail.com', 'www.kamrajenterprises.com', '', '', '', 'Y', '0600030001', '', '', '', null, 'BK', 'UGX', null, null, '2210000001', '3010000001', '0700010001', null, '0100011000', 'A', '401', 'N', '', '0600030001', '0700020001', '0700030001', null, null);

-- ----------------------------
-- Table structure for `container_size`
-- ----------------------------
DROP TABLE IF EXISTS `container_size`;
CREATE TABLE `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of container_size
-- ----------------------------
INSERT INTO `container_size` VALUES ('0001', '16 Feet');
INSERT INTO `container_size` VALUES ('0002', '20 Feet');
INSERT INTO `container_size` VALUES ('0003', '22 Feet');
INSERT INTO `container_size` VALUES ('0004', '24 Feet');
INSERT INTO `container_size` VALUES ('0005', '40 Feet');
INSERT INTO `container_size` VALUES ('0006', '50 Feet');

-- ----------------------------
-- Table structure for `currency`
-- ----------------------------
DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of currency
-- ----------------------------
INSERT INTO `currency` VALUES ('PK', 'PKR');

-- ----------------------------
-- Table structure for `dc_type`
-- ----------------------------
DROP TABLE IF EXISTS `dc_type`;
CREATE TABLE `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of dc_type
-- ----------------------------
INSERT INTO `dc_type` VALUES ('01', 'Sale');

-- ----------------------------
-- Table structure for `discount`
-- ----------------------------
DROP TABLE IF EXISTS `discount`;
CREATE TABLE `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_percentage`
-- ----------------------------
DROP TABLE IF EXISTS `discount_percentage`;
CREATE TABLE `discount_percentage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_percentage
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `discount_voucher`;
CREATE TABLE `discount_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `division`
-- ----------------------------
DROP TABLE IF EXISTS `division`;
CREATE TABLE `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of division
-- ----------------------------
INSERT INTO `division` VALUES ('10', 'TEXTILE');

-- ----------------------------
-- Table structure for `expense`
-- ----------------------------
DROP TABLE IF EXISTS `expense`;
CREATE TABLE `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of expense
-- ----------------------------
INSERT INTO `expense` VALUES ('01', 'L/C EXPENSES');

-- ----------------------------
-- Table structure for `fin_years`
-- ----------------------------
DROP TABLE IF EXISTS `fin_years`;
CREATE TABLE `fin_years` (
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  PRIMARY KEY (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of fin_years
-- ----------------------------
INSERT INTO `fin_years` VALUES ('17', '2017', '2017-01-01', '2017-06-30');

-- ----------------------------
-- Table structure for `grn`
-- ----------------------------
DROP TABLE IF EXISTS `grn`;
CREATE TABLE `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn
-- ----------------------------

-- ----------------------------
-- Table structure for `grndet`
-- ----------------------------
DROP TABLE IF EXISTS `grndet`;
CREATE TABLE `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_return`
-- ----------------------------
DROP TABLE IF EXISTS `grn_return`;
CREATE TABLE `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_return
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `grn_returndet`;
CREATE TABLE `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boe`
-- ----------------------------
DROP TABLE IF EXISTS `im_boe`;
CREATE TABLE `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boe
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boedet`
-- ----------------------------
DROP TABLE IF EXISTS `im_boedet`;
CREATE TABLE `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boedet
-- ----------------------------

-- ----------------------------
-- Table structure for `invoice_no`
-- ----------------------------
DROP TABLE IF EXISTS `invoice_no`;
CREATE TABLE `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of invoice_no
-- ----------------------------
INSERT INTO `invoice_no` VALUES ('1', 'SL', '06');
INSERT INTO `invoice_no` VALUES ('2', 'SL', '06');

-- ----------------------------
-- Table structure for `item`
-- ----------------------------
DROP TABLE IF EXISTS `item`;
CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  `brand_id` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`),
  KEY `item_fk_brand_id` (`brand_id`),
  CONSTRAINT `item_fk_brand_id` FOREIGN KEY (`brand_id`) REFERENCES `prod_brand` (`BRAND_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=19560 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item
-- ----------------------------
INSERT INTO `item` VALUES ('19305', '0001', 'Alu side Plate', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19306', '0002', 'Alu Plate 5 T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19307', '0003', 'Alu Sheet', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19308', '0004', 'Alu BTM Casting Plate 6T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19309', '0005', 'Alu Plate 6/7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19310', '0006', 'Alu Palte 8T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19311', '0007', 'Alu Plate 10t', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19312', '0008', 'Alu Plate L type', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19313', '0009', 'Anion + Cation', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19314', '0010', 'Antenna Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19315', '0011', 'Antenna Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19316', '0012', 'Asbestos Pipe Sleeve 14 Ft', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19317', '0013', 'Asbestos Pipe Sleeve 16 Ft', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19318', '0014', 'Asbestos Pipe Sleeve 18 Ft', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19319', '0015', 'B1+', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19320', '0016', 'Bearing UCF 217', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19321', '0017', 'Bracket UCF 217', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19322', '0018', 'Bearing UCF 218', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19323', '0019', 'Bracket UCF 218', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19324', '0020', 'Bekalight Sheet', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19325', '0021', 'Bottom Block S.S T 71\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19326', '0022', 'Bottom Block S.S T 79\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19327', '0023', 'Bottom Block S.S T 84\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19328', '0024', 'Braker 0.5 A', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19329', '0025', 'Braker 1 A Single Pole', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19330', '0026', 'Braker 2 A Single Pole', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19331', '0027', 'Brarker 2 A Double Pole', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19332', '0028', 'Brass Bolt 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19333', '0029', 'Brass Bolt 1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19334', '0030', 'Brass bolt 1 1/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19335', '0031', 'Brass Bolt 1  1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19336', '0032', 'Brass Bolt For Coil 2 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19337', '0033', 'Brass Bolt For Coil 3 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19338', '0034', 'Brass For extension Rod', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19339', '0035', 'Brass Nipple', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19340', '0036', 'Brass Nut', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19341', '0037', 'Brass Washer (Big)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19342', '0038', 'Brass Washer (Small)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19343', '0039', 'Bus Bar', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19344', '0040', 'Bush For Cyl', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19345', '0041', 'Blue Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19346', '0042', 'Cable 2 Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19347', '0043', 'Cable 3 Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19348', '0044', 'Cable 3 Core Cotton + Rubber Sheet', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19349', '0045', 'Cable 18 Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19350', '0046', 'Cable 25 Core Shielded', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19351', '0047', 'Cable 25 Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19352', '0048', 'Cable 35 MM Single Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19353', '0049', 'Cable 60 Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19354', '0050', 'Cable 65 Core Shielded', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19355', '0051', 'Cable 66 Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19356', '0052', 'Cable single Core', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19357', '0053', 'Casting Soda', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19358', '0054', 'Clamp 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19359', '0055', 'Clamp 3/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19360', '0056', 'Clamp 1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19361', '0057', 'Clamp 1 !/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19362', '0058', 'Clamp 2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19363', '0059', 'Clamp 2 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19364', '0060', 'Clamp 3\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19365', '0061', 'Coil Stud Copper', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19366', '0062', 'Coil Coat', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19367', '0063', 'Coil Support 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19368', '0064', 'Coil Support6T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19369', '0065', 'Coil Support 8T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19370', '0066', 'Coil Support 10T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19371', '0067', 'Coil Support 12T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19372', '0068', 'Coil Turn 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19373', '0069', 'Coil Turn 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19374', '0070', 'Coil Turn 10T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19375', '0071', 'Coil turn 12T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19376', '0072', 'Copper Spring Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19377', '0073', 'Copper Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19378', '0074', 'Cyl Bore 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19379', '0075', 'Cyl Bore 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19380', '0076', 'Cyl Shroud 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19381', '0077', 'Cyl Shroud 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19382', '0078', 'D. C Supplier', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19383', '0079', 'Data Cable', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19384', '0080', 'Distilled Water', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19385', '0081', 'Dl-Coil 5T ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19386', '0082', 'DL-Coil 6 T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19387', '0083', 'DL - Coil 7 T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19388', '0084', 'Dl-Coil 8T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19389', '0085', 'DL-Coil 10T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19390', '0086', 'DL-Coil 12T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19391', '0087', 'Elbow', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19392', '0088', 'Extension Rod', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19393', '0089', 'F.G Coil Support', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19394', '0090', 'F.G Pipe', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19395', '0091', 'F.g Sheet 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19396', '0092', 'F.G Sheet 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19397', '0093', 'F.G Sheet (Round)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19398', '0094', 'F.G Sheet (Small)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19399', '0095', 'F.G Sheet (England0', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19400', '0096', 'F.G Sheet Front', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19401', '0097', 'F.G Gutke 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19402', '0098', 'F.G Gutke 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19403', '0099', 'F.G Gutke 12 T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19404', '0100', 'F. G Spacer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19405', '0101', 'F.G Washer (Big)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19406', '0102', 'F.G Washer (Small)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19407', '0103', 'Fire Fly Sheet', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19408', '0104', 'Flow Pipe', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19409', '0105', 'Foundation Foot 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19410', '0106', 'Foundation Foot 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19411', '0107', 'Foundation Gutke', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19412', '0108', 'Furnace Block Support', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19413', '0109', 'Gear Pump', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19414', '0110', 'GFL Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19415', '0111', 'GLD Antenna', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19416', '0112', 'GLD Antenna Rod', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19417', '0113', 'GLD Antenna Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19418', '0114', 'GLD Chok', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19419', '0115', 'GLD Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19420', '0116', 'Glass Fuse Box', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19421', '0117', 'H1+', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19422', '0118', 'H2+', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19423', '0119', 'Hockey pipe', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19424', '0120', 'Hooter', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19425', '0121', 'Hose Pipe 1/2', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19426', '0122', 'Hose Pipe 3/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19427', '0123', 'Hose Pipe 1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19428', '0124', 'Hose Pipe 1 1/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19429', '0125', 'Hose Pipe 1 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19430', '0126', 'Hose Pipe 2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19431', '0127', 'Hose Pi[pe 3\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19432', '0128', 'Hyd Hose Pipe 30\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19433', '0129', 'Hyd Hose Pipe 36\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19434', '0130', 'Hyd Hose Pipe 3/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19435', '0131', 'Hyd Hose Pipe 12T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19436', '0132', 'Ibonite Sheet', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19437', '0133', 'Laans', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19438', '0134', 'Laans Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19439', '0135', 'Lance Sleeve', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19440', '0136', 'Lead Adaptor', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19441', '0137', 'Lead ring Shield', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19442', '0138', 'Light Red', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19443', '0139', 'Light Yellow', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19444', '0140', 'Light Green', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19445', '0141', 'Lugs (Flat)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19446', '0142', 'Lugs (I) Big', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19447', '0143', 'Lugs (i) Small', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19448', '0144', 'Lugs (O) Small', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19449', '0145', 'Lugs O (Big)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19450', '0146', 'Lugs U', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19451', '0147', 'M S Plain Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19452', '0148', 'M S Spring Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19453', '0149', 'Manifol', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19454', '0150', 'Mica Sheet 0.5 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19455', '0151', 'Mica Sheet 1 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19456', '0152', 'Mica Sheet 1.5 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19457', '0153', 'Mica Sheet 2.5 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19458', '0154', 'Mica Sheet 2 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19459', '0155', 'Mica Sheet 3 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19460', '0156', 'Mica Sheet 5 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19461', '0157', 'Mica Sheet 6 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19462', '0158', 'Mica Sheet 6.5 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19463', '0159', 'Mica Sheet 9 MM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19464', '0160', 'Mica Sheet For Shunt', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19465', '0161', 'Mica tape', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19466', '0162', 'Multimeter', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19467', '0163', 'Nipple', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19468', '0164', 'Numbering Set', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19469', '0165', 'p4+', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19470', '0166', 'Pt For Energy Meter', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19471', '0167', 'Pyrometer\'s Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19472', '0168', 'R1+', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19473', '0169', 'Raping Tape', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19474', '0170', 'S.S Nut1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19475', '0171', 'S.S Nut 1 1/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19476', '0172', 'S.S Nut 1 1/2\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19477', '0173', 'S.S Nut & Bolt For Trunine Plate', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19478', '0174', 'S.S Rod Full Thread 1\'\' L 76\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19479', '0175', 'S.S Rod Full Thread 1\'\' L 78\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19480', '0176', 'S.S Rod Both Side Thread 1\'\' L 72\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19481', '0177', 'S.S Rod Both Side Thread 1\'\' L 80\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19482', '0178', 'S.S Rod Both Side Thread 1 1/4\'\' L 82\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19483', '0179', 'S.S Rod Both Side Thread 1 \'\' L 85\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19484', '0180', 'S.S Rod Both Side Thread 1 1/4\'\' L 85\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19485', '0181', 'S.S Rod Both Side Thread 1 1/4\'\' L 88\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19486', '0182', 'S.S Rod Both Side Thread 1 1/4\'\' L 93\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19487', '0183', 'S.S Rod Both Side Thread 1 1/2\'\' L 93\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19488', '0184', 'S.S Rod Both Side Thread 1 1/2\'\' L 94\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19489', '0185', 'S.S Rod Full Thread 1 1/4\'\' L88\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19490', '0186', 'S.S Rod Full Thread 1\'\' L80\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19491', '0187', 'S.S Spring Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19492', '0188', 'S.S Tee For Bottom block 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19493', '0189', 'S.S Tee For Bottom block 6T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19494', '0190', 'S.S Tee For Bottom block 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19495', '0191', 'S.S Tee For Bottom block 8T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19496', '0192', 'S.S Plain washer 1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19497', '0193', 'S.S Plain washer 1 1/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19498', '0194', 'S.S Spring Washer 1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19499', '0195', 'S.S Spring Washer 1 1/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19500', '0196', 'Sendium Spacer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19501', '0197', 'Shaft 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19502', '0198', 'Shaft 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19503', '0199', 'Sockit', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19504', '0200', 'Side Plate For 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19505', '0201', 'Side Plate For 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19506', '0202', 'Silicon tube', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19507', '0203', 'Silicon Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19508', '0204', 'Solid State relay', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19509', '0205', 'Stud union For Bus Bar', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19510', '0206', 'Stud Union For Coil', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19511', '0207', 'Stud Union For W.C Lead ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19512', '0208', 'Stud Union For W.C Lead 12t', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19513', '0209', 'T3+', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19514', '0210', 'T. Bush 1\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19515', '0211', 'T.Bush 1 1/4\'\'', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19516', '0212', 'Tape F.G (Big)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19517', '0213', 'Tape F.G (Small)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19518', '0214', 'Teflon Wire', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19519', '0215', 'Teflon Washer', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19520', '0216', 'Teflon Paper', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19521', '0217', 'Teflon Sleeve 5T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19522', '0218', 'Teflon Sleeve 7T', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19523', '0219', 'Temprature Gauge', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19524', '0220', 'Thermocouple rod', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19525', '0221', 'Temprature Tips', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19526', '0222', 'Twist tape (big)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19527', '0223', 'Twist (Small)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('19528', '0224', 'Yoke', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);

-- ----------------------------
-- Table structure for `item_description`
-- ----------------------------
DROP TABLE IF EXISTS `item_description`;
CREATE TABLE `item_description` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item_description
-- ----------------------------

-- ----------------------------
-- Table structure for `location`
-- ----------------------------
DROP TABLE IF EXISTS `location`;
CREATE TABLE `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  `comp_id` varchar(2) NOT NULL,
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of location
-- ----------------------------
INSERT INTO `location` VALUES ('01', 'Main Store', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on', '01');

-- ----------------------------
-- Table structure for `locations`
-- ----------------------------
DROP TABLE IF EXISTS `locations`;
CREATE TABLE `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of locations
-- ----------------------------
INSERT INTO `locations` VALUES ('01', 'Main Store');

-- ----------------------------
-- Table structure for `lots`
-- ----------------------------
DROP TABLE IF EXISTS `lots`;
CREATE TABLE `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of lots
-- ----------------------------

-- ----------------------------
-- Table structure for `menu`
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL,
  `menu_detail` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES ('1', 'Sale', null, null);
INSERT INTO `menu` VALUES ('1.1', 'Invoice', null, null);
INSERT INTO `menu` VALUES ('1.2', 'Order', null, null);
INSERT INTO `menu` VALUES ('1.3', 'Sale Delivery Challan', null, null);
INSERT INTO `menu` VALUES ('1.4', 'Outword Gate pass', null, null);
INSERT INTO `menu` VALUES ('1.5', 'Receipts', null, null);
INSERT INTO `menu` VALUES ('1.6', 'Journal', null, null);
INSERT INTO `menu` VALUES ('1.7', 'Sale Return', null, null);
INSERT INTO `menu` VALUES ('2', 'Purchase', null, null);
INSERT INTO `menu` VALUES ('2.1', 'Invoice', null, null);
INSERT INTO `menu` VALUES ('2.2', 'Order', null, null);
INSERT INTO `menu` VALUES ('2.3', 'Inward Gate pass', null, null);
INSERT INTO `menu` VALUES ('2.4', 'Payments', null, null);
INSERT INTO `menu` VALUES ('2.5', 'Journal', null, null);
INSERT INTO `menu` VALUES ('2.6', 'Purchase Return', null, null);
INSERT INTO `menu` VALUES ('3', 'Accounts', null, null);
INSERT INTO `menu` VALUES ('3.1', 'Payments', null, null);
INSERT INTO `menu` VALUES ('3.2', 'Journal Voucher', null, null);
INSERT INTO `menu` VALUES ('4', 'Stock', null, null);
INSERT INTO `menu` VALUES ('4.1', 'Production', null, null);
INSERT INTO `menu` VALUES ('4.2', 'Consumption', null, null);
INSERT INTO `menu` VALUES ('5', 'Master File', null, null);
INSERT INTO `menu` VALUES ('5.1', 'Items', null, null);
INSERT INTO `menu` VALUES ('5.2', 'Chart Of Accounts', null, null);
INSERT INTO `menu` VALUES ('5.3', 'Items', null, null);
INSERT INTO `menu` VALUES ('5.4', 'Sale Person', null, null);
INSERT INTO `menu` VALUES ('5.5', 'Category', null, null);
INSERT INTO `menu` VALUES ('5.6', 'Users', null, null);
INSERT INTO `menu` VALUES ('6', 'Reports Summary', null, null);
INSERT INTO `menu` VALUES ('6.1', 'Sale Summary', null, null);
INSERT INTO `menu` VALUES ('6.2', 'Stock Summary', null, null);
INSERT INTO `menu` VALUES ('6.3', 'Outword Gate pass Summary', null, null);
INSERT INTO `menu` VALUES ('6.4', 'Sale Order Summary', null, null);
INSERT INTO `menu` VALUES ('6.5', 'Purchase Summary', null, null);
INSERT INTO `menu` VALUES ('6.6', 'Purchase Order Summary', null, null);
INSERT INTO `menu` VALUES ('6.7', 'Purchase InwordGatepass Summary', null, null);
INSERT INTO `menu` VALUES ('7', 'Reports Detail', null, null);
INSERT INTO `menu` VALUES ('7.1', 'Sale Report', null, null);
INSERT INTO `menu` VALUES ('7.2', 'Sale Order', null, null);
INSERT INTO `menu` VALUES ('7.3', 'Outword Gatepass', null, null);
INSERT INTO `menu` VALUES ('7.4', 'WareHouse Stock', null, null);
INSERT INTO `menu` VALUES ('7.5', 'Purchase Invoice', null, null);
INSERT INTO `menu` VALUES ('7.6', 'Inword Gatepass', null, null);
INSERT INTO `menu` VALUES ('7.7', 'Stock Ledger', null, null);
INSERT INTO `menu` VALUES ('8', 'Reports Accounts', null, null);
INSERT INTO `menu` VALUES ('8.1', 'Ledgers', null, null);
INSERT INTO `menu` VALUES ('8.2', 'Day Book', null, null);
INSERT INTO `menu` VALUES ('9', 'Reports', null, null);
INSERT INTO `menu` VALUES ('9.1', 'Sale Report', null, null);
INSERT INTO `menu` VALUES ('9.2', 'Gatepass Outword Report', null, null);
INSERT INTO `menu` VALUES ('9.3', 'Current Stock', null, null);

-- ----------------------------
-- Table structure for `ms_sale`
-- ----------------------------
DROP TABLE IF EXISTS `ms_sale`;
CREATE TABLE `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of ms_sale
-- ----------------------------

-- ----------------------------
-- Table structure for `nom`
-- ----------------------------
DROP TABLE IF EXISTS `nom`;
CREATE TABLE `nom` (
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_NAME` char(50) NOT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `ACCT_TYPE` varchar(4) DEFAULT NULL,
  `FS_TYPE` varchar(1) DEFAULT NULL,
  `SUB` varchar(1) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `TEST_NAME` char(50) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `address` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `reg_id` varchar(6) NOT NULL,
  `credit_limit` decimal(10,2) NOT NULL,
  `ntn` varchar(50) NOT NULL,
  `stax_no` varchar(50) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom
-- ----------------------------
INSERT INTO `nom` VALUES ('01', 'CAPITAL & LIABILITIES', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('010001', 'PAID UP CAPITAL', null, '3101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100010001', 'OPENING BALANCES', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('010002', 'DRAWINGS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020001', 'Happy Malik Sb', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020002', 'Waseem Sb', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020003', 'MOHSIN SB', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020004', 'FAROOQ SB', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020005', 'SHEIKH SALEEM', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020006', 'KHALID SB', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020007', 'NADEEM SB vanity', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020008', 'SAJED SB markiting', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020009', 'HASEEB WALPAPER', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020011', 'DR RASHEED SB GAZI ROD STOR', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100020012', 'KHURAM SB', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('010003', 'Investments', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100030001', 'Investment Account', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('13', 'CREDITORS & OTHER PAYABLES', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('131000', 'TRADE CREDITORS CONTROL A/C', null, '2802', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000001', 'Ashfaq Sons', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000002', 'Porta Acrylic Bath Tubs Lahore', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000003', 'TREND BATHROOM ACCESSORIES', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000004', 'URBAN CERAMICS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000005', 'SABAAN', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000006', 'MAGOON TRADERS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000007', 'MASTER', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000008', 'DIAMOND', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000009', 'A', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000010', 'STYLE BATH WARE', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000011', 'AL-HARMAIN PAINT CENTRE', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000012', 'SYMBOL INDUSTRIES (PVT) LTD', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000013', 'VEGA', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000014', 'JAVAID', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000015', 'MAHMOOD GUJRANWALA', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000017', 'GOROHE', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000018', 'KBS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000019', 'SKY SANITORY', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000020', 'MIDAS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000021', 'USAMA PRINTING', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000022', 'ALLAH WASAYA', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000023', 'RAVI TRADERS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000024', 'SAMAAR SKIRTING', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000025', 'MIAN FAKHAR', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000026', 'USMAN', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000027', 'IMC', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000028', 'MAHMOOD SONS', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000029', 'ijaz  architect', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000030', 'MUHAMMADI STORE', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000031', 'ILYAS/SONS', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000032', 'WASEEM BROTHERS', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000033', 'BASRA BROTHERS', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000034', 'VIZDOM', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000035', 'SILLA CONCEPT\'S', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000036', 'CANON', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000037', 'AMJAD GUJRANWALA', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000038', 'GODI COMMODE', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000039', 'NATURE', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000040', 'ANSARI PLASTIC', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000041', 'ASIAN STANDERED', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000042', 'LEXTA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000043', 'SHEN CHINEESE', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000044', 'MARACHI', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000045', 'INTERIO FLOORS', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000046', 'BEST HOME', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000047', 'BUTT TRADER', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000048', 'Cash Purchases', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000049', 'FABER', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000050', 'OULIN', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000051', 'CHAINES SHYN', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000052', 'ANSARI SANITARY', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000053', 'U.S TRADERS', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000054', 'HAJWARI', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000055', 'ISLAM JALI', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000056', 'MODEREN JALI', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000057', 'JAMSHAID', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000058', 'GOZZINI', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000059', 'RAAED IMPEX', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000060', 'usman builder', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000061', 'KASEL ( PVT ) LTD.', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000062', 'SONEX', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000063', 'Classic Cramics', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000064', 'G.B TRADERS', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000065', 'SAROSH GROHE', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000066', 'Mak Trading', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000067', 'SWIFETLOCK', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000068', 'CERAMICS WORLD', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000069', 'SARINA FLOORING', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000070', 'MOHKAM TILES N BATH', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('15', 'ADMIN AND GENERAL EXPENSES', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('19', 'EXPENSED PAYABLE AND ACCRUED', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('191000', 'SALARIES PAYABLE', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000001', 'SALARY PAYABLE SHAHID SHEIKH', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000002', 'SALARY PAYABLE Sarosh Ch', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000003', 'SALARY PAYABLE Rashid', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000004', 'SALARY PAYABLE Salman SB', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000005', 'SALARY PAYABLE Hafiz Azeem', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000006', 'SALARY PAYABLE Yaseen', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000007', 'SALARY PAYABLE Awias', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000008', 'SALARY PAYABLE Bilawal', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000009', 'SALARY PAYABLE Atif', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000010', 'SALARY PAYABLE Mubashar', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000011', 'SALARY PAYABLE Driver happy sb', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000012', 'SALARY PAYABLE Driver waseem sb', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000013', 'SALARY PAYABLE Faisal Zia', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000014', 'SALARY PAYABLE Hameed', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000015', 'SALARY PAYABLE IBRAR', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000016', 'SALARY PAYABLE Arslan Paint', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000017', 'SALARY PAYABLE Ashraf Paint', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000018', 'SALARY PAYABLE Naveed paINT', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000019', 'SALARY PAYABLE FATEH MUHAMMAD', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000020', 'SALARY PAYABLE GULAM DESTAGIR', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000021', 'SALARY PAYABLE QUEEM', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000022', 'SALARY PAYABLE DILAWER', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000023', 'SALARY PAYABLE HADIR MIRROR', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000024', 'SALARY PAYABLE NADEEM', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000025', 'SALARY PAYABLE AHMAD MIRROR', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000026', 'SALARY PAYABLE TO USMAN TBC', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000027', 'SALARY PAYABLE NASIR', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000028', 'SALARY PAYABLE MURTAZA', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000029', 'SALARY PAYABLE TAYYAB', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000030', 'SALARY PAYABLE BABAR', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000031', 'SALARY PAYABLE WAQAS', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000032', 'SALARY PAYABLE JAMEEL', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000033', 'SALARY PAYABLE TANVEER', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000034', 'SALARY PAYABLE WALEED', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000035', 'SALARY PAYABLE AMJAD', null, '2801', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000036', 'SALARY PAYABLE AMMAR', null, '2801', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000037', 'SALARY PAYABLE IMRAN PAINT', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000038', 'SALARY PAYABLE USMAN VANITY', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000039', 'SALARY PAYABLE ADEEL MIRROR', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000040', 'SALARY PAYABLE WAQAR', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000041', 'SALARY PAYABLE HAIDER MIRROR', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000042', 'SALARY PAYABLE DASTAGIR', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000050', 'SALARY PAYABLE NABEEL', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000051', 'SALARY PAYABLE AHMAD', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1910000052', 'SALARY PAYABLE AMAAN', null, '2801', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('191002', 'Salary Payable (Perfect Home)', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('191003', 'Salary Payable (Ghazi Road)', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('192000', 'Commission Payable', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000001', 'Commission Payable Sarosh', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000002', 'COMMISSION TO SHAHID SB', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000003', 'Commission Payable RASHID', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000004', 'Commission Payable WAQAS', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000005', 'Commission Payable WALEED', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000006', 'Commission Payable YASEEN', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000007', 'Commission Payable SALMAN sb', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000008', 'OVER TIME STAFF', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1920000009', 'STAFF BONUS', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('20', 'ASSETS', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('201000', 'FIXED ASSETS', null, '1101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2010000001', 'FIXED ASSETS (OFFICE)', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('201500', 'Loans & Advances', null, '1901', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('202000', 'VEHICLES', null, '1901', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('22', 'STOCKS', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('221000', 'STOCKS IN TRADE', null, '1903', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2210000001', 'Stock In Trade', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('26', 'SUNDRY DEBTORS', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('261000', 'TRADE DEBTORS CONTROL A/C', null, '1902', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000001', 'Walk-In-Customers', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000003', 'Gourmet', null, '1902', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000027', 'SAYYAD BROTHER', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000028', 'KASHIF SB 245/G PHS# 5 DHA', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000029', 'MURTZA CUSTMER', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000030', '200/1-B ST-NO #1 PHASE-5 DHA', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000031', '36-D LAWRENCE ROAD LHR 03034291889', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000032', 'AHMAD SB', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000033', 'OLYMPIA BUILDERS', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000034', 'H-NO. 923/D PHS 6 DHA LHR', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000035', 'MR. ANEES SB 0321-4185133', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000036', '904/K PHS#6 DHA 03228470847', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000037', '547/D 0322454045', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000038', 'MALL OF SIALKOT', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000039', 'DISPLAY', null, '1902', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000040', 'SHOAIB KHAN SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000041', 'NADEEM SB CUSTOMER', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000042', 'CERAMICS', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000043', 'HOME TECH', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000044', 'KHALID SB ASKRI 10', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000045', '347/Y PHS# 3', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000046', 'QAYUM SB DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000047', 'ARIF NAZIR SB 141-J PHAS 6 DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000048', 'NASEEM AHMAD software', null, '', null, null, null, null, '02', null, null, '', '', '', '1', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000049', 'HAJI HAKM SB 73 / C PH# 6', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000050', 'B PLAZA NADEEM KHAN', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000051', '125/E DHA PHS#6 03429693431', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000052', 'DR. ASIM SB 03214864288', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000053', '69/G MODAL TWON', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000054', '228/B STAT LIFE', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000056', '242/L PH# 5 DHA  MR.UMAR', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000057', 'ABDULLAH SB PH# 6 839/D DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000058', 'AFTAB SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000059', 'H-NO 254-DD PHS# 4 03218487965', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000060', '246/E-1 WAPDA TWON PHAS# 1', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000061', 'UMER KHALID SB 54/C PHAS# 5 DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000062', 'H-NO 862/B PH# 5 DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000063', 'H-NO 1070/N PH# 6 BUTT SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000064', 'PESHWAR MALL', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000065', 'H-NO 25/E 35210478', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000066', '398/B PH# 5 DHA KASHIF SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000067', 'KHAZIR SB SOI GAS SUCITY', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000068', 'FAZAN SB 03339678883', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000069', '69/9-J-3 JOHAR TWON LHR', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000070', '102/CC PHS# 4 DHA SULTAN SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000071', 'FAROOQ SB 147/E DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000072', 'WASEEM SB 539/G PH#5 DHA', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000073', '328/17 W DHA 03214873769', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000074', 'MR. SHAHID 0300 5865466', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000075', '236/N PHS# 6 DHA 03226777706', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000076', 'SYSTEM PLAZA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000077', 'H-NO 732/C PH# 5 DHA', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000078', 'H/NO 48/C PH# 8 DHA ABDUL BASIT SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000079', 'JAMEEL SB', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000080', 'ALI SAAB', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000081', 'DR. TALAL SB PH# 6', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000082', 'HAROON HAMEED H-NO 179/PHS#4', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000083', 'JAVAID SB 293/N PHS#6 DHA', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000084', 'TAMMOOR SB 591/B PHS#6 03224569837', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000085', 'H-NO 355/B PHS#8 DHA 03214420002', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000086', '1016/D PHS#4 DHA', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000087', 'NASIR SB', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000088', '355/C PH#6 DHA', null, null, null, null, null, null, null, null, null, '', '', '03236225022', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000089', 'H-NO 308 03001200192', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000090', '174/V PH# 2 DHA 0307406954', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000091', 'AHMED GROHE', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000092', 'IMRAN SB 593-X DHA 032188400772', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000093', '490/L PH#5 DHA KHURAM SB', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000094', 'MR ABUZAR 03214448693', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000095', 'MR JAVAID IQBAL', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000096', 'H/NO 834/D PH#6 DHA', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000097', 'M IFTKHAR SB 124/BAHRIA TWON', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('262000', 'Other Debtors', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2620000001', 'Bath & Kitchen', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2620000002', 'Perfect Homes', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('263000', 'Other Receivables', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2630000001', 'Cash Reconciliation', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('27', 'CASH & BANK BALANCES', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('271000', 'CASH', null, '1999', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2710000001', 'Cash In Hand', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2710000005', 'Cheques In Hand', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2710000007', 'Soft Payments', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('271500', 'Other Cash Accounts', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2715000010', 'Cash In Hand (Ghazi Road)', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('272000', 'BANK BALANCES', null, '1999', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000001', 'HABIB BANK', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000002', 'Bank Alfalah', null, '', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000003', 'CLEARING CHARGES', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000004', 'SILK BANK', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('30', 'REVENUE', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('301000', 'SALES', null, '4101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010000001', 'SALE', null, '4101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010000010', 'Discount Allowed', null, '4101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010000020', 'Sale Returns', null, '4101', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('302000', 'COST OF SALES', null, '5101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000001', 'Cost OF SALE', null, '5101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('35', 'STAFF LOAN AND ADVANCES', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('351000', 'STAFF LOAN', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000001', 'STAFF LOAN SAROSH', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000002', 'STAFF LOAN YASEEN', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000003', 'STAFF LOAN SALMAN', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000004', 'STAFF LOAN IBRAR', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000005', 'STAFF LOAN MOBASHER', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000006', 'STAFF LOAN WAQAR', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000007', 'STAFF LOAN WALEED', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000008', 'STAFF LOAN Hafiz Azeem', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000009', 'STAFF LOAN GULAM DESTAGIR', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000010', 'STAFF LOAN QUEEM', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000011', 'STAFF LOAN Ashraf Paint', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000012', 'STAFF LOAN Atif', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000013', 'STAFF LOAN Shahid Sheikh', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000014', 'STAFF LOAN Rashid', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('3510000015', 'STAFF LOAN Awias', null, '', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('40', 'ADMINISTRATIVE EXPENSES', null, '6101', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('401000', 'SHOP EXPENSES', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000001', 'ENTERTAINMENT EXPENSES', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000002', 'PAINT EXPENSES', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000003', 'MISC EXPENSES', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000004', 'RENT CUSTOMER', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000005', 'FRIGHT', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000006', 'Fuel Expenses', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000007', 'Stationary Expenses', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000008', 'Utility BILL', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000009', 'CHARITY PAID', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000010', 'LABOUR PAYABLE', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000011', 'OBLIGED PAYABLE', null, '6101', null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000013', 'CUSTOMER ENTERTAINMENT', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000014', 'ZAKAT', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000015', 'DISPLAY EXP', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000016', 'REPAIR EXP', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010001000', 'TAMOUR SB SHOW ROOM PERFACT HOME', null, '6101', null, null, null, null, '02', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('402000', 'DOMESTIC EXPENSES', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('403000', 'SALARIES AND BENEFITS', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('4030000001', 'STAFF SALARIES', null, '6101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('50', 'SELLING EXPENCES', null, '0', null, null, 'click', null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('501000', 'FREIGHT ON SALE', null, '6201', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('60', 'INCOME', null, '8101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('601000', 'Other Income', null, '8101', null, null, null, null, '01', null, null, '', '', '', '', '0.00', '', '');

-- ----------------------------
-- Table structure for `nom_add`
-- ----------------------------
DROP TABLE IF EXISTS `nom_add`;
CREATE TABLE `nom_add` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `reg_id` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_add
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_copy`
-- ----------------------------
DROP TABLE IF EXISTS `nom_copy`;
CREATE TABLE `nom_copy` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT 'HO'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_copy
-- ----------------------------
INSERT INTO `nom_copy` VALUES ('01', 'CAPITAL & LIABILITIES', '0', '', '', 'HO');

-- ----------------------------
-- Table structure for `nom_lc`
-- ----------------------------
DROP TABLE IF EXISTS `nom_lc`;
CREATE TABLE `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_lc
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_old`
-- ----------------------------
DROP TABLE IF EXISTS `nom_old`;
CREATE TABLE `nom_old` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '01',
  PRIMARY KEY (`comp_id`,`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_old
-- ----------------------------
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '0', '', '', '01');
INSERT INTO `nom_old` VALUES ('010001', 'DIRECT EXPENSES', '31', '', '5', '01');
INSERT INTO `nom_old` VALUES ('0100010001', 'COST OF GOOD SOLD', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '31', '', '61', '01');
INSERT INTO `nom_old` VALUES ('0100020001', 'ENTERTAINMENT EXPENSES', null, '', '', '01');
INSERT INTO `nom_old` VALUES ('0100020002', 'TRAVELLING EXPENSES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020003', 'STATIONARY', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020004', 'ADVERTISEMENT EXP', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020005', 'GROCERY EXP', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020006', 'OFFICE EXPENSES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020007', 'REPAIR AND MAINTAINANCE\r\n', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020008', 'RENT WAREHOUSE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020010', 'KARIM BLOCK OUTLET EXPENSES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010003', 'OPENING BALANCES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100030001', 'OPENING BALANCES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010010', 'STAFF SALARIES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100100001', 'STAFF SALARIES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('02', 'EQUITY', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('020001', 'PROPRITERS CAPITAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0200010001', 'PROPRITERS CAPITAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0200010002', 'OPENING BALANCE ADJUSTMENT ACOOUNT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('03', 'Short Term Liabilites', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('030007', 'Accrued Salaries', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070001', 'SALARY PAYABLE KAMRAN', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070002', 'SALARY PAYABLE - NADISH', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070003', 'SALARY PAYABLE - KHURRAM', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070004', 'SALARY PAYABLE - JAVED', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070005', 'SALARY PAYABLE - FAROOQ', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070006', 'SALARY PAYABLE - SHUJA BAHI (TAX ADVISOR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070007', 'SALARY PAYABLE - VICTOR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070008', 'SALARY PAYABLE - MOHSIN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070009', 'SALARY PAYABLE - FAISAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070010', 'SALARY PAYABLE - TALAH', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070011', 'SALARY PAYABLE - SIKANDAR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070012', 'SALARY PAYABLE - SONIL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070013', 'SALARY PAYABLE - ALI RAZA', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('10', 'LIABILITIES', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('100001', 'VENDOR FINISHED GOODS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010001', 'VENDOR SHOES - KASHIF PAYABLE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010002', 'MR MAJEED (KURTA)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010003', 'MR TAHIR (WAIST COAT)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010004', 'MR ARIF (EMBROIDARY)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010005', 'MR MUSHTAQ (HSY)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010006', 'HUMD INTERNATIONAL PVT LTD', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('100002', 'VENDOR RAW MATERIAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020001', 'HAMZA AKHTAR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020002', 'HAJI KHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020003', 'WAZIR AHMED', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020004', 'ZAKIR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020005', 'LONDON', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020006', 'DARWESH KHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020007', 'AL-REHMAT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020008', 'SHADMAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('20', 'STOCK', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('200001', 'STOCK IN TRADE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2000010001', 'STOCK IN TRADE (RM)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2000010002', 'STOCK IN TRADE (FG)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '19', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000002', 'ELECTRONICS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000003', 'FURNITURE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('272000', 'BANK BALANCES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2720000001', 'HABIB BANK', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2720000002', 'FAYSAL BANK', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('273000', 'OUTLET', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000001', 'HEAD OFFICE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000002', 'STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000003', 'DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000004', 'EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000005', 'EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000006', 'SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000007', 'FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000008', 'OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000009', 'BWP ', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000012', 'KAREEM BLOCK', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('41', 'TURNOVER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('410001', 'SALE', null, '', '4', '01');
INSERT INTO `nom_old` VALUES ('4100010001', 'SALES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010002', 'SALE - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010003', 'SALES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010004', 'SALES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010005', 'SALES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010006', 'SALES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010007', 'SALES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010008', 'SALES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010009', 'SALES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010012', 'SALES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410002', 'DISCOUNT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020001', 'DISCOUNT - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020002', 'DISCOUNT - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020003', 'DISCOUNT - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020004', 'DISCOUNT - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020005', 'DISCOUNT - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020006', 'DISCOUNT - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020007', 'DISCOUNT - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020008', 'DISCOUNT - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020009', 'DISCOUNT - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020012', 'DISCOUNT - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410003', 'SALES RETURN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030001', 'RETURN - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030002', 'RETURN - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030003', 'RETURN - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030004', 'RETURN - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030005', 'RETURN - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030006', 'RETURN - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030007', 'RETURN - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030008', 'RETURN - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030009', 'RETURN - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030012', 'RETURN - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410004', 'CREDIT NOTES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040001', 'CREDIT NOTES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040002', 'CREDIT NOTES - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040003', 'CREDIT NOTES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040004', 'CREDIT NOTES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040005', 'CREDIT NOTES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040006', 'CREDIT NOTES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040007', 'CREDIT NOTES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040008', 'CREDIT NOTES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040009', 'CREDIT NOTES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040012', 'CREDIT NOTES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410005', 'DEBIT NOTES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050001', 'DEBIT NOTES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050002', 'DEBIT NOTES - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050003', 'DEBIT NOTES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050004', 'DEBIT NOTES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050005', 'DEBIT NOTES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050006', 'DEBIT NOTES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050007', 'DEBIT NOTES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050008', 'DEBIT NOTES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050009', 'DEBIT NOTES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050012', 'DEBIT NOTES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('99', 'COST CENTRES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('990001', 'STAFF', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010001', 'ALI SHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010002', 'HUSNAIN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010003', 'MUSA', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('20', 'STOCK', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('200001', 'STOCK IN TRADE', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('2000010001', 'STOCK IN TRADE (RM)', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('2000010002', 'STOCK IN TRADE (FG)', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '13');

-- ----------------------------
-- Table structure for `o_batch`
-- ----------------------------
DROP TABLE IF EXISTS `o_batch`;
CREATE TABLE `o_batch` (
  `PROD_ID` varchar(4) NOT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `BAL_QTY` decimal(10,0) DEFAULT NULL,
  `O_QTY` decimal(10,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_batch
-- ----------------------------
INSERT INTO `o_batch` VALUES ('0420', '2017-04-30 00:00:00', 'TOS-1525', null, '1200');

-- ----------------------------
-- Table structure for `o_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucher`;
CREATE TABLE `o_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime NOT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `POSTED` varchar(1) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `o_voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucherdet`;
CREATE TABLE `o_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(13,2) DEFAULT NULL,
  `CREDIT` decimal(13,2) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucherdet
-- ----------------------------

-- ----------------------------
-- Table structure for `o_voucherdet_e`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucherdet_e`;
CREATE TABLE `o_voucherdet_e` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `BPV_ID` varchar(20) DEFAULT NULL,
  `TENDER_NO` varchar(50) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucherdet_e
-- ----------------------------

-- ----------------------------
-- Table structure for `party`
-- ----------------------------
DROP TABLE IF EXISTS `party`;
CREATE TABLE `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party
-- ----------------------------

-- ----------------------------
-- Table structure for `party_add`
-- ----------------------------
DROP TABLE IF EXISTS `party_add`;
CREATE TABLE `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `party_product`
-- ----------------------------
DROP TABLE IF EXISTS `party_product`;
CREATE TABLE `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_product
-- ----------------------------
INSERT INTO `party_product` VALUES ('0001', '0357', '46.000', null, null, null, '3');

-- ----------------------------
-- Table structure for `party_type`
-- ----------------------------
DROP TABLE IF EXISTS `party_type`;
CREATE TABLE `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_type
-- ----------------------------
INSERT INTO `party_type` VALUES ('C', 'Customer');
INSERT INTO `party_type` VALUES ('S', 'Supplier');
INSERT INTO `party_type` VALUES ('T', 'Trader');
INSERT INTO `party_type` VALUES ('I', 'Import');
INSERT INTO `party_type` VALUES ('P', 'Production');
INSERT INTO `party_type` VALUES ('A', 'Cash');
INSERT INTO `party_type` VALUES ('O', 'Other');
INSERT INTO `party_type` VALUES ('V', 'Vender');

-- ----------------------------
-- Table structure for `pay_mode`
-- ----------------------------
DROP TABLE IF EXISTS `pay_mode`;
CREATE TABLE `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pay_mode
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dc`;
CREATE TABLE `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dcdet`;
CREATE TABLE `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gp`;
CREATE TABLE `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `pl_gp_fk_year_id` (`year_id`),
  KEY `pl_gp_fk_comp_id` (`comp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gpdet`;
CREATE TABLE `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grn`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grn`;
CREATE TABLE `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grn
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grndet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grndet`;
CREATE TABLE `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice`;
CREATE TABLE `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedet`;
CREATE TABLE `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoice_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedetapp`;
CREATE TABLE `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoicedet_copy`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedet_copy`;
CREATE TABLE `pl_invoicedet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedet_copy
-- ----------------------------
INSERT INTO `pl_invoicedet_copy` VALUES ('060001', '1', '4242', '', '4.000', '2548.00000', '10193.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060002', '1', '3976', '', '1.000', '708.00000', '708.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060002', '2', '3976', '', '1.000', '708.00000', '708.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060002', '3', '4228', '', '1.000', '3174.00000', '3174.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060002', '4', '4243', '', '1.000', '1641.00000', '1641.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060002', '5', '4244', '', '1.000', '4017.00000', '4017.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060002', '6', '3826', '', '1.000', '1400.00000', '1400.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060003', '1', '3821', '', '4.000', '5412.00000', '21648.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060003', '2', '4245', '', '4.000', '4437.00000', '17748.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060003', '3', '3822', '', '2.000', '3847.00000', '7694.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060003', '4', '4246', '', '4.000', '6357.00000', '25429.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060003', '5', '3779', '', '1.000', '13990.00000', '13990.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060004', '1', '4247', '', '1.000', '7500.00000', '7500.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060005', '1', '4248', '', '1.000', '2520.00000', '2520.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060005', '2', '4249', '', '1.000', '5580.00000', '5580.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060006', '1', '4250', '', '1.000', '14500.00000', '14500.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060007', '1', '4261', '', '1.000', '14150.00000', '13443.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '5.000', '708.00', '0', '708');
INSERT INTO `pl_invoicedet_copy` VALUES ('060007', '2', '3984', '', '1.000', '1945.00000', '1848.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '5.000', '97.00', '0', '97');
INSERT INTO `pl_invoicedet_copy` VALUES ('060007', '3', '4214', '', '1.000', '680.00000', '646.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '5.000', '34.00', '0', '34');
INSERT INTO `pl_invoicedet_copy` VALUES ('060007', '4', '4084', '', '1.000', '4420.00000', '4111.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '7.000', '309.00', '0', '309');
INSERT INTO `pl_invoicedet_copy` VALUES ('060008', '1', '4253', '', '1.000', '4150.00000', '4150.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060008', '2', '4265', '', '1.000', '2950.00000', '2950.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060009', '1', '4273', '', '1.000', '3500.00000', '3500.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060010', '1', '4235', '', '1.000', '1100.00000', '1100.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060011', '1', '3826', '510', '1.000', '1150.00000', '1150.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060011', '2', '4276', '', '1.000', '10272.00000', '10272.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060011', '3', '4275', '', '1.000', '3964.00000', '3964.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060011', '4', '4274', '', '1.000', '5184.00000', '5184.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060012', '1', '4029', '', '1.000', '150.00000', '150.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060013', '1', '4271', '', '1.000', '12734.00000', '12734.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060014', '1', '4279', '', '1.000', '17340.00000', '17340.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060015', '1', '3975', '', '25.000', '270.00000', '6750.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060016', '1', '4243', '', '3.000', '1396.00000', '4189.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060016', '2', '3826', '510', '3.000', '1190.00000', '3570.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060017', '1', '4246', '', '1.000', '14958.00000', '14958.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060018', '1', '4029', '', '3.000', '330.00000', '990.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060019', '1', '4290', '', '1.000', '6609.00000', '6609.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060020', '1', '4036', '', '12.000', '80.00000', '960.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060021', '1', '3826', '510', '1.000', '1400.00000', '1400.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060022', '1', '4307', '', '2.000', '55.00000', '110.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060023', '1', '4308', '', '1.000', '350.00000', '350.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060024', '1', '4309', '', '1.000', '14150.00000', '13018.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '8.000', '1132.00', '0', '1132');
INSERT INTO `pl_invoicedet_copy` VALUES ('060024', '2', '4309', '', '2.000', '12785.00000', '23524.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '8.000', '2046.00', '0', '2046');
INSERT INTO `pl_invoicedet_copy` VALUES ('060025', '1', '4310', '', '1.000', '5500.00000', '5500.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060026', '1', '4311', '', '17.000', '825.00000', '14025.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('', '1', '4292', '', '1.000', '4136.00000', '4136.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('', '2', '4291', '', '1.000', '2464.00000', '2464.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('', '3', '3975', '', '6.000', '1140.00000', '6840.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('', '4', '4293', '', '2.000', '1400.00000', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('', '5', '4243', '', '2.000', '1641.00000', '3282.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060027', '1', '4292', '', '1.000', '4136.00000', '4136.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060027', '2', '4291', '', '1.000', '2464.00000', '2464.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060027', '3', '3975', '', '6.000', '1140.00000', '6840.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060027', '4', '4293', '', '2.000', '1400.00000', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060027', '5', '4243', '', '2.000', '1641.00000', '3282.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060028', '1', '4312', '', '40.000', '525.00000', '21000.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060029', '1', '3826', '510', '2.000', '1400.00000', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060030', '1', '4316', '', '1.000', '950.00000', '950.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060031', '1', '4319', '', '1.000', '3500.00000', '3500.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060032', '1', '4304', '', '6.000', '4868.00000', '29208.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060032', '2', '4303', '', '4.000', '1239.00000', '4956.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060033', '1', '4337', '', '1.000', '10424.00000', '10424.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060034', '1', '4331', '', '1.000', '19403.00000', '19403.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060035', '1', '4340', '', '1.000', '3175.00000', '3175.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060036', '1', '4332', '', '2.000', '14892.00000', '29784.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060036', '2', '4333', '', '2.000', '13140.00000', '26280.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060037', '1', '4029', '', '3.000', '350.00000', '1050.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet_copy` VALUES ('060038', '1', '4351', '', '1.000', '1739.00000', '1739.00', '', null, null, null, null, null, null, null, null, null, null, null, '02', '17', '0.000', null, '0', '0');

-- ----------------------------
-- Table structure for `pl_invoice_adv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice_adv`;
CREATE TABLE `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice_adv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice_copy`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice_copy`;
CREATE TABLE `pl_invoice_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice_copy
-- ----------------------------
INSERT INTO `pl_invoice_copy` VALUES ('060025', '2017-06-14', '1310000029', '0.00', '0.00', '5500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-17 11:29:21', '', '0001', '', '0.000', '', '', '5500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060024', '2017-06-14', '1310000033', '0.00', '0.00', '36542.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-17 11:27:54', '', '0001', '', '0.000', '', '', '36542.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060023', '2017-06-13', '1310000031', '0.00', '0.00', '350.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-17 11:30:18', '', '0001', '', '0.000', '', '', '350.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060022', '2017-06-13', '1310000', '0.00', '0.00', '110.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 11:10:09', '', '0001', '', '0.000', '', '', '110.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060021', '2017-06-13', '1310000028', '250.00', '0.00', '1150.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-17 11:31:07', '', '0001', '', '0.000', '', '', '1150.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060020', '2017-06-13', '1310000030', '0.00', '0.00', '960.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-17 11:31:42', '', '0001', '', '0.000', '', '', '960.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060019', '2017-06-12', '1310000', '1109.00', '0.00', '5500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 11:17:17', '', '0001', '', '0.000', '', '', '5500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060018', '2017-06-12', '1310000014', '0.00', '0.00', '990.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:53:21', '', '0001', '', '0.000', '', '', '990.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060017', '2017-06-12', '1310000006', '2543.00', '0.00', '12415.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:54:17', '', '0001', '', '0.000', '', '', '12415.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060016', '2017-06-12', '1310000028', '259.00', '0.00', '7500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:55:07', '', '0001', '', '0.000', '', '', '7500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060015', '2017-06-12', '1310000014', '0.00', '0.00', '6750.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:53:21', '', '0001', '', '0.000', '', '', '6750.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060014', '2017-06-08', '1310000027', '0.00', '0.00', '17340.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:56:00', '', '0001', '', '0.000', '', '', '17340.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060013', '2017-06-08', '1310000006', '2164.00', '0.00', '10570.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:54:17', '', '0001', '', '0.000', '', '', '10570.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060002', '2017-06-01', '1310000028', '2098.00', '0.00', '9550.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:55:07', '', '0001', '', '0.000', '', '', '9550.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060001', '2017-06-01', '1310000028', '0.00', '0.00', '10193.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:55:07', '', '0001', '', '0.000', '', '', '10193.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060012', '2017-06-07', '1310000034', '0.00', '0.00', '150.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:56:54', '', '0001', '', '0.000', '', '', '150.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060011', '2017-06-07', '1310000028', '685.00', '0.00', '19885.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:55:07', '', '0001', '', '0.000', '', '', '19885.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060010', '2017-06-06', '1310000035', '0.00', '230.00', '1330.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-19 17:06:48', '', '0001', '', '0.000', '', '', '1330.00', '', '', null, '02', '17', 'on', 'SILLA CONCEPT\'S', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060003', '2017-06-02', '1310000028', '60379.00', '0.00', '26130.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:55:07', '', '0001', '', '0.000', '', '', '26130.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060004', '2017-06-03', '1310000014', '0.00', '0.00', '7500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:53:21', '', '0001', '', '0.000', '', '', '7500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060005', '2017-06-03', '1310000014', '0.00', '0.00', '8100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:53:21', '', '0001', '', '0.000', '', '', '8100.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060006', '2017-06-03', '1310000018', '0.00', '0.00', '14500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:59:43', '', '0001', '', '0.000', '', '', '14500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '14500');
INSERT INTO `pl_invoice_copy` VALUES ('060007', '2017-06-05', '1310000033', '277.00', '0.00', '19770.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 18:00:30', '', '0001', '', '0.000', '', '', '19770.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060008', '2017-06-05', '1310000006', '710.00', '0.00', '6390.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 17:54:17', '', '0001', '', '0.000', '', '', '6390.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060009', '2017-06-06', '1310000034', '0.00', '0.00', '3500.00', null, null, null, null, null, null, '815', null, null, null, null, null, '01', null, '2017-06-16 17:56:54', '', '0001', '', '0.000', '', '', '3500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060026', '2017-06-14', '1310000034', '25.00', '0.00', '14000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 12:25:58', '', '0001', '', '0.000', '', '', '14000.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060027', '2017-06-14', '1310000006', '2192.00', '0.00', '17330.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 12:47:23', '', '0001', '', '0.000', '', '', '17330.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060028', '2017-06-15', '1310000034', '0.00', '0.00', '21000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-16 18:06:26', '', '0001', '', '0.000', '', '', '21000.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060029', '2017-06-17', '1310000006', '476.00', '0.00', '2324.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-19 10:43:46', '', '0001', '', '0.000', '', '', '2324.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060030', '2017-06-17', '2610000042', '0.00', '0.00', '950.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-19 11:07:41', '', '0001', '', '0.000', '', '', '950.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060031', '2017-06-17', '2610000043', '0.00', '0.00', '3500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-19 11:10:49', '', '0001', '', '0.000', '', '', '3500.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060032', '2017-06-20', '1310000006', '5804.00', '0.00', '28360.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-21 10:26:11', '', '0001', '', '0.000', '', '', '28360.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060033', '2017-06-21', '1310000028', '1824.00', '0.00', '8600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-22 10:20:00', '', '0001', '', '0.000', '', '', '8600.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060034', '2017-06-21', '1310000006', '3403.00', '0.00', '16000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-22 10:27:07', '', '0001', '', '0.000', '', '', '16000.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060035', '2017-06-22', '1310000006', '475.00', '0.00', '2700.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-23 10:33:09', '', '0001', '', '0.000', '', '', '2700.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060036', '2017-06-22', '1310000006', '4.00', '0.00', '56060.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-23 10:35:08', '', '0001', '', '0.000', '', '', '56060.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060037', '2017-06-22', '1310000014', '50.00', '0.00', '1000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-23 10:36:01', '', '0001', '', '0.000', '', '', '1000.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');
INSERT INTO `pl_invoice_copy` VALUES ('060038', '2017-06-23', '1310000028', '59.00', '0.00', '1680.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-06-24 11:26:51', '', '0001', '', '0.000', '', '', '1680.00', '', '', null, '02', '17', 'on', '', '', '0', '0', '', '', '', '', '0');

-- ----------------------------
-- Table structure for `pl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jv`;
CREATE TABLE `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet`;
CREATE TABLE `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet_inst`;
CREATE TABLE `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_order`
-- ----------------------------
DROP TABLE IF EXISTS `pl_order`;
CREATE TABLE `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `po_no` varchar(30) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `disc_amt` decimal(15,2) DEFAULT NULL,
  `dc_amt` decimal(15,2) DEFAULT NULL,
  `loc_id` char(2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `sp_id` varchar(7) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `service` char(2) DEFAULT NULL,
  `ut` char(2) DEFAULT NULL,
  `adv_amt` decimal(15,2) DEFAULT NULL,
  `net_amt` decimal(15,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `pl_order_fk_year_id` (`year_id`),
  KEY `pl_order_fk_comp_id` (`comp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_orderdet`;
CREATE TABLE `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` decimal(6,3) DEFAULT NULL,
  `stax` decimal(15,2) DEFAULT NULL,
  `stax_rate` decimal(15,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `sed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`),
  KEY `pl_orderdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `pl_pay`;
CREATE TABLE `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet`;
CREATE TABLE `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet_inst`;
CREATE TABLE `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `pl_payment`;
CREATE TABLE `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paymentdet`;
CREATE TABLE `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_po`;
CREATE TABLE `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_podet`;
CREATE TABLE `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receipt`;
CREATE TABLE `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet`;
CREATE TABLE `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_acct`;
CREATE TABLE `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_inv`;
CREATE TABLE `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_po`;
CREATE TABLE `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_return`
-- ----------------------------
DROP TABLE IF EXISTS `pl_return`;
CREATE TABLE `pl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_return
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_returndet`;
CREATE TABLE `pl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship`;
CREATE TABLE `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_shipdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_shipdet`;
CREATE TABLE `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_shipdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship_inv`;
CREATE TABLE `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `po`
-- ----------------------------
DROP TABLE IF EXISTS `po`;
CREATE TABLE `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po
-- ----------------------------

-- ----------------------------
-- Table structure for `podet`
-- ----------------------------
DROP TABLE IF EXISTS `podet`;
CREATE TABLE `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of podet
-- ----------------------------

-- ----------------------------
-- Table structure for `po_type`
-- ----------------------------
DROP TABLE IF EXISTS `po_type`;
CREATE TABLE `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po_type
-- ----------------------------
INSERT INTO `po_type` VALUES ('01', 'Ex Works');

-- ----------------------------
-- Table structure for `process`
-- ----------------------------
DROP TABLE IF EXISTS `process`;
CREATE TABLE `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of process
-- ----------------------------
INSERT INTO `process` VALUES ('1', 'Mixing');

-- ----------------------------
-- Table structure for `prod`
-- ----------------------------
DROP TABLE IF EXISTS `prod`;
CREATE TABLE `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod
-- ----------------------------

-- ----------------------------
-- Table structure for `proddet`
-- ----------------------------
DROP TABLE IF EXISTS `proddet`;
CREATE TABLE `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of proddet
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_batch`
-- ----------------------------
DROP TABLE IF EXISTS `prod_batch`;
CREATE TABLE `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_batch
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_brand`
-- ----------------------------
DROP TABLE IF EXISTS `prod_brand`;
CREATE TABLE `prod_brand` (
  `BRAND_ID` varchar(6) NOT NULL,
  `BRAND_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`BRAND_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_brand
-- ----------------------------
INSERT INTO `prod_brand` VALUES ('01', 'Local', null, null, null);
INSERT INTO `prod_brand` VALUES ('02', 'China', null, null, null);
INSERT INTO `prod_brand` VALUES ('03', 'SONEX', null, null, null);
INSERT INTO `prod_brand` VALUES ('04', 'GROHE', null, null, null);
INSERT INTO `prod_brand` VALUES ('05', 'GROHE CHI', null, null, null);
INSERT INTO `prod_brand` VALUES ('06', 'CLASSIC', null, null, null);
INSERT INTO `prod_brand` VALUES ('07', 'OTHERS', null, null, null);
INSERT INTO `prod_brand` VALUES ('08', 'JAGUAR', null, null, null);

-- ----------------------------
-- Table structure for `prod_cat`
-- ----------------------------
DROP TABLE IF EXISTS `prod_cat`;
CREATE TABLE `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_cat
-- ----------------------------
INSERT INTO `prod_cat` VALUES ('01', 'Local Item', null, null, null);
INSERT INTO `prod_cat` VALUES ('02', 'Imported Item', null, null, null);

-- ----------------------------
-- Table structure for `prod_comp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_comp`;
CREATE TABLE `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_comp
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_grp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_grp`;
CREATE TABLE `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_grp
-- ----------------------------
INSERT INTO `prod_grp` VALUES ('01', 'Group Name');

-- ----------------------------
-- Table structure for `prod_rm_date`
-- ----------------------------
DROP TABLE IF EXISTS `prod_rm_date`;
CREATE TABLE `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_rm_date
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_type`
-- ----------------------------
DROP TABLE IF EXISTS `prod_type`;
CREATE TABLE `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_type
-- ----------------------------
INSERT INTO `prod_type` VALUES ('01', 'Franchise Group', '0700100001', '0500030003', '0800010101');

-- ----------------------------
-- Table structure for `regions`
-- ----------------------------
DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
  `reg_id` varchar(6) NOT NULL DEFAULT '',
  `REG_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`reg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of regions
-- ----------------------------
INSERT INTO `regions` VALUES ('1', 'Punjab (Province)');

-- ----------------------------
-- Table structure for `replanishment`
-- ----------------------------
DROP TABLE IF EXISTS `replanishment`;
CREATE TABLE `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of replanishment
-- ----------------------------

-- ----------------------------
-- Table structure for `report`
-- ----------------------------
DROP TABLE IF EXISTS `report`;
CREATE TABLE `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report
-- ----------------------------
INSERT INTO `report` VALUES ('2010-11-25', '2015-11-25');

-- ----------------------------
-- Table structure for `reports`
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`REP_ID`),
  UNIQUE KEY `REPORTS_PK11109972190599` (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports
-- ----------------------------
INSERT INTO `reports` VALUES ('trial_balance', 'Trial Balance', '1', '', '001');
INSERT INTO `reports` VALUES ('daybook', 'Daybook', '1', 'Y', '002');
INSERT INTO `reports` VALUES ('ledger', 'Ledger', '1', 'N', '003');
INSERT INTO `reports` VALUES ('profit_loss', 'Profit & Loss', '1', 'N', '004');
INSERT INTO `reports` VALUES ('chart', 'Chart of Accounts', '1', 'N', '005');
INSERT INTO `reports` VALUES ('balancesheet', 'Balance Sheet', '1', 'N', '006');
INSERT INTO `reports` VALUES ('daybook_kt', 'Daybook (KT)', '1', 'Y', '007');
INSERT INTO `reports` VALUES ('pdf_sl_due_invoices', 'Due Invoices', '2', '', '009');
INSERT INTO `reports` VALUES ('pf_sl_supply_register', 'Supply Register', '2', '', '010');
INSERT INTO `reports` VALUES ('report_current_stock', 'Current Stock', '2', '', '011');
INSERT INTO `reports` VALUES ('report_sale?report=PL', 'Day Book', '3', '', '012');
INSERT INTO `reports` VALUES ('report_sale?report=ST', 'Day Book', '4', '', '013');
INSERT INTO `reports` VALUES ('stock_ledger', 'Stock Ledger', '4', '', '014');
INSERT INTO `reports` VALUES ('stock_summary', 'Stock Summary', '4', '', '015');
INSERT INTO `reports` VALUES ('smart_stock', 'Smart Stock', '4', '', '016');
INSERT INTO `reports` VALUES ('report_sale?report=SL', 'Day Book', '2', '', '017');
INSERT INTO `reports` VALUES ('cashbook', 'Cash Book', '1', '', '018');
INSERT INTO `reports` VALUES ('report_sales', 'Sale Report', '2', 'Y', '019');
INSERT INTO `reports` VALUES ('kt_cashbook', 'Cashbook-KT', '1', 'Y', '022');

-- ----------------------------
-- Table structure for `reports_all`
-- ----------------------------
DROP TABLE IF EXISTS `reports_all`;
CREATE TABLE `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports_all
-- ----------------------------
INSERT INTO `reports_all` VALUES ('accountsummary', 'Account Summary', '1', 'N');

-- ----------------------------
-- Table structure for `report_brands`
-- ----------------------------
DROP TABLE IF EXISTS `report_brands`;
CREATE TABLE `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_brands
-- ----------------------------
INSERT INTO `report_brands` VALUES ('1301', '1202', '1103', '1102', null);

-- ----------------------------
-- Table structure for `report_cat`
-- ----------------------------
DROP TABLE IF EXISTS `report_cat`;
CREATE TABLE `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `report_comp`
-- ----------------------------
DROP TABLE IF EXISTS `report_comp`;
CREATE TABLE `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_comp
-- ----------------------------
INSERT INTO `report_comp` VALUES ('01');

-- ----------------------------
-- Table structure for `report_cs`
-- ----------------------------
DROP TABLE IF EXISTS `report_cs`;
CREATE TABLE `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cs
-- ----------------------------

-- ----------------------------
-- Table structure for `report_div`
-- ----------------------------
DROP TABLE IF EXISTS `report_div`;
CREATE TABLE `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_div
-- ----------------------------

-- ----------------------------
-- Table structure for `report_party`
-- ----------------------------
DROP TABLE IF EXISTS `report_party`;
CREATE TABLE `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_party
-- ----------------------------
INSERT INTO `report_party` VALUES ('0063');

-- ----------------------------
-- Table structure for `report_sp`
-- ----------------------------
DROP TABLE IF EXISTS `report_sp`;
CREATE TABLE `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_sp
-- ----------------------------

-- ----------------------------
-- Table structure for `season_cat`
-- ----------------------------
DROP TABLE IF EXISTS `season_cat`;
CREATE TABLE `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of season_cat
-- ----------------------------
INSERT INTO `season_cat` VALUES ('010101', 'WINTER');
INSERT INTO `season_cat` VALUES ('010102', 'SUMMER');

-- ----------------------------
-- Table structure for `size`
-- ----------------------------
DROP TABLE IF EXISTS `size`;
CREATE TABLE `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of size
-- ----------------------------
INSERT INTO `size` VALUES ('08', 'S');
INSERT INTO `size` VALUES ('09', 'M');
INSERT INTO `size` VALUES ('10', 'L');
INSERT INTO `size` VALUES ('11', 'XL');

-- ----------------------------
-- Table structure for `sl_am_con`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_con`;
CREATE TABLE `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_con
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_condet`;
CREATE TABLE `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_cont`
-- ----------------------------
DROP TABLE IF EXISTS `sl_cont`;
CREATE TABLE `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_cont
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contdet`;
CREATE TABLE `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contmaint`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contmaint`;
CREATE TABLE `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contmaint
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contpay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contpay`;
CREATE TABLE `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contpay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc`;
CREATE TABLE `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `order_id` varchar(10) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet`;
CREATE TABLE `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_dcdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_copy`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_copy`;
CREATE TABLE `sl_dcdet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_copy
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_ser`;
CREATE TABLE `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtn`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtn`;
CREATE TABLE `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtn
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet`;
CREATE TABLE `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet_ser`;
CREATE TABLE `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gp`;
CREATE TABLE `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_gp` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gpdet`;
CREATE TABLE `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(11,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_gpdet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice`;
CREATE TABLE `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) DEFAULT NULL,
  `order_id` varchar(10) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet`;
CREATE TABLE `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,2) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoice_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedetapp`;
CREATE TABLE `sl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedet_bon`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet_bon`;
CREATE TABLE `sl_invoicedet_bon` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet_bon
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice_rec`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice_rec`;
CREATE TABLE `sl_invoice_rec` (
  `REC_ID` varchar(7) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice_rec
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jv`;
CREATE TABLE `sl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jvdet`;
CREATE TABLE `sl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jvdet_inst`;
CREATE TABLE `sl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_order`
-- ----------------------------
DROP TABLE IF EXISTS `sl_order`;
CREATE TABLE `sl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `po_no` varchar(10) NOT NULL DEFAULT '',
  `po_date` date DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `sl_order_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_orderdet`;
CREATE TABLE `sl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`),
  KEY `sl_orderdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_party_add`
-- ----------------------------
DROP TABLE IF EXISTS `sl_party_add`;
CREATE TABLE `sl_party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_pay`;
CREATE TABLE `sl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) DEFAULT '',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(10) DEFAULT '',
  `other_id_2` varchar(10) DEFAULT '',
  `other_id_3` varchar(10) DEFAULT '',
  `itax_id` varchar(10) DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paydet`;
CREATE TABLE `sl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paydet_inst`;
CREATE TABLE `sl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `sl_payment`;
CREATE TABLE `sl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) NOT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(100) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paymentdet`;
CREATE TABLE `sl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_po`
-- ----------------------------
DROP TABLE IF EXISTS `sl_po`;
CREATE TABLE `sl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_podet`;
CREATE TABLE `sl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `BONUS_QTY` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product`;
CREATE TABLE `sl_product` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `O_QTY` decimal(10,3) DEFAULT NULL,
  `O_RATE` decimal(10,2) DEFAULT NULL,
  `CAT_ID` varchar(6) NOT NULL,
  `TYPE_ID` varchar(10) NOT NULL,
  `BATCHWISE` varchar(1) NOT NULL,
  `REG_NO` varchar(10) DEFAULT NULL,
  `PACK_SIZE` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) NOT NULL,
  `P_RATE` decimal(10,2) DEFAULT NULL,
  `TYPE_GRP` varchar(1) NOT NULL,
  `PACK_RATE` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(10,3) NOT NULL,
  `ALL_CUST` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `GRP_ID` varchar(2) NOT NULL,
  `MOL_QTY` decimal(10,3) DEFAULT NULL,
  `MOL` varchar(1) DEFAULT NULL,
  `OLD_CODE` varchar(9) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PART_NO` varchar(30) DEFAULT NULL,
  `SAMPL_ID` varchar(4) DEFAULT NULL,
  `SAMPLE_ID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_products_log`
-- ----------------------------
DROP TABLE IF EXISTS `sl_products_log`;
CREATE TABLE `sl_products_log` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `POST_DATE` datetime NOT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_products_log
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product_brand`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product_brand`;
CREATE TABLE `sl_product_brand` (
  `PROD_ID` varchar(4) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product_brand
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product_rm`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product_rm`;
CREATE TABLE `sl_product_rm` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(13,6) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `RM_ID` varchar(4) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product_rm
-- ----------------------------
INSERT INTO `sl_product_rm` VALUES ('0356', '0.000310', '1', '0027', '01');

-- ----------------------------
-- Table structure for `sl_quote`
-- ----------------------------
DROP TABLE IF EXISTS `sl_quote`;
CREATE TABLE `sl_quote` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(10,2) NOT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(5) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_quote
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_quotedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_quotedet`;
CREATE TABLE `sl_quotedet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `UNIT_RATE` decimal(10,3) NOT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,0) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_quotedet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receipt`;
CREATE TABLE `sl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet`;
CREATE TABLE `sl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet_acct`;
CREATE TABLE `sl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet_inv`;
CREATE TABLE `sl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_return`
-- ----------------------------
DROP TABLE IF EXISTS `sl_return`;
CREATE TABLE `sl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_return_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_return
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_returndet`;
CREATE TABLE `sl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_sa`
-- ----------------------------
DROP TABLE IF EXISTS `sl_sa`;
CREATE TABLE `sl_sa` (
  `SA_ID` varchar(5) NOT NULL,
  `SA_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_sa
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_sadet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_sadet`;
CREATE TABLE `sl_sadet` (
  `SA_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `AMOUNT` decimal(10,0) NOT NULL,
  `SP_ID` varchar(4) NOT NULL,
  `DIV_ID` varchar(2) NOT NULL,
  `CITY_ID` varchar(2) NOT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_sadet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_wo`
-- ----------------------------
DROP TABLE IF EXISTS `sl_wo`;
CREATE TABLE `sl_wo` (
  `WO_ID` varchar(5) NOT NULL,
  `WO_DATE` datetime NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `WO_NAME` varchar(50) DEFAULT NULL,
  `DIV_ID` varchar(2) DEFAULT NULL,
  `CITY_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`WO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_wo
-- ----------------------------

-- ----------------------------
-- Table structure for `sp`
-- ----------------------------
DROP TABLE IF EXISTS `sp`;
CREATE TABLE `sp` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sp
-- ----------------------------
INSERT INTO `sp` VALUES ('0001', 'Shahid Sheikh', null, '02');
INSERT INTO `sp` VALUES ('0019', 'WAQAR', null, '02');
INSERT INTO `sp` VALUES ('0009', 'Atif', null, '01');
INSERT INTO `sp` VALUES ('0018', 'NADEEM', null, '01');
INSERT INTO `sp` VALUES ('0007', 'WALEED', null, '01');
INSERT INTO `sp` VALUES ('0006', 'WAQAS', null, '01');
INSERT INTO `sp` VALUES ('0005', 'Yaseen', null, '01');
INSERT INTO `sp` VALUES ('0004', 'Salman', null, '01');
INSERT INTO `sp` VALUES ('0003', 'Rashid', null, '02');
INSERT INTO `sp` VALUES ('0002', 'Sarosh Ch', null, '01');
INSERT INTO `sp` VALUES ('0011', 'Hafiz Azeem', null, '01');
INSERT INTO `sp` VALUES ('0012', 'Bilawal', null, '01');
INSERT INTO `sp` VALUES ('0013', 'Mubashar', null, '01');
INSERT INTO `sp` VALUES ('0014', 'HASEEB', null, '02');
INSERT INTO `sp` VALUES ('0015', 'MURTAZA', null, '02');
INSERT INTO `sp` VALUES ('0016', 'BABAR', null, '02');
INSERT INTO `sp` VALUES ('0017', 'DEALER', null, '01');
INSERT INTO `sp` VALUES ('0020', 'NASIR', null, '02');
INSERT INTO `sp` VALUES ('0021', 'TAYYEB', null, '01');
INSERT INTO `sp` VALUES ('0022', 'AMMAR', null, '01');
INSERT INTO `sp` VALUES ('0023', 'HAMEED', null, '01');
INSERT INTO `sp` VALUES ('0024', 'IRFAN', null, '01');
INSERT INTO `sp` VALUES ('0025', 'NAVEED ELECTRTION', null, '01');
INSERT INTO `sp` VALUES ('0026', 'AHMED', null, '01');

-- ----------------------------
-- Table structure for `sp_party`
-- ----------------------------
DROP TABLE IF EXISTS `sp_party`;
CREATE TABLE `sp_party` (
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `lineitem` varchar(4) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`sp_id`,`party_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sp_party
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_cat`
-- ----------------------------
DROP TABLE IF EXISTS `stk_cat`;
CREATE TABLE `stk_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_collection`
-- ----------------------------
DROP TABLE IF EXISTS `stk_collection`;
CREATE TABLE `stk_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_collection
-- ----------------------------
INSERT INTO `stk_collection` VALUES ('010101', 'Men');
INSERT INTO `stk_collection` VALUES ('010102', 'Gold');

-- ----------------------------
-- Table structure for `stk_con`
-- ----------------------------
DROP TABLE IF EXISTS `stk_con`;
CREATE TABLE `stk_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` bigint(10) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_con` (`voucher_id`,`bill_no`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_con
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_condet`
-- ----------------------------
DROP TABLE IF EXISTS `stk_condet`;
CREATE TABLE `stk_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_condet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `system`
-- ----------------------------
DROP TABLE IF EXISTS `system`;
CREATE TABLE `system` (
  `comp_name` varchar(100) NOT NULL DEFAULT '',
  `cash_id` varchar(10) NOT NULL DEFAULT '',
  `bank_id` varchar(10) NOT NULL DEFAULT '',
  `creditor_id` varchar(10) DEFAULT '1601999',
  `stax_id` varchar(10) DEFAULT '2201001',
  `dc_id` varchar(10) DEFAULT '5302005',
  `disc_id` varchar(10) DEFAULT '5107001',
  `debtor_id` varchar(10) DEFAULT '4201999',
  `adv_id` varchar(10) DEFAULT '4201999',
  `db_id` varchar(10) DEFAULT '4201999',
  `ret_id` varchar(10) DEFAULT '4201999',
  `sec_id` varchar(10) DEFAULT '4201999',
  `stax_id_sl` varchar(10) DEFAULT '2201001',
  `dc_id_sl` varchar(10) DEFAULT '5302005',
  `disc_id_sl` varchar(10) DEFAULT '5107001',
  `adv_id_sl` varchar(10) DEFAULT '4201999',
  `db_id_sl` varchar(10) DEFAULT '4201999',
  `ret_id_sl` varchar(10) DEFAULT '4201999',
  `sec_id_sl` varchar(10) DEFAULT '4201999',
  `stock_id` varchar(10) DEFAULT '4201999',
  `turnover_id` varchar(10) DEFAULT '3010000001',
  `cogs_id` varchar(10) DEFAULT '3020000001',
  `sed_id` varchar(10) DEFAULT NULL,
  `sed_id_sl` varchar(10) DEFAULT NULL,
  `hide_taxes` char(1) DEFAULT NULL,
  `date_from` date DEFAULT '2009-07-01',
  `date_to` date DEFAULT '2010-06-30',
  `ait_id` varchar(10) DEFAULT NULL,
  `cdi_id` varchar(10) DEFAULT NULL,
  `date_close` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) DEFAULT 'support@clicksoft.org',
  `qty_decimal` int(11) DEFAULT '0',
  `fed_id` varchar(10) DEFAULT NULL,
  `fed_id_sl` varchar(10) DEFAULT NULL,
  `stock_transfer_id` varchar(10) DEFAULT NULL,
  `login_page` varchar(30) NOT NULL,
  `sale_form` varchar(30) NOT NULL,
  `qty_decimals` int(1) DEFAULT '0',
  PRIMARY KEY (`comp_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of system
-- ----------------------------
INSERT INTO `system` VALUES ('Kamraj Enterprises', '271000', '272000', '131000', '3011000001', '5010000001', '2210000004', '261000', '1001001', '5010000001', '1001001', '1001001', '3011000001', '3020000010', '3010000010', '4201', '3020000010', '4201', '4201', '221000', '3010000001', '3020000001', '3011000005', '3011000005', '', '2011-07-01', '2012-06-30', '2530000002', '4060000005', '2017-09-21', 'accounts@rakcorporation.com,support@clicksoft.com.pk', '3', '3011000004', '3011000004', '2210000002', 'bk', '', '0');

-- ----------------------------
-- Table structure for `tf`
-- ----------------------------
DROP TABLE IF EXISTS `tf`;
CREATE TABLE `tf` (
  `INV_ID` varchar(5) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `PACK_SIZE` varchar(30) DEFAULT NULL,
  `PACK_QTY` decimal(10,2) DEFAULT NULL,
  `UNIT_QTY` decimal(10,2) DEFAULT NULL,
  `STD_WT` decimal(15,5) DEFAULT NULL,
  `UNIT_WT` decimal(15,5) DEFAULT NULL,
  `BATCH_MONTH` varchar(10) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `INACTIVE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tf
-- ----------------------------
INSERT INTO `tf` VALUES ('00140', null, '0001', '', '', '', '2015-12-28 00:00:00', '1*1', '1.00', '222.00', '0.00000', null, null, null, null);

-- ----------------------------
-- Table structure for `tfdet`
-- ----------------------------
DROP TABLE IF EXISTS `tfdet`;
CREATE TABLE `tfdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(15,5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `DONT_INCLUDE` varchar(1) NOT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `LL_P` decimal(6,3) DEFAULT NULL,
  `LL_QTY` decimal(15,5) DEFAULT NULL,
  `QTY` decimal(15,5) DEFAULT NULL,
  `REQ_QTY` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tfdet
-- ----------------------------
INSERT INTO `tfdet` VALUES ('00141', '1', null, '0', null, '', '', '', '', null, null, null, '0.00000', null);

-- ----------------------------
-- Table structure for `trans`
-- ----------------------------
DROP TABLE IF EXISTS `trans`;
CREATE TABLE `trans` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of trans
-- ----------------------------
INSERT INTO `trans` VALUES ('00001', '2015-08-08 00:00:00', '01', '15', 'inam', '01', 'N', null);

-- ----------------------------
-- Table structure for `transdet`
-- ----------------------------
DROP TABLE IF EXISTS `transdet`;
CREATE TABLE `transdet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `REMARKS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of transdet
-- ----------------------------
INSERT INTO `transdet` VALUES ('00001', '1', '0394', '332.000', null, '15D523', null, '01', '15', '02', null, 'Nearest Exipry Date 30-09-15');

-- ----------------------------
-- Table structure for `tt`
-- ----------------------------
DROP TABLE IF EXISTS `tt`;
CREATE TABLE `tt` (
  `v_id` int(11) NOT NULL AUTO_INCREMENT,
  `v_date` date DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `comp_name` varchar(100) DEFAULT NULL,
  `debit_amount` int(15) DEFAULT NULL,
  `credit_amount` int(15) DEFAULT NULL,
  `ref_no` varchar(250) DEFAULT NULL,
  `acct_type` varchar(250) DEFAULT NULL,
  `remarks` text,
  `opening_balance` int(15) DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tt
-- ----------------------------

-- ----------------------------
-- Table structure for `type`
-- ----------------------------
DROP TABLE IF EXISTS `type`;
CREATE TABLE `type` (
  `type_id` varchar(6) NOT NULL DEFAULT '',
  `type_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of type
-- ----------------------------
INSERT INTO `type` VALUES ('0002', 'KHUSSA');
INSERT INTO `type` VALUES ('0003', 'SEMI FORMAL');
INSERT INTO `type` VALUES ('0004', 'FORMAL');
INSERT INTO `type` VALUES ('0005', 'CASUAL');

-- ----------------------------
-- Table structure for `units`
-- ----------------------------
DROP TABLE IF EXISTS `units`;
CREATE TABLE `units` (
  `unit` char(3) NOT NULL DEFAULT '',
  `unit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of units
-- ----------------------------
INSERT INTO `units` VALUES ('Bag', 'Bags');
INSERT INTO `units` VALUES ('Bot', 'Bottle');
INSERT INTO `units` VALUES ('Bun', 'Bundle');
INSERT INTO `units` VALUES ('Coi', 'Coil');
INSERT INTO `units` VALUES ('Dru', 'Drum');
INSERT INTO `units` VALUES ('Dzn', 'Dzn');
INSERT INTO `units` VALUES ('Ft', 'Ft');
INSERT INTO `units` VALUES ('Gln', 'Gln');
INSERT INTO `units` VALUES ('Grm', 'Grams');
INSERT INTO `units` VALUES ('Kg', 'Kg');
INSERT INTO `units` VALUES ('Ltr', 'Liter');
INSERT INTO `units` VALUES ('Mtr', 'Mtr');
INSERT INTO `units` VALUES ('Nos', 'Nos');
INSERT INTO `units` VALUES ('Pai', 'Pairs');
INSERT INTO `units` VALUES ('Pcs', 'Pices');
INSERT INTO `units` VALUES ('Pkt', 'Pkt');
INSERT INTO `units` VALUES ('Qtr', 'Qtr');
INSERT INTO `units` VALUES ('Rft', 'Rft');
INSERT INTO `units` VALUES ('Rim', 'Rim');
INSERT INTO `units` VALUES ('Rol', 'Roll');
INSERT INTO `units` VALUES ('Set', 'Set');
INSERT INTO `units` VALUES ('Sqf', 'Sqft');
INSERT INTO `units` VALUES ('Tin', 'Tin');
INSERT INTO `units` VALUES ('Tro', 'Trolly');
INSERT INTO `units` VALUES ('Tru', 'Truck');
INSERT INTO `units` VALUES ('MT', 'M.Tons');
INSERT INTO `units` VALUES ('100', 'baggage');
INSERT INTO `units` VALUES ('Guz', 'GUZZ');

-- ----------------------------
-- Table structure for `users`
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `EMP_ID` varchar(20) NOT NULL,
  `EMP_NAME` varchar(40) NOT NULL,
  `PASSWORD` varchar(20) DEFAULT NULL,
  `AUTH_ID` varchar(1) NOT NULL,
  `USE_FORM` varchar(1) DEFAULT NULL,
  `USE_REP` varchar(1) DEFAULT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `PK_BILL_NO_FROM` varchar(4) DEFAULT NULL,
  `PK_BILL_NO_TO` varchar(4) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `VOUCHER_TYPE` varchar(2) DEFAULT NULL,
  `POST` varchar(1) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `u_session_id` decimal(65,30) DEFAULT NULL,
  `inactive` char(1) NOT NULL,
  PRIMARY KEY (`EMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('admin', 'Admin', '123', '9', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null, '');
INSERT INTO `users` VALUES ('click', 'ClickSoft (Pvt) Ltd', '124', '9', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null, '');
INSERT INTO `users` VALUES ('haseeb', 'Haseeb Muhammad', '123', '9', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null, '');

-- ----------------------------
-- Table structure for `users_comp`
-- ----------------------------
DROP TABLE IF EXISTS `users_comp`;
CREATE TABLE `users_comp` (
  `EMP_ID` varchar(20) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `inactive` char(1) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_comp
-- ----------------------------
INSERT INTO `users_comp` VALUES ('Amaan', '01', null, '');
INSERT INTO `users_comp` VALUES ('atif', '01', null, '');
INSERT INTO `users_comp` VALUES ('babar', '01', null, '');
INSERT INTO `users_comp` VALUES ('babar', '02', null, '');
INSERT INTO `users_comp` VALUES ('click', '01', null, '');
INSERT INTO `users_comp` VALUES ('click', '02', null, '');
INSERT INTO `users_comp` VALUES ('irfan', '01', null, '');
INSERT INTO `users_comp` VALUES ('nadeem', '03', null, '');
INSERT INTO `users_comp` VALUES ('waqas', '01', null, '');

-- ----------------------------
-- Table structure for `users_menu`
-- ----------------------------
DROP TABLE IF EXISTS `users_menu`;
CREATE TABLE `users_menu` (
  `emp_id` varchar(20) NOT NULL DEFAULT '',
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `inactive` char(2) NOT NULL DEFAULT '',
  `insert_allowed` char(1) NOT NULL DEFAULT 'N',
  `update_allowed` char(1) NOT NULL DEFAULT 'N',
  `delete_allowed` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`emp_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_menu
-- ----------------------------
INSERT INTO `users_menu` VALUES ('Amaan', '1', '', '', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '1.7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '2.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '2.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '2.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '2.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '2.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '3.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '3.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '4.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '4.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '5.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '5.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '5.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('Amaan', '6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '6.7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '7.7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '8', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '8.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '8.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '9', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '9.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '9.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('Amaan', '9.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1', 'Y', 'Y', '', '');
INSERT INTO `users_menu` VALUES ('atif', '1.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1.4', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1.5', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1.6', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '1.7', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2.3', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2.4', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2.5', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '2.6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '3.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '3.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '4', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '4.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '4.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '5', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '5.1', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '5.2', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('atif', '5.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '5.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('atif', '5.5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '5.6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.1', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.3', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.4', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.5', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.6', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '6.7', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.1', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.3', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.4', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.5', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.6', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '7.7', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '8', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '8.1', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '8.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '9', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '9.1', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '9.2', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('atif', '9.3', 'Y', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '1.7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '2.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '2.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '2.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '2.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '2.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '3.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '3.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '4.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '4.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '5.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('babar', '5.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('babar', '5.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('babar', '6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '6.7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.4', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.5', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.6', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '7.7', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '8', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '8.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '8.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '9', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '9.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '9.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('babar', '9.3', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('bt', '2.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('click', '1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('farooq', '1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('farooq', '1.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('farooq', '1.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('it', '2.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kafeel', '1.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '3.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '3.2', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '4.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('nadeem', '2.1', '', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('nadeem', '2.4', '', 'N', 'N', 'N');

-- ----------------------------
-- Table structure for `users_mod`
-- ----------------------------
DROP TABLE IF EXISTS `users_mod`;
CREATE TABLE `users_mod` (
  `EMP_ID` varchar(6) NOT NULL,
  `VOUCHER_TYPE` varchar(20) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_mod
-- ----------------------------
INSERT INTO `users_mod` VALUES ('Abid', 'PL_INVOICE');

-- ----------------------------
-- Table structure for `users_rep`
-- ----------------------------
DROP TABLE IF EXISTS `users_rep`;
CREATE TABLE `users_rep` (
  `EMP_ID` varchar(6) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`REP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_rep
-- ----------------------------
INSERT INTO `users_rep` VALUES ('abid', '068');
INSERT INTO `users_rep` VALUES ('click', '019');

-- ----------------------------
-- Table structure for `user_mod`
-- ----------------------------
DROP TABLE IF EXISTS `user_mod`;
CREATE TABLE `user_mod` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_CP',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_mod
-- ----------------------------

-- ----------------------------
-- Table structure for `user_profile`
-- ----------------------------
DROP TABLE IF EXISTS `user_profile`;
CREATE TABLE `user_profile` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `user_name` varchar(50) DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '123',
  `desig_id` varchar(30) DEFAULT '',
  `div_name` varchar(30) DEFAULT '',
  `sec_lvl` char(1) DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_profile
-- ----------------------------
INSERT INTO `user_profile` VALUES ('HEAD OFFICE', 'HEAD OFFICE', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('02-admin', 'EQUATOR', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('03-admin', 'Wapda Town', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('04-admin', 'Studio Mir - Gujranwala', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('05-admin', 'Dreams - M.M.Alam', '123', '', '', '0');

-- ----------------------------
-- Table structure for `user_rep`
-- ----------------------------
DROP TABLE IF EXISTS `user_rep`;
CREATE TABLE `user_rep` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_10',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_rep
-- ----------------------------

-- ----------------------------
-- Table structure for `vehicle_type`
-- ----------------------------
DROP TABLE IF EXISTS `vehicle_type`;
CREATE TABLE `vehicle_type` (
  `vehicle_id` varchar(4) NOT NULL,
  `vehicle_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`vehicle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of vehicle_type
-- ----------------------------
INSERT INTO `vehicle_type` VALUES ('0001', 'MAZDA');
INSERT INTO `vehicle_type` VALUES ('0002', 'PICK UP');

-- ----------------------------
-- Table structure for `voucher`
-- ----------------------------
DROP TABLE IF EXISTS `voucher`;
CREATE TABLE `voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `voucher_date` date DEFAULT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `POSTED` char(2) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `UPD_DATE` datetime DEFAULT NULL,
  `UPD_EMP_ID` varchar(8) DEFAULT NULL,
  `ACCT_ID_CS_1` char(10) DEFAULT NULL,
  `ACCT_ID_CS_2` char(10) DEFAULT NULL,
  `BILTY_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`),
  KEY `voucher_fk_year_id` (`YEAR_ID`),
  CONSTRAINT `voucher_fk_comp_id` FOREIGN KEY (`COMP_ID`) REFERENCES `company` (`COMP_ID`),
  CONSTRAINT `voucher_fk_year_id` FOREIGN KEY (`YEAR_ID`) REFERENCES `fin_years` (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `voucherdet`;
CREATE TABLE `voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `debit` decimal(20,2) DEFAULT NULL,
  `credit` decimal(20,2) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ER` decimal(65,30) DEFAULT NULL,
  `UNIT_RATE` decimal(65,30) DEFAULT NULL,
  `TT_NO` varchar(30) DEFAULT NULL,
  `REG_NO` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucherdet
-- ----------------------------

-- ----------------------------
-- Table structure for `voucher_id`
-- ----------------------------
DROP TABLE IF EXISTS `voucher_id`;
CREATE TABLE `voucher_id` (
  `v_id` int(11) DEFAULT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucher_id
-- ----------------------------
INSERT INTO `voucher_id` VALUES ('1', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1', 'CP', '');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '');
INSERT INTO `voucher_id` VALUES ('3', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'CP', '');
INSERT INTO `voucher_id` VALUES ('2', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('25', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('119', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('119', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('138', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('139', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('140', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('141', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('142', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('143', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('144', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('145', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('146', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('119', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('147', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('148', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('149', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('150', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('151', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('152', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('153', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('154', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('155', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('156', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('157', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('158', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('159', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('160', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('161', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('162', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('163', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('164', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('165', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('166', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('167', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('168', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('169', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('170', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('171', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('172', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('173', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('174', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('175', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('176', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('177', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('178', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('179', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('180', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('181', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('182', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('183', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('184', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('185', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('186', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('187', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('188', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('189', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('190', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('191', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('192', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('193', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('194', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('195', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('196', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('197', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('198', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('199', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('200', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('201', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('202', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('203', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('204', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('205', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('206', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('207', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('208', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('209', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('210', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('211', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('212', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('213', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('214', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('215', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('216', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('217', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('218', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('219', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('220', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('221', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('222', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('223', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('224', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('225', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('226', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('227', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('228', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('229', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('230', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('138', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('231', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('232', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('139', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('233', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('234', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('235', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('236', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('140', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('237', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('141', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('142', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('238', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('239', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('240', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('241', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('242', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('243', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('244', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('245', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('246', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('143', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('144', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('145', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('146', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('147', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('148', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('149', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('150', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('151', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('152', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('153', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('154', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('155', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('247', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('248', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('249', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('250', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('251', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('252', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('253', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('254', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('255', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('156', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('157', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('158', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('159', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('256', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('257', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('258', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('160', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'BP', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('1', '', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('88', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('161', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('259', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('260', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('261', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('262', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('263', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('264', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('265', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('162', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('163', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('164', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('266', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('267', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('268', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('269', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('270', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('271', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('165', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('166', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'BP', 'KT');
INSERT INTO `voucher_id` VALUES ('167', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'CR', 'BT');
INSERT INTO `voucher_id` VALUES ('8', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('168', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('272', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('273', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('169', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('274', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('275', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('276', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('277', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('170', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('171', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('172', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('278', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('279', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('280', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('173', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('174', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('175', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('176', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('177', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('178', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('179', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('180', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('281', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('181', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('182', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('282', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('183', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('184', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('185', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('186', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('187', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('283', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('188', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('189', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('190', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('284', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('285', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('191', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'BR', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('192', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('286', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('11', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('12', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('16', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('17', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('21', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('22', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('23', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('24', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'ST', '01');
INSERT INTO `voucher_id` VALUES ('25', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('26', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('27', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('28', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('11', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('12', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('29', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('30', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('31', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('32', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('33', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('34', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('35', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('36', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('37', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('38', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('39', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'ST', '01');
INSERT INTO `voucher_id` VALUES ('40', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('41', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('42', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('44', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('45', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('46', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('47', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('48', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('49', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('50', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('52', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('53', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('2', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('54', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('55', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('56', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('4', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('57', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('58', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('59', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('60', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('61', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('62', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('63', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('64', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('65', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('66', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('67', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('68', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('69', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('70', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('71', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('72', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('73', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('74', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('75', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('76', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('77', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('78', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('79', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('80', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('81', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('82', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('83', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('16', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('85', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('17', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('21', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('22', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('23', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('24', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('25', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('86', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('87', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('88', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('89', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('90', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('91', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('92', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('93', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('94', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('95', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('96', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('97', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('98', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('99', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('26', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('100', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('101', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('102', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('27', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('103', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('104', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('28', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('105', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('106', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('107', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('108', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('109', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('110', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('111', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('112', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('113', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('114', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('115', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('116', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('117', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('118', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('119', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('120', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('121', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('29', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('30', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('122', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('123', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('124', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('125', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('126', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('127', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('128', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('129', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('130', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('131', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('132', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('133', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('134', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('31', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('32', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('33', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('34', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('35', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('36', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('37', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('38', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('39', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('40', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('41', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('42', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('135', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('136', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('137', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('138', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('139', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('140', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('141', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('142', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('143', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('2', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('3', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('144', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('145', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('146', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('147', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('148', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('149', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('150', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('151', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('152', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('153', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('154', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('155', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('156', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('157', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('158', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('159', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('160', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('161', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('162', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('163', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('164', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('165', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('166', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('167', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('168', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('169', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('170', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('171', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('172', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('173', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('174', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('175', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('176', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('177', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('178', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('179', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('180', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('181', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('182', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('183', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('184', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('185', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('186', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('187', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('188', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('189', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('190', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('191', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('192', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('193', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('194', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('195', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('196', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('197', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('198', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('199', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('200', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('201', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('202', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('203', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('204', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('205', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('206', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('207', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('208', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('209', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('210', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('211', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('212', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('213', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('214', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('215', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('216', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('7', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('217', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('218', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('219', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('220', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('221', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('222', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('223', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('11', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('12', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('224', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('225', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('226', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('14', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('227', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('228', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('229', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('230', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('16', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('231', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('232', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('17', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('18', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('233', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('234', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('235', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('236', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('237', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('238', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('21', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('239', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('44', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('22', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('240', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('45', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('46', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('47', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('48', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('49', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('50', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('52', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('53', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('54', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('55', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('56', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('57', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('58', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('59', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('60', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('61', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('62', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('63', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('64', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('65', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('241', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('242', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('243', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('244', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('245', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('246', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('247', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('248', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('249', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('250', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('251', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('252', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('253', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('254', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('255', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('256', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('257', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('258', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('259', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('66', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('260', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('261', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('262', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('263', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('264', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('265', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('266', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('267', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('23', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('268', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('24', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('25', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('269', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('270', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('271', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('26', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('272', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('27', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('273', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('274', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('28', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('275', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('276', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('29', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('277', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('278', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('279', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('280', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('281', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('282', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('283', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('284', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('285', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('286', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('287', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('288', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('289', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('290', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('67', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('68', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('30', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('291', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('292', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('293', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('294', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('295', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('296', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('297', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('298', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('299', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('300', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('301', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('302', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('303', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('304', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('69', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('70', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('305', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('306', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('307', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('308', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('309', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('310', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('311', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('4', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('2', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('3', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('4', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('5', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('6', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('312', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('313', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('314', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('315', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('316', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('317', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('318', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('319', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('320', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('321', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('322', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('323', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('324', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('325', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('326', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('327', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('328', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('329', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('330', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('331', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('332', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('333', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('334', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('335', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('336', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('337', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('338', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('339', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('340', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('341', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('342', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('343', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('344', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('345', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('346', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('347', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('348', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('349', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('350', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('351', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('352', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('353', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('354', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('355', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('356', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('357', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('358', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('359', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('71', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('72', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('73', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('74', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('75', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('76', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('77', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('78', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('9', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('10', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('11', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('12', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('13', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('79', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('80', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('81', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('360', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('361', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('362', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('31', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('363', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('364', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('365', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('366', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('367', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('368', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('82', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('83', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1', 'PR', '01');
INSERT INTO `voucher_id` VALUES ('369', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('370', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('16', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('85', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('371', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('372', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('373', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('374', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('375', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('376', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('377', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('378', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('379', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('380', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('381', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('382', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('383', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('384', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('385', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('386', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('387', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('388', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('389', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('390', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('391', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('392', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('393', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('394', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('395', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('396', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('397', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('398', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('399', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('400', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('401', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('402', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('403', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('404', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('405', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('32', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('33', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('34', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('406', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('407', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('408', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('409', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('410', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('411', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('412', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('413', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('86', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('87', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('88', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('89', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('414', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('415', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('416', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('417', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('418', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('419', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('420', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('421', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('422', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('423', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('424', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('425', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('426', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('427', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('428', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('429', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('430', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('431', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('90', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('91', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('432', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('3', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('4', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('5', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('6', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('7', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('8', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('9', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('10', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('11', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('12', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('13', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('14', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('433', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('434', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('435', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('436', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('437', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('438', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('439', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('440', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('92', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('93', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'PR', '01');
INSERT INTO `voucher_id` VALUES ('15', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('16', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('17', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('18', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('19', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('441', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('442', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('35', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('443', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('444', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('445', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('446', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('447', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('448', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('94', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('95', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('449', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('450', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('451', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('452', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('453', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('454', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('455', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('456', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('457', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('458', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('459', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('460', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('21', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('22', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('23', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('24', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('25', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('26', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('461', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('462', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('463', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('464', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('465', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('466', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('467', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('468', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('469', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('470', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('471', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('472', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('473', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('474', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('475', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('476', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('477', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('478', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('27', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('28', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('29', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('30', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('31', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('479', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('480', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('481', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('482', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('483', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('484', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('485', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('486', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('487', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('488', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('489', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('490', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('491', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('492', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('493', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('494', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('495', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('496', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('497', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('498', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('32', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('8', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('17', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('2', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('1', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('2', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('3', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('4', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('499', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('500', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('501', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('502', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('503', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('504', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('505', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('506', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('507', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('508', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('509', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('510', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('511', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('512', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('513', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('514', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('515', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('516', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('517', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('518', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('519', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('520', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('33', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('34', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('35', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('18', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('96', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('97', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('98', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('99', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('100', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('101', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('102', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('103', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('104', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('105', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('106', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('107', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('108', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('521', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('522', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('523', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('524', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('525', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('109', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('110', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('111', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('112', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('113', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('526', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('527', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('114', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('115', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('116', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('528', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('529', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('117', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('118', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('119', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('120', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('121', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('530', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('531', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('532', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('36', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('533', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('534', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('535', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('536', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('537', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('538', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('539', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('36', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('37', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('38', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('39', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('19', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('20', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('3', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('9', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('10', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('11', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('12', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('13', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('540', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('122', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('541', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('542', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('543', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('37', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('38', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('39', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('544', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('545', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('546', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('547', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('548', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('549', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('550', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('551', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('552', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('553', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('554', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('555', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('40', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('41', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('556', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('557', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('558', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('559', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('42', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('560', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('561', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('562', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('563', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('123', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('21', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('564', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('565', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('22', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('566', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('567', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('568', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('569', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('570', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('571', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('572', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('573', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('124', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('574', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('575', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('576', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('577', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('578', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('579', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('580', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('581', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('582', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('583', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('584', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('585', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('586', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('44', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('587', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('588', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('589', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('590', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('591', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('592', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('593', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('45', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('594', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('23', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('595', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('596', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('597', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('598', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('599', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('600', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('601', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('602', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('603', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('604', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('605', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('606', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('607', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('608', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('609', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('610', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('611', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('612', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('613', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('614', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('615', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('616', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('617', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('618', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('619', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('40', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('41', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('125', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('126', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('24', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('127', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('620', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('621', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('25', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('128', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('129', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('130', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('26', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('27', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('28', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('29', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('30', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('31', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('131', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('14', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('622', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('623', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('624', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('625', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('626', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('627', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('628', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('629', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('630', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('631', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('632', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('633', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('634', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('635', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('636', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('637', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('638', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('639', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('640', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('641', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('642', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('643', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('46', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('47', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('3', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('4', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('5', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('644', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('645', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('646', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('647', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('648', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('649', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('650', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('651', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('652', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('653', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('654', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('655', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('48', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('656', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('657', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('658', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('659', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('660', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('49', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('661', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('662', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('663', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('664', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('50', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('665', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('666', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('667', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('668', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('669', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('670', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('671', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('672', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('673', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('674', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('675', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('676', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('677', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('678', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('679', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('680', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('52', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('681', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('682', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('683', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('684', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('685', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('53', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('686', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('687', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('688', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('42', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('43', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('44', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('45', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('46', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('47', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('48', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('49', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('50', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('6', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('7', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('2', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('3', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('51', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('52', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('53', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('689', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('32', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('9', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('10', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('11', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('54', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('55', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('56', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('57', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('58', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('59', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('5', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('60', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('61', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('3', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('4', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('12', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('13', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('14', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('62', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('63', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('64', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('2', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('3', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('65', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('66', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('67', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('68', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('15', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('16', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('69', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('17', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('18', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('70', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('71', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('4', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('19', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('20', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('21', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('22', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('23', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('72', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('73', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('5', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('74', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('5', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('6', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('7', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('8', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('9', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('10', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('11', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('12', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('75', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('76', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('77', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('78', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('79', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('80', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('6', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('81', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('82', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('4', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('7', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('83', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('84', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('85', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('13', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('8', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('24', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('25', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('26', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('27', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('28', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('86', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('87', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('88', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('89', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('90', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('91', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('9', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('10', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('1', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('1', 'ST', '02');
INSERT INTO `voucher_id` VALUES ('92', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('93', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('11', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('14', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('29', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('30', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('31', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('32', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('12', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('13', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('14', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('94', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('95', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('96', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('97', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('98', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('99', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('100', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('15', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('101', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('16', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('102', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('103', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('104', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('105', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('106', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('107', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('108', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('109', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('110', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('111', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('112', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('33', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('34', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('35', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('36', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('37', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('38', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('113', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('39', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('40', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('41', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('42', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('43', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('44', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('15', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('45', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('46', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('47', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('48', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('49', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('17', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('50', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('114', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('115', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('116', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('117', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('118', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('119', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('120', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('121', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('122', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('123', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('124', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('125', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('126', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('127', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('128', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('129', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('130', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('131', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('18', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('19', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('51', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('52', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('53', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('54', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('20', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('55', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('56', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('57', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('21', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('22', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('58', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('59', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('23', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('24', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('25', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('26', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('27', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('28', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('29', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('60', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('61', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('62', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('63', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('30', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('31', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('32', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('33', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('34', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('35', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('36', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('37', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('38', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('39', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('2', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('3', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('4', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('132', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('133', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('134', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('135', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('136', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('137', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('16', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('17', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('138', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('139', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('140', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('141', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('142', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('143', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('144', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('145', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('146', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('18', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('147', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('148', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('149', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('150', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('19', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('151', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('152', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('153', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('20', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('21', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('22', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('154', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('64', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('155', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('156', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('157', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('158', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('159', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('160', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('161', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('65', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('66', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('162', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('163', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('164', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('165', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('166', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('23', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('167', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('168', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('169', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('170', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('67', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('68', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('69', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('70', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('171', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('24', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('172', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('173', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('174', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('175', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('176', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('177', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('178', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('179', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('180', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('181', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('182', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('183', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('25', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('184', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('185', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('186', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('187', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('188', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('189', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('190', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('191', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('192', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('193', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('194', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('195', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('196', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('197', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('198', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('199', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('200', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('201', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('202', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('203', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('204', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('205', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('206', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('207', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('208', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('209', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('210', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('71', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('5', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('211', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('212', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('26', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('213', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('27', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('28', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('214', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('215', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('216', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('217', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('218', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('219', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('220', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('221', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('72', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('73', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('74', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('222', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('223', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('224', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('225', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('226', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('227', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('228', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('229', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('230', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('231', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('232', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('233', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('234', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('235', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('236', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('40', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('237', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('238', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('239', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('240', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('33', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('34', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('35', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('36', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('37', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('132', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('54', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('38', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('5', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('4', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('133', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('134', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('135', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('136', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('55', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('6', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('75', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('241', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('242', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('243', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('244', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('76', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('77', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('245', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('246', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('39', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('247', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('78', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('248', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('249', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('250', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('251', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('252', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('253', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('254', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('255', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('256', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('257', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('79', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('80', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('81', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('82', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('7', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('258', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('259', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('260', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('261', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('262', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('263', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('264', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('265', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('266', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('267', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('268', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('269', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('270', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('271', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('272', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('273', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('274', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('275', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('6', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('29', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('276', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('277', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('83', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('84', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('30', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('278', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('279', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('280', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('281', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('282', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('283', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('284', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('31', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('285', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('85', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('86', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('32', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('87', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('88', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('286', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('287', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('288', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('289', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('290', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('291', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('33', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('292', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('293', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('294', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('295', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('296', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('297', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('34', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('7', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('8', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('298', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('35', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('299', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('690', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('691', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('137', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('300', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('138', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('139', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('140', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('41', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('692', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('141', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('693', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('89', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('90', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('91', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('36', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('92', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('301', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('302', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('303', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('93', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('37', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('304', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('305', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('306', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('307', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('308', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('142', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('309', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('310', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('311', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('312', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('313', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('314', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('9', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('42', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('694', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('695', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('696', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('315', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('316', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('317', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('318', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('319', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('320', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('321', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('322', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('697', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('698', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('699', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('700', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('701', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('323', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('702', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('703', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('704', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('705', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('706', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('707', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('56', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('10', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('38', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('39', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('324', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('40', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('325', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('326', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('708', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('327', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('328', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('709', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('710', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('711', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('712', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('713', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('714', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('715', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('716', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('143', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('144', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('94', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('57', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('717', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('329', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('718', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('719', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('720', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('330', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('721', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('331', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('332', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('722', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('333', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('334', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('335', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('336', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('337', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('95', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('96', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('97', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('98', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('99', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('100', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('338', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('339', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('340', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('341', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('342', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('343', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('344', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('41', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('42', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('345', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('346', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('347', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('348', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('43', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('349', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('44', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('5', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('350', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('351', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('45', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('101', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('43', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('11', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('6', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('352', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('353', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('354', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('723', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('724', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('725', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('726', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('727', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('355', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('356', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('357', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'BP', '02');
INSERT INTO `voucher_id` VALUES ('102', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('358', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('145', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('359', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('360', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('361', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('728', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('103', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('729', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('104', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('105', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('58', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('730', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('731', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('106', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('732', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('733', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('107', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('734', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('362', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('46', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('363', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('146', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('147', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('148', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('364', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('149', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('365', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('150', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('151', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('152', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('735', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('736', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('737', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('738', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('153', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('739', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('740', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('154', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('155', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('108', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('109', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('741', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('156', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('110', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('111', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('112', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('113', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('114', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('157', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('158', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('159', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('160', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('161', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('162', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('742', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('743', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('59', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('60', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('744', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('745', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('746', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('747', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('748', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('749', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('163', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('366', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('750', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('164', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('165', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('751', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('752', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('753', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('754', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('755', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('756', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('757', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('758', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('61', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('47', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('48', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('367', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('368', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('369', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('370', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('44', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('115', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('371', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('49', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('116', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('759', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('760', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('761', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('762', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('763', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('764', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('765', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('766', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('767', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('768', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('769', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('770', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('166', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('167', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('771', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('168', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('372', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('169', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('772', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('773', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('774', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('775', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('776', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('777', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('117', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('50', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('118', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('373', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('119', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('374', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('41', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('170', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('171', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('172', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('173', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('375', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('376', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('174', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('42', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('175', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('176', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('177', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('178', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('179', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('44', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('180', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('181', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('182', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('183', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('184', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('185', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'ST', '01');
INSERT INTO `voucher_id` VALUES ('377', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('378', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('379', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('380', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('381', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('45', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('45', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('12', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('382', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('186', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('187', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('188', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('189', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('46', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('120', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('121', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('383', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('122', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('778', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('123', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('124', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('125', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('126', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('190', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'ST', '02');
INSERT INTO `voucher_id` VALUES ('191', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('192', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('193', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('194', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('195', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('779', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('384', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('385', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('386', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('387', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('196', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('780', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('197', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('198', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('199', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('200', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('201', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('388', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('389', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('390', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('391', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('392', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('393', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('394', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('202', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('395', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('203', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('204', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('205', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('206', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('207', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('208', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('209', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('52', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('53', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('396', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('397', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('13', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('14', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('398', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('399', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('400', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('401', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('16', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('17', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('402', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('18', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('47', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('54', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('210', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('211', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('212', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('213', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('214', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('215', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('403', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('46', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('47', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('48', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('49', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('50', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('127', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('404', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('128', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('129', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('130', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('405', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('406', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('407', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('55', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('56', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('57', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('58', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('131', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('132', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('133', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('134', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('135', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('136', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('137', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('138', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('139', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('48', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('408', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('409', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('49', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('50', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('51', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('410', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('411', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('3', 'ST', '02');
INSERT INTO `voucher_id` VALUES ('412', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('413', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('414', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('52', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('53', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('54', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('216', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('217', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('218', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('140', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('15', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('16', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('17', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('9', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('10', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('11', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('415', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('416', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('417', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('418', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('419', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('420', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('421', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('422', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('423', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('51', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('424', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('141', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('142', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('143', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('144', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('145', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('146', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('425', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('426', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('147', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('148', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('149', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('427', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('59', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('18', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('428', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('429', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('430', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('150', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('55', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('56', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('151', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('152', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('153', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('154', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('155', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('156', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('157', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('431', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('19', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('60', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('61', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('432', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('433', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('20', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('52', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('53', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('62', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('434', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('158', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('63', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('435', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('159', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('436', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('437', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('438', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('439', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('440', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('441', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('442', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('443', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('444', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('64', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('21', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('22', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('23', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('445', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('24', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('446', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('447', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('448', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('160', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('57', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('449', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('161', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('450', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('451', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('452', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('453', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('59', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('65', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('66', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('67', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('454', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('68', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('455', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('456', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('162', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('457', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('25', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('60', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('458', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('459', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('460', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('69', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('461', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('462', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('463', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('26', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('27', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('163', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('164', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('70', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('464', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('781', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('219', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('220', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('221', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('465', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('466', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('467', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('468', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('71', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('469', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('470', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('28', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('29', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('30', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('471', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('54', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('2', 'BP', '02');
INSERT INTO `voucher_id` VALUES ('31', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('1', 'BR', '02');
INSERT INTO `voucher_id` VALUES ('165', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('166', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('55', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('56', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('32', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('167', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('472', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('61', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('72', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('473', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('33', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('474', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('62', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('19', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('782', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('63', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('64', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('7', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('8', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('9', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('10', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('65', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('475', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('476', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('477', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('478', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('479', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('57', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('58', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('59', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('60', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('34', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('61', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('12', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('62', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('73', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('168', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('480', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('74', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('481', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('482', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('483', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('484', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('485', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('75', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('486', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('76', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('169', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('170', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('487', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('35', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('488', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('489', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('77', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('490', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('783', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('784', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('491', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('78', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('492', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('493', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('494', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('495', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('496', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('497', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('79', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('498', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('499', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('500', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('171', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('501', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('502', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('503', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('172', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('173', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('174', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('175', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('785', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('67', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('68', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('20', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('786', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('787', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('788', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('789', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('790', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('791', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('792', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('793', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('794', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('176', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('177', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('63', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('80', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('36', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('504', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('505', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('506', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('507', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('795', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('796', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('797', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('798', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('799', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('800', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('801', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('802', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('803', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('804', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('805', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('508', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('806', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('807', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('808', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('809', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('810', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('811', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('812', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('813', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('509', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('814', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('815', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('816', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('817', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('818', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('819', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('820', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('821', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('822', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('62', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('63', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('64', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('823', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('69', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('222', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('37', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('38', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('39', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('70', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('178', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('223', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('224', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('225', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('179', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('226', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('71', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('227', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('228', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('229', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('230', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('65', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('824', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('72', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('64', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('180', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('825', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('66', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('67', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('826', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('68', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('11', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('827', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('510', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('81', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('828', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('82', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('829', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('830', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('831', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('69', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('231', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('73', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('232', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('233', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('832', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('74', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('75', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('21', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('22', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('23', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('833', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('70', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('71', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('72', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('511', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('834', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('76', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('77', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('512', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('65', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('13', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('835', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('513', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('514', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('515', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('836', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('837', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('234', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('235', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('838', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('839', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('840', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('841', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('83', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('842', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('516', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('517', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('236', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('843', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('844', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('845', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('846', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('847', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('848', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('518', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('849', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('850', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('851', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('852', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('73', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('78', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('79', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('519', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('520', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('853', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('854', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('181', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('521', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('85', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('86', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('182', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('855', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('183', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('856', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('857', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('858', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('859', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('522', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('523', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('524', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'SO', '02');
INSERT INTO `voucher_id` VALUES ('860', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('861', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('862', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('863', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('16', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('184', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('185', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('525', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('526', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('527', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('24', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('25', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('17', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('16', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('87', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('528', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('529', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('530', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('531', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('88', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('532', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('533', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('534', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('186', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('187', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('535', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('188', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('189', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('190', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('191', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('192', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('536', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('537', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('538', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('539', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('540', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('193', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('194', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('195', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('196', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('197', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('198', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('199', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('200', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('201', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('541', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('542', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('202', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('203', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('543', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('544', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('204', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('205', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('545', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('546', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('547', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('548', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('549', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('864', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('865', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('866', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('867', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('868', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('869', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('870', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('871', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('872', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('873', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('66', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('550', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('551', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('552', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('553', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('206', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('554', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('17', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('207', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('80', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('555', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('40', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('67', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('208', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('556', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('557', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('558', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('209', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('210', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('559', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('89', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('560', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('561', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('90', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('18', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('68', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('562', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('563', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('211', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('212', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('564', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('565', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('213', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('566', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('214', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('69', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('19', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('41', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('70', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('567', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('568', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('569', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('71', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('215', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('72', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('570', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('73', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('216', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('217', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('91', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('92', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('74', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('75', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('218', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('571', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('572', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('81', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('219', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('76', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('874', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('90', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('91', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('93', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('96', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('875', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('97', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('98', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('876', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('877', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('878', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('879', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('880', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('881', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('99', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('100', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('882', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('883', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('884', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('885', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('101', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('573', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('102', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('104', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('220', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('42', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('105', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('574', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('575', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('221', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('576', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('107', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('222', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('93', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('577', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('43', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('578', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('579', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('118', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('580', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('581', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('122', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('223', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('582', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('224', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('225', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('226', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('227', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('30', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('38', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('41', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('42', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('77', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('78', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('44', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('79', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('583', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('228', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('80', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('229', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('230', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('9', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('237', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('238', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('584', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('886', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('231', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('123', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('585', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('586', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('239', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('125', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('587', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('126', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('127', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('588', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('589', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('45', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('590', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('130', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('132', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('240', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('133', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('241', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('242', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('134', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('135', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('887', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('888', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('889', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('243', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('244', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('591', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('245', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('246', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('890', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('247', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('891', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('248', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('892', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('893', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('894', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('895', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('896', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('897', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('898', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('899', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('249', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('900', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('901', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('902', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('903', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('904', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('905', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('232', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('233', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('234', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('235', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('74', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('136', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('137', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('236', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('237', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('592', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('593', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('906', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('2', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('3', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('4', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('5', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('6', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('7', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('907', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('908', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('909', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('75', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('238', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('9', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('140', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('910', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('911', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('912', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('913', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('250', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('914', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('142', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('915', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('916', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('917', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('239', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('918', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('919', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('920', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('921', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('922', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('923', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('924', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('925', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('926', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('927', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('928', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('929', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('251', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('594', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('595', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('596', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('597', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('598', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('599', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('600', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('601', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('94', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('602', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('603', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('95', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('143', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('252', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('604', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('930', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('96', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('931', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('932', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('97', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('98', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('144', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('933', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('934', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('935', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('253', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('240', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('46', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('99', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('100', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('101', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('102', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('103', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('936', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('937', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('938', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('939', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('940', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('941', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('942', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('943', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('605', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('606', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('104', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('944', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('945', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('105', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('106', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('11', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('1', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('107', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('241', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('81', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('242', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('82', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('243', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('244', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('245', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('246', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('47', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('607', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('2', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('3', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('1', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('2', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('3', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('4', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('4', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('5', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('6', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('946', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('8', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('9', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('10', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('608', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('947', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('948', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('949', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('950', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('951', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('952', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('953', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('954', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('955', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('956', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('609', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('957', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('958', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('959', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('76', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('960', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('961', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('962', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('963', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('964', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('965', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('5', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('254', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('966', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('77', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('145', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('967', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('968', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('969', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('970', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('971', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('146', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('972', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('973', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('974', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('975', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('976', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('610', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('977', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('611', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('108', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('612', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('148', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('247', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('248', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('613', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('4', 'CP', '');
INSERT INTO `voucher_id` VALUES ('978', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('614', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('10', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('979', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('615', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('980', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('616', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('981', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('982', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('983', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('984', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('617', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('985', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('986', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('987', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('988', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('149', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('618', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('619', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('7', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('78', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('150', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('83', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('620', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('989', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('990', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('11', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('991', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('621', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('992', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('993', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('622', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('249', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('623', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('151', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('152', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('624', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('255', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('256', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('153', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('257', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('258', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('259', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('994', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('250', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('8', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('48', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('995', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('260', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('261', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('625', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('996', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('997', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('85', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('86', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('87', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('88', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('89', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('90', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('154', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('91', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('998', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('626', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('627', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('251', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('12', 'DC', '02');
INSERT INTO `voucher_id` VALUES ('20', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('21', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('999', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1000', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('628', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1001', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1002', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1003', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1004', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('252', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('629', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('253', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('79', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('262', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('1005', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1006', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1007', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('254', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('630', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('263', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('631', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('155', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('264', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('156', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('632', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('265', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('633', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('266', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('267', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('268', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('269', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('270', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('157', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('158', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('271', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('80', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('272', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('159', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('273', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('634', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('49', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('160', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('274', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('1008', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1009', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('275', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('276', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('277', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('635', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('636', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('109', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('278', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('279', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('110', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('12', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('637', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('280', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('281', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('282', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('283', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'PO', '01');
INSERT INTO `voucher_id` VALUES ('1', 'PO', '02');
INSERT INTO `voucher_id` VALUES ('255', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('256', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1010', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('638', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('284', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('639', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('640', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('12', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('13', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('1011', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('257', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('92', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('1012', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('81', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1013', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1014', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('82', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1015', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('1016', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('15', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('16', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('17', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('1017', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('19', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('285', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('258', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('259', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('260', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('261', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('262', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('263', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('5', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('6', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('7', 'SO', '01');
INSERT INTO `voucher_id` VALUES ('1018', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1019', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1020', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1021', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1022', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1023', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1024', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1025', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('264', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('265', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1026', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('266', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1027', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1028', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1029', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1030', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('641', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('642', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('643', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('644', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('286', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('93', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('50', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('1031', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1032', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1033', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1034', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('267', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('645', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('268', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('646', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('647', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('648', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('649', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('650', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('20', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('21', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('22', 'DC', '01');
INSERT INTO `voucher_id` VALUES ('651', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('652', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('653', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('654', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('287', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('161', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('162', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1035', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('288', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('163', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('164', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1036', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('83', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('9', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('1037', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1038', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('289', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('290', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('291', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('292', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('293', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('655', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('294', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('295', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('296', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('656', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('297', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('298', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('269', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('270', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1039', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1040', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1041', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1042', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('52', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('1043', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1044', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1045', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1046', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('657', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1047', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1048', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('658', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1049', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('659', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1050', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1051', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1052', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1053', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1054', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('111', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('112', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('1055', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1056', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1057', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('271', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('272', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('273', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('274', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('275', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('113', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('114', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('299', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('44', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('165', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('276', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('277', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1058', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('166', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('278', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('279', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('660', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('661', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('280', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('94', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('281', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('282', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('283', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('662', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('663', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('284', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('115', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('285', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('286', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('287', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('288', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('289', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('290', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('291', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('292', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('293', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('664', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('116', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('294', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('295', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('296', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('297', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('298', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('665', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('666', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('667', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('668', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('669', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('299', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('300', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('301', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('302', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('303', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('304', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('305', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('306', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('307', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('308', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('309', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('310', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('670', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('671', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('672', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('311', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('673', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('312', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('313', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('314', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('315', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('316', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('317', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('318', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('319', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('320', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('321', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('117', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('118', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('322', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('323', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('1059', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1060', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1061', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1062', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1063', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1064', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1065', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1066', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1067', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1068', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1069', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1070', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1071', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('85', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('86', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('87', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1072', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1073', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1074', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1075', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1076', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1077', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1078', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1079', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1080', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1081', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1082', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1083', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1084', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1085', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1086', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1087', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('95', 'CP', '02');
INSERT INTO `voucher_id` VALUES ('53', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('674', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('20', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('21', 'JV', '02');
INSERT INTO `voucher_id` VALUES ('675', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('324', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('676', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('677', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('678', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('679', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('325', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('326', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('327', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('328', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('329', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('330', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('331', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('332', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('333', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('334', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('335', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('336', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('337', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('338', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('339', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('340', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('341', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('342', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('343', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('344', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('345', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('346', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('347', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('348', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('349', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('350', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('351', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('352', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('353', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('354', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('355', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('356', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('357', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('358', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('359', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('360', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('361', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('362', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('363', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('680', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1', 'CP', '03');
INSERT INTO `voucher_id` VALUES ('1', 'PL', '03');
INSERT INTO `voucher_id` VALUES ('1', 'SL', '03');
INSERT INTO `voucher_id` VALUES ('1', 'DC', '03');
INSERT INTO `voucher_id` VALUES ('2', 'PL', '03');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '03');
INSERT INTO `voucher_id` VALUES ('681', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('682', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('683', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('684', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('685', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1088', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1089', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1090', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1091', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1092', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1093', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1094', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1095', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1096', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1097', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1098', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1099', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('88', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1100', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1101', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1102', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('686', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('687', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('688', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('689', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('690', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('691', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('692', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('693', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('694', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('695', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('696', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('697', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('698', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('364', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('365', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('366', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('367', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('368', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('369', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('370', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('371', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('372', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('373', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('374', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('375', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('376', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('377', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('378', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('379', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('380', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('381', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('382', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('383', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('384', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('385', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('386', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('387', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('388', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('389', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('390', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('391', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('392', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('393', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('394', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('395', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('699', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('396', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('397', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('398', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('399', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('400', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('401', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('402', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('403', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('404', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('405', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('406', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('407', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('408', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('409', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('410', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('411', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('412', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('413', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('414', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('415', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('416', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('417', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('418', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('419', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('420', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('421', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('422', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('423', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('424', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('425', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('700', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('426', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('427', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('428', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('429', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('430', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('431', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('432', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('433', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('434', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('435', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('436', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('437', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('438', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('439', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('440', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('441', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('442', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('443', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('444', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('445', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('446', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('447', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('448', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('449', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('450', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('451', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('452', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('453', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('454', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('455', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('456', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('457', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('458', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('459', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('460', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('461', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('462', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('463', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('464', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('465', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('466', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('467', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('701', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('468', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('4', 'ST', '02');
INSERT INTO `voucher_id` VALUES ('2', 'DC', '03');
INSERT INTO `voucher_id` VALUES ('1103', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'DC', '03');
INSERT INTO `voucher_id` VALUES ('4', 'DC', '03');
INSERT INTO `voucher_id` VALUES ('702', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('703', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1104', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1105', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1106', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1107', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1108', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1109', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('89', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1110', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1111', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1112', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1113', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1114', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1115', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1116', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1117', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1118', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('90', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1119', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1120', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1121', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1122', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1123', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1124', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1125', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1126', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1127', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1128', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('54', 'CR', '02');
INSERT INTO `voucher_id` VALUES ('119', 'RT', '02');
INSERT INTO `voucher_id` VALUES ('1129', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1130', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1131', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('704', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('1132', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1133', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1134', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1135', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1136', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1137', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1138', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1139', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1140', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('91', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('92', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('93', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('1141', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1142', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1143', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1144', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1145', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1146', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1147', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1148', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1149', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1150', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1151', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1152', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1153', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1154', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1155', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1156', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1157', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1158', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1159', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1160', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1161', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('705', 'SL', '02');
INSERT INTO `voucher_id` VALUES ('469', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('470', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('471', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('472', 'PL', '02');
INSERT INTO `voucher_id` VALUES ('473', 'PL', '02');

-- ----------------------------
-- Table structure for `web_title`
-- ----------------------------
DROP TABLE IF EXISTS `web_title`;
CREATE TABLE `web_title` (
  `acct_id` int(11) NOT NULL AUTO_INCREMENT,
  `acct_name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of web_title
-- ----------------------------
INSERT INTO `web_title` VALUES ('1', 'Kamraj Enterprises');

-- ----------------------------
-- Table structure for `xls_bk_stock`
-- ----------------------------
DROP TABLE IF EXISTS `xls_bk_stock`;
CREATE TABLE `xls_bk_stock` (
  `description` varchar(255) DEFAULT NULL,
  `bs` varchar(255) DEFAULT NULL,
  `ds` varchar(255) DEFAULT NULL,
  `ms` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_bk_stock
-- ----------------------------
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET  GOLD 1900 ', '0', '3', '3');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET S&C SOQEAR', '0', '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET KOTO GOLDEN 8001', '1', '10', '11');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET POMA TRAND', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET SOLO TRAND', '1', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET DIMAND', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET CUBE', '0', '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('BRUSH HOLDER 304', '0', '19', '19');
INSERT INTO `xls_bk_stock` VALUES ('TAWER RING 304', '0', '86', '86');
INSERT INTO `xls_bk_stock` VALUES ('TAWER RAD 304', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('PAPER HOLDER 304', '0', '37', '37');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISH 304', '0', '18', '18');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISH GALA', '0', '13', '13');
INSERT INTO `xls_bk_stock` VALUES ('BRUSH HOLDER GALA', '0', '27', '27');
INSERT INTO `xls_bk_stock` VALUES ('PAPER HOLDER GALA', '0', '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('TAWER RING GALA', '0', '14', '14');
INSERT INTO `xls_bk_stock` VALUES ('TAWEL RAD SOQEAR S&C', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('TAWEL RING SOQEAR S&C', '0', '10', '10');
INSERT INTO `xls_bk_stock` VALUES ('PAPER HOLDER SOQEAR S&C', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('BURSH HOLDER SOQEAR S&C', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TAWEL RAD G CHI', '0', '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('TAWEL RING G CHI', '0', '20', '20');
INSERT INTO `xls_bk_stock` VALUES ('PAPER HOLDER G CHI', '0', '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH G CHI', '0', '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('BURSH HOLDER G CHI', '0', '21', '21');
INSERT INTO `xls_bk_stock` VALUES ('COAT HOOK G CHI', '0', '154', '154');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET KROM', '0', '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET WHITE', '0', '16', '16');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET TRAND VENAS', '0', '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET ACITKA', '0', '7', '7');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET 23600', '0', '11', '11');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET TRAND QUEN', '0', '2', '2');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET 304 H', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('PAPER HOLDER BK-03', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET WHITE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET BLACK', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET SKY BLUE', '0', '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET GRAY', '0', '3', '3');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET GREEN LIGHT', '0', '2', '2');
INSERT INTO `xls_bk_stock` VALUES ('TABLE SET RED', '0', '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH MATT', '0', '90', '90');
INSERT INTO `xls_bk_stock` VALUES ('GLASS MATT', '0', '50', '50');
INSERT INTO `xls_bk_stock` VALUES ('TOWEL RING JAGUAR', '0', '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH JAGUOR', '0', '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('BURSH HOLDER JAGUOR', '0', '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS B1009', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS B1008', '0', '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS B100', '0', '61', '61');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS B103', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS 786', '0', '165', '165');
INSERT INTO `xls_bk_stock` VALUES ('SOAP DISH SS 1005', '0', '38', '38');
INSERT INTO `xls_bk_stock` VALUES ('PAPER HOLDER 151', '89', '0', '91');
INSERT INTO `xls_bk_stock` VALUES ('ACCESSORY SET 304', '1', '3', '4');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('COMMODE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H K01', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H K03', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H K05', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H K011', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H K012', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H 010', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H VG 0714', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H BM-1203050', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H NW-303', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H ENG', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD W/H RI-210', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD 9095/A', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD 9008/A', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD 014', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD VG-854 4\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD VG-855 4\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD VG-858 4\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD VG-840B 4\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD VG-840A 12\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD 2PEC 2339', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD LX-5011', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD LX-154-5047', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD LX-5019', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD LX-5051', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD LX-367-5027', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD LX-5035', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD 5054', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD MC 2100', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD MC 103', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD 1205', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD PORTA HD-02N', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 109', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 10', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 104', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 101', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 103', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 105', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 102', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C RLAQ-804', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 608', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 804', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 722', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 218-211', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('W/C 0001', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('URINAL', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('URINAL RI 8925', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('HOOB-KITCHEN MASTER 530', '0', '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('HOOB-KITCHEN MASTER 560', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB-KITCHEN MASTER 500', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB-KITCHEN MASTER ', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-JW40', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-C212', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-8', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-24', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-BH945S1', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-CNBG-5', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CA-915G1', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CAK-25', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-04/1B', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-03/1B', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-07', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-11', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-82', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-B04', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-9A', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-10A', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-G2', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-G1', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-04/3B', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-S9', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-S4', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB BH-68', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CH-G1022', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CH-G1021', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CH-G1013', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB CH-G1012', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TAMPESD GLASS STOVER 014', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('TAMPESD GLASS STOVER NEW', '0', '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 9328-1', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB HM59056', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 016', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 018', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB HM58005', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB H87-5004G', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB H87-5002G', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB Z815', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB NY-QM 5041', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB Z-825', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB HG72-01B', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB HM-5113', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 10T', '0', '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4T', '0', '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 01T', '0', '1', '3');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 15T', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 13T', '0', '1', '3');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4063', '0', '1', '5');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 11GT', '0', '1', '3');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4071', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4026', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4003', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4062', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB 4025', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB YMA1', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOB WHITE WASTING HOUSE', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('HOOD', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE 600(209) 24\'\'', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE R209A(900)', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE R210A(900)', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE ST BK-44DC', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE ST BK-44DC 24\'\'', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE 404A- 24\'\'', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD SIGNATURE DC 52', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD FABER H-803', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD CANON HD-U3', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-137-28\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-51', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-50', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-32', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD PLT 802', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-139', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-204', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-1360', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD BH-1370', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('CENTER HOOD BH2010', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('CENTER HOOD BH-2008', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('CENTER HOOD BH-2005', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('CENTER HOOD R-KE03', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('CENTER HOOD C-9010-2', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 36\'\' SB', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 36\'\' SBT', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 36\'\' SS', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 36\'\' CB', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 36\'\' CS', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 36\'\' OS', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOD 90CA-U1 ', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('TUB ITALYA WHITE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:27x66 BATH TUB', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:29x50 ITALIA', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:9028', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:A7150B', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BATH TUB', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BATH TUB OVAL', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BATH TUB PINK', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BATH TUB SIGMA', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GEMY 033', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 06', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 09', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 10', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 12', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 14', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 15', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 16', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 16 WITHOUT MOTOR', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 07', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 18', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 18 SYSTEM', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 20', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 21', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 22', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 24', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 26', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 27', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 30', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 31', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 33', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 41', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 43', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 44', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 47', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 49', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 51', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 53', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 56', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 57', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 64', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:BTG 65', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:CINDI WHITE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:DIAMOND WHITE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:EXTRA PANEL BTG 64', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GEMY DAMEGE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 03', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 04', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 05', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 07', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 09', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 10', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 11', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 13', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 14', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 17', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 18', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 20', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 22', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 24', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 28', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 29', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 30', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:MOTOR', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:PANEL', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:RED', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:TUB 06', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:TUB 09', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:WHITE TUB', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:YG 18', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:YG 88', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('JACUZZI:GOLD 43', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TUB92*62 RED', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TUB23*66 WHITE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('PUSH WAIST S&C', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('PUSH WAIST USA', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('PUSH WAIST 4\'\'', null, '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('PUSH WAIST 6\'\'', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('PUSH WAIST 8\'\'', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP WWT', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP GROHE', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP SOQEUAR', null, '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP JAGUAR', null, '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP HAJVERY 12\'\'', null, '15', '15');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP USA', null, '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP PURO', null, '23', '23');
INSERT INTO `xls_bk_stock` VALUES ('BOTLE TRAP PIPE', null, '104', '104');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT WWT', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT LEVER A-GROHE', null, '2', '2');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT JAGUAR', null, '14', '14');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT SOQEAR A-G', null, '13', '13');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT RAOUND A-G', null, '21', '21');
INSERT INTO `xls_bk_stock` VALUES ('BIB COCK STYLISH', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BIB COCK JAGUAR', null, '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('BIB COCK MILLI', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BIB COCK 3/4', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BIB COCK NOZAL', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('D-BIB COCK MALAYSIA', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('D-BIB COCK JAGUAR', null, '7', '7');
INSERT INTO `xls_bk_stock` VALUES ('D-BIB COCK CHI', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('D-BIB COCK WWT', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK SQUARE GOLDEN CHI', null, '36', '36');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK SQUARE CHI', null, '232', '232');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK JAGUAR', null, '110', '110');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK GROHE CHI', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK WHIT 2384', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('U-BEND', null, '19', '19');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHOWER CHI', null, '35', '36');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHOWER MALISHA', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHOWER KROM GROHE CHI', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHOWER WHIT  LOCKAL', null, '279', '279');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER FORTE ONLY HEAD', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHOWER BUTTEN', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HAND SHWER 065', null, '42', '43');
INSERT INTO `xls_bk_stock` VALUES ('HAND SHWER 067', null, '47', '48');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST KABZA ', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST PUSH', null, '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST PACHO ', null, '76', '77');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST PLAN NEW', null, '192', '192');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST HAVY PLAN ', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST CENTER HOLE ', null, '37', '37');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST HEAVY SHAIN', null, '12', '12');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST HEAVY MATT', null, '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('FLOOR WAIST 4*4', null, '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('SINK WAST 1 1/2', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN WAST SS', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 16*16', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER ROUND 16*16', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER ROUND 16*16 SLIM', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SOQEAR 16*16 SLIM', null, '27', '27');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER BRASS 8*8', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 8*8', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SLIM 8*8', null, '43', '43');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SLIM 12*12', null, '-5', '-5');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER ROUND 12*12', null, '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 12*12', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 24*24', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 24*24 SLIM', null, '31', '31');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER RAWOND 20*20', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 20*20', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHOWER SQUARE 20*20 SLIM', null, '19', '19');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHWER CB-5518', null, '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHWER 516', null, '12', '12');
INSERT INTO `xls_bk_stock` VALUES ('CONNECTOR PIPE', null, '55', '55');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER CHAIN PIPE', null, '105', '105');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER SPRING PIPE', null, '47', '47');
INSERT INTO `xls_bk_stock` VALUES ('CONNECTOR PIPE 1 1/2 FT', null, '37', '37');
INSERT INTO `xls_bk_stock` VALUES ('CONACTION PIPE 2FIT', null, '19', '18');
INSERT INTO `xls_bk_stock` VALUES ('CONACTION PIPE 3FIT', null, '93', '93');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER PIPE', null, '354', '354');
INSERT INTO `xls_bk_stock` VALUES ('WAST PIPE CROM', null, '213', '213');
INSERT INTO `xls_bk_stock` VALUES ('WAST PIPE PVC 1 1/2', null, '46', '46');
INSERT INTO `xls_bk_stock` VALUES ('WAST PIPE SS', null, '121', '121');
INSERT INTO `xls_bk_stock` VALUES ('HOCKY PIPE SS', null, '7', '7');
INSERT INTO `xls_bk_stock` VALUES ('WAST PIPE PVC ', null, '79', '79');
INSERT INTO `xls_bk_stock` VALUES ('HAND SHWER PIPE', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MANIFIVE MIRREOR', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('MANIFIVE MIRREOR LED', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('THIMBLE WHITE', null, '111', '111');
INSERT INTO `xls_bk_stock` VALUES ('THIMBLE BLACK', null, '14', '14');
INSERT INTO `xls_bk_stock` VALUES ('THIMBLE GREES', null, '38', '38');
INSERT INTO `xls_bk_stock` VALUES ('THIMBLE GREES JEL', null, '100', '100');
INSERT INTO `xls_bk_stock` VALUES ('BOLT KIT CAMMOD W/H', null, '65', '65');
INSERT INTO `xls_bk_stock` VALUES ('CP NOZAL 1\'\'', null, '308', '308');
INSERT INTO `xls_bk_stock` VALUES ('CP NOZAL 2\'\'', null, '96', '96');
INSERT INTO `xls_bk_stock` VALUES ('CP NOZAL 1 1/2\'\'', null, '230', '230');
INSERT INTO `xls_bk_stock` VALUES ('CP NOZAL 3\'\'', null, '44', '44');
INSERT INTO `xls_bk_stock` VALUES ('CP NOZAL 4\'\'', null, '62', '62');
INSERT INTO `xls_bk_stock` VALUES ('CP NOZAL 6\'\'', null, '39', '39');
INSERT INTO `xls_bk_stock` VALUES ('CP NEUT', null, '18', '18');
INSERT INTO `xls_bk_stock` VALUES ('BEORING NIPPEL', null, '56', '56');
INSERT INTO `xls_bk_stock` VALUES ('CAMMOD KIT W/H', null, '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('BOLT KIT BASIN', null, '30', '30');
INSERT INTO `xls_bk_stock` VALUES ('TAFLAN TAPE', null, '501', '501');
INSERT INTO `xls_bk_stock` VALUES ('RACK 123 CYJ', null, '27', '28');
INSERT INTO `xls_bk_stock` VALUES ('RACK CONER  SS A013', null, '87', '88');
INSERT INTO `xls_bk_stock` VALUES ('RACK 1005', null, '33', '33');
INSERT INTO `xls_bk_stock` VALUES ('RACK 006 BK', null, '6', '7');
INSERT INTO `xls_bk_stock` VALUES ('RACK A57 CONER', null, '8', '9');
INSERT INTO `xls_bk_stock` VALUES ('ALUMINIUM SHELF 03', null, '6', '7');
INSERT INTO `xls_bk_stock` VALUES ('ALUMINIUM SHELF 02', null, '17', '17');
INSERT INTO `xls_bk_stock` VALUES ('ROSE PETAL SS', null, '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('TAWEL RACK D-21', null, '8', '9');
INSERT INTO `xls_bk_stock` VALUES ('RACK USA', null, '3', '4');
INSERT INTO `xls_bk_stock` VALUES ('RACK WESDA', null, '3', '3');
INSERT INTO `xls_bk_stock` VALUES ('SINGAL CONER RACK', null, '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('RACK BK58', null, '10', '10');
INSERT INTO `xls_bk_stock` VALUES ('RACK A160', null, '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('RACK B1106', null, '17', '17');
INSERT INTO `xls_bk_stock` VALUES ('RACK B1103', null, '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('RACK B1104', null, '2', '2');
INSERT INTO `xls_bk_stock` VALUES ('RACK 904', null, '30', '31');
INSERT INTO `xls_bk_stock` VALUES ('RACK 698/737', null, '6', '');
INSERT INTO `xls_bk_stock` VALUES ('TAWEL RAD SS', null, '30', '30');
INSERT INTO `xls_bk_stock` VALUES ('D-TAWEL RAD 7612', null, '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('D-TAWEL RAD 50D', null, '5', '5');
INSERT INTO `xls_bk_stock` VALUES ('T-ARM 18\'\' WWT', null, '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('T-ARM 24\'\' JAGUER', null, '29', '29');
INSERT INTO `xls_bk_stock` VALUES ('T-ARM 18\'\' JAGUER', null, '16', '16');
INSERT INTO `xls_bk_stock` VALUES ('ARM 12\'\' WWT', null, '37', '37');
INSERT INTO `xls_bk_stock` VALUES ('ARM 15\'\' WWT', null, '9', '9');
INSERT INTO `xls_bk_stock` VALUES ('ARM 18\'\' WWT', null, '7', '7');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER KM-2111 GOLD', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER KM-2111 CP', null, '7', '8');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 501-B', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 9745', null, '8', '10');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 5084-WHITE', null, '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 8276', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 8277', null, '8', '9');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 1137', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 0205 SK', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 0106 SK', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER CA-1', null, '2', '2');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 2080', null, '11', '11');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 2090', null, '5', '7');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 1805', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER CC3', null, '8', '9');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 8317', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 16157', null, '8', '8');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 1060 SK', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 1002', null, '15', '16');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 8319', null, '8', '9');
INSERT INTO `xls_bk_stock` VALUES ('WALL MOUNTED MIXER', null, '24', '25');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 7809', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER LT-0099', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SAPPRING SINK MIXER A/G', null, '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER M30', null, '11', '11');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 7109', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 7113', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER CC1', null, '9', '10');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER CC2', null, '11', '12');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 0179', null, '4', '5');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 0178', null, '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER CHI ', null, '19', '19');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER OULIN CS9605', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 1734', null, '2', '3');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER W/H 013-1', null, '6', '6');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER W/H 6010', null, '11', '11');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 9802', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 9819', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 9818', null, '7', '8');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 9722', null, '7', '7');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 9720', null, '13', '14');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 624', null, '4', '4');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 625', null, '10', '10');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 626', null, '10', '10');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET MALYSIA 9723', null, '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET GOLDEN UNCOMPLET', null, '5', '6');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET CTO CP', null, '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER SS', null, '12', '13');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER ', null, '26', '27');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER GOOL', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER SOQEAR', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER A57 ', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('KRB SOOP DISPANSER', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER PVC SMAL', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SOOP DISPANSER A013', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HOOK 8205 SS', null, '9', '10');
INSERT INTO `xls_bk_stock` VALUES ('HOOK 8105 SS', null, '9', '10');
INSERT INTO `xls_bk_stock` VALUES ('HOOK 3011 SS', null, '22', '23');
INSERT INTO `xls_bk_stock` VALUES ('HOOK FLOWER BIG', null, '24', '25');
INSERT INTO `xls_bk_stock` VALUES ('HOOK 8045 SS', null, '6', '7');
INSERT INTO `xls_bk_stock` VALUES ('GREY BAR', null, '92', '94');
INSERT INTO `xls_bk_stock` VALUES ('HAND DARYER LIGHT', null, '6', '6');
INSERT INTO `xls_bk_stock` VALUES ('HAND DARYER 010840', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HAND DARYER 9712154', null, '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('TANK SAGA CO13', null, '18', '19');
INSERT INTO `xls_bk_stock` VALUES ('TANK SAGA CO12', null, '27', '27');
INSERT INTO `xls_bk_stock` VALUES ('TANK VEGA 80009', null, '5', '6');
INSERT INTO `xls_bk_stock` VALUES ('SET COVER ROUND WHIT', null, '15', '15');
INSERT INTO `xls_bk_stock` VALUES ('SET COVER ROUND IVORY', null, '7', '7');
INSERT INTO `xls_bk_stock` VALUES ('SET COVER SQUORE WHIT', null, '3', '3');
INSERT INTO `xls_bk_stock` VALUES ('OIL HETER', null, '2', '3');
INSERT INTO `xls_bk_stock` VALUES ('VAKUM CALENER', null, '9', '10');
INSERT INTO `xls_bk_stock` VALUES ('', null, '', '');
INSERT INTO `xls_bk_stock` VALUES ('', null, '', '');
INSERT INTO `xls_bk_stock` VALUES ('', null, '', '');
INSERT INTO `xls_bk_stock` VALUES ('', null, '', '');
INSERT INTO `xls_bk_stock` VALUES ('', null, '', '');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN BH-201025 SS', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN BH-195125 BK', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN BOV-G17 SILVER', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN BOV-G17 BLCK', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN BMO-25E', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN TECNOGUS 23A5-RR', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('MICRO OVEN BH-97728', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN OL-10G59E', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN F-107 SIX', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN BOV-07', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN BH-1925 SS', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN BM67T2-B1-17', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN LAGERMWIA', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('OVEN 1946 GL', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('DISHWASHER GALANZ ESQ-FS', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN 401', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:36*36 TRAY', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:39*39 C02', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 777-16', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 777-17', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 777-18', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:8001-A', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:8001-C', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:49*49', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:8812', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:067', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:2012', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:P004', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN:8001 B', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER STEMAR :A 1750 B', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN TRAY SW 8001', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN 5019 A', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN S111', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN 2013', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER CABIN LYP 829', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 34', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 35', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 36', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 37', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 38', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL GOLDEN', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 111', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 527', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 511', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHOWER PANAL 516', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 7645', '0', '1', '3');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 7050', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 6045', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 8090', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 7050 24\'\'', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 9050', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-320L', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-S8916', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-336', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-H9818', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-330', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-S9916', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-825', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-367', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-205', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-0302', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK OL-8902', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 9848BL', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 11650', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK 518', '0', '1', '10');
INSERT INTO `xls_bk_stock` VALUES ('SINK 8349', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 520', '0', '1', '50');
INSERT INTO `xls_bk_stock` VALUES ('SINK 7540', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 8834', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 6045 S', '0', '1', '18');
INSERT INTO `xls_bk_stock` VALUES ('SINK 7843', '0', '2', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK 8343', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 11550A', '0', '1', '2');
INSERT INTO `xls_bk_stock` VALUES ('SINK 8044B', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 4546', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 8644', '0', '1', '33');
INSERT INTO `xls_bk_stock` VALUES ('SINK 7575', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 6643T', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK CLARA', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 1836 TEKA', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('LOCAL GOOL', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 9848', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 7243', '0', '1', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 9546', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK 4835', '0', '1', '42');
INSERT INTO `xls_bk_stock` VALUES ('SINK 6045 B', '0', '1', '40');
INSERT INTO `xls_bk_stock` VALUES ('SINK 3018', '0', '1', '15');
INSERT INTO `xls_bk_stock` VALUES ('SINK 2046', '0', '1', '9');
INSERT INTO `xls_bk_stock` VALUES ('SINK H/M 7843 ', '0', '1', '-1');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('SLAB', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 6149 24\'\' W', '0', '0', '7');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3070-28\'\' W', '0', '0', '18');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3080-32\'\' W', '0', '0', '15');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3090-36\'\' W', '0', '0', '81');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 6140 W 24*12', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3100-40\'\' W', '4', '0', '6');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3120-48\'\' W', '0', '0', '18');
INSERT INTO `xls_bk_stock` VALUES ('SLAB SOQEAR 32\'\' 8046 W', '0', '0', '14');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3090-36\'\' IVORY', '0', '0', '15');
INSERT INTO `xls_bk_stock` VALUES ('SLAB 3100-40\'\' IVORY', '0', '0', '7');
INSERT INTO `xls_bk_stock` VALUES ('BOWAL', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL Y016', '0', '0', '4');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 004', '0', '0', '17');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 005', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL U/C 1002', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL U/C RI-019', '1', '0', '9');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL U/C F917', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL U/C AS-206', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL RB -39', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 068', '0', '0', '6');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 073', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 580-A', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 5514', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL 8619', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL BK-30B', '0', '0', '5');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL BK-40B', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL BK-50B', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL BK-10B', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-306', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-058', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-052', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-055', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-031', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-091', '0', '0', '4');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-057', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-027', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL LX-054', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL VG-713', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL VG-706', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL VG-022', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL VG-664', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL MJ-220', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAWOL MJ-302', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET SONEX', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWERSET 4091/4093', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SSHWER SET 3111/3113', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 3141/3143', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 3151/3153', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 3131/3133', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 3171/3173', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 4051/4053', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 4061/4063', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 4071/4073', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 4081/4083', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 112/111', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 251/252', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 317/318', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 320/322', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 381/383', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 491/493', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 641/643', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHWER SET 991/993', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHWER', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHWER 524', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHWER 520', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('T-ARM', '0', '0', '43');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER SONEX', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 3151', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 4071', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 661-C', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 991', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 441', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 6031', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 751', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 3131', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BATH MIXER 691', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER SONEX', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 644', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 4093', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 4011', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 4073', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 673', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 4053', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 5073', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 633', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER 623', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER SONEX', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 316', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 909', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER 907', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK', '0', '0', '21');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER SONEX', '0', '0', '40');
INSERT INTO `xls_bk_stock` VALUES ('JUTT SHWER 532', '0', '0', '6');
INSERT INTO `xls_bk_stock` VALUES ('JUTT SHWER 518', '0', '0', '54');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET TENSO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET CONCETO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET LINEAR', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET STYLE CASMO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET SAMRT CASMO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET SMART', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET ECO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET DIS CASMO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET CUBE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET ESSENCE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET BLOOP', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SHAWER SET BAU EDGE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER EURO DISCASMO 33390002', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER EURO SMARTCASMO 32831000', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER BOULOOP 32815000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER BAU EDGE 32820000', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER  EURO SAMRT 33344441', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BAHT MIXER EURO STYLE CASMO 33591002', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER BAUOEG', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER BOULOOP 32814000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER EUROSTYL CASMO 33552002', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER CUBE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER LINEAR', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASAIN MIXER CONCETTO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER EURO SMART 32482001', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT GROHE 13255000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SPOUT GROHE 13252000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK 220170000M', '0', '0', '10');
INSERT INTO `xls_bk_stock` VALUES ('SALDING RAD GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SALDING RAD 27368000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SALDING RAD 28436', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SALDING RAD ', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('HAND SHWER GROHE 27673000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('HAND SHWER GROHE 27675000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER GROHE MEAT', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER GROHE WHITE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('RAIN SHWER EURO PLUS 124', '0', '0', '11');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET GROHE ORGNAL', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET N.A EURO CUBE 19898000', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET N.A ESSENCE 19286000', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET EURO DISC 19549001', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET AUTO BAULOOP 29041000', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET N.A CHIARA 19156000', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET N.A EURO STYLE', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET DISC NAN AUTO GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET LINEAR NAN AUTO GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET CHIRA NAN AUTO GROHE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('GROHE BAHT MIXER CHI EURODISCOSMO', '0', '0', '34');
INSERT INTO `xls_bk_stock` VALUES ('GROHE BAHT MIXER CHI EURODISC', '0', '0', '9');
INSERT INTO `xls_bk_stock` VALUES ('GROHE BAHT MIXER CHI QUDERA', '0', '0', '5');
INSERT INTO `xls_bk_stock` VALUES ('GROHE BAHT MIXER CHI SMRT CASMO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('GROHE BAHT MIXER CHI EURO STYLE', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('GROHE BAHT MIXER CHI SMRT ', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER EURO DISC', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER EURO SAMRT', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER EURO SAMRT CASMO', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER EURO DISC CASMO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER CUBE', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER EURO STYEL', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER CONCETTO', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('BASIN MIXER QUADERA', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('SINK MIXER CHI ', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER GROHE CHI', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER MATT', '0', '0', '6');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER CP', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER MATT ONLY HEAD', '0', '0', '66');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER ONLY HEAD', '0', '0', '41');
INSERT INTO `xls_bk_stock` VALUES ('HAND SHWER TEMPESTE', '0', '0', '123');
INSERT INTO `xls_bk_stock` VALUES ('AUTO BODY 33963000', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('NON AUTO BODY ', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SLIDING ROD EUPHORIA', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('SLIDING ROD XOXO', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('DAIL PLET EURO SMART GROHE CHI', '0', '0', '26');
INSERT INTO `xls_bk_stock` VALUES ('CLASSIC SET OCTION', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('CLASSIC SET CANON', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('SWANA SET', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('PROPHET SET', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('DOWAL SET', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('CAPRICON SET CLASSIC', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('SAHRA SET CLASSIC', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('RADO-B SET CLASSIC', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('BOLON SET CLASSIC', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('JAZZ SET CLASSIC', '0', '0', '5');
INSERT INTO `xls_bk_stock` VALUES ('KAMAN SET CLASSIC', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('NAYLON SET CLASSIC', '0', '0', '4');
INSERT INTO `xls_bk_stock` VALUES ('REMAX SET CLASSIC', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('VECTRON SET CLASSIC', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('DHOL SET CLASSIC', '0', '0', '3');
INSERT INTO `xls_bk_stock` VALUES ('KATER SET CLASSIC', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('VICTORION SET CLASSIC', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('KASHMIR SINK MIXER  CLASSIC', '0', '0', '7');
INSERT INTO `xls_bk_stock` VALUES ('DELTA SINK MIXER CLASSIC', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('KAMEO SINK MIXER CLASSIC', '0', '1', '1');
INSERT INTO `xls_bk_stock` VALUES ('OCEAN SINK MIXER CLASSIC', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('BOLON SINK MIXER CLASSIC', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('VANITY BAWOL MIXER CLASSIC', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('DELTA BASIN MIXER CLASSIC', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('RIVER BASIN MIXER CLASSIC', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('VIGO BASIN MIXER CLASSIC', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('NEW LEVER BASIN MIXER ', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('COMMON BASIN MIXER ', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('PROPHET LEVER BATH MIXER', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('SINKAM BATH MIXER ', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('RIVER KULLI BATH MIXER', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('RIVER SOQEAR BATH MIXER', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('COMMON BATH MIXER ', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK REVER ', '0', '0', '12');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK PLUS', '0', '0', '2');
INSERT INTO `xls_bk_stock` VALUES ('T-COCK VIGO', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('D-BIB COCK RIVER', '0', '0', '4');
INSERT INTO `xls_bk_stock` VALUES ('D-BIB COCK PLUS', '0', '0', '1');
INSERT INTO `xls_bk_stock` VALUES ('MUSLIM SHWER CLASSIC', '0', '0', '4');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 601', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 701', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 801', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 70102', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY P-010', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY P-053', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY CA-538', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY CA-70272', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY SP5206-1500', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY RI-712-120', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 6142', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY RI-704-70', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 6140', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('VANITY 3100 W00D', '0', '0', '0');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');
INSERT INTO `xls_bk_stock` VALUES ('', '', '', '');

-- ----------------------------
-- Table structure for `xls_imp_cat`
-- ----------------------------
DROP TABLE IF EXISTS `xls_imp_cat`;
CREATE TABLE `xls_imp_cat` (
  `description` varchar(255) DEFAULT NULL,
  `K` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_imp_cat
-- ----------------------------
INSERT INTO `xls_imp_cat` VALUES ('ACCESSORY SET', 'K');
INSERT INTO `xls_imp_cat` VALUES ('ART BOWEL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BAR 71011', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BASIN EXTENSION', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BASIN MIXER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BASIN PADESTAL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BASIN WAST', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BASKET', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BATH MIXER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BATH WAST', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BIB COCK', 'K');
INSERT INTO `xls_imp_cat` VALUES ('BOTAL TRYP', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BOX', 'B');
INSERT INTO `xls_imp_cat` VALUES ('BRUSH HOLDER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CABNET BOX', 'B');
INSERT INTO `xls_imp_cat` VALUES ('COMMODE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CONCELED BODY', 'K');
INSERT INTO `xls_imp_cat` VALUES ('COOKING RANGE', 'K');
INSERT INTO `xls_imp_cat` VALUES ('CP BUSH 3/8*1/2', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP CUP', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP CUP SMALL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP NAT 1/4', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP NOZEL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP PIPE 1 FT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP PIPE 2 FT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CP PIPE 3 FT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('CURTAIN', 'B');
INSERT INTO `xls_imp_cat` VALUES ('DIAL PLATE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('DIVIDER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('DUST BIN', 'B');
INSERT INTO `xls_imp_cat` VALUES ('ESPA PUMP', 'B');
INSERT INTO `xls_imp_cat` VALUES ('EXTENTION', 'B');
INSERT INTO `xls_imp_cat` VALUES ('FLEX DAMAGE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('FLOOR WAST', 'B');
INSERT INTO `xls_imp_cat` VALUES ('FLUSH TANK', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GEBERIT BEND 367.792.19.1', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GEBERIT STRAIGHT PIPE 152.420.4', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GLASS DISH', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GOLA', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GRAB BAR HS-30118', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GRAB BAR HS-30312', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GRAY BAR 12\"', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GRAY BAR 9\"', 'B');
INSERT INTO `xls_imp_cat` VALUES ('GYSER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HAND DRAYER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HAND SHOWER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HANDLE 905-192', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HOB', 'K');
INSERT INTO `xls_imp_cat` VALUES ('HOOD', 'K');
INSERT INTO `xls_imp_cat` VALUES ('HOOK', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HOOK COAT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HOOK COAT GROHE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HOOK MUSLIM SHOWER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('HOOK ZILVER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('JACUZZI', 'B');
INSERT INTO `xls_imp_cat` VALUES ('JALI', 'B');
INSERT INTO `xls_imp_cat` VALUES ('JET SHOWER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('JUMBO LON', 'B');
INSERT INTO `xls_imp_cat` VALUES ('KIT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('KITCHEN ACCESSORY', 'K');
INSERT INTO `xls_imp_cat` VALUES ('L BRACKET 3\" 1715', 'B');
INSERT INTO `xls_imp_cat` VALUES ('LONG BOLT S.S', 'B');
INSERT INTO `xls_imp_cat` VALUES ('LOSE ITEM', 'K');
INSERT INTO `xls_imp_cat` VALUES ('MICRO OVEN', 'K');
INSERT INTO `xls_imp_cat` VALUES ('MIRROR', 'B');
INSERT INTO `xls_imp_cat` VALUES ('MUSLIM SHOWER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('NALKA ROUND 0088 N.C', 'B');
INSERT INTO `xls_imp_cat` VALUES ('NAT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('NECK MEDIUM', 'B');
INSERT INTO `xls_imp_cat` VALUES ('NIPLE BARREL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('NIPLE CP 1/2 * 3/4', 'B');
INSERT INTO `xls_imp_cat` VALUES ('NOZEL COCK 1/2', 'B');
INSERT INTO `xls_imp_cat` VALUES ('OVER COUNTER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('PAPER HOLDER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('PIPE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('POP WAST', 'B');
INSERT INTO `xls_imp_cat` VALUES ('PUSH WAST', 'B');
INSERT INTO `xls_imp_cat` VALUES ('PUSH WAST BRASS', 'B');
INSERT INTO `xls_imp_cat` VALUES ('PUSH WAST SMALL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('RACK', 'B');
INSERT INTO `xls_imp_cat` VALUES ('RAIN SHOWER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('ROSE PATEL BOX', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SANGI 704', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SCREW HOOK 12', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SEAT COVER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SHOWER CABIN', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SHOWER PANEL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SHOWER ROOM', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SHOWER SET', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SIDE BOX 705', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SIDE PILLER COCK', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SILICON', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SINK', 'K');
INSERT INTO `xls_imp_cat` VALUES ('SINK BASKET', 'K');
INSERT INTO `xls_imp_cat` VALUES ('SINK FITTING', 'K');
INSERT INTO `xls_imp_cat` VALUES ('SINK MIXER', 'K');
INSERT INTO `xls_imp_cat` VALUES ('SINK WAST', 'K');
INSERT INTO `xls_imp_cat` VALUES ('SLAB', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SLIDING RAD', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SOAP DISH', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SOAP DSPENSER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('SPOUT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('STAND', 'B');
INSERT INTO `xls_imp_cat` VALUES ('STOPC 3704', 'B');
INSERT INTO `xls_imp_cat` VALUES ('T-ARM', 'K');
INSERT INTO `xls_imp_cat` VALUES ('T-COCK', 'K');
INSERT INTO `xls_imp_cat` VALUES ('TAFLON TAPE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TAFLON TAPE BIG', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TANKI PLATE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TANKI PLATE DUAL 38506000', 'B');
INSERT INTO `xls_imp_cat` VALUES ('THIMBLE ALPHAIN', 'B');
INSERT INTO `xls_imp_cat` VALUES ('THIMBLE GREES', 'B');
INSERT INTO `xls_imp_cat` VALUES ('THIMBLE SET', 'B');
INSERT INTO `xls_imp_cat` VALUES ('THIMBLE UK', 'B');
INSERT INTO `xls_imp_cat` VALUES ('THIMBLE WHITE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('THREAD GOLA', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TILE', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TOILET SHOWER BOD', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TOWEL RAD', 'B');
INSERT INTO `xls_imp_cat` VALUES ('TOWEL RING', 'B');
INSERT INTO `xls_imp_cat` VALUES ('U BEND WWT', 'B');
INSERT INTO `xls_imp_cat` VALUES ('UNDER COUNTER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('UPPER COUNTER', 'B');
INSERT INTO `xls_imp_cat` VALUES ('URINAL', 'B');
INSERT INTO `xls_imp_cat` VALUES ('URIRNAL PORTA', 'B');
INSERT INTO `xls_imp_cat` VALUES ('VANITY', 'B');
INSERT INTO `xls_imp_cat` VALUES ('W.C', 'B');
INSERT INTO `xls_imp_cat` VALUES ('WASHER CONNECTION', 'B');
INSERT INTO `xls_imp_cat` VALUES ('WOOD FLOOR', 'F');

-- ----------------------------
-- Table structure for `xls_imp_item`
-- ----------------------------
DROP TABLE IF EXISTS `xls_imp_item`;
CREATE TABLE `xls_imp_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3991 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_imp_item
-- ----------------------------
INSERT INTO `xls_imp_item` VALUES ('2520', '0001', 'ACCESSORY SET:0600 7 PCS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2521', '0002', 'ACCESSORY SET:10000 7 PCS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2522', '0003', 'ACCESSORY SET:1100', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2523', '0004', 'ACCESSORY SET:11309', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2524', '0005', 'ACCESSORY SET:14013 KOTO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2525', '0006', 'ACCESSORY SET:1500', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2526', '0007', 'ACCESSORY SET:1600', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2527', '0008', 'ACCESSORY SET:2 FT KBS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2528', '0009', 'ACCESSORY SET:2300', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2529', '0010', 'ACCESSORY SET:2600', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2530', '0011', 'ACCESSORY SET:4002 LUXURY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2531', '0012', 'ACCESSORY SET:4034', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2532', '0013', 'ACCESSORY SET:40344', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2533', '0014', 'ACCESSORY SET:4054', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2534', '0015', 'ACCESSORY SET:4064', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2535', '0016', 'ACCESSORY SET:4900', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2536', '0017', 'ACCESSORY SET:5200', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2537', '0018', 'ACCESSORY SET:8001 GOLD', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2538', '0019', 'ACCESSORY SET:8002 CP', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2539', '0020', 'ACCESSORY SET:8002 KOTO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2540', '0021', 'ACCESSORY SET:8013', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2541', '0022', 'ACCESSORY SET:8014', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2542', '0023', 'ACCESSORY SET:B&K NEW', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2543', '0024', 'ACCESSORY SET:BK 1000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2544', '0025', 'ACCESSORY SET:BK 1900', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2545', '0026', 'ACCESSORY SET:BK 2000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2546', '0027', 'ACCESSORY SET:BK 3000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2547', '0028', 'ACCESSORY SET:CLASSIC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2548', '0029', 'ACCESSORY SET:DIAMOND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2549', '0030', 'ACCESSORY SET:DIAMOND NEW', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2550', '0031', 'ACCESSORY SET:ELEGANCE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2551', '0032', 'ACCESSORY SET:FASTENING SET 1909', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2552', '0033', 'ACCESSORY SET:GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2553', '0034', 'ACCESSORY SET:GROHE CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2554', '0035', 'ACCESSORY SET:JAGUAR CLASSIC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2555', '0036', 'ACCESSORY SET:OCEAN TREND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2556', '0037', 'ACCESSORY SET:QUEEN', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2557', '0038', 'ACCESSORY SET:ROUND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2558', '0039', 'ACCESSORY SET:ROYAL', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2559', '0040', 'ACCESSORY SET:SKY LAND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2560', '0041', 'ACCESSORY SET:SOLO CP', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2561', '0042', 'ACCESSORY SET:SQUAR', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2562', '0043', 'ACCESSORY SET:TOP MOUNT', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2563', '0044', 'ACCESSORY SET:VANITY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2564', '0045', 'ACCESSORY SET:VIGRA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2565', '0046', 'ART BOWEL:001', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2566', '0047', 'ART BOWEL:002', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2567', '0048', 'ART BOWEL:006', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2568', '0049', 'ART BOWEL:007', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2569', '0050', 'ART BOWEL:019', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2570', '0051', 'ART BOWEL:027', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2571', '0052', 'ART BOWEL:031-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2572', '0053', 'ART BOWEL:042-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2573', '0054', 'ART BOWEL:046-LEXTA WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2574', '0055', 'ART BOWEL:051-LEXTA WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2575', '0056', 'ART BOWEL:052-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2576', '0057', 'ART BOWEL:057-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2577', '0058', 'ART BOWEL:068 IVORY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2578', '0059', 'ART BOWEL:073', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2579', '0060', 'ART BOWEL:083-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2580', '0061', 'ART BOWEL:1006', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2581', '0062', 'ART BOWEL:114', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2582', '0063', 'ART BOWEL:114-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2583', '0064', 'ART BOWEL:12-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2584', '0065', 'ART BOWEL:120', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2585', '0066', 'ART BOWEL:14-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2586', '0067', 'ART BOWEL:152 MARACHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2587', '0068', 'ART BOWEL:157-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2588', '0069', 'ART BOWEL:169', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2589', '0070', 'ART BOWEL:2001', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2590', '0071', 'ART BOWEL:220-MD', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2591', '0072', 'ART BOWEL:227 MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2592', '0073', 'ART BOWEL:228-MD', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2593', '0074', 'ART BOWEL:239-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2594', '0075', 'ART BOWEL:2452', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2595', '0076', 'ART BOWEL:288', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2596', '0077', 'ART BOWEL:301', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2597', '0078', 'ART BOWEL:305 MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2598', '0079', 'ART BOWEL:306', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2599', '0080', 'ART BOWEL:307 MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2600', '0081', 'ART BOWEL:4546', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2601', '0082', 'ART BOWEL:47-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2602', '0083', 'ART BOWEL:477', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2603', '0084', 'ART BOWEL:5000 C', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2604', '0085', 'ART BOWEL:5004', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2605', '0086', 'ART BOWEL:55-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2606', '0087', 'ART BOWEL:6061', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2607', '0088', 'ART BOWEL:6068', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2608', '0089', 'ART BOWEL:6089 IMC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2609', '0090', 'ART BOWEL:7005', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2610', '0091', 'ART BOWEL:7235', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2611', '0092', 'ART BOWEL:7386', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2612', '0093', 'ART BOWEL:7562', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2613', '0094', 'ART BOWEL:7565 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2614', '0095', 'ART BOWEL:7604', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2615', '0096', 'ART BOWEL:7627', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2616', '0097', 'ART BOWEL:7704', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2617', '0098', 'ART BOWEL:7709 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2618', '0099', 'ART BOWEL:7756', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2619', '0100', 'ART BOWEL:8432 IVORY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2620', '0101', 'ART BOWEL:8604', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2621', '0102', 'ART BOWEL:8611', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2622', '0103', 'ART BOWEL:8617 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2623', '0104', 'ART BOWEL:8618', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2624', '0105', 'ART BOWEL:8619 IVORY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2625', '0106', 'ART BOWEL:8629 IVORY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2626', '0107', 'ART BOWEL:8629 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2627', '0108', 'ART BOWEL:8641', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2628', '0109', 'ART BOWEL:8652 IVORY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2629', '0110', 'ART BOWEL:9060', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2630', '0111', 'ART BOWEL:9064-MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2631', '0112', 'ART BOWEL:A 03', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2632', '0113', 'ART BOWEL:CERAMIC BIG U TYPE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2633', '0114', 'ART BOWEL:CERAMIC LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2634', '0115', 'ART BOWEL:CERAMIC TYRE TYPE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2635', '0116', 'ART BOWEL:COLOR', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2636', '0117', 'ART BOWEL:HD 008', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2637', '0118', 'ART BOWEL:HD 01', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2638', '0119', 'ART BOWEL:HD 015', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2639', '0120', 'ART BOWEL:HD 03', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2640', '0121', 'ART BOWEL:LOCAL', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2641', '0122', 'ART BOWEL:M 302', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2642', '0123', 'ART BOWEL:MB 52 CITO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2643', '0124', 'ART BOWEL:RB 02', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2644', '0125', 'ART BOWEL:RB 12', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2645', '0126', 'ART BOWEL:RB 13', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2646', '0127', 'ART BOWEL:RB 14', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2647', '0128', 'ART BOWEL:RB 39', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2648', '0129', 'ART BOWEL:Y 003', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2649', '0130', 'ART BOWEL:Y 016', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2650', '0131', 'ART BOWEL:Y 032', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2651', '0132', 'ART BOWEL:Y 033', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2652', '0133', 'ART BOWEL:Y 047', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2653', '0134', 'ART BOWEL:Y 051', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2654', '0135', 'ART BOWEL:Y 068', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2655', '0136', 'BASIN MIXER:0038 CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2656', '0137', 'BASIN MIXER:0088', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2657', '0138', 'BASIN MIXER:033', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2658', '0139', 'BASIN MIXER:054-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2659', '0140', 'BASIN MIXER:058-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2660', '0141', 'BASIN MIXER:1000-L-1 S-S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2661', '0142', 'BASIN MIXER:111', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2662', '0143', 'BASIN MIXER:1805-KM CP', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2663', '0144', 'BASIN MIXER:189', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2664', '0145', 'BASIN MIXER:2-HOLE W/M 19895000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2665', '0146', 'BASIN MIXER:201', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2666', '0147', 'BASIN MIXER:20143000 GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2667', '0148', 'BASIN MIXER:211', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2668', '0149', 'BASIN MIXER:23127000 EURO CUBE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2669', '0150', 'BASIN MIXER:23136000 LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2670', '0151', 'BASIN MIXER:23303000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2671', '0152', 'BASIN MIXER:2500', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2672', '0153', 'BASIN MIXER:2601', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2673', '0154', 'BASIN MIXER:293', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2674', '0155', 'BASIN MIXER:2D', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2675', '0156', 'BASIN MIXER:3113', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2676', '0157', 'BASIN MIXER:3133', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2677', '0158', 'BASIN MIXER:3143', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2678', '0159', 'BASIN MIXER:3153', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2679', '0160', 'BASIN MIXER:3173', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2680', '0161', 'BASIN MIXER:318', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2681', '0162', 'BASIN MIXER:32630000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2682', '0163', 'BASIN MIXER:32737000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2683', '0164', 'BASIN MIXER:32814000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2684', '0165', 'BASIN MIXER:3281900', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2685', '0166', 'BASIN MIXER:32825000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2686', '0167', 'BASIN MIXER:32856 BAULOOP', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2687', '0168', 'BASIN MIXER:32856000 LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2688', '0169', 'BASIN MIXER:32860000 LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2689', '0170', 'BASIN MIXER:33190002', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2690', '0171', 'BASIN MIXER:33265001 EURO ECO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2691', '0172', 'BASIN MIXER:33532000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2692', '0173', 'BASIN MIXER:33552001', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2693', '0174', 'BASIN MIXER:33552002', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2694', '0175', 'BASIN MIXER:383', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2695', '0176', 'BASIN MIXER:384 SONEX', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2696', '0177', 'BASIN MIXER:4033', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2697', '0178', 'BASIN MIXER:4053', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2698', '0179', 'BASIN MIXER:4063', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2699', '0180', 'BASIN MIXER:4073', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2700', '0181', 'BASIN MIXER:4083', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2701', '0182', 'BASIN MIXER:4093', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2702', '0183', 'BASIN MIXER:423', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2703', '0184', 'BASIN MIXER:443', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2704', '0185', 'BASIN MIXER:493', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2705', '0186', 'BASIN MIXER:506', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2706', '0187', 'BASIN MIXER:566 LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2707', '0188', 'BASIN MIXER:623 SONEX', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2708', '0189', 'BASIN MIXER:631-MK', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2709', '0190', 'BASIN MIXER:633', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2710', '0191', 'BASIN MIXER:640-MK', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2711', '0192', 'BASIN MIXER:643', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2712', '0193', 'BASIN MIXER:644', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2713', '0194', 'BASIN MIXER:658', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2714', '0195', 'BASIN MIXER:666', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2715', '0196', 'BASIN MIXER:673', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2716', '0197', 'BASIN MIXER:810', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2717', '0198', 'BASIN MIXER:812', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2718', '0199', 'BASIN MIXER:9121', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2719', '0200', 'BASIN MIXER:9744', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2720', '0201', 'BASIN MIXER:9745', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2721', '0202', 'BASIN MIXER:983', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2722', '0203', 'BASIN MIXER:993', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2723', '0204', 'BASIN MIXER:A 002 PORTA WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2724', '0205', 'BASIN MIXER:ABSHAR', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2725', '0206', 'BASIN MIXER:ABSHAR GLASS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2726', '0207', 'BASIN MIXER:ABSHAR METAL', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2727', '0208', 'BASIN MIXER:AMJAD 1 HOLE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2728', '0209', 'BASIN MIXER:AMJAD 1 HOLE HEAVY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2729', '0210', 'BASIN MIXER:AMJAD LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2730', '0211', 'BASIN MIXER:BAU EDGE GROHE ORG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2731', '0212', 'BASIN MIXER:BAU EDGE LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2732', '0213', 'BASIN MIXER:BAULOOP GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2733', '0214', 'BASIN MIXER:BAULOOP LONG GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2734', '0215', 'BASIN MIXER:BAULOOP SMALL', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2735', '0216', 'BASIN MIXER:BK-57', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2736', '0217', 'BASIN MIXER:COMMON', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2737', '0218', 'BASIN MIXER:CONCETO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2738', '0219', 'BASIN MIXER:DELTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2739', '0220', 'BASIN MIXER:DISC COSMO CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2740', '0221', 'BASIN MIXER:DISC COSMO GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2741', '0222', 'BASIN MIXER:ECO GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2742', '0223', 'BASIN MIXER:ESSENCE GROHE ORG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2743', '0224', 'BASIN MIXER:ESSENCE LONG GROHE ORG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2744', '0225', 'BASIN MIXER:EURO COSMO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2745', '0226', 'BASIN MIXER:EURO CUBE LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2746', '0227', 'BASIN MIXER:EURO DISC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2747', '0228', 'BASIN MIXER:EURO DISC COSMOPOLITAN', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2748', '0229', 'BASIN MIXER:EURO ECO 32732', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2749', '0230', 'BASIN MIXER:EURO PLUS GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2750', '0231', 'BASIN MIXER:EURO SMART BIDET', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2751', '0232', 'BASIN MIXER:EURO SMART CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2752', '0233', 'BASIN MIXER:EURO SMART COSMO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2753', '0234', 'BASIN MIXER:EURO SMART GROHE ORG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2754', '0235', 'BASIN MIXER:EURO STYLE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2755', '0236', 'BASIN MIXER:GOLDEN MIXER SMALL 0102-G', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2756', '0237', 'BASIN MIXER:GRANDERA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2757', '0238', 'BASIN MIXER:HDL 4008 PORTA WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2758', '0239', 'BASIN MIXER:JAZZ 1401', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2759', '0240', 'BASIN MIXER:LINEARE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2760', '0241', 'BASIN MIXER:LOCAL', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2761', '0242', 'BASIN MIXER:LONG BRASS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2762', '0243', 'BASIN MIXER:M 56', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2763', '0244', 'BASIN MIXER:MASTER', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2764', '0245', 'BASIN MIXER:OREAL', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2765', '0246', 'BASIN MIXER:PA 100-1', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2766', '0247', 'BASIN MIXER:QAUDRA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2767', '0248', 'BASIN MIXER:QUADRA CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2768', '0249', 'BASIN MIXER:QUADRA GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2769', '0250', 'BASIN MIXER:QUBE CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2770', '0251', 'BASIN MIXER:QUBE GROHE ORG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2771', '0252', 'BASIN MIXER:RADO B', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2772', '0253', 'BASIN MIXER:REMAX', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2773', '0254', 'BASIN MIXER:SQUAR LONG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2774', '0255', 'BASIN MIXER:SQUAR MEDIUM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2775', '0256', 'BASIN MIXER:SQUAR NALKA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2776', '0257', 'BASIN MIXER:STYLISH CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2777', '0258', 'BASIN MIXER:TENSO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2778', '0259', 'BASIN MIXER:U SPOUT (32146000)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2779', '0260', 'BASIN MIXER:VANITY BOWL MIXER', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2780', '0261', 'BASIN MIXER:VANITY RADO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2781', '0262', 'BASIN MIXER:VIGO 2601', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2782', '0263', 'BASIN MIXER:XOXO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2783', '0264', 'BASIN PADESTAL:008-MC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2784', '0265', 'BASIN PADESTAL:102', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2785', '0266', 'BASIN PADESTAL:2011-MC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2786', '0267', 'BASIN PADESTAL:2020-MC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2787', '0268', 'BASIN PADESTAL:2048 M.C', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2788', '0269', 'BASIN PADESTAL:2469', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2789', '0270', 'BASIN PADESTAL:338', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2790', '0271', 'BASIN PADESTAL:3600-WHITE (LEXTA)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2791', '0272', 'BASIN PADESTAL:3700-WHITE (LEXTA)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2792', '0273', 'BASIN PADESTAL:839 A/S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2793', '0274', 'BASIN PADESTAL:915 A/S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2794', '0275', 'BASIN PADESTAL:916', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2795', '0276', 'BASIN PADESTAL:IMC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2796', '0277', 'BASIN PADESTAL:LOCAL IFO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2797', '0278', 'BASIN PADESTAL:WHITE (M)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2798', '0279', 'BASIN WAST:507 SONEX', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2799', '0280', 'BASIN WAST:LONG S.S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2800', '0281', 'BASKET:5600243', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2801', '0282', 'BASKET:56007225', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2802', '0283', 'BASKET:5600912', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2803', '0284', 'BASKET:5601148', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2804', '0285', 'BASKET:A 57', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2805', '0286', 'BASKET:CWJ 225', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2806', '0287', 'BASKET:LADAR 6', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2807', '0288', 'BASKET:ML 007C PULL OUT', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2808', '0289', 'BASKET:PTJ 23 E', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2809', '0290', 'BATH MIXER:0100', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2810', '0291', 'BATH MIXER:23140000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2811', '0292', 'BATH MIXER:251', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2812', '0293', 'BATH MIXER:253', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2813', '0294', 'BATH MIXER:291', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2814', '0295', 'BATH MIXER:3111', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2815', '0296', 'BATH MIXER:3131', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2816', '0297', 'BATH MIXER:3141', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2817', '0298', 'BATH MIXER:3151', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2818', '0299', 'BATH MIXER:317', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2819', '0300', 'BATH MIXER:3171', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2820', '0301', 'BATH MIXER:321', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2821', '0302', 'BATH MIXER:32638000 QUADRA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2822', '0303', 'BATH MIXER:32743000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2823', '0304', 'BATH MIXER:32815000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2824', '0305', 'BATH MIXER:32820000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2825', '0306', 'BATH MIXER:32831000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2826', '0307', 'BATH MIXER:33300001', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2827', '0308', 'BATH MIXER:33390002', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2828', '0309', 'BATH MIXER:33624000', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2829', '0310', 'BATH MIXER:381 A', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2830', '0311', 'BATH MIXER:4021', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2831', '0312', 'BATH MIXER:4051', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2832', '0313', 'BATH MIXER:4061', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2833', '0314', 'BATH MIXER:4071', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2834', '0315', 'BATH MIXER:4081', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2835', '0316', 'BATH MIXER:4091', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2836', '0317', 'BATH MIXER:421', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2837', '0318', 'BATH MIXER:441', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2838', '0319', 'BATH MIXER:491', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2839', '0320', 'BATH MIXER:631', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2840', '0321', 'BATH MIXER:641', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2841', '0322', 'BATH MIXER:644', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2842', '0323', 'BATH MIXER:661', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2843', '0324', 'BATH MIXER:671', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2844', '0325', 'BATH MIXER:681', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2845', '0326', 'BATH MIXER:6832', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2846', '0327', 'BATH MIXER:8402', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2847', '0328', 'BATH MIXER:8403', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2848', '0329', 'BATH MIXER:981', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2849', '0330', 'BATH MIXER:991', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2850', '0331', 'BATH MIXER:BAU EDGE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2851', '0332', 'BATH MIXER:BAULOOP', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2852', '0333', 'BATH MIXER:BAULOOP COSMOPOLITAN', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2853', '0334', 'BATH MIXER:CONCETTO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2854', '0335', 'BATH MIXER:DELTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2855', '0336', 'BATH MIXER:DISC CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2856', '0337', 'BATH MIXER:DISC COMSO GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2857', '0338', 'BATH MIXER:DISC COSMO CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2858', '0339', 'BATH MIXER:ECO GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2859', '0340', 'BATH MIXER:ESSENCE GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2860', '0341', 'BATH MIXER:EURO COSMO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2861', '0342', 'BATH MIXER:EURO CUBE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2862', '0343', 'BATH MIXER:EURO DISC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2863', '0344', 'BATH MIXER:EURO DISC COSMOPOLITAN', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2864', '0345', 'BATH MIXER:EURO ECO SMART', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2865', '0346', 'BATH MIXER:EURO PLUS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2866', '0347', 'BATH MIXER:EURO SMART', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2867', '0348', 'BATH MIXER:EURO SMART CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2868', '0349', 'BATH MIXER:EURO SMART COSMO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2869', '0350', 'BATH MIXER:EURO SMART ORG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2870', '0351', 'BATH MIXER:EURO STYLE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2871', '0352', 'BATH MIXER:GRANDERA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2872', '0353', 'BATH MIXER:LINEARE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2873', '0354', 'BATH MIXER:MASTER', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2874', '0355', 'BATH MIXER:NICE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2875', '0356', 'BATH MIXER:QUADRA CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2876', '0357', 'BATH MIXER:QUADRA GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2877', '0358', 'BATH MIXER:QUBE 2314', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2878', '0359', 'BATH MIXER:REVER SQUARE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2879', '0360', 'BATH MIXER:STYLE CHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2880', '0361', 'BATH WAST:VEGA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2881', '0362', 'BIB COCK:3009801', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2882', '0363', 'BIB COCK:355', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2883', '0364', 'BIB COCK:405', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2884', '0365', 'BIB COCK:415', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2885', '0366', 'BIB COCK:417', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2886', '0367', 'BIB COCK:A/S 1/2', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2887', '0368', 'BIB COCK:COSTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2888', '0369', 'BIB COCK:SARTAJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2889', '0370', 'BIB COCK:SINGAL CHROM', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2890', '0371', 'BIB COCK:STYLISH 1/2', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2891', '0372', 'BIB COCK:WWT', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2892', '0373', 'BOTAL TRYP:BRASS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2893', '0374', 'BOTAL TRYP:GROHE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2894', '0375', 'BOTAL TRYP:R.S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2895', '0376', 'BOTAL TRYP:WWT', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2896', '0377', 'BOX:AIR FRESHNER', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2897', '0378', 'BOX:TISSUE BOX', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2898', '0379', 'BRUSH HOLDER:GALA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2899', '0380', 'BRUSH HOLDER:LOSE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2900', '0381', 'BRUSH HOLDER:WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2901', '0382', 'CABNET BOX:1036', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2902', '0383', 'CABNET BOX:1202', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2903', '0384', 'CABNET BOX:2019 CABNET', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2904', '0385', 'CABNET BOX:6009-A S.S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2905', '0386', 'CABNET BOX:6652 CABNET S.S', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2906', '0387', 'CABNET BOX:705', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2907', '0388', 'CABNET BOX:706', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2908', '0389', 'CABNET BOX:708 CABINET', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2909', '0390', 'CABNET BOX:710101', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2910', '0391', 'CABNET BOX:714', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2911', '0392', 'CABNET BOX:815', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2912', '0393', 'CABNET BOX:831 STANDING', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2913', '0394', 'CABNET BOX:STEEL WOOD 100GM MARACHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2914', '0395', 'CABNET BOX:STEEL WOOD 80CM MARACHI', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2915', '0396', 'COMMODE:001', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2916', '0397', 'COMMODE:019-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2917', '0398', 'COMMODE:02', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2918', '0399', 'COMMODE:059', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2919', '0400', 'COMMODE:08 MJ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2920', '0401', 'COMMODE:1017', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2921', '0402', 'COMMODE:102', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2922', '0403', 'COMMODE:102 N', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2923', '0404', 'COMMODE:105', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2924', '0405', 'COMMODE:1067 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2925', '0406', 'COMMODE:1068', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2926', '0407', 'COMMODE:108', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2927', '0408', 'COMMODE:1100', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2928', '0409', 'COMMODE:11093', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2929', '0410', 'COMMODE:112', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2930', '0411', 'COMMODE:113', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2931', '0412', 'COMMODE:133', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2932', '0413', 'COMMODE:138', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2933', '0414', 'COMMODE:1400', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2934', '0415', 'COMMODE:154-LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2935', '0416', 'COMMODE:1700', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2936', '0417', 'COMMODE:2004 WALL HAND IVORY', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2937', '0418', 'COMMODE:2006', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2938', '0419', 'COMMODE:2006-MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2939', '0420', 'COMMODE:201', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2940', '0421', 'COMMODE:2016 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2941', '0422', 'COMMODE:2018 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2942', '0423', 'COMMODE:2019 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2943', '0424', 'COMMODE:2027', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2944', '0425', 'COMMODE:205-RI WALL HAND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2945', '0426', 'COMMODE:2051 MA-CITO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2946', '0427', 'COMMODE:2054 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2947', '0428', 'COMMODE:2055', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2948', '0429', 'COMMODE:2060 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2949', '0430', 'COMMODE:2077 MA CITO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2950', '0431', 'COMMODE:2078', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2951', '0432', 'COMMODE:2078 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2952', '0433', 'COMMODE:208', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2953', '0434', 'COMMODE:208-A', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2954', '0435', 'COMMODE:2080 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2955', '0436', 'COMMODE:2082 LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2956', '0437', 'COMMODE:2083', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2957', '0438', 'COMMODE:2086', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2958', '0439', 'COMMODE:209', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2959', '0440', 'COMMODE:2091', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2960', '0441', 'COMMODE:2100', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2961', '0442', 'COMMODE:2127', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2962', '0443', 'COMMODE:2128', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2963', '0444', 'COMMODE:2156', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2964', '0445', 'COMMODE:219', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2965', '0446', 'COMMODE:2200', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2966', '0447', 'COMMODE:2208 MA-CITO', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2967', '0448', 'COMMODE:222 MA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2968', '0449', 'COMMODE:2370', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2969', '0450', 'COMMODE:2375', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2970', '0451', 'COMMODE:2376 WALL HAND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2971', '0452', 'COMMODE:2390', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2972', '0453', 'COMMODE:2400', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2973', '0454', 'COMMODE:2469', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2974', '0455', 'COMMODE:2487', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2975', '0456', 'COMMODE:2806', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2976', '0457', 'COMMODE:288', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2977', '0458', 'COMMODE:290 WHITE (2091)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2978', '0459', 'COMMODE:291', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2979', '0460', 'COMMODE:2950', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2980', '0461', 'COMMODE:303', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2981', '0462', 'COMMODE:303 MA WALL HANG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2982', '0463', 'COMMODE:3040', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2983', '0464', 'COMMODE:3050 WHITE', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2984', '0465', 'COMMODE:3057', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2985', '0466', 'COMMODE:3104 LEXTA', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2986', '0467', 'COMMODE:320', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2987', '0468', 'COMMODE:350', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2988', '0469', 'COMMODE:3500 MC', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2989', '0470', 'COMMODE:4466-IVORY (LEXTA)', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2990', '0471', 'COMMODE:5004 MA WALL HANG', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2991', '0472', 'COMMODE:50100', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2992', '0473', 'COMMODE:6525', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2993', '0474', 'COMMODE:8008 2 PCS', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2994', '0475', 'COMMODE:808', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2995', '0476', 'COMMODE:809 WALL HAND', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2996', '0477', 'COMMODE:8104', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');
INSERT INTO `xls_imp_item` VALUES ('2997', '0478', 'COMMODE:8126', null, null, null