/*
Navicat MySQL Data Transfer

Source Server         : mysql_cloud_138.201.220.146
Source Server Version : 50614
Source Host           : 138.201.220.146:3306
Source Database       : cnlxidtp_click_kt

Target Server Type    : MYSQL
Target Server Version : 50614
File Encoding         : 65001

Date: 2017-09-30 06:43:46
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `acct_type`
-- ----------------------------
DROP TABLE IF EXISTS `acct_type`;
CREATE TABLE `acct_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `debit_name` varchar(20) DEFAULT NULL,
  `credit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of acct_type
-- ----------------------------
INSERT INTO `acct_type` VALUES ('2251', 'LNCL - LONG TERM LOANS - SECURED', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1101', 'ANCA - OPERATING FIXED ASSETS - OWNED', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1201', 'ANCA - INTENGIBLE FIXED ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('13', 'ANCA - UN-ALLOCATED PRE-PRODUCTION EXP.', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1301', 'ANCA - UN-ALLOCATED PRE-PRODUCTION EXP.', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('35', 'E - RESERVES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2101', 'LNCL - REDEEMABLE CAPITAL - SECURED', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2201', 'LNCL - DEBENTURES - SECURED', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('3101', 'E - Capital', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('4101', 'TURNOVER', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('5101', 'Cost of Sales', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('6101', 'Administrative & General Expenses', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('6201', 'Selling & Distribution Expenses', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('6301', 'Finanacial Expenses', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('8101', 'Other Income', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('9101', 'Other Expense', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('3510', 'E - RESERVES - CAPITAL', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('7', 'P&L APPROPRIATIONS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('23', 'LNCL - LIABILITIES AGAINST ASSETS SUBJECT TO F_LEA', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('71', 'P&L APPROPRIATIONS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('22', 'LNCL - DEBENTURES & LONG TERM LOANS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('7101', 'P&L APPROPRIATIONS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1141', 'ANCA - STORES & SPARES HELD FOR CAPITAL EXP.', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1', 'ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2', 'LIABILITIES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('3', 'EQUITY (E)', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('4', 'TURNOVER', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('5', 'COST OF SALES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('6', 'OPERATING EXPENSES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('8', 'Other Income', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('9', 'Other Expense', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('11', 'ANCA -TANGIBLE FIXED ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('12', 'ANCA - INTENGIBLE FIXED ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('21', 'LNCL - REDEEMABLE CAPITAL', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('28', 'LCL - CURRENT LIABILITIES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('31', 'E - CAPITAL', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('41', 'TURNOVER', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('51', 'Cost of Sales', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('61', 'ADMINISTRATIVE & GENERAL EXPENSES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('62', 'SELLING & DISTRIBUTION EXPENSES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('63', 'FINANCIAL EXPENSES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('81', 'Other Income', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('91', 'Other Expense', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('14', 'ANCA - LONG TERM INVESTMENTS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('0', 'NA', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('3520', 'E - RESERVES - REVENUE', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('36', 'E - UN-APPROPRIATED P&L', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('3601', 'E - UN-APPROPRIATED P&L B/F', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('37', 'E - SURPLUS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('3701', 'E - SURPLUS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2801', 'LCL - CURRENT LIABILITIES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2802', 'LCL - Trade Creditors', 'PAYMENTS TO SUPPLIER', 'PURCHASES');
INSERT INTO `acct_type` VALUES ('2899', 'LCL - Cash & Bank', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2301', 'LNCL - LIABILITIES AGAINST ASSETS SUBJECT TO F_LEA', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('24', 'LNCL - DEFERRED LIABILITIES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2401', 'LNCL - DEFERRED LIABILITIES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('25', 'LNCL -  LONG TERM DEPOSITS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2501', 'LNCL - LONG TERM SECURITIES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2502', 'LNCL - LONG TERM ADVANCES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2503', 'LNCL - LONG TERM EARNEST/RETENTIONS MONEY', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2504', 'LNCL - LONG TERM DEPOSITS ETC.- OTHERS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2102', 'LNCL - REDEEMABLE CAPITAL - UNSECURED', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2202', 'LNCL - DEBENTURES - UNSECURED', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('2252', 'LNCL - LONG TERM LOANS - UNSECURED', 'DEBIT', 'DEBIT');
INSERT INTO `acct_type` VALUES ('1102', 'ANCA - OPERATING FIXED ASSETS - SUBJECT TO F_LEA', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1111', 'ANCA - NON-OPERATING FIXED ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1121', 'ANCA - CAPITAL WORK-IN-PROGRESS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1131', 'ANCA - STOCKS HELD FOR CAPITAL EXPENDITURES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('19', 'ACA - CURRENT ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1902', 'ACA - Trade Debtors', 'SALES', 'CUSTOMER RECEIPTS');
INSERT INTO `acct_type` VALUES ('1903', 'ACA - Stocks In Trade', 'STOCK RECEIPTS', 'STOCK ISSUED');
INSERT INTO `acct_type` VALUES ('1901', 'ACA - CURRENT ASSETS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1999', 'ACA - Cash & Bank ', 'RECEIPTS', 'PAYMENTS');
INSERT INTO `acct_type` VALUES ('1401', 'ANCA - LONG TERM INVESTMENTS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('15', 'ANCA - LONG TERM LOANS & ADVANCES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1501', 'ANCA - LONG TERM LOANS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1551', 'ANCA - LONG TERM ADVANCES', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('16', 'ANCA - LT DEPOSITS, PREPAY. AND DEFERRED COSTS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1601', 'ANCA - LONG TERM DEPOSITS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1621', 'ANCA - LONG TERM PREPAYMENTS', 'DEBIT', 'CREDIT');
INSERT INTO `acct_type` VALUES ('1641', 'ANCA - DEFERRED COSTS', 'DEBIT', 'CREDIT');

-- ----------------------------
-- Table structure for `am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `am_condet`;
CREATE TABLE `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `announcement`
-- ----------------------------
DROP TABLE IF EXISTS `announcement`;
CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of announcement
-- ----------------------------

-- ----------------------------
-- Table structure for `app_mod`
-- ----------------------------
DROP TABLE IF EXISTS `app_mod`;
CREATE TABLE `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_mod
-- ----------------------------
INSERT INTO `app_mod` VALUES ('AC_CP', 'Cash Payment', 'Accounts', '26', '35', '', 'CP');
INSERT INTO `app_mod` VALUES ('AC_BP', 'Bank Payment', 'Accounts', '26', '35', '', 'BP');
INSERT INTO `app_mod` VALUES ('AC_CR', 'Cash Receipt', 'Accounts', '26', '35', '', 'CR');
INSERT INTO `app_mod` VALUES ('AC_BR', 'Bank Receipt', 'Accounts', '26', '35', '', 'BR');
INSERT INTO `app_mod` VALUES ('AC_JV', 'Journal Voucher', 'Accounts', '35', '35', '', 'JV');
INSERT INTO `app_mod` VALUES ('AC_CD', 'Outstanding Clearing Dates', 'Accounts', '223', '0', '', '');
INSERT INTO `app_mod` VALUES ('PL_PO', 'Order', 'Purchases', '226', '53', 't_pl_order', '');
INSERT INTO `app_mod` VALUES ('PL_GP', 'Inward Gate Pass', 'Purchases', '226', '235', 't_pl_gp', '');
INSERT INTO `app_mod` VALUES ('PL_INV', 'Invoice', 'Purchases', '226', '235', 't_pl_invoice', '');
INSERT INTO `app_mod` VALUES ('PL_PAY', 'Payments', 'Purchases', '203', '204', 't_pl_pay', '');
INSERT INTO `app_mod` VALUES ('PL_JV', 'JV', 'Purchases', '216', '212', 'pl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_GP', 'Inward Gate Pass', 'Sales', '226', '235', 't_sl_gp', '');
INSERT INTO `app_mod` VALUES ('SL_INV', 'Invoice', 'Sales', '226', '235', 't_sl_invoice', '');
INSERT INTO `app_mod` VALUES ('SL_RTN', 'Return', 'Sales', '226', '235', 't_sl_return', '');
INSERT INTO `app_mod` VALUES ('SL_PAY', 'Payments', 'Sales', '203', '204', 't_sl_pay', '');
INSERT INTO `app_mod` VALUES ('SL_JV', 'JV', 'Sales', '216', '212', 'sl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_OB', 'Outstanding Bilties', 'Sales', '221', '260', '', '');
INSERT INTO `app_mod` VALUES ('STK_PROD', 'Production', 'Stock', '226', '53', 't_stk_con', 'Y');
INSERT INTO `app_mod` VALUES ('STK_CON', 'Consumption', 'Stock', '226', '235', 't_stk_con', 'N');
INSERT INTO `app_mod` VALUES ('MF_NOM', 'Chart of Accounts', 'Master Files', '164', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_PARTY', 'Parties', 'Master Files', '66', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_ITEM', 'Items', 'Master Files', '64', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_UNIT', 'Units', 'Master Files', '106', '0', '', '');
INSERT INTO `app_mod` VALUES ('IM_BOE', 'Bill of Entry', 'Imports', '226', '235', 't_im_boe', '');

-- ----------------------------
-- Table structure for `app_rep`
-- ----------------------------
DROP TABLE IF EXISTS `app_rep`;
CREATE TABLE `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_rep
-- ----------------------------
INSERT INTO `app_rep` VALUES ('AC_10', 'Daybook', 'Accounts', '144', '');
INSERT INTO `app_rep` VALUES ('AC_20', 'Ledger', 'Accounts', '91', '');
INSERT INTO `app_rep` VALUES ('AC_31', 'Trial - Balance', 'Accounts', '163', '');
INSERT INTO `app_rep` VALUES ('AC_32', 'Trial - Control', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_33', 'Trial - Subsidary', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_40', 'Profit & Loss', 'Accounts', '190', '');
INSERT INTO `app_rep` VALUES ('AC_50', 'Profit & Loss (Level 2)', 'Accounts', '191', '');
INSERT INTO `app_rep` VALUES ('PL_10', 'Purchase Daybook', 'Purchases', '187', 'PL');
INSERT INTO `app_rep` VALUES ('PL_20', 'Payment Daybook', 'Purchases', '187', 'PP');
INSERT INTO `app_rep` VALUES ('PL_30', 'Detail Ledger', 'Purchases', '405', 'S');
INSERT INTO `app_rep` VALUES ('PL_40', 'Trial', 'Purchases', '194', 'S');
INSERT INTO `app_rep` VALUES ('PL_50', 'Summary', 'Purchases', '188', 'S');
INSERT INTO `app_rep` VALUES ('SL_10', 'Sale Daybook', 'Sales', '187', 'SL');
INSERT INTO `app_rep` VALUES ('SL_20', 'Sale Receipts', 'Sales', '187', 'SR');
INSERT INTO `app_rep` VALUES ('SL_30', 'Detail Ledger', 'Sales', '405', 'C');
INSERT INTO `app_rep` VALUES ('SL_40', 'Trial', 'Sales', '194', 'C');
INSERT INTO `app_rep` VALUES ('SL_50', 'Summary', 'Sales', '188', 'C');
INSERT INTO `app_rep` VALUES ('SL_60', 'Empty Stock Report', 'Sales', '406', '');
INSERT INTO `app_rep` VALUES ('SL_70', 'Empty Stock Report Rate Wise', 'Sales', '407', '');
INSERT INTO `app_rep` VALUES ('SL_80', 'Outstanding Bills', 'Sales', '189', '');
INSERT INTO `app_rep` VALUES ('SL_90', 'SPO Outstanding', 'Sales', '195', '');
INSERT INTO `app_rep` VALUES ('STK_10', 'Ledger', 'Stocks', '401', '');
INSERT INTO `app_rep` VALUES ('STK_20', 'Summary', 'Stocks', '402', '');
INSERT INTO `app_rep` VALUES ('STK_30', 'Summary - Value', 'Stocks', '403', '');

-- ----------------------------
-- Table structure for `bill_type`
-- ----------------------------
DROP TABLE IF EXISTS `bill_type`;
CREATE TABLE `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of bill_type
-- ----------------------------
INSERT INTO `bill_type` VALUES ('0001', 'Normal', null);
INSERT INTO `bill_type` VALUES ('0002', 'Exchange', null);
INSERT INTO `bill_type` VALUES ('0003', 'VIP', null);
INSERT INTO `bill_type` VALUES ('0004', 'Sale Return', null);

-- ----------------------------
-- Table structure for `brands`
-- ----------------------------
DROP TABLE IF EXISTS `brands`;
CREATE TABLE `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of brands
-- ----------------------------
INSERT INTO `brands` VALUES ('0001', 'APC');
INSERT INTO `brands` VALUES ('0002', 'MGE UPS Systems');
INSERT INTO `brands` VALUES ('0003', 'Stulz Air Conditioning');
INSERT INTO `brands` VALUES ('0004', 'Bergvik Flooring');
INSERT INTO `brands` VALUES ('0005', 'APC / MGE UPS Systems');
INSERT INTO `brands` VALUES ('0006', 'APC / MGE');

-- ----------------------------
-- Table structure for `city`
-- ----------------------------
DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
  `CITY_ID` varchar(2) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`CITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of city
-- ----------------------------
INSERT INTO `city` VALUES ('10', 'LAHORE', '3801101001');

-- ----------------------------
-- Table structure for `closing_dates`
-- ----------------------------
DROP TABLE IF EXISTS `closing_dates`;
CREATE TABLE `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL,
  PRIMARY KEY (`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of closing_dates
-- ----------------------------
INSERT INTO `closing_dates` VALUES ('BP', '2003-12-31 00:00:00');

-- ----------------------------
-- Table structure for `code_cat`
-- ----------------------------
DROP TABLE IF EXISTS `code_cat`;
CREATE TABLE `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_cat
-- ----------------------------
INSERT INTO `code_cat` VALUES ('00', 'KURTA');
INSERT INTO `code_cat` VALUES ('01', 'SHALWAR');
INSERT INTO `code_cat` VALUES ('02', 'TROUSER');
INSERT INTO `code_cat` VALUES ('03', 'KHUSSA\r\n');
INSERT INTO `code_cat` VALUES ('04', 'WAIST COAT\r\n');
INSERT INTO `code_cat` VALUES ('05', 'NIGHT SUIT');
INSERT INTO `code_cat` VALUES ('06', 'FULL SUIT');
INSERT INTO `code_cat` VALUES ('07', 'COAT');
INSERT INTO `code_cat` VALUES ('08', 'FOOTWEAR\r\n');
INSERT INTO `code_cat` VALUES ('09', 'SHIRT\r\n');
INSERT INTO `code_cat` VALUES ('10', 'SHERWANI\r\n');
INSERT INTO `code_cat` VALUES ('11', 'TURBON\r\n');
INSERT INTO `code_cat` VALUES ('12', 'SUITING\r\n');
INSERT INTO `code_cat` VALUES ('13', 'CAP');
INSERT INTO `code_cat` VALUES ('14', 'ACCESSORIES');
INSERT INTO `code_cat` VALUES ('15', 'SHAWL');

-- ----------------------------
-- Table structure for `code_collection`
-- ----------------------------
DROP TABLE IF EXISTS `code_collection`;
CREATE TABLE `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_collection
-- ----------------------------
INSERT INTO `code_collection` VALUES ('SK', 'MEN');
INSERT INTO `code_collection` VALUES ('SG', 'GOLD');
INSERT INTO `code_collection` VALUES ('SD', 'DESIGNER\r\n');

-- ----------------------------
-- Table structure for `color`
-- ----------------------------
DROP TABLE IF EXISTS `color`;
CREATE TABLE `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of color
-- ----------------------------
INSERT INTO `color` VALUES ('PU', 'PURPLE');
INSERT INTO `color` VALUES ('OW', 'OFF WHITE');
INSERT INTO `color` VALUES ('BL', 'BLACK');
INSERT INTO `color` VALUES ('SN', 'SKIN');
INSERT INTO `color` VALUES ('GO', 'GOLDEN');
INSERT INTO `color` VALUES ('BR', 'BROWN');
INSERT INTO `color` VALUES ('MD', 'MUD');
INSERT INTO `color` VALUES ('SG', 'SEA GREEN');
INSERT INTO `color` VALUES ('MR', 'MAROON');
INSERT INTO `color` VALUES ('MV', 'MOUVE');
INSERT INTO `color` VALUES ('GR', 'GREEN');
INSERT INTO `color` VALUES ('MU', 'MUSTARD');
INSERT INTO `color` VALUES ('WH', 'WHITE');
INSERT INTO `color` VALUES ('GY', 'GREY');
INSERT INTO `color` VALUES ('DG', 'DARK GREEN');
INSERT INTO `color` VALUES ('LG', 'LIGHT GREEN');
INSERT INTO `color` VALUES ('BU', 'BLUE');
INSERT INTO `color` VALUES ('GB', 'GREEN BLUE');
INSERT INTO `color` VALUES ('OR', 'ORANGE');
INSERT INTO `color` VALUES ('PH', 'PEACH');
INSERT INTO `color` VALUES ('RS', 'RUST');
INSERT INTO `color` VALUES ('DB', 'DARK BLUE');
INSERT INTO `color` VALUES ('LY', 'LIGHT GREY');
INSERT INTO `color` VALUES ('SB', 'SKY BLUE');
INSERT INTO `color` VALUES ('FN', 'FORN');
INSERT INTO `color` VALUES ('CB', 'CHOCOLATE BROWN');
INSERT INTO `color` VALUES ('NB', 'NAVY BLUE');
INSERT INTO `color` VALUES ('YB', 'GREY BLACK');
INSERT INTO `color` VALUES ('GS', 'GREY SHINING');
INSERT INTO `color` VALUES ('FR', 'FEROOZI');
INSERT INTO `color` VALUES ('RD', 'RED');
INSERT INTO `color` VALUES ('LR', 'LIGHT BROWN');
INSERT INTO `color` VALUES ('LB', 'LIGHT BLUE');
INSERT INTO `color` VALUES ('CM', 'CAMEL');
INSERT INTO `color` VALUES ('CH', 'CHOCOLATE');
INSERT INTO `color` VALUES ('BG', 'BLACK GREY');
INSERT INTO `color` VALUES ('AR', 'ARMY');
INSERT INTO `color` VALUES ('MT', 'MULTI COLOUR');

-- ----------------------------
-- Table structure for `company`
-- ----------------------------
DROP TABLE IF EXISTS `company`;
CREATE TABLE `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of company
-- ----------------------------
INSERT INTO `company` VALUES ('BT', 'Qureshi Mor', 'Qureshi Mor near Bahoo flour mill Dik', '0966-851470-71', null, null, null, null, null, 'Y', null, null, null, null, null, 'BT', null, null, null, '2210000001', '3010000002', null, '2610000422', null, '', null, '', null, null, null, null, null, null);
INSERT INTO `company` VALUES ('IT', 'Tijarat Ganj', 'Tijarat ganj Tank Ada DIK', '0966-731165,66', null, null, null, null, null, 'Y', null, null, null, null, null, null, null, null, null, '2210000001', '3010000003', null, '2610000420', null, '', null, '', null, null, null, null, null, null);
INSERT INTO `company` VALUES ('KT', 'Kafeel Traders', 'PURNI SABZIMANDI NEAR CITY POLICE STATION DIK', '0966-710466,715469', '', '', '', '', '', 'Y', '0600030001', '', '', '', null, 'KT', 'UGX', null, null, '2210000001', '3010000001', '0700010001', '2610000419', '0100011000', 'A', '401', 'N', '', '0600030001', '0700020001', '0700030001', null, null);

-- ----------------------------
-- Table structure for `container_size`
-- ----------------------------
DROP TABLE IF EXISTS `container_size`;
CREATE TABLE `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of container_size
-- ----------------------------
INSERT INTO `container_size` VALUES ('0001', '16 Feet');
INSERT INTO `container_size` VALUES ('0002', '20 Feet');
INSERT INTO `container_size` VALUES ('0003', '22 Feet');
INSERT INTO `container_size` VALUES ('0004', '24 Feet');
INSERT INTO `container_size` VALUES ('0005', '40 Feet');
INSERT INTO `container_size` VALUES ('0006', '50 Feet');

-- ----------------------------
-- Table structure for `currency`
-- ----------------------------
DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of currency
-- ----------------------------
INSERT INTO `currency` VALUES ('PK', 'PKR');

-- ----------------------------
-- Table structure for `dc_type`
-- ----------------------------
DROP TABLE IF EXISTS `dc_type`;
CREATE TABLE `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of dc_type
-- ----------------------------
INSERT INTO `dc_type` VALUES ('01', 'Sale');

-- ----------------------------
-- Table structure for `discount`
-- ----------------------------
DROP TABLE IF EXISTS `discount`;
CREATE TABLE `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_percentage`
-- ----------------------------
DROP TABLE IF EXISTS `discount_percentage`;
CREATE TABLE `discount_percentage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_percentage
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `discount_voucher`;
CREATE TABLE `discount_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `division`
-- ----------------------------
DROP TABLE IF EXISTS `division`;
CREATE TABLE `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of division
-- ----------------------------
INSERT INTO `division` VALUES ('10', 'TEXTILE');

-- ----------------------------
-- Table structure for `expense`
-- ----------------------------
DROP TABLE IF EXISTS `expense`;
CREATE TABLE `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of expense
-- ----------------------------
INSERT INTO `expense` VALUES ('01', 'L/C EXPENSES');

-- ----------------------------
-- Table structure for `fin_years`
-- ----------------------------
DROP TABLE IF EXISTS `fin_years`;
CREATE TABLE `fin_years` (
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  PRIMARY KEY (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of fin_years
-- ----------------------------
INSERT INTO `fin_years` VALUES ('17', '17-18', '2017-07-01', '2018-06-30');

-- ----------------------------
-- Table structure for `grn`
-- ----------------------------
DROP TABLE IF EXISTS `grn`;
CREATE TABLE `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn
-- ----------------------------

-- ----------------------------
-- Table structure for `grndet`
-- ----------------------------
DROP TABLE IF EXISTS `grndet`;
CREATE TABLE `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_return`
-- ----------------------------
DROP TABLE IF EXISTS `grn_return`;
CREATE TABLE `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_return
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `grn_returndet`;
CREATE TABLE `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boe`
-- ----------------------------
DROP TABLE IF EXISTS `im_boe`;
CREATE TABLE `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boe
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boedet`
-- ----------------------------
DROP TABLE IF EXISTS `im_boedet`;
CREATE TABLE `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boedet
-- ----------------------------

-- ----------------------------
-- Table structure for `invoice_no`
-- ----------------------------
DROP TABLE IF EXISTS `invoice_no`;
CREATE TABLE `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of invoice_no
-- ----------------------------
INSERT INTO `invoice_no` VALUES ('1', 'SL', '06');
INSERT INTO `invoice_no` VALUES ('2', 'SL', '06');

-- ----------------------------
-- Table structure for `item`
-- ----------------------------
DROP TABLE IF EXISTS `item`;
CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) CHARACTER SET utf8 NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  `part_no` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=266 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item
-- ----------------------------
INSERT INTO `item` VALUES ('1', '0001', 'sultan 250 ml oil', '0.000', null, null, null, '0', null, null, '39', '820.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '800.00', null);
INSERT INTO `item` VALUES ('2', '0002', '16kg Olien Cane', '0.000', null, null, null, '0', null, null, '15', '3120.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '44434.00', null);
INSERT INTO `item` VALUES ('3', '0003', 'Cholaa 25 Kg Bag Barma', '0.000', null, null, null, '0', null, null, '23', '3500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('4', '0004', 'Daal Channa Supreem', null, null, null, null, null, null, null, '04', '4700.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('5', '0005', 'Daal Masoor', '0.000', null, null, null, '0', null, null, '45', '4600.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '4500.00', null);
INSERT INTO `item` VALUES ('6', '0006', 'Daal Moong', '0.000', null, null, null, '0', null, null, '45', '5200.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '4500.00', null);
INSERT INTO `item` VALUES ('7', '0007', 'Flour 20 Kg. Bag', '0.000', null, null, null, '0', null, null, '24', '670.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '715.00', null);
INSERT INTO `item` VALUES ('8', '0008', 'Flour 40 Kg. Bag', '0.000', null, null, null, '0', null, null, '24', '1400.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1430.00', null);
INSERT INTO `item` VALUES ('9', '0009', 'Flour 49 Kg Bag', '0.000', null, null, null, '0', null, null, '24', '1593.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1752.00', null);
INSERT INTO `item` VALUES ('10', '0010', 'Gur 40kg Bag', null, null, null, null, null, null, null, '05', '2850.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2240.15', null);
INSERT INTO `item` VALUES ('11', '0011', 'Sultan 10 Liter Oil Carton', '0.000', null, null, null, '0', null, null, '40', '1500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('12', '0012', 'Sultan 16 Kg Bucket', '0.000', null, null, null, '0', null, null, '14', '2500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('13', '0013', 'Sultan 16 Kg. Tin', '0.000', null, null, null, '0', null, null, '41', '2350.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('14', '0014', 'Sultan 16 Liter Oil Tin', '0.000', null, null, null, '0', null, null, '15', '2400.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2450.00', null);
INSERT INTO `item` VALUES ('15', '0015', 'Sultan 5 Kg Can', '0.000', null, null, null, '0', null, null, '35', '780.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('16', '0016', 'Khal 18 Kg', '0.000', null, null, null, '0', null, null, '26', '810.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('17', '0017', 'Maida 40 Kg Bag', '0.000', null, null, null, '0', null, null, '25', '1550.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1560.00', null);
INSERT INTO `item` VALUES ('18', '0018', 'Maqbool 10kg Bucket', '0.000', null, null, null, '0', null, null, '18', '1220.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1287.50', null);
INSERT INTO `item` VALUES ('19', '0019', 'Maqbool 16kg Bucket', '0.000', null, null, null, '0', null, null, '17', '1940.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2060.00', null);
INSERT INTO `item` VALUES ('20', '0020', 'Maqbool 2.5kg Bucket', '0.000', null, null, null, '0', null, null, '20', '320.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '337.00', null);
INSERT INTO `item` VALUES ('21', '0021', 'Maqbool 5kg Bucket', '0.000', null, null, null, '0', null, null, '11', '650.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '654.00', null);
INSERT INTO `item` VALUES ('22', '0022', 'Maqbool Cortan(1kg)', '0.000', null, null, null, '0', null, null, '10', '1840.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1940.00', null);
INSERT INTO `item` VALUES ('23', '0023', 'Maqbool Tin', '0.000', null, null, null, '0', null, null, '16', '1850.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1950.00', null);
INSERT INTO `item` VALUES ('24', '0024', 'Meezan 1 Liter Bottle Carton', '0.000', null, null, null, '0', null, null, '09', '800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('25', '0025', 'Meezan 10 Kg Bucket', '0.000', null, null, null, '0', null, null, '13', '1500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('26', '0026', 'Meezan 2.5 Kg Bucket', '0.000', null, null, null, '0', null, null, '20', '375.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('27', '0027', 'Millat 10 Kg Bucket', '0.000', null, null, null, '0', null, null, '18', '1230.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1287.50', null);
INSERT INTO `item` VALUES ('28', '0028', 'Millat 2.5 Kg Can', '0.000', null, null, null, '0', null, null, '32', '285.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '294.00', null);
INSERT INTO `item` VALUES ('29', '0029', 'Millat 5 Kg Bucket', '0.000', null, null, null, '0', null, null, '11', '625.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '585.00', null);
INSERT INTO `item` VALUES ('31', '0031', 'Millat Tin', '0.000', null, null, null, '0', null, null, '21', '1730.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1791.00', null);
INSERT INTO `item` VALUES ('32', '0032', 'Rahat 2.5 Kg Can', '0.000', null, null, null, '0', null, null, '32', '295.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '325.00', null);
INSERT INTO `item` VALUES ('33', '0033', 'Rahat 5 Kg Can', '0.000', null, null, null, '0', null, null, '31', '630.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '600.00', null);
INSERT INTO `item` VALUES ('34', '0034', 'Rahat Carton 1kg', '0.000', null, null, null, '0', null, null, '10', '1860.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1900.00', null);
INSERT INTO `item` VALUES ('35', '0035', 'Rahat Carton 250 Gm P', '0.000', null, null, null, '0', null, null, '10', '1875.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1920.00', null);
INSERT INTO `item` VALUES ('36', '0036', 'Rahat Cortan 1/2 Kg', '0.000', null, null, null, '0', null, null, '10', '1860.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1900.00', null);
INSERT INTO `item` VALUES ('37', '0037', 'Rahat Tin', '0.000', null, null, null, '0', null, null, '16', '1875.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1910.00', null);
INSERT INTO `item` VALUES ('38', '0038', 'Rahat Washing Powder 20 Rs(36pack)', '29.000', null, null, null, '0', null, null, '33', '500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '504.51', null);
INSERT INTO `item` VALUES ('39', '0039', 'Rahat Washing Powder Rs 10', '0.000', null, null, null, '0', null, null, '33', '530.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '513.64', null);
INSERT INTO `item` VALUES ('40', '0040', 'Rice 25 Kg Kanyt', null, null, null, null, null, null, null, '08', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('41', '0041', 'Rice 50 Kg Bag Waqas', '0.000', null, null, null, '0', null, null, '30', '4500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '4200.00', null);
INSERT INTO `item` VALUES ('42', '0042', 'Rice Ks82/25kg', null, null, null, null, null, null, null, '08', '1200.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1100.00', null);
INSERT INTO `item` VALUES ('43', '0043', 'Salt Bundle', null, null, null, null, null, null, null, '05', '50.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '60.00', null);
INSERT INTO `item` VALUES ('44', '0044', 'Sarso Oil 26 Kg', '0.000', null, null, null, '0', null, null, '15', '3910.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('46', '0046', 'Sooji 50 Kg Bag', '0.000', null, null, null, '0', null, null, '24', '1900.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1940.00', null);
INSERT INTO `item` VALUES ('47', '0047', 'Starch Bag', '0.000', null, null, null, '0', null, null, '25', '3250.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '3350.00', null);
INSERT INTO `item` VALUES ('48', '0048', 'Sugar Bag', null, null, null, null, null, null, null, '07', '2600.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2775.00', null);
INSERT INTO `item` VALUES ('49', '0049', 'Sultan 10kg Ghee Cortan', '0.000', null, null, null, '0', null, null, '40', '1500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('50', '0050', 'Maqbool Cortan(1/4kg)', '0.000', null, null, null, '0', null, null, '10', '1850.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1960.00', null);
INSERT INTO `item` VALUES ('52', '0052', 'Meezan 5 Ltr Bottal', '0.000', null, null, null, '0', null, null, '43', '800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '775.00', null);
INSERT INTO `item` VALUES ('53', '0053', 'Cholaa 30 Kg Bag', '0.000', null, null, null, '0', null, null, '23', '5400.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '4964.00', null);
INSERT INTO `item` VALUES ('54', '0054', 'Rice 25 Kg IRRI 9', null, null, null, null, null, null, null, '08', '1550.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1150.00', null);
INSERT INTO `item` VALUES ('55', '0055', 'Sultan 10 Kg Bucket', '0.000', null, null, null, '0', null, null, '13', '1600.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '100.00', null);
INSERT INTO `item` VALUES ('56', '0056', 'Maqbool Cortan(1/2kg)', '0.000', null, null, null, '0', null, null, '10', '1850.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1940.00', null);
INSERT INTO `item` VALUES ('57', '0057', 'Rahat 100 Gram', '0.000', null, null, null, '0', null, null, '01', '50100.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '800.00', null);
INSERT INTO `item` VALUES ('58', '0058', 'Meezan 3 Ltr Bottal', '0.000', null, null, null, '0', null, null, '01', '500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '500.00', null);
INSERT INTO `item` VALUES ('59', '0059', 'Chashm Soap 13 Kg', '0.000', null, null, null, '0', null, null, '34', '870.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('60', '0060', 'Saleem Dish Wash Bar', '0.000', null, null, null, '0', null, null, '34', '280.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('61', '0061', 'Hifazat Bath Soap', '0.000', null, null, null, '0', null, null, '34', '2400.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2000.00', null);
INSERT INTO `item` VALUES ('62', '0062', 'Khal 10 Kg Bag', '0.000', null, null, null, '0', null, null, '26', '810.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('63', '0063', 'Meezan 5 Liter Bottle', '0.000', null, null, null, '0', null, null, '01', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('65', '0065', 'Latif 12 Liter Oil Carton', null, null, null, null, null, null, null, '09', '1460.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1365.00', null);
INSERT INTO `item` VALUES ('66', '0066', 'Rice 25 Kg Bag', null, null, null, null, null, null, null, '08', '1900.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('67', '0067', 'Meezan 3 Liter Bottle Carton', null, null, null, null, null, null, null, '05', '2900.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('68', '0068', 'sultan 1000 ML sarso', '0.000', null, null, null, '0', null, null, '09', '815.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('69', '0069', 'Sultan 5 Liter Dispenser', '0.000', null, null, null, '0', null, null, '39', '730.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('70', '0070', 'Meezan 5 Litre Dispenser', '0.000', null, null, null, '0', null, null, '39', '750.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '680.00', null);
INSERT INTO `item` VALUES ('71', '0071', 'Maida 80 Kg. Bag', '0.000', null, null, null, '0', null, null, '25', '3500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '3120.00', null);
INSERT INTO `item` VALUES ('72', '0072', 'Latif 16 Kg Tin', '0.000', null, null, null, '0', null, null, '41', '2350.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2260.00', null);
INSERT INTO `item` VALUES ('74', '0074', 'Shopper 25 Kg', '0.000', null, null, null, '0', null, null, '33', '5200.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('75', '0075', 'Meezan Carton', null, null, null, null, null, null, null, '05', '750.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('76', '0076', 'Millat Carton', '0.000', null, null, null, '0', null, null, '21', '1700.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1774.00', null);
INSERT INTO `item` VALUES ('77', '0077', 'Sultan 3 Litre Bottle Carton', '0.000', null, null, null, '0', null, null, '05', '2950.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('78', '0078', 'Match Rs 2 Hook', '0.000', null, null, null, '0', null, null, '44', '700.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('79', '0079', 'Meezan 5 Kg. Can', '0.000', null, null, null, '0', null, null, '35', '750.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('80', '0080', 'Khal 40 Kg Bag', '0.000', null, null, null, '0', null, null, '26', '1720.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('81', '0081', 'Millat 16 Kg Bucket', '0.000', null, null, null, '0', null, null, '17', '1950.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2020.00', null);
INSERT INTO `item` VALUES ('82', '0082', 'Sultan 5 Liter Bottle Carton', '0.000', null, null, null, '0', null, null, '05', '1550.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('83', '0083', 'Rice 50 Kg Bag', '0.000', null, null, null, '0', null, null, '30', '3750.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('84', '0084', 'Latif 16 Ltr Oil Tin', '0.000', null, null, null, '0', null, null, '15', '2350.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('85', '0085', 'Rice Rahat 25 Kg Kainat', null, null, null, null, null, null, null, '08', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2150.00', null);
INSERT INTO `item` VALUES ('86', '0086', 'Chashma Soap 10 Kg.', '0.000', null, null, null, '0', null, null, '33', '620.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('87', '0087', 'Rahat Rice 50 Kg Super Karnala', '0.000', null, null, null, '0', null, null, '30', '3950.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '3750.00', null);
INSERT INTO `item` VALUES ('90', '0090', 'Meezan 5 Liter Bottle Carton', null, null, null, null, null, null, null, '01', '3050.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('91', '0091', 'Rice Rahat 25 Kg Super Karnal', '0.000', null, null, null, '0', null, null, '08', '2600.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1900.00', null);
INSERT INTO `item` VALUES ('92', '0092', 'Chola 25 Kg 9mm', '0.000', null, null, null, '0', null, null, '23', '4600.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '4200.00', null);
INSERT INTO `item` VALUES ('93', '0093', 'Rahat 16 Ltr Oil Tin', '0.000', null, null, null, '0', null, null, '15', '5000.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1910.00', null);
INSERT INTO `item` VALUES ('94', '0094', 'Chokar 30kg', '0.000', null, null, null, '0', null, null, '02', '730.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('95', '0095', 'Rice 25kg Kaynat(Murgh)', '0.000', null, null, null, '0', null, null, '08', '2000.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '12200.00', null);
INSERT INTO `item` VALUES ('96', '0096', 'Sultan 5 Kg Bucket', '0.000', null, null, null, '0', null, null, '11', '800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('97', '0097', 'Rice 50 Kg. KS-82', '0.000', null, null, null, '0', null, null, '30', '2250.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('98', '0098', 'Millat 2.5 Kg Bucket', '0.000', null, null, null, '0', null, null, '20', '320.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '335.50', null);
INSERT INTO `item` VALUES ('99', '0099', 'China Salt', '0.000', null, null, null, '0', null, null, '06', '50.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('101', '0101', 'Meezan 5 Kg Bucket', '0.000', null, null, null, '0', null, null, '11', '760.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('102', '0102', 'Chokar 10 Kg Bag', '0.000', null, null, null, '0', null, null, '02', '240.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('104', '0104', 'Meezan 16 Liter Oil Tin', '0.000', null, null, null, '0', null, null, '15', '2450.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('105', '0105', 'Rahat 10kg Bucket', '0.000', null, null, null, '0', null, null, '18', '1300.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '1331.00', null);
INSERT INTO `item` VALUES ('106', '0106', 'Meezan 10 Kg Carton Ghee', '0.000', null, null, null, '0', null, null, '40', '1430.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('107', '0107', 'Rice Rahat 50 Kg Kainat', '0.000', null, null, null, '0', null, null, '30', '3950.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('108', '0108', 'RAHAT 5KG BUCKETS', '0.000', null, null, null, '0', null, null, '11', '660.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('109', '0109', 'Meezan 10 Liter Oil', '0.000', null, null, null, '0', null, null, '13', '1500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('110', '0110', 'Rahat 16 Kg Bucket', '0.000', null, null, null, '0', null, null, '17', '2020.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('111', '0111', '17 KG SOAP', '0.000', null, null, null, '0', null, null, '34', '870.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('116', '0116', 'Bath Soap(Rs20 )', '0.000', null, null, null, '0', null, null, '34', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('117', '0117', 'Both Soap 48 Piece', '0.000', null, null, null, '0', null, null, '34', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('118', '0118', 'Can Empty', '0.000', null, null, null, '0', null, null, '05', '250.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('121', '0121', 'Chashma Soap 20 Kg', '0.000', null, null, null, '0', null, null, '34', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('124', '0124', 'Chokar 15 Kg Bag', '0.000', null, null, null, '0', null, null, '02', '375.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('125', '0125', 'Cholaa 25 Kg Bag', '0.000', null, null, null, '0', null, null, '23', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('126', '0126', 'Cholaa 50 Kg Bag', '0.000', null, null, null, '0', null, null, '23', '6900.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('129', '0129', 'Coca Cola 1.5 Ltr', '0.000', null, null, null, '0', null, null, '05', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('132', '0132', 'Daal Mong Halki', '0.000', null, null, null, '0', null, null, '04', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('133', '0133', 'DAL CHANA HALKI', '0.000', null, null, null, '0', null, null, '04', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('138', '0138', 'Drum Empty', '0.000', null, null, null, '0', null, null, '05', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('139', '0139', 'Empty 16kg Cane', '0.000', null, null, null, '0', null, null, '05', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('156', '0156', 'Hifazat Bath Ticki', '0.000', null, null, null, '0', null, null, '33', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('159', '0159', 'sultan 2.5 Kg Bucket', '0.000', null, null, null, '0', null, null, '12', '400.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('160', '0160', 'sultan 2.5 Kg Can', '0.000', null, null, null, '0', null, null, '36', '356.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('161', '0161', 'Jamesheren 800 Ml', '0.000', null, null, null, '0', null, null, '13', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('162', '0162', 'Kachi Basmati Rice25 Kg', '0.000', null, null, null, '0', null, null, '08', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('164', '0164', 'Khal 25 Kg Bag', '0.000', null, null, null, '0', null, null, '26', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('165', '0165', 'Lobia 50 Kg Bag', '0.000', null, null, null, '0', null, null, '04', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('166', '0166', 'Maida 50kg Bag Punjaib', '0.000', null, null, null, '0', null, null, '25', '1520.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('167', '0167', 'Maida 85 Kg Buri', '0.000', null, null, null, '0', null, null, '25', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('168', '0168', 'Maqbool 2.5kg Tin', '0.000', null, null, null, '0', null, null, '32', '330.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('169', '0169', 'Match', '0.000', null, null, null, '0', null, null, '05', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('171', '0171', 'MEEZA 10LTR CANE', '0.000', null, null, null, '0', null, null, '13', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('172', '0172', 'Meezan 16 Kg Bucket', '0.000', null, null, null, '0', null, null, '14', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('173', '0173', 'Meezan 16 Kg Tin', '0.000', null, null, null, '0', null, null, '41', '2300.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('174', '0174', 'Meezan 2.5 Kg Can', '0.000', null, null, null, '0', null, null, '36', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('175', '0175', 'Mezan 12kg Ghee Cortan', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('176', '0176', 'Milk 25 Kg USA', '0.000', null, null, null, '0', null, null, '06', '9500.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('179', '0179', 'Olien can 25 kg', '0.000', null, null, null, '0', null, null, '15', '3095.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('180', '0180', 'Olein Oil Drum', '0.000', null, null, null, '0', null, null, '05', '3120.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('185', '0185', 'RAHAT 2.5KG BUCKETS', '0.000', null, null, null, '0', null, null, '20', '300.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('186', '0186', 'Rahat 5 Ltr Dispencer', '0.000', null, null, null, '0', null, null, '39', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('187', '0187', 'Rahat Washing Powder 1 Kg', '0.000', null, null, null, '0', null, null, '33', '520.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('189', '0189', 'Rice 25 Kg. IRRI 6', '0.000', null, null, null, '0', null, null, '08', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('190', '0190', 'Rice 25 Kg Supri', '0.000', null, null, null, '0', null, null, '08', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('191', '0191', 'Rice 50kg Kiynat (Murgh)', '0.000', null, null, null, '0', null, null, '30', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('196', '0196', 'Shopper 20 Kg B', '0.000', null, null, null, '0', null, null, '05', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('199', '0199', 'Starch 25kg Bag', '0.000', null, null, null, '0', null, null, '25', '3250.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('200', '0200', 'Sultan 10 Kg Soap', '0.000', null, null, null, '0', null, null, '34', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('203', '0203', 'Wanda Bag 40 Kg', '0.000', null, null, null, '0', null, null, '28', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('206', '0206', 'Glocose Cortan 25kg', '0.000', null, null, '0.00', '0', null, null, '25', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('207', '0207', 'Sultan 5 Liter Bottele Cortan', '0.000', null, null, '0.00', '0', null, null, '01', '1550.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('208', '0208', 'Meezan cane', '0.000', null, null, '0.00', '0', null, null, '13', '1530.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('209', '0209', '1 LTR OIL BOTTAL', '0.000', null, null, null, '0', null, null, '43', '1.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('210', '0210', 'Basin 40 Kg', '0.000', null, null, null, '0', null, null, '29', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('211', '0211', 'Chola 8mm 50 Kg', '0.000', null, null, null, '0', null, null, '23', '7100.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('212', '0212', 'Chola 9mm 50 Kg', '0.000', null, null, null, '0', null, null, '23', '9150.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('213', '0213', 'DAAL MASH 25 KG', '0.000', null, null, null, '0', null, null, '22', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('214', '0214', 'Daal Matri', '0.000', null, null, null, '0', null, null, '04', '2350.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('215', '0215', 'Daal Mong 25 Kg', '0.000', null, null, null, '0', null, null, '22', '1900.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('216', '0216', 'Glucose 25kg Cortan R', '0.000', null, null, null, '0', null, null, '25', '1820.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('217', '0217', 'Kashmir 10 Ltr Cane', '0.000', null, null, null, '0', null, null, '13', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('218', '0218', 'Kashmir 12 Ltr Cortan', null, null, null, null, null, null, null, '05', '1880.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('219', '0219', 'Kashmir Bottle 3 Ltr Cortan', '0.000', null, null, null, '0', null, null, '42', '3100.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('220', '0220', 'Kashmir Bottle 5ltr Cortan', '0.000', null, null, null, '0', null, null, '42', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('221', '0221', 'Kashmir Bucket 10 Kg', '0.000', null, null, null, '0', null, null, '13', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('222', '0222', 'Kashmir Bucket 2.5 Kg', '0.000', null, null, null, '0', null, null, '12', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('223', '0223', 'Kashmir Bucket 5 Kg', '0.000', null, null, null, '0', null, null, '11', '820.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('224', '0224', 'Kashmir Dispenser Ghee 5kg', '0.000', null, null, null, '0', null, null, '39', '820.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('225', '0225', 'Kashmir Dispenser Oil 5ltr', '0.000', null, null, null, '0', null, null, '39', '835.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('226', '0226', 'Kashmir Ghee 16kg Tin', '0.000', null, null, null, '0', null, null, '41', '2480.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('227', '0227', 'Latif 16kg Cortan', '0.000', null, null, null, '0', null, null, '01', '2350.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('228', '0228', 'Latif 5 Kg Tin', '0.000', null, null, null, '0', null, null, '35', '700.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('229', '0229', 'Latif 5 Ltr Tin', '0.000', null, null, null, '0', null, null, '35', '730.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('230', '0230', 'Lobia 25 Kg B', '0.000', null, null, null, '0', null, null, '22', '3750.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('231', '0231', 'Rice 25 Kg Kaiynat Multan', '0.000', null, null, null, '0', null, null, '08', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('232', '0232', 'SARSO 500 GRM OIL(C)', '0.000', null, null, null, '0', null, null, '39', '1000.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('245', '0234', 'Millat 5kg Cane', '0.000', null, null, null, '0', null, null, '31', '570.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('247', '0235', 'Achar 5kg Bucket', '0.000', null, null, null, '0', null, null, '43', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('248', '0236', 'Chola 25 Kg 933', '0.000', null, null, null, '0', null, null, '23', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('250', '0238', 'Daal Masoor 25 Kg', '0.000', null, null, null, '0', null, null, '22', '1800.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('251', '0239', 'Hifazat Both Soap', '0.000', null, null, null, '0', null, null, '33', '2400.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('252', '0240', 'Match RS 1', '0.000', null, null, null, '0', null, null, '44', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('254', '0242', 'Soda 25 kg Bag', null, null, null, null, null, null, null, '05', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('255', '0243', 'Tea 190 Grm Pack', null, null, null, null, null, null, null, '05', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('262', '0241', 'Chola 25 Kg Barma', '0.000', null, null, null, '0', null, null, '23', '3250.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('263', '0237', 'daal mash 50kg bag', '0.000', null, null, null, '0', null, null, '05', '600.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('264', '0064', 'Item Deleted', '0.000', null, null, null, '0', null, null, '05', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);
INSERT INTO `item` VALUES ('265', '0244', 'TIQAT 16 KG ( C)', '100.000', null, null, null, '0', null, null, '10', '1830.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null);

-- ----------------------------
-- Table structure for `item_description`
-- ----------------------------
DROP TABLE IF EXISTS `item_description`;
CREATE TABLE `item_description` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item_description
-- ----------------------------

-- ----------------------------
-- Table structure for `location`
-- ----------------------------
DROP TABLE IF EXISTS `location`;
CREATE TABLE `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of location
-- ----------------------------
INSERT INTO `location` VALUES ('01', 'KAFEEL TRADER', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on', 'KT');
INSERT INTO `location` VALUES ('02', 'Qureshi Mor', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on', 'BT');
INSERT INTO `location` VALUES ('03', 'Tijarat Ganj', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on', 'IT');

-- ----------------------------
-- Table structure for `locations`
-- ----------------------------
DROP TABLE IF EXISTS `locations`;
CREATE TABLE `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of locations
-- ----------------------------
INSERT INTO `locations` VALUES ('01', 'Main Store');

-- ----------------------------
-- Table structure for `lots`
-- ----------------------------
DROP TABLE IF EXISTS `lots`;
CREATE TABLE `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of lots
-- ----------------------------

-- ----------------------------
-- Table structure for `menu`
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL,
  `menu_detail` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES ('1', 'Sale', null, null);
INSERT INTO `menu` VALUES ('1.1', 'Invoice', null, null);
INSERT INTO `menu` VALUES ('1.2', 'Order', null, null);
INSERT INTO `menu` VALUES ('1.3', 'Sale Delivery Challan', null, null);
INSERT INTO `menu` VALUES ('1.4', 'Outword Gate pass', null, null);
INSERT INTO `menu` VALUES ('1.5', 'Receipts', null, null);
INSERT INTO `menu` VALUES ('1.6', 'Journal', null, null);
INSERT INTO `menu` VALUES ('1.7', 'Sale Return', null, null);
INSERT INTO `menu` VALUES ('2', 'Purchase', null, null);
INSERT INTO `menu` VALUES ('2.1', 'Invoice', null, null);
INSERT INTO `menu` VALUES ('2.2', 'Order', null, null);
INSERT INTO `menu` VALUES ('2.3', 'Inward Gate pass', null, null);
INSERT INTO `menu` VALUES ('2.4', 'Payments', null, null);
INSERT INTO `menu` VALUES ('2.5', 'Journal', null, null);
INSERT INTO `menu` VALUES ('2.6', 'Purchase Return', null, null);
INSERT INTO `menu` VALUES ('3', 'Accounts', null, null);
INSERT INTO `menu` VALUES ('3.1', 'Payments', null, null);
INSERT INTO `menu` VALUES ('3.2', 'Journal Voucher', null, null);
INSERT INTO `menu` VALUES ('4', 'Stock', null, null);
INSERT INTO `menu` VALUES ('4.1', 'Production', null, null);
INSERT INTO `menu` VALUES ('4.2', 'Consumption', null, null);
INSERT INTO `menu` VALUES ('5', 'Master File', null, null);
INSERT INTO `menu` VALUES ('5.1', 'Items', null, null);
INSERT INTO `menu` VALUES ('5.2', 'Chart Of Accounts', null, null);
INSERT INTO `menu` VALUES ('5.3', 'Items', null, null);
INSERT INTO `menu` VALUES ('5.4', 'Sale Person', null, null);
INSERT INTO `menu` VALUES ('5.5', 'Category', null, null);
INSERT INTO `menu` VALUES ('5.6', 'Users', null, null);
INSERT INTO `menu` VALUES ('6', 'Reports Summary', null, null);
INSERT INTO `menu` VALUES ('6.1', 'Sale Summary', null, null);
INSERT INTO `menu` VALUES ('6.2', 'Stock Summary', null, null);
INSERT INTO `menu` VALUES ('6.3', 'Outword Gate pass Summary', null, null);
INSERT INTO `menu` VALUES ('6.4', 'Sale Order Summary', null, null);
INSERT INTO `menu` VALUES ('6.5', 'Purchase Summary', null, null);
INSERT INTO `menu` VALUES ('6.6', 'Purchase Order Summary', null, null);
INSERT INTO `menu` VALUES ('6.7', 'Purchase InwordGatepass Summary', null, null);
INSERT INTO `menu` VALUES ('7', 'Reports Detail', null, null);
INSERT INTO `menu` VALUES ('7.1', 'Sale Report', null, null);
INSERT INTO `menu` VALUES ('7.2', 'Sale Order', null, null);
INSERT INTO `menu` VALUES ('7.3', 'Outword Gatepass', null, null);
INSERT INTO `menu` VALUES ('7.4', 'WareHouse Stock', null, null);
INSERT INTO `menu` VALUES ('7.5', 'Purchase Invoice', null, null);
INSERT INTO `menu` VALUES ('7.6', 'Inword Gatepass', null, null);
INSERT INTO `menu` VALUES ('7.7', 'Stock Ledger', null, null);
INSERT INTO `menu` VALUES ('8', 'Reports Accounts', null, null);
INSERT INTO `menu` VALUES ('8.1', 'Ledgers', null, null);
INSERT INTO `menu` VALUES ('8.2', 'Day Book', null, null);
INSERT INTO `menu` VALUES ('9', 'Reports', null, null);
INSERT INTO `menu` VALUES ('9.1', 'Sale Report', null, null);
INSERT INTO `menu` VALUES ('9.2', 'Gatepass Outword Report', null, null);
INSERT INTO `menu` VALUES ('9.3', 'Current Stock', null, null);

-- ----------------------------
-- Table structure for `ms_sale`
-- ----------------------------
DROP TABLE IF EXISTS `ms_sale`;
CREATE TABLE `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of ms_sale
-- ----------------------------

-- ----------------------------
-- Table structure for `nom`
-- ----------------------------
DROP TABLE IF EXISTS `nom`;
CREATE TABLE `nom` (
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_NAME` char(50) NOT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `ACCT_TYPE` varchar(4) DEFAULT NULL,
  `FS_TYPE` varchar(1) DEFAULT NULL,
  `SUB` varchar(1) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `TEST_NAME` char(50) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `address` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `reg_id` varchar(6) NOT NULL,
  `credit_limit` decimal(10,2) NOT NULL,
  `ntn` varchar(50) NOT NULL,
  `stax_no` varchar(50) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom
-- ----------------------------
INSERT INTO `nom` VALUES ('01', 'CAPITAL & LIABILITIES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('010001', 'Reserves & Surplus', null, '3101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100010002', 'Haji Nizam Din', null, '3101', null, null, null, null, 'KT', null, null, '', 'bahoo.mill@gmail.com', '03219608611', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100010010', 'Drawings', null, '3101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100010020', 'Suspense A/c', null, '3101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('010010', 'Opening Balance', null, '7101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100100050', 'Profit And Loss Opening Balance', null, '7101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('13', 'CREDITORS & OTHER PAYABLES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('131000', 'Sundry Creditors', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000424', 'Bahoo Flour Mills', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000426', 'Chashma Ghee Mills Ghee', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000427', 'Haji Allaudin, Tank Adda', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000432', 'Latif Ghee', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000435', 'Next Cola Meezan', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000437', 'Sultan Ghee', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000439', 'Waheed Salt Dealer', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000443', 'Zaqat', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000444', 'Hoor Oil Mills', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000445', 'Tayyab Traders', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000446', 'Kashmir Ghee Mill', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000447', 'Khwaja Muhammad Imran', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000448', 'abdul ghffar kafeel traders', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('20', 'ASSETS', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('201000', 'FIXED ASSETS', null, '1101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('201500', 'Loans & Advances', null, '1901', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000001', 'Baloch Sahab, Bank Alfalah', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000002', 'BaNK ALF Insurance', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000003', 'Dera News', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000004', 'Dildar Munshi', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000005', 'Godam  Bahoo Traders', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000006', 'Gohar Zaman, Driver', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000007', 'Gulzar MCB', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000008', 'Habib Mushtaq Panter', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000009', 'Hafiz Ismail Makkah', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000010', 'Haifz Munir Cant', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000011', 'Haji Aslam Rose Hotel', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000012', 'Haji Jan Mohammad', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000013', 'Haji Saad Ullah, Ramak', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000014', 'Hasnain Kotex', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000015', 'Jamshed Bhai Bank Alfalah', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000016', 'KAPCO Shares', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000017', 'Mansoor Ahmed, Paharpur', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000018', 'Maqbool HBL', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000019', 'Maqbool UBL', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000020', 'Muhammad Aqeel Darya Khan', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000021', 'Muhammad Aslam Lahori', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000022', 'Muhammad Ilyas, Tijarat Ganj', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000023', 'Muhammad Khaleel, Madina Colony', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000024', 'Najeeb Paracha Rawalpindi', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000025', 'Sad Rossal', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2015000026', 'Wasi Header Zadi Chahshma Gee Mii', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('22', 'STOCKS', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('221000', 'Closing Stock', null, '1903', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2210000001', 'STOCKS IN TRADE', null, '1903', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2210000002', 'STOCK TRANSFERS', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('26', 'SUNDRY DEBTORS', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('261000', 'Sundry Debtors', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000001', 'Asghar Lucknow Bakers', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000003', 'Aas Muhammad, Nawab Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000004', 'Abdul Bari, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000005', 'Abdul Ghaffar, Mohallah Khattaki', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020109', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000006', 'Abdul Ghani Pansar, Raheem Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000007', 'Abdul Hafeez, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000008', 'Abdul Hanan, Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000009', 'Abdur Raheem, Soda Water Factory', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000010', 'Abdur Rauf, Degree College', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000011', 'Abdur Razaq, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000012', 'Abdur Rehman, Hayat Bochra', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000013', 'Abdur Rehman Mosa Khar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000014', 'Abdur Rehman Saddar Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000015', 'Abdu Sattar, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000016', 'Abid & Tauseef, Chah Syed Munawar Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000017', 'Abudlraziq Quarshi Drabn', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000019', 'Ahmed Ali, Sheikh Yousaf Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000020', 'Ahmed Jan, Kulachi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000021', 'Ahmed Pansar Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000023', 'Al Asad Muryali Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000025', 'Al Hamd Karyana, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000026', 'Al Hamd Kayana, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000027', 'Al Hassan Karyana, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000028', 'Ali Super Store', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000029', 'Allah Baksh Baloch, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000030', 'Allah Daad Khan, Kiri Shamozai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000031', 'Allah Nawaz Clerk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000032', 'Al Rehmat, Fateh Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000033', 'Aman Ullah Mohalla Deewan Sahab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000034', 'Aman Ullah Pahor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000035', 'Ameer Nawaz Eidgah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000036', 'Ameer Nawaz, Saddar Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000037', 'Amjad Gul Karyana, Bannu Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000038', 'Anwar Masood Diyal Road', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000039', 'Aqal Khan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000040', 'Arif Uncal Mahallah Gosi Wala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000041', 'Army Welfare Shop', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000042', 'Arshad, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000043', 'Asad, Bank Alfalah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000044', 'Ashraf Tayyab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000045', 'Asif Loading Clerk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000046', 'Aslam Munshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000047', 'Asmat Ullah Paandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000048', 'Atiq Ahmed, Chaman Chowk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000049', 'Atta Ullah Khan, Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000050', 'Ayaz Deen Pur', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000051', 'Ayaz Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000052', 'Ayub Baloch', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000053', 'Ayub Khan Tank Ada', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000054', 'Azhair  C/o Zafir Wapda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000055', 'Aziz Khan Triman', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000056', 'Aziz Naswar, Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000057', 'Aziz Ur Rehman, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000058', 'Babar Sewayan Chaman Chowk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000059', 'Baloch Hotel, Nawab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000060', 'Basheer Hussain', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000061', 'Basit-Cook', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000062', 'Bhai Shahid Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000063', 'Bismillah General Store', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000064', 'Bismillah Hotel, Bannu Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000065', 'Bismillah Karyana Store', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000066', 'Chaudhry Ikram, Bazar Kalan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000067', 'Chaudhry Islam, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000068', 'Chaudhry Mehr Deen', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000069', 'Chaudhry Yameen, Paharpur', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000070', 'City Super Store, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000072', 'Diler Milk Powder', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000073', 'Doctor Ramzan, Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000074', 'Doest Muhmmad Khan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000075', 'Dotani Super Store, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000076', 'Faheem, Chah Syed Munawar Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000077', 'Faisal Goga Khel, Bazar Kalan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000078', 'Faiz Ullah, SABZI MANDI', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000079', 'Falak Shar Parova', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000080', 'Fareed Bahi Madina Colny', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000081', 'Fauji Ahmed Nawaz', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000083', 'Fazar Ur Rehman, Bakhri Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000084', 'Fida Hussain, Bannu Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000085', 'Gentry Palace', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000086', 'Ghar Kharcha Haji Imamdin', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000087', 'Ghar Kharcha Haji Nizam Din', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000088', 'Ghulam Baqir Shahani, Meeran', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000089', 'Ghulam Hussain, Hotel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000090', 'Ghulam Muhammad, City Police', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000091', 'Ghulam Muhammad GM, Ghala Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000092', 'Ghulam Nabi, Draban', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000093', 'Ghulam Rasool, Police Line', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000094', 'Green Hotel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000095', 'Gul Habib, Naiwela', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000096', 'Gulshan Bakers, Factory', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000097', 'Gulshan Bakers Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000098', 'Gulshan Bakers, Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000099', 'Gulshan Baker Tank Ada', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000100', 'Gul Zaman Kulchi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000101', 'Habib Ramzan, Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000102', 'Habib Ullah Kundi, Draban', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000103', 'Hafiz Muhammad Rafique, Ghala Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000104', 'Haji Abdullah, Gaba Karyana Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000105', 'Haji Abdullah, Muzamil Karyana', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000106', 'Haji Abdullah, Sheikh Yousaf Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000107', 'Haji Abdur Rasheed, Chashma Chowk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000108', 'Haji Abdur Rauf, Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000109', 'Haji Abdur Rehman, Commisionary Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000110', 'Haji Abdur Rehman Tirjat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000111', 'Haji Abdu Salam, Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000112', 'Haji Aleem Ud Din, Commisionary Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000113', 'Haji Allah Mehr Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000114', 'Haji Allaudin, Basti Tareen Abad', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000115', 'Haji Anwar, Bachri', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000116', 'Haji Azam, Marah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000117', 'Haji Aziz, Ghala Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000118', 'Haji Azmat Tank Ada', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000119', 'Haji Babu Aslam', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000120', 'Haji Ehsan Atta Dealer', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000121', 'Haji Ehsan Kaka Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000122', 'Haji Ellahi Bakhsh, Bazar Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000123', 'Haji Faheem', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000124', 'Haji Faiz Muhammad, Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000125', 'Haji Ghulam Fareed, Bakhri Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000126', 'Haji Ghulam Qadir Goga Khel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000127', 'Haji Ghulam Rabani, Nawab Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000128', 'Haji Ghulam Subhani', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000129', 'Haji Gul Anwar Pulaow Wala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020109', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000130', 'Haji Imam Din Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000131', 'Haji Ishfaq Madina Market', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000132', 'Haji Ishfaq Police Lines', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000133', 'Haji Jafir Poara', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000134', 'Haji Khan C/o Sami Bahoo Mill', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000135', 'Haji Kheeri', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000136', 'Haji Lal Rang Saaz, Shoaib', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000137', 'Haji Mani Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000138', 'Haji Mubeen, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000139', 'Haji Muhammad Ibrahim, Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000140', 'Haji Muhammad Ramzan, Baloch Nagar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000141', 'Haji Mushtaq, Bachri', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000142', 'Haji Saad Rossal', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000143', 'Haji Saad Ullah, Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000144', 'Haji Sadiq Ghee Dealer', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000145', 'Haji Sadiq Malang, Bazar Kalan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000146', 'Haji Sadiq Pakwan, Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000147', 'Haji Saleem, Lala Sweets', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000148', 'Haji Saleem, Pak Milan Halwa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000149', 'Haji Sardar Ali, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000150', 'Haji Shahjehan, Sheikh Yousaf Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000151', 'Haji Shaukat Mohallah Dewan Sahab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000152', 'Haji Sher Khan, Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000153', 'Haji Sher Muhammad', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000155', 'Haji Wahid Bakhsh, Bazar Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000156', 'Haji Yaqoob Number Daar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000157', 'Haji Younas Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000158', 'Haji Zahoor, Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000159', 'Hakim Khan Qursahi Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000160', 'Hameed Ullah, Commissionary Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000161', 'Hameed Ullah, Lunda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000162', 'Haq Nawaz, Draban Chungi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000163', 'Hashim Khan, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000165', 'Hassan Bakers, Sheikh Yousaf Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000166', 'Hassan Khan, HBL', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000167', 'Ibrahim  Mohallah Dewan Shaib', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000168', 'Ibrahim Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000169', 'Ideal Hotel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020109', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000170', 'Ijaz Mohallah Hayat Ullah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000171', 'Ikram, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000172', 'Imperial Bakers Rafique', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000173', 'Imran Bakhar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000174', 'Inayat Dilawar, Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000175', 'Inayat Hotel Jhok', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000176', 'Inayat Ullah, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000177', 'Inayat Ullah, Ubhaya Pul', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000178', 'Iqra Bakers Nawab Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000179', 'Irfan Ahmed, Kotli Imam', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000180', 'Irfan  Chotat BAZAR', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000181', 'Irfan Munshi, Mohallah Deewan Sahab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000182', 'Islam Ud Din Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000183', 'Islam Ud Din Mohallah Deewan Sahab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000184', 'Ismail Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000185', 'Jabir Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000186', 'Jamal Karyana Nawab Ada', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000187', 'Jamil Ahmad S/o Haji Ibrahim Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000188', 'Jamil Bahi C/o Usman Munshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000189', 'Jamil & Javed Mohallah Deewan Sahab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000190', 'Jamil Naiwela', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000191', 'Jamil NCN Cable', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000192', 'Javed Khan Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000193', 'Javed Ustaad', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000194', 'Jeelani Halwai Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000195', 'Kabul Karyana, Mission Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000196', 'Kala Khan, Jhok Qureshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000197', 'Karachi Hotel, Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000198', 'Kashaf Bakers', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000199', 'Khair Wali, Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000200', 'Khaleel Ahmed, Tauseef Abad', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000201', 'Khaleel Meezan Ghee', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000202', 'Khalid, Chaman Chowk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000203', 'Khalid Halwai, Maqbool Sweets, Ghas Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000204', 'Khalid Khan, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000205', 'Khalid, Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000206', 'Khalil Hotel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000207', 'Khizar Hayat KULCHI', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000208', 'KHUDA BAKSH TIBBI QASRANI', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000209', 'Lal Badshah, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000210', 'Lal Behram, Naiwela', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000211', 'Lal Shah Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000212', 'Liauqat Ali, Pezu', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000213', 'Maani Super Store', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000214', 'Maaz Karyna', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000215', 'Madina Tea Store', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000216', 'Madni Gur Dealer', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000217', 'M Ali G Soter', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000218', 'Malik Allah Nawaz, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000219', 'Malik Ellahi Bakhsh, Bazar Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000220', 'Malik Gul Muhammad, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000221', 'Malik Mithu, Bakhri Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000222', 'Malik Mushtaq, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000223', 'Malik Riaz, Baloch Nagar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000224', 'Malik Sami Ullah Chashma Sugar Mills', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000225', 'Mama Qayyum, TTC College', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000226', 'Mama Yaseen & Sons, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000227', 'Mamoon Peshwar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000228', 'Manzoor Hussain, Chairman', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000229', 'Maqbooal Khan Mara', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000230', 'Maqbool Sweet House', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000231', 'Marhaba Sweets, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000232', 'Master  Mohllah Shibshah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000233', 'Master Nadir Bhittani, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000234', 'Matloob Bakers', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000235', 'Mazhar Hameed, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000236', 'Meer Daad, Naiwela', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000237', 'Meer Zaman, Sadar Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000238', 'Meer Zaman Sadar Bazar 2', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000239', 'Mehdi Hassan, Chah Syed Munawar Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000240', 'Metro Shop', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '5000.00', '', '');
INSERT INTO `nom` VALUES ('2610000242', 'Mohmmad Aslam Near Ghas Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000243', 'Molvi Hotel, Ghala Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000244', 'Moon Light Bakers, Bazar Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000245', 'Moti Mahal', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000246', 'Mubeen Cannt.', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000247', 'Muhammad Afzal Bhakkar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000248', 'Muhammad Arif, Kachi Paind Khan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000249', 'Muhammad Arif Khan, Khansama', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000250', 'Muhammad Arshad, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000251', 'Muhammad Aslam, Bachri', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000252', 'Muhammad Aslam, Eidgah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000253', 'Muhammad Aslam Noor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000254', 'Muhammad Ayub, Nawab Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000255', 'Muhammad Bilal, Diyal Road', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000256', 'Muhammad Faheem, Sadar Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000257', 'Muhammad Farhan, Eidgah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020109', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000258', 'Muhammad Farid Basti Nad Ali Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000259', 'Muhammad Hashim Pakwan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000260', 'Muhammad Hussain, Shorkot', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000261', 'Muhammad Ibrahim, Naiwela', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000262', 'Muhammad Ilyas, Atta Dealer', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000263', 'Muhammad Irfan, Mission Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000264', 'Muhammad Irfan Mithai Wala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000265', 'Muhammad Irfan Parpur', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000266', 'Muhammad Islam, Tank', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000267', 'Muhammad Khalid, Mujahid Nagar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000268', 'Muhammad Luqman, Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000269', 'Muhammad Nawaz, Chodhwan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000270', 'Muhammad Nawaz, Lunda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000271', 'Muhammad Qadeer, Fateh Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000272', 'Muhammad Ramzan Bismillah Kryana', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000273', 'Muhammad Ramzan, CRBC', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000274', 'Muhammad Shahid & Saleem', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000275', 'Muhammad Shakeel, Imamia Gate', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000276', 'Muhammad Shakeel, Mohallah Gosaiyan Wala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000277', 'Muhammad Shakeel, Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000278', 'Muhammad Shakeel, Nawab Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000279', 'Muhammad Shehzad', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000280', 'Muhammad Shoaib, Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000281', 'Muhammad Suleman, Mahra', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000282', 'Muhammad Suleman, Parosi Haji Imam Din', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000283', 'Muhammad Tariq, Mahra', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000284', 'Muhammad Yaqoob, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000285', 'Muhammad Zafar, Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000286', 'Muhibullah- Lunda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000287', 'Muhmmad Imran Pathan, Madina Colony', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000288', 'Mukhtiyar Ahmad Darban', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000289', 'Mukhtiyar Ahmed, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000290', 'Mukhtiyar Hussain, Kotla Saidan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000291', 'Multan Bakers, Chotta Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000292', 'Muneer Ahmed, Kiri Alizai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000293', 'Muneer Ahmed, Naiwela', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000294', 'Muneer Ahmed, New Sabzi Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000295', 'Muneer Halwai', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000296', 'Muneer Halwai, Bazar Topanwala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000298', 'Muzamil, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000299', 'Nadeem Bakers', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000300', 'Nadeem Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000302', 'Nasar Ullah, Kotli Imam', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000303', 'Naseeb Fath Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000304', 'Naseer, Mohallah Hazrat Bilal', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000305', 'Nasir Hussain Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000307', 'Nawaz Rice Qureshi Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000308', 'Nazir Ubhaya Pul', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000309', 'New Gulshan Kashmir', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000310', 'Niazi Bakers Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000311', 'Nisar Karore', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000312', 'Noman Karyana', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000313', 'Noor Kariyana Sabzi Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000314', 'Other Debtors', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000315', 'Pasham Gul', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000316', 'Peer Zada, Bakhri Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000317', 'Qari Irfan Madrsaa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000318', 'Qari Saeed, Saddar Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000320', 'Qayyum Nawaz, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000321', 'Qureshi Mor Other Debtors', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000322', 'Rahat International Haj Umra', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000323', 'Rahat Kashmir Bakers', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000324', 'Rahat Washing Free Packet', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000325', 'Ramzan Kat Mallana', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000326', 'Ramzan, New Sabzi Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000327', 'Rana Abdu Sattar, Chah Munshi Wala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000328', 'Rana Amjad Ali, Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000329', 'Rana Faheem Mohallh Gosiyn Wala', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000330', 'Rana Sagheer Mujahid Nagar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000331', 'Rana Tahir Paroa Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000332', 'Rasheed Draban', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000333', 'Rasheed, Maqbool Sweets', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000334', 'Rasheed Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000335', 'Rasool Wali, Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000336', 'Rauf Malanra', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000337', 'Raza Ullah Mara', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000338', 'Rehmat Ullah Ramak', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000339', 'Riaz General Store', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000340', 'Riaz Jhok Qureshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000341', 'Rizwan Atta Dealer, Ghala Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000343', 'Saad Ullah Jhok Qureshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000344', 'Sabir Rice Jhok Qureshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000346', 'Saeed & Wahid Bakhsh, Ubhaya Pul', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000347', 'Saif Ullah, Ubhaya Pul', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000348', 'Saif Ur Rehman', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000349', 'Saif Ur Rehman Nawab Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000350', 'Sana Ullah Mohallah Ship Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000351', 'Sana Ullah Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000352', 'Saqib Saleem Mohallah Allaudin', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000353', 'Sardar Naimat Kundi, Lunda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000354', 'Sarwar Khan Kundi Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000355', 'Seth Aman Ullah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000356', 'Seth Shareef', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000357', 'Shabeer Azad', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000358', 'Shafi Jhok Qureshi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000359', 'Shahid Ahmed, Chah Syed Munawar Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000360', 'Shahid & Fazal', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000361', 'Shahid Khan, Shobrah Hotel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000362', 'Shah Jee Palay Daar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000363', 'Shahnawaz Pakwan, Muryali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000364', 'Shahnawaz, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000365', 'Shakeel Ahmed Muslim Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000366', 'Shamsher, Dajal', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000367', 'Shaukat Shah, Chah Syed Munawar Shah', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000368', 'Shehzad Imtiaz, Basti Kanchkan Wali', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000369', 'Sheikh Abdullah Quraishi Morr', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000370', 'Sheikh Abdul Latif, Maddi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000371', 'Sheikh Hadi, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000372', 'Sheikh Irfan, Bazar Kalan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000373', 'Sheikh Qamar, Mission Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000374', 'Sheikh Shaukat, Mission Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000375', 'Siddique Cloth', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000376', 'Siddique, Fateh Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000377', 'Sidra Genral Store Mahsood Market', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000378', 'Sohail Ahmed Clerk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000379', 'Sohail Parwana', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000381', 'Sufi Allah Nawaz, Baloch Nagar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000382', 'Sufi Ramzan, Flying Coach Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000383', 'Sufi Saleem, Hussania Chowk', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000384', 'Suleman, Bakhri Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000385', 'Surat Khan Tank Ada', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000386', 'Taj & Saleem', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000387', 'Tanveer Ahmed, Ghala Mandi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000388', 'Tanveer Ahmed Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000389', 'Tariq Factory Worker', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000390', 'Tayyab Chota Baazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000391', 'Tijarat Ganj Other Debtors', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000392', 'Umar Hayat Pehlwan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000393', 'Umar Hayat Son of Hayat Sugar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000394', 'United Karyana Sheikh Yousaf Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000395', 'Uzair Karyana Bannu Adaa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000396', 'Wahab, Goga Khel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000397', 'Wahab Mara', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000398', 'Wajahat Hussain, Misgran Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000399', 'Waqas Khan, Madi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000400', 'Wazir Ikram Baloch', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000401', 'Yaqoob, Ubhaya Pul', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000402', 'Yaseen Gulzar, Bazar Kalan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000403', 'Yaseen Khan, Tijarat Ganj', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000404', 'Younis Goga Khel', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000406', 'Yousaf Lunda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000408', 'Zahir Shah, Paroa', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000409', 'Zahoor Din Chota Bazar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000411', 'Zeshan Clark Cgm', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000412', 'Ziaudin, Bazar Kalan', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000413', 'Zia Ul Haq, Shorkot', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000414', 'Zia Ur Rehman, Kulachi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000415', 'Zubair Tayyab', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000417', 'Urdu Name', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000419', 'Cash KT', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000420', 'Cash-IT', null, '1902', null, null, null, null, 'IT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000421', 'Hayat ASI', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000422', 'Cash-BT', null, '1902', null, null, null, null, 'BT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000447', 'Irshad Jhok Qureshi Mor', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000449', 'Murtaza, New  Bannu Chungi', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000451', 'Abdur Rehman, Bagi Qamar', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000453', 'Zam Zam Karyana, Tank Adda', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000454', 'Gulshan Bakers, Town Hall', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000456', 'Muhammad Javed Advocate', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000460', 'Usman c/o irfan', null, '1902', null, null, null, null, 'IT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000462', 'Abdul Rehman Kot Jai', null, '1902', null, null, null, null, 'IT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000464', 'Allah Diwaya Adil Sipraa', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000465', 'Allah Nawaz, Faqeerni Gate', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000466', 'Al-Lateef Qadeemi Sohan Halwa', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000467', 'Al Sana Super Store', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000468', 'Aman Super Store', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000469', 'Aqeel Traders, Darya Khan', null, null, null, null, null, null, null, null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000472', 'Chaudhry Hotel, Bazar Topanwala', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000473', 'Doctor Ajmal Gandapur', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000479', 'Hafiz Usman, Fateh Mor', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000480', 'Haji Allah Bakhsh Atta Dealer', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000481', 'Haji Elahi Bakhsh Proa', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000490', 'Haji Shaukat Tank Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000492', 'Hameed Ullah, Mahra', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000493', 'Haseeb Khan, Misgran Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000500', 'Kareem Khan, Shobrah Hotel', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000501', 'Khaki Shah Paizu', null, null, null, null, null, null, null, null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000502', 'Khaleel Paroa', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000506', 'Mithu Karyana, Naiwela', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000508', 'Muhammad Ashraf, Gali Kapas Wali', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000509', 'Muhammad Aslam, Hotel', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000510', 'Muhammad Rafique Bakers, Chota Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000511', 'Muhammad Shahid, Nawab Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000513', 'Muhammad Younus, Muslim Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '020109', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000515', 'Naseeb Shah, Tank Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000516', 'Naseem, Madina Colony', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000517', 'Near of Mubeen Tanak Ada', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000518', 'Niaz Muhammad', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000519', 'Noor Islam, New Sabzi Mandi', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000522', 'Qari Noor Rehman Tijarat Ganj', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000526', 'Saif Ullah,', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000527', 'Saif Ur Rehman Nawab Adda (470)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000528', 'Saleem, Imamia Gate', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000531', 'Shahjehan, Paroa', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000532', 'Sheikh Akram, Bakhri Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000533', 'Sheikh Waheed, Misgran Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000534', 'Sial Electronic Store', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000535', 'Siraj Ud Din', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000536', 'Taha Bakers', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000537', 'Taj Din Clerk', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000538', 'Tariq Nadeem, Samosay Wala', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000540', 'Kashmir Bakers circular Road', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000541', 'Abdur Rehman Mosa Khar 714', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000542', 'Abid Jhok Qureshi', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000543', 'Abrar Paroa C/o Shabbir Sb.', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000544', 'Adnan Tijarat Ganj', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000545', 'Ahtisham Mchra Ada', null, null, null, null, null, null, null, null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000546', 'Ahtisham Tank Ada', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000547', 'Alamgir Khan Mara', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000548', 'Allah Mehar Roti Wala', null, null, null, null, null, null, null, null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000549', 'Al-Madina Kryana Draban Chungi', null, null, null, null, null, null, null, null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000550', 'Ameer Hamza', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000551', 'Ayub Khan Tank Ada  588', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000552', 'Baba Super Soter 720', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000553', 'Bashir-Lunda', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000554', 'chaudhary shahid c/o mati ullah munshi', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '85000.00', '', '');
INSERT INTO `nom` VALUES ('2610000555', 'Dost Muhmmad Khan (48)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000556', 'Falak Sher Proa', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000557', 'Fast Baker', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000558', 'Friends Bakers New Chungi', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000559', 'Gul Mohammad Shorkot 180', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000560', 'Gulshan Bakers Multan Road', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000561', 'Gulshan Cash & Carry (672)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000562', 'Haji Azmat Tank Ada (36)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000563', 'Haji Jafir Proa', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000564', 'Haji Kaleem Ptcl', null, null, null, null, null, null, null, null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000565', 'Haji Mani Tijarat Ganj (880)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000566', 'Haji Sultan, Mahra', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000567', 'Hakem Khan Qureshi Mor', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000568', 'Imran Bakhar (846)', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000569', 'Inayat Hotel Jhok Qureshi', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000570', 'Inayat Pansar, Muslim Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '020109', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000573', 'Ismail Tijarat Gang', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000574', 'Jamal Karyana Nawab Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000575', 'Jameel Naiwela', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000576', 'Kashif Muriali C/o Irfan', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000577', 'Khuda Bakhsh Tibbi Qasrani', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000578', 'Kifayat Munshi (706)', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000579', 'M Ali G Soter(894', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000580', 'Maqbool Khan Mara 648', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000583', 'Muhammad Imran Paroa', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000584', 'Muhammad Irfan Parpur (892)', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000585', 'Muhibullah Lunda 450', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000586', 'Mukhtiar Ahmad Draban', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000587', 'Muneer Halwai (768)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000588', 'Mushtaq Hathal', null, null, null, null, null, null, null, null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000589', 'Muzafar Khan Muriali 160', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000590', 'Nasar Ullah Zhob C/o Irfan', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000591', 'Naseeb Fath Mor (652)', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000592', 'Nasr Ullah Khan Mara', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000593', 'Nazir Ubhya Pull', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000594', 'Near Bandhan Marraige Laan', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000596', 'Niaz Muhammad Pezu', null, null, null, null, null, null, null, null, null, '', '', '', '020111', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000597', 'Noorani Karyana Bannu Adda 680', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000601', 'Razaullah Mara 416', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000602', 'Rizwan Mujahid Nagar', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000604', 'Sadiq & Shairoo Din Pur', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000606', 'Saeed Yarak 402', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000607', 'Sana Ullah Zhob C/o Irfan', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000611', 'Uzair Karyana Bannu Adaa (326', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000612', 'Wahab Mara 412', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000613', 'WAHEED Kokar  C/o Irfan', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000614', 'Waqqar Najm-U-Din (28)', null, null, null, null, null, null, null, null, null, '', '', '', '020108', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000615', 'Yousuf Mara 414', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000617', 'Zeshan Old Ledger', null, null, null, null, null, null, null, null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000619', 'Zubair Wana', null, null, null, null, null, null, null, null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000620', 'Haji Saad Rasool', null, null, null, null, null, null, null, null, null, '', '', '', '020112', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000621', 'Zubair Haji Aslam Goga Khail', null, null, null, null, null, null, null, null, null, '', '', '', '020113', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000622', 'Iqbal A Mehar', null, null, null, null, null, null, null, null, null, '', '', '', '020107', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000623', 'Abdul Jaleel Wana', null, null, null, null, null, null, null, null, null, '', '', '', '020106', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000624', 'Baba Super Soter', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000625', 'Gulshan Cash & Carry', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000626', 'Noorani Karyana Bannu Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020104', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000627', 'Gul Mohammad Shorkot', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000628', 'NEW KULACHI SHEIKH YOUSAF', null, null, null, null, null, null, null, null, null, '', '', '', '020103', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000629', 'Ajab Khan Tirjat Ganj', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000630', 'Dost Muhmmad Khan', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000631', 'Haji Zar Wali Tank Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000632', 'Yousaf Cheeni Dealer', null, null, null, null, null, null, null, null, null, '', '', '', '020105', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000633', 'Feroaz Ara Road C/o Ayub Nawab Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000634', 'Kaka Ustad Muryali', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000635', 'Ramzan Kat Malana', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000636', 'Haji Bilal Lunda', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000637', 'Maqbool Khan Mara', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000638', 'Muhibullah Lunda', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000639', 'Muzafar Khan Muriali', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000640', 'Rauf Malana', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000641', 'Razaullah Mara', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000642', 'Saeed Draban', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000643', 'Yousuf Mara', null, null, null, null, null, null, null, null, null, '', '', '', '020114', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000644', 'Qari Baitullah', null, null, null, null, null, null, null, null, null, '', '', '', '020113', '100000.00', '', '');
INSERT INTO `nom` VALUES ('2610000645', 'Haji sattar paroa', null, null, null, null, null, null, null, null, null, '', '', '', '', '100000.00', '', '');
INSERT INTO `nom` VALUES ('2610000646', 'sana ullah bahoo traders', null, null, null, null, null, null, null, null, null, '', '', '', '', '20000.00', '', '');
INSERT INTO `nom` VALUES ('2610000647', 'saqib kafeel traders', null, null, null, null, null, null, null, null, null, 'old sabzi mandi', '', '92320000605', '0102', '50000.00', '', '');
INSERT INTO `nom` VALUES ('27', 'CASH & BANK BALANCES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('271000', 'CASH', null, '1999', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('272000', 'Bank Accounts', null, '1999', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000001', '1189-79000868-03', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000002', '218174931 Ubl', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000003', 'ABL', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000004', 'ABL Faqeerni Gate', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000005', 'ABL Khalid Market', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000006', 'Al Habib Metro', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000007', 'Bank Alfalah', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000008', 'Bank Alfalah 106', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000009', 'Bank of Khyber 718', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000010', 'BOK 5393-5', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000011', 'BOK 8903', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000012', 'FAISAL BANK', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000013', 'HBL Bazar Kalan', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000014', 'HBL Dollar Account', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000015', 'Islamic Bank', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000016', 'MCB-2032', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000017', 'MCB-Tank Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000018', 'UBL-Circular Road', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000019', 'UBL-Tank Adda', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('30', 'REVENUE', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('301000', 'SALES', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010000001', 'Sales-KT', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010000002', 'Sales-BT', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010000003', 'Sales-IT', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('301010', 'DISCOUNT ALLOWED', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3010100001', 'Discount Expense', null, null, null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('302000', 'COST OF SALES', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000001', 'Purchase Cost', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000005', 'Freight Inwards', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000010', 'Freight Inward Tijarat Ganj', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000020', 'Freight Inwards  Quarshi Mor', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000100', 'Loading/ Unloading', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000110', 'Loading/Unloading-IT', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('3020000120', 'Loading/unloading B-T', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('40', 'ADMINISTRATIVE EXPENSES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('401000', 'SHOP EXPENSES', null, '6101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000001', 'Shop Expense', null, '6101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000010', 'Shop Expense Qureshi Mor', null, '6101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('4010000020', 'Shop Expense, Tijarat Ganj', null, '6101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('50', 'SELLING EXPENCES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('501000', 'FREIGHT ON SALE', null, '6201', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('60', 'INCOME', null, '8101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('601000', 'Other Income', null, '8101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('90', 'Suspense', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('900001', 'Suspense', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('9000010001', 'OPENING BALANCES', null, null, null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');

-- ----------------------------
-- Table structure for `nom_add`
-- ----------------------------
DROP TABLE IF EXISTS `nom_add`;
CREATE TABLE `nom_add` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `reg_id` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_add
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_copy`
-- ----------------------------
DROP TABLE IF EXISTS `nom_copy`;
CREATE TABLE `nom_copy` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT 'HO'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_copy
-- ----------------------------
INSERT INTO `nom_copy` VALUES ('01', 'CAPITAL & LIABILITIES', '0', '', '', 'HO');

-- ----------------------------
-- Table structure for `nom_lc`
-- ----------------------------
DROP TABLE IF EXISTS `nom_lc`;
CREATE TABLE `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_lc
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_old`
-- ----------------------------
DROP TABLE IF EXISTS `nom_old`;
CREATE TABLE `nom_old` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '01',
  PRIMARY KEY (`comp_id`,`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_old
-- ----------------------------
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '0', '', '', '01');
INSERT INTO `nom_old` VALUES ('010001', 'DIRECT EXPENSES', '31', '', '5', '01');
INSERT INTO `nom_old` VALUES ('0100010001', 'COST OF GOOD SOLD', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '31', '', '61', '01');
INSERT INTO `nom_old` VALUES ('0100020001', 'ENTERTAINMENT EXPENSES', null, '', '', '01');
INSERT INTO `nom_old` VALUES ('0100020002', 'TRAVELLING EXPENSES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020003', 'STATIONARY', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020004', 'ADVERTISEMENT EXP', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020005', 'GROCERY EXP', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020006', 'OFFICE EXPENSES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020007', 'REPAIR AND MAINTAINANCE\r\n', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020008', 'RENT WAREHOUSE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020010', 'KARIM BLOCK OUTLET EXPENSES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010003', 'OPENING BALANCES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100030001', 'OPENING BALANCES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010010', 'STAFF SALARIES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100100001', 'STAFF SALARIES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('02', 'EQUITY', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('020001', 'PROPRITERS CAPITAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0200010001', 'PROPRITERS CAPITAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0200010002', 'OPENING BALANCE ADJUSTMENT ACOOUNT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('03', 'Short Term Liabilites', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('030007', 'Accrued Salaries', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070001', 'SALARY PAYABLE KAMRAN', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070002', 'SALARY PAYABLE - NADISH', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070003', 'SALARY PAYABLE - KHURRAM', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070004', 'SALARY PAYABLE - JAVED', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070005', 'SALARY PAYABLE - FAROOQ', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070006', 'SALARY PAYABLE - SHUJA BAHI (TAX ADVISOR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070007', 'SALARY PAYABLE - VICTOR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070008', 'SALARY PAYABLE - MOHSIN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070009', 'SALARY PAYABLE - FAISAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070010', 'SALARY PAYABLE - TALAH', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070011', 'SALARY PAYABLE - SIKANDAR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070012', 'SALARY PAYABLE - SONIL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070013', 'SALARY PAYABLE - ALI RAZA', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('10', 'LIABILITIES', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('100001', 'VENDOR FINISHED GOODS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010001', 'VENDOR SHOES - KASHIF PAYABLE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010002', 'MR MAJEED (KURTA)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010003', 'MR TAHIR (WAIST COAT)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010004', 'MR ARIF (EMBROIDARY)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010005', 'MR MUSHTAQ (HSY)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010006', 'HUMD INTERNATIONAL PVT LTD', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('100002', 'VENDOR RAW MATERIAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020001', 'HAMZA AKHTAR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020002', 'HAJI KHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020003', 'WAZIR AHMED', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020004', 'ZAKIR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020005', 'LONDON', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020006', 'DARWESH KHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020007', 'AL-REHMAT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020008', 'SHADMAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('20', 'STOCK', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('200001', 'STOCK IN TRADE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2000010001', 'STOCK IN TRADE (RM)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2000010002', 'STOCK IN TRADE (FG)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '19', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000002', 'ELECTRONICS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000003', 'FURNITURE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('272000', 'BANK BALANCES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2720000001', 'HABIB BANK', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2720000002', 'FAYSAL BANK', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('273000', 'OUTLET', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000001', 'HEAD OFFICE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000002', 'STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000003', 'DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000004', 'EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000005', 'EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000006', 'SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000007', 'FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000008', 'OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000009', 'BWP ', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000012', 'KAREEM BLOCK', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('41', 'TURNOVER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('410001', 'SALE', null, '', '4', '01');
INSERT INTO `nom_old` VALUES ('4100010001', 'SALES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010002', 'SALE - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010003', 'SALES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010004', 'SALES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010005', 'SALES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010006', 'SALES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010007', 'SALES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010008', 'SALES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010009', 'SALES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010012', 'SALES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410002', 'DISCOUNT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020001', 'DISCOUNT - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020002', 'DISCOUNT - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020003', 'DISCOUNT - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020004', 'DISCOUNT - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020005', 'DISCOUNT - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020006', 'DISCOUNT - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020007', 'DISCOUNT - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020008', 'DISCOUNT - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020009', 'DISCOUNT - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020012', 'DISCOUNT - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410003', 'SALES RETURN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030001', 'RETURN - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030002', 'RETURN - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030003', 'RETURN - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030004', 'RETURN - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030005', 'RETURN - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030006', 'RETURN - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030007', 'RETURN - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030008', 'RETURN - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030009', 'RETURN - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030012', 'RETURN - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410004', 'CREDIT NOTES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040001', 'CREDIT NOTES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040002', 'CREDIT NOTES - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040003', 'CREDIT NOTES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040004', 'CREDIT NOTES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040005', 'CREDIT NOTES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040006', 'CREDIT NOTES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040007', 'CREDIT NOTES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040008', 'CREDIT NOTES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040009', 'CREDIT NOTES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040012', 'CREDIT NOTES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410005', 'DEBIT NOTES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050001', 'DEBIT NOTES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050002', 'DEBIT NOTES - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050003', 'DEBIT NOTES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050004', 'DEBIT NOTES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050005', 'DEBIT NOTES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050006', 'DEBIT NOTES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050007', 'DEBIT NOTES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050008', 'DEBIT NOTES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050009', 'DEBIT NOTES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050012', 'DEBIT NOTES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('99', 'COST CENTRES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('990001', 'STAFF', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010001', 'ALI SHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010002', 'HUSNAIN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010003', 'MUSA', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('20', 'STOCK', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('200001', 'STOCK IN TRADE', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('2000010001', 'STOCK IN TRADE (RM)', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('2000010002', 'STOCK IN TRADE (FG)', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '13');

-- ----------------------------
-- Table structure for `o_batch`
-- ----------------------------
DROP TABLE IF EXISTS `o_batch`;
CREATE TABLE `o_batch` (
  `PROD_ID` varchar(4) NOT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `BAL_QTY` decimal(10,0) DEFAULT NULL,
  `O_QTY` decimal(10,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_batch
-- ----------------------------
INSERT INTO `o_batch` VALUES ('0420', '2017-04-30 00:00:00', 'TOS-1525', null, '1200');

-- ----------------------------
-- Table structure for `o_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucher`;
CREATE TABLE `o_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime NOT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `POSTED` varchar(1) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `o_voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucherdet`;
CREATE TABLE `o_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(13,2) DEFAULT NULL,
  `CREDIT` decimal(13,2) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucherdet
-- ----------------------------

-- ----------------------------
-- Table structure for `o_voucherdet_e`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucherdet_e`;
CREATE TABLE `o_voucherdet_e` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `BPV_ID` varchar(20) DEFAULT NULL,
  `TENDER_NO` varchar(50) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucherdet_e
-- ----------------------------

-- ----------------------------
-- Table structure for `party`
-- ----------------------------
DROP TABLE IF EXISTS `party`;
CREATE TABLE `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party
-- ----------------------------
INSERT INTO `party` VALUES ('0001', 'Asghar Lucknow Bakers', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000001', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0002', 'Aabid Jhok Qureshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000002', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0003', 'Aas Muhammad, Nawab Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000003', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0004', 'Abdul Bari, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000004', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0005', 'Abdul Ghaffar, Mohallah Khattaki', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000005', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0006', 'Abdul Ghani Pansar, Raheem Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000006', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0007', 'Abdul Hafeez, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000007', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0008', 'Abdul Hanan, Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000008', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0009', 'Abdur Raheem, Soda Water Factory', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000009', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0010', 'Abdur Rauf, Degree College', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000010', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0011', 'Abdur Razaq, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000011', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0012', 'Abdur Rehman, Hayat Bochra', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000012', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0013', 'Abdur Rehman Mosa Khar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000013', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0014', 'Abdur Rehman Saddar Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000014', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0015', 'Abdu Sattar, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000015', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0016', 'Abid & Tauseef, Chah Syed Munawar Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000016', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0017', 'Abudlraziq Quarshi Drabn', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000017', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0018', 'Adnan Tirjat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000018', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0019', 'Ahmed Ali, Sheikh Yousaf Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000019', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0020', 'Ahmed Jan, Kulachi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000020', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0021', 'Ahmed Pansar Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000021', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0022', 'Ahmed Shah Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000022', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0023', 'Al Asad Muryali Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000023', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0024', 'Alhabib Kariyana Bannu Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000024', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0025', 'Al Hamd Karyana, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000025', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0026', 'Al Hamd Kayana, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000026', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0027', 'Al Hassan Karyana, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000027', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0028', 'Ali Super Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000028', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0029', 'Allah Baksh Baloch, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000029', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0030', 'Allah Daad Khan, Kiri Shamozai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000030', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0031', 'Allah Nawaz Clerk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000031', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0032', 'Al Rehmat, Fateh Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000032', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0033', 'Aman Ullah Mohalla Deewan Sahab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000033', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0034', 'Aman Ullah Pahor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000034', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0035', 'Ameer Nawaz Eidgah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000035', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0036', 'Ameer Nawaz, Saddar Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000036', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0037', 'Amjad Gul Karyana, Bannu Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000037', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0038', 'Anwar Masood Diyal Road', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000038', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0039', 'Aqal Khan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000039', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0040', 'Arif Uncal Mahallah Gosi Wala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000040', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0041', 'Army Welfare Shop', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000041', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0042', 'Arshad, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000042', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0043', 'Asad, Bank Alfalah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000043', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0044', 'Ashraf Tayyab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000044', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0045', 'Asif Loading Clerk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000045', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0046', 'Aslam Munshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000046', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0047', 'Asmat Ullah Paandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000047', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0048', 'Atiq Ahmed, Chaman Chowk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000048', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0049', 'Atta Ullah Khan, Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000049', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0050', 'Ayaz Deen Pur', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000050', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0051', 'Ayaz Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000051', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0052', 'Ayub Baloch', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000052', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0053', 'Ayub Khan Tank Ada', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000053', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0054', 'Azhair  C/o Zafir Wapda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000054', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0055', 'Aziz Khan Triman', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000055', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0056', 'Aziz Naswar, Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000056', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0057', 'Aziz Ur Rehman, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000057', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0058', 'Babar Sewayan Chaman Chowk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000058', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0059', 'Baloch Hotel, Nawab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000059', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0060', 'Basheer Hussain', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000060', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0061', 'Basit-Cook', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000061', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0062', 'Bhai Shahid Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000062', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0063', 'Bismillah General Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000063', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0064', 'Bismillah Hotel, Bannu Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000064', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0065', 'Bismillah Karyana Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000065', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0066', 'Chaudhry Ikram, Bazar Kalan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000066', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0067', 'Chaudhry Islam, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000067', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0068', 'Chaudhry Mehr Deen', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000068', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0069', 'Chaudhry Yameen, Paharpur', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000069', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0070', 'City Super Store, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000070', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0071', 'C/o Haji Atiq', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000071', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0072', 'Diler Milk Powder', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000072', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0073', 'Doctor Ramzan, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000073', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0074', 'Doest Muhmmad Khan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000074', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0075', 'Dotani Super Store, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000075', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0076', 'Faheem, Chah Syed Munawar Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000076', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0077', 'Faisal Goga Khel, Bazar Kalan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000077', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0078', 'Faiz Ullah, SABZI MANDI', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000078', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0079', 'Falak Shar Parova', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000079', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0080', 'Fareed Bahi Madina Colny', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000080', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0081', 'Fauji Ahmed Nawaz', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000081', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0082', 'Fayaz Ahmed, Ghala Mandi, Hayat Sugar Dealer', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000082', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0083', 'Fazar Ur Rehman, Bakhri Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000083', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0084', 'Fida Hussain, Bannu Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000084', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0085', 'Gentry Palace', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000085', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0086', 'Ghar Kharcha Haji Imamdin', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000086', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0087', 'Ghar Kharcha Haji Nizam Din', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000087', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0088', 'Ghulam Baqir Shahani, Meeran', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000088', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0089', 'Ghulam Hussain, Hotel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000089', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0090', 'Ghulam Muhammad, City Police', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000090', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0091', 'Ghulam Muhammad GM, Ghala Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000091', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0092', 'Ghulam Nabi, Draban', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000092', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0093', 'Ghulam Rasool, Police Line', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000093', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0094', 'Green Hotel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000094', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0095', 'Gul Habib, Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000095', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0096', 'Gulshan Bakers, Factory', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000096', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0097', 'Gulshan Bakers Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000097', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0098', 'Gulshan Bakers, Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000098', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0099', 'Gulshan Baker Tank Ada', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000099', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0100', 'Gul Zaman Kulchi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000100', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0101', 'Habib Ramzan, Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000101', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0102', 'Habib Ullah Kundi, Draban', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000102', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0103', 'Hafiz Muhammad Rafique, Ghala Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000103', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0104', 'Haji Abdullah, Gaba Karyana Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000104', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0105', 'Haji Abdullah, Muzamil Karyana', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000105', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0106', 'Haji Abdullah, Sheikh Yousaf Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000106', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0107', 'Haji Abdur Rasheed, Chashma Chowk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000107', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0108', 'Haji Abdur Rauf, Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000108', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0109', 'Haji Abdur Rehman, Commisionary Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000109', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0110', 'Haji Abdur Rehman Tirjat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000110', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0111', 'Haji Abdu Salam, Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000111', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0112', 'Haji Aleem Ud Din, Commisionary Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000112', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0113', 'Haji Allah Mehr Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000113', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0114', 'Haji Allaudin, Basti Tareen Abad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000114', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0115', 'Haji Anwar, Bachri', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000115', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0116', 'Haji Azam, Marah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000116', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0117', 'Haji Aziz, Ghala Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000117', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0118', 'Haji Azmat Tank Ada', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000118', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0119', 'Haji Babu Aslam', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000119', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0120', 'Haji Ehsan Atta Dealer', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000120', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0121', 'Haji Ehsan Kaka Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000121', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0122', 'Haji Ellahi Bakhsh, Bazar Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000122', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0123', 'Haji Faheem', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000123', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0124', 'Haji Faiz Muhammad, Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000124', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0125', 'Haji Ghulam Fareed, Bakhri Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000125', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0126', 'Haji Ghulam Qadir Goga Khel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000126', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0127', 'Haji Ghulam Rabani, Nawab Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000127', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0128', 'Haji Ghulam Subhani', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000128', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0129', 'Haji Gul Anwar Pulaow Wala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000129', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0130', 'Haji Imam Din Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000130', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0131', 'Haji Ishfaq Madina Market', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000131', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0132', 'Haji Ishfaq Police Lines', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000132', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0133', 'Haji Jafir Poara', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000133', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0134', 'Haji Khan C/o Sami Bahoo Mill', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000134', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0135', 'Haji Kheeri', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000135', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0136', 'Haji Lal Rang Saaz, Shoaib', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000136', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0137', 'Haji Mani Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000137', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0138', 'Haji Mubeen, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000138', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0139', 'Haji Muhammad Ibrahim, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000139', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0140', 'Haji Muhammad Ramzan, Baloch Nagar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000140', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0141', 'Haji Mushtaq, Bachri', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000141', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0142', 'Haji Saad Rossal', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000142', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0143', 'Haji Saad Ullah, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000143', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0144', 'Haji Sadiq Ghee Dealer', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000144', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0145', 'Haji Sadiq Malang, Bazar Kalan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000145', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0146', 'Haji Sadiq Pakwan, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000146', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0147', 'Haji Saleem, Lala Sweets', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000147', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0148', 'Haji Saleem, Pak Milan Halwa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000148', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0149', 'Haji Sardar Ali, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000149', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0150', 'Haji Shahjehan, Sheikh Yousaf Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000150', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0151', 'Haji Shaukat Mohallah Dewan Sahab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000151', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0152', 'Haji Sher Khan, Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000152', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0153', 'Haji Sher Muhammad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000153', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0154', 'Haji Tea Soter', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000154', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0155', 'Haji Wahid Bakhsh, Bazar Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000155', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0156', 'Haji Yaqoob Number Daar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000156', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0157', 'Haji Younas Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000157', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0158', 'Haji Zahoor, Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000158', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0159', 'Hakim Khan Qursahi Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000159', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0160', 'Hameed Ullah, Commissionary Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000160', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0161', 'Hameed Ullah, Lunda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000161', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0162', 'Haq Nawaz, Draban Chungi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000162', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0163', 'Hashim Khan, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000163', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0164', 'Hashmat Khan, Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000164', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0165', 'Hassan Bakers, Sheikh Yousaf Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000165', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0166', 'Hassan Khan, HBL', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000166', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0167', 'Ibrahim  Mohallah Dewan Shaib', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000167', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0168', 'Ibrahim Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000168', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0169', 'Ideal Hotel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000169', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0170', 'Ijaz Mohallah Hayat Ullah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000170', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0171', 'Ikram, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000171', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0172', 'Imperial Bakers Rafique', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000172', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0173', 'Imran Bakhar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000173', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0174', 'Inayat Dilawar, Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000174', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0175', 'Inayat Hotel Jhok', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000175', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0176', 'Inayat Ullah, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000176', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0177', 'Inayat Ullah, Ubhaya Pul', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000177', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0178', 'Iqra Bakers Nawab Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000178', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0179', 'Irfan Ahmed, Kotli Imam', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000179', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0180', 'Irfan  Chotat BAZAR', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000180', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0181', 'Irfan Munshi, Mohallah Deewan Sahab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000181', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0182', 'Islam Ud Din Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000182', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0183', 'Islam Ud Din Mohallah Deewan Sahab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000183', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0184', 'Ismail Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000184', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0185', 'Jabir Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000185', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0186', 'Jamal Karyana Nawab Ada', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000186', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0187', 'Jamil Ahmad S/o Haji Ibrahim Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000187', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0188', 'Jamil Bahi C/o Usman Munshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000188', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0189', 'Jamil & Javed Mohallah Deewan Sahab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000189', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0190', 'Jamil Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000190', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0191', 'Jamil NCN Cable', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000191', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0192', 'Javed Khan Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000192', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0193', 'Javed Ustaad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000193', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0194', 'Jeelani Halwai Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000194', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0195', 'Kabul Karyana, Mission Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000195', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0196', 'Kala Khan, Jhok Qureshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000196', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0197', 'Karachi Hotel, Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000197', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0198', 'Kashaf Bakers', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000198', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0199', 'Khair Wali, Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000199', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0200', 'Khaleel Ahmed, Tauseef Abad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000200', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0201', 'Khaleel Meezan Ghee', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000201', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0202', 'Khalid, Chaman Chowk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000202', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0203', 'Khalid Halwai, Maqbool Sweets, Ghas Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000203', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0204', 'Khalid Khan, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000204', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0205', 'Khalid, Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000205', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0206', 'Khalil Hotel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000206', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0207', 'Khizar Hayat KULCHI', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000207', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0208', 'KHUDA BAKSH TIBBI QASRANI', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000208', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0209', 'Lal Badshah, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000209', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0210', 'Lal Behram, Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000210', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0211', 'Lal Shah Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000211', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0212', 'Liauqat Ali, Pezu', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000212', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0213', 'Maani Super Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000213', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0214', 'Maaz Karyna', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000214', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0215', 'Madina Tea Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000215', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0216', 'Madni Gur Dealer', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000216', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0217', 'M Ali G Soter', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000217', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0218', 'Malik Allah Nawaz, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000218', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0219', 'Malik Ellahi Bakhsh, Bazar Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000219', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0220', 'Malik Gul Muhammad, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000220', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0221', 'Malik Mithu, Bakhri Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000221', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0222', 'Malik Mushtaq, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000222', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0223', 'Malik Riaz, Baloch Nagar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000223', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0224', 'Malik Sami Ullah Chashma Sugar Mills', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000224', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0225', 'Mama Qayyum, TTC College', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000225', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0226', 'Mama Yaseen & Sons, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000226', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0227', 'Mamoon Peshwar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000227', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0228', 'Manzoor Hussain, Chairman', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000228', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0229', 'Maqbooal Khan Mara', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000229', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0230', 'Maqbool Sweet House', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000230', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0231', 'Marhaba Sweets, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000231', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0232', 'Master  Mohllah Shibshah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000232', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0233', 'Master Nadir Bhittani, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000233', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0234', 'Matloob Bakers', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000234', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0235', 'Mazhar Hameed, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000235', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0236', 'Meer Daad, Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000236', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0237', 'Meer Zaman, Sadar Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000237', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0238', 'Meer Zaman Sadar Bazar 2', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000238', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0239', 'Mehdi Hassan, Chah Syed Munawar Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000239', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0240', 'Metro Shop', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000240', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0241', 'Mohammad Imran Parova', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000241', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0242', 'Mohmmad Aslam Near Ghas Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000242', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0243', 'Molvi Hotel, Ghala Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000243', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0244', 'Moon Light Bakers, Bazar Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000244', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0245', 'Moti Mahal', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000245', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0246', 'Mubeen Cannt.', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000246', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0247', 'Muhammad Afzal Bhakkar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000247', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0248', 'Muhammad Arif, Kachi Paind Khan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000248', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0249', 'Muhammad Arif Khan, Khansama', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000249', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0250', 'Muhammad Arshad, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000250', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0251', 'Muhammad Aslam, Bachri', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000251', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0252', 'Muhammad Aslam, Eidgah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000252', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0253', 'Muhammad Aslam Noor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000253', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0254', 'Muhammad Ayub, Nawab Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000254', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0255', 'Muhammad Bilal, Diyal Road', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000255', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0256', 'Muhammad Faheem, Sadar Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000256', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0257', 'Muhammad Farhan, Eidgah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000257', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0258', 'Muhammad Farid Basti Nad Ali Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000258', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0259', 'Muhammad Hashim Pakwan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000259', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0260', 'Muhammad Hussain, Shorkot', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000260', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0261', 'Muhammad Ibrahim, Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000261', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0262', 'Muhammad Ilyas, Atta Dealer', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000262', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0263', 'Muhammad Irfan, Mission Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000263', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0264', 'Muhammad Irfan Mithai Wala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000264', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0265', 'Muhammad Irfan Parpur', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000265', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0266', 'Muhammad Islam, Tank', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000266', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0267', 'Muhammad Khalid, Mujahid Nagar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000267', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0268', 'Muhammad Luqman, Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000268', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0269', 'Muhammad Nawaz, Chodhwan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000269', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0270', 'Muhammad Nawaz, Lunda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000270', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0271', 'Muhammad Qadeer, Fateh Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000271', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0272', 'Muhammad Ramzan Bismillah Kryana', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000272', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0273', 'Muhammad Ramzan, CRBC', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000273', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0274', 'Muhammad Shahid & Saleem', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000274', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0275', 'Muhammad Shakeel, Imamia Gate', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000275', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0276', 'Muhammad Shakeel, Mohallah Gosaiyan Wala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000276', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0277', 'Muhammad Shakeel, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000277', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0278', 'Muhammad Shakeel, Nawab Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000278', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0279', 'Muhammad Shehzad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000279', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0280', 'Muhammad Shoaib, Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000280', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0281', 'Muhammad Suleman, Mahra', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000281', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0282', 'Muhammad Suleman, Parosi Haji Imam Din', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000282', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0283', 'Muhammad Tariq, Mahra', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000283', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0284', 'Muhammad Yaqoob, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000284', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0285', 'Muhammad Zafar, Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000285', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0286', 'Muhibullah- Lunda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000286', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0287', 'Muhmmad Imran Pathan, Madina Colony', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000287', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0288', 'Mukhtiyar Ahmad Darban', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000288', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0289', 'Mukhtiyar Ahmed, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000289', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0290', 'Mukhtiyar Hussain, Kotla Saidan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000290', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0291', 'Multan Bakers, Chotta Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000291', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0292', 'Muneer Ahmed, Kiri Alizai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000292', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0293', 'Muneer Ahmed, Naiwela', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000293', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0294', 'Muneer Ahmed, New Sabzi Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000294', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0295', 'Muneer Halwai', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000295', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0296', 'Muneer Halwai, Bazar Topanwala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000296', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0297', 'MUZAFIR KHAN MURYALI', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000297', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0298', 'Muzamil, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000298', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0299', 'Nadeem Bakers', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000299', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0300', 'Nadeem Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000300', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0301', 'Nasar Ullah Khan Mara', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000301', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0302', 'Nasar Ullah, Kotli Imam', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000302', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0303', 'Naseeb Fath Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000303', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0304', 'Naseer, Mohallah Hazrat Bilal', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000304', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0305', 'Nasir Hussain Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000305', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0306', 'Naveed Tea Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000306', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0307', 'Nawaz Rice Qureshi Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000307', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0308', 'Nazir Ubhaya Pul', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000308', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0309', 'New Gulshan Kashmir', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000309', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0310', 'Niazi Bakers Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000310', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0311', 'Nisar Karore', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000311', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0312', 'Noman Karyana', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000312', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0313', 'Noor Kariyana Sabzi Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000313', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0314', 'Other Debtors', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000314', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0315', 'Pasham Gul', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000315', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0316', 'Peer Zada, Bakhri Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000316', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0317', 'Qari Irfan Madrsaa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000317', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0318', 'Qari Saeed, Saddar Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000318', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0319', 'Qayyum Karki Shop', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000319', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0320', 'Qayyum Nawaz, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000320', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0321', 'Qureshi Mor Other Debtors', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000321', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0322', 'Rahat International Haj Umra', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000322', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0323', 'Rahat Kashmir Bakers', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000323', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0324', 'Rahat Washing Free Packet', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000324', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0325', 'Ramzan Kat Mallana', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000325', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0326', 'Ramzan, New Sabzi Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000326', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0327', 'Rana Abdu Sattar, Chah Munshi Wala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000327', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0328', 'Rana Amjad Ali, Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000328', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0329', 'Rana Faheem Mohallh Gosiyn Wala', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000329', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0330', 'Rana Sagheer Mujahid Nagar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000330', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0331', 'Rana Tahir Paroa Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000331', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0332', 'Rasheed Draban', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000332', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0333', 'Rasheed, Maqbool Sweets', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000333', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0334', 'Rasheed Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000334', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0335', 'Rasool Wali, Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000335', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0336', 'Rauf Malanra', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000336', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0337', 'Raza Ullah Mara', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000337', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0338', 'Rehmat Ullah Ramak', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000338', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0339', 'Riaz General Store', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000339', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0340', 'Riaz Jhok Qureshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000340', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0341', 'Rizwan Atta Dealer, Ghala Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000341', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0342', 'Rizwan Mujad Neger', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000342', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0343', 'Saad Ullah Jhok Qureshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000343', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0344', 'Sabir Rice Jhok Qureshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000344', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0345', 'Saeed Daraban', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000345', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0346', 'Saeed & Wahid Bakhsh, Ubhaya Pul', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000346', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0347', 'Saif Ullah, Ubhaya Pul', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000347', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0348', 'Saif Ur Rehman', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000348', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0349', 'Saif Ur Rehman Nawab Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000349', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0350', 'Sana Ullah Mohallah Ship Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000350', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0351', 'Sana Ullah Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000351', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0352', 'Saqib Saleem Mohallah Allaudin', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000352', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0353', 'Sardar Naimat Kundi, Lunda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000353', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0354', 'Sarwar Khan Kundi Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000354', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0355', 'Seth Aman Ullah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000355', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0356', 'Seth Shareef', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000356', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0357', 'Shabeer Azad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000357', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0358', 'Shafi Jhok Qureshi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000358', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0359', 'Shahid Ahmed, Chah Syed Munawar Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000359', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0360', 'Shahid & Fazal', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000360', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0361', 'Shahid Khan, Shobrah Hotel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000361', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0362', 'Shah Jee Palay Daar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000362', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0363', 'Shahnawaz Pakwan, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000363', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0364', 'Shahnawaz, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000364', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0365', 'Shakeel Ahmed Muslim Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000365', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0366', 'Shamsher, Dajal', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000366', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0367', 'Shaukat Shah, Chah Syed Munawar Shah', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000367', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0368', 'Shehzad Imtiaz, Basti Kanchkan Wali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000368', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0369', 'Sheikh Abdullah Quraishi Morr', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000369', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0370', 'Sheikh Abdul Latif, Maddi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000370', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0371', 'Sheikh Hadi, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000371', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0372', 'Sheikh Irfan, Bazar Kalan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000372', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0373', 'Sheikh Qamar, Mission Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000373', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0374', 'Sheikh Shaukat, Mission Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000374', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0375', 'Siddique Cloth', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000375', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0376', 'Siddique, Fateh Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000376', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0377', 'Sidra Genral Store Mahsood Market', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000377', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0378', 'Sohail Ahmed Clerk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000378', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0379', 'Sohail Parwana', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000379', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0380', 'Suba Khan Purni Sabzi Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000380', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0381', 'Sufi Allah Nawaz, Baloch Nagar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000381', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0382', 'Sufi Ramzan, Flying Coach Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000382', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0383', 'Sufi Saleem, Hussania Chowk', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000383', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0384', 'Suleman, Bakhri Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000384', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0385', 'Surat Khan Tank Ada', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000385', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0386', 'Taj & Saleem', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000386', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0387', 'Tanveer Ahmed, Ghala Mandi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000387', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0388', 'Tanveer Ahmed Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000388', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0389', 'Tariq Factory Worker', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000389', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0390', 'Tayyab Chota Baazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000390', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0391', 'Tijarat Ganj Other Debtors', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000391', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0392', 'Umar Hayat Pehlwan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000392', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0393', 'Umar Hayat Son of Hayat Sugar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000393', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0394', 'United Karyana Sheikh Yousaf Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000394', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0395', 'Uzair Karyana Bannu Adaa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000395', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0396', 'Wahab, Goga Khel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000396', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0397', 'Wahab Mara', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000397', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0398', 'Wajahat Hussain, Misgran Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000398', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0399', 'Waqas Khan, Madi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000399', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0400', 'Wazir Ikram Baloch', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000400', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0401', 'Yaqoob, Ubhaya Pul', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000401', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0402', 'Yaseen Gulzar, Bazar Kalan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000402', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0403', 'Yaseen Khan, Tijarat Ganj', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000403', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0404', 'Younis Goga Khel', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000404', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0405', 'Yousaf Cheeni Delair', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000405', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0406', 'Yousaf Lunda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000406', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0407', 'Yousaf-Mahra', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000407', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0408', 'Zahir Shah, Paroa', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000408', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0409', 'Zahoor Din Chota Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000409', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0410', 'Zaki Karyana', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000410', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0411', 'Zeshan Clark Cgm', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000411', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0412', 'Ziaudin, Bazar Kalan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000412', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0413', 'Zia Ul Haq, Shorkot', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000413', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0414', 'Zia Ur Rehman, Kulachi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000414', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0415', 'Zubair Tayyab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000415', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0416', 'Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000416', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0417', 'Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿Ã‚Â¿ Ã‚Â¿Ã‚Â¿Ã‚Â¿', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000417', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0418', 'Grand Total', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000418', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0419', 'Cash KT', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000419', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0420', 'Cash-IT', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000419', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0421', 'Hayat ASI', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000420', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0422', 'Cash-BT', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000421', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0423', 'Azhar Corporation(Pvt) Ltd', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000423', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0424', 'Bahoo Flour Mills', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000424', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0425', 'Chashma Ghee Mills Dasti Khata', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000425', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0426', 'Chashma Ghee Mills Ghee', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000426', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0427', 'Haji Allaudin, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000427', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0428', 'Haji Muhammad Guhlam', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000428', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0429', 'Hifzat Soap', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000429', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0430', 'Kafeel Trader Sugar Khtta', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000430', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0431', 'Khwaja Muhammad Imran', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000431', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0432', 'Latif Ghee', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000432', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0433', 'Muhammad Gul, Zafarabad', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000433', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0434', 'Mushtiq Cuhnoti Cheeni Borker', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000434', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0435', 'Next Cola Meezan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000435', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0436', 'Sheikh Shafique', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000436', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0437', 'Sultan Ghee', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000437', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0438', 'Tayyab Traders Sugar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000438', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0439', 'Waheed Salt Dealer', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000439', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0440', 'Waqas Rice Mills', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000440', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0441', 'Zam Rice Khata', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000441', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0442', 'Zam \\ Bahoo Rice Khata', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000442', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0443', 'Zaqat', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000443', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0444', 'Shop Expense', '', '', '', '', '', '', '', null, null, null, null, null, null, null, null, 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0445', 'Loading/ Unloading', '', '', '', '', '', '', '', null, null, null, null, null, null, null, null, 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0446', 'Waqas Nawab', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000421', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0447', 'Irshad Jhok Qureshi Mor', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000447', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0448', 'Haji Aman Ullah, Muryali', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000448', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0449', 'Murtaza, New  Bannu Chungi', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000449', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0450', '(cancelled)', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000450', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0451', 'Abdur Rehman, Bagi Qamar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000451', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0452', 'Aqeel Traders, Darya Khan', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '1310000443', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('0453', 'Zam Zam Karyana, Tank Adda', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000453', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0454', 'Gulshan Bakers, Town Hall', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000454', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0455', 'Haji Gul Anwar, Muslim Bazar', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000455', 'C', null, null, '', null, null);
INSERT INTO `party` VALUES ('0456', 'Muhammad Javed Advocate', '', '', '', '', '', '', '', null, null, null, null, null, null, null, '2610000456', 'S', null, null, '', null, null);
INSERT INTO `party` VALUES ('C0456', 'Younas Muslim Bazar', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);
INSERT INTO `party` VALUES ('C0457', 'Tariq Gandapur', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);
INSERT INTO `party` VALUES ('C0458', 'Kareem Khan Shobra Hotel', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);
INSERT INTO `party` VALUES ('C0459', 'Nasarullah zob c/o Irfan', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);
INSERT INTO `party` VALUES ('C0460', 'Usman c/o irfan', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);
INSERT INTO `party` VALUES ('C0461', 'Friends Bakers', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);
INSERT INTO `party` VALUES ('C0462', 'Abdul Rehman Kot Jai', '', '', '', '', '', 'undefined', '', null, null, null, null, null, null, null, null, 'C', null, null, 'Selet S', null, null);

-- ----------------------------
-- Table structure for `party_add`
-- ----------------------------
DROP TABLE IF EXISTS `party_add`;
CREATE TABLE `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `party_product`
-- ----------------------------
DROP TABLE IF EXISTS `party_product`;
CREATE TABLE `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_product
-- ----------------------------
INSERT INTO `party_product` VALUES ('0001', '0357', '46.000', null, null, null, '3');

-- ----------------------------
-- Table structure for `party_type`
-- ----------------------------
DROP TABLE IF EXISTS `party_type`;
CREATE TABLE `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_type
-- ----------------------------
INSERT INTO `party_type` VALUES ('C', 'Customer');
INSERT INTO `party_type` VALUES ('S', 'Supplier');
INSERT INTO `party_type` VALUES ('T', 'Trader');
INSERT INTO `party_type` VALUES ('I', 'Import');
INSERT INTO `party_type` VALUES ('P', 'Production');
INSERT INTO `party_type` VALUES ('A', 'Cash');
INSERT INTO `party_type` VALUES ('O', 'Other');
INSERT INTO `party_type` VALUES ('V', 'Vender');

-- ----------------------------
-- Table structure for `pay_mode`
-- ----------------------------
DROP TABLE IF EXISTS `pay_mode`;
CREATE TABLE `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pay_mode
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dc`;
CREATE TABLE `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dcdet`;
CREATE TABLE `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gp`;
CREATE TABLE `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `pl_gp_fk_loc_id` (`loc_id`),
  KEY `pl_gp_fk_acct_id` (`acct_id`),
  KEY `pl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gpdet`;
CREATE TABLE `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `pl_gpdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grn`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grn`;
CREATE TABLE `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grn
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grndet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grndet`;
CREATE TABLE `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice`;
CREATE TABLE `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) DEFAULT NULL,
  `acct_id_cs_1` char(10) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoice_fk_loc_id` (`loc_id`),
  KEY `pl_invoice_fk_acct_id` (`acct_id`),
  KEY `pl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice
-- ----------------------------
INSERT INTO `pl_invoice` VALUES ('080003', '2017-08-14', '1310000426', '0.00', '0.00', '229975.00', null, null, null, null, null, null, '424', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '229975', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080002', '2017-08-14', '1310000424', '0.00', '0.00', '79290.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '79290', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080001', '2017-08-13', '9000010001', '0.00', '0.00', '0.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 14:23:44', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', null, null, null, '', '', '', '0', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080004', '2017-08-15', '1310000424', '0.00', '0.00', '25650.00', null, null, null, null, null, null, 'FOR KARCHI', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '25650', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080005', '2017-08-15', '1310000424', '0.00', '0.00', '32350.00', null, null, null, null, null, null, 'KARCHI', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '32350', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080006', '2017-08-15', '1310000424', '0.00', '0.00', '74960.00', null, null, null, null, null, null, 'AHMAD ALI', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '74960', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080007', '2017-08-15', '1310000445', '0.00', '0.00', '1224000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1224000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080002', '2017-08-15', '1310000424', '0.00', '0.00', '3230.00', null, null, null, null, null, null, 'BAHOO SHOP', null, null, null, null, null, '01', null, '2017-08-19 18:32:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3230', 'rashid', null);
INSERT INTO `pl_invoice` VALUES ('080003', '2017-08-15', '1310000424', '0.00', '0.00', '20600.00', null, null, null, null, null, null, 'BAHOO SHOP', null, null, null, null, null, '01', null, '2017-08-19 18:32:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '20600', 'rashid', null);
INSERT INTO `pl_invoice` VALUES ('080004', '2017-08-15', '1310000424', '0.00', '0.00', '14015.00', null, null, null, null, null, null, 'BAHOO SHOP', null, null, null, null, null, '02', null, '2017-08-19 18:32:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '14015', 'rashid', null);
INSERT INTO `pl_invoice` VALUES ('080008', '2017-08-16', '1310000426', '0.00', '0.00', '238850.00', null, null, null, null, null, null, 'saif ullah', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '238850', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080009', '2017-08-16', '1310000426', '0.00', '0.00', '229725.00', null, null, null, null, null, null, 'abdur hmn ', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '229725', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080010', '2017-08-16', '1310000426', '0.00', '0.00', '229975.00', null, null, null, null, null, null, 'munir', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '229975', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080011', '2017-08-16', '1310000426', '0.00', '0.00', '233100.00', null, null, null, null, null, null, 'SHOP 427', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '233100', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080012', '2017-08-16', '1310000424', '0.00', '0.00', '85800.00', null, null, null, null, null, null, 'SHOP', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '85800', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080013', '2017-08-16', '1310000424', '0.00', '0.00', '57960.00', null, null, null, null, null, null, 'SHOP', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '57960', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080005', '2017-08-16', '1310000437', '0.00', '0.00', '1108862.60', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-19 18:32:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1108863', 'rashid', null);
INSERT INTO `pl_invoice` VALUES ('080006', '2017-08-16', '1310000424', '0.00', '0.00', '28315.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-19 18:32:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '28315', 'rashid', null);
INSERT INTO `pl_invoice` VALUES ('080007', '2017-08-16', '2610000422', '0.00', '0.00', '1300.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-19 18:32:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1300', 'rashid', null);
INSERT INTO `pl_invoice` VALUES ('080015', '2017-08-17', '1310000426', null, null, '154870.00', null, null, null, null, null, null, '437', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '', '', null, '', '', null, '', '', null, 'KT', '17', 'on', 'zam zam kryana', null, null, null, null, '', '', '', '154870', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080016', '2017-08-17', '1310000426', null, null, '239058.00', null, null, null, null, null, null, '438', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '', '', null, '', '', null, '', '', null, 'KT', '17', 'on', 'rabani nawab', null, null, null, null, '', '', '', '239058', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090003', '2017-09-24', '1310000439', '0.00', '0.00', '2000.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '03', null, '2017-09-24 18:08:12', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2000', 'it', null);
INSERT INTO `pl_invoice` VALUES ('090002', '2017-08-17', '2610000642', '0.00', '0.00', '1763.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-09-09 14:07:16', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1763', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080017', '2017-08-17', '1310000426', '0.00', '0.00', '239150.00', null, null, null, null, null, null, '439 ahmad', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '239150', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080018', '2017-08-17', '2610000419', '0.00', '0.00', '3099.96', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3100', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080019', '2017-08-17', '1310000424', '0.00', '0.00', '32350.00', null, null, null, null, null, null, 'karchi', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '32350', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080020', '2017-08-17', '1310000424', '0.00', '0.00', '50050.00', null, null, null, null, null, null, 'shop', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '50050', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080009', '2017-08-17', '1310000445', '0.00', '0.00', '1184400.00', null, null, null, null, null, null, 'bahoo shop', null, null, null, null, null, '02', null, '2017-08-20 11:25:28', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1184400', null, null);
INSERT INTO `pl_invoice` VALUES ('080008', '2017-08-17', '1310000424', '0.00', '0.00', '71005.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-20 11:24:50', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '71005', null, null);
INSERT INTO `pl_invoice` VALUES ('080010', '2017-08-16', '1310000426', '0.00', '0.00', '375440.00', null, null, null, null, null, null, '430 BAHOO ', null, null, null, null, null, '02', null, '2017-08-20 11:48:21', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '375440', null, null);
INSERT INTO `pl_invoice` VALUES ('080021', '2017-08-17', '1310000426', '0.00', '0.00', '73800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '73800', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090012', '2017-09-24', '2610000422', '0.00', '0.00', '5500.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '02', null, '2017-09-24 15:51:35', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5500', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090001', '2017-09-24', '2610000201', '0.00', '0.00', '1175000.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '03', null, '2017-09-24 15:34:54', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1175000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080023', '2017-08-17', '2610000419', '0.00', '0.00', '750.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '750', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('43', '2017-08-25', '2610000422', '0.00', '0.00', '4680.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-09-26 09:53:23', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4680', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080025', '2017-08-18', '2610000419', '0.00', '0.00', '520.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '520', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080026', '2017-08-18', '1310000426', '0.00', '0.00', '229375.00', null, null, null, null, null, null, '456', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop', '', '0', '0', '', '', '', '', '229375', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080027', '2017-08-21', '1310000426', '0.00', '0.00', '229975.00', null, null, null, null, null, null, 'shop 456', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '229975', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080028', '2017-08-18', '2610000181', '0.00', '0.00', '660.00', null, null, null, null, null, null, 'shop', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '660', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080029', '2017-08-18', '1310000426', '0.00', '0.00', '229575.00', null, null, null, null, null, null, '444 ehsan ', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '229575', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080030', '2017-08-18', '1310000426', '0.00', '0.00', '238750.00', null, null, null, null, null, null, '445', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'sulman bakhri bazr', '', '0', '0', '', '', '', '', '238750', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080031', '2017-08-18', '1310000426', '0.00', '0.00', '294650.00', null, null, null, null, null, null, '452', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'saeed yark', '', '0', '0', '', '', '', '', '294650', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080032', '2017-08-18', '1310000426', '0.00', '0.00', '240625.00', null, null, null, null, null, null, '459', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'wazir ikram', '', '0', '0', '', '', '', '', '240625', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080033', '2017-08-18', '1310000424', '0.00', '0.00', '85800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop', '', '0', '0', '', '', '', '', '85800', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080034', '2017-08-18', '1310000445', '0.00', '0.00', '1170000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'kafeel', '', '0', '0', '', '', '', '', '1170000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080035', '2017-08-18', '2610000422', '0.00', '0.00', '1520.00', null, null, null, null, null, null, 'bahoo shop', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1520', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('390', '2017-08-19', '1310000426', '0.00', '0.00', '229375.00', null, null, null, null, null, null, '184', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop', '', '0', '0', '', '', '', '', '229375', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080036', '2017-08-20', '1310000426', '0.00', '0.00', '228420.00', null, null, null, null, null, null, '440', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shoukat missn mor', '', '0', '0', '', '', '', '', '228420', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080037', '2017-08-20', '1310000426', '0.00', '0.00', '230475.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop', '', '0', '0', '', '', '', '', '230475', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080038', '2017-08-20', '1310000424', '0.00', '0.00', '85800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'moti mahl', '', '0', '0', '', '', '', '', '85800', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('394', '2017-08-20', '1310000424', '0.00', '0.00', '32350.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'karachi hotal', '', '0', '0', '', '', '', '', '32350', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080039', '2017-08-20', '1310000445', '0.00', '0.00', '576000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'kafeel shop', '', '0', '0', '', '', '', '', '576000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080040', '2017-08-20', '2610000257', '0.00', '0.00', '7250.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '7250', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080041', '2017-08-22', '1310000445', '0.00', '0.00', '2304000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2304000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080042', '2017-08-21', '2610000419', '0.00', '0.00', '2340.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2340', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080043', '2017-08-23', '1310000426', '0.00', '0.00', '238850.00', null, null, null, null, null, null, '477', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'allah mehr', '', '0', '0', '', '', '', '', '238850', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080044', '2017-08-21', '1310000426', '0.00', '0.00', '229775.00', null, null, null, null, null, null, '476', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'ayoub nawab adda', '', '0', '0', '', '', '', '', '229775', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080045', '2017-08-23', '1310000426', '0.00', '0.00', '238550.00', null, null, null, null, null, null, '467', null, null, null, null, null, '02', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'bahoo shop', '', '0', '0', '', '', '', '', '238550', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080046', '2017-08-21', '1310000426', '0.00', '0.00', '163850.00', null, null, null, null, null, null, '468', null, null, null, null, null, '02', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'BAHOO TRADERS', '', '0', '0', '', '', '', '', '163850', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080047', '2017-08-21', '1310000424', '0.00', '0.00', '37150.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'IRFAN BAHOO', '', '0', '0', '', '', '', '', '37150', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080048', '2017-08-21', '2610000136', '0.00', '0.00', '76000.00', null, null, null, null, null, null, '1855', null, null, null, null, null, '01', null, '2017-08-23 13:39:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '76000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080049', '2017-08-22', '1310000426', '0.00', '0.00', '234575.00', null, null, null, null, null, null, '480', null, null, null, null, null, '01', null, '2017-08-24 09:22:56', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop', '', '0', '0', '', '', '', '', '234575', null, null);
INSERT INTO `pl_invoice` VALUES ('080050', '2017-08-22', '1310000426', '0.00', '0.00', '399465.00', null, null, null, null, null, null, '481', null, null, null, null, null, '02', null, '2017-08-24 09:31:54', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'bahoo shop', '', '0', '0', '', '', '', '', '399465', null, null);
INSERT INTO `pl_invoice` VALUES ('080051', '2017-08-22', '1310000426', '0.00', '0.00', '238800.00', null, null, null, null, null, null, '485', null, null, null, null, null, '01', null, '2017-08-24 09:37:27', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'saif ullah  ubhya', '', '0', '0', '', '', '', '', '238800', null, null);
INSERT INTO `pl_invoice` VALUES ('080052', '2017-08-22', '1310000426', '0.00', '0.00', '226355.00', null, null, null, null, null, null, '489', null, null, null, null, null, '01', null, '2017-08-24 09:42:24', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'taj&amp; saleem', '', '0', '0', '', '', '', '', '226355', null, null);
INSERT INTO `pl_invoice` VALUES ('080053', '2017-08-22', '1310000424', '0.00', '0.00', '76375.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 09:47:19', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'ahmed ali', '', '0', '0', '', '', '', '', '76375', null, null);
INSERT INTO `pl_invoice` VALUES ('080054', '2017-08-22', '1310000424', '0.00', '0.00', '32350.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 09:50:37', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'karachi hotal', '', '0', '0', '', '', '', '', '32350', null, null);
INSERT INTO `pl_invoice` VALUES ('080055', '2017-08-22', '1310000424', '0.00', '0.00', '50890.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 09:52:47', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop', '', '0', '0', '', '', '', '', '50890', null, null);
INSERT INTO `pl_invoice` VALUES ('080056', '2017-08-23', '1310000426', '0.00', '0.00', '229375.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 10:32:00', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'SHOP', '', '0', '0', '', '', '', '', '229375', null, null);
INSERT INTO `pl_invoice` VALUES ('090008', '2017-08-23', '2610000422', '0.00', '0.00', '3120.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-09-09 17:21:07', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3120', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('080058', '2017-08-18', '2610000181', '0.00', '0.00', '660.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 10:16:36', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '660', null, null);
INSERT INTO `pl_invoice` VALUES ('080011', '2017-08-20', '2610000422', '0.00', '0.00', '260.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:26:33', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '260', null, null);
INSERT INTO `pl_invoice` VALUES ('080012', '2017-08-21', '2610000422', '0.00', '0.00', '260.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:38:59', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '260', null, null);
INSERT INTO `pl_invoice` VALUES ('080059', '2017-08-25', '2610000201', '0.00', '0.00', '205500.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-27 08:29:53', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'bahoo shop', '', '0', '0', '', '', '', '', '205500', null, null);
INSERT INTO `pl_invoice` VALUES ('080060', '2017-08-25', '2610000201', '0.00', '0.00', '111510.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-27 08:32:09', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'bahoo shop', '', '0', '0', '', '', '', '', '111510', null, null);
INSERT INTO `pl_invoice` VALUES ('080061', '2017-08-25', '1310000445', '0.00', '0.00', '1728000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 08:37:01', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1728000', null, null);
INSERT INTO `pl_invoice` VALUES ('080062', '2017-08-25', '2610000201', '0.00', '0.00', '179000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 08:41:35', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '179000', null, null);
INSERT INTO `pl_invoice` VALUES ('080063', '2017-08-25', '2610000422', '0.00', '0.00', '4680.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-27 08:43:12', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'bt', '', '0', '0', '', '', '', '', '4680', null, null);
INSERT INTO `pl_invoice` VALUES ('080064', '2017-08-25', '1310000426', '0.00', '0.00', '230825.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 08:58:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'shop 530', '', '0', '0', '', '', '', '', '230825', null, null);
INSERT INTO `pl_invoice` VALUES ('080065', '2017-08-25', '1310000426', '0.00', '0.00', '129350.00', null, null, null, null, null, null, '522', null, null, null, null, null, '01', null, '2017-08-27 09:02:42', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'new kulachi', '', '0', '0', '', '', '', '', '129350', null, null);
INSERT INTO `pl_invoice` VALUES ('080066', '2017-08-25', '1310000426', '0.00', '0.00', '92450.00', null, null, null, null, null, null, '523', null, null, null, null, null, '01', null, '2017-08-27 09:06:17', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'hussain 523', '', '0', '0', '', '', '', '', '92450', null, null);
INSERT INTO `pl_invoice` VALUES ('080067', '2017-08-25', '1310000426', '0.00', '0.00', '240200.00', null, null, null, null, null, null, '531', null, null, null, null, null, '01', null, '2017-08-27 09:11:07', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'yousaf t g', '', '0', '0', '', '', '', '', '240200', null, null);
INSERT INTO `pl_invoice` VALUES ('080068', '2017-08-25', '1310000426', '0.00', '0.00', '277350.00', null, null, null, null, null, null, '532', null, null, null, null, null, '01', null, '2017-08-27 09:13:59', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', 'kot jai', '', '0', '0', '', '', '', '', '277350', null, null);
INSERT INTO `pl_invoice` VALUES ('090002', '2017-09-24', '1310000426', '0.00', '0.00', '406700.00', null, null, null, null, null, null, 'ADNA', '1970-01-01', null, null, null, null, '03', null, '2017-09-24 17:49:43', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '406700', 'it', null);
INSERT INTO `pl_invoice` VALUES ('090009', '2017-08-25', '2610000201', '0.00', '0.00', '205500.00', null, null, null, null, null, null, 'BAHOO TRD', null, null, null, null, null, '02', null, '2017-09-10 11:59:05', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '205500', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090003', '2017-08-21', '1310000426', '0.00', '0.00', '238550.00', null, null, null, null, null, null, 'rauf', null, null, null, null, null, '02', null, '2017-09-09 16:36:58', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '238550', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090004', '2017-08-21', '1310000426', '0.00', '0.00', '163850.00', null, null, null, null, null, null, '468 shop', null, null, null, null, null, '02', null, '2017-09-09 16:40:24', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '163850', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090005', '2017-08-21', '1310000424', '0.00', '0.00', '37150.00', null, null, null, null, null, null, 'BAHJOO SHO', null, null, null, null, null, '02', null, '2017-09-09 16:49:22', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '37150', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090006', '2017-08-22', '1310000426', '0.00', '0.00', '399465.00', null, null, null, null, null, null, 'BAHOO SHOP', null, null, null, null, null, '02', null, '2017-09-09 16:53:10', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '399465', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090007', '2017-08-23', '1310000426', '0.00', '0.00', '232487.50', null, null, null, null, null, null, '502 BAHOO ', null, null, null, null, null, '02', null, '2017-09-09 16:59:55', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '232488', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('44', '2017-08-27', '2610000422', '0.00', '0.00', '1820.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-09-26 09:53:23', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1820', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('45', '2017-08-27', '1310000424', '0.00', '0.00', '74115.00', null, null, null, null, null, null, 'BAHOO SHOP', null, null, null, null, null, '02', null, '2017-09-26 09:53:23', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '74115', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('46', '2017-08-28', '1310000424', '0.00', '0.00', '42900.00', null, null, null, null, null, null, 'BAHOO SHOP', null, null, null, null, null, '02', null, '2017-09-26 09:53:23', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '42900', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090010', '2017-08-18', '1310000445', '0.00', '0.00', '585000.00', null, null, null, null, null, null, 'csm 2', null, null, null, null, null, '02', null, '2017-09-10 10:59:57', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '585000', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090011', '2017-08-15', '2610000422', '0.00', '0.00', '3170.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-09-10 14:56:34', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3170', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090004', '2017-09-26', '1310000426', '0.00', '0.00', '403400.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '03', null, '2017-09-26 17:10:38', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', 'ch', '', '0', '0', '', '', '', '', '403400', 'it', null);
INSERT INTO `pl_invoice` VALUES ('090005', '2017-09-27', '1310000424', '0.00', '0.00', '29200.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '03', null, '2017-09-27 16:27:45', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '29200', 'it', null);
INSERT INTO `pl_invoice` VALUES ('090006', '2017-09-27', '1310000426', '0.00', '0.00', '92250.00', null, null, null, null, null, null, '838 shop', '1970-01-01', null, null, null, null, '03', null, '2017-09-28 09:31:01', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '92250', 'kt', null);
INSERT INTO `pl_invoice` VALUES ('090007', '2017-09-28', '1310000426', '0.00', '0.00', '423350.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '03', null, '2017-09-28 15:57:07', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '423350', 'it', null);
INSERT INTO `pl_invoice` VALUES ('090008', '2017-09-29', '2610000201', '0.00', '0.00', '240000.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '03', null, '2017-09-29 10:06:26', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '240000', 'it', '9900010001');

-- ----------------------------
-- Table structure for `pl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedet`;
CREATE TABLE `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedet
-- ----------------------------
INSERT INTO `pl_invoicedet` VALUES ('090002', '2', '0033', '', '51.000', '600.00000', '30600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080007', '1', '0118', '', '5.000', '260.00000', '1300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080006', '3', '0017', '', '10.000', '1430.00000', '14300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080006', '1', '0008', '', '5.000', '1260.00000', '6300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080006', '2', '0009', '', '5.000', '1543.00000', '7715.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '1', '0013', '', '50.000', '2286.00000', '114286.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080013', '1', '0007', '', '92.000', '630.00000', '57960.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080011', '1', '0037', '', '70.000', '1845.00000', '129150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '1', '0035', '', '30.000', '1855.00000', '55650.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080009', '1', '0034', '', '90.000', '1835.00000', '165150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '4', '0035', '', '5.000', '1855.00000', '9275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '1', '0037', '', '20.000', '1845.00000', '36900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080004', '1', '0007', '', '10.000', '630.00000', '6300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080004', '2', '0009', '', '5.000', '1543.00000', '7715.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080003', '1', '0007', '', '10.000', '630.00000', '6300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080002', '1', '0017', 'BAHOO SHOP', '1.000', '1430.00000', '1430.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080007', '1', '0048', 'KAFEEL SHOP', '480.000', '2550.00000', '1224000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080002', '2', '0046', '', '1.000', '1800.00000', '1800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080006', '3', '0009', '', '20.000', '1543.00000', '30860.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080006', '1', '0007', '', '20.000', '630.00000', '12600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '1', '0008', '', '20.000', '1260.00000', '25200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080004', '1', '0008', '', '15.000', '1240.00000', '18600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080004', '2', '0017', '', '5.000', '1410.00000', '7050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080003', '3', '0034', '', '65.000', '1835.00000', '119275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080003', '1', '0035', '', '30.000', '1855.00000', '55650.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080002', '1', '0007', '', '83.000', '630.00000', '52290.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '062', '0078', '', '92.000', '722.00000', '66400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '074', '0094', '', '11.000', '774.00000', '8509.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '085', '0111', '', '7.000', '802.00000', '5617.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '093', '0132', '', '5.000', '5065.00000', '25327.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '094', '0133', '', '8.000', '5000.00000', '40000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '095', '0139', '', '2.000', '211.00000', '422.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '096', '0159', '', '67.000', '369.00000', '24750.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '097', '0160', '', '48.000', '358.00000', '17177.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '123', '0225', '', '160.000', '812.39000', '129982.40', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '124', '0226', '', '9.000', '2563.00000', '23067.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '125', '0227', '', '104.000', '2155.83000', '224206.62', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '126', '0228', '', '36.000', '688.67000', '24792.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '132', '0238', '', '62.000', '1474.68000', '91430.10', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '133', '0239', '', '28.000', '2080.90000', '58265.13', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '134', '0240', '', '1.000', '380.00000', '380.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '135', '0242', '', '18.000', '1160.00000', '20880.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '136', '0243', '', '1.000', '85.00000', '85.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '137', '0241', '', '58.000', '3062.30000', '177613.33', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '138', '0237', '', '182.000', '575.80000', '104795.45', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '3', '0037', '', '20.000', '1845.00000', '36900.00', '', null, null, null, null, '1858.990', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '4', '0076', '', '20.000', '1662.00000', '33240.00', '', null, null, null, null, '1731.660', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '9', '0068', '', '130.000', '985.22000', '128078.60', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '8', '0001', '', '800.000', '818.00000', '654184.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '7', '0069', '', '50.000', '766.00000', '38301.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '6', '0049', '', '50.000', '1429.00000', '71429.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '5', '0096', '', '30.000', '712.00000', '21368.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '4', '0055', '', '20.000', '1406.00000', '28116.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '3', '0160', '', '52.000', '356.00000', '18486.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '2', '0015', '', '50.000', '692.00000', '34614.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080012', '1', '0017', '', '60.000', '1430.00000', '85800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080011', '5', '0034', '', '40.000', '1835.00000', '73400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080011', '4', '0108', '', '10.000', '637.00000', '6370.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080011', '3', '0027', '', '10.000', '1184.00000', '11840.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080011', '2', '0105', '', '10.000', '1234.00000', '12340.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '3', '0034', '', '65.000', '1835.00000', '119275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '2', '0036', '', '30.000', '1835.00000', '55050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080009', '4', '0037', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080009', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080009', '2', '0036', '', '10.000', '1835.00000', '18350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '3', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '2', '0034', '', '85.000', '1835.00000', '155975.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080003', '2', '0017', '', '10.000', '1430.00000', '14300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080006', '2', '0008', '', '25.000', '1260.00000', '31500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080005', '2', '0017', '', '5.000', '1430.00000', '7150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080003', '2', '0036', '', '30.000', '1835.00000', '55050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080002', '2', '0046', '', '15.000', '1800.00000', '27000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '013', '0016', '', '44.000', '758.00000', '33351.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '014', '0017', '', '76.000', '1500.00000', '113974.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '015', '0018', '', '18.000', '1217.00000', '21900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '016', '0019', '', '18.000', '1955.00000', '35192.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '017', '0020', '', '89.000', '319.00000', '28433.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '018', '0021', '', '1.000', '628.00000', '628.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '019', '0022', '', '100.000', '1866.00000', '186626.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '020', '0023', '', '70.000', '1876.00000', '131343.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '021', '0024', '', '17.000', '745.00000', '12669.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '022', '0025', '', '6.000', '1458.00000', '8747.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '023', '0026', '', '2.000', '344.00000', '688.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '024', '0027', '', '82.000', '1219.00000', '99986.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '025', '0028', '', '111.000', '287.00000', '31830.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '026', '0029', '', '144.000', '623.00000', '89783.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '027', '0031', '', '57.000', '1734.00000', '98861.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '028', '0032', '', '178.000', '293.00000', '52218.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '029', '0033', '', '206.000', '597.00000', '123014.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '030', '0034', '', '792.000', '1886.00000', '1493656.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '031', '0035', '', '299.000', '1917.00000', '573144.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '032', '0036', '', '409.000', '1896.00000', '775411.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '033', '0037', '', '572.000', '1901.00000', '1087351.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '034', '0038', '', '261.000', '505.00000', '131837.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '035', '0039', '', '134.000', '513.00000', '68755.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '036', '0042', '', '25.000', '1102.00000', '27560.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '037', '0043', '', '225.000', '41.00000', '9291.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '038', '0044', '', '82.000', '3586.00000', '294043.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '039', '0046', '', '20.000', '1908.00000', '38163.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '040', '0047', '', '116.000', '3282.00000', '380680.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '041', '0048', '', '494.000', '2686.00000', '1326978.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '042', '0049', '', '214.000', '1431.00000', '306219.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '043', '0050', '', '13.000', '1922.00000', '24987.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '044', '0052', '', '3.000', '516.00000', '1549.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '045', '0054', '', '109.000', '1360.00000', '148254.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '046', '0055', '', '29.000', '1425.00000', '41323.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '047', '0056', '', '24.000', '1865.00000', '44764.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '048', '0057', '', '91.000', '799.00000', '72680.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '049', '0058', '', '7.000', '419.00000', '2936.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '050', '0059', '', '12.000', '619.00000', '7432.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '051', '0060', '', '16.000', '291.00000', '4655.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '052', '0062', '', '64.000', '433.00000', '27713.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '053', '0065', '', '326.000', '1416.00000', '461532.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '054', '0067', '', '34.000', '2721.00000', '92524.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '131', '0236', '', '1.000', '4200.00000', '4200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '130', '0235', '', '2.000', '210.00000', '420.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '129', '0231', '', '33.000', '2186.76000', '72163.24', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '127', '0229', '', '144.000', '725.76000', '104510.12', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '128', '0230', '', '15.000', '3259.00000', '48885.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '121', '0223', '', '38.000', '820.53000', '31180.14', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '122', '0224', '', '118.000', '803.45000', '94807.10', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '119', '0221', '', '22.000', '1622.33000', '35691.26', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '120', '0222', '', '39.000', '413.48000', '16125.83', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '118', '0219', '', '8.000', '3053.16000', '24425.28', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '116', '0217', '', '14.000', '1613.41000', '22587.74', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '117', '0218', '', '135.000', '1931.81000', '260793.75', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '115', '0215', '', '85.000', '1857.74000', '157907.77', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '114', '0214', '', '14.000', '2215.38000', '31015.38', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '111', '0211', '', '24.000', '6702.25000', '160853.88', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '112', '0212', '', '8.000', '8731.81000', '69854.44', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '113', '0213', '', '20.000', '3160.33000', '63206.67', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '110', '0210', '', '6.000', '3850.00000', '23100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '109', '0209', '', '2.000', '212.12000', '424.24', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '107', '0187', '', '1.000', '689.19000', '689.19', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '108', '0203', '', '3.000', '911.11000', '2733.33', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '106', '0186', '', '8.000', '653.28000', '5226.23', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '104', '0179', '', '105.000', '2917.67000', '306355.43', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '105', '0185', '', '42.000', '347.15000', '14580.11', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '103', '0176', '', '47.000', '8788.37000', '413053.46', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '102', '0174', '', '24.000', '362.86000', '8708.66', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '099', '0168', '', '33.000', '282.00000', '9294.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '100', '0171', '', '0.000', '0.00000', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '101', '0173', '', '84.000', '2192.86000', '184200.37', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '091', '0126', '', '25.000', '5902.00000', '147545.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '098', '0162', '', '4.000', '2206.00000', '8822.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '092', '0129', '', '35.000', '80.00000', '2800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '089', '0124', '', '32.000', '409.00000', '13076.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '090', '0125', '', '12.000', '2359.00000', '28311.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '088', '0118', '', '215.000', '257.00000', '55279.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '086', '0116', '', '21.000', '1086.00000', '22800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '087', '0117', '', '16.000', '1629.00000', '26057.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '083', '0109', '', '38.000', '1414.00000', '53736.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '084', '0110', '', '3.000', '2043.00000', '6128.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '080', '0102', '', '4.000', '233.00000', '933.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '081', '0104', '', '9.000', '2295.00000', '20655.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '082', '0105', '', '11.000', '1274.00000', '14010.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '078', '0099', '', '4.000', '3992.00000', '15970.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '079', '0101', '', '6.000', '684.00000', '4101.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '077', '0098', '', '30.000', '321.00000', '9644.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '075', '0096', '', '60.000', '720.00000', '43189.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '076', '0097', '', '44.000', '2190.00000', '96380.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '073', '0093', '', '24.000', '2168.00000', '52026.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '071', '0087', '', '67.000', '3784.00000', '253501.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '072', '0091', '', '94.000', '2052.00000', '192919.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '070', '0086', '', '50.000', '568.00000', '28393.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '068', '0084', '', '43.000', '2328.00000', '100108.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '069', '0085', '', '878.000', '2446.00000', '2147710.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '066', '0082', '', '13.000', '1491.00000', '19389.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '067', '0083', '', '5.000', '5444.00000', '27221.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '065', '0081', '', '75.000', '1939.00000', '145403.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '063', '0079', '', '9.000', '700.00000', '6297.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '064', '0080', '', '52.000', '1677.00000', '87204.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '058', '0072', '', '628.000', '2169.00000', '1362230.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '059', '0074', '', '27.000', '5206.00000', '140551.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '060', '0076', '', '23.000', '1732.00000', '39828.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '061', '0077', '', '25.000', '1783.00000', '44563.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '055', '0069', '', '155.000', '730.00000', '113227.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '056', '0070', '', '17.000', '699.00000', '11876.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '057', '0071', '', '12.000', '3083.00000', '37001.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '010', '0013', '', '152.000', '2281.00000', '346646.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '011', '0014', '', '77.000', '2408.00000', '185433.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '012', '0015', '', '106.000', '692.00000', '73335.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '008', '0011', '', '69.000', '1487.00000', '102574.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '009', '0012', '', '35.000', '2359.00000', '82577.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '006', '0009', '', '18.000', '1673.00000', '30115.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '007', '0010', '', '51.000', '2119.00000', '108087.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '004', '0007', '', '92.000', '690.00000', '63440.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '005', '0008', '', '10.000', '1396.00000', '13959.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '001', '0002', '', '2.000', '2006.00000', '4011.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '002', '0004', '', '53.000', '4888.00000', '259054.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080001', '003', '0006', '', '3.000', '4331.00000', '12994.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', null, '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '1', '0118', '', '2.000', '882.00000', '1763.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '1', '0034', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, '1843.488', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '2', '0036', '', '3.000', '1835.00000', '5505.00', '', null, null, null, null, '1847.174', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '5', '0081', '', '4.000', '1895.00000', '7580.00', '', null, null, null, null, '1938.700', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '6', '0027', '', '10.000', '1184.00000', '11840.00', '', null, null, null, null, '1201.670', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '7', '0029', '', '10.000', '602.00000', '6020.00', '', null, null, null, null, '623.490', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '8', '0098', '', '10.000', '311.00000', '3110.00', '', null, null, null, null, '321.480', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '9', '0234', '', '20.000', '559.00000', '11180.00', '', null, null, null, null, '0.000', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080015', '10', '0028', '', '10.000', '279.50000', '2795.00', '', null, null, null, null, '286.750', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '2', '0034', '', '70.000', '1835.00000', '128450.00', '', null, null, null, null, '1843.488', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '1', '0037', '', '20.000', '1845.00000', '36900.00', '', null, null, null, null, '1858.990', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '3', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, '1847.174', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '4', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, '1867.374', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '5', '0027', '', '5.000', '1184.00000', '5920.00', '', null, null, null, null, '1201.670', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '6', '0033', '', '12.000', '579.00000', '6948.00', '', null, null, null, null, '597.150', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('080016', '7', '0234', '', '10.000', '559.00000', '5590.00', '', null, null, null, null, '0.000', null, null, null, null, null, null, 'KT', '17', null, null, null, '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '6', '0036', '', '30.000', '1860.00000', '55800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '5', '0035', '', '40.000', '1880.00000', '75200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080017', '1', '0037', '', '20.000', '1845.00000', '36900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080017', '2', '0034', '', '70.000', '1835.00000', '128450.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080017', '3', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080017', '4', '0035', '', '20.000', '1855.00000', '37100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080018', '1', '0058', '', '6.000', '516.66000', '3099.96', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080019', '1', '0008', '', '20.000', '1260.00000', '25200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080019', '2', '0017', '', '5.000', '1430.00000', '7150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080020', '1', '0017', '', '35.000', '1430.00000', '50050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080009', '1', '0048', '', '480.000', '2467.50000', '1184400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '1', '0007', '', '15.000', '630.00000', '9450.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '2', '0008', '', '10.000', '1260.00000', '12600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '3', '0009', '', '5.000', '1543.00000', '7715.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '4', '0017', '', '10.000', '1430.00000', '14300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '5', '0046', '', '5.000', '1800.00000', '9000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '6', '0102', '', '20.000', '207.00000', '4140.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '7', '0124', '', '20.000', '345.00000', '6900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080008', '8', '0094', '', '10.000', '690.00000', '6900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '3', '0032', '', '51.000', '300.00000', '15300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '4', '0028', '', '30.000', '290.00000', '8700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '1', '0037', '', '25.000', '1845.00000', '46125.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '2', '0034', '', '90.000', '1835.00000', '165150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '3', '0036', '', '35.000', '1835.00000', '64225.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '4', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '5', '0018', '', '15.000', '1184.00000', '17760.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '6', '0021', '', '30.000', '602.00000', '18060.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '7', '0020', '', '20.000', '311.00000', '6220.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '8', '0234', '', '50.000', '559.00000', '27950.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080010', '9', '0086', '', '20.000', '570.00000', '11400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080021', '1', '0037', '', '40.000', '1845.00000', '73800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090012', '1', '0118', '', '22.000', '250.00000', '5500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090001', '1', '0004', '', '250.000', '4700.00000', '1175000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080023', '1', '0070', '', '1.000', '750.00000', '750.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090009', '1', '0080', '', '100.000', '1685.00000', '168500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090009', '2', '0016', '', '50.000', '740.00000', '37000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080025', '1', '0038', '', '1.000', '520.00000', '520.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080026', '1', '0034', '', '125.000', '1835.00000', '229375.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080027', '1', '0034', '', '65.000', '1835.00000', '119275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080027', '2', '0035', '', '30.000', '1855.00000', '55650.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080027', '3', '0036', '', '30.000', '1835.00000', '55050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080028', '1', '0007', '', '1.000', '660.00000', '660.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080029', '1', '0034', '', '95.000', '1835.00000', '174325.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080029', '2', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080029', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080030', '1', '0034', '', '100.000', '1835.00000', '183500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080030', '2', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080030', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080031', '1', '0034', '', '80.000', '1835.00000', '146800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080031', '2', '0036', '', '40.000', '1835.00000', '73400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080031', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080031', '4', '0234', '', '100.000', '559.00000', '55900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '1', '0037', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '2', '0034', '', '45.000', '1835.00000', '82575.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '3', '0036', '', '45.000', '1835.00000', '82575.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '4', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '5', '0057', '', '5.000', '800.00000', '4000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '6', '0038', '', '25.000', '500.00000', '12500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080032', '7', '0039', '', '25.000', '510.00000', '12750.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080033', '1', '0017', '', '60.000', '1430.00000', '85800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080034', '1', '0048', '', '480.000', '2437.50000', '1170000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080035', '1', '0118', '', '2.000', '260.00000', '520.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080035', '2', '0118', '', '5.000', '200.00000', '1000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080036', '3', '0036', '', '10.000', '1835.00000', '18350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080036', '2', '0034', '', '40.000', '1835.00000', '73400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080036', '1', '0037', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('390', '1', '0034', '', '125.000', '1835.00000', '229375.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080036', '4', '0035', '', '5.000', '1855.00000', '9275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080036', '5', '0076', '', '60.000', '1662.00000', '99720.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080037', '1', '0037', '', '70.000', '1845.00000', '129150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080037', '2', '0036', '', '15.000', '1835.00000', '27525.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080037', '3', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080037', '4', '0035', '', '20.000', '1855.00000', '37100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080038', '1', '0017', '', '60.000', '1430.00000', '85800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('394', '1', '0008', '', '20.000', '1260.00000', '25200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('394', '2', '0017', '', '5.000', '1430.00000', '7150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080040', '1', '0118', '', '17.000', '250.00000', '4250.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080039', '1', '0048', '', '240.000', '2400.00000', '576000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080040', '2', '0139', '', '15.000', '200.00000', '3000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080041', '1', '0048', '', '960.000', '2400.00000', '2304000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080042', '1', '0091', '', '1.000', '2340.00000', '2340.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080043', '2', '0036', '', '10.000', '1835.00000', '18350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080043', '1', '0034', '', '105.000', '1835.00000', '192675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080043', '3', '0035', '', '15.000', '1855.00000', '27825.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080044', '1', '0034', '', '70.000', '1835.00000', '128450.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080044', '2', '0036', '', '25.000', '1835.00000', '45875.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080044', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080044', '4', '0037', '', '20.000', '1845.00000', '36900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080045', '1', '0034', '', '120.000', '1835.00000', '220200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080045', '2', '0036', '', '10.000', '1835.00000', '18350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080046', '1', '0022', '', '40.000', '1805.00000', '72200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080046', '2', '0036', '', '30.000', '1835.00000', '55050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080046', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080046', '4', '0056', '', '10.000', '1805.00000', '18050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080047', '1', '0007', '', '10.000', '630.00000', '6300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080047', '2', '0017', '', '10.000', '1430.00000', '14300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080047', '3', '0102', '', '10.000', '215.00000', '2150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080047', '4', '0124', '', '20.000', '360.00000', '7200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080047', '5', '0094', '', '10.000', '720.00000', '7200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080048', '1', '0176', '', '8.000', '9500.00000', '76000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080049', '1', '0035', '', '20.000', '1855.00000', '37100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080049', '2', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080049', '3', '0237', '', '50.000', '279.50000', '13975.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080049', '4', '0034', '', '80.000', '1835.00000', '146800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '1', '0037', '', '30.000', '1845.00000', '55350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '2', '0023', '', '20.000', '1815.00000', '36300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '3', '0031', '', '10.000', '1677.00000', '16770.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '4', '0081', '', '5.000', '1895.00000', '9475.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '5', '0237', '', '30.000', '559.00000', '16770.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '6', '0057', '', '10.000', '800.00000', '8000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '7', '0034', '', '100.000', '1835.00000', '183500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '8', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '9', '0056', '', '10.000', '1805.00000', '18050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080050', '10', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080051', '1', '0037', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080051', '2', '0034', '', '90.000', '1835.00000', '165150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080051', '3', '0035', '', '5.000', '1855.00000', '9275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080051', '4', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080052', '1', '0037', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080052', '2', '0034', '', '70.000', '1835.00000', '128450.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080052', '3', '0036', '', '30.000', '1835.00000', '55050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080052', '4', '0237', '', '20.000', '559.00000', '11180.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080052', '5', '0057', '', '5.000', '800.00000', '4000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080053', '1', '0008', '', '30.000', '1260.00000', '37800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080053', '2', '0009', '', '25.000', '1543.00000', '38575.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080054', '1', '0008', '', '20.000', '1260.00000', '25200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080054', '2', '0017', '', '5.000', '1430.00000', '7150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080055', '1', '0017', '', '23.000', '1430.00000', '32890.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080055', '2', '0046', '', '10.000', '1800.00000', '18000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080056', '1', '0034', '', '125.000', '1835.00000', '229375.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090008', '1', '0118', '', '12.000', '260.00000', '3120.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080058', '1', '0007', '', '1.000', '660.00000', '660.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080011', '1', '0118', '', '1.000', '260.00000', '260.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '7', '0034', '', '70.000', '1860.00000', '130200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080012', '1', '0118', '', '1.000', '260.00000', '260.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080059', '2', '0016', '', '50.000', '740.00000', '37000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080059', '1', '0080', '', '100.000', '1685.00000', '168500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080060', '1', '0044', '', '30.000', '3717.00000', '111510.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080061', '1', '0048', '', '720.000', '2400.00000', '1728000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080062', '2', '0244', '', '50.000', '1795.00000', '89750.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080062', '1', '0244', '', '50.000', '1785.00000', '89250.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080063', '1', '0118', '', '18.000', '260.00000', '4680.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080064', '1', '0034', '', '95.000', '1845.00000', '175275.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080064', '2', '0036', '', '20.000', '1845.00000', '36900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080064', '3', '0035', '', '10.000', '1865.00000', '18650.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080065', '1', '0034', '', '45.000', '1845.00000', '83025.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080065', '2', '0036', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080065', '3', '0035', '', '10.000', '1865.00000', '18650.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080066', '1', '0037', '', '20.000', '1855.00000', '37100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080066', '2', '0034', '', '30.000', '1845.00000', '55350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080067', '1', '0034', '', '90.000', '1845.00000', '166050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080067', '2', '0036', '', '15.000', '1845.00000', '27675.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080067', '3', '0037', '', '15.000', '1855.00000', '27825.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080067', '4', '0034', '', '10.000', '1865.00000', '18650.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080068', '1', '0034', '', '60.000', '1845.00000', '110700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080068', '2', '0036', '', '60.000', '1845.00000', '110700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('080068', '3', '0035', '', '30.000', '1865.00000', '55950.00', '', null, null, null, null, null, null, null, null, null, null, null, 'KT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '1', '0234', '', '60.000', '580.00000', '34800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090003', '1', '0034', '', '120.000', '1835.00000', '220200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('43', '1', '0118', '', '18.000', '260.00000', '4680.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090003', '2', '0036', '', '10.000', '1835.00000', '18350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '1', '0050', '', '40.000', '1805.00000', '72200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '2', '0036', '', '30.000', '1835.00000', '55050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '3', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '4', '0056', '', '10.000', '1805.00000', '18050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '1', '0007', '', '10.000', '630.00000', '6300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '2', '0017', '', '10.000', '1430.00000', '14300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '3', '0102', '', '10.000', '215.00000', '2150.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '4', '0124', '', '20.000', '360.00000', '7200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '5', '0094', '', '10.000', '720.00000', '7200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '1', '0037', '', '30.000', '1845.00000', '55350.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '2', '0023', '', '20.000', '1815.00000', '36300.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '3', '0031', '', '10.000', '1677.00000', '16770.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '4', '0081', '', '5.000', '1895.00000', '9475.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '5', '0237', '', '30.000', '559.00000', '16770.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '6', '0057', '', '10.000', '800.00000', '8000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '7', '0034', '', '100.000', '1835.00000', '183500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '8', '0035', '', '10.000', '1855.00000', '18550.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '9', '0056', '', '10.000', '1805.00000', '18050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '10', '0036', '', '20.000', '1835.00000', '36700.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '1', '0076', '', '50.000', '1662.00000', '83100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '2', '0098', '', '30.000', '311.00000', '9330.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '3', '0081', '', '3.000', '1895.00000', '5685.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '4', '0027', '', '5.000', '1184.50000', '5922.50', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '5', '0034', '', '70.000', '1835.00000', '128450.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('44', '1', '0118', '', '7.000', '260.00000', '1820.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('45', '1', '0007', '', '20.000', '630.00000', '12600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('45', '2', '0008', '', '20.000', '1260.00000', '25200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('45', '3', '0009', '', '5.000', '1543.00000', '7715.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('45', '4', '0017', '', '20.000', '1430.00000', '28600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('46', '1', '0017', '', '30.000', '1430.00000', '42900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090010', '1', '0048', '', '240.000', '2437.50000', '585000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090011', '1', '0118', '', '10.000', '260.00000', '2600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090011', '2', '0007', '', '1.000', '570.00000', '570.00', '', null, null, null, null, null, null, null, null, null, null, null, 'BT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '8', '0037', '', '30.000', '1870.00000', '56100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090003', '1', '0043', '', '50.000', '40.00000', '2000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '1', '0105', '', '30.000', '1240.00000', '37200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '2', '0108', '', '40.000', '630.00000', '25200.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '3', '0185', '', '50.000', '320.00000', '16000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '4', '0234', '', '60.000', '580.00000', '34800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '5', '0057', '', '20.000', '830.00000', '16600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '6', '0034', '', '90.000', '1890.00000', '170100.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '7', '0022', '', '15.000', '1860.00000', '27900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '8', '0037', '', '40.000', '1890.00000', '75600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '1', '0046', '', '8.000', '1950.00000', '15600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '2', '0007', '', '20.000', '680.00000', '13600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '1', '0179', '', '30.000', '3075.00000', '92250.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '1', '0037', '', '70.000', '1900.00000', '133000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '2', '0036', '', '20.000', '1890.00000', '37800.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '3', '0029', '', '30.000', '635.00000', '19050.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '4', '0098', '', '20.000', '320.00000', '6400.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '5', '0081', '', '10.000', '1950.00000', '19500.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '6', '0027', '', '15.000', '1240.00000', '18600.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '7', '0034', '', '100.000', '1890.00000', '189000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090008', '1', '0231', '', '100.000', '2400.00000', '240000.00', '', null, null, null, null, null, null, null, null, null, null, null, 'IT', '17', '0.000', null, '0', '0');

-- ----------------------------
-- Table structure for `pl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedetapp`;
CREATE TABLE `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice_adv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice_adv`;
CREATE TABLE `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice_adv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jv`;
CREATE TABLE `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet`;
CREATE TABLE `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `dr_acct_id` varchar(10) DEFAULT NULL,
  `cr_acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `amount` decimal(13,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet_inst`;
CREATE TABLE `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_order`
-- ----------------------------
DROP TABLE IF EXISTS `pl_order`;
CREATE TABLE `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoice_fk_loc_id` (`loc_id`),
  KEY `pl_invoice_fk_acct_id` (`acct_id`),
  KEY `pl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_orderdet`;
CREATE TABLE `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `pl_pay`;
CREATE TABLE `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet`;
CREATE TABLE `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet_inst`;
CREATE TABLE `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `pl_payment`;
CREATE TABLE `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paymentdet`;
CREATE TABLE `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_po`;
CREATE TABLE `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_podet`;
CREATE TABLE `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receipt`;
CREATE TABLE `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet`;
CREATE TABLE `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_acct`;
CREATE TABLE `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_inv`;
CREATE TABLE `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_po`;
CREATE TABLE `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship`;
CREATE TABLE `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_shipdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_shipdet`;
CREATE TABLE `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_shipdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship_inv`;
CREATE TABLE `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `po`
-- ----------------------------
DROP TABLE IF EXISTS `po`;
CREATE TABLE `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po
-- ----------------------------

-- ----------------------------
-- Table structure for `podet`
-- ----------------------------
DROP TABLE IF EXISTS `podet`;
CREATE TABLE `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of podet
-- ----------------------------

-- ----------------------------
-- Table structure for `po_type`
-- ----------------------------
DROP TABLE IF EXISTS `po_type`;
CREATE TABLE `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po_type
-- ----------------------------
INSERT INTO `po_type` VALUES ('01', 'Ex Works');

-- ----------------------------
-- Table structure for `process`
-- ----------------------------
DROP TABLE IF EXISTS `process`;
CREATE TABLE `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of process
-- ----------------------------
INSERT INTO `process` VALUES ('1', 'Mixing');

-- ----------------------------
-- Table structure for `prod`
-- ----------------------------
DROP TABLE IF EXISTS `prod`;
CREATE TABLE `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod
-- ----------------------------

-- ----------------------------
-- Table structure for `proddet`
-- ----------------------------
DROP TABLE IF EXISTS `proddet`;
CREATE TABLE `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of proddet
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_batch`
-- ----------------------------
DROP TABLE IF EXISTS `prod_batch`;
CREATE TABLE `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_batch
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_cat`
-- ----------------------------
DROP TABLE IF EXISTS `prod_cat`;
CREATE TABLE `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(100) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_cat
-- ----------------------------
INSERT INTO `prod_cat` VALUES ('01', 'Ghee', null, null, null);
INSERT INTO `prod_cat` VALUES ('02', 'CHOKAR', null, null, null);
INSERT INTO `prod_cat` VALUES ('03', 'Detergents', null, null, null);
INSERT INTO `prod_cat` VALUES ('04', 'Grains', null, null, null);
INSERT INTO `prod_cat` VALUES ('05', 'Others', null, null, null);
INSERT INTO `prod_cat` VALUES ('06', 'Spices', null, null, null);
INSERT INTO `prod_cat` VALUES ('07', 'Sugar', null, null, null);
INSERT INTO `prod_cat` VALUES ('08', 'Rice 25 kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('09', 'Oil', null, null, null);
INSERT INTO `prod_cat` VALUES ('10', 'Rahat Cortans', null, null, null);
INSERT INTO `prod_cat` VALUES ('11', 'Sultan/Kashmir 5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('12', 'Sultan/Kashmir/Meezan 2.5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('13', 'Sultan/Kashmir 10kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('14', 'Sultan/Kashmir 16kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('15', 'Sultan/Latif/Kashmir 16ltr Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('16', 'Rahat Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('17', 'Millat/Maqbool 16kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('18', 'Millat/Maqbool 10kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('19', 'Millat/Maqbool 5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('20', 'Millat/Maqbool 2.5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('21', 'Millat Cortan/Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('22', 'Daal 25 kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('23', 'Cholaa 25/50kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('24', 'FLOUR', null, null, null);
INSERT INTO `prod_cat` VALUES ('25', 'MAIDA/STARICH', null, null, null);
INSERT INTO `prod_cat` VALUES ('26', 'KHAL', null, null, null);
INSERT INTO `prod_cat` VALUES ('27', 'SOOJI', null, null, null);
INSERT INTO `prod_cat` VALUES ('28', 'WANDA', null, null, null);
INSERT INTO `prod_cat` VALUES ('29', 'BASIN', null, null, null);
INSERT INTO `prod_cat` VALUES ('30', 'Rice 50 kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('31', 'Rahat/Millat 5kg can', null, null, null);
INSERT INTO `prod_cat` VALUES ('32', 'Rahat/Millat 2.5 kg can', null, null, null);
INSERT INTO `prod_cat` VALUES ('33', 'WASHING POWDERs', null, null, null);
INSERT INTO `prod_cat` VALUES ('34', 'SOAP', null, null, null);
INSERT INTO `prod_cat` VALUES ('35', 'Sultan/Latif/Kashmir 5 kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('36', 'Sultan/Latif/Kashmir 2.5kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('37', 'Sultan/Kashmir 5kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('38', 'Sultan/Kashmir 2.5kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('39', 'Sultan/Kashmir 5ltr Dispenser', null, null, null);
INSERT INTO `prod_cat` VALUES ('40', 'Sultan/Kashmir Cortans', null, null, null);
INSERT INTO `prod_cat` VALUES ('41', 'Sultan/Kashmir 16kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('42', 'meezan sultan 3 ltr bottel carton', null, null, null);
INSERT INTO `prod_cat` VALUES ('43', 'mix iteam / all', null, null, null);
INSERT INTO `prod_cat` VALUES ('44', 'match RS /1 RS/2', null, null, null);
INSERT INTO `prod_cat` VALUES ('45', 'DAAL MOONG / DAAL MASOOR 50 KG', null, null, null);

-- ----------------------------
-- Table structure for `prod_comp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_comp`;
CREATE TABLE `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_comp
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_grp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_grp`;
CREATE TABLE `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_grp
-- ----------------------------
INSERT INTO `prod_grp` VALUES ('01', 'Group Name');

-- ----------------------------
-- Table structure for `prod_rm_date`
-- ----------------------------
DROP TABLE IF EXISTS `prod_rm_date`;
CREATE TABLE `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_rm_date
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_type`
-- ----------------------------
DROP TABLE IF EXISTS `prod_type`;
CREATE TABLE `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_type
-- ----------------------------
INSERT INTO `prod_type` VALUES ('01', 'Franchise Group', '0700100001', '0500030003', '0800010101');

-- ----------------------------
-- Table structure for `regions`
-- ----------------------------
DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
  `reg_id` varchar(6) NOT NULL DEFAULT '',
  `reg_name` varchar(100) NOT NULL,
  PRIMARY KEY (`reg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of regions
-- ----------------------------
INSERT INTO `regions` VALUES ('01', 'PUNJAB');
INSERT INTO `regions` VALUES ('0101', 'Lahore');
INSERT INTO `regions` VALUES ('010101', 'DHA');
INSERT INTO `regions` VALUES ('0102', 'MULTAN');
INSERT INTO `regions` VALUES ('02', 'KPK');
INSERT INTO `regions` VALUES ('0201', 'DERA ISMAIL KHAN');
INSERT INTO `regions` VALUES ('020101', 'BANNU ADDA');
INSERT INTO `regions` VALUES ('020102', 'Muriali to Ramak');
INSERT INTO `regions` VALUES ('020103', 'Sheikh yousaf Adda');
INSERT INTO `regions` VALUES ('020104', 'Raheem Bazar');
INSERT INTO `regions` VALUES ('020105', 'Tijarat Ganj');
INSERT INTO `regions` VALUES ('020106', 'Out Station');
INSERT INTO `regions` VALUES ('020107', 'Misgran Bazar');
INSERT INTO `regions` VALUES ('020108', 'Old Ledger');
INSERT INTO `regions` VALUES ('020109', 'Muslim Bazar');
INSERT INTO `regions` VALUES ('020110', 'Kalan Bazar');
INSERT INTO `regions` VALUES ('020111', 'Main Dealers');
INSERT INTO `regions` VALUES ('020112', 'D.I.Khan Suburbs');
INSERT INTO `regions` VALUES ('020113', 'Ghala Mandi, Bazar Kalan, Chot');
INSERT INTO `regions` VALUES ('020114', 'Muryali to Qureshi Morr');
INSERT INTO `regions` VALUES ('020115', 'Others');
INSERT INTO `regions` VALUES ('1', 'Punjab (Province)');

-- ----------------------------
-- Table structure for `replanishment`
-- ----------------------------
DROP TABLE IF EXISTS `replanishment`;
CREATE TABLE `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of replanishment
-- ----------------------------
INSERT INTO `replanishment` VALUES ('SD03001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH08', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH09', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH10', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH11', '0', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH08', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH09', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH10', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH11', '0', '05');

-- ----------------------------
-- Table structure for `report`
-- ----------------------------
DROP TABLE IF EXISTS `report`;
CREATE TABLE `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report
-- ----------------------------
INSERT INTO `report` VALUES ('2010-11-25', '2015-11-25');

-- ----------------------------
-- Table structure for `reports`
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`REP_ID`),
  UNIQUE KEY `REPORTS_PK11109972190599` (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports
-- ----------------------------
INSERT INTO `reports` VALUES ('trial_balance', 'Trial Balance', '1', '', '001');
INSERT INTO `reports` VALUES ('ledger', 'Ledger', '1', 'N', '003');
INSERT INTO `reports` VALUES ('profit_loss', 'Profit & Loss', '1', 'N', '004');
INSERT INTO `reports` VALUES ('chart', 'Chart of Accounts', '1', 'N', '005');
INSERT INTO `reports` VALUES ('balance_sheet', 'Balance Sheet', '1', 'N', '006');
INSERT INTO `reports` VALUES ('daybook_kt', 'Daybook', '1', 'Y', '007');
INSERT INTO `reports` VALUES ('pdf_sl_due_invoices', 'Due Invoices', '2', '', '009');
INSERT INTO `reports` VALUES ('pf_sl_supply_register', 'Supply Register', '2', '', '010');
INSERT INTO `reports` VALUES ('report_current_stock', 'Current Stock', '2', '', '011');
INSERT INTO `reports` VALUES ('report_sale?report=PL', 'Day Book', '3', '', '012');
INSERT INTO `reports` VALUES ('report_sale?report=ST', 'Day Book', '4', '', '013');
INSERT INTO `reports` VALUES ('stock_ledger', 'Stock Ledger', '4', '', '014');
INSERT INTO `reports` VALUES ('stock_summary', 'Stock Summary', '4', '', '015');
INSERT INTO `reports` VALUES ('smart_stock', 'Smart Stock', '4', '', '016');
INSERT INTO `reports` VALUES ('report_sale?report=SL', 'Day Book', '2', '', '017');
INSERT INTO `reports` VALUES ('cashbook', 'Cash Book', '1', '', '018');
INSERT INTO `reports` VALUES ('report_sales', 'Sale Report', '2', 'Y', '019');
INSERT INTO `reports` VALUES ('party_trial', 'Trial', '2', '', '020');
INSERT INTO `reports` VALUES ('kt_cashbook', 'Cashbook-KT', '1', 'Y', '022');

-- ----------------------------
-- Table structure for `reports_all`
-- ----------------------------
DROP TABLE IF EXISTS `reports_all`;
CREATE TABLE `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports_all
-- ----------------------------
INSERT INTO `reports_all` VALUES ('accountsummary', 'Account Summary', '1', 'N');

-- ----------------------------
-- Table structure for `report_brands`
-- ----------------------------
DROP TABLE IF EXISTS `report_brands`;
CREATE TABLE `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_brands
-- ----------------------------
INSERT INTO `report_brands` VALUES ('1301', '1202', '1103', '1102', null);

-- ----------------------------
-- Table structure for `report_cat`
-- ----------------------------
DROP TABLE IF EXISTS `report_cat`;
CREATE TABLE `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `report_comp`
-- ----------------------------
DROP TABLE IF EXISTS `report_comp`;
CREATE TABLE `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_comp
-- ----------------------------
INSERT INTO `report_comp` VALUES ('01');

-- ----------------------------
-- Table structure for `report_cs`
-- ----------------------------
DROP TABLE IF EXISTS `report_cs`;
CREATE TABLE `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cs
-- ----------------------------

-- ----------------------------
-- Table structure for `report_div`
-- ----------------------------
DROP TABLE IF EXISTS `report_div`;
CREATE TABLE `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_div
-- ----------------------------

-- ----------------------------
-- Table structure for `report_party`
-- ----------------------------
DROP TABLE IF EXISTS `report_party`;
CREATE TABLE `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_party
-- ----------------------------
INSERT INTO `report_party` VALUES ('0063');

-- ----------------------------
-- Table structure for `report_sp`
-- ----------------------------
DROP TABLE IF EXISTS `report_sp`;
CREATE TABLE `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_sp
-- ----------------------------

-- ----------------------------
-- Table structure for `season_cat`
-- ----------------------------
DROP TABLE IF EXISTS `season_cat`;
CREATE TABLE `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of season_cat
-- ----------------------------
INSERT INTO `season_cat` VALUES ('010101', 'WINTER');
INSERT INTO `season_cat` VALUES ('010102', 'SUMMER');

-- ----------------------------
-- Table structure for `size`
-- ----------------------------
DROP TABLE IF EXISTS `size`;
CREATE TABLE `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of size
-- ----------------------------
INSERT INTO `size` VALUES ('08', 'S');
INSERT INTO `size` VALUES ('09', 'M');
INSERT INTO `size` VALUES ('10', 'L');
INSERT INTO `size` VALUES ('11', 'XL');

-- ----------------------------
-- Table structure for `sl_am_con`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_con`;
CREATE TABLE `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_con
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_condet`;
CREATE TABLE `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_cont`
-- ----------------------------
DROP TABLE IF EXISTS `sl_cont`;
CREATE TABLE `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_cont
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contdet`;
CREATE TABLE `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contmaint`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contmaint`;
CREATE TABLE `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contmaint
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contpay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contpay`;
CREATE TABLE `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contpay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc`;
CREATE TABLE `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `order_id` varchar(10) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet`;
CREATE TABLE `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_dcdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_copy`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_copy`;
CREATE TABLE `sl_dcdet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_copy
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_ser`;
CREATE TABLE `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtn`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtn`;
CREATE TABLE `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtn
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet`;
CREATE TABLE `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet_ser`;
CREATE TABLE `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gp`;
CREATE TABLE `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gp_fk_loc_id` (`loc_id`),
  KEY `sl_gp_fk_acct_id` (`acct_id`),
  KEY `sl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gp
-- ----------------------------
INSERT INTO `sl_gp` VALUES ('080002', '2017-08-13', '', '0.00', '0.00', '270139.00', null, null, null, null, null, null, 'ST0002', null, null, null, null, null, '01', null, '2017-08-16 20:28:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '270139', null, '');
INSERT INTO `sl_gp` VALUES ('080003', '2017-08-13', '', '0.00', '0.00', '3096082.00', null, null, null, null, null, null, 'ST0003', null, null, null, null, null, '01', null, '2017-08-16 20:51:31', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3096082', null, '');
INSERT INTO `sl_gp` VALUES ('090001', '2017-08-16', '', '0.00', '0.00', '248123.00', null, null, null, null, null, null, 'ST0001', null, null, null, null, null, '01', null, '2017-09-09 18:03:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '248123', null, 'kt');
INSERT INTO `sl_gp` VALUES ('161', '2017-08-28', '', '0.00', '0.00', '196750.00', null, null, null, null, null, null, 'ST0004', null, null, null, null, null, '01', null, '2017-09-09 18:12:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', 'KT', '17', null, '', '', '0', '0', '', '', '', '', '196750', null, 'kt');
INSERT INTO `sl_gp` VALUES ('090002', '2017-09-23', '', '0.00', '0.00', '0.00', null, null, null, null, null, null, 'ST0005', null, null, null, null, null, '03', null, '2017-09-25 21:35:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '0', null, 'kt');
INSERT INTO `sl_gp` VALUES ('090001', '2017-09-26', '', '0.00', '0.00', '0.00', null, null, null, null, null, null, 'ST0001', null, null, null, null, null, '01', null, '2017-09-26 17:02:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '0', null, 'kt');

-- ----------------------------
-- Table structure for `sl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gpdet`;
CREATE TABLE `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gpdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gpdet
-- ----------------------------
INSERT INTO `sl_gpdet` VALUES ('090001', '1', '0001', '', '150.000', '802.00000', '120300.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '1', '0038', '', '48.000', '505.00000', '24235.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '2', '0039', '', '38.000', '514.00000', '19532.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '3', '0111', '', '7.000', '802.00000', '5617.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '4', '0129', '', '35.000', '80.00000', '2800.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '5', '0086', '', '3.000', '567.00000', '1701.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '6', '0059', '', '4.000', '618.00000', '2472.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '7', '0007', '', '8.000', '698.00000', '5584.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '8', '0008', '', '6.000', '1388.00000', '8326.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '9', '0203', '', '3.000', '911.00000', '2733.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '10', '0017', '', '9.000', '1528.00000', '13755.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '11', '0199', '', '2.000', '3367.00000', '6735.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '12', '0046', '', '3.000', '1954.00000', '5862.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '13', '0102', '', '4.000', '233.00000', '933.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '14', '0124', '', '32.000', '409.00000', '13076.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '15', '0094', '', '11.000', '774.00000', '8509.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '16', '0062', '', '64.000', '433.00000', '27713.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '17', '0016', '', '44.000', '758.00000', '33352.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080002', '18', '0080', '', '52.000', '1677.00000', '87204.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '1', '0072', '', '35.000', '2173.00000', '76065.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '2', '0055', '', '23.000', '1427.00000', '32824.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '3', '0012', '', '30.000', '2363.00000', '70885.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '4', '0014', '', '3.000', '2340.00000', '7021.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '5', '0179', '', '83.000', '3037.00000', '252071.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '6', '0044', '', '5.000', '3522.00000', '17609.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '7', '0159', '', '49.000', '368.00000', '18054.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '8', '0160', '', '12.000', '357.00000', '4280.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '9', '0077', '', '7.000', '1765.00000', '12355.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '10', '0096', '', '42.000', '719.00000', '30210.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '11', '0015', '', '92.000', '691.00000', '63566.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '12', '0082', '', '9.000', '1500.00000', '13498.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '13', '0186', '', '8.000', '653.00000', '5226.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '14', '0070', '', '3.000', '720.00000', '2161.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '15', '0049', '', '178.000', '1436.00000', '255587.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '16', '0065', '', '19.000', '1433.00000', '27228.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '17', '0013', '', '86.000', '2275.00000', '195665.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '18', '0173', '', '2.000', '2135.00000', '4269.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '19', '0018', '', '12.000', '1228.00000', '14736.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '20', '0019', '', '7.000', '1965.00000', '13758.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '21', '0020', '', '29.000', '323.00000', '9372.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '22', '0021', '', '1.000', '628.00000', '628.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '23', '0081', '', '5.000', '1900.00000', '9500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '24', '0029', '', '16.000', '644.00000', '10304.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '25', '0031', '', '12.000', '1748.00000', '20975.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '26', '0076', '', '23.000', '1732.00000', '39828.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '27', '0168', '', '30.000', '281.00000', '8415.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '28', '0032', '', '39.000', '301.00000', '11725.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '29', '0028', '', '34.000', '287.00000', '9773.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '30', '0033', '', '61.000', '597.00000', '36408.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '31', '0241', '', '34.000', '581.00000', '19765.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '32', '0056', '', '20.000', '1858.00000', '37154.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '33', '0050', '', '13.000', '1922.00000', '24987.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '34', '0022', '', '83.000', '1872.00000', '155360.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '35', '0036', '', '88.000', '1906.00000', '167761.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '36', '0035', '', '45.000', '1919.00000', '86366.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '37', '0034', '', '155.000', '1894.00000', '293576.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '38', '0023', '', '44.000', '1877.00000', '82593.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '39', '0037', '', '90.000', '1908.00000', '171713.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '40', '0057', '', '8.000', '793.00000', '6344.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '41', '0126', '', '15.000', '5667.00000', '85004.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '42', '0238', '', '8.000', '1456.00000', '11647.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '43', '0215', '', '6.000', '1722.00000', '10329.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '44', '0006', '', '3.000', '4331.00000', '12994.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '45', '0132', '', '1.000', '5461.00000', '5461.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '46', '0004', '', '10.000', '4878.00000', '48777.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '47', '0054', '', '68.000', '1345.00000', '91439.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '48', '0085', '', '40.000', '2267.00000', '90686.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '49', '0087', '', '13.000', '3750.00000', '48750.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '50', '0099', '', '2.000', '2143.00000', '4285.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '51', '0078', '', '69.000', '738.00000', '50932.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '52', '0043', '', '31.000', '48.00000', '1493.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '53', '0235', '', '2.000', '210.00000', '420.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '54', '0048', '', '107.000', '2726.00000', '291653.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '55', '0139', '', '2.000', '211.00000', '422.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('080003', '56', '0118', '', '163.000', '257.00000', '41940.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '56', '0095', '', '16.000', '2750.00000', '44000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '54', '0054', '', '19.000', '1385.00000', '26315.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '55', '0231', '', '23.000', '2185.00000', '50255.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '52', '0006', '', '4.000', '4100.00000', '16400.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '53', '0189', '', '42.000', '1150.00000', '48300.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '34', '0022', '', '25.000', '1832.00000', '45800.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '32', '0036', '', '20.000', '1860.00000', '37200.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '33', '0035', '', '7.000', '1880.00000', '13160.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '31', '0034', '', '110.000', '1860.00000', '204600.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '30', '0033', '', '16.000', '587.00000', '9392.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '29', '0234', '', '30.000', '570.00000', '17100.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '28', '0028', '', '16.000', '282.00000', '4512.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '27', '0031', '', '10.000', '1707.00000', '17070.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '26', '0098', '', '28.000', '315.00000', '8820.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '25', '0029', '', '32.000', '612.00000', '19584.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '24', '0027', '', '28.000', '1202.00000', '33656.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '23', '0081', '', '20.000', '1912.00000', '38240.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '22', '0065', '', '92.000', '1440.00000', '132480.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '21', '0227', '', '34.000', '2146.00000', '72964.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '20', '0001', '', '50.000', '805.00000', '40250.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '19', '0069', '', '12.000', '12740.00000', '152880.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '18', '0229', '', '154.000', '724.00000', '111496.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '17', '0228', '', '50.000', '690.00000', '34500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '16', '0068', '', '7.000', '1245.00000', '8715.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '15', '0044', '', '20.000', '3615.00000', '72300.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '14', '0093', '', '2.000', '2180.00000', '4360.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '13', '0084', '', '37.000', '2250.00000', '83250.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '12', '0002', '', '17.000', '2005.00000', '34085.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '11', '0072', '', '265.000', '2170.00000', '575050.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '10', '0009', '', '10.000', '1638.00000', '16380.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '9', '0017', '', '23.000', '1465.00000', '33695.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '8', '0046', '', '12.000', '1870.00000', '22440.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '7', '0007', '', '38.000', '660.00000', '25080.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '6', '0008', '', '19.000', '1325.00000', '25175.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '5', '0059', '', '6.000', '700.00000', '4200.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '4', '0074', '', '22.000', '5205.00000', '114510.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('161', '1', '0004', '', '5.000', '4600.00000', '23000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '4', '0055', '', '10.000', '1427.00000', '14270.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '5', '0096', '', '10.000', '719.00000', '7190.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '6', '0159', '', '12.000', '368.00000', '4416.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '7', '0160', '', '12.000', '356.00000', '4272.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '8', '0015', '', '10.000', '690.00000', '6900.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '9', '0013', '', '20.000', '2275.00000', '45500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '10', '0082', '', '5.000', '1500.00000', '7500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '11', '0077', '', '3.000', '1765.00000', '5295.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '12', '0068', '', '10.000', '1582.00000', '15820.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('161', '2', '0215', '', '5.000', '1750.00000', '8750.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('161', '3', '0040', '', '60.000', '2750.00000', '165000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '1', '0038', '', '47.000', '503.00000', '23641.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '2', '0039', '', '41.000', '512.00000', '20992.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '3', '0116', '', '3.000', '1200.00000', '3600.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '51', '0230', '', '11.000', '3250.00000', '35750.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '50', '0215', '', '153.000', '1720.00000', '263160.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '49', '0238', '', '26.000', '1500.00000', '39000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '48', '0237', '', '1.000', '6000.00000', '6000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '47', '0213', '', '9.000', '3160.00000', '28440.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '46', '0214', '', '4.000', '2250.00000', '9000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '45', '0004', '', '2.000', '4800.00000', '9600.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '44', '0133', '', '7.000', '4800.00000', '33600.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '43', '0053', '', '10.000', '5350.00000', '53500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '42', '0212', '', '3.000', '8735.00000', '26205.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '41', '0211', '', '8.000', '6765.00000', '54120.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '40', '0003', '', '49.000', '3065.00000', '150185.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '39', '0057', '', '2.000', '800.00000', '1600.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '38', '0037', '', '97.000', '1880.00000', '182360.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '37', '0023', '', '19.000', '1855.00000', '35245.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '35', '0056', '', '10.000', '1820.00000', '18200.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '36', '0050', '', '5.000', '1840.00000', '9200.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '2', '0232', '', '5.000', '970.00000', '4850.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '3', '0012', '', '5.000', '2362.00000', '11810.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '57', '0042', '', '12.000', '1150.00000', '13800.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '58', '0085', '', '14.000', '2520.00000', '35280.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '59', '0191', '', '12.000', '4500.00000', '54000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '60', '0097', '', '25.000', '2500.00000', '62500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '61', '0078', '', '14.000', '670.00000', '9380.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '62', '0240', '', '1.000', '380.00000', '380.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '63', '0043', '', '3.000', '40.00000', '120.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '64', '0010', '', '12.000', '2100.00000', '25200.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090002', '65', '0048', '', '1583.000', '2500.00000', '3957500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '1', '0004', '', '20.000', '4700.00000', '94000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_gpdet` VALUES ('090001', '2', '0215', '', '20.000', '1600.00000', '32000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'IT', '17', '0.000', '0.00', '0', '0', '0', '', '');

-- ----------------------------
-- Table structure for `sl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice`;
CREATE TABLE `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `order_id` varchar(10) NOT NULL,
  `emp_id` varchar(20) NOT NULL,
  `acct_id_cs_1` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoice_fk_loc_id` (`loc_id`),
  KEY `sl_invoice_fk_acct_id` (`acct_id`),
  KEY `sl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice
-- ----------------------------
INSERT INTO `sl_invoice` VALUES ('080032', '2017-08-14', '2610000223', '0.00', '0.00', '2720.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:55:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2720', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080033', '2017-08-14', '2610000419', '0.00', '0.00', '660.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:55:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '660', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080034', '2017-08-14', '2610000419', '0.00', '0.00', '2800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:55:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080035', '2017-08-14', '2610000419', '0.00', '0.00', '5200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:55:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080036', '2017-08-14', '2610000113', '0.00', '0.00', '78900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:55:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '78900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080037', '2017-08-14', '2610000299', '0.00', '0.00', '31440.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:56:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '31440', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080038', '2017-08-14', '2610000142', '0.00', '0.00', '3760.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:56:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3760', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080039', '2017-08-14', '2610000400', '0.00', '0.00', '45450.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:56:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '45450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080040', '2017-08-14', '2610000419', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:56:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080041', '2017-08-14', '2610000419', '0.00', '0.00', '850.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:56:49', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '850', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080042', '2017-08-14', '2610000419', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:57:00', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080001', '2017-08-14', '2610000419', '0.00', '0.00', '1500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:42:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080031', '2017-08-14', '2610000419', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:54:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080043', '2017-08-14', '2610000419', '0.00', '0.00', '5200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:57:11', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080018', '2017-08-14', '2610000419', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:50:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080028', '2017-08-14', '2610000148', '0.00', '0.00', '94500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:53:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '94500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080027', '2017-08-14', '2610000253', '0.00', '0.00', '231650.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:53:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '231650', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080026', '2017-08-14', '2610000107', '0.00', '0.00', '242100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:53:13', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '242100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080024', '2017-08-14', '2610000419', '0.00', '0.00', '7070.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:52:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '7070', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080023', '2017-08-14', '2610000419', '0.00', '0.00', '670.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:51:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '670', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080022', '2017-08-14', '2610000114', '0.00', '0.00', '6030.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:51:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '6030', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080021', '2017-08-14', '2610000419', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:51:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080029', '2017-08-14', '2610000419', '0.00', '0.00', '3740.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:54:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3740', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080020', '2017-08-14', '2610000419', '0.00', '0.00', '5200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:58:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080019', '2017-08-14', '2610000264', '0.00', '0.00', '22250.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:51:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '22250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080030', '2017-08-14', '2610000419', '0.00', '0.00', '1870.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:54:35', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1870', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080017', '2017-08-14', '2610000624', '0.00', '0.00', '20280.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:50:10', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '20280', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080016', '2017-08-14', '2610000419', '0.00', '0.00', '1870.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:49:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1870', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080015', '2017-08-14', '2610000419', '0.00', '0.00', '4470.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:49:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '4470', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080013', '2017-08-14', '2610000122', '0.00', '0.00', '44500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:47:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '44500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080014', '2017-08-14', '2610000393', '0.00', '0.00', '22440.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:58:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '22440', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080003', '2017-08-14', '2610000419', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:42:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080010', '2017-08-14', '2610000419', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:58:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080009', '2017-08-14', '2610000419', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:58:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080008', '2017-08-14', '2610000419', '0.00', '0.00', '1640.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:58:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1640', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080007', '2017-08-14', '2610000419', '0.00', '0.00', '1500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:58:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080006', '2017-08-14', '2610000419', '0.00', '0.00', '1880.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:45:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1880', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080005', '2017-08-14', '2610000402', '0.00', '0.00', '13110.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-14 15:45:08', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '13110', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080038', '2017-08-16', '2610000422', '0.00', '0.00', '13020.00', null, null, null, null, null, null, '1293', null, null, null, null, null, '02', null, '2017-08-17 10:33:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '13020', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080004', '2017-08-14', '2610000419', '0.00', '0.00', '1500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 22:54:15', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080001', '2017-08-15', '2610000422', '0.00', '0.00', '1880.00', null, null, null, null, null, null, '2098', null, null, null, null, null, '02', null, '2017-08-15 14:50:10', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1880', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080003', '2017-08-15', '2610000422', '0.00', '0.00', '4640.00', null, null, null, null, null, null, '2100', null, null, null, null, null, '02', null, '2017-08-15 14:55:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4640', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080004', '2017-08-15', '2610000422', '0.00', '0.00', '2680.00', null, null, null, null, null, null, '4330', null, null, null, null, null, '02', null, '2017-08-15 14:58:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2680', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080005', '2017-08-15', '2610000422', '0.00', '0.00', '10450.00', null, null, null, null, null, null, '4331', null, null, null, null, null, '02', null, '2017-08-15 15:27:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '10450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080006', '2017-08-15', '2610000422', '0.00', '0.00', '2120.00', null, null, null, null, null, null, '4332', null, null, null, null, null, '02', null, '2017-08-15 15:30:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2120', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080007', '2017-08-15', '2610000003', '0.00', '0.00', '28490.00', null, null, null, null, null, null, '4333', null, null, null, null, null, '02', null, '2017-08-15 15:37:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '28490', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080008', '2017-08-15', '2610000422', '0.00', '0.00', '5860.00', null, null, null, null, null, null, '4334', null, null, null, null, null, '02', null, '2017-09-10 11:21:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5860', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080009', '2017-08-15', '2610000332', '0.00', '0.00', '39250.00', null, null, null, null, null, null, '4335', null, null, null, null, null, '02', null, '2017-08-15 15:48:13', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '39250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080010', '2017-08-15', '2610000642', '0.00', '0.00', '59460.00', null, null, null, null, null, null, '4336', null, null, null, null, null, '02', null, '2017-09-10 11:30:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '59460', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080011', '2017-08-15', '2610000422', '0.00', '0.00', '3260.00', null, null, null, null, null, null, '4337', null, null, null, null, null, '02', null, '2017-08-15 15:59:29', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3260', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080012', '2017-08-15', '2610000422', '0.00', '0.00', '10680.00', null, null, null, null, null, null, '4338', null, null, null, null, null, '02', null, '2017-08-17 09:48:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '10680', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080013', '2017-08-15', '2610000422', '0.00', '0.00', '8610.00', null, null, null, null, null, null, '4339', null, null, null, null, null, '02', null, '2017-08-15 16:07:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8610', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080014', '2017-08-15', '2610000336', '0.00', '0.00', '17240.00', null, null, null, null, null, null, '4340', null, null, null, null, null, '02', null, '2017-08-15 16:10:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '17240', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080015', '2017-08-15', '2610000422', '0.00', '0.00', '44610.00', null, null, null, null, null, null, '4341', null, null, null, null, null, '02', null, '2017-08-15 16:13:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '44610', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080016', '2017-08-15', '2610000422', '0.00', '0.00', '5160.00', null, null, null, null, null, null, '4342', null, null, null, null, null, '02', null, '2017-08-15 16:15:08', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5160', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080017', '2017-08-15', '1310000424', '0.00', '0.00', '2173.00', null, null, null, null, null, null, '4343', null, null, null, null, null, '02', null, '2017-08-15 19:38:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2173', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080018', '2017-08-15', '2610000422', '0.00', '0.00', '8530.00', null, null, null, null, null, null, '4344', null, null, null, null, null, '02', null, '2017-08-15 16:21:55', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8530', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080019', '2017-08-15', '2610000346', '0.00', '0.00', '12600.00', null, null, null, null, null, null, '4345', null, null, null, null, null, '02', null, '2017-08-19 18:23:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '12600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080020', '2017-08-15', '2610000422', '0.00', '0.00', '26000.00', null, null, null, null, null, null, '4346', null, null, null, null, null, '02', null, '2017-08-15 16:29:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '26000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080021', '2017-08-15', '2610000422', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-15 16:30:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080022', '2017-08-15', '2610000376', '0.00', '0.00', '63000.00', null, null, null, null, null, null, '4348', null, null, null, null, null, '02', null, '2017-08-15 16:35:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '63000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080023', '2017-08-15', '2610000422', '0.00', '0.00', '1250.00', null, null, null, null, null, null, '4349', null, null, null, null, null, '02', null, '2017-08-15 16:36:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080024', '2017-08-15', '2610000574', '0.00', '0.00', '15475.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-09-10 11:26:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '15475', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080044', '2017-08-15', '2610000419', '0.00', '0.00', '1300.00', null, null, null, null, null, null, '13421 KT', null, null, null, null, null, '01', null, '2017-08-15 16:56:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080045', '2017-08-15', '2610000419', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 17:33:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080048', '2017-08-15', '2610000419', '0.00', '0.00', '122720.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:31:24', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '122720', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080049', '2017-08-15', '2610000234', '0.00', '0.00', '217900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:34:20', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '217900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080050', '2017-08-15', '2610000148', '0.00', '0.00', '15500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:35:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '15500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080051', '2017-08-15', '2610000248', '0.00', '0.00', '48000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:35:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '48000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080052', '2017-08-15', '2610000500', '0.00', '0.00', '44900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 20:36:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '44900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080053', '2017-08-15', '2610000123', '0.00', '0.00', '8940.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:38:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '8940', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080055', '2017-08-15', '2610000221', '0.00', '0.00', '129000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:39:42', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '129000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080056', '2017-08-15', '1310000426', '0.00', '0.00', '3740.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:40:45', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3740', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080057', '2017-08-15', '2610000107', '0.00', '0.00', '51600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:41:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '51600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080058', '2017-08-15', '2610000619', '0.00', '0.00', '222500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:42:00', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '222500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080059', '2017-08-15', '2610000260', '0.00', '0.00', '26300.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:42:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '26300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080060', '2017-08-15', '2610000117', '0.00', '0.00', '13000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:43:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '13000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080062', '2017-08-15', '2610000019', '0.00', '0.00', '77950.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:45:36', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '77950', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080064', '2017-08-15', '2610000197', '0.00', '0.00', '29000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-15 18:47:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '29000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080089', '2017-08-20', '2610000422', '0.00', '0.00', '36780.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '36780', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080186', '2017-08-22', '2610000312', '0.00', '0.00', '28050.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '28050', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080136', '2017-08-20', '2610000196', '0.00', '0.00', '41240.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:16:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '41240', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080068', '2017-08-16', '2610000554', '0.00', '0.00', '5400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 17:25:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080072', '2017-08-16', '2610000136', '0.00', '0.00', '37300.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 17:34:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '37300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080073', '2017-08-16', '2610000243', '0.00', '0.00', '2010.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 17:35:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2010', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080074', '2017-08-16', '2610000299', '0.00', '0.00', '47160.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 17:36:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '47160', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080075', '2017-08-16', '2610000062', '20.00', '0.00', '25400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 17:40:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '25400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080076', '2017-08-16', '2610000091', '0.00', '0.00', '92850.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 17:42:52', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '92850', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080077', '2017-08-16', '2610000098', '0.00', '0.00', '10320.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 18:01:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '10320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080078', '2017-08-16', '2610000347', '0.00', '0.00', '242100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 18:06:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '242100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080089', '2017-08-16', '2610000109', '0.00', '0.00', '232225.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 19:28:15', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '232225', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080079', '2017-08-16', '2610000294', '0.00', '0.00', '232175.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 18:12:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '232175', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080080', '2017-08-16', '2610000383', '0.00', '0.00', '12900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 18:18:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '12900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080167', '2017-08-20', '2610000238', '0.00', '0.00', '75540.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:47:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '75540', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080088', '2017-08-16', '2610000260', '0.00', '0.00', '23220.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 19:27:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '23220', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080082', '2017-08-16', '2610000083', '0.00', '0.00', '44400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 18:21:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '44400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080087', '2017-08-16', '2610000136', '0.00', '0.00', '40750.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 19:26:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '40750', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080086', '2017-08-16', '2610000117', '0.00', '0.00', '16600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-16 19:25:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '16600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080084', '2017-08-16', '1310000426', '0.00', '0.00', '3740.00', null, null, null, null, null, null, 'madrsa', null, null, null, null, null, '01', null, '2017-08-16 19:23:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3740', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080033', '2017-08-16', '2610000422', '0.00', '0.00', '3460.00', null, null, null, null, null, null, '1294', null, null, null, null, null, '02', null, '2017-08-17 10:22:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3460', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080187', '2017-08-22', '2610000068', '0.00', '0.00', '99200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '99200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080045', '2017-08-16', '2610000422', '0.00', '0.00', '57720.00', null, null, null, null, null, null, '1286', null, null, null, null, null, '02', null, '2017-08-17 15:52:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '57720', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080044', '2017-08-16', '2610000422', '0.00', '0.00', '6360.00', null, null, null, null, null, null, '1287', null, null, null, null, null, '02', null, '2017-08-17 10:43:36', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080043', '2017-08-16', '2610000422', '0.00', '0.00', '11600.00', null, null, null, null, null, null, '1288', null, null, null, null, null, '02', null, '2017-08-17 10:42:15', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '11600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080042', '2017-08-16', '2610000422', '0.00', '0.00', '4490.00', null, null, null, null, null, null, '1289', null, null, null, null, null, '02', null, '2017-08-17 10:41:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4490', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080041', '2017-08-16', '2610000422', '0.00', '0.00', '6730.00', null, null, null, null, null, null, '1290', null, null, null, null, null, '02', null, '2017-08-17 10:37:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6730', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080040', '2017-08-16', '2610000447', '0.00', '0.00', '3120.00', null, null, null, null, null, null, '1291', null, null, null, null, null, '02', null, '2017-09-10 11:31:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3120', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080039', '2017-08-16', '2610000422', '0.00', '0.00', '1360.00', null, null, null, null, null, null, '1292', null, null, null, null, null, '02', null, '2017-08-17 10:34:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080036', '2017-08-16', '2610000422', '0.00', '0.00', '11780.00', null, null, null, null, null, null, '1295', null, null, null, null, null, '02', null, '2017-08-17 10:32:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '11780', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080037', '2017-08-16', '2610000422', '0.00', '0.00', '15260.00', null, null, null, null, null, null, '1296', null, null, null, null, null, '02', null, '2017-08-17 10:32:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '15260', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080035', '2017-08-16', '2610000349', '0.00', '0.00', '30935.00', null, null, null, null, null, null, '1297', null, null, null, null, null, '02', null, '2017-09-10 11:35:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '30935', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080034', '2017-08-16', '2610000111', '0.00', '0.00', '12300.00', null, null, null, null, null, null, '1298', null, null, null, null, null, '02', null, '2017-08-17 10:28:42', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '12300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080032', '2017-08-16', '2610000645', '0.00', '0.00', '7100.00', null, null, null, null, null, null, '1299 Satta', null, null, null, null, null, '02', null, '2017-08-17 15:55:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080031', '2017-08-16', '2610000281', '0.00', '0.00', '22500.00', null, null, null, null, null, null, '1300', null, null, null, null, null, '02', null, '2017-08-17 09:52:50', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '22500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080030', '2017-08-16', '2610000563', '0.00', '0.00', '13200.00', null, null, null, null, null, null, '1', null, null, null, null, null, '02', null, '2017-08-17 09:51:35', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '13200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080029', '2017-08-16', '2610000108', '0.00', '0.00', '16400.00', null, null, null, null, null, null, '2', null, null, null, null, null, '02', null, '2017-08-17 09:46:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '16400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080028', '2017-08-16', '2610000502', '0.00', '0.00', '18200.00', null, null, null, null, null, null, '3', null, null, null, null, null, '02', null, '2017-08-17 09:45:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '18200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080027', '2017-08-16', '2610000321', '0.00', '0.00', '55940.00', null, null, null, null, null, null, '4  IMRAN B', null, null, null, null, null, '02', null, '2017-08-17 09:45:15', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '55940', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080026', '2017-08-16', '2610000422', '0.00', '0.00', '5020.00', null, null, null, null, null, null, '5', null, null, null, null, null, '02', null, '2017-08-17 09:44:11', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5020', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080025', '2017-08-16', '2610000636', '0.00', '0.00', '9100.00', null, null, null, null, null, null, '6', null, null, null, null, null, '02', null, '2017-08-17 09:43:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080163', '2017-08-27', '2610000422', '0.00', '0.00', '3460.00', null, null, null, null, null, null, '34', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3460', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080161', '2017-08-20', '2610000257', '0.00', '0.00', '37500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '37500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080165', '2017-08-20', '2610000634', '0.00', '0.00', '10440.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '10440', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080105', '2017-08-17', '2610000127', '0.00', '0.00', '242650.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-20 10:09:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '242650', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080104', '2017-08-17', '2610000419', '0.00', '0.00', '101280.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-19 19:33:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '101280', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080048', '2017-08-18', '2610000422', '0.00', '0.00', '168460.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-19 11:25:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '168460', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080049', '2017-08-18', '2610000177', '0.00', '0.00', '31080.00', null, null, null, null, null, null, '4202', null, null, null, null, null, '02', null, '2017-08-19 11:31:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '31080', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080050', '2017-08-18', '2610000640', '0.00', '0.00', '9630.00', null, null, null, null, null, null, '4205', null, null, null, null, null, '02', null, '2017-08-19 14:09:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9630', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080051', '2017-08-18', '2610000127', '0.00', '0.00', '20800.00', null, null, null, null, null, null, '4213', null, null, null, null, null, '02', null, '2017-08-19 11:47:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '20800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080052', '2017-08-18', '2610000366', '0.00', '0.00', '60540.00', null, null, null, null, null, null, '4215', null, null, null, null, null, '02', null, '2017-08-19 11:55:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '60540', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080053', '2017-08-18', '2610000336', '0.00', '0.00', '6340.00', null, null, null, null, null, null, '4222', null, null, null, null, null, '02', null, '2017-08-19 12:02:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6340', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080055', '2017-08-18', '2610000281', '0.00', '0.00', '28360.00', null, null, null, null, null, null, '4226', null, null, null, null, null, '02', null, '2017-08-19 12:14:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '28360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080159', '2017-08-20', '2610000383', '0.00', '0.00', '24800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080157', '2017-08-20', '2610000260', '0.00', '0.00', '8280.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '8280', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080154', '2017-08-20', '2610000245', '0.00', '0.00', '96000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '96000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080155', '2017-08-20', '2610000197', '0.00', '0.00', '36000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '36000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080098', '2017-08-17', '2610000197', '0.00', '0.00', '23100.00', null, null, null, null, null, null, '13558', null, null, null, null, null, '01', null, '2017-08-19 17:42:10', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '23100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080151', '2017-08-20', '2610000554', '0.00', '0.00', '3740.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3740', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080100', '2017-08-17', '2610000400', '0.00', '0.00', '142500.00', null, null, null, null, null, null, '13566', null, null, null, null, null, '01', null, '2017-08-19 17:56:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '142500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080101', '2017-08-17', '2610000364', '0.00', '0.00', '4440.00', null, null, null, null, null, null, '13571', null, null, null, null, null, '01', null, '2017-08-19 17:58:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '4440', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080102', '2017-08-17', '2610000148', '0.00', '0.00', '76500.00', null, null, null, null, null, null, '13573', null, null, null, null, null, '01', null, '2017-08-19 18:00:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '76500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080103', '2017-08-17', '2610000021', '0.00', '0.00', '242400.00', null, null, null, null, null, null, '13583', null, null, null, null, null, '01', null, '2017-08-19 18:57:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '242400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080106', '2017-08-17', '2610000453', '0.00', '0.00', '157930.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-20 10:22:02', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '157930', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080107', '2017-08-17', '2610000197', '0.00', '0.00', '36000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-21 11:29:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '36000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080056', '2017-08-20', '2610000422', '0.00', '0.00', '18510.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-20 14:18:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '18510', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080057', '2017-08-20', '2610000640', '0.00', '0.00', '19400.00', null, null, null, null, null, null, '2772', null, null, null, null, null, '02', null, '2017-08-20 16:24:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '19400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080058', '2017-08-20', '2610000422', '0.00', '0.00', '1600.00', null, null, null, null, null, null, '2773', null, null, null, null, null, '02', null, '2017-08-20 16:25:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080059', '2017-08-20', '2610000422', '0.00', '0.00', '7070.00', null, null, null, null, null, null, '2774', null, null, null, null, null, '02', null, '2017-08-20 16:27:11', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7070', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080060', '2017-08-20', '2610000422', '0.00', '0.00', '4420.00', null, null, null, null, null, null, '2775', null, null, null, null, null, '02', null, '2017-08-20 16:30:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4420', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080128', '2017-08-19', '2610000248', '0.00', '0.00', '49600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '49600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080062', '2017-08-20', '2610000422', '0.00', '0.00', '23860.00', null, null, null, null, null, null, '27g77', null, null, null, null, null, '02', null, '2017-08-20 16:42:24', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '23860', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080064', '2017-08-20', '2610000102', '0.00', '0.00', '75600.00', null, null, null, null, null, null, '2779', null, null, null, null, null, '02', null, '2017-08-20 16:54:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '75600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080088', '2017-08-20', '2610000422', '0.00', '0.00', '9410.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 16:15:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9410', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080087', '2017-08-20', '2610000422', '0.00', '0.00', '15720.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 16:10:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '15720', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080185', '2017-08-24', '2610000021', '0.00', '0.00', '26000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '26000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080135', '2017-08-20', '2610000640', '0.00', '0.00', '19920.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:13:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '19920', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080068', '2017-08-20', '2610000422', '0.00', '0.00', '3910.00', null, null, null, null, null, null, '2783', null, null, null, null, null, '02', null, '2017-08-20 17:17:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3910', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080132', '2017-08-20', '2610000422', '0.00', '0.00', '82920.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:07:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '82920', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080148', '2017-08-20', '2610000267', '0.00', '0.00', '20270.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '20270', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080145', '2017-08-20', '2610000070', '0.00', '0.00', '19580.00', null, null, null, null, null, null, '13666', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '19580', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080072', '2017-08-20', '2610000422', '0.00', '0.00', '5410.00', null, null, null, null, null, null, '2787', null, null, null, null, null, '02', null, '2017-08-20 17:28:27', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5410', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080073', '2017-08-20', '2610000447', '0.00', '0.00', '16150.00', null, null, null, null, null, null, '2788', null, null, null, null, null, '02', null, '2017-08-20 18:12:50', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '16150', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080074', '2017-08-20', '2610000422', '0.00', '0.00', '9710.00', null, null, null, null, null, null, '2789', null, null, null, null, null, '02', null, '2017-08-20 18:11:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9710', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080075', '2017-08-20', '2610000422', '0.00', '0.00', '3760.00', null, null, null, null, null, null, '2790', null, null, null, null, null, '02', null, '2017-08-20 18:14:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3760', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080076', '2017-08-20', '2610000615', '0.00', '0.00', '48850.00', null, null, null, null, null, null, '2791', null, null, null, null, null, '02', null, '2017-08-20 18:22:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '48850', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080077', '2017-08-20', '2610000422', '0.00', '0.00', '3860.00', null, null, null, null, null, null, '2792', null, null, null, null, null, '02', null, '2017-08-20 18:24:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3860', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080078', '2017-08-20', '2610000422', '0.00', '0.00', '1340.00', null, null, null, null, null, null, '2793', null, null, null, null, null, '02', null, '2017-08-20 18:25:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1340', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080079', '2017-08-20', '2610000422', '0.00', '0.00', '7530.00', null, null, null, null, null, null, '2794', null, null, null, null, null, '02', null, '2017-08-20 18:26:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7530', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080080', '2017-08-20', '2610000354', '0.00', '0.00', '105750.00', null, null, null, null, null, null, '2795', null, null, null, null, null, '02', null, '2017-08-20 18:34:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '105750', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080166', '2017-08-20', '2610000513', '0.00', '0.00', '19840.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '19840', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080082', '2017-08-20', '2610000422', '0.00', '0.00', '3740.00', null, null, null, null, null, null, '2797', null, null, null, null, null, '02', null, '2017-08-20 18:42:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3740', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080084', '2017-08-20', '2610000447', '0.00', '0.00', '7530.00', null, null, null, null, null, null, '2799', null, null, null, null, null, '02', null, '2017-08-20 18:48:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7530', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080108', '2017-08-18', '2610000419', '0.00', '0.00', '98290.50', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-21 12:49:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '98291', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080109', '2017-08-18', '2610000046', '0.00', '0.00', '1450.00', null, null, null, null, null, null, '13593', null, null, null, null, null, '01', null, '2017-08-21 12:55:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080110', '2017-08-18', '2610000415', '0.00', '0.00', '38300.00', null, null, null, null, null, null, '13598', null, null, null, null, null, '01', null, '2017-08-21 12:58:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '38300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080111', '2017-08-18', '2610000144', '0.00', '0.00', '63590.00', null, null, null, null, null, null, '13604', null, null, null, null, null, '01', null, '2017-08-21 13:01:55', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '63590', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080093', '2017-08-20', '2610000254', '0.00', '0.00', '37270.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '37270', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080113', '2017-08-18', '2610000068', '0.00', '0.00', '30000.00', null, null, null, null, null, null, '13613', null, null, null, null, null, '01', null, '2017-08-21 13:09:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '30000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080114', '2017-08-18', '2610000248', '0.00', '0.00', '55860.00', null, null, null, null, null, null, '13614', null, null, null, null, null, '01', null, '2017-08-21 13:12:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '55860', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080115', '2017-08-18', '2610000456', '0.00', '0.00', '5250.00', null, null, null, null, null, null, '13617', null, null, null, null, null, '01', null, '2017-08-21 13:14:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080116', '2017-08-18', '2610000400', '0.00', '0.00', '245900.00', null, null, null, null, null, null, '13635', null, null, null, null, null, '01', null, '2017-08-21 13:18:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '245900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080117', '2017-08-18', '2610000606', '0.00', '0.00', '297500.00', null, null, null, null, null, null, '13636', null, null, null, null, null, '01', null, '2017-08-21 13:22:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '297500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080143', '2017-08-20', '2610000419', '0.00', '0.00', '117050.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 12:02:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '117050', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080144', '2017-08-20', '2610000075', '0.00', '0.00', '20000.00', null, null, null, null, null, null, '13685', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '20000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080183', '2017-08-22', '2610000419', '0.00', '0.00', '129910.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 15:30:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '129910', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080184', '2017-08-22', '1310000426', '0.00', '0.00', '6600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 15:38:24', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '6600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080137', '2017-08-20', '2610000346', '0.00', '0.00', '100000.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:18:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '100000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080134', '2017-08-20', '2610000349', '0.00', '0.00', '25000.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:11:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '25000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080149', '2017-08-20', '2610000299', '0.00', '0.00', '15120.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '15120', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080147', '2017-08-20', '2610000318', '0.00', '0.00', '9400.00', null, null, null, null, null, null, '13690', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '9400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080168', '2017-08-20', '2610000309', '0.00', '0.00', '49600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '49600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090049', '2017-09-24', '2610000420', '0.00', '0.00', '22860.00', null, null, null, null, null, null, '3587', null, null, null, null, null, '03', null, '2017-09-24 15:49:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '22860', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090048', '2017-09-24', '2610000420', '0.00', '0.00', '2570.00', null, null, null, null, null, null, '3586', null, null, null, null, null, '03', null, '2017-09-24 15:48:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2570', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080086', '2017-08-18', '2610000358', '0.00', '0.00', '73320.00', null, null, null, null, null, null, '4224', null, null, null, null, null, '02', null, '2017-08-21 17:00:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '73320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080120', '2017-08-19', '2610000419', '0.00', '0.00', '88760.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 17:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '88760', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080121', '2017-08-19', '2610000363', '0.00', '0.00', '13960.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '13960', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080122', '2017-08-19', '2610000197', '0.00', '0.00', '3200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080123', '2017-08-19', '2610000197', '0.00', '0.00', '15400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '15400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080124', '2017-08-19', '2610000243', '0.00', '0.00', '2010.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2010', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080125', '2017-08-19', '2610000419', '0.00', '0.00', '6560.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 09:41:13', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '6560', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080126', '2017-08-19', '2610000062', '0.00', '0.00', '25000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '25000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080162', '2017-08-20', '2610000172', '0.00', '0.00', '50000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '50000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080160', '2017-08-20', '2610000386', '0.00', '0.00', '55900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '55900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080129', '2017-08-19', '2610000081', '0.00', '0.00', '168430.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '168430', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080158', '2017-08-20', '2610000091', '0.00', '0.00', '93000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '93000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080130', '2017-08-19', '2610000500', '0.00', '0.00', '5430.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5430', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080156', '2017-08-20', '2610000245', '0.00', '0.00', '37500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '37500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080153', '2017-08-20', '2610000374', '0.00', '0.00', '232450.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '232450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080152', '2017-08-20', '2610000136', '0.00', '0.00', '40750.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '40750', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080164', '2017-08-20', '2610000221', '0.00', '0.00', '24910.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24910', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090047', '2017-09-24', '2610000391', '0.00', '0.00', '30130.00', null, null, null, null, null, null, '3585', null, null, null, null, null, '03', null, '2017-09-24 15:47:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '30130', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080132', '2017-08-19', '2610000260', '0.00', '0.00', '29200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '29200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090046', '2017-09-24', '2610000286', '0.00', '0.00', '15423.00', null, null, null, null, null, null, '3584', null, null, null, null, null, '03', null, '2017-09-24 15:43:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '15423', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080134', '2017-08-19', '2610000623', '0.00', '0.00', '180000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '180000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080194', '2017-08-22', '2610000114', '0.00', '0.00', '11410.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '11410', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080136', '2017-08-19', '2610000084', '0.00', '0.00', '67310.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '67310', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080137', '2017-08-19', '2610000077', '0.00', '0.00', '19460.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '19460', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080138', '2017-08-19', '2610000149', '0.00', '0.00', '7140.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '7140', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080139', '2017-08-19', '2610000258', '0.00', '0.00', '24960.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24960', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080140', '2017-08-19', '2610000147', '0.00', '0.00', '187500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '187500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080141', '2017-08-19', '2610000138', '0.00', '0.00', '18440.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '18440', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080142', '2017-08-19', '2610000096', '0.00', '0.00', '120000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:07:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '120000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080150', '2017-08-20', '2610000382', '0.00', '0.00', '22000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 14:27:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '22000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090045', '2017-09-24', '2610000420', '0.00', '0.00', '6700.00', null, null, null, null, null, null, '3583', null, null, null, null, null, '03', null, '2017-09-24 15:40:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '6700', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090044', '2017-09-24', '2610000420', '0.00', '0.00', '4650.00', null, null, null, null, null, null, '3582', null, null, null, null, null, '03', null, '2017-09-24 15:34:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '4650', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090043', '2017-09-24', '2610000420', '0.00', '0.00', '9890.00', null, null, null, null, null, null, '3581', null, null, null, null, null, '03', null, '2017-09-24 15:33:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '9890', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090042', '2017-09-24', '2610000420', '0.00', '0.00', '4410.00', null, null, null, null, null, null, '3580', null, null, null, null, null, '03', null, '2017-09-24 15:31:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '4410', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090041', '2017-09-24', '2610000420', '0.00', '0.00', '1250.00', null, null, null, null, null, null, '3579', null, null, null, null, null, '03', null, '2017-09-24 15:28:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1250', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090040', '2017-09-24', '2610000590', '0.00', '0.00', '3510.00', null, null, null, null, null, null, '3578', null, null, null, null, null, '03', null, '2017-09-24 15:27:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3510', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090039', '2017-09-24', '2610000420', '0.00', '0.00', '5705.00', null, null, null, null, null, null, '3577', null, null, null, null, null, '03', null, '2017-09-24 15:25:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5705', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090038', '2017-09-24', '2610000420', '0.00', '0.00', '1660.00', null, null, null, null, null, null, '3576', null, null, null, null, null, '03', null, '2017-09-24 15:24:02', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1660', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090037', '2017-09-24', '2610000257', '0.00', '0.00', '20500.00', null, null, null, null, null, null, '3575', null, null, null, null, null, '03', null, '2017-09-24 17:41:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '20500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080188', '2017-08-22', '2610000597', '0.00', '0.00', '52870.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '52870', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090050', '2017-09-24', '2610000422', '0.00', '0.00', '700.00', null, null, null, null, null, null, '1583', null, null, null, null, null, '02', null, '2017-09-24 15:22:13', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '700', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('090049', '2017-09-24', '2610000422', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '1582', null, null, null, null, null, '02', null, '2017-09-24 15:21:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('090036', '2017-09-24', '2610000420', '0.00', '0.00', '2570.00', null, null, null, null, null, null, '3574', null, null, null, null, null, '03', null, '2017-09-24 15:20:08', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2570', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080095', '2017-08-20', '2610000303', '0.00', '0.00', '104000.00', null, null, null, null, null, null, '15', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '104000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080096', '2017-08-20', '2610000422', '0.00', '0.00', '4000.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080097', '2017-08-20', '2610000640', '0.00', '0.00', '242450.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '242450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080098', '2017-08-21', '2610000422', '0.00', '0.00', '5660.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5660', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080099', '2017-08-21', '2610000422', '0.00', '0.00', '4030.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4030', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080100', '2017-08-21', '2610000127', '0.00', '0.00', '2510.00', null, null, null, null, null, null, '4353', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2510', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080101', '2017-08-21', '2610000642', '0.00', '0.00', '129600.00', null, null, null, null, null, null, '4354', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '129600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080102', '2017-08-21', '2610000422', '0.00', '0.00', '10610.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '10610', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080103', '2017-08-21', '2610000422', '0.00', '0.00', '8100.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080104', '2017-08-21', '2610000422', '0.00', '0.00', '14650.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '14650', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080105', '2017-08-21', '2610000332', '0.00', '0.00', '42025.00', null, null, null, null, null, null, '4359', null, null, null, null, null, '02', null, '2017-08-22 18:01:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '42025', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080106', '2017-08-21', '2610000422', '0.00', '0.00', '8830.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8830', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080107', '2017-08-21', '2610000003', '0.00', '0.00', '32360.00', null, null, null, null, null, null, '4361', null, null, null, null, null, '02', null, '2017-08-23 14:06:20', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '32360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080108', '2017-08-21', '2610000422', '0.00', '0.00', '5000.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080109', '2017-08-21', '2610000422', '0.00', '0.00', '7500.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080110', '2017-08-21', '2610000422', '0.00', '0.00', '680.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 17:57:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '680', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080111', '2017-08-21', '2610000422', '0.00', '0.00', '810.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 17:54:41', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '810', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080112', '2017-08-21', '2610000422', '0.00', '0.00', '15260.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '15260', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080113', '2017-08-21', '2610000397', '0.00', '0.00', '53360.00', null, null, null, null, null, null, '4367', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '53360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080114', '2017-08-21', '2610000281', '0.00', '0.00', '46050.00', null, null, null, null, null, null, '4368', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '46050', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080115', '2017-08-21', '2610000111', '0.00', '0.00', '18975.00', null, null, null, null, null, null, '4369', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '18975', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080116', '2017-08-21', '2610000422', '0.00', '0.00', '5610.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5610', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080117', '2017-08-21', '2610000130', '0.00', '0.00', '51630.00', null, null, null, null, null, null, '4371', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '51630', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080118', '2017-08-21', '2610000177', '0.00', '0.00', '12480.00', null, null, null, null, null, null, '4372', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '12480', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080119', '2017-08-21', '2610000422', '0.00', '0.00', '830.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '830', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080120', '2017-08-21', '2610000422', '0.00', '0.00', '12350.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '12350', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080121', '2017-08-21', '2610000422', '0.00', '0.00', '2480.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2480', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080122', '2017-08-21', '2610000376', '0.00', '0.00', '74590.00', null, null, null, null, null, null, '4376', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '74590', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080123', '2017-08-21', '2610000422', '0.00', '0.00', '16700.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '16700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080124', '2017-08-21', '2610000422', '0.00', '0.00', '4960.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-22 18:06:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4960', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080169', '2017-08-21', '2610000419', '0.00', '0.00', '122760.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 17:48:41', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '122760', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080170', '2017-08-21', '1310000426', '0.00', '0.00', '1870.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1870', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080171', '2017-08-21', '2610000393', '0.00', '0.00', '18900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '18900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080172', '2017-08-21', '2610000243', '0.00', '0.00', '1390.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1390', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080173', '2017-08-21', '2610000131', '0.00', '0.00', '18800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '18800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080174', '2017-08-21', '2610000552', '0.00', '0.00', '32320.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '32320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080175', '2017-08-21', '2610000386', '0.00', '0.00', '18700.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '18700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080176', '2017-08-21', '2610000371', '0.00', '0.00', '18670.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '18670', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080177', '2017-08-21', '2610000393', '0.00', '0.00', '14700.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '14700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080178', '2017-08-27', '2610000422', '0.00', '0.00', '4310.00', null, null, null, null, null, null, '49', null, null, null, null, null, '02', null, '2017-08-28 11:14:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4310', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080179', '2017-08-21', '1310000424', '0.00', '0.00', '11340.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '11340', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080180', '2017-08-21', '2610000254', '0.00', '0.00', '232900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '232900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080181', '2017-08-21', '2610000113', '0.00', '0.00', '243400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-22 18:39:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080182', '2017-08-21', '2610000469', '0.00', '0.00', '71200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 11:51:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '71200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090048', '2017-09-24', '2610000358', '0.00', '0.00', '92750.00', null, null, null, null, null, null, '1581', null, null, null, null, null, '02', null, '2017-09-24 15:19:50', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '92750', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('090035', '2017-09-24', '2610000075', '0.00', '0.00', '799800.00', null, null, null, null, null, null, '3573', null, null, null, null, null, '03', null, '2017-09-24 15:19:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '799800', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080131', '2017-08-16', '2610000422', '0.00', '0.00', '8380.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 15:38:27', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8380', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090034', '2017-09-24', '2610000420', '0.00', '0.00', '5200.00', null, null, null, null, null, null, '3572', null, null, null, null, null, '03', null, '2017-09-24 15:18:02', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5200', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090033', '2017-09-24', '2610000260', '0.00', '0.00', '129500.00', null, null, null, null, null, null, '3571', null, null, null, null, null, '03', null, '2017-09-24 15:17:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '129500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080193', '2017-08-22', '2610000357', '0.00', '0.00', '2480.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2480', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090032', '2017-09-24', '2610000420', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '3570', null, null, null, null, null, '03', null, '2017-09-24 15:16:24', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090031', '2017-09-24', '2610000420', '0.00', '0.00', '1480.00', null, null, null, null, null, null, '3568', null, null, null, null, null, '03', null, '2017-09-24 15:15:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1480', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090030', '2017-09-24', '2610000420', '0.00', '0.00', '840.00', null, null, null, null, null, null, '3567', null, null, null, null, null, '03', null, '2017-09-24 15:14:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '840', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090029', '2017-09-24', '2610000420', '0.00', '0.00', '5120.00', null, null, null, null, null, null, '3566', null, null, null, null, null, '03', null, '2017-09-24 15:13:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5120', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090028', '2017-09-24', '2610000420', '0.00', '0.00', '650.00', null, null, null, null, null, null, '3565', null, null, null, null, null, '03', null, '2017-09-24 15:12:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '650', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090027', '2017-09-24', '2610000549', '0.00', '0.00', '42670.00', null, null, null, null, null, null, '3564', null, null, null, null, null, '03', null, '2017-09-24 15:11:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '42670', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090047', '2017-09-24', '2610000422', '0.00', '0.00', '7740.00', null, null, null, null, null, null, '1580', null, null, null, null, null, '02', null, '2017-09-24 15:07:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7740', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('090046', '2017-09-24', '2610000559', '0.00', '0.00', '25500.00', null, null, null, null, null, null, '1579', null, null, null, null, null, '02', null, '2017-09-24 15:06:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '25500', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('080188', '2017-08-25', '2610000447', '0.00', '0.00', '9240.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-29 16:46:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9240', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080189', '2017-08-22', '2610000561', '0.00', '0.00', '24600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080190', '2017-08-22', '2610000086', '0.00', '0.00', '8940.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '8940', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080191', '2017-08-22', '2610000087', '0.00', '0.00', '8940.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '8940', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080192', '2017-08-22', '2610000058', '0.00', '0.00', '3980.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3980', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080195', '2017-08-22', '2610000197', '0.00', '0.00', '26140.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '26140', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080196', '2017-08-22', '2610000016', '0.00', '0.00', '43470.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '43470', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080198', '2017-08-22', '2610000136', '0.00', '0.00', '243000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080199', '2017-08-22', '2610000223', '0.00', '0.00', '2680.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2680', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080200', '2017-08-22', '2610000156', '0.00', '0.00', '670.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '670', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080201', '2017-08-22', '2610000121', '0.00', '0.00', '36300.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '36300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080202', '2017-08-22', '2610000148', '0.00', '0.00', '74400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '74400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080203', '2017-08-22', '2610000016', '0.00', '0.00', '98000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '98000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080204', '2017-08-22', '2610000402', '0.00', '0.00', '21600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '21600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080205', '2017-08-22', '2610000264', '0.00', '0.00', '160640.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '160640', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080206', '2017-08-22', '2610000197', '0.00', '0.00', '36000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '36000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080207', '2017-08-22', '2610000019', '0.00', '0.00', '78825.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '78825', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080208', '2017-08-22', '2610000386', '0.00', '0.00', '229650.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '229650', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080209', '2017-08-22', '2610000347', '0.00', '0.00', '243350.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 18:22:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243350', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090026', '2017-09-24', '2610000138', '0.00', '0.00', '21470.00', null, null, null, null, null, null, '353', null, null, null, null, null, '03', null, '2017-09-24 15:04:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '21470', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090045', '2017-09-24', '2610000422', '0.00', '0.00', '690.00', null, null, null, null, null, null, '1578', null, null, null, null, null, '02', null, '2017-09-24 15:03:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '690', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('090044', '2017-09-24', '2610000422', '0.00', '0.00', '1500.00', null, null, null, null, null, null, '1577', null, null, null, null, null, '02', null, '2017-09-24 15:02:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1500', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('080210', '2017-08-22', '2610000275', '0.00', '0.00', '16730.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 17:47:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '16730', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080211', '2017-08-16', '2610000578', '0.00', '0.00', '3050.00', null, null, null, null, null, null, '13484', null, null, null, null, null, '01', null, '2017-08-23 18:50:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3050', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080175', '2017-08-27', '2610000422', '0.00', '0.00', '5580.00', null, null, null, null, null, null, '46', null, null, null, null, null, '02', null, '2017-08-27 17:53:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5580', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080213', '2017-08-16', '1310000426', '0.00', '0.00', '1950.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 19:00:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1950', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080214', '2017-08-16', '2610000014', '0.00', '0.00', '13000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 19:00:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '13000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080215', '2017-08-16', '2610000197', '0.00', '0.00', '5100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 19:00:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080216', '2017-08-16', '2610000419', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 19:00:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080125', '2017-08-15', '2610000196', '0.00', '0.00', '37440.00', null, null, null, null, null, null, '2099', null, null, null, null, null, '02', null, '2017-08-23 19:41:13', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '37440', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080217', '2017-08-15', '2610000107', '0.00', '0.00', '38700.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:01:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '38700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080218', '2017-08-15', '2610000197', '0.00', '0.00', '36000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:06:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '36000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080219', '2017-08-15', '2610000312', '0.00', '0.00', '28240.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:06:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '28240', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080220', '2017-08-15', '2610000165', '0.00', '0.00', '90000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:06:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '90000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090043', '2017-09-24', '2610000376', '0.00', '0.00', '79365.00', null, null, null, null, null, null, '1576', null, null, null, null, null, '02', null, '2017-09-24 15:00:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '79365', '', 'bt', null);
INSERT INTO `sl_invoice` VALUES ('080221', '2017-08-15', '2610000419', '0.00', '0.00', '6010.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:16:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '6010', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090025', '2017-09-24', '2610000420', '0.00', '0.00', '3840.00', null, null, null, null, null, null, '3562', null, null, null, null, null, '03', null, '2017-09-24 15:00:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3840', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090024', '2017-09-24', '2610000420', '0.00', '0.00', '1250.00', null, null, null, null, null, null, '3561', null, null, null, null, null, '03', null, '2017-09-24 14:59:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1250', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090023', '2017-09-24', '2610000596', '0.00', '0.00', '24750.00', null, null, null, null, null, null, '', null, null, null, null, null, '03', null, '2017-09-24 14:57:15', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '24750', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090022', '2017-09-24', '2610000420', '0.00', '0.00', '7770.00', null, null, null, null, null, null, '3559', null, null, null, null, null, '03', null, '2017-09-24 14:55:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '7770', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090021', '2017-09-24', '2610000629', '0.00', '0.00', '26000.00', null, null, null, null, null, null, '3558', null, null, null, null, null, '03', null, '2017-09-24 14:54:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '26000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090020', '2017-09-24', '2610000420', '0.00', '0.00', '36540.00', null, null, null, null, null, null, '3557', null, null, null, null, null, '03', null, '2017-09-24 14:53:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '36540', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('080164', '2017-08-27', '2610000422', '0.00', '0.00', '2040.00', null, null, null, null, null, null, '35', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2040', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080222', '2017-08-17', '2610000136', '0.00', '0.00', '139090.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:34:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '139090', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080223', '2017-08-17', '2610000068', '0.00', '0.00', '104400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:41:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '104400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080224', '2017-08-17', '1310000424', '0.00', '0.00', '3290.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:41:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3290', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090019', '2017-09-24', '2610000420', '0.00', '0.00', '1940.00', null, null, null, null, null, null, '3556', null, null, null, null, null, '03', null, '2017-09-24 14:47:10', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1940', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090042', '2017-09-24', '2610000422', '0.00', '0.00', '12330.00', null, null, null, null, null, null, '1575', null, null, null, null, null, '02', null, '2017-09-24 13:33:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '12330', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080225', '2017-08-17', '2610000181', '0.00', '0.00', '1320.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:37:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080226', '2017-08-17', '2610000114', '0.00', '0.00', '19490.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:41:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '19490', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080227', '2017-08-17', '2610000381', '0.00', '0.00', '5060.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-23 20:41:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5060', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080228', '2017-08-17', '2610000419', '0.00', '0.00', '1320.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 10:32:15', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090041', '2017-09-24', '2610000615', '0.00', '0.00', '75940.00', null, null, null, null, null, null, '1574', null, null, null, null, null, '02', null, '2017-09-24 13:28:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '75940', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090040', '2017-09-24', '2610000422', '0.00', '0.00', '9000.00', null, null, null, null, null, null, '1573', null, null, null, null, null, '02', null, '2017-09-24 12:47:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9000', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090018', '2017-09-24', '2610000590', '0.00', '0.00', '20880.00', null, null, null, null, null, null, '3555', null, null, null, null, null, '03', null, '2017-09-24 12:45:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '20880', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090039', '2017-09-24', '2610000422', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '1572', null, null, null, null, null, '02', null, '2017-09-24 12:43:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090017', '2017-09-24', '2610000420', '0.00', '0.00', '5180.00', null, null, null, null, null, null, '3554', null, null, null, null, null, '03', null, '2017-09-24 12:42:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5180', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090016', '2017-09-24', '2610000420', '0.00', '0.00', '2000.00', null, null, null, null, null, null, '3553', null, null, null, null, null, '03', null, '2017-09-24 12:41:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2000', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090038', '2017-09-24', '2610000422', '0.00', '0.00', '2590.00', null, null, null, null, null, null, '1571', null, null, null, null, null, '02', null, '2017-09-24 12:41:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2590', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090015', '2017-09-24', '2610000260', '0.00', '0.00', '25900.00', null, null, null, null, null, null, '3552', null, null, null, null, null, '03', null, '2017-09-24 12:41:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '25900', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090037', '2017-09-24', '2610000422', '0.00', '0.00', '5180.00', null, null, null, null, null, null, '1570', null, null, null, null, null, '02', null, '2017-09-24 12:40:10', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5180', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080179', '2017-08-27', '2610000422', '0.00', '0.00', '4880.00', null, null, null, null, null, null, '50', null, null, null, null, null, '02', null, '2017-08-28 11:15:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4880', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080229', '2017-08-23', '2610000419', '0.00', '0.00', '297080.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 10:56:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '297080', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080230', '2017-08-18', '2610000144', '0.00', '0.00', '124250.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:01:31', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '124250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090014', '2017-09-24', '2610000420', '0.00', '0.00', '3860.00', null, null, null, null, null, null, '3551', null, null, null, null, null, '03', null, '2017-09-24 12:40:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3860', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080231', '2017-08-23', '2610000112', '0.00', '0.00', '112950.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '112950', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080232', '2017-08-18', '2610000384', '0.00', '0.00', '242000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '242000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090013', '2017-09-24', '2610000221', '0.00', '0.00', '174110.00', null, null, null, null, null, null, '3550', null, null, null, null, null, '03', null, '2017-09-24 12:38:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '174110', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090012', '2017-09-24', '2610000260', '0.00', '0.00', '116092.00', null, null, null, null, null, null, '3549', null, null, null, null, null, '03', null, '2017-09-24 12:33:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '116092', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080233', '2017-08-23', '2610000382', '0.00', '0.00', '164100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '164100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080234', '2017-08-23', '2610000395', '0.00', '0.00', '74900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '74900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090036', '2017-09-24', '2610000308', '0.00', '0.00', '59760.00', null, null, null, null, null, null, '1569', null, null, null, null, null, '02', null, '2017-09-24 12:33:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '59760', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080236', '2017-08-23', '2610000243', '0.00', '0.00', '2010.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2010', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080237', '2017-08-23', '2610000318', '0.00', '0.00', '48360.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '48360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080126', '2017-08-23', '2610000422', '0.00', '0.00', '107730.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 17:02:52', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '107730', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080239', '2017-08-23', '2610000299', '0.00', '0.00', '44280.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '44280', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080240', '2017-08-18', '2610000121', '0.00', '0.00', '231450.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '231450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080241', '2017-08-23', '2610000257', '0.00', '0.00', '24960.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 11:25:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24960', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080242', '2017-08-23', '2610000500', '0.00', '0.00', '34300.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '34300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080243', '2017-08-23', '2610000393', '0.00', '0.00', '152900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '152900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080127', '2017-08-23', '2610000277', '0.00', '0.00', '48800.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-24 12:33:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '48800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080128', '2017-08-23', '2610000346', '0.00', '0.00', '46675.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:38:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '46675', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080129', '2017-08-23', '1310000426', '0.00', '0.00', '31500.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:38:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '31500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080130', '2017-08-23', '1310000424', '0.00', '0.00', '1880.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:38:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1880', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080244', '2017-08-23', '2610000419', '0.00', '0.00', '37140.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 14:04:11', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '37140', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080245', '2017-08-23', '2610000014', '0.00', '0.00', '12300.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '12300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080246', '2017-08-23', '2610000122', '0.00', '0.00', '107930.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '107930', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080247', '2017-08-23', '2610000097', '0.00', '0.00', '20650.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '20650', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080248', '2017-08-23', '2610000473', '0.00', '0.00', '4340.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '4340', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080249', '2017-08-23', '2610000264', '0.00', '0.00', '3250.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080250', '2017-08-23', '2610000102', '0.00', '0.00', '243500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080251', '2017-08-23', '2610000021', '0.00', '0.00', '339500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '339500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080252', '2017-08-23', '2610000192', '0.00', '0.00', '243600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080138', '2017-08-20', '2610000422', '0.00', '0.00', '1890.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-25 16:19:24', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1890', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080253', '2017-08-24', '2610000419', '0.00', '0.00', '104600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-24 16:17:52', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '104600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080254', '2017-08-24', '2610000359', '0.00', '0.00', '20400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '20400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080255', '2017-08-24', '2610000187', '0.00', '0.00', '16220.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '16220', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080256', '2017-08-24', '1310000424', '0.00', '0.00', '1340.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1340', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080257', '2017-08-24', '2610000067', '0.00', '0.00', '23000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '23000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080258', '2017-08-24', '2610000260', '0.00', '0.00', '21900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '21900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080259', '2017-08-24', '2610000245', '0.00', '0.00', '133500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '133500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080260', '2017-08-24', '2610000117', '0.00', '0.00', '3410.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '3410', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080261', '2017-08-24', '2610000259', '0.00', '0.00', '9800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '9800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080262', '2017-08-24', '2610000091', '0.00', '0.00', '93200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '93200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080263', '2017-08-24', '2610000062', '0.00', '0.00', '46800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '46800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080264', '2017-08-24', '2610000144', '0.00', '0.00', '173020.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '173020', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080265', '2017-08-24', '2610000181', '0.00', '0.00', '38500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '38500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080266', '2017-08-24', '1310000443', '0.00', '0.00', '1500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080267', '2017-08-24', '2610000312', '0.00', '0.00', '8300.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '8300', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080268', '2017-08-24', '2610000173', '0.00', '0.00', '5570.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '5570', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080269', '2017-08-24', '1310000445', '0.00', '0.00', '636000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '636000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080270', '2017-08-24', '2610000126', '0.00', '0.00', '73200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '73200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080271', '2017-08-24', '2610000093', '0.00', '0.00', '6780.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '6780', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080272', '2017-08-24', '2610000093', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080273', '2017-08-24', '2610000149', '0.00', '0.00', '16390.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '16390', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080274', '2017-08-24', '2610000248', '0.00', '0.00', '42600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '42600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080275', '2017-08-24', '2610000197', '0.00', '0.00', '22210.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '22210', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080276', '2017-08-24', '2610000106', '0.00', '0.00', '236900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '236900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080277', '2017-08-24', '2610000107', '0.00', '0.00', '243400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080278', '2017-08-24', '2610000136', '0.00', '0.00', '233200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '233200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080279', '2017-08-24', '2610000057', '0.00', '0.00', '241900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '241900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080280', '2017-08-24', '2610000156', '0.00', '0.00', '24400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080281', '2017-08-24', '2610000275', '0.00', '0.00', '9760.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-25 16:39:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '9760', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090011', '2017-09-24', '2610000420', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '3548', null, null, null, null, null, '03', null, '2017-09-24 12:28:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090010', '2017-09-24', '2610000420', '0.00', '0.00', '29750.00', null, null, null, null, null, null, '3546', null, null, null, null, null, '03', null, '2017-09-24 12:27:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '29750', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090009', '2017-09-24', '2610000420', '0.00', '0.00', '10270.00', null, null, null, null, null, null, '3545', null, null, null, null, null, '03', null, '2017-09-24 17:14:27', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '10270', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090035', '2017-09-24', '2610000422', '0.00', '0.00', '7750.00', null, null, null, null, null, null, '1568', null, null, null, null, null, '02', null, '2017-09-24 12:23:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7750', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090008', '2017-09-24', '2610000420', '0.00', '0.00', '1930.00', null, null, null, null, null, null, '3544', null, null, null, null, null, '03', null, '2017-09-24 12:23:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1930', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090007', '2017-09-24', '2610000420', '0.00', '0.00', '6250.00', null, null, null, null, null, null, '3543', null, null, null, null, null, '03', null, '2017-09-24 12:21:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '6250', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090034', '2017-09-24', '2610000422', '0.00', '0.00', '9780.00', null, null, null, null, null, null, '1567', null, null, null, null, null, '02', null, '2017-09-24 12:21:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9780', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090006', '2017-09-24', '2610000138', '0.00', '0.00', '32050.00', null, null, null, null, null, null, '3542', null, null, null, null, null, '03', null, '2017-09-24 12:20:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '32050', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090005', '2017-09-24', '2610000420', '0.00', '0.00', '5000.00', null, null, null, null, null, null, '3541', null, null, null, null, null, '03', null, '2017-09-24 12:18:26', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5000', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090004', '2017-09-24', '2610000420', '0.00', '0.00', '1930.00', null, null, null, null, null, null, '3540', null, null, null, null, null, '03', null, '2017-09-24 12:14:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1930', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090033', '2017-09-24', '2610000422', '0.00', '0.00', '5210.00', null, null, null, null, null, null, '1566', null, null, null, null, null, '02', null, '2017-09-24 12:13:35', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5210', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090032', '2017-09-24', '2610000422', '0.00', '0.00', '6430.00', null, null, null, null, null, null, '1565', null, null, null, null, null, '02', null, '2017-09-24 12:11:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6430', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090003', '2017-09-24', '2610000420', '0.00', '0.00', '13050.00', null, null, null, null, null, null, '3539', null, null, null, null, null, '03', null, '2017-09-24 12:12:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '13050', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090002', '2017-09-24', '2610000420', '0.00', '0.00', '1830.00', null, null, null, null, null, null, '3738', null, null, null, null, null, '03', null, '2017-09-24 12:09:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1830', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090031', '2017-09-24', '2610000422', '0.00', '0.00', '7430.00', null, null, null, null, null, null, '1564', null, null, null, null, null, '02', null, '2017-09-24 12:08:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7430', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('080139', '2017-08-25', '2610000422', '0.00', '0.00', '234285.00', null, null, null, null, null, null, '1201', null, null, null, null, null, '02', null, '2017-08-29 17:15:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '234285', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080140', '2017-08-25', '2610000055', '0.00', '0.00', '257360.00', null, null, null, null, null, null, '1206', null, null, null, null, null, '02', null, '2017-08-27 09:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '257360', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080141', '2017-08-25', '2610000196', '0.00', '0.00', '26020.00', null, null, null, null, null, null, '1207', null, null, null, null, null, '02', null, '2017-08-27 09:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '26020', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080142', '2017-08-25', '2610000349', '0.00', '0.00', '6750.00', null, null, null, null, null, null, '1210', null, null, null, null, null, '02', null, '2017-08-27 09:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6750', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080143', '2017-08-25', '2610000336', '0.00', '0.00', '25840.00', null, null, null, null, null, null, '1214', null, null, null, null, null, '02', null, '2017-08-27 09:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '25840', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080144', '2017-08-25', '2610000447', '0.00', '0.00', '3120.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-27 09:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3120', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080145', '2017-08-25', '2610000646', '0.00', '0.00', '1870.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-27 09:24:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1870', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080282', '2017-08-25', '2610000419', '0.00', '0.00', '99530.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-26 17:22:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '99530', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080283', '2017-08-25', '2610000259', '0.00', '0.00', '2000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '2000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080284', '2017-08-25', '2610000294', '0.00', '0.00', '289800.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '289800', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080285', '2017-08-25', '2610000260', '0.00', '0.00', '170100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '170100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080286', '2017-08-25', '2610000627', '0.00', '0.00', '121500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '121500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080287', '2017-08-25', '2610000070', '0.00', '0.00', '25410.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '25410', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080288', '2017-08-25', '2610000257', '0.00', '0.00', '24500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080289', '2017-08-25', '2610000014', '0.00', '0.00', '12200.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '12200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080290', '2017-08-25', '2610000299', '0.00', '0.00', '18900.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '18900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080291', '2017-08-25', '2610000623', '0.00', '0.00', '91500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '91500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080292', '2017-08-25', '2610000554', '0.00', '0.00', '36460.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '36460', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080293', '2017-08-25', '2610000393', '0.00', '0.00', '14700.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '14700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080294', '2017-08-25', '2610000248', '0.00', '0.00', '65190.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '65190', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080295', '2017-08-25', '2610000404', '0.00', '0.00', '26000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '26000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080296', '2017-08-25', '2610000404', '0.00', '0.00', '120750.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '120750', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080297', '2017-08-25', '2610000221', '0.00', '0.00', '37280.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '37280', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080298', '2017-08-25', '2610000462', '0.00', '0.00', '279600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '279600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080299', '2017-08-25', '2610000632', '0.00', '0.00', '243600.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '243600', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080300', '2017-08-25', '2610000260', '0.00', '0.00', '93700.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 08:06:55', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '93700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080301', '2017-08-25', '2610000628', '0.00', '0.00', '130400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '130400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080302', '2017-08-25', '2610000148', '0.00', '0.00', '74100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 09:24:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '74100', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080303', '2017-08-26', '2610000419', '0.00', '0.00', '84320.10', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 11:16:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '84320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080304', '2017-08-26', '2610000087', '0.00', '0.00', '1320.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-27 11:21:41', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1320', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080305', '2017-08-26', '2610000395', '0.00', '0.00', '16750.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '16750', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080306', '2017-08-26', '2610000299', '0.00', '0.00', '29400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '29400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080307', '2017-08-26', '2610000114', '0.00', '0.00', '20820.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '20820', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080308', '2017-08-26', '2610000243', '0.00', '0.00', '1340.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1340', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080309', '2017-08-26', '2610000147', '0.00', '0.00', '15500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '15500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080310', '2017-08-26', '2610000250', '0.00', '0.00', '113980.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '113980', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080311', '2017-08-26', '2610000170', '0.00', '0.00', '24500.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24500', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080312', '2017-08-26', '2610000147', '0.00', '0.00', '124000.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '124000', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080313', '2017-08-26', '2610000077', '0.00', '0.00', '24400.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '24400', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080314', '2017-08-26', '2610000245', '3230.00', '0.00', '67270.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '67270', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080315', '2017-08-26', '2610000561', '0.00', '0.00', '52250.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-08-29 15:19:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '52250', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080147', '2017-08-27', '2610000422', '0.00', '0.00', '5540.00', null, null, null, null, null, null, '18', null, null, null, null, null, '02', null, '2017-08-27 16:04:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5540', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080148', '2017-08-27', '2610000422', '0.00', '0.00', '4900.00', null, null, null, null, null, null, '19', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4900', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080149', '2017-08-27', '2610000422', '0.00', '0.00', '4880.00', null, null, null, null, null, null, '20', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4880', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080150', '2017-08-27', '2610000422', '0.00', '0.00', '3120.00', null, null, null, null, null, null, '21', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3120', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080151', '2017-08-27', '2610000422', '0.00', '0.00', '48375.00', null, null, null, null, null, null, '22', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '48375', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080152', '2017-08-27', '2610000422', '0.00', '0.00', '1990.00', null, null, null, null, null, null, '23', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1990', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080153', '2017-08-27', '2610000422', '0.00', '0.00', '3700.00', null, null, null, null, null, null, '24', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3700', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080154', '2017-08-27', '2610000422', '0.00', '0.00', '8200.00', null, null, null, null, null, null, '25', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080155', '2017-08-27', '2610000422', '0.00', '0.00', '2450.00', null, null, null, null, null, null, '26', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080156', '2017-08-27', '2610000422', '0.00', '0.00', '2510.00', null, null, null, null, null, null, '27', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2510', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080157', '2017-08-27', '2610000422', '0.00', '0.00', '2450.00', null, null, null, null, null, null, '28', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080158', '2017-08-27', '2610000422', '0.00', '0.00', '3910.00', null, null, null, null, null, null, '29', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3910', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080159', '2017-08-27', '2610000422', '0.00', '0.00', '2450.00', null, null, null, null, null, null, '30', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080160', '2017-08-27', '2610000422', '0.00', '0.00', '5790.00', null, null, null, null, null, null, '31', null, null, null, null, null, '02', null, '2017-08-27 16:32:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5790', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080161', '2017-08-27', '2610000422', '0.00', '0.00', '8850.00', null, null, null, null, null, null, '32', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8850', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080162', '2017-08-27', '2610000422', '0.00', '0.00', '15405.00', null, null, null, null, null, null, '33', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '15405', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080165', '2017-08-27', '2610000422', '0.00', '0.00', '48730.00', null, null, null, null, null, null, '36', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '48730', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080166', '2017-08-27', '2610000422', '0.00', '0.00', '2450.00', null, null, null, null, null, null, '37', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2450', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080167', '2017-08-27', '2610000422', '0.00', '0.00', '4330.00', null, null, null, null, null, null, '38', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4330', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080168', '2017-08-27', '2610000422', '0.00', '0.00', '5260.00', null, null, null, null, null, null, '39', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5260', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080169', '2017-08-27', '2610000422', '0.00', '0.00', '6830.00', null, null, null, null, null, null, '', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6830', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080170', '2017-08-27', '2610000422', '0.00', '0.00', '3200.00', null, null, null, null, null, null, '41', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3200', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080171', '2017-08-27', '2610000422', '0.00', '0.00', '3740.00', null, null, null, null, null, null, '42', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3740', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080172', '2017-08-27', '2610000332', '0.00', '0.00', '50660.00', null, null, null, null, null, null, '43', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '50660', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080173', '2017-08-27', '2610000422', '0.00', '0.00', '9350.00', null, null, null, null, null, null, '44', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9350', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080174', '2017-08-27', '2610000422', '0.00', '0.00', '9930.00', null, null, null, null, null, null, '45', null, null, null, null, null, '02', null, '2017-08-29 15:19:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9930', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080177', '2017-08-27', '2610000336', '0.00', '0.00', '25820.00', null, null, null, null, null, null, '48', null, null, null, null, null, '02', null, '2017-08-27 18:07:02', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '25820', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080176', '2017-08-27', '2610000422', '0.00', '0.00', '3120.00', null, null, null, null, null, null, '47', null, null, null, null, null, '02', null, '2017-08-27 17:54:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3120', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080181', '2017-08-27', '2610000321', '0.00', '0.00', '14270.00', null, null, null, null, null, null, '52 ansar a', null, null, null, null, null, '02', null, '2017-08-28 11:23:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '14270', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080180', '2017-08-27', '2610000422', '0.00', '0.00', '8330.00', null, null, null, null, null, null, '51', null, null, null, null, null, '02', null, '2017-08-28 11:18:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8330', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080182', '2017-08-27', '2610000422', '0.00', '0.00', '6220.00', null, null, null, null, null, null, '53', null, null, null, null, null, '02', null, '2017-08-28 11:25:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '6220', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080183', '2017-08-27', '2610000422', '0.00', '0.00', '810.00', null, null, null, null, null, null, '54', null, null, null, null, null, '02', null, '2017-08-28 11:26:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '810', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080184', '2017-08-27', '2610000422', '0.00', '0.00', '1650.00', null, null, null, null, null, null, '55', null, null, null, null, null, '02', null, '2017-08-28 11:27:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1650', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080185', '2017-08-27', '2610000422', '0.00', '0.00', '1880.00', null, null, null, null, null, null, '56', null, null, null, null, null, '02', null, '2017-08-28 11:28:49', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1880', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080186', '2017-08-27', '2610000422', '0.00', '0.00', '5080.00', null, null, null, null, null, null, '57', null, null, null, null, null, '02', null, '2017-08-28 11:30:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5080', '', '', null);
INSERT INTO `sl_invoice` VALUES ('080187', '2017-08-27', '2610000196', '0.00', '0.00', '45020.00', null, null, null, null, null, null, '58', null, null, null, null, null, '02', null, '2017-08-28 11:34:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '45020', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090001', '2017-09-24', '2610000420', '0.00', '0.00', '4490.00', null, null, null, null, null, null, '3537', null, null, null, null, null, '03', null, '2017-09-24 12:06:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '4490', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090030', '2017-09-24', '2610000422', '0.00', '0.00', '4520.00', null, null, null, null, null, null, '1563', null, null, null, null, null, '02', null, '2017-09-24 12:04:11', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4520', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090029', '2017-09-24', '2610000325', '0.00', '0.00', '7500.00', null, null, null, null, null, null, '1562', null, null, null, null, null, '02', null, '2017-09-24 12:02:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7500', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090028', '2017-09-24', '2610000422', '0.00', '0.00', '9240.00', null, null, null, null, null, null, '1561', null, null, null, null, null, '02', null, '2017-09-24 11:59:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9240', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090027', '2017-09-24', '2610000422', '0.00', '0.00', '9020.00', null, null, null, null, null, null, '1560', null, null, null, null, null, '02', null, '2017-09-24 11:54:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '9020', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090026', '2017-09-24', '2610000422', '0.00', '0.00', '4540.00', null, null, null, null, null, null, '1559', null, null, null, null, null, '02', null, '2017-09-24 11:51:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4540', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090025', '2017-09-24', '2610000347', '0.00', '0.00', '46762.00', null, null, null, null, null, null, '1558', null, null, null, null, null, '02', null, '2017-09-24 11:48:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '46762', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090024', '2017-09-24', '2610000422', '0.00', '0.00', '21130.00', null, null, null, null, null, null, '1557', null, null, null, null, null, '02', null, '2017-09-24 11:36:36', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '21130', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090023', '2017-09-24', '2610000422', '0.00', '0.00', '35560.00', null, null, null, null, null, null, '1556', null, null, null, null, null, '02', null, '2017-09-24 11:32:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '35560', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090022', '2017-09-24', '2610000159', '0.00', '0.00', '24480.00', null, null, null, null, null, null, '1555', null, null, null, null, null, '02', null, '2017-09-24 11:23:12', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '24480', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090021', '2017-09-24', '2610000422', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '1554', null, null, null, null, null, '02', null, '2017-09-24 11:16:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090020', '2017-09-24', '2610000422', '0.00', '0.00', '1260.00', null, null, null, null, null, null, '1553', null, null, null, null, null, '02', null, '2017-09-24 11:15:29', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1260', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090019', '2017-09-24', '2610000447', '0.00', '0.00', '11660.00', null, null, null, null, null, null, '1552', null, null, null, null, null, '02', null, '2017-09-24 11:14:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '11660', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090018', '2017-09-24', '2610000422', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '1551', null, null, null, null, null, '02', null, '2017-09-24 11:08:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090017', '2017-09-24', '2610000422', '0.00', '0.00', '3290.00', null, null, null, null, null, null, '1550', null, null, null, null, null, '02', null, '2017-09-24 11:05:33', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3290', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090016', '2017-09-24', '2610000422', '0.00', '0.00', '1890.00', null, null, null, null, null, null, '1549', null, null, null, null, null, '02', null, '2017-09-24 11:03:45', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1890', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090015', '2017-09-24', '2610000422', '0.00', '0.00', '5200.00', null, null, null, null, null, null, '1548', null, null, null, null, null, '02', null, '2017-09-24 11:01:49', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '5200', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090014', '2017-09-24', '2610000422', '0.00', '0.00', '24660.00', null, null, null, null, null, null, '1547', null, null, null, null, null, '02', null, '2017-09-24 11:01:20', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '24660', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090013', '2017-09-24', '2610000422', '0.00', '0.00', '28160.00', null, null, null, null, null, null, '1546', null, null, null, null, null, '02', null, '2017-09-24 10:47:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '28160', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090012', '2017-09-24', '2610000349', '0.00', '0.00', '7500.00', null, null, null, null, null, null, '1545', null, null, null, null, null, '02', null, '2017-09-24 10:44:02', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7500', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090011', '2017-09-24', '2610000422', '0.00', '0.00', '4520.00', null, null, null, null, null, null, '1544', null, null, null, null, null, '02', null, '2017-09-24 10:41:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '4520', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090010', '2017-09-24', '2610000422', '0.00', '0.00', '2590.00', null, null, null, null, null, null, '1543', null, null, null, null, null, '02', null, '2017-09-24 10:39:04', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2590', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090009', '2017-09-24', '2610000422', '0.00', '0.00', '2800.00', null, null, null, null, null, null, '1542', null, null, null, null, null, '02', null, '2017-09-24 10:37:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2800', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090008', '2017-09-24', '2610000422', '0.00', '0.00', '7730.00', null, null, null, null, null, null, '1541', null, null, null, null, null, '02', null, '2017-09-24 10:36:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '7730', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090007', '2017-09-24', '2610000422', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '1540', null, null, null, null, null, '02', null, '2017-09-24 10:32:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090006', '2017-09-24', '2610000422', '0.00', '0.00', '1600.00', null, null, null, null, null, null, '1539', null, null, null, null, null, '02', null, '2017-09-24 10:28:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '1600', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090005', '2017-09-24', '2610000422', '0.00', '0.00', '2100.00', null, null, null, null, null, null, '1538', null, null, null, null, null, '02', null, '2017-09-24 10:27:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2100', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090004', '2017-09-24', '2610000422', '0.00', '0.00', '2400.00', null, null, null, null, null, null, '1537', null, null, null, null, null, '02', null, '2017-09-24 10:24:20', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '2400', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090003', '2017-09-24', '2610000336', '0.00', '0.00', '8160.00', null, null, null, null, null, null, '1536', null, null, null, null, null, '02', null, '2017-09-24 10:20:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '8160', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090002', '2017-09-24', '2610000422', '0.00', '0.00', '3500.00', null, null, null, null, null, null, '1535', null, null, null, null, null, '02', null, '2017-09-24 10:05:49', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '3500', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090001', '2017-08-28', '2610000419', '0.00', '0.00', '2230.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-09-08 14:24:11', '', '', '', '0.000', '', '', '1230.00', '', '', null, 'KT', '17', 'on', '', '', '0', '0', '', '', '', '', '1000', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090001', '2017-08-20', '2610000346', '0.00', '0.00', '63000.00', null, null, null, null, null, null, '2780', null, null, null, null, null, '02', null, '2017-09-09 11:58:29', '', '', '', '0.000', '', '', '0.00', '', '', null, 'BT', '17', 'on', '', '', '0', '0', '', '', '', '', '63000', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('736', '2017-09-25', '2610000420', '0.00', '0.00', '7540.00', null, null, null, null, null, null, '3149', null, null, null, null, null, '03', null, '2017-09-25 13:23:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '7540', '', '', null);
INSERT INTO `sl_invoice` VALUES ('737', '2017-09-25', '2610000420', '0.00', '0.00', '1680.00', null, null, null, null, null, null, '3150', null, null, null, null, null, '03', null, '2017-09-25 13:23:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1680', '', '', null);
INSERT INTO `sl_invoice` VALUES ('738', '2017-09-25', '2610000420', '0.00', '0.00', '840.00', null, null, null, null, null, null, '3151', null, null, null, null, null, '03', null, '2017-09-25 13:23:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '840', '', '', null);
INSERT INTO `sl_invoice` VALUES ('739', '2017-09-25', '2610000420', '0.00', '0.00', '6390.00', null, null, null, null, null, null, '3152', null, null, null, null, null, '03', null, '2017-09-25 13:23:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '6390', '', '', null);
INSERT INTO `sl_invoice` VALUES ('090050', '2017-09-25', '2610000420', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '3153', null, null, null, null, null, '03', null, '2017-09-25 14:33:42', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090051', '2017-09-25', '2610000544', '0.00', '0.00', '1900.00', null, null, null, null, null, null, '3154', null, null, null, null, null, '03', null, '2017-09-25 14:35:32', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1900', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090052', '2017-09-25', '2610000420', '0.00', '0.00', '2630.00', null, null, null, null, null, null, '3155', null, null, null, null, null, '03', null, '2017-09-25 14:36:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2630', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090053', '2017-09-25', '2610000221', '0.00', '0.00', '85515.00', null, null, null, null, null, null, '3156', null, null, null, null, null, '03', null, '2017-09-25 14:49:28', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '85515', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090054', '2017-09-25', '2610000590', '0.00', '0.00', '26310.00', null, null, null, null, null, null, '3157', null, null, null, null, null, '03', null, '2017-09-25 14:52:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '26310', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090055', '2017-09-25', '2610000420', '0.00', '0.00', '1550.00', null, null, null, null, null, null, '3158', null, null, null, null, null, '03', null, '2017-09-25 14:53:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1550', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090056', '2017-09-25', '2610000192', '0.00', '0.00', '17000.00', null, null, null, null, null, null, '3159', null, null, null, null, null, '03', null, '2017-09-25 14:54:20', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '17000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090057', '2017-09-25', '2610000420', '0.00', '0.00', '9720.00', null, null, null, null, null, null, '3160in', null, null, null, null, null, '03', null, '2017-09-25 14:55:31', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '9720', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090058', '2017-09-25', '2610000420', '0.00', '0.00', '26810.00', null, null, null, null, null, null, '3161', null, null, null, null, null, '03', null, '2017-09-25 15:01:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '26810', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090059', '2017-09-25', '2610000260', '0.00', '0.00', '31200.00', null, null, null, null, null, null, '3162', null, null, null, null, null, '03', null, '2017-09-25 15:03:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '31200', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090060', '2017-09-25', '2610000420', '0.00', '0.00', '4490.00', null, null, null, null, null, null, '3163', null, null, null, null, null, '03', null, '2017-09-25 15:05:50', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '4490', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090061', '2017-09-25', '2610000420', '0.00', '0.00', '14400.00', null, null, null, null, null, null, '3164', null, null, null, null, null, '03', null, '2017-09-25 15:06:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '14400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090062', '2017-09-25', '2610000420', '0.00', '0.00', '100.00', null, null, null, null, null, null, '3165', null, null, null, null, null, '03', null, '2017-09-25 15:07:40', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '100', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090063', '2017-09-25', '2610000544', '0.00', '0.00', '27350.00', null, null, null, null, null, null, '3166', null, null, null, null, null, '03', null, '2017-09-25 15:10:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '27350', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090064', '2017-09-25', '2610000165', '0.00', '0.00', '57600.00', null, null, null, null, null, null, '3167', null, null, null, null, null, '03', null, '2017-09-25 15:12:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '57600', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090065', '2017-09-25', '2610000420', '0.00', '0.00', '4000.00', null, null, null, null, null, null, '3168', null, null, null, null, null, '03', null, '2017-09-25 15:13:45', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '4000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090066', '2017-09-25', '2610000420', '0.00', '0.00', '3840.00', null, null, null, null, null, null, '3169', null, null, null, null, null, '03', null, '2017-09-25 15:14:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3840', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090067', '2017-09-25', '2610000420', '0.00', '0.00', '51400.00', null, null, null, null, null, null, '3170', null, null, null, null, null, '03', null, '2017-09-25 15:18:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '51400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090068', '2017-09-25', '2610000420', '0.00', '0.00', '5140.00', null, null, null, null, null, null, '3171', null, null, null, null, null, '03', null, '2017-09-25 15:20:48', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5140', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090069', '2017-09-25', '2610000420', '0.00', '0.00', '3840.00', null, null, null, null, null, null, '3172', null, null, null, null, null, '03', null, '2017-09-25 15:39:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3840', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090070', '2017-09-26', '2610000364', '0.00', '0.00', '58100.00', null, null, null, null, null, null, '3588', null, null, null, null, null, '03', null, '2017-09-26 14:34:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '58100', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090071', '2017-09-26', '2610000420', '0.00', '0.00', '1980.00', null, null, null, null, null, null, '3589', null, null, null, null, null, '03', null, '2017-09-26 14:36:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1980', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090072', '2017-09-26', '2610000044', '0.00', '0.00', '105500.00', null, null, null, null, null, null, '3590', null, null, null, null, null, '03', null, '2017-09-26 14:38:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '105500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090073', '2017-09-26', '2610000420', '0.00', '0.00', '1800.00', null, null, null, null, null, null, '', null, null, null, null, null, '03', null, '2017-09-26 14:38:31', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1800', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090074', '2017-09-26', '1310000424', '0.00', '0.00', '7480.00', null, null, null, null, null, null, '3592', null, null, null, null, null, '03', null, '2017-09-26 14:41:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '7480', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090075', '2017-09-26', '2610000420', '0.00', '0.00', '1910.00', null, null, null, null, null, null, '3593', null, null, null, null, null, '03', null, '2017-09-26 14:42:30', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1910', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090076', '2017-09-26', '2610000289', '0.00', '0.00', '12400.00', null, null, null, null, null, null, '3594', null, null, null, null, null, '03', null, '2017-09-26 14:43:27', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '12400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090077', '2017-09-26', '2610000590', '0.00', '0.00', '25150.00', null, null, null, null, null, null, '3595', null, null, null, null, null, '03', null, '2017-09-26 14:59:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '25150', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090078', '2017-09-26', '2610000420', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '3596', null, null, null, null, null, '03', null, '2017-09-26 15:00:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090079', '2017-09-26', '2610000420', '0.00', '0.00', '6900.00', null, null, null, null, null, null, '3597', null, null, null, null, null, '03', null, '2017-09-26 15:01:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '6900', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090080', '2017-09-26', '2610000420', '0.00', '0.00', '3960.00', null, null, null, null, null, null, '3598', null, null, null, null, null, '03', null, '2017-09-26 15:01:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3960', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090081', '2017-09-26', '2610000138', '0.00', '0.00', '47750.00', null, null, null, null, null, null, '3599', null, null, null, null, null, '03', null, '2017-09-26 15:03:25', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '47750', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090082', '2017-09-26', '2610000050', '0.00', '0.00', '34420.00', null, null, null, null, null, null, '3600', null, null, null, null, null, '03', null, '2017-09-26 15:06:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '34420', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090083', '2017-09-27', '2610000393', '0.00', '0.00', '51500.00', null, null, null, null, null, null, '643', null, null, null, null, null, '03', null, '2017-09-27 14:40:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '51500', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090084', '2017-09-27', '2610000420', '0.00', '0.00', '2580.00', null, null, null, null, null, null, '644', null, null, null, null, null, '03', null, '2017-09-27 14:39:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2580', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090085', '2017-09-27', '2610000420', '0.00', '0.00', '1400.00', null, null, null, null, null, null, '645', null, null, null, null, null, '03', null, '2017-09-27 14:41:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1400', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090086', '2017-09-27', '2610000420', '0.00', '0.00', '2080.00', null, null, null, null, null, null, '646', null, null, null, null, null, '03', null, '2017-09-27 14:42:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2080', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090087', '2017-09-27', '2610000420', '0.00', '0.00', '6360.00', null, null, null, null, null, null, '647', null, null, null, null, null, '03', null, '2017-09-27 14:43:02', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '6360', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090088', '2017-09-27', '2610000420', '0.00', '0.00', '5650.00', null, null, null, null, null, null, '648', null, null, null, null, null, '03', null, '2017-09-27 14:43:53', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5650', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090089', '2017-09-27', '2610000148', '0.00', '0.00', '78000.00', null, null, null, null, null, null, '649', null, null, null, null, null, '03', null, '2017-09-27 14:44:23', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '78000', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090090', '2017-09-27', '2610000221', '0.00', '0.00', '128500.00', null, null, null, null, null, null, '650', null, null, null, null, null, '03', null, '2017-09-27 14:37:29', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '128500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090091', '2017-09-27', '2610000420', '0.00', '0.00', '12380.00', null, null, null, null, null, null, '651', null, null, null, null, null, '03', null, '2017-09-27 14:39:16', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '12380', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090092', '2017-09-27', '2610000420', '0.00', '0.00', '8540.00', null, null, null, null, null, null, '652', null, null, null, null, null, '03', null, '2017-09-27 14:40:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '8540', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090093', '2017-09-27', '2610000260', '0.00', '0.00', '12000.00', null, null, null, null, null, null, '653', null, null, null, null, null, '03', null, '2017-09-27 14:42:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '12000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090094', '2017-09-27', '2610000260', '0.00', '0.00', '9000.00', null, null, null, null, null, null, '654', null, null, null, null, null, '03', null, '2017-09-27 14:43:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '9000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090095', '2017-09-27', '2610000420', '0.00', '0.00', '6350.00', null, null, null, null, null, null, '655', null, null, null, null, null, '03', null, '2017-09-27 15:01:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '6350', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090096', '2017-09-27', '2610000420', '0.00', '0.00', '1550.00', null, null, null, null, null, null, '656', null, null, null, null, null, '03', null, '2017-09-27 15:01:42', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1550', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090097', '2017-09-27', '2610000091', '0.00', '0.00', '73500.00', null, null, null, null, null, null, '57', null, null, null, null, null, '03', null, '2017-09-27 15:03:29', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '73500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090098', '2017-09-27', '2610000420', '0.00', '0.00', '12400.00', null, null, null, null, null, null, '658', null, null, null, null, null, '03', null, '2017-09-27 15:06:44', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '12400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090099', '2017-09-27', '2610000370', '0.00', '0.00', '30870.00', null, null, null, null, null, null, '659', null, null, null, null, null, '03', null, '2017-09-27 15:11:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '30870', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090100', '2017-09-27', '2610000221', '0.00', '0.00', '49000.00', null, null, null, null, null, null, '660', null, null, null, null, null, '03', null, '2017-09-27 15:12:03', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '49000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090101', '2017-09-27', '2610000067', '0.00', '0.00', '12800.00', null, null, null, null, null, null, '661', null, null, null, null, null, '03', null, '2017-09-27 15:14:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '12800', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090102', '2017-09-27', '2610000420', '0.00', '0.00', '1480.00', null, null, null, null, null, null, '662', null, null, null, null, null, '03', null, '2017-09-27 15:16:36', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1480', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090103', '2017-09-27', '2610000420', '0.00', '0.00', '44800.00', null, null, null, null, null, null, '663', null, null, null, null, null, '03', null, '2017-09-27 15:17:39', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '44800', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090104', '2017-09-27', '2610000544', '0.00', '0.00', '19220.00', null, null, null, null, null, null, '664', null, null, null, null, null, '03', null, '2017-09-27 15:19:47', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '19220', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090105', '2017-09-27', '2610000420', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '665', null, null, null, null, null, '03', null, '2017-09-27 15:20:52', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090106', '2017-09-27', '2610000400', '0.00', '0.00', '27600.00', null, null, null, null, null, null, '666', null, null, null, null, null, '03', null, '2017-09-27 15:22:59', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '27600', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090107', '2017-09-28', '2610000420', '0.00', '0.00', '11120.00', null, null, null, null, null, null, '3601', null, null, null, null, null, '03', null, '2017-09-28 15:12:01', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '11120', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090108', '2017-09-28', '2610000364', '0.00', '0.00', '76500.00', null, null, null, null, null, null, '3602', null, null, null, null, null, '03', null, '2017-09-28 15:13:38', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '76500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090109', '2017-09-28', '2610000590', '0.00', '0.00', '25070.00', null, null, null, null, null, null, '3603', null, null, null, null, null, '03', null, '2017-09-28 15:15:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '25070', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090110', '2017-09-28', '2610000420', '0.00', '0.00', '20400.00', null, null, null, null, null, null, '3604', null, null, null, null, null, '03', null, '2017-09-28 15:16:34', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '20400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090111', '2017-09-28', '2610000138', '0.00', '0.00', '48000.00', null, null, null, null, null, null, '3605', null, null, null, null, null, '03', null, '2017-09-28 15:17:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '48000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090112', '2017-09-28', '2610000420', '0.00', '0.00', '5740.00', null, null, null, null, null, null, '3606', null, null, null, null, null, '03', null, '2017-09-28 15:18:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5740', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090113', '2017-09-28', '2610000420', '0.00', '0.00', '1920.00', null, null, null, null, null, null, '3607', null, null, null, null, null, '03', null, '2017-09-28 15:20:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1920', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090114', '2017-09-28', '2610000420', '0.00', '0.00', '17100.00', null, null, null, null, null, null, '3608', null, null, null, null, null, '03', null, '2017-09-28 15:21:45', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '17100', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090115', '2017-09-28', '2610000420', '0.00', '0.00', '5100.00', null, null, null, null, null, null, '3609', null, null, null, null, null, '03', null, '2017-09-28 15:22:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5100', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090116', '2017-09-28', '2610000420', '0.00', '0.00', '7240.00', null, null, null, null, null, null, '', null, null, null, null, null, '03', null, '2017-09-28 15:23:49', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '7240', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090117', '2017-09-28', '2610000420', '0.00', '0.00', '2560.00', null, null, null, null, null, null, '3611', null, null, null, null, null, '03', null, '2017-09-28 15:24:19', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2560', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090118', '2017-09-28', '2610000260', '0.00', '0.00', '65750.00', null, null, null, null, null, null, '3612', null, null, null, null, null, '03', null, '2017-09-28 15:26:00', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '65750', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090119', '2017-09-28', '2610000420', '0.00', '0.00', '1480.00', null, null, null, null, null, null, '3613', null, null, null, null, null, '03', null, '2017-09-28 15:26:46', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1480', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090120', '2017-09-28', '2610000533', '0.00', '0.00', '13400.00', null, null, null, null, null, null, '3614', null, null, null, null, null, '03', null, '2017-09-28 15:29:05', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '13400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090121', '2017-09-28', '2610000420', '0.00', '0.00', '41350.00', null, null, null, null, null, null, '3615', null, null, null, null, null, '03', null, '2017-09-28 15:30:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '41350', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090122', '2017-09-28', '2610000420', '0.00', '0.00', '3175.00', null, null, null, null, null, null, '3616', null, null, null, null, null, '03', null, '2017-09-28 15:31:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3175', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090123', '2017-09-28', '2610000420', '0.00', '0.00', '40380.00', null, null, null, null, null, null, '3617', null, null, null, null, null, '03', null, '2017-09-28 18:00:07', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '40380', '', 'kt', null);
INSERT INTO `sl_invoice` VALUES ('090124', '2017-09-28', '2610000420', '0.00', '0.00', '640.00', null, null, null, null, null, null, '3618', null, null, null, null, null, '03', null, '2017-09-28 15:36:08', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '640', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090125', '2017-09-28', '2610000083', '0.00', '0.00', '830.00', null, null, null, null, null, null, '3619', null, null, null, null, null, '03', null, '2017-09-28 15:36:58', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '830', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090126', '2017-09-28', '2610000606', '0.00', '0.00', '363625.00', null, null, null, null, null, null, '3620', null, null, null, null, null, '03', null, '2017-09-28 15:41:54', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '363625', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090127', '2017-09-28', '2610000138', '0.00', '0.00', '34400.00', null, null, null, null, null, null, '3621', null, null, null, null, null, '03', null, '2017-09-28 15:42:51', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '34400', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090128', '2017-09-28', '2610000364', '0.00', '0.00', '3666.00', null, null, null, null, null, null, '3622', null, null, null, null, null, '03', null, '2017-09-28 15:44:27', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3666', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090129', '2017-09-28', '2610000420', '0.00', '0.00', '1910.00', null, null, null, null, null, null, '3623', null, null, null, null, null, '03', null, '2017-09-28 15:45:06', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1910', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090130', '2017-09-29', '2610000420', '0.00', '0.00', '1910.00', null, null, null, null, null, null, '3459', null, null, null, null, null, '03', null, '2017-09-29 09:40:21', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1910', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090131', '2017-09-29', '2610000420', '0.00', '0.00', '700.00', null, null, null, null, null, null, '3460', null, null, null, null, null, '03', null, '2017-09-29 09:40:57', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '700', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090132', '2017-09-29', '2610000420', '0.00', '0.00', '3820.00', null, null, null, null, null, null, '3461', null, null, null, null, null, '03', null, '2017-09-29 09:45:56', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '3820', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090133', '2017-09-29', '2610000420', '0.00', '0.00', '5870.00', null, null, null, null, null, null, '3462', null, null, null, null, null, '03', null, '2017-09-29 09:48:22', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '5870', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090134', '2017-09-29', '2610000420', '0.00', '0.00', '10580.00', null, null, null, null, null, null, '3463', null, null, null, null, null, '03', null, '2017-09-29 09:49:36', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '10580', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090135', '2017-09-29', '2610000420', '0.00', '0.00', '2560.00', null, null, null, null, null, null, '3464', null, null, null, null, null, '03', null, '2017-09-29 09:50:09', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2560', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090136', '2017-09-29', '2610000221', '0.00', '0.00', '62940.00', null, null, null, null, null, null, '3465', null, null, null, null, null, '03', null, '2017-09-29 09:52:14', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '62940', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090137', '2017-09-29', '2610000420', '0.00', '0.00', '9500.00', null, null, null, null, null, null, '3466', null, null, null, null, null, '03', null, '2017-09-29 09:53:17', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '9500', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090138', '2017-09-29', '2610000420', '0.00', '0.00', '2970.00', null, null, null, null, null, null, '3467', null, null, null, null, null, '03', null, '2017-09-29 09:54:52', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2970', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090139', '2017-09-29', '2610000420', '0.00', '0.00', '7130.00', null, null, null, null, null, null, '348', null, null, null, null, null, '03', null, '2017-09-29 10:01:20', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '7130', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090140', '2017-09-29', '2610000420', '0.00', '0.00', '9000.00', null, null, null, null, null, null, '3469', null, null, null, null, null, '03', null, '2017-09-29 11:01:43', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '9000', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090141', '2017-09-29', '2610000420', '0.00', '0.00', '2600.00', null, null, null, null, null, null, '3470', null, null, null, null, null, '03', null, '2017-09-29 11:02:37', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '2600', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090142', '2017-09-29', '2610000420', '0.00', '0.00', '1480.00', null, null, null, null, null, null, '3471', null, null, null, null, null, '03', null, '2017-09-29 11:03:24', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1480', '', 'it', null);
INSERT INTO `sl_invoice` VALUES ('090143', '2017-09-29', '2610000378', '0.00', '0.00', '1930.00', null, null, null, null, null, null, '3472', null, null, null, null, null, '03', null, '2017-09-29 11:05:18', '', '', '', '0.000', '', '', '0.00', '', '', null, 'IT', '17', 'on', '', '', '0', '0', '', '', '', '', '1930', '', 'it', null);

-- ----------------------------
-- Table structure for `sl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet`;
CREATE TABLE `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet
-- ----------------------------
INSERT INTO `sl_invoicedet` VALUES ('080032', '1', '0007', '', '4.000', '680.00000', '2720.00', '', null, null, '0', null, '659.961', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080033', '1', '0007', '', '1.000', '660.00000', '660.00', '', null, null, '0', null, '659.961', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080034', '1', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2446.139', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080035', '1', '0048', '', '2.000', '2600.00000', '5200.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080036', '1', '0048', '', '30.000', '2630.00000', '78900.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080037', '1', '0048', '', '12.000', '2620.00000', '31440.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '1', '0034', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '1', '0034', '', '10.000', '1880.00000', '18800.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '2', '0004', '', '2.000', '4700.00000', '9400.00', '', null, null, '0', null, '4887.811', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '3', '0215', '', '1.000', '1950.00000', '1950.00', '', null, null, '0', null, '1857.738', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '4', '0238', '', '1.000', '1600.00000', '1600.00', '', null, null, '0', null, '1474.679', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '5', '0085', '', '3.000', '2800.00000', '8400.00', '', null, null, '0', null, '2446.139', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '6', '0091', '', '2.000', '2650.00000', '5300.00', '', null, null, '0', null, '2052.330', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080040', '1', '0046', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1857.455', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080041', '1', '0057', '', '1.000', '850.00000', '850.00', '', null, null, '0', null, '798.681', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080042', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080001', '1', '0011', '', '1.000', '1500.00000', '1500.00', '', null, null, '0', null, '1486.580', null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080031', '1', '0046', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1857.455', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '1', '0048', '', '2.000', '2600.00000', '5200.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080018', '1', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1910.334', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080028', '1', '0037', '', '50.000', '1890.00000', '94500.00', '', null, null, '0', null, '1900.963', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '1', '0037', '', '20.000', '1860.00000', '37200.00', '', null, null, '0', null, '1900.963', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '2', '0035', '', '10.000', '1870.00000', '18700.00', '', null, null, '0', null, '1910.334', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '3', '0036', '', '30.000', '1850.00000', '55500.00', '', null, null, '0', null, '1890.668', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '4', '0034', '', '65.000', '1850.00000', '120250.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '1', '0037', '', '10.000', '1870.00000', '18700.00', '', null, null, '0', null, '1900.963', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '2', '0034', '', '80.000', '1860.00000', '148800.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '3', '0036', '', '30.000', '1860.00000', '55800.00', '', null, null, '0', null, '1890.668', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '4', '0035', '', '10.000', '1880.00000', '18800.00', '', null, null, '0', null, '1910.334', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '1', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1419.074', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080024', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080024', '2', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080024', '3', '0069', '', '1.000', '730.00000', '730.00', '', null, null, '0', null, '730.497', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080023', '1', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '659.961', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '1', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1499.658', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '2', '0048', '', '1.000', '2620.00000', '2620.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '3', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080021', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080029', '1', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080020', '1', '0048', '', '2.000', '2600.00000', '5200.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080019', '1', '0048', '', '5.000', '2650.00000', '13250.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080019', '2', '0176', '', '1.000', '9000.00000', '9000.00', '', null, null, '0', null, '8788.371', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080030', '1', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080017', '1', '0048', '', '2.000', '2620.00000', '5240.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080017', '2', '0034', '', '8.000', '1880.00000', '15040.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080016', '1', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080015', '1', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080015', '2', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080013', '1', '0176', '', '5.000', '8900.00000', '44500.00', '', null, null, '0', null, '8788.371', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080014', '1', '0034', '', '11.000', '1870.00000', '20570.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080014', '2', '0036', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1890.668', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080003', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2169.156', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080009', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2686.190', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080008', '1', '0223', '', '2.000', '820.00000', '1640.00', '', null, null, '0', null, '820.530', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080007', '1', '0017', '', '1.000', '1500.00000', '1500.00', '', null, null, '0', null, '1499.658', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080006', '1', '0036', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1890.668', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '1', '0034', '', '5.000', '1870.00000', '9350.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '2', '0035', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1910.334', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '3', '0036', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1890.668', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080001', '1', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('', '1', '0011', '', '1.000', '1500.00000', '1500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080004', '1', '0011', '', '1.000', '1500.00000', '1500.00', '', null, null, '0', null, '1486.580', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '18', '0048', '', '1.000', '2460.00000', '2460.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '19', '0033', '', '1.000', '630.00000', '630.00', '', null, null, '0', null, '596.852', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080003', '1', '0048', '', '1.000', '2750.00000', '2750.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '15', '0034', '1205', '20.000', '1880.00000', '37600.00', '', null, null, '0', null, '1833.648', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '14', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1279.713', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '13', '0036', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1852.239', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '12', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1833.648', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '11', '0062', '', '1.000', '810.00000', '810.00', '', null, null, '0', null, '433.016', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '10', '0102', '', '1.000', '240.00000', '240.00', '', null, null, '0', null, '212.060', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '9', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1833.648', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '8', '0048', '1204', '2.000', '2450.00000', '4900.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '7', '0048', '1203', '10.000', '2440.00000', '24400.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '6', '0017', '1202', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1429.480', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '5', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1833.648', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '4', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '632.045', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '3', '0009', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1543.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '1', '0016', '1201', '1.000', '810.00000', '810.00', '', null, null, '0', null, '738.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080139', '2', '0168', '', '1.000', '330.00000', '330.00', '', null, null, '0', null, '280.500', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080003', '2', '0037', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1907.922', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080004', '1', '0007', '', '4.000', '670.00000', '2680.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '1', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2267.150', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '2', '0048', '', '1.000', '2740.00000', '2740.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '3', '0033', '', '1.000', '640.00000', '640.00', '', null, null, '0', null, '596.852', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '4', '0016', '', '1.000', '810.00000', '810.00', '', null, null, '0', null, '758.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '5', '0102', '', '1.000', '240.00000', '240.00', '', null, null, '0', null, '233.250', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '6', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1387.667', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080005', '7', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080006', '1', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080006', '2', '0043', '', '2.000', '50.00000', '100.00', '', null, null, '0', null, '48.161', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080006', '3', '0043', '', '2.000', '70.00000', '140.00', '', null, null, '0', null, '48.161', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080007', '1', '0017', '', '6.000', '1550.00000', '9300.00', '', null, null, '0', null, '1528.333', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080007', '2', '0023', '', '10.000', '1860.00000', '18600.00', '', null, null, '0', null, '1877.114', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080007', '3', '0039', '', '1.000', '590.00000', '590.00', '', null, null, '0', null, '514.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080008', '1', '0179', '', '1.000', '3120.00000', '3120.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080008', '2', '0048', '', '1.000', '2740.00000', '2740.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080009', '1', '0048', '', '8.000', '2750.00000', '22000.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080009', '2', '0085', '', '5.000', '2850.00000', '14250.00', '', null, null, '0', null, '2267.150', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080009', '3', '0086', '', '5.000', '600.00000', '3000.00', '', null, null, '0', null, '567.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '1', '0048', '', '10.000', '2750.00000', '27500.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '2', '0179', '', '2.000', '3120.00000', '6240.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '3', '0004', '', '1.000', '4700.00000', '4700.00', '', null, null, '0', null, '4877.700', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '4', '0034', '', '5.000', '1880.00000', '9400.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '5', '0035', '', '2.000', '1900.00000', '3800.00', '', null, null, '0', null, '1919.244', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080010', '6', '0044', '', '2.000', '3910.00000', '7820.00', '', null, null, '0', null, '3521.800', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080011', '1', '0022', '', '1.000', '1840.00000', '1840.00', '', null, null, '0', null, '1871.807', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080011', '2', '0049', '', '1.000', '1420.00000', '1420.00', '', null, null, '0', null, '1435.882', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080012', '1', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080012', '2', '0044', '', '1.000', '3900.00000', '3900.00', '', null, null, '0', null, '3521.800', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080012', '3', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080012', '4', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080012', '5', '0008', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1387.667', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080012', '6', '0037', 'RAHAT T 10KG', '1.000', '1190.00000', '1190.00', '', null, null, '0', null, '1907.922', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080013', '1', '0048', '', '2.000', '2600.00000', '5200.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080013', '2', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1528.333', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080013', '3', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080014', '1', '0017', '', '2.000', '1530.00000', '3060.00', '', null, null, '0', null, '1528.333', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080014', '2', '0065', '', '2.000', '1480.00000', '2960.00', '', null, null, '0', null, '1433.053', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080014', '3', '0034', '', '4.000', '1870.00000', '7480.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080014', '4', '0036', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1906.375', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080015', '1', '0048', '', '15.000', '2600.00000', '39000.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080015', '2', '0036', '', '3.000', '1870.00000', '5610.00', '', null, null, '0', null, '1906.375', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080016', '1', '0007', '', '1.000', '680.00000', '680.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080016', '2', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080016', '3', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080017', '1', '0008', '', '1.000', '1543.00000', '1543.00', '', null, null, '0', null, '1387.667', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080017', '2', '0007', '', '1.000', '630.00000', '630.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080018', '1', '0017', '', '1.000', '1520.00000', '1520.00', '', null, null, '0', null, '1528.333', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080018', '2', '0021', '', '1.000', '650.00000', '650.00', '', null, null, '0', null, '628.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080018', '3', '0034', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080018', '4', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080019', '1', '0004', '', '2.000', '4700.00000', '9400.00', '', null, null, '0', null, '4877.700', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080019', '2', '0238', '', '2.000', '1600.00000', '3200.00', '', null, null, '0', null, '1455.875', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080020', '1', '0048', '', '10.000', '2600.00000', '26000.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080021', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '1', '0037', '', '5.000', '1880.00000', '9400.00', '', null, null, '0', null, '1907.922', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '2', '0034', '', '15.000', '1870.00000', '28050.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '3', '0036', '', '3.000', '1870.00000', '5610.00', '', null, null, '0', null, '1906.375', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '4', '0035', '', '2.000', '1890.00000', '3780.00', '', null, null, '0', null, '1919.244', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '5', '0241', '', '15.000', '570.00000', '8550.00', '', null, null, '0', null, '581.324', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '6', '0028', '', '10.000', '285.00000', '2850.00', '', null, null, '0', null, '287.441', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '7', '0029', '', '5.000', '628.00000', '3140.00', '', null, null, '0', null, '644.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080022', '8', '0020', '', '5.000', '324.00000', '1620.00', '', null, null, '0', null, '323.172', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080023', '1', '0078', '', '1.000', '680.00000', '680.00', '', null, null, '0', null, '738.145', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080023', '2', '0038', '', '1.000', '570.00000', '570.00', '', null, null, '0', null, '504.896', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080024', '1', '0179', '', '5.000', '3095.00000', '15475.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080044', '1', '0105', '', '1.000', '1300.00000', '1300.00', '', null, null, '0', null, '1273.636', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080045', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080125', '3', '0035', '', '2.000', '1890.00000', '3780.00', '', null, null, '0', null, '1919.244', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '30', '0043', '', '2.000', '50.00000', '100.00', '', null, null, '0', null, '41.293', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '1', '0034', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '2', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '3', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '4', '0043', '', '2.000', '50.00000', '100.00', '', null, null, '0', null, '41.293', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '5', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '6', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '7', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '655.255', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '8', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '9', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '10', '0048', '', '1.000', '2580.00000', '2580.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '11', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '12', '0048', '', '1.000', '2590.00000', '2590.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '13', '0048', '', '1.000', '2580.00000', '2580.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '14', '0046', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1855.601', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '15', '0048', '', '10.000', '2590.00000', '25900.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '16', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1910.334', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '17', '0048', '', '1.000', '2580.00000', '2580.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '18', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '19', '0048', '', '1.000', '2590.00000', '2590.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '20', '0007', '', '2.000', '670.00000', '1340.00', '', null, null, '0', null, '655.255', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '21', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '22', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '23', '0036', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1890.668', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '24', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '655.255', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '25', '0004', '', '1.000', '4750.00000', '4750.00', '', null, null, '0', null, '4887.811', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '26', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '27', '0048', '', '1.000', '2590.00000', '2590.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '28', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '655.255', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '29', '0070', '', '1.000', '750.00000', '750.00', '', null, null, '0', null, '698.588', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '30', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '31', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '32', '0046', '', '1.000', '1910.00000', '1910.00', '', null, null, '0', null, '1855.601', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '33', '0057', '', '1.000', '830.00000', '830.00', '', null, null, '0', null, '798.681', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '34', '0225', '', '2.000', '835.00000', '1670.00', '', null, null, '0', null, '812.390', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '35', '0176', '', '2.000', '8950.00000', '17900.00', '', null, null, '0', null, '8788.371', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '36', '0176', '', '1.000', '8900.00000', '8900.00', '', null, null, '0', null, '8788.371', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '37', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '1', '0072', '', '20.000', '2300.00000', '46000.00', '', null, null, '0', null, '2169.156', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '2', '0065', '', '10.000', '1500.00000', '15000.00', '', null, null, '0', null, '1415.742', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '3', '0037', '', '20.000', '1900.00000', '38000.00', '', null, null, '0', null, '1900.963', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '4', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2446.139', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '5', '0048', '', '25.000', '2650.00000', '66250.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '6', '0007', '', '5.000', '670.00000', '3350.00', '', null, null, '0', null, '655.255', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '7', '0017', '', '30.000', '1550.00000', '46500.00', '', null, null, '0', null, '1481.486', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '2', '0037', '', '10.000', '1890.00000', '18900.00', '', null, null, '0', null, '1900.963', null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '1', '0048', '', '10.000', '2600.00000', '26000.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080051', '1', '0048', '', '20.000', '2400.00000', '48000.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080050', '1', '0017', '', '10.000', '1550.00000', '15500.00', '', null, null, '0', null, '1481.486', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080053', '1', '0082', '', '2.000', '1550.00000', '3100.00', '', null, null, '0', null, '1491.462', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080053', '2', '0034', '', '3.000', '1880.00000', '5640.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080053', '3', '0043', '', '4.000', '50.00000', '200.00', '', null, null, '0', null, '41.293', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080055', '1', '0048', '', '50.000', '2580.00000', '129000.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080056', '1', '0034', 'MADRSA SERJEEA', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1881.214', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080057', '1', '0048', '', '20.000', '2580.00000', '51600.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080058', '1', '0176', '', '25.000', '8900.00000', '222500.00', '', null, null, '0', null, '8788.371', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080059', '1', '0048', '', '10.000', '2630.00000', '26300.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080060', '1', '0048', '', '5.000', '2600.00000', '13000.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080128', '1', '0048', '', '20.000', '2480.00000', '49600.00', '', null, null, '0', null, '2519.773', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080062', '1', '0007', '', '20.000', '655.00000', '13100.00', '', null, null, '0', null, '655.255', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080062', '2', '0008', '', '25.000', '1310.00000', '32750.00', '', null, null, '0', null, '1263.806', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080062', '3', '0009', '', '20.000', '1605.00000', '32100.00', '', null, null, '0', null, '1604.605', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080145', '3', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1887.185', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080144', '1', '0048', '', '8.000', '2500.00000', '20000.00', '', null, null, '0', null, '2488.426', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080064', '1', '0008', '', '15.000', '1400.00000', '21000.00', '', null, null, '0', null, '1263.806', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080064', '2', '0017', '', '5.000', '1600.00000', '8000.00', '', null, null, '0', null, '1481.486', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080148', '1', '0048', '', '5.000', '2500.00000', '12500.00', '', null, null, '0', null, '2488.426', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080153', '2', '0036', '', '10.000', '1860.00000', '18600.00', '', null, null, '0', null, '1857.152', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '26', '0013', '', '1.000', '2350.00000', '2350.00', '', null, null, '0', null, '2279.051', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '25', '0023', '', '1.000', '1860.00000', '1860.00', '', null, null, '0', null, '1877.114', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '24', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '23', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '10', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '11', '0035', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '12', '0048', '', '1.000', '2500.00000', '2500.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '13', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '14', '0017', '', '1.000', '1520.00000', '1520.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '15', '0046', '', '1.000', '1930.00000', '1930.00', '', null, null, '0', null, '1844.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '16', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '17', '0048', '', '2.000', '2510.00000', '5020.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '18', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2267.150', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '19', '0034', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '20', '0009', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1543.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '21', '0023', '', '1.000', '1850.00000', '1850.00', '', null, null, '0', null, '1877.114', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '22', '0035', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080138', '1', '0034', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080137', '1', '0048', '', '40.000', '2500.00000', '100000.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080136', '4', '0001', '', '6.000', '820.00000', '4920.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080136', '3', '0007', '', '4.000', '670.00000', '2680.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080136', '1', '0048', '', '6.000', '2490.00000', '14940.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080135', '1', '0048', '', '8.000', '2490.00000', '19920.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080134', '1', '0048', '', '10.000', '2500.00000', '25000.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080120', '35', '0072', '', '1.000', '2240.00000', '2240.00', '', null, null, '0', null, '2169.156', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '28', '0048', '', '2.000', '2500.00000', '5000.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '27', '0080', '', '1.000', '1720.00000', '1720.00', '', null, null, '0', null, '1677.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080068', '1', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2446.139', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080068', '2', '0091', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2052.330', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '7', '0018', '', '1.000', '1250.00000', '1250.00', '', null, null, '0', null, '1203.556', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '5', '0048', '', '4.000', '2520.00000', '10080.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '2', '0001', '', '8.000', '820.00000', '6560.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080132', '1', '0048', '', '3.000', '2530.00000', '7590.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '11', '0234', '', '1.000', '570.00000', '570.00', '', null, null, '0', null, '559.000', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '7', '0017', '', '1.000', '1520.00000', '1520.00', '', null, null, '0', null, '1434.593', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080072', '1', '0035', '', '10.000', '1875.00000', '18750.00', '', null, null, '0', null, '1902.116', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080072', '2', '0036', '', '10.000', '1855.00000', '18550.00', '', null, null, '0', null, '1880.958', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080073', '1', '0007', '', '3.000', '670.00000', '2010.00', '', null, null, '0', null, '646.071', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080074', '1', '0048', '', '18.000', '2620.00000', '47160.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080075', '1', '0065', '', '2.000', '1460.00000', '2920.00', '', null, null, '0', null, '1415.742', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080075', '2', '0034', '', '6.000', '1870.00000', '11220.00', '', null, null, '0', null, '1864.321', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080075', '3', '0036', '', '3.000', '1870.00000', '5610.00', '', null, null, '0', null, '1880.958', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080075', '4', '0035', '', '3.000', '1890.00000', '5670.00', '', null, null, '0', null, '1902.116', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080076', '1', '0034', '', '30.000', '1855.00000', '55650.00', '', null, null, '0', null, '1864.321', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080076', '2', '0036', '', '10.000', '1855.00000', '18550.00', '', null, null, '0', null, '1880.958', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080076', '3', '0037', '', '10.000', '1865.00000', '18650.00', '', null, null, '0', null, '1888.644', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080077', '1', '0048', '', '4.000', '2580.00000', '10320.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080078', '1', '0037', '', '20.000', '1870.00000', '37400.00', '', null, null, '0', null, '1888.644', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080078', '2', '0034', '', '85.000', '1860.00000', '158100.00', '', null, null, '0', null, '1864.321', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080078', '3', '0036', '', '20.000', '1860.00000', '37200.00', '', null, null, '0', null, '1880.958', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080078', '4', '0035', '', '5.000', '1880.00000', '9400.00', '', null, null, '0', null, '1902.116', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080089', '1', '0035', '', '10.000', '1875.00000', '18750.00', '', null, null, '0', null, '1902.116', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080089', '2', '0036', '', '10.000', '1855.00000', '18550.00', '', null, null, '0', null, '1880.958', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080089', '3', '0037', '', '15.000', '1865.00000', '27975.00', '', null, null, '0', null, '1888.644', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080089', '4', '0034', '', '90.000', '1855.00000', '166950.00', '', null, null, '0', null, '1864.321', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080079', '1', '0035', '', '30.000', '1865.00000', '55950.00', '', null, null, '0', null, '1902.116', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080079', '2', '0036', '', '30.000', '1855.00000', '55650.00', '', null, null, '0', null, '1880.958', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080079', '3', '0034', '', '65.000', '1855.00000', '120575.00', '', null, null, '0', null, '1864.321', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080080', '1', '0048', '', '5.000', '2580.00000', '12900.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '44', '0048', '', '1.000', '2450.00000', '2450.00', '', null, null, '0', null, '2488.426', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080088', '1', '0048', '', '9.000', '2580.00000', '23220.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080082', '1', '0017', '', '30.000', '1480.00000', '44400.00', '', null, null, '0', null, '1448.968', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080087', '1', '0068', '', '50.000', '815.00000', '40750.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080086', '1', '0068', '', '20.000', '830.00000', '16600.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '47', '0070', '', '1.000', '750.00000', '750.00', '', null, null, '0', null, '702.261', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080084', '1', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1864.321', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '2', '0062', '', '1.000', '460.00000', '460.00', '', null, null, '0', null, '433.016', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080183', '6', '0048', '', '1.000', '2450.00000', '2450.00', '', null, null, '0', null, '2438.166', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080218', '1', '0008', '', '20.000', '1400.00000', '28000.00', '', null, null, '0', null, '1263.806', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080125', '2', '0036', '', '4.000', '1870.00000', '7480.00', '', null, null, '0', null, '1906.375', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080125', '1', '0034', '', '14.000', '1870.00000', '26180.00', '', null, null, '0', null, '1894.039', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080045', '1', '0034', '', '5.000', '1870.00000', '9350.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080045', '2', '0036', '', '4.000', '1870.00000', '7480.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080045', '3', '0035', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080045', '4', '0048', '', '15.000', '2600.00000', '39000.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080044', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080044', '2', '0036', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080044', '3', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '1', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1307.875', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '2', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1419.074', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '3', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '4', '0033', '', '1.000', '640.00000', '640.00', '', null, null, '0', null, '596.852', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '5', '0037', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1893.357', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '6', '0020', '', '1.000', '340.00000', '340.00', '', null, null, '0', null, '317.639', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '7', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080043', '8', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080042', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080042', '2', '0037', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1893.357', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080041', '1', '0048', '', '2.000', '2600.00000', '5200.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080041', '2', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1419.074', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080040', '1', '0179', '', '1.000', '3120.00000', '3120.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080039', '1', '0007', '', '2.000', '680.00000', '1360.00', '', null, null, '0', null, '655.474', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '3', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '4', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '5', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2267.150', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '6', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080038', '7', '0037', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1893.357', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080033', '1', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1419.074', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080033', '2', '0046', '', '1.000', '1930.00000', '1930.00', '', null, null, '0', null, '1954.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080037', '3', '0036', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080037', '2', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080037', '1', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080036', '4', '0039', '', '1.000', '570.00000', '570.00', '', null, null, '0', null, '514.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080036', '3', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080036', '2', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1419.074', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080036', '1', '0048', '', '3.000', '2600.00000', '7800.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080037', '4', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080037', '5', '0126', '', '1.000', '7000.00000', '7000.00', '', null, null, '0', null, '5666.933', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080035', '1', '0179', '', '5.000', '3095.00000', '15475.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080035', '2', '0048', '', '5.000', '2600.00000', '13000.00', '', null, null, '0', null, '2725.729', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080035', '3', '0001', '', '3.000', '820.00000', '2460.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080034', '1', '0001', '', '15.000', '820.00000', '12300.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080032', '1', '0001', 'Sattar Proa', '5.000', '820.00000', '4100.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080032', '2', '0068', '', '3.000', '1000.00000', '3000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080031', '1', '0001', '', '25.000', '820.00000', '20500.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080031', '2', '0068', '', '2.000', '1000.00000', '2000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080030', '1', '0001', '', '10.000', '820.00000', '8200.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080030', '2', '0068', 'sarson 500 ml', '3.000', '1000.00000', '3000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080030', '3', '0068', '', '2.000', '1000.00000', '2000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080029', '1', '0001', '', '20.000', '820.00000', '16400.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080028', '1', '0001', '', '10.000', '820.00000', '8200.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080028', '2', '0001', '500 ml', '5.000', '1000.00000', '5000.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080028', '3', '0068', '', '5.000', '1000.00000', '5000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '1', '0037', '', '10.000', '1870.00000', '18700.00', '', null, null, '0', null, '1893.357', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '2', '0034', '', '15.000', '1860.00000', '27900.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '3', '0036', '', '3.000', '1860.00000', '5580.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080027', '4', '0035', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '1', '0001', '', '2.000', '820.00000', '1640.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '2', '0021', '', '1.000', '650.00000', '650.00', '', null, null, '0', null, '602.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '3', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080026', '4', '0036', '100 GM', '1.000', '850.00000', '850.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080025', '1', '0068', '', '3.000', '1000.00000', '3000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080025', '2', '0068', '500 GM', '2.000', '1000.00000', '2000.00', '', null, null, '0', null, '985.220', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080025', '3', '0001', '', '5.000', '820.00000', '4100.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '38', '0043', '', '20.000', '50.00000', '1000.00', '', null, null, '0', null, '41.293', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '14', '0037', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1893.357', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '34', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1887.185', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '11', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '12', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '13', '0179', '', '1.000', '3120.00000', '3120.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '10', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1279.713', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '9', '0237', '', '1.000', '600.00000', '600.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '8', '0048', '', '2.000', '2600.00000', '5200.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '7', '0055', '', '1.000', '1500.00000', '1500.00', '', null, null, '0', null, '1417.209', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '6', '0037', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1893.357', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '3', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1279.713', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '4', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '5', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '2', '0034', '', '3.000', '1880.00000', '5640.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '1', '0048', '', '3.000', '2600.00000', '7800.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '31', '0048', '', '1.000', '2450.00000', '2450.00', '', null, null, '0', null, '2488.426', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080105', '1', '0034', '', '70.000', '1860.00000', '130200.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '1', '0048', '', '2.000', '2560.00000', '5120.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '2', '0048', '', '1.000', '2560.00000', '2560.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '3', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '4', '0048', '', '1.000', '2560.00000', '2560.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '5', '0037', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1880.425', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '6', '0048', '', '1.000', '2580.00000', '2580.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '7', '0070', '', '1.000', '750.00000', '750.00', '', null, null, '0', null, '702.261', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '8', '0048', '', '1.000', '2580.00000', '2580.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '9', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '10', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '11', '0034', '', '1.000', '1890.00000', '1890.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '12', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '13', '0007', '', '1.000', '660.00000', '660.00', '', null, null, '0', null, '646.071', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '14', '0038', '', '1.000', '520.00000', '520.00', '', null, null, '0', null, '505.123', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '15', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '646.071', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '16', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '646.071', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '17', '0017', '', '2.000', '1520.00000', '3040.00', '', null, null, '0', null, '1441.673', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '18', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '19', '0007', '', '1.000', '680.00000', '680.00', '', null, null, '0', null, '646.071', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '20', '0048', '', '1.000', '2530.00000', '2530.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '21', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '22', '0043', '', '7.000', '50.00000', '350.00', '', null, null, '0', null, '41.293', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '23', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '24', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '25', '0048', '', '1.000', '2530.00000', '2530.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '26', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '27', '0038', '', '1.000', '520.00000', '520.00', '', null, null, '0', null, '505.123', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '28', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '29', '0035', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1896.976', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '30', '0048', '', '2.000', '2520.00000', '5040.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '31', '0048', '', '2.000', '2520.00000', '5040.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '32', '0036', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1874.458', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '33', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '34', '0007', '', '1.000', '660.00000', '660.00', '', null, null, '0', null, '646.071', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '35', '0048', '', '2.000', '2520.00000', '5040.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '36', '0108', '', '1.000', '660.00000', '660.00', '', null, null, '0', null, '637.000', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '37', '0034', '', '1.000', '1850.00000', '1850.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '38', '0199', '', '1.000', '3250.00000', '3250.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '39', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '40', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '41', '0219', '', '1.000', '3100.00000', '3100.00', '', null, null, '0', null, '3053.160', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '42', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '43', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '44', '0048', '', '1.000', '2520.00000', '2520.00', '', null, null, '0', null, '2604.883', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '45', '0034', '', '1.000', '1870.00000', '1870.00', '', null, null, '0', null, '1857.081', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080104', '46', '0086', '', '1.000', '620.00000', '620.00', '', null, null, '0', null, '567.860', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '18', '0009', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1543.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '17', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '16', '0009', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1543.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '15', '0166', '', '1.000', '1520.00000', '1520.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '19', '0009', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1543.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '20', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '21', '0023', '', '1.000', '1860.00000', '1860.00', '', null, null, '0', null, '1877.114', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '22', '0001', '', '1.000', '820.00000', '820.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '23', '0033', '', '1.000', '630.00000', '630.00', '', null, null, '0', null, '596.852', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '24', '0036', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '25', '0057', '', '1.000', '850.00000', '850.00', '', null, null, '0', null, '793.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '26', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '27', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '28', '0237', '', '1.000', '600.00000', '600.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '29', '0065', '', '1.000', '1480.00000', '1480.00', '', null, null, '0', null, '1433.053', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '30', '0009', '', '1.000', '1650.00000', '1650.00', '', null, null, '0', null, '1543.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '31', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1279.713', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '32', '0085', '', '1.000', '2800.00000', '2800.00', '', null, null, '0', null, '2267.150', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '33', '0054', '', '1.000', '1600.00000', '1600.00', '', null, null, '0', null, '1344.691', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '34', '0057', '', '1.000', '850.00000', '850.00', '', null, null, '0', null, '793.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '35', '0034', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '36', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '37', '0179', '', '1.000', '3120.00000', '3120.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '38', '0043', '', '1.000', '70.00000', '70.00', '', null, null, '0', null, '48.161', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '39', '0007', '', '1.000', '670.00000', '670.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '40', '0048', '', '2.000', '2590.00000', '5180.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '41', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '42', '0007', '', '1.000', '680.00000', '680.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '43', '0043', '', '1.000', '50.00000', '50.00', '', null, null, '0', null, '48.161', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '44', '0007', '', '1.000', '680.00000', '680.00', '', null, null, '0', null, '638.860', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '45', '0034', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '46', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '47', '0034', '4219', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '48', '0179', '', '1.000', '3120.00000', '3120.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '49', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '50', '0008', '', '1.000', '1340.00000', '1340.00', '', null, null, '0', null, '1279.713', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '51', '0065', '', '1.000', '1480.00000', '1480.00', '', null, null, '0', null, '1433.053', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '52', '0043', '', '1.000', '70.00000', '70.00', '', null, null, '0', null, '48.161', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '53', '0048', '', '2.000', '2530.00000', '5060.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '54', '0048', '', '2.000', '2530.00000', '5060.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '55', '0048', '', '4.000', '2530.00000', '10120.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '56', '0034', '', '11.000', '1870.00000', '20570.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '57', '0036', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '58', '0035', '', '2.000', '1890.00000', '3780.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '59', '0036', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '60', '0048', '', '1.000', '2530.00000', '2530.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '61', '0062', '', '8.000', '455.00000', '3640.00', '', null, null, '0', null, '433.016', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '62', '0016', '', '3.000', '800.00000', '2400.00', '', null, null, '0', null, '758.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '63', '0034', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '64', '0036', '', '1.000', '1880.00000', '1880.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '65', '0035', '', '1.000', '1900.00000', '1900.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '66', '0057', '', '1.000', '850.00000', '850.00', '', null, null, '0', null, '793.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080048', '67', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '1', '0048', '', '4.000', '2600.00000', '10400.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '2', '0034', '', '9.000', '1880.00000', '16920.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080049', '3', '0036', '', '2.000', '1880.00000', '3760.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080050', '1', '0179', '', '1.000', '3120.00000', '3120.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080050', '2', '0044', '', '1.000', '3910.00000', '3910.00', '', null, null, '0', null, '3521.800', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080050', '3', '0048', '', '1.000', '2600.00000', '2600.00', '', null, null, '0', null, '2465.453', null, '0.00', null, null, null, null, 'BT', '17', '0.000', '0.00', '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '32', '0034', '', '2.000', '1870.00000', '3740.00', '', null, null, '0', null, '1843.330', null, '0.00', null, null, null, null, 'KT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080051', '1', '0004', '', '2.000', '4700.00000', '9400.00', '', null, null, '0', null, '4877.700', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080051', '2', '0215', '', '6.000', '1900.00000', '11400.00', '', null, null, '0', null, '1721.500', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '1', '0034', '', '18.000', '1880.00000', '33840.00', '', null, null, '0', null, '1867.471', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '2', '0036', '', '5.000', '1880.00000', '9400.00', '', null, null, '0', null, '1883.869', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '3', '0035', '', '2.000', '1900.00000', '3800.00', '', null, null, '0', null, '1906.133', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '4', '0004', '', '2.000', '4800.00000', '9600.00', '', null, null, '0', null, '4877.700', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '5', '0215', '', '1.000', '2150.00000', '2150.00', '', null, null, '0', null, '1721.500', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080052', '6', '0238', '', '1.000', '1750.00000', '1750.00', '', null, null, '0', null, '1455.875', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080053', '1', '0001', '', '4.000', '820.00000', '3280.00', '', null, null, '0', null, '817.730', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080053', '2', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080053', '3', '0017', '', '1.000', '1530.00000', '1530.00', '', null, null, '0', null, '1426.878', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080055', '1', '0179', '', '3.000', '3120.00000', '9360.00', '', null, null, '0', null, '3037.000', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080055', '2', '0004', '', '4.000', '4750.00000', '19000.00', '', null, null, '0', null, '4877.700', null, '0.00', null, null, null, null, 'BT', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `sl_invoicedet` VALUES ('080143', '27', '0037', '', '1.000', '1890.00000', '1890.00', '', null,