DROP TABLE IF EXISTS acct_type;

CREATE TABLE `acct_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `debit_name` varchar(20) DEFAULT NULL,
  `credit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS am_condet;

CREATE TABLE `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS announcement;

CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS app_mod;

CREATE TABLE `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO app_mod VALUES("AC_CP","Cash Payment","Accounts","26","35","","CP");
INSERT INTO app_mod VALUES("AC_BP","Bank Payment","Accounts","26","35","","BP");
INSERT INTO app_mod VALUES("AC_CR","Cash Receipt","Accounts","26","35","","CR");
INSERT INTO app_mod VALUES("AC_BR","Bank Receipt","Accounts","26","35","","BR");
INSERT INTO app_mod VALUES("AC_JV","Journal Voucher","Accounts","35","35","","JV");
INSERT INTO app_mod VALUES("AC_CD","Outstanding Clearing Dates","Accounts","223","0","","");
INSERT INTO app_mod VALUES("PL_PO","Order","Purchases","226","53","t_pl_order","");
INSERT INTO app_mod VALUES("PL_GP","Inward Gate Pass","Purchases","226","235","t_pl_gp","");
INSERT INTO app_mod VALUES("PL_INV","Invoice","Purchases","226","235","t_pl_invoice","");
INSERT INTO app_mod VALUES("PL_PAY","Payments","Purchases","203","204","t_pl_pay","");
INSERT INTO app_mod VALUES("PL_JV","JV","Purchases","216","212","pl_jv","");
INSERT INTO app_mod VALUES("SL_GP","Inward Gate Pass","Sales","226","235","t_sl_gp","");
INSERT INTO app_mod VALUES("SL_INV","Invoice","Sales","226","235","t_sl_invoice","");
INSERT INTO app_mod VALUES("SL_RTN","Return","Sales","226","235","t_sl_return","");
INSERT INTO app_mod VALUES("SL_PAY","Payments","Sales","203","204","t_sl_pay","");
INSERT INTO app_mod VALUES("SL_JV","JV","Sales","216","212","sl_jv","");
INSERT INTO app_mod VALUES("SL_OB","Outstanding Bilties","Sales","221","260","","");
INSERT INTO app_mod VALUES("STK_PROD","Production","Stock","226","53","t_stk_con","Y");
INSERT INTO app_mod VALUES("STK_CON","Consumption","Stock","226","235","t_stk_con","N");
INSERT INTO app_mod VALUES("MF_NOM","Chart of Accounts","Master Files","164","0","","");
INSERT INTO app_mod VALUES("MF_PARTY","Parties","Master Files","66","0","","");
INSERT INTO app_mod VALUES("MF_ITEM","Items","Master Files","64","0","","");
INSERT INTO app_mod VALUES("MF_UNIT","Units","Master Files","106","0","","");
INSERT INTO app_mod VALUES("IM_BOE","Bill of Entry","Imports","226","235","t_im_boe","");


DROP TABLE IF EXISTS app_rep;

CREATE TABLE `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO app_rep VALUES("AC_10","Daybook","Accounts","144","");
INSERT INTO app_rep VALUES("AC_20","Ledger","Accounts","91","");
INSERT INTO app_rep VALUES("AC_31","Trial - Balance","Accounts","163","");
INSERT INTO app_rep VALUES("AC_32","Trial - Control","Accounts","149","");
INSERT INTO app_rep VALUES("AC_33","Trial - Subsidary","Accounts","149","");
INSERT INTO app_rep VALUES("AC_40","Profit & Loss","Accounts","190","");
INSERT INTO app_rep VALUES("AC_50","Profit & Loss (Level 2)","Accounts","191","");
INSERT INTO app_rep VALUES("PL_10","Purchase Daybook","Purchases","187","PL");
INSERT INTO app_rep VALUES("PL_20","Payment Daybook","Purchases","187","PP");
INSERT INTO app_rep VALUES("PL_30","Detail Ledger","Purchases","405","S");
INSERT INTO app_rep VALUES("PL_40","Trial","Purchases","194","S");
INSERT INTO app_rep VALUES("PL_50","Summary","Purchases","188","S");
INSERT INTO app_rep VALUES("SL_10","Sale Daybook","Sales","187","SL");
INSERT INTO app_rep VALUES("SL_20","Sale Receipts","Sales","187","SR");
INSERT INTO app_rep VALUES("SL_30","Detail Ledger","Sales","405","C");
INSERT INTO app_rep VALUES("SL_40","Trial","Sales","194","C");
INSERT INTO app_rep VALUES("SL_50","Summary","Sales","188","C");
INSERT INTO app_rep VALUES("SL_60","Empty Stock Report","Sales","406","");
INSERT INTO app_rep VALUES("SL_70","Empty Stock Report Rate Wise","Sales","407","");
INSERT INTO app_rep VALUES("SL_80","Outstanding Bills","Sales","189","");
INSERT INTO app_rep VALUES("SL_90","SPO Outstanding","Sales","195","");
INSERT INTO app_rep VALUES("STK_10","Ledger","Stocks","401","");
INSERT INTO app_rep VALUES("STK_20","Summary","Stocks","402","");
INSERT INTO app_rep VALUES("STK_30","Summary - Value","Stocks","403","");


DROP TABLE IF EXISTS bill_type;

CREATE TABLE `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO bill_type VALUES("0001","Normal","");
INSERT INTO bill_type VALUES("0002","Exchange","");
INSERT INTO bill_type VALUES("0003","VIP","");
INSERT INTO bill_type VALUES("0004","Sale Return","");


DROP TABLE IF EXISTS brands;

CREATE TABLE `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO brands VALUES("0001","APC");
INSERT INTO brands VALUES("0002","MGE UPS Systems");
INSERT INTO brands VALUES("0003","Stulz Air Conditioning");
INSERT INTO brands VALUES("0004","Bergvik Flooring");
INSERT INTO brands VALUES("0005","APC / MGE UPS Systems");
INSERT INTO brands VALUES("0006","APC / MGE");


DROP TABLE IF EXISTS city;

CREATE TABLE `city` (
  `CITY_ID` varchar(2) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`CITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO city VALUES("10","LAHORE","3801101001");


DROP TABLE IF EXISTS closing_dates;

CREATE TABLE `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL,
  PRIMARY KEY (`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO closing_dates VALUES("BP","2003-12-31 00:00:00");


DROP TABLE IF EXISTS code_cat;

CREATE TABLE `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO code_cat VALUES("00","KURTA");
INSERT INTO code_cat VALUES("01","SHALWAR");
INSERT INTO code_cat VALUES("02","TROUSER");
INSERT INTO code_cat VALUES("03","KHUSSA
\n");
INSERT INTO code_cat VALUES("04","WAIST COAT
\n");
INSERT INTO code_cat VALUES("05","NIGHT SUIT");
INSERT INTO code_cat VALUES("06","FULL SUIT");
INSERT INTO code_cat VALUES("07","COAT");
INSERT INTO code_cat VALUES("08","FOOTWEAR
\n");
INSERT INTO code_cat VALUES("09","SHIRT
\n");
INSERT INTO code_cat VALUES("10","SHERWANI
\n");
INSERT INTO code_cat VALUES("11","TURBON
\n");
INSERT INTO code_cat VALUES("12","SUITING
\n");
INSERT INTO code_cat VALUES("13","CAP");
INSERT INTO code_cat VALUES("14","ACCESSORIES");
INSERT INTO code_cat VALUES("15","SHAWL");


DROP TABLE IF EXISTS code_collection;

CREATE TABLE `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO code_collection VALUES("SK","MEN");
INSERT INTO code_collection VALUES("SG","GOLD");
INSERT INTO code_collection VALUES("SD","DESIGNER
\n");


DROP TABLE IF EXISTS color;

CREATE TABLE `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO color VALUES("PU","PURPLE");
INSERT INTO color VALUES("OW","OFF WHITE");
INSERT INTO color VALUES("BL","BLACK");
INSERT INTO color VALUES("SN","SKIN");
INSERT INTO color VALUES("GO","GOLDEN");
INSERT INTO color VALUES("BR","BROWN");
INSERT INTO color VALUES("MD","MUD");
INSERT INTO color VALUES("SG","SEA GREEN");
INSERT INTO color VALUES("MR","MAROON");
INSERT INTO color VALUES("MV","MOUVE");
INSERT INTO color VALUES("GR","GREEN");
INSERT INTO color VALUES("MU","MUSTARD");
INSERT INTO color VALUES("WH","WHITE");
INSERT INTO color VALUES("GY","GREY");
INSERT INTO color VALUES("DG","DARK GREEN");
INSERT INTO color VALUES("LG","LIGHT GREEN");
INSERT INTO color VALUES("BU","BLUE");
INSERT INTO color VALUES("GB","GREEN BLUE");
INSERT INTO color VALUES("OR","ORANGE");
INSERT INTO color VALUES("PH","PEACH");
INSERT INTO color VALUES("RS","RUST");
INSERT INTO color VALUES("DB","DARK BLUE");
INSERT INTO color VALUES("LY","LIGHT GREY");
INSERT INTO color VALUES("SB","SKY BLUE");
INSERT INTO color VALUES("FN","FORN");
INSERT INTO color VALUES("CB","CHOCOLATE BROWN");
INSERT INTO color VALUES("NB","NAVY BLUE");
INSERT INTO color VALUES("YB","GREY BLACK");
INSERT INTO color VALUES("GS","GREY SHINING");
INSERT INTO color VALUES("FR","FEROOZI");
INSERT INTO color VALUES("RD","RED");
INSERT INTO color VALUES("LR","LIGHT BROWN");
INSERT INTO color VALUES("LB","LIGHT BLUE");
INSERT INTO color VALUES("CM","CAMEL");
INSERT INTO color VALUES("CH","CHOCOLATE");
INSERT INTO color VALUES("BG","BLACK GREY");
INSERT INTO color VALUES("AR","ARMY");
INSERT INTO color VALUES("MT","MULTI COLOUR");


DROP TABLE IF EXISTS company;

CREATE TABLE `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO company VALUES("01","New Malik Traders","E-109/3, Main Boulevard, DHA, Lahore,","04236666726 / 04236621112","","","","","","Y","0600030001","","","","","BK","UGX","","","2210000001","3010000001","0700010001","","0100011000","A","401","N","","0600030001","0700020001","0700030001","0","0");


DROP TABLE IF EXISTS container_size;

CREATE TABLE `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO container_size VALUES("0001","16 Feet");
INSERT INTO container_size VALUES("0002","20 Feet");
INSERT INTO container_size VALUES("0003","22 Feet");
INSERT INTO container_size VALUES("0004","24 Feet");
INSERT INTO container_size VALUES("0005","40 Feet");
INSERT INTO container_size VALUES("0006","50 Feet");


DROP TABLE IF EXISTS currency;

CREATE TABLE `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO currency VALUES("PK","PKR");


DROP TABLE IF EXISTS dc_type;

CREATE TABLE `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO dc_type VALUES("01","Sale");


DROP TABLE IF EXISTS discount;

CREATE TABLE `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS discount_percentage;

CREATE TABLE `discount_percentage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS discount_voucher;

CREATE TABLE `discount_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS division;

CREATE TABLE `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO division VALUES("10","TEXTILE");


DROP TABLE IF EXISTS expense;

CREATE TABLE `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO expense VALUES("01","L/C EXPENSES");


DROP TABLE IF EXISTS fin_years;

CREATE TABLE `fin_years` (
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  PRIMARY KEY (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO fin_years VALUES("17","2017","2017-01-01","2017-06-30");


DROP TABLE IF EXISTS grn;

CREATE TABLE `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grn_return;

CREATE TABLE `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grn_returndet;

CREATE TABLE `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grndet;

CREATE TABLE `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS im_boe;

CREATE TABLE `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS im_boedet;

CREATE TABLE `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS invoice_no;

CREATE TABLE `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO invoice_no VALUES("1","SL","06");
INSERT INTO invoice_no VALUES("2","SL","06");


DROP TABLE IF EXISTS item;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  `brand_id` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`) USING BTREE,
  KEY `item_fk_brand_id` (`brand_id`) USING BTREE,
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`brand_id`) REFERENCES `prod_brand` (`BRAND_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=18655 DEFAULT CHARSET=latin1;

INSERT INTO item VALUES("18592","0001","BAROZA TIN","","","TIN","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","1100.00","01");
INSERT INTO item VALUES("18593","0003","BAROZA INDONESIA DRU","0.000","","DRU","0.00","0","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","13920.00","01");
INSERT INTO item VALUES("18594","0004","BAZOIC ACID NOS","","","NOS","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18595","0005","BAROZA CHINA DRU","0.000","","DRU","0.00","0","","","01","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","13920.00","01");
INSERT INTO item VALUES("18596","0006","OIL TARPIN LIT","","","LIT","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","70.00","01");
INSERT INTO item VALUES("18597","0008","CHOONA BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","170.00","01");
INSERT INTO item VALUES("18598","0009","MICRO VACCINE CAR","","","CAR","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","3800.00","01");
INSERT INTO item VALUES("18599","0010","TRIPAL PRESS BAG BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","1980.00","01");
INSERT INTO item VALUES("18600","0011","STERIC BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","1100.00","01");
INSERT INTO item VALUES("18601","0012","GLYCRINE DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","1600.00","01");
INSERT INTO item VALUES("18602","0013","TORA MOOAM PAKISTANI TOR","0.000","","TOR","0.00","0","","","02","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","1100.00","01");
INSERT INTO item VALUES("18603","0014","MOOAM CHAINA BAG","0.000","","BAG","0.00","0","","","02","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","3400.00","01");
INSERT INTO item VALUES("18604","0015","MOOAM HUNGRY CAR","","","CAR","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","2300.00","01");
INSERT INTO item VALUES("18605","0016","MOOAM IRANI KG","","","KG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","5750.00","01");
INSERT INTO item VALUES("18606","0017","MOOAM IRANI DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18607","0018","MOOAM TAIWAN CAR","0.000","","CAR","0.00","0","","","02","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18608","0019","BROAZA VIETNAM DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18609","0020","CARTON STERIC T.P KG","","","KG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18610","0021","TORA BROZA INDONESIA TOR","","","TOR","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18611","0022","N P 9 DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18612","0023","CAUSTIC POTASH BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18613","0024","DANA WAX KG","","","KG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","165.00","01");
INSERT INTO item VALUES("18614","0025","SOUP NODLE BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18615","0026","PHATKARI NOS","","","NOS","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18616","0028","CARNOBA WAX KG","","","KG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18617","0029","SULPHONIC  INDIA DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18618","0030","SODA ASH BAG","0.000","","BAG","0.00","0","","","03","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18619","0031","SULPHONIC MIWON DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18620","0032","CAUSTIC PATRI BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18621","0033","STARCH BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18622","0034","SULPHONIC LG DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18623","0035","RASIN BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18624","0036","MOOM PAKISTANI DRUM NOS","","","NOS","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18625","0037","SULPHONIC CHINA DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18626","0038","WHITE OIL DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18627","0039","SULPHONIC MISRI DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18628","0040","LATEX RUBBER DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18629","0041","SURF BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18630","0042","SULPHONIC IRANI DRUM DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18631","0043","VASELINE DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18632","0044","MITHA SODA BAG","","","BAG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18633","0045","MICRO WAX KG","","","KG","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18634","0046","MALEIC NOS","","","NOS","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18635","0047","SULPHONIC TUFAIL DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18636","0048","BROZA INDIA DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18637","0049","SHEARS NOS","","","NOS","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18638","0050","MOOAM CHAINA CAR","","","CAR","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");
INSERT INTO item VALUES("18639","0051","SHAMPOO BASE DRU","","","DRU","","","","","99","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","0.00","01");


DROP TABLE IF EXISTS item_description;

CREATE TABLE `item_description` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS location;

CREATE TABLE `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO location VALUES("01","Main Store","245/1/1 Tufail Road, Lahore, Cantt.","Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com","03-00-2974-683-13","2974683-3","245/1/1 Tufail Road, Lahore.","","","on","on");
INSERT INTO location VALUES("02","Store","","","","","","","","","on");
INSERT INTO location VALUES("03","Display Center","","","","","","","","","on");


DROP TABLE IF EXISTS locations;

CREATE TABLE `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO locations VALUES("01","Main Store");


DROP TABLE IF EXISTS lots;

CREATE TABLE `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS menu;

CREATE TABLE `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO menu VALUES("1","Sale","");
INSERT INTO menu VALUES("1.1","Invoice","show_sale_invoice?voucher_type=SL&posted=\'\'");
INSERT INTO menu VALUES("1.2","Order","show_sale_invoice?voucher_type=SO&posted=\'\'");
INSERT INTO menu VALUES("1.3","Sale Delivery Challan","show_sale_invoice?voucher_type=DC&posted=\'\'");
INSERT INTO menu VALUES("1.4","Outword Gate pass","show_sale_invoice?voucher_type=OG&posted=\'\'");
INSERT INTO menu VALUES("1.5","Receipts","show_payments?voucher_type=SR&posted=\'\'");
INSERT INTO menu VALUES("1.6","Journal","show_pay_jv?voucher_type=SJ&posted=\'\'");
INSERT INTO menu VALUES("1.7","Sale Invoice","sl_inv?voucher_type=SL");
INSERT INTO menu VALUES("2","Purchase","");
INSERT INTO menu VALUES("2.1","Invoice","show_sale_invoice?voucher_type=PL&posted=\'\'");
INSERT INTO menu VALUES("2.2","Order","show_sale_invoice?voucher_type=PO&posted=\'\'");
INSERT INTO menu VALUES("2.3","Inward Gate pass","show_sale_invoice?voucher_type=IG&posted=\'\'");
INSERT INTO menu VALUES("2.4","Payments","show_payments?voucher_type=PP&posted=\'\'");
INSERT INTO menu VALUES("2.5","Journal","show_pay_jv?voucher_type=PJ&posted=\'\'");
INSERT INTO menu VALUES("3","Accounts","");
INSERT INTO menu VALUES("3.1","Payments","");
INSERT INTO menu VALUES("4","Stock","");
INSERT INTO menu VALUES("4.1","Production","show_production?voucher_type=FG&posted=\'\'");
INSERT INTO menu VALUES("4.2","Consumption","");
INSERT INTO menu VALUES("5","Master File","");
INSERT INTO menu VALUES("5.1","Items","items");
INSERT INTO menu VALUES("5.2","Chart Of Accounts","chart_of_accounts");
INSERT INTO menu VALUES("6","Reports Summary","");
INSERT INTO menu VALUES("6.1","Sale Summary","rpt_sale_summary?stock_summary=SL");
INSERT INTO menu VALUES("6.2","Stock Summary","rpt_sale_summary?stock_summary=FG");
INSERT INTO menu VALUES("6.3","Outword Gate pass Summary","rpt_sale_summary?stock_summary=OG");
INSERT INTO menu VALUES("6.4","Sale Order Summary","rpt_sale_summary?stock_summary=SO");
INSERT INTO menu VALUES("6.5","Purchase Summary","rpt_sale_summary?stock_summary=PL");
INSERT INTO menu VALUES("6.6","Purchase Order Summary","rpt_sale_summary?stock_summary=PO");
INSERT INTO menu VALUES("6.7","Purchase InwordGatepass Summary","rpt_sale_summary?stock_summary=IG");
INSERT INTO menu VALUES("7","Reports Detail","");
INSERT INTO menu VALUES("7.1","Sale Report","rpt_sale?detail=SL");
INSERT INTO menu VALUES("7.2","Sale Order","rpt_sale?detail=SO");
INSERT INTO menu VALUES("7.3","Outword Gatepass","rpt_sale?detail=OG");
INSERT INTO menu VALUES("7.4","WareHouse Stock","rpt_sale?detail=FG");
INSERT INTO menu VALUES("7.5","Purchase Invoice","rpt_sale?detail=PL");
INSERT INTO menu VALUES("7.6","Inword Gatepass","rpt_sale?detail=IG");
INSERT INTO menu VALUES("7.7","Stock Ledger","stock_ledger");
INSERT INTO menu VALUES("8","Reports Accounts","");
INSERT INTO menu VALUES("8.1","Ledgers","ledger");
INSERT INTO menu VALUES("8.2","Day Book","daybook");
INSERT INTO menu VALUES("9","Reports","");
INSERT INTO menu VALUES("9.1","Sale Report","rpt_sale");
INSERT INTO menu VALUES("9.2","Gatepass Outword Report","rpt_gpout");
INSERT INTO menu VALUES("9.3","Current Stock","rpt_current_stock");


DROP TABLE IF EXISTS ms_sale;

CREATE TABLE `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS nom;

CREATE TABLE `nom` (
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_NAME` char(50) NOT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `ACCT_TYPE` varchar(4) DEFAULT NULL,
  `FS_TYPE` varchar(1) DEFAULT NULL,
  `SUB` varchar(1) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `TEST_NAME` char(50) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO nom VALUES("01","EQUITY","","0","","","","","","","");
INSERT INTO nom VALUES("010001","PROPRIETOR\'S CAPITAL","","3101","","","","","","","");
INSERT INTO nom VALUES("0100010005","MAQSOODA MALIK","","3101","","","","","","","");
INSERT INTO nom VALUES("010002","UNPAPPROPRIATED B/F","","3601","","","","","","","");
INSERT INTO nom VALUES("010003","RSERVES","","3520","","","","","","","");
INSERT INTO nom VALUES("010004","SURPLUS","","3701","","","","","","","");
INSERT INTO nom VALUES("02","SHORT TERM ADVANCES","","0","","","","","","","");
INSERT INTO nom VALUES("020001","ADVANCE TO STAFF","","1901","","","","","","","");
INSERT INTO nom VALUES("0200010001","ADVANCE TO MR.SAEED AKBAR","","1901","","","","","","","");
INSERT INTO nom VALUES("020002","IMPREST TO STAFF","","1901","","","","","","","");
INSERT INTO nom VALUES("0200020001","IMPREST TO MR.NAEEM UR RAHMAN QURESHI","","1901","","","","","","","");
INSERT INTO nom VALUES("020003","SHARE HOLDERS","","1901","","","","","","","");
INSERT INTO nom VALUES("0200030001","MR.MIAN MUTTAHER SHAFIQUE","","1901","","","","","","","");
INSERT INTO nom VALUES("020004","OTHERS","","1901","","","","","","","");
INSERT INTO nom VALUES("0200040001","ALPE SPA,ITALY","","1901","","","","","","","");
INSERT INTO nom VALUES("020005","YTS EMPLOYEES","","1901","","","","","","","");
INSERT INTO nom VALUES("0200050001","MR.SHAFAQUAT","","1901","","","","","","","");
INSERT INTO nom VALUES("020006","FACTORY EMPLOYEES","","1901","","","","","","","");
INSERT INTO nom VALUES("0200060001","MR.NAVEED FACTORY EMPLOYEE","","1901","","","","","","","");
INSERT INTO nom VALUES("06","SHORT TERM LOANS","","0","","","","","","","");
INSERT INTO nom VALUES("060001","SHARE HOLDERS","","2801","","","","","","","");
INSERT INTO nom VALUES("0600010001","MST.FAZILAT JABEEN SAHIBAH","","2801","","","","","","","");
INSERT INTO nom VALUES("060002","OTHERS","","2801","","","","","","","");
INSERT INTO nom VALUES("0600020001","AHMAD MONEY CHANGERS","","2801","","","","","","","");
INSERT INTO nom VALUES("060003","OTHER LONG TERM","","2801","","","","","","","");
INSERT INTO nom VALUES("08","AGENTS","","0","","","","","","","");
INSERT INTO nom VALUES("080001","CLEARING AGENTS","","2801","","","","","","","");
INSERT INTO nom VALUES("0800010001","AL-HASSAN CARGO, LAHORE","","2801","","","","","","","");
INSERT INTO nom VALUES("080002","OTHERS","","2801","","","","","","","");
INSERT INTO nom VALUES("0800020001","MR.TAUSEEFUDDIN HAIDER","","2801","","","","","","","");
INSERT INTO nom VALUES("0800020002","MR.SH.M.DAWOOD, SAHIWAL","","2801","","","","","","","");
INSERT INTO nom VALUES("09","ACCRUED & OTHER LIABILITIES","","0","","","","","","","");
INSERT INTO nom VALUES("090000","CREDIT CARDS","","2801","","","","","","","");
INSERT INTO nom VALUES("0900000003","UNION BANK VISA GOLD CARD","","2801","","","","","","","");
INSERT INTO nom VALUES("0900000004","CITIBANK CREDIT CARD","","2801","","","","","","","");
INSERT INTO nom VALUES("0900000005","STANDARD CHARTERED CREDIT CARD","","2801","","","","","","","");
INSERT INTO nom VALUES("0900000006","BANK AL-FALAH CREDIT CARD","","2801","","","","","","","");
INSERT INTO nom VALUES("090001","TAXES PAYABLE","","2801","","","","","","","");
INSERT INTO nom VALUES("0900010001","SALES TAX A/C","","2801","","","","","","","");
INSERT INTO nom VALUES("0900010002","INCOME TAX","","2801","","","","","","","");
INSERT INTO nom VALUES("10","STOCKS","","0","","","","","","","");
INSERT INTO nom VALUES("100000","STOCK IN TRADE","","1901","","","","","","","");
INSERT INTO nom VALUES("1000000001","STOCK IN TRADE CONTROL A/C","","1901","","","","","","","");
INSERT INTO nom VALUES("11","CURRENT PORTION OF LONG TERM LOANS","","0","","","","","","","");
INSERT INTO nom VALUES("110001","BANKS","","2801","","","","","","","");
INSERT INTO nom VALUES("110002","DIRECTORS","","2801","","","","","","","");
INSERT INTO nom VALUES("110003","PRIVATE","","2899","","","","","","","");
INSERT INTO nom VALUES("110004","EMPTY","","2801","","","","","","","");
INSERT INTO nom VALUES("12","CREDITORS","","0","","","","","","","");
INSERT INTO nom VALUES("120001","CREDITORS","","2802","","","","","","","");
INSERT INTO nom VALUES("1200010002","MOHAMMAD SHABBIR MALIK","","2802","","","","","","","");
INSERT INTO nom VALUES("120002","ACCRUED EXPENSES","","2802","","","","","","","");
INSERT INTO nom VALUES("13","ADMIN & GENERAL EXPENSES","","0","","","","","","","");
INSERT INTO nom VALUES("130001","TRAVELLING & CONVEYANCE","","6101","","","","","","","");
INSERT INTO nom VALUES("1300010001","TRAVELLING EXP. MURREE","","6101","","","","","","","");
INSERT INTO nom VALUES("130010","BUILDING REPAIR","","6101","","","","","","","");
INSERT INTO nom VALUES("1310000153","SHAN TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("1310000220","AL-HARAM PETROLEUM","","","","","","","","","");
INSERT INTO nom VALUES("1310000244","KHALID & SONS KARACHI - 490","","","","","","","","","");
INSERT INTO nom VALUES("1310000259","HARIS TRADERS TEZAB MARKET","","","","","","","","","");
INSERT INTO nom VALUES("136000","OFFICE EQUIPMENTS REPAIR","","6101","","","","","","","");
INSERT INTO nom VALUES("1360000002","GENERAL REPAIR & MAINTENANCE","","6101","","","","","","","");
INSERT INTO nom VALUES("137000","PRINTING & STATIONERY","","6101","","","","","","","");
INSERT INTO nom VALUES("1370000000","STATIONERY EXP.","","6101","","","","","","","");
INSERT INTO nom VALUES("1370000002","PRINTING EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("138001","ELECT","","6101","","","","","","","");
INSERT INTO nom VALUES("138002","SUI GAS BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380020001","SUI GAS BILLS LHR OFFICE","","6101","","","","","","","");
INSERT INTO nom VALUES("138003","WATER","","6101","","","","","","","");
INSERT INTO nom VALUES("138004","OFFICE MESS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380040001","LAHORE  OFFICE MESS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380040002","KASUR OFFICE MESS","","6101","","","","","","","");
INSERT INTO nom VALUES("138005","TELEPHONE","","6101","","","","","","","");
INSERT INTO nom VALUES("138006","ENTERTAINMENT","","6101","","","","","","","");
INSERT INTO nom VALUES("1380060001","ENTERTAINMENT","","6101","","","","","","","");
INSERT INTO nom VALUES("138007","POSTAGE & COURIERS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380070001","POSTAGE EXP.BY LAHORE OFFICE","","6101","","","","","","","");
INSERT INTO nom VALUES("1380070002","POSTAGE EXP.BY KASUR OFFICE","","6101","","","","","","","");
INSERT INTO nom VALUES("138008","VEHICLES RUNNING","","6101","","","","","","","");
INSERT INTO nom VALUES("1380080001","FUEL LXZ-223","","6101","","","","","","","");
INSERT INTO nom VALUES("1380080002","PETROL LRZ-272","","6101","","","","","","","");
INSERT INTO nom VALUES("138009","VEHICLES REPAIR & MAINTENANCE","","6101","","","","","","","");
INSERT INTO nom VALUES("1380090001","REPAIR LXZ-223","","6101","","","","","","","");
INSERT INTO nom VALUES("1380090002","REPAIR LRZ-272","","6101","","","","","","","");
INSERT INTO nom VALUES("1380090003","REPAIR LOZ-967","","6101","","","","","","","");
INSERT INTO nom VALUES("1380090004","REPAIR LXE-5113","","6101","","","","","","","");
INSERT INTO nom VALUES("1380090005","REPAIR MOTORCYCLE","","6101","","","","","","","");
INSERT INTO nom VALUES("1380090006","REPAIR BICYCLE","","6101","","","","","","","");
INSERT INTO nom VALUES("138010","FEES & SUBSCRIPTIONS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380100001","FEES & SUBSCRIPTION","","6101","","","","","","","");
INSERT INTO nom VALUES("1380100002","ASK","","6101","","","","","","","");
INSERT INTO nom VALUES("1380100003","ZAKAT","","6101","","","","","","","");
INSERT INTO nom VALUES("1380100004","LEGAL EXPENCES","","6101","","","","","","","");
INSERT INTO nom VALUES("138011","UTILITY BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380110001","UTILITY BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380110002","ELECTRICITY BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380110003","WATER BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380110004","TELEPONE BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380110005","MOBILE BILLS","","6101","","","","","","","");
INSERT INTO nom VALUES("138012","RENT & BUILDING","","6101","","","","","","","");
INSERT INTO nom VALUES("1380120001","SHOP RENT","","6101","","","","","","","");
INSERT INTO nom VALUES("1380120002","RENT SHAH MUHAMMAD GHAOS","","6101","","","","","","","");
INSERT INTO nom VALUES("1380120003","RENT NEW MALIK TRADER - 838","","6101","","","","","","","");
INSERT INTO nom VALUES("1380120004","RENT OFFICE NO-9","","6101","","","","","","","");
INSERT INTO nom VALUES("138013","MIS. EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("1380130001","MIS. EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("1380130002","MIS.ROUTINE EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("138014","WELFARE A/C","","6101","","","","","","","");
INSERT INTO nom VALUES("1380140001","KHAIRAT KHATA","","6101","","","","","","","");
INSERT INTO nom VALUES("1380140002","DONATION TO MOSQUE","","6101","","","","","","","");
INSERT INTO nom VALUES("1380140003","MIS. ZAKAT KHATA","","6101","","","","","","","");
INSERT INTO nom VALUES("21","FIXED ASSETS - COST","","0","","","","","","","");
INSERT INTO nom VALUES("210001","LAND","","1101","","","","","","","");
INSERT INTO nom VALUES("210002","BUILDINGS","","1101","","","","","","","");
INSERT INTO nom VALUES("2100020001","PASARI HOUSE KASUR","","1101","","","","","","","");
INSERT INTO nom VALUES("210003","FURNITURE FIXTURE","","1101","","","","","","","");
INSERT INTO nom VALUES("2100030001","OFFICE FURNITURE - OWN","","1101","","","","","","","");
INSERT INTO nom VALUES("210004","OFFICE EQUIPMENT","","1101","","","","","","","");
INSERT INTO nom VALUES("2100040001","OFFICE EQUIPMENTS (ELECTRONIC & OTHER)","","1101","","","","","","","");
INSERT INTO nom VALUES("210005","VEHICLES","","1101","","","","","","","");
INSERT INTO nom VALUES("2100050001","VEHICLES","","1101","","","","","","","");
INSERT INTO nom VALUES("210006","LEASE VEHICLES","","1101","","","","","","","");
INSERT INTO nom VALUES("22","ASSETS SUBJECT TO FINANCE LEASE","","0","","","","","","","");
INSERT INTO nom VALUES("220001","FURNITER","","1101","","","","","","","");
INSERT INTO nom VALUES("220002","VEHICLES","","1101","","","","","","","");
INSERT INTO nom VALUES("25","CAPITAL WORKS IN PROGRESS","","0","","","","","","","");
INSERT INTO nom VALUES("26","LONG TERM INVESTMENT","","0","","","","","","","");
INSERT INTO nom VALUES("260001","INVESTMENT A/C (NASIR IQBAL)","","1401","","","","","","","");
INSERT INTO nom VALUES("261000","TRADE DEBTORS/CREDITORS","","1902","","","","","","","");
INSERT INTO nom VALUES("2610000001","NOOR TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000002","AKBAR BROTHERS - 80","","","","","","","","","");
INSERT INTO nom VALUES("2610000003","M T STOCK EXCHANGE - 570","","","","","","","","","");
INSERT INTO nom VALUES("2610000004","AHMAD TARIQ","","","","","","","","","");
INSERT INTO nom VALUES("2610000005","KHALI DRUM KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000006","SUN TRADRES - 734","","","","","","","","","");
INSERT INTO nom VALUES("2610000007","SALE TAX KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000008","SETH KHALID","","","","","","","","","");
INSERT INTO nom VALUES("2610000009","SHAN TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000010","FAISAL GENERAL STORE - 286","","","","","","","","","");
INSERT INTO nom VALUES("2610000011","KARIM KHAN PINDI - 470","","","","","","","","","");
INSERT INTO nom VALUES("2610000012","NAFA NUKSAN KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000013","HAJI MUHAMMAD RAFI SAB","","","","","","","","","");
INSERT INTO nom VALUES("2610000014","MUHAMMAD FARHAT SAB MOAM WALAY","","","","","","","","","");
INSERT INTO nom VALUES("2610000015","MODERN OIL TRADERS - 584","","","","","","","","","");
INSERT INTO nom VALUES("2610000016","MAHAM TRADERS - 61","","","","","","","","","");
INSERT INTO nom VALUES("2610000017","H S NOOR UD DIN TEXTILE MILL - 424","","","","","","","","","");
INSERT INTO nom VALUES("2610000018","ABC TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000019","FK PVC PIPE","","","","","","","","","");
INSERT INTO nom VALUES("2610000021","AYAZ RAHIM GULL","","","","","","","","","");
INSERT INTO nom VALUES("2610000022","ASHRAF UD DIN","","","","","","","","","");
INSERT INTO nom VALUES("2610000023","ASIA PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000024","AMNA BELTING - 124","","","","","","","","","");
INSERT INTO nom VALUES("2610000027","ASIF TRADERS - 16","","","","","","","","","");
INSERT INTO nom VALUES("2610000028","AL QAZI ENTERPRIZES","","","","","","","","","");
INSERT INTO nom VALUES("2610000029","AKAMAL SHAHZAD - 901","","","","","","","","","");
INSERT INTO nom VALUES("2610000030","HAJI ASGHAR - 96","","","","","","","","","");
INSERT INTO nom VALUES("2610000031","ALLIED INDUSTRIES - 37","","","","","","","","","");
INSERT INTO nom VALUES("2610000032","AL REHMAN TRADERS - 116","","","","","","","","","");
INSERT INTO nom VALUES("2610000033","RAJA BASHIR","","","","","","","","","");
INSERT INTO nom VALUES("2610000034","HAJII BASHIR - 230","","","","","","","","","");
INSERT INTO nom VALUES("2610000035","PAKISTAN VARNISH","","","","","","","","","");
INSERT INTO nom VALUES("2610000036","PARVEZ","","","","","","","","","");
INSERT INTO nom VALUES("2610000037","PARVEZ IQBAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000038","HAQ CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000039","KHALID GUL AUTOS 435","","","","","","","","","");
INSERT INTO nom VALUES("2610000040","KHADAM HUSSAIN - 460","","","","","","","","","");
INSERT INTO nom VALUES("2610000041","DAWOOD YAMAHA - 223","","","","","","","","","");
INSERT INTO nom VALUES("2610000042","B TOWNS","","","","","","","","","");
INSERT INTO nom VALUES("2610000043","PAJI ALLOUDIN","","","","","","","","","");
INSERT INTO nom VALUES("2610000044","PAK CANDLE WORKS - 668","","","","","","","","","");
INSERT INTO nom VALUES("2610000045","POLI MAR INDUSTRIES - 685","","","","","","","","","");
INSERT INTO nom VALUES("2610000046","PETRO WORKS INTERNATIONAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000047","BABA TAJ DIN","","","","","","","","","");
INSERT INTO nom VALUES("2610000049","HAJI AND COMPANY KISSAN STREET - 887","","","","","","","","","");
INSERT INTO nom VALUES("2610000050","DECENT PAINT - 218","","","","","","","","","");
INSERT INTO nom VALUES("2610000051","W S TRADRES","","","","","","","","","");
INSERT INTO nom VALUES("2610000053","RAFAQAT MULAZIM","","","","","","","","","");
INSERT INTO nom VALUES("2610000054","RAZAQ LAKH WALA -57","","","","","","","","","");
INSERT INTO nom VALUES("2610000055","RASHID ALI - 722","","","","","","","","","");
INSERT INTO nom VALUES("2610000056","RAHIM CHEMICAL - 53","","","","","","","","","");
INSERT INTO nom VALUES("2610000057","SUNNY PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000058","HAJI SIRAJDIN POLISH WALAY - 775","","","","","","","","","");
INSERT INTO nom VALUES("2610000059","CAMY TEX","","","","","","","","","");
INSERT INTO nom VALUES("2610000060","SEIKO RUBBER INDUSTRIES - 768","","","","","","","","","");
INSERT INTO nom VALUES("2610000061","SULAIMAN G - 815","","","","","","","","","");
INSERT INTO nom VALUES("2610000062","SULTAN BASHIR - 740","","","","","","","","","");
INSERT INTO nom VALUES("2610000063","SARWER RUBBER INDUSTRIES 751","","","","","","","","","");
INSERT INTO nom VALUES("2610000064","SIGMA CHEMICAL - 756","","","","","","","","","");
INSERT INTO nom VALUES("2610000065","SHERAZ AHSAN CHEMICAL -761","","","","","","","","","");
INSERT INTO nom VALUES("2610000066","SHAHALAM CHEMICAL STORE- 173","","","","","","","","","");
INSERT INTO nom VALUES("2610000067","SHAHZAD ASLAM - 143","","","","","","","","","");
INSERT INTO nom VALUES("2610000068","ZIA TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000069","TAHIR DYING","","","","","","","","","");
INSERT INTO nom VALUES("2610000070","TAYAB MOM BATI WALAY - 360","","","","","","","","","");
INSERT INTO nom VALUES("2610000071","MUHAMMAD TARIQ","","","","","","","","","");
INSERT INTO nom VALUES("2610000072","MIAN ZAFAR AND CO.24","","","","","","","","","");
INSERT INTO nom VALUES("2610000073","IMRAN","","","","","","","","","");
INSERT INTO nom VALUES("2610000074","ABID PAINT GUJRANWALA - 48","","","","","","","","","");
INSERT INTO nom VALUES("2610000075","ASIM ENTERPRISES - 132","","","","","","","","","");
INSERT INTO nom VALUES("2610000076","ABBASI CHEMICAL STORE - 11","","","","","","","","","");
INSERT INTO nom VALUES("2610000077","ABDUL HAQ - 88","","","","","","","","","");
INSERT INTO nom VALUES("2610000079","ALI HASSAN - 218","","","","","","","","","");
INSERT INTO nom VALUES("2610000080","ARIF FOOTBAL MATERIAL STORE - 964","","","","","","","","","");
INSERT INTO nom VALUES("2610000081","ALI PRINTING - 90","","","","","","","","","");
INSERT INTO nom VALUES("2610000082","GHULAM ALI & SONS","","","","","","","","","");
INSERT INTO nom VALUES("2610000083","FAROOQ CANDLE - 356","","","","","","","","","");
INSERT INTO nom VALUES("2610000084","QADIRI PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000085","KARIM DAD KHAN","","","","","","","","","");
INSERT INTO nom VALUES("2610000087","GULSHAN SOAP FACTORY - 266","","","","","","","","","");
INSERT INTO nom VALUES("2610000089","CH LATIF","","","","","","","","","");
INSERT INTO nom VALUES("2610000090","LAL BUTT","","","","","","","","","");
INSERT INTO nom VALUES("2610000091","MASTER LATIF - 531","","","","","","","","","");
INSERT INTO nom VALUES("2610000093","M R TRADING - 595","","","","","","","","","");
INSERT INTO nom VALUES("2610000094","MALIK BROTHERS AIK MORIA PUL- 682","","","","","","","","","");
INSERT INTO nom VALUES("2610000095","MAHBOOB SHAH","","","","","","","","","");
INSERT INTO nom VALUES("2610000096","MODERN PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000097","MONAY SHAH","","","","","","","","","");
INSERT INTO nom VALUES("2610000098","MICO PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000099","MUHAMMAD SALEEM - 169","","","","","","","","","");
INSERT INTO nom VALUES("2610000100","MALIK WARNISH - 570","","","","","","","","","");
INSERT INTO nom VALUES("2610000101","MUHAMMAD HAMID MAHMOOD - 358","","","","","","","","","");
INSERT INTO nom VALUES("2610000102","MUHAMMAD JAMIL - 434","","","","","","","","","");
INSERT INTO nom VALUES("2610000103",".","","","","","","","","","");
INSERT INTO nom VALUES("2610000104","MALIK BASHIR AHMAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000107","MUBASHAR LALLA MUSSA - 578","","","","","","","","","");
INSERT INTO nom VALUES("2610000108","MUHAMMAD ASHFAQ - 414","","","","","","","","","");
INSERT INTO nom VALUES("2610000109","MUNAWAR ALI","","","","","","","","","");
INSERT INTO nom VALUES("2610000110","MUHAMMAD FAROOQ","","","","","","","","","");
INSERT INTO nom VALUES("2610000111","MARSHAL PAINT - 579","","","","","","","","","");
INSERT INTO nom VALUES("2610000112","MUHAMMAD FARHAJ GUJRANWALA - 296","","","","","","","","","");
INSERT INTO nom VALUES("2610000113","MUHAMMAD NAEEM","","","","","","","","","");
INSERT INTO nom VALUES("2610000115","SYED NAJEEB HUSSAIN","","","","","","","","","");
INSERT INTO nom VALUES("2610000117","HAJI NAWAB DIN POLISH WALAY","","","","","","","","","");
INSERT INTO nom VALUES("2610000118","NEELAM PAPER MILL - 769","","","","","","","","","");
INSERT INTO nom VALUES("2610000119","MUHAMMAD NAWAZ BROKER LAHORE","","","","","","","","","");
INSERT INTO nom VALUES("2610000120","WAX INTERNATIONAL - 113","","","","","","","","","");
INSERT INTO nom VALUES("2610000121","WAQAS PAINT - 260","","","","","","","","","");
INSERT INTO nom VALUES("2610000122","HIMALIYA CHEMICAL - 549","","","","","","","","","");
INSERT INTO nom VALUES("2610000123","HAMMAYU CHEMICAL - 368","","","","","","","","","");
INSERT INTO nom VALUES("2610000124","SHEIKH YUNIS 497","","","","","","","","","");
INSERT INTO nom VALUES("2610000126","ANWAR TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000127","ABRAR CHEMICAL - 74","","","","","","","","","");
INSERT INTO nom VALUES("2610000128","AKRAM CHEMICAL SHAH ALAM - 40","","","","","","","","","");
INSERT INTO nom VALUES("2610000129","AHMAD ANWAR - 902","","","","","","","","","");
INSERT INTO nom VALUES("2610000130","TAJ PAPER MILL","","","","","","","","","");
INSERT INTO nom VALUES("2610000131","MUHAMMAD AMIN GUJRANWALA - 68","","","","","","","","","");
INSERT INTO nom VALUES("2610000132","MUHAMMAD KHALID - 917","","","","","","","","","");
INSERT INTO nom VALUES("2610000134","SUSPENSE A/C","","","","","","","","","");
INSERT INTO nom VALUES("2610000135","HABIB CHEMICAL - 487","","","","","","","","","");
INSERT INTO nom VALUES("2610000136","NISAR AHMED - 236","","","","","","","","","");
INSERT INTO nom VALUES("2610000137","ASIF CHEMICAL - 106","","","","","","","","","");
INSERT INTO nom VALUES("2610000138","MUHAMMAD AKBAR","","","","","","","","","");
INSERT INTO nom VALUES("2610000139","IRSHAD PAINT PINDI - 412","","","","","","","","","");
INSERT INTO nom VALUES("2610000140","FIVE STAR","","","","","","","","","");
INSERT INTO nom VALUES("2610000141","AQSA CHEMICAL -84","","","","","","","","","");
INSERT INTO nom VALUES("2610000142","PUNJAB LAKH","","","","","","","","","");
INSERT INTO nom VALUES("2610000143","ALI ENTERPRISES","","","","","","","","","");
INSERT INTO nom VALUES("2610000144","POWER BELTING - 714","","","","","","","","","");
INSERT INTO nom VALUES("2610000145","SHAMA CHEMICAL - 769","","","","","","","","","");
INSERT INTO nom VALUES("2610000148","HAMDARD CHEMICAL - 362","","","","","","","","","");
INSERT INTO nom VALUES("2610000149","ALFA TRADERS - 58","","","","","","","","","");
INSERT INTO nom VALUES("2610000150","RIZWAN TRADERS - 723","","","","","","","","","");
INSERT INTO nom VALUES("2610000151","GOLDEN DYING - 492","","","","","","","","","");
INSERT INTO nom VALUES("2610000152","QAZI & COMPANY","","","","","","","","","");
INSERT INTO nom VALUES("2610000154","NIMIR INDUSTRIES - 654","","","","","","","","","");
INSERT INTO nom VALUES("2610000155","MUHAMMAD YOUSUF KHATAK - 202","","","","","","","","","");
INSERT INTO nom VALUES("2610000156","SHEIKH IBRAHIM & SONS - 433","","","","","","","","","");
INSERT INTO nom VALUES("2610000157","WAQAR YOUNIS - 805","","","","","","","","","");
INSERT INTO nom VALUES("2610000158","MAQSODA MALIK 604","","","","","","","","","");
INSERT INTO nom VALUES("2610000159","MUHAMMAD IFTIKHAR KARACHI - 427","","","","","","","","","");
INSERT INTO nom VALUES("2610000160","BETA DYES - 220","","","","","","","","","");
INSERT INTO nom VALUES("2610000161","MUHAMMAD ARSHAD  MULTAN ROAD - 468","","","","","","","","","");
INSERT INTO nom VALUES("2610000164","AHMED TARIQ - 151","","","","","","","","","");
INSERT INTO nom VALUES("2610000165","IBRAHIM WALI MUHAMMAD - 395","","","","","","","","","");
INSERT INTO nom VALUES("2610000166","CASH SALES","","","","","","","","","");
INSERT INTO nom VALUES("2610000167","IMPEX RASIN","","","","","","","","","");
INSERT INTO nom VALUES("2610000169","JAHANGIR CHEMICAL - 512","","","","","","","","","");
INSERT INTO nom VALUES("2610000172"," CAPRING DYING LAHORE - 246","","","","","","","","","");
INSERT INTO nom VALUES("2610000173","HASSAN BOARD INDUSTRIES - 415","","","","","","","","","");
INSERT INTO nom VALUES("2610000174","NAZER CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000176","194 TIN BROZA","","","","","","","","","");
INSERT INTO nom VALUES("2610000177","155 TORA BROZA","","","","","","","","","");
INSERT INTO nom VALUES("2610000178","39 BAG CHOONA","","","","","","","","","");
INSERT INTO nom VALUES("2610000179","52 DRUM INDONESIA","","","","","","","","","");
INSERT INTO nom VALUES("2610000180","MOAM IRANI KG","","","","","","","","","");
INSERT INTO nom VALUES("2610000181","CARTON MOAM HUNGRY","","","","","","","","","");
INSERT INTO nom VALUES("2610000182","OIL TARPIN","","","","","","","","","");
INSERT INTO nom VALUES("2610000183","TORA MOAM PAKISTANI","","","","","","","","","");
INSERT INTO nom VALUES("2610000184","BAG MOAM CHINA","","","","","","","","","");
INSERT INTO nom VALUES("2610000185","DRUM IRANI MOAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000186","STERIC BAG","","","","","","","","","");
INSERT INTO nom VALUES("2610000187","T P BAG","","","","","","","","","");
INSERT INTO nom VALUES("2610000188","DRUM CHINA BROZA","","","","","","","","","");
INSERT INTO nom VALUES("2610000189","DRUM VIETNAM  BROZA","","","","","","","","","");
INSERT INTO nom VALUES("2610000193","RIAZ CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000194","MAGGON CHEMICAL - 558","","","","","","","","","");
INSERT INTO nom VALUES("2610000196","ABDUL WAHID ABDUL MAJID - 122","","","","","","","","","");
INSERT INTO nom VALUES("2610000197","KHAWAJA MUBARAK - 574","","","","","","","","","");
INSERT INTO nom VALUES("2610000198","TYPHOON","","","","","","","","","");
INSERT INTO nom VALUES("2610000199","CASH PURCHASE","","","","","","","","","");
INSERT INTO nom VALUES("2610000200","CASH RECEIVEABLE A/C","","","","","","","","","");
INSERT INTO nom VALUES("2610000202","JAVED PAINTS","","","","","","","","","");
INSERT INTO nom VALUES("2610000203","KASHIF CHEMICAL - 474","","","","","","","","","");
INSERT INTO nom VALUES("2610000204","MILLIAT CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000205","LALA QURBAN","","","","","","","","","");
INSERT INTO nom VALUES("2610000206","MUHAMMAD MALOOK BROKER - 555","","","","","","","","","");
INSERT INTO nom VALUES("2610000208","COMMERCIAL CHEMICAL - 250","","","","","","","","","");
INSERT INTO nom VALUES("2610000209","B.S.VERIFY","","","","","","","","","");
INSERT INTO nom VALUES("2610000210","WAZIR GUL","","","","","","","","","");
INSERT INTO nom VALUES("2610000211","AL-NOOR CHEMICAL KISAN STREET - 44","","","","","","","","","");
INSERT INTO nom VALUES("2610000212","ROYAL RASIN 54","","","","","","","","","");
INSERT INTO nom VALUES("2610000214","SHAFI & SONS - 462","","","","","","","","","");
INSERT INTO nom VALUES("2610000216","INTERNATIONAL PETRO CHEMICAL 268","","","","","","","","","");
INSERT INTO nom VALUES("2610000217","TORA BROZA","","","","","","","","","");
INSERT INTO nom VALUES("2610000218","KHAN & COMPANY QUETTA","","","","","","","","","");
INSERT INTO nom VALUES("2610000219","TAHIR KAMAL IA BROTHERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000222","NADEEM ASHFAQ","","","","","","","","","");
INSERT INTO nom VALUES("2610000224","SARDAR SONS","","","","","","","","","");
INSERT INTO nom VALUES("2610000225","IQBAL AUTO MULTAN - 408","","","","","","","","","");
INSERT INTO nom VALUES("2610000226","A B C CHEMICALS","","","","","","","","","");
INSERT INTO nom VALUES("2610000227","INAM & COMPANY - 320","","","","","","","","","");
INSERT INTO nom VALUES("2610000228","INDUS PLASTIC SHAHALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000229","AZHAR CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000230"," NADEEM JAHANGIR CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000231","HAIDER INTERPRISES - 292","","","","","","","","","");
INSERT INTO nom VALUES("2610000233","AHMED TRADERS - 39","","","","","","","","","");
INSERT INTO nom VALUES("2610000234","JAWA CHEMICAL SHAH ALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000235","KARACHI CHEMICAL SHAH ALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000236","SOHAIL MALIK LONDON","","","","","","","","","");
INSERT INTO nom VALUES("2610000237","SALEEM IQBAL JEDDAH","","","","","","","","","");
INSERT INTO nom VALUES("2610000238","NAVEED KAMAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000239","ANJUM CHEMICAL SHAH ALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000240","AL RIAZ AND COMPANY - 144","","","","","","","","","");
INSERT INTO nom VALUES("2610000241","SHAHID WARNISH - 764","","","","","","","","","");
INSERT INTO nom VALUES("2610000242","RASHID JAHANGIR","","","","","","","","","");
INSERT INTO nom VALUES("2610000243","LAYAL PUR CHEMICAL - 518","","","","","","","","","");
INSERT INTO nom VALUES("2610000245","KAUSAR TRADERS BUND ROAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000247","WARIS CHEMICAL KISSAN STREET","","","","","","","","","");
INSERT INTO nom VALUES("2610000248","RAUF & SONS SHAHALAM - 725","","","","","","","","","");
INSERT INTO nom VALUES("2610000249","C.F.S","","","","","","","","","");
INSERT INTO nom VALUES("2610000250","D.H.CHEMICALS - 229","","","","","","","","","");
INSERT INTO nom VALUES("2610000252","AL-SAEED CHEMICAL SHAHALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000254","M.ISMIAL & SONS - 138","","","","","","","","","");
INSERT INTO nom VALUES("2610000255","SULTAN NAZEER - 227","","","","","","","","","");
INSERT INTO nom VALUES("2610000256","OMER CHEMICAL KISSAN STREET 336","","","","","","","","","");
INSERT INTO nom VALUES("2610000257","HAMEED CHEMICAL FAISALABAD 382","","","","","","","","","");
INSERT INTO nom VALUES("2610000258","ASHRAF CHEMICAL ALAHI MARKET- 50","","","","","","","","","");
INSERT INTO nom VALUES("2610000260","FALKAN INDUSTRY - 264","","","","","","","","","");
INSERT INTO nom VALUES("2610000261","RAO KHURSHID - 279","","","","","","","","","");
INSERT INTO nom VALUES("2610000262","MUHAMMAD ASAD GULBERG - 86","","","","","","","","","");
INSERT INTO nom VALUES("2610000263","MEHRAN INTERPRISES","","","","","","","","","");
INSERT INTO nom VALUES("2610000264","MUHAMMAD AWAIS PINDI","","","","","","","","","");
INSERT INTO nom VALUES("2610000265","ZAHID CHEMICAL CIRCULAR ROAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000270","LAHORE ESSENCE 536","","","","","","","","","");
INSERT INTO nom VALUES("2610000271","MUNIR CHEMICAL SHAHALAM - 622","","","","","","","","","");
INSERT INTO nom VALUES("2610000272","AKHTAR NIMIR BUND ROAD - 126","","","","","","","","","");
INSERT INTO nom VALUES("2610000273","BASIT CHEMICAL SHAH ALAM - 100","","","","","","","","","");
INSERT INTO nom VALUES("2610000275","KHAWAJA  TARIQ SHAHALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000276","AKBARI STORE CIRCULAR ROAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000277","OMER TISSUE - 656","","","","","","","","","");
INSERT INTO nom VALUES("2610000278","CRESENT CHEMICAL SHAHALAM - 256","","","","","","","","","");
INSERT INTO nom VALUES("2610000279","BASIC CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000281","NIMIR INDUSTRIES CHEMICAL-AL REHMAN TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000282","DOST  MUHAMMAD - 235","","","","","","","","","");
INSERT INTO nom VALUES("2610000285","HAMAYUN BROTHERS - 390","","","","","","","","","");
INSERT INTO nom VALUES("2610000286","IRFAN PASROOR - 199","","","","","","","","","");
INSERT INTO nom VALUES("2610000288","ALI INTERNATIONAL QUETTA - 397","","","","","","","","","");
INSERT INTO nom VALUES("2610000289","ANWAR & COMPANY SHAHALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000291","CHAWALA HABIB - 240","","","","","","","","","");
INSERT INTO nom VALUES("2610000293","JAFFER CHEMICAL SHAHALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000294","HASHIM TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000297","CITY CHEMICAL KISSAN STREET","","","","","","","","","");
INSERT INTO nom VALUES("2610000298","TARIQ BROTHERS SHAHALAM 509","","","","","","","","","");
INSERT INTO nom VALUES("2610000299","BUILDING KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000300","PARACHA BROTHERS QUETA - 306","","","","","","","","","");
INSERT INTO nom VALUES("2610000304","ZAFAR & COMPANY FAISALABAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000308","KHAWAJA NASIR-UD-DIN & SONS-254","","","","","","","","","");
INSERT INTO nom VALUES("2610000309","ALI & COMPANY - 872","","","","","","","","","");
INSERT INTO nom VALUES("2610000311","MALIK EJAZ","","","","","","","","","");
INSERT INTO nom VALUES("2610000312","SAJID PAINT SHALAMAR BAGH","","","","","","","","","");
INSERT INTO nom VALUES("2610000313","AKBAR TRADERS","","","","","","","","","");
INSERT INTO nom VALUES("2610000314","TYCON BUND ROAD - 127","","","","","","","","","");
INSERT INTO nom VALUES("2610000315","PARVEZ MUGHAL PURA - 619","","","","","","","","","");
INSERT INTO nom VALUES("2610000316","SALEEM & COMPANY","","","","","","","","","");
INSERT INTO nom VALUES("2610000317","PUNJAB CHEMICAL KISSAN STREET - 891","","","","","","","","","");
INSERT INTO nom VALUES("2610000318","OMER PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000319","IQBAL TRADERS DHARAMPURA - 421","","","","","","","","","");
INSERT INTO nom VALUES("2610000320","SABIR KARACHI","","","","","","","","","");
INSERT INTO nom VALUES("2610000323","AL-QURAISH BOARD MILL","","","","","","","","","");
INSERT INTO nom VALUES("2610000324","HAJI MUHAMMAD SHAFFI","","","","","","","","","");
INSERT INTO nom VALUES("2610000325","SULTAN ASSOCIATES FAISALABAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000327","TARIQ BROTHERS KHUSH DHOODH WALAY - 688","","","","","","","","","");
INSERT INTO nom VALUES("2610000328","MUNIR ALAM","","","","","","","","","");
INSERT INTO nom VALUES("2610000331","JAMIL DYING - 484","","","","","","","","","");
INSERT INTO nom VALUES("2610000332","BUTT & COMPANY - 184","","","","","","","","","");
INSERT INTO nom VALUES("2610000334","AL MANZOOR CHEMICAL","","","","","","","","","");
INSERT INTO nom VALUES("2610000335","AQS - CHEMICAL JOHAR TOWN LAHORE - 212","","","","","","","","","");
INSERT INTO nom VALUES("2610000336","C.F.S-II - 262","","","","","","","","","");
INSERT INTO nom VALUES("2610000338","DIN MUHAMMAAD & SONS KARACHI - 274","","","","","","","","","");
INSERT INTO nom VALUES("2610000339","MUHAMMAD AMIN PESHAWAR - 316","","","","","","","","","");
INSERT INTO nom VALUES("2610000340","KIRAN CANDLE","","","","","","","","","");
INSERT INTO nom VALUES("2610000341","KHAWAR MAHMOOD & COMPANY","","","","","","","","","");
INSERT INTO nom VALUES("2610000342","GHULAM RASOOL & COMPANY - 324","","","","","","","","","");
INSERT INTO nom VALUES("2610000343","RASHID PINDI","","","","","","","","","");
INSERT INTO nom VALUES("2610000344","M.B. DYES","","","","","","","","","");
INSERT INTO nom VALUES("2610000345","JAMAL PIPE - 118","","","","","","","","","");
INSERT INTO nom VALUES("2610000346","ABID PAINT PINDI","","","","","","","","","");
INSERT INTO nom VALUES("2610000347","KARAN CANDLE SHEIKHUPURA","","","","","","","","","");
INSERT INTO nom VALUES("2610000348","GHAZI TRADERS - 943","","","","","","","","","");
INSERT INTO nom VALUES("2610000349","JAAN RUBBER INDUSTRY - 450","","","","","","","","","");
INSERT INTO nom VALUES("2610000350","COLORTEX","","","","","","","","","");
INSERT INTO nom VALUES("2610000354","ABDULLAH PLASTIC G.T. ROAD - 92","","","","","","","","","");
INSERT INTO nom VALUES("2610000355","RAZA TRADERS BUND ROAD - 3","","","","","","","","","");
INSERT INTO nom VALUES("2610000356","SAEED KHAN SHERAWALE - 5","","","","","","","","","");
INSERT INTO nom VALUES("2610000357","RAISIN HOUSE SHAHLMI - 61","","","","","","","","","");
INSERT INTO nom VALUES("2610000361","SAMAR DYES - 776","","","","","","","","","");
INSERT INTO nom VALUES("2610000362","YAQOOB DYES - 68","","","","","","","","","");
INSERT INTO nom VALUES("2610000363","IQBAL BROTHERS SHAHLMI - 142","","","","","","","","","");
INSERT INTO nom VALUES("2610000364","MUZAMIL TAJAMAL CHEMICAL SHAHLMI - 178","","","","","","","","","");
INSERT INTO nom VALUES("2610000365","VAZIR SONS CIRCULAR ROAD - 802","","","","","","","","","");
INSERT INTO nom VALUES("2610000367","AKRAM AND COMPANY AKBARI MANDI","","","","","","","","","");
INSERT INTO nom VALUES("2610000368","NAZEER PAPER MILL - 292","","","","","","","","","");
INSERT INTO nom VALUES("2610000369","NAEEM INAM ULLAH","","","","","","","","","");
INSERT INTO nom VALUES("2610000370","COLOR LINE LAL MAQSOOD MARKET - 271","","","","","","","","","");
INSERT INTO nom VALUES("2610000371","COLOUR TAX CIRCULAR ROAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000374","AL MANZOOR CHEMICAL SHAHALMI 318 PAGE","","","","","","","","","");
INSERT INTO nom VALUES("2610000375","PAKISTAN CHEMICALS CIRCULLAR ROAD 226","","","","","","","","","");
INSERT INTO nom VALUES("2610000376","SHAHID BROTHERS KISSAN STREET -780","","","","","","","","","");
INSERT INTO nom VALUES("2610000377","NEW ARBE CHEMICAL PAG 242","","","","","","","","","");
INSERT INTO nom VALUES("2610000379","STAR KO BELTING PAG - 378","","","","","","","","","");
INSERT INTO nom VALUES("2610000380","AFTABE PINDI PAG145","","","","","","","","","");
INSERT INTO nom VALUES("2610000381","BATALA CHEMICAL - 190","","","","","","","","","");
INSERT INTO nom VALUES("2610000382","ZAHIR SHAH PARA CHINAR PAG 11","","","","","","","","","");
INSERT INTO nom VALUES("2610000383","SHAHARYAR PAG 139","","","","","","","","","");
INSERT INTO nom VALUES("2610000384","MUSLIM SOAP - 328","","","","","","","","","");
INSERT INTO nom VALUES("2610000385","MUHAMMAD AWAIS SHAHDRA PAG 271","","","","","","","","","");
INSERT INTO nom VALUES("2610000386","MAHMOOD SATHI PAG 626","","","","","","","","","");
INSERT INTO nom VALUES("2610000387","KHAN TRADERS CIRCULAR ROAD - 822","","","","","","","","","");
INSERT INTO nom VALUES("2610000388","IMRAN DANISH FAISALABAD - 208","","","","","","","","","");
INSERT INTO nom VALUES("2610000389","UNITED CORPORATION -384","","","","","","","","","");
INSERT INTO nom VALUES("2610000390","CITY PACKIGIES -107","","","","","","","","","");
INSERT INTO nom VALUES("2610000391","TALIBJAN AND BROTHERS - 796","","","","","","","","","");
INSERT INTO nom VALUES("2610000395","ALI ANWAR BROKER - 422","","","","","","","","","");
INSERT INTO nom VALUES("2610000396","HAJI MUHAMMAD SHAFI BULL ROAD - 38","","","","","","","","","");
INSERT INTO nom VALUES("2610000401","MADINA COLOR CIRCULAR ROAD - 95","","","","","","","","","");
INSERT INTO nom VALUES("2610000402","CHAWALA BROTHERS FAISALABAD - 258","","","","","","","","","");
INSERT INTO nom VALUES("2610000403","MUHAMMAD SHAFI BULL ROAD","","","","","","","","","");
INSERT INTO nom VALUES("2610000405","HAJI ARSHAD MORI GATE - 117","","","","","","","","","");
INSERT INTO nom VALUES("2610000408","MUHAMMAD FAROOQ KARACHI 302","","","","","","","","","");
INSERT INTO nom VALUES("2610000410","SULAIMAN SAWEYA WALE GUJRANWALA","","","","","","","","","");
INSERT INTO nom VALUES("2610000411","SETHI PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000412","PIONEER PAPER MILL - 167","","","","","","","","","");
INSERT INTO nom VALUES("2610000414","A. R. ENTERPRISES - 27","","","","","","","","","");
INSERT INTO nom VALUES("2610000416","RIZWAN BROTHERS SHAHLMI - 101","","","","","","","","","");
INSERT INTO nom VALUES("2610000417","HAJI ALYAS MORI GATE - 192","","","","","","","","","");
INSERT INTO nom VALUES("2610000418","AL-NAEEM CORPORATION - 31","","","","","","","","","");
INSERT INTO nom VALUES("2610000419","OUN CORPORATION - P93","","","","","","","","","");
INSERT INTO nom VALUES("2610000420","MATTI ULLAH SIALKOT - 820","","","","","","","","","");
INSERT INTO nom VALUES("2610000421","TAUQIR BROTHERS - 110","","","","","","","","","");
INSERT INTO nom VALUES("2610000422","AL-HAYEE CHEMICAL - 119","","","","","","","","","");
INSERT INTO nom VALUES("2610000423","MUBARAK ALI BILLA - 634","","","","","","","","","");
INSERT INTO nom VALUES("2610000426","GUJRANWALA PAPER MILL - 238","","","","","","","","","");
INSERT INTO nom VALUES("2610000427","JALAL-UD-DIN AKBARI MANDI - 712","","","","","","","","","");
INSERT INTO nom VALUES("2610000428","ALI BABA BADAMI BAGH - 131","","","","","","","","","");
INSERT INTO nom VALUES("2610000429","FAISAL KHURSHID - 476","","","","","","","","","");
INSERT INTO nom VALUES("2610000430","JAVED RAZA BROKER - 210","","","","","","","","","");
INSERT INTO nom VALUES("2610000431","FURQAN KARACHI - 498","","","","","","","","","");
INSERT INTO nom VALUES("2610000432","ACRO CHEMICAL BUND ROAD - 900","","","","","","","","","");
INSERT INTO nom VALUES("2610000433","FARAS COMBINE MARKETING - 340","","","","","","","","","");
INSERT INTO nom VALUES("2610000434","JAVED SIALKOT - 293","","","","","","","","","");
INSERT INTO nom VALUES("2610000435","SHALIMAR RAISIN - 785","","","","","","","","","");
INSERT INTO nom VALUES("2610000436","HAJI ABDUL KARIM & SONS KARACHI - 437","","","","","","","","","");
INSERT INTO nom VALUES("2610000437","GALA PAINT","","","","","","","","","");
INSERT INTO nom VALUES("2610000438","MUHAMMADI TRADERS - 129","","","","","","","","","");
INSERT INTO nom VALUES("2610000440","ALEEM CHAUDHRY - 383","","","","","","","","","");
INSERT INTO nom VALUES("2610000442","SETHI PHARMA INDUSTRY CHACHA WATNI - 123","","","","","","","","","");
INSERT INTO nom VALUES("2610000443","REHMANI TRADERS - 179","","","","","","","","","");
INSERT INTO nom VALUES("2610000444","WAQAR L/C LATEX RUBBER 3874","","","","","","","","","");
INSERT INTO nom VALUES("2610000445","AMIR SOAP BABA PUR - 654","","","","","","","","","");
INSERT INTO nom VALUES("2610000446","KASHIF SHAHDARA - 550","","","","","","","","","");
INSERT INTO nom VALUES("2610000448","HASNAIN TRADING COMPANY CIRCULAR ROAD - 357","","","","","","","","","");
INSERT INTO nom VALUES("2610000449","UNION BELTING - 118","","","","","","","","","");
INSERT INTO nom VALUES("2610000450","QUALITY COSMETIC - 406","","","","","","","","","");
INSERT INTO nom VALUES("2610000453","INVESTMENT ACCOUNT - 432","","","","","","","","","");
INSERT INTO nom VALUES("2610000454","lL/C VIETNAM BROZA 5559","","","","","","","","","");
INSERT INTO nom VALUES("2610000455","lL/C INDONESIA BROZA 6063","","","","","","","","","");
INSERT INTO nom VALUES("2610000456","lL/C VIETNAM BROZA 6296","","","","","","","","","");
INSERT INTO nom VALUES("2610000461","ijaz kasur- 263","","","","","","","","","");
INSERT INTO nom VALUES("2610000462","SALEEM CHEMICAL KISSAN STREET - 790","","","","","","","","","");
INSERT INTO nom VALUES("2610000463","RAHIM CHEMICAL SHAHALMI","","","","","","","","","");
INSERT INTO nom VALUES("2610000464","TALHA TRADERS PAG-199","","","","","","","","","");
INSERT INTO nom VALUES("2610000466","ARIF BUTT RAVI ROAD 170","","","","","","","","","");
INSERT INTO nom VALUES("2610000467","ZAFIR AND COMPANY LAL MAQSOOD MARKET PAG 384","","","","","","","","","");
INSERT INTO nom VALUES("2610000468","SHAHBAZ AKBARI MANDI - 720","","","","","","","","","");
INSERT INTO nom VALUES("2610000469","AA INTER PRICES PAG 6","","","","","","","","","");
INSERT INTO nom VALUES("2610000471","AMIR SHAHALAMI 366","","","","","","","","","");
INSERT INTO nom VALUES("2610000472","Qamar Candle Peshawar - 504","","","","","","","","","");
INSERT INTO nom VALUES("2610000473","US GODOWN  543","","","","","","","","","");
INSERT INTO nom VALUES("2610000474","ABDUL KARIM ADAM JI 652","","","","","","","","","");
INSERT INTO nom VALUES("2610000475","IRFAN BROTHER SHAHALAMI - 94","","","","","","","","","");
INSERT INTO nom VALUES("2610000476","GUL AUTO - 334","","","","","","","","","");
INSERT INTO nom VALUES("2610000477","MAKHA PEHLWAN   219","","","","","","","","","");
INSERT INTO nom VALUES("2610000479","SULMAN MODEL TOWN - 892","","","","","","","","","");
INSERT INTO nom VALUES("2610000480","KASHAF INDUSTRY FAISLABAD - 467","","","","","","","","","");
INSERT INTO nom VALUES("2610000481"," LM TRADER - 546","","","","","","","","","");
INSERT INTO nom VALUES("2610000482","VENUS CORPORATION -  892","","","","","","","","","");
INSERT INTO nom VALUES("2610000483","BANGA INTERNATIONAL - 147","","","","","","","","","");
INSERT INTO nom VALUES("2610000484","ABID MALIK - 463","","","","","","","","","");
INSERT INTO nom VALUES("2610000485","J F CHATTI KARACHI - 456","","","","","","","","","");
INSERT INTO nom VALUES("2610000486","ASHRAF SONS KARACHI - 260","","","","","","","","","");
INSERT INTO nom VALUES("2610000487","KHURRAM CHEMICAL KARACHI - 102","","","","","","","","","");
INSERT INTO nom VALUES("2610000488","MAQSOOD GADE - 229","","","","","","","","","");
INSERT INTO nom VALUES("2610000489","SES ENGINEERS - 950","","","","","","","","","");
INSERT INTO nom VALUES("2610000490","LATIF RANG WALAY DASKA - 322","","","","","","","","","");
INSERT INTO nom VALUES("2610000493","AZHAR PINDI - 115","","","","","","","","","");
INSERT INTO nom VALUES("2610000494","MILLAT SOAP - 60","","","","","","","","","");
INSERT INTO nom VALUES("2610000495","PAK WAX COMPANY - 299","","","","","","","","","");
INSERT INTO nom VALUES("2610000496","HABIB HARDWARE MULTAN - 290","","","","","","","","","");
INSERT INTO nom VALUES("2610000497","SHER AFGAN GUJRANWALA - 304","","","","","","","","","");
INSERT INTO nom VALUES("2610000498","AHMAD PESHWAR - 18","","","","","","","","","");
INSERT INTO nom VALUES("2610000499","MUHAMMAD IMRAN - 278","","","","","","","","","");
INSERT INTO nom VALUES("2610000500","HUSNAIN BROTHERS MULTAN - 436","","","","","","","","","");
INSERT INTO nom VALUES("2610000504","OMER CHEMICAL PAPERD MANDI - 806","","","","","","","","","");
INSERT INTO nom VALUES("2610000505","INAM ULLAH FAISALABAD - 788","","","","","","","","","");
INSERT INTO nom VALUES("2610000507"," SAIF ENTERPRISES - 232","","","","","","","","","");
INSERT INTO nom VALUES("2610000508","RAIZ MINGORA - 523","","","","","","","","","");
INSERT INTO nom VALUES("2610000509","QAISAR GUJRANWALA - 445","","","","","","","","","");
INSERT INTO nom VALUES("2610000510","NAZIR ULLAH  PESHAWAR-602","","","","","","","","","");
INSERT INTO nom VALUES("2610000511","RAIZ CHKWAL - 364","","","","","","","","","");
INSERT INTO nom VALUES("2610000515","Asif Afridi and Company - 252","","","","","","","","","");
INSERT INTO nom VALUES("2610000516","PUL SAGEYAN 2 - 812","","","","","","","","","");
INSERT INTO nom VALUES("2610000517","PAC TACK TOWN SHIP - 832","","","","","","","","","");
INSERT INTO nom VALUES("2610000519","Mazda Shahzoor Khata - 973","","","","","","","","","");
INSERT INTO nom VALUES("2610000520","Carwan Craft - 223","","","","","","","","","");
INSERT INTO nom VALUES("2610000522","NADER DYING - 586","","","","","","","","","");
INSERT INTO nom VALUES("2610000523","SNOW WHITE CHEMICAL HOUSE - 842","","","","","","","","","");
INSERT INTO nom VALUES("2610000524","ALHAMD DYEING - 471","","","","","","","","","");
INSERT INTO nom VALUES("2610000525","Muhammad Usman Gujranwala - 658","","","","","","","","","");
INSERT INTO nom VALUES("2610000526","Muhammad Parvez Gujranwala - 956","","","","","","","","","");
INSERT INTO nom VALUES("2610000527","SUPURDARE KHATA - 928","","","","","","","","","");
INSERT INTO nom VALUES("2610000528","SILVER STAR ENTERPRISES - 32","","","","","","","","","");
INSERT INTO nom VALUES("2610000529","STOCK EXCHANGE TOWER No2 - 76","","","","","","","","","");
INSERT INTO nom VALUES("2610000530","GODOWN KHATA SHAH MUHAMMAD GHOSE","","","","","","","","","");
INSERT INTO nom VALUES("2610000531","MADNI CHEMICAL CIRCULER ROAD - 615","","","","","","","","","");
INSERT INTO nom VALUES("2610000533","Usman Brother Shahalum - 100","","","","","","","","","");
INSERT INTO nom VALUES("2610000534","SULPHONIC TUFAIL KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000535","RAAZQ CHEMICAL PAPERD MANDI - 688","","","","","","","","","");
INSERT INTO nom VALUES("2610000536","FALCAN BELTING - 30","","","","","","","","","");
INSERT INTO nom VALUES("2610000537","TANVEER CANDLE TAJPURA - 582","","","","","","","","","");
INSERT INTO nom VALUES("2610000538","SAYED FAISAL SHAH BROKER - 348","","","","","","","","","");
INSERT INTO nom VALUES("2610000539","MUNIR BOTTLE STORE - 894","","","","","","","","","");
INSERT INTO nom VALUES("2610000540","Nimir Chemical Pakistan LTD - 266","","","","","","","","","");
INSERT INTO nom VALUES("2610000541","MALEIC KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000542","BEGUM NASIRA SES - 614","","","","","","","","","");
INSERT INTO nom VALUES("2610000543","INDIA BROZA KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000547","SECURITY DUBI KHATA 3017","","","","","","","","","");
INSERT INTO nom VALUES("2610000548","BILAL BROTHER - 346","","","","","","","","","");
INSERT INTO nom VALUES("2610000551","Shama Malik Thana Gulberg - 26","","","","","","","","","");
INSERT INTO nom VALUES("2610000552","Grace Chemecals - 678","","","","","","","","","");
INSERT INTO nom VALUES("2610000554","Nadeem Jahangir - 248","","","","","","","","","");
INSERT INTO nom VALUES("2610000556","OWN L/C NEPALI BROZA 27207","","","","","","","","","");
INSERT INTO nom VALUES("2610000557","MUHAMMAD SAEED BROZAY WALAY-121","","","","","","","","","");
INSERT INTO nom VALUES("2610000558","UMER CHEMICAL KISAN STREET - 336","","","","","","","","","");
INSERT INTO nom VALUES("2610000561","MB CHEMICALS STORE KISAN STREET - 8","","","","","","","","","");
INSERT INTO nom VALUES("2610000562","MM TRADER - 12","","","","","","","","","");
INSERT INTO nom VALUES("2610000563","OWN L/C NEPALI BROZA 27830","","","","","","","","","");
INSERT INTO nom VALUES("2610000564","ZAIN AHMAD KHWAJA - 379","","","","","","","","","");
INSERT INTO nom VALUES("2610000565","MAHMOOD BUKHARE - 5","","","","","","","","","");
INSERT INTO nom VALUES("2610000566","UZMA SHABIR SECURITY - 506","","","","","","","","","");
INSERT INTO nom VALUES("2610000567","SES NO-2 -599","","","","","","","","","");
INSERT INTO nom VALUES("2610000568","ALI TRADERS 661","","","","","","","","","");
INSERT INTO nom VALUES("2610000569","TARIQ FEROZ KARACHI - 42","","","","","","","","","");
INSERT INTO nom VALUES("2610000571","KHAWAJA NOOR - 376","","","","","","","","","");
INSERT INTO nom VALUES("2610000572","Manzoor gadi wala - 221","","","","","","","","","");
INSERT INTO nom VALUES("2610000573","JAVED PAINT GUJRANWALA - 146","","","","","","","","","");
INSERT INTO nom VALUES("2610000574","TAHIR PARVAZ VAKEEL - 3","","","","","","","","","");
INSERT INTO nom VALUES("2610000575","DRUM BROZA INDONESIA","","","","","","","","","");
INSERT INTO nom VALUES("2610000576","Malik Ishaq Sialkot- 623","","","","","","","","","");
INSERT INTO nom VALUES("2610000577","HAMZA TARPAL - 548","","","","","","","","","");
INSERT INTO nom VALUES("2610000578","ANWER KHAWAJA INSDUSTRY - 178","","","","","","","","","");
INSERT INTO nom VALUES("2610000579","IMRAN BUND ROAD - 167","","","","","","","","","");
INSERT INTO nom VALUES("2610000582","TAHIR SIALKOT - 418","","","","","","","","","");
INSERT INTO nom VALUES("2610000583","YOUSAF DYING - 561","","","","","","","","","");
INSERT INTO nom VALUES("2610000585","KHALI DRUM KHATA","","","","","","","","","");
INSERT INTO nom VALUES("2610000587","Muhammad Rafi Moom Bati Waly - 55","","","","","","","","","");
INSERT INTO nom VALUES("2610000588","Pioneer Board Mill 508","","","","","","","","","");
INSERT INTO nom VALUES("2610000589","ABDUL RAHMAN AND COMPANY 28","","","","","","","","","");
INSERT INTO nom VALUES("2610000594","NOOR HUSSAIN KASUR 753","","","","","","","","","");
INSERT INTO nom VALUES("2610000595","SABBAR MALIK URDU BAZAR 62","","","","","","","","","");
INSERT INTO nom VALUES("2610000596","DRAZ ACCOUNT 78","","","","","","","","","");
INSERT INTO nom VALUES("2610000598","DANISH KARCHI 305","","","","","","","","","");
INSERT INTO nom VALUES("2610000599","MDS international 224","","","","","","","","","");
INSERT INTO nom VALUES("2610000602","BRIGHTER CHEMICAL 370","","","","","","","","","");
INSERT INTO nom VALUES("2610000604","Javed iqbal security 93842  675","","","","","","","","","");
INSERT INTO nom VALUES("2610000605",".","","","","","","","","","");
INSERT INTO nom VALUES("2610000606","Arif haiderabad 108","","","","","","","","","");
INSERT INTO nom VALUES("27","LONG TERM LOANS AND ADVANCES","","0","","","","","","","");
INSERT INTO nom VALUES("28","LONG TERM DEPOSITS AND PREPAYMENTS","","0","","","","","","","");
INSERT INTO nom VALUES("280001","SECURITY DEPOSITS","","1601","","","","","","","");
INSERT INTO nom VALUES("2800010001","SECURITY DEPOSIT FACTORY","","1601","","","","","","","");
INSERT INTO nom VALUES("2800010002","SECURITY DEPOSIT KHI OFFICE","","1601","","","","","","","");
INSERT INTO nom VALUES("29","MACHINE REBUILDING","","0","","","","","","","");
INSERT INTO nom VALUES("290000","FACTORY RENT","","9101","","","","","","","");
INSERT INTO nom VALUES("2900000001","FACTORY RENT","","9101","","","","","","","");
INSERT INTO nom VALUES("2900000002","ELECT.BILL FACTORY","","9101","","","","","","","");
INSERT INTO nom VALUES("290001","HLK LIFT BUILDING","","8101","","","","","","","");
INSERT INTO nom VALUES("2900010001","PURCHASES FOR HLK LIFT BUILDING","","8101","","","","","","","");
INSERT INTO nom VALUES("2900010002","CARRIGE & FREIGHT FOR HLK LIFT","","8101","","","","","","","");
INSERT INTO nom VALUES("290002","BONZER LIFT BUILDING","","8101","","","","","","","");
INSERT INTO nom VALUES("2900020001","PURCHASES FOR BONZER LIFT BUILDING","","8101","","","","","","","");
INSERT INTO nom VALUES("2900020002","CARRIAGE & FREIGHT FOR BONZER LIFT","","8101","","","","","","","");
INSERT INTO nom VALUES("290003","LEATHER DEAL HANG CHAIN DRYER","","8101","","","","","","","");
INSERT INTO nom VALUES("2900030001","PURCHASES FOR LEATHER DEAL H.C.DRYER","","8101","","","","","","","");
INSERT INTO nom VALUES("290004","SERVICE CHARGES","","8101","","","","","","","");
INSERT INTO nom VALUES("2900040001","SERVICE CHARGES","","8101","","","","","","","");
INSERT INTO nom VALUES("290005","OTHERS","","9101","","","","","","","");
INSERT INTO nom VALUES("2900050001","FACTORY ELECTRICITY BILLS","","9101","","","","","","","");
INSERT INTO nom VALUES("290006","YTS SERVICE BILLS","","8101","","","","","","","");
INSERT INTO nom VALUES("2900060001","YTS SERVICE BILLS","","8101","","","","","","","");
INSERT INTO nom VALUES("290007","LEATHER DEAL SAM/SET MACHINE","","8101","","","","","","","");
INSERT INTO nom VALUES("2900070001","LEATHER DEAL SAM/SET RECONDITIONING","","8101","","","","","","","");
INSERT INTO nom VALUES("290008","REPAIRS & MAINTENANCE","","9101","","","","","","","");
INSERT INTO nom VALUES("2900080001","REPAIRS & MANTENACE IN FACTORY","","9101","","","","","","","");
INSERT INTO nom VALUES("30","MARKETING OVERHEADS","","0","","","","","","","");
INSERT INTO nom VALUES("300001","COMMISSIONS","","6201","","","","","","","");
INSERT INTO nom VALUES("3000010001","COMMISSION ON IMPORT OF SPARES","","6201","","","","","","","");
INSERT INTO nom VALUES("300002","TRAVELLING & VISITS","","6201","","","","","","","");
INSERT INTO nom VALUES("3000020001","TRAVELLING FOR SPARES MARKETING","","6201","","","","","","","");
INSERT INTO nom VALUES("300003","OTHER EXPENSES","","6201","","","","","","","");
INSERT INTO nom VALUES("3000030001","GIFTS TO CUSTOMERS","","6201","","","","","","","");
INSERT INTO nom VALUES("31","STOCKS","","0","","","","","","","");
INSERT INTO nom VALUES("310001","STOCKS","","1903","","","","","","","");
INSERT INTO nom VALUES("3100010001","STOCKS","","1903","","","","","","","");
INSERT INTO nom VALUES("3100010010","STOCKS RETURNS","","1903","","","","","","","");
INSERT INTO nom VALUES("32","PROVISION OBSOLETE/DAMAGED STOCKS","","0","","","","","","","");
INSERT INTO nom VALUES("320001","STOCKS","","1901","","","","","","","");
INSERT INTO nom VALUES("33","TRADE DEBTORS","","0","","","","","","","");
INSERT INTO nom VALUES("3300000013","OPENING BALANCE ADJUSTMENTS","","1902","","","","","","","");
INSERT INTO nom VALUES("330001","EXPORT DEBTORS","","1902","","","","","","","");
INSERT INTO nom VALUES("34","PROVISION FOR DOUBTFUL DEBTS","","0","","","","","","","");
INSERT INTO nom VALUES("36","ADVANCES, DEPOSITS, PREPAYMENTS AND RECEIVABLES","","0","","","","","","","");
INSERT INTO nom VALUES("360000","ADVANCES","","1901","","","","","","","");
INSERT INTO nom VALUES("3600000001","ADVANCE TO MR.SADIQ,KASUR","","1901","","","","","","","");
INSERT INTO nom VALUES("360050","ADVANCE INCOME TAX","","1901","","","","","","","");
INSERT INTO nom VALUES("3600500000","ADVANCE INCOME TAX DEDUCTED - TRADE DEBTORS","","1901","","","","","","","");
INSERT INTO nom VALUES("3600500001","Advance Income Tax - Electricity","","1901","","","","","","","");
INSERT INTO nom VALUES("3600500002","Advance Income Tax - Telephone","","1901","","","","","","","");
INSERT INTO nom VALUES("3600500003","Advance Income Tax - Sui Gas","","1901","","","","","","","");
INSERT INTO nom VALUES("3600500004","Advance Income Tax - Bank Profits","","1901","","","","","","","");
INSERT INTO nom VALUES("3600500005","INCOME TAX DEDUCTED ON IMPORTS","","1901","","","","","","","");
INSERT INTO nom VALUES("361000","LC ADVANCES","","1901","","","","","","","");
INSERT INTO nom VALUES("3610000170","L/C INDONESIA BROZA TORA","","","","","","","","","");
INSERT INTO nom VALUES("3610000171","L/C INDONESIA BROZA 2783","","","","","","","","","");
INSERT INTO nom VALUES("3610000175","L/C INDONESIA BROZA 2783","","","","","","","","","");
INSERT INTO nom VALUES("3610000190","L/C INDONESIA 2140","","","","","","","","","");
INSERT INTO nom VALUES("3610000191","L/C INDONESIA 2160","","","","","","","","","");
INSERT INTO nom VALUES("3610000192","L/C INDONESIA","","","","","","","","","");
INSERT INTO nom VALUES("3610000207","L/C INDONESIA BOZA DRUM","","","","","","","","","");
INSERT INTO nom VALUES("3610000213","L/C INDONESIA BROZA 2828","","","","","","","","","");
INSERT INTO nom VALUES("3610000215","L/C MOAM CHINA 2941","","","","","","","","","");
INSERT INTO nom VALUES("3610000223","L/C MOAM CHINA 2941","","","","","","","","","");
INSERT INTO nom VALUES("3610000232","L/C INDONESIA 2835","","","","","","","","","");
INSERT INTO nom VALUES("3610000246","L/C INDONESIA BROZA 2685","","","","","","","","","");
INSERT INTO nom VALUES("3610000253","L/C INDONESIA BROZA 2361","","","","","","","","","");
INSERT INTO nom VALUES("3610000266","L/C VIETNAM 3593","","","","","","","","","");
INSERT INTO nom VALUES("3610000267","L/C INDONESIA 3599","","","","","","","","","");
INSERT INTO nom VALUES("3610000268","L/C INDONESIA DRUM 3670","","","","","","","","","");
INSERT INTO nom VALUES("3610000280","L/C VIETNAM 3825","","","","","","","","","");
INSERT INTO nom VALUES("3610000283","L/C INDONESIA BROZA 3824","","","","","","","","","");
INSERT INTO nom VALUES("3610000284","L/C INDONESIA 3634","","","","","","","","","");
INSERT INTO nom VALUES("3610000292","L/C INDONESIA BROZA 4018","","","","","","","","","");
INSERT INTO nom VALUES("3610000295","L/C INDONESIA BROZA 4019","","","","","","","","","");
INSERT INTO nom VALUES("3610000296","L/C VIETNAM BROZA 4070","","","","","","","","","");
INSERT INTO nom VALUES("3610000301","L/C INDONESIA BROZA 4214","","","","","","","","","");
INSERT INTO nom VALUES("3610000302","L/C INDONESIA BROZA 4182","","","","","","","","","");
INSERT INTO nom VALUES("3610000303","L/C INDONESIA BROZA 4183","","","","","","","","","");
INSERT INTO nom VALUES("3610000305","L/C VIETNAM BROZA 4447","","","","","","","","","");
INSERT INTO nom VALUES("3610000306","L/C  VIETNAM  BROZA 4448","","","","","","","","","");
INSERT INTO nom VALUES("3610000307","L/C  VIETNAM  BROZA  4531","","","","","","","","","");
INSERT INTO nom VALUES("3610000310","L/C INDONESIA BROZA 4533","","","","","","","","","");
INSERT INTO nom VALUES("3610000321","L/C INDONESIA BROZA 4882","","","","","","","","","");
INSERT INTO nom VALUES("3610000322","L/C INDONESIA BROZA 4882","","","","","","","","","");
INSERT INTO nom VALUES("3610000329","L/C INDONESIA BROZA 0172","","","","","","","","","");
INSERT INTO nom VALUES("3610000330","L/C VIETNAM BROZA 0367","","","","","","","","","");
INSERT INTO nom VALUES("3610000333","L/C INDONESIA BROZA 3163","","","","","","","","","");
INSERT INTO nom VALUES("3610000351","L/C STERIC 7213","","","","","","","","","");
INSERT INTO nom VALUES("3610000352","L/C STERIC 7122","","","","","","","","","");
INSERT INTO nom VALUES("3610000353","L/C STERIC 6712","","","","","","","","","");
INSERT INTO nom VALUES("3610000358","L/C INDONESIA DRUM BROZA 1784","","","","","","","","","");
INSERT INTO nom VALUES("3610000359","L/C INDONESIA DRUM BROZA 2155","","","","","","","","","");
INSERT INTO nom VALUES("3610000360","L/C INDONESIA DRUM BROZA 2373","","","","","","","","","");
INSERT INTO nom VALUES("3610000366","L/C SULPHONIC LG 4010","","","","","","","","","");
INSERT INTO nom VALUES("3610000372","L/C SULPHONI MIWON 4337","","","","","","","","","");
INSERT INTO nom VALUES("3610000373","L/C SULPHONIC MIWON 4751","","","","","","","","","");
INSERT INTO nom VALUES("3610000378","L/C SULPHONIC 5402","","","","","","","","","");
INSERT INTO nom VALUES("3610000392","L/C INDONESIA BROZA 7875","","","","","","","","","");
INSERT INTO nom VALUES("3610000393","L/C INDONESIA BROZA 7641","","","","","","","","","");
INSERT INTO nom VALUES("3610000394","L/C INDONESIA BROZA 7727","","","","","","","","","");
INSERT INTO nom VALUES("3610000397","L/C INDONESIA BROZA 8231","","","","","","","","","");
INSERT INTO nom VALUES("3610000398","L/C STERIC 8932","","","","","","","","","");
INSERT INTO nom VALUES("3610000399","L/C INDONESIA BROZA 9199","","","","","","","","","");
INSERT INTO nom VALUES("3610000400","L/C INDONESIA BROZA 9390","","","","","","","","","");
INSERT INTO nom VALUES("3610000404","L/C STERIC 10014/2","","","","","","","","","");
INSERT INTO nom VALUES("3610000406","L/C SULPHONIC MIWON 0214","","","","","","","","","");
INSERT INTO nom VALUES("3610000407","L/C SULPHONIC INDIA 0153","","","","","","","","","");
INSERT INTO nom VALUES("3610000409","L/C STERIC 10014/1","","","","","","","","","");
INSERT INTO nom VALUES("3610000413","L/C SULPHONIC MIWON 0690","","","","","","","","","");
INSERT INTO nom VALUES("3610000415","L/C SULPHONIC LG 0691","","","","","","","","","");
INSERT INTO nom VALUES("3610000424","L/C SULPHONIC CHINA 0310","","","","","","","","","");
INSERT INTO nom VALUES("3610000425","L/C SULPHONIC CHINA 0693","","","","","","","","","");
INSERT INTO nom VALUES("3610000439","L/C LATEX RUBBER 3874","","","","","","","","","");
INSERT INTO nom VALUES("3610000447","L/C VIETNAM BROZA 4705","","","","","","","","","");
INSERT INTO nom VALUES("3610000451","L/C INDONESIA BROZA 3873","","","","","","","","","");
INSERT INTO nom VALUES("3610000452","L/C VIETNAM BAROZA 4984","","","","","","","","","");
INSERT INTO nom VALUES("3610000457","L/C CHINA BROZA 6297","","","","","","","","","");
INSERT INTO nom VALUES("3610000458","L/C INDONESIA BROZA 6061","","","","","","","","","");
INSERT INTO nom VALUES("3610000459","L/C INDONESIA BROZA 6570","","","","","","","","","");
INSERT INTO nom VALUES("3610000460","L/C INDONESIA BROZA 6571","","","","","","","","","");
INSERT INTO nom VALUES("3610000465","L/C BROZA INDONESIA 6062","","","","","","","","","");
INSERT INTO nom VALUES("3610000470","L/C BROZA INDONESIA 8438","","","","","","","","","");
INSERT INTO nom VALUES("3610000478","L/C BROZA INDONESIA 9232","","","","","","","","","");
INSERT INTO nom VALUES("3610000491","L/C VIETNAM BROZA  4927","","","","","","","","","");
INSERT INTO nom VALUES("3610000492","L/C INDONESIA BROZA 6402","","","","","","","","","");
INSERT INTO nom VALUES("3610000501","L/C INDONESIA BROZA 8438","","","","","","","","","");
INSERT INTO nom VALUES("3610000502","L/C INDONESIA BROZA 8468","","","","","","","","","");
INSERT INTO nom VALUES("3610000503","L/C INDONESIA BROZA 2012","","","","","","","","","");
INSERT INTO nom VALUES("3610000506","L/C INDONESIA BROZA 2065","","","","","","","","","");
INSERT INTO nom VALUES("3610000512","L/C VIETNAM BROZA 7112","","","","","","","","","");
INSERT INTO nom VALUES("3610000513","L/C VIETNAM BROZA 7012","","","","","","","","","");
INSERT INTO nom VALUES("3610000514","L/C INDONESIA BROZA 0312","","","","","","","","","");
INSERT INTO nom VALUES("3610000518","L/C INDONESIA BROZA IBRAHIM KARACHI","","","","","","","","","");
INSERT INTO nom VALUES("3610000521","L/C VIETNAM BROZA 0712","","","","","","","","","");
INSERT INTO nom VALUES("3610000532","L/C INDONESIA BROZA  28454","","","","","","","","","");
INSERT INTO nom VALUES("3610000544","L/C NEPALI BROZA NO-1 BAZREYA IBRAHIM WALI MUHAMAD","","","","","","","","","");
INSERT INTO nom VALUES("3610000545","L/C INDONESIA BROZA CONTRACT 25288","","","","","","","","","");
INSERT INTO nom VALUES("3610000546","L/C INDONESIA BROZA CONTRACT 25719","","","","","","","","","");
INSERT INTO nom VALUES("3610000549","L/C NEPALI BROZA CONTRACT 25795","","","","","","","","","");
INSERT INTO nom VALUES("3610000550","L/C NEPALI BROZA NO-2   P-985","","","","","","","","","");
INSERT INTO nom VALUES("3610000553","L/C MOM CHINA 30719","","","","","","","","","");
INSERT INTO nom VALUES("3610000555","L/C NEPALI BROZA CONTRACT 27207","","","","","","","","","");
INSERT INTO nom VALUES("3610000559","L/C NEPALI BROZA CONTRACT 27830","","","","","","","","","");
INSERT INTO nom VALUES("3610000560","L/C INDONESIA BROZA 33395","","","","","","","","","");
INSERT INTO nom VALUES("3610000570","L/C VIETNAM BROZA 27052","","","","","","","","","");
INSERT INTO nom VALUES("3610000580","L/C INDONESIA BROZA 38477","","","","","","","","","");
INSERT INTO nom VALUES("3610000581","L/C MOM CHINA 38980","","","","","","","","","");
INSERT INTO nom VALUES("3610000584","L/C INDONESIA BROZA 40656","","","","","","","","","");
INSERT INTO nom VALUES("3610000586","L/C INDONESIA BROZA 44193","","","","","","","","","");
INSERT INTO nom VALUES("3610000590","L/C INDONESIA BROZA 29955","","","","","","","","","");
INSERT INTO nom VALUES("3610000591","L/C INDONESIA BROZA CONTRACT 27223","","","","","","","","","");
INSERT INTO nom VALUES("3610000592","L/C MOAM CHINA 31798","","","","","","","","","");
INSERT INTO nom VALUES("3610000593","L/C MOAM CHINA 32946","","","","","","","","","");
INSERT INTO nom VALUES("3610000597","L/C INDONESIA BROZA 39394","","","","","","","","","");
INSERT INTO nom VALUES("3610000600","L/C MOAM CHINA 46583","","","","","","","","","");
INSERT INTO nom VALUES("3610000601","L/C INDONESIA BROZA CONTRACT 25270","","","","","","","","","");
INSERT INTO nom VALUES("3610000603","L/C INDONESIA BROZA CONTRACT 25531","","","","","","","","","");
INSERT INTO nom VALUES("362000","PRE-PAYMENTS","","1901","","","","","","","");
INSERT INTO nom VALUES("3620000001","MAZHAR ENG.WORKS,FEROZEPUR","","1901","","","","","","","");
INSERT INTO nom VALUES("368000","OTHER RECEIVABLES","","1901","","","","","","","");
INSERT INTO nom VALUES("3680000001","MAQBOOL ENTERPRISES SAHIWAL","","1901","","","","","","","");
INSERT INTO nom VALUES("3680000002","TANNERIES ASSOCIATION,DINGARH,KASUR","","1901","","","","","","","");
INSERT INTO nom VALUES("369000","DEPOSITS","","1901","","","","","","","");
INSERT INTO nom VALUES("369010","ADVANCES TO DIRECTORS","","1901","","","","","","","");
INSERT INTO nom VALUES("3690100001","ADVANCES TO MR. SHABBIR MALIK","","1901","","","","","","","");
INSERT INTO nom VALUES("3690100002","ADVANCES TO MR. TAUQIR MALIK","","1901","","","","","","","");
INSERT INTO nom VALUES("37","CASH & BANKS","","0","","","","","","","");
INSERT INTO nom VALUES("370001","CASH IN HAND","","1999","","","","","","","");
INSERT INTO nom VALUES("3700010001","CASH IN HAND","","1999","","","","","","","");
INSERT INTO nom VALUES("375000","BANK ACCOUNTS","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000001","7940","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000002","4651","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000003","7700","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000004","ASKARI BANK MIR PUR","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000005","ASKARI BANK KARACHI","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000006","625","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000007","8790","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000008","540","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000009","1147","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000010","4221","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000011","419","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000012","K-116","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000013","131","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000014","446","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000015","018","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000016","2160","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000017","016","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000018","9808","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000019","149","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000020","801","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000021","308","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000022","2068","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000024","962","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000025","901","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000027","500","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000028","343","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000029","3002","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000030","0013","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000032","5400","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000033","057","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000034","024","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000035","LOCKER A/C","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000036","8869","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000037","100","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000038","766","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000039","803","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000040","968","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000041","4099","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000042","614","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000043","178","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000044","5416","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000045","014","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000046","842","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000047","900","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000048","603","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000049","010","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000050","4571","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000051","447","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000052","667","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000053","267","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000054","3017","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000055","542","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000056","3021","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000057","774","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000058","369","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000059","0016","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000060","1505","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000061","5015","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000062","0037","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000063","1753","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000064","1799","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000065","3015","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000066","1014","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000067","8014","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000068","9015","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000069","1500","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000070","9000","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000071","400","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000072","700","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000073","1700","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000074","5010","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000075","4993","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000076","4995","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000077","4996","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000078","7122","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000079","6951","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000080","137","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000081","812","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000082","227","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000083","788","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000084","1421","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000085","653","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000086","165","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000087","158","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000088","552","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000089","1376","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000090","048","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000091","059","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000092","067","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000093","213","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000094","20201","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000095","40201","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000096","60201","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000097","485","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000098","154","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000099","1013","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000100","497","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000101","160","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000102","7070","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000103","6732","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000104","6929","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000105","6988","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000106","5905","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000107","0121","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000108","4680","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000109","4557","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000110","3615","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000111","1360","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000112","2046","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000113","8084","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000114","345","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000115","353","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000116","4646","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000117","580","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000118","2386","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000119","0941","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000120","3004","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000121","2997","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000122","6542","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000123","2184","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000124","331","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000125","2878","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000126","7352","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000127","7353","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000128","000016","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000129","000015","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000130","3360","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000131","5373","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000132","1413","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000133","5684","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000134","9974","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000135","3023","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000136","5046","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000137","836","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000138","8297","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000139","2571","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000140","1291","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000141","1333","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000142","8454","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000143","8188","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000144","1844","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000145","784","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000146","5013","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000147","3504","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000148","9130","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000149","5014","","1999","","","","","","","");
INSERT INTO nom VALUES("3750000150","shares","","1999","","","","","","","");
INSERT INTO nom VALUES("41","SALES","","0","","","","","","","");
INSERT INTO nom VALUES("410000","SALES","","4101","","","","","","","");
INSERT INTO nom VALUES("4100000010","SALES - GROSS","","4101","","","","","","","");
INSERT INTO nom VALUES("4100000020","FREIGHT ON SALES","","4101","","","","","","","");
INSERT INTO nom VALUES("4100000030","SALES RETURN","","4101","","","","","","","");
INSERT INTO nom VALUES("4100000040","SALES DISCOUNTS","","4101","","","","","","","");
INSERT INTO nom VALUES("410001","EXPORT SALE","","4101","","","","","","","");
INSERT INTO nom VALUES("42","COST OF SALES","","0","","","","","","","");
INSERT INTO nom VALUES("420001","COST OF SALES","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010001","FREIGHT","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010002","LOADING/UNLOADING CHARGES","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010003","GODOWN RENT","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010004","INSURANCE","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010005","REPAIR MAINTENANCE (COS)","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010006","GODOWN ELECTRICITY","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010007","GODOWN STAFF SALARY","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010009","CHONA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010010","CHINA BROZA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010011","INDONESIA BROZA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010012","TORA MOAM PAKISTANI KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010013","IRANI MOAM KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010014","BROZA VEITNAM KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010015","MOAM CHINA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010016","GLYECRINE KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010017","STERIC KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010018","TORA BROZA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010019","TIN BROZA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010020","MOAM HUNGRY KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010021","DRUM IRANI MOAM KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010022","OIL TARPIN KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010023","MOAM TAIWAN KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010024","DANA WAX  KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010025","SOUP NODLE KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010026","PHATKARI  KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010027","SULPHONIC MIWON KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010028","SULPHONIC INDIA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010029","SODA ASH KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010030","CAUSTIC PATRI KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010031","STARCH KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010032","SULPHONIC LG KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010033","RASIN KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010034","CARNOBA WAX KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010035","PAKISTANI DRUM MOAM KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010036","SULPHONIC CHINA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010037","WHITE OIL KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010038","SULPHONIC IRANI KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010039","VASELINE KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010040","MITHA SODA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010041","MICRO WAX KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010042","SUPURDARE KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010043","PAKISTANI MOM KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010044","GODOWN KHATA SHAH MUHAMMAD GHOSE","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010045","SULPHONIC TUFAIL KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010046","MALEIC KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010047","INDIA BROZA KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010048","SECURITY DUBI KHATA 3017","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010049","KHALI DRUM KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("4200010050","SHAMPOO BASE KHATA","","5101","","","","","","","");
INSERT INTO nom VALUES("420002","DISCOUNT CONTROL A/C","","5101","","","","","","","");
INSERT INTO nom VALUES("4200020001","DISCOUNT ON SALES","","5101","","","","","","","");
INSERT INTO nom VALUES("420003","COST OF PURCHASES","","5101","","","","","","","");
INSERT INTO nom VALUES("4200030001"," COST OF PURCHASES","","5101","","","","","","","");
INSERT INTO nom VALUES("429990","SELLING AND MARKETING EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900000","BROUCHER PRINTING","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900001","PETROL - MARKETING","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900002","ALLOWNCES","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900003","OTHERS","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900005","PACKING MATERIAL","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900006","SALES PROMPOTIONS INVESTMENT","","6101","","","","","","","");
INSERT INTO nom VALUES("4299900010","DISCOUNT CONTROL A/C","","6101","","","","","","","");
INSERT INTO nom VALUES("429991","ADMIN EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("429992","DISCOUNTS ON SALES","","5101","","","","","","","");
INSERT INTO nom VALUES("4299920000","DISCOUNTS ON SALES CONTROL A/C","","5101","","","","","","","");
INSERT INTO nom VALUES("4299920001","CREDIT NOTE","","5101","","","","","","","");
INSERT INTO nom VALUES("4299920002","SALES PROMOTIONS","","5101","","","","","","","");
INSERT INTO nom VALUES("43","SALARY,WAGES AND OTHER BENEFITS","","0","","","","","","","");
INSERT INTO nom VALUES("430001"," SALARIES","","6101","","","","","","","");
INSERT INTO nom VALUES("4300010003","SALARIES","","6101","","","","","","","");
INSERT INTO nom VALUES("4300010004","WORKERS PAYMENT","","6101","","","","","","","");
INSERT INTO nom VALUES("4300010005","PARTNERS SALARY","","6101","","","","","","","");
INSERT INTO nom VALUES("430002","STAFF BENEFITS","","6101","","","","","","","");
INSERT INTO nom VALUES("4300020001","EID BONUS","","6101","","","","","","","");
INSERT INTO nom VALUES("4300020002","EIDI LABOUR","","6101","","","","","","","");
INSERT INTO nom VALUES("430003","STAFF WELFARE","","6101","","","","","","","");
INSERT INTO nom VALUES("44","OVERHEADS","","0","","","","","","","");
INSERT INTO nom VALUES("45","EXPENSES - BLANK","","0","","","","","","","");
INSERT INTO nom VALUES("450001","HEAD OFFICE EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("450002","FACTORY EXPENSES","","6101","","","","","","","");
INSERT INTO nom VALUES("4500020001","PURCHASE OF CONSUMABLE STORES FOR FACTOR","","6101","","","","","","","");
INSERT INTO nom VALUES("450003","EXPENSES - NASIR IQBAL","","6101","","","","","","","");
INSERT INTO nom VALUES("46","BLANK","","0","","","","","","","");
INSERT INTO nom VALUES("465003","TRAVELLING EXPENSES","","6201","","","","","","","");
INSERT INTO nom VALUES("469900","DISCOUNT ON SALES","","6201","","","","","","","");
INSERT INTO nom VALUES("469901","SALE PROMOTIONS","","6201","","","","","","","");
INSERT INTO nom VALUES("47","FINANCIAL EXPENSES","","0","","","","","","","");
INSERT INTO nom VALUES("470000","FINANCIAL CHARGES","","6301","","","","","","","");
INSERT INTO nom VALUES("4700000001","BANK CHARGES","","6301","","","","","","","");
INSERT INTO nom VALUES("4700000002","INTEREST CHARGES","","6301","","","","","","","");
INSERT INTO nom VALUES("4700000003","MARKUP","","6301","","","","","","","");
INSERT INTO nom VALUES("4700000004","CURRENCY RATE DIFFERENCE","","6301","","","","","","","");
INSERT INTO nom VALUES("48","OTHER INCOME","","0","","","","","","","");
INSERT INTO nom VALUES("480001","COMMISSIONS","","8101","","","","","","","");
INSERT INTO nom VALUES("4800010003","COMMISSION INCOME ON IMPORT OF CHEMICALS","","8101","","","","","","","");
INSERT INTO nom VALUES("4800010005","SCRAPE SALES","","8101","","","","","","","");
INSERT INTO nom VALUES("480002","PROPERTY INCOME","","8101","","","","","","","");
INSERT INTO nom VALUES("4800020001","RENT LAL MAQSOOD MARKET","","8101","","","","","","","");
INSERT INTO nom VALUES("480003","SCRAPE SALES","","8101","","","","","","","");
INSERT INTO nom VALUES("4800030001","SCRAPE SALES","","8101","","","","","","","");
INSERT INTO nom VALUES("49","OTHER EXPENSES","","0","","","","","","","");
INSERT INTO nom VALUES("490001","PAMENTS TO MSP","","9101","","","","","","","");
INSERT INTO nom VALUES("4900010001","CASH PAYMENTS TO MSP","","9101","","","","","","","");
INSERT INTO nom VALUES("490002","KARACHI OFFICE","","6201","","","","","","","");
INSERT INTO nom VALUES("4900020001","OFFICE RENT KHI","","6201","","","","","","","");
INSERT INTO nom VALUES("490003","PRINTING SECTOR","","8101","","","","","","","");
INSERT INTO nom VALUES("4900030001","DMI PRINTING","","8101","","","","","","","");
INSERT INTO nom VALUES("490004","SUSPENSE","","8101","","","","","","","");
INSERT INTO nom VALUES("4900040001","SUSPENSE INCOME","","8101","","","","","","","");
INSERT INTO nom VALUES("490005","SUSPENSE","","9101","","","","","","","");
INSERT INTO nom VALUES("4900050001","SUSPENSE PAYMENTS","","9101","","","","","","","");
INSERT INTO nom VALUES("60","L/C EXPENSES","","1901","","","","","","","");
INSERT INTO nom VALUES("600001","L/C EXPENSES","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010001","IMPORT L/C MARGIN","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010002","IMPORT L/C OPENING CHARGES","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010003","IMPORT RETIRING AMOUNT","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010004","IMPORT RETIRING CHARGES","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010005","IMPORT CLEARING AGENTS & CLEARING","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010006","IMPORT TRANSPORTATION","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010007","IMPORT DUTIES,TAXES & CHARGES","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010008","IMPORT TT","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010009","IMPORT TT CHARGES","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010010","IMPORT INSURANCE","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010011","IMPORT ON","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010012","IMPORT DOCUMENTATION CHARGES","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010013","IMPORT SECURITY","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010014","IMPORT FRIEGHT AND CUSTOM","","1901","","","","","","","");
INSERT INTO nom VALUES("6000010015","IMPORT RENT","","1901","","","","","","","");
INSERT INTO nom VALUES("99","COST CENTERS","","0","","","","","","","");
INSERT INTO nom VALUES("990000","CS FOR DISTRIBUTIONS","","6201","","","","","","","");


DROP TABLE IF EXISTS nom_copy;

CREATE TABLE `nom_copy` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT 'HO'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO nom_copy VALUES("01","CAPITAL & LIABILITIES","0","","","HO");


DROP TABLE IF EXISTS nom_lc;

CREATE TABLE `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS nom_old;

CREATE TABLE `nom_old` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '01',
  PRIMARY KEY (`comp_id`,`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO nom_old VALUES("01","Expenses","0","","","01");
INSERT INTO nom_old VALUES("010001","DIRECT EXPENSES","31","","5","01");
INSERT INTO nom_old VALUES("0100010001","COST OF GOOD SOLD","","","","01");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","31","","61","01");
INSERT INTO nom_old VALUES("0100020001","ENTERTAINMENT EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020002","TRAVELLING EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020003","STATIONARY","","","","01");
INSERT INTO nom_old VALUES("0100020004","ADVERTISEMENT EXP","","","","01");
INSERT INTO nom_old VALUES("0100020005","GROCERY EXP","","","","01");
INSERT INTO nom_old VALUES("0100020006","OFFICE EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020007","REPAIR AND MAINTAINANCE
\n","","","","01");
INSERT INTO nom_old VALUES("0100020008","RENT WAREHOUSE","","","","01");
INSERT INTO nom_old VALUES("0100020009","FLAGSHIP OUTLET EXPENSES","","","","01");
INSERT INTO nom_old VALUES("0100020010","KARIM BLOCK OUTLET EXPENSES","","","","01");
INSERT INTO nom_old VALUES("010003","OPENING BALANCES","","","","01");
INSERT INTO nom_old VALUES("0100030001","OPENING BALANCES","","","","01");
INSERT INTO nom_old VALUES("010010","STAFF SALARIES","","","","01");
INSERT INTO nom_old VALUES("0100100001","STAFF SALARIES","","","","01");
INSERT INTO nom_old VALUES("02","EQUITY","","","","01");
INSERT INTO nom_old VALUES("020001","PROPRITERS CAPITAL","","","","01");
INSERT INTO nom_old VALUES("0200010001","PROPRITERS CAPITAL","","","","01");
INSERT INTO nom_old VALUES("0200010002","OPENING BALANCE ADJUSTMENT ACOOUNT","","","","01");
INSERT INTO nom_old VALUES("03","Short Term Liabilites","","","","01");
INSERT INTO nom_old VALUES("030007","Accrued Salaries","","","","01");
INSERT INTO nom_old VALUES("0300070001","SALARY PAYABLE KAMRAN","","","","01");
INSERT INTO nom_old VALUES("0300070002","SALARY PAYABLE - NADISH","","","","01");
INSERT INTO nom_old VALUES("0300070003","SALARY PAYABLE - KHURRAM","","","","01");
INSERT INTO nom_old VALUES("0300070004","SALARY PAYABLE - JAVED","","","","01");
INSERT INTO nom_old VALUES("0300070005","SALARY PAYABLE - FAROOQ","","","","01");
INSERT INTO nom_old VALUES("0300070006","SALARY PAYABLE - SHUJA BAHI (TAX ADVISOR)","","","","01");
INSERT INTO nom_old VALUES("0300070007","SALARY PAYABLE - VICTOR","","","","01");
INSERT INTO nom_old VALUES("0300070008","SALARY PAYABLE - MOHSIN","","","","01");
INSERT INTO nom_old VALUES("0300070009","SALARY PAYABLE - FAISAL","","","","01");
INSERT INTO nom_old VALUES("0300070010","SALARY PAYABLE - TALAH","","","","01");
INSERT INTO nom_old VALUES("0300070011","SALARY PAYABLE - SIKANDAR","","","","01");
INSERT INTO nom_old VALUES("0300070012","SALARY PAYABLE - SONIL","","","","01");
INSERT INTO nom_old VALUES("0300070013","SALARY PAYABLE - ALI RAZA","","","","01");
INSERT INTO nom_old VALUES("10","LIABILITIES","","","","01");
INSERT INTO nom_old VALUES("100001","VENDOR FINISHED GOODS","","","","01");
INSERT INTO nom_old VALUES("1000010001","VENDOR SHOES - KASHIF PAYABLE","","","","01");
INSERT INTO nom_old VALUES("1000010002","MR MAJEED (KURTA)","","","","01");
INSERT INTO nom_old VALUES("1000010003","MR TAHIR (WAIST COAT)","","","","01");
INSERT INTO nom_old VALUES("1000010004","MR ARIF (EMBROIDARY)","","","","01");
INSERT INTO nom_old VALUES("1000010005","MR MUSHTAQ (HSY)","","","","01");
INSERT INTO nom_old VALUES("1000010006","HUMD INTERNATIONAL PVT LTD","","","","01");
INSERT INTO nom_old VALUES("100002","VENDOR RAW MATERIAL","","","","01");
INSERT INTO nom_old VALUES("1000020001","HAMZA AKHTAR","","","","01");
INSERT INTO nom_old VALUES("1000020002","HAJI KHAN","","","","01");
INSERT INTO nom_old VALUES("1000020003","WAZIR AHMED","","","","01");
INSERT INTO nom_old VALUES("1000020004","ZAKIR","","","","01");
INSERT INTO nom_old VALUES("1000020005","LONDON","","","","01");
INSERT INTO nom_old VALUES("1000020006","DARWESH KHAN","","","","01");
INSERT INTO nom_old VALUES("1000020007","AL-REHMAT","","","","01");
INSERT INTO nom_old VALUES("1000020008","SHADMAN","","","","01");
INSERT INTO nom_old VALUES("20","STOCK","","","","01");
INSERT INTO nom_old VALUES("200001","STOCK IN TRADE","","","","01");
INSERT INTO nom_old VALUES("2000010001","STOCK IN TRADE (RM)","","","","01");
INSERT INTO nom_old VALUES("2000010002","STOCK IN TRADE (FG)","","","","01");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","01");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","01");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","19","","","01");
INSERT INTO nom_old VALUES("2710000002","ELECTRONICS","","","","01");
INSERT INTO nom_old VALUES("2710000003","FURNITURE","","","","01");
INSERT INTO nom_old VALUES("272000","BANK BALANCES","","","","01");
INSERT INTO nom_old VALUES("2720000001","HABIB BANK","","","","01");
INSERT INTO nom_old VALUES("2720000002","FAYSAL BANK","","","","01");
INSERT INTO nom_old VALUES("273000","OUTLET","","","","01");
INSERT INTO nom_old VALUES("2730000001","HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("2730000002","STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("2730000003","DREAMS","","","","01");
INSERT INTO nom_old VALUES("2730000004","EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("2730000005","EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("2730000006","SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("2730000007","FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("2730000008","OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("2730000009","BWP ","","","","01");
INSERT INTO nom_old VALUES("2730000012","KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("41","TURNOVER","","","","01");
INSERT INTO nom_old VALUES("410001","SALE","","","4","01");
INSERT INTO nom_old VALUES("4100010001","SALES - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100010002","SALE - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100010003","SALES - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100010004","SALES - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100010005","SALES - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100010006","SALES - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100010007","SALES - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100010008","SALES - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100010009","SALES - BWP","","","","01");
INSERT INTO nom_old VALUES("4100010012","SALES - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410002","DISCOUNT","","","","01");
INSERT INTO nom_old VALUES("4100020001","DISCOUNT - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100020002","DISCOUNT - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100020003","DISCOUNT - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100020004","DISCOUNT - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100020005","DISCOUNT - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100020006","DISCOUNT - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100020007","DISCOUNT - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100020008","DISCOUNT - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100020009","DISCOUNT - BWP","","","","01");
INSERT INTO nom_old VALUES("4100020012","DISCOUNT - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410003","SALES RETURN","","","","01");
INSERT INTO nom_old VALUES("4100030001","RETURN - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100030002","RETURN - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100030003","RETURN - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100030004","RETURN - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100030005","RETURN - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100030006","RETURN - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100030007","RETURN - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100030008","RETURN - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100030009","RETURN - BWP","","","","01");
INSERT INTO nom_old VALUES("4100030012","RETURN - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410004","CREDIT NOTES","","","","01");
INSERT INTO nom_old VALUES("4100040001","CREDIT NOTES - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100040002","CREDIT NOTES - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100040003","CREDIT NOTES - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100040004","CREDIT NOTES - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100040005","CREDIT NOTES - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100040006","CREDIT NOTES - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100040007","CREDIT NOTES - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100040008","CREDIT NOTES - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100040009","CREDIT NOTES - BWP","","","","01");
INSERT INTO nom_old VALUES("4100040012","CREDIT NOTES - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("410005","DEBIT NOTES","","","","01");
INSERT INTO nom_old VALUES("4100050001","DEBIT NOTES - HEAD OFFICE","","","","01");
INSERT INTO nom_old VALUES("4100050002","DEBIT NOTES - STUDIO MEER","","","","01");
INSERT INTO nom_old VALUES("4100050003","DEBIT NOTES - DREAMS","","","","01");
INSERT INTO nom_old VALUES("4100050004","DEBIT NOTES - EQUATOR(KB)","","","","01");
INSERT INTO nom_old VALUES("4100050005","DEBIT NOTES - EQUATOR(LR)","","","","01");
INSERT INTO nom_old VALUES("4100050006","DEBIT NOTES - SATELLITE TOWN","","","","01");
INSERT INTO nom_old VALUES("4100050007","DEBIT NOTES - FLAGSHIP STORE","","","","01");
INSERT INTO nom_old VALUES("4100050008","DEBIT NOTES - OUTLET(KB)","","","","01");
INSERT INTO nom_old VALUES("4100050009","DEBIT NOTES - BWP","","","","01");
INSERT INTO nom_old VALUES("4100050012","DEBIT NOTES - KAREEM BLOCK","","","","01");
INSERT INTO nom_old VALUES("99","COST CENTRES","","","","01");
INSERT INTO nom_old VALUES("990001","STAFF","","","","01");
INSERT INTO nom_old VALUES("9900010001","ALI SHAN","","","","01");
INSERT INTO nom_old VALUES("9900010002","HUSNAIN","","","","01");
INSERT INTO nom_old VALUES("9900010003","MUSA","","","","01");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","02");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","02");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","02");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","05");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","05");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","05");
INSERT INTO nom_old VALUES("20","STOCK","","","","06");
INSERT INTO nom_old VALUES("200001","STOCK IN TRADE","","","","06");
INSERT INTO nom_old VALUES("2000010001","STOCK IN TRADE (RM)","","","","06");
INSERT INTO nom_old VALUES("2000010002","STOCK IN TRADE (FG)","","","","06");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","06");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","06");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","06");
INSERT INTO nom_old VALUES("01","Expenses","","","","07");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","07");
INSERT INTO nom_old VALUES("0100020009","FLAGSHIP OUTLET EXPENSES","","","","07");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","07");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","07");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","07");
INSERT INTO nom_old VALUES("01","Expenses","","","","08");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","08");
INSERT INTO nom_old VALUES("0100020009","KAREEM BLOCK OUTLET EXPENSES","","","","08");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","08");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","08");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","08");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","10");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","10");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","10");
INSERT INTO nom_old VALUES("01","Expenses","","","","12");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","12");
INSERT INTO nom_old VALUES("0100020009","KAREEM BLOCK OUTLET EXPENSES","","","","12");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","12");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","12");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","12");
INSERT INTO nom_old VALUES("01","Expenses","","","","13");
INSERT INTO nom_old VALUES("010002","INDIRECT EXPENSES","","","","13");
INSERT INTO nom_old VALUES("0100020009","FLAGSHIP OUTLET EXPENSES","","","","13");
INSERT INTO nom_old VALUES("27","CURRENT ASSETS","","","","13");
INSERT INTO nom_old VALUES("271000","CASH ACCOUNTS","","","","13");
INSERT INTO nom_old VALUES("2710000001","CASH IN HAND","","","","13");


DROP TABLE IF EXISTS o_batch;

CREATE TABLE `o_batch` (
  `PROD_ID` varchar(4) NOT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `BAL_QTY` decimal(10,0) DEFAULT NULL,
  `O_QTY` decimal(10,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO o_batch VALUES("0420","2017-04-30 00:00:00","TOS-1525","","1200");


DROP TABLE IF EXISTS o_voucher;

CREATE TABLE `o_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime NOT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `POSTED` varchar(1) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS o_voucherdet;

CREATE TABLE `o_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(13,2) DEFAULT NULL,
  `CREDIT` decimal(13,2) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS o_voucherdet_e;

CREATE TABLE `o_voucherdet_e` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `BPV_ID` varchar(20) DEFAULT NULL,
  `TENDER_NO` varchar(50) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS party;

CREATE TABLE `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO party VALUES("C0001","Walk-In-Customer","","","","","","undefined","","","","","","","","","2610000001","C","","","","","");
INSERT INTO party VALUES("S0002","Ashfaq Sons","","","","0","","undefined","","","","","","","","","1310000001","S","","","","","");
INSERT INTO party VALUES("S0003","Bath Tec","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0004","Porta Acrylic Bath Tubs Lahore","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0005","MAGOON TRADERS","","","","","","undefined","","","","","","","","","1310000006","S","","","","","");
INSERT INTO party VALUES("S0006","TREND BATHROOM ACCESSORIES","","","GUJRANWALA","","","undefined","","","","","","","","","1310000003","S","","","","","");
INSERT INTO party VALUES("S0007","SABAAN","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0008","URBAN CERAMICS","","","","","","undefined","","","","","","","","","1310000004","S","","","","","");
INSERT INTO party VALUES("S0009","SYMBOL INDUSTRIES (PVT.)LTD","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0010","MASTER","","","","","","undefined","","","","","","","","","1310000007","S","","","","","");
INSERT INTO party VALUES("S0011","DIAMOND","","","","","","undefined","","","","","","","","","1310000008","S","","","","","");
INSERT INTO party VALUES("S0012","A","","","","","","undefined","","","","","","","","","1310000009","S","","","","","");
INSERT INTO party VALUES("S0013","STYLE BATH WARE","","","","","","undefined","","","","","","","","","1310000005","S","","","","","");
INSERT INTO party VALUES("S0014","JAVAID","","","","","","undefined","","","","","","","","","1310000014","","","","null","","");
INSERT INTO party VALUES("S0015","MAHMOOD SONS","","","","","","undefined","","","","","","","","","1310000028","","","","null","","");
INSERT INTO party VALUES("S0016","NATURE","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0017","MA TRADERS","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0018","RAVI TRADERS","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0019","GORA TRADERS","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0020","PEARL DECOR","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0021","AL-HARMAIN PAINT CENTRE","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0022","KAPADIA INTERIOR","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0023","VEGA","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0024","BUTT SENTERY","","","","","","undefined","","","","","","","","","","S","","","","","");
INSERT INTO party VALUES("S0025","TARIQ","","","","","","undefined","","","","","","","","","","S","","","Selet S","","");
INSERT INTO party VALUES("C0036","904/K PHS#6 DHA 03228470847","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("SS0027","PERFACT HOME","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0028","MAHMOOD GUJRANWALA","","","GUJRANWALA","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0029","KBS","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0003","Gourmet","","","","","","undefined","","","","","","","","","2610000003","C","","","Selet S","","");
INSERT INTO party VALUES("V0001","GOROHE","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0002","H.M.SONS PVT. LTD.","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0003","SKY SANITORY","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0004","MIDAS","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0005","USAMA PRINTING","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0006","ALLAH WASAYA","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0007","SAMAAR SKIRTING","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0008","MIAN FAKHAR","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0009","USMAN","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("C0027","SAYYAD BROTHER","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("V0010","BASRA BROTHERS","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0011","VIZDOM","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("C0028","KASHIF SB 245/G PHS# 5 DHA","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("V0012","SILLA CONCEPT\'S","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0013","Cash Purchase","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("C0029","FAROOQ KHAN SB - 03214008311","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("S0026","IMC","","","","","","undefined","","","","","","","","","1310000027","S","","","Selet S","","");
INSERT INTO party VALUES("C0030","200/1-B ST-NO #1 PHASE-5 DHA","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0031","36-D LAWRENCE ROAD LHR 03034291889","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0032","AHMAD SB","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0033","OLYMPIA BUILDERS","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0034","H-NO. 923/D PHS 6 DHA LHR","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0035","MR. ANEES SB 0321-4185133","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0037","547/D 0322454045","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0038","MALL OF SIALKOT","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("S0027","MUHAMMADI STORE","","","","","","undefined","","","","","","","","","","S","","","Selet S","","");
INSERT INTO party VALUES("P0001","DISPLAY","","","","","","undefined","","","","","","","","","","P","","","Selet S","","");
INSERT INTO party VALUES("C0039","SHOAIB KHAN SB","","","","","","undefined","","","","","","","","","","C","","","Selet S","","");
INSERT INTO party VALUES("C0040","NADEEM SB CUSTOMER","","","","","","undefined","","","","","","","","","","","","","null","","");
INSERT INTO party VALUES("V0014","CANON","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0015","AMJAD GUJRANWALA","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0016","GODI COMMODE","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0017","ANSARI PLASTIC","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0018","ASIAN STANDERED","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0019","LEXTA","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");
INSERT INTO party VALUES("V0020","SHEN CHINEESE","","","","","","undefined","","","","","","","","","","V","","","Selet S","","");


DROP TABLE IF EXISTS party_add;

CREATE TABLE `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS party_product;

CREATE TABLE `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO party_product VALUES("0001","0357","46.000","","","","3");


DROP TABLE IF EXISTS party_type;

CREATE TABLE `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO party_type VALUES("C","Customer");
INSERT INTO party_type VALUES("S","Supplier");
INSERT INTO party_type VALUES("T","Trader");
INSERT INTO party_type VALUES("I","Import");
INSERT INTO party_type VALUES("P","Production");
INSERT INTO party_type VALUES("A","Cash");
INSERT INTO party_type VALUES("O","Other");
INSERT INTO party_type VALUES("V","Vender");


DROP TABLE IF EXISTS pay_mode;

CREATE TABLE `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_dc;

CREATE TABLE `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_dcdet;

CREATE TABLE `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_gp;

CREATE TABLE `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_gpdet;

CREATE TABLE `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_grn;

CREATE TABLE `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_grndet;

CREATE TABLE `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_invoice;

CREATE TABLE `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoice VALUES("070001","2017-07-15","2610000154","0.00","0.00","1410000.00","","","","","","","","","","","","","01","","2017-07-15 11:07:09","","0001","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","1410000");


DROP TABLE IF EXISTS pl_invoice_adv;

CREATE TABLE `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_invoice_copy;

CREATE TABLE `pl_invoice_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoice_copy VALUES("060025","2017-06-14","1310000029","0.00","0.00","5500.00","","","","","","","","","","","","","01","","2017-06-17 11:29:21","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060024","2017-06-14","1310000033","0.00","0.00","36542.00","","","","","","","","","","","","","01","","2017-06-17 11:27:54","","0001","","0.000","","","36542.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060023","2017-06-13","1310000031","0.00","0.00","350.00","","","","","","","","","","","","","01","","2017-06-17 11:30:18","","0001","","0.000","","","350.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060022","2017-06-13","1310000","0.00","0.00","110.00","","","","","","","","","","","","","01","","2017-06-16 11:10:09","","0001","","0.000","","","110.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060021","2017-06-13","1310000028","250.00","0.00","1150.00","","","","","","","","","","","","","01","","2017-06-17 11:31:07","","0001","","0.000","","","1150.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060020","2017-06-13","1310000030","0.00","0.00","960.00","","","","","","","","","","","","","01","","2017-06-17 11:31:42","","0001","","0.000","","","960.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060019","2017-06-12","1310000","1109.00","0.00","5500.00","","","","","","","","","","","","","01","","2017-06-16 11:17:17","","0001","","0.000","","","5500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060018","2017-06-12","1310000014","0.00","0.00","990.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","990.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060017","2017-06-12","1310000006","2543.00","0.00","12415.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","12415.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060016","2017-06-12","1310000028","259.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060015","2017-06-12","1310000014","0.00","0.00","6750.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","6750.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060014","2017-06-08","1310000027","0.00","0.00","17340.00","","","","","","","","","","","","","01","","2017-06-16 17:56:00","","0001","","0.000","","","17340.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060013","2017-06-08","1310000006","2164.00","0.00","10570.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","10570.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060002","2017-06-01","1310000028","2098.00","0.00","9550.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","9550.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060001","2017-06-01","1310000028","0.00","0.00","10193.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","10193.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060012","2017-06-07","1310000034","0.00","0.00","150.00","","","","","","","","","","","","","01","","2017-06-16 17:56:54","","0001","","0.000","","","150.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060011","2017-06-07","1310000028","685.00","0.00","19885.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","19885.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060010","2017-06-06","1310000035","0.00","230.00","1330.00","","","","","","","","","","","","","01","","2017-06-19 17:06:48","","0001","","0.000","","","1330.00","","","","02","17","on","SILLA CONCEPT\'S","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060003","2017-06-02","1310000028","60379.00","0.00","26130.00","","","","","","","","","","","","","01","","2017-06-16 17:55:07","","0001","","0.000","","","26130.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060004","2017-06-03","1310000014","0.00","0.00","7500.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","7500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060005","2017-06-03","1310000014","0.00","0.00","8100.00","","","","","","","","","","","","","01","","2017-06-16 17:53:21","","0001","","0.000","","","8100.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060006","2017-06-03","1310000018","0.00","0.00","14500.00","","","","","","","","","","","","","01","","2017-06-16 17:59:43","","0001","","0.000","","","14500.00","","","","02","17","on","","","0","0","","","","","14500");
INSERT INTO pl_invoice_copy VALUES("060007","2017-06-05","1310000033","277.00","0.00","19770.00","","","","","","","","","","","","","01","","2017-06-16 18:00:30","","0001","","0.000","","","19770.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060008","2017-06-05","1310000006","710.00","0.00","6390.00","","","","","","","","","","","","","01","","2017-06-16 17:54:17","","0001","","0.000","","","6390.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060009","2017-06-06","1310000034","0.00","0.00","3500.00","","","","","","","815","","","","","","01","","2017-06-16 17:56:54","","0001","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060026","2017-06-14","1310000034","25.00","0.00","14000.00","","","","","","","","","","","","","01","","2017-06-16 12:25:58","","0001","","0.000","","","14000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060027","2017-06-14","1310000006","2192.00","0.00","17330.00","","","","","","","","","","","","","01","","2017-06-16 12:47:23","","0001","","0.000","","","17330.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060028","2017-06-15","1310000034","0.00","0.00","21000.00","","","","","","","","","","","","","01","","2017-06-16 18:06:26","","0001","","0.000","","","21000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060029","2017-06-17","1310000006","476.00","0.00","2324.00","","","","","","","","","","","","","01","","2017-06-19 10:43:46","","0001","","0.000","","","2324.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060030","2017-06-17","2610000042","0.00","0.00","950.00","","","","","","","","","","","","","01","","2017-06-19 11:07:41","","0001","","0.000","","","950.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060031","2017-06-17","2610000043","0.00","0.00","3500.00","","","","","","","","","","","","","01","","2017-06-19 11:10:49","","0001","","0.000","","","3500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060032","2017-06-20","1310000006","5804.00","0.00","28360.00","","","","","","","","","","","","","01","","2017-06-21 10:26:11","","0001","","0.000","","","28360.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060033","2017-06-21","1310000028","1824.00","0.00","8600.00","","","","","","","","","","","","","01","","2017-06-22 10:20:00","","0001","","0.000","","","8600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060034","2017-06-21","1310000006","3403.00","0.00","16000.00","","","","","","","","","","","","","01","","2017-06-22 10:27:07","","0001","","0.000","","","16000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060035","2017-06-22","1310000006","475.00","0.00","2700.00","","","","","","","","","","","","","01","","2017-06-23 10:33:09","","0001","","0.000","","","2700.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060036","2017-06-22","1310000006","4.00","0.00","56060.00","","","","","","","","","","","","","01","","2017-06-23 10:35:08","","0001","","0.000","","","56060.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060037","2017-06-22","1310000014","50.00","0.00","1000.00","","","","","","","","","","","","","01","","2017-06-23 10:36:01","","0001","","0.000","","","1000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO pl_invoice_copy VALUES("060038","2017-06-23","1310000028","59.00","0.00","1680.00","","","","","","","","","","","","","01","","2017-06-24 11:26:51","","0001","","0.000","","","1680.00","","","","02","17","on","","","0","0","","","","","0");


DROP TABLE IF EXISTS pl_invoicedet;

CREATE TABLE `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoicedet VALUES("070001","1","0011","","400.000","3525.00000","1410000.00","","","","","","","","","","","","","01","17","0.000","","0","0");


DROP TABLE IF EXISTS pl_invoicedet_copy;

CREATE TABLE `pl_invoicedet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO pl_invoicedet_copy VALUES("060001","1","4242","","4.000","2548.00000","10193.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","1","3976","","1.000","708.00000","708.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","2","3976","","1.000","708.00000","708.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","3","4228","","1.000","3174.00000","3174.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","4","4243","","1.000","1641.00000","1641.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","5","4244","","1.000","4017.00000","4017.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060002","6","3826","","1.000","1400.00000","1400.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","1","3821","","4.000","5412.00000","21648.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","2","4245","","4.000","4437.00000","17748.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","3","3822","","2.000","3847.00000","7694.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","4","4246","","4.000","6357.00000","25429.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060003","5","3779","","1.000","13990.00000","13990.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060004","1","4247","","1.000","7500.00000","7500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060005","1","4248","","1.000","2520.00000","2520.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060005","2","4249","","1.000","5580.00000","5580.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060006","1","4250","","1.000","14500.00000","14500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060007","1","4261","","1.000","14150.00000","13443.00","","","","","","","","","","","","","02","17","5.000","708.00","0","708");
INSERT INTO pl_invoicedet_copy VALUES("060007","2","3984","","1.000","1945.00000","1848.00","","","","","","","","","","","","","02","17","5.000","97.00","0","97");
INSERT INTO pl_invoicedet_copy VALUES("060007","3","4214","","1.000","680.00000","646.00","","","","","","","","","","","","","02","17","5.000","34.00","0","34");
INSERT INTO pl_invoicedet_copy VALUES("060007","4","4084","","1.000","4420.00000","4111.00","","","","","","","","","","","","","02","17","7.000","309.00","0","309");
INSERT INTO pl_invoicedet_copy VALUES("060008","1","4253","","1.000","4150.00000","4150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060008","2","4265","","1.000","2950.00000","2950.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060009","1","4273","","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060010","1","4235","","1.000","1100.00000","1100.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","1","3826","510","1.000","1150.00000","1150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","2","4276","","1.000","10272.00000","10272.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","3","4275","","1.000","3964.00000","3964.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060011","4","4274","","1.000","5184.00000","5184.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060012","1","4029","","1.000","150.00000","150.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060013","1","4271","","1.000","12734.00000","12734.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060014","1","4279","","1.000","17340.00000","17340.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060015","1","3975","","25.000","270.00000","6750.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060016","1","4243","","3.000","1396.00000","4189.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060016","2","3826","510","3.000","1190.00000","3570.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060017","1","4246","","1.000","14958.00000","14958.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060018","1","4029","","3.000","330.00000","990.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060019","1","4290","","1.000","6609.00000","6609.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060020","1","4036","","12.000","80.00000","960.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060021","1","3826","510","1.000","1400.00000","1400.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060022","1","4307","","2.000","55.00000","110.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060023","1","4308","","1.000","350.00000","350.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060024","1","4309","","1.000","14150.00000","13018.00","","","","","","","","","","","","","02","17","8.000","1132.00","0","1132");
INSERT INTO pl_invoicedet_copy VALUES("060024","2","4309","","2.000","12785.00000","23524.00","","","","","","","","","","","","","02","17","8.000","2046.00","0","2046");
INSERT INTO pl_invoicedet_copy VALUES("060025","1","4310","","1.000","5500.00000","5500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060026","1","4311","","17.000","825.00000","14025.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","1","4292","","1.000","4136.00000","4136.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","2","4291","","1.000","2464.00000","2464.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","3","3975","","6.000","1140.00000","6840.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","4","4293","","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("","5","4243","","2.000","1641.00000","3282.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","1","4292","","1.000","4136.00000","4136.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","2","4291","","1.000","2464.00000","2464.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","3","3975","","6.000","1140.00000","6840.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","4","4293","","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060027","5","4243","","2.000","1641.00000","3282.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060028","1","4312","","40.000","525.00000","21000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060029","1","3826","510","2.000","1400.00000","2800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060030","1","4316","","1.000","950.00000","950.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060031","1","4319","","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060032","1","4304","","6.000","4868.00000","29208.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060032","2","4303","","4.000","1239.00000","4956.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060033","1","4337","","1.000","10424.00000","10424.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060034","1","4331","","1.000","19403.00000","19403.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060035","1","4340","","1.000","3175.00000","3175.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060036","1","4332","","2.000","14892.00000","29784.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060036","2","4333","","2.000","13140.00000","26280.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060037","1","4029","","3.000","350.00000","1050.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO pl_invoicedet_copy VALUES("060038","1","4351","","1.000","1739.00000","1739.00","","","","","","","","","","","","","02","17","0.000","","0","0");


DROP TABLE IF EXISTS pl_invoicedetapp;

CREATE TABLE `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_jv;

CREATE TABLE `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_jvdet;

CREATE TABLE `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_jvdet_inst;

CREATE TABLE `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_order;

CREATE TABLE `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `po_no` varchar(30) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `disc_amt` decimal(15,2) DEFAULT NULL,
  `dc_amt` decimal(15,2) DEFAULT NULL,
  `loc_id` char(2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `sp_id` varchar(7) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `service` char(2) DEFAULT NULL,
  `ut` char(2) DEFAULT NULL,
  `adv_amt` decimal(15,2) DEFAULT NULL,
  `net_amt` decimal(15,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_orderdet;

CREATE TABLE `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` decimal(6,3) DEFAULT NULL,
  `stax` decimal(15,2) DEFAULT NULL,
  `stax_rate` decimal(15,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `sed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_pay;

CREATE TABLE `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_paydet;

CREATE TABLE `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_paydet_inst;

CREATE TABLE `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_payment;

CREATE TABLE `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_paymentdet;

CREATE TABLE `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_po;

CREATE TABLE `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_podet;

CREATE TABLE `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receipt;

CREATE TABLE `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet;

CREATE TABLE `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet_acct;

CREATE TABLE `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet_inv;

CREATE TABLE `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_receiptdet_po;

CREATE TABLE `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_return;

CREATE TABLE `pl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_returndet;

CREATE TABLE `pl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_ship;

CREATE TABLE `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_ship_inv;

CREATE TABLE `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pl_shipdet;

CREATE TABLE `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS po;

CREATE TABLE `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS po_type;

CREATE TABLE `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO po_type VALUES("01","Ex Works");


DROP TABLE IF EXISTS podet;

CREATE TABLE `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS process;

CREATE TABLE `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO process VALUES("1","Mixing");


DROP TABLE IF EXISTS prod;

CREATE TABLE `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_batch;

CREATE TABLE `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_brand;

CREATE TABLE `prod_brand` (
  `BRAND_ID` varchar(6) NOT NULL,
  `BRAND_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`BRAND_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_brand VALUES("01","Local","","","");
INSERT INTO prod_brand VALUES("02","China","","","");
INSERT INTO prod_brand VALUES("03","SONEX","","","");
INSERT INTO prod_brand VALUES("04","GROHE","","","");
INSERT INTO prod_brand VALUES("05","GROHE CHI","","","");
INSERT INTO prod_brand VALUES("06","CLASSIC","","","");
INSERT INTO prod_brand VALUES("07","OTHERS","","","");
INSERT INTO prod_brand VALUES("08","JAGUAR","","","");


DROP TABLE IF EXISTS prod_cat;

CREATE TABLE `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_cat VALUES("01","BAROZA","","","");
INSERT INTO prod_cat VALUES("02","MOOM","","","");
INSERT INTO prod_cat VALUES("03","SODA","","","");
INSERT INTO prod_cat VALUES("99","OTHERS","","","");


DROP TABLE IF EXISTS prod_comp;

CREATE TABLE `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_grp;

CREATE TABLE `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_grp VALUES("01","Group Name");


DROP TABLE IF EXISTS prod_rm_date;

CREATE TABLE `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS prod_type;

CREATE TABLE `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO prod_type VALUES("01","Franchise Group","0700100001","0500030003","0800010101");


DROP TABLE IF EXISTS proddet;

CREATE TABLE `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS regions;

CREATE TABLE `regions` (
  `REG_ID` varchar(4) NOT NULL,
  `REG_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`REG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO regions VALUES("1","Punjab (Province)");


DROP TABLE IF EXISTS replanishment;

CREATE TABLE `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO replanishment VALUES("SD03001BL08","2","12");
INSERT INTO replanishment VALUES("SD03001BL09","2","12");
INSERT INTO replanishment VALUES("SD03001BL10","2","12");
INSERT INTO replanishment VALUES("SD03001BL11","1","12");
INSERT INTO replanishment VALUES("SD03002BL08","2","12");
INSERT INTO replanishment VALUES("SD03002BL09","2","12");
INSERT INTO replanishment VALUES("SD03002BL10","2","12");
INSERT INTO replanishment VALUES("SD03002BL11","1","12");
INSERT INTO replanishment VALUES("SD03003BL08","2","12");
INSERT INTO replanishment VALUES("SD03003BL09","2","12");
INSERT INTO replanishment VALUES("SD03003BL10","2","12");
INSERT INTO replanishment VALUES("SD03003BL11","1","12");
INSERT INTO replanishment VALUES("SD03004BL08","2","12");
INSERT INTO replanishment VALUES("SD03004BL09","2","12");
INSERT INTO replanishment VALUES("SD03004BL10","2","12");
INSERT INTO replanishment VALUES("SD03004BL11","1","12");
INSERT INTO replanishment VALUES("SD03005OW08","2","12");
INSERT INTO replanishment VALUES("SD03005OW09","2","12");
INSERT INTO replanishment VALUES("SD03005OW10","2","12");
INSERT INTO replanishment VALUES("SD03005OW11","1","12");
INSERT INTO replanishment VALUES("SD03006GO08","2","12");
INSERT INTO replanishment VALUES("SD03006GO09","2","12");
INSERT INTO replanishment VALUES("SD03006GO10","2","12");
INSERT INTO replanishment VALUES("SD03006GO11","1","12");
INSERT INTO replanishment VALUES("SD03007BL08","2","12");
INSERT INTO replanishment VALUES("SD03007BL09","2","12");
INSERT INTO replanishment VALUES("SD03007BL10","2","12");
INSERT INTO replanishment VALUES("SD03007BL11","1","12");
INSERT INTO replanishment VALUES("SD04001BG08","2","12");
INSERT INTO replanishment VALUES("SD04001BG09","2","12");
INSERT INTO replanishment VALUES("SD04001BG10","2","12");
INSERT INTO replanishment VALUES("SD04001BG11","1","12");
INSERT INTO replanishment VALUES("SD04002YB08","2","12");
INSERT INTO replanishment VALUES("SD04002YB09","2","12");
INSERT INTO replanishment VALUES("SD04002YB10","2","12");
INSERT INTO replanishment VALUES("SD04002YB11","1","12");
INSERT INTO replanishment VALUES("SD07001SB08","2","12");
INSERT INTO replanishment VALUES("SD07001SB09","2","12");
INSERT INTO replanishment VALUES("SD07001SB10","2","12");
INSERT INTO replanishment VALUES("SD07001SB11","1","12");
INSERT INTO replanishment VALUES("SD07002BU08","2","12");
INSERT INTO replanishment VALUES("SD07002BU09","2","12");
INSERT INTO replanishment VALUES("SD07002BU10","2","12");
INSERT INTO replanishment VALUES("SD07002BU11","1","12");
INSERT INTO replanishment VALUES("SD07003LR08","2","12");
INSERT INTO replanishment VALUES("SD07003LR09","2","12");
INSERT INTO replanishment VALUES("SD07003LR10","2","12");
INSERT INTO replanishment VALUES("SD07003LR11","1","12");
INSERT INTO replanishment VALUES("SD07004MR08","2","12");
INSERT INTO replanishment VALUES("SD07004MR09","2","12");
INSERT INTO replanishment VALUES("SD07004MR10","2","12");
INSERT INTO replanishment VALUES("SD07004MR11","1","12");
INSERT INTO replanishment VALUES("SD10001BL08","2","12");
INSERT INTO replanishment VALUES("SD10001BL09","2","12");
INSERT INTO replanishment VALUES("SD10001BL10","2","12");
INSERT INTO replanishment VALUES("SD10001BL11","1","12");
INSERT INTO replanishment VALUES("SD10002BL08","2","12");
INSERT INTO replanishment VALUES("SD10002BL09","2","12");
INSERT INTO replanishment VALUES("SD10002BL10","2","12");
INSERT INTO replanishment VALUES("SD10002BL11","1","12");
INSERT INTO replanishment VALUES("SD10003BL08","2","12");
INSERT INTO replanishment VALUES("SD10003BL09","2","12");
INSERT INTO replanishment VALUES("SD10003BL10","2","12");
INSERT INTO replanishment VALUES("SD10003BL11","1","12");
INSERT INTO replanishment VALUES("SD10004BL08","2","12");
INSERT INTO replanishment VALUES("SD10004BL09","2","12");
INSERT INTO replanishment VALUES("SD10004BL10","2","12");
INSERT INTO replanishment VALUES("SD10004BL11","1","12");
INSERT INTO replanishment VALUES("SD10005OW08","2","12");
INSERT INTO replanishment VALUES("SD10005OW09","2","12");
INSERT INTO replanishment VALUES("SD10005OW10","2","12");
INSERT INTO replanishment VALUES("SD10005OW11","1","12");
INSERT INTO replanishment VALUES("SD10006GO08","2","12");
INSERT INTO replanishment VALUES("SD10006GO09","2","12");
INSERT INTO replanishment VALUES("SD10006GO10","2","12");
INSERT INTO replanishment VALUES("SD10006GO11","1","12");
INSERT INTO replanishment VALUES("SD10007BL08","2","12");
INSERT INTO replanishment VALUES("SD10007BL09","2","12");
INSERT INTO replanishment VALUES("SD10007BL10","2","12");
INSERT INTO replanishment VALUES("SD10007BL11","1","12");
INSERT INTO replanishment VALUES("SD10008BU08","2","12");
INSERT INTO replanishment VALUES("SD10008BU09","2","12");
INSERT INTO replanishment VALUES("SD10008BU10","2","12");
INSERT INTO replanishment VALUES("SD10008BU11","1","12");
INSERT INTO replanishment VALUES("SD10009MR08","2","12");
INSERT INTO replanishment VALUES("SD10009MR09","2","12");
INSERT INTO replanishment VALUES("SD10009MR10","2","12");
INSERT INTO replanishment VALUES("SD10009MR11","1","12");
INSERT INTO replanishment VALUES("SD11001GO08","2","12");
INSERT INTO replanishment VALUES("SD11001GO09","2","12");
INSERT INTO replanishment VALUES("SD11001GO10","2","12");
INSERT INTO replanishment VALUES("SD11001GO11","1","12");
INSERT INTO replanishment VALUES("SD11002RD08","2","12");
INSERT INTO replanishment VALUES("SD11002RD09","2","12");
INSERT INTO replanishment VALUES("SD11002RD10","2","12");
INSERT INTO replanishment VALUES("SD11002RD11","1","12");
INSERT INTO replanishment VALUES("SD11003WH08","2","12");
INSERT INTO replanishment VALUES("SD11003WH09","2","12");
INSERT INTO replanishment VALUES("SD11003WH10","2","12");
INSERT INTO replanishment VALUES("SD11003WH11","1","12");
INSERT INTO replanishment VALUES("SD12001BL08","2","12");
INSERT INTO replanishment VALUES("SD12001BL09","2","12");
INSERT INTO replanishment VALUES("SD12001BL10","2","12");
INSERT INTO replanishment VALUES("SD12001BL11","1","12");
INSERT INTO replanishment VALUES("SD12002BU08","2","12");
INSERT INTO replanishment VALUES("SD12002BU09","2","12");
INSERT INTO replanishment VALUES("SD12002BU10","2","12");
INSERT INTO replanishment VALUES("SD12002BU11","1","12");
INSERT INTO replanishment VALUES("SD12003BL08","2","12");
INSERT INTO replanishment VALUES("SD12003BL09","2","12");
INSERT INTO replanishment VALUES("SD12003BL10","2","12");
INSERT INTO replanishment VALUES("SD12003BL11","1","12");
INSERT INTO replanishment VALUES("SD12004BU08","2","12");
INSERT INTO replanishment VALUES("SD12004BU09","2","12");
INSERT INTO replanishment VALUES("SD12004BU10","2","12");
INSERT INTO replanishment VALUES("SD12004BU11","1","12");
INSERT INTO replanishment VALUES("SD12005BL08","2","12");
INSERT INTO replanishment VALUES("SD12005BL09","2","12");
INSERT INTO replanishment VALUES("SD12005BL10","2","12");
INSERT INTO replanishment VALUES("SD12005BL11","1","12");
INSERT INTO replanishment VALUES("SG00001PU08","2","12");
INSERT INTO replanishment VALUES("SG00001PU09","2","12");
INSERT INTO replanishment VALUES("SG00001PU10","2","12");
INSERT INTO replanishment VALUES("SG00001PU11","1","12");
INSERT INTO replanishment VALUES("SG00002OW08","2","12");
INSERT INTO replanishment VALUES("SG00002OW09","2","12");
INSERT INTO replanishment VALUES("SG00002OW10","2","12");
INSERT INTO replanishment VALUES("SG00002OW11","1","12");
INSERT INTO replanishment VALUES("SG00003BL08","2","12");
INSERT INTO replanishment VALUES("SG00003BL09","2","12");
INSERT INTO replanishment VALUES("SG00003BL10","2","12");
INSERT INTO replanishment VALUES("SG00003BL11","1","12");
INSERT INTO replanishment VALUES("SG00004SN08","2","12");
INSERT INTO replanishment VALUES("SG00004SN09","2","12");
INSERT INTO replanishment VALUES("SG00004SN10","2","12");
INSERT INTO replanishment VALUES("SG00004SN11","1","12");
INSERT INTO replanishment VALUES("SG00005BU08","2","12");
INSERT INTO replanishment VALUES("SG00005BU09","2","12");
INSERT INTO replanishment VALUES("SG00005BU10","2","12");
INSERT INTO replanishment VALUES("SG00005BU11","1","12");
INSERT INTO replanishment VALUES("SG00006GO08","2","12");
INSERT INTO replanishment VALUES("SG00006GO09","2","12");
INSERT INTO replanishment VALUES("SG00006GO10","2","12");
INSERT INTO replanishment VALUES("SG00006GO11","1","12");
INSERT INTO replanishment VALUES("SG00007BR08","2","12");
INSERT INTO replanishment VALUES("SG00007BR09","2","12");
INSERT INTO replanishment VALUES("SG00007BR10","2","12");
INSERT INTO replanishment VALUES("SG00007BR11","1","12");
INSERT INTO replanishment VALUES("SG00008BU08","2","12");
INSERT INTO replanishment VALUES("SG00008BU09","2","12");
INSERT INTO replanishment VALUES("SG00008BU10","2","12");
INSERT INTO replanishment VALUES("SG00008BU11","1","12");
INSERT INTO replanishment VALUES("SG00009BU08","2","12");
INSERT INTO replanishment VALUES("SG00009BU09","2","12");
INSERT INTO replanishment VALUES("SG00009BU10","2","12");
INSERT INTO replanishment VALUES("SG00009BU11","1","12");
INSERT INTO replanishment VALUES("SG00010MS08","2","12");
INSERT INTO replanishment VALUES("SG00010MS09","2","12");
INSERT INTO replanishment VALUES("SG00010MS10","2","12");
INSERT INTO replanishment VALUES("SG00010MS11","1","12");
INSERT INTO replanishment VALUES("SG00011BR08","2","12");
INSERT INTO replanishment VALUES("SG00011BR09","2","12");
INSERT INTO replanishment VALUES("SG00011BR10","2","12");
INSERT INTO replanishment VALUES("SG00011BR11","1","12");
INSERT INTO replanishment VALUES("SG00012KH08","2","12");
INSERT INTO replanishment VALUES("SG00012KH09","2","12");
INSERT INTO replanishment VALUES("SG00012KH10","2","12");
INSERT INTO replanishment VALUES("SG00012KH11","1","12");
INSERT INTO replanishment VALUES("SG00013MR08","2","12");
INSERT INTO replanishment VALUES("SG00013MR09","2","12");
INSERT INTO replanishment VALUES("SG00013MR10","2","12");
INSERT INTO replanishment VALUES("SG00013MR11","1","12");
INSERT INTO replanishment VALUES("SG00014BL08","2","12");
INSERT INTO replanishment VALUES("SG00014BL09","2","12");
INSERT INTO replanishment VALUES("SG00014BL10","2","12");
INSERT INTO replanishment VALUES("SG00014BL11","1","12");
INSERT INTO replanishment VALUES("SG00015SB08","2","12");
INSERT INTO replanishment VALUES("SG00015SB09","2","12");
INSERT INTO replanishment VALUES("SG00015SB10","2","12");
INSERT INTO replanishment VALUES("SG00015SB11","1","12");
INSERT INTO replanishment VALUES("SG00016WH08","2","12");
INSERT INTO replanishment VALUES("SG00016WH09","2","12");
INSERT INTO replanishment VALUES("SG00016WH10","2","12");
INSERT INTO replanishment VALUES("SG00016WH11","1","12");
INSERT INTO replanishment VALUES("SG00017WH08","2","12");
INSERT INTO replanishment VALUES("SG00017WH09","2","12");
INSERT INTO replanishment VALUES("SG00017WH10","2","12");
INSERT INTO replanishment VALUES("SG00017WH11","1","12");
INSERT INTO replanishment VALUES("SG00018WH08","2","12");
INSERT INTO replanishment VALUES("SG00018WH09","2","12");
INSERT INTO replanishment VALUES("SG00018WH10","2","12");
INSERT INTO replanishment VALUES("SG00018WH11","1","12");
INSERT INTO replanishment VALUES("SG00019CB08","2","12");
INSERT INTO replanishment VALUES("SG00019CB09","2","12");
INSERT INTO replanishment VALUES("SG00019CB10","2","12");
INSERT INTO replanishment VALUES("SG00019CB11","1","12");
INSERT INTO replanishment VALUES("SG00020MR08","2","12");
INSERT INTO replanishment VALUES("SG00020MR09","2","12");
INSERT INTO replanishment VALUES("SG00020MR10","2","12");
INSERT INTO replanishment VALUES("SG00020MR11","1","12");
INSERT INTO replanishment VALUES("SG00021BL08","2","12");
INSERT INTO replanishment VALUES("SG00021BL09","2","12");
INSERT INTO replanishment VALUES("SG00021BL10","2","12");
INSERT INTO replanishment VALUES("SG00021BL11","1","12");
INSERT INTO replanishment VALUES("SG00022BR08","2","12");
INSERT INTO replanishment VALUES("SG00022BR09","2","12");
INSERT INTO replanishment VALUES("SG00022BR10","2","12");
INSERT INTO replanishment VALUES("SG00022BR11","1","12");
INSERT INTO replanishment VALUES("SG02097GO08","2","12");
INSERT INTO replanishment VALUES("SG02097GO09","2","12");
INSERT INTO replanishment VALUES("SG02097GO10","2","12");
INSERT INTO replanishment VALUES("SG02097GO11","1","12");
INSERT INTO replanishment VALUES("SG03001MD08","2","12");
INSERT INTO replanishment VALUES("SG03001MD09","2","12");
INSERT INTO replanishment VALUES("SG03001MD10","2","12");
INSERT INTO replanishment VALUES("SG03001MD11","1","12");
INSERT INTO replanishment VALUES("SG03001OW08","2","12");
INSERT INTO replanishment VALUES("SG03001OW09","2","12");
INSERT INTO replanishment VALUES("SG03001OW10","2","12");
INSERT INTO replanishment VALUES("SG03001OW11","1","12");
INSERT INTO replanishment VALUES("SG03002MD08","2","12");
INSERT INTO replanishment VALUES("SG03002MD09","2","12");
INSERT INTO replanishment VALUES("SG03002MD10","2","12");
INSERT INTO replanishment VALUES("SG03002MD11","1","12");
INSERT INTO replanishment VALUES("SG03002OW08","2","12");
INSERT INTO replanishment VALUES("SG03002OW09","2","12");
INSERT INTO replanishment VALUES("SG03002OW10","2","12");
INSERT INTO replanishment VALUES("SG03002OW11","1","12");
INSERT INTO replanishment VALUES("SG04001SG08","2","12");
INSERT INTO replanishment VALUES("SG04001SG09","2","12");
INSERT INTO replanishment VALUES("SG04001SG10","2","12");
INSERT INTO replanishment VALUES("SG04001SG11","1","12");
INSERT INTO replanishment VALUES("SG04002MR08","2","12");
INSERT INTO replanishment VALUES("SG04002MR09","2","12");
INSERT INTO replanishment VALUES("SG04002MR10","2","12");
INSERT INTO replanishment VALUES("SG04002MR11","1","12");
INSERT INTO replanishment VALUES("SG04002MV08","2","12");
INSERT INTO replanishment VALUES("SG04002MV09","2","12");
INSERT INTO replanishment VALUES("SG04002MV10","2","12");
INSERT INTO replanishment VALUES("SG04002MV11","1","12");
INSERT INTO replanishment VALUES("SG04003MR08","2","12");
INSERT INTO replanishment VALUES("SG04003MR09","2","12");
INSERT INTO replanishment VALUES("SG04003MR10","2","12");
INSERT INTO replanishment VALUES("SG04003MR11","1","12");
INSERT INTO replanishment VALUES("SG04004PK08","2","12");
INSERT INTO replanishment VALUES("SG04004PK09","2","12");
INSERT INTO replanishment VALUES("SG04004PK10","2","12");
INSERT INTO replanishment VALUES("SG04004PK11","1","12");
INSERT INTO replanishment VALUES("SG04005PR08","2","12");
INSERT INTO replanishment VALUES("SG04005PR09","2","12");
INSERT INTO replanishment VALUES("SG04005PR10","2","12");
INSERT INTO replanishment VALUES("SG04005PR11","1","12");
INSERT INTO replanishment VALUES("SK00001BR08","2","12");
INSERT INTO replanishment VALUES("SK00001BR09","2","12");
INSERT INTO replanishment VALUES("SK00001BR10","2","12");
INSERT INTO replanishment VALUES("SK00001BR11","1","12");
INSERT INTO replanishment VALUES("SK00001GR08","2","12");
INSERT INTO replanishment VALUES("SK00001GR09","2","12");
INSERT INTO replanishment VALUES("SK00001GR10","2","12");
INSERT INTO replanishment VALUES("SK00001GR11","1","12");
INSERT INTO replanishment VALUES("SK00002MU08","2","12");
INSERT INTO replanishment VALUES("SK00002MU09","2","12");
INSERT INTO replanishment VALUES("SK00002MU10","2","12");
INSERT INTO replanishment VALUES("SK00002MU11","1","12");
INSERT INTO replanishment VALUES("SK00003BL08","2","12");
INSERT INTO replanishment VALUES("SK00003BL09","2","12");
INSERT INTO replanishment VALUES("SK00003BL10","2","12");
INSERT INTO replanishment VALUES("SK00003BL11","1","12");
INSERT INTO replanishment VALUES("SK00003WH08","2","12");
INSERT INTO replanishment VALUES("SK00003WH09","2","12");
INSERT INTO replanishment VALUES("SK00003WH10","2","12");
INSERT INTO replanishment VALUES("SK00003WH11","1","12");
INSERT INTO replanishment VALUES("SK00004BL08","2","12");
INSERT INTO replanishment VALUES("SK00004BL09","2","12");
INSERT INTO replanishment VALUES("SK00004BL10","2","12");
INSERT INTO replanishment VALUES("SK00004BL11","1","12");
INSERT INTO replanishment VALUES("SK00005WH08","2","12");
INSERT INTO replanishment VALUES("SK00005WH09","2","12");
INSERT INTO replanishment VALUES("SK00005WH10","2","12");
INSERT INTO replanishment VALUES("SK00005WH11","1","12");
INSERT INTO replanishment VALUES("SK00006GR08","2","12");
INSERT INTO replanishment VALUES("SK00006GR09","2","12");
INSERT INTO replanishment VALUES("SK00006GR10","2","12");
INSERT INTO replanishment VALUES("SK00006GR11","1","12");
INSERT INTO replanishment VALUES("SK00006GY08","2","12");
INSERT INTO replanishment VALUES("SK00006GY09","2","12");
INSERT INTO replanishment VALUES("SK00006GY10","2","12");
INSERT INTO replanishment VALUES("SK00006GY11","1","12");
INSERT INTO replanishment VALUES("SK00007GY08","2","12");
INSERT INTO replanishment VALUES("SK00007GY09","2","12");
INSERT INTO replanishment VALUES("SK00007GY10","2","12");
INSERT INTO replanishment VALUES("SK00007GY11","1","12");
INSERT INTO replanishment VALUES("SK00008PL08","2","12");
INSERT INTO replanishment VALUES("SK00008PL09","2","12");
INSERT INTO replanishment VALUES("SK00008PL10","2","12");
INSERT INTO replanishment VALUES("SK00008PL11","1","12");
INSERT INTO replanishment VALUES("SK00009BR08","2","12");
INSERT INTO replanishment VALUES("SK00009BR09","2","12");
INSERT INTO replanishment VALUES("SK00009BR10","2","12");
INSERT INTO replanishment VALUES("SK00009BR11","1","12");
INSERT INTO replanishment VALUES("SK00010GR08","2","12");
INSERT INTO replanishment VALUES("SK00010GR09","2","12");
INSERT INTO replanishment VALUES("SK00010GR10","2","12");
INSERT INTO replanishment VALUES("SK00010GR11","1","12");
INSERT INTO replanishment VALUES("SK00011DG08","2","12");
INSERT INTO replanishment VALUES("SK00011DG09","2","12");
INSERT INTO replanishment VALUES("SK00011DG10","2","12");
INSERT INTO replanishment VALUES("SK00011DG11","1","12");
INSERT INTO replanishment VALUES("SK00011LG08","2","12");
INSERT INTO replanishment VALUES("SK00011LG09","2","12");
INSERT INTO replanishment VALUES("SK00011LG10","2","12");
INSERT INTO replanishment VALUES("SK00011LG11","1","12");
INSERT INTO replanishment VALUES("SK00012BR08","2","12");
INSERT INTO replanishment VALUES("SK00012BR09","2","12");
INSERT INTO replanishment VALUES("SK00012BR10","2","12");
INSERT INTO replanishment VALUES("SK00012BR11","1","12");
INSERT INTO replanishment VALUES("SK00012GY08","2","12");
INSERT INTO replanishment VALUES("SK00012GY09","2","12");
INSERT INTO replanishment VALUES("SK00012GY10","2","12");
INSERT INTO replanishment VALUES("SK00012GY11","1","12");
INSERT INTO replanishment VALUES("SK00013MH08","2","12");
INSERT INTO replanishment VALUES("SK00013MH09","2","12");
INSERT INTO replanishment VALUES("SK00013MH10","2","12");
INSERT INTO replanishment VALUES("SK00013MH11","1","12");
INSERT INTO replanishment VALUES("SK00017BL08","2","12");
INSERT INTO replanishment VALUES("SK00017BL09","2","12");
INSERT INTO replanishment VALUES("SK00017BL10","2","12");
INSERT INTO replanishment VALUES("SK00017BL11","1","12");
INSERT INTO replanishment VALUES("SK00017BU08","2","12");
INSERT INTO replanishment VALUES("SK00017BU09","2","12");
INSERT INTO replanishment VALUES("SK00017BU10","2","12");
INSERT INTO replanishment VALUES("SK00017BU11","1","12");
INSERT INTO replanishment VALUES("SK00018BR08","2","12");
INSERT INTO replanishment VALUES("SK00018BR09","2","12");
INSERT INTO replanishment VALUES("SK00018BR10","2","12");
INSERT INTO replanishment VALUES("SK00018BR11","1","12");
INSERT INTO replanishment VALUES("SK00018BU08","2","12");
INSERT INTO replanishment VALUES("SK00018BU09","2","12");
INSERT INTO replanishment VALUES("SK00018BU10","2","12");
INSERT INTO replanishment VALUES("SK00018BU11","1","12");
INSERT INTO replanishment VALUES("SK00018GB08","2","12");
INSERT INTO replanishment VALUES("SK00018GB09","2","12");
INSERT INTO replanishment VALUES("SK00018GB10","2","12");
INSERT INTO replanishment VALUES("SK00018GB11","1","12");
INSERT INTO replanishment VALUES("SK00019BR08","2","12");
INSERT INTO replanishment VALUES("SK00019BR09","2","12");
INSERT INTO replanishment VALUES("SK00019BR10","2","12");
INSERT INTO replanishment VALUES("SK00019BR11","1","12");
INSERT INTO replanishment VALUES("SK00020PR08","2","12");
INSERT INTO replanishment VALUES("SK00020PR09","2","12");
INSERT INTO replanishment VALUES("SK00020PR10","2","12");
INSERT INTO replanishment VALUES("SK00020PR11","1","12");
INSERT INTO replanishment VALUES("SK00021WH08","2","12");
INSERT INTO replanishment VALUES("SK00021WH09","2","12");
INSERT INTO replanishment VALUES("SK00021WH10","2","12");
INSERT INTO replanishment VALUES("SK00021WH11","1","12");
INSERT INTO replanishment VALUES("SK00022GY08","2","12");
INSERT INTO replanishment VALUES("SK00022GY09","2","12");
INSERT INTO replanishment VALUES("SK00022GY10","2","12");
INSERT INTO replanishment VALUES("SK00022GY11","1","12");
INSERT INTO replanishment VALUES("SK00022MR08","2","12");
INSERT INTO replanishment VALUES("SK00022MR09","2","12");
INSERT INTO replanishment VALUES("SK00022MR10","2","12");
INSERT INTO replanishment VALUES("SK00022MR11","1","12");
INSERT INTO replanishment VALUES("SK00023BU08","2","12");
INSERT INTO replanishment VALUES("SK00023BU09","2","12");
INSERT INTO replanishment VALUES("SK00023BU10","2","12");
INSERT INTO replanishment VALUES("SK00023BU11","1","12");
INSERT INTO replanishment VALUES("SK00023GR08","2","12");
INSERT INTO replanishment VALUES("SK00023GR09","2","12");
INSERT INTO replanishment VALUES("SK00023GR10","2","12");
INSERT INTO replanishment VALUES("SK00023GR11","1","12");
INSERT INTO replanishment VALUES("SK00025BU08","2","12");
INSERT INTO replanishment VALUES("SK00025BU09","2","12");
INSERT INTO replanishment VALUES("SK00025BU10","2","12");
INSERT INTO replanishment VALUES("SK00025BU11","1","12");
INSERT INTO replanishment VALUES("SK00025MV08","2","12");
INSERT INTO replanishment VALUES("SK00025MV09","2","12");
INSERT INTO replanishment VALUES("SK00025MV10","2","12");
INSERT INTO replanishment VALUES("SK00025MV11","1","12");
INSERT INTO replanishment VALUES("SK00025PU08","2","12");
INSERT INTO replanishment VALUES("SK00025PU09","2","12");
INSERT INTO replanishment VALUES("SK00025PU10","2","12");
INSERT INTO replanishment VALUES("SK00025PU11","1","12");
INSERT INTO replanishment VALUES("SK00026BD08","2","12");
INSERT INTO replanishment VALUES("SK00026BD09","2","12");
INSERT INTO replanishment VALUES("SK00026BD10","2","12");
INSERT INTO replanishment VALUES("SK00026BD11","1","12");
INSERT INTO replanishment VALUES("SK00026FE08","2","12");
INSERT INTO replanishment VALUES("SK00026FE09","2","12");
INSERT INTO replanishment VALUES("SK00026FE10","2","12");
INSERT INTO replanishment VALUES("SK00026FE11","1","12");
INSERT INTO replanishment VALUES("SK00026NE08","2","12");
INSERT INTO replanishment VALUES("SK00026NE09","2","12");
INSERT INTO replanishment VALUES("SK00026NE10","2","12");
INSERT INTO replanishment VALUES("SK00026NE11","1","12");
INSERT INTO replanishment VALUES("SK00027CR08","2","12");
INSERT INTO replanishment VALUES("SK00027CR09","2","12");
INSERT INTO replanishment VALUES("SK00027CR10","2","12");
INSERT INTO replanishment VALUES("SK00027CR11","1","12");
INSERT INTO replanishment VALUES("SK00027FE08","2","12");
INSERT INTO replanishment VALUES("SK00027FE09","2","12");
INSERT INTO replanishment VALUES("SK00027FE10","2","12");
INSERT INTO replanishment VALUES("SK00027FE11","1","12");
INSERT INTO replanishment VALUES("SK00027LV08","2","12");
INSERT INTO replanishment VALUES("SK00027LV09","2","12");
INSERT INTO replanishment VALUES("SK00027LV10","2","12");
INSERT INTO replanishment VALUES("SK00027LV11","1","12");
INSERT INTO replanishment VALUES("SK00030BU08","2","12");
INSERT INTO replanishment VALUES("SK00030BU09","2","12");
INSERT INTO replanishment VALUES("SK00030BU10","2","12");
INSERT INTO replanishment VALUES("SK00030BU11","1","12");
INSERT INTO replanishment VALUES("SK00033BU08","2","12");
INSERT INTO replanishment VALUES("SK00033BU09","2","12");
INSERT INTO replanishment VALUES("SK00033BU10","2","12");
INSERT INTO replanishment VALUES("SK00033BU11","1","12");
INSERT INTO replanishment VALUES("SK00033WH08","2","12");
INSERT INTO replanishment VALUES("SK00033WH09","2","12");
INSERT INTO replanishment VALUES("SK00033WH10","2","12");
INSERT INTO replanishment VALUES("SK00033WH11","1","12");
INSERT INTO replanishment VALUES("SK00034WH08","2","12");
INSERT INTO replanishment VALUES("SK00034WH09","2","12");
INSERT INTO replanishment VALUES("SK00034WH10","2","12");
INSERT INTO replanishment VALUES("SK00034WH11","1","12");
INSERT INTO replanishment VALUES("SK00035BL08","2","12");
INSERT INTO replanishment VALUES("SK00035BL09","2","12");
INSERT INTO replanishment VALUES("SK00035BL10","2","12");
INSERT INTO replanishment VALUES("SK00035BL11","1","12");
INSERT INTO replanishment VALUES("SK00036GO08","2","12");
INSERT INTO replanishment VALUES("SK00036GO09","2","12");
INSERT INTO replanishment VALUES("SK00036GO10","2","12");
INSERT INTO replanishment VALUES("SK00036GO11","1","12");
INSERT INTO replanishment VALUES("SK00036GR08","2","12");
INSERT INTO replanishment VALUES("SK00036GR09","2","12");
INSERT INTO replanishment VALUES("SK00036GR10","2","12");
INSERT INTO replanishment VALUES("SK00036GR11","1","12");
INSERT INTO replanishment VALUES("SK00036GY08","2","12");
INSERT INTO replanishment VALUES("SK00036GY09","2","12");
INSERT INTO replanishment VALUES("SK00036GY10","2","12");
INSERT INTO replanishment VALUES("SK00036GY11","1","12");
INSERT INTO replanishment VALUES("SK00037BL08","2","12");
INSERT INTO replanishment VALUES("SK00037BL09","2","12");
INSERT INTO replanishment VALUES("SK00037BL10","2","12");
INSERT INTO replanishment VALUES("SK00037BL11","1","12");
INSERT INTO replanishment VALUES("SK00038GO08","2","12");
INSERT INTO replanishment VALUES("SK00038GO09","2","12");
INSERT INTO replanishment VALUES("SK00038GO10","2","12");
INSERT INTO replanishment VALUES("SK00038GO11","1","12");
INSERT INTO replanishment VALUES("SK00039GY08","2","12");
INSERT INTO replanishment VALUES("SK00039GY09","2","12");
INSERT INTO replanishment VALUES("SK00039GY10","2","12");
INSERT INTO replanishment VALUES("SK00039GY11","1","12");
INSERT INTO replanishment VALUES("SK00040GR08","2","12");
INSERT INTO replanishment VALUES("SK00040GR09","2","12");
INSERT INTO replanishment VALUES("SK00040GR10","2","12");
INSERT INTO replanishment VALUES("SK00040GR11","1","12");
INSERT INTO replanishment VALUES("SK00041PU08","2","12");
INSERT INTO replanishment VALUES("SK00041PU09","2","12");
INSERT INTO replanishment VALUES("SK00041PU10","2","12");
INSERT INTO replanishment VALUES("SK00041PU11","1","12");
INSERT INTO replanishment VALUES("SK00042BU08","2","12");
INSERT INTO replanishment VALUES("SK00042BU09","2","12");
INSERT INTO replanishment VALUES("SK00042BU10","2","12");
INSERT INTO replanishment VALUES("SK00042BU11","1","12");
INSERT INTO replanishment VALUES("SK00049GY08","2","12");
INSERT INTO replanishment VALUES("SK00049GY09","2","12");
INSERT INTO replanishment VALUES("SK00049GY10","2","12");
INSERT INTO replanishment VALUES("SK00049GY11","1","12");
INSERT INTO replanishment VALUES("SK00055OR08","2","12");
INSERT INTO replanishment VALUES("SK00055OR09","2","12");
INSERT INTO replanishment VALUES("SK00055OR10","2","12");
INSERT INTO replanishment VALUES("SK00055OR11","1","12");
INSERT INTO replanishment VALUES("SK00056MR08","2","12");
INSERT INTO replanishment VALUES("SK00056MR09","2","12");
INSERT INTO replanishment VALUES("SK00056MR10","2","12");
INSERT INTO replanishment VALUES("SK00056MR11","1","12");
INSERT INTO replanishment VALUES("SK00059GR08","2","12");
INSERT INTO replanishment VALUES("SK00059GR09","2","12");
INSERT INTO replanishment VALUES("SK00059GR10","2","12");
INSERT INTO replanishment VALUES("SK00059GR11","1","12");
INSERT INTO replanishment VALUES("SK00060WH08","2","12");
INSERT INTO replanishment VALUES("SK00060WH09","2","12");
INSERT INTO replanishment VALUES("SK00060WH10","2","12");
INSERT INTO replanishment VALUES("SK00060WH11","1","12");
INSERT INTO replanishment VALUES("SK00062BL08","2","12");
INSERT INTO replanishment VALUES("SK00062BL09","2","12");
INSERT INTO replanishment VALUES("SK00062BL10","2","12");
INSERT INTO replanishment VALUES("SK00062BL11","1","12");
INSERT INTO replanishment VALUES("SK00063BL08","2","12");
INSERT INTO replanishment VALUES("SK00063BL09","2","12");
INSERT INTO replanishment VALUES("SK00063BL10","2","12");
INSERT INTO replanishment VALUES("SK00063BL11","1","12");
INSERT INTO replanishment VALUES("SK00064BL08","2","12");
INSERT INTO replanishment VALUES("SK00064BL09","2","12");
INSERT INTO replanishment VALUES("SK00064BL10","2","12");
INSERT INTO replanishment VALUES("SK00064BL11","1","12");
INSERT INTO replanishment VALUES("SK00070BL08","2","12");
INSERT INTO replanishment VALUES("SK00070BL09","2","12");
INSERT INTO replanishment VALUES("SK00070BL10","2","12");
INSERT INTO replanishment VALUES("SK00070BL11","1","12");
INSERT INTO replanishment VALUES("SK00071GY08","2","12");
INSERT INTO replanishment VALUES("SK00071GY09","2","12");
INSERT INTO replanishment VALUES("SK00071GY10","2","12");
INSERT INTO replanishment VALUES("SK00071GY11","1","12");
INSERT INTO replanishment VALUES("SK00072BU08","2","12");
INSERT INTO replanishment VALUES("SK00072BU09","2","12");
INSERT INTO replanishment VALUES("SK00072BU10","2","12");
INSERT INTO replanishment VALUES("SK00072BU11","1","12");
INSERT INTO replanishment VALUES("SK00073PH08","2","12");
INSERT INTO replanishment VALUES("SK00073PH09","2","12");
INSERT INTO replanishment VALUES("SK00073PH10","2","12");
INSERT INTO replanishment VALUES("SK00073PH11","1","12");
INSERT INTO replanishment VALUES("SK00074BU08","2","12");
INSERT INTO replanishment VALUES("SK00074BU09","2","12");
INSERT INTO replanishment VALUES("SK00074BU10","2","12");
INSERT INTO replanishment VALUES("SK00074BU11","1","12");
INSERT INTO replanishment VALUES("SK00075BL08","2","12");
INSERT INTO replanishment VALUES("SK00075BL09","2","12");
INSERT INTO replanishment VALUES("SK00075BL10","2","12");
INSERT INTO replanishment VALUES("SK00075BL11","1","12");
INSERT INTO replanishment VALUES("SK00076BR08","2","12");
INSERT INTO replanishment VALUES("SK00076BR09","2","12");
INSERT INTO replanishment VALUES("SK00076BR10","2","12");
INSERT INTO replanishment VALUES("SK00076BR11","1","12");
INSERT INTO replanishment VALUES("SK00077WH08","2","12");
INSERT INTO replanishment VALUES("SK00077WH09","2","12");
INSERT INTO replanishment VALUES("SK00077WH10","2","12");
INSERT INTO replanishment VALUES("SK00077WH11","1","12");
INSERT INTO replanishment VALUES("SK00079WH08","2","12");
INSERT INTO replanishment VALUES("SK00079WH09","2","12");
INSERT INTO replanishment VALUES("SK00079WH10","2","12");
INSERT INTO replanishment VALUES("SK00079WH11","1","12");
INSERT INTO replanishment VALUES("SK00082PU08","2","12");
INSERT INTO replanishment VALUES("SK00082PU09","2","12");
INSERT INTO replanishment VALUES("SK00082PU10","2","12");
INSERT INTO replanishment VALUES("SK00082PU11","1","12");
INSERT INTO replanishment VALUES("SK00083LG08","2","12");
INSERT INTO replanishment VALUES("SK00083LG09","2","12");
INSERT INTO replanishment VALUES("SK00083LG10","2","12");
INSERT INTO replanishment VALUES("SK00083LG11","1","12");
INSERT INTO replanishment VALUES("SK00086GR08","2","12");
INSERT INTO replanishment VALUES("SK00086GR09","2","12");
INSERT INTO replanishment VALUES("SK00086GR10","2","12");
INSERT INTO replanishment VALUES("SK00086GR11","1","12");
INSERT INTO replanishment VALUES("SK00087OR08","2","12");
INSERT INTO replanishment VALUES("SK00087OR09","2","12");
INSERT INTO replanishment VALUES("SK00087OR10","2","12");
INSERT INTO replanishment VALUES("SK00087OR11","1","12");
INSERT INTO replanishment VALUES("SK00088PR08","2","12");
INSERT INTO replanishment VALUES("SK00088PR09","2","12");
INSERT INTO replanishment VALUES("SK00088PR10","2","12");
INSERT INTO replanishment VALUES("SK00088PR11","1","12");
INSERT INTO replanishment VALUES("SK00089WH08","2","12");
INSERT INTO replanishment VALUES("SK00089WH09","2","12");
INSERT INTO replanishment VALUES("SK00089WH10","2","12");
INSERT INTO replanishment VALUES("SK00089WH11","1","12");
INSERT INTO replanishment VALUES("SK00090BL08","2","12");
INSERT INTO replanishment VALUES("SK00090BL09","2","12");
INSERT INTO replanishment VALUES("SK00090BL10","2","12");
INSERT INTO replanishment VALUES("SK00090BL11","1","12");
INSERT INTO replanishment VALUES("SK00092OF08","2","12");
INSERT INTO replanishment VALUES("SK00092OF09","2","12");
INSERT INTO replanishment VALUES("SK00092OF10","2","12");
INSERT INTO replanishment VALUES("SK00092OF11","1","12");
INSERT INTO replanishment VALUES("SK00093WH08","2","12");
INSERT INTO replanishment VALUES("SK00093WH09","2","12");
INSERT INTO replanishment VALUES("SK00093WH10","2","12");
INSERT INTO replanishment VALUES("SK00093WH11","1","12");
INSERT INTO replanishment VALUES("SK00094BR08","2","12");
INSERT INTO replanishment VALUES("SK00094BR09","2","12");
INSERT INTO replanishment VALUES("SK00094BR10","2","12");
INSERT INTO replanishment VALUES("SK00094BR11","1","12");
INSERT INTO replanishment VALUES("SK00095WH08","2","12");
INSERT INTO replanishment VALUES("SK00095WH09","2","12");
INSERT INTO replanishment VALUES("SK00095WH10","2","12");
INSERT INTO replanishment VALUES("SK00095WH11","1","12");
INSERT INTO replanishment VALUES("SK00096WH08","2","12");
INSERT INTO replanishment VALUES("SK00096WH09","2","12");
INSERT INTO replanishment VALUES("SK00096WH10","2","12");
INSERT INTO replanishment VALUES("SK00096WH11","1","12");
INSERT INTO replanishment VALUES("SK00097RS08","2","12");
INSERT INTO replanishment VALUES("SK00097RS09","2","12");
INSERT INTO replanishment VALUES("SK00097RS10","2","12");
INSERT INTO replanishment VALUES("SK00097RS11","1","12");
INSERT INTO replanishment VALUES("SK00098DB08","2","12");
INSERT INTO replanishment VALUES("SK00098DB09","2","12");
INSERT INTO replanishment VALUES("SK00098DB10","2","12");
INSERT INTO replanishment VALUES("SK00098DB11","1","12");
INSERT INTO replanishment VALUES("SK00099OW08","2","12");
INSERT INTO replanishment VALUES("SK00099OW09","2","12");
INSERT INTO replanishment VALUES("SK00099OW10","2","12");
INSERT INTO replanishment VALUES("SK00099OW11","1","12");
INSERT INTO replanishment VALUES("SK00100GR08","2","12");
INSERT INTO replanishment VALUES("SK00100GR09","2","12");
INSERT INTO replanishment VALUES("SK00100GR10","2","12");
INSERT INTO replanishment VALUES("SK00100GR11","1","12");
INSERT INTO replanishment VALUES("SK00101LG08","2","12");
INSERT INTO replanishment VALUES("SK00101LG09","2","12");
INSERT INTO replanishment VALUES("SK00101LG10","2","12");
INSERT INTO replanishment VALUES("SK00101LG11","1","12");
INSERT INTO replanishment VALUES("SK00102SB08","2","12");
INSERT INTO replanishment VALUES("SK00102SB09","2","12");
INSERT INTO replanishment VALUES("SK00102SB10","2","12");
INSERT INTO replanishment VALUES("SK00102SB11","1","12");
INSERT INTO replanishment VALUES("SK00103FN08","2","12");
INSERT INTO replanishment VALUES("SK00103FN09","2","12");
INSERT INTO replanishment VALUES("SK00103FN10","2","12");
INSERT INTO replanishment VALUES("SK00103FN11","1","12");
INSERT INTO replanishment VALUES("SK00105CB08","2","12");
INSERT INTO replanishment VALUES("SK00105CB09","2","12");
INSERT INTO replanishment VALUES("SK00105CB10","2","12");
INSERT INTO replanishment VALUES("SK00105CB11","1","12");
INSERT INTO replanishment VALUES("SK00107NB08","2","12");
INSERT INTO replanishment VALUES("SK00107NB09","2","12");
INSERT INTO replanishment VALUES("SK00107NB10","2","12");
INSERT INTO replanishment VALUES("SK00107NB11","1","12");
INSERT INTO replanishment VALUES("SK00109WH08","2","12");
INSERT INTO replanishment VALUES("SK00109WH09","2","12");
INSERT INTO replanishment VALUES("SK00109WH10","2","12");
INSERT INTO replanishment VALUES("SK00109WH11","1","12");
INSERT INTO replanishment VALUES("SK00110GO08","2","12");
INSERT INTO replanishment VALUES("SK00110GO09","2","12");
INSERT INTO replanishment VALUES("SK00110GO10","2","12");
INSERT INTO replanishment VALUES("SK00110GO11","1","12");
INSERT INTO replanishment VALUES("SK00112PU08","2","12");
INSERT INTO replanishment VALUES("SK00112PU09","2","12");
INSERT INTO replanishment VALUES("SK00112PU10","2","12");
INSERT INTO replanishment VALUES("SK00112PU11","1","12");
INSERT INTO replanishment VALUES("SK00113GY08","2","12");
INSERT INTO replanishment VALUES("SK00113GY09","2","12");
INSERT INTO replanishment VALUES("SK00113GY10","2","12");
INSERT INTO replanishment VALUES("SK00113GY11","1","12");
INSERT INTO replanishment VALUES("SK00114BR08","2","12");
INSERT INTO replanishment VALUES("SK00114BR09","2","12");
INSERT INTO replanishment VALUES("SK00114BR10","2","12");
INSERT INTO replanishment VALUES("SK00114BR11","1","12");
INSERT INTO replanishment VALUES("SK00115BL08","2","12");
INSERT INTO replanishment VALUES("SK00115BL09","2","12");
INSERT INTO replanishment VALUES("SK00115BL10","2","12");
INSERT INTO replanishment VALUES("SK00115BL11","1","12");
INSERT INTO replanishment VALUES("SK00116GY08","2","12");
INSERT INTO replanishment VALUES("SK00116GY09","2","12");
INSERT INTO replanishment VALUES("SK00116GY10","2","12");
INSERT INTO replanishment VALUES("SK00116GY11","1","12");
INSERT INTO replanishment VALUES("SK00117BL08","2","12");
INSERT INTO replanishment VALUES("SK00117BL09","2","12");
INSERT INTO replanishment VALUES("SK00117BL10","2","12");
INSERT INTO replanishment VALUES("SK00117BL11","1","12");
INSERT INTO replanishment VALUES("SK00118BL08","2","12");
INSERT INTO replanishment VALUES("SK00118BL09","2","12");
INSERT INTO replanishment VALUES("SK00118BL10","2","12");
INSERT INTO replanishment VALUES("SK00118BL11","1","12");
INSERT INTO replanishment VALUES("SK00119BL08","2","12");
INSERT INTO replanishment VALUES("SK00119BL09","2","12");
INSERT INTO replanishment VALUES("SK00119BL10","2","12");
INSERT INTO replanishment VALUES("SK00119BL11","1","12");
INSERT INTO replanishment VALUES("SK00120MR08","2","12");
INSERT INTO replanishment VALUES("SK00120MR09","2","12");
INSERT INTO replanishment VALUES("SK00120MR10","2","12");
INSERT INTO replanishment VALUES("SK00120MR11","1","12");
INSERT INTO replanishment VALUES("SK00121BL08","2","12");
INSERT INTO replanishment VALUES("SK00121BL09","2","12");
INSERT INTO replanishment VALUES("SK00121BL10","2","12");
INSERT INTO replanishment VALUES("SK00121BL11","1","12");
INSERT INTO replanishment VALUES("SK00122WH08","0","12");
INSERT INTO replanishment VALUES("SK00122WH09","0","12");
INSERT INTO replanishment VALUES("SK00122WH10","0","12");
INSERT INTO replanishment VALUES("SK00122WH11","0","12");
INSERT INTO replanishment VALUES("SD03001BL08","2","05");
INSERT INTO replanishment VALUES("SD03001BL09","2","05");
INSERT INTO replanishment VALUES("SD03001BL10","2","05");
INSERT INTO replanishment VALUES("SD03001BL11","1","05");
INSERT INTO replanishment VALUES("SD03002BL08","2","05");
INSERT INTO replanishment VALUES("SD03002BL09","2","05");
INSERT INTO replanishment VALUES("SD03002BL10","2","05");
INSERT INTO replanishment VALUES("SD03002BL11","1","05");
INSERT INTO replanishment VALUES("SD03003BL08","2","05");
INSERT INTO replanishment VALUES("SD03003BL09","2","05");
INSERT INTO replanishment VALUES("SD03003BL10","2","05");
INSERT INTO replanishment VALUES("SD03003BL11","1","05");
INSERT INTO replanishment VALUES("SD03004BL08","2","05");
INSERT INTO replanishment VALUES("SD03004BL09","2","05");
INSERT INTO replanishment VALUES("SD03004BL10","2","05");
INSERT INTO replanishment VALUES("SD03004BL11","1","05");
INSERT INTO replanishment VALUES("SD03005OW08","2","05");
INSERT INTO replanishment VALUES("SD03005OW09","2","05");
INSERT INTO replanishment VALUES("SD03005OW10","2","05");
INSERT INTO replanishment VALUES("SD03005OW11","1","05");
INSERT INTO replanishment VALUES("SD03006GO08","2","05");
INSERT INTO replanishment VALUES("SD03006GO09","2","05");
INSERT INTO replanishment VALUES("SD03006GO10","2","05");
INSERT INTO replanishment VALUES("SD03006GO11","1","05");
INSERT INTO replanishment VALUES("SD03007BL08","2","05");
INSERT INTO replanishment VALUES("SD03007BL09","2","05");
INSERT INTO replanishment VALUES("SD03007BL10","2","05");
INSERT INTO replanishment VALUES("SD03007BL11","1","05");
INSERT INTO replanishment VALUES("SD04001BG08","2","05");
INSERT INTO replanishment VALUES("SD04001BG09","2","05");
INSERT INTO replanishment VALUES("SD04001BG10","2","05");
INSERT INTO replanishment VALUES("SD04001BG11","1","05");
INSERT INTO replanishment VALUES("SD04002YB08","2","05");
INSERT INTO replanishment VALUES("SD04002YB09","2","05");
INSERT INTO replanishment VALUES("SD04002YB10","2","05");
INSERT INTO replanishment VALUES("SD04002YB11","1","05");
INSERT INTO replanishment VALUES("SD07001SB08","2","05");
INSERT INTO replanishment VALUES("SD07001SB09","2","05");
INSERT INTO replanishment VALUES("SD07001SB10","2","05");
INSERT INTO replanishment VALUES("SD07001SB11","1","05");
INSERT INTO replanishment VALUES("SD07002BU08","2","05");
INSERT INTO replanishment VALUES("SD07002BU09","2","05");
INSERT INTO replanishment VALUES("SD07002BU10","2","05");
INSERT INTO replanishment VALUES("SD07002BU11","1","05");
INSERT INTO replanishment VALUES("SD07003LR08","2","05");
INSERT INTO replanishment VALUES("SD07003LR09","2","05");
INSERT INTO replanishment VALUES("SD07003LR10","2","05");
INSERT INTO replanishment VALUES("SD07003LR11","1","05");
INSERT INTO replanishment VALUES("SD07004MR08","2","05");
INSERT INTO replanishment VALUES("SD07004MR09","2","05");
INSERT INTO replanishment VALUES("SD07004MR10","2","05");
INSERT INTO replanishment VALUES("SD07004MR11","1","05");
INSERT INTO replanishment VALUES("SD10001BL08","2","05");
INSERT INTO replanishment VALUES("SD10001BL09","2","05");
INSERT INTO replanishment VALUES("SD10001BL10","2","05");
INSERT INTO replanishment VALUES("SD10001BL11","1","05");
INSERT INTO replanishment VALUES("SD10002BL08","2","05");
INSERT INTO replanishment VALUES("SD10002BL09","2","05");
INSERT INTO replanishment VALUES("SD10002BL10","2","05");
INSERT INTO replanishment VALUES("SD10002BL11","1","05");
INSERT INTO replanishment VALUES("SD10003BL08","2","05");
INSERT INTO replanishment VALUES("SD10003BL09","2","05");
INSERT INTO replanishment VALUES("SD10003BL10","2","05");
INSERT INTO replanishment VALUES("SD10003BL11","1","05");
INSERT INTO replanishment VALUES("SD10004BL08","2","05");
INSERT INTO replanishment VALUES("SD10004BL09","2","05");
INSERT INTO replanishment VALUES("SD10004BL10","2","05");
INSERT INTO replanishment VALUES("SD10004BL11","1","05");
INSERT INTO replanishment VALUES("SD10005OW08","2","05");
INSERT INTO replanishment VALUES("SD10005OW09","2","05");
INSERT INTO replanishment VALUES("SD10005OW10","2","05");
INSERT INTO replanishment VALUES("SD10005OW11","1","05");
INSERT INTO replanishment VALUES("SD10006GO08","2","05");
INSERT INTO replanishment VALUES("SD10006GO09","2","05");
INSERT INTO replanishment VALUES("SD10006GO10","2","05");
INSERT INTO replanishment VALUES("SD10006GO11","1","05");
INSERT INTO replanishment VALUES("SD10007BL08","2","05");
INSERT INTO replanishment VALUES("SD10007BL09","2","05");
INSERT INTO replanishment VALUES("SD10007BL10","2","05");
INSERT INTO replanishment VALUES("SD10007BL11","1","05");
INSERT INTO replanishment VALUES("SD10008BU08","2","05");
INSERT INTO replanishment VALUES("SD10008BU09","2","05");
INSERT INTO replanishment VALUES("SD10008BU10","2","05");
INSERT INTO replanishment VALUES("SD10008BU11","1","05");
INSERT INTO replanishment VALUES("SD10009MR08","2","05");
INSERT INTO replanishment VALUES("SD10009MR09","2","05");
INSERT INTO replanishment VALUES("SD10009MR10","2","05");
INSERT INTO replanishment VALUES("SD10009MR11","1","05");
INSERT INTO replanishment VALUES("SD11001GO08","2","05");
INSERT INTO replanishment VALUES("SD11001GO09","2","05");
INSERT INTO replanishment VALUES("SD11001GO10","2","05");
INSERT INTO replanishment VALUES("SD11001GO11","1","05");
INSERT INTO replanishment VALUES("SD11002RD08","2","05");
INSERT INTO replanishment VALUES("SD11002RD09","2","05");
INSERT INTO replanishment VALUES("SD11002RD10","2","05");
INSERT INTO replanishment VALUES("SD11002RD11","1","05");
INSERT INTO replanishment VALUES("SD11003WH08","2","05");
INSERT INTO replanishment VALUES("SD11003WH09","2","05");
INSERT INTO replanishment VALUES("SD11003WH10","2","05");
INSERT INTO replanishment VALUES("SD11003WH11","1","05");
INSERT INTO replanishment VALUES("SD12001BL08","2","05");
INSERT INTO replanishment VALUES("SD12001BL09","2","05");
INSERT INTO replanishment VALUES("SD12001BL10","2","05");
INSERT INTO replanishment VALUES("SD12001BL11","1","05");
INSERT INTO replanishment VALUES("SD12002BU08","2","05");
INSERT INTO replanishment VALUES("SD12002BU09","2","05");
INSERT INTO replanishment VALUES("SD12002BU10","2","05");
INSERT INTO replanishment VALUES("SD12002BU11","1","05");
INSERT INTO replanishment VALUES("SD12003BL08","2","05");
INSERT INTO replanishment VALUES("SD12003BL09","2","05");
INSERT INTO replanishment VALUES("SD12003BL10","2","05");
INSERT INTO replanishment VALUES("SD12003BL11","1","05");
INSERT INTO replanishment VALUES("SD12004BU08","2","05");
INSERT INTO replanishment VALUES("SD12004BU09","2","05");
INSERT INTO replanishment VALUES("SD12004BU10","2","05");
INSERT INTO replanishment VALUES("SD12004BU11","1","05");
INSERT INTO replanishment VALUES("SD12005BL08","2","05");
INSERT INTO replanishment VALUES("SD12005BL09","2","05");
INSERT INTO replanishment VALUES("SD12005BL10","2","05");
INSERT INTO replanishment VALUES("SD12005BL11","1","05");
INSERT INTO replanishment VALUES("SG00001PU08","2","05");
INSERT INTO replanishment VALUES("SG00001PU09","2","05");
INSERT INTO replanishment VALUES("SG00001PU10","2","05");
INSERT INTO replanishment VALUES("SG00001PU11","1","05");
INSERT INTO replanishment VALUES("SG00002OW08","2","05");
INSERT INTO replanishment VALUES("SG00002OW09","2","05");
INSERT INTO replanishment VALUES("SG00002OW10","2","05");
INSERT INTO replanishment VALUES("SG00002OW11","1","05");
INSERT INTO replanishment VALUES("SG00003BL08","2","05");
INSERT INTO replanishment VALUES("SG00003BL09","2","05");
INSERT INTO replanishment VALUES("SG00003BL10","2","05");
INSERT INTO replanishment VALUES("SG00003BL11","1","05");
INSERT INTO replanishment VALUES("SG00004SN08","2","05");
INSERT INTO replanishment VALUES("SG00004SN09","2","05");
INSERT INTO replanishment VALUES("SG00004SN10","2","05");
INSERT INTO replanishment VALUES("SG00004SN11","1","05");
INSERT INTO replanishment VALUES("SG00005BU08","2","05");
INSERT INTO replanishment VALUES("SG00005BU09","2","05");
INSERT INTO replanishment VALUES("SG00005BU10","2","05");
INSERT INTO replanishment VALUES("SG00005BU11","1","05");
INSERT INTO replanishment VALUES("SG00006GO08","2","05");
INSERT INTO replanishment VALUES("SG00006GO09","2","05");
INSERT INTO replanishment VALUES("SG00006GO10","2","05");
INSERT INTO replanishment VALUES("SG00006GO11","1","05");
INSERT INTO replanishment VALUES("SG00007BR08","2","05");
INSERT INTO replanishment VALUES("SG00007BR09","2","05");
INSERT INTO replanishment VALUES("SG00007BR10","2","05");
INSERT INTO replanishment VALUES("SG00007BR11","1","05");
INSERT INTO replanishment VALUES("SG00008BU08","2","05");
INSERT INTO replanishment VALUES("SG00008BU09","2","05");
INSERT INTO replanishment VALUES("SG00008BU10","2","05");
INSERT INTO replanishment VALUES("SG00008BU11","1","05");
INSERT INTO replanishment VALUES("SG00009BU08","2","05");
INSERT INTO replanishment VALUES("SG00009BU09","2","05");
INSERT INTO replanishment VALUES("SG00009BU10","2","05");
INSERT INTO replanishment VALUES("SG00009BU11","1","05");
INSERT INTO replanishment VALUES("SG00010MS08","2","05");
INSERT INTO replanishment VALUES("SG00010MS09","2","05");
INSERT INTO replanishment VALUES("SG00010MS10","2","05");
INSERT INTO replanishment VALUES("SG00010MS11","1","05");
INSERT INTO replanishment VALUES("SG00011BR08","2","05");
INSERT INTO replanishment VALUES("SG00011BR09","2","05");
INSERT INTO replanishment VALUES("SG00011BR10","2","05");
INSERT INTO replanishment VALUES("SG00011BR11","1","05");
INSERT INTO replanishment VALUES("SG00012KH08","2","05");
INSERT INTO replanishment VALUES("SG00012KH09","2","05");
INSERT INTO replanishment VALUES("SG00012KH10","2","05");
INSERT INTO replanishment VALUES("SG00012KH11","1","05");
INSERT INTO replanishment VALUES("SG00013MR08","2","05");
INSERT INTO replanishment VALUES("SG00013MR09","2","05");
INSERT INTO replanishment VALUES("SG00013MR10","2","05");
INSERT INTO replanishment VALUES("SG00013MR11","1","05");
INSERT INTO replanishment VALUES("SG00014BL08","2","05");
INSERT INTO replanishment VALUES("SG00014BL09","2","05");
INSERT INTO replanishment VALUES("SG00014BL10","2","05");
INSERT INTO replanishment VALUES("SG00014BL11","1","05");
INSERT INTO replanishment VALUES("SG00015SB08","2","05");
INSERT INTO replanishment VALUES("SG00015SB09","2","05");
INSERT INTO replanishment VALUES("SG00015SB10","2","05");
INSERT INTO replanishment VALUES("SG00015SB11","1","05");
INSERT INTO replanishment VALUES("SG00016WH08","2","05");
INSERT INTO replanishment VALUES("SG00016WH09","2","05");
INSERT INTO replanishment VALUES("SG00016WH10","2","05");
INSERT INTO replanishment VALUES("SG00016WH11","1","05");
INSERT INTO replanishment VALUES("SG00017WH08","2","05");
INSERT INTO replanishment VALUES("SG00017WH09","2","05");
INSERT INTO replanishment VALUES("SG00017WH10","2","05");
INSERT INTO replanishment VALUES("SG00017WH11","1","05");
INSERT INTO replanishment VALUES("SG00018WH08","2","05");
INSERT INTO replanishment VALUES("SG00018WH09","2","05");
INSERT INTO replanishment VALUES("SG00018WH10","2","05");
INSERT INTO replanishment VALUES("SG00018WH11","1","05");
INSERT INTO replanishment VALUES("SG00019CB08","2","05");
INSERT INTO replanishment VALUES("SG00019CB09","2","05");
INSERT INTO replanishment VALUES("SG00019CB10","2","05");
INSERT INTO replanishment VALUES("SG00019CB11","1","05");
INSERT INTO replanishment VALUES("SG00020MR08","2","05");
INSERT INTO replanishment VALUES("SG00020MR09","2","05");
INSERT INTO replanishment VALUES("SG00020MR10","2","05");
INSERT INTO replanishment VALUES("SG00020MR11","1","05");
INSERT INTO replanishment VALUES("SG00021BL08","2","05");
INSERT INTO replanishment VALUES("SG00021BL09","2","05");
INSERT INTO replanishment VALUES("SG00021BL10","2","05");
INSERT INTO replanishment VALUES("SG00021BL11","1","05");
INSERT INTO replanishment VALUES("SG00022BR08","2","05");
INSERT INTO replanishment VALUES("SG00022BR09","2","05");
INSERT INTO replanishment VALUES("SG00022BR10","2","05");
INSERT INTO replanishment VALUES("SG00022BR11","1","05");
INSERT INTO replanishment VALUES("SG02097GO08","2","05");
INSERT INTO replanishment VALUES("SG02097GO09","2","05");
INSERT INTO replanishment VALUES("SG02097GO10","2","05");
INSERT INTO replanishment VALUES("SG02097GO11","1","05");
INSERT INTO replanishment VALUES("SG03001MD08","2","05");
INSERT INTO replanishment VALUES("SG03001MD09","2","05");
INSERT INTO replanishment VALUES("SG03001MD10","2","05");
INSERT INTO replanishment VALUES("SG03001MD11","1","05");
INSERT INTO replanishment VALUES("SG03001OW08","2","05");
INSERT INTO replanishment VALUES("SG03001OW09","2","05");
INSERT INTO replanishment VALUES("SG03001OW10","2","05");
INSERT INTO replanishment VALUES("SG03001OW11","1","05");
INSERT INTO replanishment VALUES("SG03002MD08","2","05");
INSERT INTO replanishment VALUES("SG03002MD09","2","05");
INSERT INTO replanishment VALUES("SG03002MD10","2","05");
INSERT INTO replanishment VALUES("SG03002MD11","1","05");
INSERT INTO replanishment VALUES("SG03002OW08","2","05");
INSERT INTO replanishment VALUES("SG03002OW09","2","05");
INSERT INTO replanishment VALUES("SG03002OW10","2","05");
INSERT INTO replanishment VALUES("SG03002OW11","1","05");
INSERT INTO replanishment VALUES("SG04001SG08","2","05");
INSERT INTO replanishment VALUES("SG04001SG09","2","05");
INSERT INTO replanishment VALUES("SG04001SG10","2","05");
INSERT INTO replanishment VALUES("SG04001SG11","1","05");
INSERT INTO replanishment VALUES("SG04002MR08","2","05");
INSERT INTO replanishment VALUES("SG04002MR09","2","05");
INSERT INTO replanishment VALUES("SG04002MR10","2","05");
INSERT INTO replanishment VALUES("SG04002MR11","1","05");
INSERT INTO replanishment VALUES("SG04002MV08","2","05");
INSERT INTO replanishment VALUES("SG04002MV09","2","05");
INSERT INTO replanishment VALUES("SG04002MV10","2","05");
INSERT INTO replanishment VALUES("SG04002MV11","1","05");
INSERT INTO replanishment VALUES("SG04003MR08","2","05");
INSERT INTO replanishment VALUES("SG04003MR09","2","05");
INSERT INTO replanishment VALUES("SG04003MR10","2","05");
INSERT INTO replanishment VALUES("SG04003MR11","1","05");
INSERT INTO replanishment VALUES("SG04004PK08","2","05");
INSERT INTO replanishment VALUES("SG04004PK09","2","05");
INSERT INTO replanishment VALUES("SG04004PK10","2","05");
INSERT INTO replanishment VALUES("SG04004PK11","1","05");
INSERT INTO replanishment VALUES("SG04005PR08","2","05");
INSERT INTO replanishment VALUES("SG04005PR09","2","05");
INSERT INTO replanishment VALUES("SG04005PR10","2","05");
INSERT INTO replanishment VALUES("SG04005PR11","1","05");
INSERT INTO replanishment VALUES("SK00001BR08","2","05");
INSERT INTO replanishment VALUES("SK00001BR09","2","05");
INSERT INTO replanishment VALUES("SK00001BR10","2","05");
INSERT INTO replanishment VALUES("SK00001BR11","1","05");
INSERT INTO replanishment VALUES("SK00001GR08","2","05");
INSERT INTO replanishment VALUES("SK00001GR09","2","05");
INSERT INTO replanishment VALUES("SK00001GR10","2","05");
INSERT INTO replanishment VALUES("SK00001GR11","1","05");
INSERT INTO replanishment VALUES("SK00002MU08","2","05");
INSERT INTO replanishment VALUES("SK00002MU09","2","05");
INSERT INTO replanishment VALUES("SK00002MU10","2","05");
INSERT INTO replanishment VALUES("SK00002MU11","1","05");
INSERT INTO replanishment VALUES("SK00003BL08","2","05");
INSERT INTO replanishment VALUES("SK00003BL09","2","05");
INSERT INTO replanishment VALUES("SK00003BL10","2","05");
INSERT INTO replanishment VALUES("SK00003BL11","1","05");
INSERT INTO replanishment VALUES("SK00003WH08","2","05");
INSERT INTO replanishment VALUES("SK00003WH09","2","05");
INSERT INTO replanishment VALUES("SK00003WH10","2","05");
INSERT INTO replanishment VALUES("SK00003WH11","1","05");
INSERT INTO replanishment VALUES("SK00004BL08","2","05");
INSERT INTO replanishment VALUES("SK00004BL09","2","05");
INSERT INTO replanishment VALUES("SK00004BL10","2","05");
INSERT INTO replanishment VALUES("SK00004BL11","1","05");
INSERT INTO replanishment VALUES("SK00005WH08","2","05");
INSERT INTO replanishment VALUES("SK00005WH09","2","05");
INSERT INTO replanishment VALUES("SK00005WH10","2","05");
INSERT INTO replanishment VALUES("SK00005WH11","1","05");
INSERT INTO replanishment VALUES("SK00006GR08","2","05");
INSERT INTO replanishment VALUES("SK00006GR09","2","05");
INSERT INTO replanishment VALUES("SK00006GR10","2","05");
INSERT INTO replanishment VALUES("SK00006GR11","1","05");
INSERT INTO replanishment VALUES("SK00006GY08","2","05");
INSERT INTO replanishment VALUES("SK00006GY09","2","05");
INSERT INTO replanishment VALUES("SK00006GY10","2","05");
INSERT INTO replanishment VALUES("SK00006GY11","1","05");
INSERT INTO replanishment VALUES("SK00007GY08","2","05");
INSERT INTO replanishment VALUES("SK00007GY09","2","05");
INSERT INTO replanishment VALUES("SK00007GY10","2","05");
INSERT INTO replanishment VALUES("SK00007GY11","1","05");
INSERT INTO replanishment VALUES("SK00008PL08","2","05");
INSERT INTO replanishment VALUES("SK00008PL09","2","05");
INSERT INTO replanishment VALUES("SK00008PL10","2","05");
INSERT INTO replanishment VALUES("SK00008PL11","1","05");
INSERT INTO replanishment VALUES("SK00009BR08","2","05");
INSERT INTO replanishment VALUES("SK00009BR09","2","05");
INSERT INTO replanishment VALUES("SK00009BR10","2","05");
INSERT INTO replanishment VALUES("SK00009BR11","1","05");
INSERT INTO replanishment VALUES("SK00010GR08","2","05");
INSERT INTO replanishment VALUES("SK00010GR09","2","05");
INSERT INTO replanishment VALUES("SK00010GR10","2","05");
INSERT INTO replanishment VALUES("SK00010GR11","1","05");
INSERT INTO replanishment VALUES("SK00011DG08","2","05");
INSERT INTO replanishment VALUES("SK00011DG09","2","05");
INSERT INTO replanishment VALUES("SK00011DG10","2","05");
INSERT INTO replanishment VALUES("SK00011DG11","1","05");
INSERT INTO replanishment VALUES("SK00011LG08","2","05");
INSERT INTO replanishment VALUES("SK00011LG09","2","05");
INSERT INTO replanishment VALUES("SK00011LG10","2","05");
INSERT INTO replanishment VALUES("SK00011LG11","1","05");
INSERT INTO replanishment VALUES("SK00012BR08","2","05");
INSERT INTO replanishment VALUES("SK00012BR09","2","05");
INSERT INTO replanishment VALUES("SK00012BR10","2","05");
INSERT INTO replanishment VALUES("SK00012BR11","1","05");
INSERT INTO replanishment VALUES("SK00012GY08","2","05");
INSERT INTO replanishment VALUES("SK00012GY09","2","05");
INSERT INTO replanishment VALUES("SK00012GY10","2","05");
INSERT INTO replanishment VALUES("SK00012GY11","1","05");
INSERT INTO replanishment VALUES("SK00013MH08","2","05");
INSERT INTO replanishment VALUES("SK00013MH09","2","05");
INSERT INTO replanishment VALUES("SK00013MH10","2","05");
INSERT INTO replanishment VALUES("SK00013MH11","1","05");
INSERT INTO replanishment VALUES("SK00017BL08","2","05");
INSERT INTO replanishment VALUES("SK00017BL09","2","05");
INSERT INTO replanishment VALUES("SK00017BL10","2","05");
INSERT INTO replanishment VALUES("SK00017BL11","1","05");
INSERT INTO replanishment VALUES("SK00017BU08","2","05");
INSERT INTO replanishment VALUES("SK00017BU09","2","05");
INSERT INTO replanishment VALUES("SK00017BU10","2","05");
INSERT INTO replanishment VALUES("SK00017BU11","1","05");
INSERT INTO replanishment VALUES("SK00018BR08","2","05");
INSERT INTO replanishment VALUES("SK00018BR09","2","05");
INSERT INTO replanishment VALUES("SK00018BR10","2","05");
INSERT INTO replanishment VALUES("SK00018BR11","1","05");
INSERT INTO replanishment VALUES("SK00018BU08","2","05");
INSERT INTO replanishment VALUES("SK00018BU09","2","05");
INSERT INTO replanishment VALUES("SK00018BU10","2","05");
INSERT INTO replanishment VALUES("SK00018BU11","1","05");
INSERT INTO replanishment VALUES("SK00018GB08","2","05");
INSERT INTO replanishment VALUES("SK00018GB09","2","05");
INSERT INTO replanishment VALUES("SK00018GB10","2","05");
INSERT INTO replanishment VALUES("SK00018GB11","1","05");
INSERT INTO replanishment VALUES("SK00019BR08","2","05");
INSERT INTO replanishment VALUES("SK00019BR09","2","05");
INSERT INTO replanishment VALUES("SK00019BR10","2","05");
INSERT INTO replanishment VALUES("SK00019BR11","1","05");
INSERT INTO replanishment VALUES("SK00020PR08","2","05");
INSERT INTO replanishment VALUES("SK00020PR09","2","05");
INSERT INTO replanishment VALUES("SK00020PR10","2","05");
INSERT INTO replanishment VALUES("SK00020PR11","1","05");
INSERT INTO replanishment VALUES("SK00021WH08","2","05");
INSERT INTO replanishment VALUES("SK00021WH09","2","05");
INSERT INTO replanishment VALUES("SK00021WH10","2","05");
INSERT INTO replanishment VALUES("SK00021WH11","1","05");
INSERT INTO replanishment VALUES("SK00022GY08","2","05");
INSERT INTO replanishment VALUES("SK00022GY09","2","05");
INSERT INTO replanishment VALUES("SK00022GY10","2","05");
INSERT INTO replanishment VALUES("SK00022GY11","1","05");
INSERT INTO replanishment VALUES("SK00022MR08","2","05");
INSERT INTO replanishment VALUES("SK00022MR09","2","05");
INSERT INTO replanishment VALUES("SK00022MR10","2","05");
INSERT INTO replanishment VALUES("SK00022MR11","1","05");
INSERT INTO replanishment VALUES("SK00023BU08","2","05");
INSERT INTO replanishment VALUES("SK00023BU09","2","05");
INSERT INTO replanishment VALUES("SK00023BU10","2","05");
INSERT INTO replanishment VALUES("SK00023BU11","1","05");
INSERT INTO replanishment VALUES("SK00023GR08","2","05");
INSERT INTO replanishment VALUES("SK00023GR09","2","05");
INSERT INTO replanishment VALUES("SK00023GR10","2","05");
INSERT INTO replanishment VALUES("SK00023GR11","1","05");
INSERT INTO replanishment VALUES("SK00025BU08","2","05");
INSERT INTO replanishment VALUES("SK00025BU09","2","05");
INSERT INTO replanishment VALUES("SK00025BU10","2","05");
INSERT INTO replanishment VALUES("SK00025BU11","1","05");
INSERT INTO replanishment VALUES("SK00025MV08","2","05");
INSERT INTO replanishment VALUES("SK00025MV09","2","05");
INSERT INTO replanishment VALUES("SK00025MV10","2","05");
INSERT INTO replanishment VALUES("SK00025MV11","1","05");
INSERT INTO replanishment VALUES("SK00025PU08","2","05");
INSERT INTO replanishment VALUES("SK00025PU09","2","05");
INSERT INTO replanishment VALUES("SK00025PU10","2","05");
INSERT INTO replanishment VALUES("SK00025PU11","1","05");
INSERT INTO replanishment VALUES("SK00026BD08","2","05");
INSERT INTO replanishment VALUES("SK00026BD09","2","05");
INSERT INTO replanishment VALUES("SK00026BD10","2","05");
INSERT INTO replanishment VALUES("SK00026BD11","1","05");
INSERT INTO replanishment VALUES("SK00026FE08","2","05");
INSERT INTO replanishment VALUES("SK00026FE09","2","05");
INSERT INTO replanishment VALUES("SK00026FE10","2","05");
INSERT INTO replanishment VALUES("SK00026FE11","1","05");
INSERT INTO replanishment VALUES("SK00026NE08","2","05");
INSERT INTO replanishment VALUES("SK00026NE09","2","05");
INSERT INTO replanishment VALUES("SK00026NE10","2","05");
INSERT INTO replanishment VALUES("SK00026NE11","1","05");
INSERT INTO replanishment VALUES("SK00027CR08","2","05");
INSERT INTO replanishment VALUES("SK00027CR09","2","05");
INSERT INTO replanishment VALUES("SK00027CR10","2","05");
INSERT INTO replanishment VALUES("SK00027CR11","1","05");
INSERT INTO replanishment VALUES("SK00027FE08","2","05");
INSERT INTO replanishment VALUES("SK00027FE09","2","05");
INSERT INTO replanishment VALUES("SK00027FE10","2","05");
INSERT INTO replanishment VALUES("SK00027FE11","1","05");
INSERT INTO replanishment VALUES("SK00027LV08","2","05");
INSERT INTO replanishment VALUES("SK00027LV09","2","05");
INSERT INTO replanishment VALUES("SK00027LV10","2","05");
INSERT INTO replanishment VALUES("SK00027LV11","1","05");
INSERT INTO replanishment VALUES("SK00030BU08","2","05");
INSERT INTO replanishment VALUES("SK00030BU09","2","05");
INSERT INTO replanishment VALUES("SK00030BU10","2","05");
INSERT INTO replanishment VALUES("SK00030BU11","1","05");
INSERT INTO replanishment VALUES("SK00033BU08","2","05");
INSERT INTO replanishment VALUES("SK00033BU09","2","05");
INSERT INTO replanishment VALUES("SK00033BU10","2","05");
INSERT INTO replanishment VALUES("SK00033BU11","1","05");
INSERT INTO replanishment VALUES("SK00033WH08","2","05");
INSERT INTO replanishment VALUES("SK00033WH09","2","05");
INSERT INTO replanishment VALUES("SK00033WH10","2","05");
INSERT INTO replanishment VALUES("SK00033WH11","1","05");
INSERT INTO replanishment VALUES("SK00034WH08","2","05");
INSERT INTO replanishment VALUES("SK00034WH09","2","05");
INSERT INTO replanishment VALUES("SK00034WH10","2","05");
INSERT INTO replanishment VALUES("SK00034WH11","1","05");
INSERT INTO replanishment VALUES("SK00035BL08","2","05");
INSERT INTO replanishment VALUES("SK00035BL09","2","05");
INSERT INTO replanishment VALUES("SK00035BL10","2","05");
INSERT INTO replanishment VALUES("SK00035BL11","1","05");
INSERT INTO replanishment VALUES("SK00036GO08","2","05");
INSERT INTO replanishment VALUES("SK00036GO09","2","05");
INSERT INTO replanishment VALUES("SK00036GO10","2","05");
INSERT INTO replanishment VALUES("SK00036GO11","1","05");
INSERT INTO replanishment VALUES("SK00036GR08","2","05");
INSERT INTO replanishment VALUES("SK00036GR09","2","05");
INSERT INTO replanishment VALUES("SK00036GR10","2","05");
INSERT INTO replanishment VALUES("SK00036GR11","1","05");
INSERT INTO replanishment VALUES("SK00036GY08","2","05");
INSERT INTO replanishment VALUES("SK00036GY09","2","05");
INSERT INTO replanishment VALUES("SK00036GY10","2","05");
INSERT INTO replanishment VALUES("SK00036GY11","1","05");
INSERT INTO replanishment VALUES("SK00037BL08","2","05");
INSERT INTO replanishment VALUES("SK00037BL09","2","05");
INSERT INTO replanishment VALUES("SK00037BL10","2","05");
INSERT INTO replanishment VALUES("SK00037BL11","1","05");
INSERT INTO replanishment VALUES("SK00038GO08","2","05");
INSERT INTO replanishment VALUES("SK00038GO09","2","05");
INSERT INTO replanishment VALUES("SK00038GO10","2","05");
INSERT INTO replanishment VALUES("SK00038GO11","1","05");
INSERT INTO replanishment VALUES("SK00039GY08","2","05");
INSERT INTO replanishment VALUES("SK00039GY09","2","05");
INSERT INTO replanishment VALUES("SK00039GY10","2","05");
INSERT INTO replanishment VALUES("SK00039GY11","1","05");
INSERT INTO replanishment VALUES("SK00040GR08","2","05");
INSERT INTO replanishment VALUES("SK00040GR09","2","05");
INSERT INTO replanishment VALUES("SK00040GR10","2","05");
INSERT INTO replanishment VALUES("SK00040GR11","1","05");
INSERT INTO replanishment VALUES("SK00041PU08","2","05");
INSERT INTO replanishment VALUES("SK00041PU09","2","05");
INSERT INTO replanishment VALUES("SK00041PU10","2","05");
INSERT INTO replanishment VALUES("SK00041PU11","1","05");
INSERT INTO replanishment VALUES("SK00042BU08","2","05");
INSERT INTO replanishment VALUES("SK00042BU09","2","05");
INSERT INTO replanishment VALUES("SK00042BU10","2","05");
INSERT INTO replanishment VALUES("SK00042BU11","1","05");
INSERT INTO replanishment VALUES("SK00049GY08","2","05");
INSERT INTO replanishment VALUES("SK00049GY09","2","05");
INSERT INTO replanishment VALUES("SK00049GY10","2","05");
INSERT INTO replanishment VALUES("SK00049GY11","1","05");
INSERT INTO replanishment VALUES("SK00055OR08","2","05");
INSERT INTO replanishment VALUES("SK00055OR09","2","05");
INSERT INTO replanishment VALUES("SK00055OR10","2","05");
INSERT INTO replanishment VALUES("SK00055OR11","1","05");
INSERT INTO replanishment VALUES("SK00056MR08","2","05");
INSERT INTO replanishment VALUES("SK00056MR09","2","05");
INSERT INTO replanishment VALUES("SK00056MR10","2","05");
INSERT INTO replanishment VALUES("SK00056MR11","1","05");
INSERT INTO replanishment VALUES("SK00059GR08","2","05");
INSERT INTO replanishment VALUES("SK00059GR09","2","05");
INSERT INTO replanishment VALUES("SK00059GR10","2","05");
INSERT INTO replanishment VALUES("SK00059GR11","1","05");
INSERT INTO replanishment VALUES("SK00060WH08","2","05");
INSERT INTO replanishment VALUES("SK00060WH09","2","05");
INSERT INTO replanishment VALUES("SK00060WH10","2","05");
INSERT INTO replanishment VALUES("SK00060WH11","1","05");
INSERT INTO replanishment VALUES("SK00062BL08","2","05");
INSERT INTO replanishment VALUES("SK00062BL09","2","05");
INSERT INTO replanishment VALUES("SK00062BL10","2","05");
INSERT INTO replanishment VALUES("SK00062BL11","1","05");
INSERT INTO replanishment VALUES("SK00063BL08","2","05");
INSERT INTO replanishment VALUES("SK00063BL09","2","05");
INSERT INTO replanishment VALUES("SK00063BL10","2","05");
INSERT INTO replanishment VALUES("SK00063BL11","1","05");
INSERT INTO replanishment VALUES("SK00064BL08","2","05");
INSERT INTO replanishment VALUES("SK00064BL09","2","05");
INSERT INTO replanishment VALUES("SK00064BL10","2","05");
INSERT INTO replanishment VALUES("SK00064BL11","1","05");
INSERT INTO replanishment VALUES("SK00070BL08","2","05");
INSERT INTO replanishment VALUES("SK00070BL09","2","05");
INSERT INTO replanishment VALUES("SK00070BL10","2","05");
INSERT INTO replanishment VALUES("SK00070BL11","1","05");
INSERT INTO replanishment VALUES("SK00071GY08","2","05");
INSERT INTO replanishment VALUES("SK00071GY09","2","05");
INSERT INTO replanishment VALUES("SK00071GY10","2","05");
INSERT INTO replanishment VALUES("SK00071GY11","1","05");
INSERT INTO replanishment VALUES("SK00072BU08","2","05");
INSERT INTO replanishment VALUES("SK00072BU09","2","05");
INSERT INTO replanishment VALUES("SK00072BU10","2","05");
INSERT INTO replanishment VALUES("SK00072BU11","1","05");
INSERT INTO replanishment VALUES("SK00073PH08","2","05");
INSERT INTO replanishment VALUES("SK00073PH09","2","05");
INSERT INTO replanishment VALUES("SK00073PH10","2","05");
INSERT INTO replanishment VALUES("SK00073PH11","1","05");
INSERT INTO replanishment VALUES("SK00074BU08","2","05");
INSERT INTO replanishment VALUES("SK00074BU09","2","05");
INSERT INTO replanishment VALUES("SK00074BU10","2","05");
INSERT INTO replanishment VALUES("SK00074BU11","1","05");
INSERT INTO replanishment VALUES("SK00075BL08","2","05");
INSERT INTO replanishment VALUES("SK00075BL09","2","05");
INSERT INTO replanishment VALUES("SK00075BL10","2","05");
INSERT INTO replanishment VALUES("SK00075BL11","1","05");
INSERT INTO replanishment VALUES("SK00076BR08","2","05");
INSERT INTO replanishment VALUES("SK00076BR09","2","05");
INSERT INTO replanishment VALUES("SK00076BR10","2","05");
INSERT INTO replanishment VALUES("SK00076BR11","1","05");
INSERT INTO replanishment VALUES("SK00077WH08","2","05");
INSERT INTO replanishment VALUES("SK00077WH09","2","05");
INSERT INTO replanishment VALUES("SK00077WH10","2","05");
INSERT INTO replanishment VALUES("SK00077WH11","1","05");
INSERT INTO replanishment VALUES("SK00079WH08","2","05");
INSERT INTO replanishment VALUES("SK00079WH09","2","05");
INSERT INTO replanishment VALUES("SK00079WH10","2","05");
INSERT INTO replanishment VALUES("SK00079WH11","1","05");
INSERT INTO replanishment VALUES("SK00082PU08","2","05");
INSERT INTO replanishment VALUES("SK00082PU09","2","05");
INSERT INTO replanishment VALUES("SK00082PU10","2","05");
INSERT INTO replanishment VALUES("SK00082PU11","1","05");
INSERT INTO replanishment VALUES("SK00083LG08","2","05");
INSERT INTO replanishment VALUES("SK00083LG09","2","05");
INSERT INTO replanishment VALUES("SK00083LG10","2","05");
INSERT INTO replanishment VALUES("SK00083LG11","1","05");
INSERT INTO replanishment VALUES("SK00086GR08","2","05");
INSERT INTO replanishment VALUES("SK00086GR09","2","05");
INSERT INTO replanishment VALUES("SK00086GR10","2","05");
INSERT INTO replanishment VALUES("SK00086GR11","1","05");
INSERT INTO replanishment VALUES("SK00087OR08","2","05");
INSERT INTO replanishment VALUES("SK00087OR09","2","05");
INSERT INTO replanishment VALUES("SK00087OR10","2","05");
INSERT INTO replanishment VALUES("SK00087OR11","1","05");
INSERT INTO replanishment VALUES("SK00088PR08","2","05");
INSERT INTO replanishment VALUES("SK00088PR09","2","05");
INSERT INTO replanishment VALUES("SK00088PR10","2","05");
INSERT INTO replanishment VALUES("SK00088PR11","1","05");
INSERT INTO replanishment VALUES("SK00089WH08","2","05");
INSERT INTO replanishment VALUES("SK00089WH09","2","05");
INSERT INTO replanishment VALUES("SK00089WH10","2","05");
INSERT INTO replanishment VALUES("SK00089WH11","1","05");
INSERT INTO replanishment VALUES("SK00090BL08","2","05");
INSERT INTO replanishment VALUES("SK00090BL09","2","05");
INSERT INTO replanishment VALUES("SK00090BL10","2","05");
INSERT INTO replanishment VALUES("SK00090BL11","1","05");
INSERT INTO replanishment VALUES("SK00092OF08","2","05");
INSERT INTO replanishment VALUES("SK00092OF09","2","05");
INSERT INTO replanishment VALUES("SK00092OF10","2","05");
INSERT INTO replanishment VALUES("SK00092OF11","1","05");
INSERT INTO replanishment VALUES("SK00093WH08","2","05");
INSERT INTO replanishment VALUES("SK00093WH09","2","05");
INSERT INTO replanishment VALUES("SK00093WH10","2","05");
INSERT INTO replanishment VALUES("SK00093WH11","1","05");
INSERT INTO replanishment VALUES("SK00094BR08","2","05");
INSERT INTO replanishment VALUES("SK00094BR09","2","05");
INSERT INTO replanishment VALUES("SK00094BR10","2","05");
INSERT INTO replanishment VALUES("SK00094BR11","1","05");
INSERT INTO replanishment VALUES("SK00095WH08","2","05");
INSERT INTO replanishment VALUES("SK00095WH09","2","05");
INSERT INTO replanishment VALUES("SK00095WH10","2","05");
INSERT INTO replanishment VALUES("SK00095WH11","1","05");
INSERT INTO replanishment VALUES("SK00096WH08","2","05");
INSERT INTO replanishment VALUES("SK00096WH09","2","05");
INSERT INTO replanishment VALUES("SK00096WH10","2","05");
INSERT INTO replanishment VALUES("SK00096WH11","1","05");
INSERT INTO replanishment VALUES("SK00097RS08","2","05");
INSERT INTO replanishment VALUES("SK00097RS09","2","05");
INSERT INTO replanishment VALUES("SK00097RS10","2","05");
INSERT INTO replanishment VALUES("SK00097RS11","1","05");
INSERT INTO replanishment VALUES("SK00098DB08","2","05");
INSERT INTO replanishment VALUES("SK00098DB09","2","05");
INSERT INTO replanishment VALUES("SK00098DB10","2","05");
INSERT INTO replanishment VALUES("SK00098DB11","1","05");
INSERT INTO replanishment VALUES("SK00099OW08","2","05");
INSERT INTO replanishment VALUES("SK00099OW09","2","05");
INSERT INTO replanishment VALUES("SK00099OW10","2","05");
INSERT INTO replanishment VALUES("SK00099OW11","1","05");
INSERT INTO replanishment VALUES("SK00100GR08","2","05");
INSERT INTO replanishment VALUES("SK00100GR09","2","05");
INSERT INTO replanishment VALUES("SK00100GR10","2","05");
INSERT INTO replanishment VALUES("SK00100GR11","1","05");
INSERT INTO replanishment VALUES("SK00101LG08","2","05");
INSERT INTO replanishment VALUES("SK00101LG09","2","05");
INSERT INTO replanishment VALUES("SK00101LG10","2","05");
INSERT INTO replanishment VALUES("SK00101LG11","1","05");
INSERT INTO replanishment VALUES("SK00102SB08","2","05");
INSERT INTO replanishment VALUES("SK00102SB09","2","05");
INSERT INTO replanishment VALUES("SK00102SB10","2","05");
INSERT INTO replanishment VALUES("SK00102SB11","1","05");
INSERT INTO replanishment VALUES("SK00103FN08","2","05");
INSERT INTO replanishment VALUES("SK00103FN09","2","05");
INSERT INTO replanishment VALUES("SK00103FN10","2","05");
INSERT INTO replanishment VALUES("SK00103FN11","1","05");
INSERT INTO replanishment VALUES("SK00105CB08","2","05");
INSERT INTO replanishment VALUES("SK00105CB09","2","05");
INSERT INTO replanishment VALUES("SK00105CB10","2","05");
INSERT INTO replanishment VALUES("SK00105CB11","1","05");
INSERT INTO replanishment VALUES("SK00107NB08","2","05");
INSERT INTO replanishment VALUES("SK00107NB09","2","05");
INSERT INTO replanishment VALUES("SK00107NB10","2","05");
INSERT INTO replanishment VALUES("SK00107NB11","1","05");
INSERT INTO replanishment VALUES("SK00109WH08","2","05");
INSERT INTO replanishment VALUES("SK00109WH09","2","05");
INSERT INTO replanishment VALUES("SK00109WH10","2","05");
INSERT INTO replanishment VALUES("SK00109WH11","1","05");
INSERT INTO replanishment VALUES("SK00110GO08","2","05");
INSERT INTO replanishment VALUES("SK00110GO09","2","05");
INSERT INTO replanishment VALUES("SK00110GO10","2","05");
INSERT INTO replanishment VALUES("SK00110GO11","1","05");
INSERT INTO replanishment VALUES("SK00112PU08","2","05");
INSERT INTO replanishment VALUES("SK00112PU09","2","05");
INSERT INTO replanishment VALUES("SK00112PU10","2","05");
INSERT INTO replanishment VALUES("SK00112PU11","1","05");
INSERT INTO replanishment VALUES("SK00113GY08","2","05");
INSERT INTO replanishment VALUES("SK00113GY09","2","05");
INSERT INTO replanishment VALUES("SK00113GY10","2","05");
INSERT INTO replanishment VALUES("SK00113GY11","1","05");
INSERT INTO replanishment VALUES("SK00114BR08","2","05");
INSERT INTO replanishment VALUES("SK00114BR09","2","05");
INSERT INTO replanishment VALUES("SK00114BR10","2","05");
INSERT INTO replanishment VALUES("SK00114BR11","1","05");
INSERT INTO replanishment VALUES("SK00115BL08","2","05");
INSERT INTO replanishment VALUES("SK00115BL09","2","05");
INSERT INTO replanishment VALUES("SK00115BL10","2","05");
INSERT INTO replanishment VALUES("SK00115BL11","1","05");
INSERT INTO replanishment VALUES("SK00116GY08","2","05");
INSERT INTO replanishment VALUES("SK00116GY09","2","05");
INSERT INTO replanishment VALUES("SK00116GY10","2","05");
INSERT INTO replanishment VALUES("SK00116GY11","1","05");
INSERT INTO replanishment VALUES("SK00117BL08","2","05");
INSERT INTO replanishment VALUES("SK00117BL09","2","05");
INSERT INTO replanishment VALUES("SK00117BL10","2","05");
INSERT INTO replanishment VALUES("SK00117BL11","1","05");
INSERT INTO replanishment VALUES("SK00118BL08","2","05");
INSERT INTO replanishment VALUES("SK00118BL09","2","05");
INSERT INTO replanishment VALUES("SK00118BL10","2","05");
INSERT INTO replanishment VALUES("SK00118BL11","1","05");
INSERT INTO replanishment VALUES("SK00119BL08","2","05");
INSERT INTO replanishment VALUES("SK00119BL09","2","05");
INSERT INTO replanishment VALUES("SK00119BL10","2","05");
INSERT INTO replanishment VALUES("SK00119BL11","1","05");
INSERT INTO replanishment VALUES("SK00120MR08","2","05");
INSERT INTO replanishment VALUES("SK00120MR09","2","05");
INSERT INTO replanishment VALUES("SK00120MR10","2","05");
INSERT INTO replanishment VALUES("SK00120MR11","1","05");
INSERT INTO replanishment VALUES("SK00121BL08","2","05");
INSERT INTO replanishment VALUES("SK00121BL09","2","05");
INSERT INTO replanishment VALUES("SK00121BL10","2","05");
INSERT INTO replanishment VALUES("SK00121BL11","1","05");
INSERT INTO replanishment VALUES("SK00122WH08","0","05");
INSERT INTO replanishment VALUES("SK00122WH09","0","05");
INSERT INTO replanishment VALUES("SK00122WH10","0","05");
INSERT INTO replanishment VALUES("SK00122WH11","0","05");


DROP TABLE IF EXISTS report;

CREATE TABLE `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report VALUES("2010-11-25","2015-11-25");


DROP TABLE IF EXISTS report_brands;

CREATE TABLE `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report_brands VALUES("1301","1202","1103","1102","");


DROP TABLE IF EXISTS report_cat;

CREATE TABLE `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS report_comp;

CREATE TABLE `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report_comp VALUES("01");


DROP TABLE IF EXISTS report_cs;

CREATE TABLE `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS report_div;

CREATE TABLE `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS report_party;

CREATE TABLE `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO report_party VALUES("0063");


DROP TABLE IF EXISTS report_sp;

CREATE TABLE `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS reports;

CREATE TABLE `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS reports_all;

CREATE TABLE `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO reports_all VALUES("accountsummary","Account Summary","1","N");


DROP TABLE IF EXISTS season_cat;

CREATE TABLE `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO season_cat VALUES("010101","WINTER");
INSERT INTO season_cat VALUES("010102","SUMMER");


DROP TABLE IF EXISTS size;

CREATE TABLE `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO size VALUES("08","S");
INSERT INTO size VALUES("09","M");
INSERT INTO size VALUES("10","L");
INSERT INTO size VALUES("11","XL");


DROP TABLE IF EXISTS sl_am_con;

CREATE TABLE `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_am_condet;

CREATE TABLE `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_cont;

CREATE TABLE `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_contdet;

CREATE TABLE `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_contmaint;

CREATE TABLE `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_contpay;

CREATE TABLE `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc;

CREATE TABLE `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc_rtn;

CREATE TABLE `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc_rtndet;

CREATE TABLE `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dc_rtndet_ser;

CREATE TABLE `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dcdet;

CREATE TABLE `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dcdet_copy;

CREATE TABLE `sl_dcdet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_dcdet_ser;

CREATE TABLE `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_gp;

CREATE TABLE `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_gp` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_gpdet;

CREATE TABLE `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(11,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_gpdet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_invoice;

CREATE TABLE `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_invoice VALUES("070001","2017-07-15","2610000166","0.00","0.00","5051835.00","","","","","","","1","","","","","","01","","2017-07-15 12:56:14","","0001","","0.000","","","0.00","","","","01","17","","","","0","0","","","","","0");
INSERT INTO sl_invoice VALUES("706","2017-07-15","1200010002","0.00","0.00","66.00","","","","","","","2","","","","","","01","","2017-07-15 13:59:09","","0001","","0.000","","","0.00","","","","01","17","","","","0","0","","","","","66");


DROP TABLE IF EXISTS sl_invoice_rec;

CREATE TABLE `sl_invoice_rec` (
  `REC_ID` varchar(7) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_invoicedet;

CREATE TABLE `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_invoicedet VALUES("070001","1","0001","","30.000","8567.00000","257000.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","5","0008","","75.000","1130.00000","84750.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","4","0032","","95.000","1945.00000","184750.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","3","0028","","91.000","1300.00000","118300.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","2","0003","","23.000","51258.00000","1178930.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","7","0014","","60.000","9807.00000","588400.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","8","0015","","2.000","12200.00000","24400.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","9","0016","","18116.000","118.00000","2140405.00","","","","0","","","","0.00","","","","","01","17","0.000","0.00","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","10","0006","","157.000","365.60500","57399.99","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","11","0030","","16.000","2137.50000","34200.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","14","0046","","2.000","6800.00000","13600.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","13","0050","","80.000","4837.50000","387000.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("070001","12","0018","","5.000","8020.00000","40100.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("706","1","0012","","1.000","22.00000","22.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("706","2","0003","","1.000","22.00000","22.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");
INSERT INTO sl_invoicedet VALUES("706","6","0020","","1.000","22.00000","22.00","","","","0","","","","0.00","","","","","01","17","0.000","","0","0","0","","");


DROP TABLE IF EXISTS sl_invoicedet_bon;

CREATE TABLE `sl_invoicedet_bon` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_invoicedetapp;

CREATE TABLE `sl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_jv;

CREATE TABLE `sl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_jvdet;

CREATE TABLE `sl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_jvdet_inst;

CREATE TABLE `sl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_order;

CREATE TABLE `sl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `po_no` varchar(10) NOT NULL DEFAULT '',
  `po_date` date DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_orderdet;

CREATE TABLE `sl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_party_add;

CREATE TABLE `sl_party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_pay;

CREATE TABLE `sl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) DEFAULT '',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(10) DEFAULT '',
  `other_id_2` varchar(10) DEFAULT '',
  `other_id_3` varchar(10) DEFAULT '',
  `itax_id` varchar(10) DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_paydet;

CREATE TABLE `sl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_paydet_inst;

CREATE TABLE `sl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_payment;

CREATE TABLE `sl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) NOT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(100) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_paymentdet;

CREATE TABLE `sl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_po;

CREATE TABLE `sl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_podet;

CREATE TABLE `sl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `BONUS_QTY` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_product;

CREATE TABLE `sl_product` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `O_QTY` decimal(10,3) DEFAULT NULL,
  `O_RATE` decimal(10,2) DEFAULT NULL,
  `CAT_ID` varchar(6) NOT NULL,
  `TYPE_ID` varchar(10) NOT NULL,
  `BATCHWISE` varchar(1) NOT NULL,
  `REG_NO` varchar(10) DEFAULT NULL,
  `PACK_SIZE` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) NOT NULL,
  `P_RATE` decimal(10,2) DEFAULT NULL,
  `TYPE_GRP` varchar(1) NOT NULL,
  `PACK_RATE` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(10,3) NOT NULL,
  `ALL_CUST` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `GRP_ID` varchar(2) NOT NULL,
  `MOL_QTY` decimal(10,3) DEFAULT NULL,
  `MOL` varchar(1) DEFAULT NULL,
  `OLD_CODE` varchar(9) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PART_NO` varchar(30) DEFAULT NULL,
  `SAMPL_ID` varchar(4) DEFAULT NULL,
  `SAMPLE_ID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_product_brand;

CREATE TABLE `sl_product_brand` (
  `PROD_ID` varchar(4) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_product_rm;

CREATE TABLE `sl_product_rm` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(13,6) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `RM_ID` varchar(4) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO sl_product_rm VALUES("0356","0.000310","1","0027","01");


DROP TABLE IF EXISTS sl_products_log;

CREATE TABLE `sl_products_log` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `POST_DATE` datetime NOT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_quote;

CREATE TABLE `sl_quote` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(10,2) NOT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(5) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_quotedet;

CREATE TABLE `sl_quotedet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `UNIT_RATE` decimal(10,3) NOT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,0) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receipt;

CREATE TABLE `sl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receiptdet;

CREATE TABLE `sl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receiptdet_acct;

CREATE TABLE `sl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_receiptdet_inv;

CREATE TABLE `sl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_return;

CREATE TABLE `sl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_return VALUES("SL050001","2017-05-16","0026","0.00","0.00","4000.00","","","","","","","1774","","","","","","01","","2017-05-18 15:24:04","","0007","","0.000","","","0.00","","","","01","17","on","MUHAMMAD","03214420814","0","0","","","","","4000");
INSERT INTO sl_return VALUES("RT050001","2017-05-16","0026","0.00","0.00","2800.00","","","","","","","5575","","","","","","01","","2017-05-18 15:38:53","","0001","","0.000","","","0.00","","","","01","17","on","mr . 82k","","0","0","","","","","2800");
INSERT INTO sl_return VALUES("RT050002","2017-05-17","0026","0.00","0.00","4815.25","","","","","","","8835","","","","","","01","","2017-05-19 16:34:32","","0004","","0.000","","","0.00","","","","01","17","on","SARFRAZ SB","","0","0","","","","","4815");
INSERT INTO sl_return VALUES("RT050003","2017-05-22","0026","0.00","0.00","1300.00","","","","","","","8752","","","","","","01","","2017-05-27 17:31:31","","0002","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","1300");
INSERT INTO sl_return VALUES("RT050004","2017-05-22","0026","0.00","0.00","10125.00","","","","","","","8757","","","","","","01","","2017-05-27 17:45:37","","0002","","0.000","","","0.00","","","","01","17","on","TAHIR SB","","0","0","","","","","10125");
INSERT INTO sl_return VALUES("RT050005","2017-05-22","0026","0.00","0.00","4000.00","","","","","","","866","","","","","","01","","2017-05-29 10:03:37","","0001","","0.000","","","0.00","","","","01","17","on","262/L","","0","0","","","","","4000");
INSERT INTO sl_return VALUES("RT050006","2017-05-22","0026","0.00","0.00","3500.00","","","","","","","867","","","","","","01","","2017-05-29 10:08:14","","0006","","0.000","","","0.00","","","","01","17","on","AWAIS","","0","0","","","","","3500");
INSERT INTO sl_return VALUES("52","2017-05-24","0026","0.00","0.00","18500.00","","","","","","","8771","","","","","","01","","2017-05-29 11:57:20","","0002","","0.000","","","0.00","","","","01","17","","","","0","0","","","","","18500");
INSERT INTO sl_return VALUES("RT050007","2017-05-24","0026","0.00","0.00","8600.00","","","","","","","5457","","","","","","01","","2017-05-29 12:12:35","","0002","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","8600");
INSERT INTO sl_return VALUES("RT060001","2017-06-07","2610000001","0.00","0.00","18850.00","","","","","","","","","","","","","01","","2017-06-19 15:35:24","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","18850");
INSERT INTO sl_return VALUES("RT060002","2017-06-07","2610000001","2679.00","0.00","8221.00","","","","","","","3363","","","","","","01","","2017-06-30 12:35:25","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","8221");
INSERT INTO sl_return VALUES("RT060003","2017-06-10","2610000001","0.00","0.00","18000.00","","","","","","","3366","","","","","","01","","2017-06-19 15:32:56","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","18000");
INSERT INTO sl_return VALUES("RT060004","2017-06-12","2610000001","0.00","0.00","21000.00","","","","","","","1035","","","","","","01","","2017-06-19 15:17:09","","0001","","0.000","","","21000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060005","2017-06-12","2610000001","0.00","0.00","17500.00","","","","","","","1074","","","","","","01","","2017-06-19 15:17:32","","0001","","0.000","","","17500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060007","2017-06-13","2610000001","0.00","0.00","1800.00","","","","","","","3376","","","","","","01","","2017-07-01 12:51:19","","0001","","0.000","","","1800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060008","2017-06-13","2610000001","0.00","0.00","23000.00","","","","","","","1096","","","","","","01","","2017-06-19 15:16:14","","0001","","0.000","","","23000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060009","2017-06-13","2610000001","0.00","0.00","2100.00","","","","","","","1042","","","","","","01","","2017-06-19 15:16:35","","0001","","0.000","","","2100.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060010","2017-06-14","2610000001","0.00","0.00","14500.00","","","","","","","3357","","","","","","01","","2017-06-19 15:15:18","","0001","","0.000","","","3000.00","","","","02","17","on","","","0","0","","","","","11500");
INSERT INTO sl_return VALUES("RT060011","2017-06-19","2610000032","0.00","0.00","10000.00","","","","","","","1082","","","","","","01","","2017-06-20 14:37:46","","0001","","0.000","","","10000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060013","2017-06-20","2610000001","500.00","0.00","2000.00","","","","","","","1122","","","","","","01","","2017-06-30 12:11:25","","0003","","0.000","","","2000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060012","2017-06-20","2610000032","100.00","0.00","10000.00","","","","","","","1081","","","","","","01","","2017-06-20 12:37:37","","0001","","0.000","","","10000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060014","2017-06-20","2610000001","0.00","0.00","61950.00","","","","","","","1005","","","","","","01","","2017-07-14 17:00:30","","0001","","0.000","","","0.00","","","","02","17","","","","0","0","","","","","61950");
INSERT INTO sl_return VALUES("RT060015","2017-06-20","2610000045","0.00","0.00","11000.00","","","","","","","1088","","","","","","01","","2017-06-21 10:30:56","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","11000");
INSERT INTO sl_return VALUES("RT060016","2017-06-22","2610000001","0.00","50.00","5600.00","","","","","","","","","","","","","01","","2017-07-01 12:18:34","","0003","","0.000","","","5600.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT060017","2017-07-06","2610000049","0.00","0.00","40000.00","","","","","","","009","","","","","","01","","2017-07-07 12:09:57","","0001","","0.000","","","12500.00","","","","02","17","on","","","0","0","","","","","27500");
INSERT INTO sl_return VALUES("RT060018","2017-06-29","2610000045","0.00","0.00","6000.00","","","","","","","1079","","","","","","01","","2017-07-07 16:19:17","","0001","","0.000","","","800.00","","","","02","17","on","","","0","0","","","","","5200");
INSERT INTO sl_return VALUES("RT060019","2017-06-29","2610000035","0.00","0.00","16000.00","","","","","","","3378","","","","","","01","","2017-07-01 11:17:32","","0015","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","16000");
INSERT INTO sl_return VALUES("RT070001","2017-06-01","2610000001","0.00","0.00","2000.00","","","","","","","10442","","","","","","01","","2017-07-03 16:57:26","","0007","","0.000","","","2000.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070002","2017-06-02","2610000001","0.00","0.00","8000.00","","","","","","","10446","","","","","","01","","2017-07-03 18:05:23","","0006","","0.000","","","8000.00","","","","01","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070001","2017-07-06","2610000001","0.00","0.00","7800.00","","","","","","","1082","","","","","","01","","2017-07-07 12:12:24","","0003","","0.000","","","7800.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070002","2017-07-06","2610000001","0.00","0.00","11000.00","","","","","","","1560","","","","","","01","","2017-07-07 17:00:01","","0001","","0.000","","","0.00","","","","02","17","on","","","0","0","","","","","11000");
INSERT INTO sl_return VALUES("RT070003","2017-07-07","2610000001","0.00","0.00","5000.00","","","","","","","3372","","","","","","01","","2017-07-07 17:43:56","","0001","","0.000","","","5000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070004","2017-07-08","2610000001","50.00","0.00","6000.00","","","","","","","1184","","","","","","01","","2017-07-08 16:29:14","","0001","","0.000","","","6000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070005","2017-07-08","2610000066","0.00","0.00","43000.00","","","","","","","1176","","","","","","01","","2017-07-10 17:01:38","","0003","","0.000","","","30000.00","","","","02","17","on","","","0","0","","","","","13000");
INSERT INTO sl_return VALUES("RT070006","2017-07-11","2610000001","0.00","0.00","5000.00","","","","","","","1089","","","","","","01","","2017-07-12 11:28:18","","0001","","0.000","","","5000.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070003","2017-07-01","1310000001","0.00","0.00","4000.00","","","","","","","6764","","","","","","01","","2017-07-14 12:28:12","","0007","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","4000");
INSERT INTO sl_return VALUES("RT070007","2017-07-14","2610000030","0.00","0.00","154500.00","","","","","","","1139","","","","","","01","","2017-07-14 14:11:08","","0003","","0.000","","","154500.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070008","2017-07-14","2610000030","0.00","0.00","1950.00","","","","","","","1199","","","","","","01","","2017-07-15 10:52:11","","0003","","0.000","","","1950.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070009","2017-07-14","2610000030","150.00","0.00","1790.00","","","","","","","3367","","","","","","01","","2017-07-15 11:04:16","","0001","","0.000","","","1790.00","","","","02","17","on","","","0","0","","","","","0");
INSERT INTO sl_return VALUES("RT070004","2017-07-01","2610000001","0.00","0.00","42000.00","","","","","","","6758","","","","","","01","","2017-07-15 11:48:09","","0002","","0.000","","","0.00","","","","01","17","on","","","0","0","","","","","42000");


DROP TABLE IF EXISTS sl_returndet;

CREATE TABLE `sl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sl_returndet VALUES("SL050001","1","3931","BILL NO 5484","1.000","3100.00000","3100.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("SL050001","2","4165","","1.000","900.00000","900.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT050004","1","4219","","1.000","10125.00000","10125.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060001","1","4272","","1.000","18850.00000","18850.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT050002","1","4225","186","28.325","170.00000","4815.25","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050001","1","4104","BILL NO 5489","1.000","2800.00000","2800.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("52","3","3565","","1.000","3500.00000","3500.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("52","1","4004","","2.000","1500.00000","3000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050003","1","3987","","2.000","650.00000","1300.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050005","1","3697","GLASS ( BILL NO 866)","1.000","4000.00000","4000.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT050006","1","4013","BILL NO 868","2.000","1750.00000","3500.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("52","2","3698","","2.000","6000.00000","12000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT050007","1","4206","","1.000","8600.00000","8600.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060003","1","4279","BILL NO 3372","1.000","18000.00000","18000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","1","4303","BILL NO 1184","1.000","1060.00000","1060.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070002","1","3731","","1.000","8000.00000","8000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060002","2","3894","","1.000","3900.00000","3900.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060002","1","4277","","2.000","3500.00000","7000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070007","3","4349","","1.000","16500.00000","16500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","3","3976","","1.000","610.00000","610.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060018","2","3984","","1.000","2500.00000","2500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060005","1","4238","BILL NO 3384","1.000","17500.00000","17500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060018","1","4004","BILL NO 1143","1.000","3500.00000","3500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060004","1","3888","BILL NO 3379","3.000","7000.00000","21000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070002","1","3740","","1.000","11000.00000","11000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060017","1","4342","BILL NO 1136","1.000","40000.00000","40000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060016","2","4341","","1.000","2850.00000","2850.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060013","1","4285","BILL NO 1123","1.000","2500.00000","2500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060016","1","4243","BILL NO 1133","2.000","1350.00000","2700.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060015","1","4241","BILL NO 1126","1.000","11000.00000","11000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060012","3","4067","","1.000","1500.00000","1500.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060012","2","3953","","5.000","1200.00000","6000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060014","1","4330","BILL NO 1124","59.000","1050.00000","61950.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060012","1","3947","BILL NO 1121","4.000","650.00000","2600.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060007","1","4293","BILL NO 3386","1.000","1800.00000","1800.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060008","1","3493","BILL NO 3387","1.000","23000.00000","23000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070001","1","4339","","1.000","2000.00000","2000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT060009","1","4031","BILL NO 3388","7.000","300.00000","2100.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060019","2","4355","","1.000","4000.00000","4000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060010","1","4258","BILL NO 3389","1.000","14500.00000","14500.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060011","1","3745","BILL NO 1117","1.000","10000.00000","10000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT060019","1","4356","BILL NO 1142","2.000","6000.00000","12000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070001","1","3740","BILL NO 1182","1.000","7800.00000","7800.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070004","2","4304","","1.000","4380.00000","4380.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070003","1","4210","BILL NO","1.000","5000.00000","5000.00","","","","","","","","","","","","","02","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070005","1","4398","BILL NO 1190","1.000","43000.00000","43000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070007","2","4348","","2.000","29500.00000","59000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070007","1","4347","BILL NO 3396","2.000","39500.00000","79000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070006","1","4260","BILL NO 1196","1.000","5000.00000","5000.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070003","1","3490","","1.000","4000.00000","4000.00","","","","","","","","","","","","","01","17","0.000","","0","0");
INSERT INTO sl_returndet VALUES("RT070009","2","4034","","20.000","65.00000","1300.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070009","1","4035","","8.000","80.00000","640.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070008","1","3947","","3.000","650.00000","1950.00","","","","","","","","","","","","","02","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","3","3491","","1.000","7000.00000","7000.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","2","4201","","1.000","6500.00000","6500.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");
INSERT INTO sl_returndet VALUES("RT070004","1","3497","BILL NO 6758","1.000","28500.00000","28500.00","","","","","","","","","","","","","01","17","0.000","0.00","0","0");


DROP TABLE IF EXISTS sl_sa;

CREATE TABLE `sl_sa` (
  `SA_ID` varchar(5) NOT NULL,
  `SA_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_sadet;

CREATE TABLE `sl_sadet` (
  `SA_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `AMOUNT` decimal(10,0) NOT NULL,
  `SP_ID` varchar(4) NOT NULL,
  `DIV_ID` varchar(2) NOT NULL,
  `CITY_ID` varchar(2) NOT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sl_wo;

CREATE TABLE `sl_wo` (
  `WO_ID` varchar(5) NOT NULL,
  `WO_DATE` datetime NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `WO_NAME` varchar(50) DEFAULT NULL,
  `DIV_ID` varchar(2) DEFAULT NULL,
  `CITY_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`WO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sp;

CREATE TABLE `sp` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO sp VALUES("0001","Shahid Sheikh","","");
INSERT INTO sp VALUES("0010","Faisal Zia","","");
INSERT INTO sp VALUES("0009","Atif","","");
INSERT INTO sp VALUES("0008","IBRAR","","");
INSERT INTO sp VALUES("0007","WALEED","","");
INSERT INTO sp VALUES("0006","WAQAS","","");
INSERT INTO sp VALUES("0005","Yaseen","","");
INSERT INTO sp VALUES("0004","Salman","","");
INSERT INTO sp VALUES("0003","Rashid","","");
INSERT INTO sp VALUES("0002","Sarosh Ch","","");
INSERT INTO sp VALUES("0011","Hafiz Azeem","","");
INSERT INTO sp VALUES("0012","Bilawal","","");
INSERT INTO sp VALUES("0013","Mubashar","","");
INSERT INTO sp VALUES("0014","HASEEB","","");
INSERT INTO sp VALUES("0015","MURTAZA","","");
INSERT INTO sp VALUES("0016","BABAR","","");


DROP TABLE IF EXISTS sp_party;

CREATE TABLE `sp_party` (
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `lineitem` varchar(4) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`sp_id`,`party_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS stk_cat;

CREATE TABLE `stk_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS stk_collection;

CREATE TABLE `stk_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO stk_collection VALUES("010101","Men");
INSERT INTO stk_collection VALUES("010102","Gold");


DROP TABLE IF EXISTS stk_con;

CREATE TABLE `stk_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` bigint(10) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_con` (`voucher_id`,`bill_no`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS stk_condet;

CREATE TABLE `stk_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_condet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS system;

CREATE TABLE `system` (
  `comp_name` varchar(100) NOT NULL DEFAULT '',
  `cash_id` varchar(10) NOT NULL DEFAULT '',
  `bank_id` varchar(10) NOT NULL DEFAULT '',
  `creditor_id` varchar(10) DEFAULT '1601999',
  `stax_id` varchar(10) DEFAULT '2201001',
  `dc_id` varchar(10) DEFAULT '5302005',
  `disc_id` varchar(10) DEFAULT '5107001',
  `debtor_id` varchar(10) DEFAULT '4201999',
  `adv_id` varchar(10) DEFAULT '4201999',
  `db_id` varchar(10) DEFAULT '4201999',
  `ret_id` varchar(10) DEFAULT '4201999',
  `sec_id` varchar(10) DEFAULT '4201999',
  `stax_id_sl` varchar(10) DEFAULT '2201001',
  `dc_id_sl` varchar(10) DEFAULT '5302005',
  `disc_id_sl` varchar(10) DEFAULT '5107001',
  `adv_id_sl` varchar(10) DEFAULT '4201999',
  `db_id_sl` varchar(10) DEFAULT '4201999',
  `ret_id_sl` varchar(10) DEFAULT '4201999',
  `sec_id_sl` varchar(10) DEFAULT '4201999',
  `stock_id` varchar(10) DEFAULT '4201999',
  `turnover_id` varchar(10) DEFAULT '3010000001',
  `cogs_id` varchar(10) DEFAULT '3020000001',
  `sed_id` varchar(10) DEFAULT NULL,
  `sed_id_sl` varchar(10) DEFAULT NULL,
  `hide_taxes` char(1) DEFAULT NULL,
  `date_from` date DEFAULT '2009-07-01',
  `date_to` date DEFAULT '2010-06-30',
  `ait_id` varchar(10) DEFAULT NULL,
  `cdi_id` varchar(10) DEFAULT NULL,
  `date_close` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) DEFAULT 'support@clicksoft.org',
  `qty_decimal` int(11) DEFAULT '0',
  `fed_id` varchar(10) DEFAULT NULL,
  `fed_id_sl` varchar(10) DEFAULT NULL,
  `stock_transfer_id` varchar(10) DEFAULT NULL,
  `login_page` varchar(30) NOT NULL,
  PRIMARY KEY (`comp_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO system VALUES("Bath & Kitchen Group","370001","375000","120001","3011000001","5010000001","2210000004","261000","1001001","5010000001","1001001","1001001","3011000001","3020000010","3020000002","4201","3020000010","4201","4201","3100010001","3010000001","3020000001","3011000005","3011000005","","2011-07-01","2012-06-30","2530000002","4060000005","2000-12-31","accounts@rakcorporation.com,support@clicksoft.com.pk","3","3011000004","3011000004","2210000002","bk");


DROP TABLE IF EXISTS tf;

CREATE TABLE `tf` (
  `INV_ID` varchar(5) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `PACK_SIZE` varchar(30) DEFAULT NULL,
  `PACK_QTY` decimal(10,2) DEFAULT NULL,
  `UNIT_QTY` decimal(10,2) DEFAULT NULL,
  `STD_WT` decimal(15,5) DEFAULT NULL,
  `UNIT_WT` decimal(15,5) DEFAULT NULL,
  `BATCH_MONTH` varchar(10) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `INACTIVE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO tf VALUES("00140","","0001","","","","2015-12-28 00:00:00","1*1","1.00","222.00","0.00000","","","","");


DROP TABLE IF EXISTS tfdet;

CREATE TABLE `tfdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(15,5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `DONT_INCLUDE` varchar(1) NOT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `LL_P` decimal(6,3) DEFAULT NULL,
  `LL_QTY` decimal(15,5) DEFAULT NULL,
  `QTY` decimal(15,5) DEFAULT NULL,
  `REQ_QTY` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO tfdet VALUES("00141","1","","0","","","","","","","","","0.00000","");


DROP TABLE IF EXISTS trans;

CREATE TABLE `trans` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO trans VALUES("00001","2015-08-08 00:00:00","01","15","inam","01","N","");


DROP TABLE IF EXISTS transdet;

CREATE TABLE `transdet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `REMARKS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO transdet VALUES("00001","1","0394","332.000","","15D523","","01","15","02","","Nearest Exipry Date 30-09-15");


DROP TABLE IF EXISTS tt;

CREATE TABLE `tt` (
  `v_id` int(11) NOT NULL AUTO_INCREMENT,
  `v_date` date DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `comp_name` varchar(100) DEFAULT NULL,
  `debit_amount` int(15) DEFAULT NULL,
  `credit_amount` int(15) DEFAULT NULL,
  `ref_no` varchar(250) DEFAULT NULL,
  `acct_type` varchar(250) DEFAULT NULL,
  `remarks` text,
  `opening_balance` int(15) DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS type;

CREATE TABLE `type` (
  `type_id` varchar(6) NOT NULL DEFAULT '',
  `type_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO type VALUES("0002","KHUSSA");
INSERT INTO type VALUES("0003","SEMI FORMAL");
INSERT INTO type VALUES("0004","FORMAL");
INSERT INTO type VALUES("0005","CASUAL");


DROP TABLE IF EXISTS units;

CREATE TABLE `units` (
  `unit` char(3) NOT NULL DEFAULT '',
  `unit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO units VALUES("Bag","Bags");
INSERT INTO units VALUES("Bot","Bottle");
INSERT INTO units VALUES("Bun","Bundle");
INSERT INTO units VALUES("Coi","Coil");
INSERT INTO units VALUES("Dru","Drum");
INSERT INTO units VALUES("Dzn","Dzn");
INSERT INTO units VALUES("Ft","Ft");
INSERT INTO units VALUES("Gln","Gln");
INSERT INTO units VALUES("Grm","Grams");
INSERT INTO units VALUES("Kg","Kg");
INSERT INTO units VALUES("Ltr","Liter");
INSERT INTO units VALUES("Mtr","Mtr");
INSERT INTO units VALUES("Nos","Nos");
INSERT INTO units VALUES("Pai","Pairs");
INSERT INTO units VALUES("Pcs","Pices");
INSERT INTO units VALUES("Pkt","Pkt");
INSERT INTO units VALUES("Qtr","Qtr");
INSERT INTO units VALUES("Rft","Rft");
INSERT INTO units VALUES("Rim","Rim");
INSERT INTO units VALUES("Rol","Roll");
INSERT INTO units VALUES("Set","Set");
INSERT INTO units VALUES("Sqf","Sqft");
INSERT INTO units VALUES("Tin","Tin");
INSERT INTO units VALUES("Tro","Trolly");
INSERT INTO units VALUES("Tru","Truck");
INSERT INTO units VALUES("MT","M.Tons");
INSERT INTO units VALUES("100","baggage");
INSERT INTO units VALUES("Guz","GUZZ");


DROP TABLE IF EXISTS user_mod;

CREATE TABLE `user_mod` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_CP',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS user_profile;

CREATE TABLE `user_profile` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `user_name` varchar(50) DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '123',
  `desig_id` varchar(30) DEFAULT '',
  `div_name` varchar(30) DEFAULT '',
  `sec_lvl` char(1) DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO user_profile VALUES("HEAD OFFICE","HEAD OFFICE","123","","","0");
INSERT INTO user_profile VALUES("02-admin","EQUATOR","123","","","0");
INSERT INTO user_profile VALUES("03-admin","Wapda Town","123","","","0");
INSERT INTO user_profile VALUES("04-admin","Studio Mir - Gujranwala","123","","","0");
INSERT INTO user_profile VALUES("05-admin","Dreams - M.M.Alam","123","","","0");


DROP TABLE IF EXISTS user_rep;

CREATE TABLE `user_rep` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_10',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `EMP_ID` varchar(20) NOT NULL,
  `EMP_NAME` varchar(40) NOT NULL,
  `PASSWORD` varchar(20) DEFAULT NULL,
  `AUTH_ID` varchar(1) NOT NULL,
  `USE_FORM` varchar(1) DEFAULT NULL,
  `USE_REP` varchar(1) DEFAULT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `PK_BILL_NO_FROM` varchar(4) DEFAULT NULL,
  `PK_BILL_NO_TO` varchar(4) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `VOUCHER_TYPE` varchar(2) DEFAULT NULL,
  `POST` varchar(1) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `u_session_id` decimal(65,30) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users VALUES("atif","Atif","123","1","","","","","","","","","","","","","","","","");
INSERT INTO users VALUES("bt","BT","123","1","Y","Y","N","01","04","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","","","","N","0007","0.000000000000000000000000000000");
INSERT INTO users VALUES("click","ClickSoft (Pvt) Ltd","m.","9","","","","","","","","","","","","","","","","");
INSERT INTO users VALUES("it","IT","123","1","Y","Y","N","01","04","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","","","","N","0007","0.000000000000000000000000000000");
INSERT INTO users VALUES("kt","Kafeel Trader","123","1","Y","Y","N","01","04","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","","","","N","0007","0.000000000000000000000000000000");


DROP TABLE IF EXISTS users_comp;

CREATE TABLE `users_comp` (
  `EMP_ID` varchar(20) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`,`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users_comp VALUES("atif","01","");
INSERT INTO users_comp VALUES("click","01","");
INSERT INTO users_comp VALUES("click","02","");


DROP TABLE IF EXISTS users_menu;

CREATE TABLE `users_menu` (
  `emp_id` varchar(20) NOT NULL DEFAULT '',
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `inactive` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`emp_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS users_mod;

CREATE TABLE `users_mod` (
  `EMP_ID` varchar(6) NOT NULL,
  `VOUCHER_TYPE` varchar(20) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users_mod VALUES("Abid","PL_INVOICE");


DROP TABLE IF EXISTS users_rep;

CREATE TABLE `users_rep` (
  `EMP_ID` varchar(6) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`REP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO users_rep VALUES("abid","068");


DROP TABLE IF EXISTS v_p_vouchers;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_p_vouchers` AS select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,concat(`p`.`acct_name`,' / ',`l`.`loc_name`) AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('RT',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_return` `m` left join `sl_returndet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SD',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,NULL AS `lineitem`,NULL AS `stock_code`,'Discount' AS `stock_name`,NULL AS `rate`,0 AS `db_qty`,0 AS `db_amt`,NULL AS `cr_qty`,`m`.`disc_amt` AS `cr_amt` from (`sl_invoice` `m` left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) where (`m`.`disc_amt` <> 0) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`)));

INSERT INTO v_p_vouchers VALUES("01","17","PL070001","2017-07-15","2610000154","NIMIR INDUSTRIES - 654 / Main Store","1","0011","STERIC BAG","3525.00000","400.000","1410000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","1","0001","BAROZA TIN","8567.00000","0.000","0.00","30.000","257000.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","10","0006","OIL TARPIN LIT","365.60500","0.000","0.00","157.000","57399.99");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","11","0030","SODA ASH BAG","2137.50000","0.000","0.00","16.000","34200.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","12","0018","MOOAM TAIWAN CAR","8020.00000","0.000","0.00","5.000","40100.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","13","0050","MOOAM CHAINA CAR","4837.50000","0.000","0.00","80.000","387000.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","14","0046","MALEIC NOS","6800.00000","0.000","0.00","2.000","13600.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","2","0003","BAROZA INDONESIA DRU","51258.00000","0.000","0.00","23.000","1178930.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","3","0028","CARNOBA WAX KG","1300.00000","0.000","0.00","91.000","118300.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","4","0032","CAUSTIC PATRI BAG","1945.00000","0.000","0.00","95.000","184750.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","5","0008","CHOONA BAG","1130.00000","0.000","0.00","75.000","84750.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","7","0014","MOOAM CHAINA BAG","9807.00000","0.000","0.00","60.000","588400.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","8","0015","MOOAM HUNGRY CAR","12200.00000","0.000","0.00","2.000","24400.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL070001","2017-07-15","2610000166","CASH SALES","9","0016","MOOAM IRANI KG","118.00000","0.000","0.00","18116.000","2140405.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL706","2017-07-15","1200010002","MOHAMMAD SHABBIR MALIK","1","0012","GLYCRINE DRU","22.00000","0.000","0.00","1.000","22.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL706","2017-07-15","1200010002","MOHAMMAD SHABBIR MALIK","2","0003","BAROZA INDONESIA DRU","22.00000","0.000","0.00","1.000","22.00");
INSERT INTO v_p_vouchers VALUES("01","17","SL706","2017-07-15","1200010002","MOHAMMAD SHABBIR MALIK","6","0020","CARTON STERIC T.P KG","22.00000","0.000","0.00","1.000","22.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTSL050001","2017-05-16","0026","","1","3931","","3100.00000","1.000","3100.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTSL050001","2017-05-16","0026","","2","4165","","900.00000","1.000","900.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050001","2017-05-16","0026","","1","4104","","2800.00000","1.000","2800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050002","2017-05-17","0026","","1","4225","","170.00000","28.325","4815.25","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050003","2017-05-22","0026","","1","3987","","650.00000","2.000","1300.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050004","2017-05-22","0026","","1","4219","","10125.00000","1.000","10125.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050005","2017-05-22","0026","","1","3697","","4000.00000","1.000","4000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050006","2017-05-22","0026","","1","4013","","1750.00000","2.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RT52","2017-05-24","0026","","1","4004","","1500.00000","2.000","3000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RT52","2017-05-24","0026","","2","3698","","6000.00000","2.000","12000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RT52","2017-05-24","0026","","3","3565","","3500.00000","1.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT050007","2017-05-24","0026","","1","4206","","8600.00000","1.000","8600.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060001","2017-06-07","2610000001","NOOR TRADERS","1","4272","","18850.00000","1.000","18850.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060002","2017-06-07","2610000001","NOOR TRADERS","1","4277","","3500.00000","2.000","7000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060002","2017-06-07","2610000001","NOOR TRADERS","2","3894","","3900.00000","1.000","3900.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060003","2017-06-10","2610000001","NOOR TRADERS","1","4279","","18000.00000","1.000","18000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060004","2017-06-12","2610000001","NOOR TRADERS","1","3888","","7000.00000","3.000","21000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060005","2017-06-12","2610000001","NOOR TRADERS","1","4238","","17500.00000","1.000","17500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060007","2017-06-13","2610000001","NOOR TRADERS","1","4293","","1800.00000","1.000","1800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060008","2017-06-13","2610000001","NOOR TRADERS","1","3493","","23000.00000","1.000","23000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060009","2017-06-13","2610000001","NOOR TRADERS","1","4031","","300.00000","7.000","2100.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060010","2017-06-14","2610000001","NOOR TRADERS","1","4258","","14500.00000","1.000","14500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060011","2017-06-19","2610000032","AL REHMAN TRADERS - 116","1","3745","","10000.00000","1.000","10000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060013","2017-06-20","2610000001","NOOR TRADERS","1","4285","","2500.00000","1.000","2500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060012","2017-06-20","2610000032","AL REHMAN TRADERS - 116","1","3947","","650.00000","4.000","2600.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060012","2017-06-20","2610000032","AL REHMAN TRADERS - 116","2","3953","","1200.00000","5.000","6000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060012","2017-06-20","2610000032","AL REHMAN TRADERS - 116","3","4067","","1500.00000","1.000","1500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060014","2017-06-20","2610000001","NOOR TRADERS","1","4330","","1050.00000","59.000","61950.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060015","2017-06-20","2610000045","POLI MAR INDUSTRIES - 685","1","4241","","11000.00000","1.000","11000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060016","2017-06-22","2610000001","NOOR TRADERS","1","4243","","1350.00000","2.000","2700.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060016","2017-06-22","2610000001","NOOR TRADERS","2","4341","","2850.00000","1.000","2850.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060017","2017-07-06","2610000049","HAJI AND COMPANY KISSAN STREET - 887","1","4342","","40000.00000","1.000","40000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060018","2017-06-29","2610000045","POLI MAR INDUSTRIES - 685","1","4004","","3500.00000","1.000","3500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060018","2017-06-29","2610000045","POLI MAR INDUSTRIES - 685","2","3984","","2500.00000","1.000","2500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060019","2017-06-29","2610000035","PAKISTAN VARNISH","1","4356","","6000.00000","2.000","12000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT060019","2017-06-29","2610000035","PAKISTAN VARNISH","2","4355","","4000.00000","1.000","4000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070001","2017-06-01","2610000001","NOOR TRADERS","1","4339","","2000.00000","1.000","2000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070002","2017-06-02","2610000001","NOOR TRADERS","1","3731","","8000.00000","1.000","8000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070001","2017-07-06","2610000001","NOOR TRADERS","1","3740","","7800.00000","1.000","7800.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070002","2017-07-06","2610000001","NOOR TRADERS","1","3740","","11000.00000","1.000","11000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070003","2017-07-07","2610000001","NOOR TRADERS","1","4210","","5000.00000","1.000","5000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070004","2017-07-08","2610000001","NOOR TRADERS","1","4303","","1060.00000","1.000","1060.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070004","2017-07-08","2610000001","NOOR TRADERS","2","4304","","4380.00000","1.000","4380.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070004","2017-07-08","2610000001","NOOR TRADERS","3","3976","","610.00000","1.000","610.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070005","2017-07-08","2610000066","SHAHALAM CHEMICAL STORE- 173","1","4398","","43000.00000","1.000","43000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070006","2017-07-11","2610000001","NOOR TRADERS","1","4260","","5000.00000","1.000","5000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070003","2017-07-01","1310000001","","1","3490","","4000.00000","1.000","4000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070007","2017-07-14","2610000030","HAJI ASGHAR - 96","1","4347","","39500.00000","2.000","79000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070007","2017-07-14","2610000030","HAJI ASGHAR - 96","2","4348","","29500.00000","2.000","59000.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070007","2017-07-14","2610000030","HAJI ASGHAR - 96","3","4349","","16500.00000","1.000","16500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070008","2017-07-14","2610000030","HAJI ASGHAR - 96","1","3947","","650.00000","3.000","1950.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070009","2017-07-14","2610000030","HAJI ASGHAR - 96","1","4035","","80.00000","8.000","640.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("02","17","RTRT070009","2017-07-14","2610000030","HAJI ASGHAR - 96","2","4034","","65.00000","20.000","1300.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070004","2017-07-01","2610000001","NOOR TRADERS","1","3497","","28500.00000","1.000","28500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070004","2017-07-01","2610000001","NOOR TRADERS","2","4201","","6500.00000","1.000","6500.00","0.000","0.00");
INSERT INTO v_p_vouchers VALUES("01","17","RTRT070004","2017-07-01","2610000001","NOOR TRADERS","3","3491","","7000.00000","1.000","7000.00","0.000","0.00");


DROP TABLE IF EXISTS v_party;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,if((convert(substr(1,6) using latin1) = `s`.`creditor_id`),'S','C') AS `party_type` from (`nom` `n` join `system` `s`) where ((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`,'361000')) and (length(`n`.`ACCT_ID`) = 10));

INSERT INTO v_party VALUES("1200010002","MOHAMMAD SHABBIR MALIK","C");
INSERT INTO v_party VALUES("2610000001","NOOR TRADERS","C");
INSERT INTO v_party VALUES("2610000002","AKBAR BROTHERS - 80","C");
INSERT INTO v_party VALUES("2610000003","M T STOCK EXCHANGE - 570","C");
INSERT INTO v_party VALUES("2610000004","AHMAD TARIQ","C");
INSERT INTO v_party VALUES("2610000005","KHALI DRUM KHATA","C");
INSERT INTO v_party VALUES("2610000006","SUN TRADRES - 734","C");
INSERT INTO v_party VALUES("2610000007","SALE TAX KHATA","C");
INSERT INTO v_party VALUES("2610000008","SETH KHALID","C");
INSERT INTO v_party VALUES("2610000009","SHAN TRADERS","C");
INSERT INTO v_party VALUES("2610000010","FAISAL GENERAL STORE - 286","C");
INSERT INTO v_party VALUES("2610000011","KARIM KHAN PINDI - 470","C");
INSERT INTO v_party VALUES("2610000012","NAFA NUKSAN KHATA","C");
INSERT INTO v_party VALUES("2610000013","HAJI MUHAMMAD RAFI SAB","C");
INSERT INTO v_party VALUES("2610000014","MUHAMMAD FARHAT SAB MOAM WALAY","C");
INSERT INTO v_party VALUES("2610000015","MODERN OIL TRADERS - 584","C");
INSERT INTO v_party VALUES("2610000016","MAHAM TRADERS - 61","C");
INSERT INTO v_party VALUES("2610000017","H S NOOR UD DIN TEXTILE MILL - 424","C");
INSERT INTO v_party VALUES("2610000018","ABC TRADERS","C");
INSERT INTO v_party VALUES("2610000019","FK PVC PIPE","C");
INSERT INTO v_party VALUES("2610000021","AYAZ RAHIM GULL","C");
INSERT INTO v_party VALUES("2610000022","ASHRAF UD DIN","C");
INSERT INTO v_party VALUES("2610000023","ASIA PAINT","C");
INSERT INTO v_party VALUES("2610000024","AMNA BELTING - 124","C");
INSERT INTO v_party VALUES("2610000027","ASIF TRADERS - 16","C");
INSERT INTO v_party VALUES("2610000028","AL QAZI ENTERPRIZES","C");
INSERT INTO v_party VALUES("2610000029","AKAMAL SHAHZAD - 901","C");
INSERT INTO v_party VALUES("2610000030","HAJI ASGHAR - 96","C");
INSERT INTO v_party VALUES("2610000031","ALLIED INDUSTRIES - 37","C");
INSERT INTO v_party VALUES("2610000032","AL REHMAN TRADERS - 116","C");
INSERT INTO v_party VALUES("2610000033","RAJA BASHIR","C");
INSERT INTO v_party VALUES("2610000034","HAJII BASHIR - 230","C");
INSERT INTO v_party VALUES("2610000035","PAKISTAN VARNISH","C");
INSERT INTO v_party VALUES("2610000036","PARVEZ","C");
INSERT INTO v_party VALUES("2610000037","PARVEZ IQBAL","C");
INSERT INTO v_party VALUES("2610000038","HAQ CHEMICAL","C");
INSERT INTO v_party VALUES("2610000039","KHALID GUL AUTOS 435","C");
INSERT INTO v_party VALUES("2610000040","KHADAM HUSSAIN - 460","C");
INSERT INTO v_party VALUES("2610000041","DAWOOD YAMAHA - 223","C");
INSERT INTO v_party VALUES("2610000042","B TOWNS","C");
INSERT INTO v_party VALUES("2610000043","PAJI ALLOUDIN","C");
INSERT INTO v_party VALUES("2610000044","PAK CANDLE WORKS - 668","C");
INSERT INTO v_party VALUES("2610000045","POLI MAR INDUSTRIES - 685","C");
INSERT INTO v_party VALUES("2610000046","PETRO WORKS INTERNATIONAL","C");
INSERT INTO v_party VALUES("2610000047","BABA TAJ DIN","C");
INSERT INTO v_party VALUES("2610000049","HAJI AND COMPANY KISSAN STREET - 887","C");
INSERT INTO v_party VALUES("2610000050","DECENT PAINT - 218","C");
INSERT INTO v_party VALUES("2610000051","W S TRADRES","C");
INSERT INTO v_party VALUES("2610000053","RAFAQAT MULAZIM","C");
INSERT INTO v_party VALUES("2610000054","RAZAQ LAKH WALA -57","C");
INSERT INTO v_party VALUES("2610000055","RASHID ALI - 722","C");
INSERT INTO v_party VALUES("2610000056","RAHIM CHEMICAL - 53","C");
INSERT INTO v_party VALUES("2610000057","SUNNY PAINT","C");
INSERT INTO v_party VALUES("2610000058","HAJI SIRAJDIN POLISH WALAY - 775","C");
INSERT INTO v_party VALUES("2610000059","CAMY TEX","C");
INSERT INTO v_party VALUES("2610000060","SEIKO RUBBER INDUSTRIES - 768","C");
INSERT INTO v_party VALUES("2610000061","SULAIMAN G - 815","C");
INSERT INTO v_party VALUES("2610000062","SULTAN BASHIR - 740","C");
INSERT INTO v_party VALUES("2610000063","SARWER RUBBER INDUSTRIES 751","C");
INSERT INTO v_party VALUES("2610000064","SIGMA CHEMICAL - 756","C");
INSERT INTO v_party VALUES("2610000065","SHERAZ AHSAN CHEMICAL -761","C");
INSERT INTO v_party VALUES("2610000066","SHAHALAM CHEMICAL STORE- 173","C");
INSERT INTO v_party VALUES("2610000067","SHAHZAD ASLAM - 143","C");
INSERT INTO v_party VALUES("2610000068","ZIA TRADERS","C");
INSERT INTO v_party VALUES("2610000069","TAHIR DYING","C");
INSERT INTO v_party VALUES("2610000070","TAYAB MOM BATI WALAY - 360","C");
INSERT INTO v_party VALUES("2610000071","MUHAMMAD TARIQ","C");
INSERT INTO v_party VALUES("2610000072","MIAN ZAFAR AND CO.24","C");
INSERT INTO v_party VALUES("2610000073","IMRAN","C");
INSERT INTO v_party VALUES("2610000074","ABID PAINT GUJRANWALA - 48","C");
INSERT INTO v_party VALUES("2610000075","ASIM ENTERPRISES - 132","C");
INSERT INTO v_party VALUES("2610000076","ABBASI CHEMICAL STORE - 11","C");
INSERT INTO v_party VALUES("2610000077","ABDUL HAQ - 88","C");
INSERT INTO v_party VALUES("2610000079","ALI HASSAN - 218","C");
INSERT INTO v_party VALUES("2610000080","ARIF FOOTBAL MATERIAL STORE - 964","C");
INSERT INTO v_party VALUES("2610000081","ALI PRINTING - 90","C");
INSERT INTO v_party VALUES("2610000082","GHULAM ALI & SONS","C");
INSERT INTO v_party VALUES("2610000083","FAROOQ CANDLE - 356","C");
INSERT INTO v_party VALUES("2610000084","QADIRI PAINT","C");
INSERT INTO v_party VALUES("2610000085","KARIM DAD KHAN","C");
INSERT INTO v_party VALUES("2610000087","GULSHAN SOAP FACTORY - 266","C");
INSERT INTO v_party VALUES("2610000089","CH LATIF","C");
INSERT INTO v_party VALUES("2610000090","LAL BUTT","C");
INSERT INTO v_party VALUES("2610000091","MASTER LATIF - 531","C");
INSERT INTO v_party VALUES("2610000093","M R TRADING - 595","C");
INSERT INTO v_party VALUES("2610000094","MALIK BROTHERS AIK MORIA PUL- 682","C");
INSERT INTO v_party VALUES("2610000095","MAHBOOB SHAH","C");
INSERT INTO v_party VALUES("2610000096","MODERN PAINT","C");
INSERT INTO v_party VALUES("2610000097","MONAY SHAH","C");
INSERT INTO v_party VALUES("2610000098","MICO PAINT","C");
INSERT INTO v_party VALUES("2610000099","MUHAMMAD SALEEM - 169","C");
INSERT INTO v_party VALUES("2610000100","MALIK WARNISH - 570","C");
INSERT INTO v_party VALUES("2610000101","MUHAMMAD HAMID MAHMOOD - 358","C");
INSERT INTO v_party VALUES("2610000102","MUHAMMAD JAMIL - 434","C");
INSERT INTO v_party VALUES("2610000103",".","C");
INSERT INTO v_party VALUES("2610000104","MALIK BASHIR AHMAD","C");
INSERT INTO v_party VALUES("2610000107","MUBASHAR LALLA MUSSA - 578","C");
INSERT INTO v_party VALUES("2610000108","MUHAMMAD ASHFAQ - 414","C");
INSERT INTO v_party VALUES("2610000109","MUNAWAR ALI","C");
INSERT INTO v_party VALUES("2610000110","MUHAMMAD FAROOQ","C");
INSERT INTO v_party VALUES("2610000111","MARSHAL PAINT - 579","C");
INSERT INTO v_party VALUES("2610000112","MUHAMMAD FARHAJ GUJRANWALA - 296","C");
INSERT INTO v_party VALUES("2610000113","MUHAMMAD NAEEM","C");
INSERT INTO v_party VALUES("2610000115","SYED NAJEEB HUSSAIN","C");
INSERT INTO v_party VALUES("2610000117","HAJI NAWAB DIN POLISH WALAY","C");
INSERT INTO v_party VALUES("2610000118","NEELAM PAPER MILL - 769","C");
INSERT INTO v_party VALUES("2610000119","MUHAMMAD NAWAZ BROKER LAHORE","C");
INSERT INTO v_party VALUES("2610000120","WAX INTERNATIONAL - 113","C");
INSERT INTO v_party VALUES("2610000121","WAQAS PAINT - 260","C");
INSERT INTO v_party VALUES("2610000122","HIMALIYA CHEMICAL - 549","C");
INSERT INTO v_party VALUES("2610000123","HAMMAYU CHEMICAL - 368","C");
INSERT INTO v_party VALUES("2610000124","SHEIKH YUNIS 497","C");
INSERT INTO v_party VALUES("2610000126","ANWAR TRADERS","C");
INSERT INTO v_party VALUES("2610000127","ABRAR CHEMICAL - 74","C");
INSERT INTO v_party VALUES("2610000128","AKRAM CHEMICAL SHAH ALAM - 40","C");
INSERT INTO v_party VALUES("2610000129","AHMAD ANWAR - 902","C");
INSERT INTO v_party VALUES("2610000130","TAJ PAPER MILL","C");
INSERT INTO v_party VALUES("2610000131","MUHAMMAD AMIN GUJRANWALA - 68","C");
INSERT INTO v_party VALUES("2610000132","MUHAMMAD KHALID - 917","C");
INSERT INTO v_party VALUES("2610000134","SUSPENSE A/C","C");
INSERT INTO v_party VALUES("2610000135","HABIB CHEMICAL - 487","C");
INSERT INTO v_party VALUES("2610000136","NISAR AHMED - 236","C");
INSERT INTO v_party VALUES("2610000137","ASIF CHEMICAL - 106","C");
INSERT INTO v_party VALUES("2610000138","MUHAMMAD AKBAR","C");
INSERT INTO v_party VALUES("2610000139","IRSHAD PAINT PINDI - 412","C");
INSERT INTO v_party VALUES("2610000140","FIVE STAR","C");
INSERT INTO v_party VALUES("2610000141","AQSA CHEMICAL -84","C");
INSERT INTO v_party VALUES("2610000142","PUNJAB LAKH","C");
INSERT INTO v_party VALUES("2610000143","ALI ENTERPRISES","C");
INSERT INTO v_party VALUES("2610000144","POWER BELTING - 714","C");
INSERT INTO v_party VALUES("2610000145","SHAMA CHEMICAL - 769","C");
INSERT INTO v_party VALUES("2610000148","HAMDARD CHEMICAL - 362","C");
INSERT INTO v_party VALUES("2610000149","ALFA TRADERS - 58","C");
INSERT INTO v_party VALUES("2610000150","RIZWAN TRADERS - 723","C");
INSERT INTO v_party VALUES("2610000151","GOLDEN DYING - 492","C");
INSERT INTO v_party VALUES("2610000152","QAZI & COMPANY","C");
INSERT INTO v_party VALUES("2610000154","NIMIR INDUSTRIES - 654","C");
INSERT INTO v_party VALUES("2610000155","MUHAMMAD YOUSUF KHATAK - 202","C");
INSERT INTO v_party VALUES("2610000156","SHEIKH IBRAHIM & SONS - 433","C");
INSERT INTO v_party VALUES("2610000157","WAQAR YOUNIS - 805","C");
INSERT INTO v_party VALUES("2610000158","MAQSODA MALIK 604","C");
INSERT INTO v_party VALUES("2610000159","MUHAMMAD IFTIKHAR KARACHI - 427","C");
INSERT INTO v_party VALUES("2610000160","BETA DYES - 220","C");
INSERT INTO v_party VALUES("2610000161","MUHAMMAD ARSHAD  MULTAN ROAD - 468","C");
INSERT INTO v_party VALUES("2610000164","AHMED TARIQ - 151","C");
INSERT INTO v_party VALUES("2610000165","IBRAHIM WALI MUHAMMAD - 395","C");
INSERT INTO v_party VALUES("2610000166","CASH SALES","C");
INSERT INTO v_party VALUES("2610000167","IMPEX RASIN","C");
INSERT INTO v_party VALUES("2610000169","JAHANGIR CHEMICAL - 512","C");
INSERT INTO v_party VALUES("2610000172"," CAPRING DYING LAHORE - 246","C");
INSERT INTO v_party VALUES("2610000173","HASSAN BOARD INDUSTRIES - 415","C");
INSERT INTO v_party VALUES("2610000174","NAZER CHEMICAL","C");
INSERT INTO v_party VALUES("2610000176","194 TIN BROZA","C");
INSERT INTO v_party VALUES("2610000177","155 TORA BROZA","C");
INSERT INTO v_party VALUES("2610000178","39 BAG CHOONA","C");
INSERT INTO v_party VALUES("2610000179","52 DRUM INDONESIA","C");
INSERT INTO v_party VALUES("2610000180","MOAM IRANI KG","C");
INSERT INTO v_party VALUES("2610000181","CARTON MOAM HUNGRY","C");
INSERT INTO v_party VALUES("2610000182","OIL TARPIN","C");
INSERT INTO v_party VALUES("2610000183","TORA MOAM PAKISTANI","C");
INSERT INTO v_party VALUES("2610000184","BAG MOAM CHINA","C");
INSERT INTO v_party VALUES("2610000185","DRUM IRANI MOAM","C");
INSERT INTO v_party VALUES("2610000186","STERIC BAG","C");
INSERT INTO v_party VALUES("2610000187","T P BAG","C");
INSERT INTO v_party VALUES("2610000188","DRUM CHINA BROZA","C");
INSERT INTO v_party VALUES("2610000189","DRUM VIETNAM  BROZA","C");
INSERT INTO v_party VALUES("2610000193","RIAZ CHEMICAL","C");
INSERT INTO v_party VALUES("2610000194","MAGGON CHEMICAL - 558","C");
INSERT INTO v_party VALUES("2610000196","ABDUL WAHID ABDUL MAJID - 122","C");
INSERT INTO v_party VALUES("2610000197","KHAWAJA MUBARAK - 574","C");
INSERT INTO v_party VALUES("2610000198","TYPHOON","C");
INSERT INTO v_party VALUES("2610000199","CASH PURCHASE","C");
INSERT INTO v_party VALUES("2610000200","CASH RECEIVEABLE A/C","C");
INSERT INTO v_party VALUES("2610000202","JAVED PAINTS","C");
INSERT INTO v_party VALUES("2610000203","KASHIF CHEMICAL - 474","C");
INSERT INTO v_party VALUES("2610000204","MILLIAT CHEMICAL","C");
INSERT INTO v_party VALUES("2610000205","LALA QURBAN","C");
INSERT INTO v_party VALUES("2610000206","MUHAMMAD MALOOK BROKER - 555","C");
INSERT INTO v_party VALUES("2610000208","COMMERCIAL CHEMICAL - 250","C");
INSERT INTO v_party VALUES("2610000209","B.S.VERIFY","C");
INSERT INTO v_party VALUES("2610000210","WAZIR GUL","C");
INSERT INTO v_party VALUES("2610000211","AL-NOOR CHEMICAL KISAN STREET - 44","C");
INSERT INTO v_party VALUES("2610000212","ROYAL RASIN 54","C");
INSERT INTO v_party VALUES("2610000214","SHAFI & SONS - 462","C");
INSERT INTO v_party VALUES("2610000216","INTERNATIONAL PETRO CHEMICAL 268","C");
INSERT INTO v_party VALUES("2610000217","TORA BROZA","C");
INSERT INTO v_party VALUES("2610000218","KHAN & COMPANY QUETTA","C");
INSERT INTO v_party VALUES("2610000219","TAHIR KAMAL IA BROTHERS","C");
INSERT INTO v_party VALUES("2610000222","NADEEM ASHFAQ","C");
INSERT INTO v_party VALUES("2610000224","SARDAR SONS","C");
INSERT INTO v_party VALUES("2610000225","IQBAL AUTO MULTAN - 408","C");
INSERT INTO v_party VALUES("2610000226","A B C CHEMICALS","C");
INSERT INTO v_party VALUES("2610000227","INAM & COMPANY - 320","C");
INSERT INTO v_party VALUES("2610000228","INDUS PLASTIC SHAHALAM","C");
INSERT INTO v_party VALUES("2610000229","AZHAR CHEMICAL","C");
INSERT INTO v_party VALUES("2610000230"," NADEEM JAHANGIR CHEMICAL","C");
INSERT INTO v_party VALUES("2610000231","HAIDER INTERPRISES - 292","C");
INSERT INTO v_party VALUES("2610000233","AHMED TRADERS - 39","C");
INSERT INTO v_party VALUES("2610000234","JAWA CHEMICAL SHAH ALAM","C");
INSERT INTO v_party VALUES("2610000235","KARACHI CHEMICAL SHAH ALAM","C");
INSERT INTO v_party VALUES("2610000236","SOHAIL MALIK LONDON","C");
INSERT INTO v_party VALUES("2610000237","SALEEM IQBAL JEDDAH","C");
INSERT INTO v_party VALUES("2610000238","NAVEED KAMAL","C");
INSERT INTO v_party VALUES("2610000239","ANJUM CHEMICAL SHAH ALAM","C");
INSERT INTO v_party VALUES("2610000240","AL RIAZ AND COMPANY - 144","C");
INSERT INTO v_party VALUES("2610000241","SHAHID WARNISH - 764","C");
INSERT INTO v_party VALUES("2610000242","RASHID JAHANGIR","C");
INSERT INTO v_party VALUES("2610000243","LAYAL PUR CHEMICAL - 518","C");
INSERT INTO v_party VALUES("2610000245","KAUSAR TRADERS BUND ROAD","C");
INSERT INTO v_party VALUES("2610000247","WARIS CHEMICAL KISSAN STREET","C");
INSERT INTO v_party VALUES("2610000248","RAUF & SONS SHAHALAM - 725","C");
INSERT INTO v_party VALUES("2610000249","C.F.S","C");
INSERT INTO v_party VALUES("2610000250","D.H.CHEMICALS - 229","C");
INSERT INTO v_party VALUES("2610000252","AL-SAEED CHEMICAL SHAHALAM","C");
INSERT INTO v_party VALUES("2610000254","M.ISMIAL & SONS - 138","C");
INSERT INTO v_party VALUES("2610000255","SULTAN NAZEER - 227","C");
INSERT INTO v_party VALUES("2610000256","OMER CHEMICAL KISSAN STREET 336","C");
INSERT INTO v_party VALUES("2610000257","HAMEED CHEMICAL FAISALABAD 382","C");
INSERT INTO v_party VALUES("2610000258","ASHRAF CHEMICAL ALAHI MARKET- 50","C");
INSERT INTO v_party VALUES("2610000260","FALKAN INDUSTRY - 264","C");
INSERT INTO v_party VALUES("2610000261","RAO KHURSHID - 279","C");
INSERT INTO v_party VALUES("2610000262","MUHAMMAD ASAD GULBERG - 86","C");
INSERT INTO v_party VALUES("2610000263","MEHRAN INTERPRISES","C");
INSERT INTO v_party VALUES("2610000264","MUHAMMAD AWAIS PINDI","C");
INSERT INTO v_party VALUES("2610000265","ZAHID CHEMICAL CIRCULAR ROAD","C");
INSERT INTO v_party VALUES("2610000270","LAHORE ESSENCE 536","C");
INSERT INTO v_party VALUES("2610000271","MUNIR CHEMICAL SHAHALAM - 622","C");
INSERT INTO v_party VALUES("2610000272","AKHTAR NIMIR BUND ROAD - 126","C");
INSERT INTO v_party VALUES("2610000273","BASIT CHEMICAL SHAH ALAM - 100","C");
INSERT INTO v_party VALUES("2610000275","KHAWAJA  TARIQ SHAHALAM","C");
INSERT INTO v_party VALUES("2610000276","AKBARI STORE CIRCULAR ROAD","C");
INSERT INTO v_party VALUES("2610000277","OMER TISSUE - 656","C");
INSERT INTO v_party VALUES("2610000278","CRESENT CHEMICAL SHAHALAM - 256","C");
INSERT INTO v_party VALUES("2610000279","BASIC CHEMICAL","C");
INSERT INTO v_party VALUES("2610000281","NIMIR INDUSTRIES CHEMICAL-AL REHMAN TRADERS","C");
INSERT INTO v_party VALUES("2610000282","DOST  MUHAMMAD - 235","C");
INSERT INTO v_party VALUES("2610000285","HAMAYUN BROTHERS - 390","C");
INSERT INTO v_party VALUES("2610000286","IRFAN PASROOR - 199","C");
INSERT INTO v_party VALUES("2610000288","ALI INTERNATIONAL QUETTA - 397","C");
INSERT INTO v_party VALUES("2610000289","ANWAR & COMPANY SHAHALAM","C");
INSERT INTO v_party VALUES("2610000291","CHAWALA HABIB - 240","C");
INSERT INTO v_party VALUES("2610000293","JAFFER CHEMICAL SHAHALAM","C");
INSERT INTO v_party VALUES("2610000294","HASHIM TRADERS","C");
INSERT INTO v_party VALUES("2610000297","CITY CHEMICAL KISSAN STREET","C");
INSERT INTO v_party VALUES("2610000298","TARIQ BROTHERS SHAHALAM 509","C");
INSERT INTO v_party VALUES("2610000299","BUILDING KHATA","C");
INSERT INTO v_party VALUES("2610000300","PARACHA BROTHERS QUETA - 306","C");
INSERT INTO v_party VALUES("2610000304","ZAFAR & COMPANY FAISALABAD","C");
INSERT INTO v_party VALUES("2610000308","KHAWAJA NASIR-UD-DIN & SONS-254","C");
INSERT INTO v_party VALUES("2610000309","ALI & COMPANY - 872","C");
INSERT INTO v_party VALUES("2610000311","MALIK EJAZ","C");
INSERT INTO v_party VALUES("2610000312","SAJID PAINT SHALAMAR BAGH","C");
INSERT INTO v_party VALUES("2610000313","AKBAR TRADERS","C");
INSERT INTO v_party VALUES("2610000314","TYCON BUND ROAD - 127","C");
INSERT INTO v_party VALUES("2610000315","PARVEZ MUGHAL PURA - 619","C");
INSERT INTO v_party VALUES("2610000316","SALEEM & COMPANY","C");
INSERT INTO v_party VALUES("2610000317","PUNJAB CHEMICAL KISSAN STREET - 891","C");
INSERT INTO v_party VALUES("2610000318","OMER PAINT","C");
INSERT INTO v_party VALUES("2610000319","IQBAL TRADERS DHARAMPURA - 421","C");
INSERT INTO v_party VALUES("2610000320","SABIR KARACHI","C");
INSERT INTO v_party VALUES("2610000323","AL-QURAISH BOARD MILL","C");
INSERT INTO v_party VALUES("2610000324","HAJI MUHAMMAD SHAFFI","C");
INSERT INTO v_party VALUES("2610000325","SULTAN ASSOCIATES FAISALABAD","C");
INSERT INTO v_party VALUES("2610000327","TARIQ BROTHERS KHUSH DHOODH WALAY - 688","C");
INSERT INTO v_party VALUES("2610000328","MUNIR ALAM","C");
INSERT INTO v_party VALUES("2610000331","JAMIL DYING - 484","C");
INSERT INTO v_party VALUES("2610000332","BUTT & COMPANY - 184","C");
INSERT INTO v_party VALUES("2610000334","AL MANZOOR CHEMICAL","C");
INSERT INTO v_party VALUES("2610000335","AQS - CHEMICAL JOHAR TOWN LAHORE - 212","C");
INSERT INTO v_party VALUES("2610000336","C.F.S-II - 262","C");
INSERT INTO v_party VALUES("2610000338","DIN MUHAMMAAD & SONS KARACHI - 274","C");
INSERT INTO v_party VALUES("2610000339","MUHAMMAD AMIN PESHAWAR - 316","C");
INSERT INTO v_party VALUES("2610000340","KIRAN CANDLE","C");
INSERT INTO v_party VALUES("2610000341","KHAWAR MAHMOOD & COMPANY","C");
INSERT INTO v_party VALUES("2610000342","GHULAM RASOOL & COMPANY - 324","C");
INSERT INTO v_party VALUES("2610000343","RASHID PINDI","C");
INSERT INTO v_party VALUES("2610000344","M.B. DYES","C");
INSERT INTO v_party VALUES("2610000345","JAMAL PIPE - 118","C");
INSERT INTO v_party VALUES("2610000346","ABID PAINT PINDI","C");
INSERT INTO v_party VALUES("2610000347","KARAN CANDLE SHEIKHUPURA","C");
INSERT INTO v_party VALUES("2610000348","GHAZI TRADERS - 943","C");
INSERT INTO v_party VALUES("2610000349","JAAN RUBBER INDUSTRY - 450","C");
INSERT INTO v_party VALUES("2610000350","COLORTEX","C");
INSERT INTO v_party VALUES("2610000354","ABDULLAH PLASTIC G.T. ROAD - 92","C");
INSERT INTO v_party VALUES("2610000355","RAZA TRADERS BUND ROAD - 3","C");
INSERT INTO v_party VALUES("2610000356","SAEED KHAN SHERAWALE - 5","C");
INSERT INTO v_party VALUES("2610000357","RAISIN HOUSE SHAHLMI - 61","C");
INSERT INTO v_party VALUES("2610000361","SAMAR DYES - 776","C");
INSERT INTO v_party VALUES("2610000362","YAQOOB DYES - 68","C");
INSERT INTO v_party VALUES("2610000363","IQBAL BROTHERS SHAHLMI - 142","C");
INSERT INTO v_party VALUES("2610000364","MUZAMIL TAJAMAL CHEMICAL SHAHLMI - 178","C");
INSERT INTO v_party VALUES("2610000365","VAZIR SONS CIRCULAR ROAD - 802","C");
INSERT INTO v_party VALUES("2610000367","AKRAM AND COMPANY AKBARI MANDI","C");
INSERT INTO v_party VALUES("2610000368","NAZEER PAPER MILL - 292","C");
INSERT INTO v_party VALUES("2610000369","NAEEM INAM ULLAH","C");
INSERT INTO v_party VALUES("2610000370","COLOR LINE LAL MAQSOOD MARKET - 271","C");
INSERT INTO v_party VALUES("2610000371","COLOUR TAX CIRCULAR ROAD","C");
INSERT INTO v_party VALUES("2610000374","AL MANZOOR CHEMICAL SHAHALMI 318 PAGE","C");
INSERT INTO v_party VALUES("2610000375","PAKISTAN CHEMICALS CIRCULLAR ROAD 226","C");
INSERT INTO v_party VALUES("2610000376","SHAHID BROTHERS KISSAN STREET -780","C");
INSERT INTO v_party VALUES("2610000377","NEW ARBE CHEMICAL PAG 242","C");
INSERT INTO v_party VALUES("2610000379","STAR KO BELTING PAG - 378","C");
INSERT INTO v_party VALUES("2610000380","AFTABE PINDI PAG145","C");
INSERT INTO v_party VALUES("2610000381","BATALA CHEMICAL - 190","C");
INSERT INTO v_party VALUES("2610000382","ZAHIR SHAH PARA CHINAR PAG 11","C");
INSERT INTO v_party VALUES("2610000383","SHAHARYAR PAG 139","C");
INSERT INTO v_party VALUES("2610000384","MUSLIM SOAP - 328","C");
INSERT INTO v_party VALUES("2610000385","MUHAMMAD AWAIS SHAHDRA PAG 271","C");
INSERT INTO v_party VALUES("2610000386","MAHMOOD SATHI PAG 626","C");
INSERT INTO v_party VALUES("2610000387","KHAN TRADERS CIRCULAR ROAD - 822","C");
INSERT INTO v_party VALUES("2610000388","IMRAN DANISH FAISALABAD - 208","C");
INSERT INTO v_party VALUES("2610000389","UNITED CORPORATION -384","C");
INSERT INTO v_party VALUES("2610000390","CITY PACKIGIES -107","C");
INSERT INTO v_party VALUES("2610000391","TALIBJAN AND BROTHERS - 796","C");
INSERT INTO v_party VALUES("2610000395","ALI ANWAR BROKER - 422","C");
INSERT INTO v_party VALUES("2610000396","HAJI MUHAMMAD SHAFI BULL ROAD - 38","C");
INSERT INTO v_party VALUES("2610000401","MADINA COLOR CIRCULAR ROAD - 95","C");
INSERT INTO v_party VALUES("2610000402","CHAWALA BROTHERS FAISALABAD - 258","C");
INSERT INTO v_party VALUES("2610000403","MUHAMMAD SHAFI BULL ROAD","C");
INSERT INTO v_party VALUES("2610000405","HAJI ARSHAD MORI GATE - 117","C");
INSERT INTO v_party VALUES("2610000408","MUHAMMAD FAROOQ KARACHI 302","C");
INSERT INTO v_party VALUES("2610000410","SULAIMAN SAWEYA WALE GUJRANWALA","C");
INSERT INTO v_party VALUES("2610000411","SETHI PAINT","C");
INSERT INTO v_party VALUES("2610000412","PIONEER PAPER MILL - 167","C");
INSERT INTO v_party VALUES("2610000414","A. R. ENTERPRISES - 27","C");
INSERT INTO v_party VALUES("2610000416","RIZWAN BROTHERS SHAHLMI - 101","C");
INSERT INTO v_party VALUES("2610000417","HAJI ALYAS MORI GATE - 192","C");
INSERT INTO v_party VALUES("2610000418","AL-NAEEM CORPORATION - 31","C");
INSERT INTO v_party VALUES("2610000419","OUN CORPORATION - P93","C");
INSERT INTO v_party VALUES("2610000420","MATTI ULLAH SIALKOT - 820","C");
INSERT INTO v_party VALUES("2610000421","TAUQIR BROTHERS - 110","C");
INSERT INTO v_party VALUES("2610000422","AL-HAYEE CHEMICAL - 119","C");
INSERT INTO v_party VALUES("2610000423","MUBARAK ALI BILLA - 634","C");
INSERT INTO v_party VALUES("2610000426","GUJRANWALA PAPER MILL - 238","C");
INSERT INTO v_party VALUES("2610000427","JALAL-UD-DIN AKBARI MANDI - 712","C");
INSERT INTO v_party VALUES("2610000428","ALI BABA BADAMI BAGH - 131","C");
INSERT INTO v_party VALUES("2610000429","FAISAL KHURSHID - 476","C");
INSERT INTO v_party VALUES("2610000430","JAVED RAZA BROKER - 210","C");
INSERT INTO v_party VALUES("2610000431","FURQAN KARACHI - 498","C");
INSERT INTO v_party VALUES("2610000432","ACRO CHEMICAL BUND ROAD - 900","C");
INSERT INTO v_party VALUES("2610000433","FARAS COMBINE MARKETING - 340","C");
INSERT INTO v_party VALUES("2610000434","JAVED SIALKOT - 293","C");
INSERT INTO v_party VALUES("2610000435","SHALIMAR RAISIN - 785","C");
INSERT INTO v_party VALUES("2610000436","HAJI ABDUL KARIM & SONS KARACHI - 437","C");
INSERT INTO v_party VALUES("2610000437","GALA PAINT","C");
INSERT INTO v_party VALUES("2610000438","MUHAMMADI TRADERS - 129","C");
INSERT INTO v_party VALUES("2610000440","ALEEM CHAUDHRY - 383","C");
INSERT INTO v_party VALUES("2610000442","SETHI PHARMA INDUSTRY CHACHA WATNI - 123","C");
INSERT INTO v_party VALUES("2610000443","REHMANI TRADERS - 179","C");
INSERT INTO v_party VALUES("2610000444","WAQAR L/C LATEX RUBBER 3874","C");
INSERT INTO v_party VALUES("2610000445","AMIR SOAP BABA PUR - 654","C");
INSERT INTO v_party VALUES("2610000446","KASHIF SHAHDARA - 550","C");
INSERT INTO v_party VALUES("2610000448","HASNAIN TRADING COMPANY CIRCULAR ROAD - 357","C");
INSERT INTO v_party VALUES("2610000449","UNION BELTING - 118","C");
INSERT INTO v_party VALUES("2610000450","QUALITY COSMETIC - 406","C");
INSERT INTO v_party VALUES("2610000453","INVESTMENT ACCOUNT - 432","C");
INSERT INTO v_party VALUES("2610000454","lL/C VIETNAM BROZA 5559","C");
INSERT INTO v_party VALUES("2610000455","lL/C INDONESIA BROZA 6063","C");
INSERT INTO v_party VALUES("2610000456","lL/C VIETNAM BROZA 6296","C");
INSERT INTO v_party VALUES("2610000461","ijaz kasur- 263","C");
INSERT INTO v_party VALUES("2610000462","SALEEM CHEMICAL KISSAN STREET - 790","C");
INSERT INTO v_party VALUES("2610000463","RAHIM CHEMICAL SHAHALMI","C");
INSERT INTO v_party VALUES("2610000464","TALHA TRADERS PAG-199","C");
INSERT INTO v_party VALUES("2610000466","ARIF BUTT RAVI ROAD 170","C");
INSERT INTO v_party VALUES("2610000467","ZAFIR AND COMPANY LAL MAQSOOD MARKET PAG 384","C");
INSERT INTO v_party VALUES("2610000468","SHAHBAZ AKBARI MANDI - 720","C");
INSERT INTO v_party VALUES("2610000469","AA INTER PRICES PAG 6","C");
INSERT INTO v_party VALUES("2610000471","AMIR SHAHALAMI 366","C");
INSERT INTO v_party VALUES("2610000472","Qamar Candle Peshawar - 504","C");
INSERT INTO v_party VALUES("2610000473","US GODOWN  543","C");
INSERT INTO v_party VALUES("2610000474","ABDUL KARIM ADAM JI 652","C");
INSERT INTO v_party VALUES("2610000475","IRFAN BROTHER SHAHALAMI - 94","C");
INSERT INTO v_party VALUES("2610000476","GUL AUTO - 334","C");
INSERT INTO v_party VALUES("2610000477","MAKHA PEHLWAN   219","C");
INSERT INTO v_party VALUES("2610000479","SULMAN MODEL TOWN - 892","C");
INSERT INTO v_party VALUES("2610000480","KASHAF INDUSTRY FAISLABAD - 467","C");
INSERT INTO v_party VALUES("2610000481"," LM TRADER - 546","C");
INSERT INTO v_party VALUES("2610000482","VENUS CORPORATION -  892","C");
INSERT INTO v_party VALUES("2610000483","BANGA INTERNATIONAL - 147","C");
INSERT INTO v_party VALUES("2610000484","ABID MALIK - 463","C");
INSERT INTO v_party VALUES("2610000485","J F CHATTI KARACHI - 456","C");
INSERT INTO v_party VALUES("2610000486","ASHRAF SONS KARACHI - 260","C");
INSERT INTO v_party VALUES("2610000487","KHURRAM CHEMICAL KARACHI - 102","C");
INSERT INTO v_party VALUES("2610000488","MAQSOOD GADE - 229","C");
INSERT INTO v_party VALUES("2610000489","SES ENGINEERS - 950","C");
INSERT INTO v_party VALUES("2610000490","LATIF RANG WALAY DASKA - 322","C");
INSERT INTO v_party VALUES("2610000493","AZHAR PINDI - 115","C");
INSERT INTO v_party VALUES("2610000494","MILLAT SOAP - 60","C");
INSERT INTO v_party VALUES("2610000495","PAK WAX COMPANY - 299","C");
INSERT INTO v_party VALUES("2610000496","HABIB HARDWARE MULTAN - 290","C");
INSERT INTO v_party VALUES("2610000497","SHER AFGAN GUJRANWALA - 304","C");
INSERT INTO v_party VALUES("2610000498","AHMAD PESHWAR - 18","C");
INSERT INTO v_party VALUES("2610000499","MUHAMMAD IMRAN - 278","C");
INSERT INTO v_party VALUES("2610000500","HUSNAIN BROTHERS MULTAN - 436","C");
INSERT INTO v_party VALUES("2610000504","OMER CHEMICAL PAPERD MANDI - 806","C");
INSERT INTO v_party VALUES("2610000505","INAM ULLAH FAISALABAD - 788","C");
INSERT INTO v_party VALUES("2610000507"," SAIF ENTERPRISES - 232","C");
INSERT INTO v_party VALUES("2610000508","RAIZ MINGORA - 523","C");
INSERT INTO v_party VALUES("2610000509","QAISAR GUJRANWALA - 445","C");
INSERT INTO v_party VALUES("2610000510","NAZIR ULLAH  PESHAWAR-602","C");
INSERT INTO v_party VALUES("2610000511","RAIZ CHKWAL - 364","C");
INSERT INTO v_party VALUES("2610000515","Asif Afridi and Company - 252","C");
INSERT INTO v_party VALUES("2610000516","PUL SAGEYAN 2 - 812","C");
INSERT INTO v_party VALUES("2610000517","PAC TACK TOWN SHIP - 832","C");
INSERT INTO v_party VALUES("2610000519","Mazda Shahzoor Khata - 973","C");
INSERT INTO v_party VALUES("2610000520","Carwan Craft - 223","C");
INSERT INTO v_party VALUES("2610000522","NADER DYING - 586","C");
INSERT INTO v_party VALUES("2610000523","SNOW WHITE CHEMICAL HOUSE - 842","C");
INSERT INTO v_party VALUES("2610000524","ALHAMD DYEING - 471","C");
INSERT INTO v_party VALUES("2610000525","Muhammad Usman Gujranwala - 658","C");
INSERT INTO v_party VALUES("2610000526","Muhammad Parvez Gujranwala - 956","C");
INSERT INTO v_party VALUES("2610000527","SUPURDARE KHATA - 928","C");
INSERT INTO v_party VALUES("2610000528","SILVER STAR ENTERPRISES - 32","C");
INSERT INTO v_party VALUES("2610000529","STOCK EXCHANGE TOWER No2 - 76","C");
INSERT INTO v_party VALUES("2610000530","GODOWN KHATA SHAH MUHAMMAD GHOSE","C");
INSERT INTO v_party VALUES("2610000531","MADNI CHEMICAL CIRCULER ROAD - 615","C");
INSERT INTO v_party VALUES("2610000533","Usman Brother Shahalum - 100","C");
INSERT INTO v_party VALUES("2610000534","SULPHONIC TUFAIL KHATA","C");
INSERT INTO v_party VALUES("2610000535","RAAZQ CHEMICAL PAPERD MANDI - 688","C");
INSERT INTO v_party VALUES("2610000536","FALCAN BELTING - 30","C");
INSERT INTO v_party VALUES("2610000537","TANVEER CANDLE TAJPURA - 582","C");
INSERT INTO v_party VALUES("2610000538","SAYED FAISAL SHAH BROKER - 348","C");
INSERT INTO v_party VALUES("2610000539","MUNIR BOTTLE STORE - 894","C");
INSERT INTO v_party VALUES("2610000540","Nimir Chemical Pakistan LTD - 266","C");
INSERT INTO v_party VALUES("2610000541","MALEIC KHATA","C");
INSERT INTO v_party VALUES("2610000542","BEGUM NASIRA SES - 614","C");
INSERT INTO v_party VALUES("2610000543","INDIA BROZA KHATA","C");
INSERT INTO v_party VALUES("2610000547","SECURITY DUBI KHATA 3017","C");
INSERT INTO v_party VALUES("2610000548","BILAL BROTHER - 346","C");
INSERT INTO v_party VALUES("2610000551","Shama Malik Thana Gulberg - 26","C");
INSERT INTO v_party VALUES("2610000552","Grace Chemecals - 678","C");
INSERT INTO v_party VALUES("2610000554","Nadeem Jahangir - 248","C");
INSERT INTO v_party VALUES("2610000556","OWN L/C NEPALI BROZA 27207","C");
INSERT INTO v_party VALUES("2610000557","MUHAMMAD SAEED BROZAY WALAY-121","C");
INSERT INTO v_party VALUES("2610000558","UMER CHEMICAL KISAN STREET - 336","C");
INSERT INTO v_party VALUES("2610000561","MB CHEMICALS STORE KISAN STREET - 8","C");
INSERT INTO v_party VALUES("2610000562","MM TRADER - 12","C");
INSERT INTO v_party VALUES("2610000563","OWN L/C NEPALI BROZA 27830","C");
INSERT INTO v_party VALUES("2610000564","ZAIN AHMAD KHWAJA - 379","C");
INSERT INTO v_party VALUES("2610000565","MAHMOOD BUKHARE - 5","C");
INSERT INTO v_party VALUES("2610000566","UZMA SHABIR SECURITY - 506","C");
INSERT INTO v_party VALUES("2610000567","SES NO-2 -599","C");
INSERT INTO v_party VALUES("2610000568","ALI TRADERS 661","C");
INSERT INTO v_party VALUES("2610000569","TARIQ FEROZ KARACHI - 42","C");
INSERT INTO v_party VALUES("2610000571","KHAWAJA NOOR - 376","C");
INSERT INTO v_party VALUES("2610000572","Manzoor gadi wala - 221","C");
INSERT INTO v_party VALUES("2610000573","JAVED PAINT GUJRANWALA - 146","C");
INSERT INTO v_party VALUES("2610000574","TAHIR PARVAZ VAKEEL - 3","C");
INSERT INTO v_party VALUES("2610000575","DRUM BROZA INDONESIA","C");
INSERT INTO v_party VALUES("2610000576","Malik Ishaq Sialkot- 623","C");
INSERT INTO v_party VALUES("2610000577","HAMZA TARPAL - 548","C");
INSERT INTO v_party VALUES("2610000578","ANWER KHAWAJA INSDUSTRY - 178","C");
INSERT INTO v_party VALUES("2610000579","IMRAN BUND ROAD - 167","C");
INSERT INTO v_party VALUES("2610000582","TAHIR SIALKOT - 418","C");
INSERT INTO v_party VALUES("2610000583","YOUSAF DYING - 561","C");
INSERT INTO v_party VALUES("2610000585","KHALI DRUM KHATA","C");
INSERT INTO v_party VALUES("2610000587","Muhammad Rafi Moom Bati Waly - 55","C");
INSERT INTO v_party VALUES("2610000588","Pioneer Board Mill 508","C");
INSERT INTO v_party VALUES("2610000589","ABDUL RAHMAN AND COMPANY 28","C");
INSERT INTO v_party VALUES("2610000594","NOOR HUSSAIN KASUR 753","C");
INSERT INTO v_party VALUES("2610000595","SABBAR MALIK URDU BAZAR 62","C");
INSERT INTO v_party VALUES("2610000596","DRAZ ACCOUNT 78","C");
INSERT INTO v_party VALUES("2610000598","DANISH KARCHI 305","C");
INSERT INTO v_party VALUES("2610000599","MDS international 224","C");
INSERT INTO v_party VALUES("2610000602","BRIGHTER CHEMICAL 370","C");
INSERT INTO v_party VALUES("2610000604","Javed iqbal security 93842  675","C");
INSERT INTO v_party VALUES("2610000605",".","C");
INSERT INTO v_party VALUES("2610000606","Arif haiderabad 108","C");
INSERT INTO v_party VALUES("3610000170","L/C INDONESIA BROZA TORA","C");
INSERT INTO v_party VALUES("3610000171","L/C INDONESIA BROZA 2783","C");
INSERT INTO v_party VALUES("3610000175","L/C INDONESIA BROZA 2783","C");
INSERT INTO v_party VALUES("3610000190","L/C INDONESIA 2140","C");
INSERT INTO v_party VALUES("3610000191","L/C INDONESIA 2160","C");
INSERT INTO v_party VALUES("3610000192","L/C INDONESIA","C");
INSERT INTO v_party VALUES("3610000207","L/C INDONESIA BOZA DRUM","C");
INSERT INTO v_party VALUES("3610000213","L/C INDONESIA BROZA 2828","C");
INSERT INTO v_party VALUES("3610000215","L/C MOAM CHINA 2941","C");
INSERT INTO v_party VALUES("3610000223","L/C MOAM CHINA 2941","C");
INSERT INTO v_party VALUES("3610000232","L/C INDONESIA 2835","C");
INSERT INTO v_party VALUES("3610000246","L/C INDONESIA BROZA 2685","C");
INSERT INTO v_party VALUES("3610000253","L/C INDONESIA BROZA 2361","C");
INSERT INTO v_party VALUES("3610000266","L/C VIETNAM 3593","C");
INSERT INTO v_party VALUES("3610000267","L/C INDONESIA 3599","C");
INSERT INTO v_party VALUES("3610000268","L/C INDONESIA DRUM 3670","C");
INSERT INTO v_party VALUES("3610000280","L/C VIETNAM 3825","C");
INSERT INTO v_party VALUES("3610000283","L/C INDONESIA BROZA 3824","C");
INSERT INTO v_party VALUES("3610000284","L/C INDONESIA 3634","C");
INSERT INTO v_party VALUES("3610000292","L/C INDONESIA BROZA 4018","C");
INSERT INTO v_party VALUES("3610000295","L/C INDONESIA BROZA 4019","C");
INSERT INTO v_party VALUES("3610000296","L/C VIETNAM BROZA 4070","C");
INSERT INTO v_party VALUES("3610000301","L/C INDONESIA BROZA 4214","C");
INSERT INTO v_party VALUES("3610000302","L/C INDONESIA BROZA 4182","C");
INSERT INTO v_party VALUES("3610000303","L/C INDONESIA BROZA 4183","C");
INSERT INTO v_party VALUES("3610000305","L/C VIETNAM BROZA 4447","C");
INSERT INTO v_party VALUES("3610000306","L/C  VIETNAM  BROZA 4448","C");
INSERT INTO v_party VALUES("3610000307","L/C  VIETNAM  BROZA  4531","C");
INSERT INTO v_party VALUES("3610000310","L/C INDONESIA BROZA 4533","C");
INSERT INTO v_party VALUES("3610000321","L/C INDONESIA BROZA 4882","C");
INSERT INTO v_party VALUES("3610000322","L/C INDONESIA BROZA 4882","C");
INSERT INTO v_party VALUES("3610000329","L/C INDONESIA BROZA 0172","C");
INSERT INTO v_party VALUES("3610000330","L/C VIETNAM BROZA 0367","C");
INSERT INTO v_party VALUES("3610000333","L/C INDONESIA BROZA 3163","C");
INSERT INTO v_party VALUES("3610000351","L/C STERIC 7213","C");
INSERT INTO v_party VALUES("3610000352","L/C STERIC 7122","C");
INSERT INTO v_party VALUES("3610000353","L/C STERIC 6712","C");
INSERT INTO v_party VALUES("3610000358","L/C INDONESIA DRUM BROZA 1784","C");
INSERT INTO v_party VALUES("3610000359","L/C INDONESIA DRUM BROZA 2155","C");
INSERT INTO v_party VALUES("3610000360","L/C INDONESIA DRUM BROZA 2373","C");
INSERT INTO v_party VALUES("3610000366","L/C SULPHONIC LG 4010","C");
INSERT INTO v_party VALUES("3610000372","L/C SULPHONI MIWON 4337","C");
INSERT INTO v_party VALUES("3610000373","L/C SULPHONIC MIWON 4751","C");
INSERT INTO v_party VALUES("3610000378","L/C SULPHONIC 5402","C");
INSERT INTO v_party VALUES("3610000392","L/C INDONESIA BROZA 7875","C");
INSERT INTO v_party VALUES("3610000393","L/C INDONESIA BROZA 7641","C");
INSERT INTO v_party VALUES("3610000394","L/C INDONESIA BROZA 7727","C");
INSERT INTO v_party VALUES("3610000397","L/C INDONESIA BROZA 8231","C");
INSERT INTO v_party VALUES("3610000398","L/C STERIC 8932","C");
INSERT INTO v_party VALUES("3610000399","L/C INDONESIA BROZA 9199","C");
INSERT INTO v_party VALUES("3610000400","L/C INDONESIA BROZA 9390","C");
INSERT INTO v_party VALUES("3610000404","L/C STERIC 10014/2","C");
INSERT INTO v_party VALUES("3610000406","L/C SULPHONIC MIWON 0214","C");
INSERT INTO v_party VALUES("3610000407","L/C SULPHONIC INDIA 0153","C");
INSERT INTO v_party VALUES("3610000409","L/C STERIC 10014/1","C");
INSERT INTO v_party VALUES("3610000413","L/C SULPHONIC MIWON 0690","C");
INSERT INTO v_party VALUES("3610000415","L/C SULPHONIC LG 0691","C");
INSERT INTO v_party VALUES("3610000424","L/C SULPHONIC CHINA 0310","C");
INSERT INTO v_party VALUES("3610000425","L/C SULPHONIC CHINA 0693","C");
INSERT INTO v_party VALUES("3610000439","L/C LATEX RUBBER 3874","C");
INSERT INTO v_party VALUES("3610000447","L/C VIETNAM BROZA 4705","C");
INSERT INTO v_party VALUES("3610000451","L/C INDONESIA BROZA 3873","C");
INSERT INTO v_party VALUES("3610000452","L/C VIETNAM BAROZA 4984","C");
INSERT INTO v_party VALUES("3610000457","L/C CHINA BROZA 6297","C");
INSERT INTO v_party VALUES("3610000458","L/C INDONESIA BROZA 6061","C");
INSERT INTO v_party VALUES("3610000459","L/C INDONESIA BROZA 6570","C");
INSERT INTO v_party VALUES("3610000460","L/C INDONESIA BROZA 6571","C");
INSERT INTO v_party VALUES("3610000465","L/C BROZA INDONESIA 6062","C");
INSERT INTO v_party VALUES("3610000470","L/C BROZA INDONESIA 8438","C");
INSERT INTO v_party VALUES("3610000478","L/C BROZA INDONESIA 9232","C");
INSERT INTO v_party VALUES("3610000491","L/C VIETNAM BROZA  4927","C");
INSERT INTO v_party VALUES("3610000492","L/C INDONESIA BROZA 6402","C");
INSERT INTO v_party VALUES("3610000501","L/C INDONESIA BROZA 8438","C");
INSERT INTO v_party VALUES("3610000502","L/C INDONESIA BROZA 8468","C");
INSERT INTO v_party VALUES("3610000503","L/C INDONESIA BROZA 2012","C");
INSERT INTO v_party VALUES("3610000506","L/C INDONESIA BROZA 2065","C");
INSERT INTO v_party VALUES("3610000512","L/C VIETNAM BROZA 7112","C");
INSERT INTO v_party VALUES("3610000513","L/C VIETNAM BROZA 7012","C");
INSERT INTO v_party VALUES("3610000514","L/C INDONESIA BROZA 0312","C");
INSERT INTO v_party VALUES("3610000518","L/C INDONESIA BROZA IBRAHIM KARACHI","C");
INSERT INTO v_party VALUES("3610000521","L/C VIETNAM BROZA 0712","C");
INSERT INTO v_party VALUES("3610000532","L/C INDONESIA BROZA  28454","C");
INSERT INTO v_party VALUES("3610000544","L/C NEPALI BROZA NO-1 BAZREYA IBRAHIM WALI MUHAMAD","C");
INSERT INTO v_party VALUES("3610000545","L/C INDONESIA BROZA CONTRACT 25288","C");
INSERT INTO v_party VALUES("3610000546","L/C INDONESIA BROZA CONTRACT 25719","C");
INSERT INTO v_party VALUES("3610000549","L/C NEPALI BROZA CONTRACT 25795","C");
INSERT INTO v_party VALUES("3610000550","L/C NEPALI BROZA NO-2   P-985","C");
INSERT INTO v_party VALUES("3610000553","L/C MOM CHINA 30719","C");
INSERT INTO v_party VALUES("3610000555","L/C NEPALI BROZA CONTRACT 27207","C");
INSERT INTO v_party VALUES("3610000559","L/C NEPALI BROZA CONTRACT 27830","C");
INSERT INTO v_party VALUES("3610000560","L/C INDONESIA BROZA 33395","C");
INSERT INTO v_party VALUES("3610000570","L/C VIETNAM BROZA 27052","C");
INSERT INTO v_party VALUES("3610000580","L/C INDONESIA BROZA 38477","C");
INSERT INTO v_party VALUES("3610000581","L/C MOM CHINA 38980","C");
INSERT INTO v_party VALUES("3610000584","L/C INDONESIA BROZA 40656","C");
INSERT INTO v_party VALUES("3610000586","L/C INDONESIA BROZA 44193","C");
INSERT INTO v_party VALUES("3610000590","L/C INDONESIA BROZA 29955","C");
INSERT INTO v_party VALUES("3610000591","L/C INDONESIA BROZA CONTRACT 27223","C");
INSERT INTO v_party VALUES("3610000592","L/C MOAM CHINA 31798","C");
INSERT INTO v_party VALUES("3610000593","L/C MOAM CHINA 32946","C");
INSERT INTO v_party VALUES("3610000597","L/C INDONESIA BROZA 39394","C");
INSERT INTO v_party VALUES("3610000600","L/C MOAM CHINA 46583","C");
INSERT INTO v_party VALUES("3610000601","L/C INDONESIA BROZA CONTRACT 25270","C");
INSERT INTO v_party VALUES("3610000603","L/C INDONESIA BROZA CONTRACT 25531","C");


DROP TABLE IF EXISTS v_party_bal;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0);

INSERT INTO v_party_bal VALUES("0026","57640.25");
INSERT INTO v_party_bal VALUES("1200010002","-66.00");
INSERT INTO v_party_bal VALUES("1310000001","4000.00");
INSERT INTO v_party_bal VALUES("2610000001","284500.00");
INSERT INTO v_party_bal VALUES("2610000030","158390.00");
INSERT INTO v_party_bal VALUES("2610000032","20100.00");
INSERT INTO v_party_bal VALUES("2610000035","16000.00");
INSERT INTO v_party_bal VALUES("2610000045","17000.00");
INSERT INTO v_party_bal VALUES("2610000049","40000.00");
INSERT INTO v_party_bal VALUES("2610000066","43000.00");
INSERT INTO v_party_bal VALUES("2610000154","1410000.00");
INSERT INTO v_party_bal VALUES("2610000166","-5109234.99");


DROP TABLE IF EXISTS v_voucherdet_pay;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_voucherdet_pay` AS select concat(`d`.`COMP_ID`,`d`.`VOUCHER_ID`,'/',`d`.`LINEITEM`) AS `voucher_id`,concat(`d`.`LINEITEM`,'.') AS `lineitem`,`d`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name` from (`voucherdet` `d` left join `nom` `n` on((`d`.`ACCT_ID` = `n`.`ACCT_ID`))) where (substr(`d`.`LINEITEM`,-(1)) <> '.');

INSERT INTO v_voucherdet_pay VALUES("01PL070001/1","1.","2210000001","");
INSERT INTO v_voucherdet_pay VALUES("01PL070001/2","2.","2610000154","NIMIR INDUSTRIES - 654");
INSERT INTO v_voucherdet_pay VALUES("01SL070001/1","1.","2610000166","CASH SALES");
INSERT INTO v_voucherdet_pay VALUES("01CP070001/1","1.","3750000075","4993");


DROP TABLE IF EXISTS v_vouchers;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_vouchers` AS select `v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`CREDIT` < 0),-(`vd`.`CREDIT`),if((`vd`.`DEBIT` > 0),`vd`.`DEBIT`,0)) AS `debit`,if((`vd`.`DEBIT` < 0),-(`vd`.`DEBIT`),if((`vd`.`CREDIT` > 0),`vd`.`CREDIT`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,concat(if((`vd`.`V_NO` <> ''),concat('Bill#',`vd`.`V_NO`,' / '),''),`vd`.`PARTICULARS`) AS `particulars`,`v`.`POSTED` AS `posted` from ((((`cnlxidtp_click_nmt`.`voucher` `v` left join `cnlxidtp_click_nmt`.`voucherdet` `vd` on(((`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`) and (`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`)))) left join `cnlxidtp_click_nmt`.`nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) left join `cnlxidtp_click_nmt`.`nom` `n2` on((`vd`.`ACCT_ID_CS` = `n2`.`ACCT_ID`))) left join `cnlxidtp_click_bk`.`v_voucherdet_pay` `d` on(((`vd`.`VOUCHER_ID` = `d`.`voucher_id`) and (`vd`.`LINEITEM` = `d`.`lineitem`)))) where (`v`.`POSTED` = 'on');

INSERT INTO v_vouchers VALUES("01","01PL070001/1","","","2017-07-15 00:00:00","1","2210000001","","","1410000.000000000000000000000000000000","0","","","on");
INSERT INTO v_vouchers VALUES("01","01PL070001/2","","","2017-07-15 00:00:00","2","2610000154","","","0","1410000.000000000000000000000000000000","NIMIR INDUSTRIES - 654","","on");
INSERT INTO v_vouchers VALUES("01","01SL070001/1","","","2017-07-15 00:00:00","1","2610000166","","","5051835.000000000000000000000000000000","0","CASH SALES","Bill#1","on");
INSERT INTO v_vouchers VALUES("01","01SL070001/1.","","","2017-07-15 00:00:00","1.","3010000001","","","0","0","","Bill#1","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/1.","","","2017-07-16 00:00:00","1.","3700010001","","","0","85000.000000000000000000000000000000","CASH IN HAND","/","on");
INSERT INTO v_vouchers VALUES("01","01CP070001/1","","","2017-07-16 00:00:00","1","3750000075","","","85000.000000000000000000000000000000","0","4993","","on");


DROP TABLE IF EXISTS v_vouchers_07_06_17;

CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_vouchers_07_06_17` AS select `v_vouchers`.`comp_id` AS `comp_id`,`v_vouchers`.`voucher_id` AS `voucher_id`,`v_vouchers`.`inv_no` AS `inv_no`,`v_vouchers`.`description` AS `description`,`v_vouchers`.`voucher_date` AS `voucher_date`,`v_vouchers`.`lineitem` AS `lineitem`,`v_vouchers`.`acct_id` AS `acct_id`,`v_vouchers`.`acct_id_cs_1` AS `acct_id_cs_1`,`v_vouchers`.`acct_id_cs_2` AS `acct_id_cs_2`,`v_vouchers`.`debit` AS `debit`,`v_vouchers`.`credit` AS `credit`,`v_vouchers`.`acct_name` AS `acct_name`,`v_vouchers`.`particulars` AS `particulars`,`v_vouchers`.`posted` AS `posted` from `cnlxidtp_click_bk`.`v_vouchers`;

INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/1","","","2017-06-05 00:00:00","1","1310000023","","","100000.000000000000000000000000000000","0","RAVI TRADERS","CASH + CHEQUE PAID TO RAVI TRADERS CASH PURCHASE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/1.","","","2017-06-05 00:00:00","1.","2720000001","","","0","100000.000000000000000000000000000000","HABIB BANK","RAVI TRADERS/CASH + CHEQUE PAID TO RAVI TRADERS CASH PURCHASE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/2","","","2017-06-05 00:00:00","2","2610000043","","","100000.000000000000000000000000000000","0","HOME TECH","CHEQUE PAID TO BATH TECH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/2.","","","2017-06-05 00:00:00","2.","2720000001","","","0","100000.000000000000000000000000000000","HABIB BANK","/CHEQUE PAID TO BATH TECH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/3","","","2017-06-05 00:00:00","3","1310000044","","","100000.000000000000000000000000000000","0","MARACHI","2 CHEQUES PAID TO MARACHI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/3.","","","2017-06-05 00:00:00","3.","2720000001","","","0","100000.000000000000000000000000000000","HABIB BANK","MARACHI/2 CHEQUES PAID TO MARACHI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/4","","","2017-06-05 00:00:00","4","2720000003","","","1000.000000000000000000000000000000","0","CLEARING CHARGES","PAID CHEQUE CLEARING CHARGES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BP070001/4.","","","2017-06-05 00:00:00","4.","2720000001","","","0","1000.000000000000000000000000000000","HABIB BANK","CLEARING CHARGES/PAID CHEQUE CLEARING CHARGES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BR070001/1","","","2017-06-05 00:00:00","1","2710000001","","","0","78000.000000000000000000000000000000","Cash In Hand","CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BR070001/1.","","","2017-06-05 00:00:00","1.","2720000001","","","78000.000000000000000000000000000000","0","HABIB BANK","Cash In Hand/CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BR070001/2","","","2017-06-05 00:00:00","2","2710000001","","","0","53000.000000000000000000000000000000","Cash In Hand","CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BR070001/2.","","","2017-06-05 00:00:00","2.","2720000001","","","53000.000000000000000000000000000000","0","HABIB BANK","Cash In Hand/CHEQUE DEPOSITED IN HBL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BR070001/3","","","2017-06-05 00:00:00","3","2610000001","","","0","1200.000000000000000000000000000000","Walk-In-Customers","DIRECT DEPOSITED IN HBL CC SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01BR070001/3.","","","2017-06-05 00:00:00","3.","2720000001","","","1200.000000000000000000000000000000","0","HABIB BANK","Walk-In-Customers/DIRECT DEPOSITED IN HBL CC SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/1","","","2017-06-01 00:00:00","1","4010000009","","","200.000000000000000000000000000000","0","CHARITY PAID","CHARITY PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/1.","","","2017-06-01 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","CHARITY PAID/CHARITY PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/10","","","2017-06-01 00:00:00","10","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","PAID FOR REPAIR ELECTRIC BOARD STAFF ROOM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/10.","","","2017-06-01 00:00:00","10.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PAID FOR REPAIR ELECTRIC BOARD STAFF ROOM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/11","","","2017-06-01 00:00:00","11","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT TO ASHFAQ ACCESSORY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/11.","","","2017-06-01 00:00:00","11.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT TO ASHFAQ ACCESSORY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/12","","","2017-06-01 00:00:00","12","4010000004","","","2300.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/12.","","","2017-06-01 00:00:00","12.","2710000001","","","0","2300.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/13","","","2017-06-01 00:00:00","13","4010000006","","","300.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/13.","","","2017-06-01 00:00:00","13.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/14","","","2017-06-01 00:00:00","14","4010000001","","","1000.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PAID TO SALMAN SB FOR AFTARI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/14.","","","2017-06-01 00:00:00","14.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","ENTERTAINMENT EXPENSES/PAID TO SALMAN SB FOR AFTARI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/15","","","2017-06-01 00:00:00","15","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","CASH PAID TO AMEEN FOR MIRRORS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/15.","","","2017-06-01 00:00:00","15.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/CASH PAID TO AMEEN FOR MIRRORS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/16","","","2017-06-01 00:00:00","16","4010000003","","","900.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASED SILICON","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/16.","","","2017-06-01 00:00:00","16.","2710000001","","","0","900.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PURCHASED SILICON","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/17","","","2017-06-01 00:00:00","17","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO WALEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/17.","","","2017-06-01 00:00:00","17.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO WALEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/18","","","2017-06-01 00:00:00","18","4010000001","","","350.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","WATER BILL PAID AMAIZING","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/18.","","","2017-06-01 00:00:00","18.","2710000001","","","0","350.000000000000000000000000000000","Cash In Hand","ENTERTAINMENT EXPENSES/WATER BILL PAID AMAIZING","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/19","","","2017-06-01 00:00:00","19","1310000017","","","200000.000000000000000000000000000000","0","GOROHE","PAID TO SAROSH FOR GROHE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/19.","","","2017-06-01 00:00:00","19.","2710000001","","","0","200000.000000000000000000000000000000","Cash In Hand","GOROHE/PAID TO SAROSH FOR GROHE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/2","","","2017-06-01 00:00:00","2","2610000042","","","44775.000000000000000000000000000000","0","CERAMICS","CHEQUE PAID TO SUNNY CERAMICS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/2.","","","2017-06-01 00:00:00","2.","2710000001","","","0","44775.000000000000000000000000000000","Cash In Hand","/CHEQUE PAID TO SUNNY CERAMICS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/20","","","2017-06-01 00:00:00","20","4010000003","","","400.000000000000000000000000000000","0","OTHER EXPENSES","PAID TO PLUMBER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/20.","","","2017-06-01 00:00:00","20.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PAID TO PLUMBER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/21","","","2017-06-01 00:00:00","21","4010000001","","","600.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PAID FOR FUEL + FOOD TO LABOUR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/21.","","","2017-06-01 00:00:00","21.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","ENTERTAINMENT EXPENSES/PAID FOR FUEL + FOOD TO LABOUR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/22","","","2017-06-01 00:00:00","22","4010000006","","","180.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO AWAIS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/22.","","","2017-06-01 00:00:00","22.","2710000001","","","0","180.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO AWAIS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/23","","","2017-06-01 00:00:00","23","4010000003","","","1000.000000000000000000000000000000","0","OTHER EXPENSES","PAID TO HAMEED FOR HINGES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/23.","","","2017-06-01 00:00:00","23.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PAID TO HAMEED FOR HINGES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/3","","","2017-06-01 00:00:00","3","1310000036","","","70400.000000000000000000000000000000","0","CANON","PAID TO CANON BK BILL NO 6709","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/3.","","","2017-06-01 00:00:00","3.","2710000001","","","0","70400.000000000000000000000000000000","Cash In Hand","CANON/PAID TO CANON BK BILL NO 6709","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/4","","","2017-06-01 00:00:00","4","1910000031","","","5000.000000000000000000000000000000","0","SALARY PAYABLE WAQAS","ADV SALARY TO WAQAS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/4.","","","2017-06-01 00:00:00","4.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE WAQAS/ADV SALARY TO WAQAS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/5","","","2017-06-01 00:00:00","5","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO IBRAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/5.","","","2017-06-01 00:00:00","5.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO IBRAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/6","","","2017-06-01 00:00:00","6","0100020005","","","10000.000000000000000000000000000000","0","SHEIKH SALEEM","PAID LABOUR TO SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/6.","","","2017-06-01 00:00:00","6.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","SHEIKH SALEEM/PAID LABOUR TO SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/7","","","2017-06-01 00:00:00","7","0100020005","","","10000.000000000000000000000000000000","0","SHEIKH SALEEM","PAID TO SALEEM FOR HINGES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/7.","","","2017-06-01 00:00:00","7.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","SHEIKH SALEEM/PAID TO SALEEM FOR HINGES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/8","","","2017-06-01 00:00:00","8","1310000008","","","5000.000000000000000000000000000000","0","DIAMOND","PAID TO DIAMOND JAMBO LOAN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/8.","","","2017-06-01 00:00:00","8.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","DIAMOND/PAID TO DIAMOND JAMBO LOAN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/9","","","2017-06-01 00:00:00","9","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070001/9.","","","2017-06-01 00:00:00","9.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/1","","","2017-06-02 00:00:00","1","2610000043","","","100000.000000000000000000000000000000","0","HOME TECH","CASH PAID TO BATH TECH AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/1.","","","2017-06-02 00:00:00","1.","2710000001","","","0","100000.000000000000000000000000000000","Cash In Hand","/CASH PAID TO BATH TECH AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/10","","","2017-06-02 00:00:00","10","4010000009","","","16000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/10.","","","2017-06-02 00:00:00","10.","2710000001","","","0","16000.000000000000000000000000000000","Cash In Hand","CHARITY PAID/ZAKAT PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/11","","","2017-06-02 00:00:00","11","4010000010","","","1000.000000000000000000000000000000","0","LABOUR PAYABLE","LABOUR PAID TO USMAN PLUMBER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/11.","","","2017-06-02 00:00:00","11.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","LABOUR PAYABLE/LABOUR PAID TO USMAN PLUMBER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/12","","","2017-06-02 00:00:00","12","4010000010","","","20000.000000000000000000000000000000","0","LABOUR PAYABLE","LABOUR PAID TO SALEEM FACTORY FOR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/12.","","","2017-06-02 00:00:00","12.","2710000001","","","0","20000.000000000000000000000000000000","Cash In Hand","LABOUR PAYABLE/LABOUR PAID TO SALEEM FACTORY FOR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/13","","","2017-06-02 00:00:00","13","1310000011","","","30300.000000000000000000000000000000","0","AL-HARMAIN PAINT CENTRE","CASH + CHEQUE PAID TO ALHARAM PAINT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/13.","","","2017-06-02 00:00:00","13.","2710000001","","","0","30300.000000000000000000000000000000","Cash In Hand","AL-HARMAIN PAINT CENTRE/CASH + CHEQUE PAID TO ALHARAM PAINT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/14","","","2017-06-02 00:00:00","14","4010000010","","","7920.000000000000000000000000000000","0","LABOUR PAYABLE","PAID LABOUR TO ZULIFQAR BILL NO 8846","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/14.","","","2017-06-02 00:00:00","14.","2710000001","","","0","7920.000000000000000000000000000000","Cash In Hand","LABOUR PAYABLE/PAID LABOUR TO ZULIFQAR BILL NO 8846","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/15","","","2017-06-02 00:00:00","15","4010000010","","","2200.000000000000000000000000000000","0","LABOUR PAYABLE","PAID FOR WATER PIPE AND LABOUR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/15.","","","2017-06-02 00:00:00","15.","2710000001","","","0","2200.000000000000000000000000000000","Cash In Hand","LABOUR PAYABLE/PAID FOR WATER PIPE AND LABOUR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/16","","","2017-06-02 00:00:00","16","1310000018","","","79000.000000000000000000000000000000","0","KBS","CASH PAID TO KBS AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/16.","","","2017-06-02 00:00:00","16.","2710000001","","","0","79000.000000000000000000000000000000","Cash In Hand","KBS/CASH PAID TO KBS AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/17","","","2017-06-02 00:00:00","17","1310000018","","","365700.000000000000000000000000000000","0","KBS","3 CHEQUE PAID TO KBS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/17.","","","2017-06-02 00:00:00","17.","2710000001","","","0","365700.000000000000000000000000000000","Cash In Hand","KBS/3 CHEQUE PAID TO KBS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/18","","","2017-06-02 00:00:00","18","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/18.","","","2017-06-02 00:00:00","18.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","CHARITY PAID/ZAKAT PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/19","","","2017-06-02 00:00:00","19","4010000004","","","2400.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/19.","","","2017-06-02 00:00:00","19.","2710000001","","","0","2400.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/2","","","2017-06-02 00:00:00","2","1310000037","","","100000.000000000000000000000000000000","0","AMJAD GUJRANWALA","CASH ONLINE TO AMJAD GUJRANWALA AGAINST CHEQUE ONLINE TO VECTOR LOGISTICS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/2.","","","2017-06-02 00:00:00","2.","2710000001","","","0","100000.000000000000000000000000000000","Cash In Hand","AMJAD GUJRANWALA/CASH ONLINE TO AMJAD GUJRANWALA AGAINST CHEQUE ONLINE TO VECTOR LOGISTICS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/20","","","2017-06-02 00:00:00","20","4010000003","","","1000.000000000000000000000000000000","0","OTHER EXPENSES","PAID TO IMRAN PAINT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/20.","","","2017-06-02 00:00:00","20.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PAID TO IMRAN PAINT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/21","","","2017-06-02 00:00:00","21","4010000006","","","80.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO IBRAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/21.","","","2017-06-02 00:00:00","21.","2710000001","","","0","80.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO IBRAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/22","","","2017-06-02 00:00:00","22","1910000031","","","5000.000000000000000000000000000000","0","SALARY PAYABLE WAQAS","ADV SALARY TO WAQAS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/22.","","","2017-06-02 00:00:00","22.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE WAQAS/ADV SALARY TO WAQAS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/23","","","2017-06-02 00:00:00","23","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","FUEL PAID TO WALEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/23.","","","2017-06-02 00:00:00","23.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","Fuel Expenses/FUEL PAID TO WALEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/24","","","2017-06-02 00:00:00","24","4010000004","","","3000.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO AMEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/24.","","","2017-06-02 00:00:00","24.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO AMEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/25","","","2017-06-02 00:00:00","25","4010000003","","","3500.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASED HINGES FOR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/25.","","","2017-06-02 00:00:00","25.","2710000001","","","0","3500.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PURCHASED HINGES FOR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/26","","","2017-06-02 00:00:00","26","1910000002","","","5000.000000000000000000000000000000","0","SALARY PAYABLE Sarosh Ch","ADV SALARY TO SAROSH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/26.","","","2017-06-02 00:00:00","26.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Sarosh Ch/ADV SALARY TO SAROSH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/27","","","2017-06-02 00:00:00","27","1310000038","","","20000.000000000000000000000000000000","0","GODI COMMODE","CASH PAID TO GODI COMMODE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/27.","","","2017-06-02 00:00:00","27.","2710000001","","","0","20000.000000000000000000000000000000","Cash In Hand","GODI COMMODE/CASH PAID TO GODI COMMODE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/28","","","2017-06-02 00:00:00","28","2610000001","","","8000.000000000000000000000000000000","0","Walk-In-Customers","DIRECT DEPOSITEDD IN BANK CC SALE BILL NO","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/28.","","","2017-06-02 00:00:00","28.","2710000001","","","0","8000.000000000000000000000000000000","Cash In Hand","Walk-In-Customers/DIRECT DEPOSITEDD IN BANK CC SALE BILL NO","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/3","","","2017-06-02 00:00:00","3","1910000014","","","5000.000000000000000000000000000000","0","SALARY PAYABLE Hameed","ADV SALARY TO HAMEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/3.","","","2017-06-02 00:00:00","3.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Hameed/ADV SALARY TO HAMEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/4","","","2017-06-02 00:00:00","4","1310000015","","","55500.000000000000000000000000000000","0","MAHMOOD GUJRANWALA","CASH ONLINE TO MAHMOOD GUJRANWALA AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/4.","","","2017-06-02 00:00:00","4.","2710000001","","","0","55500.000000000000000000000000000000","Cash In Hand","MAHMOOD GUJRANWALA/CASH ONLINE TO MAHMOOD GUJRANWALA AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/5","","","2017-06-02 00:00:00","5","0100020002","","","95000.000000000000000000000000000000","0","Waseem Sb","LOAN RETURNED TO WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/5.","","","2017-06-02 00:00:00","5.","2710000001","","","0","95000.000000000000000000000000000000","Cash In Hand","Waseem Sb/LOAN RETURNED TO WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/6","","","2017-06-02 00:00:00","6","1910000021","","","1000.000000000000000000000000000000","0","SALARY PAYABLE QUEEM","ADV SALARY TO QUEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/6.","","","2017-06-02 00:00:00","6.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE QUEEM/ADV SALARY TO QUEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/7","","","2017-06-02 00:00:00","7","4010000004","","","12000.000000000000000000000000000000","0","Travelling Expenses","CASH PAID TO AMEEN FOR MIRRORS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/7.","","","2017-06-02 00:00:00","7.","2710000001","","","0","12000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/CASH PAID TO AMEEN FOR MIRRORS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/8","","","2017-06-02 00:00:00","8","1310000022","","","6000.000000000000000000000000000000","0","ALLAH WASAYA","PAID TO ALLAH WASAYA FOR MIRRORS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/8.","","","2017-06-02 00:00:00","8.","2710000001","","","0","6000.000000000000000000000000000000","Cash In Hand","ALLAH WASAYA/PAID TO ALLAH WASAYA FOR MIRRORS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/9","","","2017-06-02 00:00:00","9","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070002/9.","","","2017-06-02 00:00:00","9.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/1","","","2017-06-03 00:00:00","1","4010000003","","","1500.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASED DORI AND TAPES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/1.","","","2017-06-03 00:00:00","1.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PURCHASED DORI AND TAPES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/10","","","2017-06-03 00:00:00","10","4010000004","","","500.000000000000000000000000000000","0","Travelling Expenses","RENT PAID STOCK FROM MARACHI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/10.","","","2017-06-03 00:00:00","10.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID STOCK FROM MARACHI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/11","","","2017-06-03 00:00:00","11","1310000017","","","80000.000000000000000000000000000000","0","GOROHE","CHEQUE PAID TO IMRAN GROHE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/11.","","","2017-06-03 00:00:00","11.","2710000001","","","0","80000.000000000000000000000000000000","Cash In Hand","GOROHE/CHEQUE PAID TO IMRAN GROHE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/12","","","2017-06-03 00:00:00","12","0100020001","","","5000.000000000000000000000000000000","0","Happy Malik Sb","PERSONAL HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/12.","","","2017-06-03 00:00:00","12.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Happy Malik Sb/PERSONAL HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/13","","","2017-06-03 00:00:00","13","0100020006","","","10000.000000000000000000000000000000","0","KHALID SB","PAID TO KHALID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/13.","","","2017-06-03 00:00:00","13.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","KHALID SB/PAID TO KHALID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/14","","","2017-06-03 00:00:00","14","4010000009","","","50.000000000000000000000000000000","0","CHARITY PAID","CHARITY PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/14.","","","2017-06-03 00:00:00","14.","2710000001","","","0","50.000000000000000000000000000000","Cash In Hand","CHARITY PAID/CHARITY PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/15","","","2017-06-03 00:00:00","15","4010000004","","","3000.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO SHEHZAD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/15.","","","2017-06-03 00:00:00","15.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO SHEHZAD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/16","","","2017-06-03 00:00:00","16","4010000009","","","1000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/16.","","","2017-06-03 00:00:00","16.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","CHARITY PAID/ZAKAT PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/17","","","2017-06-03 00:00:00","17","0100020002","","","5000.000000000000000000000000000000","0","Waseem Sb","PERSONAL WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/17.","","","2017-06-03 00:00:00","17.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Waseem Sb/PERSONAL WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/18","","","2017-06-03 00:00:00","18","4010000003","","","10000.000000000000000000000000000000","0","OTHER EXPENSES","CASH PAID TO IMRAN PAINT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/18.","","","2017-06-03 00:00:00","18.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/CASH PAID TO IMRAN PAINT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/19","","","2017-06-03 00:00:00","19","1310000017","","","10000.000000000000000000000000000000","0","GOROHE","CASH PAID TO RIZWAN FOR GROHE RAEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/19.","","","2017-06-03 00:00:00","19.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","GOROHE/CASH PAID TO RIZWAN FOR GROHE RAEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/2","","","2017-06-03 00:00:00","2","0100020004","","","2000.000000000000000000000000000000","0","FAROOQ SB","ADV RENT TO FAROOQ SB BK BILL NO 10441","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/2.","","","2017-06-03 00:00:00","2.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","FAROOQ SB/ADV RENT TO FAROOQ SB BK BILL NO 10441","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/20","","","2017-06-03 00:00:00","20","4010000004","","","2000.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO QAMAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/20.","","","2017-06-03 00:00:00","20.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO QAMAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/21","","","2017-06-03 00:00:00","21","0100020007","","","4000.000000000000000000000000000000","0","NADEEM SB","PAID TO NADEEM FOR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/21.","","","2017-06-03 00:00:00","21.","2710000001","","","0","4000.000000000000000000000000000000","Cash In Hand","NADEEM SB/PAID TO NADEEM FOR VANITIES","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/22","","","2017-06-03 00:00:00","22","2610000001","","","2900.000000000000000000000000000000","0","Walk-In-Customers","DIRECT DEPOSITED IN BANK CC SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/22.","","","2017-06-03 00:00:00","22.","2710000001","","","0","2900.000000000000000000000000000000","Cash In Hand","Walk-In-Customers/DIRECT DEPOSITED IN BANK CC SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/23","","","2017-06-03 00:00:00","23","4010000004","","","2000.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO AMEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/23.","","","2017-06-03 00:00:00","23.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID TO AMEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/24","","","2017-06-03 00:00:00","24","1910000031","","","5000.000000000000000000000000000000","0","SALARY PAYABLE WAQAS","SALARY PAID TO WAQAS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/24.","","","2017-06-03 00:00:00","24.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE WAQAS/SALARY PAID TO WAQAS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/25","","","2017-06-03 00:00:00","25","1910000006","","","6000.000000000000000000000000000000","0","SALARY PAYABLE Yaseen","SALARY PAID TO YASEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/25.","","","2017-06-03 00:00:00","25.","2710000001","","","0","6000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Yaseen/SALARY PAID TO YASEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/26","","","2017-06-03 00:00:00","26","1910000005","","","17000.000000000000000000000000000000","0","SALARY PAYABLE Hafiz Azeem","SALARY PAID TO HAFIZ AZEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/26.","","","2017-06-03 00:00:00","26.","2710000001","","","0","17000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Hafiz Azeem/SALARY PAID TO HAFIZ AZEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/27","","","2017-06-03 00:00:00","27","1910000017","","","8000.000000000000000000000000000000","0","SALARY PAYABLE Ashraf Paint","SALARY PAID TO ASHRAF","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/27.","","","2017-06-03 00:00:00","27.","2710000001","","","0","8000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Ashraf Paint/SALARY PAID TO ASHRAF","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/28","","","2017-06-03 00:00:00","28","1910000002","","","10000.000000000000000000000000000000","0","SALARY PAYABLE Sarosh Ch","ADV SALARY TO SAROSH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/28.","","","2017-06-03 00:00:00","28.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Sarosh Ch/ADV SALARY TO SAROSH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/29","","","2017-06-03 00:00:00","29","1910000013","","","9000.000000000000000000000000000000","0","SALARY PAYABLE Faisal Zia","ADV SALARY TO FAISAL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/29.","","","2017-06-03 00:00:00","29.","2710000001","","","0","9000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE Faisal Zia/ADV SALARY TO FAISAL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/3","","","2017-06-03 00:00:00","3","0100020004","","","5000.000000000000000000000000000000","0","FAROOQ SB","ADV RENT TO FCAROOQ SB PAID BY WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/3.","","","2017-06-03 00:00:00","3.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","FAROOQ SB/ADV RENT TO FCAROOQ SB PAID BY WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/30","","","2017-06-03 00:00:00","30","1310000002","","","20000.000000000000000000000000000000","0","Porta Acrylic Bath Tubs Lahore","PAID TO PORTA TUB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/30.","","","2017-06-03 00:00:00","30.","2710000001","","","0","20000.000000000000000000000000000000","Cash In Hand","Porta Acrylic Bath Tubs Lahore/PAID TO PORTA TUB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/31","","","2017-06-03 00:00:00","31","1310000040","","","10000.000000000000000000000000000000","0","ANSARI PLASTIC","CASH PAID TO ANSARI PLASTIC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/31.","","","2017-06-03 00:00:00","31.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/CASH PAID TO ANSARI PLASTIC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/32","","","2017-06-03 00:00:00","32","1310000041","","","50000.000000000000000000000000000000","0","ASIAN STANDERED","CASH PAID TO ASIAN STANDERED AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/32.","","","2017-06-03 00:00:00","32.","2710000001","","","0","50000.000000000000000000000000000000","Cash In Hand","/CASH PAID TO ASIAN STANDERED AGAINST CHEQUE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/33","","","2017-06-03 00:00:00","33","1310000042","","","400000.000000000000000000000000000000","0","LEXTA","4 CHEQUE PAID TO LEXTA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/33.","","","2017-06-03 00:00:00","33.","2710000001","","","0","400000.000000000000000000000000000000","Cash In Hand","/4 CHEQUE PAID TO LEXTA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/34","","","2017-06-03 00:00:00","34","1310000043","","","150000.000000000000000000000000000000","0","SHEN CHINEESE","CASH PAID TO SHEN CHINEESE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/34.","","","2017-06-03 00:00:00","34.","2710000001","","","0","150000.000000000000000000000000000000","Cash In Hand","/CASH PAID TO SHEN CHINEESE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/35","","","2017-06-03 00:00:00","35","1910000034","","","9000.000000000000000000000000000000","0","SALARY PAYABLE WALEED","SALARY PAID TO WALEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/35.","","","2017-06-03 00:00:00","35.","2710000001","","","0","9000.000000000000000000000000000000","Cash In Hand","/SALARY PAID TO WALEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/36","","","2017-06-03 00:00:00","36","1910000032","","","1000.000000000000000000000000000000","0","SALARY PAYABLE JAMEEL","SALARY PAID TO JAMEEL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/36.","","","2017-06-03 00:00:00","36.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/SALARY PAID TO JAMEEL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/37","","","2017-06-03 00:00:00","37","1910000033","","","2000.000000000000000000000000000000","0","SALARY PAYABLE TANVEER","SALARY PAID TO TANVEER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/37.","","","2017-06-03 00:00:00","37.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/SALARY PAID TO TANVEER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/38","","","2017-06-03 00:00:00","38","1910000035","","","500.000000000000000000000000000000","0","SALARY PAYABLE AMJAD","ADV SALARY TO AMJAD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/38.","","","2017-06-03 00:00:00","38.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/ADV SALARY TO AMJAD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/4","","","2017-06-03 00:00:00","4","4010000004","","","350.000000000000000000000000000000","0","Travelling Expenses","RENT PAID STOCK FROM ASHFAQ ACCESSORY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/4.","","","2017-06-03 00:00:00","4.","2710000001","","","0","350.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID STOCK FROM ASHFAQ ACCESSORY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/5","","","2017-06-03 00:00:00","5","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASED AIR FRESHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/5.","","","2017-06-03 00:00:00","5.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","OTHER EXPENSES/PURCHASED AIR FRESHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/6","","","2017-06-03 00:00:00","6","1310000003","","","10000.000000000000000000000000000000","0","TREND BATHROOM ACCESSORIES","CASH PAID TO TREND ACCESSORY SET","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/6.","","","2017-06-03 00:00:00","6.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","TREND BATHROOM ACCESSORIES/CASH PAID TO TREND ACCESSORY SET","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/7","","","2017-06-03 00:00:00","7","0100020004","","","2000.000000000000000000000000000000","0","FAROOQ SB","ADV RENT TO FAROOQ SB MOBILE BILL PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/7.","","","2017-06-03 00:00:00","7.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","FAROOQ SB/ADV RENT TO FAROOQ SB MOBILE BILL PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/8","","","2017-06-03 00:00:00","8","4010000010","","","5060.000000000000000000000000000000","0","LABOUR PAYABLE","PAID LABOUR TO ZULIFQAR BILL NO 8849","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/8.","","","2017-06-03 00:00:00","8.","2710000001","","","0","5060.000000000000000000000000000000","Cash In Hand","LABOUR PAYABLE/PAID LABOUR TO ZULIFQAR BILL NO 8849","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/9","","","2017-06-03 00:00:00","9","4010000004","","","350.000000000000000000000000000000","0","Travelling Expenses","RENT PAID STPCK FROM IMRAN GROHE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01CP070003/9.","","","2017-06-03 00:00:00","9.","2710000001","","","0","350.000000000000000000000000000000","Cash In Hand","Travelling Expenses/RENT PAID STPCK FROM IMRAN GROHE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01JV070001/1","","","2017-05-31 00:00:00","1","2710000001","","","443929.000000000000000000000000000000","0","Cash In Hand","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01JV070001/2","","","2017-05-31 00:00:00","2","0100010001","","","0","443929.000000000000000000000000000000","OPENING BALANCES","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01JV070002/1","","","2017-07-01 00:00:00","1","2610000001","","","42000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6758 / Return Adjustment bill no 6758","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01JV070002/2","","","2017-07-01 00:00:00","2","2610000001","","","0","52100.000000000000000000000000000000","Walk-In-Customers","Bill#6758 / Return Adjustment bill no 6758","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01JV070002/3","","","2017-07-01 00:00:00","3","2610000001","","","10100.000000000000000000000000000000","0","Walk-In-Customers","Bill#6758 / BALANCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070001/1","","","2017-06-01 00:00:00","1","2210000001","","","4343.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070001/2","","","2017-06-01 00:00:00","2","1310000028","","","0","4343.000000000000000000000000000000","MAHMOOD SONS","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070001/3","","","2017-06-01 00:00:00","3","1310000028","","","4190.000000000000000000000000000000","0","MAHMOOD SONS","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070001/4","","","2017-06-01 00:00:00","4","2710000001","","","0","4190.000000000000000000000000000000","Cash In Hand","Purchase From MAHMOOD SONS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070002/1","","","2017-06-02 00:00:00","1","2210000001","","","8778.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070002/2","","","2017-06-02 00:00:00","2","1310000028","","","0","8778.000000000000000000000000000000","MAHMOOD SONS","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070002/3","","","2017-06-02 00:00:00","3","1310000028","","","8470.000000000000000000000000000000","0","MAHMOOD SONS","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070002/4","","","2017-06-02 00:00:00","4","2710000001","","","0","8470.000000000000000000000000000000","Cash In Hand","Purchase From MAHMOOD SONS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070003/1","","","2017-06-02 00:00:00","1","2210000001","","","10850.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070003/2","","","2017-06-02 00:00:00","2","1310000028","","","0","10850.000000000000000000000000000000","MAHMOOD SONS","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070003/3","","","2017-06-02 00:00:00","3","1310000028","","","8900.000000000000000000000000000000","0","MAHMOOD SONS","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070003/4","","","2017-06-02 00:00:00","4","2710000001","","","0","8900.000000000000000000000000000000","Cash In Hand","Purchase From MAHMOOD SONS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070004/1","","","2017-06-02 00:00:00","1","2210000001","","","79564.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070004/2","","","2017-06-02 00:00:00","2","1310000039","","","0","79564.000000000000000000000000000000","NATURE","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070004/3","","","2017-06-02 00:00:00","3","1310000039","","","79564.000000000000000000000000000000","0","NATURE","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070004/4","","","2017-06-02 00:00:00","4","2710000001","","","0","79564.000000000000000000000000000000","Cash In Hand","Purchase From NATURE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070005/1","","","2017-07-14 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01PL070005/2","","","2017-07-14 00:00:00","2","1310000044","","","0","0","MARACHI","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01RT070001/1","","","2017-06-01 00:00:00","1","3010000001","","","2000.000000000000000000000000000000","0","Turnover","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01RT070001/4","","","2017-06-01 00:00:00","4","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01RT070002/1","","","2017-06-02 00:00:00","1","3010000001","","","8000.000000000000000000000000000000","0","Turnover","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01RT070002/4","","","2017-06-02 00:00:00","4","2710000001","","","0","8000.000000000000000000000000000000","Cash In Hand","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01RT070003/1","","","2017-07-01 00:00:00","1","3010000001","","","4000.000000000000000000000000000000","0","Turnover","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01RT070004/1","","","2017-07-01 00:00:00","1","3010000001","","","42000.000000000000000000000000000000","0","Turnover","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070001/1","","","2017-07-01 00:00:00","1","2610000001","","","31500.000000000000000000000000000000","0","Walk-In-Customers","Bill#6765","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070001/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","0","Turnover","Bill#6765","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070001/2","","","2017-07-01 00:00:00","2","2710000001","","","31500.000000000000000000000000000000","0","Cash In Hand","Bill#6765 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070001/3","","","2017-07-01 00:00:00","3","2610000001","","","0","31500.000000000000000000000000000000","Walk-In-Customers","Bill#6765 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070002/1","","","2017-07-01 00:00:00","1","2610000072","","","29000.000000000000000000000000000000","0","WASEEM SB 539/G PH#5 DHA","Bill#6766","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070002/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","550.000000000000000000000000000000","Turnover","Bill#6766","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070002/2.","","","2017-07-01 00:00:00","2.","3010000010","","","550.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070002/3","","","2017-07-01 00:00:00","3","2710000001","","","29000.000000000000000000000000000000","0","Cash In Hand","Bill#6766 / Received From Sale To  WASEEM SB 539/G PH#5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070002/4","","","2017-07-01 00:00:00","4","2610000072","","","0","29000.000000000000000000000000000000","WASEEM SB 539/G PH#5 DHA","Bill#6766 / Received From Sale To  WASEEM SB 539/G PH#5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070003/1","","","2017-07-10 00:00:00","1","2610000001","","","14000.000000000000000000000000000000","0","Walk-In-Customers","Bill#4756","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070003/1.","","","2017-07-10 00:00:00","1.","3010000001","","","0","950.000000000000000000000000000000","Turnover","Bill#4756","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070003/2.","","","2017-07-10 00:00:00","2.","3010000010","","","400.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070003/3","","","2017-07-10 00:00:00","3","2710000001","","","14000.000000000000000000000000000000","0","Cash In Hand","Bill#4756 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070003/4","","","2017-07-10 00:00:00","4","2610000001","","","0","14000.000000000000000000000000000000","Walk-In-Customers","Bill#4756 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070004/1","","","2017-07-01 00:00:00","1","2610000001","","","15320.000000000000000000000000000000","0","Walk-In-Customers","Bill#6767","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070004/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","950.000000000000000000000000000000","Turnover","Bill#6767","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070004/2","","","2017-07-01 00:00:00","2","2710000001","","","15320.000000000000000000000000000000","0","Cash In Hand","Bill#6767 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070004/3","","","2017-07-01 00:00:00","3","2610000001","","","0","15320.000000000000000000000000000000","Walk-In-Customers","Bill#6767 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070005/1","","","2017-07-01 00:00:00","1","2610000001","","","2500.000000000000000000000000000000","0","Walk-In-Customers","Bill#6770","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070005/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","1450.000000000000000000000000000000","Turnover","Bill#6770","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070005/2.","","","2017-07-01 00:00:00","2.","3010000010","","","500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070005/3","","","2017-07-01 00:00:00","3","2710000001","","","2500.000000000000000000000000000000","0","Cash In Hand","Bill#6770 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070005/4","","","2017-07-01 00:00:00","4","2610000001","","","0","2500.000000000000000000000000000000","Walk-In-Customers","Bill#6770 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070006/1","","","2017-07-01 00:00:00","1","2610000074","","","60000.000000000000000000000000000000","0","MR. SHAHID 0300 5865466","Bill#6771","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070006/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","5400.000000000000000000000000000000","Turnover","Bill#6771","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070006/2.","","","2017-07-01 00:00:00","2.","3010000010","","","3950.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070006/3","","","2017-07-01 00:00:00","3","2710000001","","","60000.000000000000000000000000000000","0","Cash In Hand","Bill#6771 / Received From Sale To  MR. SHAHID 0300 5865466","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070006/4","","","2017-07-01 00:00:00","4","2610000074","","","0","60000.000000000000000000000000000000","MR. SHAHID 0300 5865466","Bill#6771 / Received From Sale To  MR. SHAHID 0300 5865466","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070007/1","","","2017-07-01 00:00:00","1","2610000001","","","41000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6764","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070007/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","5400.000000000000000000000000000000","Turnover","Bill#6764","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070007/2","","","2017-07-01 00:00:00","2","2710000001","","","41000.000000000000000000000000000000","0","Cash In Hand","Bill#6764 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070007/3","","","2017-07-01 00:00:00","3","2610000001","","","0","41000.000000000000000000000000000000","Walk-In-Customers","Bill#6764 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070008/1","","","2017-07-01 00:00:00","1","2610000001","","","9500.000000000000000000000000000000","0","Walk-In-Customers","Bill#6763","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070008/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","5400.000000000000000000000000000000","Turnover","Bill#6763","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070008/2","","","2017-07-01 00:00:00","2","2710000001","","","9500.000000000000000000000000000000","0","Cash In Hand","Bill#6763 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070008/3","","","2017-07-01 00:00:00","3","2610000001","","","0","9500.000000000000000000000000000000","Walk-In-Customers","Bill#6763 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070009/1","","","2017-07-01 00:00:00","1","2610000001","","","1000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6762","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070009/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","5400.000000000000000000000000000000","Turnover","Bill#6762","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070009/2","","","2017-07-01 00:00:00","2","2710000001","","","1000.000000000000000000000000000000","0","Cash In Hand","Bill#6762 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070009/3","","","2017-07-01 00:00:00","3","2610000001","","","0","1000.000000000000000000000000000000","Walk-In-Customers","Bill#6762 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070010/1","","","2017-07-01 00:00:00","1","2610000001","","","149000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6761","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070010/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","5400.000000000000000000000000000000","Turnover","Bill#6761","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070010/2","","","2017-07-01 00:00:00","2","2710000001","","","149000.000000000000000000000000000000","0","Cash In Hand","Bill#6761 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070010/3","","","2017-07-01 00:00:00","3","2610000001","","","0","149000.000000000000000000000000000000","Walk-In-Customers","Bill#6761 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070011/1","","","2017-07-01 00:00:00","1","2610000001","","","8000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6760","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070011/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","6400.000000000000000000000000000000","Turnover","Bill#6760","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070011/2.","","","2017-07-01 00:00:00","2.","3010000010","","","1000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070011/3","","","2017-07-01 00:00:00","3","2710000001","","","8000.000000000000000000000000000000","0","Cash In Hand","Bill#6760 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070011/4","","","2017-07-01 00:00:00","4","2610000001","","","0","8000.000000000000000000000000000000","Walk-In-Customers","Bill#6760 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070012/1","","","2017-07-01 00:00:00","1","2610000001","","","18000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6757","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070012/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","7300.000000000000000000000000000000","Turnover","Bill#6757","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070012/2.","","","2017-07-01 00:00:00","2.","3010000010","","","900.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070012/3","","","2017-07-01 00:00:00","3","2710000001","","","18000.000000000000000000000000000000","0","Cash In Hand","Bill#6757 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070012/4","","","2017-07-01 00:00:00","4","2610000001","","","0","18000.000000000000000000000000000000","Walk-In-Customers","Bill#6757 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070013/1","","","2017-07-01 00:00:00","1","2610000001","","","52100.000000000000000000000000000000","0","Walk-In-Customers","Bill#6758","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070013/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","7300.000000000000000000000000000000","Turnover","Bill#6758","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070014/1","","","2017-07-01 00:00:00","1","2610000001","","","1000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6772","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070014/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","7300.000000000000000000000000000000","Turnover","Bill#6772","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070014/2","","","2017-07-01 00:00:00","2","2710000001","","","1000.000000000000000000000000000000","0","Cash In Hand","Bill#6772 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070014/3","","","2017-07-01 00:00:00","3","2610000001","","","0","1000.000000000000000000000000000000","Walk-In-Customers","Bill#6772 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070015/1","","","2017-07-03 00:00:00","1","2610000001","","","7000.000000000000000000000000000000","0","Walk-In-Customers","Bill#6774","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070015/1.","","","2017-07-03 00:00:00","1.","3010000001","","","0","7300.000000000000000000000000000000","Turnover","Bill#6774","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070015/2","","","2017-07-03 00:00:00","2","2710000001","","","7000.000000000000000000000000000000","0","Cash In Hand","Bill#6774 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","01SL070015/3","","","2017-07-03 00:00:00","3","2610000001","","","0","7000.000000000000000000000000000000","Walk-In-Customers","Bill#6774 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","","","","2017-07-10 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("01","","","","2017-07-14 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/1","","","2017-06-01 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/1.","","","2017-06-01 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/10","","","2017-06-01 00:00:00","10","4010000009","","","1000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/10.","","","2017-06-01 00:00:00","10.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/11","","","2017-06-01 00:00:00","11","4010000010","","","300.000000000000000000000000000000","0","LABOUR PAYABLE","LABOUR PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/11.","","","2017-06-01 00:00:00","11.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/LABOUR PAID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/12","","","2017-06-01 00:00:00","12","4010000003","","","170.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE FOR WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/12.","","","2017-06-01 00:00:00","12.","2710000001","","","0","170.000000000000000000000000000000","Cash In Hand","/PURCHASE FOR WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/13","","","2017-06-01 00:00:00","13","4010000003","","","1000.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE SURF","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/13.","","","2017-06-01 00:00:00","13.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/PURCHASE SURF","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/2","","","2017-06-01 00:00:00","2","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","PAID FOR SALEEM B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/2.","","","2017-06-01 00:00:00","2.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID FOR SALEEM B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/3","","","2017-06-01 00:00:00","3","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 2 DAYS RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/3.","","","2017-06-01 00:00:00","3.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 2 DAYS RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/4","","","2017-06-01 00:00:00","4","4010000006","","","2000.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR SAJIDE THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/4.","","","2017-06-01 00:00:00","4.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/PETROL FOR SAJIDE THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/5","","","2017-06-01 00:00:00","5","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","CASH PAID TO WASEEM SB FOR B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/5.","","","2017-06-01 00:00:00","5.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CASH PAID TO WASEEM SB FOR B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/6","","","2017-06-01 00:00:00","6","2620000001","","","100000.000000000000000000000000000000","0","Bath & Kitchen","PAID FOR B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/6.","","","2017-06-01 00:00:00","6.","2710000001","","","0","100000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID FOR B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/7","","","2017-06-01 00:00:00","7","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","MONTHLY CHARITY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/7.","","","2017-06-01 00:00:00","7.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/MONTHLY CHARITY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/8","","","2017-06-01 00:00:00","8","2620000001","","","5000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO JAMBO LON B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/8.","","","2017-06-01 00:00:00","8.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO JAMBO LON B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/9","","","2017-06-01 00:00:00","9","4010000003","","","2000.000000000000000000000000000000","0","OTHER EXPENSES","PAID CASH TO HASEEB FOR FLAKS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060001/9.","","","2017-06-01 00:00:00","9.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/PAID CASH TO HASEEB FOR FLAKS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/1","","","2017-06-02 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/1.","","","2017-06-02 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/2","","","2017-06-02 00:00:00","2","4010000004","","","400.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTMORE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/2.","","","2017-06-02 00:00:00","2.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/RENT CUSTMORE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/3","","","2017-06-02 00:00:00","3","4010000006","","","500.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/3.","","","2017-06-02 00:00:00","3.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/4","","","2017-06-02 00:00:00","4","4010000009","","","5000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/4.","","","2017-06-02 00:00:00","4.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/5","","","2017-06-02 00:00:00","5","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","AIR FRESHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/5.","","","2017-06-02 00:00:00","5.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/AIR FRESHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/6","","","2017-06-02 00:00:00","6","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/6.","","","2017-06-02 00:00:00","6.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/7","","","2017-06-02 00:00:00","7","2620000001","","","5000.000000000000000000000000000000","0","Bath & Kitchen","CASH PAID TO NADEEM B&amp;K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/7.","","","2017-06-02 00:00:00","7.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CASH PAID TO NADEEM B&amp;K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/8","","","2017-06-02 00:00:00","8","1910000001","","","16000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","SALARY PAID TO SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/8.","","","2017-06-02 00:00:00","8.","2710000001","","","0","16000.000000000000000000000000000000","Cash In Hand","/SALARY PAID TO SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/9","","","2017-06-02 00:00:00","9","4010000003","","","2500.000000000000000000000000000000","0","OTHER EXPENSES","CASH PAID TO HASEEB SB CARD PRINTING PERFACT HOME","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060002/9.","","","2017-06-02 00:00:00","9.","2710000001","","","0","2500.000000000000000000000000000000","Cash In Hand","/CASH PAID TO HASEEB SB CARD PRINTING PERFACT HOME","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/1","","","2017-06-03 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/1.","","","2017-06-03 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/10","","","2017-06-03 00:00:00","10","4010000004","","","1900.000000000000000000000000000000","0","Travelling Expenses","RENT PAY SALEEM CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/10.","","","2017-06-03 00:00:00","10.","2710000001","","","0","1900.000000000000000000000000000000","Cash In Hand","/RENT PAY SALEEM CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/11","","","2017-06-03 00:00:00","11","4010000004","","","1500.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER PIKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/11.","","","2017-06-03 00:00:00","11.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER PIKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/12","","","2017-06-03 00:00:00","12","1910000028","","","2000.000000000000000000000000000000","0","SALARY PAYABLE MURTAZA","BALANCE SALARY MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/12.","","","2017-06-03 00:00:00","12.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE MURTAZA/BALANCE SALARY MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/13","","","2017-06-03 00:00:00","13","1910000029","","","3000.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","BALANCE SALARY TAYYAB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/13.","","","2017-06-03 00:00:00","13.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/BALANCE SALARY TAYYAB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/14","","","2017-06-03 00:00:00","14","0100020008","","","25000.000000000000000000000000000000","0","SAJED SB","PAID FOR SAJED SB AGNEST HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/14.","","","2017-06-03 00:00:00","14.","2710000001","","","0","25000.000000000000000000000000000000","Cash In Hand","SAJED SB/PAID FOR SAJED SB AGNEST HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/15","","","2017-06-03 00:00:00","15","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE CLENARE 5 PEC BOTAL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/15.","","","2017-06-03 00:00:00","15.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/PURCHASE CLENARE 5 PEC BOTAL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/2","","","2017-06-03 00:00:00","2","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/2.","","","2017-06-03 00:00:00","2.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/3","","","2017-06-03 00:00:00","3","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT PAY SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/3.","","","2017-06-03 00:00:00","3.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/RENT PAY SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/4","","","2017-06-03 00:00:00","4","1910000003","","","10000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","SALARY PAID RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/4.","","","2017-06-03 00:00:00","4.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/SALARY PAID RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/5","","","2017-06-03 00:00:00","5","4010000003","","","37700.000000000000000000000000000000","0","OTHER EXPENSES","PAID TO HASEEB FOR WALPAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/5.","","","2017-06-03 00:00:00","5.","2710000001","","","0","37700.000000000000000000000000000000","Cash In Hand","/PAID TO HASEEB FOR WALPAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/6","","","2017-06-03 00:00:00","6","4010000009","","","1500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/6.","","","2017-06-03 00:00:00","6.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/7","","","2017-06-03 00:00:00","7","1910000027","","","6000.000000000000000000000000000000","0","SALARY PAYABLE NASIR","BALANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/7.","","","2017-06-03 00:00:00","7.","2710000001","","","0","6000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/BALANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/8","","","2017-06-03 00:00:00","8","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXPENS MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/8.","","","2017-06-03 00:00:00","8.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/IFTAR EXPENS MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/9","","","2017-06-03 00:00:00","9","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARIDE CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060003/9.","","","2017-06-03 00:00:00","9.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARIDE CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/1","","","2017-06-05 00:00:00","1","4010000009","","","1000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/1.","","","2017-06-05 00:00:00","1.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/10","","","2017-06-05 00:00:00","10","4010000004","","","400.000000000000000000000000000000","0","Travelling Expenses","RENT FOR SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/10.","","","2017-06-05 00:00:00","10.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/RENT FOR SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/11","","","2017-06-05 00:00:00","11","4010000009","","","1800.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/11.","","","2017-06-05 00:00:00","11.","2710000001","","","0","1800.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/2","","","2017-06-05 00:00:00","2","4010000006","","","500.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GARNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/2.","","","2017-06-05 00:00:00","2.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/PETROL FOR GARNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/3","","","2017-06-05 00:00:00","3","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP TAYYAB 5 DAYS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/3.","","","2017-06-05 00:00:00","3.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/IFTAR EXP TAYYAB 5 DAYS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/4","","","2017-06-05 00:00:00","4","0100020007","","","5000.000000000000000000000000000000","0","NADEEM SB","PAID COMMISION NADEEM THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/4.","","","2017-06-05 00:00:00","4.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","/PAID COMMISION NADEEM THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/5","","","2017-06-05 00:00:00","5","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/5.","","","2017-06-05 00:00:00","5.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/6","","","2017-06-05 00:00:00","6","4010000004","","","500.000000000000000000000000000000","0","Travelling Expenses","RENT FOR MUKHTAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/6.","","","2017-06-05 00:00:00","6.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/RENT FOR MUKHTAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/7","","","2017-06-05 00:00:00","7","4010000003","","","170.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/7.","","","2017-06-05 00:00:00","7.","2710000001","","","0","170.000000000000000000000000000000","Cash In Hand","/PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/8","","","2017-06-05 00:00:00","8","4010000009","","","500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/8.","","","2017-06-05 00:00:00","8.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/9","","","2017-06-05 00:00:00","9","4010000004","","","1100.000000000000000000000000000000","0","Travelling Expenses","RENT FOR SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060004/9.","","","2017-06-05 00:00:00","9.","2710000001","","","0","1100.000000000000000000000000000000","Cash In Hand","/RENT FOR SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/1","","","2017-06-06 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/1.","","","2017-06-06 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/2","","","2017-06-06 00:00:00","2","2620000001","","","36850.000000000000000000000000000000","0","Bath & Kitchen","PAID FOR B&amp;K MUBASHER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/2.","","","2017-06-06 00:00:00","2.","2710000001","","","0","36850.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID FOR B&amp;K MUBASHER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/3","","","2017-06-06 00:00:00","3","2620000001","","","13200.000000000000000000000000000000","0","Bath & Kitchen","PAID FOR B/K RETRN SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/3.","","","2017-06-06 00:00:00","3.","2710000001","","","0","13200.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID FOR B/K RETRN SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/4","","","2017-06-06 00:00:00","4","4010000006","","","400.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GARNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/4.","","","2017-06-06 00:00:00","4.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PETROL FOR GARNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/5","","","2017-06-06 00:00:00","5","4010000004","","","1200.000000000000000000000000000000","0","Travelling Expenses","RENT PEID FOR AMJAD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/5.","","","2017-06-06 00:00:00","5.","2710000001","","","0","1200.000000000000000000000000000000","Cash In Hand","/RENT PEID FOR AMJAD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/6","","","2017-06-06 00:00:00","6","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","PAID FOR B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/6.","","","2017-06-06 00:00:00","6.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID FOR B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/7","","","2017-06-06 00:00:00","7","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT PEID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/7.","","","2017-06-06 00:00:00","7.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/RENT PEID TO IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/8","","","2017-06-06 00:00:00","8","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXPENS TO CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060005/8.","","","2017-06-06 00:00:00","8.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/IFTAR EXPENS TO CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/1","","","2017-06-07 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003+RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/1.","","","2017-06-07 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003+RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/10","","","2017-06-07 00:00:00","10","4010000003","","","50.000000000000000000000000000000","0","OTHER EXPENSES","PHOTO COPY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/10.","","","2017-06-07 00:00:00","10.","2710000001","","","0","50.000000000000000000000000000000","Cash In Hand","/PHOTO COPY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/11","","","2017-06-07 00:00:00","11","4010000003","","","50.000000000000000000000000000000","0","OTHER EXPENSES","PETROL FOR BABAR BAIK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/11.","","","2017-06-07 00:00:00","11.","2710000001","","","0","50.000000000000000000000000000000","Cash In Hand","/PETROL FOR BABAR BAIK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/12","","","2017-06-07 00:00:00","12","1910000003","","","1500.000000000000000000000000000000","0","SALARY PAYABLE Rashid","ADVANCE SALALRY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/12.","","","2017-06-07 00:00:00","12.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","/ADVANCE SALALRY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/13","","","2017-06-07 00:00:00","13","4010000003","","","600.000000000000000000000000000000","0","OTHER EXPENSES","REPAIR BATH SET TO CUSTMARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/13.","","","2017-06-07 00:00:00","13.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","/REPAIR BATH SET TO CUSTMARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/14","","","2017-06-07 00:00:00","14","4010000004","","","800.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO PICKUP FOR CUSTMARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/14.","","","2017-06-07 00:00:00","14.","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","/RENT PAID TO PICKUP FOR CUSTMARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/15","","","2017-06-07 00:00:00","15","1910000027","","","500.000000000000000000000000000000","0","SALARY PAYABLE NASIR","ADVANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/15.","","","2017-06-07 00:00:00","15.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/ADVANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/2","","","2017-06-07 00:00:00","2","2620000001","","","15000.000000000000000000000000000000","0","Bath & Kitchen","PAID ONLINE TO MUBASHER BILL NO 060012 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/2.","","","2017-06-07 00:00:00","2.","2710000001","","","0","15000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID ONLINE TO MUBASHER BILL NO 060012 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/3","","","2017-06-07 00:00:00","3","2620000001","","","45830.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO MAHMOOD SONS FOR SONIX SET B/k","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/3.","","","2017-06-07 00:00:00","3.","2710000001","","","0","45830.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO MAHMOOD SONS FOR SONIX SET B/k","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/4","","","2017-06-07 00:00:00","4","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD FOR SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/4.","","","2017-06-07 00:00:00","4.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD FOR SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/5","","","2017-06-07 00:00:00","5","1910000001","","","40000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","SALARY PAID TO SHAHID SB BALANCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/5.","","","2017-06-07 00:00:00","5.","2710000001","","","0","40000.000000000000000000000000000000","Cash In Hand","/SALARY PAID TO SHAHID SB BALANCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/6","","","2017-06-07 00:00:00","6","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/6.","","","2017-06-07 00:00:00","6.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/7","","","2017-06-07 00:00:00","7","4010000003","","","50.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE DORI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/7.","","","2017-06-07 00:00:00","7.","2710000001","","","0","50.000000000000000000000000000000","Cash In Hand","/PURCHASE DORI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/8","","","2017-06-07 00:00:00","8","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE PRINTER PAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/8.","","","2017-06-07 00:00:00","8.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/PURCHASE PRINTER PAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/9","","","2017-06-07 00:00:00","9","4010000009","","","500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060006/9.","","","2017-06-07 00:00:00","9.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/1","","","2017-06-08 00:00:00","1","4010000003","","","1000.000000000000000000000000000000","0","OTHER EXPENSES","MISC EXP HASEEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/1.","","","2017-06-08 00:00:00","1.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/MISC EXP HASEEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/2","","","2017-06-08 00:00:00","2","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/2.","","","2017-06-08 00:00:00","2.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/3","","","2017-06-08 00:00:00","3","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT PEID TO KAMAR PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/3.","","","2017-06-08 00:00:00","3.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/RENT PEID TO KAMAR PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/4","","","2017-06-08 00:00:00","4","2620000001","","","4300.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K RETRN BILL  WOOD FLOOR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/4.","","","2017-06-08 00:00:00","4.","2710000001","","","0","4300.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K RETRN BILL  WOOD FLOOR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/5","","","2017-06-08 00:00:00","5","4010000004","","","600.000000000000000000000000000000","0","Travelling Expenses","RENT PEID TO CUSTAMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/5.","","","2017-06-08 00:00:00","5.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","/RENT PEID TO CUSTAMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/6","","","2017-06-08 00:00:00","6","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT PEID TO CUSTAMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/6.","","","2017-06-08 00:00:00","6.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/RENT PEID TO CUSTAMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/7","","","2017-06-08 00:00:00","7","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP FOR STAF","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/7.","","","2017-06-08 00:00:00","7.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/IFTAR EXP FOR STAF","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/8","","","2017-06-08 00:00:00","8","4010000009","","","600.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/8.","","","2017-06-08 00:00:00","8.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/9","","","2017-06-08 00:00:00","9","4010000003","","","20000.000000000000000000000000000000","0","OTHER EXPENSES","PAID TO HASEEB SB FOR PURCHASE OF WALL PAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060007/9.","","","2017-06-08 00:00:00","9.","2710000001","","","0","20000.000000000000000000000000000000","Cash In Hand","/PAID TO HASEEB SB FOR PURCHASE OF WALL PAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/1","","","2017-06-09 00:00:00","1","4010000006","","","130.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/1.","","","2017-06-09 00:00:00","1.","2710000001","","","0","130.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/2","","","2017-06-09 00:00:00","2","0100020009","","","29000.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO HASEEB FOR WALLPAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/2.","","","2017-06-09 00:00:00","2.","2710000001","","","0","29000.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO HASEEB FOR WALLPAPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/3","","","2017-06-09 00:00:00","3","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/3.","","","2017-06-09 00:00:00","3.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/4","","","2017-06-09 00:00:00","4","4010000009","","","3000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/4.","","","2017-06-09 00:00:00","4.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/5","","","2017-06-09 00:00:00","5","4010000004","","","800.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/5.","","","2017-06-09 00:00:00","5.","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/6","","","2017-06-09 00:00:00","6","4010000004","","","1000.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/6.","","","2017-06-09 00:00:00","6.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/7","","","2017-06-09 00:00:00","7","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060008/7.","","","2017-06-09 00:00:00","7.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/1","","","2017-06-10 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/1.","","","2017-06-10 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/10","","","2017-06-10 00:00:00","10","4010000004","","","400.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO CUSTAMER PHASE 5","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/10.","","","2017-06-10 00:00:00","10.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/RENT PAID TO CUSTAMER PHASE 5","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/11","","","2017-06-10 00:00:00","11","1910000029","","","3000.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","ADVANCE SALARY TAYYAB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/11.","","","2017-06-10 00:00:00","11.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/ADVANCE SALARY TAYYAB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/12","","","2017-06-10 00:00:00","12","2620000001","","","60000.000000000000000000000000000000","0","Bath & Kitchen","CASH PAID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/12.","","","2017-06-10 00:00:00","12.","2710000001","","","0","60000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CASH PAID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/13","","","2017-06-10 00:00:00","13","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE TISSU","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/13.","","","2017-06-10 00:00:00","13.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PURCHASE TISSU","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/2","","","2017-06-10 00:00:00","2","4010000009","","","1500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/2.","","","2017-06-10 00:00:00","2.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/3","","","2017-06-10 00:00:00","3","2620000001","","","16170.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/3.","","","2017-06-10 00:00:00","3.","2710000001","","","0","16170.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/4","","","2017-06-10 00:00:00","4","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/4.","","","2017-06-10 00:00:00","4.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/5","","","2017-06-10 00:00:00","5","4010000003","","","120.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE STEEL KIL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/5.","","","2017-06-10 00:00:00","5.","2710000001","","","0","120.000000000000000000000000000000","Cash In Hand","/PURCHASE STEEL KIL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/6","","","2017-06-10 00:00:00","6","4010000004","","","500.000000000000000000000000000000","0","Travelling Expenses","RENT PAID CUSTMARE WAPDA TWON","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/6.","","","2017-06-10 00:00:00","6.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/RENT PAID CUSTMARE WAPDA TWON","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/7","","","2017-06-10 00:00:00","7","4010000009","","","1000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/7.","","","2017-06-10 00:00:00","7.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/8","","","2017-06-10 00:00:00","8","4010000006","","","400.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/8.","","","2017-06-10 00:00:00","8.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/9","","","2017-06-10 00:00:00","9","4010000004","","","800.000000000000000000000000000000","0","Travelling Expenses","RENT PAID TO CUSTAMER PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060009/9.","","","2017-06-10 00:00:00","9.","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","/RENT PAID TO CUSTAMER PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060010/1","","","2017-06-02 00:00:00","1","2620000001","","","78000.000000000000000000000000000000","0","Bath & Kitchen","CHQ PAID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060010/1.","","","2017-06-02 00:00:00","1.","2710000001","","","0","78000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ PAID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060011/1","","","2017-06-03 00:00:00","1","2620000001","","","118000.000000000000000000000000000000","0","Bath & Kitchen","CHQ GIVE TO B&amp;K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060011/1.","","","2017-06-03 00:00:00","1.","2710000001","","","0","118000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ GIVE TO B&amp;K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060012/1","","","2017-06-10 00:00:00","1","2620000001","","","70000.000000000000000000000000000000","0","Bath & Kitchen","CHUQ PEID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060012/1.","","","2017-06-10 00:00:00","1.","2710000001","","","0","70000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHUQ PEID TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060013/1","","","2017-06-08 00:00:00","1","2620000001","","","37400.000000000000000000000000000000","0","Bath & Kitchen","CHUQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060013/1.","","","2017-06-08 00:00:00","1.","2710000001","","","0","37400.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHUQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/1","","","2017-06-12 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL 8003+RASHID+BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/1.","","","2017-06-12 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL 8003+RASHID+BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/10","","","2017-06-12 00:00:00","10","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/10.","","","2017-06-12 00:00:00","10.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/2","","","2017-06-12 00:00:00","2","4010000003","","","250.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP 11-06-17","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/2.","","","2017-06-12 00:00:00","2.","2710000001","","","0","250.000000000000000000000000000000","Cash In Hand","/IFTAR EXP 11-06-17","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/3","","","2017-06-12 00:00:00","3","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/3.","","","2017-06-12 00:00:00","3.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/4","","","2017-06-12 00:00:00","4","4010000003","","","340.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/4.","","","2017-06-12 00:00:00","4.","2710000001","","","0","340.000000000000000000000000000000","Cash In Hand","/PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/5","","","2017-06-12 00:00:00","5","2620000001","","","242745.000000000000000000000000000000","0","Bath & Kitchen","SYD CHQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/5.","","","2017-06-12 00:00:00","5.","2710000001","","","0","242745.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/SYD CHQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/6","","","2017-06-12 00:00:00","6","4010000004","","","450.000000000000000000000000000000","0","Travelling Expenses","RENT STOCK RED MIRROR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/6.","","","2017-06-12 00:00:00","6.","2710000001","","","0","450.000000000000000000000000000000","Cash In Hand","/RENT STOCK RED MIRROR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/7","","","2017-06-12 00:00:00","7","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP 12-06-17","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/7.","","","2017-06-12 00:00:00","7.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/IFTAR EXP 12-06-17","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/8","","","2017-06-12 00:00:00","8","2620000001","","","60000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K THROGH MURTZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/8.","","","2017-06-12 00:00:00","8.","2710000001","","","0","60000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K THROGH MURTZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/9","","","2017-06-12 00:00:00","9","4010000004","","","800.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTMER PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060014/9.","","","2017-06-12 00:00:00","9.","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","/RENT CUSTMER PICKUP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/1","","","2017-06-13 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/1.","","","2017-06-13 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/2","","","2017-06-13 00:00:00","2","4010000004","","","800.000000000000000000000000000000","0","Travelling Expenses","RENT FROM CUSTOMER SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/2.","","","2017-06-13 00:00:00","2.","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","/RENT FROM CUSTOMER SALEEM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/3","","","2017-06-13 00:00:00","3","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/3.","","","2017-06-13 00:00:00","3.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/4","","","2017-06-13 00:00:00","4","4010000009","","","1000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/4.","","","2017-06-13 00:00:00","4.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/5","","","2017-06-13 00:00:00","5","4010000004","","","700.000000000000000000000000000000","0","Travelling Expenses","RENT FROM CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/5.","","","2017-06-13 00:00:00","5.","2710000001","","","0","700.000000000000000000000000000000","Cash In Hand","/RENT FROM CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/6","","","2017-06-13 00:00:00","6","4010000008","","","1600.000000000000000000000000000000","0","Utility BILL","NET BILL WI-TRIB (PERFACT HOME)","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/6.","","","2017-06-13 00:00:00","6.","2710000001","","","0","1600.000000000000000000000000000000","Cash In Hand","/NET BILL WI-TRIB (PERFACT HOME)","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/7","","","2017-06-13 00:00:00","7","4010000006","","","50.000000000000000000000000000000","0","Fuel Expenses","PETROL FROM RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060015/7.","","","2017-06-13 00:00:00","7.","2710000001","","","0","50.000000000000000000000000000000","Cash In Hand","/PETROL FROM RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060016/1","","","2017-06-12 00:00:00","1","2620000001","","","8700.000000000000000000000000000000","0","Bath & Kitchen","RTN BILL NO 3688 SALE BILL 2118 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060016/1.","","","2017-06-12 00:00:00","1.","2710000001","","","0","8700.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/RTN BILL NO 3688 SALE BILL 2118 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/2","","","2017-06-14 00:00:00","2","4010000003","","","250.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/2.","","","2017-06-14 00:00:00","2.","2710000001","","","0","250.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/3","","","2017-06-14 00:00:00","3","1910000003","","","1000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","ADVANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/3.","","","2017-06-14 00:00:00","3.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/4","","","2017-06-14 00:00:00","4","4010000001","","","300.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","MILK OR TEA BAG ETC.","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/4.","","","2017-06-14 00:00:00","4.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/MILK OR TEA BAG ETC.","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/5","","","2017-06-14 00:00:00","5","4010000001","","","140.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/5.","","","2017-06-14 00:00:00","5.","2710000001","","","0","140.000000000000000000000000000000","Cash In Hand","/CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/6","","","2017-06-14 00:00:00","6","4010000004","","","1200.000000000000000000000000000000","0","Travelling Expenses","RENT PAID CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/6.","","","2017-06-14 00:00:00","6.","2710000001","","","0","1200.000000000000000000000000000000","Cash In Hand","/RENT PAID CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/7","","","2017-06-14 00:00:00","7","4010000009","","","600.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/7.","","","2017-06-14 00:00:00","7.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/8","","","2017-06-14 00:00:00","8","1910000001","","","10000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANCE SALRY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/8.","","","2017-06-14 00:00:00","8.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALRY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/9","","","2017-06-14 00:00:00","9","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060017/9.","","","2017-06-14 00:00:00","9.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/1","","","2017-06-15 00:00:00","1","4010000004","","","3000.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER PICKUP 3 DAYS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/1.","","","2017-06-15 00:00:00","1.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER PICKUP 3 DAYS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/2","","","2017-06-15 00:00:00","2","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/2.","","","2017-06-15 00:00:00","2.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/3","","","2017-06-15 00:00:00","3","4010000009","","","500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/3.","","","2017-06-15 00:00:00","3.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/4","","","2017-06-15 00:00:00","4","4010000003","","","55.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE SOOP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/4.","","","2017-06-15 00:00:00","4.","2710000001","","","0","55.000000000000000000000000000000","Cash In Hand","/PURCHASE SOOP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/5","","","2017-06-15 00:00:00","5","4010000004","","","500.000000000000000000000000000000","0","Travelling Expenses","RENT STOCK LEXTA IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/5.","","","2017-06-15 00:00:00","5.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/RENT STOCK LEXTA IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/6","","","2017-06-15 00:00:00","6","4010000004","","","1800.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/6.","","","2017-06-15 00:00:00","6.","2710000001","","","0","1800.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/7","","","2017-06-15 00:00:00","7","4010000003","","","1000.000000000000000000000000000000","0","OTHER EXPENSES","MISC EXP SAJID MARKITING","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060018/7.","","","2017-06-15 00:00:00","7.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/MISC EXP SAJID MARKITING","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/1","","","2017-06-16 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/1.","","","2017-06-16 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/2","","","2017-06-16 00:00:00","2","4010000009","","","1500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/2.","","","2017-06-16 00:00:00","2.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/3","","","2017-06-16 00:00:00","3","1910000001","","","14000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANCE SALARY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/3.","","","2017-06-16 00:00:00","3.","2710000001","","","0","14000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALARY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/4","","","2017-06-16 00:00:00","4","4010000004","","","600.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/4.","","","2017-06-16 00:00:00","4.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER IJAZ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/5","","","2017-06-16 00:00:00","5","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/5.","","","2017-06-16 00:00:00","5.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/6","","","2017-06-16 00:00:00","6","4010000009","","","500.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/6.","","","2017-06-16 00:00:00","6.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/7","","","2017-06-16 00:00:00","7","4010000003","","","270.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/7.","","","2017-06-16 00:00:00","7.","2710000001","","","0","270.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/8","","","2017-06-16 00:00:00","8","4010000004","","","1200.000000000000000000000000000000","0","Travelling Expenses","RENT STOCK RCVD GUJRAWALA CLASSIC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060019/8.","","","2017-06-16 00:00:00","8.","2710000001","","","0","1200.000000000000000000000000000000","Cash In Hand","/RENT STOCK RCVD GUJRAWALA CLASSIC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/1","","","2017-06-17 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/1.","","","2017-06-17 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/10","","","2017-06-17 00:00:00","10","1910000001","","","30000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","EID BOUNS SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/10.","","","2017-06-17 00:00:00","10.","2710000001","","","0","30000.000000000000000000000000000000","Cash In Hand","/EID BOUNS SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/2","","","2017-06-17 00:00:00","2","4010000004","","","600.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/2.","","","2017-06-17 00:00:00","2.","2710000001","","","0","600.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/3","","","2017-06-17 00:00:00","3","4010000006","","","400.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/3.","","","2017-06-17 00:00:00","3.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/4","","","2017-06-17 00:00:00","4","2620000001","","","100000.000000000000000000000000000000","0","Bath & Kitchen","CASH PAID TO B/K THROGH HAPPY SB CHINA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/4.","","","2017-06-17 00:00:00","4.","2710000001","","","0","100000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CASH PAID TO B/K THROGH HAPPY SB CHINA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/5","","","2017-06-17 00:00:00","5","1910000030","","","5000.000000000000000000000000000000","0","SALARY PAYABLE BABAR","EID BOUNS BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/5.","","","2017-06-17 00:00:00","5.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE BABAR/EID BOUNS BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/6","","","2017-06-17 00:00:00","6","1910000027","","","12000.000000000000000000000000000000","0","SALARY PAYABLE NASIR","EID BOUNS NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/6.","","","2017-06-17 00:00:00","6.","2710000001","","","0","12000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/EID BOUNS NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/7","","","2017-06-17 00:00:00","7","1910000028","","","22000.000000000000000000000000000000","0","SALARY PAYABLE MURTAZA","EID BOUNS MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/7.","","","2017-06-17 00:00:00","7.","2710000001","","","0","22000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE MURTAZA/EID BOUNS MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/8","","","2017-06-17 00:00:00","8","1910000029","","","12000.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","EID BOUNS TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/8.","","","2017-06-17 00:00:00","8.","2710000001","","","0","12000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/EID BOUNS TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/9","","","2017-06-17 00:00:00","9","1910000003","","","15000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","EID BOUNS RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060020/9.","","","2017-06-17 00:00:00","9.","2710000001","","","0","15000.000000000000000000000000000000","Cash In Hand","/EID BOUNS RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/1","","","2017-06-19 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/1.","","","2017-06-19 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/2","","","2017-06-19 00:00:00","2","2620000001","","","100000.000000000000000000000000000000","0","Bath & Kitchen","CHQ GIVEN TO B/K ASKRI BANK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/2.","","","2017-06-19 00:00:00","2.","2710000001","","","0","100000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ GIVEN TO B/K ASKRI BANK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/3","","","2017-06-19 00:00:00","3","4010000003","","","230.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/3.","","","2017-06-19 00:00:00","3.","2710000001","","","0","230.000000000000000000000000000000","Cash In Hand","/PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/4","","","2017-06-19 00:00:00","4","4010000009","","","250.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/4.","","","2017-06-19 00:00:00","4.","2710000001","","","0","250.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/5","","","2017-06-19 00:00:00","5","2620000001","","","2000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K BILL NO 1119","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060021/5.","","","2017-06-19 00:00:00","5.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K BILL NO 1119","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/1","","","2017-06-20 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR RASHID 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/1.","","","2017-06-20 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR RASHID 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/2","","","2017-06-20 00:00:00","2","4010000004","","","400.000000000000000000000000000000","0","Travelling Expenses","RENT BILL NO 1118","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/2.","","","2017-06-20 00:00:00","2.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/RENT BILL NO 1118","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/3","","","2017-06-20 00:00:00","3","0100020009","","","6000.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO HASEEB FOR PVC 669 ASKRI 10","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/3.","","","2017-06-20 00:00:00","3.","2710000001","","","0","6000.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO HASEEB FOR PVC 669 ASKRI 10","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/4","","","2017-06-20 00:00:00","4","4010000009","","","250.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/4.","","","2017-06-20 00:00:00","4.","2710000001","","","0","250.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/5","","","2017-06-20 00:00:00","5","4010000006","","","500.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/5.","","","2017-06-20 00:00:00","5.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/6","","","2017-06-20 00:00:00","6","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/6.","","","2017-06-20 00:00:00","6.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/7","","","2017-06-20 00:00:00","7","4010000003","","","235.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060022/7.","","","2017-06-20 00:00:00","7.","2710000001","","","0","235.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/1","","","2017-06-21 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/1.","","","2017-06-21 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/2","","","2017-06-21 00:00:00","2","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/2.","","","2017-06-21 00:00:00","2.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/3","","","2017-06-21 00:00:00","3","1910000027","","","1500.000000000000000000000000000000","0","SALARY PAYABLE NASIR","ADVANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/3.","","","2017-06-21 00:00:00","3.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/ADVANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/4","","","2017-06-21 00:00:00","4","2620000001","","","50000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO SHAHID GUJ AGNAST  CHUQ B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/4.","","","2017-06-21 00:00:00","4.","2710000001","","","0","50000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO SHAHID GUJ AGNAST  CHUQ B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/5","","","2017-06-21 00:00:00","5","4010000009","","","450.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/5.","","","2017-06-21 00:00:00","5.","2710000001","","","0","450.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/6","","","2017-06-21 00:00:00","6","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060023/6.","","","2017-06-21 00:00:00","6.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/1","","","2017-06-22 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/1.","","","2017-06-22 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/10","","","2017-06-22 00:00:00","10","4010000001","","","210.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","GUST ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/10.","","","2017-06-22 00:00:00","10.","2710000001","","","0","210.000000000000000000000000000000","Cash In Hand","/GUST ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/11","","","2017-06-22 00:00:00","11","4010000003","","","90.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE SCREW","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/11.","","","2017-06-22 00:00:00","11.","2710000001","","","0","90.000000000000000000000000000000","Cash In Hand","/PURCHASE SCREW","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/2","","","2017-06-22 00:00:00","2","0100020002","","","750.000000000000000000000000000000","0","Waseem Sb","PERSONAL WASEEM SB DOUGHTER FEE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/2.","","","2017-06-22 00:00:00","2.","2710000001","","","0","750.000000000000000000000000000000","Cash In Hand","/PERSONAL WASEEM SB DOUGHTER FEE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/3","","","2017-06-22 00:00:00","3","0100020002","","","260.000000000000000000000000000000","0","Waseem Sb","PERSONAL T.C.S  WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/3.","","","2017-06-22 00:00:00","3.","2710000001","","","0","260.000000000000000000000000000000","Cash In Hand","/PERSONAL T.C.S  WASEEM SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/4","","","2017-06-22 00:00:00","4","2620000001","","","84500.000000000000000000000000000000","0","Bath & Kitchen","ONLIN PYMENT FROME SIALKOT B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/4.","","","2017-06-22 00:00:00","4.","2710000001","","","0","84500.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/ONLIN PYMENT FROME SIALKOT B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/5","","","2017-06-22 00:00:00","5","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/5.","","","2017-06-22 00:00:00","5.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/6","","","2017-06-22 00:00:00","6","2610000048","","","6500.000000000000000000000000000000","0","NASEEM AHMAD SOFTWARE DEVELOPER","OBLIGE BY HAPPY SB BILL NO 1132","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/6.","","","2017-06-22 00:00:00","6.","2710000001","","","0","6500.000000000000000000000000000000","Cash In Hand","NASEEM AHMAD SOFTWARE DEVELOPER/OBLIGE BY HAPPY SB BILL NO 1132","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/7","","","2017-06-22 00:00:00","7","2610000048","","","1600.000000000000000000000000000000","0","NASEEM AHMAD SOFTWARE DEVELOPER","OBLIGE BY HAPPY SB BILL NO 1135","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/7.","","","2017-06-22 00:00:00","7.","2710000001","","","0","1600.000000000000000000000000000000","Cash In Hand","NASEEM AHMAD SOFTWARE DEVELOPER/OBLIGE BY HAPPY SB BILL NO 1135","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/8","","","2017-06-22 00:00:00","8","4010000003","","","220.000000000000000000000000000000","0","OTHER EXPENSES","SPRAY BLACK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/8.","","","2017-06-22 00:00:00","8.","2710000001","","","0","220.000000000000000000000000000000","Cash In Hand","/SPRAY BLACK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/9","","","2017-06-22 00:00:00","9","4010000009","","","750.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060024/9.","","","2017-06-22 00:00:00","9.","2710000001","","","0","750.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/1","","","2017-06-23 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/1.","","","2017-06-23 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/2","","","2017-06-23 00:00:00","2","4010000007","","","30.000000000000000000000000000000","0","Stationary Expenses","PHOTO COPY DAYBOOK 15","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/2.","","","2017-06-23 00:00:00","2.","2710000001","","","0","30.000000000000000000000000000000","Cash In Hand","/PHOTO COPY DAYBOOK 15","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/3","","","2017-06-23 00:00:00","3","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/3.","","","2017-06-23 00:00:00","3.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/4","","","2017-06-23 00:00:00","4","4010000009","","","1000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/4.","","","2017-06-23 00:00:00","4.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/5","","","2017-06-23 00:00:00","5","0100020009","","","40000.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO HASEEB FOR WOOD FLOOR FOR AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/5.","","","2017-06-23 00:00:00","5.","2710000001","","","0","40000.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO HASEEB FOR WOOD FLOOR FOR AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/6","","","2017-06-23 00:00:00","6","2620000001","","","50000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO IMRAN C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/6.","","","2017-06-23 00:00:00","6.","2710000001","","","0","50000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO IMRAN C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/7","","","2017-06-23 00:00:00","7","1310000028","","","10000.000000000000000000000000000000","0","MAHMOOD SONS","PAID TO MAHMOOD SONS OLD BALANCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/7.","","","2017-06-23 00:00:00","7.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","MAHMOOD SONS/PAID TO MAHMOOD SONS OLD BALANCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/8","","","2017-06-23 00:00:00","8","0100020010","","","200000.000000000000000000000000000000","0","TAMOUR SB SHOW ROOM PERFACT HOME","PAID CASH TO TAMOUR SB AGNEST RENT SHOW ROOM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/8.","","","2017-06-23 00:00:00","8.","2710000001","","","0","200000.000000000000000000000000000000","Cash In Hand","TAMOUR SB SHOW ROOM PERFACT HOME/PAID CASH TO TAMOUR SB AGNEST RENT SHOW ROOM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/9","","","2017-06-23 00:00:00","9","1910000029","","","4000.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","ADVANC SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060025/9.","","","2017-06-23 00:00:00","9.","2710000001","","","0","4000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/ADVANC SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/1","","","2017-06-24 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/1.","","","2017-06-24 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/2","","","2017-06-24 00:00:00","2","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/2.","","","2017-06-24 00:00:00","2.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/3","","","2017-06-24 00:00:00","3","1910000027","","","5000.000000000000000000000000000000","0","SALARY PAYABLE NASIR","ADVANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/3.","","","2017-06-24 00:00:00","3.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/ADVANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/4","","","2017-06-24 00:00:00","4","1910000028","","","5000.000000000000000000000000000000","0","SALARY PAYABLE MURTAZA","ADVANCE SALARY MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/4.","","","2017-06-24 00:00:00","4.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE MURTAZA/ADVANCE SALARY MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/5","","","2017-06-24 00:00:00","5","1910000003","","","15000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","BALANCE COMMISSION / EID RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/5.","","","2017-06-24 00:00:00","5.","2710000001","","","0","15000.000000000000000000000000000000","Cash In Hand","/BALANCE COMMISSION / EID RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/6","","","2017-06-24 00:00:00","6","1910000003","","","10000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","ADVANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/6.","","","2017-06-24 00:00:00","6.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/7","","","2017-06-24 00:00:00","7","4010000003","","","315.000000000000000000000000000000","0","OTHER EXPENSES","IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/7.","","","2017-06-24 00:00:00","7.","2710000001","","","0","315.000000000000000000000000000000","Cash In Hand","/IFTAR EXP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/8","","","2017-06-24 00:00:00","8","4010000003","","","25000.000000000000000000000000000000","0","OTHER EXPENSES","BALANCE EID SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/8.","","","2017-06-24 00:00:00","8.","2710000001","","","0","25000.000000000000000000000000000000","Cash In Hand","/BALANCE EID SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/9","","","2017-06-24 00:00:00","9","2610000045","","","1000.000000000000000000000000000000","0","347/Y PHS# 3","RTN BILL NO 1140","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060026/9.","","","2017-06-24 00:00:00","9.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","347/Y PHS# 3/RTN BILL NO 1140","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/1","","","2017-06-29 00:00:00","1","2620000001","","","14000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO NADEEM C/O HAPPY SB B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/1.","","","2017-06-29 00:00:00","1.","2710000001","","","0","14000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO NADEEM C/O HAPPY SB B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/2","","","2017-06-29 00:00:00","2","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/2.","","","2017-06-29 00:00:00","2.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/3","","","2017-06-29 00:00:00","3","1910000003","","","2000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","ADVANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/3.","","","2017-06-29 00:00:00","3.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/4","","","2017-06-29 00:00:00","4","4010000001","","","745.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","T BAGG + MILK ETC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/4.","","","2017-06-29 00:00:00","4.","2710000001","","","0","745.000000000000000000000000000000","Cash In Hand","/T BAGG + MILK ETC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/5","","","2017-06-29 00:00:00","5","4010000001","","","300.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/5.","","","2017-06-29 00:00:00","5.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/6","","","2017-06-29 00:00:00","6","1910000029","","","1000.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","ADVANCE SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/6.","","","2017-06-29 00:00:00","6.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/ADVANCE SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/7","","","2017-06-29 00:00:00","7","1910000001","","","10000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANCE SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP060027/7.","","","2017-06-29 00:00:00","7.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/1","","","2017-06-30 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/1.","","","2017-06-30 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/2","","","2017-06-30 00:00:00","2","4010000001","","","450.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/2.","","","2017-06-30 00:00:00","2.","2710000001","","","0","450.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/3","","","2017-06-30 00:00:00","3","2620000001","","","5000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO B/K TROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/3.","","","2017-06-30 00:00:00","3.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO B/K TROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/4","","","2017-06-30 00:00:00","4","2620000001","","","350000.000000000000000000000000000000","0","Bath & Kitchen","PAY ORDER GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/4.","","","2017-06-30 00:00:00","4.","2710000001","","","0","350000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAY ORDER GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/5","","","2017-06-30 00:00:00","5","4010000006","","","2000.000000000000000000000000000000","0","Fuel Expenses","PAID TO SAJID FOR PETROL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/5.","","","2017-06-30 00:00:00","5.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/PAID TO SAJID FOR PETROL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/6","","","2017-06-30 00:00:00","6","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/6.","","","2017-06-30 00:00:00","6.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/7","","","2017-06-30 00:00:00","7","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/7.","","","2017-06-30 00:00:00","7.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/8","","","2017-06-30 00:00:00","8","4010000009","","","450.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/8.","","","2017-06-30 00:00:00","8.","2710000001","","","0","450.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/9","","","2017-06-30 00:00:00","9","1910000030","","","5000.000000000000000000000000000000","0","SALARY PAYABLE BABAR","ADVANCE SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070001/9.","","","2017-06-30 00:00:00","9.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE BABAR/ADVANCE SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/1","","","2017-07-01 00:00:00","1","4010000006","","","400.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/1.","","","2017-07-01 00:00:00","1.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/10","","","2017-07-01 00:00:00","10","4010000001","","","205.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/10.","","","2017-07-01 00:00:00","10.","2710000001","","","0","205.000000000000000000000000000000","Cash In Hand","/CUTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/11","","","2017-07-01 00:00:00","11","0100020001","","","10000.000000000000000000000000000000","0","Happy Malik Sb","PERSONAL HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/11.","","","2017-07-01 00:00:00","11.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/PERSONAL HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/12","","","2017-07-01 00:00:00","12","4010000009","","","2000.000000000000000000000000000000","0","CHARITY PAID","MONTHLY CHARITY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/12.","","","2017-07-01 00:00:00","12.","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","/MONTHLY CHARITY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/13","","","2017-07-01 00:00:00","13","4010000003","","","1000.000000000000000000000000000000","0","OTHER EXPENSES","OBLIGE TO X Y Z","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/13.","","","2017-07-01 00:00:00","13.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","/OBLIGE TO X Y Z","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/14","","","2017-07-01 00:00:00","14","1910000001","","","10000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANCE SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/14.","","","2017-07-01 00:00:00","14.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/ADVANCE SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/2","","","2017-07-01 00:00:00","2","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/2.","","","2017-07-01 00:00:00","2.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/3","","","2017-07-01 00:00:00","3","4010000003","","","95.000000000000000000000000000000","0","OTHER EXPENSES","TISSUE BOX","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/3.","","","2017-07-01 00:00:00","3.","2710000001","","","0","95.000000000000000000000000000000","Cash In Hand","/TISSUE BOX","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/4","","","2017-07-01 00:00:00","4","4010000001","","","450.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/4.","","","2017-07-01 00:00:00","4.","2710000001","","","0","450.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/5","","","2017-07-01 00:00:00","5","4010000003","","","60.000000000000000000000000000000","0","OTHER EXPENSES","REPARE 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/5.","","","2017-07-01 00:00:00","5.","2710000001","","","0","60.000000000000000000000000000000","Cash In Hand","/REPARE 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/6","","","2017-07-01 00:00:00","6","2620000001","","","33000.000000000000000000000000000000","0","Bath & Kitchen","CHQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/6.","","","2017-07-01 00:00:00","6.","2710000001","","","0","33000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/7","","","2017-07-01 00:00:00","7","2620000001","","","25000.000000000000000000000000000000","0","Bath & Kitchen","CASH GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/7.","","","2017-07-01 00:00:00","7.","2710000001","","","0","25000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CASH GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/8","","","2017-07-01 00:00:00","8","2620000001","","","14000.000000000000000000000000000000","0","Bath & Kitchen","C.C. BILL NO 1156 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/8.","","","2017-07-01 00:00:00","8.","2710000001","","","0","14000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/C.C. BILL NO 1156 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/9","","","2017-07-01 00:00:00","9","2620000001","","","177000.000000000000000000000000000000","0","Bath & Kitchen","C.C. BILL NO 1157 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070002/9.","","","2017-07-01 00:00:00","9.","2710000001","","","0","177000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/C.C. BILL NO 1157 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/1","","","2017-07-03 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/1.","","","2017-07-03 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/10","","","2017-07-03 00:00:00","10","1910000029","","","1000.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","ADVANC SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/10.","","","2017-07-03 00:00:00","10.","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/ADVANC SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/11","","","2017-07-03 00:00:00","11","1910000001","","","10000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANC SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/11.","","","2017-07-03 00:00:00","11.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","/ADVANC SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/12","","","2017-07-03 00:00:00","12","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/12.","","","2017-07-03 00:00:00","12.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/2","","","2017-07-03 00:00:00","2","4010000001","","","315.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/2.","","","2017-07-03 00:00:00","2.","2710000001","","","0","315.000000000000000000000000000000","Cash In Hand","/PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/3","","","2017-07-03 00:00:00","3","0100020009","","","15000.000000000000000000000000000000","0","HASEEB WALPAPER","PAID CASH TO HASEEB FOR WOOD FLOOR AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/3.","","","2017-07-03 00:00:00","3.","2710000001","","","0","15000.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID CASH TO HASEEB FOR WOOD FLOOR AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/4","","","2017-07-03 00:00:00","4","4010000001","","","400.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH + SOAP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/4.","","","2017-07-03 00:00:00","4.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/LUNCH + SOAP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/5","","","2017-07-03 00:00:00","5","4010000001","","","170.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","MILK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/5.","","","2017-07-03 00:00:00","5.","2710000001","","","0","170.000000000000000000000000000000","Cash In Hand","/MILK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/6","","","2017-07-03 00:00:00","6","0100020007","","","19000.000000000000000000000000000000","0","NADEEM SB","COMMISON NADEEM PLUMBER C/O HAPPY SB C/O RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/6.","","","2017-07-03 00:00:00","6.","2710000001","","","0","19000.000000000000000000000000000000","Cash In Hand","/COMMISON NADEEM PLUMBER C/O HAPPY SB C/O RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/7","","","2017-07-03 00:00:00","7","4010000001","","","180.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/7.","","","2017-07-03 00:00:00","7.","2710000001","","","0","180.000000000000000000000000000000","Cash In Hand","/CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/8","","","2017-07-03 00:00:00","8","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/8.","","","2017-07-03 00:00:00","8.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/9","","","2017-07-03 00:00:00","9","1910000030","","","5000.000000000000000000000000000000","0","SALARY PAYABLE BABAR","ADVANC SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070003/9.","","","2017-07-03 00:00:00","9.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE BABAR/ADVANC SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/1","","","2017-07-04 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/1.","","","2017-07-04 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/10","","","2017-07-04 00:00:00","10","4010000003","","","5000.000000000000000000000000000000","0","OTHER EXPENSES","OBLIGE TO X Y Z C/O HASPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/10.","","","2017-07-04 00:00:00","10.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","/OBLIGE TO X Y Z C/O HASPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/11","","","2017-07-04 00:00:00","11","2620000001","","","450000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO B/K TO HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/11.","","","2017-07-04 00:00:00","11.","2710000001","","","0","450000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO B/K TO HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/12","","","2017-07-04 00:00:00","12","4010000009","","","100.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/12.","","","2017-07-04 00:00:00","12.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/2","","","2017-07-04 00:00:00","2","2620000001","","","43000.000000000000000000000000000000","0","Bath & Kitchen","CHQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/2.","","","2017-07-04 00:00:00","2.","2710000001","","","0","43000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ GIVEN TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/3","","","2017-07-04 00:00:00","3","4010000003","","","500.000000000000000000000000000000","0","OTHER EXPENSES","MEDICAL EXP NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/3.","","","2017-07-04 00:00:00","3.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/MEDICAL EXP NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/4","","","2017-07-04 00:00:00","4","0100020009","","","840.000000000000000000000000000000","0","HASEEB WALPAPER","LABAURE ASKRI 10 C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/4.","","","2017-07-04 00:00:00","4.","2710000001","","","0","840.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/LABAURE ASKRI 10 C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/5","","","2017-07-04 00:00:00","5","4010000001","","","450.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/5.","","","2017-07-04 00:00:00","5.","2710000001","","","0","450.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/6","","","2017-07-04 00:00:00","6","4010000003","","","1100.000000000000000000000000000000","0","OTHER EXPENSES","REPAIR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/6.","","","2017-07-04 00:00:00","6.","2710000001","","","0","1100.000000000000000000000000000000","Cash In Hand","/REPAIR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/7","","","2017-07-04 00:00:00","7","4010000006","","","400.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/7.","","","2017-07-04 00:00:00","7.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/8","","","2017-07-04 00:00:00","8","2620000001","","","31000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO C.C BILL NO 1562 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/8.","","","2017-07-04 00:00:00","8.","2710000001","","","0","31000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO C.C BILL NO 1562 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/9","","","2017-07-04 00:00:00","9","4010000001","","","150.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070004/9.","","","2017-07-04 00:00:00","9.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/1","","","2017-07-05 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/1.","","","2017-07-05 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/2","","","2017-07-05 00:00:00","2","2620000001","","","113640.000000000000000000000000000000","0","Bath & Kitchen","PAID TO MAGOON AGNEST PURCHASE B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/2.","","","2017-07-05 00:00:00","2.","2710000001","","","0","113640.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO MAGOON AGNEST PURCHASE B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/3","","","2017-07-05 00:00:00","3","4010000001","","","560.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/3.","","","2017-07-05 00:00:00","3.","2710000001","","","0","560.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/4","","","2017-07-05 00:00:00","4","1910000030","","","10000.000000000000000000000000000000","0","SALARY PAYABLE BABAR","BALANCE SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/4.","","","2017-07-05 00:00:00","4.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE BABAR/BALANCE SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/5","","","2017-07-05 00:00:00","5","4010000001","","","350.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","T BAG MILK ETC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/5.","","","2017-07-05 00:00:00","5.","2710000001","","","0","350.000000000000000000000000000000","Cash In Hand","/T BAG MILK ETC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/6","","","2017-07-05 00:00:00","6","1910000027","","","3800.000000000000000000000000000000","0","SALARY PAYABLE NASIR","BALANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/6.","","","2017-07-05 00:00:00","6.","2710000001","","","0","3800.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/BALANCE SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/7","","","2017-07-05 00:00:00","7","1910000029","","","1500.000000000000000000000000000000","0","SALARY PAYABLE TAYYAB","BALANCE SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070005/7.","","","2017-07-05 00:00:00","7.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE TAYYAB/BALANCE SALARY TAYYEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/1","","","2017-07-06 00:00:00","1","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/1.","","","2017-07-06 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/10","","","2017-07-06 00:00:00","10","2620000001","","","50000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO MUBASHER FOR BATH TEC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/10.","","","2017-07-06 00:00:00","10.","2710000001","","","0","50000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO MUBASHER FOR BATH TEC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/11","","","2017-07-06 00:00:00","11","4010000001","","","255.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/11.","","","2017-07-06 00:00:00","11.","2710000001","","","0","255.000000000000000000000000000000","Cash In Hand","/PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/12","","","2017-07-06 00:00:00","12","4010000001","","","175.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUTOMER ENTERTMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/12.","","","2017-07-06 00:00:00","12.","2710000001","","","0","175.000000000000000000000000000000","Cash In Hand","/CUTOMER ENTERTMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/13","","","2017-07-06 00:00:00","13","4010000001","","","560.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/13.","","","2017-07-06 00:00:00","13.","2710000001","","","0","560.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/14","","","2017-07-06 00:00:00","14","4010000006","","","500.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/14.","","","2017-07-06 00:00:00","14.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/PETROL FOR GERNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/15","","","2017-07-06 00:00:00","15","2620000001","","","7000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/15.","","","2017-07-06 00:00:00","15.","2710000001","","","0","7000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/16","","","2017-07-06 00:00:00","16","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K C/O HAPPY SB FOR HAMEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/16.","","","2017-07-06 00:00:00","16.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K C/O HAPPY SB FOR HAMEED","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/17","","","2017-07-06 00:00:00","17","0100020001","","","5000.000000000000000000000000000000","0","Happy Malik Sb","PERSONAL HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/17.","","","2017-07-06 00:00:00","17.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","/PERSONAL HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/18","","","2017-07-06 00:00:00","18","4010000003","","","320.000000000000000000000000000000","0","OTHER EXPENSES","BILTY RCD FROM GUJRAWALA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/18.","","","2017-07-06 00:00:00","18.","2710000001","","","0","320.000000000000000000000000000000","Cash In Hand","/BILTY RCD FROM GUJRAWALA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/19","","","2017-07-06 00:00:00","19","2620000001","","","20000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K TAYYEB C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/19.","","","2017-07-06 00:00:00","19.","2710000001","","","0","20000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K TAYYEB C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/2","","","2017-07-06 00:00:00","2","4010000001","","","200.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/2.","","","2017-07-06 00:00:00","2.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/3","","","2017-07-06 00:00:00","3","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/3.","","","2017-07-06 00:00:00","3.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/4","","","2017-07-06 00:00:00","4","1910000003","","","28000.000000000000000000000000000000","0","SALARY PAYABLE Rashid","BALANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/4.","","","2017-07-06 00:00:00","4.","2710000001","","","0","28000.000000000000000000000000000000","Cash In Hand","/BALANCE SALARY RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/5","","","2017-07-06 00:00:00","5","1910000001","","","22000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","BALANCE SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/5.","","","2017-07-06 00:00:00","5.","2710000001","","","0","22000.000000000000000000000000000000","Cash In Hand","/BALANCE SALARY SHAHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/6","","","2017-07-06 00:00:00","6","1910000028","","","16000.000000000000000000000000000000","0","SALARY PAYABLE MURTAZA","BALANCE SALARY MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/6.","","","2017-07-06 00:00:00","6.","2710000001","","","0","16000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE MURTAZA/BALANCE SALARY MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/7","","","2017-07-06 00:00:00","7","0100020009","","","17000.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO SHAFIQ SB C/O HASEEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/7.","","","2017-07-06 00:00:00","7.","2710000001","","","0","17000.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO SHAFIQ SB C/O HASEEB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/8","","","2017-07-06 00:00:00","8","0100020009","","","34000.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO HASEEB FOR WOOD FLOOR FOR FAROOQ SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/8.","","","2017-07-06 00:00:00","8.","2710000001","","","0","34000.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO HASEEB FOR WOOD FLOOR FOR FAROOQ SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/9","","","2017-07-06 00:00:00","9","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR MURTAZA 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070006/9.","","","2017-07-06 00:00:00","9.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR MURTAZA 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/1","","","2017-07-07 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/1.","","","2017-07-07 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/12","","","2017-07-07 00:00:00","12","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","REPAIR PHONE PAID TO LINE MAN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/12.","","","2017-07-07 00:00:00","12.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/REPAIR PHONE PAID TO LINE MAN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/13","","","2017-07-07 00:00:00","13","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/13.","","","2017-07-07 00:00:00","13.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/14","","","2017-07-07 00:00:00","14","2620000001","","","40000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K CHQ RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/14.","","","2017-07-07 00:00:00","14.","2710000001","","","0","40000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K CHQ RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/2","","","2017-07-07 00:00:00","2","4010000007","","","110.000000000000000000000000000000","0","Stationary Expenses","PURCHASE STATIONARY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/2.","","","2017-07-07 00:00:00","2.","2710000001","","","0","110.000000000000000000000000000000","Cash In Hand","/PURCHASE STATIONARY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/3","","","2017-07-07 00:00:00","3","4010000003","","","130.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE HARDWARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/3.","","","2017-07-07 00:00:00","3.","2710000001","","","0","130.000000000000000000000000000000","Cash In Hand","/PURCHASE HARDWARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/4","","","2017-07-07 00:00:00","4","2620000001","","","13000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K AGNEST BALANC COMMODE VIZDAM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/4.","","","2017-07-07 00:00:00","4.","2710000001","","","0","13000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K AGNEST BALANC COMMODE VIZDAM","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/5","","","2017-07-07 00:00:00","5","4010000001","","","300.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/5.","","","2017-07-07 00:00:00","5.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/6","","","2017-07-07 00:00:00","6","4010000009","","","160.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/6.","","","2017-07-07 00:00:00","6.","2710000001","","","0","160.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/7","","","2017-07-07 00:00:00","7","2620000001","","","4000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO NADEEM B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/7.","","","2017-07-07 00:00:00","7.","2710000001","","","0","4000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO NADEEM B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/8","","","2017-07-07 00:00:00","8","0100020009","","","1500.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO HASEEB  AGNEST PROFIT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/8.","","","2017-07-07 00:00:00","8.","2710000001","","","0","1500.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO HASEEB  AGNEST PROFIT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/9","","","2017-07-07 00:00:00","9","4010000001","","","90.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070007/9.","","","2017-07-07 00:00:00","9.","2710000001","","","0","90.000000000000000000000000000000","Cash In Hand","/CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/1","","","2017-07-08 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/1.","","","2017-07-08 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/10","","","2017-07-08 00:00:00","10","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR WAQAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/10.","","","2017-07-08 00:00:00","10.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR WAQAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/11","","","2017-07-08 00:00:00","11","2620000001","","","80000.000000000000000000000000000000","0","Bath & Kitchen","CASH GIVEN TO B/K C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/11.","","","2017-07-08 00:00:00","11.","2710000001","","","0","80000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CASH GIVEN TO B/K C/O HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/12","","","2017-07-08 00:00:00","12","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/12.","","","2017-07-08 00:00:00","12.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/13","","","2017-07-08 00:00:00","13","2620000001","","","25500.000000000000000000000000000000","0","Bath & Kitchen","CHQ TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/13.","","","2017-07-08 00:00:00","13.","2710000001","","","0","25500.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ TO B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/2","","","2017-07-08 00:00:00","2","4010000001","","","350.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PURCHASE MILK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/2.","","","2017-07-08 00:00:00","2.","2710000001","","","0","350.000000000000000000000000000000","Cash In Hand","/PURCHASE MILK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/3","","","2017-07-08 00:00:00","3","4010000003","","","40.000000000000000000000000000000","0","OTHER EXPENSES","HARD WARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/3.","","","2017-07-08 00:00:00","3.","2710000001","","","0","40.000000000000000000000000000000","Cash In Hand","/HARD WARE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/4","","","2017-07-08 00:00:00","4","4010000001","","","296.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/4.","","","2017-07-08 00:00:00","4.","2710000001","","","0","296.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/5","","","2017-07-08 00:00:00","5","0100020001","","","4000.000000000000000000000000000000","0","Happy Malik Sb","PERSONAL HAPPY SB ( TYER )","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/5.","","","2017-07-08 00:00:00","5.","2710000001","","","0","4000.000000000000000000000000000000","Cash In Hand","/PERSONAL HAPPY SB ( TYER )","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/6","","","2017-07-08 00:00:00","6","2620000001","","","128000.000000000000000000000000000000","0","Bath & Kitchen","CHQ GIVEN TO B/K BILL NO 1176 , 1177","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/6.","","","2017-07-08 00:00:00","6.","2710000001","","","0","128000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/CHQ GIVEN TO B/K BILL NO 1176 , 1177","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/7","","","2017-07-08 00:00:00","7","2620000001","","","8000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO NADEEM C/O HAPPY SB B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/7.","","","2017-07-08 00:00:00","7.","2710000001","","","0","8000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO NADEEM C/O HAPPY SB B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/8","","","2017-07-08 00:00:00","8","4010000001","","","150.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/8.","","","2017-07-08 00:00:00","8.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/CUTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/9","","","2017-07-08 00:00:00","9","4010000009","","","170.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070008/9.","","","2017-07-08 00:00:00","9.","2710000001","","","0","170.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/1","","","2017-07-10 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/1.","","","2017-07-10 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003 MURTAZA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/10","","","2017-07-10 00:00:00","10","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL RASHID + BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/10.","","","2017-07-10 00:00:00","10.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL RASHID + BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/2","","","2017-07-10 00:00:00","2","0100020002","","","400.000000000000000000000000000000","0","Waseem Sb","PERSONAL WASEEM SB ( FEE )","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/2.","","","2017-07-10 00:00:00","2.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PERSONAL WASEEM SB ( FEE )","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/3","","","2017-07-10 00:00:00","3","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/3.","","","2017-07-10 00:00:00","3.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/4","","","2017-07-10 00:00:00","4","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE TAP AND DORI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/4.","","","2017-07-10 00:00:00","4.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PURCHASE TAP AND DORI","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/5","","","2017-07-10 00:00:00","5","4010000001","","","390.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","TEA BAGS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/5.","","","2017-07-10 00:00:00","5.","2710000001","","","0","390.000000000000000000000000000000","Cash In Hand","/TEA BAGS","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/6","","","2017-07-10 00:00:00","6","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","CROCKRY ( GLASS )","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/6.","","","2017-07-10 00:00:00","6.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/CROCKRY ( GLASS )","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/7","","","2017-07-10 00:00:00","7","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K THROGH HAPPY SB TO AMEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/7.","","","2017-07-10 00:00:00","7.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K THROGH HAPPY SB TO AMEEN","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/8","","","2017-07-10 00:00:00","8","4010000001","","","520.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/8.","","","2017-07-10 00:00:00","8.","2710000001","","","0","520.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/9","","","2017-07-10 00:00:00","9","4010000009","","","150.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070009/9.","","","2017-07-10 00:00:00","9.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/1","","","2017-07-11 00:00:00","1","4010000006","","","200.000000000000000000000000000000","0","Fuel Expenses","PETROL+ REPAIR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/1.","","","2017-07-11 00:00:00","1.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/PETROL+ REPAIR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/10","","","2017-07-11 00:00:00","10","1910000001","","","8000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANC SALRY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/10.","","","2017-07-11 00:00:00","10.","2710000001","","","0","8000.000000000000000000000000000000","Cash In Hand","/ADVANC SALRY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/2","","","2017-07-11 00:00:00","2","2620000001","","","5000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K FOR SONEX","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/2.","","","2017-07-11 00:00:00","2.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K FOR SONEX","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/3","","","2017-07-11 00:00:00","3","4010000001","","","250.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/3.","","","2017-07-11 00:00:00","3.","2710000001","","","0","250.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/4","","","2017-07-11 00:00:00","4","4010000009","","","90.000000000000000000000000000000","0","CHARITY PAID","ZAKAT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/4.","","","2017-07-11 00:00:00","4.","2710000001","","","0","90.000000000000000000000000000000","Cash In Hand","/ZAKAT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/5","","","2017-07-11 00:00:00","5","2620000001","","","11900.000000000000000000000000000000","0","Bath & Kitchen","PAID TO MAGOON AGNEST SONEX PURCHASE B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/5.","","","2017-07-11 00:00:00","5.","2710000001","","","0","11900.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO MAGOON AGNEST SONEX PURCHASE B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/6","","","2017-07-11 00:00:00","6","2620000001","","","10000.000000000000000000000000000000","0","Bath & Kitchen","PAID CASH TO MODREN JALI B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/6.","","","2017-07-11 00:00:00","6.","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID CASH TO MODREN JALI B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/7","","","2017-07-11 00:00:00","7","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR WAQAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/7.","","","2017-07-11 00:00:00","7.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR WAQAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/8","","","2017-07-11 00:00:00","8","4010000001","","","240.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUTOMER ENTERTANMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/8.","","","2017-07-11 00:00:00","8.","2710000001","","","0","240.000000000000000000000000000000","Cash In Hand","/CUTOMER ENTERTANMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/9","","","2017-07-11 00:00:00","9","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","REPAIR 8003 TUBE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070010/9.","","","2017-07-11 00:00:00","9.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/REPAIR 8003 TUBE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/1","","","2017-07-12 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/1.","","","2017-07-12 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/2","","","2017-07-12 00:00:00","2","4010000007","","","35.000000000000000000000000000000","0","Stationary Expenses","PHOTO COPY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/2.","","","2017-07-12 00:00:00","2.","2710000001","","","0","35.000000000000000000000000000000","Cash In Hand","/PHOTO COPY","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/3","","","2017-07-12 00:00:00","3","4010000001","","","440.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/3.","","","2017-07-12 00:00:00","3.","2710000001","","","0","440.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/4","","","2017-07-12 00:00:00","4","4010000003","","","170.000000000000000000000000000000","0","OTHER EXPENSES","TISSUE + SAOP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/4.","","","2017-07-12 00:00:00","4.","2710000001","","","0","170.000000000000000000000000000000","Cash In Hand","/TISSUE + SAOP","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/5","","","2017-07-12 00:00:00","5","4010000009","","","110.000000000000000000000000000000","0","CHARITY PAID","ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/5.","","","2017-07-12 00:00:00","5.","2710000001","","","0","110.000000000000000000000000000000","Cash In Hand","/ZAKAT 2017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/6","","","2017-07-12 00:00:00","6","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/6.","","","2017-07-12 00:00:00","6.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/7","","","2017-07-12 00:00:00","7","2620000001","","","160000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K BILL NO 1173","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/7.","","","2017-07-12 00:00:00","7.","2710000001","","","0","160000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K BILL NO 1173","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/8","","","2017-07-12 00:00:00","8","4010000003","","","300.000000000000000000000000000000","0","OTHER EXPENSES","PURCHASE AIR FRESHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/8.","","","2017-07-12 00:00:00","8.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/PURCHASE AIR FRESHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/9","","","2017-07-12 00:00:00","9","2620000001","","","40000.000000000000000000000000000000","0","Bath & Kitchen","ONLIN BILL NO 1179 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070011/9.","","","2017-07-12 00:00:00","9.","2710000001","","","0","40000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/ONLIN BILL NO 1179 B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/1","","","2017-07-13 00:00:00","1","4010000006","","","150.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/1.","","","2017-07-13 00:00:00","1.","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/10","","","2017-07-13 00:00:00","10","0100020009","","","500.000000000000000000000000000000","0","HASEEB WALPAPER","PAID TO HASEEB AGNEST PROFIT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/10.","","","2017-07-13 00:00:00","10.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","HASEEB WALPAPER/PAID TO HASEEB AGNEST PROFIT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/11","","","2017-07-13 00:00:00","11","2620000001","","","15000.000000000000000000000000000000","0","Bath & Kitchen","PAID TO B/K SONEX PURCHASE MAHMOOD SON","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/11.","","","2017-07-13 00:00:00","11.","2710000001","","","0","15000.000000000000000000000000000000","Cash In Hand","Bath & Kitchen/PAID TO B/K SONEX PURCHASE MAHMOOD SON","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/12","","","2017-07-13 00:00:00","12","4010000009","","","70.000000000000000000000000000000","0","CHARITY PAID","ZAKAT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/12.","","","2017-07-13 00:00:00","12.","2710000001","","","0","70.000000000000000000000000000000","Cash In Hand","/ZAKAT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/2","","","2017-07-13 00:00:00","2","4010000004","","","170.000000000000000000000000000000","0","Travelling Expenses","BILTY RCIPT GUJRAWALA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/2.","","","2017-07-13 00:00:00","2.","2710000001","","","0","170.000000000000000000000000000000","Cash In Hand","/BILTY RCIPT GUJRAWALA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/3","","","2017-07-13 00:00:00","3","4010000001","","","410.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","TEA BAGG  SUGAR + MILK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/3.","","","2017-07-13 00:00:00","3.","2710000001","","","0","410.000000000000000000000000000000","Cash In Hand","/TEA BAGG  SUGAR + MILK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/4","","","2017-07-13 00:00:00","4","4010000006","","","400.000000000000000000000000000000","0","Fuel Expenses","PETROL GARNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/4.","","","2017-07-13 00:00:00","4.","2710000001","","","0","400.000000000000000000000000000000","Cash In Hand","/PETROL GARNATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/5","","","2017-07-13 00:00:00","5","4010000001","","","500.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/5.","","","2017-07-13 00:00:00","5.","2710000001","","","0","500.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/6","","","2017-07-13 00:00:00","6","4010000001","","","340.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/6.","","","2017-07-13 00:00:00","6.","2710000001","","","0","340.000000000000000000000000000000","Cash In Hand","/PURCHASE WATER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/7","","","2017-07-13 00:00:00","7","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/7.","","","2017-07-13 00:00:00","7.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR RASHID","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/8","","","2017-07-13 00:00:00","8","1910000027","","","3000.000000000000000000000000000000","0","SALARY PAYABLE NASIR","ADVANC SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/8.","","","2017-07-13 00:00:00","8.","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE NASIR/ADVANC SALARY NASIR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/9","","","2017-07-13 00:00:00","9","1910000001","","","5000.000000000000000000000000000000","0","SALARY PAYABLE SHAHID SHEIKH","ADVANC SALARY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070012/9.","","","2017-07-13 00:00:00","9.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","/ADVANC SALARY SHAHID SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/1","","","2017-07-14 00:00:00","1","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/1.","","","2017-07-14 00:00:00","1.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/10","","","2017-07-14 00:00:00","10","4010000006","","","100.000000000000000000000000000000","0","Fuel Expenses","PETROL FOR WAQAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/10.","","","2017-07-14 00:00:00","10.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/PETROL FOR WAQAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/11","","","2017-07-14 00:00:00","11","4010000001","","","300.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/11.","","","2017-07-14 00:00:00","11.","2710000001","","","0","300.000000000000000000000000000000","Cash In Hand","/LUNCH","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/2","","","2017-07-14 00:00:00","2","4010000004","","","800.000000000000000000000000000000","0","Travelling Expenses","RENT CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/2.","","","2017-07-14 00:00:00","2.","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","/RENT CUSTOMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/3","","","2017-07-14 00:00:00","3","4010000003","","","100.000000000000000000000000000000","0","OTHER EXPENSES","WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/3.","","","2017-07-14 00:00:00","3.","2710000001","","","0","100.000000000000000000000000000000","Cash In Hand","/WARID CARD","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/4","","","2017-07-14 00:00:00","4","4010000007","","","240.000000000000000000000000000000","0","Stationary Expenses","PHOTO COPY BILL BOOK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/4.","","","2017-07-14 00:00:00","4.","2710000001","","","0","240.000000000000000000000000000000","Cash In Hand","/PHOTO COPY BILL BOOK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/5","","","2017-07-14 00:00:00","5","4010000001","","","60.000000000000000000000000000000","0","ENTERTAINMENT EXPENSES","CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/5.","","","2017-07-14 00:00:00","5.","2710000001","","","0","60.000000000000000000000000000000","Cash In Hand","/CUSTOMER ENTERTAINMENT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/6","","","2017-07-14 00:00:00","6","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","CHALAN 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/6.","","","2017-07-14 00:00:00","6.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/CHALAN 8003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/7","","","2017-07-14 00:00:00","7","1910000030","","","5000.000000000000000000000000000000","0","SALARY PAYABLE BABAR","ADVANC SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/7.","","","2017-07-14 00:00:00","7.","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","SALARY PAYABLE BABAR/ADVANC SALARY BABAR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/8","","","2017-07-14 00:00:00","8","4010000003","","","200.000000000000000000000000000000","0","OTHER EXPENSES","AIR FRASHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/8.","","","2017-07-14 00:00:00","8.","2710000001","","","0","200.000000000000000000000000000000","Cash In Hand","/AIR FRASHNER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/9","","","2017-07-14 00:00:00","9","4010000009","","","140.000000000000000000000000000000","0","CHARITY PAID","ZAKAT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CP070013/9.","","","2017-07-14 00:00:00","9.","2710000001","","","0","140.000000000000000000000000000000","Cash In Hand","/ZAKAT","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060001/1","","","2017-06-01 00:00:00","1","2610000001","","","0","40000.000000000000000000000000000000","Walk-In-Customers","Bill#1082 / BALANCE BILL NO 1082","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060001/1.","","","2017-06-01 00:00:00","1.","2710000001","","","40000.000000000000000000000000000000","0","Cash In Hand","Bill#1082 / /BALANCE BILL NO 1082","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060002/1","","","2017-06-02 00:00:00","1","2610000001","","","0","35000.000000000000000000000000000000","Walk-In-Customers","Bill#3191 / BALANCE BILL NO 3191","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060002/1.","","","2017-06-02 00:00:00","1.","2710000001","","","35000.000000000000000000000000000000","0","Cash In Hand","Bill#3191 / /BALANCE BILL NO 3191","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060002/2","","","2017-06-02 00:00:00","2","2610000001","","","0","78000.000000000000000000000000000000","Walk-In-Customers","Bill#1073 / BALANCE BILL NO 1073","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060002/2.","","","2017-06-02 00:00:00","2.","2710000001","","","78000.000000000000000000000000000000","0","Cash In Hand","Bill#1073 / /BALANCE BILL NO 1073","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060003/1","","","2017-06-03 00:00:00","1","2610000001","","","0","25000.000000000000000000000000000000","Walk-In-Customers","Bill#1085 / BALANCE BILL NO 1085","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060003/1.","","","2017-06-03 00:00:00","1.","2710000001","","","25000.000000000000000000000000000000","0","Cash In Hand","Bill#1085 / /BALANCE BILL NO 1085","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060004/1","","","2017-06-07 00:00:00","1","2610000001","","","0","11000.000000000000000000000000000000","Walk-In-Customers","BALANCE BILL NO 1085","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060004/1.","","","2017-06-07 00:00:00","1.","2710000001","","","11000.000000000000000000000000000000","0","Cash In Hand","/BALANCE BILL NO 1085","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060005/1","","","2017-06-08 00:00:00","1","2610000001","","","0","20000.000000000000000000000000000000","Walk-In-Customers","Bill#1051 / BALAANCE BILL NO 1051","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060005/1.","","","2017-06-08 00:00:00","1.","2710000001","","","20000.000000000000000000000000000000","0","Cash In Hand","Bill#1051 / /BALAANCE BILL NO 1051","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060005/2","","","2017-06-08 00:00:00","2","2610000001","","","0","17900.000000000000000000000000000000","Walk-In-Customers","Bill#3366 / BALAANCE BILL NO 3366","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060005/2.","","","2017-06-08 00:00:00","2.","2710000001","","","17900.000000000000000000000000000000","0","Cash In Hand","Bill#3366 / /BALAANCE BILL NO 3366","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060006/1","","","2017-06-08 00:00:00","1","4010000003","","","0","5500.000000000000000000000000000000","OTHER EXPENSES","RTN WOOD FLOOR TO SHOP KEPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060006/1.","","","2017-06-08 00:00:00","1.","2710000001","","","5500.000000000000000000000000000000","0","Cash In Hand","/RTN WOOD FLOOR TO SHOP KEPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060006/2","","","2017-06-08 00:00:00","2","4010000003","","","0","4300.000000000000000000000000000000","OTHER EXPENSES","RTN WOOD FLOOR TO SHOP KEPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060006/2.","","","2017-06-08 00:00:00","2.","2710000001","","","4300.000000000000000000000000000000","0","Cash In Hand","/RTN WOOD FLOOR TO SHOP KEPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060007/1","","","2017-06-10 00:00:00","1","2610000030","","","0","2000.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#3367 / BALANCE BILL NO 3367","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060007/1.","","","2017-06-10 00:00:00","1.","2710000001","","","2000.000000000000000000000000000000","0","Cash In Hand","Bill#3367 / 200/1-B ST-NO #1 PHASE-5 DHA/BALANCE BILL NO 3367","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/2","","","2017-06-12 00:00:00","2","2610000001","","","0","66500.000000000000000000000000000000","Walk-In-Customers","Bill#1087 / BALANCE BILL NO 1087","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/2.","","","2017-06-12 00:00:00","2.","2710000001","","","66500.000000000000000000000000000000","0","Cash In Hand","Bill#1087 / /BALANCE BILL NO 1087","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/3","","","2017-06-12 00:00:00","3","2610000001","","","0","28000.000000000000000000000000000000","Walk-In-Customers","Bill#1091 / BALANCE BILL NO 1091","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/3.","","","2017-06-12 00:00:00","3.","2710000001","","","28000.000000000000000000000000000000","0","Cash In Hand","Bill#1091 / /BALANCE BILL NO 1091","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/4","","","2017-06-12 00:00:00","4","2610000001","","","0","7000.000000000000000000000000000000","Walk-In-Customers","Bill#3354 / BALANCE BILL NO 3354","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/4.","","","2017-06-12 00:00:00","4.","2710000001","","","7000.000000000000000000000000000000","0","Cash In Hand","Bill#3354 / /BALANCE BILL NO 3354","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/5","","","2017-06-12 00:00:00","5","2610000001","","","0","17500.000000000000000000000000000000","Walk-In-Customers","Bill#1074 / BALANCE BILL NO 1074","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/5.","","","2017-06-12 00:00:00","5.","2710000001","","","17500.000000000000000000000000000000","0","Cash In Hand","Bill#1074 / /BALANCE BILL NO 1074","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/6","","","2017-06-12 00:00:00","6","2610000001","","","0","150000.000000000000000000000000000000","Walk-In-Customers","Bill#060011 / BALANCE BILL NO 060011","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060008/6.","","","2017-06-12 00:00:00","6.","2710000001","","","150000.000000000000000000000000000000","0","Cash In Hand","Bill#060011 / /BALANCE BILL NO 060011","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060009/1","","","2017-06-07 00:00:00","1","4010000003","","","0","8221.000000000000000000000000000000","OTHER EXPENSES","RTN TO SHOP BASIN MIXER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060009/1.","","","2017-06-07 00:00:00","1.","2710000001","","","8221.000000000000000000000000000000","0","Cash In Hand","/RTN TO SHOP BASIN MIXER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060010/1","","","2017-06-07 00:00:00","1","2610000001","","","0","15000.000000000000000000000000000000","Walk-In-Customers","Bill#1094 / BALANCE BILL 060012 (1094)","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060010/1.","","","2017-06-07 00:00:00","1.","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1094 / /BALANCE BILL 060012 (1094)","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/1","","","2017-06-13 00:00:00","1","2610000001","","","0","7900.000000000000000000000000000000","Walk-In-Customers","Bill#3376 / BALANCE BILL NO 3376","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/1.","","","2017-06-13 00:00:00","1.","2710000001","","","7900.000000000000000000000000000000","0","Cash In Hand","Bill#3376 / /BALANCE BILL NO 3376","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/2","","","2017-06-13 00:00:00","2","2610000001","","","0","800.000000000000000000000000000000","Walk-In-Customers","Bill#1051 / BALANCE BILL NO 1051","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/2.","","","2017-06-13 00:00:00","2.","2710000001","","","800.000000000000000000000000000000","0","Cash In Hand","Bill#1051 / /BALANCE BILL NO 1051","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/3","","","2017-06-13 00:00:00","3","2610000001","","","0","10000.000000000000000000000000000000","Walk-In-Customers","Bill#1009 / BALANCE BILL NO 1009","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/3.","","","2017-06-13 00:00:00","3.","2710000001","","","10000.000000000000000000000000000000","0","Cash In Hand","Bill#1009 / /BALANCE BILL NO 1009","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/4","","","2017-06-13 00:00:00","4","2610000001","","","0","17000.000000000000000000000000000000","Walk-In-Customers","Bill#1017 / BALANCE BILL NO 1017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060011/4.","","","2017-06-13 00:00:00","4.","2710000001","","","17000.000000000000000000000000000000","0","Cash In Hand","Bill#1017 / /BALANCE BILL NO 1017","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060012/1","","","2017-06-14 00:00:00","1","2610000001","","","0","20000.000000000000000000000000000000","Walk-In-Customers","Bill#3352 / BALANCE BILL NO 3352","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060012/1.","","","2017-06-14 00:00:00","1.","2710000001","","","20000.000000000000000000000000000000","0","Cash In Hand","Bill#3352 / /BALANCE BILL NO 3352","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060012/2","","","2017-06-14 00:00:00","2","2610000056","","","0","30000.000000000000000000000000000000","242/L PH# 5 DHA  MR.UMAR","Bill#3353 / BALANCE BILL NO 3353","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060012/2.","","","2017-06-14 00:00:00","2.","2710000001","","","30000.000000000000000000000000000000","0","Cash In Hand","Bill#3353 / 242/L PH# 5 DHA  MR.UMAR/BALANCE BILL NO 3353","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060013/1","","","2017-06-15 00:00:00","1","2610000001","","","0","7000.000000000000000000000000000000","Walk-In-Customers","Bill#1051 / BALANCE BILL NO 1051","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060013/1.","","","2017-06-15 00:00:00","1.","2710000001","","","7000.000000000000000000000000000000","0","Cash In Hand","Bill#1051 / /BALANCE BILL NO 1051","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060013/2","","","2017-06-15 00:00:00","2","4010000003","","","0","12200.000000000000000000000000000000","OTHER EXPENSES","BILL NO 1086 WOOD FLOOR RTN TO SHOP KEEPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060013/2.","","","2017-06-15 00:00:00","2.","2710000001","","","12200.000000000000000000000000000000","0","Cash In Hand","/BILL NO 1086 WOOD FLOOR RTN TO SHOP KEEPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060014/1","","","2017-06-17 00:00:00","1","2620000001","","","0","60000.000000000000000000000000000000","Bath & Kitchen","RECEIPTS FROM B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060014/1.","","","2017-06-17 00:00:00","1.","2710000001","","","60000.000000000000000000000000000000","0","Cash In Hand","Bath & Kitchen/RECEIPTS FROM B/K THROGH HAPPY SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060015/1","","","2017-06-19 00:00:00","1","2610000040","","","0","100000.000000000000000000000000000000","SHOAIB KHAN SB","Bill#3199,3200, / BALANCE BILL NO 3199+3200+1021+3355+3680+1798","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060015/1.","","","2017-06-19 00:00:00","1.","2710000001","","","100000.000000000000000000000000000000","0","Cash In Hand","Bill#3199,3200, / SHOAIB KHAN SB/BALANCE BILL NO 3199+3200+1021+3355+3680+1798","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060016/1","","","2017-06-22 00:00:00","1","2610000038","","","0","34500.000000000000000000000000000000","MALL OF SIALKOT","Bill#1102 / BALANCE BILL NO 1102","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060016/1.","","","2017-06-22 00:00:00","1.","2710000001","","","34500.000000000000000000000000000000","0","Cash In Hand","Bill#1102 / MALL OF SIALKOT/BALANCE BILL NO 1102","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060016/2","","","2017-06-22 00:00:00","2","2610000038","","","0","18000.000000000000000000000000000000","MALL OF SIALKOT","Bill#1103 / BALANCE BILL NO 1103","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060016/2.","","","2017-06-22 00:00:00","2.","2710000001","","","18000.000000000000000000000000000000","0","Cash In Hand","Bill#1103 / MALL OF SIALKOT/BALANCE BILL NO 1103","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060016/3","","","2017-06-22 00:00:00","3","2610000038","","","0","32000.000000000000000000000000000000","MALL OF SIALKOT","Bill#1104 / BALANCE BILL NO 1104","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060016/3.","","","2017-06-22 00:00:00","3.","2710000001","","","32000.000000000000000000000000000000","0","Cash In Hand","Bill#1104 / MALL OF SIALKOT/BALANCE BILL NO 1104","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060017/1","","","2017-06-23 00:00:00","1","2610000058","","","0","100000.000000000000000000000000000000","AFTAB SB","Bill#1147 / PAYMENT RED FROM AFTAB SB AGNAST 25 PEC VANITY PVC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060017/1.","","","2017-06-23 00:00:00","1.","2710000001","","","100000.000000000000000000000000000000","0","Cash In Hand","Bill#1147 / AFTAB SB/PAYMENT RED FROM AFTAB SB AGNAST 25 PEC VANITY PVC","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060017/2","","","2017-06-23 00:00:00","2","2610000032","","","0","40000.000000000000000000000000000000","AHMAD SB","Bill#1198 / ADVANCE PAYMENT RED FROM AHMAD SB AGNST WOOD FLOOR 1198 BILL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060017/2.","","","2017-06-23 00:00:00","2.","2710000001","","","40000.000000000000000000000000000000","0","Cash In Hand","Bill#1198 / AHMAD SB/ADVANCE PAYMENT RED FROM AHMAD SB AGNST WOOD FLOOR 1198 BILL","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060018/1","","","2017-06-24 00:00:00","1","0100020009","","","0","40000.000000000000000000000000000000","HASEEB WALPAPER","RTN BY HASEEB AGNAST WOOD FLOOR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060018/1.","","","2017-06-24 00:00:00","1.","2710000001","","","40000.000000000000000000000000000000","0","Cash In Hand","HASEEB WALPAPER/RTN BY HASEEB AGNAST WOOD FLOOR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060019/1","","","2017-06-29 00:00:00","1","2610000035","","","0","5600.000000000000000000000000000000","MR. ANEES SB 0321-4185133","Bill#1142 / BALANCE BILL NO 1142","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060019/1.","","","2017-06-29 00:00:00","1.","2710000001","","","5600.000000000000000000000000000000","0","Cash In Hand","Bill#1142 / MR. ANEES SB 0321-4185133/BALANCE BILL NO 1142","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060019/2","","","2017-06-29 00:00:00","2","2610000035","","","0","400.000000000000000000000000000000","MR. ANEES SB 0321-4185133","Bill#1141 / BALANCE BILL NO 1141","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR060019/2.","","","2017-06-29 00:00:00","2.","2710000001","","","400.000000000000000000000000000000","0","Cash In Hand","Bill#1141 / MR. ANEES SB 0321-4185133/BALANCE BILL NO 1141","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070001/1","","","2017-07-03 00:00:00","1","2610000001","","","0","43000.000000000000000000000000000000","Walk-In-Customers","Bill#1153 / BALANCE BILL NO 1153","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070001/1.","","","2017-07-03 00:00:00","1.","2710000001","","","43000.000000000000000000000000000000","0","Cash In Hand","Bill#1153 / /BALANCE BILL NO 1153","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070002/1","","","2017-07-03 00:00:00","1","2610000041","","","0","19000.000000000000000000000000000000","NADEEM SB CUSTOMER","Bill#1109 / BALANCE BILL NO 1109","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070002/1.","","","2017-07-03 00:00:00","1.","2710000001","","","19000.000000000000000000000000000000","0","Cash In Hand","Bill#1109 / NADEEM SB CUSTOMER/BALANCE BILL NO 1109","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070003/1","","","2017-07-05 00:00:00","1","2610000001","","","0","235000.000000000000000000000000000000","Walk-In-Customers","Bill#2244 / BALANCE B/K BILL NO 2244 SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070003/1.","","","2017-07-05 00:00:00","1.","2710000001","","","235000.000000000000000000000000000000","0","Cash In Hand","Bill#2244 / /BALANCE B/K BILL NO 2244 SALE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070004/1","","","2017-07-06 00:00:00","1","2610000049","","","0","8500.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Bill#1138 / BALANC BILL NO 1138","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070004/1.","","","2017-07-06 00:00:00","1.","2710000001","","","8500.000000000000000000000000000000","0","Cash In Hand","Bill#1138 / HAJI HAKM SB 73 / C PH# 6/BALANC BILL NO 1138","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070004/2","","","2017-07-06 00:00:00","2","2610000052","","","0","18000.000000000000000000000000000000","DR. ASIM SB 03214864288","Bill#1014 / BALANC BILL NO 1014","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070004/2.","","","2017-07-06 00:00:00","2.","2710000001","","","18000.000000000000000000000000000000","0","Cash In Hand","Bill#1014 / DR. ASIM SB 03214864288/BALANC BILL NO 1014","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070005/1","","","2017-07-07 00:00:00","1","2610000056","","","0","2400.000000000000000000000000000000","242/L PH# 5 DHA  MR.UMAR","Bill#3385 / BALANCE BILL NO 3385","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070005/1.","","","2017-07-07 00:00:00","1.","2710000001","","","2400.000000000000000000000000000000","0","Cash In Hand","Bill#3385 / 242/L PH# 5 DHA  MR.UMAR/BALANCE BILL NO 3385","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070005/2","","","2017-07-07 00:00:00","2","2610000056","","","0","24900.000000000000000000000000000000","242/L PH# 5 DHA  MR.UMAR","Bill#3353 / BALANC BILL NO 3353","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070005/2.","","","2017-07-07 00:00:00","2.","2710000001","","","24900.000000000000000000000000000000","0","Cash In Hand","Bill#3353 / 242/L PH# 5 DHA  MR.UMAR/BALANC BILL NO 3353","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070005/3","","","2017-07-07 00:00:00","3","2610000056","","","0","12700.000000000000000000000000000000","242/L PH# 5 DHA  MR.UMAR","Bill#1057 / BALANC BILL NO 1057","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070005/3.","","","2017-07-07 00:00:00","3.","2710000001","","","12700.000000000000000000000000000000","0","Cash In Hand","Bill#1057 / 242/L PH# 5 DHA  MR.UMAR/BALANC BILL NO 1057","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/1","","","2017-07-08 00:00:00","1","2610000066","","","0","102800.000000000000000000000000000000","398/B PH# 5 DHA KASHIF SB","Bill#1176 / BALANC BILL 1176","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/1.","","","2017-07-08 00:00:00","1.","2710000001","","","102800.000000000000000000000000000000","0","Cash In Hand","Bill#1176 / 398/B PH# 5 DHA KASHIF SB/BALANC BILL 1176","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/2","","","2017-07-08 00:00:00","2","2610000066","","","0","55200.000000000000000000000000000000","398/B PH# 5 DHA KASHIF SB","Bill#1177 / BALANC BILL NO 1177","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/2.","","","2017-07-08 00:00:00","2.","2710000001","","","55200.000000000000000000000000000000","0","Cash In Hand","Bill#1177 / 398/B PH# 5 DHA KASHIF SB/BALANC BILL NO 1177","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/3","","","2017-07-08 00:00:00","3","2610000054","","","0","28000.000000000000000000000000000000","228/B STAT LIFE","Bill#1018 / BALANC BILL NO 1018","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/3.","","","2017-07-08 00:00:00","3.","2710000001","","","28000.000000000000000000000000000000","0","Cash In Hand","Bill#1018 / 228/B STAT LIFE/BALANC BILL NO 1018","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/4","","","2017-07-08 00:00:00","4","2610000054","","","0","21600.000000000000000000000000000000","228/B STAT LIFE","Bill#1095 / BALANC BILL NO 1095","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/4.","","","2017-07-08 00:00:00","4.","2710000001","","","21600.000000000000000000000000000000","0","Cash In Hand","Bill#1095 / 228/B STAT LIFE/BALANC BILL NO 1095","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/5","","","2017-07-08 00:00:00","5","2610000054","","","0","400.000000000000000000000000000000","228/B STAT LIFE","Bill#1070 / BALANC BILL NO 1070","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070006/5.","","","2017-07-08 00:00:00","5.","2710000001","","","400.000000000000000000000000000000","0","Cash In Hand","Bill#1070 / 228/B STAT LIFE/BALANC BILL NO 1070","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070007/1","","","2017-07-10 00:00:00","1","2610000070","","","0","15000.000000000000000000000000000000","102/CC PHS# 4 DHA SULTAN SB","Bill#1189 / BALANC BILL NO 1189","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070007/1.","","","2017-07-10 00:00:00","1.","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1189 / 102/CC PHS# 4 DHA SULTAN SB/BALANC BILL NO 1189","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070008/1","","","2017-07-11 00:00:00","1","2610000065","","","0","26000.000000000000000000000000000000","H-NO 25/E 35210478","Bill#1174 / BALANC BILL NO 1174","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070008/1.","","","2017-07-11 00:00:00","1.","2710000001","","","26000.000000000000000000000000000000","0","Cash In Hand","Bill#1174 / H-NO 25/E 35210478/BALANC BILL NO 1174","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070009/1","","","2017-07-12 00:00:00","1","2610000067","","","0","40000.000000000000000000000000000000","KHAZIR SB SOI GAS SUCITY","Bill#1179 / BALANC BILL NO 1179","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070009/1.","","","2017-07-12 00:00:00","1.","2710000001","","","40000.000000000000000000000000000000","0","Cash In Hand","Bill#1179 / KHAZIR SB SOI GAS SUCITY/BALANC BILL NO 1179","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070009/2","","","2017-07-12 00:00:00","2","2610000064","","","0","160000.000000000000000000000000000000","PESHWAR MALL","Bill#1173 / BALANC BILL NO 1173","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070009/2.","","","2017-07-12 00:00:00","2.","2710000001","","","160000.000000000000000000000000000000","0","Cash In Hand","Bill#1173 / PESHWAR MALL/BALANC BILL NO 1173","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070010/1","","","2017-07-13 00:00:00","1","2610000001","","","0","1750.000000000000000000000000000000","Walk-In-Customers","Bill#1194 / BALANC BILL NO 1194","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070010/1.","","","2017-07-13 00:00:00","1.","2710000001","","","1750.000000000000000000000000000000","0","Cash In Hand","Bill#1194 / /BALANC BILL NO 1194","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/1","","","2017-07-14 00:00:00","1","2610000030","","","0","86500.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1139 / BALANC BILL NO 1139","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/1.","","","2017-07-14 00:00:00","1.","2710000001","","","86500.000000000000000000000000000000","0","Cash In Hand","Bill#1139 / 200/1-B ST-NO #1 PHASE-5 DHA/BALANC BILL NO 1139","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/2","","","2017-07-14 00:00:00","2","2610000001","","","0","3290.000000000000000000000000000000","Walk-In-Customers","Bill#1167 / BALANC BILL NO 1167","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/2.","","","2017-07-14 00:00:00","2.","2710000001","","","3290.000000000000000000000000000000","0","Cash In Hand","Bill#1167 / /BALANC BILL NO 1167","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/3","","","2017-07-14 00:00:00","3","2610000030","","","0","3000.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1199 / BALANC BILL NO 1199","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/3.","","","2017-07-14 00:00:00","3.","2710000001","","","3000.000000000000000000000000000000","0","Cash In Hand","Bill#1199 / 200/1-B ST-NO #1 PHASE-5 DHA/BALANC BILL NO 1199","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/4","","","2017-07-14 00:00:00","4","2620000001","","","0","65500.000000000000000000000000000000","Bath & Kitchen","PYMENT RCIPT B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02CR070011/4.","","","2017-07-14 00:00:00","4.","2710000001","","","65500.000000000000000000000000000000","0","Cash In Hand","Bath & Kitchen/PYMENT RCIPT B/K","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060001/1","","","2017-05-31 00:00:00","1","0100010001","","","0","53366.000000000000000000000000000000","OPENING BALANCES","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060001/2","","","2017-05-31 00:00:00","2","2710000001","","","53366.000000000000000000000000000000","0","Cash In Hand","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060002/1","","","2017-06-02 00:00:00","1","2630000001","","","720.000000000000000000000000000000","0","Cash Reconciliation","DIEFFERENCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060002/2","","","2017-06-02 00:00:00","2","2710000001","","","0","720.000000000000000000000000000000","Cash In Hand","DIEFFERENCE","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060004/1","","","2017-06-12 00:00:00","1","2710000001","","","720.000000000000000000000000000000","0","Cash In Hand","2-06-17 ERR IN DAYBOOK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060004/2","","","2017-06-12 00:00:00","2","2630000001","","","0","720.000000000000000000000000000000","Cash Reconciliation","2-06-17 ERR IN DAYBOOK","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060005/1","","","2017-06-20 00:00:00","1","2610000045","","","11000.000000000000000000000000000000","0","347/Y PHS# 3","Bill#1088 / Return Adjustment","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060005/2","","","2017-06-20 00:00:00","2","2610000045","","","0","9000.000000000000000000000000000000","347/Y PHS# 3","Bill#1126 / Return Adjustment","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060005/3","","","2017-06-20 00:00:00","3","2610000045","","","0","1000.000000000000000000000000000000","347/Y PHS# 3","Bill#1118 / ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060005/4","","","2017-06-20 00:00:00","4","2610000045","","","0","1000.000000000000000000000000000000","347/Y PHS# 3","347/YBalance Payable","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060006/1","","","2017-05-31 00:00:00","1","0100010001","","","290540.000000000000000000000000000000","0","OPENING BALANCES","Not Paid Invoices Receipts","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060006/2","","","2017-05-31 00:00:00","2","2710000001","","","0","290540.000000000000000000000000000000","Cash In Hand","Not Paid Invoices Receipts","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060007/1","","","2017-07-03 00:00:00","1","2610000049","","","40000.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Bill#009 / 	Return Adjustment","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060007/2","","","2017-07-03 00:00:00","2","2610000049","","","0","27500.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Bill#1136 / ","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV060007/3","","","2017-07-03 00:00:00","3","2610000049","","","0","12500.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Balance Payable","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070001/1","","","2017-06-14 00:00:00","1","2610000001","","","11500.000000000000000000000000000000","0","Walk-In-Customers","Bill#3389 / Old bill return adj","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070001/2","","","2017-06-14 00:00:00","2","0100010001","","","0","11500.000000000000000000000000000000","OPENING BALANCES","Bill#3389 / Old bill return adj","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070002/1","","","2017-06-29 00:00:00","1","2610000045","","","5200.000000000000000000000000000000","0","347/Y PHS# 3","Bill#1079 / Return Adjustment Bill No 1143","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070002/2","","","2017-06-29 00:00:00","2","2610000045","","","0","5200.000000000000000000000000000000","347/Y PHS# 3","Bill#1143 / Return Bill No 1079 Adjusted","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070003/1","","","2017-07-06 00:00:00","1","2610000001","","","11000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1560 / Return Adjustment Bill No 1560","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070003/2","","","2017-07-06 00:00:00","2","2610000001","","","0","11000.000000000000000000000000000000","Walk-In-Customers","Bill#1560 / Return Bill No 1560 Adjusted","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070004/1","","","2017-07-08 00:00:00","1","2610000066","","","43000.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1176 / Return Adjustment Bill No 1776","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070004/2","","","2017-07-08 00:00:00","2","2610000066","","","0","13000.000000000000000000000000000000","398/B PH# 5 DHA KASHIF SB","Bill#1190 / Return Bill No 1190 Adjusted","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02JV070004/3","","","2017-07-08 00:00:00","3","2610000066","","","0","30000.000000000000000000000000000000","398/B PH# 5 DHA KASHIF SB","Balance Payable","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060001/1","","","2017-06-01 00:00:00","1","2210000001","","","10193.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060001/2","","","2017-06-01 00:00:00","2","1310000028","","","0","10193.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060001/3","","","2017-06-01 00:00:00","3","1310000028","","","10193.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060001/4","","","2017-06-01 00:00:00","4","2710000001","","","0","10193.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060002/1","","","2017-06-01 00:00:00","1","2210000001","","","11648.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060002/2","","","2017-06-01 00:00:00","2","1310000028","","","0","11648.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060002/3","","","2017-06-01 00:00:00","3","1310000028","","","9550.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060002/4","","","2017-06-01 00:00:00","4","2710000001","","","0","9550.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060003/1","","","2017-06-02 00:00:00","1","2210000001","","","86509.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060003/2","","","2017-06-02 00:00:00","2","1310000028","","","0","86509.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060003/3","","","2017-06-02 00:00:00","3","1310000028","","","26130.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060003/4","","","2017-06-02 00:00:00","4","2710000001","","","0","26130.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060004/1","","","2017-06-03 00:00:00","1","2210000001","","","7500.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060004/2","","","2017-06-03 00:00:00","2","1310000014","","","0","7500.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060004/3","","","2017-06-03 00:00:00","3","1310000014","","","7500.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060004/4","","","2017-06-03 00:00:00","4","2710000001","","","0","7500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060005/1","","","2017-06-03 00:00:00","1","2210000001","","","8100.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060005/2","","","2017-06-03 00:00:00","2","1310000014","","","0","8100.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060005/3","","","2017-06-03 00:00:00","3","1310000014","","","8100.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060005/4","","","2017-06-03 00:00:00","4","2710000001","","","0","8100.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060006/1","","","2017-06-03 00:00:00","1","2210000001","","","14500.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060006/2","","","2017-06-03 00:00:00","2","1310000018","","","0","14500.000000000000000000000000000000","KBS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060006/3","","","2017-06-03 00:00:00","3","1310000018","","","14500.000000000000000000000000000000","0","KBS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060006/4","","","2017-06-03 00:00:00","4","2710000001","","","0","14500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060007/1","","","2017-06-05 00:00:00","1","2210000001","","","20047.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060007/2","","","2017-06-05 00:00:00","2","1310000033","","","0","20047.000000000000000000000000000000","BASRA BROTHERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060007/3","","","2017-06-05 00:00:00","3","1310000033","","","19770.000000000000000000000000000000","0","BASRA BROTHERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060007/4","","","2017-06-05 00:00:00","4","2710000001","","","0","19770.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060008/1","","","2017-06-05 00:00:00","1","2210000001","","","7100.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060008/2","","","2017-06-05 00:00:00","2","1310000006","","","0","7100.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060008/3","","","2017-06-05 00:00:00","3","1310000006","","","6390.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060008/4","","","2017-06-05 00:00:00","4","2710000001","","","0","6390.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060009/1","","","2017-06-06 00:00:00","1","2210000001","","","3500.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060009/2","","","2017-06-06 00:00:00","2","1310000034","","","0","3500.000000000000000000000000000000","VIZDOM","Bill#815","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060009/3","","","2017-06-06 00:00:00","3","1310000034","","","3500.000000000000000000000000000000","0","VIZDOM","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060009/4","","","2017-06-06 00:00:00","4","2710000001","","","0","3500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060010/1","","","2017-06-06 00:00:00","1","2210000001","","","1330.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060010/2","","","2017-06-06 00:00:00","2","1310000035","","","0","1330.000000000000000000000000000000","SILLA CONCEPT\'S","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060010/3","","","2017-06-06 00:00:00","3","1310000035","","","1330.000000000000000000000000000000","0","SILLA CONCEPT\'S","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060010/4","","","2017-06-06 00:00:00","4","2710000001","","","0","1330.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060011/1","","","2017-06-07 00:00:00","1","2210000001","","","20570.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060011/2","","","2017-06-07 00:00:00","2","1310000028","","","0","20570.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060011/3","","","2017-06-07 00:00:00","3","1310000028","","","19885.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060011/4","","","2017-06-07 00:00:00","4","2710000001","","","0","19885.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060012/1","","","2017-06-07 00:00:00","1","2210000001","","","150.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060012/2","","","2017-06-07 00:00:00","2","1310000034","","","0","150.000000000000000000000000000000","VIZDOM","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060012/3","","","2017-06-07 00:00:00","3","1310000034","","","150.000000000000000000000000000000","0","VIZDOM","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060012/4","","","2017-06-07 00:00:00","4","2710000001","","","0","150.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060013/1","","","2017-06-08 00:00:00","1","2210000001","","","12734.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060013/2","","","2017-06-08 00:00:00","2","1310000006","","","0","12734.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060013/3","","","2017-06-08 00:00:00","3","1310000006","","","10570.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060013/4","","","2017-06-08 00:00:00","4","2710000001","","","0","10570.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060014/1","","","2017-06-08 00:00:00","1","2210000001","","","17340.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060014/2","","","2017-06-08 00:00:00","2","1310000027","","","0","17340.000000000000000000000000000000","IMC","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060014/3","","","2017-06-08 00:00:00","3","1310000027","","","17340.000000000000000000000000000000","0","IMC","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060014/4","","","2017-06-08 00:00:00","4","2710000001","","","0","17340.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060015/1","","","2017-06-12 00:00:00","1","2210000001","","","6750.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060015/2","","","2017-06-12 00:00:00","2","1310000014","","","0","6750.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060015/3","","","2017-06-12 00:00:00","3","1310000014","","","6750.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060015/4","","","2017-06-12 00:00:00","4","2710000001","","","0","6750.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060016/1","","","2017-06-12 00:00:00","1","2210000001","","","7759.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060016/2","","","2017-06-12 00:00:00","2","1310000028","","","0","7759.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060016/3","","","2017-06-12 00:00:00","3","1310000028","","","7500.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060016/4","","","2017-06-12 00:00:00","4","2710000001","","","0","7500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060017/1","","","2017-06-12 00:00:00","1","2210000001","","","14958.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060017/2","","","2017-06-12 00:00:00","2","1310000006","","","0","14958.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060017/3","","","2017-06-12 00:00:00","3","1310000006","","","12415.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060017/4","","","2017-06-12 00:00:00","4","2710000001","","","0","12415.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060018/1","","","2017-06-12 00:00:00","1","2210000001","","","990.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060018/2","","","2017-06-12 00:00:00","2","1310000014","","","0","990.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060018/3","","","2017-06-12 00:00:00","3","1310000014","","","990.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060018/4","","","2017-06-12 00:00:00","4","2710000001","","","0","990.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060019/1","","","2017-06-12 00:00:00","1","2210000001","","","6609.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060019/2","","","2017-06-12 00:00:00","2","1310000","","","0","6609.000000000000000000000000000000","","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060019/3","","","2017-06-12 00:00:00","3","1310000","","","5500.000000000000000000000000000000","0","","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060019/4","","","2017-06-12 00:00:00","4","2710000001","","","0","5500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060020/1","","","2017-06-13 00:00:00","1","2210000001","","","960.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060020/2","","","2017-06-13 00:00:00","2","1310000030","","","0","960.000000000000000000000000000000","MUHAMMADI STORE","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060020/3","","","2017-06-13 00:00:00","3","1310000030","","","960.000000000000000000000000000000","0","MUHAMMADI STORE","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060020/4","","","2017-06-13 00:00:00","4","2710000001","","","0","960.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060021/1","","","2017-06-13 00:00:00","1","2210000001","","","1400.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060021/2","","","2017-06-13 00:00:00","2","1310000028","","","0","1400.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060021/3","","","2017-06-13 00:00:00","3","1310000028","","","1150.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060021/4","","","2017-06-13 00:00:00","4","2710000001","","","0","1150.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060022/1","","","2017-06-13 00:00:00","1","2210000001","","","110.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060022/2","","","2017-06-13 00:00:00","2","1310000","","","0","110.000000000000000000000000000000","","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060022/3","","","2017-06-13 00:00:00","3","1310000","","","110.000000000000000000000000000000","0","","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060022/4","","","2017-06-13 00:00:00","4","2710000001","","","0","110.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060023/1","","","2017-06-13 00:00:00","1","2210000001","","","350.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060023/2","","","2017-06-13 00:00:00","2","1310000031","","","0","350.000000000000000000000000000000","ILYAS/SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060023/3","","","2017-06-13 00:00:00","3","1310000031","","","350.000000000000000000000000000000","0","ILYAS/SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060023/4","","","2017-06-13 00:00:00","4","2710000001","","","0","350.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060024/1","","","2017-06-14 00:00:00","1","2210000001","","","36542.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060024/2","","","2017-06-14 00:00:00","2","1310000033","","","0","36542.000000000000000000000000000000","BASRA BROTHERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060024/3","","","2017-06-14 00:00:00","3","1310000033","","","36542.000000000000000000000000000000","0","BASRA BROTHERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060024/4","","","2017-06-14 00:00:00","4","2710000001","","","0","36542.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060025/1","","","2017-06-14 00:00:00","1","2210000001","","","5500.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060025/2","","","2017-06-14 00:00:00","2","1310000029","","","0","5500.000000000000000000000000000000","KBS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060025/3","","","2017-06-14 00:00:00","3","1310000029","","","5500.000000000000000000000000000000","0","KBS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060025/4","","","2017-06-14 00:00:00","4","2710000001","","","0","5500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060026/1","","","2017-06-14 00:00:00","1","2210000001","","","14025.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060026/2","","","2017-06-14 00:00:00","2","1310000034","","","0","14025.000000000000000000000000000000","VIZDOM","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060026/3","","","2017-06-14 00:00:00","3","1310000034","","","14000.000000000000000000000000000000","0","VIZDOM","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060026/4","","","2017-06-14 00:00:00","4","2710000001","","","0","14000.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060027/1","","","2017-06-14 00:00:00","1","2210000001","","","19522.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060027/2","","","2017-06-14 00:00:00","2","1310000006","","","0","19522.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060027/3","","","2017-06-14 00:00:00","3","1310000006","","","17330.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060027/4","","","2017-06-14 00:00:00","4","2710000001","","","0","17330.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060028/1","","","2017-06-15 00:00:00","1","2210000001","","","21000.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060028/2","","","2017-06-15 00:00:00","2","1310000034","","","0","21000.000000000000000000000000000000","VIZDOM","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060028/3","","","2017-06-15 00:00:00","3","1310000034","","","21000.000000000000000000000000000000","0","VIZDOM","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060028/4","","","2017-06-15 00:00:00","4","2710000001","","","0","21000.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060029/1","","","2017-06-17 00:00:00","1","2210000001","","","2800.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060029/2","","","2017-06-17 00:00:00","2","1310000006","","","0","2800.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060029/3","","","2017-06-17 00:00:00","3","1310000006","","","2324.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060029/4","","","2017-06-17 00:00:00","4","2710000001","","","0","2324.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060030/1","","","2017-06-17 00:00:00","1","2210000001","","","950.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060030/2","","","2017-06-17 00:00:00","2","2610000042","","","0","950.000000000000000000000000000000","CERAMICS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060030/3","","","2017-06-17 00:00:00","3","2610000042","","","950.000000000000000000000000000000","0","CERAMICS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060030/4","","","2017-06-17 00:00:00","4","2710000001","","","0","950.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060031/1","","","2017-06-17 00:00:00","1","2210000001","","","3500.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060031/2","","","2017-06-17 00:00:00","2","2610000043","","","0","3500.000000000000000000000000000000","HOME TECH","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060031/3","","","2017-06-17 00:00:00","3","2610000043","","","3500.000000000000000000000000000000","0","HOME TECH","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060031/4","","","2017-06-17 00:00:00","4","2710000001","","","0","3500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060032/1","","","2017-06-20 00:00:00","1","2210000001","","","34164.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060032/2","","","2017-06-20 00:00:00","2","1310000006","","","0","34164.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060032/3","","","2017-06-20 00:00:00","3","1310000006","","","28360.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060032/4","","","2017-06-20 00:00:00","4","2710000001","","","0","28360.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060033/1","","","2017-06-21 00:00:00","1","2210000001","","","10424.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060033/2","","","2017-06-21 00:00:00","2","1310000028","","","0","10424.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060033/3","","","2017-06-21 00:00:00","3","1310000028","","","8600.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060033/4","","","2017-06-21 00:00:00","4","2710000001","","","0","8600.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060034/1","","","2017-06-21 00:00:00","1","2210000001","","","19403.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060034/2","","","2017-06-21 00:00:00","2","1310000006","","","0","19403.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060034/3","","","2017-06-21 00:00:00","3","1310000006","","","16000.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060034/4","","","2017-06-21 00:00:00","4","2710000001","","","0","16000.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060035/1","","","2017-06-22 00:00:00","1","2210000001","","","3175.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060035/2","","","2017-06-22 00:00:00","2","1310000006","","","0","3175.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060035/3","","","2017-06-22 00:00:00","3","1310000006","","","2700.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060035/4","","","2017-06-22 00:00:00","4","2710000001","","","0","2700.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060036/1","","","2017-06-22 00:00:00","1","2210000001","","","56064.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060036/2","","","2017-06-22 00:00:00","2","1310000006","","","0","56064.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060036/3","","","2017-06-22 00:00:00","3","1310000006","","","56060.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060036/4","","","2017-06-22 00:00:00","4","2710000001","","","0","56060.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060037/1","","","2017-06-22 00:00:00","1","2210000001","","","1050.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060037/2","","","2017-06-22 00:00:00","2","1310000014","","","0","1050.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060037/3","","","2017-06-22 00:00:00","3","1310000014","","","1000.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060037/4","","","2017-06-22 00:00:00","4","2710000001","","","0","1000.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060038/1","","","2017-06-23 00:00:00","1","2210000001","","","1739.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060038/2","","","2017-06-23 00:00:00","2","1310000028","","","0","1739.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060038/3","","","2017-06-23 00:00:00","3","1310000028","","","1680.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL060038/4","","","2017-06-23 00:00:00","4","2710000001","","","0","1680.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070001/1","","","2017-07-03 00:00:00","1","2210000001","","","1800.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070001/2","","","2017-07-03 00:00:00","2","1310000018","","","0","1800.000000000000000000000000000000","KBS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070001/3","","","2017-07-03 00:00:00","3","1310000018","","","1800.000000000000000000000000000000","0","KBS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070001/4","","","2017-07-03 00:00:00","4","2710000001","","","0","1800.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070002/1","","","2017-06-30 00:00:00","1","2210000001","","","4793.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070002/2","","","2017-06-30 00:00:00","2","1310000028","","","0","4793.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070002/3","","","2017-06-30 00:00:00","3","1310000028","","","4630.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070002/4","","","2017-06-30 00:00:00","4","2710000001","","","0","4630.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070004/1","","","2017-06-30 00:00:00","1","2210000001","","","560.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070004/2","","","2017-06-30 00:00:00","2","1310000033","","","0","560.000000000000000000000000000000","BASRA BROTHERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070004/3","","","2017-06-30 00:00:00","3","1310000033","","","560.000000000000000000000000000000","0","BASRA BROTHERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070004/4","","","2017-06-30 00:00:00","4","2710000001","","","0","560.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070005/1","","","2017-06-30 00:00:00","1","2210000001","","","7293.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070005/2","","","2017-06-30 00:00:00","2","1310000006","","","0","7293.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070005/3","","","2017-06-30 00:00:00","3","1310000006","","","6050.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070005/4","","","2017-06-30 00:00:00","4","2710000001","","","0","6050.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070006/1","","","2017-07-04 00:00:00","1","2210000001","","","3350.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070006/2","","","2017-07-04 00:00:00","2","1310000006","","","0","3350.000000000000000000000000000000","MAGOON TRADERS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070006/3","","","2017-07-04 00:00:00","3","1310000006","","","3350.000000000000000000000000000000","0","MAGOON TRADERS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070006/4","","","2017-07-04 00:00:00","4","2710000001","","","0","3350.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070007/1","","","2017-07-04 00:00:00","1","2210000001","","","7500.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070007/2","","","2017-07-04 00:00:00","2","1310000014","","","0","7500.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070007/3","","","2017-07-04 00:00:00","3","1310000014","","","7500.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070007/4","","","2017-07-04 00:00:00","4","2710000001","","","0","7500.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070008/1","","","2017-07-06 00:00:00","1","2210000001","","","21117.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070008/2","","","2017-07-06 00:00:00","2","1310000028","","","0","21117.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070008/3","","","2017-07-06 00:00:00","3","1310000028","","","20370.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070008/4","","","2017-07-06 00:00:00","4","2710000001","","","0","20370.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070009/1","","","2017-07-06 00:00:00","1","2210000001","","","19420.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070009/2","","","2017-07-06 00:00:00","2","1310000028","","","0","19420.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070009/3","","","2017-07-06 00:00:00","3","1310000028","","","3730.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070009/4","","","2017-07-06 00:00:00","4","2710000001","","","0","3730.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070010/1","","","2017-07-07 00:00:00","1","2210000001","","","3392.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070010/2","","","2017-07-07 00:00:00","2","1310000045","","","0","3392.000000000000000000000000000000","INTERIO FLOORS","Bill#if-l-07913","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070010/3","","","2017-07-07 00:00:00","3","1310000045","","","3390.000000000000000000000000000000","0","INTERIO FLOORS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070010/4","","","2017-07-07 00:00:00","4","2710000001","","","0","3390.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070011/1","","","2017-07-10 00:00:00","1","2210000001","","","13000.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070011/2","","","2017-07-10 00:00:00","2","1310000047","","","0","13000.000000000000000000000000000000","BUTT TRADER","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070011/3","","","2017-07-10 00:00:00","3","1310000047","","","13000.000000000000000000000000000000","0","BUTT TRADER","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070011/4","","","2017-07-10 00:00:00","4","2710000001","","","0","13000.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070012/1","","","2017-07-10 00:00:00","1","2210000001","","","14050.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070012/2","","","2017-07-10 00:00:00","2","1310000014","","","0","14050.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070012/3","","","2017-07-10 00:00:00","3","1310000014","","","14050.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070012/4","","","2017-07-10 00:00:00","4","2710000001","","","0","14050.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070013/1","","","2017-07-11 00:00:00","1","2210000001","","","7350.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070013/2","","","2017-07-11 00:00:00","2","1310000014","","","0","7350.000000000000000000000000000000","JAVAID","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070013/3","","","2017-07-11 00:00:00","3","1310000014","","","7350.000000000000000000000000000000","0","JAVAID","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070013/4","","","2017-07-11 00:00:00","4","2710000001","","","0","7350.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070014/1","","","2017-07-14 00:00:00","1","2210000001","","","15863.000000000000000000000000000000","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070014/2","","","2017-07-14 00:00:00","2","1310000028","","","0","15863.000000000000000000000000000000","MAHMOOD SONS","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070014/3","","","2017-07-14 00:00:00","3","1310000028","","","15300.000000000000000000000000000000","0","MAHMOOD SONS","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070014/4","","","2017-07-14 00:00:00","4","2710000001","","","0","15300.000000000000000000000000000000","Cash In Hand","Paid against Purchase","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070015/1","","","2017-05-31 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070015/2","","","2017-05-31 00:00:00","2","2210000001","","","0","0","Stock In Trade","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070016/1","","","2017-05-31 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070016/2","","","2017-05-31 00:00:00","2","2210000001","","","0","0","Stock In Trade","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070017/1","","","2017-05-31 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070017/2","","","2017-05-31 00:00:00","2","2210000001","","","0","0","Stock In Trade","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070018/1","","","2017-05-31 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070018/2","","","2017-05-31 00:00:00","2","2210000001","","","0","0","Stock In Trade","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070019/1","","","2017-05-31 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070019/2","","","2017-05-31 00:00:00","2","2210000001","","","0","0","Stock In Trade","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070020/1","","","2017-05-31 00:00:00","1","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02PL070020/2","","","2017-05-31 00:00:00","2","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060001/1","","","2017-06-07 00:00:00","1","3010000020","","","18850.000000000000000000000000000000","0","Sale Returns","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060001/2","","","2017-06-07 00:00:00","2","2610000001","","","0","18850.000000000000000000000000000000","Walk-In-Customers","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060001/3","","","2017-06-07 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060001/4","","","2017-06-07 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060002/1","","","2017-06-07 00:00:00","1","3010000020","","","10900.000000000000000000000000000000","0","Sale Returns","Bill#3363","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060002/2","","","2017-06-07 00:00:00","2","2610000001","","","0","10900.000000000000000000000000000000","Walk-In-Customers","Bill#3363","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060002/3","","","2017-06-07 00:00:00","3","3010000010","","","0","2679.000000000000000000000000000000","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060002/4","","","2017-06-07 00:00:00","4","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060002/5","","","2017-06-07 00:00:00","5","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060003/1","","","2017-06-10 00:00:00","1","3010000020","","","18000.000000000000000000000000000000","0","Sale Returns","Bill#3366","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060003/2","","","2017-06-10 00:00:00","2","2610000001","","","0","18000.000000000000000000000000000000","Walk-In-Customers","Bill#3366","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060003/3","","","2017-06-10 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060003/4","","","2017-06-10 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060004/1","","","2017-06-12 00:00:00","1","3010000020","","","21000.000000000000000000000000000000","0","Sale Returns","Bill#1035","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060004/2","","","2017-06-12 00:00:00","2","2610000001","","","0","21000.000000000000000000000000000000","Walk-In-Customers","Bill#1035","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060004/3","","","2017-06-12 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060004/4","","","2017-06-12 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060004/5","","","2017-06-12 00:00:00","5","2610000001","","","21000.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060004/6","","","2017-06-12 00:00:00","6","2710000001","","","0","21000.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060005/1","","","2017-06-12 00:00:00","1","3010000020","","","17500.000000000000000000000000000000","0","Sale Returns","Bill#1074","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060005/2","","","2017-06-12 00:00:00","2","2610000001","","","0","17500.000000000000000000000000000000","Walk-In-Customers","Bill#1074","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060005/3","","","2017-06-12 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060005/4","","","2017-06-12 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060005/5","","","2017-06-12 00:00:00","5","2610000001","","","17500.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060005/6","","","2017-06-12 00:00:00","6","2710000001","","","0","17500.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060007/1","","","2017-06-13 00:00:00","1","3010000020","","","1800.000000000000000000000000000000","0","Sale Returns","Bill#3376","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060007/2","","","2017-06-13 00:00:00","2","2610000001","","","0","1800.000000000000000000000000000000","Walk-In-Customers","Bill#3376","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060007/3","","","2017-06-13 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060007/4","","","2017-06-13 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060007/5","","","2017-06-13 00:00:00","5","2610000001","","","1800.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060007/6","","","2017-06-13 00:00:00","6","2710000001","","","0","1800.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060008/1","","","2017-06-13 00:00:00","1","3010000020","","","23000.000000000000000000000000000000","0","Sale Returns","Bill#1096","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060008/2","","","2017-06-13 00:00:00","2","2610000001","","","0","23000.000000000000000000000000000000","Walk-In-Customers","Bill#1096","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060008/3","","","2017-06-13 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060008/4","","","2017-06-13 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060008/5","","","2017-06-13 00:00:00","5","2610000001","","","23000.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060008/6","","","2017-06-13 00:00:00","6","2710000001","","","0","23000.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060009/1","","","2017-06-13 00:00:00","1","3010000020","","","2100.000000000000000000000000000000","0","Sale Returns","Bill#1042","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060009/2","","","2017-06-13 00:00:00","2","2610000001","","","0","2100.000000000000000000000000000000","Walk-In-Customers","Bill#1042","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060009/3","","","2017-06-13 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060009/4","","","2017-06-13 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060009/5","","","2017-06-13 00:00:00","5","2610000001","","","2100.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060009/6","","","2017-06-13 00:00:00","6","2710000001","","","0","2100.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060010/1","","","2017-06-14 00:00:00","1","3010000020","","","14500.000000000000000000000000000000","0","Sale Returns","Bill#3357","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060010/2","","","2017-06-14 00:00:00","2","2610000001","","","0","14500.000000000000000000000000000000","Walk-In-Customers","Bill#3357","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060010/3","","","2017-06-14 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060010/4","","","2017-06-14 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060010/5","","","2017-06-14 00:00:00","5","2610000001","","","3000.000000000000000000000000000000","0","Walk-In-Customers","Advance Paid against 14,500 Sale Return  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060010/6","","","2017-06-14 00:00:00","6","2710000001","","","0","3000.000000000000000000000000000000","Cash In Hand","Advance Paid against 14,500 Sale Return  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060011/1","","","2017-06-19 00:00:00","1","3010000020","","","10000.000000000000000000000000000000","0","Sale Returns","Bill#1082","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060011/2","","","2017-06-19 00:00:00","2","2610000032","","","0","10000.000000000000000000000000000000","AHMAD SB","Bill#1082","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060011/3","","","2017-06-19 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060011/4","","","2017-06-19 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060011/5","","","2017-06-19 00:00:00","5","2610000032","","","10000.000000000000000000000000000000","0","AHMAD SB","Paid against Sale Return To  AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060011/6","","","2017-06-19 00:00:00","6","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/1","","","2017-06-20 00:00:00","1","3010000020","","","10100.000000000000000000000000000000","0","Sale Returns","Bill#1081","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/2","","","2017-06-20 00:00:00","2","2610000032","","","0","10100.000000000000000000000000000000","AHMAD SB","Bill#1081","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/3","","","2017-06-20 00:00:00","3","3010000010","","","0","100.000000000000000000000000000000","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/4","","","2017-06-20 00:00:00","4","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/5","","","2017-06-20 00:00:00","5","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/6","","","2017-06-20 00:00:00","6","2610000032","","","10000.000000000000000000000000000000","0","AHMAD SB","Advance Paid against 10,100 Sale Return  AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060012/7","","","2017-06-20 00:00:00","7","2710000001","","","0","10000.000000000000000000000000000000","Cash In Hand","Advance Paid against 10,100 Sale Return  AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/1","","","2017-06-20 00:00:00","1","3010000020","","","2500.000000000000000000000000000000","0","Sale Returns","Bill#1122","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/2","","","2017-06-20 00:00:00","2","2610000001","","","0","2500.000000000000000000000000000000","Walk-In-Customers","Bill#1122","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/3","","","2017-06-20 00:00:00","3","3010000010","","","0","500.000000000000000000000000000000","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/4","","","2017-06-20 00:00:00","4","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/5","","","2017-06-20 00:00:00","5","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/6","","","2017-06-20 00:00:00","6","2610000001","","","2000.000000000000000000000000000000","0","Walk-In-Customers","Advance Paid against 2,500 Sale Return  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060013/7","","","2017-06-20 00:00:00","7","2710000001","","","0","2000.000000000000000000000000000000","Cash In Hand","Advance Paid against 2,500 Sale Return  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060014/1","","","2017-06-20 00:00:00","1","3010000020","","","61950.000000000000000000000000000000","0","Sale Returns","Bill#1005","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060014/2","","","2017-06-20 00:00:00","2","2610000001","","","0","61950.000000000000000000000000000000","Walk-In-Customers","Bill#1005","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060014/3","","","2017-06-20 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060014/4","","","2017-06-20 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060015/1","","","2017-06-20 00:00:00","1","3010000020","","","11000.000000000000000000000000000000","0","Sale Returns","Bill#1088","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060015/2","","","2017-06-20 00:00:00","2","2610000045","","","0","11000.000000000000000000000000000000","347/Y PHS# 3","Bill#1088","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060015/3","","","2017-06-20 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060015/4","","","2017-06-20 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060016/1","","","2017-06-22 00:00:00","1","3010000020","","","5600.000000000000000000000000000000","0","Sale Returns","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060016/2","","","2017-06-22 00:00:00","2","2610000001","","","0","5600.000000000000000000000000000000","Walk-In-Customers","Bill#","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060016/3","","","2017-06-22 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060016/4","","","2017-06-22 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060016/5","","","2017-06-22 00:00:00","5","2610000001","","","5600.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060016/6","","","2017-06-22 00:00:00","6","2710000001","","","0","5600.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060017/1","","","2017-07-06 00:00:00","1","3010000020","","","40000.000000000000000000000000000000","0","Sale Returns","Bill#009","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060017/2","","","2017-07-06 00:00:00","2","2610000049","","","0","40000.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Bill#009","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060017/3","","","2017-07-06 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060017/4","","","2017-07-06 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060017/5","","","2017-07-06 00:00:00","5","2610000049","","","12500.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Advance Paid against 40,000 Sale Return  HAJI HAKM SB 73 / C PH# 6","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060017/6","","","2017-07-06 00:00:00","6","2710000001","","","0","12500.000000000000000000000000000000","Cash In Hand","Advance Paid against 40,000 Sale Return  HAJI HAKM SB 73 / C PH# 6","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060018/1","","","2017-06-29 00:00:00","1","3010000020","","","6000.000000000000000000000000000000","0","Sale Returns","Bill#1079","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060018/2","","","2017-06-29 00:00:00","2","2610000045","","","0","6000.000000000000000000000000000000","347/Y PHS# 3","Bill#1079","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060018/3","","","2017-06-29 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060018/4","","","2017-06-29 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060018/5","","","2017-06-29 00:00:00","5","2610000045","","","800.000000000000000000000000000000","0","347/Y PHS# 3","Advance Paid against 6,000 Sale Return  347/Y PHS# 3","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060018/6","","","2017-06-29 00:00:00","6","2710000001","","","0","800.000000000000000000000000000000","Cash In Hand","Advance Paid against 6,000 Sale Return  347/Y PHS# 3","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060019/1","","","2017-06-29 00:00:00","1","3010000020","","","16000.000000000000000000000000000000","0","Sale Returns","Bill#3378","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060019/2","","","2017-06-29 00:00:00","2","2610000035","","","0","16000.000000000000000000000000000000","MR. ANEES SB 0321-4185133","Bill#3378","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060019/3","","","2017-06-29 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT060019/4","","","2017-06-29 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070001/1","","","2017-07-06 00:00:00","1","3010000020","","","7800.000000000000000000000000000000","0","Sale Returns","Bill#1082","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070001/2","","","2017-07-06 00:00:00","2","2610000001","","","0","7800.000000000000000000000000000000","Walk-In-Customers","Bill#1082","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070001/3","","","2017-07-06 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070001/4","","","2017-07-06 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070001/5","","","2017-07-06 00:00:00","5","2610000001","","","7800.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070001/6","","","2017-07-06 00:00:00","6","2710000001","","","0","7800.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070002/1","","","2017-07-06 00:00:00","1","3010000020","","","11000.000000000000000000000000000000","0","Sale Returns","Bill#1560","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070002/2","","","2017-07-06 00:00:00","2","2610000001","","","0","11000.000000000000000000000000000000","Walk-In-Customers","Bill#1560","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070002/3","","","2017-07-06 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070002/4","","","2017-07-06 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070003/1","","","2017-07-07 00:00:00","1","3010000020","","","5000.000000000000000000000000000000","0","Sale Returns","Bill#3372","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070003/2","","","2017-07-07 00:00:00","2","2610000001","","","0","5000.000000000000000000000000000000","Walk-In-Customers","Bill#3372","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070003/3","","","2017-07-07 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070003/4","","","2017-07-07 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070003/5","","","2017-07-07 00:00:00","5","2610000001","","","5000.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070003/6","","","2017-07-07 00:00:00","6","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/1","","","2017-07-08 00:00:00","1","3010000020","","","6050.000000000000000000000000000000","0","Sale Returns","Bill#1184","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/2","","","2017-07-08 00:00:00","2","2610000001","","","0","6050.000000000000000000000000000000","Walk-In-Customers","Bill#1184","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/3","","","2017-07-08 00:00:00","3","3010000010","","","0","50.000000000000000000000000000000","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/4","","","2017-07-08 00:00:00","4","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/5","","","2017-07-08 00:00:00","5","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/6","","","2017-07-08 00:00:00","6","2610000001","","","6000.000000000000000000000000000000","0","Walk-In-Customers","Advance Paid against 6,050 Sale Return  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070004/7","","","2017-07-08 00:00:00","7","2710000001","","","0","6000.000000000000000000000000000000","Cash In Hand","Advance Paid against 6,050 Sale Return  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070005/1","","","2017-07-08 00:00:00","1","3010000020","","","43000.000000000000000000000000000000","0","Sale Returns","Bill#1176","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070005/2","","","2017-07-08 00:00:00","2","2610000066","","","0","43000.000000000000000000000000000000","398/B PH# 5 DHA KASHIF SB","Bill#1176","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070005/3","","","2017-07-08 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070005/4","","","2017-07-08 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070005/5","","","2017-07-08 00:00:00","5","2610000066","","","30000.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Advance Paid against 43,000 Sale Return  398/B PH# 5 DHA KASHIF SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070005/6","","","2017-07-08 00:00:00","6","2710000001","","","0","30000.000000000000000000000000000000","Cash In Hand","Advance Paid against 43,000 Sale Return  398/B PH# 5 DHA KASHIF SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070006/1","","","2017-07-11 00:00:00","1","3010000020","","","5000.000000000000000000000000000000","0","Sale Returns","Bill#1089","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070006/2","","","2017-07-11 00:00:00","2","2610000001","","","0","5000.000000000000000000000000000000","Walk-In-Customers","Bill#1089","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070006/3","","","2017-07-11 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070006/4","","","2017-07-11 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070006/5","","","2017-07-11 00:00:00","5","2610000001","","","5000.000000000000000000000000000000","0","Walk-In-Customers","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070006/6","","","2017-07-11 00:00:00","6","2710000001","","","0","5000.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070007/1","","","2017-07-14 00:00:00","1","3010000020","","","154500.000000000000000000000000000000","0","Sale Returns","Bill#1139","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070007/2","","","2017-07-14 00:00:00","2","2610000030","","","0","154500.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1139","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070007/3","","","2017-07-14 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070007/4","","","2017-07-14 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070007/5","","","2017-07-14 00:00:00","5","2610000030","","","154500.000000000000000000000000000000","0","200/1-B ST-NO #1 PHASE-5 DHA","Paid against Sale Return To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070007/6","","","2017-07-14 00:00:00","6","2710000001","","","0","154500.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070008/1","","","2017-07-14 00:00:00","1","3010000020","","","1950.000000000000000000000000000000","0","Sale Returns","Bill#1199","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070008/2","","","2017-07-14 00:00:00","2","2610000030","","","0","1950.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1199","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070008/3","","","2017-07-14 00:00:00","3","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070008/4","","","2017-07-14 00:00:00","4","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070008/5","","","2017-07-14 00:00:00","5","2610000030","","","1950.000000000000000000000000000000","0","200/1-B ST-NO #1 PHASE-5 DHA","Paid against Sale Return To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070008/6","","","2017-07-14 00:00:00","6","2710000001","","","0","1950.000000000000000000000000000000","Cash In Hand","Paid against Sale Return To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/1","","","2017-07-14 00:00:00","1","3010000020","","","1940.000000000000000000000000000000","0","Sale Returns","Bill#3367","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/2","","","2017-07-14 00:00:00","2","2610000030","","","0","1940.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#3367","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/3","","","2017-07-14 00:00:00","3","3010000010","","","0","150.000000000000000000000000000000","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/4","","","2017-07-14 00:00:00","4","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/5","","","2017-07-14 00:00:00","5","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/6","","","2017-07-14 00:00:00","6","2610000030","","","1790.000000000000000000000000000000","0","200/1-B ST-NO #1 PHASE-5 DHA","Advance Paid against 1,940 Sale Return  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070009/7","","","2017-07-14 00:00:00","7","2710000001","","","0","1790.000000000000000000000000000000","Cash In Hand","Advance Paid against 1,940 Sale Return  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070010/1","","","2017-07-15 00:00:00","1","3010000020","","","9600.000000000000000000000000000000","0","Sale Returns","Bill#1138","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070010/2","","","2017-07-15 00:00:00","2","2610000049","","","0","9600.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Bill#1138","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070010/3","","","2017-07-15 00:00:00","3","3010000010","","","0","1100.000000000000000000000000000000","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070010/4","","","2017-07-15 00:00:00","4","3020000001","","","0","0","Purchase Cost","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02RT070010/5","","","2017-07-15 00:00:00","5","2210000001","","","0","0","Stock In Trade","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060001/1","","","2017-06-01 00:00:00","1","2610000032","","","60000.000000000000000000000000000000","0","AHMAD SB","Bill#1089","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060001/1.","","","2017-06-01 00:00:00","1.","3010000001","","","0","7800.000000000000000000000000000000","Turnover","Bill#1089","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060001/2.","","","2017-06-01 00:00:00","2.","3010000010","","","500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060001/3","","","2017-06-01 00:00:00","3","2710000001","","","60000.000000000000000000000000000000","0","Cash In Hand","Bill#1089 / Received From Sale To  AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060001/4","","","2017-06-01 00:00:00","4","2610000032","","","0","60000.000000000000000000000000000000","AHMAD SB","Bill#1089 / Received From Sale To  AHMAD SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060002/1","","","2017-06-01 00:00:00","1","2610000027","","","66500.000000000000000000000000000000","0","SAYYAD BROTHER","Bill#1087","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060002/1.","","","2017-06-01 00:00:00","1.","3010000001","","","0","7800.000000000000000000000000000000","Turnover","Bill#1087","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060003/1","","","2017-06-01 00:00:00","1","2610000045","","","25000.000000000000000000000000000000","0","347/Y PHS# 3","Bill#1088","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060003/1.","","","2017-06-01 00:00:00","1.","3010000001","","","0","9600.000000000000000000000000000000","Turnover","Bill#1088","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060003/2.","","","2017-06-01 00:00:00","2.","3010000010","","","1800.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060003/3","","","2017-06-01 00:00:00","3","2710000001","","","25000.000000000000000000000000000000","0","Cash In Hand","Bill#1088 / Received From Sale To  347/Y PHS# 3","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060003/4","","","2017-06-01 00:00:00","4","2610000045","","","0","25000.000000000000000000000000000000","347/Y PHS# 3","Bill#1088 / Received From Sale To  347/Y PHS# 3","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060004/1","","","2017-06-03 00:00:00","1","2610000001","","","18000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1093","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060004/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","10600.000000000000000000000000000000","Turnover","Bill#1093","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060004/2.","","","2017-06-03 00:00:00","2.","3010000010","","","1000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060004/3","","","2017-06-03 00:00:00","3","2710000001","","","18000.000000000000000000000000000000","0","Cash In Hand","Bill#1093 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060004/4","","","2017-06-03 00:00:00","4","2610000001","","","0","18000.000000000000000000000000000000","Walk-In-Customers","Bill#1093 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060005/1","","","2017-06-03 00:00:00","1","2610000001","","","118000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1096","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060005/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","15800.000000000000000000000000000000","Turnover","Bill#1096","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060005/2.","","","2017-06-03 00:00:00","2.","3010000010","","","5200.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060005/3","","","2017-06-03 00:00:00","3","2710000001","","","118000.000000000000000000000000000000","0","Cash In Hand","Bill#1096 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060005/4","","","2017-06-03 00:00:00","4","2610000001","","","0","118000.000000000000000000000000000000","Walk-In-Customers","Bill#1096 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060006/1","","","2017-06-03 00:00:00","1","2610000001","","","13000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1097","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060006/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","15800.000000000000000000000000000000","Turnover","Bill#1097","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060006/2","","","2017-06-03 00:00:00","2","2710000001","","","13000.000000000000000000000000000000","0","Cash In Hand","Bill#1097 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060006/3","","","2017-06-03 00:00:00","3","2610000001","","","0","13000.000000000000000000000000000000","Walk-In-Customers","Bill#1097 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060007/1","","","2017-06-03 00:00:00","1","2610000001","","","148000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1099","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060007/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","22700.000000000000000000000000000000","Turnover","Bill#1099","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060007/2.","","","2017-06-03 00:00:00","2.","3010000010","","","6900.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060007/3","","","2017-06-03 00:00:00","3","2710000001","","","148000.000000000000000000000000000000","0","Cash In Hand","Bill#1099 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060007/4","","","2017-06-03 00:00:00","4","2610000001","","","0","148000.000000000000000000000000000000","Walk-In-Customers","Bill#1099 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060008/1","","","2017-06-03 00:00:00","1","2610000001","","","54000.000000000000000000000000000000","0","Walk-In-Customers","Bill#3360","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060008/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","23050.000000000000000000000000000000","Turnover","Bill#3360","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060008/2.","","","2017-06-03 00:00:00","2.","3010000010","","","350.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060008/3","","","2017-06-03 00:00:00","3","2710000001","","","54000.000000000000000000000000000000","0","Cash In Hand","Bill#3360 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060008/4","","","2017-06-03 00:00:00","4","2610000001","","","0","54000.000000000000000000000000000000","Walk-In-Customers","Bill#3360 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060009/1","","","2017-06-03 00:00:00","1","2610000001","","","27000.000000000000000000000000000000","0","Walk-In-Customers","Bill#3361","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060009/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","23200.000000000000000000000000000000","Turnover","Bill#3361","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060009/2.","","","2017-06-03 00:00:00","2.","3010000010","","","150.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060009/3","","","2017-06-03 00:00:00","3","2710000001","","","27000.000000000000000000000000000000","0","Cash In Hand","Bill#3361 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060009/4","","","2017-06-03 00:00:00","4","2610000001","","","0","27000.000000000000000000000000000000","Walk-In-Customers","Bill#3361 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060010/1","","","2017-06-05 00:00:00","1","2610000001","","","3000.000000000000000000000000000000","0","Walk-In-Customers","Bill#3362","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060010/1.","","","2017-06-05 00:00:00","1.","3010000001","","","0","23500.000000000000000000000000000000","Turnover","Bill#3362","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060010/2.","","","2017-06-05 00:00:00","2.","3010000010","","","300.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060010/3","","","2017-06-05 00:00:00","3","2710000001","","","3000.000000000000000000000000000000","0","Cash In Hand","Bill#3362 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060010/4","","","2017-06-05 00:00:00","4","2610000001","","","0","3000.000000000000000000000000000000","Walk-In-Customers","Bill#3362 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060011/1","","","2017-06-06 00:00:00","1","2610000027","","","150000.000000000000000000000000000000","0","SAYYAD BROTHER","Bill#060011","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060011/1.","","","2017-06-06 00:00:00","1.","3010000001","","","0","23500.000000000000000000000000000000","Turnover","Bill#060011","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060012/1","","","2017-06-06 00:00:00","1","2610000027","","","36850.000000000000000000000000000000","0","SAYYAD BROTHER","Bill#1094","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060012/1.","","","2017-06-06 00:00:00","1.","3010000001","","","0","23500.000000000000000000000000000000","Turnover","Bill#1094","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060012/2","","","2017-06-06 00:00:00","2","2710000001","","","36850.000000000000000000000000000000","0","Cash In Hand","Bill#1094 / Received From Sale To  SAYYAD BROTHER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060012/3","","","2017-06-06 00:00:00","3","2610000027","","","0","36850.000000000000000000000000000000","SAYYAD BROTHER","Bill#1094 / Received From Sale To  SAYYAD BROTHER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060015/1","","","2017-06-07 00:00:00","1","2610000028","","","4500.000000000000000000000000000000","0","KASHIF SB 245/G PHS# 5 DHA","Bill#060015","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060015/1.","","","2017-06-07 00:00:00","1.","3010000001","","","0","23500.000000000000000000000000000000","Turnover","Bill#060015","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060016/1","","","2017-06-07 00:00:00","1","2610000001","","","1850.000000000000000000000000000000","0","Walk-In-Customers","Bill#060016","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060016/1.","","","2017-06-07 00:00:00","1.","3010000001","","","0","23500.000000000000000000000000000000","Turnover","Bill#060016","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060016/2","","","2017-06-07 00:00:00","2","2710000001","","","1850.000000000000000000000000000000","0","Cash In Hand","Bill#060016 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060016/3","","","2017-06-07 00:00:00","3","2610000001","","","0","1850.000000000000000000000000000000","Walk-In-Customers","Bill#060016 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060018/1","","","2017-06-07 00:00:00","1","2610000029","","","16800.000000000000000000000000000000","0","MURTZA CUSTMER","Bill#3363","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060018/1.","","","2017-06-07 00:00:00","1.","3010000001","","","0","35230.000000000000000000000000000000","Turnover","Bill#3363","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060018/2.","","","2017-06-07 00:00:00","2.","3010000010","","","11730.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060018/3","","","2017-06-07 00:00:00","3","2710000001","","","16800.000000000000000000000000000000","0","Cash In Hand","Bill#3363 / Received From Sale To  MURTZA CUSTMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060018/4","","","2017-06-07 00:00:00","4","2610000029","","","0","16800.000000000000000000000000000000","MURTZA CUSTMER","Bill#3363 / Received From Sale To  MURTZA CUSTMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060019/1","","","2017-06-08 00:00:00","1","2610000001","","","37400.000000000000000000000000000000","0","Walk-In-Customers","Bill#3365","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060019/1.","","","2017-06-08 00:00:00","1.","3010000001","","","0","35230.000000000000000000000000000000","Turnover","Bill#3365","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060019/2","","","2017-06-08 00:00:00","2","2710000001","","","37400.000000000000000000000000000000","0","Cash In Hand","Bill#3365 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060019/3","","","2017-06-08 00:00:00","3","2610000001","","","0","37400.000000000000000000000000000000","Walk-In-Customers","Bill#3365 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060020/1","","","2017-06-08 00:00:00","1","2610000029","","","32900.000000000000000000000000000000","0","MURTZA CUSTMER","Bill#3366","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060020/1.","","","2017-06-08 00:00:00","1.","3010000001","","","0","42230.000000000000000000000000000000","Turnover","Bill#3366","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060020/2.","","","2017-06-08 00:00:00","2.","3010000010","","","7000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060020/3","","","2017-06-08 00:00:00","3","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#3366 / Advance Received From 32,900 Sale To  MURTZA CUSTMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060020/4","","","2017-06-08 00:00:00","4","2610000029","","","0","15000.000000000000000000000000000000","MURTZA CUSTMER","Bill#3366 / Advance Received From 32,900 Sale To  MURTZA CUSTMER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060021/1","","","2017-06-08 00:00:00","1","2610000030","","","112000.000000000000000000000000000000","0","200/1-B ST-NO #1 PHASE-5 DHA","Bill#3367","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060021/1.","","","2017-06-08 00:00:00","1.","3010000001","","","0","46242.000000000000000000000000000000","Turnover","Bill#3367","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060021/2.","","","2017-06-08 00:00:00","2.","3010000010","","","4012.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060021/3","","","2017-06-08 00:00:00","3","2710000001","","","110000.000000000000000000000000000000","0","Cash In Hand","Bill#3367 / Advance Received From 112,000 Sale To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060021/4","","","2017-06-08 00:00:00","4","2610000030","","","0","110000.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#3367 / Advance Received From 112,000 Sale To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-06-10 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060024/1","","","2017-06-10 00:00:00","1","2610000031","","","19000.000000000000000000000000000000","0","36-D LAWRENCE ROAD LHR 03034291889","Bill#3373","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060024/1.","","","2017-06-10 00:00:00","1.","3010000001","","","0","46242.000000000000000000000000000000","Turnover","Bill#3373","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060025/1","","","2017-06-12 00:00:00","1","2610000034","","","10500.000000000000000000000000000000","0","H-NO. 923/D PHS 6 DHA LHR","Bill#3375","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060025/1.","","","2017-06-12 00:00:00","1.","3010000001","","","0","46242.000000000000000000000000000000","Turnover","Bill#3375","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060025/2","","","2017-06-12 00:00:00","2","2710000001","","","10500.000000000000000000000000000000","0","Cash In Hand","Bill#3375 / Received From Sale To  H-NO. 923/D PHS 6 DHA LHR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060025/3","","","2017-06-12 00:00:00","3","2610000034","","","0","10500.000000000000000000000000000000","H-NO. 923/D PHS 6 DHA LHR","Bill#3375 / Received From Sale To  H-NO. 923/D PHS 6 DHA LHR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060026/1","","","2017-06-12 00:00:00","1","2610000001","","","37900.000000000000000000000000000000","0","Walk-In-Customers","Bill#3376","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060026/1.","","","2017-06-12 00:00:00","1.","3010000001","","","0","46282.000000000000000000000000000000","Turnover","Bill#3376","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060026/2.","","","2017-06-12 00:00:00","2.","3010000010","","","40.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060026/3","","","2017-06-12 00:00:00","3","2710000001","","","30000.000000000000000000000000000000","0","Cash In Hand","Bill#3376 / Advance Received From 37,900 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060026/4","","","2017-06-12 00:00:00","4","2610000001","","","0","30000.000000000000000000000000000000","Walk-In-Customers","Bill#3376 / Advance Received From 37,900 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060027/1","","","2017-06-12 00:00:00","1","2610000001","","","47350.000000000000000000000000000000","0","Walk-In-Customers","Bill#3377","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060027/1.","","","2017-06-12 00:00:00","1.","3010000001","","","0","46282.000000000000000000000000000000","Turnover","Bill#3377","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060027/2","","","2017-06-12 00:00:00","2","2710000001","","","47350.000000000000000000000000000000","0","Cash In Hand","Bill#3377 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060027/3","","","2017-06-12 00:00:00","3","2610000001","","","0","47350.000000000000000000000000000000","Walk-In-Customers","Bill#3377 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060028/1","","","2017-06-12 00:00:00","1","2610000035","","","30000.000000000000000000000000000000","0","MR. ANEES SB 0321-4185133","Bill#3378","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060028/1.","","","2017-06-12 00:00:00","1.","3010000001","","","0","47282.000000000000000000000000000000","Turnover","Bill#3378","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060028/2.","","","2017-06-12 00:00:00","2.","3010000010","","","1000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060028/3","","","2017-06-12 00:00:00","3","2710000001","","","30000.000000000000000000000000000000","0","Cash In Hand","Bill#3378 / Received From Sale To  MR. ANEES SB 0321-4185133","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060028/4","","","2017-06-12 00:00:00","4","2610000035","","","0","30000.000000000000000000000000000000","MR. ANEES SB 0321-4185133","Bill#3378 / Received From Sale To  MR. ANEES SB 0321-4185133","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060030/1","","","2017-06-13 00:00:00","1","2610000001","","","28800.000000000000000000000000000000","0","Walk-In-Customers","Bill#3382","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060030/1.","","","2017-06-13 00:00:00","1.","3010000001","","","0","47282.000000000000000000000000000000","Turnover","Bill#3382","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060030/2","","","2017-06-13 00:00:00","2","2710000001","","","28800.000000000000000000000000000000","0","Cash In Hand","Bill#3382 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060030/3","","","2017-06-13 00:00:00","3","2610000001","","","0","28800.000000000000000000000000000000","Walk-In-Customers","Bill#3382 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060031/1","","","2017-06-13 00:00:00","1","2610000001","","","20400.000000000000000000000000000000","0","Walk-In-Customers","Bill#3381","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060031/1.","","","2017-06-13 00:00:00","1.","3010000001","","","0","47297.000000000000000000000000000000","Turnover","Bill#3381","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060031/2.","","","2017-06-13 00:00:00","2.","3010000010","","","15.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060031/3","","","2017-06-13 00:00:00","3","2710000001","","","20400.000000000000000000000000000000","0","Cash In Hand","Bill#3381 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060031/4","","","2017-06-13 00:00:00","4","2610000001","","","0","20400.000000000000000000000000000000","Walk-In-Customers","Bill#3381 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060032/1","","","2017-06-13 00:00:00","1","2610000001","","","2400.000000000000000000000000000000","0","Walk-In-Customers","Bill#1558","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060032/1.","","","2017-06-13 00:00:00","1.","3010000001","","","0","47320.000000000000000000000000000000","Turnover","Bill#1558","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060032/2.","","","2017-06-13 00:00:00","2.","3010000010","","","23.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060032/3","","","2017-06-13 00:00:00","3","2710000001","","","2400.000000000000000000000000000000","0","Cash In Hand","Bill#1558 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060032/4","","","2017-06-13 00:00:00","4","2610000001","","","0","2400.000000000000000000000000000000","Walk-In-Customers","Bill#1558 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060033/1","","","2017-06-14 00:00:00","1","2610000001","","","9000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1559","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060033/1.","","","2017-06-14 00:00:00","1.","3010000001","","","0","47320.000000000000000000000000000000","Turnover","Bill#1559","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060033/2","","","2017-06-14 00:00:00","2","2710000001","","","9000.000000000000000000000000000000","0","Cash In Hand","Bill#1559 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060033/3","","","2017-06-14 00:00:00","3","2610000001","","","0","9000.000000000000000000000000000000","Walk-In-Customers","Bill#1559 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060034/1","","","2017-06-15 00:00:00","1","2610000001","","","11000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1560","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060034/1.","","","2017-06-15 00:00:00","1.","3010000001","","","0","47320.000000000000000000000000000000","Turnover","Bill#1560","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060035/1","","","2017-06-16 00:00:00","1","2610000001","","","14500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1101","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060035/1.","","","2017-06-16 00:00:00","1.","3010000001","","","0","47570.000000000000000000000000000000","Turnover","Bill#1101","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060035/2.","","","2017-06-16 00:00:00","2.","3010000010","","","250.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060035/3","","","2017-06-16 00:00:00","3","2710000001","","","14500.000000000000000000000000000000","0","Cash In Hand","Bill#1101 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060035/4","","","2017-06-16 00:00:00","4","2610000001","","","0","14500.000000000000000000000000000000","Walk-In-Customers","Bill#1101 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060036/1","","","2017-06-15 00:00:00","1","2610000038","","","34500.000000000000000000000000000000","0","MALL OF SIALKOT","Bill#1102","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060036/1.","","","2017-06-15 00:00:00","1.","3010000001","","","0","47590.000000000000000000000000000000","Turnover","Bill#1102","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060036/2.","","","2017-06-15 00:00:00","2.","3010000010","","","20.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060037/1","","","2017-06-15 00:00:00","1","2610000038","","","18000.000000000000000000000000000000","0","MALL OF SIALKOT","Bill#1103","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060037/1.","","","2017-06-15 00:00:00","1.","3010000001","","","0","47690.000000000000000000000000000000","Turnover","Bill#1103","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060037/2.","","","2017-06-15 00:00:00","2.","3010000010","","","100.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060038/1","","","2017-06-15 00:00:00","1","2610000038","","","32000.000000000000000000000000000000","0","MALL OF SIALKOT","Bill#1104","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060038/1.","","","2017-06-15 00:00:00","1.","3010000001","","","0","47690.000000000000000000000000000000","Turnover","Bill#1104","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060040/1","","","2017-06-17 00:00:00","1","2610000001","","","94500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1557","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060040/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","47756.000000000000000000000000000000","Turnover","Bill#1557","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060040/2.","","","2017-06-17 00:00:00","2.","3010000010","","","66.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060040/3","","","2017-06-17 00:00:00","3","2710000001","","","94500.000000000000000000000000000000","0","Cash In Hand","Bill#1557 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060040/4","","","2017-06-17 00:00:00","4","2610000001","","","0","94500.000000000000000000000000000000","Walk-In-Customers","Bill#1557 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060041/1","","","2017-06-17 00:00:00","1","2610000001","","","2600.000000000000000000000000000000","0","Walk-In-Customers","Bill#1105","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060041/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","47756.000000000000000000000000000000","Turnover","Bill#1105","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060041/2","","","2017-06-17 00:00:00","2","2710000001","","","2600.000000000000000000000000000000","0","Cash In Hand","Bill#1105 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060041/3","","","2017-06-17 00:00:00","3","2610000001","","","0","2600.000000000000000000000000000000","Walk-In-Customers","Bill#1105 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060042/1","","","2017-06-17 00:00:00","1","2610000040","","","2000.000000000000000000000000000000","0","SHOAIB KHAN SB","Bill#1106","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060042/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","47756.000000000000000000000000000000","Turnover","Bill#1106","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060043/1","","","2017-06-17 00:00:00","1","2610000001","","","3000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1107","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060043/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","47756.000000000000000000000000000000","Turnover","Bill#1107","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060043/2","","","2017-06-17 00:00:00","2","2710000001","","","3000.000000000000000000000000000000","0","Cash In Hand","Bill#1107 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060043/3","","","2017-06-17 00:00:00","3","2610000001","","","0","3000.000000000000000000000000000000","Walk-In-Customers","Bill#1107 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060044/1","","","2017-06-17 00:00:00","1","2610000001","","","4500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1108","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060044/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","48256.000000000000000000000000000000","Turnover","Bill#1108","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060044/2.","","","2017-06-17 00:00:00","2.","3010000010","","","500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060044/3","","","2017-06-17 00:00:00","3","2710000001","","","4500.000000000000000000000000000000","0","Cash In Hand","Bill#1108 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060044/4","","","2017-06-17 00:00:00","4","2610000001","","","0","4500.000000000000000000000000000000","Walk-In-Customers","Bill#1108 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060045/1","","","2017-06-17 00:00:00","1","2610000041","","","19000.000000000000000000000000000000","0","NADEEM SB CUSTOMER","Bill#1109","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060045/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","49756.000000000000000000000000000000","Turnover","Bill#1109","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060045/2.","","","2017-06-17 00:00:00","2.","3010000010","","","1500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060046/1","","","2017-06-17 00:00:00","1","2610000001","","","45000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1110","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060046/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","49756.000000000000000000000000000000","Turnover","Bill#1110","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060046/2","","","2017-06-17 00:00:00","2","2710000001","","","14000.000000000000000000000000000000","0","Cash In Hand","Bill#1110 / Advance Received From 45,000 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060046/3","","","2017-06-17 00:00:00","3","2610000001","","","0","14000.000000000000000000000000000000","Walk-In-Customers","Bill#1110 / Advance Received From 45,000 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060047/1","","","2017-06-17 00:00:00","1","2610000001","","","15000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1111","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060047/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","51256.000000000000000000000000000000","Turnover","Bill#1111","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060047/2.","","","2017-06-17 00:00:00","2.","3010000010","","","1500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060047/3","","","2017-06-17 00:00:00","3","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1111 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060047/4","","","2017-06-17 00:00:00","4","2610000001","","","0","15000.000000000000000000000000000000","Walk-In-Customers","Bill#1111 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060048/1","","","2017-06-17 00:00:00","1","2610000001","","","13000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1112","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060048/1.","","","2017-06-17 00:00:00","1.","3010000001","","","0","51256.000000000000000000000000000000","Turnover","Bill#1112","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060048/2","","","2017-06-17 00:00:00","2","2710000001","","","13000.000000000000000000000000000000","0","Cash In Hand","Bill#1112 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060048/3","","","2017-06-17 00:00:00","3","2610000001","","","0","13000.000000000000000000000000000000","Walk-In-Customers","Bill#1112 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060049/1","","","2017-06-20 00:00:00","1","2610000001","","","8275.000000000000000000000000000000","0","Walk-In-Customers","Bill#1115","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060049/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","51256.000000000000000000000000000000","Turnover","Bill#1115","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060050/1","","","2017-06-20 00:00:00","1","2610000001","","","10950.000000000000000000000000000000","0","Walk-In-Customers","Bill#1116","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060050/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","51256.000000000000000000000000000000","Turnover","Bill#1116","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060051/1","","","2017-06-19 00:00:00","1","2610000044","","","1000.000000000000000000000000000000","0","KHALID SB ASKRI 10","Bill#1113","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060051/1.","","","2017-06-19 00:00:00","1.","3010000001","","","0","51256.000000000000000000000000000000","Turnover","Bill#1113","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060052/1","","","2017-06-20 00:00:00","1","2610000045","","","9500.000000000000000000000000000000","0","347/Y PHS# 3","Bill#1118","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060052/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","52116.000000000000000000000000000000","Turnover","Bill#1118","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060052/2.","","","2017-06-20 00:00:00","2.","3010000010","","","860.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060052/3","","","2017-06-20 00:00:00","3","2710000001","","","8500.000000000000000000000000000000","0","Cash In Hand","Bill#1118 / Advance Received From 9,500 Sale To  347/Y PHS# 3","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060052/4","","","2017-06-20 00:00:00","4","2610000045","","","0","8500.000000000000000000000000000000","347/Y PHS# 3","Bill#1118 / Advance Received From 9,500 Sale To  347/Y PHS# 3","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-06-19 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060054/1","","","2017-06-19 00:00:00","1","2610000001","","","2000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1119","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060054/1.","","","2017-06-19 00:00:00","1.","3010000001","","","0","52116.000000000000000000000000000000","Turnover","Bill#1119","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060054/2","","","2017-06-19 00:00:00","2","2710000001","","","2000.000000000000000000000000000000","0","Cash In Hand","Bill#1119 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060054/3","","","2017-06-19 00:00:00","3","2610000001","","","0","2000.000000000000000000000000000000","Walk-In-Customers","Bill#1119 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060055/1","","","2017-06-20 00:00:00","1","2610000001","","","45000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1120","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060055/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","56116.000000000000000000000000000000","Turnover","Bill#1120","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060055/2.","","","2017-06-20 00:00:00","2.","3010000010","","","4000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060055/3","","","2017-06-20 00:00:00","3","2710000001","","","45000.000000000000000000000000000000","0","Cash In Hand","Bill#1120 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060055/4","","","2017-06-20 00:00:00","4","2610000001","","","0","45000.000000000000000000000000000000","Walk-In-Customers","Bill#1120 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060056/1","","","2017-06-20 00:00:00","1","2610000001","","","15000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1122","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060056/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","57616.000000000000000000000000000000","Turnover","Bill#1122","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060056/2.","","","2017-06-20 00:00:00","2.","3010000010","","","1500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060056/3","","","2017-06-20 00:00:00","3","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1122 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060056/4","","","2017-06-20 00:00:00","4","2610000001","","","0","15000.000000000000000000000000000000","Walk-In-Customers","Bill#1122 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060057/1","","","2017-06-20 00:00:00","1","2610000001","","","300.000000000000000000000000000000","0","Walk-In-Customers","Bill#1125","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060057/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","57676.000000000000000000000000000000","Turnover","Bill#1125","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060057/2.","","","2017-06-20 00:00:00","2.","3010000010","","","60.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060057/3","","","2017-06-20 00:00:00","3","2710000001","","","300.000000000000000000000000000000","0","Cash In Hand","Bill#1125 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060057/4","","","2017-06-20 00:00:00","4","2610000001","","","0","300.000000000000000000000000000000","Walk-In-Customers","Bill#1125 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060058/1","","","2017-06-20 00:00:00","1","2610000001","","","300.000000000000000000000000000000","0","Walk-In-Customers","Bill#1127","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060058/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","57701.000000000000000000000000000000","Turnover","Bill#1127","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060058/2.","","","2017-06-20 00:00:00","2.","3010000010","","","25.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060058/3","","","2017-06-20 00:00:00","3","2710000001","","","300.000000000000000000000000000000","0","Cash In Hand","Bill#1127 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060058/4","","","2017-06-20 00:00:00","4","2610000001","","","0","300.000000000000000000000000000000","Walk-In-Customers","Bill#1127 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060059/1","","","2017-06-20 00:00:00","1","2610000001","","","5500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1123","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060059/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","58451.000000000000000000000000000000","Turnover","Bill#1123","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060059/2.","","","2017-06-20 00:00:00","2.","3010000010","","","750.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060059/3","","","2017-06-20 00:00:00","3","2710000001","","","5500.000000000000000000000000000000","0","Cash In Hand","Bill#1123 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060059/4","","","2017-06-20 00:00:00","4","2610000001","","","0","5500.000000000000000000000000000000","Walk-In-Customers","Bill#1123 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060060/1","","","2017-06-21 00:00:00","1","2610000046","","","16700.000000000000000000000000000000","0","QAYUM SB DHA","Bill#1128","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060060/1.","","","2017-06-21 00:00:00","1.","3010000001","","","0","62885.000000000000000000000000000000","Turnover","Bill#1128","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060060/2.","","","2017-06-21 00:00:00","2.","3010000010","","","4434.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060060/3","","","2017-06-21 00:00:00","3","2710000001","","","16700.000000000000000000000000000000","0","Cash In Hand","Bill#1128 / Received From Sale To  QAYUM SB DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060060/4","","","2017-06-21 00:00:00","4","2610000046","","","0","16700.000000000000000000000000000000","QAYUM SB DHA","Bill#1128 / Received From Sale To  QAYUM SB DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060061/1","","","2017-06-21 00:00:00","1","2610000047","","","237000.000000000000000000000000000000","0","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1129","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060061/1.","","","2017-06-21 00:00:00","1.","3010000001","","","0","102385.000000000000000000000000000000","Turnover","Bill#1129","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060061/2.","","","2017-06-21 00:00:00","2.","3010000010","","","39500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060061/3","","","2017-06-21 00:00:00","3","2710000001","","","237000.000000000000000000000000000000","0","Cash In Hand","Bill#1129 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060061/4","","","2017-06-21 00:00:00","4","2610000047","","","0","237000.000000000000000000000000000000","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1129 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060062/1","","","2017-06-21 00:00:00","1","2610000047","","","55000.000000000000000000000000000000","0","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1130","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060062/1.","","","2017-06-21 00:00:00","1.","3010000001","","","0","105835.000000000000000000000000000000","Turnover","Bill#1130","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060062/2.","","","2017-06-21 00:00:00","2.","3010000010","","","3450.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060062/3","","","2017-06-21 00:00:00","3","2710000001","","","55000.000000000000000000000000000000","0","Cash In Hand","Bill#1130 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060062/4","","","2017-06-21 00:00:00","4","2610000047","","","0","55000.000000000000000000000000000000","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1130 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060063/1","","","2017-06-21 00:00:00","1","2610000001","","","5500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1131","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060063/1.","","","2017-06-21 00:00:00","1.","3010000001","","","0","105835.000000000000000000000000000000","Turnover","Bill#1131","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060063/2","","","2017-06-21 00:00:00","2","2710000001","","","5500.000000000000000000000000000000","0","Cash In Hand","Bill#1131 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060063/3","","","2017-06-21 00:00:00","3","2610000001","","","0","5500.000000000000000000000000000000","Walk-In-Customers","Bill#1131 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060064/1","","","2017-06-22 00:00:00","1","2610000048","","","6500.000000000000000000000000000000","0","NASEEM AHMAD SOFTWARE DEVELOPER","Bill#1132","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060064/1.","","","2017-06-22 00:00:00","1.","3010000001","","","0","106205.000000000000000000000000000000","Turnover","Bill#1132","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060064/2.","","","2017-06-22 00:00:00","2.","3010000010","","","370.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060064/3","","","2017-06-22 00:00:00","3","2710000001","","","6500.000000000000000000000000000000","0","Cash In Hand","Bill#1132 / Received From Sale To  NASEEM AHMAD SOFTWARE DEVELOPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060064/4","","","2017-06-22 00:00:00","4","2610000048","","","0","6500.000000000000000000000000000000","NASEEM AHMAD SOFTWARE DEVELOPER","Bill#1132 / Received From Sale To  NASEEM AHMAD SOFTWARE DEVELOPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-06-22 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060066/1","","","2017-06-22 00:00:00","1","2610000001","","","18000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1133","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060066/1.","","","2017-06-22 00:00:00","1.","3010000001","","","0","106605.000000000000000000000000000000","Turnover","Bill#1133","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060066/2.","","","2017-06-22 00:00:00","2.","3010000010","","","400.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060066/3","","","2017-06-22 00:00:00","3","2710000001","","","18000.000000000000000000000000000000","0","Cash In Hand","Bill#1133 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060066/4","","","2017-06-22 00:00:00","4","2610000001","","","0","18000.000000000000000000000000000000","Walk-In-Customers","Bill#1133 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060067/1","","","2017-06-22 00:00:00","1","2610000001","","","300.000000000000000000000000000000","0","Walk-In-Customers","Bill#1134","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060067/1.","","","2017-06-22 00:00:00","1.","3010000001","","","0","106605.000000000000000000000000000000","Turnover","Bill#1134","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060067/2","","","2017-06-22 00:00:00","2","2710000001","","","300.000000000000000000000000000000","0","Cash In Hand","Bill#1134 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060067/3","","","2017-06-22 00:00:00","3","2610000001","","","0","300.000000000000000000000000000000","Walk-In-Customers","Bill#1134 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060068/1","","","2017-06-22 00:00:00","1","2610000048","","","1600.000000000000000000000000000000","0","NASEEM AHMAD SOFTWARE DEVELOPER","Bill#1135","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060068/1.","","","2017-06-22 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#1135","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060068/2.","","","2017-06-22 00:00:00","2.","3010000010","","","50.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060068/3","","","2017-06-22 00:00:00","3","2710000001","","","1600.000000000000000000000000000000","0","Cash In Hand","Bill#1135 / Received From Sale To  NASEEM AHMAD SOFTWARE DEVELOPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060068/4","","","2017-06-22 00:00:00","4","2610000048","","","0","1600.000000000000000000000000000000","NASEEM AHMAD SOFTWARE DEVELOPER","Bill#1135 / Received From Sale To  NASEEM AHMAD SOFTWARE DEVELOPER","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060069/1","","","2017-06-20 00:00:00","1","2610000045","","","9000.000000000000000000000000000000","0","347/Y PHS# 3","Bill#1126","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060069/1.","","","2017-06-20 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#1126","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060070/1","","","2017-06-23 00:00:00","1","2610000049","","","27500.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Bill#1136","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060070/1.","","","2017-06-23 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#1136","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-06-23 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060072/1","","","2017-05-08 00:00:00","1","2610000028","","","124040.000000000000000000000000000000","0","KASHIF SB 245/G PHS# 5 DHA","Bill#3193","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060072/1.","","","2017-05-08 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#3193","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060072/2","","","2017-05-08 00:00:00","2","2710000001","","","51040.000000000000000000000000000000","0","Cash In Hand","Bill#3193 / Advance Received From 124,040 Sale To  KASHIF SB 245/G PHS# 5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060072/3","","","2017-05-08 00:00:00","3","2610000028","","","0","51040.000000000000000000000000000000","KASHIF SB 245/G PHS# 5 DHA","Bill#3193 / Advance Received From 124,040 Sale To  KASHIF SB 245/G PHS# 5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060073/1","","","2017-05-08 00:00:00","1","2610000050","","","8700.000000000000000000000000000000","0","B PLAZA NADEEM KHAN","Bill#3195","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060073/1.","","","2017-05-08 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#3195","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060074/1","","","2017-05-12 00:00:00","1","2610000040","","","4800.000000000000000000000000000000","0","SHOAIB KHAN SB","Bill#1002","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060074/1.","","","2017-05-12 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#1002","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060075/1","","","2017-05-12 00:00:00","1","2610000028","","","19000.000000000000000000000000000000","0","KASHIF SB 245/G PHS# 5 DHA","Bill#1003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060075/1.","","","2017-05-12 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#1003","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060076/1","","","2017-06-23 00:00:00","1","2610000001","","","4800.000000000000000000000000000000","0","Walk-In-Customers","Bill#1137","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060076/1.","","","2017-06-23 00:00:00","1.","3010000001","","","0","106655.000000000000000000000000000000","Turnover","Bill#1137","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060076/2","","","2017-06-23 00:00:00","2","2710000001","","","4800.000000000000000000000000000000","0","Cash In Hand","Bill#1137 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060076/3","","","2017-06-23 00:00:00","3","2610000001","","","0","4800.000000000000000000000000000000","Walk-In-Customers","Bill#1137 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-05-13 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060078/1","","","2017-05-16 00:00:00","1","2610000049","","","219500.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Bill#009","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060078/1.","","","2017-05-16 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#009","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060078/2.","","","2017-05-16 00:00:00","2.","3010000010","","","12500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060078/3","","","2017-05-16 00:00:00","3","2710000001","","","219500.000000000000000000000000000000","0","Cash In Hand","Bill#009 / Received From Sale To  HAJI HAKM SB 73 / C PH# 6","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060078/4","","","2017-05-16 00:00:00","4","2610000049","","","0","219500.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Bill#009 / Received From Sale To  HAJI HAKM SB 73 / C PH# 6","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060079/1","","","2017-05-17 00:00:00","1","2610000052","","","38000.000000000000000000000000000000","0","DR. ASIM SB 03214864288","Bill#1014","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060079/1.","","","2017-05-17 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1014","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060079/2","","","2017-05-17 00:00:00","2","2710000001","","","20000.000000000000000000000000000000","0","Cash In Hand","Bill#1014 / Advance Received From 38,000 Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060079/3","","","2017-05-17 00:00:00","3","2610000052","","","0","20000.000000000000000000000000000000","DR. ASIM SB 03214864288","Bill#1014 / Advance Received From 38,000 Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060080/1","","","2017-05-17 00:00:00","1","2610000053","","","1000.000000000000000000000000000000","0","69/G MODAL TWON","Bill#1015","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060080/1.","","","2017-05-17 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1015","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060081/1","","","2017-05-17 00:00:00","1","2610000054","","","28000.000000000000000000000000000000","0","228/B STAT LIFE","Bill#1018","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060081/1.","","","2017-05-17 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1018","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060082/1","","","2017-05-22 00:00:00","1","2610000001","","","950.000000000000000000000000000000","0","Walk-In-Customers","Bill#1033","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060082/1.","","","2017-05-22 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1033","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060083/1","","","2017-05-24 00:00:00","1","2610000050","","","6390.000000000000000000000000000000","0","B PLAZA NADEEM KHAN","Bill#1056","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060083/1.","","","2017-05-24 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1056","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060084/1","","","2017-05-24 00:00:00","1","2610000056","","","12700.000000000000000000000000000000","0","242/L PH# 5 DHA  MR.UMAR","Bill#1057","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060084/1.","","","2017-05-24 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1057","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060085/1","","","2017-05-25 00:00:00","1","2610000050","","","11650.000000000000000000000000000000","0","B PLAZA NADEEM KHAN","Bill#1060","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060085/1.","","","2017-05-25 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1060","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060086/1","","","2017-05-27 00:00:00","1","2610000054","","","10000.000000000000000000000000000000","0","228/B STAT LIFE","Bill#1070","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060086/1.","","","2017-05-27 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1070","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060087/1","","","2017-06-23 00:00:00","1","2610000049","","","9600.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Bill#1138","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060087/1.","","","2017-06-23 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1138","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060088/1","","","2017-06-03 00:00:00","1","2610000054","","","21600.000000000000000000000000000000","0","228/B STAT LIFE","Bill#1095","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060088/1.","","","2017-06-03 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1095","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060089/1","","","2017-06-10 00:00:00","1","2610000030","","","154500.000000000000000000000000000000","0","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1139","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060089/1.","","","2017-06-10 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1139","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060089/2","","","2017-06-10 00:00:00","2","2710000001","","","68000.000000000000000000000000000000","0","Cash In Hand","Bill#1139 / Advance Received From 154,500 Sale To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060089/3","","","2017-06-10 00:00:00","3","2610000030","","","0","68000.000000000000000000000000000000","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1139 / Advance Received From 154,500 Sale To  200/1-B ST-NO #1 PHASE-5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060090/1","","","2017-06-13 00:00:00","1","2610000056","","","10000.000000000000000000000000000000","0","242/L PH# 5 DHA  MR.UMAR","Bill#3385","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060090/1.","","","2017-06-13 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#3385","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060091/1","","","2017-06-13 00:00:00","1","2610000027","","","10500.000000000000000000000000000000","0","SAYYAD BROTHER","Bill#3383","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060091/1.","","","2017-06-13 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#3383","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060092/1","","","2017-06-13 00:00:00","1","2610000057","","","10700.000000000000000000000000000000","0","ABDULLAH SB PH# 6 839/D DHA","Bill#3380","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060092/1.","","","2017-06-13 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#3380","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060093/1","","","2017-06-12 00:00:00","1","2610000056","","","650.000000000000000000000000000000","0","242/L PH# 5 DHA  MR.UMAR","Bill#3374","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060093/1.","","","2017-06-12 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#3374","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060094/1","","","2017-06-24 00:00:00","1","2610000035","","","400.000000000000000000000000000000","0","MR. ANEES SB 0321-4185133","Bill#1141","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060094/1.","","","2017-06-24 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1141","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060095/1","","","2017-06-29 00:00:00","1","2610000035","","","22200.000000000000000000000000000000","0","MR. ANEES SB 0321-4185133","Bill#1142","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060095/1.","","","2017-06-29 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1142","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060096/1","","","2017-06-29 00:00:00","1","2610000045","","","5200.000000000000000000000000000000","0","347/Y PHS# 3","Bill#1143","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060096/1.","","","2017-06-29 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1143","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060097/1","","","2017-06-30 00:00:00","1","2610000001","","","1500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1144","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060097/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119155.000000000000000000000000000000","Turnover","Bill#1144","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060097/2","","","2017-06-30 00:00:00","2","2710000001","","","1500.000000000000000000000000000000","0","Cash In Hand","Bill#1144 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060097/3","","","2017-06-30 00:00:00","3","2610000001","","","0","1500.000000000000000000000000000000","Walk-In-Customers","Bill#1144 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060098/1","","","2017-06-30 00:00:00","1","2610000001","","","3700.000000000000000000000000000000","0","Walk-In-Customers","Bill#1145","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060098/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119205.000000000000000000000000000000","Turnover","Bill#1145","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060098/2.","","","2017-06-30 00:00:00","2.","3010000010","","","50.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060098/3","","","2017-06-30 00:00:00","3","2710000001","","","3700.000000000000000000000000000000","0","Cash In Hand","Bill#1145 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060098/4","","","2017-06-30 00:00:00","4","2610000001","","","0","3700.000000000000000000000000000000","Walk-In-Customers","Bill#1145 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060099/1","","","2017-06-30 00:00:00","1","2610000001","","","10000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1146","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060099/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119305.000000000000000000000000000000","Turnover","Bill#1146","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060099/2.","","","2017-06-30 00:00:00","2.","3010000010","","","100.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060099/3","","","2017-06-30 00:00:00","3","2710000001","","","10000.000000000000000000000000000000","0","Cash In Hand","Bill#1146 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060099/4","","","2017-06-30 00:00:00","4","2610000001","","","0","10000.000000000000000000000000000000","Walk-In-Customers","Bill#1146 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060100/1","","","2017-06-30 00:00:00","1","2610000058","","","450000.000000000000000000000000000000","0","AFTAB SB","Bill#1147","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060100/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119305.000000000000000000000000000000","Turnover","Bill#1147","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060100/2","","","2017-06-30 00:00:00","2","2710000001","","","350000.000000000000000000000000000000","0","Cash In Hand","Bill#1147 / Advance Received From 450,000 Sale To  AFTAB SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060100/3","","","2017-06-30 00:00:00","3","2610000058","","","0","350000.000000000000000000000000000000","AFTAB SB","Bill#1147 / Advance Received From 450,000 Sale To  AFTAB SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060101/1","","","2017-06-30 00:00:00","1","2610000001","","","3500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1148","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060101/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119305.000000000000000000000000000000","Turnover","Bill#1148","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060101/2","","","2017-06-30 00:00:00","2","2710000001","","","3500.000000000000000000000000000000","0","Cash In Hand","Bill#1148 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060101/3","","","2017-06-30 00:00:00","3","2610000001","","","0","3500.000000000000000000000000000000","Walk-In-Customers","Bill#1148 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060102/1","","","2017-06-30 00:00:00","1","2610000001","","","350.000000000000000000000000000000","0","Walk-In-Customers","Bill#1149","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060102/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119305.000000000000000000000000000000","Turnover","Bill#1149","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060102/2","","","2017-06-30 00:00:00","2","2710000001","","","350.000000000000000000000000000000","0","Cash In Hand","Bill#1149 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060102/3","","","2017-06-30 00:00:00","3","2610000001","","","0","350.000000000000000000000000000000","Walk-In-Customers","Bill#1149 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060103/1","","","2017-06-30 00:00:00","1","2610000001","","","6200.000000000000000000000000000000","0","Walk-In-Customers","Bill#1151","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060103/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119305.000000000000000000000000000000","Turnover","Bill#1151","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060103/2","","","2017-06-30 00:00:00","2","2710000001","","","6200.000000000000000000000000000000","0","Cash In Hand","Bill#1151 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL060103/3","","","2017-06-30 00:00:00","3","2610000001","","","0","6200.000000000000000000000000000000","Walk-In-Customers","Bill#1151 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070001/1","","","2017-06-30 00:00:00","1","2610000001","","","1800.000000000000000000000000000000","0","Walk-In-Customers","Bill#1150","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070001/1.","","","2017-06-30 00:00:00","1.","3010000001","","","0","119305.000000000000000000000000000000","Turnover","Bill#1150","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070001/2","","","2017-06-30 00:00:00","2","2710000001","","","1800.000000000000000000000000000000","0","Cash In Hand","Bill#1150 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070001/3","","","2017-06-30 00:00:00","3","2610000001","","","0","1800.000000000000000000000000000000","Walk-In-Customers","Bill#1150 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070002/1","","","2017-07-01 00:00:00","1","2610000059","","","33000.000000000000000000000000000000","0","H-NO 254-DD PHS# 4 03218487965","Bill#1152","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070002/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","120505.000000000000000000000000000000","Turnover","Bill#1152","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070002/2.","","","2017-07-01 00:00:00","2.","3010000010","","","1200.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070002/3","","","2017-07-01 00:00:00","3","2710000001","","","33000.000000000000000000000000000000","0","Cash In Hand","Bill#1152 / Received From Sale To  H-NO 254-DD PHS# 4 03218487965","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070002/4","","","2017-07-01 00:00:00","4","2610000059","","","0","33000.000000000000000000000000000000","H-NO 254-DD PHS# 4 03218487965","Bill#1152 / Received From Sale To  H-NO 254-DD PHS# 4 03218487965","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070003/1","","","2017-07-01 00:00:00","1","2610000001","","","93000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1153","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070003/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","121210.000000000000000000000000000000","Turnover","Bill#1153","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070003/2.","","","2017-07-01 00:00:00","2.","3010000010","","","705.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070003/3","","","2017-07-01 00:00:00","3","2710000001","","","50000.000000000000000000000000000000","0","Cash In Hand","Bill#1153 / Advance Received From 93,000 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070003/4","","","2017-07-01 00:00:00","4","2610000001","","","0","50000.000000000000000000000000000000","Walk-In-Customers","Bill#1153 / Advance Received From 93,000 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070004/1","","","2017-07-01 00:00:00","1","2610000001","","","4000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1155","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070004/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","121210.000000000000000000000000000000","Turnover","Bill#1155","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070004/2","","","2017-07-01 00:00:00","2","2710000001","","","4000.000000000000000000000000000000","0","Cash In Hand","Bill#1155 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070004/3","","","2017-07-01 00:00:00","3","2610000001","","","0","4000.000000000000000000000000000000","Walk-In-Customers","Bill#1155 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070005/1","","","2017-07-01 00:00:00","1","2610000001","","","1500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1154","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070005/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","121210.000000000000000000000000000000","Turnover","Bill#1154","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070005/2","","","2017-07-01 00:00:00","2","2710000001","","","1500.000000000000000000000000000000","0","Cash In Hand","Bill#1154 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070005/3","","","2017-07-01 00:00:00","3","2610000001","","","0","1500.000000000000000000000000000000","Walk-In-Customers","Bill#1154 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070006/1","","","2017-07-01 00:00:00","1","2610000001","","","14000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1156","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070006/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","121710.000000000000000000000000000000","Turnover","Bill#1156","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070006/2.","","","2017-07-01 00:00:00","2.","3010000010","","","500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070006/3","","","2017-07-01 00:00:00","3","2710000001","","","14000.000000000000000000000000000000","0","Cash In Hand","Bill#1156 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070006/4","","","2017-07-01 00:00:00","4","2610000001","","","0","14000.000000000000000000000000000000","Walk-In-Customers","Bill#1156 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070007/1","","","2017-07-01 00:00:00","1","2610000060","","","177000.000000000000000000000000000000","0","246/E-1 WAPDA TWON PHAS# 1","Bill#1157","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070007/1.","","","2017-07-01 00:00:00","1.","3010000001","","","0","121710.000000000000000000000000000000","Turnover","Bill#1157","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070007/2","","","2017-07-01 00:00:00","2","2710000001","","","177000.000000000000000000000000000000","0","Cash In Hand","Bill#1157 / Received From Sale To  246/E-1 WAPDA TWON PHAS# 1","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070007/3","","","2017-07-01 00:00:00","3","2610000060","","","0","177000.000000000000000000000000000000","246/E-1 WAPDA TWON PHAS# 1","Bill#1157 / Received From Sale To  246/E-1 WAPDA TWON PHAS# 1","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070008/1","","","2017-07-03 00:00:00","1","2610000001","","","2500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1159","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070008/1.","","","2017-07-03 00:00:00","1.","3010000001","","","0","121710.000000000000000000000000000000","Turnover","Bill#1159","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070008/2","","","2017-07-03 00:00:00","2","2710000001","","","2500.000000000000000000000000000000","0","Cash In Hand","Bill#1159 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070008/3","","","2017-07-03 00:00:00","3","2610000001","","","0","2500.000000000000000000000000000000","Walk-In-Customers","Bill#1159 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070009/1","","","2017-07-03 00:00:00","1","2610000001","","","19000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1160","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070009/1.","","","2017-07-03 00:00:00","1.","3010000001","","","0","121710.000000000000000000000000000000","Turnover","Bill#1160","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070009/2","","","2017-07-03 00:00:00","2","2710000001","","","19000.000000000000000000000000000000","0","Cash In Hand","Bill#1160 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070009/3","","","2017-07-03 00:00:00","3","2610000001","","","0","19000.000000000000000000000000000000","Walk-In-Customers","Bill#1160 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070010/1","","","2017-07-03 00:00:00","1","2610000061","","","47000.000000000000000000000000000000","0","UMER KHALID SB 54/C PHAS# 5 DHA","Bill#1158","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070010/1.","","","2017-07-03 00:00:00","1.","3010000001","","","0","122010.000000000000000000000000000000","Turnover","Bill#1158","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070010/2.","","","2017-07-03 00:00:00","2.","3010000010","","","300.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070010/3","","","2017-07-03 00:00:00","3","2710000001","","","47000.000000000000000000000000000000","0","Cash In Hand","Bill#1158 / Received From Sale To  UMER KHALID SB 54/C PHAS# 5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070010/4","","","2017-07-03 00:00:00","4","2610000061","","","0","47000.000000000000000000000000000000","UMER KHALID SB 54/C PHAS# 5 DHA","Bill#1158 / Received From Sale To  UMER KHALID SB 54/C PHAS# 5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070011/1","","","2017-07-03 00:00:00","1","2610000062","","","19000.000000000000000000000000000000","0","H-NO 862/B PH# 5 DHA","Bill#1161","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070011/1.","","","2017-07-03 00:00:00","1.","3010000001","","","0","122060.000000000000000000000000000000","Turnover","Bill#1161","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070011/2.","","","2017-07-03 00:00:00","2.","3010000010","","","50.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070011/3","","","2017-07-03 00:00:00","3","2710000001","","","19000.000000000000000000000000000000","0","Cash In Hand","Bill#1161 / Received From Sale To  H-NO 862/B PH# 5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070011/4","","","2017-07-03 00:00:00","4","2610000062","","","0","19000.000000000000000000000000000000","H-NO 862/B PH# 5 DHA","Bill#1161 / Received From Sale To  H-NO 862/B PH# 5 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070012/1","","","2017-07-04 00:00:00","1","2610000047","","","1800.000000000000000000000000000000","0","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1162","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070012/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","122060.000000000000000000000000000000","Turnover","Bill#1162","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070012/2","","","2017-07-04 00:00:00","2","2710000001","","","1800.000000000000000000000000000000","0","Cash In Hand","Bill#1162 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070012/3","","","2017-07-04 00:00:00","3","2610000047","","","0","1800.000000000000000000000000000000","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1162 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070013/1","","","2017-07-04 00:00:00","1","2610000047","","","800.000000000000000000000000000000","0","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1163","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070013/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","122160.000000000000000000000000000000","Turnover","Bill#1163","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070013/2.","","","2017-07-04 00:00:00","2.","3010000010","","","100.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070013/3","","","2017-07-04 00:00:00","3","2710000001","","","800.000000000000000000000000000000","0","Cash In Hand","Bill#1163 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070013/4","","","2017-07-04 00:00:00","4","2610000047","","","0","800.000000000000000000000000000000","ARIF NAZIR SB 141-J PHAS 6 DHA","Bill#1163 / Received From Sale To  ARIF NAZIR SB 141-J PHAS 6 DHA","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070014/1","","","2017-07-04 00:00:00","1","2610000001","","","4950.000000000000000000000000000000","0","Walk-In-Customers","Bill#1167","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070014/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","122160.000000000000000000000000000000","Turnover","Bill#1167","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070015/1","","","2017-07-04 00:00:00","1","2610000059","","","31000.000000000000000000000000000000","0","H-NO 254-DD PHS# 4 03218487965","Bill#1562","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070015/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","122240.000000000000000000000000000000","Turnover","Bill#1562","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070015/2.","","","2017-07-04 00:00:00","2.","3010000010","","","80.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070015/3","","","2017-07-04 00:00:00","3","2710000001","","","31000.000000000000000000000000000000","0","Cash In Hand","Bill#1562 / Received From Sale To  H-NO 254-DD PHS# 4 03218487965","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070015/4","","","2017-07-04 00:00:00","4","2610000059","","","0","31000.000000000000000000000000000000","H-NO 254-DD PHS# 4 03218487965","Bill#1562 / Received From Sale To  H-NO 254-DD PHS# 4 03218487965","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070016/1","","","2017-07-04 00:00:00","1","2610000063","","","250000.000000000000000000000000000000","0","H-NO 1070/N PH# 6 BUTT SB","Bill#1168","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070016/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","123853.000000000000000000000000000000","Turnover","Bill#1168","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070016/2.","","","2017-07-04 00:00:00","2.","3010000010","","","1613.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070016/3","","","2017-07-04 00:00:00","3","2710000001","","","250000.000000000000000000000000000000","0","Cash In Hand","Bill#1168 / Received From Sale To  H-NO 1070/N PH# 6 BUTT SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070016/4","","","2017-07-04 00:00:00","4","2610000063","","","0","250000.000000000000000000000000000000","H-NO 1070/N PH# 6 BUTT SB","Bill#1168 / Received From Sale To  H-NO 1070/N PH# 6 BUTT SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070017/1","","","2017-07-04 00:00:00","1","2610000063","","","24000.000000000000000000000000000000","0","H-NO 1070/N PH# 6 BUTT SB","Bill#1169","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070017/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","127353.000000000000000000000000000000","Turnover","Bill#1169","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070017/2.","","","2017-07-04 00:00:00","2.","3010000010","","","3500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070017/3","","","2017-07-04 00:00:00","3","2710000001","","","24000.000000000000000000000000000000","0","Cash In Hand","Bill#1169 / Received From Sale To  H-NO 1070/N PH# 6 BUTT SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070017/4","","","2017-07-04 00:00:00","4","2610000063","","","0","24000.000000000000000000000000000000","H-NO 1070/N PH# 6 BUTT SB","Bill#1169 / Received From Sale To  H-NO 1070/N PH# 6 BUTT SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070018/1","","","2017-07-04 00:00:00","1","2610000063","","","106000.000000000000000000000000000000","0","H-NO 1070/N PH# 6 BUTT SB","Bill#1170","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070018/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","129993.000000000000000000000000000000","Turnover","Bill#1170","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070018/2.","","","2017-07-04 00:00:00","2.","3010000010","","","2640.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070018/3","","","2017-07-04 00:00:00","3","2710000001","","","106000.000000000000000000000000000000","0","Cash In Hand","Bill#1170 / Received From Sale To  H-NO 1070/N PH# 6 BUTT SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070018/4","","","2017-07-04 00:00:00","4","2610000063","","","0","106000.000000000000000000000000000000","H-NO 1070/N PH# 6 BUTT SB","Bill#1170 / Received From Sale To  H-NO 1070/N PH# 6 BUTT SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-07-04 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070020/1","","","2017-07-04 00:00:00","1","2610000001","","","8400.000000000000000000000000000000","0","Walk-In-Customers","Bill#1165","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070020/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","129993.000000000000000000000000000000","Turnover","Bill#1165","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070020/2","","","2017-07-04 00:00:00","2","2710000001","","","8400.000000000000000000000000000000","0","Cash In Hand","Bill#1165 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070020/3","","","2017-07-04 00:00:00","3","2610000001","","","0","8400.000000000000000000000000000000","Walk-In-Customers","Bill#1165 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070021/1","","","2017-07-04 00:00:00","1","2610000001","","","12000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1164","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070021/1.","","","2017-07-04 00:00:00","1.","3010000001","","","0","130093.000000000000000000000000000000","Turnover","Bill#1164","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070021/2.","","","2017-07-04 00:00:00","2.","3010000010","","","100.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070021/3","","","2017-07-04 00:00:00","3","2710000001","","","12000.000000000000000000000000000000","0","Cash In Hand","Bill#1164 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070021/4","","","2017-07-04 00:00:00","4","2610000001","","","0","12000.000000000000000000000000000000","Walk-In-Customers","Bill#1164 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070022/1","","","2017-07-05 00:00:00","1","2610000001","","","1100.000000000000000000000000000000","0","Walk-In-Customers","Bill#1171","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070022/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","130193.000000000000000000000000000000","Turnover","Bill#1171","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070022/2.","","","2017-07-05 00:00:00","2.","3010000010","","","100.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070022/3","","","2017-07-05 00:00:00","3","2710000001","","","1100.000000000000000000000000000000","0","Cash In Hand","Bill#1171 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070022/4","","","2017-07-05 00:00:00","4","2610000001","","","0","1100.000000000000000000000000000000","Walk-In-Customers","Bill#1171 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070023/1","","","2017-07-05 00:00:00","1","2610000001","","","15000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1172","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070023/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","134193.000000000000000000000000000000","Turnover","Bill#1172","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070023/2.","","","2017-07-05 00:00:00","2.","3010000010","","","4000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070023/3","","","2017-07-05 00:00:00","3","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1172 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070023/4","","","2017-07-05 00:00:00","4","2610000001","","","0","15000.000000000000000000000000000000","Walk-In-Customers","Bill#1172 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070024/1","","","2017-07-05 00:00:00","1","2610000064","","","160000.000000000000000000000000000000","0","PESHWAR MALL","Bill#1173","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070024/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","144993.000000000000000000000000000000","Turnover","Bill#1173","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070024/2.","","","2017-07-05 00:00:00","2.","3010000010","","","10800.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070025/1","","","2017-07-05 00:00:00","1","2610000065","","","31000.000000000000000000000000000000","0","H-NO 25/E 35210478","Bill#1174","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070025/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","144993.000000000000000000000000000000","Turnover","Bill#1174","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070025/2","","","2017-07-05 00:00:00","2","2710000001","","","5000.000000000000000000000000000000","0","Cash In Hand","Bill#1174 / Advance Received From 31,000 Sale To  H-NO 25/E 35210478","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070025/3","","","2017-07-05 00:00:00","3","2610000065","","","0","5000.000000000000000000000000000000","H-NO 25/E 35210478","Bill#1174 / Advance Received From 31,000 Sale To  H-NO 25/E 35210478","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070026/1","","","2017-07-05 00:00:00","1","2610000001","","","6000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1175","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070026/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","144993.000000000000000000000000000000","Turnover","Bill#1175","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070026/2","","","2017-07-05 00:00:00","2","2710000001","","","1000.000000000000000000000000000000","0","Cash In Hand","Bill#1175 / Advance Received From 6,000 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070026/3","","","2017-07-05 00:00:00","3","2610000001","","","0","1000.000000000000000000000000000000","Walk-In-Customers","Bill#1175 / Advance Received From 6,000 Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070027/1","","","2017-07-05 00:00:00","1","2610000066","","","102800.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1176","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070027/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","146293.000000000000000000000000000000","Turnover","Bill#1176","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070027/2.","","","2017-07-05 00:00:00","2.","3010000010","","","1300.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070028/1","","","2017-07-05 00:00:00","1","2610000066","","","55200.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1177","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070028/1.","","","2017-07-05 00:00:00","1.","3010000001","","","0","146293.000000000000000000000000000000","Turnover","Bill#1177","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070029/1","","","2017-07-06 00:00:00","1","2610000049","","","100000.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Bill#1178","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070029/1.","","","2017-07-06 00:00:00","1.","3010000001","","","0","150793.000000000000000000000000000000","Turnover","Bill#1178","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070029/2.","","","2017-07-06 00:00:00","2.","3010000010","","","4500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070029/3","","","2017-07-06 00:00:00","3","2710000001","","","100000.000000000000000000000000000000","0","Cash In Hand","Bill#1178 / Received From Sale To  HAJI HAKM SB 73 / C PH# 6","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070029/4","","","2017-07-06 00:00:00","4","2610000049","","","0","100000.000000000000000000000000000000","HAJI HAKM SB 73 / C PH# 6","Bill#1178 / Received From Sale To  HAJI HAKM SB 73 / C PH# 6","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070030/1","","","2017-07-06 00:00:00","1","2610000067","","","40000.000000000000000000000000000000","0","KHAZIR SB SOI GAS SUCITY","Bill#1179","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070030/1.","","","2017-07-06 00:00:00","1.","3010000001","","","0","154759.000000000000000000000000000000","Turnover","Bill#1179","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070030/2.","","","2017-07-06 00:00:00","2.","3010000010","","","3966.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070031/1","","","2017-07-06 00:00:00","1","2610000052","","","15000.000000000000000000000000000000","0","DR. ASIM SB 03214864288","Bill#1180","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070031/1.","","","2017-07-06 00:00:00","1.","3010000001","","","0","154759.000000000000000000000000000000","Turnover","Bill#1180","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070031/2","","","2017-07-06 00:00:00","2","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1180 / Received From Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070031/3","","","2017-07-06 00:00:00","3","2610000052","","","0","15000.000000000000000000000000000000","DR. ASIM SB 03214864288","Bill#1180 / Received From Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070032/1","","","2017-07-06 00:00:00","1","2610000052","","","9000.000000000000000000000000000000","0","DR. ASIM SB 03214864288","Bill#1181","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070032/1.","","","2017-07-06 00:00:00","1.","3010000001","","","0","154759.000000000000000000000000000000","Turnover","Bill#1181","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070032/2","","","2017-07-06 00:00:00","2","2710000001","","","9000.000000000000000000000000000000","0","Cash In Hand","Bill#1181 / Received From Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070032/3","","","2017-07-06 00:00:00","3","2610000052","","","0","9000.000000000000000000000000000000","DR. ASIM SB 03214864288","Bill#1181 / Received From Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070033/1","","","2017-07-07 00:00:00","1","2610000034","","","12200.000000000000000000000000000000","0","H-NO. 923/D PHS 6 DHA LHR","Bill#1183","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070033/1.","","","2017-07-07 00:00:00","1.","3010000001","","","0","155109.000000000000000000000000000000","Turnover","Bill#1183","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070033/2.","","","2017-07-07 00:00:00","2.","3010000010","","","350.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070033/3","","","2017-07-07 00:00:00","3","2710000001","","","12200.000000000000000000000000000000","0","Cash In Hand","Bill#1183 / Received From Sale To  H-NO. 923/D PHS 6 DHA LHR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070033/4","","","2017-07-07 00:00:00","4","2610000034","","","0","12200.000000000000000000000000000000","H-NO. 923/D PHS 6 DHA LHR","Bill#1183 / Received From Sale To  H-NO. 923/D PHS 6 DHA LHR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070034/1","","","2017-05-09 00:00:00","1","2610000056","","","54900.000000000000000000000000000000","0","242/L PH# 5 DHA  MR.UMAR","Bill#3353","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070034/1.","","","2017-05-09 00:00:00","1.","3010000001","","","0","155109.000000000000000000000000000000","Turnover","Bill#3353","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070035/1","","","2017-07-08 00:00:00","1","2610000068","","","42000.000000000000000000000000000000","0","FAZAN SB 03339678883","Bill#1185","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070035/1.","","","2017-07-08 00:00:00","1.","3010000001","","","0","155109.000000000000000000000000000000","Turnover","Bill#1185","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070035/2","","","2017-07-08 00:00:00","2","2710000001","","","42000.000000000000000000000000000000","0","Cash In Hand","Bill#1185 / Received From Sale To  FAZAN SB 03339678883","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070035/3","","","2017-07-08 00:00:00","3","2610000068","","","0","42000.000000000000000000000000000000","FAZAN SB 03339678883","Bill#1185 / Received From Sale To  FAZAN SB 03339678883","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070036/1","","","2017-07-08 00:00:00","1","2610000069","","","9000.000000000000000000000000000000","0","69/9-J-3 JOHAR TWON LHR","Bill#1186","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070036/1.","","","2017-07-08 00:00:00","1.","3010000001","","","0","155109.000000000000000000000000000000","Turnover","Bill#1186","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070036/2","","","2017-07-08 00:00:00","2","2710000001","","","9000.000000000000000000000000000000","0","Cash In Hand","Bill#1186 / Received From Sale To  69/9-J-3 JOHAR TWON LHR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070036/3","","","2017-07-08 00:00:00","3","2610000069","","","0","9000.000000000000000000000000000000","69/9-J-3 JOHAR TWON LHR","Bill#1186 / Received From Sale To  69/9-J-3 JOHAR TWON LHR","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070037/1","","","2017-07-08 00:00:00","1","2610000044","","","1000.000000000000000000000000000000","0","KHALID SB ASKRI 10","Bill#1188","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070037/1.","","","2017-07-08 00:00:00","1.","3010000001","","","0","155109.000000000000000000000000000000","Turnover","Bill#1188","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070038/1","","","2017-07-08 00:00:00","1","2610000001","","","25500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1187","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070038/1.","","","2017-07-08 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1187","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070038/2.","","","2017-07-08 00:00:00","2.","3010000010","","","3000.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070038/3","","","2017-07-08 00:00:00","3","2710000001","","","25500.000000000000000000000000000000","0","Cash In Hand","Bill#1187 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070038/4","","","2017-07-08 00:00:00","4","2610000001","","","0","25500.000000000000000000000000000000","Walk-In-Customers","Bill#1187 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070039/1","","","2017-07-08 00:00:00","1","2610000070","","","15000.000000000000000000000000000000","0","102/CC PHS# 4 DHA SULTAN SB","Bill#1189","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070039/1.","","","2017-07-08 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1189","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070040/1","","","2017-07-08 00:00:00","1","2610000066","","","13000.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1190","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070040/1.","","","2017-07-08 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1190","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070041/1","","","2017-07-10 00:00:00","1","2610000001","","","23300.000000000000000000000000000000","0","Walk-In-Customers","Bill#1191","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070041/1.","","","2017-07-10 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1191","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070041/2","","","2017-07-10 00:00:00","2","2710000001","","","23300.000000000000000000000000000000","0","Cash In Hand","Bill#1191 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070041/3","","","2017-07-10 00:00:00","3","2610000001","","","0","23300.000000000000000000000000000000","Walk-In-Customers","Bill#1191 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070042/1","","","2017-07-11 00:00:00","1","2610000066","","","3500.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1192","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070042/1.","","","2017-07-11 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1192","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070043/1","","","2017-07-11 00:00:00","1","2610000001","","","15000.000000000000000000000000000000","0","Walk-In-Customers","Bill#1193","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070043/1.","","","2017-07-11 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1193","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070043/2","","","2017-07-11 00:00:00","2","2710000001","","","15000.000000000000000000000000000000","0","Cash In Hand","Bill#1193 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070043/3","","","2017-07-11 00:00:00","3","2610000001","","","0","15000.000000000000000000000000000000","Walk-In-Customers","Bill#1193 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070044/1","","","2017-07-11 00:00:00","1","2610000056","","","2000.000000000000000000000000000000","0","242/L PH# 5 DHA  MR.UMAR","Bill#1195","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070044/1.","","","2017-07-11 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1195","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070045/1","","","2017-07-11 00:00:00","1","2610000001","","","1750.000000000000000000000000000000","0","Walk-In-Customers","Bill#1194","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070045/1.","","","2017-07-11 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1194","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070046/1","","","2017-07-12 00:00:00","1","2610000066","","","9100.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1197","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070046/1.","","","2017-07-12 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1197","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070047/1","","","2017-07-12 00:00:00","1","2610000032","","","62280.000000000000000000000000000000","0","AHMAD SB","Bill#1198","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070047/1.","","","2017-07-12 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1198","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070048/1","","","2017-07-12 00:00:00","1","2610000030","","","3250.000000000000000000000000000000","0","200/1-B ST-NO #1 PHASE-5 DHA","Bill#1199","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070048/1.","","","2017-07-12 00:00:00","1.","3010000001","","","0","158109.000000000000000000000000000000","Turnover","Bill#1199","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070049/1","","","2017-07-12 00:00:00","1","2610000001","","","500.000000000000000000000000000000","0","Walk-In-Customers","Bill#1200","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070049/1.","","","2017-07-12 00:00:00","1.","3010000001","","","0","158609.000000000000000000000000000000","Turnover","Bill#1200","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070049/2.","","","2017-07-12 00:00:00","2.","3010000010","","","500.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070049/3","","","2017-07-12 00:00:00","3","2710000001","","","500.000000000000000000000000000000","0","Cash In Hand","Bill#1200 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070049/4","","","2017-07-12 00:00:00","4","2610000001","","","0","500.000000000000000000000000000000","Walk-In-Customers","Bill#1200 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070050/1","","","2017-07-13 00:00:00","1","2610000001","","","4200.000000000000000000000000000000","0","Walk-In-Customers","Bill#3392","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070050/1.","","","2017-07-13 00:00:00","1.","3010000001","","","0","158609.000000000000000000000000000000","Turnover","Bill#3392","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070050/2","","","2017-07-13 00:00:00","2","2710000001","","","4200.000000000000000000000000000000","0","Cash In Hand","Bill#3392 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070050/3","","","2017-07-13 00:00:00","3","2610000001","","","0","4200.000000000000000000000000000000","Walk-In-Customers","Bill#3392 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070051/1","","","2017-07-13 00:00:00","1","2610000001","","","800.000000000000000000000000000000","0","Walk-In-Customers","Bill#3391","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070051/1.","","","2017-07-13 00:00:00","1.","3010000001","","","0","158609.000000000000000000000000000000","Turnover","Bill#3391","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070051/2","","","2017-07-13 00:00:00","2","2710000001","","","800.000000000000000000000000000000","0","Cash In Hand","Bill#3391 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070051/3","","","2017-07-13 00:00:00","3","2610000001","","","0","800.000000000000000000000000000000","Walk-In-Customers","Bill#3391 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070052/1","","","2017-07-13 00:00:00","1","2610000073","","","21000.000000000000000000000000000000","0","328/17 W DHA 03214873769","Bill#3393","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070052/1.","","","2017-07-13 00:00:00","1.","3010000001","","","0","158609.000000000000000000000000000000","Turnover","Bill#3393","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070052/2","","","2017-07-13 00:00:00","2","2710000001","","","21000.000000000000000000000000000000","0","Cash In Hand","Bill#3393 / Received From Sale To  328/17 W DHA 03214873769","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070052/3","","","2017-07-13 00:00:00","3","2610000073","","","0","21000.000000000000000000000000000000","328/17 W DHA 03214873769","Bill#3393 / Received From Sale To  328/17 W DHA 03214873769","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070053/1","","","2017-07-13 00:00:00","1","2610000001","","","13000.000000000000000000000000000000","0","Walk-In-Customers","Bill#3394","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070053/1.","","","2017-07-13 00:00:00","1.","3010000001","","","0","158609.000000000000000000000000000000","Turnover","Bill#3394","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070053/2","","","2017-07-13 00:00:00","2","2710000001","","","13000.000000000000000000000000000000","0","Cash In Hand","Bill#3394 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070053/3","","","2017-07-13 00:00:00","3","2610000001","","","0","13000.000000000000000000000000000000","Walk-In-Customers","Bill#3394 / Received From Sale To  Walk-In-Customers","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070054/1","","","2017-07-13 00:00:00","1","2610000003","","","28800.000000000000000000000000000000","0","Gourmet","Bill#3501","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070054/1.","","","2017-07-13 00:00:00","1.","3010000001","","","0","187409.000000000000000000000000000000","Turnover","Bill#3501","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070054/2.","","","2017-07-13 00:00:00","2.","3010000010","","","28800.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-07-13 00:00:00","","","","","0","0","","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070056/1","","","2017-07-13 00:00:00","1","2610000052","","","66000.000000000000000000000000000000","0","DR. ASIM SB 03214864288","Bill#3395","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070056/1.","","","2017-07-13 00:00:00","1.","3010000001","","","0","188009.000000000000000000000000000000","Turnover","Bill#3395","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070056/2.","","","2017-07-13 00:00:00","2.","3010000010","","","600.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070056/3","","","2017-07-13 00:00:00","3","2710000001","","","66000.000000000000000000000000000000","0","Cash In Hand","Bill#3395 / Received From Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070056/4","","","2017-07-13 00:00:00","4","2610000052","","","0","66000.000000000000000000000000000000","DR. ASIM SB 03214864288","Bill#3395 / Received From Sale To  DR. ASIM SB 03214864288","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070057/1","","","2017-07-14 00:00:00","1","2610000058","","","39000.000000000000000000000000000000","0","AFTAB SB","Bill#1563","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070057/1.","","","2017-07-14 00:00:00","1.","3010000001","","","0","188009.000000000000000000000000000000","Turnover","Bill#1563","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070057/2","","","2017-07-14 00:00:00","2","2710000001","","","39000.000000000000000000000000000000","0","Cash In Hand","Bill#1563 / Received From Sale To  AFTAB SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070057/3","","","2017-07-14 00:00:00","3","2610000058","","","0","39000.000000000000000000000000000000","AFTAB SB","Bill#1563 / Received From Sale To  AFTAB SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070058/1","","","2017-07-14 00:00:00","1","2610000075","","","63000.000000000000000000000000000000","0","236/N PHS# 6 DHA 03226777706","Bill#1201","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070058/1.","","","2017-07-14 00:00:00","1.","3010000001","","","0","188009.000000000000000000000000000000","Turnover","Bill#1201","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070058/2","","","2017-07-14 00:00:00","2","2710000001","","","63000.000000000000000000000000000000","0","Cash In Hand","Bill#1201 / Received From Sale To  236/N PHS# 6 DHA 03226777706","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070058/3","","","2017-07-14 00:00:00","3","2610000075","","","0","63000.000000000000000000000000000000","236/N PHS# 6 DHA 03226777706","Bill#1201 / Received From Sale To  236/N PHS# 6 DHA 03226777706","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070059/1","","","2017-07-15 00:00:00","1","2610000066","","","14000.000000000000000000000000000000","0","398/B PH# 5 DHA KASHIF SB","Bill#1202","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070059/1.","","","2017-07-15 00:00:00","1.","3010000001","","","0","188009.000000000000000000000000000000","Turnover","Bill#1202","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070059/2","","","2017-07-15 00:00:00","2","2710000001","","","14000.000000000000000000000000000000","0","Cash In Hand","Bill#1202 / Received From Sale To  398/B PH# 5 DHA KASHIF SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070059/3","","","2017-07-15 00:00:00","3","2610000066","","","0","14000.000000000000000000000000000000","398/B PH# 5 DHA KASHIF SB","Bill#1202 / Received From Sale To  398/B PH# 5 DHA KASHIF SB","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070060/1","","","2017-07-15 00:00:00","1","2610000076","","","117627.000000000000000000000000000000","0","SYSTEM PLAZA","Bill#1203","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070060/1.","","","2017-07-15 00:00:00","1.","3010000001","","","0","188009.000000000000000000000000000000","Turnover","Bill#1203","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070061/1","","","2017-07-15 00:00:00","1","2610000049","","","19500.000000000000000000000000000000","0","HAJI HAKM SB 73 / C PH# 6","Bill#1205","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070061/1.","","","2017-07-15 00:00:00","1.","3010000001","","","0","197809.000000000000000000000000000000","Turnover","Bill#1205","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","02SL070061/2.","","","2017-07-15 00:00:00","2.","3010000010","","","9800.000000000000000000000000000000","0","Discount Allowed","","on");
INSERT INTO v_vouchers_07_06_17 VALUES("02","","","","2017-06-23 00:00:00","","","","","0","0","","","on");


DROP TABLE IF EXISTS vehicle_type;

CREATE TABLE `vehicle_type` (
  `vehicle_id` varchar(4) NOT NULL,
  `vehicle_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`vehicle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO vehicle_type VALUES("0001","MAZDA");
INSERT INTO vehicle_type VALUES("0002","PICK UP");


DROP TABLE IF EXISTS voucher;

CREATE TABLE `voucher` (
  `VOUCHER_ID` varchar(13) DEFAULT NULL,
  `VOUCHER_DATE` datetime DEFAULT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `POSTED` char(2) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `UPD_DATE` datetime DEFAULT NULL,
  `UPD_EMP_ID` varchar(8) DEFAULT NULL,
  `ACCT_ID_CS_1` char(10) DEFAULT NULL,
  `ACCT_ID_CS_2` char(10) DEFAULT NULL,
  `BILTY_NO` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO voucher VALUES("PL070001","2017-07-15 00:00:00","","","","","on","","","01","17","","","","","","");
INSERT INTO voucher VALUES("SL070001","2017-07-15 00:00:00","","","","","on","","","01","17","","","","","","");
INSERT INTO voucher VALUES("CP070001","2017-07-16 00:00:00","","3700010001","","","on","","","01","17","","","","","","");


DROP TABLE IF EXISTS voucher_id;

CREATE TABLE `voucher_id` (
  `v_id` int(11) DEFAULT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO voucher_id VALUES("1","CP","01");
INSERT INTO voucher_id VALUES("2","CP","01");
INSERT INTO voucher_id VALUES("1","CP","");
INSERT INTO voucher_id VALUES("2","CP","");
INSERT INTO voucher_id VALUES("3","CP","01");
INSERT INTO voucher_id VALUES("1","CP","KT");
INSERT INTO voucher_id VALUES("3","CP","");
INSERT INTO voucher_id VALUES("2","CP","KT");
INSERT INTO voucher_id VALUES("3","CP","KT");
INSERT INTO voucher_id VALUES("4","CP","KT");
INSERT INTO voucher_id VALUES("5","CP","KT");
INSERT INTO voucher_id VALUES("6","CP","KT");
INSERT INTO voucher_id VALUES("7","CP","KT");
INSERT INTO voucher_id VALUES("8","CP","KT");
INSERT INTO voucher_id VALUES("9","CP","KT");
INSERT INTO voucher_id VALUES("10","CP","KT");
INSERT INTO voucher_id VALUES("11","CP","KT");
INSERT INTO voucher_id VALUES("12","CP","KT");
INSERT INTO voucher_id VALUES("13","CP","KT");
INSERT INTO voucher_id VALUES("14","CP","KT");
INSERT INTO voucher_id VALUES("1","JV","KT");
INSERT INTO voucher_id VALUES("2","JV","KT");
INSERT INTO voucher_id VALUES("3","JV","KT");
INSERT INTO voucher_id VALUES("4","JV","KT");
INSERT INTO voucher_id VALUES("1","SL","KT");
INSERT INTO voucher_id VALUES("2","SL","KT");
INSERT INTO voucher_id VALUES("3","SL","KT");
INSERT INTO voucher_id VALUES("4","SL","KT");
INSERT INTO voucher_id VALUES("5","SL","KT");
INSERT INTO voucher_id VALUES("6","SL","KT");
INSERT INTO voucher_id VALUES("7","SL","KT");
INSERT INTO voucher_id VALUES("8","SL","KT");
INSERT INTO voucher_id VALUES("9","SL","KT");
INSERT INTO voucher_id VALUES("10","SL","KT");
INSERT INTO voucher_id VALUES("11","SL","KT");
INSERT INTO voucher_id VALUES("12","SL","KT");
INSERT INTO voucher_id VALUES("13","SL","KT");
INSERT INTO voucher_id VALUES("14","SL","KT");
INSERT INTO voucher_id VALUES("15","SL","KT");
INSERT INTO voucher_id VALUES("16","SL","KT");
INSERT INTO voucher_id VALUES("17","SL","KT");
INSERT INTO voucher_id VALUES("18","SL","KT");
INSERT INTO voucher_id VALUES("19","SL","KT");
INSERT INTO voucher_id VALUES("20","SL","KT");
INSERT INTO voucher_id VALUES("21","SL","KT");
INSERT INTO voucher_id VALUES("22","SL","KT");
INSERT INTO voucher_id VALUES("23","SL","KT");
INSERT INTO voucher_id VALUES("24","SL","KT");
INSERT INTO voucher_id VALUES("25","SL","KT");
INSERT INTO voucher_id VALUES("26","SL","KT");
INSERT INTO voucher_id VALUES("27","SL","KT");
INSERT INTO voucher_id VALUES("28","SL","KT");
INSERT INTO voucher_id VALUES("29","SL","KT");
INSERT INTO voucher_id VALUES("30","SL","KT");
INSERT INTO voucher_id VALUES("31","SL","KT");
INSERT INTO voucher_id VALUES("32","SL","KT");
INSERT INTO voucher_id VALUES("33","SL","KT");
INSERT INTO voucher_id VALUES("34","SL","KT");
INSERT INTO voucher_id VALUES("35","SL","KT");
INSERT INTO voucher_id VALUES("36","SL","KT");
INSERT INTO voucher_id VALUES("37","SL","KT");
INSERT INTO voucher_id VALUES("38","SL","KT");
INSERT INTO voucher_id VALUES("40","SL","KT");
INSERT INTO voucher_id VALUES("42","SL","KT");
INSERT INTO voucher_id VALUES("43","SL","KT");
INSERT INTO voucher_id VALUES("44","SL","KT");
INSERT INTO voucher_id VALUES("45","SL","KT");
INSERT INTO voucher_id VALUES("46","SL","KT");
INSERT INTO voucher_id VALUES("47","SL","KT");
INSERT INTO voucher_id VALUES("1","PL","KT");
INSERT INTO voucher_id VALUES("2","PL","KT");
INSERT INTO voucher_id VALUES("3","PL","KT");
INSERT INTO voucher_id VALUES("4","PL","KT");
INSERT INTO voucher_id VALUES("5","PL","KT");
INSERT INTO voucher_id VALUES("6","PL","KT");
INSERT INTO voucher_id VALUES("7","PL","KT");
INSERT INTO voucher_id VALUES("8","PL","KT");
INSERT INTO voucher_id VALUES("9","PL","KT");
INSERT INTO voucher_id VALUES("10","PL","KT");
INSERT INTO voucher_id VALUES("11","PL","KT");
INSERT INTO voucher_id VALUES("12","PL","KT");
INSERT INTO voucher_id VALUES("13","PL","KT");
INSERT INTO voucher_id VALUES("1","ST","KT");
INSERT INTO voucher_id VALUES("2","ST","KT");
INSERT INTO voucher_id VALUES("3","ST","KT");
INSERT INTO voucher_id VALUES("4","ST","KT");
INSERT INTO voucher_id VALUES("5","ST","KT");
INSERT INTO voucher_id VALUES("6","ST","KT");
INSERT INTO voucher_id VALUES("7","ST","KT");
INSERT INTO voucher_id VALUES("8","ST","KT");
INSERT INTO voucher_id VALUES("9","ST","KT");
INSERT INTO voucher_id VALUES("10","ST","KT");
INSERT INTO voucher_id VALUES("11","ST","KT");
INSERT INTO voucher_id VALUES("12","ST","KT");
INSERT INTO voucher_id VALUES("13","ST","KT");
INSERT INTO voucher_id VALUES("14","ST","KT");
INSERT INTO voucher_id VALUES("15","ST","KT");
INSERT INTO voucher_id VALUES("16","ST","KT");
INSERT INTO voucher_id VALUES("17","ST","KT");
INSERT INTO voucher_id VALUES("18","ST","KT");
INSERT INTO voucher_id VALUES("19","ST","KT");
INSERT INTO voucher_id VALUES("20","ST","KT");
INSERT INTO voucher_id VALUES("21","ST","KT");
INSERT INTO voucher_id VALUES("22","ST","KT");
INSERT INTO voucher_id VALUES("23","ST","KT");
INSERT INTO voucher_id VALUES("24","ST","KT");
INSERT INTO voucher_id VALUES("25","ST","KT");
INSERT INTO voucher_id VALUES("26","ST","KT");
INSERT INTO voucher_id VALUES("27","ST","KT");
INSERT INTO voucher_id VALUES("28","ST","KT");
INSERT INTO voucher_id VALUES("29","ST","KT");
INSERT INTO voucher_id VALUES("30","ST","KT");
INSERT INTO voucher_id VALUES("31","ST","KT");
INSERT INTO voucher_id VALUES("32","ST","KT");
INSERT INTO voucher_id VALUES("33","ST","KT");
INSERT INTO voucher_id VALUES("34","ST","KT");
INSERT INTO voucher_id VALUES("35","ST","KT");
INSERT INTO voucher_id VALUES("36","ST","KT");
INSERT INTO voucher_id VALUES("37","ST","KT");
INSERT INTO voucher_id VALUES("38","ST","KT");
INSERT INTO voucher_id VALUES("39","ST","KT");
INSERT INTO voucher_id VALUES("40","ST","KT");
INSERT INTO voucher_id VALUES("41","ST","KT");
INSERT INTO voucher_id VALUES("42","ST","KT");
INSERT INTO voucher_id VALUES("43","ST","KT");
INSERT INTO voucher_id VALUES("44","ST","KT");
INSERT INTO voucher_id VALUES("14","PL","KT");
INSERT INTO voucher_id VALUES("15","PL","KT");
INSERT INTO voucher_id VALUES("16","PL","KT");
INSERT INTO voucher_id VALUES("17","PL","KT");
INSERT INTO voucher_id VALUES("18","PL","KT");
INSERT INTO voucher_id VALUES("19","PL","KT");
INSERT INTO voucher_id VALUES("48","SL","KT");
INSERT INTO voucher_id VALUES("49","SL","KT");
INSERT INTO voucher_id VALUES("45","ST","KT");
INSERT INTO voucher_id VALUES("46","ST","KT");
INSERT INTO voucher_id VALUES("47","ST","KT");
INSERT INTO voucher_id VALUES("48","ST","KT");
INSERT INTO voucher_id VALUES("49","ST","KT");
INSERT INTO voucher_id VALUES("50","ST","KT");
INSERT INTO voucher_id VALUES("51","ST","KT");
INSERT INTO voucher_id VALUES("52","ST","KT");
INSERT INTO voucher_id VALUES("53","ST","KT");
INSERT INTO voucher_id VALUES("54","ST","KT");
INSERT INTO voucher_id VALUES("55","ST","KT");
INSERT INTO voucher_id VALUES("56","ST","KT");
INSERT INTO voucher_id VALUES("57","ST","KT");
INSERT INTO voucher_id VALUES("58","ST","KT");
INSERT INTO voucher_id VALUES("59","ST","KT");
INSERT INTO voucher_id VALUES("60","ST","KT");
INSERT INTO voucher_id VALUES("15","CP","KT");
INSERT INTO voucher_id VALUES("16","CP","KT");
INSERT INTO voucher_id VALUES("5","JV","KT");
INSERT INTO voucher_id VALUES("50","SL","KT");
INSERT INTO voucher_id VALUES("17","CP","KT");
INSERT INTO voucher_id VALUES("51","SL","KT");
INSERT INTO voucher_id VALUES("6","JV","KT");
INSERT INTO voucher_id VALUES("7","JV","KT");
INSERT INTO voucher_id VALUES("8","JV","KT");
INSERT INTO voucher_id VALUES("9","JV","KT");
INSERT INTO voucher_id VALUES("20","PL","KT");
INSERT INTO voucher_id VALUES("52","SL","KT");
INSERT INTO voucher_id VALUES("53","SL","KT");
INSERT INTO voucher_id VALUES("54","SL","KT");
INSERT INTO voucher_id VALUES("21","PL","KT");
INSERT INTO voucher_id VALUES("18","CP","KT");
INSERT INTO voucher_id VALUES("55","SL","KT");
INSERT INTO voucher_id VALUES("61","ST","KT");
INSERT INTO voucher_id VALUES("56","SL","KT");
INSERT INTO voucher_id VALUES("22","PL","KT");
INSERT INTO voucher_id VALUES("62","ST","KT");
INSERT INTO voucher_id VALUES("63","ST","KT");
INSERT INTO voucher_id VALUES("57","SL","KT");
INSERT INTO voucher_id VALUES("58","SL","KT");
INSERT INTO voucher_id VALUES("59","SL","KT");
INSERT INTO voucher_id VALUES("60","SL","KT");
INSERT INTO voucher_id VALUES("61","SL","KT");
INSERT INTO voucher_id VALUES("62","SL","KT");
INSERT INTO voucher_id VALUES("63","SL","KT");
INSERT INTO voucher_id VALUES("23","PL","KT");
INSERT INTO voucher_id VALUES("24","PL","KT");
INSERT INTO voucher_id VALUES("64","ST","KT");
INSERT INTO voucher_id VALUES("1","SL","IT");
INSERT INTO voucher_id VALUES("2","SL","IT");
INSERT INTO voucher_id VALUES("25","PL","KT");
INSERT INTO voucher_id VALUES("26","PL","KT");
INSERT INTO voucher_id VALUES("27","PL","KT");
INSERT INTO voucher_id VALUES("28","PL","KT");
INSERT INTO voucher_id VALUES("29","PL","KT");
INSERT INTO voucher_id VALUES("30","PL","KT");
INSERT INTO voucher_id VALUES("31","PL","KT");
INSERT INTO voucher_id VALUES("32","PL","KT");
INSERT INTO voucher_id VALUES("33","PL","KT");
INSERT INTO voucher_id VALUES("34","PL","KT");
INSERT INTO voucher_id VALUES("35","PL","KT");
INSERT INTO voucher_id VALUES("36","PL","KT");
INSERT INTO voucher_id VALUES("37","PL","KT");
INSERT INTO voucher_id VALUES("38","PL","KT");
INSERT INTO voucher_id VALUES("39","PL","KT");
INSERT INTO voucher_id VALUES("40","PL","KT");
INSERT INTO voucher_id VALUES("41","PL","KT");
INSERT INTO voucher_id VALUES("42","PL","KT");
INSERT INTO voucher_id VALUES("43","PL","KT");
INSERT INTO voucher_id VALUES("44","PL","KT");
INSERT INTO voucher_id VALUES("45","PL","KT");
INSERT INTO voucher_id VALUES("46","PL","KT");
INSERT INTO voucher_id VALUES("47","PL","KT");
INSERT INTO voucher_id VALUES("48","PL","KT");
INSERT INTO voucher_id VALUES("49","PL","KT");
INSERT INTO voucher_id VALUES("50","PL","KT");
INSERT INTO voucher_id VALUES("51","PL","KT");
INSERT INTO voucher_id VALUES("52","PL","KT");
INSERT INTO voucher_id VALUES("53","PL","KT");
INSERT INTO voucher_id VALUES("54","PL","KT");
INSERT INTO voucher_id VALUES("55","PL","KT");
INSERT INTO voucher_id VALUES("56","PL","KT");
INSERT INTO voucher_id VALUES("57","PL","KT");
INSERT INTO voucher_id VALUES("58","PL","KT");
INSERT INTO voucher_id VALUES("59","PL","KT");
INSERT INTO voucher_id VALUES("60","PL","KT");
INSERT INTO voucher_id VALUES("61","PL","KT");
INSERT INTO voucher_id VALUES("62","PL","KT");
INSERT INTO voucher_id VALUES("63","PL","KT");
INSERT INTO voucher_id VALUES("64","PL","KT");
INSERT INTO voucher_id VALUES("65","PL","KT");
INSERT INTO voucher_id VALUES("66","PL","KT");
INSERT INTO voucher_id VALUES("67","PL","KT");
INSERT INTO voucher_id VALUES("68","PL","KT");
INSERT INTO voucher_id VALUES("69","PL","KT");
INSERT INTO voucher_id VALUES("70","PL","KT");
INSERT INTO voucher_id VALUES("71","PL","KT");
INSERT INTO voucher_id VALUES("72","PL","KT");
INSERT INTO voucher_id VALUES("73","PL","KT");
INSERT INTO voucher_id VALUES("74","PL","KT");
INSERT INTO voucher_id VALUES("75","PL","KT");
INSERT INTO voucher_id VALUES("76","PL","KT");
INSERT INTO voucher_id VALUES("77","PL","KT");
INSERT INTO voucher_id VALUES("78","PL","KT");
INSERT INTO voucher_id VALUES("79","PL","KT");
INSERT INTO voucher_id VALUES("64","SL","KT");
INSERT INTO voucher_id VALUES("80","PL","KT");
INSERT INTO voucher_id VALUES("65","SL","KT");
INSERT INTO voucher_id VALUES("66","SL","KT");
INSERT INTO voucher_id VALUES("67","SL","KT");
INSERT INTO voucher_id VALUES("68","SL","KT");
INSERT INTO voucher_id VALUES("69","SL","KT");
INSERT INTO voucher_id VALUES("70","SL","KT");
INSERT INTO voucher_id VALUES("71","SL","KT");
INSERT INTO voucher_id VALUES("72","SL","KT");
INSERT INTO voucher_id VALUES("73","SL","KT");
INSERT INTO voucher_id VALUES("74","SL","KT");
INSERT INTO voucher_id VALUES("75","SL","KT");
INSERT INTO voucher_id VALUES("76","SL","KT");
INSERT INTO voucher_id VALUES("77","SL","KT");
INSERT INTO voucher_id VALUES("78","SL","KT");
INSERT INTO voucher_id VALUES("79","SL","KT");
INSERT INTO voucher_id VALUES("80","SL","KT");
INSERT INTO voucher_id VALUES("81","SL","KT");
INSERT INTO voucher_id VALUES("82","SL","KT");
INSERT INTO voucher_id VALUES("83","SL","KT");
INSERT INTO voucher_id VALUES("84","SL","KT");
INSERT INTO voucher_id VALUES("85","SL","KT");
INSERT INTO voucher_id VALUES("86","SL","KT");
INSERT INTO voucher_id VALUES("87","SL","KT");
INSERT INTO voucher_id VALUES("81","PL","KT");
INSERT INTO voucher_id VALUES("88","SL","KT");
INSERT INTO voucher_id VALUES("89","SL","KT");
INSERT INTO voucher_id VALUES("90","SL","KT");
INSERT INTO voucher_id VALUES("91","SL","KT");
INSERT INTO voucher_id VALUES("92","SL","KT");
INSERT INTO voucher_id VALUES("93","SL","KT");
INSERT INTO voucher_id VALUES("94","SL","KT");
INSERT INTO voucher_id VALUES("82","PL","KT");
INSERT INTO voucher_id VALUES("95","SL","KT");
INSERT INTO voucher_id VALUES("96","SL","KT");
INSERT INTO voucher_id VALUES("97","SL","KT");
INSERT INTO voucher_id VALUES("98","SL","KT");
INSERT INTO voucher_id VALUES("99","SL","KT");
INSERT INTO voucher_id VALUES("100","SL","KT");
INSERT INTO voucher_id VALUES("101","SL","KT");
INSERT INTO voucher_id VALUES("102","SL","KT");
INSERT INTO voucher_id VALUES("103","SL","KT");
INSERT INTO voucher_id VALUES("104","SL","KT");
INSERT INTO voucher_id VALUES("105","SL","KT");
INSERT INTO voucher_id VALUES("106","SL","KT");
INSERT INTO voucher_id VALUES("107","SL","KT");
INSERT INTO voucher_id VALUES("108","SL","KT");
INSERT INTO voucher_id VALUES("109","SL","KT");
INSERT INTO voucher_id VALUES("110","SL","KT");
INSERT INTO voucher_id VALUES("111","SL","KT");
INSERT INTO voucher_id VALUES("112","SL","KT");
INSERT INTO voucher_id VALUES("113","SL","KT");
INSERT INTO voucher_id VALUES("114","SL","KT");
INSERT INTO voucher_id VALUES("115","SL","KT");
INSERT INTO voucher_id VALUES("116","SL","KT");
INSERT INTO voucher_id VALUES("117","SL","KT");
INSERT INTO voucher_id VALUES("118","SL","KT");
INSERT INTO voucher_id VALUES("119","SL","KT");
INSERT INTO voucher_id VALUES("83","PL","KT");
INSERT INTO voucher_id VALUES("84","PL","KT");
INSERT INTO voucher_id VALUES("85","PL","KT");
INSERT INTO voucher_id VALUES("86","PL","KT");
INSERT INTO voucher_id VALUES("87","PL","KT");
INSERT INTO voucher_id VALUES("120","SL","KT");
INSERT INTO voucher_id VALUES("88","PL","KT");
INSERT INTO voucher_id VALUES("89","PL","KT");
INSERT INTO voucher_id VALUES("90","PL","KT");
INSERT INTO voucher_id VALUES("91","PL","KT");
INSERT INTO voucher_id VALUES("10","JV","KT");
INSERT INTO voucher_id VALUES("11","JV","KT");
INSERT INTO voucher_id VALUES("12","JV","KT");
INSERT INTO voucher_id VALUES("13","JV","KT");
INSERT INTO voucher_id VALUES("14","JV","KT");
INSERT INTO voucher_id VALUES("15","JV","KT");
INSERT INTO voucher_id VALUES("16","JV","KT");
INSERT INTO voucher_id VALUES("17","JV","KT");
INSERT INTO voucher_id VALUES("18","JV","KT");
INSERT INTO voucher_id VALUES("19","JV","KT");
INSERT INTO voucher_id VALUES("20","JV","KT");
INSERT INTO voucher_id VALUES("21","JV","KT");
INSERT INTO voucher_id VALUES("22","JV","KT");
INSERT INTO voucher_id VALUES("23","JV","KT");
INSERT INTO voucher_id VALUES("24","JV","KT");
INSERT INTO voucher_id VALUES("25","JV","KT");
INSERT INTO voucher_id VALUES("26","JV","KT");
INSERT INTO voucher_id VALUES("27","JV","KT");
INSERT INTO voucher_id VALUES("28","JV","KT");
INSERT INTO voucher_id VALUES("92","PL","KT");
INSERT INTO voucher_id VALUES("93","PL","KT");
INSERT INTO voucher_id VALUES("94","PL","KT");
INSERT INTO voucher_id VALUES("95","PL","KT");
INSERT INTO voucher_id VALUES("96","PL","KT");
INSERT INTO voucher_id VALUES("97","PL","KT");
INSERT INTO voucher_id VALUES("98","PL","KT");
INSERT INTO voucher_id VALUES("99","PL","KT");
INSERT INTO voucher_id VALUES("121","SL","KT");
INSERT INTO voucher_id VALUES("122","SL","KT");
INSERT INTO voucher_id VALUES("123","SL","KT");
INSERT INTO voucher_id VALUES("29","JV","KT");
INSERT INTO voucher_id VALUES("30","JV","KT");
INSERT INTO voucher_id VALUES("31","JV","KT");
INSERT INTO voucher_id VALUES("32","JV","KT");
INSERT INTO voucher_id VALUES("33","JV","KT");
INSERT INTO voucher_id VALUES("34","JV","KT");
INSERT INTO voucher_id VALUES("124","SL","KT");
INSERT INTO voucher_id VALUES("125","SL","KT");
INSERT INTO voucher_id VALUES("126","SL","KT");
INSERT INTO voucher_id VALUES("127","SL","KT");
INSERT INTO voucher_id VALUES("100","PL","KT");
INSERT INTO voucher_id VALUES("101","PL","KT");
INSERT INTO voucher_id VALUES("102","PL","KT");
INSERT INTO voucher_id VALUES("103","PL","KT");
INSERT INTO voucher_id VALUES("104","PL","KT");
INSERT INTO voucher_id VALUES("105","PL","KT");
INSERT INTO voucher_id VALUES("106","PL","KT");
INSERT INTO voucher_id VALUES("107","PL","KT");
INSERT INTO voucher_id VALUES("108","PL","KT");
INSERT INTO voucher_id VALUES("109","PL","KT");
INSERT INTO voucher_id VALUES("110","PL","KT");
INSERT INTO voucher_id VALUES("111","PL","KT");
INSERT INTO voucher_id VALUES("112","PL","KT");
INSERT INTO voucher_id VALUES("113","PL","KT");
INSERT INTO voucher_id VALUES("35","JV","KT");
INSERT INTO voucher_id VALUES("36","JV","KT");
INSERT INTO voucher_id VALUES("37","JV","KT");
INSERT INTO voucher_id VALUES("38","JV","KT");
INSERT INTO voucher_id VALUES("39","JV","KT");
INSERT INTO voucher_id VALUES("40","JV","KT");
INSERT INTO voucher_id VALUES("41","JV","KT");
INSERT INTO voucher_id VALUES("42","JV","KT");
INSERT INTO voucher_id VALUES("43","JV","KT");
INSERT INTO voucher_id VALUES("44","JV","KT");
INSERT INTO voucher_id VALUES("45","JV","KT");
INSERT INTO voucher_id VALUES("46","JV","KT");
INSERT INTO voucher_id VALUES("47","JV","KT");
INSERT INTO voucher_id VALUES("48","JV","KT");
INSERT INTO voucher_id VALUES("49","JV","KT");
INSERT INTO voucher_id VALUES("50","JV","KT");
INSERT INTO voucher_id VALUES("51","JV","KT");
INSERT INTO voucher_id VALUES("52","JV","KT");
INSERT INTO voucher_id VALUES("128","SL","KT");
INSERT INTO voucher_id VALUES("129","SL","KT");
INSERT INTO voucher_id VALUES("53","JV","KT");
INSERT INTO voucher_id VALUES("54","JV","KT");
INSERT INTO voucher_id VALUES("55","JV","KT");
INSERT INTO voucher_id VALUES("56","JV","KT");
INSERT INTO voucher_id VALUES("114","PL","KT");
INSERT INTO voucher_id VALUES("57","JV","KT");
INSERT INTO voucher_id VALUES("115","PL","KT");
INSERT INTO voucher_id VALUES("116","PL","KT");
INSERT INTO voucher_id VALUES("117","PL","KT");
INSERT INTO voucher_id VALUES("118","PL","KT");
INSERT INTO voucher_id VALUES("119","PL","KT");
INSERT INTO voucher_id VALUES("120","PL","KT");
INSERT INTO voucher_id VALUES("121","PL","KT");
INSERT INTO voucher_id VALUES("130","SL","KT");
INSERT INTO voucher_id VALUES("131","SL","KT");
INSERT INTO voucher_id VALUES("132","SL","KT");
INSERT INTO voucher_id VALUES("133","SL","KT");
INSERT INTO voucher_id VALUES("65","ST","KT");
INSERT INTO voucher_id VALUES("66","ST","KT");
INSERT INTO voucher_id VALUES("67","ST","KT");
INSERT INTO voucher_id VALUES("68","ST","KT");
INSERT INTO voucher_id VALUES("69","ST","KT");
INSERT INTO voucher_id VALUES("134","SL","KT");
INSERT INTO voucher_id VALUES("122","PL","KT");
INSERT INTO voucher_id VALUES("19","CP","KT");
INSERT INTO voucher_id VALUES("20","CP","KT");
INSERT INTO voucher_id VALUES("21","CP","KT");
INSERT INTO voucher_id VALUES("22","CP","KT");
INSERT INTO voucher_id VALUES("23","CP","KT");
INSERT INTO voucher_id VALUES("24","CP","KT");
INSERT INTO voucher_id VALUES("25","CP","KT");
INSERT INTO voucher_id VALUES("26","CP","KT");
INSERT INTO voucher_id VALUES("27","CP","KT");
INSERT INTO voucher_id VALUES("28","CP","KT");
INSERT INTO voucher_id VALUES("29","CP","KT");
INSERT INTO voucher_id VALUES("30","CP","KT");
INSERT INTO voucher_id VALUES("31","CP","KT");
INSERT INTO voucher_id VALUES("32","CP","KT");
INSERT INTO voucher_id VALUES("33","CP","KT");
INSERT INTO voucher_id VALUES("135","SL","KT");
INSERT INTO voucher_id VALUES("34","CP","KT");
INSERT INTO voucher_id VALUES("35","CP","KT");
INSERT INTO voucher_id VALUES("36","CP","KT");
INSERT INTO voucher_id VALUES("37","CP","KT");
INSERT INTO voucher_id VALUES("38","CP","KT");
INSERT INTO voucher_id VALUES("39","CP","KT");
INSERT INTO voucher_id VALUES("40","CP","KT");
INSERT INTO voucher_id VALUES("41","CP","KT");
INSERT INTO voucher_id VALUES("42","CP","KT");
INSERT INTO voucher_id VALUES("43","CP","KT");
INSERT INTO voucher_id VALUES("44","CP","KT");
INSERT INTO voucher_id VALUES("45","CP","KT");
INSERT INTO voucher_id VALUES("46","CP","KT");
INSERT INTO voucher_id VALUES("47","CP","KT");
INSERT INTO voucher_id VALUES("48","CP","KT");
INSERT INTO voucher_id VALUES("49","CP","KT");
INSERT INTO voucher_id VALUES("50","CP","KT");
INSERT INTO voucher_id VALUES("51","CP","KT");
INSERT INTO voucher_id VALUES("52","CP","KT");
INSERT INTO voucher_id VALUES("53","CP","KT");
INSERT INTO voucher_id VALUES("54","CP","KT");
INSERT INTO voucher_id VALUES("55","CP","KT");
INSERT INTO voucher_id VALUES("56","CP","KT");
INSERT INTO voucher_id VALUES("57","CP","KT");
INSERT INTO voucher_id VALUES("58","CP","KT");
INSERT INTO voucher_id VALUES("59","CP","KT");
INSERT INTO voucher_id VALUES("60","CP","KT");
INSERT INTO voucher_id VALUES("61","CP","KT");
INSERT INTO voucher_id VALUES("62","CP","KT");
INSERT INTO voucher_id VALUES("63","CP","KT");
INSERT INTO voucher_id VALUES("64","CP","KT");
INSERT INTO voucher_id VALUES("65","CP","KT");
INSERT INTO voucher_id VALUES("66","CP","KT");
INSERT INTO voucher_id VALUES("67","CP","KT");
INSERT INTO voucher_id VALUES("68","CP","KT");
INSERT INTO voucher_id VALUES("69","CP","KT");
INSERT INTO voucher_id VALUES("70","CP","KT");
INSERT INTO voucher_id VALUES("71","CP","KT");
INSERT INTO voucher_id VALUES("72","CP","KT");
INSERT INTO voucher_id VALUES("73","CP","KT");
INSERT INTO voucher_id VALUES("74","CP","KT");
INSERT INTO voucher_id VALUES("75","CP","KT");
INSERT INTO voucher_id VALUES("76","CP","KT");
INSERT INTO voucher_id VALUES("77","CP","KT");
INSERT INTO voucher_id VALUES("78","CP","KT");
INSERT INTO voucher_id VALUES("79","CP","KT");
INSERT INTO voucher_id VALUES("80","CP","KT");
INSERT INTO voucher_id VALUES("123","PL","KT");
INSERT INTO voucher_id VALUES("124","PL","KT");
INSERT INTO voucher_id VALUES("125","PL","KT");
INSERT INTO voucher_id VALUES("126","PL","KT");
INSERT INTO voucher_id VALUES("127","PL","KT");
INSERT INTO voucher_id VALUES("128","PL","KT");
INSERT INTO voucher_id VALUES("129","PL","KT");
INSERT INTO voucher_id VALUES("130","PL","KT");
INSERT INTO voucher_id VALUES("131","PL","KT");
INSERT INTO voucher_id VALUES("132","PL","KT");
INSERT INTO voucher_id VALUES("133","PL","KT");
INSERT INTO voucher_id VALUES("134","PL","KT");
INSERT INTO voucher_id VALUES("135","PL","KT");
INSERT INTO voucher_id VALUES("136","PL","KT");
INSERT INTO voucher_id VALUES("137","PL","KT");
INSERT INTO voucher_id VALUES("138","PL","KT");
INSERT INTO voucher_id VALUES("139","PL","KT");
INSERT INTO voucher_id VALUES("140","PL","KT");
INSERT INTO voucher_id VALUES("141","PL","KT");
INSERT INTO voucher_id VALUES("142","PL","KT");
INSERT INTO voucher_id VALUES("136","SL","KT");
INSERT INTO voucher_id VALUES("137","SL","KT");
INSERT INTO voucher_id VALUES("143","PL","KT");
INSERT INTO voucher_id VALUES("144","PL","KT");
INSERT INTO voucher_id VALUES("145","PL","KT");
INSERT INTO voucher_id VALUES("146","PL","KT");
INSERT INTO voucher_id VALUES("81","CP","KT");
INSERT INTO voucher_id VALUES("82","CP","KT");
INSERT INTO voucher_id VALUES("83","CP","KT");
INSERT INTO voucher_id VALUES("84","CP","KT");
INSERT INTO voucher_id VALUES("85","CP","KT");
INSERT INTO voucher_id VALUES("86","CP","KT");
INSERT INTO voucher_id VALUES("87","CP","KT");
INSERT INTO voucher_id VALUES("88","CP","KT");
INSERT INTO voucher_id VALUES("89","CP","KT");
INSERT INTO voucher_id VALUES("90","CP","KT");
INSERT INTO voucher_id VALUES("91","CP","KT");
INSERT INTO voucher_id VALUES("92","CP","KT");
INSERT INTO voucher_id VALUES("93","CP","KT");
INSERT INTO voucher_id VALUES("94","CP","KT");
INSERT INTO voucher_id VALUES("95","CP","KT");
INSERT INTO voucher_id VALUES("96","CP","KT");
INSERT INTO voucher_id VALUES("97","CP","KT");
INSERT INTO voucher_id VALUES("98","CP","KT");
INSERT INTO voucher_id VALUES("99","CP","KT");
INSERT INTO voucher_id VALUES("100","CP","KT");
INSERT INTO voucher_id VALUES("101","CP","KT");
INSERT INTO voucher_id VALUES("102","CP","KT");
INSERT INTO voucher_id VALUES("103","CP","KT");
INSERT INTO voucher_id VALUES("104","CP","KT");
INSERT INTO voucher_id VALUES("105","CP","KT");
INSERT INTO voucher_id VALUES("106","CP","KT");
INSERT INTO voucher_id VALUES("107","CP","KT");
INSERT INTO voucher_id VALUES("108","CP","KT");
INSERT INTO voucher_id VALUES("109","CP","KT");
INSERT INTO voucher_id VALUES("110","CP","KT");
INSERT INTO voucher_id VALUES("111","CP","KT");
INSERT INTO voucher_id VALUES("112","CP","KT");
INSERT INTO voucher_id VALUES("113","CP","KT");
INSERT INTO voucher_id VALUES("114","CP","KT");
INSERT INTO voucher_id VALUES("115","CP","KT");
INSERT INTO voucher_id VALUES("116","CP","KT");
INSERT INTO voucher_id VALUES("117","CP","KT");
INSERT INTO voucher_id VALUES("118","CP","KT");
INSERT INTO voucher_id VALUES("119","CP","KT");
INSERT INTO voucher_id VALUES("120","CP","KT");
INSERT INTO voucher_id VALUES("121","CP","KT");
INSERT INTO voucher_id VALUES("122","CP","KT");
INSERT INTO voucher_id VALUES("123","CP","KT");
INSERT INTO voucher_id VALUES("124","CP","KT");
INSERT INTO voucher_id VALUES("125","CP","KT");
INSERT INTO voucher_id VALUES("147","PL","KT");
INSERT INTO voucher_id VALUES("148","PL","KT");
INSERT INTO voucher_id VALUES("149","PL","KT");
INSERT INTO voucher_id VALUES("150","PL","KT");
INSERT INTO voucher_id VALUES("151","PL","KT");
INSERT INTO voucher_id VALUES("152","PL","KT");
INSERT INTO voucher_id VALUES("153","PL","KT");
INSERT INTO voucher_id VALUES("154","PL","KT");
INSERT INTO voucher_id VALUES("155","PL","KT");
INSERT INTO voucher_id VALUES("156","PL","KT");
INSERT INTO voucher_id VALUES("157","PL","KT");
INSERT INTO voucher_id VALUES("158","PL","KT");
INSERT INTO voucher_id VALUES("159","PL","KT");
INSERT INTO voucher_id VALUES("160","PL","KT");
INSERT INTO voucher_id VALUES("161","PL","KT");
INSERT INTO voucher_id VALUES("162","PL","KT");
INSERT INTO voucher_id VALUES("163","PL","KT");
INSERT INTO voucher_id VALUES("164","PL","KT");
INSERT INTO voucher_id VALUES("165","PL","KT");
INSERT INTO voucher_id VALUES("166","PL","KT");
INSERT INTO voucher_id VALUES("167","PL","KT");
INSERT INTO voucher_id VALUES("168","PL","KT");
INSERT INTO voucher_id VALUES("169","PL","KT");
INSERT INTO voucher_id VALUES("170","PL","KT");
INSERT INTO voucher_id VALUES("171","PL","KT");
INSERT INTO voucher_id VALUES("172","PL","KT");
INSERT INTO voucher_id VALUES("173","PL","KT");
INSERT INTO voucher_id VALUES("174","PL","KT");
INSERT INTO voucher_id VALUES("175","PL","KT");
INSERT INTO voucher_id VALUES("176","PL","KT");
INSERT INTO voucher_id VALUES("177","PL","KT");
INSERT INTO voucher_id VALUES("178","PL","KT");
INSERT INTO voucher_id VALUES("179","PL","KT");
INSERT INTO voucher_id VALUES("180","PL","KT");
INSERT INTO voucher_id VALUES("181","PL","KT");
INSERT INTO voucher_id VALUES("182","PL","KT");
INSERT INTO voucher_id VALUES("183","PL","KT");
INSERT INTO voucher_id VALUES("184","PL","KT");
INSERT INTO voucher_id VALUES("185","PL","KT");
INSERT INTO voucher_id VALUES("186","PL","KT");
INSERT INTO voucher_id VALUES("187","PL","KT");
INSERT INTO voucher_id VALUES("188","PL","KT");
INSERT INTO voucher_id VALUES("189","PL","KT");
INSERT INTO voucher_id VALUES("190","PL","KT");
INSERT INTO voucher_id VALUES("191","PL","KT");
INSERT INTO voucher_id VALUES("192","PL","KT");
INSERT INTO voucher_id VALUES("193","PL","KT");
INSERT INTO voucher_id VALUES("194","PL","KT");
INSERT INTO voucher_id VALUES("195","PL","KT");
INSERT INTO voucher_id VALUES("196","PL","KT");
INSERT INTO voucher_id VALUES("197","PL","KT");
INSERT INTO voucher_id VALUES("198","PL","KT");
INSERT INTO voucher_id VALUES("199","PL","KT");
INSERT INTO voucher_id VALUES("200","PL","KT");
INSERT INTO voucher_id VALUES("201","PL","KT");
INSERT INTO voucher_id VALUES("202","PL","KT");
INSERT INTO voucher_id VALUES("203","PL","KT");
INSERT INTO voucher_id VALUES("204","PL","KT");
INSERT INTO voucher_id VALUES("205","PL","KT");
INSERT INTO voucher_id VALUES("206","PL","KT");
INSERT INTO voucher_id VALUES("207","PL","KT");
INSERT INTO voucher_id VALUES("208","PL","KT");
INSERT INTO voucher_id VALUES("209","PL","KT");
INSERT INTO voucher_id VALUES("210","PL","KT");
INSERT INTO voucher_id VALUES("211","PL","KT");
INSERT INTO voucher_id VALUES("212","PL","KT");
INSERT INTO voucher_id VALUES("213","PL","KT");
INSERT INTO voucher_id VALUES("214","PL","KT");
INSERT INTO voucher_id VALUES("215","PL","KT");
INSERT INTO voucher_id VALUES("216","PL","KT");
INSERT INTO voucher_id VALUES("217","PL","KT");
INSERT INTO voucher_id VALUES("218","PL","KT");
INSERT INTO voucher_id VALUES("219","PL","KT");
INSERT INTO voucher_id VALUES("126","CP","KT");
INSERT INTO voucher_id VALUES("127","CP","KT");
INSERT INTO voucher_id VALUES("70","ST","KT");
INSERT INTO voucher_id VALUES("128","CP","KT");
INSERT INTO voucher_id VALUES("129","CP","KT");
INSERT INTO voucher_id VALUES("130","CP","KT");
INSERT INTO voucher_id VALUES("131","CP","KT");
INSERT INTO voucher_id VALUES("220","PL","KT");
INSERT INTO voucher_id VALUES("221","PL","KT");
INSERT INTO voucher_id VALUES("222","PL","KT");
INSERT INTO voucher_id VALUES("223","PL","KT");
INSERT INTO voucher_id VALUES("224","PL","KT");
INSERT INTO voucher_id VALUES("225","PL","KT");
INSERT INTO voucher_id VALUES("226","PL","KT");
INSERT INTO voucher_id VALUES("227","PL","KT");
INSERT INTO voucher_id VALUES("228","PL","KT");
INSERT INTO voucher_id VALUES("229","PL","KT");
INSERT INTO voucher_id VALUES("230","PL","KT");
INSERT INTO voucher_id VALUES("138","SL","KT");
INSERT INTO voucher_id VALUES("231","PL","KT");
INSERT INTO voucher_id VALUES("232","PL","KT");
INSERT INTO voucher_id VALUES("71","ST","KT");
INSERT INTO voucher_id VALUES("72","ST","KT");
INSERT INTO voucher_id VALUES("73","ST","KT");
INSERT INTO voucher_id VALUES("74","ST","KT");
INSERT INTO voucher_id VALUES("75","ST","KT");
INSERT INTO voucher_id VALUES("76","ST","KT");
INSERT INTO voucher_id VALUES("77","ST","KT");
INSERT INTO voucher_id VALUES("78","ST","KT");
INSERT INTO voucher_id VALUES("79","ST","KT");
INSERT INTO voucher_id VALUES("80","ST","KT");
INSERT INTO voucher_id VALUES("81","ST","KT");
INSERT INTO voucher_id VALUES("82","ST","KT");
INSERT INTO voucher_id VALUES("139","SL","KT");
INSERT INTO voucher_id VALUES("233","PL","KT");
INSERT INTO voucher_id VALUES("234","PL","KT");
INSERT INTO voucher_id VALUES("235","PL","KT");
INSERT INTO voucher_id VALUES("236","PL","KT");
INSERT INTO voucher_id VALUES("140","SL","KT");
INSERT INTO voucher_id VALUES("237","PL","KT");
INSERT INTO voucher_id VALUES("141","SL","KT");
INSERT INTO voucher_id VALUES("142","SL","KT");
INSERT INTO voucher_id VALUES("238","PL","KT");
INSERT INTO voucher_id VALUES("83","ST","KT");
INSERT INTO voucher_id VALUES("132","CP","KT");
INSERT INTO voucher_id VALUES("133","CP","KT");
INSERT INTO voucher_id VALUES("134","CP","KT");
INSERT INTO voucher_id VALUES("135","CP","KT");
INSERT INTO voucher_id VALUES("239","PL","KT");
INSERT INTO voucher_id VALUES("240","PL","KT");
INSERT INTO voucher_id VALUES("241","PL","KT");
INSERT INTO voucher_id VALUES("242","PL","KT");
INSERT INTO voucher_id VALUES("243","PL","KT");
INSERT INTO voucher_id VALUES("244","PL","KT");
INSERT INTO voucher_id VALUES("245","PL","KT");
INSERT INTO voucher_id VALUES("246","PL","KT");
INSERT INTO voucher_id VALUES("143","SL","KT");
INSERT INTO voucher_id VALUES("144","SL","KT");
INSERT INTO voucher_id VALUES("145","SL","KT");
INSERT INTO voucher_id VALUES("146","SL","KT");
INSERT INTO voucher_id VALUES("147","SL","KT");
INSERT INTO voucher_id VALUES("148","SL","KT");
INSERT INTO voucher_id VALUES("149","SL","KT");
INSERT INTO voucher_id VALUES("150","SL","KT");
INSERT INTO voucher_id VALUES("151","SL","KT");
INSERT INTO voucher_id VALUES("152","SL","KT");
INSERT INTO voucher_id VALUES("153","SL","KT");
INSERT INTO voucher_id VALUES("154","SL","KT");
INSERT INTO voucher_id VALUES("155","SL","KT");
INSERT INTO voucher_id VALUES("84","ST","KT");
INSERT INTO voucher_id VALUES("247","PL","KT");
INSERT INTO voucher_id VALUES("248","PL","KT");
INSERT INTO voucher_id VALUES("85","ST","KT");
INSERT INTO voucher_id VALUES("249","PL","KT");
INSERT INTO voucher_id VALUES("250","PL","KT");
INSERT INTO voucher_id VALUES("251","PL","KT");
INSERT INTO voucher_id VALUES("252","PL","KT");
INSERT INTO voucher_id VALUES("253","PL","KT");
INSERT INTO voucher_id VALUES("86","ST","KT");
INSERT INTO voucher_id VALUES("254","PL","KT");
INSERT INTO voucher_id VALUES("255","PL","KT");
INSERT INTO voucher_id VALUES("156","SL","KT");
INSERT INTO voucher_id VALUES("157","SL","KT");
INSERT INTO voucher_id VALUES("158","SL","KT");
INSERT INTO voucher_id VALUES("159","SL","KT");
INSERT INTO voucher_id VALUES("256","PL","KT");
INSERT INTO voucher_id VALUES("257","PL","KT");
INSERT INTO voucher_id VALUES("258","PL","KT");
INSERT INTO voucher_id VALUES("87","ST","KT");
INSERT INTO voucher_id VALUES("160","SL","KT");
INSERT INTO voucher_id VALUES("1","CP","IT");
INSERT INTO voucher_id VALUES("1","ST","IT");
INSERT INTO voucher_id VALUES("2","ST","IT");
INSERT INTO voucher_id VALUES("1","BP","IT");
INSERT INTO voucher_id VALUES("3","SL","IT");
INSERT INTO voucher_id VALUES("1","","IT");
INSERT INTO voucher_id VALUES("1","PL","IT");
INSERT INTO voucher_id VALUES("4","SL","IT");
INSERT INTO voucher_id VALUES("2","PL","IT");
INSERT INTO voucher_id VALUES("5","SL","IT");
INSERT INTO voucher_id VALUES("3","ST","IT");
INSERT INTO voucher_id VALUES("4","ST","IT");
INSERT INTO voucher_id VALUES("5","ST","IT");
INSERT INTO voucher_id VALUES("6","SL","IT");
INSERT INTO voucher_id VALUES("88","ST","KT");
INSERT INTO voucher_id VALUES("1","CR","KT");
INSERT INTO voucher_id VALUES("2","CR","KT");
INSERT INTO voucher_id VALUES("89","ST","KT");
INSERT INTO voucher_id VALUES("90","ST","KT");
INSERT INTO voucher_id VALUES("91","ST","KT");
INSERT INTO voucher_id VALUES("3","CR","KT");
INSERT INTO voucher_id VALUES("7","SL","IT");
INSERT INTO voucher_id VALUES("161","SL","KT");
INSERT INTO voucher_id VALUES("259","PL","KT");
INSERT INTO voucher_id VALUES("260","PL","KT");
INSERT INTO voucher_id VALUES("261","PL","KT");
INSERT INTO voucher_id VALUES("262","PL","KT");
INSERT INTO voucher_id VALUES("263","PL","KT");
INSERT INTO voucher_id VALUES("264","PL","KT");
INSERT INTO voucher_id VALUES("265","PL","KT");
INSERT INTO voucher_id VALUES("162","SL","KT");
INSERT INTO voucher_id VALUES("163","SL","KT");
INSERT INTO voucher_id VALUES("164","SL","KT");
INSERT INTO voucher_id VALUES("266","PL","KT");
INSERT INTO voucher_id VALUES("267","PL","KT");
INSERT INTO voucher_id VALUES("136","CP","KT");
INSERT INTO voucher_id VALUES("137","CP","KT");
INSERT INTO voucher_id VALUES("268","PL","KT");
INSERT INTO voucher_id VALUES("269","PL","KT");
INSERT INTO voucher_id VALUES("270","PL","KT");
INSERT INTO voucher_id VALUES("271","PL","KT");
INSERT INTO voucher_id VALUES("165","SL","KT");
INSERT INTO voucher_id VALUES("166","SL","KT");
INSERT INTO voucher_id VALUES("1","BP","KT");
INSERT INTO voucher_id VALUES("167","SL","KT");
INSERT INTO voucher_id VALUES("1","CR","BT");
INSERT INTO voucher_id VALUES("8","SL","IT");
INSERT INTO voucher_id VALUES("168","SL","KT");
INSERT INTO voucher_id VALUES("272","PL","KT");
INSERT INTO voucher_id VALUES("273","PL","KT");
INSERT INTO voucher_id VALUES("169","SL","KT");
INSERT INTO voucher_id VALUES("274","PL","KT");
INSERT INTO voucher_id VALUES("275","PL","KT");
INSERT INTO voucher_id VALUES("276","PL","KT");
INSERT INTO voucher_id VALUES("277","PL","KT");
INSERT INTO voucher_id VALUES("170","SL","KT");
INSERT INTO voucher_id VALUES("171","SL","KT");
INSERT INTO voucher_id VALUES("172","SL","KT");
INSERT INTO voucher_id VALUES("278","PL","KT");
INSERT INTO voucher_id VALUES("279","PL","KT");
INSERT INTO voucher_id VALUES("280","PL","KT");
INSERT INTO voucher_id VALUES("173","SL","KT");
INSERT INTO voucher_id VALUES("174","SL","KT");
INSERT INTO voucher_id VALUES("175","SL","KT");
INSERT INTO voucher_id VALUES("176","SL","KT");
INSERT INTO voucher_id VALUES("177","SL","KT");
INSERT INTO voucher_id VALUES("178","SL","KT");
INSERT INTO voucher_id VALUES("179","SL","KT");
INSERT INTO voucher_id VALUES("180","SL","KT");
INSERT INTO voucher_id VALUES("281","PL","KT");
INSERT INTO voucher_id VALUES("181","SL","KT");
INSERT INTO voucher_id VALUES("182","SL","KT");
INSERT INTO voucher_id VALUES("282","PL","KT");
INSERT INTO voucher_id VALUES("183","SL","KT");
INSERT INTO voucher_id VALUES("184","SL","KT");
INSERT INTO voucher_id VALUES("185","SL","KT");
INSERT INTO voucher_id VALUES("186","SL","KT");
INSERT INTO voucher_id VALUES("1","PL","BT");
INSERT INTO voucher_id VALUES("2","PL","BT");
INSERT INTO voucher_id VALUES("187","SL","KT");
INSERT INTO voucher_id VALUES("283","PL","KT");
INSERT INTO voucher_id VALUES("188","SL","KT");
INSERT INTO voucher_id VALUES("189","SL","KT");
INSERT INTO voucher_id VALUES("190","SL","KT");
INSERT INTO voucher_id VALUES("284","PL","KT");
INSERT INTO voucher_id VALUES("285","PL","KT");
INSERT INTO voucher_id VALUES("1","SL","BT");
INSERT INTO voucher_id VALUES("3","PL","BT");
INSERT INTO voucher_id VALUES("191","SL","KT");
INSERT INTO voucher_id VALUES("2","SL","BT");
INSERT INTO voucher_id VALUES("1","BR","BT");
INSERT INTO voucher_id VALUES("1","RT","KT");
INSERT INTO voucher_id VALUES("3","PL","IT");
INSERT INTO voucher_id VALUES("9","SL","IT");
INSERT INTO voucher_id VALUES("192","SL","KT");
INSERT INTO voucher_id VALUES("286","PL","KT");
INSERT INTO voucher_id VALUES("92","ST","KT");
INSERT INTO voucher_id VALUES("2","RT","KT");
INSERT INTO voucher_id VALUES("3","RT","KT");
INSERT INTO voucher_id VALUES("4","PL","IT");
INSERT INTO voucher_id VALUES("10","SL","IT");
INSERT INTO voucher_id VALUES("2","CP","IT");
INSERT INTO voucher_id VALUES("1","SL","01");
INSERT INTO voucher_id VALUES("2","SL","01");
INSERT INTO voucher_id VALUES("3","SL","01");
INSERT INTO voucher_id VALUES("4","SL","01");
INSERT INTO voucher_id VALUES("5","SL","01");
INSERT INTO voucher_id VALUES("6","SL","01");
INSERT INTO voucher_id VALUES("7","SL","01");
INSERT INTO voucher_id VALUES("8","SL","01");
INSERT INTO voucher_id VALUES("9","SL","01");
INSERT INTO voucher_id VALUES("10","SL","01");
INSERT INTO voucher_id VALUES("11","SL","01");
INSERT INTO voucher_id VALUES("12","SL","01");
INSERT INTO voucher_id VALUES("13","SL","01");
INSERT INTO voucher_id VALUES("14","SL","01");
INSERT INTO voucher_id VALUES("15","SL","01");
INSERT INTO voucher_id VALUES("16","SL","01");
INSERT INTO voucher_id VALUES("17","SL","01");
INSERT INTO voucher_id VALUES("18","SL","01");
INSERT INTO voucher_id VALUES("19","SL","01");
INSERT INTO voucher_id VALUES("20","SL","01");
INSERT INTO voucher_id VALUES("21","SL","01");
INSERT INTO voucher_id VALUES("22","SL","01");
INSERT INTO voucher_id VALUES("23","SL","01");
INSERT INTO voucher_id VALUES("24","SL","01");
INSERT INTO voucher_id VALUES("1","ST","01");
INSERT INTO voucher_id VALUES("25","SL","01");
INSERT INTO voucher_id VALUES("1","PL","01");
INSERT INTO voucher_id VALUES("26","SL","01");
INSERT INTO voucher_id VALUES("27","SL","01");
INSERT INTO voucher_id VALUES("28","SL","01");
INSERT INTO voucher_id VALUES("2","PL","01");
INSERT INTO voucher_id VALUES("3","PL","01");
INSERT INTO voucher_id VALUES("4","PL","01");
INSERT INTO voucher_id VALUES("5","PL","01");
INSERT INTO voucher_id VALUES("6","PL","01");
INSERT INTO voucher_id VALUES("7","PL","01");
INSERT INTO voucher_id VALUES("8","PL","01");
INSERT INTO voucher_id VALUES("9","PL","01");
INSERT INTO voucher_id VALUES("10","PL","01");
INSERT INTO voucher_id VALUES("11","PL","01");
INSERT INTO voucher_id VALUES("12","PL","01");
INSERT INTO voucher_id VALUES("13","PL","01");
INSERT INTO voucher_id VALUES("14","PL","01");
INSERT INTO voucher_id VALUES("15","PL","01");
INSERT INTO voucher_id VALUES("29","SL","01");
INSERT INTO voucher_id VALUES("30","SL","01");
INSERT INTO voucher_id VALUES("31","SL","01");
INSERT INTO voucher_id VALUES("32","SL","01");
INSERT INTO voucher_id VALUES("33","SL","01");
INSERT INTO voucher_id VALUES("34","SL","01");
INSERT INTO voucher_id VALUES("35","SL","01");
INSERT INTO voucher_id VALUES("36","SL","01");
INSERT INTO voucher_id VALUES("37","SL","01");
INSERT INTO voucher_id VALUES("38","SL","01");
INSERT INTO voucher_id VALUES("39","SL","01");
INSERT INTO voucher_id VALUES("2","ST","01");
INSERT INTO voucher_id VALUES("40","SL","01");
INSERT INTO voucher_id VALUES("41","SL","01");
INSERT INTO voucher_id VALUES("42","SL","01");
INSERT INTO voucher_id VALUES("43","SL","01");
INSERT INTO voucher_id VALUES("44","SL","01");
INSERT INTO voucher_id VALUES("45","SL","01");
INSERT INTO voucher_id VALUES("46","SL","01");
INSERT INTO voucher_id VALUES("47","SL","01");
INSERT INTO voucher_id VALUES("48","SL","01");
INSERT INTO voucher_id VALUES("49","SL","01");
INSERT INTO voucher_id VALUES("50","SL","01");
INSERT INTO voucher_id VALUES("51","SL","01");
INSERT INTO voucher_id VALUES("52","SL","01");
INSERT INTO voucher_id VALUES("53","SL","01");
INSERT INTO voucher_id VALUES("1","RT","01");
INSERT INTO voucher_id VALUES("2","RT","01");
INSERT INTO voucher_id VALUES("54","SL","01");
INSERT INTO voucher_id VALUES("55","SL","01");
INSERT INTO voucher_id VALUES("56","SL","01");
INSERT INTO voucher_id VALUES("3","RT","01");
INSERT INTO voucher_id VALUES("4","RT","01");
INSERT INTO voucher_id VALUES("57","SL","01");
INSERT INTO voucher_id VALUES("58","SL","01");
INSERT INTO voucher_id VALUES("59","SL","01");
INSERT INTO voucher_id VALUES("60","SL","01");
INSERT INTO voucher_id VALUES("61","SL","01");
INSERT INTO voucher_id VALUES("62","SL","01");
INSERT INTO voucher_id VALUES("63","SL","01");
INSERT INTO voucher_id VALUES("64","SL","01");
INSERT INTO voucher_id VALUES("65","SL","01");
INSERT INTO voucher_id VALUES("66","SL","01");
INSERT INTO voucher_id VALUES("67","SL","01");
INSERT INTO voucher_id VALUES("68","SL","01");
INSERT INTO voucher_id VALUES("69","SL","01");
INSERT INTO voucher_id VALUES("70","SL","01");
INSERT INTO voucher_id VALUES("71","SL","01");
INSERT INTO voucher_id VALUES("72","SL","01");
INSERT INTO voucher_id VALUES("73","SL","01");
INSERT INTO voucher_id VALUES("74","SL","01");
INSERT INTO voucher_id VALUES("75","SL","01");
INSERT INTO voucher_id VALUES("76","SL","01");
INSERT INTO voucher_id VALUES("77","SL","01");
INSERT INTO voucher_id VALUES("78","SL","01");
INSERT INTO voucher_id VALUES("79","SL","01");
INSERT INTO voucher_id VALUES("80","SL","01");
INSERT INTO voucher_id VALUES("81","SL","01");
INSERT INTO voucher_id VALUES("82","SL","01");
INSERT INTO voucher_id VALUES("83","SL","01");
INSERT INTO voucher_id VALUES("16","PL","01");
INSERT INTO voucher_id VALUES("84","SL","01");
INSERT INTO voucher_id VALUES("85","SL","01");
INSERT INTO voucher_id VALUES("17","PL","01");
INSERT INTO voucher_id VALUES("18","PL","01");
INSERT INTO voucher_id VALUES("19","PL","01");
INSERT INTO voucher_id VALUES("20","PL","01");
INSERT INTO voucher_id VALUES("4","CP","01");
INSERT INTO voucher_id VALUES("21","PL","01");
INSERT INTO voucher_id VALUES("22","PL","01");
INSERT INTO voucher_id VALUES("23","PL","01");
INSERT INTO voucher_id VALUES("24","PL","01");
INSERT INTO voucher_id VALUES("25","PL","01");
INSERT INTO voucher_id VALUES("86","SL","01");
INSERT INTO voucher_id VALUES("87","SL","01");
INSERT INTO voucher_id VALUES("88","SL","01");
INSERT INTO voucher_id VALUES("5","CP","01");
INSERT INTO voucher_id VALUES("89","SL","01");
INSERT INTO voucher_id VALUES("90","SL","01");
INSERT INTO voucher_id VALUES("91","SL","01");
INSERT INTO voucher_id VALUES("92","SL","01");
INSERT INTO voucher_id VALUES("93","SL","01");
INSERT INTO voucher_id VALUES("94","SL","01");
INSERT INTO voucher_id VALUES("95","SL","01");
INSERT INTO voucher_id VALUES("96","SL","01");
INSERT INTO voucher_id VALUES("97","SL","01");
INSERT INTO voucher_id VALUES("98","SL","01");
INSERT INTO voucher_id VALUES("99","SL","01");
INSERT INTO voucher_id VALUES("26","PL","01");
INSERT INTO voucher_id VALUES("100","SL","01");
INSERT INTO voucher_id VALUES("101","SL","01");
INSERT INTO voucher_id VALUES("102","SL","01");
INSERT INTO voucher_id VALUES("27","PL","01");
INSERT INTO voucher_id VALUES("103","SL","01");
INSERT INTO voucher_id VALUES("104","SL","01");
INSERT INTO voucher_id VALUES("28","PL","01");
INSERT INTO voucher_id VALUES("105","SL","01");
INSERT INTO voucher_id VALUES("106","SL","01");
INSERT INTO voucher_id VALUES("107","SL","01");
INSERT INTO voucher_id VALUES("108","SL","01");
INSERT INTO voucher_id VALUES("109","SL","01");
INSERT INTO voucher_id VALUES("110","SL","01");
INSERT INTO voucher_id VALUES("111","SL","01");
INSERT INTO voucher_id VALUES("112","SL","01");
INSERT INTO voucher_id VALUES("113","SL","01");
INSERT INTO voucher_id VALUES("114","SL","01");
INSERT INTO voucher_id VALUES("115","SL","01");
INSERT INTO voucher_id VALUES("116","SL","01");
INSERT INTO voucher_id VALUES("117","SL","01");
INSERT INTO voucher_id VALUES("118","SL","01");
INSERT INTO voucher_id VALUES("119","SL","01");
INSERT INTO voucher_id VALUES("120","SL","01");
INSERT INTO voucher_id VALUES("121","SL","01");
INSERT INTO voucher_id VALUES("29","PL","01");
INSERT INTO voucher_id VALUES("30","PL","01");
INSERT INTO voucher_id VALUES("122","SL","01");
INSERT INTO voucher_id VALUES("123","SL","01");
INSERT INTO voucher_id VALUES("124","SL","01");
INSERT INTO voucher_id VALUES("125","SL","01");
INSERT INTO voucher_id VALUES("126","SL","01");
INSERT INTO voucher_id VALUES("127","SL","01");
INSERT INTO voucher_id VALUES("128","SL","01");
INSERT INTO voucher_id VALUES("129","SL","01");
INSERT INTO voucher_id VALUES("130","SL","01");
INSERT INTO voucher_id VALUES("131","SL","01");
INSERT INTO voucher_id VALUES("132","SL","01");
INSERT INTO voucher_id VALUES("133","SL","01");
INSERT INTO voucher_id VALUES("134","SL","01");
INSERT INTO voucher_id VALUES("31","PL","01");
INSERT INTO voucher_id VALUES("32","PL","01");
INSERT INTO voucher_id VALUES("33","PL","01");
INSERT INTO voucher_id VALUES("34","PL","01");
INSERT INTO voucher_id VALUES("35","PL","01");
INSERT INTO voucher_id VALUES("36","PL","01");
INSERT INTO voucher_id VALUES("37","PL","01");
INSERT INTO voucher_id VALUES("38","PL","01");
INSERT INTO voucher_id VALUES("39","PL","01");
INSERT INTO voucher_id VALUES("40","PL","01");
INSERT INTO voucher_id VALUES("41","PL","01");
INSERT INTO voucher_id VALUES("42","PL","01");
INSERT INTO voucher_id VALUES("43","PL","01");
INSERT INTO voucher_id VALUES("135","SL","01");
INSERT INTO voucher_id VALUES("136","SL","01");
INSERT INTO voucher_id VALUES("137","SL","01");
INSERT INTO voucher_id VALUES("138","SL","01");
INSERT INTO voucher_id VALUES("139","SL","01");
INSERT INTO voucher_id VALUES("140","SL","01");
INSERT INTO voucher_id VALUES("141","SL","01");
INSERT INTO voucher_id VALUES("142","SL","01");
INSERT INTO voucher_id VALUES("143","SL","01");
INSERT INTO voucher_id VALUES("1","JV","01");
INSERT INTO voucher_id VALUES("2","JV","01");
INSERT INTO voucher_id VALUES("3","JV","01");
INSERT INTO voucher_id VALUES("144","SL","01");
INSERT INTO voucher_id VALUES("145","SL","01");
INSERT INTO voucher_id VALUES("5","RT","01");
INSERT INTO voucher_id VALUES("146","SL","01");
INSERT INTO voucher_id VALUES("147","SL","01");
INSERT INTO voucher_id VALUES("148","SL","01");
INSERT INTO voucher_id VALUES("149","SL","01");
INSERT INTO voucher_id VALUES("150","SL","01");
INSERT INTO voucher_id VALUES("151","SL","01");
INSERT INTO voucher_id VALUES("152","SL","01");
INSERT INTO voucher_id VALUES("153","SL","01");
INSERT INTO voucher_id VALUES("154","SL","01");
INSERT INTO voucher_id VALUES("155","SL","01");
INSERT INTO voucher_id VALUES("156","SL","01");
INSERT INTO voucher_id VALUES("157","SL","01");
INSERT INTO voucher_id VALUES("158","SL","01");
INSERT INTO voucher_id VALUES("159","SL","01");
INSERT INTO voucher_id VALUES("160","SL","01");
INSERT INTO voucher_id VALUES("161","SL","01");
INSERT INTO voucher_id VALUES("162","SL","01");
INSERT INTO voucher_id VALUES("163","SL","01");
INSERT INTO voucher_id VALUES("164","SL","01");
INSERT INTO voucher_id VALUES("165","SL","01");
INSERT INTO voucher_id VALUES("166","SL","01");
INSERT INTO voucher_id VALUES("167","SL","01");
INSERT INTO voucher_id VALUES("168","SL","01");
INSERT INTO voucher_id VALUES("169","SL","01");
INSERT INTO voucher_id VALUES("170","SL","01");
INSERT INTO voucher_id VALUES("171","SL","01");
INSERT INTO voucher_id VALUES("172","SL","01");
INSERT INTO voucher_id VALUES("173","SL","01");
INSERT INTO voucher_id VALUES("174","SL","01");
INSERT INTO voucher_id VALUES("175","SL","01");
INSERT INTO voucher_id VALUES("176","SL","01");
INSERT INTO voucher_id VALUES("177","SL","01");
INSERT INTO voucher_id VALUES("178","SL","01");
INSERT INTO voucher_id VALUES("179","SL","01");
INSERT INTO voucher_id VALUES("180","SL","01");
INSERT INTO voucher_id VALUES("181","SL","01");
INSERT INTO voucher_id VALUES("182","SL","01");
INSERT INTO voucher_id VALUES("183","SL","01");
INSERT INTO voucher_id VALUES("184","SL","01");
INSERT INTO voucher_id VALUES("185","SL","01");
INSERT INTO voucher_id VALUES("186","SL","01");
INSERT INTO voucher_id VALUES("187","SL","01");
INSERT INTO voucher_id VALUES("188","SL","01");
INSERT INTO voucher_id VALUES("189","SL","01");
INSERT INTO voucher_id VALUES("190","SL","01");
INSERT INTO voucher_id VALUES("191","SL","01");
INSERT INTO voucher_id VALUES("192","SL","01");
INSERT INTO voucher_id VALUES("193","SL","01");
INSERT INTO voucher_id VALUES("194","SL","01");
INSERT INTO voucher_id VALUES("195","SL","01");
INSERT INTO voucher_id VALUES("196","SL","01");
INSERT INTO voucher_id VALUES("197","SL","01");
INSERT INTO voucher_id VALUES("198","SL","01");
INSERT INTO voucher_id VALUES("199","SL","01");
INSERT INTO voucher_id VALUES("200","SL","01");
INSERT INTO voucher_id VALUES("201","SL","01");
INSERT INTO voucher_id VALUES("202","SL","01");
INSERT INTO voucher_id VALUES("203","SL","01");
INSERT INTO voucher_id VALUES("204","SL","01");
INSERT INTO voucher_id VALUES("205","SL","01");
INSERT INTO voucher_id VALUES("206","SL","01");
INSERT INTO voucher_id VALUES("207","SL","01");
INSERT INTO voucher_id VALUES("208","SL","01");
INSERT INTO voucher_id VALUES("209","SL","01");
INSERT INTO voucher_id VALUES("210","SL","01");
INSERT INTO voucher_id VALUES("211","SL","01");
INSERT INTO voucher_id VALUES("212","SL","01");
INSERT INTO voucher_id VALUES("213","SL","01");
INSERT INTO voucher_id VALUES("214","SL","01");
INSERT INTO voucher_id VALUES("215","SL","01");
INSERT INTO voucher_id VALUES("216","SL","01");
INSERT INTO voucher_id VALUES("6","RT","01");
INSERT INTO voucher_id VALUES("7","RT","01");
INSERT INTO voucher_id VALUES("217","SL","01");
INSERT INTO voucher_id VALUES("8","RT","01");
INSERT INTO voucher_id VALUES("218","SL","01");
INSERT INTO voucher_id VALUES("219","SL","01");
INSERT INTO voucher_id VALUES("9","RT","01");
INSERT INTO voucher_id VALUES("220","SL","01");
INSERT INTO voucher_id VALUES("221","SL","01");
INSERT INTO voucher_id VALUES("222","SL","01");
INSERT INTO voucher_id VALUES("223","SL","01");
INSERT INTO voucher_id VALUES("10","RT","01");
INSERT INTO voucher_id VALUES("11","RT","01");
INSERT INTO voucher_id VALUES("12","RT","01");
INSERT INTO voucher_id VALUES("224","SL","01");
INSERT INTO voucher_id VALUES("225","SL","01");
INSERT INTO voucher_id VALUES("226","SL","01");
INSERT INTO voucher_id VALUES("13","RT","01");
INSERT INTO voucher_id VALUES("14","RT","01");
INSERT INTO voucher_id VALUES("227","SL","01");
INSERT INTO voucher_id VALUES("228","SL","01");
INSERT INTO voucher_id VALUES("15","RT","01");
INSERT INTO voucher_id VALUES("229","SL","01");
INSERT INTO voucher_id VALUES("230","SL","01");
INSERT INTO voucher_id VALUES("16","RT","01");
INSERT INTO voucher_id VALUES("231","SL","01");
INSERT INTO voucher_id VALUES("232","SL","01");
INSERT INTO voucher_id VALUES("17","RT","01");
INSERT INTO voucher_id VALUES("18","RT","01");
INSERT INTO voucher_id VALUES("233","SL","01");
INSERT INTO voucher_id VALUES("234","SL","01");
INSERT INTO voucher_id VALUES("19","RT","01");
INSERT INTO voucher_id VALUES("235","SL","01");
INSERT INTO voucher_id VALUES("236","SL","01");
INSERT INTO voucher_id VALUES("237","SL","01");
INSERT INTO voucher_id VALUES("20","RT","01");
INSERT INTO voucher_id VALUES("238","SL","01");
INSERT INTO voucher_id VALUES("21","RT","01");
INSERT INTO voucher_id VALUES("239","SL","01");
INSERT INTO voucher_id VALUES("44","PL","01");
INSERT INTO voucher_id VALUES("22","RT","01");
INSERT INTO voucher_id VALUES("240","SL","01");
INSERT INTO voucher_id VALUES("45","PL","01");
INSERT INTO voucher_id VALUES("46","PL","01");
INSERT INTO voucher_id VALUES("47","PL","01");
INSERT INTO voucher_id VALUES("48","PL","01");
INSERT INTO voucher_id VALUES("49","PL","01");
INSERT INTO voucher_id VALUES("50","PL","01");
INSERT INTO voucher_id VALUES("51","PL","01");
INSERT INTO voucher_id VALUES("52","PL","01");
INSERT INTO voucher_id VALUES("53","PL","01");
INSERT INTO voucher_id VALUES("54","PL","01");
INSERT INTO voucher_id VALUES("55","PL","01");
INSERT INTO voucher_id VALUES("56","PL","01");
INSERT INTO voucher_id VALUES("57","PL","01");
INSERT INTO voucher_id VALUES("58","PL","01");
INSERT INTO voucher_id VALUES("59","PL","01");
INSERT INTO voucher_id VALUES("60","PL","01");
INSERT INTO voucher_id VALUES("61","PL","01");
INSERT INTO voucher_id VALUES("62","PL","01");
INSERT INTO voucher_id VALUES("63","PL","01");
INSERT INTO voucher_id VALUES("64","PL","01");
INSERT INTO voucher_id VALUES("65","PL","01");
INSERT INTO voucher_id VALUES("241","SL","01");
INSERT INTO voucher_id VALUES("242","SL","01");
INSERT INTO voucher_id VALUES("243","SL","01");
INSERT INTO voucher_id VALUES("244","SL","01");
INSERT INTO voucher_id VALUES("245","SL","01");
INSERT INTO voucher_id VALUES("246","SL","01");
INSERT INTO voucher_id VALUES("247","SL","01");
INSERT INTO voucher_id VALUES("248","SL","01");
INSERT INTO voucher_id VALUES("249","SL","01");
INSERT INTO voucher_id VALUES("250","SL","01");
INSERT INTO voucher_id VALUES("251","SL","01");
INSERT INTO voucher_id VALUES("252","SL","01");
INSERT INTO voucher_id VALUES("253","SL","01");
INSERT INTO voucher_id VALUES("254","SL","01");
INSERT INTO voucher_id VALUES("255","SL","01");
INSERT INTO voucher_id VALUES("256","SL","01");
INSERT INTO voucher_id VALUES("257","SL","01");
INSERT INTO voucher_id VALUES("6","CP","01");
INSERT INTO voucher_id VALUES("258","SL","01");
INSERT INTO voucher_id VALUES("259","SL","01");
INSERT INTO voucher_id VALUES("66","PL","01");
INSERT INTO voucher_id VALUES("260","SL","01");
INSERT INTO voucher_id VALUES("261","SL","01");
INSERT INTO voucher_id VALUES("262","SL","01");
INSERT INTO voucher_id VALUES("263","SL","01");
INSERT INTO voucher_id VALUES("264","SL","01");
INSERT INTO voucher_id VALUES("265","SL","01");
INSERT INTO voucher_id VALUES("266","SL","01");
INSERT INTO voucher_id VALUES("267","SL","01");
INSERT INTO voucher_id VALUES("23","RT","01");
INSERT INTO voucher_id VALUES("268","SL","01");
INSERT INTO voucher_id VALUES("24","RT","01");
INSERT INTO voucher_id VALUES("25","RT","01");
INSERT INTO voucher_id VALUES("269","SL","01");
INSERT INTO voucher_id VALUES("270","SL","01");
INSERT INTO voucher_id VALUES("271","SL","01");
INSERT INTO voucher_id VALUES("26","RT","01");
INSERT INTO voucher_id VALUES("272","SL","01");
INSERT INTO voucher_id VALUES("27","RT","01");
INSERT INTO voucher_id VALUES("273","SL","01");
INSERT INTO voucher_id VALUES("274","SL","01");
INSERT INTO voucher_id VALUES("28","RT","01");
INSERT INTO voucher_id VALUES("275","SL","01");
INSERT INTO voucher_id VALUES("276","SL","01");
INSERT INTO voucher_id VALUES("29","RT","01");
INSERT INTO voucher_id VALUES("277","SL","01");
INSERT INTO voucher_id VALUES("278","SL","01");
INSERT INTO voucher_id VALUES("279","SL","01");
INSERT INTO voucher_id VALUES("280","SL","01");
INSERT INTO voucher_id VALUES("281","SL","01");
INSERT INTO voucher_id VALUES("282","SL","01");
INSERT INTO voucher_id VALUES("283","SL","01");
INSERT INTO voucher_id VALUES("284","SL","01");
INSERT INTO voucher_id VALUES("285","SL","01");
INSERT INTO voucher_id VALUES("286","SL","01");
INSERT INTO voucher_id VALUES("287","SL","01");
INSERT INTO voucher_id VALUES("288","SL","01");
INSERT INTO voucher_id VALUES("289","SL","01");
INSERT INTO voucher_id VALUES("290","SL","01");
INSERT INTO voucher_id VALUES("67","PL","01");
INSERT INTO voucher_id VALUES("68","PL","01");
INSERT INTO voucher_id VALUES("30","RT","01");
INSERT INTO voucher_id VALUES("291","SL","01");
INSERT INTO voucher_id VALUES("292","SL","01");
INSERT INTO voucher_id VALUES("293","SL","01");
INSERT INTO voucher_id VALUES("294","SL","01");
INSERT INTO voucher_id VALUES("295","SL","01");
INSERT INTO voucher_id VALUES("296","SL","01");
INSERT INTO voucher_id VALUES("297","SL","01");
INSERT INTO voucher_id VALUES("298","SL","01");
INSERT INTO voucher_id VALUES("299","SL","01");
INSERT INTO voucher_id VALUES("300","SL","01");
INSERT INTO voucher_id VALUES("301","SL","01");
INSERT INTO voucher_id VALUES("302","SL","01");
INSERT INTO voucher_id VALUES("303","SL","01");
INSERT INTO voucher_id VALUES("304","SL","01");
INSERT INTO voucher_id VALUES("69","PL","01");
INSERT INTO voucher_id VALUES("70","PL","01");
INSERT INTO voucher_id VALUES("305","SL","01");
INSERT INTO voucher_id VALUES("306","SL","01");
INSERT INTO voucher_id VALUES("307","SL","01");
INSERT INTO voucher_id VALUES("308","SL","01");
INSERT INTO voucher_id VALUES("309","SL","01");
INSERT INTO voucher_id VALUES("310","SL","01");
INSERT INTO voucher_id VALUES("311","SL","01");
INSERT INTO voucher_id VALUES("1","CR","01");
INSERT INTO voucher_id VALUES("4","JV","01");
INSERT INTO voucher_id VALUES("2","CR","01");
INSERT INTO voucher_id VALUES("3","CR","01");
INSERT INTO voucher_id VALUES("4","CR","01");
INSERT INTO voucher_id VALUES("5","CR","01");
INSERT INTO voucher_id VALUES("6","CR","01");
INSERT INTO voucher_id VALUES("312","SL","01");
INSERT INTO voucher_id VALUES("313","SL","01");
INSERT INTO voucher_id VALUES("314","SL","01");
INSERT INTO voucher_id VALUES("315","SL","01");
INSERT INTO voucher_id VALUES("316","SL","01");
INSERT INTO voucher_id VALUES("317","SL","01");
INSERT INTO voucher_id VALUES("318","SL","01");
INSERT INTO voucher_id VALUES("319","SL","01");
INSERT INTO voucher_id VALUES("320","SL","01");
INSERT INTO voucher_id VALUES("321","SL","01");
INSERT INTO voucher_id VALUES("322","SL","01");
INSERT INTO voucher_id VALUES("323","SL","01");
INSERT INTO voucher_id VALUES("324","SL","01");
INSERT INTO voucher_id VALUES("325","SL","01");
INSERT INTO voucher_id VALUES("326","SL","01");
INSERT INTO voucher_id VALUES("327","SL","01");
INSERT INTO voucher_id VALUES("328","SL","01");
INSERT INTO voucher_id VALUES("329","SL","01");
INSERT INTO voucher_id VALUES("330","SL","01");
INSERT INTO voucher_id VALUES("331","SL","01");
INSERT INTO voucher_id VALUES("332","SL","01");
INSERT INTO voucher_id VALUES("333","SL","01");
INSERT INTO voucher_id VALUES("334","SL","01");
INSERT INTO voucher_id VALUES("335","SL","01");
INSERT INTO voucher_id VALUES("336","SL","01");
INSERT INTO voucher_id VALUES("337","SL","01");
INSERT INTO voucher_id VALUES("338","SL","01");
INSERT INTO voucher_id VALUES("339","SL","01");
INSERT INTO voucher_id VALUES("340","SL","01");
INSERT INTO voucher_id VALUES("341","SL","01");
INSERT INTO voucher_id VALUES("342","SL","01");
INSERT INTO voucher_id VALUES("343","SL","01");
INSERT INTO voucher_id VALUES("344","SL","01");
INSERT INTO voucher_id VALUES("345","SL","01");
INSERT INTO voucher_id VALUES("346","SL","01");
INSERT INTO voucher_id VALUES("347","SL","01");
INSERT INTO voucher_id VALUES("348","SL","01");
INSERT INTO voucher_id VALUES("349","SL","01");
INSERT INTO voucher_id VALUES("350","SL","01");
INSERT INTO voucher_id VALUES("351","SL","01");
INSERT INTO voucher_id VALUES("352","SL","01");
INSERT INTO voucher_id VALUES("353","SL","01");
INSERT INTO voucher_id VALUES("354","SL","01");
INSERT INTO voucher_id VALUES("355","SL","01");
INSERT INTO voucher_id VALUES("356","SL","01");
INSERT INTO voucher_id VALUES("357","SL","01");
INSERT INTO voucher_id VALUES("358","SL","01");
INSERT INTO voucher_id VALUES("359","SL","01");
INSERT INTO voucher_id VALUES("71","PL","01");
INSERT INTO voucher_id VALUES("72","PL","01");
INSERT INTO voucher_id VALUES("73","PL","01");
INSERT INTO voucher_id VALUES("74","PL","01");
INSERT INTO voucher_id VALUES("75","PL","01");
INSERT INTO voucher_id VALUES("76","PL","01");
INSERT INTO voucher_id VALUES("77","PL","01");
INSERT INTO voucher_id VALUES("78","PL","01");
INSERT INTO voucher_id VALUES("8","CP","01");
INSERT INTO voucher_id VALUES("9","CP","01");
INSERT INTO voucher_id VALUES("10","CP","01");
INSERT INTO voucher_id VALUES("11","CP","01");
INSERT INTO voucher_id VALUES("12","CP","01");
INSERT INTO voucher_id VALUES("13","CP","01");
INSERT INTO voucher_id VALUES("79","PL","01");
INSERT INTO voucher_id VALUES("80","PL","01");
INSERT INTO voucher_id VALUES("81","PL","01");
INSERT INTO voucher_id VALUES("14","CP","01");
INSERT INTO voucher_id VALUES("360","SL","01");
INSERT INTO voucher_id VALUES("361","SL","01");
INSERT INTO voucher_id VALUES("362","SL","01");
INSERT INTO voucher_id VALUES("31","RT","01");
INSERT INTO voucher_id VALUES("363","SL","01");
INSERT INTO voucher_id VALUES("364","SL","01");
INSERT INTO voucher_id VALUES("365","SL","01");
INSERT INTO voucher_id VALUES("366","SL","01");
INSERT INTO voucher_id VALUES("367","SL","01");
INSERT INTO voucher_id VALUES("368","SL","01");
INSERT INTO voucher_id VALUES("82","PL","01");
INSERT INTO voucher_id VALUES("83","PL","01");
INSERT INTO voucher_id VALUES("15","CP","01");
INSERT INTO voucher_id VALUES("1","PR","01");
INSERT INTO voucher_id VALUES("369","SL","01");
INSERT INTO voucher_id VALUES("84","PL","01");
INSERT INTO voucher_id VALUES("7","CR","01");
INSERT INTO voucher_id VALUES("370","SL","01");
INSERT INTO voucher_id VALUES("16","CP","01");
INSERT INTO voucher_id VALUES("85","PL","01");
INSERT INTO voucher_id VALUES("371","SL","01");
INSERT INTO voucher_id VALUES("372","SL","01");
INSERT INTO voucher_id VALUES("373","SL","01");
INSERT INTO voucher_id VALUES("374","SL","01");
INSERT INTO voucher_id VALUES("375","SL","01");
INSERT INTO voucher_id VALUES("376","SL","01");
INSERT INTO voucher_id VALUES("377","SL","01");
INSERT INTO voucher_id VALUES("378","SL","01");
INSERT INTO voucher_id VALUES("379","SL","01");
INSERT INTO voucher_id VALUES("380","SL","01");
INSERT INTO voucher_id VALUES("381","SL","01");
INSERT INTO voucher_id VALUES("382","SL","01");
INSERT INTO voucher_id VALUES("383","SL","01");
INSERT INTO voucher_id VALUES("384","SL","01");
INSERT INTO voucher_id VALUES("385","SL","01");
INSERT INTO voucher_id VALUES("386","SL","01");
INSERT INTO voucher_id VALUES("387","SL","01");
INSERT INTO voucher_id VALUES("388","SL","01");
INSERT INTO voucher_id VALUES("389","SL","01");
INSERT INTO voucher_id VALUES("390","SL","01");
INSERT INTO voucher_id VALUES("391","SL","01");
INSERT INTO voucher_id VALUES("392","SL","01");
INSERT INTO voucher_id VALUES("393","SL","01");
INSERT INTO voucher_id VALUES("394","SL","01");
INSERT INTO voucher_id VALUES("395","SL","01");
INSERT INTO voucher_id VALUES("396","SL","01");
INSERT INTO voucher_id VALUES("397","SL","01");
INSERT INTO voucher_id VALUES("398","SL","01");
INSERT INTO voucher_id VALUES("399","SL","01");
INSERT INTO voucher_id VALUES("400","SL","01");
INSERT INTO voucher_id VALUES("401","SL","01");
INSERT INTO voucher_id VALUES("402","SL","01");
INSERT INTO voucher_id VALUES("403","SL","01");
INSERT INTO voucher_id VALUES("404","SL","01");
INSERT INTO voucher_id VALUES("405","SL","01");
INSERT INTO voucher_id VALUES("32","RT","01");
INSERT INTO voucher_id VALUES("33","RT","01");
INSERT INTO voucher_id VALUES("34","RT","01");
INSERT INTO voucher_id VALUES("406","SL","01");
INSERT INTO voucher_id VALUES("407","SL","01");
INSERT INTO voucher_id VALUES("408","SL","01");
INSERT INTO voucher_id VALUES("409","SL","01");
INSERT INTO voucher_id VALUES("410","SL","01");
INSERT INTO voucher_id VALUES("411","SL","01");
INSERT INTO voucher_id VALUES("412","SL","01");
INSERT INTO voucher_id VALUES("413","SL","01");
INSERT INTO voucher_id VALUES("86","PL","01");
INSERT INTO voucher_id VALUES("87","PL","01");
INSERT INTO voucher_id VALUES("88","PL","01");
INSERT INTO voucher_id VALUES("89","PL","01");
INSERT INTO voucher_id VALUES("414","SL","01");
INSERT INTO voucher_id VALUES("415","SL","01");
INSERT INTO voucher_id VALUES("416","SL","01");
INSERT INTO voucher_id VALUES("417","SL","01");
INSERT INTO voucher_id VALUES("418","SL","01");
INSERT INTO voucher_id VALUES("419","SL","01");
INSERT INTO voucher_id VALUES("420","SL","01");
INSERT INTO voucher_id VALUES("421","SL","01");
INSERT INTO voucher_id VALUES("422","SL","01");
INSERT INTO voucher_id VALUES("423","SL","01");
INSERT INTO voucher_id VALUES("424","SL","01");
INSERT INTO voucher_id VALUES("425","SL","01");
INSERT INTO voucher_id VALUES("426","SL","01");
INSERT INTO voucher_id VALUES("427","SL","01");
INSERT INTO voucher_id VALUES("428","SL","01");
INSERT INTO voucher_id VALUES("429","SL","01");
INSERT INTO voucher_id VALUES("430","SL","01");
INSERT INTO voucher_id VALUES("431","SL","01");
INSERT INTO voucher_id VALUES("1","SL","02");
INSERT INTO voucher_id VALUES("90","PL","01");
INSERT INTO voucher_id VALUES("91","PL","01");
INSERT INTO voucher_id VALUES("432","SL","01");
INSERT INTO voucher_id VALUES("2","SL","02");
INSERT INTO voucher_id VALUES("3","SL","02");
INSERT INTO voucher_id VALUES("4","SL","02");
INSERT INTO voucher_id VALUES("5","SL","02");
INSERT INTO voucher_id VALUES("6","SL","02");
INSERT INTO voucher_id VALUES("7","SL","02");
INSERT INTO voucher_id VALUES("8","SL","02");
INSERT INTO voucher_id VALUES("1","RT","02");
INSERT INTO voucher_id VALUES("9","SL","02");
INSERT INTO voucher_id VALUES("10","SL","02");
INSERT INTO voucher_id VALUES("11","SL","02");
INSERT INTO voucher_id VALUES("12","SL","02");
INSERT INTO voucher_id VALUES("13","SL","02");
INSERT INTO voucher_id VALUES("14","SL","02");
INSERT INTO voucher_id VALUES("433","SL","01");
INSERT INTO voucher_id VALUES("434","SL","01");
INSERT INTO voucher_id VALUES("435","SL","01");
INSERT INTO voucher_id VALUES("436","SL","01");
INSERT INTO voucher_id VALUES("437","SL","01");
INSERT INTO voucher_id VALUES("438","SL","01");
INSERT INTO voucher_id VALUES("439","SL","01");
INSERT INTO voucher_id VALUES("440","SL","01");
INSERT INTO voucher_id VALUES("92","PL","01");
INSERT INTO voucher_id VALUES("93","PL","01");
INSERT INTO voucher_id VALUES("2","PR","01");
INSERT INTO voucher_id VALUES("15","SL","02");
INSERT INTO voucher_id VALUES("16","SL","02");
INSERT INTO voucher_id VALUES("17","SL","02");
INSERT INTO voucher_id VALUES("18","SL","02");
INSERT INTO voucher_id VALUES("19","SL","02");
INSERT INTO voucher_id VALUES("441","SL","01");
INSERT INTO voucher_id VALUES("442","SL","01");
INSERT INTO voucher_id VALUES("35","RT","01");
INSERT INTO voucher_id VALUES("443","SL","01");
INSERT INTO voucher_id VALUES("444","SL","01");
INSERT INTO voucher_id VALUES("445","SL","01");
INSERT INTO voucher_id VALUES("446","SL","01");
INSERT INTO voucher_id VALUES("1","BR","01");
INSERT INTO voucher_id VALUES("447","SL","01");
INSERT INTO voucher_id VALUES("448","SL","01");
INSERT INTO voucher_id VALUES("94","PL","01");
INSERT INTO voucher_id VALUES("95","PL","01");
INSERT INTO voucher_id VALUES("449","SL","01");
INSERT INTO voucher_id VALUES("450","SL","01");
INSERT INTO voucher_id VALUES("451","SL","01");
INSERT INTO voucher_id VALUES("452","SL","01");
INSERT INTO voucher_id VALUES("453","SL","01");
INSERT INTO voucher_id VALUES("454","SL","01");
INSERT INTO voucher_id VALUES("455","SL","01");
INSERT INTO voucher_id VALUES("456","SL","01");
INSERT INTO voucher_id VALUES("457","SL","01");
INSERT INTO voucher_id VALUES("458","SL","01");
INSERT INTO voucher_id VALUES("459","SL","01");
INSERT INTO voucher_id VALUES("460","SL","01");
INSERT INTO voucher_id VALUES("20","SL","02");
INSERT INTO voucher_id VALUES("21","SL","02");
INSERT INTO voucher_id VALUES("22","SL","02");
INSERT INTO voucher_id VALUES("23","SL","02");
INSERT INTO voucher_id VALUES("24","SL","02");
INSERT INTO voucher_id VALUES("25","SL","02");
INSERT INTO voucher_id VALUES("26","SL","02");
INSERT INTO voucher_id VALUES("461","SL","01");
INSERT INTO voucher_id VALUES("462","SL","01");
INSERT INTO voucher_id VALUES("463","SL","01");
INSERT INTO voucher_id VALUES("464","SL","01");
INSERT INTO voucher_id VALUES("465","SL","01");
INSERT INTO voucher_id VALUES("466","SL","01");
INSERT INTO voucher_id VALUES("467","SL","01");
INSERT INTO voucher_id VALUES("468","SL","01");
INSERT INTO voucher_id VALUES("469","SL","01");
INSERT INTO voucher_id VALUES("470","SL","01");
INSERT INTO voucher_id VALUES("471","SL","01");
INSERT INTO voucher_id VALUES("472","SL","01");
INSERT INTO voucher_id VALUES("473","SL","01");
INSERT INTO voucher_id VALUES("474","SL","01");
INSERT INTO voucher_id VALUES("475","SL","01");
INSERT INTO voucher_id VALUES("476","SL","01");
INSERT INTO voucher_id VALUES("477","SL","01");
INSERT INTO voucher_id VALUES("478","SL","01");
INSERT INTO voucher_id VALUES("27","SL","02");
INSERT INTO voucher_id VALUES("28","SL","02");
INSERT INTO voucher_id VALUES("29","SL","02");
INSERT INTO voucher_id VALUES("30","SL","02");
INSERT INTO voucher_id VALUES("31","SL","02");
INSERT INTO voucher_id VALUES("479","SL","01");
INSERT INTO voucher_id VALUES("480","SL","01");
INSERT INTO voucher_id VALUES("481","SL","01");
INSERT INTO voucher_id VALUES("482","SL","01");
INSERT INTO voucher_id VALUES("483","SL","01");
INSERT INTO voucher_id VALUES("484","SL","01");
INSERT INTO voucher_id VALUES("485","SL","01");
INSERT INTO voucher_id VALUES("486","SL","01");
INSERT INTO voucher_id VALUES("487","SL","01");
INSERT INTO voucher_id VALUES("488","SL","01");
INSERT INTO voucher_id VALUES("489","SL","01");
INSERT INTO voucher_id VALUES("490","SL","01");
INSERT INTO voucher_id VALUES("491","SL","01");
INSERT INTO voucher_id VALUES("492","SL","01");
INSERT INTO voucher_id VALUES("493","SL","01");
INSERT INTO voucher_id VALUES("494","SL","01");
INSERT INTO voucher_id VALUES("495","SL","01");
INSERT INTO voucher_id VALUES("496","SL","01");
INSERT INTO voucher_id VALUES("497","SL","01");
INSERT INTO voucher_id VALUES("498","SL","01");
INSERT INTO voucher_id VALUES("32","SL","02");
INSERT INTO voucher_id VALUES("8","CR","01");
INSERT INTO voucher_id VALUES("17","CP","01");
INSERT INTO voucher_id VALUES("2","BR","01");
INSERT INTO voucher_id VALUES("1","BP","01");
INSERT INTO voucher_id VALUES("2","BP","01");
INSERT INTO voucher_id VALUES("3","BP","01");
INSERT INTO voucher_id VALUES("4","BP","01");
INSERT INTO voucher_id VALUES("499","SL","01");
INSERT INTO voucher_id VALUES("500","SL","01");
INSERT INTO voucher_id VALUES("501","SL","01");
INSERT INTO voucher_id VALUES("502","SL","01");
INSERT INTO voucher_id VALUES("503","SL","01");
INSERT INTO voucher_id VALUES("504","SL","01");
INSERT INTO voucher_id VALUES("505","SL","01");
INSERT INTO voucher_id VALUES("506","SL","01");
INSERT INTO voucher_id VALUES("507","SL","01");
INSERT INTO voucher_id VALUES("508","SL","01");
INSERT INTO voucher_id VALUES("509","SL","01");
INSERT INTO voucher_id VALUES("510","SL","01");
INSERT INTO voucher_id VALUES("511","SL","01");
INSERT INTO voucher_id VALUES("512","SL","01");
INSERT INTO voucher_id VALUES("513","SL","01");
INSERT INTO voucher_id VALUES("514","SL","01");
INSERT INTO voucher_id VALUES("515","SL","01");
INSERT INTO voucher_id VALUES("516","SL","01");
INSERT INTO voucher_id VALUES("517","SL","01");
INSERT INTO voucher_id VALUES("518","SL","01");
INSERT INTO voucher_id VALUES("519","SL","01");
INSERT INTO voucher_id VALUES("520","SL","01");
INSERT INTO voucher_id VALUES("33","SL","02");
INSERT INTO voucher_id VALUES("34","SL","02");
INSERT INTO voucher_id VALUES("35","SL","02");
INSERT INTO voucher_id VALUES("18","CP","01");
INSERT INTO voucher_id VALUES("96","PL","01");
INSERT INTO voucher_id VALUES("97","PL","01");
INSERT INTO voucher_id VALUES("98","PL","01");
INSERT INTO voucher_id VALUES("99","PL","01");
INSERT INTO voucher_id VALUES("100","PL","01");
INSERT INTO voucher_id VALUES("101","PL","01");
INSERT INTO voucher_id VALUES("102","PL","01");
INSERT INTO voucher_id VALUES("103","PL","01");
INSERT INTO voucher_id VALUES("104","PL","01");
INSERT INTO voucher_id VALUES("105","PL","01");
INSERT INTO voucher_id VALUES("106","PL","01");
INSERT INTO voucher_id VALUES("107","PL","01");
INSERT INTO voucher_id VALUES("108","PL","01");
INSERT INTO voucher_id VALUES("521","SL","01");
INSERT INTO voucher_id VALUES("522","SL","01");
INSERT INTO voucher_id VALUES("523","SL","01");
INSERT INTO voucher_id VALUES("524","SL","01");
INSERT INTO voucher_id VALUES("525","SL","01");
INSERT INTO voucher_id VALUES("109","PL","01");
INSERT INTO voucher_id VALUES("110","PL","01");
INSERT INTO voucher_id VALUES("111","PL","01");
INSERT INTO voucher_id VALUES("112","PL","01");
INSERT INTO voucher_id VALUES("113","PL","01");
INSERT INTO voucher_id VALUES("526","SL","01");
INSERT INTO voucher_id VALUES("527","SL","01");
INSERT INTO voucher_id VALUES("114","PL","01");
INSERT INTO voucher_id VALUES("115","PL","01");
INSERT INTO voucher_id VALUES("116","PL","01");
INSERT INTO voucher_id VALUES("528","SL","01");
INSERT INTO voucher_id VALUES("529","SL","01");
INSERT INTO voucher_id VALUES("117","PL","01");
INSERT INTO voucher_id VALUES("118","PL","01");
INSERT INTO voucher_id VALUES("119","PL","01");
INSERT INTO voucher_id VALUES("120","PL","01");
INSERT INTO voucher_id VALUES("121","PL","01");
INSERT INTO voucher_id VALUES("530","SL","01");
INSERT INTO voucher_id VALUES("531","SL","01");
INSERT INTO voucher_id VALUES("532","SL","01");
INSERT INTO voucher_id VALUES("36","RT","01");
INSERT INTO voucher_id VALUES("533","SL","01");
INSERT INTO voucher_id VALUES("534","SL","01");
INSERT INTO voucher_id VALUES("535","SL","01");
INSERT INTO voucher_id VALUES("536","SL","01");
INSERT INTO voucher_id VALUES("537","SL","01");
INSERT INTO voucher_id VALUES("538","SL","01");
INSERT INTO voucher_id VALUES("539","SL","01");
INSERT INTO voucher_id VALUES("36","SL","02");
INSERT INTO voucher_id VALUES("37","SL","02");
INSERT INTO voucher_id VALUES("38","SL","02");
INSERT INTO voucher_id VALUES("39","SL","02");
INSERT INTO voucher_id VALUES("19","CP","01");
INSERT INTO voucher_id VALUES("20","CP","01");
INSERT INTO voucher_id VALUES("3","BR","01");
INSERT INTO voucher_id VALUES("9","CR","01");
INSERT INTO voucher_id VALUES("10","CR","01");
INSERT INTO voucher_id VALUES("11","CR","01");
INSERT INTO voucher_id VALUES("12","CR","01");
INSERT INTO voucher_id VALUES("13","CR","01");
INSERT INTO voucher_id VALUES("540","SL","01");
INSERT INTO voucher_id VALUES("122","PL","01");
INSERT INTO voucher_id VALUES("541","SL","01");
INSERT INTO voucher_id VALUES("542","SL","01");
INSERT INTO voucher_id VALUES("543","SL","01");
INSERT INTO voucher_id VALUES("37","RT","01");
INSERT INTO voucher_id VALUES("38","RT","01");
INSERT INTO voucher_id VALUES("39","RT","01");
INSERT INTO voucher_id VALUES("544","SL","01");
INSERT INTO voucher_id VALUES("545","SL","01");
INSERT INTO voucher_id VALUES("546","SL","01");
INSERT INTO voucher_id VALUES("547","SL","01");
INSERT INTO voucher_id VALUES("548","SL","01");
INSERT INTO voucher_id VALUES("549","SL","01");
INSERT INTO voucher_id VALUES("550","SL","01");
INSERT INTO voucher_id VALUES("551","SL","01");
INSERT INTO voucher_id VALUES("552","SL","01");
INSERT INTO voucher_id VALUES("553","SL","01");
INSERT INTO voucher_id VALUES("554","SL","01");
INSERT INTO voucher_id VALUES("555","SL","01");
INSERT INTO voucher_id VALUES("40","RT","01");
INSERT INTO voucher_id VALUES("41","RT","01");
INSERT INTO voucher_id VALUES("556","SL","01");
INSERT INTO voucher_id VALUES("557","SL","01");
INSERT INTO voucher_id VALUES("558","SL","01");
INSERT INTO voucher_id VALUES("559","SL","01");
INSERT INTO voucher_id VALUES("42","RT","01");
INSERT INTO voucher_id VALUES("560","SL","01");
INSERT INTO voucher_id VALUES("561","SL","01");
INSERT INTO voucher_id VALUES("562","SL","01");
INSERT INTO voucher_id VALUES("563","SL","01");
INSERT INTO voucher_id VALUES("43","RT","01");
INSERT INTO voucher_id VALUES("123","PL","01");
INSERT INTO voucher_id VALUES("21","CP","01");
INSERT INTO voucher_id VALUES("564","SL","01");
INSERT INTO voucher_id VALUES("565","SL","01");
INSERT INTO voucher_id VALUES("22","CP","01");
INSERT INTO voucher_id VALUES("566","SL","01");
INSERT INTO voucher_id VALUES("567","SL","01");
INSERT INTO voucher_id VALUES("568","SL","01");
INSERT INTO voucher_id VALUES("569","SL","01");
INSERT INTO voucher_id VALUES("570","SL","01");
INSERT INTO voucher_id VALUES("571","SL","01");
INSERT INTO voucher_id VALUES("572","SL","01");
INSERT INTO voucher_id VALUES("573","SL","01");
INSERT INTO voucher_id VALUES("124","PL","01");
INSERT INTO voucher_id VALUES("574","SL","01");
INSERT INTO voucher_id VALUES("575","SL","01");
INSERT INTO voucher_id VALUES("576","SL","01");
INSERT INTO voucher_id VALUES("577","SL","01");
INSERT INTO voucher_id VALUES("578","SL","01");
INSERT INTO voucher_id VALUES("579","SL","01");
INSERT INTO voucher_id VALUES("580","SL","01");
INSERT INTO voucher_id VALUES("581","SL","01");
INSERT INTO voucher_id VALUES("582","SL","01");
INSERT INTO voucher_id VALUES("583","SL","01");
INSERT INTO voucher_id VALUES("584","SL","01");
INSERT INTO voucher_id VALUES("585","SL","01");
INSERT INTO voucher_id VALUES("586","SL","01");
INSERT INTO voucher_id VALUES("44","RT","01");
INSERT INTO voucher_id VALUES("587","SL","01");
INSERT INTO voucher_id VALUES("588","SL","01");
INSERT INTO voucher_id VALUES("589","SL","01");
INSERT INTO voucher_id VALUES("590","SL","01");
INSERT INTO voucher_id VALUES("591","SL","01");
INSERT INTO voucher_id VALUES("592","SL","01");
INSERT INTO voucher_id VALUES("593","SL","01");
INSERT INTO voucher_id VALUES("45","RT","01");
INSERT INTO voucher_id VALUES("594","SL","01");
INSERT INTO voucher_id VALUES("23","CP","01");
INSERT INTO voucher_id VALUES("595","SL","01");
INSERT INTO voucher_id VALUES("596","SL","01");
INSERT INTO voucher_id VALUES("597","SL","01");
INSERT INTO voucher_id VALUES("598","SL","01");
INSERT INTO voucher_id VALUES("599","SL","01");
INSERT INTO voucher_id VALUES("600","SL","01");
INSERT INTO voucher_id VALUES("601","SL","01");
INSERT INTO voucher_id VALUES("602","SL","01");
INSERT INTO voucher_id VALUES("603","SL","01");
INSERT INTO voucher_id VALUES("604","SL","01");
INSERT INTO voucher_id VALUES("605","SL","01");
INSERT INTO voucher_id VALUES("606","SL","01");
INSERT INTO voucher_id VALUES("607","SL","01");
INSERT INTO voucher_id VALUES("608","SL","01");
INSERT INTO voucher_id VALUES("609","SL","01");
INSERT INTO voucher_id VALUES("610","SL","01");
INSERT INTO voucher_id VALUES("611","SL","01");
INSERT INTO voucher_id VALUES("612","SL","01");
INSERT INTO voucher_id VALUES("613","SL","01");
INSERT INTO voucher_id VALUES("614","SL","01");
INSERT INTO voucher_id VALUES("615","SL","01");
INSERT INTO voucher_id VALUES("616","SL","01");
INSERT INTO voucher_id VALUES("617","SL","01");
INSERT INTO voucher_id VALUES("618","SL","01");
INSERT INTO voucher_id VALUES("619","SL","01");
INSERT INTO voucher_id VALUES("40","SL","02");
INSERT INTO voucher_id VALUES("41","SL","02");
INSERT INTO voucher_id VALUES("1","PL","02");
INSERT INTO voucher_id VALUES("125","PL","01");
INSERT INTO voucher_id VALUES("126","PL","01");
INSERT INTO voucher_id VALUES("24","CP","01");
INSERT INTO voucher_id VALUES("127","PL","01");
INSERT INTO voucher_id VALUES("620","SL","01");
INSERT INTO voucher_id VALUES("621","SL","01");
INSERT INTO voucher_id VALUES("25","CP","01");
INSERT INTO voucher_id VALUES("128","PL","01");
INSERT INTO voucher_id VALUES("129","PL","01");
INSERT INTO voucher_id VALUES("130","PL","01");
INSERT INTO voucher_id VALUES("26","CP","01");
INSERT INTO voucher_id VALUES("27","CP","01");
INSERT INTO voucher_id VALUES("28","CP","01");
INSERT INTO voucher_id VALUES("29","CP","01");
INSERT INTO voucher_id VALUES("30","CP","01");
INSERT INTO voucher_id VALUES("31","CP","01");
INSERT INTO voucher_id VALUES("131","PL","01");
INSERT INTO voucher_id VALUES("2","PL","02");
INSERT INTO voucher_id VALUES("14","CR","01");
INSERT INTO voucher_id VALUES("622","SL","01");
INSERT INTO voucher_id VALUES("623","SL","01");
INSERT INTO voucher_id VALUES("624","SL","01");
INSERT INTO voucher_id VALUES("625","SL","01");
INSERT INTO voucher_id VALUES("626","SL","01");
INSERT INTO voucher_id VALUES("627","SL","01");
INSERT INTO voucher_id VALUES("628","SL","01");
INSERT INTO voucher_id VALUES("629","SL","01");
INSERT INTO voucher_id VALUES("630","SL","01");
INSERT INTO voucher_id VALUES("631","SL","01");
INSERT INTO voucher_id VALUES("632","SL","01");
INSERT INTO voucher_id VALUES("633","SL","01");
INSERT INTO voucher_id VALUES("634","SL","01");
INSERT INTO voucher_id VALUES("635","SL","01");
INSERT INTO voucher_id VALUES("636","SL","01");
INSERT INTO voucher_id VALUES("637","SL","01");
INSERT INTO voucher_id VALUES("638","SL","01");
INSERT INTO voucher_id VALUES("639","SL","01");
INSERT INTO voucher_id VALUES("640","SL","01");
INSERT INTO voucher_id VALUES("641","SL","01");
INSERT INTO voucher_id VALUES("642","SL","01");
INSERT INTO voucher_id VALUES("643","SL","01");
INSERT INTO voucher_id VALUES("46","RT","01");
INSERT INTO voucher_id VALUES("47","RT","01");
INSERT INTO voucher_id VALUES("3","PL","02");
INSERT INTO voucher_id VALUES("4","PL","02");
INSERT INTO voucher_id VALUES("5","PL","02");
INSERT INTO voucher_id VALUES("644","SL","01");
INSERT INTO voucher_id VALUES("645","SL","01");
INSERT INTO voucher_id VALUES("646","SL","01");
INSERT INTO voucher_id VALUES("647","SL","01");
INSERT INTO voucher_id VALUES("648","SL","01");
INSERT INTO voucher_id VALUES("649","SL","01");
INSERT INTO voucher_id VALUES("650","SL","01");
INSERT INTO voucher_id VALUES("651","SL","01");
INSERT INTO voucher_id VALUES("652","SL","01");
INSERT INTO voucher_id VALUES("653","SL","01");
INSERT INTO voucher_id VALUES("654","SL","01");
INSERT INTO voucher_id VALUES("655","SL","01");
INSERT INTO voucher_id VALUES("48","RT","01");
INSERT INTO voucher_id VALUES("656","SL","01");
INSERT INTO voucher_id VALUES("657","SL","01");
INSERT INTO voucher_id VALUES("658","SL","01");
INSERT INTO voucher_id VALUES("659","SL","01");
INSERT INTO voucher_id VALUES("660","SL","01");
INSERT INTO voucher_id VALUES("49","RT","01");
INSERT INTO voucher_id VALUES("661","SL","01");
INSERT INTO voucher_id VALUES("662","SL","01");
INSERT INTO voucher_id VALUES("663","SL","01");
INSERT INTO voucher_id VALUES("664","SL","01");
INSERT INTO voucher_id VALUES("50","RT","01");
INSERT INTO voucher_id VALUES("665","SL","01");
INSERT INTO voucher_id VALUES("666","SL","01");
INSERT INTO voucher_id VALUES("667","SL","01");
INSERT INTO voucher_id VALUES("51","RT","01");
INSERT INTO voucher_id VALUES("668","SL","01");
INSERT INTO voucher_id VALUES("669","SL","01");
INSERT INTO voucher_id VALUES("670","SL","01");
INSERT INTO voucher_id VALUES("671","SL","01");
INSERT INTO voucher_id VALUES("672","SL","01");
INSERT INTO voucher_id VALUES("673","SL","01");
INSERT INTO voucher_id VALUES("674","SL","01");
INSERT INTO voucher_id VALUES("675","SL","01");
INSERT INTO voucher_id VALUES("676","SL","01");
INSERT INTO voucher_id VALUES("677","SL","01");
INSERT INTO voucher_id VALUES("678","SL","01");
INSERT INTO voucher_id VALUES("679","SL","01");
INSERT INTO voucher_id VALUES("680","SL","01");
INSERT INTO voucher_id VALUES("52","RT","01");
INSERT INTO voucher_id VALUES("681","SL","01");
INSERT INTO voucher_id VALUES("682","SL","01");
INSERT INTO voucher_id VALUES("683","SL","01");
INSERT INTO voucher_id VALUES("684","SL","01");
INSERT INTO voucher_id VALUES("685","SL","01");
INSERT INTO voucher_id VALUES("53","RT","01");
INSERT INTO voucher_id VALUES("686","SL","01");
INSERT INTO voucher_id VALUES("687","SL","01");
INSERT INTO voucher_id VALUES("688","SL","01");
INSERT INTO voucher_id VALUES("42","SL","02");
INSERT INTO voucher_id VALUES("43","SL","02");
INSERT INTO voucher_id VALUES("44","SL","02");
INSERT INTO voucher_id VALUES("45","SL","02");
INSERT INTO voucher_id VALUES("46","SL","02");
INSERT INTO voucher_id VALUES("47","SL","02");
INSERT INTO voucher_id VALUES("48","SL","02");
INSERT INTO voucher_id VALUES("49","SL","02");
INSERT INTO voucher_id VALUES("50","SL","02");
INSERT INTO voucher_id VALUES("6","PL","02");
INSERT INTO voucher_id VALUES("1","CP","02");
INSERT INTO voucher_id VALUES("7","PL","02");
INSERT INTO voucher_id VALUES("1","JV","02");
INSERT INTO voucher_id VALUES("2","JV","02");
INSERT INTO voucher_id VALUES("3","JV","02");
INSERT INTO voucher_id VALUES("51","SL","02");
INSERT INTO voucher_id VALUES("52","SL","02");
INSERT INTO voucher_id VALUES("53","SL","02");
INSERT INTO voucher_id VALUES("689","SL","01");
INSERT INTO voucher_id VALUES("8","PL","02");
INSERT INTO voucher_id VALUES("32","CP","01");
INSERT INTO voucher_id VALUES("9","PL","02");
INSERT INTO voucher_id VALUES("10","PL","02");
INSERT INTO voucher_id VALUES("11","PL","02");
INSERT INTO voucher_id VALUES("54","SL","02");
INSERT INTO voucher_id VALUES("55","SL","02");
INSERT INTO voucher_id VALUES("56","SL","02");
INSERT INTO voucher_id VALUES("57","SL","02");
INSERT INTO voucher_id VALUES("58","SL","02");
INSERT INTO voucher_id VALUES("59","SL","02");
INSERT INTO voucher_id VALUES("2","CP","02");
INSERT INTO voucher_id VALUES("5","JV","01");
INSERT INTO voucher_id VALUES("60","SL","02");
INSERT INTO voucher_id VALUES("61","SL","02");
INSERT INTO voucher_id VALUES("3","CP","02");
INSERT INTO voucher_id VALUES("4","CP","02");
INSERT INTO voucher_id VALUES("12","PL","02");
INSERT INTO voucher_id VALUES("13","PL","02");
INSERT INTO voucher_id VALUES("14","PL","02");
INSERT INTO voucher_id VALUES("62","SL","02");
INSERT INTO voucher_id VALUES("63","SL","02");
INSERT INTO voucher_id VALUES("64","SL","02");
INSERT INTO voucher_id VALUES("2","RT","02");
INSERT INTO voucher_id VALUES("3","RT","02");
INSERT INTO voucher_id VALUES("65","SL","02");
INSERT INTO voucher_id VALUES("66","SL","02");
INSERT INTO voucher_id VALUES("67","SL","02");
INSERT INTO voucher_id VALUES("68","SL","02");
INSERT INTO voucher_id VALUES("15","PL","02");
INSERT INTO voucher_id VALUES("16","PL","02");
INSERT INTO voucher_id VALUES("69","SL","02");
INSERT INTO voucher_id VALUES("17","PL","02");
INSERT INTO voucher_id VALUES("18","PL","02");
INSERT INTO voucher_id VALUES("70","SL","02");
INSERT INTO voucher_id VALUES("71","SL","02");
INSERT INTO voucher_id VALUES("4","RT","02");
INSERT INTO voucher_id VALUES("19","PL","02");
INSERT INTO voucher_id VALUES("20","PL","02");
INSERT INTO voucher_id VALUES("21","PL","02");
INSERT INTO voucher_id VALUES("22","PL","02");
INSERT INTO voucher_id VALUES("23","PL","02");
INSERT INTO voucher_id VALUES("72","SL","02");
INSERT INTO voucher_id VALUES("73","SL","02");
INSERT INTO voucher_id VALUES("5","RT","02");
INSERT INTO voucher_id VALUES("74","SL","02");
INSERT INTO voucher_id VALUES("5","CP","02");
INSERT INTO voucher_id VALUES("6","CP","02");
INSERT INTO voucher_id VALUES("7","CP","02");
INSERT INTO voucher_id VALUES("8","CP","02");
INSERT INTO voucher_id VALUES("9","CP","02");
INSERT INTO voucher_id VALUES("10","CP","02");
INSERT INTO voucher_id VALUES("11","CP","02");
INSERT INTO voucher_id VALUES("12","CP","02");
INSERT INTO voucher_id VALUES("75","SL","02");
INSERT INTO voucher_id VALUES("76","SL","02");
INSERT INTO voucher_id VALUES("77","SL","02");
INSERT INTO voucher_id VALUES("78","SL","02");
INSERT INTO voucher_id VALUES("79","SL","02");
INSERT INTO voucher_id VALUES("80","SL","02");
INSERT INTO voucher_id VALUES("6","RT","02");
INSERT INTO voucher_id VALUES("81","SL","02");
INSERT INTO voucher_id VALUES("82","SL","02");
INSERT INTO voucher_id VALUES("4","JV","02");
INSERT INTO voucher_id VALUES("7","RT","02");
INSERT INTO voucher_id VALUES("83","SL","02");
INSERT INTO voucher_id VALUES("84","SL","02");
INSERT INTO voucher_id VALUES("85","SL","02");
INSERT INTO voucher_id VALUES("13","CP","02");
INSERT INTO voucher_id VALUES("8","RT","02");
INSERT INTO voucher_id VALUES("24","PL","02");
INSERT INTO voucher_id VALUES("25","PL","02");
INSERT INTO voucher_id VALUES("26","PL","02");
INSERT INTO voucher_id VALUES("27","PL","02");
INSERT INTO voucher_id VALUES("28","PL","02");
INSERT INTO voucher_id VALUES("86","SL","02");
INSERT INTO voucher_id VALUES("87","SL","02");
INSERT INTO voucher_id VALUES("88","SL","02");
INSERT INTO voucher_id VALUES("89","SL","02");
INSERT INTO voucher_id VALUES("90","SL","02");
INSERT INTO voucher_id VALUES("91","SL","02");
INSERT INTO voucher_id VALUES("9","RT","02");
INSERT INTO voucher_id VALUES("10","RT","02");
INSERT INTO voucher_id VALUES("1","CR","02");
INSERT INTO voucher_id VALUES("1","ST","02");
INSERT INTO voucher_id VALUES("92","SL","02");
INSERT INTO voucher_id VALUES("93","SL","02");
INSERT INTO voucher_id VALUES("11","RT","02");
INSERT INTO voucher_id VALUES("14","CP","02");
INSERT INTO voucher_id VALUES("29","PL","02");
INSERT INTO voucher_id VALUES("30","PL","02");
INSERT INTO voucher_id VALUES("31","PL","02");
INSERT INTO voucher_id VALUES("32","PL","02");
INSERT INTO voucher_id VALUES("12","RT","02");
INSERT INTO voucher_id VALUES("13","RT","02");
INSERT INTO voucher_id VALUES("14","RT","02");
INSERT INTO voucher_id VALUES("94","SL","02");
INSERT INTO voucher_id VALUES("95","SL","02");
INSERT INTO voucher_id VALUES("96","SL","02");
INSERT INTO voucher_id VALUES("97","SL","02");
INSERT INTO voucher_id VALUES("98","SL","02");
INSERT INTO voucher_id VALUES("99","SL","02");
INSERT INTO voucher_id VALUES("100","SL","02");
INSERT INTO voucher_id VALUES("15","CP","02");
INSERT INTO voucher_id VALUES("101","SL","02");
INSERT INTO voucher_id VALUES("16","CP","02");
INSERT INTO voucher_id VALUES("102","SL","02");
INSERT INTO voucher_id VALUES("103","SL","02");
INSERT INTO voucher_id VALUES("104","SL","02");
INSERT INTO voucher_id VALUES("105","SL","02");
INSERT INTO voucher_id VALUES("106","SL","02");
INSERT INTO voucher_id VALUES("107","SL","02");
INSERT INTO voucher_id VALUES("108","SL","02");
INSERT INTO voucher_id VALUES("109","SL","02");
INSERT INTO voucher_id VALUES("110","SL","02");
INSERT INTO voucher_id VALUES("111","SL","02");
INSERT INTO voucher_id VALUES("112","SL","02");
INSERT INTO voucher_id VALUES("33","PL","02");
INSERT INTO voucher_id VALUES("34","PL","02");
INSERT INTO voucher_id VALUES("35","PL","02");
INSERT INTO voucher_id VALUES("36","PL","02");
INSERT INTO voucher_id VALUES("37","PL","02");
INSERT INTO voucher_id VALUES("38","PL","02");
INSERT INTO voucher_id VALUES("113","SL","02");
INSERT INTO voucher_id VALUES("39","PL","02");
INSERT INTO voucher_id VALUES("40","PL","02");
INSERT INTO voucher_id VALUES("41","PL","02");
INSERT INTO voucher_id VALUES("42","PL","02");
INSERT INTO voucher_id VALUES("43","PL","02");
INSERT INTO voucher_id VALUES("44","PL","02");
INSERT INTO voucher_id VALUES("15","RT","02");
INSERT INTO voucher_id VALUES("45","PL","02");
INSERT INTO voucher_id VALUES("46","PL","02");
INSERT INTO voucher_id VALUES("47","PL","02");
INSERT INTO voucher_id VALUES("48","PL","02");
INSERT INTO voucher_id VALUES("49","PL","02");
INSERT INTO voucher_id VALUES("17","CP","02");
INSERT INTO voucher_id VALUES("50","PL","02");
INSERT INTO voucher_id VALUES("114","SL","02");
INSERT INTO voucher_id VALUES("115","SL","02");
INSERT INTO voucher_id VALUES("116","SL","02");
INSERT INTO voucher_id VALUES("117","SL","02");
INSERT INTO voucher_id VALUES("118","SL","02");
INSERT INTO voucher_id VALUES("119","SL","02");
INSERT INTO voucher_id VALUES("120","SL","02");
INSERT INTO voucher_id VALUES("121","SL","02");
INSERT INTO voucher_id VALUES("122","SL","02");
INSERT INTO voucher_id VALUES("123","SL","02");
INSERT INTO voucher_id VALUES("124","SL","02");
INSERT INTO voucher_id VALUES("125","SL","02");
INSERT INTO voucher_id VALUES("126","SL","02");
INSERT INTO voucher_id VALUES("127","SL","02");
INSERT INTO voucher_id VALUES("128","SL","02");
INSERT INTO voucher_id VALUES("129","SL","02");
INSERT INTO voucher_id VALUES("130","SL","02");
INSERT INTO voucher_id VALUES("131","SL","02");
INSERT INTO voucher_id VALUES("18","CP","02");
INSERT INTO voucher_id VALUES("19","CP","02");
INSERT INTO voucher_id VALUES("51","PL","02");
INSERT INTO voucher_id VALUES("52","PL","02");
INSERT INTO voucher_id VALUES("53","PL","02");
INSERT INTO voucher_id VALUES("54","PL","02");
INSERT INTO voucher_id VALUES("20","CP","02");
INSERT INTO voucher_id VALUES("55","PL","02");
INSERT INTO voucher_id VALUES("56","PL","02");
INSERT INTO voucher_id VALUES("57","PL","02");
INSERT INTO voucher_id VALUES("21","CP","02");
INSERT INTO voucher_id VALUES("22","CP","02");
INSERT INTO voucher_id VALUES("58","PL","02");
INSERT INTO voucher_id VALUES("59","PL","02");
INSERT INTO voucher_id VALUES("23","CP","02");
INSERT INTO voucher_id VALUES("24","CP","02");
INSERT INTO voucher_id VALUES("25","CP","02");
INSERT INTO voucher_id VALUES("26","CP","02");
INSERT INTO voucher_id VALUES("27","CP","02");
INSERT INTO voucher_id VALUES("28","CP","02");
INSERT INTO voucher_id VALUES("29","CP","02");
INSERT INTO voucher_id VALUES("60","PL","02");
INSERT INTO voucher_id VALUES("61","PL","02");
INSERT INTO voucher_id VALUES("62","PL","02");
INSERT INTO voucher_id VALUES("63","PL","02");
INSERT INTO voucher_id VALUES("30","CP","02");
INSERT INTO voucher_id VALUES("31","CP","02");
INSERT INTO voucher_id VALUES("32","CP","02");
INSERT INTO voucher_id VALUES("33","CP","02");
INSERT INTO voucher_id VALUES("34","CP","02");
INSERT INTO voucher_id VALUES("35","CP","02");
INSERT INTO voucher_id VALUES("36","CP","02");
INSERT INTO voucher_id VALUES("37","CP","02");
INSERT INTO voucher_id VALUES("38","CP","02");
INSERT INTO voucher_id VALUES("39","CP","02");
INSERT INTO voucher_id VALUES("2","CR","02");
INSERT INTO voucher_id VALUES("3","CR","02");
INSERT INTO voucher_id VALUES("4","CR","02");
INSERT INTO voucher_id VALUES("132","SL","02");
INSERT INTO voucher_id VALUES("133","SL","02");
INSERT INTO voucher_id VALUES("134","SL","02");
INSERT INTO voucher_id VALUES("135","SL","02");
INSERT INTO voucher_id VALUES("136","SL","02");
INSERT INTO voucher_id VALUES("137","SL","02");
INSERT INTO voucher_id VALUES("16","RT","02");
INSERT INTO voucher_id VALUES("17","RT","02");
INSERT INTO voucher_id VALUES("138","SL","02");
INSERT INTO voucher_id VALUES("139","SL","02");
INSERT INTO voucher_id VALUES("140","SL","02");
INSERT INTO voucher_id VALUES("141","SL","02");
INSERT INTO voucher_id VALUES("142","SL","02");
INSERT INTO voucher_id VALUES("143","SL","02");
INSERT INTO voucher_id VALUES("144","SL","02");
INSERT INTO voucher_id VALUES("145","SL","02");
INSERT INTO voucher_id VALUES("146","SL","02");
INSERT INTO voucher_id VALUES("18","RT","02");
INSERT INTO voucher_id VALUES("147","SL","02");
INSERT INTO voucher_id VALUES("148","SL","02");
INSERT INTO voucher_id VALUES("149","SL","02");
INSERT INTO voucher_id VALUES("150","SL","02");
INSERT INTO voucher_id VALUES("19","RT","02");
INSERT INTO voucher_id VALUES("151","SL","02");
INSERT INTO voucher_id VALUES("152","SL","02");
INSERT INTO voucher_id VALUES("153","SL","02");
INSERT INTO voucher_id VALUES("20","RT","02");
INSERT INTO voucher_id VALUES("21","RT","02");
INSERT INTO voucher_id VALUES("22","RT","02");
INSERT INTO voucher_id VALUES("154","SL","02");
INSERT INTO voucher_id VALUES("64","PL","02");
INSERT INTO voucher_id VALUES("155","SL","02");
INSERT INTO voucher_id VALUES("156","SL","02");
INSERT INTO voucher_id VALUES("157","SL","02");
INSERT INTO voucher_id VALUES("158","SL","02");
INSERT INTO voucher_id VALUES("159","SL","02");
INSERT INTO voucher_id VALUES("160","SL","02");
INSERT INTO voucher_id VALUES("161","SL","02");
INSERT INTO voucher_id VALUES("65","PL","02");
INSERT INTO voucher_id VALUES("66","PL","02");
INSERT INTO voucher_id VALUES("162","SL","02");
INSERT INTO voucher_id VALUES("163","SL","02");
INSERT INTO voucher_id VALUES("164","SL","02");
INSERT INTO voucher_id VALUES("165","SL","02");
INSERT INTO voucher_id VALUES("166","SL","02");
INSERT INTO voucher_id VALUES("23","RT","02");
INSERT INTO voucher_id VALUES("167","SL","02");
INSERT INTO voucher_id VALUES("168","SL","02");
INSERT INTO voucher_id VALUES("169","SL","02");
INSERT INTO voucher_id VALUES("170","SL","02");
INSERT INTO voucher_id VALUES("67","PL","02");
INSERT INTO voucher_id VALUES("68","PL","02");
INSERT INTO voucher_id VALUES("69","PL","02");
INSERT INTO voucher_id VALUES("70","PL","02");
INSERT INTO voucher_id VALUES("171","SL","02");
INSERT INTO voucher_id VALUES("24","RT","02");
INSERT INTO voucher_id VALUES("172","SL","02");
INSERT INTO voucher_id VALUES("173","SL","02");
INSERT INTO voucher_id VALUES("174","SL","02");
INSERT INTO voucher_id VALUES("175","SL","02");
INSERT INTO voucher_id VALUES("176","SL","02");
INSERT INTO voucher_id VALUES("177","SL","02");
INSERT INTO voucher_id VALUES("178","SL","02");
INSERT INTO voucher_id VALUES("179","SL","02");
INSERT INTO voucher_id VALUES("180","SL","02");
INSERT INTO voucher_id VALUES("181","SL","02");
INSERT INTO voucher_id VALUES("182","SL","02");
INSERT INTO voucher_id VALUES("183","SL","02");
INSERT INTO voucher_id VALUES("25","RT","02");
INSERT INTO voucher_id VALUES("184","SL","02");
INSERT INTO voucher_id VALUES("185","SL","02");
INSERT INTO voucher_id VALUES("186","SL","02");
INSERT INTO voucher_id VALUES("187","SL","02");
INSERT INTO voucher_id VALUES("188","SL","02");
INSERT INTO voucher_id VALUES("189","SL","02");
INSERT INTO voucher_id VALUES("190","SL","02");
INSERT INTO voucher_id VALUES("191","SL","02");
INSERT INTO voucher_id VALUES("192","SL","02");
INSERT INTO voucher_id VALUES("193","SL","02");
INSERT INTO voucher_id VALUES("194","SL","02");
INSERT INTO voucher_id VALUES("195","SL","02");
INSERT INTO voucher_id VALUES("196","SL","02");
INSERT INTO voucher_id VALUES("197","SL","02");
INSERT INTO voucher_id VALUES("198","SL","02");
INSERT INTO voucher_id VALUES("199","SL","02");
INSERT INTO voucher_id VALUES("200","SL","02");
INSERT INTO voucher_id VALUES("201","SL","02");
INSERT INTO voucher_id VALUES("202","SL","02");
INSERT INTO voucher_id VALUES("203","SL","02");
INSERT INTO voucher_id VALUES("204","SL","02");
INSERT INTO voucher_id VALUES("205","SL","02");
INSERT INTO voucher_id VALUES("206","SL","02");
INSERT INTO voucher_id VALUES("207","SL","02");
INSERT INTO voucher_id VALUES("208","SL","02");
INSERT INTO voucher_id VALUES("209","SL","02");
INSERT INTO voucher_id VALUES("210","SL","02");
INSERT INTO voucher_id VALUES("71","PL","02");
INSERT INTO voucher_id VALUES("5","CR","02");
INSERT INTO voucher_id VALUES("211","SL","02");
INSERT INTO voucher_id VALUES("212","SL","02");
INSERT INTO voucher_id VALUES("213","SL","02");
INSERT INTO voucher_id VALUES("45","SL","KT");
INSERT INTO voucher_id VALUES("46","SL","KT");
INSERT INTO voucher_id VALUES("47","SL","KT");
INSERT INTO voucher_id VALUES("1","PL","KT");
INSERT INTO voucher_id VALUES("2","PL","KT");
INSERT INTO voucher_id VALUES("3","PL","KT");
INSERT INTO voucher_id VALUES("4","PL","KT");
INSERT INTO voucher_id VALUES("5","PL","KT");
INSERT INTO voucher_id VALUES("6","PL","KT");
INSERT INTO voucher_id VALUES("7","PL","KT");
INSERT INTO voucher_id VALUES("8","PL","KT");
INSERT INTO voucher_id VALUES("9","PL","KT");
INSERT INTO voucher_id VALUES("10","PL","KT");
INSERT INTO voucher_id VALUES("11","PL","KT");
INSERT INTO voucher_id VALUES("12","PL","KT");
INSERT INTO voucher_id VALUES("13","PL","KT");
INSERT INTO voucher_id VALUES("1","ST","KT");
INSERT INTO voucher_id VALUES("2","ST","KT");
INSERT INTO voucher_id VALUES("3","ST","KT");
INSERT INTO voucher_id VALUES("4","ST","KT");
INSERT INTO voucher_id VALUES("5","ST","KT");
INSERT INTO voucher_id VALUES("6","ST","KT");
INSERT INTO voucher_id VALUES("7","ST","KT");
INSERT INTO voucher_id VALUES("8","ST","KT");
INSERT INTO voucher_id VALUES("9","ST","KT");
INSERT INTO voucher_id VALUES("10","ST","KT");
INSERT INTO voucher_id VALUES("11","ST","KT");
INSERT INTO voucher_id VALUES("12","ST","KT");
INSERT INTO voucher_id VALUES("13","ST","KT");
INSERT INTO voucher_id VALUES("14","ST","KT");
INSERT INTO voucher_id VALUES("15","ST","KT");
INSERT INTO voucher_id VALUES("16","ST","KT");
INSERT INTO voucher_id VALUES("17","ST","KT");
INSERT INTO voucher_id VALUES("18","ST","KT");
INSERT INTO voucher_id VALUES("19","ST","KT");
INSERT INTO voucher_id VALUES("20","ST","KT");
INSERT INTO voucher_id VALUES("21","ST","KT");
INSERT INTO voucher_id VALUES("22","ST","KT");
INSERT INTO voucher_id VALUES("23","ST","KT");
INSERT INTO voucher_id VALUES("24","ST","KT");
INSERT INTO voucher_id VALUES("25","ST","KT");
INSERT INTO voucher_id VALUES("26","ST","KT");
INSERT INTO voucher_id VALUES("27","ST","KT");
INSERT INTO voucher_id VALUES("28","ST","KT");
INSERT INTO voucher_id VALUES("29","ST","KT");
INSERT INTO voucher_id VALUES("30","ST","KT");
INSERT INTO voucher_id VALUES("31","ST","KT");
INSERT INTO voucher_id VALUES("32","ST","KT");
INSERT INTO voucher_id VALUES("33","ST","KT");
INSERT INTO voucher_id VALUES("34","ST","KT");
INSERT INTO voucher_id VALUES("35","ST","KT");
INSERT INTO voucher_id VALUES("36","ST","KT");
INSERT INTO voucher_id VALUES("37","ST","KT");
INSERT INTO voucher_id VALUES("38","ST","KT");
INSERT INTO voucher_id VALUES("39","ST","KT");
INSERT INTO voucher_id VALUES("40","ST","KT");
INSERT INTO voucher_id VALUES("41","ST","KT");
INSERT INTO voucher_id VALUES("42","ST","KT");
INSERT INTO voucher_id VALUES("43","ST","KT");
INSERT INTO voucher_id VALUES("44","ST","KT");
INSERT INTO voucher_id VALUES("14","PL","KT");
INSERT INTO voucher_id VALUES("15","PL","KT");
INSERT INTO voucher_id VALUES("16","PL","KT");
INSERT INTO voucher_id VALUES("17","PL","KT");
INSERT INTO voucher_id VALUES("18","PL","KT");
INSERT INTO voucher_id VALUES("19","PL","KT");
INSERT INTO voucher_id VALUES("48","SL","KT");
INSERT INTO voucher_id VALUES("49","SL","KT");
INSERT INTO voucher_id VALUES("45","ST","KT");
INSERT INTO voucher_id VALUES("46","ST","KT");
INSERT INTO voucher_id VALUES("47","ST","KT");
INSERT INTO voucher_id VALUES("48","ST","KT");
INSERT INTO voucher_id VALUES("49","ST","KT");
INSERT INTO voucher_id VALUES("50","ST","KT");
INSERT INTO voucher_id VALUES("51","ST","KT");
INSERT INTO voucher_id VALUES("52","ST","KT");
INSERT INTO voucher_id VALUES("53","ST","KT");
INSERT INTO voucher_id VALUES("54","ST","KT");
INSERT INTO voucher_id VALUES("55","ST","KT");
INSERT INTO voucher_id VALUES("56","ST","KT");
INSERT INTO voucher_id VALUES("57","ST","KT");
INSERT INTO voucher_id VALUES("58","ST","KT");
INSERT INTO voucher_id VALUES("59","ST","KT");
INSERT INTO voucher_id VALUES("60","ST","KT");
INSERT INTO voucher_id VALUES("15","CP","KT");
INSERT INTO voucher_id VALUES("16","CP","KT");
INSERT INTO voucher_id VALUES("5","JV","KT");
INSERT INTO voucher_id VALUES("50","SL","KT");
INSERT INTO voucher_id VALUES("17","CP","KT");
INSERT INTO voucher_id VALUES("51","SL","KT");
INSERT INTO voucher_id VALUES("6","JV","KT");
INSERT INTO voucher_id VALUES("7","JV","KT");
INSERT INTO voucher_id VALUES("8","JV","KT");
INSERT INTO voucher_id VALUES("9","JV","KT");
INSERT INTO voucher_id VALUES("20","PL","KT");
INSERT INTO voucher_id VALUES("52","SL","KT");
INSERT INTO voucher_id VALUES("53","SL","KT");
INSERT INTO voucher_id VALUES("54","SL","KT");
INSERT INTO voucher_id VALUES("21","PL","KT");
INSERT INTO voucher_id VALUES("18","CP","KT");
INSERT INTO voucher_id VALUES("55","SL","KT");
INSERT INTO voucher_id VALUES("61","ST","KT");
INSERT INTO voucher_id VALUES("56","SL","KT");
INSERT INTO voucher_id VALUES("22","PL","KT");
INSERT INTO voucher_id VALUES("62","ST","KT");
INSERT INTO voucher_id VALUES("63","ST","KT");
INSERT INTO voucher_id VALUES("57","SL","KT");
INSERT INTO voucher_id VALUES("58","SL","KT");
INSERT INTO voucher_id VALUES("59","SL","KT");
INSERT INTO voucher_id VALUES("60","SL","KT");
INSERT INTO voucher_id VALUES("61","SL","KT");
INSERT INTO voucher_id VALUES("62","SL","KT");
INSERT INTO voucher_id VALUES("63","SL","KT");
INSERT INTO voucher_id VALUES("23","PL","KT");
INSERT INTO voucher_id VALUES("24","PL","KT");
INSERT INTO voucher_id VALUES("64","ST","KT");
INSERT INTO voucher_id VALUES("1","SL","IT");
INSERT INTO voucher_id VALUES("2","SL","IT");
INSERT INTO voucher_id VALUES("25","PL","KT");
INSERT INTO voucher_id VALUES("26","PL","KT");
INSERT INTO voucher_id VALUES("27","PL","KT");
INSERT INTO voucher_id VALUES("28","PL","KT");
INSERT INTO voucher_id VALUES("29","PL","KT");
INSERT INTO voucher_id VALUES("30","PL","KT");
INSERT INTO voucher_id VALUES("31","PL","KT");
INSERT INTO voucher_id VALUES("32","PL","KT");
INSERT INTO voucher_id VALUES("33","PL","KT");
INSERT INTO voucher_id VALUES("34","PL","KT");
INSERT INTO voucher_id VALUES("35","PL","KT");
INSERT INTO voucher_id VALUES("36","PL","KT");
INSERT INTO voucher_id VALUES("37","PL","KT");
INSERT INTO voucher_id VALUES("38","PL","KT");
INSERT INTO voucher_id VALUES("39","PL","KT");
INSERT INTO voucher_id VALUES("40","PL","KT");
INSERT INTO voucher_id VALUES("41","PL","KT");
INSERT INTO voucher_id VALUES("42","PL","KT");
INSERT INTO voucher_id VALUES("43","PL","KT");
INSERT INTO voucher_id VALUES("44","PL","KT");
INSERT INTO voucher_id VALUES("45","PL","KT");
INSERT INTO voucher_id VALUES("46","PL","KT");
INSERT INTO voucher_id VALUES("47","PL","KT");
INSERT INTO voucher_id VALUES("48","PL","KT");
INSERT INTO voucher_id VALUES("49","PL","KT");
INSERT INTO voucher_id VALUES("50","PL","KT");
INSERT INTO voucher_id VALUES("51","PL","KT");
INSERT INTO voucher_id VALUES("52","PL","KT");
INSERT INTO voucher_id VALUES("53","PL","KT");
INSERT INTO voucher_id VALUES("54","PL","KT");
INSERT INTO voucher_id VALUES("55","PL","KT");
INSERT INTO voucher_id VALUES("56","PL","KT");
INSERT INTO voucher_id VALUES("57","PL","KT");
INSERT INTO voucher_id VALUES("58","PL","KT");
INSERT INTO voucher_id VALUES("59","PL","KT");
INSERT INTO voucher_id VALUES("60","PL","KT");
INSERT INTO voucher_id VALUES("61","PL","KT");
INSERT INTO voucher_id VALUES("62","PL","KT");
INSERT INTO voucher_id VALUES("63","PL","KT");
INSERT INTO voucher_id VALUES("64","PL","KT");
INSERT INTO voucher_id VALUES("65","PL","KT");
INSERT INTO voucher_id VALUES("66","PL","KT");
INSERT INTO voucher_id VALUES("67","PL","KT");
INSERT INTO voucher_id VALUES("68","PL","KT");
INSERT INTO voucher_id VALUES("69","PL","KT");
INSERT INTO voucher_id VALUES("70","PL","KT");
INSERT INTO voucher_id VALUES("71","PL","KT");
INSERT INTO voucher_id VALUES("72","PL","KT");
INSERT INTO voucher_id VALUES("73","PL","KT");
INSERT INTO voucher_id VALUES("74","PL","KT");
INSERT INTO voucher_id VALUES("75","PL","KT");
INSERT INTO voucher_id VALUES("76","PL","KT");
INSERT INTO voucher_id VALUES("77","PL","KT");
INSERT INTO voucher_id VALUES("78","PL","KT");
INSERT INTO voucher_id VALUES("79","PL","KT");
INSERT INTO voucher_id VALUES("64","SL","KT");
INSERT INTO voucher_id VALUES("80","PL","KT");
INSERT INTO voucher_id VALUES("65","SL","KT");
INSERT INTO voucher_id VALUES("66","SL","KT");
INSERT INTO voucher_id VALUES("67","SL","KT");
INSERT INTO voucher_id VALUES("68","SL","KT");
INSERT INTO voucher_id VALUES("69","SL","KT");
INSERT INTO voucher_id VALUES("70","SL","KT");
INSERT INTO voucher_id VALUES("71","SL","KT");
INSERT INTO voucher_id VALUES("72","SL","KT");
INSERT INTO voucher_id VALUES("73","SL","KT");
INSERT INTO voucher_id VALUES("74","SL","KT");
INSERT INTO voucher_id VALUES("75","SL","KT");
INSERT INTO voucher_id VALUES("76","SL","KT");
INSERT INTO voucher_id VALUES("77","SL","KT");
INSERT INTO voucher_id VALUES("78","SL","KT");
INSERT INTO voucher_id VALUES("79","SL","KT");
INSERT INTO voucher_id VALUES("80","SL","KT");
INSERT INTO voucher_id VALUES("81","SL","KT");
INSERT INTO voucher_id VALUES("82","SL","KT");
INSERT INTO voucher_id VALUES("83","SL","KT");
INSERT INTO voucher_id VALUES("84","SL","KT");
INSERT INTO voucher_id VALUES("85","SL","KT");
INSERT INTO voucher_id VALUES("86","SL","KT");
INSERT INTO voucher_id VALUES("87","SL","KT");
INSERT INTO voucher_id VALUES("81","PL","KT");
INSERT INTO voucher_id VALUES("88","SL","KT");
INSERT INTO voucher_id VALUES("89","SL","KT");
INSERT INTO voucher_id VALUES("90","SL","KT");
INSERT INTO voucher_id VALUES("91","SL","KT");
INSERT INTO voucher_id VALUES("92","SL","KT");
INSERT INTO voucher_id VALUES("93","SL","KT");
INSERT INTO voucher_id VALUES("94","SL","KT");
INSERT INTO voucher_id VALUES("82","PL","KT");
INSERT INTO voucher_id VALUES("95","SL","KT");
INSERT INTO voucher_id VALUES("96","SL","KT");
INSERT INTO voucher_id VALUES("97","SL","KT");
INSERT INTO voucher_id VALUES("98","SL","KT");
INSERT INTO voucher_id VALUES("99","SL","KT");
INSERT INTO voucher_id VALUES("100","SL","KT");
INSERT INTO voucher_id VALUES("101","SL","KT");
INSERT INTO voucher_id VALUES("102","SL","KT");
INSERT INTO voucher_id VALUES("103","SL","KT");
INSERT INTO voucher_id VALUES("104","SL","KT");
INSERT INTO voucher_id VALUES("105","SL","KT");
INSERT INTO voucher_id VALUES("106","SL","KT");
INSERT INTO voucher_id VALUES("107","SL","KT");
INSERT INTO voucher_id VALUES("108","SL","KT");
INSERT INTO voucher_id VALUES("109","SL","KT");
INSERT INTO voucher_id VALUES("110","SL","KT");
INSERT INTO voucher_id VALUES("111","SL","KT");
INSERT INTO voucher_id VALUES("112","SL","KT");
INSERT INTO voucher_id VALUES("113","SL","KT");
INSERT INTO voucher_id VALUES("114","SL","KT");
INSERT INTO voucher_id VALUES("115","SL","KT");
INSERT INTO voucher_id VALUES("116","SL","KT");
INSERT INTO voucher_id VALUES("117","SL","KT");
INSERT INTO voucher_id VALUES("118","SL","KT");
INSERT INTO voucher_id VALUES("119","SL","KT");
INSERT INTO voucher_id VALUES("83","PL","KT");
INSERT INTO voucher_id VALUES("84","PL","KT");
INSERT INTO voucher_id VALUES("85","PL","KT");
INSERT INTO voucher_id VALUES("86","PL","KT");
INSERT INTO voucher_id VALUES("87","PL","KT");
INSERT INTO voucher_id VALUES("120","SL","KT");
INSERT INTO voucher_id VALUES("88","PL","KT");
INSERT INTO voucher_id VALUES("89","PL","KT");
INSERT INTO voucher_id VALUES("90","PL","KT");
INSERT INTO voucher_id VALUES("91","PL","KT");
INSERT INTO voucher_id VALUES("10","JV","KT");
INSERT INTO voucher_id VALUES("11","JV","KT");
INSERT INTO voucher_id VALUES("12","JV","KT");
INSERT INTO voucher_id VALUES("13","JV","KT");
INSERT INTO voucher_id VALUES("14","JV","KT");
INSERT INTO voucher_id VALUES("15","JV","KT");
INSERT INTO voucher_id VALUES("16","JV","KT");
INSERT INTO voucher_id VALUES("17","JV","KT");
INSERT INTO voucher_id VALUES("18","JV","KT");
INSERT INTO voucher_id VALUES("19","JV","KT");
INSERT INTO voucher_id VALUES("20","JV","KT");
INSERT INTO voucher_id VALUES("21","JV","KT");
INSERT INTO voucher_id VALUES("22","JV","KT");
INSERT INTO voucher_id VALUES("23","JV","KT");
INSERT INTO voucher_id VALUES("24","JV","KT");
INSERT INTO voucher_id VALUES("25","JV","KT");
INSERT INTO voucher_id VALUES("26","JV","KT");
INSERT INTO voucher_id VALUES("27","JV","KT");
INSERT INTO voucher_id VALUES("28","JV","KT");
INSERT INTO voucher_id VALUES("92","PL","KT");
INSERT INTO voucher_id VALUES("93","PL","KT");
INSERT INTO voucher_id VALUES("94","PL","KT");
INSERT INTO voucher_id VALUES("95","PL","KT");
INSERT INTO voucher_id VALUES("96","PL","KT");
INSERT INTO voucher_id VALUES("97","PL","KT");
INSERT INTO voucher_id VALUES("98","PL","KT");
INSERT INTO voucher_id VALUES("99","PL","KT");
INSERT INTO voucher_id VALUES("121","SL","KT");
INSERT INTO voucher_id VALUES("122","SL","KT");
INSERT INTO voucher_id VALUES("123","SL","KT");
INSERT INTO voucher_id VALUES("29","JV","KT");
INSERT INTO voucher_id VALUES("30","JV","KT");
INSERT INTO voucher_id VALUES("31","JV","KT");
INSERT INTO voucher_id VALUES("32","JV","KT");
INSERT INTO voucher_id VALUES("33","JV","KT");
INSERT INTO voucher_id VALUES("34","JV","KT");
INSERT INTO voucher_id VALUES("124","SL","KT");
INSERT INTO voucher_id VALUES("125","SL","KT");
INSERT INTO voucher_id VALUES("126","SL","KT");
INSERT INTO voucher_id VALUES("127","SL","KT");
INSERT INTO voucher_id VALUES("100","PL","KT");
INSERT INTO voucher_id VALUES("101","PL","KT");
INSERT INTO voucher_id VALUES("102","PL","KT");
INSERT INTO voucher_id VALUES("103","PL","KT");
INSERT INTO voucher_id VALUES("104","PL","KT");
INSERT INTO voucher_id VALUES("105","PL","KT");
INSERT INTO voucher_id VALUES("106","PL","KT");
INSERT INTO voucher_id VALUES("107","PL","KT");
INSERT INTO voucher_id VALUES("108","PL","KT");
INSERT INTO voucher_id VALUES("109","PL","KT");
INSERT INTO voucher_id VALUES("110","PL","KT");
INSERT INTO voucher_id VALUES("111","PL","KT");
INSERT INTO voucher_id VALUES("112","PL","KT");
INSERT INTO voucher_id VALUES("113","PL","KT");
INSERT INTO voucher_id VALUES("35","JV","KT");
INSERT INTO voucher_id VALUES("36","JV","KT");
INSERT INTO voucher_id VALUES("37","JV","KT");
INSERT INTO voucher_id VALUES("38","JV","KT");
INSERT INTO voucher_id VALUES("39","JV","KT");
INSERT INTO voucher_id VALUES("40","JV","KT");
INSERT INTO voucher_id VALUES("41","JV","KT");
INSERT INTO voucher_id VALUES("42","JV","KT");
INSERT INTO voucher_id VALUES("43","JV","KT");
INSERT INTO voucher_id VALUES("44","JV","KT");
INSERT INTO voucher_id VALUES("45","JV","KT");
INSERT INTO voucher_id VALUES("46","JV","KT");
INSERT INTO voucher_id VALUES("47","JV","KT");
INSERT INTO voucher_id VALUES("48","JV","KT");
INSERT INTO voucher_id VALUES("49","JV","KT");
INSERT INTO voucher_id VALUES("50","JV","KT");
INSERT INTO voucher_id VALUES("51","JV","KT");
INSERT INTO voucher_id VALUES("52","JV","KT");
INSERT INTO voucher_id VALUES("128","SL","KT");
INSERT INTO voucher_id VALUES("129","SL","KT");
INSERT INTO voucher_id VALUES("53","JV","KT");
INSERT INTO voucher_id VALUES("54","JV","KT");
INSERT INTO voucher_id VALUES("55","JV","KT");
INSERT INTO voucher_id VALUES("56","JV","KT");
INSERT INTO voucher_id VALUES("114","PL","KT");
INSERT INTO voucher_id VALUES("57","JV","KT");
INSERT INTO voucher_id VALUES("115","PL","KT");
INSERT INTO voucher_id VALUES("116","PL","KT");
INSERT INTO voucher_id VALUES("117","PL","KT");
INSERT INTO voucher_id VALUES("118","PL","KT");
INSERT INTO voucher_id VALUES("119","PL","KT");
INSERT INTO voucher_id VALUES("120","PL","KT");
INSERT INTO voucher_id VALUES("121","PL","KT");
INSERT INTO voucher_id VALUES("130","SL","KT");
INSERT INTO voucher_id VALUES("131","SL","KT");
INSERT INTO voucher_id VALUES("132","SL","KT");
INSERT INTO voucher_id VALUES("133","SL","KT");
INSERT INTO voucher_id VALUES("65","ST","KT");
INSERT INTO voucher_id VALUES("66","ST","KT");
INSERT INTO voucher_id VALUES("67","ST","KT");
INSERT INTO voucher_id VALUES("68","ST","KT");
INSERT INTO voucher_id VALUES("69","ST","KT");
INSERT INTO voucher_id VALUES("134","SL","KT");
INSERT INTO voucher_id VALUES("122","PL","KT");
INSERT INTO voucher_id VALUES("19","CP","KT");
INSERT INTO voucher_id VALUES("20","CP","KT");
INSERT INTO voucher_id VALUES("21","CP","KT");
INSERT INTO voucher_id VALUES("22","CP","KT");
INSERT INTO voucher_id VALUES("23","CP","KT");
INSERT INTO voucher_id VALUES("24","CP","KT");
INSERT INTO voucher_id VALUES("25","CP","KT");
INSERT INTO voucher_id VALUES("26","CP","KT");
INSERT INTO voucher_id VALUES("27","CP","KT");
INSERT INTO voucher_id VALUES("28","CP","KT");
INSERT INTO voucher_id VALUES("29","CP","KT");
INSERT INTO voucher_id VALUES("30","CP","KT");
INSERT INTO voucher_id VALUES("31","CP","KT");
INSERT INTO voucher_id VALUES("32","CP","KT");
INSERT INTO voucher_id VALUES("33","CP","KT");
INSERT INTO voucher_id VALUES("135","SL","KT");
INSERT INTO voucher_id VALUES("34","CP","KT");
INSERT INTO voucher_id VALUES("35","CP","KT");
INSERT INTO voucher_id VALUES("36","CP","KT");
INSERT INTO voucher_id VALUES("37","CP","KT");
INSERT INTO voucher_id VALUES("38","CP","KT");
INSERT INTO voucher_id VALUES("39","CP","KT");
INSERT INTO voucher_id VALUES("40","CP","KT");
INSERT INTO voucher_id VALUES("41","CP","KT");
INSERT INTO voucher_id VALUES("42","CP","KT");
INSERT INTO voucher_id VALUES("43","CP","KT");
INSERT INTO voucher_id VALUES("44","CP","KT");
INSERT INTO voucher_id VALUES("45","CP","KT");
INSERT INTO voucher_id VALUES("46","CP","KT");
INSERT INTO voucher_id VALUES("47","CP","KT");
INSERT INTO voucher_id VALUES("48","CP","KT");
INSERT INTO voucher_id VALUES("49","CP","KT");
INSERT INTO voucher_id VALUES("50","CP","KT");
INSERT INTO voucher_id VALUES("51","CP","KT");
INSERT INTO voucher_id VALUES("52","CP","KT");
INSERT INTO voucher_id VALUES("53","CP","KT");
INSERT INTO voucher_id VALUES("54","CP","KT");
INSERT INTO voucher_id VALUES("55","CP","KT");
INSERT INTO voucher_id VALUES("56","CP","KT");
INSERT INTO voucher_id VALUES("57","CP","KT");
INSERT INTO voucher_id VALUES("58","CP","KT");
INSERT INTO voucher_id VALUES("59","CP","KT");
INSERT INTO voucher_id VALUES("60","CP","KT");
INSERT INTO voucher_id VALUES("61","CP","KT");
INSERT INTO voucher_id VALUES("62","CP","KT");
INSERT INTO voucher_id VALUES("63","CP","KT");
INSERT INTO voucher_id VALUES("64","CP","KT");
INSERT INTO voucher_id VALUES("65","CP","KT");
INSERT INTO voucher_id VALUES("66","CP","KT");
INSERT INTO voucher_id VALUES("67","CP","KT");
INSERT INTO voucher_id VALUES("68","CP","KT");
INSERT INTO voucher_id VALUES("69","CP","KT");
INSERT INTO voucher_id VALUES("70","CP","KT");
INSERT INTO voucher_id VALUES("71","CP","KT");
INSERT INTO voucher_id VALUES("72","CP","KT");
INSERT INTO voucher_id VALUES("73","CP","KT");
INSERT INTO voucher_id VALUES("74","CP","KT");
INSERT INTO voucher_id VALUES("75","CP","KT");
INSERT INTO voucher_id VALUES("76","CP","KT");
INSERT INTO voucher_id VALUES("77","CP","KT");
INSERT INTO voucher_id VALUES("78","CP","KT");
INSERT INTO voucher_id VALUES("79","CP","KT");
INSERT INTO voucher_id VALUES("80","CP","KT");
INSERT INTO voucher_id VALUES("123","PL","KT");
INSERT INTO voucher_id VALUES("124","PL","KT");
INSERT INTO voucher_id VALUES("125","PL","KT");
INSERT INTO voucher_id VALUES("126","PL","KT");
INSERT INTO voucher_id VALUES("127","PL","KT");
INSERT INTO voucher_id VALUES("128","PL","KT");
INSERT INTO voucher_id VALUES("129","PL","KT");
INSERT INTO voucher_id VALUES("130","PL","KT");
INSERT INTO voucher_id VALUES("131","PL","KT");
INSERT INTO voucher_id VALUES("132","PL","KT");
INSERT INTO voucher_id VALUES("133","PL","KT");
INSERT INTO voucher_id VALUES("134","PL","KT");
INSERT INTO voucher_id VALUES("135","PL","KT");
INSERT INTO voucher_id VALUES("136","PL","KT");
INSERT INTO voucher_id VALUES("137","PL","KT");
INSERT INTO voucher_id VALUES("138","PL","KT");
INSERT INTO voucher_id VALUES("139","PL","KT");
INSERT INTO voucher_id VALUES("140","PL","KT");
INSERT INTO voucher_id VALUES("141","PL","KT");
INSERT INTO voucher_id VALUES("142","PL","KT");
INSERT INTO voucher_id VALUES("136","SL","KT");
INSERT INTO voucher_id VALUES("137","SL","KT");
INSERT INTO voucher_id VALUES("143","PL","KT");
INSERT INTO voucher_id VALUES("144","PL","KT");
INSERT INTO voucher_id VALUES("145","PL","KT");
INSERT INTO voucher_id VALUES("146","PL","KT");
INSERT INTO voucher_id VALUES("81","CP","KT");
INSERT INTO voucher_id VALUES("82","CP","KT");
INSERT INTO voucher_id VALUES("83","CP","KT");
INSERT INTO voucher_id VALUES("84","CP","KT");
INSERT INTO voucher_id VALUES("85","CP","KT");
INSERT INTO voucher_id VALUES("86","CP","KT");
INSERT INTO voucher_id VALUES("87","CP","KT");
INSERT INTO voucher_id VALUES("88","CP","KT");
INSERT INTO voucher_id VALUES("89","CP","KT");
INSERT INTO voucher_id VALUES("90","CP","KT");
INSERT INTO voucher_id VALUES("91","CP","KT");
INSERT INTO voucher_id VALUES("92","CP","KT");
INSERT INTO voucher_id VALUES("93","CP","KT");
INSERT INTO voucher_id VALUES("94","CP","KT");
INSERT INTO voucher_id VALUES("95","CP","KT");
INSERT INTO voucher_id VALUES("96","CP","KT");
INSERT INTO voucher_id VALUES("97","CP","KT");
INSERT INTO voucher_id VALUES("98","CP","KT");
INSERT INTO voucher_id VALUES("99","CP","KT");
INSERT INTO voucher_id VALUES("100","CP","KT");
INSERT INTO voucher_id VALUES("101","CP","KT");
INSERT INTO voucher_id VALUES("102","CP","KT");
INSERT INTO voucher_id VALUES("103","CP","KT");
INSERT INTO voucher_id VALUES("104","CP","KT");
INSERT INTO voucher_id VALUES("105","CP","KT");
INSERT INTO voucher_id VALUES("106","CP","KT");
INSERT INTO voucher_id VALUES("107","CP","KT");
INSERT INTO voucher_id VALUES("108","CP","KT");
INSERT INTO voucher_id VALUES("109","CP","KT");
INSERT INTO voucher_id VALUES("110","CP","KT");
INSERT INTO voucher_id VALUES("111","CP","KT");
INSERT INTO voucher_id VALUES("112","CP","KT");
INSERT INTO voucher_id VALUES("113","CP","KT");
INSERT INTO voucher_id VALUES("114","CP","KT");
INSERT INTO voucher_id VALUES("115","CP","KT");
INSERT INTO voucher_id VALUES("116","CP","KT");
INSERT INTO voucher_id VALUES("117","CP","KT");
INSERT INTO voucher_id VALUES("118","CP","KT");
INSERT INTO voucher_id VALUES("119","CP","KT");
INSERT INTO voucher_id VALUES("120","CP","KT");
INSERT INTO voucher_id VALUES("121","CP","KT");
INSERT INTO voucher_id VALUES("122","CP","KT");
INSERT INTO voucher_id VALUES("123","CP","KT");
INSERT INTO voucher_id VALUES("124","CP","KT");
INSERT INTO voucher_id VALUES("125","CP","KT");
INSERT INTO voucher_id VALUES("147","PL","KT");
INSERT INTO voucher_id VALUES("148","PL","KT");
INSERT INTO voucher_id VALUES("149","PL","KT");
INSERT INTO voucher_id VALUES("150","PL","KT");
INSERT INTO voucher_id VALUES("151","PL","KT");
INSERT INTO voucher_id VALUES("152","PL","KT");
INSERT INTO voucher_id VALUES("153","PL","KT");
INSERT INTO voucher_id VALUES("154","PL","KT");
INSERT INTO voucher_id VALUES("155","PL","KT");
INSERT INTO voucher_id VALUES("156","PL","KT");
INSERT INTO voucher_id VALUES("157","PL","KT");
INSERT INTO voucher_id VALUES("158","PL","KT");
INSERT INTO voucher_id VALUES("159","PL","KT");
INSERT INTO voucher_id VALUES("160","PL","KT");
INSERT INTO voucher_id VALUES("161","PL","KT");
INSERT INTO voucher_id VALUES("162","PL","KT");
INSERT INTO voucher_id VALUES("163","PL","KT");
INSERT INTO voucher_id VALUES("164","PL","KT");
INSERT INTO voucher_id VALUES("165","PL","KT");
INSERT INTO voucher_id VALUES("166","PL","KT");
INSERT INTO voucher_id VALUES("167","PL","KT");
INSERT INTO voucher_id VALUES("168","PL","KT");
INSERT INTO voucher_id VALUES("169","PL","KT");
INSERT INTO voucher_id VALUES("170","PL","KT");
INSERT INTO voucher_id VALUES("171","PL","KT");
INSERT INTO voucher_id VALUES("172","PL","KT");
INSERT INTO voucher_id VALUES("173","PL","KT");
INSERT INTO voucher_id VALUES("174","PL","KT");
INSERT INTO voucher_id VALUES("175","PL","KT");
INSERT INTO voucher_id VALUES("176","PL","KT");
INSERT INTO voucher_id VALUES("177","PL","KT");
INSERT INTO voucher_id VALUES("178","PL","KT");
INSERT INTO voucher_id VALUES("179","PL","KT");
INSERT INTO voucher_id VALUES("180","PL","KT");
INSERT INTO voucher_id VALUES("181","PL","KT");
INSERT INTO voucher_id VALUES("182","PL","KT");
INSERT INTO voucher_id VALUES("183","PL","KT");
INSERT INTO voucher_id VALUES("184","PL","KT");
INSERT INTO voucher_id VALUES("185","PL","KT");
INSERT INTO voucher_id VALUES("186","PL","KT");
INSERT INTO voucher_id VALUES("187","PL","KT");
INSERT INTO voucher_id VALUES("188","PL","KT");
INSERT INTO voucher_id VALUES("189","PL","KT");
INSERT INTO voucher_id VALUES("190","PL","KT");
INSERT INTO voucher_id VALUES("191","PL","KT");
INSERT INTO voucher_id VALUES("192","PL","KT");
INSERT INTO voucher_id VALUES("193","PL","KT");
INSERT INTO voucher_id VALUES("194","PL","KT");
INSERT INTO voucher_id VALUES("195","PL","KT");
INSERT INTO voucher_id VALUES("196","PL","KT");
INSERT INTO voucher_id VALUES("197","PL","KT");
INSERT INTO voucher_id VALUES("198","PL","KT");
INSERT INTO voucher_id VALUES("199","PL","KT");
INSERT INTO voucher_id VALUES("200","PL","KT");
INSERT INTO voucher_id VALUES("201","PL","KT");
INSERT INTO voucher_id VALUES("202","PL","KT");
INSERT INTO voucher_id VALUES("203","PL","KT");
INSERT INTO voucher_id VALUES("204","PL","KT");
INSERT INTO voucher_id VALUES("205","PL","KT");
INSERT INTO voucher_id VALUES("206","PL","KT");
INSERT INTO voucher_id VALUES("207","PL","KT");
INSERT INTO voucher_id VALUES("208","PL","KT");
INSERT INTO voucher_id VALUES("209","PL","KT");
INSERT INTO voucher_id VALUES("210","PL","KT");
INSERT INTO voucher_id VALUES("211","PL","KT");
INSERT INTO voucher_id VALUES("212","PL","KT");
INSERT INTO voucher_id VALUES("213","PL","KT");
INSERT INTO voucher_id VALUES("214","PL","KT");
INSERT INTO voucher_id VALUES("215","PL","KT");
INSERT INTO voucher_id VALUES("216","PL","KT");
INSERT INTO voucher_id VALUES("217","PL","KT");
INSERT INTO voucher_id VALUES("218","PL","KT");
INSERT INTO voucher_id VALUES("219","PL","KT");
INSERT INTO voucher_id VALUES("126","CP","KT");
INSERT INTO voucher_id VALUES("127","CP","KT");
INSERT INTO voucher_id VALUES("70","ST","KT");
INSERT INTO voucher_id VALUES("128","CP","KT");
INSERT INTO voucher_id VALUES("129","CP","KT");
INSERT INTO voucher_id VALUES("130","CP","KT");
INSERT INTO voucher_id VALUES("131","CP","KT");
INSERT INTO voucher_id VALUES("220","PL","KT");
INSERT INTO voucher_id VALUES("221","PL","KT");
INSERT INTO voucher_id VALUES("222","PL","KT");
INSERT INTO voucher_id VALUES("223","PL","KT");
INSERT INTO voucher_id VALUES("224","PL","KT");
INSERT INTO voucher_id VALUES("225","PL","KT");
INSERT INTO voucher_id VALUES("226","PL","KT");
INSERT INTO voucher_id VALUES("227","PL","KT");
INSERT INTO voucher_id VALUES("228","PL","KT");
INSERT INTO voucher_id VALUES("229","PL","KT");
INSERT INTO voucher_id VALUES("230","PL","KT");
INSERT INTO voucher_id VALUES("138","SL","KT");
INSERT INTO voucher_id VALUES("231","PL","KT");
INSERT INTO voucher_id VALUES("232","PL","KT");
INSERT INTO voucher_id VALUES("71","ST","KT");
INSERT INTO voucher_id VALUES("72","ST","KT");
INSERT INTO voucher_id VALUES("73","ST","KT");
INSERT INTO voucher_id VALUES("74","ST","KT");
INSERT INTO voucher_id VALUES("75","ST","KT");
INSERT INTO voucher_id VALUES("76","ST","KT");
INSERT INTO voucher_id VALUES("77","ST","KT");
INSERT INTO voucher_id VALUES("78","ST","KT");
INSERT INTO voucher_id VALUES("79","ST","KT");
INSERT INTO voucher_id VALUES("80","ST","KT");
INSERT INTO voucher_id VALUES("81","ST","KT");
INSERT INTO voucher_id VALUES("82","ST","KT");
INSERT INTO voucher_id VALUES("139","SL","KT");
INSERT INTO voucher_id VALUES("233","PL","KT");
INSERT INTO voucher_id VALUES("234","PL","KT");
INSERT INTO voucher_id VALUES("235","PL","KT");
INSERT INTO voucher_id VALUES("236","PL","KT");
INSERT INTO voucher_id VALUES("140","SL","KT");
INSERT INTO voucher_id VALUES("237","PL","KT");
INSERT INTO voucher_id VALUES("141","SL","KT");
INSERT INTO voucher_id VALUES("142","SL","KT");
INSERT INTO voucher_id VALUES("238","PL","KT");
INSERT INTO voucher_id VALUES("83","ST","KT");
INSERT INTO voucher_id VALUES("132","CP","KT");
INSERT INTO voucher_id VALUES("133","CP","KT");
INSERT INTO voucher_id VALUES("134","CP","KT");
INSERT INTO voucher_id VALUES("135","CP","KT");
INSERT INTO voucher_id VALUES("239","PL","KT");
INSERT INTO voucher_id VALUES("240","PL","KT");
INSERT INTO voucher_id VALUES("241","PL","KT");
INSERT INTO voucher_id VALUES("242","PL","KT");
INSERT INTO voucher_id VALUES("243","PL","KT");
INSERT INTO voucher_id VALUES("244","PL","KT");
INSERT INTO voucher_id VALUES("245","PL","KT");
INSERT INTO voucher_id VALUES("246","PL","KT");
INSERT INTO voucher_id VALUES("143","SL","KT");
INSERT INTO voucher_id VALUES("144","SL","KT");
INSERT INTO voucher_id VALUES("145","SL","KT");
INSERT INTO voucher_id VALUES("146","SL","KT");
INSERT INTO voucher_id VALUES("147","SL","KT");
INSERT INTO voucher_id VALUES("148","SL","KT");
INSERT INTO voucher_id VALUES("149","SL","KT");
INSERT INTO voucher_id VALUES("150","SL","KT");
INSERT INTO voucher_id VALUES("151","SL","KT");
INSERT INTO voucher_id VALUES("152","SL","KT");
INSERT INTO voucher_id VALUES("153","SL","KT");
INSERT INTO voucher_id VALUES("154","SL","KT");
INSERT INTO voucher_id VALUES("155","SL","KT");
INSERT INTO voucher_id VALUES("84","ST","KT");
INSERT INTO voucher_id VALUES("247","PL","KT");
INSERT INTO voucher_id VALUES("248","PL","KT");
INSERT INTO voucher_id VALUES("85","ST","KT");
INSERT INTO voucher_id VALUES("249","PL","KT");
INSERT INTO voucher_id VALUES("250","PL","KT");
INSERT INTO voucher_id VALUES("251","PL","KT");
INSERT INTO voucher_id VALUES("252","PL","KT");
INSERT INTO voucher_id VALUES("253","PL","KT");
INSERT INTO voucher_id VALUES("86","ST","KT");
INSERT INTO voucher_id VALUES("254","PL","KT");
INSERT INTO voucher_id VALUES("255","PL","KT");
INSERT INTO voucher_id VALUES("156","SL","KT");
INSERT INTO voucher_id VALUES("157","SL","KT");
INSERT INTO voucher_id VALUES("158","SL","KT");
INSERT INTO voucher_id VALUES("159","SL","KT");
INSERT INTO voucher_id VALUES("256","PL","KT");
INSERT INTO voucher_id VALUES("257","PL","KT");
INSERT INTO voucher_id VALUES("258","PL","KT");
INSERT INTO voucher_id VALUES("87","ST","KT");
INSERT INTO voucher_id VALUES("160","SL","KT");
INSERT INTO voucher_id VALUES("1","CP","IT");
INSERT INTO voucher_id VALUES("1","ST","IT");
INSERT INTO voucher_id VALUES("2","ST","IT");
INSERT INTO voucher_id VALUES("1","BP","IT");
INSERT INTO voucher_id VALUES("3","SL","IT");
INSERT INTO voucher_id VALUES("1","","IT");
INSERT INTO voucher_id VALUES("1","PL","IT");
INSERT INTO voucher_id VALUES("4","SL","IT");
INSERT INTO voucher_id VALUES("2","PL","IT");
INSERT INTO voucher_id VALUES("5","SL","IT");
INSERT INTO voucher_id VALUES("3","ST","IT");
INSERT INTO voucher_id VALUES("4","ST","IT");
INSERT INTO voucher_id VALUES("5","ST","IT");
INSERT INTO voucher_id VALUES("6","SL","IT");
INSERT INTO voucher_id VALUES("88","ST","KT");
INSERT INTO voucher_id VALUES("1","CR","KT");
INSERT INTO voucher_id VALUES("2","CR","KT");
INSERT INTO voucher_id VALUES("89","ST","KT");
INSERT INTO voucher_id VALUES("90","ST","KT");
INSERT INTO voucher_id VALUES("91","ST","KT");
INSERT INTO voucher_id VALUES("3","CR"