CREATE VIEW `v_cost_centre` AS select `nom`.`ACCT_ID` AS `acct_id`,`nom`.`ACCT_NAME` AS `acct_name` from `nom` where ((substr(`nom`.`ACCT_ID`,1,2) = '99') and (length(`nom`.`ACCT_ID`) = 10));

CREATE VIEW `v_stk` AS select 1 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,if((isnull(`m`.`bill_date`) or (`m`.`bill_date` = '1970-01-01')),`m`.`voucher_date`,`m`.`bill_date`) AS `bill_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select 2 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,(`d`.`qty` * `d`.`avg_rate`) AS `cr_amt` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select 3.1 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select 3.2 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`)));

CREATE VIEW `v_current_qty` AS select `v`.`comp_id` AS `comp_id`,`v`.`stock_code` AS `stock_code`,`v`.`db_qty` AS `db_qty`,`v`.`cr_qty` AS `cr_qty`,sum((ifnull(`v`.`db_qty`,0) - ifnull(`v`.`cr_qty`,0))) AS `bal_qty` from `v_stk` `v` where ((1 = 1) and ((`v`.`db_qty` is not null) or (`v`.`cr_qty` is not null))) group by `v`.`comp_id`,`v`.`stock_code`;
CREATE VIEW `v_item` AS select `i`.`stock_code` AS `stock_code`,ifnull(`i`.`party_stock_code`,'') AS `party_stock_code`,concat(`i`.`stock_code`,convert(if((isnull(`i`.`party_stock_code`) or (`i`.`party_stock_code` = '')),'','-') using latin1),ifnull(`i`.`party_stock_code`,'')) AS `item_code`,concat(ifnull(`i`.`party_stock_code`,''),' ',`i`.`description`,' - ',`c`.`CAT_NAME`) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`i`.`cat_id` AS `cat_id` from (`item` `i` left join `prod_cat` `c` on((`i`.`cat_id` = `c`.`CAT_ID`)));
CREATE VIEW `v_nom` AS select `n`.`ACCT_ID` AS `acct_id`,concat(`n`.`ACCT_NAME`,convert(if((ifnull(`n`.`address`,'') = ''),'',', ') using latin1),ifnull(`n`.`address`,''),convert(if((ifnull(`n`.`city`,'') = ''),'',', ') using latin1),ifnull(`n`.`city`,'')) AS `acct_name`,`n`.`reg_id` AS `reg_id` from `nom` `n`;
CREATE VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,(case when ((substr(`n`.`ACCT_ID`,1,6) = `s`.`creditor_id`) or (substr(`n`.`ACCT_ID`,1,10) = '0100010001')) then 'S' when (substr(`n`.`ACCT_ID`,1,6) = `s`.`debtor_id`) then 'C' when (substr(`n`.`ACCT_ID`,1,6) = `s`.`stock_id`) then 'P' else 'O' end) AS `party_type`,`n`.`city` AS `city`,`n`.`reg_id` AS `reg_id`,`n`.`sp_id` AS `sp_id`,`n`.`address` AS `address`,`n`.`phone` AS `phone`,`n`.`cnic` AS `cnic` from (`nom` `n` join `system` `s`) where (((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`,`s`.`stock_id`)) and (length(`n`.`ACCT_ID`) = 10)) or (substr(`n`.`ACCT_ID`,1,10) = '0100010001'));
CREATE VIEW `v_p_vouchers` AS select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,(`d`.`qty` * `d`.`avg_rate`) AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('RT',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,0 AS `db_qty`,0 AS `db_amt`,(`d`.`qty` * `d`.`avg_rate`) AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_return` `m` left join `sl_returndet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`)));
CREATE VIEW `v_voucherdet_pay` AS select 1 AS `voucher_id`,1 AS `lineitem`,1 AS `acct_id`,1 AS `acct_name`;

CREATE VIEW `v_cs_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`voucher_date` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where ((`v`.`POSTED` = 'on') and (ifnull(`v`.`ACCT_ID_CS_1`,'') <> '') and (substr(`vd`.`LINEITEM`,-(1)) <> '.')) union all select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`voucher_date` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`vd`.`ACCT_ID_CS` AS `acct_id_cs`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where ((`v`.`POSTED` = 'on') and (ifnull(`vd`.`ACCT_ID_CS`,'') <> '') and (ifnull(`v`.`ACCT_ID_CS_1`,'') = ''));

CREATE VIEW `v_voucherdet_cs` AS select `m`.`COMP_ID` AS `COMP_ID`,`m`.`YEAR_ID` AS `YEAR_ID`,`m`.`VOUCHER_ID` AS `VOUCHER_ID`,`m`.`LINEITEM` AS `LINEITEM`,`m`.`ACCT_ID` AS `ACCT_ID`,`m`.`debit` AS `DEBIT`,`m`.`credit` AS `CREDIT`,`m`.`PARTICULARS` AS `PARTICULARS`,`d`.`ACCT_ID_CS_1` AS `ACCT_ID_CS` from (`voucher` `d` left join `voucherdet` `m` on(((`d`.`COMP_ID` = `m`.`COMP_ID`) and (`d`.`YEAR_ID` = `m`.`YEAR_ID`) and (`d`.`VOUCHER_ID` = `m`.`VOUCHER_ID`)))) where (ifnull(`d`.`ACCT_ID_CS_1`,'') <> '');
CREATE VIEW `vue_voucher_cs` AS select `v`.`COMP_ID` AS `comp_id`,`v`.`YEAR_ID` AS `year_id`,`v`.`VOUCHER_ID` AS `voucher_id`,`v`.`voucher_date` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`vd`.`PARTICULARS` AS `particulars`,`vd`.`DEBIT` AS `debit`,`vd`.`CREDIT` AS `credit`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs` from (`voucher` `v` left join `v_voucherdet_cs` `vd` on(((`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`) and (`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`)))) where (ifnull(`v`.`ACCT_ID_CS_1`,'') <> '');
CREATE VIEW `v_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`voucher_date` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where (`v`.`POSTED` = 'on');
