/*
Navicat MySQL Data Transfer

Source Server         : mysql
Source Server Version : 50614
Source Host           : localhost:3306
Source Database       : cnlxidtp_click_origa

Target Server Type    : MYSQL
Target Server Version : 50614
File Encoding         : 65001

Date: 2017-12-15 09:08:35
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `acct_type`
-- ----------------------------
DROP TABLE IF EXISTS `acct_type`;
CREATE TABLE `acct_type` (
  `acct_id` varchar(4) NOT NULL,
  `acct_name` varchar(50) NOT NULL,
  `debit_name` varchar(30) NOT NULL,
  `credit_name` varchar(30) NOT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of acct_type
-- ----------------------------

-- ----------------------------
-- Table structure for `am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `am_condet`;
CREATE TABLE `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `announcement`
-- ----------------------------
DROP TABLE IF EXISTS `announcement`;
CREATE TABLE `announcement` (
  `id` int(11) NOT NULL,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of announcement
-- ----------------------------

-- ----------------------------
-- Table structure for `app_mod`
-- ----------------------------
DROP TABLE IF EXISTS `app_mod`;
CREATE TABLE `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_mod
-- ----------------------------
INSERT INTO `app_mod` VALUES ('AC_CP', 'Cash Payment', 'Accounts', '26', '35', '', 'CP');
INSERT INTO `app_mod` VALUES ('AC_BP', 'Bank Payment', 'Accounts', '26', '35', '', 'BP');
INSERT INTO `app_mod` VALUES ('AC_CR', 'Cash Receipt', 'Accounts', '26', '35', '', 'CR');
INSERT INTO `app_mod` VALUES ('AC_BR', 'Bank Receipt', 'Accounts', '26', '35', '', 'BR');
INSERT INTO `app_mod` VALUES ('AC_JV', 'Journal Voucher', 'Accounts', '35', '35', '', 'JV');
INSERT INTO `app_mod` VALUES ('AC_CD', 'Outstanding Clearing Dates', 'Accounts', '223', '0', '', '');
INSERT INTO `app_mod` VALUES ('PL_PO', 'Order', 'Purchases', '226', '53', 't_pl_order', '');
INSERT INTO `app_mod` VALUES ('PL_GP', 'Inward Gate Pass', 'Purchases', '226', '235', 't_pl_gp', '');
INSERT INTO `app_mod` VALUES ('PL_INV', 'Invoice', 'Purchases', '226', '235', 't_pl_invoice', '');
INSERT INTO `app_mod` VALUES ('PL_PAY', 'Payments', 'Purchases', '203', '204', 't_pl_pay', '');
INSERT INTO `app_mod` VALUES ('PL_JV', 'JV', 'Purchases', '216', '212', 'pl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_GP', 'Inward Gate Pass', 'Sales', '226', '235', 't_sl_gp', '');
INSERT INTO `app_mod` VALUES ('SL_INV', 'Invoice', 'Sales', '226', '235', 't_sl_invoice', '');
INSERT INTO `app_mod` VALUES ('SL_RTN', 'Return', 'Sales', '226', '235', 't_sl_return', '');
INSERT INTO `app_mod` VALUES ('SL_PAY', 'Payments', 'Sales', '203', '204', 't_sl_pay', '');
INSERT INTO `app_mod` VALUES ('SL_JV', 'JV', 'Sales', '216', '212', 'sl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_OB', 'Outstanding Bilties', 'Sales', '221', '260', '', '');
INSERT INTO `app_mod` VALUES ('STK_PROD', 'Production', 'Stock', '226', '53', 't_stk_con', 'Y');
INSERT INTO `app_mod` VALUES ('STK_CON', 'Consumption', 'Stock', '226', '235', 't_stk_con', 'N');
INSERT INTO `app_mod` VALUES ('MF_NOM', 'Chart of Accounts', 'Master Files', '164', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_PARTY', 'Parties', 'Master Files', '66', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_ITEM', 'Items', 'Master Files', '64', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_UNIT', 'Units', 'Master Files', '106', '0', '', '');
INSERT INTO `app_mod` VALUES ('IM_BOE', 'Bill of Entry', 'Imports', '226', '235', 't_im_boe', '');

-- ----------------------------
-- Table structure for `app_rep`
-- ----------------------------
DROP TABLE IF EXISTS `app_rep`;
CREATE TABLE `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_rep
-- ----------------------------
INSERT INTO `app_rep` VALUES ('AC_10', 'Daybook', 'Accounts', '144', '');
INSERT INTO `app_rep` VALUES ('AC_20', 'Ledger', 'Accounts', '91', '');
INSERT INTO `app_rep` VALUES ('AC_31', 'Trial - Balance', 'Accounts', '163', '');
INSERT INTO `app_rep` VALUES ('AC_32', 'Trial - Control', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_33', 'Trial - Subsidary', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_40', 'Profit & Loss', 'Accounts', '190', '');
INSERT INTO `app_rep` VALUES ('AC_50', 'Profit & Loss (Level 2)', 'Accounts', '191', '');
INSERT INTO `app_rep` VALUES ('PL_10', 'Purchase Daybook', 'Purchases', '187', 'PL');
INSERT INTO `app_rep` VALUES ('PL_20', 'Payment Daybook', 'Purchases', '187', 'PP');
INSERT INTO `app_rep` VALUES ('PL_30', 'Detail Ledger', 'Purchases', '405', 'S');
INSERT INTO `app_rep` VALUES ('PL_40', 'Trial', 'Purchases', '194', 'S');
INSERT INTO `app_rep` VALUES ('PL_50', 'Summary', 'Purchases', '188', 'S');
INSERT INTO `app_rep` VALUES ('SL_10', 'Sale Daybook', 'Sales', '187', 'SL');
INSERT INTO `app_rep` VALUES ('SL_20', 'Sale Receipts', 'Sales', '187', 'SR');
INSERT INTO `app_rep` VALUES ('SL_30', 'Detail Ledger', 'Sales', '405', 'C');
INSERT INTO `app_rep` VALUES ('SL_40', 'Trial', 'Sales', '194', 'C');
INSERT INTO `app_rep` VALUES ('SL_50', 'Summary', 'Sales', '188', 'C');
INSERT INTO `app_rep` VALUES ('SL_60', 'Empty Stock Report', 'Sales', '406', '');
INSERT INTO `app_rep` VALUES ('SL_70', 'Empty Stock Report Rate Wise', 'Sales', '407', '');
INSERT INTO `app_rep` VALUES ('SL_80', 'Outstanding Bills', 'Sales', '189', '');
INSERT INTO `app_rep` VALUES ('SL_90', 'SPO Outstanding', 'Sales', '195', '');
INSERT INTO `app_rep` VALUES ('STK_10', 'Ledger', 'Stocks', '401', '');
INSERT INTO `app_rep` VALUES ('STK_20', 'Summary', 'Stocks', '402', '');
INSERT INTO `app_rep` VALUES ('STK_30', 'Summary - Value', 'Stocks', '403', '');

-- ----------------------------
-- Table structure for `backup_sl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `backup_sl_invoice`;
CREATE TABLE `backup_sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of backup_sl_invoice
-- ----------------------------
INSERT INTO `backup_sl_invoice` VALUES ('080001', '2017-08-01', '2610000004', '0.00', '0.00', '11500.00', null, null, null, null, null, null, '7729-UGS17', null, null, null, null, null, '01', null, '2017-08-17 14:58:15', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', '', '', '0', '0', '', '', '', '', '11500');
INSERT INTO `backup_sl_invoice` VALUES ('080002', '2017-08-01', '2610000004', '0.00', '0.00', '4800.00', null, null, null, null, null, null, '7730 XP70L', null, null, null, null, null, '01', null, '2017-08-17 15:20:23', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', '', '', '0', '0', '', '', '', '', '4800');
INSERT INTO `backup_sl_invoice` VALUES ('080003', '2017-08-01', '2610000004', '0.00', '0.00', '11300.00', null, null, null, null, null, null, '7731 GX165', null, null, null, null, null, '01', null, '2017-08-17 20:40:25', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', 'JASIM BAIG', '03233333669', '0', '0', '', '', '', '', '11300');
INSERT INTO `backup_sl_invoice` VALUES ('080004', '2017-08-02', '2610000148', '0.00', '0.00', '1100.00', null, null, null, null, null, null, '7732', null, null, null, null, null, '01', null, '2017-08-17 20:44:54', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', 'UPS REP', '03214079909', '0', '0', '', '', '', '', '1100');
INSERT INTO `backup_sl_invoice` VALUES ('080005', '2017-08-02', '2610000093', '0.00', '0.00', '66000.00', null, null, null, null, null, null, '7733 GX200', null, null, null, null, null, '01', null, '2017-08-18 12:28:58', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', 'DR EJAZ', '03454079717', '0', '0', '', '', '', '', '66000');
INSERT INTO `backup_sl_invoice` VALUES ('51', '2017-08-02', '1310000010', '0.00', '0.00', '28000.00', null, null, null, null, null, null, '7733 SCP', null, null, null, null, null, '01', null, '2017-08-19 16:08:11', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', 'DR EJAZ', '', '0', '0', '', '', '', '', '28000');

-- ----------------------------
-- Table structure for `backup_sl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `backup_sl_invoicedet`;
CREATE TABLE `backup_sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of backup_sl_invoicedet
-- ----------------------------
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '10', '0183', '', '2.000', '4500.00000', '9000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '11', '0208', '', '1.000', '8000.00000', '8000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '12', '0209', '', '2.000', '2800.00000', '5600.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '13', '0100', '', '1.000', '9500.00000', '9500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '14', '0175', '', '2.000', '9500.00000', '19000.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '15', '0113', '', '11.000', '13500.00000', '148500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080009', '16', '0114', '', '21.000', '10500.00000', '220500.00', '', null, null, '0', null, null, null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080001', '1', '0049', '', '1.000', '11500.00000', '11500.00', '', null, null, '0', null, '10841.670', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080002', '1', '0233', '', '1.000', '4800.00000', '4800.00', '', null, null, '0', null, '4600.000', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080005', '1', '0024', '', '4.000', '16500.00000', '66000.00', '', null, null, '0', null, '15750.000', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080004', '1', '0132', '', '1.000', '800.00000', '800.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080003', '1', '0020', '', '1.000', '11300.00000', '11300.00', '', null, null, '0', null, '10950.000', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('080004', '2', '0093', '', '1.000', '300.00000', '300.00', '', null, null, '0', null, '0.000', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');
INSERT INTO `backup_sl_invoicedet` VALUES ('51', '1', '0131', '', '8.000', '3500.00000', '28000.00', '', null, null, '0', null, '2700.000', null, '0.00', null, null, null, null, '01', '17', '0.000', null, '0', '0', '0', '', '');

-- ----------------------------
-- Table structure for `bill_type`
-- ----------------------------
DROP TABLE IF EXISTS `bill_type`;
CREATE TABLE `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of bill_type
-- ----------------------------
INSERT INTO `bill_type` VALUES ('0001', 'Normal', null);
INSERT INTO `bill_type` VALUES ('0002', 'Exchange', null);
INSERT INTO `bill_type` VALUES ('0003', 'VIP', null);
INSERT INTO `bill_type` VALUES ('0004', 'Sale Return', null);

-- ----------------------------
-- Table structure for `brands`
-- ----------------------------
DROP TABLE IF EXISTS `brands`;
CREATE TABLE `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of brands
-- ----------------------------
INSERT INTO `brands` VALUES ('0001', 'APC');
INSERT INTO `brands` VALUES ('0002', 'MGE UPS Systems');
INSERT INTO `brands` VALUES ('0003', 'Stulz Air Conditioning');
INSERT INTO `brands` VALUES ('0004', 'Bergvik Flooring');
INSERT INTO `brands` VALUES ('0005', 'APC / MGE UPS Systems');
INSERT INTO `brands` VALUES ('0006', 'APC / MGE');

-- ----------------------------
-- Table structure for `city`
-- ----------------------------
DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
  `CITY_ID` varchar(4) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of city
-- ----------------------------
INSERT INTO `city` VALUES ('0001', 'Quetta.', null);
INSERT INTO `city` VALUES ('0002', ' Mian Channu.', null);
INSERT INTO `city` VALUES ('0003', 'Lahore.', null);
INSERT INTO `city` VALUES ('0004', 'Merdan.', null);
INSERT INTO `city` VALUES ('0005', 'Rawala Kot.', null);
INSERT INTO `city` VALUES ('0006', 'Sher Shah Lahore.', null);
INSERT INTO `city` VALUES ('0007', 'Mochi Pura Lahore.', null);
INSERT INTO `city` VALUES ('0008', 'D.G.Khan.', null);
INSERT INTO `city` VALUES ('0009', 'Sadiq Abad.', null);
INSERT INTO `city` VALUES ('0010', 'Khan Pur.', null);
INSERT INTO `city` VALUES ('0011', 'Karachi.', null);
INSERT INTO `city` VALUES ('0012', 'Hyderabad.', null);
INSERT INTO `city` VALUES ('0013', 'Sargodha.', null);
INSERT INTO `city` VALUES ('0014', 'Daska.', null);
INSERT INTO `city` VALUES ('0015', 'Gujrat.', null);
INSERT INTO `city` VALUES ('0016', 'Kasur.', null);
INSERT INTO `city` VALUES ('0017', 'Khuddian.', null);
INSERT INTO `city` VALUES ('0018', 'Lala Musa.', null);
INSERT INTO `city` VALUES ('0019', 'Shekhupura. ', null);
INSERT INTO `city` VALUES ('0020', 'Jehlum.', null);
INSERT INTO `city` VALUES ('0021', 'Bhalwal', null);
INSERT INTO `city` VALUES ('0022', 'Sadhoki (Kamonki)', null);
INSERT INTO `city` VALUES ('0023', 'Kamonki', null);
INSERT INTO `city` VALUES ('0024', 'Khanqah Dogran', null);
INSERT INTO `city` VALUES ('0025', 'Sharq Pur', null);
INSERT INTO `city` VALUES ('0026', 'Sialkot', null);
INSERT INTO `city` VALUES ('0027', 'Rai Wind', null);
INSERT INTO `city` VALUES ('0028', 'Pattoki.', null);
INSERT INTO `city` VALUES ('0029', 'Mureed Key', null);
INSERT INTO `city` VALUES ('0030', 'Deenga.', null);
INSERT INTO `city` VALUES ('0031', 'Frooq Abad', null);
INSERT INTO `city` VALUES ('0032', 'Narang Mandi', null);
INSERT INTO `city` VALUES ('0033', 'Ajmal Narang Mandi', null);
INSERT INTO `city` VALUES ('0034', 'Gujranwala.', null);
INSERT INTO `city` VALUES ('0035', 'Samberyal.', null);
INSERT INTO `city` VALUES ('0036', 'Kotla Arab Ali Khan.', null);
INSERT INTO `city` VALUES ('0037', 'Phool Nagar.', null);
INSERT INTO `city` VALUES ('0038', ' Nankana Sahib.', null);
INSERT INTO `city` VALUES ('0039', 'Talwandi Bhandran.', null);
INSERT INTO `city` VALUES ('0040', 'Uggoki.', null);
INSERT INTO `city` VALUES ('0041', 'Hafiz Abaz.', null);
INSERT INTO `city` VALUES ('0042', 'Mano Chak..', null);
INSERT INTO `city` VALUES ('0043', 'Multan.', null);
INSERT INTO `city` VALUES ('0044', 'Chishtian.', null);
INSERT INTO `city` VALUES ('0045', 'Baseer Pur.', null);
INSERT INTO `city` VALUES ('0046', 'Minchan Abad.', null);
INSERT INTO `city` VALUES ('0047', 'Bahawal Nagar.', null);
INSERT INTO `city` VALUES ('0048', 'Pak Pattan.', null);
INSERT INTO `city` VALUES ('0049', 'Choonian.', null);
INSERT INTO `city` VALUES ('0050', 'Milhen Choonian', null);
INSERT INTO `city` VALUES ('0051', 'Depal Pur.', null);
INSERT INTO `city` VALUES ('0052', 'Havely Lakha.', null);
INSERT INTO `city` VALUES ('0053', 'Vehari.', null);
INSERT INTO `city` VALUES ('0054', 'Kamalia.', null);
INSERT INTO `city` VALUES ('0055', 'Bunga Hayat.', null);
INSERT INTO `city` VALUES ('0056', 'Sahiwal.', null);
INSERT INTO `city` VALUES ('0057', 'Bure Wala.', null);
INSERT INTO `city` VALUES ('0058', 'Mian Channu.', null);
INSERT INTO `city` VALUES ('0059', 'Hasil Pur.', null);
INSERT INTO `city` VALUES ('0060', 'Saad Okara ', null);
INSERT INTO `city` VALUES ('0061', 'Arif Wala.', null);
INSERT INTO `city` VALUES ('0062', 'Theeng Moor', null);
INSERT INTO `city` VALUES ('0063', 'Renala Khurd', null);
INSERT INTO `city` VALUES ('0064', 'Ghotki (Sukkhar)', null);

-- ----------------------------
-- Table structure for `closing_dates`
-- ----------------------------
DROP TABLE IF EXISTS `closing_dates`;
CREATE TABLE `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of closing_dates
-- ----------------------------
INSERT INTO `closing_dates` VALUES ('BP', '2003-12-31 00:00:00');

-- ----------------------------
-- Table structure for `code_cat`
-- ----------------------------
DROP TABLE IF EXISTS `code_cat`;
CREATE TABLE `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_cat
-- ----------------------------
INSERT INTO `code_cat` VALUES ('00', 'KURTA');
INSERT INTO `code_cat` VALUES ('01', 'SHALWAR');
INSERT INTO `code_cat` VALUES ('02', 'TROUSER');
INSERT INTO `code_cat` VALUES ('03', 'KHUSSA\r\n');
INSERT INTO `code_cat` VALUES ('04', 'WAIST COAT\r\n');
INSERT INTO `code_cat` VALUES ('05', 'NIGHT SUIT');
INSERT INTO `code_cat` VALUES ('06', 'FULL SUIT');
INSERT INTO `code_cat` VALUES ('07', 'COAT');
INSERT INTO `code_cat` VALUES ('08', 'FOOTWEAR\r\n');
INSERT INTO `code_cat` VALUES ('09', 'SHIRT\r\n');
INSERT INTO `code_cat` VALUES ('10', 'SHERWANI\r\n');
INSERT INTO `code_cat` VALUES ('11', 'TURBON\r\n');
INSERT INTO `code_cat` VALUES ('12', 'SUITING\r\n');
INSERT INTO `code_cat` VALUES ('13', 'CAP');
INSERT INTO `code_cat` VALUES ('14', 'ACCESSORIES');
INSERT INTO `code_cat` VALUES ('15', 'SHAWL');

-- ----------------------------
-- Table structure for `code_collection`
-- ----------------------------
DROP TABLE IF EXISTS `code_collection`;
CREATE TABLE `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_collection
-- ----------------------------
INSERT INTO `code_collection` VALUES ('SK', 'MEN');
INSERT INTO `code_collection` VALUES ('SG', 'GOLD');
INSERT INTO `code_collection` VALUES ('SD', 'DESIGNER\r\n');

-- ----------------------------
-- Table structure for `color`
-- ----------------------------
DROP TABLE IF EXISTS `color`;
CREATE TABLE `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of color
-- ----------------------------
INSERT INTO `color` VALUES ('PU', 'PURPLE');
INSERT INTO `color` VALUES ('OW', 'OFF WHITE');
INSERT INTO `color` VALUES ('BL', 'BLACK');
INSERT INTO `color` VALUES ('SN', 'SKIN');
INSERT INTO `color` VALUES ('GO', 'GOLDEN');
INSERT INTO `color` VALUES ('BR', 'BROWN');
INSERT INTO `color` VALUES ('MD', 'MUD');
INSERT INTO `color` VALUES ('SG', 'SEA GREEN');
INSERT INTO `color` VALUES ('MR', 'MAROON');
INSERT INTO `color` VALUES ('MV', 'MOUVE');
INSERT INTO `color` VALUES ('GR', 'GREEN');
INSERT INTO `color` VALUES ('MU', 'MUSTARD');
INSERT INTO `color` VALUES ('WH', 'WHITE');
INSERT INTO `color` VALUES ('GY', 'GREY');
INSERT INTO `color` VALUES ('DG', 'DARK GREEN');
INSERT INTO `color` VALUES ('LG', 'LIGHT GREEN');
INSERT INTO `color` VALUES ('BU', 'BLUE');
INSERT INTO `color` VALUES ('GB', 'GREEN BLUE');
INSERT INTO `color` VALUES ('OR', 'ORANGE');
INSERT INTO `color` VALUES ('PH', 'PEACH');
INSERT INTO `color` VALUES ('RS', 'RUST');
INSERT INTO `color` VALUES ('DB', 'DARK BLUE');
INSERT INTO `color` VALUES ('LY', 'LIGHT GREY');
INSERT INTO `color` VALUES ('SB', 'SKY BLUE');
INSERT INTO `color` VALUES ('FN', 'FORN');
INSERT INTO `color` VALUES ('CB', 'CHOCOLATE BROWN');
INSERT INTO `color` VALUES ('NB', 'NAVY BLUE');
INSERT INTO `color` VALUES ('YB', 'GREY BLACK');
INSERT INTO `color` VALUES ('GS', 'GREY SHINING');
INSERT INTO `color` VALUES ('FR', 'FEROOZI');
INSERT INTO `color` VALUES ('RD', 'RED');
INSERT INTO `color` VALUES ('LR', 'LIGHT BROWN');
INSERT INTO `color` VALUES ('LB', 'LIGHT BLUE');
INSERT INTO `color` VALUES ('CM', 'CAMEL');
INSERT INTO `color` VALUES ('CH', 'CHOCOLATE');
INSERT INTO `color` VALUES ('BG', 'BLACK GREY');
INSERT INTO `color` VALUES ('AR', 'ARMY');
INSERT INTO `color` VALUES ('MT', 'MULTI COLOUR');

-- ----------------------------
-- Table structure for `company`
-- ----------------------------
DROP TABLE IF EXISTS `company`;
CREATE TABLE `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of company
-- ----------------------------
INSERT INTO `company` VALUES ('01', 'Origa Chemicals', 'New Airport Road Opp; Bata Shoes Gulshan Ali Colony Lahore Cantt', 'M.Rashad-03213888834', '', '', '03004005471', '', '', 'Y', '0600030001', '', '', '', null, 'BK', 'UGX', null, null, '2210000001', '3010000001', '0700010001', null, '0100011000', 'A', '401', 'N', '', '0600030001', '0700020001', '0700030001', null, null);
INSERT INTO `company` VALUES ('02', 'Welcome Industries', 'House #: 5. Street #: 1 Muhammad Pura Model Town Link Road Lahore.  54770', '0092-42-35943143.Fax #: 0092-42-35943143.Mobile # 0321-4199945', null, null, null, null, null, 'Y', null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, '', null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `container_size`
-- ----------------------------
DROP TABLE IF EXISTS `container_size`;
CREATE TABLE `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of container_size
-- ----------------------------
INSERT INTO `container_size` VALUES ('0001', '16 Feet');
INSERT INTO `container_size` VALUES ('0002', '20 Feet');
INSERT INTO `container_size` VALUES ('0003', '22 Feet');
INSERT INTO `container_size` VALUES ('0004', '24 Feet');
INSERT INTO `container_size` VALUES ('0005', '40 Feet');
INSERT INTO `container_size` VALUES ('0006', '50 Feet');

-- ----------------------------
-- Table structure for `currency`
-- ----------------------------
DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of currency
-- ----------------------------
INSERT INTO `currency` VALUES ('PK', 'PKR');

-- ----------------------------
-- Table structure for `dc_type`
-- ----------------------------
DROP TABLE IF EXISTS `dc_type`;
CREATE TABLE `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of dc_type
-- ----------------------------
INSERT INTO `dc_type` VALUES ('01', 'Sale');

-- ----------------------------
-- Table structure for `discount`
-- ----------------------------
DROP TABLE IF EXISTS `discount`;
CREATE TABLE `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_percentage`
-- ----------------------------
DROP TABLE IF EXISTS `discount_percentage`;
CREATE TABLE `discount_percentage` (
  `id` int(11) NOT NULL,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_percentage
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `discount_voucher`;
CREATE TABLE `discount_voucher` (
  `id` int(11) NOT NULL,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `division`
-- ----------------------------
DROP TABLE IF EXISTS `division`;
CREATE TABLE `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of division
-- ----------------------------
INSERT INTO `division` VALUES ('10', 'TEXTILE');

-- ----------------------------
-- Table structure for `expense`
-- ----------------------------
DROP TABLE IF EXISTS `expense`;
CREATE TABLE `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of expense
-- ----------------------------
INSERT INTO `expense` VALUES ('01', 'L/C EXPENSES');

-- ----------------------------
-- Table structure for `fin_years`
-- ----------------------------
DROP TABLE IF EXISTS `fin_years`;
CREATE TABLE `fin_years` (
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  PRIMARY KEY (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of fin_years
-- ----------------------------
INSERT INTO `fin_years` VALUES ('17', '2017', '2017-01-01', '2017-06-30');

-- ----------------------------
-- Table structure for `grn`
-- ----------------------------
DROP TABLE IF EXISTS `grn`;
CREATE TABLE `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn
-- ----------------------------

-- ----------------------------
-- Table structure for `grndet`
-- ----------------------------
DROP TABLE IF EXISTS `grndet`;
CREATE TABLE `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_return`
-- ----------------------------
DROP TABLE IF EXISTS `grn_return`;
CREATE TABLE `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_return
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `grn_returndet`;
CREATE TABLE `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boe`
-- ----------------------------
DROP TABLE IF EXISTS `im_boe`;
CREATE TABLE `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boe
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boedet`
-- ----------------------------
DROP TABLE IF EXISTS `im_boedet`;
CREATE TABLE `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boedet
-- ----------------------------

-- ----------------------------
-- Table structure for `invoice_no`
-- ----------------------------
DROP TABLE IF EXISTS `invoice_no`;
CREATE TABLE `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of invoice_no
-- ----------------------------
INSERT INTO `invoice_no` VALUES ('1', 'SL', '06');
INSERT INTO `invoice_no` VALUES ('2', 'SL', '06');

-- ----------------------------
-- Table structure for `item`
-- ----------------------------
DROP TABLE IF EXISTS `item`;
CREATE TABLE `item` (
  `id` int(11) NOT NULL,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  `brand_id` varchar(6) DEFAULT NULL,
  `product_code` varchar(30) DEFAULT NULL,
  `CatagoryID` int(11) DEFAULT NULL,
  `CategoryID` int(11) DEFAULT NULL,
  `part_no` varchar(100) DEFAULT NULL,
  `party_stock_code` varchar(30) DEFAULT NULL,
  `pack_size` varchar(30) DEFAULT NULL,
  `trade_price` decimal(15,2) DEFAULT NULL,
  `scheme` varchar(30) DEFAULT NULL,
  `add_discp` decimal(6,3) DEFAULT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`),
  KEY `item_fk_brand_id` (`brand_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item
-- ----------------------------
INSERT INTO `item` VALUES ('0', '0001', 'Peach Bleach Sachet', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0002', 'HRL Rose Jar 120 ml', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0003', 'HRL Lemon Jar 120 ml', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '450.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0004', 'HRL Alove Jar 120 ml', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0005', 'HRL Alove Jar 80 ml', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0006', 'HRL Rose Jar 80 ml', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0007', 'HRL Lemon Jar 80 ml', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0008', 'Hair Color Rs 10', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0009', 'Hair Color Rs 12', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0010', 'Navia Bleach  576', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0011', 'Navia Bleach  672', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '150.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0012', 'Alove Bleach Sache', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0013', 'HRL Sache  Lemon 576', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0014', 'HRL Sache  Lemon 620', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0015', 'HRL Sache  Lemon 720', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0016', 'HRL Sache  Rose 576', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0017', 'HRL Sache  Rose 672', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0018', 'HRL Sache  Rose 720', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0019', 'HRL Sache  Alove576', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0020', 'HRL Sache  Alove672', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0021', 'HRL Sache  Alove720', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0022', 'Navia HR Rose 576', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0023', 'Navia HR Rose 672', null, null, null, null, null, null, null, '04', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0024', 'Fast Fishal ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0025', 'Peach Bleach Sache', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0026', 'Beauty Cream', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0027', 'Bleach Cream Sache', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0028', 'Fast Wax', null, null, null, null, null, null, null, '01', '60.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '50.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0029', 'Parlor Pak', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0030', 'Deco Whietning', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '200.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0031', 'Deco Clinzar', null, null, null, null, null, null, null, '01', '100.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0032', 'Deco Anti Hair Fall', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '500.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0033', 'HR Rose Jar 120 ml', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '150.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0034', 'HR Rose Jar 80 ml', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0035', 'Beauty cream', null, null, null, null, null, null, null, '02', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0036', 'Fast Ficial', null, null, null, null, null, null, null, '02', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0037', 'Alove Bleach Sache', null, null, null, null, null, null, null, '03', '100.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '90.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0038', 'HRL Sache  Lemon 576', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0039', 'HRL Sache  Lemon 620', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0040', 'HRL Sache  Lemon 720', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0041', 'HRL Sache  Rose 576', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0042', 'HRL Sache  Rose 672', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0043', 'HRL Sache  Rose 720', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0044', 'HRL Sache  Alove576', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0045', 'HRL Sache  Alove672', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0046', 'HRL Sache  Alove720', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0047', 'Navia HR Rose 576', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0048', 'Navia HR Rose 672', null, null, null, null, null, null, null, '03', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0049', 'HR Sache Rose', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0050', 'Bleach Haldi Chandan  ', null, null, null, null, null, null, null, '01', null, '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, null, null, null, null);
INSERT INTO `item` VALUES ('0', '0051', 'Welcome Whitening Cream.', null, null, null, null, null, null, null, '01', '230.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '144 Pcs.', '22440.00', '12+2', '0.020');
INSERT INTO `item` VALUES ('0', '0052', 'Welcome Deeco Whitening Serum.', null, null, null, null, null, null, null, '01', '120.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '144 Pcs.', '10368.00', '12+1', '0.020');
INSERT INTO `item` VALUES ('0', '0053', 'Welcome Deeco Face Cleanser Serum.', null, null, null, null, null, null, null, '01', '120.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '144 Pcs.', '10368.00', '12+1', '0.020');
INSERT INTO `item` VALUES ('0', '0054', 'Welcome Deeco Anti Hair Fall Serum.', null, null, null, null, null, null, null, '01', '120.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '144 Pcs.', '10368.00', '12+1', '0.020');
INSERT INTO `item` VALUES ('0', '0055', 'Welcome Fast Facial Jar.', null, null, null, null, null, null, null, '01', '0.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '96 Jar.', '0.00', '12+2', '0.020');
INSERT INTO `item` VALUES ('0', '0056', 'Welcome Fast Facial (Sachet)', null, null, null, null, null, null, null, '01', '30.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '576 Pcs.', '10080.00', '12+1', '0.020');
INSERT INTO `item` VALUES ('0', '0057', 'Welcome Fast Wax Jar', null, null, null, null, null, null, null, '01', '0.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '96 Jar.', '7360.00', '12+2', '0.020');
INSERT INTO `item` VALUES ('0', '0058', 'Welcome Peach Bleach Parlor Pack', null, null, null, null, null, null, null, '01', '425.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '12 Pcs.', '4320.00', '0', '0.020');
INSERT INTO `item` VALUES ('0', '0059', 'Welcome Bleach Cream (Sachet)', null, null, null, null, null, null, null, '01', '10.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '576 Pcs.', '4032.00', '0', '0.020');
INSERT INTO `item` VALUES ('0', '0060', 'Welcome Haldi Chandan (Sachet)', null, null, null, null, null, null, null, '01', '10.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '672Pcs.', '4704.00', '0', '0.020');
INSERT INTO `item` VALUES ('0', '0061', 'Welcome Lovely  Cream (Sachet)', null, null, null, null, null, null, null, '01', '10.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '1296 Pcs.', '9072.00', '0', '0.020');
INSERT INTO `item` VALUES ('0', '0062', 'Welcome Blakee Hair Color (45)Black.', null, null, null, null, null, null, null, '01', '25.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '192 Pcs.', '2678.00', '0', '0.020');
INSERT INTO `item` VALUES ('0', '0063', 'Welcome Blakee Hair Color (43)Brown.', null, null, null, null, null, null, null, '01', '25.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '192 Pcs.', '2678.00', '0', '0.020');
INSERT INTO `item` VALUES ('0', '0064', 'Welcome Hair/R Lotion (L) 120g.', null, null, null, null, null, null, null, '01', '120.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '72 Pcs.', '7200.00', '12+12', '0.020');
INSERT INTO `item` VALUES ('0', '0065', 'Welcome Hair/R Lotion (R) 120g.', null, null, null, null, null, null, null, '01', '120.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '72 Pcs.', '7200.00', '12+12', '0.020');
INSERT INTO `item` VALUES ('0', '0066', 'Welcome Hair/R Lotion (A) 120g.', null, null, null, null, null, null, null, '01', '120.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '72 Pcs.', '7200.00', '12+12', '0.020');
INSERT INTO `item` VALUES ('0', '0067', 'Welcome Hair/R Lotion (L) 80g.', null, null, null, null, null, null, null, '01', '80.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '96 Pcs.', '7168.00', '12+12', '0.020');
INSERT INTO `item` VALUES ('0', '0068', 'Welcome Hair/R Lotion (R) 80g.', null, null, null, null, null, null, null, '01', '80.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '96 Pcs.', '7168.00', '12+12', '0.020');
INSERT INTO `item` VALUES ('0', '0069', 'Welcome Hair/R Lotion (A) 80g.', null, null, null, null, null, null, null, '01', '80.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '96 Pcs.', '7168.00', '12+12', '0.020');
INSERT INTO `item` VALUES ('0', '0070', 'Welcome Hair Remover (Sachet)', null, null, null, null, null, null, null, '01', '10.00', '', null, null, null, null, null, '0.150', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00', null, null, null, null, null, null, '672 Pcs.', '4032.00', '0', '0.020');

-- ----------------------------
-- Table structure for `item_description`
-- ----------------------------
DROP TABLE IF EXISTS `item_description`;
CREATE TABLE `item_description` (
  `id` int(6) NOT NULL,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item_description
-- ----------------------------

-- ----------------------------
-- Table structure for `location`
-- ----------------------------
DROP TABLE IF EXISTS `location`;
CREATE TABLE `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  `comp_id` varchar(2) NOT NULL,
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of location
-- ----------------------------
INSERT INTO `location` VALUES ('01', 'Main Store', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on', '01');

-- ----------------------------
-- Table structure for `locations`
-- ----------------------------
DROP TABLE IF EXISTS `locations`;
CREATE TABLE `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of locations
-- ----------------------------
INSERT INTO `locations` VALUES ('01', 'Main Store');

-- ----------------------------
-- Table structure for `lots`
-- ----------------------------
DROP TABLE IF EXISTS `lots`;
CREATE TABLE `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of lots
-- ----------------------------

-- ----------------------------
-- Table structure for `menu`
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL,
  `menu_detail` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES ('1', 'Sale', null, null);
INSERT INTO `menu` VALUES ('1.1', 'Invoice', null, null);
INSERT INTO `menu` VALUES ('1.2', 'Order', null, null);
INSERT INTO `menu` VALUES ('1.3', 'Sale Delivery Challan', null, null);
INSERT INTO `menu` VALUES ('1.4', 'Outword Gate pass', null, null);
INSERT INTO `menu` VALUES ('1.5', 'Receipts', null, null);
INSERT INTO `menu` VALUES ('1.6', 'Journal', null, null);
INSERT INTO `menu` VALUES ('1.7', 'Sale Invoice', null, null);
INSERT INTO `menu` VALUES ('2', 'Purchase', null, null);
INSERT INTO `menu` VALUES ('2.1', 'Invoice', null, null);
INSERT INTO `menu` VALUES ('2.2', 'Order', null, null);
INSERT INTO `menu` VALUES ('2.3', 'Inward Gate pass', null, null);
INSERT INTO `menu` VALUES ('2.4', 'Payments', null, null);
INSERT INTO `menu` VALUES ('2.5', 'Journal', null, null);
INSERT INTO `menu` VALUES ('3', 'Accounts', null, null);
INSERT INTO `menu` VALUES ('3.1', 'Payments', null, null);
INSERT INTO `menu` VALUES ('3.2', 'Journal Voucher', null, null);
INSERT INTO `menu` VALUES ('4', 'Stock', null, null);
INSERT INTO `menu` VALUES ('4.1', 'Production', null, null);
INSERT INTO `menu` VALUES ('4.2', 'Consumption', null, null);
INSERT INTO `menu` VALUES ('5', 'Master File', null, null);
INSERT INTO `menu` VALUES ('5.1', 'Items', null, null);
INSERT INTO `menu` VALUES ('5.2', 'Chart Of Accounts', null, null);
INSERT INTO `menu` VALUES ('5.5', 'Category', null, null);
INSERT INTO `menu` VALUES ('6', 'Reports Summary', null, null);
INSERT INTO `menu` VALUES ('6.1', 'Sale Summary', null, null);
INSERT INTO `menu` VALUES ('6.2', 'Stock Summary', null, null);
INSERT INTO `menu` VALUES ('6.3', 'Outword Gate pass Summary', null, null);
INSERT INTO `menu` VALUES ('6.4', 'Sale Order Summary', null, null);
INSERT INTO `menu` VALUES ('6.5', 'Purchase Summary', null, null);
INSERT INTO `menu` VALUES ('6.6', 'Purchase Order Summary', null, null);
INSERT INTO `menu` VALUES ('6.7', 'Purchase InwordGatepass Summary', null, null);
INSERT INTO `menu` VALUES ('7', 'Reports Detail', null, null);
INSERT INTO `menu` VALUES ('7.1', 'Sale Report', null, null);
INSERT INTO `menu` VALUES ('7.2', 'Sale Order', null, null);
INSERT INTO `menu` VALUES ('7.3', 'Outword Gatepass', null, null);
INSERT INTO `menu` VALUES ('7.4', 'WareHouse Stock', null, null);
INSERT INTO `menu` VALUES ('7.5', 'Purchase Invoice', null, null);
INSERT INTO `menu` VALUES ('7.6', 'Inword Gatepass', null, null);
INSERT INTO `menu` VALUES ('7.7', 'Stock Ledger', null, null);
INSERT INTO `menu` VALUES ('8', 'Reports Accounts', null, null);
INSERT INTO `menu` VALUES ('8.1', 'Ledgers', null, null);
INSERT INTO `menu` VALUES ('8.2', 'Day Book', null, null);
INSERT INTO `menu` VALUES ('9', 'Reports', null, null);
INSERT INTO `menu` VALUES ('9.1', 'Sale Report', null, null);
INSERT INTO `menu` VALUES ('9.2', 'Gatepass Outword Report', null, null);
INSERT INTO `menu` VALUES ('9.3', 'Current Stock', null, null);

-- ----------------------------
-- Table structure for `ms_sale`
-- ----------------------------
DROP TABLE IF EXISTS `ms_sale`;
CREATE TABLE `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of ms_sale
-- ----------------------------

-- ----------------------------
-- Table structure for `nom`
-- ----------------------------
DROP TABLE IF EXISTS `nom`;
CREATE TABLE `nom` (
  `acct_id` char(10) NOT NULL,
  `acct_name` char(50) NOT NULL,
  `o_bal` decimal(13,2) DEFAULT NULL,
  `acct_type` varchar(4) DEFAULT NULL,
  `emp_id` varchar(8) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(200) NOT NULL,
  `reg_id` varchar(6) NOT NULL,
  `credit_limit` decimal(10,0) NOT NULL,
  `ntn` varchar(50) NOT NULL,
  `stax_no` varchar(50) NOT NULL,
  `city_id` int(11) DEFAULT NULL,
  `sp_id` varchar(4) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `cash` varchar(1) DEFAULT 'N',
  `bank` varchar(1) DEFAULT 'N',
  `cnic` varchar(13) DEFAULT NULL,
  `page_no` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom
-- ----------------------------
INSERT INTO `nom` VALUES ('01', 'CAPITAL & LIABILITIES', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('010001', 'PAID UP CAPITAL', null, '3101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0100010001', 'Opening Capital', null, '', null, '02', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('010002', 'DRAWINGS', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('010003', 'Investments', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0100030001', 'Investment Account', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('03', 'Current Liabilities', null, '2801', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('030005', 'Credit Cards Payable', null, '2802', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0300050001', 'Credit Cards Receivable', null, '2803', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0300050002', 'Credit Card Payable', null, '2803', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0300050003', 'Bank Alfalh Card', null, '2803', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0300050004', 'Amex Payable', null, '2803', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('031000', 'Other Current Liabilities', null, '2801', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0310000001', 'Wages Payable', null, '2801', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0310000002', 'Retirement Plan Payable', null, '2801', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0310000003', 'Unearned Revenue', null, '2801', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0310000004', 'Interest Payable', null, '2801', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('05', 'Current Assets', null, '1901', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('051000', 'Other Current Assets', null, '1901', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('0510000001', '-Hasan', null, '1901', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('13', 'CREDITORS & OTHER PAYABLES', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('131000', 'TRADE CREDITORS CONTROL A/C', null, '2802', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('1310000001', 'Supplier#1', null, null, null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('19', 'EXPENSED PAYABLE AND ACCRUED', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('191000', 'SALARIES PAYABLE', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('192000', 'Commission Payable', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('20', 'ASSETS', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('201000', 'FIXED ASSETS', null, '1101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('201500', 'Loans & Advances', null, '1901', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('202000', 'VEHICLES', null, '1901', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('22', 'STOCKS', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('221000', 'STOCKS IN TRADE', null, '1903', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('2210000001', 'Stock In Trade', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('26', 'SUNDRY DEBTORS', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('261000', 'TRADE DEBTORS CONTROL A/C', null, '1902', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('2610000001', 'Seven Star Traders Quetta.', null, null, null, null, null, '', '0313-8285138', '0101', '0', '', '', '1', '0001', null, 'N', 'N', null, '126');
INSERT INTO `nom` VALUES ('2610000002', 'Tahir Sb. Lahore. (Pelle)', null, null, null, null, null, '', '0321-8892665', '0102', '0', '', '', '2', '0001', null, 'N', 'N', null, '234');
INSERT INTO `nom` VALUES ('2610000003', 'Fzami Trading Co. Lahore.', null, null, null, null, null, '', '0321-4062807', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '242');
INSERT INTO `nom` VALUES ('2610000004', 'Ch. House   (Talha Sb.)', null, null, null, null, null, '', '0331-3385784', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '228');
INSERT INTO `nom` VALUES ('2610000005', 'Hanan Traders Lahore', null, null, null, null, null, '', '0324-4546001', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '70');
INSERT INTO `nom` VALUES ('2610000006', 'Faseeh Traders Lahore.', null, null, null, null, null, '', '0322-8426047', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '8');
INSERT INTO `nom` VALUES ('2610000007', 'Naveed Sb Lahore.', null, null, null, null, null, '', '0345-4100826', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '10');
INSERT INTO `nom` VALUES ('2610000008', 'Fira Cosmetics Lahore.', null, null, null, null, null, '', '0321-4590030', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '');
INSERT INTO `nom` VALUES ('2610000009', 'Abdul Rehman Traders.', null, null, null, null, null, '', '0321-4851639****', '0102', '0', '', '', '3', '0001', null, 'N', 'N', null, '148');
INSERT INTO `nom` VALUES ('2610000010', 'Abdullah Traders Lahore.', null, null, null, null, null, '', '0336-4745288', '0105', '0', '', '', '3', '0001', null, 'N', 'N', null, '12');
INSERT INTO `nom` VALUES ('2610000011', 'Alpha Traders Lahore.', null, null, null, null, null, '', '0300-4281428', '0105', '0', '', '', '3', '0001', null, 'N', 'N', null, '146');
INSERT INTO `nom` VALUES ('2610000012', 'Nisar Sb. Merdan.', null, null, null, null, null, '', '0333-9854234', '0102', '0', '', '', '4', '0001', null, 'N', 'N', null, '230');
INSERT INTO `nom` VALUES ('2610000013', 'Hasham Traders Rawala Kot.', null, null, null, null, null, '', '0333-5269927', '0102', '0', '', '', '5', '0001', null, 'N', 'N', null, '16');
INSERT INTO `nom` VALUES ('2610000014', 'Shoaib & Brothers Lahore.', null, null, null, null, null, '', '0333-4047507', '0102', '0', '', '', '6', '0001', null, 'N', 'N', null, '38');
INSERT INTO `nom` VALUES ('2610000015', 'Bhatti Traders, Lahore.', null, null, null, null, null, '', '0304-8966082', '0102', '0', '', '', '7', '0001', null, 'N', 'N', null, '150');
INSERT INTO `nom` VALUES ('2610000016', 'Hanan Traders D.G.Khan.', null, null, null, null, null, '', '0334-7171222', '0103', '0', '', '', '8', '0001', null, 'N', 'N', null, '126');
INSERT INTO `nom` VALUES ('2610000017', 'Al-Madni Nawaz Agencies.', null, null, null, null, null, '', '0300-8612450', '0103', '0', '', '', '9', '0001', null, 'N', 'N', null, '142');
INSERT INTO `nom` VALUES ('2610000018', 'Waqar Traders.', null, null, null, null, null, '', '0306-5435551', '0103', '0', '', '', '10', '0001', null, 'N', 'N', null, '144');
INSERT INTO `nom` VALUES ('2610000019', 'Riaz Sb. Karachi.', null, null, null, null, null, '', '0333-9243342', '0104', '0', '', '', '11', '0001', null, 'N', 'N', null, '124');
INSERT INTO `nom` VALUES ('2610000020', 'Hania Traders Karachi.', null, null, null, null, null, '', '0336-1841305', '0104', '0', '', '', '11', '0001', null, 'N', 'N', null, '125');
INSERT INTO `nom` VALUES ('2610000021', 'Javed Traders Hderabad.', null, null, null, null, null, '', '0300-3043879', '0104', '0', '', '', '12', '0001', null, 'N', 'N', null, '128');
INSERT INTO `nom` VALUES ('2610000022', 'Emaan Traders Sargodha.', null, null, null, null, null, '', '0308-7544950', '0105', '0', '', '', '13', '0001', null, 'N', 'N', null, '6');
INSERT INTO `nom` VALUES ('2610000023', 'Talha Traders Sargodha', null, null, null, null, null, '', '0333-8448951', '0105', '0', '', '', '13', '0001', null, 'N', 'N', null, '6');
INSERT INTO `nom` VALUES ('2610000024', 'Friends Traders Daska.', null, null, null, null, null, '', '0300-7464022', '0105', '0', '', '', '14', '0001', null, 'N', 'N', null, '34');
INSERT INTO `nom` VALUES ('2610000025', 'A.A. Enterprises Gujrat.', null, null, null, null, null, '', '0333-2105352', '0105', '0', '', '', '15', '0001', null, 'N', 'N', null, '36');
INSERT INTO `nom` VALUES ('2610000026', 'Hamad Traders Kasur.', null, null, null, null, null, '', '0300-4344080', '0105', '0', '', '', '16', '0001', null, 'N', 'N', null, '42');
INSERT INTO `nom` VALUES ('2610000027', 'Madina Traders Kasur.', null, null, null, null, null, '', '0322-7186591', '0105', '0', '', '', '16', '0001', null, 'N', 'N', null, '43');
INSERT INTO `nom` VALUES ('2610000028', 'Honey Traders.', null, null, null, null, null, '', '0305-7132979', '0105', '0', '', '', '17', '0001', null, 'N', 'N', null, '44');
INSERT INTO `nom` VALUES ('2610000029', 'Hamza Traders.', null, null, null, null, null, '', '0302-6251170', '0105', '0', '', '', '18', '0001', null, 'N', 'N', null, '46');
INSERT INTO `nom` VALUES ('2610000030', 'Pak Traders.', null, null, null, null, null, '', '0321-6204335', '0105', '0', '', '', '18', '0001', null, 'N', 'N', null, '47');
INSERT INTO `nom` VALUES ('2610000031', 'Imran Traders Shekhupura.', null, null, null, null, null, '', '0300-4987134', '0105', '0', '', '', '19', '0001', null, 'N', 'N', null, '48');
INSERT INTO `nom` VALUES ('2610000032', 'Waqar Traders Jehlum.', null, null, null, null, null, '', '0307-5895610', '0105', '0', '', '', '20', '0001', null, 'N', 'N', null, '50');
INSERT INTO `nom` VALUES ('2610000033', 'Usman Traders Bhalwal', null, null, null, null, null, '', '0321-6544085', '0105', '0', '', '', '21', '0001', null, 'N', 'N', null, '52');
INSERT INTO `nom` VALUES ('2610000034', 'Aamir Traders Kamonki', null, null, null, null, null, '', '0300-4604356', '0105', '0', '', '', '22', '0001', null, 'N', 'N', null, '54');
INSERT INTO `nom` VALUES ('2610000035', 'Anila General Store', null, null, null, null, null, '', '0323-7045641', '0105', '0', '', '', '23', '0001', null, 'N', 'N', null, '54');
INSERT INTO `nom` VALUES ('2610000036', 'Haider Traders Khanqah Dogran', null, null, null, null, null, '', '0301-4755098', '0105', '0', '', '', '24', '0001', null, 'N', 'N', null, '58');
INSERT INTO `nom` VALUES ('2610000037', 'Al-Macca Traders', null, null, null, null, null, '', '0301-4517220', '0105', '0', '', '', '25', '0001', null, 'N', 'N', null, '60');
INSERT INTO `nom` VALUES ('2610000038', 'Rameez Traders', null, null, null, null, null, '', '0300-6101296', '0105', '0', '', '', '26', '0001', null, 'N', 'N', null, '62');
INSERT INTO `nom` VALUES ('2610000039', 'Farwa Trades.', null, null, null, null, null, '', '0300-9619391', '0105', '0', '', '', '26', '0001', null, 'N', 'N', null, '62');
INSERT INTO `nom` VALUES ('2610000040', 'Zain Traders', null, null, null, null, null, '', '0333-4303179', '0105', '0', '', '', '27', '0001', null, 'N', 'N', null, '64');
INSERT INTO `nom` VALUES ('2610000041', 'M.A.Traders Pattoki.', null, null, null, null, null, '', '0300-4566124', '0105', '0', '', '', '28', '0001', null, 'N', 'N', null, '70');
INSERT INTO `nom` VALUES ('2610000042', 'Ahmed Subhan Traders.', null, null, null, null, null, '', '0300-4706114', '0105', '0', '', '', '29', '0001', null, 'N', 'N', null, '72');
INSERT INTO `nom` VALUES ('2610000043', 'Younas Traders Deenga.', null, null, null, null, null, '', '0300-6288270', '0105', '0', '', '', '30', '0001', null, 'N', 'N', null, '79');
INSERT INTO `nom` VALUES ('2610000044', 'Awan Traders Frooq Abad', null, null, null, null, null, '', '0344-4321892', '0105', '0', '', '', '31', '0001', null, 'N', 'N', null, '78');
INSERT INTO `nom` VALUES ('2610000045', 'Rehman Traders Narang Mandi', null, null, null, null, null, '', '0333-4147313', '0105', '0', '', '', '32', '0001', null, 'N', 'N', null, '80');
INSERT INTO `nom` VALUES ('2610000046', 'Ajmal Traders Narang Mandi', null, null, null, null, null, '', '0300-7776584', '0105', '0', '', '', '33', '0001', null, 'N', 'N', null, '80');
INSERT INTO `nom` VALUES ('2610000047', 'Shami Enterprises.', null, null, null, null, null, '', '0300-6473326', '0105', '0', '', '', '34', '0001', null, 'N', 'N', null, '74');
INSERT INTO `nom` VALUES ('2610000048', 'Naro Enterprises.', null, null, null, null, null, '', '0312-5766425', '0105', '0', '', '', '35', '0001', null, 'N', 'N', null, '82');
INSERT INTO `nom` VALUES ('2610000049', 'Ali Traders Samberyal.', null, null, null, null, null, '', '0331-6712306', '0105', '0', '', '', '35', '0001', null, 'N', 'N', null, '94');
INSERT INTO `nom` VALUES ('2610000050', 'Sardar Traders.', null, null, null, null, null, '', '0301-6216003', '0105', '0', '', '', '36', '0001', null, 'N', 'N', null, '84');
INSERT INTO `nom` VALUES ('2610000051', 'Sardar Nawab Phool Nagar.', null, null, null, null, null, '', '0305-6574054', '0105', '0', '', '', '37', '0001', null, 'N', 'N', null, '100');
INSERT INTO `nom` VALUES ('2610000052', 'Sardar Nawab General Store.', null, null, null, null, null, '', '0305-6574054', '0107', '0', '', '', '37', '0001', null, 'N', 'N', null, '100');
INSERT INTO `nom` VALUES ('2610000053', 'Javed Nankana Sahib.', null, null, null, null, null, '', '0300-4899409', '0105', '0', '', '', '38', '0001', null, 'N', 'N', null, '114');
INSERT INTO `nom` VALUES ('2610000054', 'Saquie Genaral Store.', null, null, null, null, null, '', '0333-7776803', '0105', '0', '', '', '39', '0001', null, 'N', 'N', null, '134');
INSERT INTO `nom` VALUES ('2610000055', 'Sabri Traders Uggoki.', null, null, null, null, null, '', '0334-7868600', '0105', '0', '', '', '40', '0001', null, 'N', 'N', null, '136');
INSERT INTO `nom` VALUES ('2610000056', 'Jeem Traders Hafiz Abaz.', null, null, null, null, null, '', '0345-6626050', '0105', '0', '', '', '41', '0001', null, 'N', 'N', null, '138');
INSERT INTO `nom` VALUES ('2610000057', 'Vicky Traders Hafiz Abaz.', null, null, null, null, null, '', '0345-6626050', '0105', '0', '', '', '41', '0001', null, 'N', 'N', null, '138');
INSERT INTO `nom` VALUES ('2610000058', 'Asghar Kiryana, Mano Chak..', null, null, null, null, null, '', '0348-7222166', '0105', '0', '', '', '42', '0001', null, 'N', 'N', null, '152');
INSERT INTO `nom` VALUES ('2610000059', 'Usman Agencies Multan.', null, null, null, null, null, '', '0333-6102905', '0106', '0', '', '', '43', '0001', null, 'N', 'N', null, '122');
INSERT INTO `nom` VALUES ('2610000060', 'Afaq General Store.', null, null, null, null, null, '', '0303-2502369', '0107', '0', '', '', '44', '0001', null, 'N', 'N', null, '96');
INSERT INTO `nom` VALUES ('2610000061', 'Zain Traders.', null, null, null, null, null, '', '0304-4488602', '0107', '0', '', '', '45', '0001', null, 'N', 'N', null, '98');
INSERT INTO `nom` VALUES ('2610000062', 'Master Traders', null, null, null, null, null, '', '0304-8273695', '0107', '0', '', '', '46', '0001', null, 'N', 'N', null, '102');
INSERT INTO `nom` VALUES ('2610000063', 'Zubair Cosmetics.', null, null, null, null, null, '', '0305-7235747', '0107', '0', '', '', '46', '0001', null, 'N', 'N', null, '102');
INSERT INTO `nom` VALUES ('2610000064', 'Hamza Traders Bahawal Nagar', null, null, null, null, null, '', '0308-2945102', '0107', '0', '', '', '47', '0001', null, 'N', 'N', null, '104');
INSERT INTO `nom` VALUES ('2610000065', 'Pappu Genaral Store.', null, null, null, null, null, '', '0300-8758304', '0107', '0', '', '', '48', '0001', null, 'N', 'N', null, '106');
INSERT INTO `nom` VALUES ('2610000066', 'Shabbir Traders Choonian.', null, null, null, null, null, '', '0301-4002423', '0107', '0', '', '', '49', '0001', null, 'N', 'N', null, '40');
INSERT INTO `nom` VALUES ('2610000067', 'Milhen Traders Choonian', null, null, null, null, null, '', '0300-6541742', '0107', '0', '', '', '50', '0001', null, 'N', 'N', null, '40');
INSERT INTO `nom` VALUES ('2610000068', 'Ch. Pappu Traders.', null, null, null, null, null, '', '0302-4992762', '0107', '0', '', '', '51', '0001', null, 'N', 'N', null, '108');
INSERT INTO `nom` VALUES ('2610000069', 'Ahsin Traders.', null, null, null, null, null, '', '0333-6975926', '0107', '0', '', '', '52', '0001', null, 'N', 'N', null, '110');
INSERT INTO `nom` VALUES ('2610000070', 'Riasat Traders Vehari.', null, null, null, null, null, '', '0302-2684600', '0107', '0', '', '', '53', '0001', null, 'N', 'N', null, '112');
INSERT INTO `nom` VALUES ('2610000071', 'Nizami Traders Kamalia.', null, null, null, null, null, '', '0304-9704358', '0107', '0', '', '', '54', '0001', null, 'N', 'N', null, '116');
INSERT INTO `nom` VALUES ('2610000072', 'Chaudhary Traders.', null, null, null, null, null, '', '0308-4843155', '0107', '0', '', '', '55', '0001', null, 'N', 'N', null, '118');
INSERT INTO `nom` VALUES ('2610000073', 'Salman Yousaf Sahiwal', null, null, null, null, null, '', '0323-6944159', '0107', '0', '', '', '56', '0001', null, 'N', 'N', null, '56');
INSERT INTO `nom` VALUES ('2610000074', 'Naeem Shahzad Sahiwal.', null, null, null, null, null, '', '0300-9699145', '0107', '0', '', '', '56', '0001', null, 'N', 'N', null, '57');
INSERT INTO `nom` VALUES ('2610000075', 'Maqbool Multi Store.', null, null, null, null, null, '', '0300-6990040', '0107', '0', '', '', '57', '0001', null, 'N', 'N', null, '120');
INSERT INTO `nom` VALUES ('2610000076', 'Al-Qaim Traders Mian Channu.', null, null, null, null, null, '', '0336-7009801', '0107', '0', '', '', '58', '0001', null, 'N', 'N', null, '130');
INSERT INTO `nom` VALUES ('2610000077', 'Imran Book Depot Hasil Pur.', null, null, null, null, null, '', '0303-7138266', '0107', '0', '', '', '59', '0001', null, 'N', 'N', null, '132');
INSERT INTO `nom` VALUES ('2610000078', 'Saad Traders Okara', null, null, null, null, null, '', '0321-6950537', '0107', '0', '', '', '60', '0001', null, 'N', 'N', null, '66');
INSERT INTO `nom` VALUES ('2610000079', 'Zafran Traders Arif Wala.', null, null, null, null, null, '', '0323-7170336', '0107', '0', '', '', '61', '0001', null, 'N', 'N', null, '68');
INSERT INTO `nom` VALUES ('2610000080', 'Jafar & Sons Theeng Moor', null, null, null, null, null, '', '0332-4100684', '0107', '0', '', '', '62', '0001', null, 'N', 'N', null, '76');
INSERT INTO `nom` VALUES ('2610000081', 'Ayyan Traders Theeng More.', null, null, null, null, null, '', '0308-5230899', '0107', '0', '', '', '62', '0001', null, 'N', 'N', null, '77');
INSERT INTO `nom` VALUES ('2610000082', 'Ahmer Traders.', null, null, null, null, null, '', '0306-6597858', '0107', '0', '', '', '63', '0001', null, 'N', 'N', null, '88');
INSERT INTO `nom` VALUES ('2610000083', 'Ta Ta Traders,  Ghotki (Sukkhar)', null, null, null, null, null, '', '0322-5420726', '0103', '0', '', '', '64', '0001', null, 'N', 'N', null, '154');
INSERT INTO `nom` VALUES ('262000', 'Other Debtors', null, '', null, '02', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('263000', 'Other Receivables', null, '', null, '02', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('2630000001', 'Cash Reconciliation', null, '', null, '02', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('27', 'CASH & BANK BALANCES', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('271000', 'CASH', null, '1999', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('2710000001', 'Cash In Hand', null, null, null, null, '', '', '', '', '0', '', '', null, null, null, 'Y', 'N', null, null);
INSERT INTO `nom` VALUES ('272000', 'BANK BALANCES', null, '1999', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('2720000001', 'Bank#1', null, null, null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'Y', null, null);
INSERT INTO `nom` VALUES ('30', 'REVENUE', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('301000', 'SALES', null, '4101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3010000001', 'Turnover', null, '4101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3010000010', 'Discount Allowed', null, '4101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3010000020', 'Sale Returns', null, '4101', null, '02', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('302000', 'COST OF SALES', null, '5101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3020000001', 'Purchase Cost', null, '5101', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3020000002', 'Labor', null, '5101', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3020000003', 'Less: Purchase Discounts', null, '5101', null, null, '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('3020000004', 'Freight Outwards', null, null, null, null, null, '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('35', 'STAFF LOAN AND ADVANCES', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('351000', 'STAFF LOAN', null, '', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('40', 'ADMINISTRATIVE EXPENSES', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('401000', 'SHOP EXPENSES', null, '6101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('4010000001', 'Operating Expenses', null, null, null, null, null, '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('402000', 'DOMESTIC EXPENSES', null, '6101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('4020000001', 'Home Expenses', null, '6101', null, null, '', '', '', '', '0', '', '', '0', null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('403000', 'SALARIES AND BENEFITS', null, '6101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('4030000001', 'STAFF SALARIES', null, '6101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('50', 'SELLING EXPENCES', null, '0', 'click', '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('501000', 'SELLING EXPENCES', null, '6201', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('5010000001', 'Commission', null, '6201', null, null, '', '', '', '', '0', '', '', '0', null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('60', 'INCOME', null, '8101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);
INSERT INTO `nom` VALUES ('601000', 'Other Income', null, '8101', null, '01', '', '', '', '', '0', '', '', null, null, null, 'N', 'N', null, null);

-- ----------------------------
-- Table structure for `nom_add`
-- ----------------------------
DROP TABLE IF EXISTS `nom_add`;
CREATE TABLE `nom_add` (
  `acct_id` char(10) NOT NULL DEFAULT '',
  `contact_name` varchar(100) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `city` varchar(30) DEFAULT NULL,
  `mobile_no` varchar(100) DEFAULT NULL,
  `phone_no` varchar(100) DEFAULT NULL,
  `fax_no` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`acct_id`),
  CONSTRAINT `nom_add_fk_acct_id` FOREIGN KEY (`acct_id`) REFERENCES `nom` (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_add
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_lc`
-- ----------------------------
DROP TABLE IF EXISTS `nom_lc`;
CREATE TABLE `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_lc
-- ----------------------------

-- ----------------------------
-- Table structure for `party`
-- ----------------------------
DROP TABLE IF EXISTS `party`;
CREATE TABLE `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party
-- ----------------------------

-- ----------------------------
-- Table structure for `party_add`
-- ----------------------------
DROP TABLE IF EXISTS `party_add`;
CREATE TABLE `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `party_product`
-- ----------------------------
DROP TABLE IF EXISTS `party_product`;
CREATE TABLE `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_product
-- ----------------------------
INSERT INTO `party_product` VALUES ('0001', '0357', '46.000', null, null, null, '3');

-- ----------------------------
-- Table structure for `party_type`
-- ----------------------------
DROP TABLE IF EXISTS `party_type`;
CREATE TABLE `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_type
-- ----------------------------
INSERT INTO `party_type` VALUES ('C', 'Customer');
INSERT INTO `party_type` VALUES ('S', 'Supplier');
INSERT INTO `party_type` VALUES ('T', 'Trader');
INSERT INTO `party_type` VALUES ('I', 'Import');
INSERT INTO `party_type` VALUES ('P', 'Production');
INSERT INTO `party_type` VALUES ('A', 'Cash');
INSERT INTO `party_type` VALUES ('O', 'Other');
INSERT INTO `party_type` VALUES ('V', 'Vender');

-- ----------------------------
-- Table structure for `pay_mode`
-- ----------------------------
DROP TABLE IF EXISTS `pay_mode`;
CREATE TABLE `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pay_mode
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dc`;
CREATE TABLE `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dcdet`;
CREATE TABLE `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gp`;
CREATE TABLE `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `pl_gp_fk_loc_id` (`loc_id`),
  KEY `pl_gp_fk_acct_id` (`acct_id`),
  KEY `pl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gpdet`;
CREATE TABLE `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `pl_gpdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grn`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grn`;
CREATE TABLE `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grn
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grndet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grndet`;
CREATE TABLE `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice`;
CREATE TABLE `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) NOT NULL,
  `acct_id_cs_1` char(10) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoice_fk_loc_id` (`loc_id`),
  KEY `pl_invoice_fk_acct_id` (`acct_id`),
  KEY `pl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice
-- ----------------------------
INSERT INTO `pl_invoice` VALUES ('120001', '2017-11-30', '0100010001', '0.00', '0.00', '0.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-12-14 16:52:37', '', '0015', '', '0.000', '', '', '0.00', '', '', null, '01', '17', 'on', '', '', '0', '0', '', '', '', '', '0', 'click', '');

-- ----------------------------
-- Table structure for `pl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedet`;
CREATE TABLE `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedet
-- ----------------------------
INSERT INTO `pl_invoicedet` VALUES ('120001', '1', '0051', '', '6.000', '0.00000', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, '01', '17', '0.000', '0.00', '0', '0', '2017-12-14 16:52:37');
INSERT INTO `pl_invoicedet` VALUES ('120001', '2', '0056', '', '45.000', '0.00000', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, '01', '17', '0.000', '0.00', '0', '0', '2017-12-14 16:53:30');
INSERT INTO `pl_invoicedet` VALUES ('120001', '3', '0063', '', '9.000', '0.00000', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, '01', '17', '0.000', null, '0', '0', '2017-12-15 05:17:05');
INSERT INTO `pl_invoicedet` VALUES ('120001', '4', '0068', '', '25.000', '0.00000', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, '01', '17', '0.000', null, '0', '0', '2017-12-15 05:17:05');

-- ----------------------------
-- Table structure for `pl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedetapp`;
CREATE TABLE `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice_adv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice_adv`;
CREATE TABLE `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice_adv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jv`;
CREATE TABLE `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet`;
CREATE TABLE `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `dr_acct_id` varchar(10) DEFAULT NULL,
  `cr_acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `amount` decimal(13,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet_inst`;
CREATE TABLE `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_order`
-- ----------------------------
DROP TABLE IF EXISTS `pl_order`;
CREATE TABLE `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `po_no` varchar(30) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `disc_amt` decimal(15,2) DEFAULT NULL,
  `dc_amt` decimal(15,2) DEFAULT NULL,
  `loc_id` char(2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `sp_id` varchar(7) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `service` char(2) DEFAULT NULL,
  `ut` char(2) DEFAULT NULL,
  `adv_amt` decimal(15,2) DEFAULT NULL,
  `net_amt` decimal(15,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `pl_order_fk_loc_id` (`loc_id`),
  KEY `pl_order_fk_acct_id` (`acct_id`),
  KEY `pl_order_fk_comp_id` (`comp_id`),
  KEY `pl_order_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_orderdet`;
CREATE TABLE `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` decimal(6,3) DEFAULT NULL,
  `stax` decimal(15,2) DEFAULT NULL,
  `stax_rate` decimal(15,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `sed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`),
  KEY `pl_orderdet_fk_stock_code` (`stock_code`),
  KEY `pl_orderdet_fk_v_id` (`comp_id`,`year_id`,`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `pl_pay`;
CREATE TABLE `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet`;
CREATE TABLE `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet_inst`;
CREATE TABLE `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `pl_payment`;
CREATE TABLE `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paymentdet`;
CREATE TABLE `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_po`;
CREATE TABLE `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_podet`;
CREATE TABLE `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receipt`;
CREATE TABLE `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet`;
CREATE TABLE `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_acct`;
CREATE TABLE `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_inv`;
CREATE TABLE `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_po`;
CREATE TABLE `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_return`
-- ----------------------------
DROP TABLE IF EXISTS `pl_return`;
CREATE TABLE `pl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_return
-- ----------------------------
INSERT INTO `pl_return` VALUES ('1', '2017-07-15', '', '0.00', '0.00', '8100.00', null, null, null, null, null, null, '', null, null, null, null, null, '01', null, '2017-07-15 21:17:08', '', '0001', '', '0.000', '', '', '0.00', '', '', null, '01', '17', null, 'hjk', '098', '0', '0', '', '', '', '', '8100');

-- ----------------------------
-- Table structure for `pl_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_returndet`;
CREATE TABLE `pl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_returndet
-- ----------------------------
INSERT INTO `pl_returndet` VALUES ('1', '1', '0068', '', '1.000', '8100.00000', '8100.00', '', null, null, null, null, null, null, null, null, null, null, null, '01', '17', '0.000', null, '0', '0');

-- ----------------------------
-- Table structure for `pl_ship`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship`;
CREATE TABLE `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_shipdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_shipdet`;
CREATE TABLE `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_shipdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship_inv`;
CREATE TABLE `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `po`
-- ----------------------------
DROP TABLE IF EXISTS `po`;
CREATE TABLE `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po
-- ----------------------------

-- ----------------------------
-- Table structure for `podet`
-- ----------------------------
DROP TABLE IF EXISTS `podet`;
CREATE TABLE `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of podet
-- ----------------------------

-- ----------------------------
-- Table structure for `po_type`
-- ----------------------------
DROP TABLE IF EXISTS `po_type`;
CREATE TABLE `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po_type
-- ----------------------------
INSERT INTO `po_type` VALUES ('01', 'Ex Works');

-- ----------------------------
-- Table structure for `process`
-- ----------------------------
DROP TABLE IF EXISTS `process`;
CREATE TABLE `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of process
-- ----------------------------
INSERT INTO `process` VALUES ('1', 'Mixing');

-- ----------------------------
-- Table structure for `prod`
-- ----------------------------
DROP TABLE IF EXISTS `prod`;
CREATE TABLE `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod
-- ----------------------------

-- ----------------------------
-- Table structure for `proddet`
-- ----------------------------
DROP TABLE IF EXISTS `proddet`;
CREATE TABLE `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of proddet
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_batch`
-- ----------------------------
DROP TABLE IF EXISTS `prod_batch`;
CREATE TABLE `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_batch
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_brand`
-- ----------------------------
DROP TABLE IF EXISTS `prod_brand`;
CREATE TABLE `prod_brand` (
  `BRAND_ID` varchar(6) NOT NULL,
  `BRAND_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`BRAND_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_brand
-- ----------------------------
INSERT INTO `prod_brand` VALUES ('01', 'Local', null, null, null);
INSERT INTO `prod_brand` VALUES ('02', 'China', null, null, null);
INSERT INTO `prod_brand` VALUES ('03', 'SONEX', null, null, null);
INSERT INTO `prod_brand` VALUES ('04', 'GROHE', null, null, null);
INSERT INTO `prod_brand` VALUES ('05', 'GROHE CHI', null, null, null);
INSERT INTO `prod_brand` VALUES ('06', 'CLASSIC', null, null, null);
INSERT INTO `prod_brand` VALUES ('07', 'OTHERS', null, null, null);
INSERT INTO `prod_brand` VALUES ('08', 'JAGUAR', null, null, null);

-- ----------------------------
-- Table structure for `prod_cat`
-- ----------------------------
DROP TABLE IF EXISTS `prod_cat`;
CREATE TABLE `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(30) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  `CatagoryID` int(11) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_cat
-- ----------------------------
INSERT INTO `prod_cat` VALUES ('01', 'Welcome', null, null, null, null);
INSERT INTO `prod_cat` VALUES ('02', 'Sohni', null, null, null, null);
INSERT INTO `prod_cat` VALUES ('03', 'V Take Care', null, null, null, null);
INSERT INTO `prod_cat` VALUES ('04', 'Others', null, null, null, null);

-- ----------------------------
-- Table structure for `prod_comp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_comp`;
CREATE TABLE `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_comp
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_grp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_grp`;
CREATE TABLE `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_grp
-- ----------------------------
INSERT INTO `prod_grp` VALUES ('01', 'Group Name');

-- ----------------------------
-- Table structure for `prod_rm_date`
-- ----------------------------
DROP TABLE IF EXISTS `prod_rm_date`;
CREATE TABLE `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_rm_date
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_type`
-- ----------------------------
DROP TABLE IF EXISTS `prod_type`;
CREATE TABLE `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_type
-- ----------------------------
INSERT INTO `prod_type` VALUES ('01', 'Franchise Group', '0700100001', '0500030003', '0800010101');

-- ----------------------------
-- Table structure for `regions`
-- ----------------------------
DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
  `reg_id` varchar(6) NOT NULL,
  `reg_name` varchar(30) NOT NULL,
  PRIMARY KEY (`reg_id`),
  KEY `REG_ID` (`reg_id`),
  KEY `reg_id_2` (`reg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of regions
-- ----------------------------
INSERT INTO `regions` VALUES ('0101', 'Quetta');
INSERT INTO `regions` VALUES ('0102', 'Central');
INSERT INTO `regions` VALUES ('0103', 'D.G.Khan');
INSERT INTO `regions` VALUES ('0104', 'Karachi');
INSERT INTO `regions` VALUES ('0105', 'Lahore');
INSERT INTO `regions` VALUES ('0106', 'Multan');
INSERT INTO `regions` VALUES ('0107', 'Sahiwal');

-- ----------------------------
-- Table structure for `replanishment`
-- ----------------------------
DROP TABLE IF EXISTS `replanishment`;
CREATE TABLE `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of replanishment
-- ----------------------------
INSERT INTO `replanishment` VALUES ('SD03001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH08', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH09', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH10', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH11', '0', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH08', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH09', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH10', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH11', '0', '05');

-- ----------------------------
-- Table structure for `report`
-- ----------------------------
DROP TABLE IF EXISTS `report`;
CREATE TABLE `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report
-- ----------------------------
INSERT INTO `report` VALUES ('2010-11-25', '2015-11-25');

-- ----------------------------
-- Table structure for `reports`
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports
-- ----------------------------
INSERT INTO `reports` VALUES ('trial_balance', 'Trial Balance', '1', '', '001');
INSERT INTO `reports` VALUES ('daybook', 'Daybook', '1', 'Y', '002');
INSERT INTO `reports` VALUES ('ledger', 'Ledger', '1', 'N', '003');
INSERT INTO `reports` VALUES ('profit_loss', 'Profit & Loss', '1', 'N', '004');
INSERT INTO `reports` VALUES ('chart', 'Chart of Accounts', '1', 'N', '005');
INSERT INTO `reports` VALUES ('balance_sheet', 'Balance Sheet', '1', 'N', '006');
INSERT INTO `reports` VALUES ('pdf_sl_due_invoices', 'Due Invoices', '2', '', '009');
INSERT INTO `reports` VALUES ('pf_sl_supply_register', 'Supply Register', '2', '', '010');
INSERT INTO `reports` VALUES ('report_current_stock', 'Current Stock', '2', '', '011');
INSERT INTO `reports` VALUES ('report_sale?report=PL', 'Day Book', '3', '', '012');
INSERT INTO `reports` VALUES ('report_sale?report=ST', 'Day Book', '4', '', '013');
INSERT INTO `reports` VALUES ('stock_ledger', 'Stock Ledger', '4', '', '014');
INSERT INTO `reports` VALUES ('stock_summary', 'Stock Summary', '4', '', '015');
INSERT INTO `reports` VALUES ('smart_stock', 'Smart Stock', '4', '', '016');
INSERT INTO `reports` VALUES ('report_sale?report=SL', 'Day Book', '2', '', '017');
INSERT INTO `reports` VALUES ('cashbook', 'Cash Book', '1', '', '018');
INSERT INTO `reports` VALUES ('report_sales', 'Sale Report', '2', 'Y', '019');
INSERT INTO `reports` VALUES ('sp_sale_report', 'Due Invoices Sales Person Wise', '2', 'Y', '023');
INSERT INTO `reports` VALUES ('party_balances', 'Balances', '2', 'Y', '024');
INSERT INTO `reports` VALUES ('party_analysis', 'Party Analysis', '5', 'Y', '025');
INSERT INTO `reports` VALUES ('smart_accounting', 'Smart Accounting', '1', 'Y', '026');
INSERT INTO `reports` VALUES ('smart_party_accounting', 'Smart Accounting', '5', 'Y', '027');
INSERT INTO `reports` VALUES ('rpt_sl', 'Outstanding Report By Region', '2', 'Y', '028');
INSERT INTO `reports` VALUES ('rpt_sl', 'Outstanding Report By Agent', '2', 'Y', '029');
INSERT INTO `reports` VALUES ('rpt_sl', 'Outstanding Report By Company', '2', 'Y', '030');
INSERT INTO `reports` VALUES ('rpt_sl', 'Recovery Report By Date', '2', 'Y', '031');
INSERT INTO `reports` VALUES ('rpt_sl', 'Recovery Report By Agent', '2', 'Y', '032');
INSERT INTO `reports` VALUES ('rpt_sl', 'Recovery Report By Company', '2', 'Y', '033');
INSERT INTO `reports` VALUES ('rpt_sl', 'Recovery Report By City', '2', 'Y', '034');
INSERT INTO `reports` VALUES ('rpt_sl', 'Recovery Summary Party Wise', '2', 'Y', '035');
INSERT INTO `reports` VALUES ('rpt_sl', 'Sale Report By Company', '2', 'Y', '036');
INSERT INTO `reports` VALUES ('rpt_sl', 'Sale Report By Agent', '2', 'Y', '037');
INSERT INTO `reports` VALUES ('rpt_sl', 'Sale Report By City', '2', 'Y', '038');
INSERT INTO `reports` VALUES ('rpt_sl', 'Sale Summary Party Wise', '2', 'Y', '039');

-- ----------------------------
-- Table structure for `reports_all`
-- ----------------------------
DROP TABLE IF EXISTS `reports_all`;
CREATE TABLE `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports_all
-- ----------------------------
INSERT INTO `reports_all` VALUES ('accountsummary', 'Account Summary', '1', 'N');

-- ----------------------------
-- Table structure for `report_brands`
-- ----------------------------
DROP TABLE IF EXISTS `report_brands`;
CREATE TABLE `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_brands
-- ----------------------------
INSERT INTO `report_brands` VALUES ('1301', '1202', '1103', '1102', null);

-- ----------------------------
-- Table structure for `report_cat`
-- ----------------------------
DROP TABLE IF EXISTS `report_cat`;
CREATE TABLE `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `report_comp`
-- ----------------------------
DROP TABLE IF EXISTS `report_comp`;
CREATE TABLE `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_comp
-- ----------------------------
INSERT INTO `report_comp` VALUES ('01');

-- ----------------------------
-- Table structure for `report_cs`
-- ----------------------------
DROP TABLE IF EXISTS `report_cs`;
CREATE TABLE `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cs
-- ----------------------------

-- ----------------------------
-- Table structure for `report_div`
-- ----------------------------
DROP TABLE IF EXISTS `report_div`;
CREATE TABLE `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_div
-- ----------------------------

-- ----------------------------
-- Table structure for `report_party`
-- ----------------------------
DROP TABLE IF EXISTS `report_party`;
CREATE TABLE `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_party
-- ----------------------------
INSERT INTO `report_party` VALUES ('0063');

-- ----------------------------
-- Table structure for `report_sp`
-- ----------------------------
DROP TABLE IF EXISTS `report_sp`;
CREATE TABLE `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_sp
-- ----------------------------

-- ----------------------------
-- Table structure for `season_cat`
-- ----------------------------
DROP TABLE IF EXISTS `season_cat`;
CREATE TABLE `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of season_cat
-- ----------------------------
INSERT INTO `season_cat` VALUES ('010101', 'WINTER');
INSERT INTO `season_cat` VALUES ('010102', 'SUMMER');

-- ----------------------------
-- Table structure for `size`
-- ----------------------------
DROP TABLE IF EXISTS `size`;
CREATE TABLE `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of size
-- ----------------------------
INSERT INTO `size` VALUES ('08', 'S');
INSERT INTO `size` VALUES ('09', 'M');
INSERT INTO `size` VALUES ('10', 'L');
INSERT INTO `size` VALUES ('11', 'XL');

-- ----------------------------
-- Table structure for `sl_am_con`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_con`;
CREATE TABLE `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_con
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_condet`;
CREATE TABLE `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_cont`
-- ----------------------------
DROP TABLE IF EXISTS `sl_cont`;
CREATE TABLE `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_cont
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contdet`;
CREATE TABLE `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contmaint`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contmaint`;
CREATE TABLE `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contmaint
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contpay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contpay`;
CREATE TABLE `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contpay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc`;
CREATE TABLE `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `order_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet`;
CREATE TABLE `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_dcdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_ser`;
CREATE TABLE `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtn`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtn`;
CREATE TABLE `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtn
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet`;
CREATE TABLE `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet_ser`;
CREATE TABLE `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gp`;
CREATE TABLE `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  `sp_id` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_gp` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gp_fk_loc_id` (`loc_id`),
  KEY `sl_gp_fk_acct_id` (`acct_id`),
  KEY `sl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gpdet`;
CREATE TABLE `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(11,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_gpdet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gpdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice`;
CREATE TABLE `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) NOT NULL,
  `acct_id_cs_1` varchar(10) DEFAULT NULL,
  `staxp` decimal(6,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoice_fk_loc_id` (`loc_id`),
  KEY `sl_invoice_fk_acct_id` (`acct_id`),
  KEY `sl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet`;
CREATE TABLE `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedetapp`;
CREATE TABLE `sl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedet_bon`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet_bon`;
CREATE TABLE `sl_invoicedet_bon` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet_bon
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice_rate`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice_rate`;
CREATE TABLE `sl_invoice_rate` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `index_sl_invoice` (`voucher_id`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice_rate
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice_rate_det`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice_rate_det`;
CREATE TABLE `sl_invoice_rate_det` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `rate` decimal(15,5) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice_rate_det
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice_rec`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice_rec`;
CREATE TABLE `sl_invoice_rec` (
  `REC_ID` varchar(7) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice_rec
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jv`;
CREATE TABLE `sl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jvdet`;
CREATE TABLE `sl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jvdet_inst`;
CREATE TABLE `sl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_order`
-- ----------------------------
DROP TABLE IF EXISTS `sl_order`;
CREATE TABLE `sl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `po_no` varchar(10) NOT NULL DEFAULT '',
  `po_date` date DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `sl_order_fk_loc_id` (`loc_id`),
  KEY `sl_order_fk_acct_id` (`acct_id`),
  KEY `sl_order_fk_comp_id` (`comp_id`),
  KEY `sl_order_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_orderdet`;
CREATE TABLE `sl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`),
  KEY `sl_orderdet_fk_stock_code` (`stock_code`),
  KEY `sl_orderdet_fk_v_id` (`comp_id`,`year_id`,`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_party_add`
-- ----------------------------
DROP TABLE IF EXISTS `sl_party_add`;
CREATE TABLE `sl_party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_pay`;
CREATE TABLE `sl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) DEFAULT '',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(10) DEFAULT '',
  `other_id_2` varchar(10) DEFAULT '',
  `other_id_3` varchar(10) DEFAULT '',
  `itax_id` varchar(10) DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paydet`;
CREATE TABLE `sl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paydet_inst`;
CREATE TABLE `sl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `sl_payment`;
CREATE TABLE `sl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) NOT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(100) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paymentdet`;
CREATE TABLE `sl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_po`
-- ----------------------------
DROP TABLE IF EXISTS `sl_po`;
CREATE TABLE `sl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_podet`;
CREATE TABLE `sl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `BONUS_QTY` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product`;
CREATE TABLE `sl_product` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `O_QTY` decimal(10,3) DEFAULT NULL,
  `O_RATE` decimal(10,2) DEFAULT NULL,
  `CAT_ID` varchar(6) NOT NULL,
  `TYPE_ID` varchar(10) NOT NULL,
  `BATCHWISE` varchar(1) NOT NULL,
  `REG_NO` varchar(10) DEFAULT NULL,
  `PACK_SIZE` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) NOT NULL,
  `P_RATE` decimal(10,2) DEFAULT NULL,
  `TYPE_GRP` varchar(1) NOT NULL,
  `PACK_RATE` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(10,3) NOT NULL,
  `ALL_CUST` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `GRP_ID` varchar(2) NOT NULL,
  `MOL_QTY` decimal(10,3) DEFAULT NULL,
  `MOL` varchar(1) DEFAULT NULL,
  `OLD_CODE` varchar(9) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PART_NO` varchar(30) DEFAULT NULL,
  `SAMPL_ID` varchar(4) DEFAULT NULL,
  `SAMPLE_ID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_products_log`
-- ----------------------------
DROP TABLE IF EXISTS `sl_products_log`;
CREATE TABLE `sl_products_log` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `POST_DATE` datetime NOT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_products_log
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product_brand`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product_brand`;
CREATE TABLE `sl_product_brand` (
  `PROD_ID` varchar(4) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product_brand
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product_rm`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product_rm`;
CREATE TABLE `sl_product_rm` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(13,6) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `RM_ID` varchar(4) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product_rm
-- ----------------------------
INSERT INTO `sl_product_rm` VALUES ('0356', '0.000310', '1', '0027', '01');

-- ----------------------------
-- Table structure for `sl_quote`
-- ----------------------------
DROP TABLE IF EXISTS `sl_quote`;
CREATE TABLE `sl_quote` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(10,2) NOT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(5) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_quote
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_quotedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_quotedet`;
CREATE TABLE `sl_quotedet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `UNIT_RATE` decimal(10,3) NOT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,0) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_quotedet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receipt`;
CREATE TABLE `sl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet`;
CREATE TABLE `sl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet_acct`;
CREATE TABLE `sl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet_inv`;
CREATE TABLE `sl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_return`
-- ----------------------------
DROP TABLE IF EXISTS `sl_return`;
CREATE TABLE `sl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_return_fk_loc_id` (`loc_id`),
  KEY `sl_return_fk_acct_id` (`acct_id`),
  KEY `sl_return_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_return
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_returndet`;
CREATE TABLE `sl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_returndet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_sa`
-- ----------------------------
DROP TABLE IF EXISTS `sl_sa`;
CREATE TABLE `sl_sa` (
  `SA_ID` varchar(5) NOT NULL,
  `SA_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_sa
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_sadet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_sadet`;
CREATE TABLE `sl_sadet` (
  `SA_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `AMOUNT` decimal(10,0) NOT NULL,
  `SP_ID` varchar(4) NOT NULL,
  `DIV_ID` varchar(2) NOT NULL,
  `CITY_ID` varchar(2) NOT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_sadet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_wo`
-- ----------------------------
DROP TABLE IF EXISTS `sl_wo`;
CREATE TABLE `sl_wo` (
  `WO_ID` varchar(5) NOT NULL,
  `WO_DATE` datetime NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `WO_NAME` varchar(50) DEFAULT NULL,
  `DIV_ID` varchar(2) DEFAULT NULL,
  `CITY_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`WO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_wo
-- ----------------------------

-- ----------------------------
-- Table structure for `sp`
-- ----------------------------
DROP TABLE IF EXISTS `sp`;
CREATE TABLE `sp` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sp
-- ----------------------------
INSERT INTO `sp` VALUES ('0001', 'Office Sales', null, '01');

-- ----------------------------
-- Table structure for `sp_party`
-- ----------------------------
DROP TABLE IF EXISTS `sp_party`;
CREATE TABLE `sp_party` (
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `lineitem` varchar(4) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`sp_id`,`party_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sp_party
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_cat`
-- ----------------------------
DROP TABLE IF EXISTS `stk_cat`;
CREATE TABLE `stk_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_collection`
-- ----------------------------
DROP TABLE IF EXISTS `stk_collection`;
CREATE TABLE `stk_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_collection
-- ----------------------------
INSERT INTO `stk_collection` VALUES ('010101', 'Men');
INSERT INTO `stk_collection` VALUES ('010102', 'Gold');

-- ----------------------------
-- Table structure for `stk_con`
-- ----------------------------
DROP TABLE IF EXISTS `stk_con`;
CREATE TABLE `stk_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` bigint(10) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_con` (`voucher_id`,`bill_no`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_con
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_condet`
-- ----------------------------
DROP TABLE IF EXISTS `stk_condet`;
CREATE TABLE `stk_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_condet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `system`
-- ----------------------------
DROP TABLE IF EXISTS `system`;
CREATE TABLE `system` (
  `comp_name` varchar(100) NOT NULL DEFAULT '',
  `cash_id` varchar(10) NOT NULL DEFAULT '',
  `bank_id` varchar(10) NOT NULL DEFAULT '',
  `creditor_id` varchar(10) DEFAULT '1601999',
  `stax_id` varchar(10) DEFAULT '2201001',
  `dc_id` varchar(10) DEFAULT '5302005',
  `disc_id` varchar(10) DEFAULT '5107001',
  `debtor_id` varchar(10) DEFAULT '4201999',
  `adv_id` varchar(10) DEFAULT '4201999',
  `db_id` varchar(10) DEFAULT '4201999',
  `ret_id` varchar(10) DEFAULT '4201999',
  `sec_id` varchar(10) DEFAULT '4201999',
  `stax_id_sl` varchar(10) DEFAULT '2201001',
  `dc_id_sl` varchar(10) DEFAULT '5302005',
  `disc_id_sl` varchar(10) DEFAULT '5107001',
  `adv_id_sl` varchar(10) DEFAULT '4201999',
  `db_id_sl` varchar(10) DEFAULT '4201999',
  `ret_id_sl` varchar(10) DEFAULT '4201999',
  `sec_id_sl` varchar(10) DEFAULT '4201999',
  `stock_id` varchar(10) DEFAULT '4201999',
  `turnover_id` varchar(10) DEFAULT '3010000001',
  `cogs_id` varchar(10) DEFAULT '3020000001',
  `sed_id` varchar(10) DEFAULT NULL,
  `sed_id_sl` varchar(10) DEFAULT NULL,
  `hide_taxes` char(1) DEFAULT NULL,
  `date_from` date DEFAULT '2009-07-01',
  `date_to` date DEFAULT '2010-06-30',
  `ait_id` varchar(10) DEFAULT NULL,
  `cdi_id` varchar(10) DEFAULT NULL,
  `date_close` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) DEFAULT 'support@clicksoft.org',
  `qty_decimal` int(11) DEFAULT '0',
  `fed_id` varchar(10) DEFAULT NULL,
  `fed_id_sl` varchar(10) DEFAULT NULL,
  `stock_transfer_id` varchar(10) DEFAULT NULL,
  `login_page` varchar(30) NOT NULL,
  `sale_form` varchar(30) NOT NULL,
  `qty_decimals` int(1) DEFAULT '0',
  `rate_decimals` int(1) DEFAULT '2',
  PRIMARY KEY (`comp_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of system
-- ----------------------------
INSERT INTO `system` VALUES ('Origa Chemicals', '271000', '272000', '131000', '3011000001', '5010000001', '2210000004', '261000', '1001001', '5010000001', '1001001', '1001001', '3011000001', '3020000010', '3020000002', '4201', '3020000010', '4201', '4201', '2210000001', '3010000001', '3020000001', '3011000005', '3011000005', '', '2011-07-01', '2012-06-30', '2530000002', '4060000005', '2017-11-29', 'accounts@rakcorporation.com,support@clicksoft.com.pk', '3', '3011000004', '3011000004', '2210000002', 'origa', '', '0', '2');

-- ----------------------------
-- Table structure for `tf`
-- ----------------------------
DROP TABLE IF EXISTS `tf`;
CREATE TABLE `tf` (
  `INV_ID` varchar(5) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `PACK_SIZE` varchar(30) DEFAULT NULL,
  `PACK_QTY` decimal(10,2) DEFAULT NULL,
  `UNIT_QTY` decimal(10,2) DEFAULT NULL,
  `STD_WT` decimal(15,5) DEFAULT NULL,
  `UNIT_WT` decimal(15,5) DEFAULT NULL,
  `BATCH_MONTH` varchar(10) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `INACTIVE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tf
-- ----------------------------
INSERT INTO `tf` VALUES ('00140', null, '0001', '', '', '', '2015-12-28 00:00:00', '1*1', '1.00', '222.00', '0.00000', null, null, null, null);

-- ----------------------------
-- Table structure for `tfdet`
-- ----------------------------
DROP TABLE IF EXISTS `tfdet`;
CREATE TABLE `tfdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(15,5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `DONT_INCLUDE` varchar(1) NOT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `LL_P` decimal(6,3) DEFAULT NULL,
  `LL_QTY` decimal(15,5) DEFAULT NULL,
  `QTY` decimal(15,5) DEFAULT NULL,
  `REQ_QTY` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tfdet
-- ----------------------------
INSERT INTO `tfdet` VALUES ('00141', '1', null, '0', null, '', '', '', '', null, null, null, '0.00000', null);

-- ----------------------------
-- Table structure for `trans`
-- ----------------------------
DROP TABLE IF EXISTS `trans`;
CREATE TABLE `trans` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of trans
-- ----------------------------
INSERT INTO `trans` VALUES ('00001', '2015-08-08 00:00:00', '01', '15', 'inam', '01', 'N', null);

-- ----------------------------
-- Table structure for `transdet`
-- ----------------------------
DROP TABLE IF EXISTS `transdet`;
CREATE TABLE `transdet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `REMARKS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of transdet
-- ----------------------------
INSERT INTO `transdet` VALUES ('00001', '1', '0394', '332.000', null, '15D523', null, '01', '15', '02', null, 'Nearest Exipry Date 30-09-15');

-- ----------------------------
-- Table structure for `tt`
-- ----------------------------
DROP TABLE IF EXISTS `tt`;
CREATE TABLE `tt` (
  `v_id` int(11) NOT NULL,
  `v_date` date DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `comp_name` varchar(100) DEFAULT NULL,
  `debit_amount` int(15) DEFAULT NULL,
  `credit_amount` int(15) DEFAULT NULL,
  `ref_no` varchar(250) DEFAULT NULL,
  `acct_type` varchar(250) DEFAULT NULL,
  `remarks` text,
  `opening_balance` int(15) DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tt
-- ----------------------------

-- ----------------------------
-- Table structure for `type`
-- ----------------------------
DROP TABLE IF EXISTS `type`;
CREATE TABLE `type` (
  `type_id` varchar(6) NOT NULL DEFAULT '',
  `type_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of type
-- ----------------------------
INSERT INTO `type` VALUES ('0002', 'KHUSSA');
INSERT INTO `type` VALUES ('0003', 'SEMI FORMAL');
INSERT INTO `type` VALUES ('0004', 'FORMAL');
INSERT INTO `type` VALUES ('0005', 'CASUAL');

-- ----------------------------
-- Table structure for `units`
-- ----------------------------
DROP TABLE IF EXISTS `units`;
CREATE TABLE `units` (
  `unit` char(3) NOT NULL DEFAULT '',
  `unit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of units
-- ----------------------------
INSERT INTO `units` VALUES ('Bag', 'Bags');
INSERT INTO `units` VALUES ('Bot', 'Bottle');
INSERT INTO `units` VALUES ('Bun', 'Bundle');
INSERT INTO `units` VALUES ('Coi', 'Coil');
INSERT INTO `units` VALUES ('Dru', 'Drum');
INSERT INTO `units` VALUES ('Dzn', 'Dzn');
INSERT INTO `units` VALUES ('Ft', 'Ft');
INSERT INTO `units` VALUES ('Gln', 'Gln');
INSERT INTO `units` VALUES ('Grm', 'Grams');
INSERT INTO `units` VALUES ('Kg', 'Kg');
INSERT INTO `units` VALUES ('Ltr', 'Liter');
INSERT INTO `units` VALUES ('Mtr', 'Mtr');
INSERT INTO `units` VALUES ('Nos', 'Nos');
INSERT INTO `units` VALUES ('Pai', 'Pairs');
INSERT INTO `units` VALUES ('Pcs', 'Pices');
INSERT INTO `units` VALUES ('Pkt', 'Pkt');
INSERT INTO `units` VALUES ('Qtr', 'Qtr');
INSERT INTO `units` VALUES ('Rft', 'Rft');
INSERT INTO `units` VALUES ('Rim', 'Rim');
INSERT INTO `units` VALUES ('Rol', 'Roll');
INSERT INTO `units` VALUES ('Set', 'Set');
INSERT INTO `units` VALUES ('Sqf', 'Sqft');
INSERT INTO `units` VALUES ('Tin', 'Tin');
INSERT INTO `units` VALUES ('Tro', 'Trolly');
INSERT INTO `units` VALUES ('Tru', 'Truck');
INSERT INTO `units` VALUES ('MT', 'M.Tons');
INSERT INTO `units` VALUES ('100', 'baggage');
INSERT INTO `units` VALUES ('Guz', 'GUZZ');

-- ----------------------------
-- Table structure for `users`
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `EMP_ID` varchar(20) NOT NULL,
  `EMP_NAME` varchar(40) NOT NULL,
  `PASSWORD` varchar(20) DEFAULT NULL,
  `AUTH_ID` varchar(1) NOT NULL,
  `USE_FORM` varchar(1) DEFAULT NULL,
  `USE_REP` varchar(1) DEFAULT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `PK_BILL_NO_FROM` varchar(4) DEFAULT NULL,
  `PK_BILL_NO_TO` varchar(4) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `VOUCHER_TYPE` varchar(2) DEFAULT NULL,
  `POST` varchar(1) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `u_session_id` decimal(65,30) DEFAULT NULL,
  `inactive` char(1) NOT NULL,
  PRIMARY KEY (`EMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('admin', 'admin', 'admin', '9', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null, '');
INSERT INTO `users` VALUES ('click', 'ClickSoft (Pvt) Ltd', '124', '9', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null, '');

-- ----------------------------
-- Table structure for `users_comp`
-- ----------------------------
DROP TABLE IF EXISTS `users_comp`;
CREATE TABLE `users_comp` (
  `EMP_ID` varchar(20) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `inactive` char(1) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_comp
-- ----------------------------
INSERT INTO `users_comp` VALUES ('admin', '01', null, '');
INSERT INTO `users_comp` VALUES ('admin', '02', null, '');
INSERT INTO `users_comp` VALUES ('click', '01', null, '');
INSERT INTO `users_comp` VALUES ('click', '02', null, '');

-- ----------------------------
-- Table structure for `users_menu`
-- ----------------------------
DROP TABLE IF EXISTS `users_menu`;
CREATE TABLE `users_menu` (
  `emp_id` varchar(20) NOT NULL DEFAULT '',
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `inactive` char(2) NOT NULL DEFAULT '',
  `insert_allowed` char(1) NOT NULL DEFAULT 'N',
  `update_allowed` char(1) NOT NULL DEFAULT 'N',
  `delete_allowed` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`emp_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_menu
-- ----------------------------
INSERT INTO `users_menu` VALUES ('click', '1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '1.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '2.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '2.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '2.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '2.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '2.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '3.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '3.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '4.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '4.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '5.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '5.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '5.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '6.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '7.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '8', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '8.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '8.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '9', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '9.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '9.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('madni', '9.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '1.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '2.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '2.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '2.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '2.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '2.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '3.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '3.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '4.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '4.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '5.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '5.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '5.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '6.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '7.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '8', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '8.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '8.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '9', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '9.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '9.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('rashid', '9.3', 'N', 'Y', 'Y', 'Y');

-- ----------------------------
-- Table structure for `users_mod`
-- ----------------------------
DROP TABLE IF EXISTS `users_mod`;
CREATE TABLE `users_mod` (
  `EMP_ID` varchar(6) NOT NULL,
  `VOUCHER_TYPE` varchar(20) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_mod
-- ----------------------------
INSERT INTO `users_mod` VALUES ('Abid', 'PL_INVOICE');

-- ----------------------------
-- Table structure for `users_rep`
-- ----------------------------
DROP TABLE IF EXISTS `users_rep`;
CREATE TABLE `users_rep` (
  `EMP_ID` varchar(6) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`REP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_rep
-- ----------------------------

-- ----------------------------
-- Table structure for `user_mod`
-- ----------------------------
DROP TABLE IF EXISTS `user_mod`;
CREATE TABLE `user_mod` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_CP',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_mod
-- ----------------------------

-- ----------------------------
-- Table structure for `user_profile`
-- ----------------------------
DROP TABLE IF EXISTS `user_profile`;
CREATE TABLE `user_profile` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `user_name` varchar(50) DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '123',
  `desig_id` varchar(30) DEFAULT '',
  `div_name` varchar(30) DEFAULT '',
  `sec_lvl` char(1) DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_profile
-- ----------------------------
INSERT INTO `user_profile` VALUES ('HEAD OFFICE', 'HEAD OFFICE', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('02-admin', 'EQUATOR', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('03-admin', 'Wapda Town', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('04-admin', 'Studio Mir - Gujranwala', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('05-admin', 'Dreams - M.M.Alam', '123', '', '', '0');

-- ----------------------------
-- Table structure for `user_rep`
-- ----------------------------
DROP TABLE IF EXISTS `user_rep`;
CREATE TABLE `user_rep` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_10',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_rep
-- ----------------------------

-- ----------------------------
-- Table structure for `vehicle_type`
-- ----------------------------
DROP TABLE IF EXISTS `vehicle_type`;
CREATE TABLE `vehicle_type` (
  `vehicle_id` varchar(4) NOT NULL,
  `vehicle_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`vehicle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of vehicle_type
-- ----------------------------
INSERT INTO `vehicle_type` VALUES ('0001', 'MAZDA');
INSERT INTO `vehicle_type` VALUES ('0002', 'PICK UP');

-- ----------------------------
-- Table structure for `voucher`
-- ----------------------------
DROP TABLE IF EXISTS `voucher`;
CREATE TABLE `voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `voucher_date` date DEFAULT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `POSTED` char(2) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `UPD_DATE` datetime DEFAULT NULL,
  `UPD_EMP_ID` varchar(8) DEFAULT NULL,
  `ACCT_ID_CS_1` char(10) DEFAULT NULL,
  `ACCT_ID_CS_2` char(10) DEFAULT NULL,
  `BILTY_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`),
  KEY `voucher_fk_year_id` (`YEAR_ID`),
  CONSTRAINT `voucher_fk_comp_id` FOREIGN KEY (`COMP_ID`) REFERENCES `company` (`COMP_ID`),
  CONSTRAINT `voucher_fk_year_id` FOREIGN KEY (`YEAR_ID`) REFERENCES `fin_years` (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucher
-- ----------------------------
INSERT INTO `voucher` VALUES ('PL120001', '2017-11-30', '2017-12-15 05:17:20', null, null, null, 'on', null, null, '01', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('JV120001', '2017-12-13', '2017-12-15 08:45:23', null, null, null, 'on', null, null, '02', '17', null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `voucherdet`;
CREATE TABLE `voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `debit` decimal(20,2) DEFAULT NULL,
  `credit` decimal(20,2) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ER` decimal(65,30) DEFAULT NULL,
  `UNIT_RATE` decimal(65,30) DEFAULT NULL,
  `TT_NO` varchar(30) DEFAULT NULL,
  `REG_NO` varchar(30) DEFAULT NULL,
  `post_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `CHQ_NO` varchar(100) DEFAULT NULL,
  `CHQ_DATE` date DEFAULT NULL,
  `CHQ_CLR_DATE` date DEFAULT NULL,
  `mode_id` varchar(2) DEFAULT NULL,
  `sms_no` varchar(12) DEFAULT NULL,
  `sms_time` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`),
  KEY `voucherdet_fk_acct_id` (`ACCT_ID`),
  CONSTRAINT `voucherdet_fk_v_id` FOREIGN KEY (`COMP_ID`, `YEAR_ID`, `VOUCHER_ID`) REFERENCES `voucher` (`COMP_ID`, `YEAR_ID`, `VOUCHER_ID`),
  CONSTRAINT `voucherdet_fk_acct_id` FOREIGN KEY (`ACCT_ID`) REFERENCES `nom` (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucherdet
-- ----------------------------
INSERT INTO `voucherdet` VALUES ('PL120001', '1', '2210000001', 'Supplier#1', '0.00', null, null, null, null, '01', '17', null, null, null, null, null, null, null, null, '2017-12-15 05:17:20', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL120001', '2', '1310000001', 'Bill#120001', null, '0.00', null, null, null, '01', '17', null, null, null, null, null, null, null, null, '2017-12-15 05:17:20', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '001', '2610000001', 'Opening Balance', '561398.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '002', '2610000002', 'Opening Balance', '-1765.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '003', '2610000003', 'Opening Balance', '45039.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '004', '2610000004', 'Opening Balance', '412653.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '005', '2610000005', 'Opening Balance', '13839.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '006', '2610000006', 'Opening Balance', '28970.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '007', '2610000007', 'Opening Balance', '43460.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '008', '2610000008', 'Opening Balance', '6600.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '009', '2610000009', 'Opening Balance', '33074.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '010', '2610000010', 'Opening Balance', '1703991.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '011', '2610000011', 'Opening Balance', '584726.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '012', '2610000012', 'Opening Balance', '255314.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '013', '2610000013', 'Opening Balance', '336699.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '014', '2610000014', 'Opening Balance', '6003.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '015', '2610000015', 'Opening Balance', '97474.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '016', '2610000016', 'Opening Balance', '490121.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '017', '2610000017', 'Opening Balance', '99097.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '018', '2610000018', 'Opening Balance', '79360.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '019', '2610000019', 'Opening Balance', '1638978.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '020', '2610000021', 'Opening Balance', '1277023.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '021', '2610000022', 'Opening Balance', '6374.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '022', '2610000023', 'Opening Balance', '70000.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '023', '2610000024', 'Opening Balance', '277272.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '024', '2610000025', 'Opening Balance', '221542.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '025', '2610000027', 'Opening Balance', '81323.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '026', '2610000028', 'Opening Balance', '78757.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '027', '2610000029', 'Opening Balance', '16052.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '028', '2610000030', 'Opening Balance', '91372.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '029', '2610000031', 'Opening Balance', '316231.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '030', '2610000032', 'Opening Balance', '189272.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '031', '2610000033', 'Opening Balance', '24164.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '032', '2610000035', 'Opening Balance', '38241.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '033', '2610000037', 'Opening Balance', '70531.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '034', '2610000038', 'Opening Balance', '3798.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '035', '2610000039', 'Opening Balance', '210582.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '036', '2610000040', 'Opening Balance', '92752.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '037', '2610000041', 'Opening Balance', '56138.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '038', '2610000044', 'Opening Balance', '572.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '039', '2610000046', 'Opening Balance', '192829.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '040', '2610000047', 'Opening Balance', '308188.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '041', '2610000049', 'Opening Balance', '115223.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '042', '2610000050', 'Opening Balance', '88039.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '043', '2610000051', 'Opening Balance', '46326.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '044', '2610000054', 'Opening Balance', '160812.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '045', '2610000056', 'Opening Balance', '21073.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '046', '2610000057', 'Opening Balance', '138809.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '047', '2610000058', 'Opening Balance', '13840.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '048', '2610000059', 'Opening Balance', '4420028.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '049', '2610000060', 'Opening Balance', '308943.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '050', '2610000061', 'Opening Balance', '121094.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '051', '2610000062', 'Opening Balance', '30672.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '052', '2610000063', 'Opening Balance', '148765.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '053', '2610000064', 'Opening Balance', '215143.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '054', '2610000065', 'Opening Balance', '112743.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '055', '2610000066', 'Opening Balance', '14016.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '056', '2610000067', 'Opening Balance', '43804.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '057', '2610000068', 'Opening Balance', '117724.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '058', '2610000069', 'Opening Balance', '92511.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '059', '2610000070', 'Opening Balance', '322117.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '060', '2610000071', 'Opening Balance', '88192.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '061', '2610000072', 'Opening Balance', '137901.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '062', '2610000073', 'Opening Balance', '52281.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '063', '2610000074', 'Opening Balance', '332760.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '064', '2610000075', 'Opening Balance', '166098.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '065', '2610000076', 'Opening Balance', '78973.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '066', '2610000077', 'Opening Balance', '16904.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '067', '2610000078', 'Opening Balance', '249824.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '068', '2610000079', 'Opening Balance', '139658.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '069', '2610000080', 'Opening Balance', '16135.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '070', '2610000081', 'Opening Balance', '141429.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '071', '2610000082', 'Opening Balance', '108716.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV120001', '072', '2610000083', 'Opening Balance', '407040.00', null, null, null, null, '02', '17', null, null, null, null, null, null, null, null, '2017-12-15 08:45:23', null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `voucher_id`
-- ----------------------------
DROP TABLE IF EXISTS `voucher_id`;
CREATE TABLE `voucher_id` (
  `v_id` int(11) DEFAULT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucher_id
-- ----------------------------
INSERT INTO `voucher_id` VALUES ('1', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('11', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('12', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('15', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('16', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('17', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('11', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('12', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('21', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'ST', '01');
INSERT INTO `voucher_id` VALUES ('14', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('15', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('22', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('23', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'PR', '01');
INSERT INTO `voucher_id` VALUES ('16', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('24', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('17', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('21', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('22', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('23', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('25', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('24', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('26', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('27', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('25', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('2', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('3', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('28', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('29', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('26', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('27', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('28', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('29', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('30', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('31', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('32', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('33', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('34', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('35', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('36', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('37', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('38', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('39', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('40', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('41', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('4', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('42', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('44', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('45', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('46', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('47', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('6', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('48', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('30', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('31', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('49', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('5', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('6', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('5', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('9', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('10', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('32', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('33', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('34', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('35', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('36', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('37', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('38', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('50', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('52', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('53', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('54', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('55', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('39', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'ST', '01');
INSERT INTO `voucher_id` VALUES ('40', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('41', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('56', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('42', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('43', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('57', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('44', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('58', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('45', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('46', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('59', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('60', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('47', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('7', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('6', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('48', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('61', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('49', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('50', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('51', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('52', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('62', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('53', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('63', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('54', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('55', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('56', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('64', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('57', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('58', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('65', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('59', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('66', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('60', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('61', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('62', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('67', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('63', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('68', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('64', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('69', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('65', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('66', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('67', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('70', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('71', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('68', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('69', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('70', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('72', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('71', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('72', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('73', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('74', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('73', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('75', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('11', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('76', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('77', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('78', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('74', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('79', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('75', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('80', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('81', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('76', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('82', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('83', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('85', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('86', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('87', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('77', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('78', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('88', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('79', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('80', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('81', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('82', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('83', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('84', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('85', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('89', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('86', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('87', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('88', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('90', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('91', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('92', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('89', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('90', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('93', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('94', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('91', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('95', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('96', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('97', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('92', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('98', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('99', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('93', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('94', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('100', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('95', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('96', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('97', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('98', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('99', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('11', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('7', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('100', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('101', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('102', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('103', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('104', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('12', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('105', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('106', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('8', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('107', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('108', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('109', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('101', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('102', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('103', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('104', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('105', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('106', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('107', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('108', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('110', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('111', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('109', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('112', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('113', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('110', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('114', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('111', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('112', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('113', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('114', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('115', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('115', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('116', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('116', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('117', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('118', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('119', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('117', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('118', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('119', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('120', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('120', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('121', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('122', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('123', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('124', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('121', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('125', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('122', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('123', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('124', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('125', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('126', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('126', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('127', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('128', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('129', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('130', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('131', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('132', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('133', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('134', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('135', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('136', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('137', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('138', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('139', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('140', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('127', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('141', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('128', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('142', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('129', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('143', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('144', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('145', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('146', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('147', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('130', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('148', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('131', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('149', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('132', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('150', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('133', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('151', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('152', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('153', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('154', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('134', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('135', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('136', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('137', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('138', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('155', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('139', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('140', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('156', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('141', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('157', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('158', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('142', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('159', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('143', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('144', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('160', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('161', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('162', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('163', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('164', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('145', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('165', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('146', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('166', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('167', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('147', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('168', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('169', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('148', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('149', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('170', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('171', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('150', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('151', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('172', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('173', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('9', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('152', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('153', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('12', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('13', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('154', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('155', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('174', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('175', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('156', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('176', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('157', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('158', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('159', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('177', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('178', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('179', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('180', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('181', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('160', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('161', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('182', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('183', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('184', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('10', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('185', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('186', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'BR', '01');
INSERT INTO `voucher_id` VALUES ('187', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('162', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('11', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('163', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('188', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('189', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('190', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('164', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('191', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('192', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('165', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('166', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('167', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('168', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('193', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('169', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('170', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('194', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('195', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('171', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('196', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('172', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('173', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('174', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('175', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('197', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('176', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('177', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('198', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('199', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('200', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('178', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('201', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('202', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('179', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('203', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('204', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('205', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('206', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('207', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('208', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('209', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('210', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('211', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('212', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('213', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('214', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('215', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('216', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('217', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('218', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('219', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('220', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('221', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('222', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('180', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('223', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('181', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('224', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('182', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('225', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('226', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('183', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('227', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('184', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('228', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('185', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('229', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('230', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('231', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('232', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('186', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('233', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('234', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('235', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('236', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('237', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('187', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('238', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('188', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('239', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('240', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('189', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('241', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('242', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('190', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('243', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('244', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('191', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('245', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('246', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('247', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('192', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('193', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('248', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('194', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('195', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('196', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('249', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('250', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('251', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('197', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('252', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('198', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('253', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('199', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('15', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('254', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('200', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('201', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('255', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('202', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('256', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('257', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('203', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('258', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('204', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('259', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('260', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('205', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('261', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('206', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('207', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('262', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('208', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('263', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('209', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('210', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('264', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('211', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('265', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('212', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('266', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('267', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('268', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('269', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('270', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('271', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('213', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('272', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('273', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('274', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('275', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('214', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('15', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('276', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('215', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('16', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('277', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('216', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('278', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('217', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('279', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('218', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('280', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('281', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('282', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('283', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('219', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('284', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('285', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('286', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('220', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('287', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('16', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('17', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('17', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('18', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('288', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('2', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('289', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('290', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('221', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('291', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('292', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('222', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('223', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('293', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('224', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('294', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('295', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('296', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('225', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('226', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('297', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('298', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('227', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('299', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('300', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('301', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('228', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('302', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('229', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('230', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('303', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('231', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('304', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('232', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('305', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('306', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('307', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('308', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('309', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('233', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('310', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('311', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('234', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('312', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('313', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('235', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('314', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('315', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('316', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('236', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('317', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('237', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('318', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('238', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('319', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('320', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('321', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('322', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('323', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('239', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('240', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('241', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('324', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('325', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('326', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('327', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('328', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('242', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('329', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('243', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('244', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('330', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('331', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('245', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('332', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('246', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('333', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('334', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('247', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('335', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('336', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('248', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('337', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('338', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('249', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('339', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('340', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('341', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('250', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('342', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('343', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('344', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('251', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('345', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('252', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('346', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('347', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('348', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('253', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('254', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('349', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('255', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('350', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('256', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('351', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('257', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('258', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('352', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('353', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('354', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('355', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('259', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('356', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('260', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('357', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('358', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('261', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('262', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('359', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('360', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('361', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('263', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('3', 'BP', '01');
INSERT INTO `voucher_id` VALUES ('264', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('362', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('363', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('265', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('364', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('266', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('365', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('267', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('366', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('367', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('268', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('368', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('369', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('370', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('269', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('371', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('270', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('271', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('272', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('273', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('13', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('274', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('275', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('372', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('373', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('276', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('374', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('375', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('376', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('277', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('278', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('377', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('279', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('378', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('379', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('280', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('281', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('380', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('381', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('382', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('282', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('383', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('384', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('283', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('385', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('386', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('387', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('388', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('284', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('285', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('389', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('390', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('286', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('391', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('392', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('287', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('393', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('394', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('288', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('395', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('396', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('397', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('289', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('290', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('291', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('398', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('292', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('399', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('400', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('293', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('401', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('294', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('402', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('403', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('295', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('296', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('297', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('404', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('298', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('405', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('299', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('300', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('406', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('407', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('301', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('408', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('302', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('409', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('303', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('410', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('304', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('411', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('412', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('413', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('305', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('306', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('414', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('415', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('307', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('416', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('417', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('308', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('418', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('419', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('309', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('310', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('311', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('312', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('313', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('314', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('315', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('316', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('317', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('420', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('318', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('421', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('422', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('423', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('424', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('319', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('425', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('320', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('426', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('321', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('322', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('323', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('20', 'CR', '01');
INSERT INTO `voucher_id` VALUES ('427', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('324', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('428', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('325', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('429', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('326', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('430', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('327', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('431', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('432', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('328', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('433', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('329', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('434', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('330', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('435', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('436', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('437', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('438', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('439', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('440', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('18', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('331', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('332', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('333', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('334', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('335', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('336', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('441', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('442', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('443', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('444', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('337', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('445', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('446', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('1', 'RT', '01');
INSERT INTO `voucher_id` VALUES ('447', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('338', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('448', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('449', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('339', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('340', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('450', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('341', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('342', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('451', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('452', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('453', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('454', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('343', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('455', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('344', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('456', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('457', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('458', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('345', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('19', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1', 'CP', 'TT');
INSERT INTO `voucher_id` VALUES ('2', 'CP', 'TT');
INSERT INTO `voucher_id` VALUES ('3', 'CP', 'TT');
INSERT INTO `voucher_id` VALUES ('346', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('347', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('459', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('348', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('460', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('14', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('20', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('15', 'JV', '01');
INSERT INTO `voucher_id` VALUES ('349', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('461', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('350', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('351', 'PL', '01');
INSERT INTO `voucher_id` VALUES ('462', 'SL', '01');
INSERT INTO `voucher_id` VALUES ('352', 'PL', '01');

-- ----------------------------
-- Table structure for `web_title`
-- ----------------------------
DROP TABLE IF EXISTS `web_title`;
CREATE TABLE `web_title` (
  `acct_id` int(11) NOT NULL AUTO_INCREMENT,
  `acct_name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of web_title
-- ----------------------------
INSERT INTO `web_title` VALUES ('1', 'Origa Chemicals');

-- ----------------------------
-- Table structure for `xls_distributors`
-- ----------------------------
DROP TABLE IF EXISTS `xls_distributors`;
CREATE TABLE `xls_distributors` (
  `p_no` varchar(255) DEFAULT NULL,
  `acct_name` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `Debit` varchar(255) DEFAULT NULL,
  `Credit` varchar(255) DEFAULT NULL,
  `Credit Note` varchar(255) DEFAULT NULL,
  `balance` varchar(255) DEFAULT NULL,
  `F9` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `F11` varchar(255) DEFAULT NULL,
  `F12` varchar(255) DEFAULT NULL,
  `F13` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_distributors
-- ----------------------------
INSERT INTO `xls_distributors` VALUES ('126', 'Seven Star Traders Quetta.', 'Quetta.', '0313-8285138', '561398', '0', '0', '561398', '', 'Quetta', '', '', '');
INSERT INTO `xls_distributors` VALUES ('234', 'Tahir Sb. Lahore. (Pelle)', ' Mian Channu.', '0321-8892665', '121000', '116000', '6765', '-1765', '', 'Central', '', '', '');
INSERT INTO `xls_distributors` VALUES ('242', 'Fzami Trading Co. Lahore.   ', 'Lahore.', '0321-4062807', '151513', '95000', '11474', '45039', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('230', 'Nisar Sb. Merdan.', 'Merdan.', '0333-9854234', '389049', '0', '133735', '255314', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('228', 'Ch. House   (Talha Sb.)', 'Lahore.', '0331-3385784', '478153', '65500', '0', '412653', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('70', 'Hanan Traders Lahore', 'Lahore.', '0324-4546001', '31509', '3000', '14670', '13839', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('8', 'Faseeh Traders Lahore.', 'Lahore.', '0322-8426047', '49970', '21000', '0', '28970', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('10', 'Naveed Sb Lahore.', 'Lahore.', '0345-4100826', '118140', '74680', '0', '43460', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('16', 'Hasham Traders Rawala Kot.', 'Rawala Kot.', '0333-5269927', '845699', '509000', '0', '336699', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('', 'Fira Cosmetics Lahore.', 'Lahore.', '0321-4590030', '6600', '0', '0', '6600', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('38', 'Shoaib & Brothers Lahore.', 'Sher Shah Lahore.', '0333-4047507', '19901', '9100', '4798', '6003', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('148', 'Abdul Rehman Traders.', 'Lahore.', '0321-4851639****', '33074', '0', '0', '33074', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('150', 'Bhatti Traders, Lahore.', 'Mochi Pura Lahore.', '0304-8966082', '126474', '29000', '0', '97474', '', 'Central ', '', '', '');
INSERT INTO `xls_distributors` VALUES ('126', 'Hanan Traders D.G.Khan.', 'D.G.Khan.', '0334-7171222', '2052277', '1300000', '262156', '490121', '', 'D.G.Khan', '', '', '');
INSERT INTO `xls_distributors` VALUES ('142', 'Al-Madni Nawaz Agencies.', 'Sadiq Abad.', '0300-8612450', '99097', '0', '0', '99097', '', 'D.G.Khan', '', '', '');
INSERT INTO `xls_distributors` VALUES ('144', 'Waqar Traders.', 'Khan Pur.', '0306-5435551', '104360', '25000', '0', '79360', '', 'D.G.Khan', '', '', '');
INSERT INTO `xls_distributors` VALUES ('124', 'Riaz Sb. Karachi.', 'Karachi.', '0333-9243342', '2525554', '0', '886576', '1638978', '', 'Karachi', '', '', '');
INSERT INTO `xls_distributors` VALUES ('125', 'Hania Traders Karachi.', 'Karachi.', '0336-1841305', '576568', '0', '576568', '0', '', 'Karachi', '', '', '');
INSERT INTO `xls_distributors` VALUES ('128', 'Javed Traders Hderabad.', 'Hyderabad.', '0300-3043879', '3045168', '1300000', '468145', '1277023', '', 'Karachi', '', '', '');
INSERT INTO `xls_distributors` VALUES ('6', 'Emaan Traders Sargodha.', 'Sargodha.', '0308-7544950', '61547', '20000', '35173', '6374', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('6', 'Talha Traders Sargodha', 'Sargodha.', '0333-8448951', '982827', '545000', '367827', '70000', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('12', 'Abdullah Traders Lahore.', 'Lahore.', '0336-4745288', '6347174', '3444244', '1198939', '1703991', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('34', 'Friends Traders Daska.', 'Daska.', '0300-7464022', '474210', '195000', '1938', '277272', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('36', 'A.A. Enterprises Gujrat.', 'Gujrat.', '0333-2105352', '521014', '255000', '44472', '221542', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('42', 'Hamad Traders Kasur.', 'Kasur.', '0300-4344080', '154604', '74400', '80204', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('43', 'Madina Traders Kasur.', 'Kasur.', '0322-7186591', '239169', '125000', '32846', '81323', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('44', 'Honey Traders.   ', 'Khuddian.', '0305-7132979', '158557', '65000', '14800', '78757', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('46', 'Hamza Traders.', 'Lala Musa.', '0302-6251170', '124139', '45000', '63087', '16052', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('47', 'Pak Traders.', 'Lala Musa.', '0321-6204335', '91372', '0', '0', '91372', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('48', 'Imran Traders Shekhupura.', 'Shekhupura. ', '0300-4987134', '753067', '333000', '103836', '316231', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('50', 'Waqar Traders Jehlum.', 'Jehlum.', '0307-5895610', '511197', '319000', '2925', '189272', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('52', 'Usman Traders Bhalwal', 'Bhalwal', '0321-6544085', '55164', '31000', '0', '24164', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('54', 'Aamir Traders Kamonki', 'Sadhoki (Kamonki)', '0300-4604356', '0', '0', '0', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('54', 'Anila General Store', 'Kamonki', '0323-7045641', '172450', '90000', '44209', '38241', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('58', 'Haider Traders Khanqah Dogran', 'Khanqah Dogran', '0301-4755098', '65013', '25649', '39364', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('60', 'Al-Macca Traders', 'Sharq Pur', '0301-4517220', '247789', '160000', '17258', '70531', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('62', 'Rameez Traders', 'Sialkot', '0300-6101296', '106297', '55000', '47499', '3798', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('62', 'Farwa Trades.', 'Sialkot', '0300-9619391', '393737', '145000', '38155', '210582', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('64', 'Zain Traders', 'Rai Wind', '0333-4303179', '298812', '148000', '58060', '92752', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('70', 'M.A.Traders Pattoki.', 'Pattoki.', '0300-4566124', '205640', '119000', '30502', '56138', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('72', 'Ahmed Subhan Traders.', 'Mureed Key', '0300-4706114', '119638', '60000', '59638', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('79', 'Younas Traders Deenga.', 'Deenga.', '0300-6288270', '25863', '0', '25863', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('78', 'Awan Traders Frooq Abad', 'Frooq Abad', '0344-4321892', '39639', '5550', '33517', '572', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('80', 'Rehman Traders Narang Mandi', 'Narang Mandi', '0333-4147313', '0', '0', '0', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('80', 'Ajmal Traders Narang Mandi', 'Ajmal Narang Mandi', '0300-7776584', '435274', '237130', '5315', '192829', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('74', 'Shami Enterprises.', 'Gujranwala.', '0300-6473326', '1496378', '780370', '407820', '308188', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('82', 'Naro Enterprises.', 'Samberyal.', '0312-5766425', '59006', '10000', '49006', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('84', 'Sardar Traders.', 'Kotla Arab Ali Khan.', '0301-6216003', '164209', '40000', '36170', '88039', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('94', 'Ali Traders Samberyal.', 'Samberyal.', '0331-6712306', '273107', '25000', '132884', '115223', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('100', 'Sardar Nawab Phool Nagar.', 'Phool Nagar.', '0305-6574054', '79451', '32300', '825', '46326', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('114', 'Javed Nankana Sahib.', ' Nankana Sahib.', '0300-4899409', '53082', '26190', '26892', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('134', 'Saquie Genaral Store.', 'Talwandi Bhandran.', '0333-7776803', '262427', '90000', '11615', '160812', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('136', 'Sabri Traders Uggoki.', 'Uggoki.', '0334-7868600', '41273', '0', '41273', '0', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('138', 'Jeem Traders Hafiz Abaz.', 'Hafiz Abaz.', '0345-6626050', '59073', '38000', '0', '21073', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('138', 'Vicky Traders Hafiz Abaz.', 'Hafiz Abaz.', '0345-6626050', '158809', '20000', '0', '138809', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('146', 'Alpha Traders Lahore.', 'Lahore.', '0300-4281428', '716035', '0', '131309', '584726', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('152', 'Asghar Kiryana, Mano Chak..', 'Mano Chak..', '0348-7222166', '33840', '20000', '0', '13840', '', 'Lahore', '', '', '');
INSERT INTO `xls_distributors` VALUES ('122', 'Usman Agencies Multan.', 'Multan.', '0333-6102905', '7150028', '2590000', '140000', '4420028', '', 'Multan', '', '', '');
INSERT INTO `xls_distributors` VALUES ('96', 'Afaq General Store.', 'Chishtian.', '0303-2502369', '470943', '162000', '0', '308943', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('98', 'Zain Traders.', 'Baseer Pur.', '0304-4488602', '171094', '50000', '0', '121094', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('100', 'Sardar Nawab General Store.', 'Phool Nagar.', '0305-6574054', '', '', '', '0', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('102', 'Master Traders', 'Minchan Abad.', '0304-8273695', '99208', '10000', '58536', '30672', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('104', 'Hamza Traders Bahawal Nagar', 'Bahawal Nagar.', '0308-2945102', '315143', '100000', '0', '215143', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('106', 'Pappu Genaral Store.', 'Pak Pattan.', '0300-8758304', '182743', '70000', '0', '112743', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('40', 'Shabbir Traders Choonian. ', 'Choonian.', '0301-4002423', '29324', '8000', '7308', '14016', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('40', 'Milhen Traders Choonian', 'Milhen Choonian', '0300-6541742', '96178', '9381', '42993', '43804', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('108', 'Ch. Pappu Traders.', 'Depal Pur.', '0302-4992762', '144724', '27000', '0', '117724', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('102', 'Zubair Cosmetics.', 'Minchan Abad.', '0305-7235747', '193765', '45000', '0', '148765', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('110', 'Ahsin Traders.', 'Havely Lakha.', '0333-6975926', '107511', '15000', '0', '92511', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('112', 'Riasat Traders Vehari.', 'Vehari.', '0302-2684600', '558117', '236000', '0', '322117', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('116', 'Nizami Traders Kamalia.', 'Kamalia.', '0304-9704358', '192109', '80000', '23917', '88192', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('118', 'Chaudhary Traders.', 'Bunga Hayat.', '0308-4843155', '192901', '55000', '0', '137901', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('56', 'Salman Yousaf Sahiwal', 'Sahiwal.', '0323-6944159', '118225', '50000', '15944', '52281', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('57', 'Naeem Shahzad Sahiwal.', 'Sahiwal.', '0300-9699145', '538760', '206000', '0', '332760', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('120', 'Maqbool Multi Store.', 'Bure Wala.', '0300-6990040', '256098', '90000', '0', '166098', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('130', 'Al-Qaim Traders Mian Channu.', 'Mian Channu.', '0336-7009801', '181973', '103000', '0', '78973', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('132', 'Imran Book Depot Hasil Pur.', 'Hasil Pur.', '0303-7138266', '23904', '7000', '0', '16904', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('66', 'Saad Traders Okara ', 'Saad Okara ', '0321-6950537', '490268', '224500', '15944', '249824', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('68', 'Zafran Traders Arif Wala.', 'Arif Wala.', '0323-7170336', '283883', '124000', '20225', '139658', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('76', 'Jafar & Sons Theeng Moor', 'Theeng Moor', '0332-4100684', '70134', '35000', '18999', '16135', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('77', 'Ayyan Traders Theeng More.', 'Theeng Moor', '0308-5230899', '236429', '95000', '0', '141429', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('88', 'Ahmer Traders.', 'Renala Khurd', '0306-6597858', '159716', '51000', '0', '108716', '', 'Sahiwal', '', '', '');
INSERT INTO `xls_distributors` VALUES ('154', 'Ta Ta Traders,  Ghotki (Sukkhar)', 'Ghotki (Sukkhar)', '0322-5420726', '407040', '0', '0', '407040', '', 'D.G.Khan', '', '', '');

-- ----------------------------
-- Table structure for `xls_item_wellcome_dist`
-- ----------------------------
DROP TABLE IF EXISTS `xls_item_wellcome_dist`;
CREATE TABLE `xls_item_wellcome_dist` (
  `F1` varchar(255) DEFAULT NULL,
  `F2` varchar(255) DEFAULT NULL,
  `F3` varchar(255) DEFAULT NULL,
  `F4` varchar(255) DEFAULT NULL,
  `F5` varchar(255) DEFAULT NULL,
  `F6` varchar(255) DEFAULT NULL,
  `F7` varchar(255) DEFAULT NULL,
  `F8` varchar(255) DEFAULT NULL,
  `F9` varchar(255) DEFAULT NULL,
  `F10` varchar(255) DEFAULT NULL,
  `F11` varchar(255) DEFAULT NULL,
  `F12` varchar(255) DEFAULT NULL,
  `F13` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_item_wellcome_dist
-- ----------------------------
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Whitening Cream.', '144 Pcs.', '22440', '12+2', '19234.285714', '0.15', '16349.142857', '0.02', '16022.16', '230', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Deeco Whitening Serum.', '144 Pcs.', '10368', '12+1', '9570.4615385', '0.15', '8134.8923077', '0.02', '7972.1944615', '120', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Deeco Face Cleanser Serum.', '144 Pcs.', '10368', '12+1', '9570.4615385', '0.15', '8134.8923077', '0.02', '7972.1944615', '120', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Deeco Anti Hair Fall Serum.', '144 Pcs.', '10368', '12+1', '9570.4615385', '0.15', '8134.8923077', '0.02', '7972.1944615', '120', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Fast Facial Jar.', '96 Jar.', '0', '12+2', '0', '0.15', '0', '0.02', '0', '', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Fast Facial (Sachet)', '576 Pcs.', '10080', '12+1', '9304.6153846', '0.15', '7908.9230769', '0.02', '7750.7446154', '30', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Fast Wax Jar', '96 Jar.', '7360', '12+2', '6308.5714286', '0.15', '5362.2857143', '0.02', '5255.04', '', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Peach Bleach Parlor Pack', '12 Pcs.', '4320', '0', '4320', '0.15', '3672', '0.02', '3598.56', '425', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Bleach Cream (Sachet)', '576 Pcs.', '4032', '0', '4032', '0.15', '3427.2', '0.02', '3358.656', '10', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Haldi Chandan (Sachet)', '672Pcs.', '4704', '0', '4704', '0.15', '3998.4', '0.02', '3918.432', '10', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Lovely  Cream (Sachet)', '1296 Pcs.', '9072', '0', '9072', '0.15', '7711.2', '0.02', '7556.976', '10', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Blakee Hair Color (45)Black.', '192 Pcs.', '2678', '0', '2678', '0.15', '2276.3', '0.02', '2230.774', '25', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Blakee Hair Color (43)Brown.', '192 Pcs.', '2678', '0', '2678', '0.15', '2276.3', '0.02', '2230.774', '25', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair/R Lotion (L) 120g.', '72 Pcs.', '7200', '12+12', '3600', '0.15', '3060', '0.02', '2998.8', '120', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair/R Lotion (R) 120g.', '72 Pcs.', '7200', '12+12', '3600', '0.15', '3060', '0.02', '2998.8', '120', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair/R Lotion (A) 120g.', '72 Pcs.', '7200', '12+12', '3600', '0.15', '3060', '0.02', '2998.8', '120', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair/R Lotion (L) 80g.', '96 Pcs.', '7168', '12+12', '3584', '0.15', '3046.4', '0.02', '2985.472', '80', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair/R Lotion (R) 80g.', '96 Pcs.', '7168', '12+12', '3584', '0.15', '3046.4', '0.02', '2985.472', '80', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair/R Lotion (A) 80g.', '96 Pcs.', '7168', '12+12', '3584', '0.15', '3046.4', '0.02', '2985.472', '80', '', '');
INSERT INTO `xls_item_wellcome_dist` VALUES ('', 'Welcome Hair Remover (Sachet)', '672 Pcs.', '4032', '0', '4032', '0.15', '3427.2', '0.02', '3358.656', '10', '', '');

-- ----------------------------
-- View structure for `v_cost_centre`
-- ----------------------------
DROP VIEW IF EXISTS `v_cost_centre`;
CREATE ALGORITHM=UNDEFINED DEFINER=`click`@`%` SQL SECURITY DEFINER VIEW `v_cost_centre` AS select `cnlxidtp_click_origa`.`nom`.`ACCT_ID` AS `acct_id`,`cnlxidtp_click_origa`.`nom`.`ACCT_NAME` AS `acct_name` from `nom` where ((substr(`cnlxidtp_click_origa`.`nom`.`ACCT_ID`,1,2) = '99') and (length(`cnlxidtp_click_origa`.`nom`.`ACCT_ID`) = 10)) ;

-- ----------------------------
-- View structure for `v_current_qty`
-- ----------------------------
DROP VIEW IF EXISTS `v_current_qty`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_current_qty` AS select `v`.`comp_id` AS `comp_id`,`v`.`stock_code` AS `stock_code`,`v`.`db_qty` AS `db_qty`,`v`.`cr_qty` AS `cr_qty`,sum((ifnull(`v`.`db_qty`,0) - ifnull(`v`.`cr_qty`,0))) AS `bal_qty` from `v_stk` `v` where ((1 = 1) and ((`v`.`db_qty` is not null) or (`v`.`cr_qty` is not null))) group by `v`.`comp_id`,`v`.`stock_code` ;

-- ----------------------------
-- View structure for `v_grp_item`
-- ----------------------------
DROP VIEW IF EXISTS `v_grp_item`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_grp_item` AS select 'KT' AS `comp_id`,`item`.`stock_code` AS `stock_code`,`item`.`description` AS `description`,`item`.`p_rate` AS `p_rate`,`item`.`s_rate` AS `s_rate` from `item` union all select 'BT' AS `comp_id`,`item`.`stock_code` AS `stock_code`,`item`.`description` AS `description`,`item`.`p_rate` AS `p_rate`,`item`.`s_rate` AS `s_rate` from `item` union all select 'IT' AS `comp_id`,`item`.`stock_code` AS `stock_code`,`item`.`description` AS `description`,`item`.`p_rate` AS `p_rate`,`item`.`s_rate` AS `s_rate` from `item` ;

-- ----------------------------
-- View structure for `v_item`
-- ----------------------------
DROP VIEW IF EXISTS `v_item`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_item` AS select `i`.`stock_code` AS `stock_code`,`i`.`party_stock_code` AS `party_stock_code`,concat(`i`.`stock_code`,convert(if((isnull(`i`.`party_stock_code`) or (`i`.`party_stock_code` = '')),'','-') using latin1),ifnull(`i`.`party_stock_code`,'')) AS `item_code`,concat(ifnull(`i`.`party_stock_code`,''),' ',`i`.`description`,' - ',`c`.`CAT_NAME`) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`i`.`cat_id` AS `cat_id` from (`item` `i` left join `prod_cat` `c` on((`i`.`cat_id` = `c`.`CAT_ID`))) ;

-- ----------------------------
-- View structure for `v_item_bal`
-- ----------------------------
DROP VIEW IF EXISTS `v_item_bal`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_item_bal` AS select `i`.`stock_code` AS `stock_code`,concat(convert(`i`.`description` using utf8),'-',convert(`c`.`COMP_NAME` using utf8),'-',round(`v`.`bal_qty`,0)) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`v`.`bal_qty` AS `bal_qty` from ((`item` `i` left join `v_current_qty` `v` on((`i`.`stock_code` = `v`.`stock_code`))) left join `company` `c` on((`v`.`comp_id` = `c`.`COMP_ID`))) ;

-- ----------------------------
-- View structure for `v_nom`
-- ----------------------------
DROP VIEW IF EXISTS `v_nom`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_nom` AS select `n`.`acct_id` AS `acct_id`,concat(`n`.`acct_name`,convert(if((ifnull(`n`.`address`,'') = ''),'',', ') using latin1),ifnull(`n`.`address`,''),convert(if((ifnull(`n`.`city`,'') = ''),'',', ') using latin1),ifnull(`n`.`city`,''),if(isnull(`n`.`page_no`),'',concat('-P#',`n`.`page_no`))) AS `acct_name`,`n`.`reg_id` AS `reg_id` from `nom` `n` ;

-- ----------------------------
-- View structure for `v_party`
-- ----------------------------
DROP VIEW IF EXISTS `v_party`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_party` AS select `n`.`acct_id` AS `acct_id`,`n`.`acct_name` AS `acct_name`,(case when (substr(`n`.`acct_id`,1,6) = `s`.`creditor_id`) then 'S' when (substr(`n`.`acct_id`,1,6) = `s`.`debtor_id`) then 'C' when (substr(`n`.`acct_id`,1,6) = `s`.`stock_id`) then 'P' else 'O' end) AS `party_type`,`n`.`city` AS `city`,`n`.`reg_id` AS `reg_id`,`n`.`sp_id` AS `sp_id`,`n`.`address` AS `address`,`n`.`phone` AS `phone`,`n`.`cnic` AS `cnic` from (`nom` `n` join `system` `s`) where (((`n`.`acct_id` = '0100010001') or (substr(`n`.`acct_id`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`))) and (length(`n`.`acct_id`) = 10)) ;

-- ----------------------------
-- View structure for `v_party_bal`
-- ----------------------------
DROP VIEW IF EXISTS `v_party_bal`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0) ;

-- ----------------------------
-- View structure for `v_party_city`
-- ----------------------------
DROP VIEW IF EXISTS `v_party_city`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_party_city` AS select distinct `nom`.`city` AS `city` from `nom` where (`nom`.`city` is not null) ;

-- ----------------------------
-- View structure for `v_p_vouchers`
-- ----------------------------
DROP VIEW IF EXISTS `v_p_vouchers`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_p_vouchers` AS select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,(`d`.`qty` * `d`.`avg_rate`) AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) ;

-- ----------------------------
-- View structure for `v_stk`
-- ----------------------------
DROP VIEW IF EXISTS `v_stk`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_stk` AS select 1 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,if((isnull(`m`.`bill_date`) or (`m`.`bill_date` = '1970-01-01')),`m`.`voucher_date`,`m`.`bill_date`) AS `bill_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select 2 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,if((isnull(`m`.`bill_date`) or (`m`.`bill_date` = '1970-01-01')),`m`.`voucher_date`,`m`.`bill_date`) AS `bill_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,(`d`.`qty` * `d`.`avg_rate`) AS `cr_amt` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select 3.1 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select 3.2 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) ;

-- ----------------------------
-- View structure for `v_voucherdet_pay`
-- ----------------------------
DROP VIEW IF EXISTS `v_voucherdet_pay`;
CREATE ALGORITHM=UNDEFINED DEFINER=`click`@`%` SQL SECURITY DEFINER VIEW `v_voucherdet_pay` AS select 1 AS `voucher_id`,1 AS `lineitem`,1 AS `acct_id`,1 AS `acct_name` ;

-- ----------------------------
-- View structure for `v_vouchers`
-- ----------------------------
DROP VIEW IF EXISTS `v_vouchers`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp_clickso`@`localhost` SQL SECURITY DEFINER VIEW `v_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`voucher_date` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`acct_name` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`acct_id`))) where (`v`.`POSTED` = 'on') ;

-- ----------------------------
-- View structure for `v_vouchers_07_06_17`
-- ----------------------------
DROP VIEW IF EXISTS `v_vouchers_07_06_17`;
CREATE ALGORITHM=UNDEFINED DEFINER=`click`@`%` SQL SECURITY DEFINER VIEW `v_vouchers_07_06_17` AS select 1 AS `comp_id`,1 AS `voucher_id`,1 AS `inv_no`,1 AS `description`,1 AS `voucher_date`,1 AS `lineitem`,1 AS `acct_id`,1 AS `acct_id_cs_1`,1 AS `acct_id_cs_2`,1 AS `debit`,1 AS `credit`,1 AS `acct_name`,1 AS `particulars`,1 AS `posted` ;

-- ----------------------------
-- Function structure for `f_pl_invoice_products`
-- ----------------------------
DROP FUNCTION IF EXISTS `f_pl_invoice_products`;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `f_pl_invoice_products`(`p_comp_id` VARCHAR(2), `p_voucher_id` VARCHAR(10)) RETURNS text CHARSET latin1
    NO SQL
    DETERMINISTIC
BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from pl_invoicedet d left join item i on 

d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.voucher_id=p_voucher_id order by d.itemtot desc;

DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
 
RETURN (substring(cProd_Name,3));
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for `f_sl_invoice_products`
-- ----------------------------
DROP FUNCTION IF EXISTS `f_sl_invoice_products`;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `f_sl_invoice_products`(`p_comp_id` VARCHAR(2), `p_voucher_id` VARCHAR(10)) RETURNS text CHARSET latin1
    NO SQL
    DETERMINISTIC
BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from sl_invoicedet d left join item i on 

d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.voucher_id=p_voucher_id order by d.itemtot desc;

DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
 
RETURN (substring(cProd_Name,3));
END
;;
DELIMITER ;
