DELIMITER $$

CREATE FUNCTION `f_sl_invoice_products`(`p_comp_id` VARCHAR(2), `p_year_id` VARCHAR(2), `p_voucher_id` VARCHAR(10)) RETURNS TEXT CHARSET latin1 DETERMINISTIC NO SQL SQL SECURITY DEFINER 

BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from sl_invoicedet d left join item i on 

d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.year_id = p_year_id and d.voucher_id=p_voucher_id order by d.itemtot desc;

DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
 
RETURN (substring(cProd_Name,3));
END$$



DELIMITER $$

CREATE FUNCTION `f_pl_invoice_products`(`p_comp_id` VARCHAR(2), `p_year_id` VARCHAR(2), `p_voucher_id` VARCHAR(10)) RETURNS TEXT CHARSET latin1 DETERMINISTIC NO SQL SQL SECURITY DEFINER 

BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from pl_invoicedet d left join item i on 

d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.year_id = p_year_id and d.voucher_id=p_voucher_id order by d.itemtot desc;

DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
 
RETURN (substring(cProd_Name,3));
END$$
