CREATE VIEW `v_cost_centre` AS select `nom`.`ACCT_ID` AS `acct_id`,`nom`.`ACCT_NAME` AS `acct_name` from `nom` where ((substr(`nom`.`ACCT_ID`,1,2) = '99') and (length(`nom`.`ACCT_ID`) = 10));
CREATE VIEW `v_stk` AS select 1 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,if((isnull(`m`.`bill_date`) or (`m`.`bill_date` = '1970-01-01')),`m`.`voucher_date`,`m`.`bill_date`) AS `bill_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select 2 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,if((isnull(`m`.`bill_date`) or (`m`.`bill_date` = '1970-01-01')),`m`.`voucher_date`,`m`.`bill_date`) AS `bill_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`avg_rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,(`d`.`avg_rate` * `d`.`qty`) AS `cr_amt` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) where (`m`.`voucher_id` not in ('145','148','080002')) union all select 3.1 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select 3.2 AS `voucher_order`,`m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`voucher_date` AS `bill_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`)));
CREATE VIEW `v_current_qty` AS select `v`.`comp_id` AS `comp_id`,`v`.`stock_code` AS `stock_code`,`v`.`db_qty` AS `db_qty`,`v`.`cr_qty` AS `cr_qty`,sum((ifnull(`v`.`db_qty`,0) - ifnull(`v`.`cr_qty`,0))) AS `bal_qty` from `v_stk` `v` where ((1 = 1) and ((`v`.`db_qty` is not null) or (`v`.`cr_qty` is not null))) group by `v`.`comp_id`,`v`.`stock_code`;
CREATE VIEW `v_grp_item` AS select 'KT' AS `comp_id`,`cnlxidtp_click_kt`.`item`.`stock_code` AS `stock_code`,`cnlxidtp_click_kt`.`item`.`description` AS `description`,`cnlxidtp_click_kt`.`item`.`p_rate` AS `p_rate`,`cnlxidtp_click_kt`.`item`.`s_rate` AS `s_rate` from `cnlxidtp_click_kt`.`item` union all select 'BT' AS `comp_id`,`cnlxidtp_click_kt`.`item`.`stock_code` AS `stock_code`,`cnlxidtp_click_kt`.`item`.`description` AS `description`,`cnlxidtp_click_kt`.`item`.`p_rate` AS `p_rate`,`cnlxidtp_click_kt`.`item`.`s_rate` AS `s_rate` from `cnlxidtp_click_kt`.`item` union all select 'IT' AS `comp_id`,`cnlxidtp_click_kt`.`item`.`stock_code` AS `stock_code`,`cnlxidtp_click_kt`.`item`.`description` AS `description`,`cnlxidtp_click_kt`.`item`.`p_rate` AS `p_rate`,`cnlxidtp_click_kt`.`item`.`s_rate` AS `s_rate` from `cnlxidtp_click_kt`.`item`;
CREATE VIEW `v_item` AS select `i`.`stock_code` AS `stock_code`,ifnull(`i`.`party_stock_code`,'') AS `party_stock_code`,concat(`i`.`stock_code`,convert(if((isnull(`i`.`party_stock_code`) or (`i`.`party_stock_code` = '')),'','-') using latin1),ifnull(`i`.`party_stock_code`,'')) AS `item_code`,`i`.`description` AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`i`.`cat_id` AS `cat_id` from (`item` `i` left join `prod_cat` `c` on((`i`.`cat_id` = `c`.`CAT_ID`)));
CREATE VIEW `v_item_bal` AS select `i`.`stock_code` AS `stock_code`,concat(`i`.`description`,'-',convert(`c`.`COMP_NAME` using utf8),'-',round(`v`.`bal_qty`,0)) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`v`.`bal_qty` AS `bal_qty` from ((`cnlxidtp_click_kt`.`item` `i` left join `cnlxidtp_click_kt`.`v_current_qty` `v` on((`i`.`stock_code` = `v`.`stock_code`))) left join `cnlxidtp_click_kt`.`company` `c` on((`v`.`comp_id` = `c`.`COMP_ID`)));
CREATE VIEW `v_nom` AS select `n`.`ACCT_ID` AS `acct_id`,concat(`n`.`ACCT_NAME`,convert(if((ifnull(`n`.`address`,'') = ''),'',', ') using latin1),ifnull(`n`.`address`,''),convert(if((ifnull(`n`.`city`,'') = ''),'',', ') using latin1),ifnull(`n`.`city`,'')) AS `acct_name`,`n`.`reg_id` AS `reg_id` from `nom` `n`;
CREATE VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,(case when (substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,'010010')) then 'S' when (substr(`n`.`ACCT_ID`,1,6) = `s`.`debtor_id`) then 'C' when (substr(`n`.`ACCT_ID`,1,6) = `s`.`stock_id`) then 'P' else 'O' end) AS `party_type`,`n`.`city` AS `city`,`n`.`reg_id` AS `reg_id`,`n`.`sp_id` AS `sp_id`,`n`.`address` AS `address`,`n`.`phone` AS `phone`,`n`.`cnic` AS `cnic` from (`nom` `n` join `system` `s`) where ((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`,`s`.`stock_id`,'0100100001')) and (length(`n`.`ACCT_ID`) = 10));
CREATE VIEW `v_p_vouchers` AS select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,(`d`.`qty` * `d`.`avg_rate`) AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `cost_amt`,`m`.`sp_id` AS `sp_id`,`s`.`acct_name` AS `sp_name` from ((((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `sp` `s` on((`m`.`sp_id` = `s`.`acct_id`)));
CREATE VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `cnlxidtp_click_kt`.`v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0);
CREATE VIEW `v_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where (`v`.`POSTED` = 'on') union all select concat('PJ-',`v`.`comp_id`) AS `concat('PJ-', ``v``.``COMP_ID``)`,'6.1' AS `6.1`,`v`.`comp_id` AS `comp_id`,concat(`v`.`comp_id`,concat('PJ-',`v`.`voucher_id`),'/',convert(concat(`vd`.`lineitem`,'.1') using latin1)) AS `voucher_id`,NULL AS `NULL`,`v`.`particulars` AS `description`,`v`.`voucher_date` AS `voucher_date`,concat(`vd`.`lineitem`,'.1') AS `concat(``vd``.``LINEITEM``,'.1')`,`vd`.`dr_acct_id` AS `dr_acct_id`,NULL AS `My_exp_NULL`,NULL AS `My_exp_1_NULL`,`vd`.`amount` AS `amount`,NULL AS `My_exp_2_NULL`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`particulars` AS `particulars`,`v`.`posted` AS `posted` from ((`pl_jv` `v` left join `pl_jvdet` `vd` on(((`v`.`comp_id` = `vd`.`comp_id`) and (`v`.`year_id` = `vd`.`year_id`) and (`v`.`voucher_id` = `vd`.`voucher_id`)))) left join `nom` `n` on((`vd`.`dr_acct_id` = `n`.`ACCT_ID`))) where ((`vd`.`dr_acct_id` is not null) and (`vd`.`cr_acct_id` is not null) and (`v`.`posted` = 'on')) union all select concat('PJ-',`v`.`comp_id`) AS `voucher_type`,'6.2' AS `6.2`,`v`.`comp_id` AS `comp_id`,concat(`v`.`comp_id`,concat('PJ-',`v`.`voucher_id`),'/',convert(concat(`vd`.`lineitem`,'.1') using latin1)) AS `voucher_id`,NULL AS `NULL`,`v`.`particulars` AS `description`,`v`.`voucher_date` AS `voucher_date`,concat(`vd`.`lineitem`,'.2') AS `concat(``vd``.``LINEITEM``,'.2')`,`vd`.`cr_acct_id` AS `cr_acct_id`,NULL AS `My_exp_NULL`,NULL AS `My_exp_1_NULL`,NULL AS `My_exp_2_NULL`,`vd`.`amount` AS `amount`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`particulars` AS `particulars`,`v`.`posted` AS `posted` from ((`pl_jv` `v` left join `pl_jvdet` `vd` on(((`v`.`comp_id` = `vd`.`comp_id`) and (`v`.`year_id` = `vd`.`year_id`) and (`v`.`voucher_id` = `vd`.`voucher_id`)))) left join `nom` `n` on((`vd`.`cr_acct_id` = `n`.`ACCT_ID`))) where ((`vd`.`dr_acct_id` is not null) and (`vd`.`cr_acct_id` is not null) and (`v`.`posted` = 'on'));
