CREATE OR REPLACE VIEW `v_p_vouchers` AS select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,concat('Inv#',`m`.`bill_no`) AS `particulars`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,`d`.`staxp` AS `staxp`,`d`.`stax` AS `stax`,`d`.`add_staxp` AS `add_staxp`,((`d`.`qty` * `d`.`rate`) * (`d`.`add_staxp` / 100)) AS `add_stax`,NULL AS `cost_amt` from (((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,concat('Inv#',`m`.`bill_no`) AS `particulars`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,`d`.`staxp` AS `staxp`,`d`.`stax` AS `stax`,`d`.`add_staxp` AS `add_staxp`,((`d`.`qty` * `d`.`rate`) * (`d`.`add_staxp` / 100)) AS `add_stax`,(`d`.`qty` * `d`.`avg_rate`) AS `cost_amt` from (((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,concat('Inv#',`m`.`bill_no`) AS `particulars`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt`,`d`.`staxp` AS `staxp`,`d`.`stax` AS `stax`,`d`.`add_staxp` AS `add_staxp`,((`d`.`qty` * `d`.`rate`) * (`d`.`add_staxp` / 100)) AS `add_stax`,NULL AS `cost_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,concat('Inv#',`m`.`bill_no`) AS `particulars`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt`,NULL AS `staxp`,NULL AS `stax`,NULL AS `add_staxp`,NULL AS `add_stax`,NULL AS `cost_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select NULL AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,substr(`m`.`voucher_id`,5,12) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`m`.`acct_name` AS `party_name`,substr(`m`.`lineitem`,1,3) AS `lineitem`,NULL AS `stock_code`,`m`.`particulars` AS `stock_name`,`m`.`particulars` AS `particulars`,NULL AS `rate`,NULL AS `db_qty`,`m`.`credit` AS `db_amt`,NULL AS `cr_qty`,`m`.`debit` AS `cr_amt`,NULL AS `staxp`,NULL AS `stax`,NULL AS `add_staxp`,NULL AS `add_stax`,NULL AS `cost_amt` from (`v_vouchers` `m` left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) where ((substr(`m`.`voucher_id`,5,2) not in ('SL','PL')) and (`p`.`acct_id` is not null));

CREATE OR REPLACE VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,if((substr(`n`.`ACCT_ID`,1,6) = `s`.`creditor_id`),'S','C') AS `party_type` from (`nom` `n` join `system` `s`) where ((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`)) and (length(`n`.`ACCT_ID`) = 10));

CREATE OR REPLACE VIEW `v_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'SR') then concat('Sale Receipt-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`YEAR_ID` AS `year_id`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`YEAR_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where (`v`.`POSTED` = 'on');

CREATE OR REPLACE VIEW `v_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'SR') then concat('Sale Receipt-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`YEAR_ID` AS `year_id`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`YEAR_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where (`v`.`POSTED` = 'on');

CREATE OR REPLACE VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0);


CREATE OR REPLACE VIEW `v_stk` AS select `m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`avg_rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,(`d`.`avg_rate` * `d`.`qty`) AS `cr_amt` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('FG',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,NULL AS `party_id`,'PRODUCTION' AS `party_name`,1 AS `lineitem`,`m`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,(`m`.`net_amt` / `m`.`qty`) AS `rate`,`m`.`qty` AS `db_qty`,`m`.`net_amt` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (`prod` `m` left join `item` `i` on((`m`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PC',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,NULL AS `party_id`,'CONSUMPTION' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from ((`prod` `m` left join `item` `i` on((`m`.`stock_code` = `i`.`stock_code`))) left join `proddet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`))));

CREATE OR REPLACE VIEW `v_current_qty` AS select `v`.`comp_id` AS `comp_id`,`v`.`stock_code` AS `stock_code`,`v`.`db_qty` AS `db_qty`,`v`.`cr_qty` AS `cr_qty`,sum((ifnull(`v`.`db_qty`,0) - ifnull(`v`.`cr_qty`,0))) AS `bal_qty` from `v_stk` `v` where ((1 = 1) and ((`v`.`db_qty` is not null) or (`v`.`cr_qty` is not null))) group by `v`.`comp_id`,`v`.`stock_code`;



CREATE OR REPLACE VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0);

CREATE OR REPLACE VIEW `v_item` AS select `i`.`stock_code` AS `stock_code`,concat(`i`.`description`,' - ',convert(`c`.`CAT_NAME` using utf8)) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate` from (`item` `i` left join `prod_cat` `c` on((`i`.`cat_id` = `c`.`CAT_ID`)));

CREATE OR REPLACE VIEW `v_item_bal` AS select `i`.`stock_code` AS `stock_code`,concat(`i`.`description`,'-',convert(`c`.`COMP_NAME` using utf8),'-',round(`v`.`bal_qty`,0)) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`v`.`bal_qty` AS `bal_qty` from ((`item` `i` left join `v_current_qty` `v` on((`i`.`stock_code` = `v`.`stock_code`))) left join `company` `c` on((`v`.`comp_id` = `c`.`COMP_ID`)));

CREATE OR REPLACE VIEW `v_grp_item` AS select 'KT' AS `comp_id`,`item`.`stock_code` AS `stock_code`,`item`.`description` AS `description`,`item`.`p_rate` AS `p_rate`,`item`.`s_rate` AS `s_rate` from `item` union all select 'BT' AS `comp_id`,`item`.`stock_code` AS `stock_code`,`item`.`description` AS `description`,`item`.`p_rate` AS `p_rate`,`item`.`s_rate` AS `s_rate` from `item` union all select 'IT' AS `comp_id`,`item`.`stock_code` AS `stock_code`,`item`.`description` AS `description`,`item`.`p_rate` AS `p_rate`,`item`.`s_rate` AS `s_rate` from `item`;

