/*
Navicat MySQL Data Transfer

Source Server         : mysql
Source Server Version : 50625
Source Host           : localhost:3306
Source Database       : cnlxidtp_click_tt

Target Server Type    : MYSQL
Target Server Version : 50625
File Encoding         : 65001

Date: 2017-09-17 14:25:32
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `acct_type`
-- ----------------------------
DROP TABLE IF EXISTS `acct_type`;
CREATE TABLE `acct_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `debit_name` varchar(20) DEFAULT NULL,
  `credit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of acct_type
-- ----------------------------

-- ----------------------------
-- Table structure for `am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `am_condet`;
CREATE TABLE `am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `announcement`
-- ----------------------------
DROP TABLE IF EXISTS `announcement`;
CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement` text,
  `post_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of announcement
-- ----------------------------

-- ----------------------------
-- Table structure for `app_mod`
-- ----------------------------
DROP TABLE IF EXISTS `app_mod`;
CREATE TABLE `app_mod` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `unpost` int(4) NOT NULL DEFAULT '0',
  `table_name` varchar(50) NOT NULL DEFAULT '',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_mod
-- ----------------------------
INSERT INTO `app_mod` VALUES ('AC_CP', 'Cash Payment', 'Accounts', '26', '35', '', 'CP');
INSERT INTO `app_mod` VALUES ('AC_BP', 'Bank Payment', 'Accounts', '26', '35', '', 'BP');
INSERT INTO `app_mod` VALUES ('AC_CR', 'Cash Receipt', 'Accounts', '26', '35', '', 'CR');
INSERT INTO `app_mod` VALUES ('AC_BR', 'Bank Receipt', 'Accounts', '26', '35', '', 'BR');
INSERT INTO `app_mod` VALUES ('AC_JV', 'Journal Voucher', 'Accounts', '35', '35', '', 'JV');
INSERT INTO `app_mod` VALUES ('AC_CD', 'Outstanding Clearing Dates', 'Accounts', '223', '0', '', '');
INSERT INTO `app_mod` VALUES ('PL_PO', 'Order', 'Purchases', '226', '53', 't_pl_order', '');
INSERT INTO `app_mod` VALUES ('PL_GP', 'Inward Gate Pass', 'Purchases', '226', '235', 't_pl_gp', '');
INSERT INTO `app_mod` VALUES ('PL_INV', 'Invoice', 'Purchases', '226', '235', 't_pl_invoice', '');
INSERT INTO `app_mod` VALUES ('PL_PAY', 'Payments', 'Purchases', '203', '204', 't_pl_pay', '');
INSERT INTO `app_mod` VALUES ('PL_JV', 'JV', 'Purchases', '216', '212', 'pl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_GP', 'Inward Gate Pass', 'Sales', '226', '235', 't_sl_gp', '');
INSERT INTO `app_mod` VALUES ('SL_INV', 'Invoice', 'Sales', '226', '235', 't_sl_invoice', '');
INSERT INTO `app_mod` VALUES ('SL_RTN', 'Return', 'Sales', '226', '235', 't_sl_return', '');
INSERT INTO `app_mod` VALUES ('SL_PAY', 'Payments', 'Sales', '203', '204', 't_sl_pay', '');
INSERT INTO `app_mod` VALUES ('SL_JV', 'JV', 'Sales', '216', '212', 'sl_jv', '');
INSERT INTO `app_mod` VALUES ('SL_OB', 'Outstanding Bilties', 'Sales', '221', '260', '', '');
INSERT INTO `app_mod` VALUES ('STK_PROD', 'Production', 'Stock', '226', '53', 't_stk_con', 'Y');
INSERT INTO `app_mod` VALUES ('STK_CON', 'Consumption', 'Stock', '226', '235', 't_stk_con', 'N');
INSERT INTO `app_mod` VALUES ('MF_NOM', 'Chart of Accounts', 'Master Files', '164', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_PARTY', 'Parties', 'Master Files', '66', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_ITEM', 'Items', 'Master Files', '64', '0', '', '');
INSERT INTO `app_mod` VALUES ('MF_UNIT', 'Units', 'Master Files', '106', '0', '', '');
INSERT INTO `app_mod` VALUES ('IM_BOE', 'Bill of Entry', 'Imports', '226', '235', 't_im_boe', '');

-- ----------------------------
-- Table structure for `app_rep`
-- ----------------------------
DROP TABLE IF EXISTS `app_rep`;
CREATE TABLE `app_rep` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) NOT NULL DEFAULT '',
  `grp_name` varchar(50) NOT NULL DEFAULT '',
  `action` int(4) NOT NULL DEFAULT '0',
  `cvoucher_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of app_rep
-- ----------------------------
INSERT INTO `app_rep` VALUES ('AC_10', 'Daybook', 'Accounts', '144', '');
INSERT INTO `app_rep` VALUES ('AC_20', 'Ledger', 'Accounts', '91', '');
INSERT INTO `app_rep` VALUES ('AC_31', 'Trial - Balance', 'Accounts', '163', '');
INSERT INTO `app_rep` VALUES ('AC_32', 'Trial - Control', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_33', 'Trial - Subsidary', 'Accounts', '149', '');
INSERT INTO `app_rep` VALUES ('AC_40', 'Profit & Loss', 'Accounts', '190', '');
INSERT INTO `app_rep` VALUES ('AC_50', 'Profit & Loss (Level 2)', 'Accounts', '191', '');
INSERT INTO `app_rep` VALUES ('PL_10', 'Purchase Daybook', 'Purchases', '187', 'PL');
INSERT INTO `app_rep` VALUES ('PL_20', 'Payment Daybook', 'Purchases', '187', 'PP');
INSERT INTO `app_rep` VALUES ('PL_30', 'Detail Ledger', 'Purchases', '405', 'S');
INSERT INTO `app_rep` VALUES ('PL_40', 'Trial', 'Purchases', '194', 'S');
INSERT INTO `app_rep` VALUES ('PL_50', 'Summary', 'Purchases', '188', 'S');
INSERT INTO `app_rep` VALUES ('SL_10', 'Sale Daybook', 'Sales', '187', 'SL');
INSERT INTO `app_rep` VALUES ('SL_20', 'Sale Receipts', 'Sales', '187', 'SR');
INSERT INTO `app_rep` VALUES ('SL_30', 'Detail Ledger', 'Sales', '405', 'C');
INSERT INTO `app_rep` VALUES ('SL_40', 'Trial', 'Sales', '194', 'C');
INSERT INTO `app_rep` VALUES ('SL_50', 'Summary', 'Sales', '188', 'C');
INSERT INTO `app_rep` VALUES ('SL_60', 'Empty Stock Report', 'Sales', '406', '');
INSERT INTO `app_rep` VALUES ('SL_70', 'Empty Stock Report Rate Wise', 'Sales', '407', '');
INSERT INTO `app_rep` VALUES ('SL_80', 'Outstanding Bills', 'Sales', '189', '');
INSERT INTO `app_rep` VALUES ('SL_90', 'SPO Outstanding', 'Sales', '195', '');
INSERT INTO `app_rep` VALUES ('STK_10', 'Ledger', 'Stocks', '401', '');
INSERT INTO `app_rep` VALUES ('STK_20', 'Summary', 'Stocks', '402', '');
INSERT INTO `app_rep` VALUES ('STK_30', 'Summary - Value', 'Stocks', '403', '');

-- ----------------------------
-- Table structure for `bill_type`
-- ----------------------------
DROP TABLE IF EXISTS `bill_type`;
CREATE TABLE `bill_type` (
  `acct_id` varchar(7) NOT NULL,
  `acct_name` varchar(30) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of bill_type
-- ----------------------------
INSERT INTO `bill_type` VALUES ('0001', 'Normal', null);
INSERT INTO `bill_type` VALUES ('0002', 'Exchange', null);
INSERT INTO `bill_type` VALUES ('0003', 'VIP', null);
INSERT INTO `bill_type` VALUES ('0004', 'Sale Return', null);

-- ----------------------------
-- Table structure for `brands`
-- ----------------------------
DROP TABLE IF EXISTS `brands`;
CREATE TABLE `brands` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of brands
-- ----------------------------
INSERT INTO `brands` VALUES ('0001', 'APC');
INSERT INTO `brands` VALUES ('0002', 'MGE UPS Systems');
INSERT INTO `brands` VALUES ('0003', 'Stulz Air Conditioning');
INSERT INTO `brands` VALUES ('0004', 'Bergvik Flooring');
INSERT INTO `brands` VALUES ('0005', 'APC / MGE UPS Systems');
INSERT INTO `brands` VALUES ('0006', 'APC / MGE');

-- ----------------------------
-- Table structure for `city`
-- ----------------------------
DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
  `CITY_ID` varchar(2) NOT NULL,
  `CITY_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`CITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of city
-- ----------------------------
INSERT INTO `city` VALUES ('10', 'LAHORE', '3801101001');

-- ----------------------------
-- Table structure for `closing_dates`
-- ----------------------------
DROP TABLE IF EXISTS `closing_dates`;
CREATE TABLE `closing_dates` (
  `VOUCHER_TYPE` varchar(2) NOT NULL,
  `DATE_CLOSING` datetime NOT NULL,
  PRIMARY KEY (`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of closing_dates
-- ----------------------------
INSERT INTO `closing_dates` VALUES ('BP', '2003-12-31 00:00:00');

-- ----------------------------
-- Table structure for `code_cat`
-- ----------------------------
DROP TABLE IF EXISTS `code_cat`;
CREATE TABLE `code_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_cat
-- ----------------------------
INSERT INTO `code_cat` VALUES ('00', 'KURTA');
INSERT INTO `code_cat` VALUES ('01', 'SHALWAR');
INSERT INTO `code_cat` VALUES ('02', 'TROUSER');
INSERT INTO `code_cat` VALUES ('03', 'KHUSSA\r\n');
INSERT INTO `code_cat` VALUES ('04', 'WAIST COAT\r\n');
INSERT INTO `code_cat` VALUES ('05', 'NIGHT SUIT');
INSERT INTO `code_cat` VALUES ('06', 'FULL SUIT');
INSERT INTO `code_cat` VALUES ('07', 'COAT');
INSERT INTO `code_cat` VALUES ('08', 'FOOTWEAR\r\n');
INSERT INTO `code_cat` VALUES ('09', 'SHIRT\r\n');
INSERT INTO `code_cat` VALUES ('10', 'SHERWANI\r\n');
INSERT INTO `code_cat` VALUES ('11', 'TURBON\r\n');
INSERT INTO `code_cat` VALUES ('12', 'SUITING\r\n');
INSERT INTO `code_cat` VALUES ('13', 'CAP');
INSERT INTO `code_cat` VALUES ('14', 'ACCESSORIES');
INSERT INTO `code_cat` VALUES ('15', 'SHAWL');

-- ----------------------------
-- Table structure for `code_collection`
-- ----------------------------
DROP TABLE IF EXISTS `code_collection`;
CREATE TABLE `code_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of code_collection
-- ----------------------------
INSERT INTO `code_collection` VALUES ('SK', 'MEN');
INSERT INTO `code_collection` VALUES ('SG', 'GOLD');
INSERT INTO `code_collection` VALUES ('SD', 'DESIGNER\r\n');

-- ----------------------------
-- Table structure for `color`
-- ----------------------------
DROP TABLE IF EXISTS `color`;
CREATE TABLE `color` (
  `color_id` varchar(2) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`color_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of color
-- ----------------------------
INSERT INTO `color` VALUES ('PU', 'PURPLE');
INSERT INTO `color` VALUES ('OW', 'OFF WHITE');
INSERT INTO `color` VALUES ('BL', 'BLACK');
INSERT INTO `color` VALUES ('SN', 'SKIN');
INSERT INTO `color` VALUES ('GO', 'GOLDEN');
INSERT INTO `color` VALUES ('BR', 'BROWN');
INSERT INTO `color` VALUES ('MD', 'MUD');
INSERT INTO `color` VALUES ('SG', 'SEA GREEN');
INSERT INTO `color` VALUES ('MR', 'MAROON');
INSERT INTO `color` VALUES ('MV', 'MOUVE');
INSERT INTO `color` VALUES ('GR', 'GREEN');
INSERT INTO `color` VALUES ('MU', 'MUSTARD');
INSERT INTO `color` VALUES ('WH', 'WHITE');
INSERT INTO `color` VALUES ('GY', 'GREY');
INSERT INTO `color` VALUES ('DG', 'DARK GREEN');
INSERT INTO `color` VALUES ('LG', 'LIGHT GREEN');
INSERT INTO `color` VALUES ('BU', 'BLUE');
INSERT INTO `color` VALUES ('GB', 'GREEN BLUE');
INSERT INTO `color` VALUES ('OR', 'ORANGE');
INSERT INTO `color` VALUES ('PH', 'PEACH');
INSERT INTO `color` VALUES ('RS', 'RUST');
INSERT INTO `color` VALUES ('DB', 'DARK BLUE');
INSERT INTO `color` VALUES ('LY', 'LIGHT GREY');
INSERT INTO `color` VALUES ('SB', 'SKY BLUE');
INSERT INTO `color` VALUES ('FN', 'FORN');
INSERT INTO `color` VALUES ('CB', 'CHOCOLATE BROWN');
INSERT INTO `color` VALUES ('NB', 'NAVY BLUE');
INSERT INTO `color` VALUES ('YB', 'GREY BLACK');
INSERT INTO `color` VALUES ('GS', 'GREY SHINING');
INSERT INTO `color` VALUES ('FR', 'FEROOZI');
INSERT INTO `color` VALUES ('RD', 'RED');
INSERT INTO `color` VALUES ('LR', 'LIGHT BROWN');
INSERT INTO `color` VALUES ('LB', 'LIGHT BLUE');
INSERT INTO `color` VALUES ('CM', 'CAMEL');
INSERT INTO `color` VALUES ('CH', 'CHOCOLATE');
INSERT INTO `color` VALUES ('BG', 'BLACK GREY');
INSERT INTO `color` VALUES ('AR', 'ARMY');
INSERT INTO `color` VALUES ('MT', 'MULTI COLOUR');

-- ----------------------------
-- Table structure for `company`
-- ----------------------------
DROP TABLE IF EXISTS `company`;
CREATE TABLE `company` (
  `COMP_ID` varchar(2) NOT NULL,
  `COMP_NAME` varchar(100) DEFAULT NULL,
  `ADD_LINE1` varchar(100) DEFAULT NULL,
  `PHONE` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `FAX` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `STAX_NO` varchar(17) DEFAULT NULL,
  `PRODUCTION` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ADD_LINE2` varchar(100) DEFAULT NULL,
  `COUNTRY` varchar(30) DEFAULT NULL,
  `ZIP_CODE` varchar(30) DEFAULT NULL,
  `ACCT_ID_PL` char(10) DEFAULT NULL,
  `SHORT_NAME` varchar(10) DEFAULT NULL,
  `CUR_NAME` varchar(10) DEFAULT NULL,
  `DISC_DR` char(10) DEFAULT NULL,
  `DISC_CR` char(10) DEFAULT NULL,
  `STOCK_ACCT_ID` char(10) DEFAULT NULL,
  `SALES_ACCT_ID` char(10) DEFAULT NULL,
  `G_ACCT_ID_SL` char(10) DEFAULT NULL,
  `DEBTORS` char(10) DEFAULT NULL,
  `COGS` char(10) DEFAULT NULL,
  `COMP_TYPE` varchar(2) NOT NULL,
  `TRACK_ORD` varchar(3) DEFAULT NULL,
  `GRP_BS` varchar(1) NOT NULL,
  `country_flag` varchar(5) DEFAULT NULL,
  `G_ACCT_ID_DR` char(10) DEFAULT NULL,
  `G_ACCT_ID_DISC` char(10) DEFAULT NULL,
  `G_ACCT_ID_RT` char(10) DEFAULT NULL,
  `outlet_percentage` decimal(9,0) DEFAULT NULL,
  `outlet_margin` decimal(9,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of company
-- ----------------------------
INSERT INTO `company` VALUES ('TT', 'Tayyab Traders', 'PURNI SABZIMANDI NEAR CITY POLICE STATION DIK', '0966-710466,715469', '', '', '', '', '', 'Y', '0600030001', '', '', '', null, 'KT', 'UGX', null, null, '2210000001', '3010000001', '0700010001', '2610000419', '0100011000', 'A', '401', 'N', '', '0600030001', '0700020001', '0700030001', null, null);

-- ----------------------------
-- Table structure for `container_size`
-- ----------------------------
DROP TABLE IF EXISTS `container_size`;
CREATE TABLE `container_size` (
  `container_id` varchar(4) NOT NULL,
  `container_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`container_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of container_size
-- ----------------------------
INSERT INTO `container_size` VALUES ('0001', '16 Feet');
INSERT INTO `container_size` VALUES ('0002', '20 Feet');
INSERT INTO `container_size` VALUES ('0003', '22 Feet');
INSERT INTO `container_size` VALUES ('0004', '24 Feet');
INSERT INTO `container_size` VALUES ('0005', '40 Feet');
INSERT INTO `container_size` VALUES ('0006', '50 Feet');

-- ----------------------------
-- Table structure for `currency`
-- ----------------------------
DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_NAME` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`CUR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of currency
-- ----------------------------
INSERT INTO `currency` VALUES ('PK', 'PKR');

-- ----------------------------
-- Table structure for `dc_type`
-- ----------------------------
DROP TABLE IF EXISTS `dc_type`;
CREATE TABLE `dc_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of dc_type
-- ----------------------------
INSERT INTO `dc_type` VALUES ('01', 'Sale');

-- ----------------------------
-- Table structure for `discount`
-- ----------------------------
DROP TABLE IF EXISTS `discount`;
CREATE TABLE `discount` (
  `stock_code` varchar(50) DEFAULT NULL,
  `discount` decimal(20,0) DEFAULT NULL,
  `sharing` decimal(20,0) NOT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  KEY `index_discount` (`stock_code`,`comp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_percentage`
-- ----------------------------
DROP TABLE IF EXISTS `discount_percentage`;
CREATE TABLE `discount_percentage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_code` varchar(100) NOT NULL DEFAULT '',
  `discount_percentage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_percentage
-- ----------------------------

-- ----------------------------
-- Table structure for `discount_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `discount_voucher`;
CREATE TABLE `discount_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_voucher_no` varchar(100) CHARACTER SET latin7 NOT NULL DEFAULT '',
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of discount_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `division`
-- ----------------------------
DROP TABLE IF EXISTS `division`;
CREATE TABLE `division` (
  `DIV_ID` varchar(2) NOT NULL,
  `DIV_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of division
-- ----------------------------
INSERT INTO `division` VALUES ('10', 'TEXTILE');

-- ----------------------------
-- Table structure for `expense`
-- ----------------------------
DROP TABLE IF EXISTS `expense`;
CREATE TABLE `expense` (
  `EXP_ID` varchar(7) NOT NULL,
  `EXP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`EXP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of expense
-- ----------------------------
INSERT INTO `expense` VALUES ('01', 'L/C EXPENSES');

-- ----------------------------
-- Table structure for `fin_years`
-- ----------------------------
DROP TABLE IF EXISTS `fin_years`;
CREATE TABLE `fin_years` (
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `year_name` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  PRIMARY KEY (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of fin_years
-- ----------------------------
INSERT INTO `fin_years` VALUES ('17', '17-18', '2017-07-01', '2018-06-30');

-- ----------------------------
-- Table structure for `grn`
-- ----------------------------
DROP TABLE IF EXISTS `grn`;
CREATE TABLE `grn` (
  `GRN_ID` varchar(5) NOT NULL,
  `GRN_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`GRN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn
-- ----------------------------

-- ----------------------------
-- Table structure for `grndet`
-- ----------------------------
DROP TABLE IF EXISTS `grndet`;
CREATE TABLE `grndet` (
  `GRN_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `REC_QTY` decimal(13,3) NOT NULL,
  PRIMARY KEY (`GRN_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_return`
-- ----------------------------
DROP TABLE IF EXISTS `grn_return`;
CREATE TABLE `grn_return` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `INV_ID_RTN` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_return
-- ----------------------------

-- ----------------------------
-- Table structure for `grn_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `grn_returndet`;
CREATE TABLE `grn_returndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `INV_LINEITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of grn_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boe`
-- ----------------------------
DROP TABLE IF EXISTS `im_boe`;
CREATE TABLE `im_boe` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) DEFAULT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boe
-- ----------------------------

-- ----------------------------
-- Table structure for `im_boedet`
-- ----------------------------
DROP TABLE IF EXISTS `im_boedet`;
CREATE TABLE `im_boedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` tinyint(4) DEFAULT NULL,
  `aitp` tinyint(4) DEFAULT NULL,
  `ait` decimal(13,2) DEFAULT NULL,
  `cdip` tinyint(4) DEFAULT NULL,
  `cdi` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of im_boedet
-- ----------------------------

-- ----------------------------
-- Table structure for `invoice_no`
-- ----------------------------
DROP TABLE IF EXISTS `invoice_no`;
CREATE TABLE `invoice_no` (
  `v_id` int(11) NOT NULL,
  `v_type` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of invoice_no
-- ----------------------------
INSERT INTO `invoice_no` VALUES ('1', 'SL', '06');
INSERT INTO `invoice_no` VALUES ('2', 'SL', '06');

-- ----------------------------
-- Table structure for `item`
-- ----------------------------
DROP TABLE IF EXISTS `item`;
CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(50) NOT NULL,
  `description` varchar(100) CHARACTER SET utf8 NOT NULL,
  `o_qty` decimal(10,3) DEFAULT NULL,
  `specs` mediumtext,
  `unit` char(3) DEFAULT NULL,
  `o_rate` decimal(10,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `gl_acct_id` varchar(7) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `cat_id` varchar(10) DEFAULT NULL,
  `s_rate` decimal(10,2) DEFAULT NULL,
  `inactive` char(2) NOT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `col_id` varchar(6) DEFAULT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `article_name` varchar(255) DEFAULT NULL,
  `vender_party` varchar(5) DEFAULT NULL,
  `v_cloth_yard` decimal(10,0) DEFAULT NULL,
  `v_cloth_rate` decimal(10,0) DEFAULT NULL,
  `v_cloth_amount` decimal(10,0) DEFAULT NULL,
  `match_yard` decimal(10,0) DEFAULT NULL,
  `match_rate` decimal(10,0) DEFAULT NULL,
  `match_amount` decimal(10,0) DEFAULT NULL,
  `stitching_party` varchar(5) DEFAULT NULL,
  `stitching_yard` decimal(10,0) DEFAULT NULL,
  `stitching_rate` decimal(10,0) DEFAULT NULL,
  `stitching_amount` decimal(10,0) DEFAULT NULL,
  `dying_unit` decimal(10,0) DEFAULT NULL,
  `dying_rate` decimal(10,0) DEFAULT NULL,
  `dying_amount` decimal(10,0) DEFAULT NULL,
  `emb_party` varchar(5) DEFAULT NULL,
  `emb_yard` decimal(10,0) DEFAULT NULL,
  `emb_rate` decimal(10,0) DEFAULT NULL,
  `emb_amount` decimal(10,0) DEFAULT NULL,
  `an_emb_party` varchar(5) DEFAULT NULL,
  `an_emb_yard` decimal(10,0) DEFAULT NULL,
  `an_emb_rate` decimal(10,0) DEFAULT NULL,
  `an_emb_amount` decimal(10,0) DEFAULT NULL,
  `leather_yard` decimal(10,0) DEFAULT NULL,
  `leather_rate` decimal(10,0) DEFAULT NULL,
  `leather_amount` decimal(10,0) DEFAULT NULL,
  `back_cloth_yard` decimal(10,0) DEFAULT NULL,
  `back_cloth_rate` decimal(10,0) DEFAULT NULL,
  `back_cloth_amount` decimal(10,0) DEFAULT NULL,
  `shoe_box_unit` decimal(10,0) DEFAULT NULL,
  `shoe_box_rate` decimal(10,0) DEFAULT NULL,
  `shoe_box_amount` decimal(10,0) DEFAULT NULL,
  `inside_tags_unit` decimal(10,0) DEFAULT NULL,
  `inside_tags_rate` decimal(10,0) DEFAULT NULL,
  `inside_tags_amount` decimal(10,0) DEFAULT NULL,
  `hanger_unit` decimal(10,0) DEFAULT NULL,
  `hanger_rate` decimal(10,0) DEFAULT NULL,
  `hanger_amount` decimal(10,0) DEFAULT NULL,
  `cover_packing_unit` decimal(10,0) DEFAULT NULL,
  `cover_packing_rate` decimal(10,0) DEFAULT NULL,
  `cover_packing_amount` decimal(10,0) DEFAULT NULL,
  `stone_unit` decimal(10,0) DEFAULT NULL,
  `stone_rate` decimal(10,0) DEFAULT NULL,
  `stone_amount` decimal(10,0) DEFAULT NULL,
  `zip_unit` decimal(10,0) DEFAULT NULL,
  `zip_rate` decimal(10,0) DEFAULT NULL,
  `zip_amount` decimal(10,0) DEFAULT NULL,
  `button_unit` decimal(10,0) DEFAULT NULL,
  `button_rate` decimal(10,0) DEFAULT NULL,
  `button_amount` decimal(10,0) DEFAULT NULL,
  `tag_unit` decimal(10,0) DEFAULT NULL,
  `tag_rate` decimal(10,0) DEFAULT NULL,
  `tag_amount` decimal(10,0) DEFAULT NULL,
  `ext_unit` decimal(10,0) DEFAULT NULL,
  `ext_rate` decimal(10,0) DEFAULT NULL,
  `ext_amount` decimal(10,0) DEFAULT NULL,
  `other_unit` decimal(10,0) DEFAULT NULL,
  `other_rate` decimal(10,0) DEFAULT NULL,
  `other_amount` decimal(10,0) DEFAULT NULL,
  `season_id` varchar(6) NOT NULL,
  `type_id` varchar(6) NOT NULL,
  `p_rate` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`,`stock_code`),
  KEY `index_item` (`stock_code`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item
-- ----------------------------
INSERT INTO `item` VALUES ('266', '0001', 'Sugar', '0.000', null, null, null, '0', null, null, '07', '0.00', '', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '0.00');

-- ----------------------------
-- Table structure for `item_description`
-- ----------------------------
DROP TABLE IF EXISTS `item_description`;
CREATE TABLE `item_description` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of item_description
-- ----------------------------

-- ----------------------------
-- Table structure for `location`
-- ----------------------------
DROP TABLE IF EXISTS `location`;
CREATE TABLE `location` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `loc_name` varchar(50) DEFAULT '',
  `address` varchar(200) DEFAULT NULL,
  `ph_no` varchar(200) DEFAULT NULL,
  `stax_no` varchar(50) DEFAULT NULL,
  `ntn_no` varchar(50) DEFAULT NULL,
  `add_line1` varchar(50) DEFAULT NULL,
  `add_line2` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `stk_sl` char(2) DEFAULT NULL,
  `stk_pl` char(2) DEFAULT 'on',
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of location
-- ----------------------------
INSERT INTO `location` VALUES ('01', 'Main Store', '245/1/1 Tufail Road, Lahore, Cantt.', 'Tel # 0092-42-36605100-7 Fax # 0092-42-36605109 Email # accounts@rakcorporation.com', '03-00-2974-683-13', '2974683-3', '245/1/1 Tufail Road, Lahore.', '', '', 'on', 'on', 'TT');

-- ----------------------------
-- Table structure for `locations`
-- ----------------------------
DROP TABLE IF EXISTS `locations`;
CREATE TABLE `locations` (
  `LOC_ID` varchar(2) NOT NULL,
  `LOC_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`LOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of locations
-- ----------------------------
INSERT INTO `locations` VALUES ('01', 'Main Store');

-- ----------------------------
-- Table structure for `lots`
-- ----------------------------
DROP TABLE IF EXISTS `lots`;
CREATE TABLE `lots` (
  `LOT_ID` varchar(5) NOT NULL,
  `LOT_DATE` datetime NOT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`LOT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of lots
-- ----------------------------

-- ----------------------------
-- Table structure for `menu`
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `menu_name` varchar(100) DEFAULT NULL,
  `menu_cmd` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES ('1', 'Sale', null);
INSERT INTO `menu` VALUES ('1.1', 'Invoice', null);
INSERT INTO `menu` VALUES ('1.2', 'Order', null);
INSERT INTO `menu` VALUES ('1.3', 'Sale Delivery Challan', null);
INSERT INTO `menu` VALUES ('1.4', 'Outword Gate pass', null);
INSERT INTO `menu` VALUES ('1.5', 'Receipts', null);
INSERT INTO `menu` VALUES ('1.6', 'Journal', null);
INSERT INTO `menu` VALUES ('1.7', 'Sale Return', null);
INSERT INTO `menu` VALUES ('2', 'Purchase', null);
INSERT INTO `menu` VALUES ('2.1', 'Invoice', null);
INSERT INTO `menu` VALUES ('2.2', 'Order', null);
INSERT INTO `menu` VALUES ('2.3', 'Inward Gate pass', null);
INSERT INTO `menu` VALUES ('2.4', 'Payments', null);
INSERT INTO `menu` VALUES ('2.5', 'Journal', null);
INSERT INTO `menu` VALUES ('2.6', 'Purchase Return', null);
INSERT INTO `menu` VALUES ('3', 'Accounts', null);
INSERT INTO `menu` VALUES ('3.1', 'Payments', null);
INSERT INTO `menu` VALUES ('3.2', 'Journal Voucher', null);
INSERT INTO `menu` VALUES ('4', 'Stock', null);
INSERT INTO `menu` VALUES ('4.1', 'Production', null);
INSERT INTO `menu` VALUES ('4.2', 'Consumption', null);
INSERT INTO `menu` VALUES ('5', 'Master File', null);
INSERT INTO `menu` VALUES ('5.1', 'Items', null);
INSERT INTO `menu` VALUES ('5.2', 'Chart Of Accounts', null);
INSERT INTO `menu` VALUES ('5.3', 'Items', null);
INSERT INTO `menu` VALUES ('5.4', 'Sale Person', null);
INSERT INTO `menu` VALUES ('5.5', 'Category', null);
INSERT INTO `menu` VALUES ('5.6', 'Users', null);
INSERT INTO `menu` VALUES ('6', 'Reports Summary', null);
INSERT INTO `menu` VALUES ('6.1', 'Sale Summary', null);
INSERT INTO `menu` VALUES ('6.2', 'Stock Summary', null);
INSERT INTO `menu` VALUES ('6.3', 'Outword Gate pass Summary', null);
INSERT INTO `menu` VALUES ('6.4', 'Sale Order Summary', null);
INSERT INTO `menu` VALUES ('6.5', 'Purchase Summary', null);
INSERT INTO `menu` VALUES ('6.6', 'Purchase Order Summary', null);
INSERT INTO `menu` VALUES ('6.7', 'Purchase InwordGatepass Summary', null);
INSERT INTO `menu` VALUES ('7', 'Reports Detail', null);
INSERT INTO `menu` VALUES ('7.1', 'Sale Report', null);
INSERT INTO `menu` VALUES ('7.2', 'Sale Order', null);
INSERT INTO `menu` VALUES ('7.3', 'Outword Gatepass', null);
INSERT INTO `menu` VALUES ('7.4', 'WareHouse Stock', null);
INSERT INTO `menu` VALUES ('7.5', 'Purchase Invoice', null);
INSERT INTO `menu` VALUES ('7.6', 'Inword Gatepass', null);
INSERT INTO `menu` VALUES ('7.7', 'Stock Ledger', null);
INSERT INTO `menu` VALUES ('8', 'Reports Accounts', null);
INSERT INTO `menu` VALUES ('8.1', 'Ledgers', null);
INSERT INTO `menu` VALUES ('8.2', 'Day Book', null);
INSERT INTO `menu` VALUES ('9', 'Reports', null);
INSERT INTO `menu` VALUES ('9.1', 'Sale Report', null);
INSERT INTO `menu` VALUES ('9.2', 'Gatepass Outword Report', null);
INSERT INTO `menu` VALUES ('9.3', 'Current Stock', null);

-- ----------------------------
-- Table structure for `ms_sale`
-- ----------------------------
DROP TABLE IF EXISTS `ms_sale`;
CREATE TABLE `ms_sale` (
  `crid` varchar(4) NOT NULL DEFAULT '',
  `v_date` date DEFAULT NULL,
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `qty` decimal(10,3) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of ms_sale
-- ----------------------------

-- ----------------------------
-- Table structure for `nom`
-- ----------------------------
DROP TABLE IF EXISTS `nom`;
CREATE TABLE `nom` (
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_NAME` char(50) NOT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `ACCT_TYPE` varchar(4) DEFAULT NULL,
  `FS_TYPE` varchar(1) DEFAULT NULL,
  `SUB` varchar(1) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `TEST_NAME` char(50) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `address` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `reg_id` varchar(6) NOT NULL,
  `credit_limit` decimal(10,2) NOT NULL,
  `ntn` varchar(50) NOT NULL,
  `stax_no` varchar(50) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom
-- ----------------------------
INSERT INTO `nom` VALUES ('01', 'CAPITAL & LIABILITIES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('010001', 'Reserves & Surplus', null, '3101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('010010', 'Opening Balance', null, '7101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('0100100001', 'opening Balances', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('13', 'CREDITORS & OTHER PAYABLES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('131000', 'Sundry Creditors', null, '2802', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000001', 'Gulf Sugar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000002', 'Chashma', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000003', 'Malik Faizan Guds', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000004', 'Chashma 2', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000005', 'Jdw Sugar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000006', 'Roktak Hasar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000007', 'Miran Sugar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('1310000008', 'Sarhad Guds', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('20', 'ASSETS', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('201000', 'FIXED ASSETS', null, '1101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('201500', 'Loans & Advances', null, '1901', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('202000', 'VEHICLES', null, '1901', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('22', 'STOCKS', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('221000', 'Closing Stock', null, '1903', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('26', 'SUNDRY DEBTORS', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('261000', 'Sundry Debtors', null, '1902', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000001', 'Abbas Khan Peshawar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000002', 'Akbar Zaman Kulachi', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000003', 'Al Habib Bank', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000004', 'Ameer Nawaz Sher Gar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000005', 'Amir Family Ghee', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000006', 'Aqeel Traders Darya', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000007', 'Asghar Ali Pabi', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000008', 'Aslam Mama', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000009', 'Baho Flour Mills Dasti', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000010', 'BAHOO RAHAT GARDAN DASTI KHATA', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000011', 'Bahoo Rice Mill Kahta', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000012', 'Bakht Niaz Sugar Broker', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000013', 'CHACHA ILYAS', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000014', 'Chashma Ghee Mills Sugar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000015', 'Chashma Oil', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000016', 'Faizan Malik Adda', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000017', 'Gogi Sugar Broker', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000018', 'Gulf Sugar Mills', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000019', 'Hahji Fazal Riaz Bannu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000020', 'Haji Abdul Rehman  Sheikh Yousaf', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000021', 'Haji Akbar Ali Pdsp', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000022', 'Haji Awal Khan Nourang', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000023', 'HAJI AWAS DRABAN', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000024', 'Haji Ehsan Atta Diler Tirjat Ganj', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000025', 'Haji Gullu Fayaz', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000026', 'Haji Gul Shah Jahan Dera', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000027', 'HAJI IMAM DIN', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000028', 'Haji Mohammad Ghulam', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000029', 'Haji Sadiq Ghee', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000030', 'Haji Sharif Pezu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000031', 'HAJI SULTAN NOOR KOHAT', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000032', 'Haji Taj Alil Khan Sheikh Yousaf', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000033', 'Hanif Bhatti', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000034', 'Hikmat Ullah  Bannu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000035', 'Ibrahim Khalil Dasti Khata', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000036', 'Imran Bannu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000037', 'Imran Bhakkar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000038', 'Ismail Paroa', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000039', 'Kafel Traders Shop', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000040', 'Kalan Bazar', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000041', 'Khaki Shah Pezu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000042', 'Khaleel Traders', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000043', 'Khalid Bashir Fsd', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000044', 'Khizar Kulachi', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000045', 'Khwaja Imran Saroda', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000046', 'Laiq Zaheer Lahore', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000047', 'Lal Zadah Kohat', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000048', 'Liaqat Ali Pezu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000049', 'Liaqat Harnoli', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000050', 'Malik Mithu Cheeni Khtta', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000051', 'Munsif Doaba', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000052', 'Naseeb Shah Amberi Kaly', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000053', 'Naveed Bahoo Mill', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000054', 'NEW RAHAT GARDAN', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000055', 'Niaz Muhammad Pezu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000056', 'Rafeeq Kohat', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000057', 'Raja Nadeem', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000058', 'Rana Shahid Multan', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000059', 'Rehman Ullah Amberi Kaly', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000060', 'Rizwan Lakki Marwat', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000061', 'SALAM TANK', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000062', 'Sami Ullah Mianwali', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000063', 'Saqib Sahab', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000064', 'Shahid Zam Rice Mill', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000065', 'Shakeel Pabi', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000066', 'Sheikh Safdar Piplan', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000067', 'Sheryar Chashma Ghee Mill', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000068', 'Shop Rent Incom Bannu Adda Shop', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000069', 'Sufi Umar Gul Lakki', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000070', 'Ustad Sahab C/o Malik Mithu', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000071', 'YAMEEN HALWI C/O HAJI MOBEEN', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000072', 'Zafar Iqbal Karak', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000073', 'Zam Rice Mill Rice  Khtta', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000074', 'Zam Traders Cash', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000075', 'Zaqat', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000076', 'SUSPENSE AC', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2610000077', 'MALIK MAHI NAWAB ADDA', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('27', 'CASH & BANK BALANCES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('271000', 'CASH', null, '1999', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('272000', 'Bank Accounts', null, '1999', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000001', 'Abl Bank', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000002', 'Alfalh Bank Tank Adda', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000003', 'Alhabib Bank New Ac', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000004', 'Faysal Bank(1449)', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000005', 'HBL BANK (7901408403)', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('2720000006', 'Mcb Bank', null, null, null, null, null, null, null, null, null, '', '', '', '', '0.00', '', '');
INSERT INTO `nom` VALUES ('30', 'REVENUE', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('301000', 'SALES', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('301010', 'DISCOUNT ALLOWED', null, '4101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('302000', 'COST OF SALES', null, '5101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('40', 'ADMINISTRATIVE EXPENSES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('401000', 'SHOP EXPENSES', null, '6101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('402000', 'DOMESTIC EXPENSES', null, '6101', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('50', 'SELLING EXPENCES', null, '0', null, null, 'click', null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('501000', 'FREIGHT ON SALE', null, '6201', null, null, null, null, 'KT', null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('60', 'INCOME', null, '8101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('601000', 'Other Income', null, '8101', null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('90', 'Suspense', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');
INSERT INTO `nom` VALUES ('900001', 'Suspense', null, null, null, null, null, null, null, null, null, '', '', '', '020115', '0.00', '', '');

-- ----------------------------
-- Table structure for `nom_add`
-- ----------------------------
DROP TABLE IF EXISTS `nom_add`;
CREATE TABLE `nom_add` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `reg_id` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_add
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_copy`
-- ----------------------------
DROP TABLE IF EXISTS `nom_copy`;
CREATE TABLE `nom_copy` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT 'HO'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_copy
-- ----------------------------
INSERT INTO `nom_copy` VALUES ('01', 'CAPITAL & LIABILITIES', '0', '', '', 'HO');

-- ----------------------------
-- Table structure for `nom_lc`
-- ----------------------------
DROP TABLE IF EXISTS `nom_lc`;
CREATE TABLE `nom_lc` (
  `ACCT_ID` char(10) NOT NULL,
  `OPEN_DATE` datetime NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_lc
-- ----------------------------

-- ----------------------------
-- Table structure for `nom_old`
-- ----------------------------
DROP TABLE IF EXISTS `nom_old`;
CREATE TABLE `nom_old` (
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `acct_name` varchar(50) DEFAULT '',
  `acct_type` varchar(4) DEFAULT NULL,
  `user_id` varchar(8) DEFAULT '',
  `type_id` varchar(4) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '01',
  PRIMARY KEY (`comp_id`,`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of nom_old
-- ----------------------------
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '0', '', '', '01');
INSERT INTO `nom_old` VALUES ('010001', 'DIRECT EXPENSES', '31', '', '5', '01');
INSERT INTO `nom_old` VALUES ('0100010001', 'COST OF GOOD SOLD', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '31', '', '61', '01');
INSERT INTO `nom_old` VALUES ('0100020001', 'ENTERTAINMENT EXPENSES', null, '', '', '01');
INSERT INTO `nom_old` VALUES ('0100020002', 'TRAVELLING EXPENSES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020003', 'STATIONARY', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020004', 'ADVERTISEMENT EXP', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020005', 'GROCERY EXP', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020006', 'OFFICE EXPENSES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020007', 'REPAIR AND MAINTAINANCE\r\n', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020008', 'RENT WAREHOUSE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100020010', 'KARIM BLOCK OUTLET EXPENSES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010003', 'OPENING BALANCES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100030001', 'OPENING BALANCES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('010010', 'STAFF SALARIES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0100100001', 'STAFF SALARIES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('02', 'EQUITY', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('020001', 'PROPRITERS CAPITAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0200010001', 'PROPRITERS CAPITAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0200010002', 'OPENING BALANCE ADJUSTMENT ACOOUNT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('03', 'Short Term Liabilites', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('030007', 'Accrued Salaries', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070001', 'SALARY PAYABLE KAMRAN', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070002', 'SALARY PAYABLE - NADISH', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070003', 'SALARY PAYABLE - KHURRAM', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070004', 'SALARY PAYABLE - JAVED', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070005', 'SALARY PAYABLE - FAROOQ', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070006', 'SALARY PAYABLE - SHUJA BAHI (TAX ADVISOR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070007', 'SALARY PAYABLE - VICTOR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070008', 'SALARY PAYABLE - MOHSIN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070009', 'SALARY PAYABLE - FAISAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070010', 'SALARY PAYABLE - TALAH', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070011', 'SALARY PAYABLE - SIKANDAR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070012', 'SALARY PAYABLE - SONIL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('0300070013', 'SALARY PAYABLE - ALI RAZA', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('10', 'LIABILITIES', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('100001', 'VENDOR FINISHED GOODS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010001', 'VENDOR SHOES - KASHIF PAYABLE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010002', 'MR MAJEED (KURTA)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010003', 'MR TAHIR (WAIST COAT)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010004', 'MR ARIF (EMBROIDARY)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010005', 'MR MUSHTAQ (HSY)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000010006', 'HUMD INTERNATIONAL PVT LTD', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('100002', 'VENDOR RAW MATERIAL', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020001', 'HAMZA AKHTAR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020002', 'HAJI KHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020003', 'WAZIR AHMED', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020004', 'ZAKIR', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020005', 'LONDON', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020006', 'DARWESH KHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020007', 'AL-REHMAT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('1000020008', 'SHADMAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('20', 'STOCK', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('200001', 'STOCK IN TRADE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2000010001', 'STOCK IN TRADE (RM)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2000010002', 'STOCK IN TRADE (FG)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '19', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000002', 'ELECTRONICS', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2710000003', 'FURNITURE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('272000', 'BANK BALANCES', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2720000001', 'HABIB BANK', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2720000002', 'FAYSAL BANK', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('273000', 'OUTLET', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000001', 'HEAD OFFICE', '', '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000002', 'STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000003', 'DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000004', 'EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000005', 'EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000006', 'SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000007', 'FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000008', 'OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000009', 'BWP ', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('2730000012', 'KAREEM BLOCK', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('41', 'TURNOVER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('410001', 'SALE', null, '', '4', '01');
INSERT INTO `nom_old` VALUES ('4100010001', 'SALES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010002', 'SALE - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010003', 'SALES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010004', 'SALES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010005', 'SALES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010006', 'SALES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010007', 'SALES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010008', 'SALES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010009', 'SALES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100010012', 'SALES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410002', 'DISCOUNT', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020001', 'DISCOUNT - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020002', 'DISCOUNT - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020003', 'DISCOUNT - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020004', 'DISCOUNT - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020005', 'DISCOUNT - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020006', 'DISCOUNT - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020007', 'DISCOUNT - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020008', 'DISCOUNT - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020009', 'DISCOUNT - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100020012', 'DISCOUNT - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410003', 'SALES RETURN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030001', 'RETURN - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030002', 'RETURN - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030003', 'RETURN - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030004', 'RETURN - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030005', 'RETURN - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030006', 'RETURN - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030007', 'RETURN - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030008', 'RETURN - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030009', 'RETURN - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100030012', 'RETURN - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410004', 'CREDIT NOTES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040001', 'CREDIT NOTES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040002', 'CREDIT NOTES - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040003', 'CREDIT NOTES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040004', 'CREDIT NOTES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040005', 'CREDIT NOTES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040006', 'CREDIT NOTES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040007', 'CREDIT NOTES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040008', 'CREDIT NOTES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040009', 'CREDIT NOTES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100040012', 'CREDIT NOTES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('410005', 'DEBIT NOTES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050001', 'DEBIT NOTES - HEAD OFFICE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050002', 'DEBIT NOTES - STUDIO MEER', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050003', 'DEBIT NOTES - DREAMS', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050004', 'DEBIT NOTES - EQUATOR(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050005', 'DEBIT NOTES - EQUATOR(LR)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050006', 'DEBIT NOTES - SATELLITE TOWN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050007', 'DEBIT NOTES - FLAGSHIP STORE', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050008', 'DEBIT NOTES - OUTLET(KB)', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050009', 'DEBIT NOTES - BWP', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('4100050012', 'DEBIT NOTES - KAREEM BLOCK', '', '', '', '01');
INSERT INTO `nom_old` VALUES ('99', 'COST CENTRES', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('990001', 'STAFF', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010001', 'ALI SHAN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010002', 'HUSNAIN', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('9900010003', 'MUSA', null, '', null, '01');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '02');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '05');
INSERT INTO `nom_old` VALUES ('20', 'STOCK', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('200001', 'STOCK IN TRADE', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('2000010001', 'STOCK IN TRADE (RM)', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('2000010002', 'STOCK IN TRADE (FG)', null, '', null, '06');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '06');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', null, '', null, '07');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', null, '', null, '08');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '10');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('0100020009', 'KAREEM BLOCK OUTLET EXPENSES', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '12');
INSERT INTO `nom_old` VALUES ('01', 'Expenses', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('010002', 'INDIRECT EXPENSES', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('0100020009', 'FLAGSHIP OUTLET EXPENSES', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('27', 'CURRENT ASSETS', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('271000', 'CASH ACCOUNTS', '', '', '', '13');
INSERT INTO `nom_old` VALUES ('2710000001', 'CASH IN HAND', '', '', '', '13');

-- ----------------------------
-- Table structure for `o_batch`
-- ----------------------------
DROP TABLE IF EXISTS `o_batch`;
CREATE TABLE `o_batch` (
  `PROD_ID` varchar(4) NOT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `BAL_QTY` decimal(10,0) DEFAULT NULL,
  `O_QTY` decimal(10,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_batch
-- ----------------------------
INSERT INTO `o_batch` VALUES ('0420', '2017-04-30 00:00:00', 'TOS-1525', null, '1200');

-- ----------------------------
-- Table structure for `o_voucher`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucher`;
CREATE TABLE `o_voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` datetime NOT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `POSTED` varchar(1) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucher
-- ----------------------------

-- ----------------------------
-- Table structure for `o_voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucherdet`;
CREATE TABLE `o_voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `DEBIT` decimal(13,2) DEFAULT NULL,
  `CREDIT` decimal(13,2) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucherdet
-- ----------------------------

-- ----------------------------
-- Table structure for `o_voucherdet_e`
-- ----------------------------
DROP TABLE IF EXISTS `o_voucherdet_e`;
CREATE TABLE `o_voucherdet_e` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `BPV_ID` varchar(20) DEFAULT NULL,
  `TENDER_NO` varchar(50) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of o_voucherdet_e
-- ----------------------------

-- ----------------------------
-- Table structure for `party`
-- ----------------------------
DROP TABLE IF EXISTS `party`;
CREATE TABLE `party` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `add_line1` varchar(50) DEFAULT '',
  `add_line2` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `phone` varchar(50) DEFAULT '',
  `fax` varchar(50) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `history` mediumtext,
  `contact` varchar(100) DEFAULT NULL,
  `ntn` varchar(50) DEFAULT NULL,
  `stax_no` varchar(20) DEFAULT NULL,
  `cnic` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `inactive` char(2) DEFAULT NULL,
  `gl_acct_id` varchar(10) DEFAULT NULL,
  `party_type` char(1) NOT NULL DEFAULT 'C',
  `old_acct_id` varchar(7) DEFAULT NULL,
  `del_day` varchar(10) DEFAULT NULL,
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `credit_days` int(6) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party
-- ----------------------------

-- ----------------------------
-- Table structure for `party_add`
-- ----------------------------
DROP TABLE IF EXISTS `party_add`;
CREATE TABLE `party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `party_product`
-- ----------------------------
DROP TABLE IF EXISTS `party_product`;
CREATE TABLE `party_product` (
  `PARTY_ID` varchar(4) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `UNIT_RATE` decimal(10,3) DEFAULT NULL,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `P_RATE` decimal(10,3) DEFAULT NULL,
  `LINEITEM` decimal(6,0) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_product
-- ----------------------------
INSERT INTO `party_product` VALUES ('0001', '0357', '46.000', null, null, null, '3');

-- ----------------------------
-- Table structure for `party_type`
-- ----------------------------
DROP TABLE IF EXISTS `party_type`;
CREATE TABLE `party_type` (
  `acct_id` varchar(4) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of party_type
-- ----------------------------
INSERT INTO `party_type` VALUES ('C', 'Customer');
INSERT INTO `party_type` VALUES ('S', 'Supplier');
INSERT INTO `party_type` VALUES ('T', 'Trader');
INSERT INTO `party_type` VALUES ('I', 'Import');
INSERT INTO `party_type` VALUES ('P', 'Production');
INSERT INTO `party_type` VALUES ('A', 'Cash');
INSERT INTO `party_type` VALUES ('O', 'Other');
INSERT INTO `party_type` VALUES ('V', 'Vender');

-- ----------------------------
-- Table structure for `pay_mode`
-- ----------------------------
DROP TABLE IF EXISTS `pay_mode`;
CREATE TABLE `pay_mode` (
  `mode_id` char(2) NOT NULL DEFAULT '',
  `mode_name` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`mode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pay_mode
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dc`;
CREATE TABLE `pl_dc` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_dcdet`;
CREATE TABLE `pl_dcdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gp`;
CREATE TABLE `pl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `pl_gp_fk_loc_id` (`loc_id`),
  KEY `pl_gp_fk_acct_id` (`acct_id`),
  KEY `pl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_gpdet`;
CREATE TABLE `pl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `pl_gpdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grn`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grn`;
CREATE TABLE `pl_grn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(4) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grn
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_grndet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_grndet`;
CREATE TABLE `pl_grndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_grndet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice`;
CREATE TABLE `pl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `emp_id` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoice_fk_loc_id` (`loc_id`),
  KEY `pl_invoice_fk_acct_id` (`acct_id`),
  KEY `pl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice
-- ----------------------------
INSERT INTO `pl_invoice` VALUES ('090001', '2017-09-16', '1310000001', '0.00', '0.00', '27040216.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:04:32', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '27040216', 'click');
INSERT INTO `pl_invoice` VALUES ('090002', '2017-09-16', '1310000002', '0.00', '0.00', '6474925.80', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '6474926', 'click');
INSERT INTO `pl_invoice` VALUES ('090003', '2017-09-16', '1310000003', '0.00', '0.00', '6474925.80', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '6474926', 'click');
INSERT INTO `pl_invoice` VALUES ('090004', '2017-09-16', '1310000004', '0.00', '0.00', '2510665.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '2510665', 'click');
INSERT INTO `pl_invoice` VALUES ('090005', '2017-09-16', '1310000003', '0.00', '0.00', '2510665.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '2510665', 'click');
INSERT INTO `pl_invoice` VALUES ('090006', '2017-09-16', '1310000005', '0.00', '0.00', '8795969.60', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '8795970', 'click');
INSERT INTO `pl_invoice` VALUES ('090007', '2017-09-16', '1310000006', '0.00', '0.00', '8795969.60', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '8795970', 'click');
INSERT INTO `pl_invoice` VALUES ('090008', '2017-09-16', '1310000007', '0.00', '0.00', '6708900.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '6708900', 'click');
INSERT INTO `pl_invoice` VALUES ('090009', '2017-09-16', '1310000008', '0.00', '0.00', '6708900.00', null, null, null, null, null, null, '', '1970-01-01', null, null, null, null, '01', null, '2017-09-17 13:34:15', '', '0002', '', '0.000', '', '', '0.00', '', '', null, 'TT', '17', 'on', '', '', '0', '0', '', '', '', '', '6708900', 'click');

-- ----------------------------
-- Table structure for `pl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedet`;
CREATE TABLE `pl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `pl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedet
-- ----------------------------
INSERT INTO `pl_invoicedet` VALUES ('090001', '1', '0001', '', '5600.000', '4828.61000', '27040216.00', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090002', '1', '0001', '', '1260.000', '5138.83000', '6474925.80', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090003', '1', '0001', '', '1260.000', '5138.83000', '6474925.80', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090004', '1', '0001', '', '500.000', '5021.00000', '2510665.00', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', '0.00', '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090005', '1', '0001', '', '500.000', '5021.33000', '2510665.00', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090006', '1', '0001', '', '1760.000', '4997.71000', '8795969.60', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090007', '1', '0001', '', '1760.000', '4997.71000', '8795969.60', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090008', '1', '0001', '', '1320.000', '5082.50000', '6708900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', null, '0', '0');
INSERT INTO `pl_invoicedet` VALUES ('090009', '1', '0001', '', '1320.000', '5082.50000', '6708900.00', '', null, null, null, null, null, null, null, null, null, null, null, 'TT', '17', '0.000', null, '0', '0');

-- ----------------------------
-- Table structure for `pl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoicedetapp`;
CREATE TABLE `pl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_invoice_adv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_invoice_adv`;
CREATE TABLE `pl_invoice_adv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `REC_ID` varchar(15) NOT NULL,
  `AMOUNT` decimal(15,0) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_invoice_adv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jv`;
CREATE TABLE `pl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet`;
CREATE TABLE `pl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_jvdet_inst`;
CREATE TABLE `pl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_order`
-- ----------------------------
DROP TABLE IF EXISTS `pl_order`;
CREATE TABLE `pl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `po_no` varchar(30) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `disc_amt` decimal(15,2) DEFAULT NULL,
  `dc_amt` decimal(15,2) DEFAULT NULL,
  `loc_id` char(2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `sp_id` varchar(7) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `service` char(2) DEFAULT NULL,
  `ut` char(2) DEFAULT NULL,
  `adv_amt` decimal(15,2) DEFAULT NULL,
  `net_amt` decimal(15,2) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `pl_order_fk_loc_id` (`loc_id`),
  KEY `pl_order_fk_acct_id` (`acct_id`),
  KEY `pl_order_fk_comp_id` (`comp_id`),
  KEY `pl_order_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_orderdet`;
CREATE TABLE `pl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` decimal(6,3) DEFAULT NULL,
  `stax` decimal(15,2) DEFAULT NULL,
  `stax_rate` decimal(15,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `sed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`),
  KEY `pl_orderdet_fk_stock_code` (`stock_code`),
  KEY `pl_orderdet_fk_v_id` (`comp_id`,`year_id`,`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `pl_pay`;
CREATE TABLE `pl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) NOT NULL DEFAULT '',
  `mode_id` char(2) NOT NULL DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(7) NOT NULL DEFAULT '',
  `other_id_2` varchar(7) NOT NULL DEFAULT '',
  `other_id_3` varchar(7) NOT NULL DEFAULT '',
  `itax_id` varchar(7) NOT NULL DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet`;
CREATE TABLE `pl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paydet_inst`;
CREATE TABLE `pl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `pl_payment`;
CREATE TABLE `pl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(30) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_paymentdet`;
CREATE TABLE `pl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `R_NO` varchar(30) DEFAULT NULL,
  `V_NO` varchar(30) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_po`;
CREATE TABLE `pl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_podet`;
CREATE TABLE `pl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `DELIVERY_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receipt`;
CREATE TABLE `pl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `REC_NO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet`;
CREATE TABLE `pl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_acct`;
CREATE TABLE `pl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_inv`;
CREATE TABLE `pl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_receiptdet_po`
-- ----------------------------
DROP TABLE IF EXISTS `pl_receiptdet_po`;
CREATE TABLE `pl_receiptdet_po` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  `AMOUNT_FC` decimal(13,2) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`LINE_ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_receiptdet_po
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship`;
CREATE TABLE `pl_ship` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) NOT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `GD_NO` varchar(30) DEFAULT NULL,
  `BOL_NO` varchar(30) DEFAULT NULL,
  `AWB_NO` varchar(30) DEFAULT NULL,
  `FORWARDER` varchar(30) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `CONTAINER_NO` varchar(30) DEFAULT NULL,
  `WT` varchar(10) DEFAULT NULL,
  `NO_CARTONS` varchar(10) DEFAULT NULL,
  `STATUS_ID` varchar(2) NOT NULL,
  `ARRIVAL_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_shipdet`
-- ----------------------------
DROP TABLE IF EXISTS `pl_shipdet`;
CREATE TABLE `pl_shipdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PARTICULARS` text,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_shipdet
-- ----------------------------

-- ----------------------------
-- Table structure for `pl_ship_inv`
-- ----------------------------
DROP TABLE IF EXISTS `pl_ship_inv`;
CREATE TABLE `pl_ship_inv` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `PO_ID` varchar(7) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of pl_ship_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `po`
-- ----------------------------
DROP TABLE IF EXISTS `po`;
CREATE TABLE `po` (
  `PO_ID` varchar(5) NOT NULL,
  `PO_DATE` datetime NOT NULL,
  `PARTY_ID` varchar(7) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po
-- ----------------------------

-- ----------------------------
-- Table structure for `podet`
-- ----------------------------
DROP TABLE IF EXISTS `podet`;
CREATE TABLE `podet` (
  `PO_ID` varchar(6) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `ORD_QTY` decimal(13,3) NOT NULL,
  `ORD_RATE` decimal(13,2) DEFAULT NULL,
  `DMD_LINEITEM` decimal(4,0) DEFAULT NULL,
  `DMD_NO` varchar(6) DEFAULT NULL,
  `REC_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(13,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`PO_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of podet
-- ----------------------------

-- ----------------------------
-- Table structure for `po_type`
-- ----------------------------
DROP TABLE IF EXISTS `po_type`;
CREATE TABLE `po_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of po_type
-- ----------------------------
INSERT INTO `po_type` VALUES ('01', 'Ex Works');

-- ----------------------------
-- Table structure for `process`
-- ----------------------------
DROP TABLE IF EXISTS `process`;
CREATE TABLE `process` (
  `PROCESS_ID` decimal(4,0) NOT NULL,
  `PROCESS_NAME` varchar(20) NOT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of process
-- ----------------------------
INSERT INTO `process` VALUES ('1', 'Mixing');

-- ----------------------------
-- Table structure for `prod`
-- ----------------------------
DROP TABLE IF EXISTS `prod`;
CREATE TABLE `prod` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `PROD_ID` varchar(9) DEFAULT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `REJECTED` decimal(10,3) DEFAULT NULL,
  `D_LOT_NO` varchar(10) DEFAULT NULL,
  `TARGET` decimal(13,3) DEFAULT NULL,
  `WORK_NOS` decimal(6,0) DEFAULT NULL,
  `WORK_TIME` decimal(6,2) DEFAULT NULL,
  `STD_TIME` decimal(6,2) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `ADJ_AMT` decimal(13,2) DEFAULT NULL,
  `CLOSE_DATE` datetime DEFAULT NULL,
  `QTY_SAMPLE` decimal(13,3) DEFAULT NULL,
  `UNIT_COST` decimal(13,4) DEFAULT NULL,
  `WIP_AMT` decimal(13,2) DEFAULT NULL,
  `WASTE_AMT` decimal(13,2) DEFAULT NULL,
  `WIP_QTY` decimal(13,3) DEFAULT NULL,
  `WASTE_QTY` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod
-- ----------------------------

-- ----------------------------
-- Table structure for `proddet`
-- ----------------------------
DROP TABLE IF EXISTS `proddet`;
CREATE TABLE `proddet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `REQ_QTY` decimal(13,3) DEFAULT NULL,
  `REJ_QTY` decimal(13,0) DEFAULT NULL,
  `FORMULA` varchar(1) DEFAULT NULL,
  `CON_QTY` decimal(13,3) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `SER_NO` varchar(2) DEFAULT NULL,
  `QC_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of proddet
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_batch`
-- ----------------------------
DROP TABLE IF EXISTS `prod_batch`;
CREATE TABLE `prod_batch` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `P_DATE` datetime DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `TOLL_RATE` decimal(10,2) DEFAULT NULL,
  `TOLL_AMT` decimal(10,2) DEFAULT NULL,
  `SAMPLE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_batch
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_cat`
-- ----------------------------
DROP TABLE IF EXISTS `prod_cat`;
CREATE TABLE `prod_cat` (
  `CAT_ID` varchar(6) NOT NULL,
  `CAT_NAME` varchar(100) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `GRP_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_cat
-- ----------------------------
INSERT INTO `prod_cat` VALUES ('01', 'Ghee', null, null, null);
INSERT INTO `prod_cat` VALUES ('02', 'CHOKAR', null, null, null);
INSERT INTO `prod_cat` VALUES ('03', 'Detergents', null, null, null);
INSERT INTO `prod_cat` VALUES ('04', 'Grains', null, null, null);
INSERT INTO `prod_cat` VALUES ('05', 'Others', null, null, null);
INSERT INTO `prod_cat` VALUES ('06', 'Spices', null, null, null);
INSERT INTO `prod_cat` VALUES ('07', 'Sugar', null, null, null);
INSERT INTO `prod_cat` VALUES ('08', 'Rice 25 kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('09', 'Oil', null, null, null);
INSERT INTO `prod_cat` VALUES ('10', 'Rahat Cortans', null, null, null);
INSERT INTO `prod_cat` VALUES ('11', 'Sultan/Kashmir 5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('12', 'Sultan/Kashmir/Meezan 2.5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('13', 'Sultan/Kashmir 10kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('14', 'Sultan/Kashmir 16kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('15', 'Sultan/Latif/Kashmir 16ltr Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('16', 'Rahat Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('17', 'Millat/Maqbool 16kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('18', 'Millat/Maqbool 10kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('19', 'Millat/Maqbool 5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('20', 'Millat/Maqbool 2.5kg Bucket', null, null, null);
INSERT INTO `prod_cat` VALUES ('21', 'Millat Cortan/Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('22', 'Daal 25 kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('23', 'Cholaa 25/50kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('24', 'FLOUR', null, null, null);
INSERT INTO `prod_cat` VALUES ('25', 'MAIDA/STARICH', null, null, null);
INSERT INTO `prod_cat` VALUES ('26', 'KHAL', null, null, null);
INSERT INTO `prod_cat` VALUES ('27', 'SOOJI', null, null, null);
INSERT INTO `prod_cat` VALUES ('28', 'WANDA', null, null, null);
INSERT INTO `prod_cat` VALUES ('29', 'BASIN', null, null, null);
INSERT INTO `prod_cat` VALUES ('30', 'Rice 50 kg', null, null, null);
INSERT INTO `prod_cat` VALUES ('31', 'Rahat/Millat 5kg can', null, null, null);
INSERT INTO `prod_cat` VALUES ('32', 'Rahat/Millat 2.5 kg can', null, null, null);
INSERT INTO `prod_cat` VALUES ('33', 'WASHING POWDERs', null, null, null);
INSERT INTO `prod_cat` VALUES ('34', 'SOAP', null, null, null);
INSERT INTO `prod_cat` VALUES ('35', 'Sultan/Latif/Kashmir 5 kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('36', 'Sultan/Latif/Kashmir 2.5kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('37', 'Sultan/Kashmir 5kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('38', 'Sultan/Kashmir 2.5kg Tin', null, null, null);
INSERT INTO `prod_cat` VALUES ('39', 'Sultan/Kashmir 5ltr Dispenser', null, null, null);
INSERT INTO `prod_cat` VALUES ('40', 'Sultan/Kashmir Cortans', null, null, null);
INSERT INTO `prod_cat` VALUES ('41', 'Sultan/Kashmir 16kg Tin', null, null, null);

-- ----------------------------
-- Table structure for `prod_comp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_comp`;
CREATE TABLE `prod_comp` (
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `comp_code` varchar(13) NOT NULL DEFAULT '',
  `factor` decimal(10,3) DEFAULT NULL,
  `ser_no` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`stock_code`,`comp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_comp
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_grp`
-- ----------------------------
DROP TABLE IF EXISTS `prod_grp`;
CREATE TABLE `prod_grp` (
  `GRP_ID` varchar(2) NOT NULL,
  `GRP_NAME` varchar(30) NOT NULL,
  PRIMARY KEY (`GRP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_grp
-- ----------------------------
INSERT INTO `prod_grp` VALUES ('01', 'Group Name');

-- ----------------------------
-- Table structure for `prod_rm_date`
-- ----------------------------
DROP TABLE IF EXISTS `prod_rm_date`;
CREATE TABLE `prod_rm_date` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`P_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_rm_date
-- ----------------------------

-- ----------------------------
-- Table structure for `prod_type`
-- ----------------------------
DROP TABLE IF EXISTS `prod_type`;
CREATE TABLE `prod_type` (
  `TYPE_ID` varchar(2) NOT NULL,
  `TYPE_NAME` varchar(30) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `ACCT_ID_PL` char(10) NOT NULL,
  `ACCT_ID_COGS` char(10) DEFAULT NULL,
  PRIMARY KEY (`TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of prod_type
-- ----------------------------
INSERT INTO `prod_type` VALUES ('01', 'Franchise Group', '0700100001', '0500030003', '0800010101');

-- ----------------------------
-- Table structure for `regions`
-- ----------------------------
DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
  `reg_id` varchar(6) NOT NULL DEFAULT '',
  `reg_name` varchar(100) NOT NULL,
  PRIMARY KEY (`reg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of regions
-- ----------------------------
INSERT INTO `regions` VALUES ('01', 'PUNJAB');
INSERT INTO `regions` VALUES ('0101', 'Lahore');
INSERT INTO `regions` VALUES ('010101', 'DHA');
INSERT INTO `regions` VALUES ('0102', 'MULTAN');
INSERT INTO `regions` VALUES ('02', 'KPK');
INSERT INTO `regions` VALUES ('0201', 'DERA ISMAIL KHAN');
INSERT INTO `regions` VALUES ('020101', 'BANNU ADDA');
INSERT INTO `regions` VALUES ('020102', 'Muriali to Ramak');
INSERT INTO `regions` VALUES ('020103', 'Sheikh yousaf Adda');
INSERT INTO `regions` VALUES ('020104', 'Raheem Bazar');
INSERT INTO `regions` VALUES ('020105', 'Tijarat Ganj');
INSERT INTO `regions` VALUES ('020106', 'Out Station');
INSERT INTO `regions` VALUES ('020107', 'Misgran Bazar');
INSERT INTO `regions` VALUES ('020108', 'Old Ledger');
INSERT INTO `regions` VALUES ('020109', 'Muslim Bazar');
INSERT INTO `regions` VALUES ('020110', 'Kalan Bazar');
INSERT INTO `regions` VALUES ('020111', 'Main Dealers');
INSERT INTO `regions` VALUES ('020112', 'D.I.Khan Suburbs');
INSERT INTO `regions` VALUES ('020113', 'Ghala Mandi, Bazar Kalan, Chot');
INSERT INTO `regions` VALUES ('020114', 'Muryali to Qureshi Morr');
INSERT INTO `regions` VALUES ('020115', 'Others');
INSERT INTO `regions` VALUES ('1', 'Punjab (Province)');

-- ----------------------------
-- Table structure for `replanishment`
-- ----------------------------
DROP TABLE IF EXISTS `replanishment`;
CREATE TABLE `replanishment` (
  `stock_code` varchar(50) DEFAULT NULL,
  `qty` decimal(20,0) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of replanishment
-- ----------------------------
INSERT INTO `replanishment` VALUES ('SD03001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03002BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03005OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD03007BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04001BG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD04002YB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07001SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07002BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07003LR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD07004MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10002BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10005OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10007BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10008BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD10009MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11001GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11002RD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD11003WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12001BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12002BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12004BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SD12005BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00001PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00002OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00004SN11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00005BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00006GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00007BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00008BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00009BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00010MS11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00011BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00012KH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00013MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00014BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00015SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00016WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00017WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00018WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00019CB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00020MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00021BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG00022BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG02097GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001MD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03001OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002MD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG03002OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04001SG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04002MV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04003MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04004PK11', '1', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SG04005PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00001GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00002MU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00003WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00004BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00005WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00006GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00007GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00008PL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00009BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00010GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011DG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00011LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00012GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00013MH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00017BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00018GB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00019BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00020PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00021WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00022MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00023GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025MV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00025PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026BD11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026FE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00026NE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027CR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027FE11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00027LV11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00030BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00033WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00034WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00035BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00036GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00037BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00038GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00039GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00040GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00041PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00042BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00049GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00055OR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00056MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00059GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00060WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00062BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00063BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00064BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00070BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00071GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00072BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00073PH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00074BU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00075BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00076BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00077WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00079WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00082PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00083LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00086GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00087OR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00088PR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00089WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00090BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00092OF11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00093WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00094BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00095WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00096WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00097RS11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00098DB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00099OW11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00100GR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00101LG11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00102SB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00103FN11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00105CB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00107NB11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00109WH11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00110GO11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00112PU11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00113GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00114BR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00115BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00116GY11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00117BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00118BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00119BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00120MR11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL08', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL09', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL10', '2', '12');
INSERT INTO `replanishment` VALUES ('SK00121BL11', '1', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH08', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH09', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH10', '0', '12');
INSERT INTO `replanishment` VALUES ('SK00122WH11', '0', '12');
INSERT INTO `replanishment` VALUES ('SD03001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03002BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03005OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD03007BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04001BG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD04002YB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07001SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07002BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07003LR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD07004MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10002BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10005OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10007BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10008BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD10009MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11001GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11002RD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD11003WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12001BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12002BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12004BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SD12005BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00001PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00002OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00004SN11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00005BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00006GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00007BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00008BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00009BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00010MS11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00011BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00012KH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00013MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00014BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00015SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00016WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00017WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00018WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00019CB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00020MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00021BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG00022BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG02097GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001MD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03001OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002MD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG03002OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04001SG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04002MV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04003MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04004PK11', '1', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SG04005PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00001GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00002MU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00003WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00004BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00005WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00006GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00007GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00008PL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00009BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00010GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011DG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00011LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00012GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00013MH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00017BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00018GB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00019BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00020PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00021WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00022MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00023GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025MV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00025PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026BD11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026FE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00026NE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027CR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027FE11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00027LV11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00030BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00033WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00034WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00035BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00036GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00037BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00038GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00039GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00040GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00041PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00042BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00049GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00055OR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00056MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00059GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00060WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00062BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00063BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00064BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00070BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00071GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00072BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00073PH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00074BU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00075BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00076BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00077WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00079WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00082PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00083LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00086GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00087OR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00088PR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00089WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00090BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00092OF11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00093WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00094BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00095WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00096WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00097RS11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00098DB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00099OW11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00100GR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00101LG11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00102SB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00103FN11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00105CB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00107NB11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00109WH11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00110GO11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00112PU11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00113GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00114BR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00115BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00116GY11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00117BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00118BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00119BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00120MR11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL08', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL09', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL10', '2', '05');
INSERT INTO `replanishment` VALUES ('SK00121BL11', '1', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH08', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH09', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH10', '0', '05');
INSERT INTO `replanishment` VALUES ('SK00122WH11', '0', '05');

-- ----------------------------
-- Table structure for `report`
-- ----------------------------
DROP TABLE IF EXISTS `report`;
CREATE TABLE `report` (
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report
-- ----------------------------
INSERT INTO `report` VALUES ('2010-11-25', '2015-11-25');

-- ----------------------------
-- Table structure for `reports`
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`REP_ID`),
  UNIQUE KEY `REPORTS_PK11109972190599` (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports
-- ----------------------------
INSERT INTO `reports` VALUES ('trial_balance', 'Trial Balance', '1', '', '001');
INSERT INTO `reports` VALUES ('ledger', 'Ledger', '1', 'N', '003');
INSERT INTO `reports` VALUES ('profit_loss', 'Profit & Loss', '1', 'N', '004');
INSERT INTO `reports` VALUES ('chart', 'Chart of Accounts', '1', 'N', '005');
INSERT INTO `reports` VALUES ('balance_sheet', 'Balance Sheet', '1', 'N', '006');
INSERT INTO `reports` VALUES ('daybook_kt', 'Daybook', '1', 'Y', '007');
INSERT INTO `reports` VALUES ('pdf_sl_due_invoices', 'Due Invoices', '2', '', '009');
INSERT INTO `reports` VALUES ('pf_sl_supply_register', 'Supply Register', '2', '', '010');
INSERT INTO `reports` VALUES ('report_current_stock', 'Current Stock', '2', '', '011');
INSERT INTO `reports` VALUES ('report_sale?report=PL', 'Day Book', '3', '', '012');
INSERT INTO `reports` VALUES ('report_sale?report=ST', 'Day Book', '4', '', '013');
INSERT INTO `reports` VALUES ('stock_ledger', 'Stock Ledger', '4', '', '014');
INSERT INTO `reports` VALUES ('stock_summary', 'Stock Summary', '4', '', '015');
INSERT INTO `reports` VALUES ('smart_stock', 'Smart Stock', '4', '', '016');
INSERT INTO `reports` VALUES ('report_sale?report=SL', 'Day Book', '2', '', '017');
INSERT INTO `reports` VALUES ('cashbook', 'Cash Book', '1', '', '018');
INSERT INTO `reports` VALUES ('report_sales', 'Sale Report', '2', 'Y', '019');
INSERT INTO `reports` VALUES ('party_trial', 'Trial', '2', '', '020');

-- ----------------------------
-- Table structure for `reports_all`
-- ----------------------------
DROP TABLE IF EXISTS `reports_all`;
CREATE TABLE `reports_all` (
  `FILE_NAME` varchar(50) NOT NULL,
  `REPORT_NAME` varchar(50) NOT NULL,
  `CAT` decimal(1,0) NOT NULL,
  `LANDSCAPE` varchar(1) NOT NULL,
  PRIMARY KEY (`FILE_NAME`,`CAT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of reports_all
-- ----------------------------
INSERT INTO `reports_all` VALUES ('accountsummary', 'Account Summary', '1', 'N');

-- ----------------------------
-- Table structure for `report_brands`
-- ----------------------------
DROP TABLE IF EXISTS `report_brands`;
CREATE TABLE `report_brands` (
  `BRAND_ID_1` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_2` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_3` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_4` decimal(4,0) DEFAULT NULL,
  `BRAND_ID_5` decimal(4,0) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_brands
-- ----------------------------
INSERT INTO `report_brands` VALUES ('1301', '1202', '1103', '1102', null);

-- ----------------------------
-- Table structure for `report_cat`
-- ----------------------------
DROP TABLE IF EXISTS `report_cat`;
CREATE TABLE `report_cat` (
  `CAT_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`CAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `report_comp`
-- ----------------------------
DROP TABLE IF EXISTS `report_comp`;
CREATE TABLE `report_comp` (
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_comp
-- ----------------------------
INSERT INTO `report_comp` VALUES ('01');

-- ----------------------------
-- Table structure for `report_cs`
-- ----------------------------
DROP TABLE IF EXISTS `report_cs`;
CREATE TABLE `report_cs` (
  `ACCT_ID` char(10) NOT NULL,
  PRIMARY KEY (`ACCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_cs
-- ----------------------------

-- ----------------------------
-- Table structure for `report_div`
-- ----------------------------
DROP TABLE IF EXISTS `report_div`;
CREATE TABLE `report_div` (
  `DIV_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`DIV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_div
-- ----------------------------

-- ----------------------------
-- Table structure for `report_party`
-- ----------------------------
DROP TABLE IF EXISTS `report_party`;
CREATE TABLE `report_party` (
  `PARTY_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_party
-- ----------------------------
INSERT INTO `report_party` VALUES ('0063');

-- ----------------------------
-- Table structure for `report_sp`
-- ----------------------------
DROP TABLE IF EXISTS `report_sp`;
CREATE TABLE `report_sp` (
  `SP_ID` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of report_sp
-- ----------------------------

-- ----------------------------
-- Table structure for `season_cat`
-- ----------------------------
DROP TABLE IF EXISTS `season_cat`;
CREATE TABLE `season_cat` (
  `season_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`season_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of season_cat
-- ----------------------------
INSERT INTO `season_cat` VALUES ('010101', 'WINTER');
INSERT INTO `season_cat` VALUES ('010102', 'SUMMER');

-- ----------------------------
-- Table structure for `size`
-- ----------------------------
DROP TABLE IF EXISTS `size`;
CREATE TABLE `size` (
  `size_id` varchar(6) NOT NULL DEFAULT '',
  `size` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of size
-- ----------------------------
INSERT INTO `size` VALUES ('08', 'S');
INSERT INTO `size` VALUES ('09', 'M');
INSERT INTO `size` VALUES ('10', 'L');
INSERT INTO `size` VALUES ('11', 'XL');

-- ----------------------------
-- Table structure for `sl_am_con`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_con`;
CREATE TABLE `sl_am_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_con
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_am_condet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_am_condet`;
CREATE TABLE `sl_am_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `staxp` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_am_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_cont`
-- ----------------------------
DROP TABLE IF EXISTS `sl_cont`;
CREATE TABLE `sl_cont` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `cont_no` varchar(10) NOT NULL DEFAULT '',
  `cont_date` date NOT NULL DEFAULT '0000-00-00',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id_cs` varchar(7) NOT NULL DEFAULT '',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00',
  `unit_location` varchar(100) NOT NULL DEFAULT '',
  `ann_inc_p` decimal(6,2) DEFAULT NULL,
  `ann_inc` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_cont
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contdet`;
CREATE TABLE `sl_contdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `ser_no` varchar(50) NOT NULL DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contmaint`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contmaint`;
CREATE TABLE `sl_contmaint` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `visit_no` tinyint(4) DEFAULT NULL,
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `visit_date` date DEFAULT NULL,
  `person` varchar(30) DEFAULT '',
  `visit_report` mediumtext,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contmaint
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_contpay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_contpay`;
CREATE TABLE `sl_contpay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `voucher_date` date DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_contpay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc`;
CREATE TABLE `sl_dc` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) DEFAULT NULL,
  `person` varchar(30) DEFAULT NULL,
  `tpt_mode` varchar(30) DEFAULT NULL,
  `disc_amt` decimal(13,2) DEFAULT NULL,
  `dc_amt` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet`;
CREATE TABLE `sl_dcdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `ser_no` varchar(30) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `discp` decimal(6,0) DEFAULT NULL,
  `discount` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_copy`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_copy`;
CREATE TABLE `sl_dcdet_copy` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_copy
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dcdet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dcdet_ser`;
CREATE TABLE `sl_dcdet_ser` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `dc_lineitem` tinyint(4) NOT NULL DEFAULT '0',
  `ser_no` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`dc_lineitem`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dcdet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtn`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtn`;
CREATE TABLE `sl_dc_rtn` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(7) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `TYPE_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtn
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet`;
CREATE TABLE `sl_dc_rtndet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(3) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_dc_rtndet_ser`
-- ----------------------------
DROP TABLE IF EXISTS `sl_dc_rtndet_ser`;
CREATE TABLE `sl_dc_rtndet_ser` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(30) NOT NULL,
  `PO_LINE_ITEM` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_dc_rtndet_ser
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gp`;
CREATE TABLE `sl_gp` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `received_stock` char(1) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gp_fk_loc_id` (`loc_id`),
  KEY `sl_gp_fk_acct_id` (`acct_id`),
  KEY `sl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gp
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_gpdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_gpdet`;
CREATE TABLE `sl_gpdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_gpdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_gpdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice`;
CREATE TABLE `sl_invoice` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `order_id` varchar(10) NOT NULL,
  `emp_id` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoice_fk_loc_id` (`loc_id`),
  KEY `sl_invoice_fk_acct_id` (`acct_id`),
  KEY `sl_invoice_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet`;
CREATE TABLE `sl_invoicedet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_invoicedet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedetapp`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedetapp`;
CREATE TABLE `sl_invoicedetapp` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(6,0) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedetapp
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoicedet_bon`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoicedet_bon`;
CREATE TABLE `sl_invoicedet_bon` (
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoicedet_bon
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_invoice_rec`
-- ----------------------------
DROP TABLE IF EXISTS `sl_invoice_rec`;
CREATE TABLE `sl_invoice_rec` (
  `REC_ID` varchar(7) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `INV_ID` varchar(5) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_invoice_rec
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jv`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jv`;
CREATE TABLE `sl_jv` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jv
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jvdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jvdet`;
CREATE TABLE `sl_jvdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  `acct_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `debit` decimal(13,2) DEFAULT NULL,
  `credit` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jvdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_jvdet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `sl_jvdet_inst`;
CREATE TABLE `sl_jvdet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_jvdet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_order`
-- ----------------------------
DROP TABLE IF EXISTS `sl_order`;
CREATE TABLE `sl_order` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  `discount_voucher_no` varchar(50) NOT NULL,
  `return_status` varchar(1) NOT NULL,
  `exchange_status` varchar(1) NOT NULL,
  `net_payable` decimal(10,0) NOT NULL,
  `order_id` varchar(10) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_invoice` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_order_fk_loc_id` (`loc_id`),
  KEY `sl_order_fk_acct_id` (`acct_id`),
  KEY `sl_order_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_order
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_orderdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_orderdet`;
CREATE TABLE `sl_orderdet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(6,0) DEFAULT NULL,
  `disc_amt` decimal(10,0) NOT NULL,
  `add_staxp` decimal(6,0) NOT NULL,
  `color_id` varchar(6) NOT NULL,
  `size_id` varchar(6) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_invoicedet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_orderdet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_orderdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_party_add`
-- ----------------------------
DROP TABLE IF EXISTS `sl_party_add`;
CREATE TABLE `sl_party_add` (
  `PARTY_ID` varchar(4) NOT NULL,
  `ADD_ID` decimal(4,0) NOT NULL,
  `ADD_LINE1` varchar(50) DEFAULT NULL,
  `ADD_LINE2` varchar(50) DEFAULT NULL,
  `CITY` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`PARTY_ID`,`ADD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_party_add
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_pay`
-- ----------------------------
DROP TABLE IF EXISTS `sl_pay`;
CREATE TABLE `sl_pay` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `advance` char(2) DEFAULT '',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `db_amt` decimal(13,2) DEFAULT NULL,
  `ret_amt` decimal(13,2) DEFAULT NULL,
  `sec_amt` decimal(13,2) DEFAULT NULL,
  `itax_amt` decimal(13,2) DEFAULT NULL,
  `other_id_1` varchar(10) DEFAULT '',
  `other_id_2` varchar(10) DEFAULT '',
  `other_id_3` varchar(10) DEFAULT '',
  `itax_id` varchar(10) DEFAULT '',
  `other_amt_1` decimal(13,2) DEFAULT NULL,
  `other_amt_2` decimal(13,2) DEFAULT NULL,
  `other_amt_3` decimal(13,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `v_no` varchar(30) DEFAULT NULL,
  `posted` varchar(2) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_pay
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paydet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paydet`;
CREATE TABLE `sl_paydet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `caba_id` varchar(10) DEFAULT NULL,
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`voucher_id`,`lineitem`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paydet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paydet_inst`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paydet_inst`;
CREATE TABLE `sl_paydet_inst` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(6) NOT NULL DEFAULT '0',
  `ser_no` int(6) NOT NULL DEFAULT '0',
  `mode_id` char(2) DEFAULT '',
  `inst_no` varchar(50) DEFAULT '',
  `inst_date` date DEFAULT NULL,
  `particulars` varchar(200) DEFAULT '',
  `v_no` varchar(10) NOT NULL DEFAULT '',
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `bank_name` varchar(50) DEFAULT '',
  `branch_name` varchar(50) DEFAULT '',
  PRIMARY KEY (`voucher_id`,`lineitem`,`ser_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paydet_inst
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_payment`
-- ----------------------------
DROP TABLE IF EXISTS `sl_payment`;
CREATE TABLE `sl_payment` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,4) DEFAULT NULL,
  `PARTY_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `NET_AMT` decimal(13,2) NOT NULL,
  `MODE_ID` varchar(2) NOT NULL,
  `ADVANCE` varchar(1) NOT NULL,
  `INST_NO` varchar(100) DEFAULT NULL,
  `INST_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_payment
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_paymentdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_paymentdet`;
CREATE TABLE `sl_paymentdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_ID` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_paymentdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_po`
-- ----------------------------
DROP TABLE IF EXISTS `sl_po`;
CREATE TABLE `sl_po` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(13,2) DEFAULT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,0) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(10) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(30) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `LOT_ID` varchar(5) DEFAULT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `PO_ID` varchar(5) DEFAULT NULL,
  `BALANCE` decimal(10,2) DEFAULT NULL,
  `DISCP` decimal(6,3) DEFAULT NULL,
  `CREDIT_DAYS` decimal(4,0) DEFAULT NULL,
  `SUP_ID` varchar(4) DEFAULT NULL,
  `BILL_NO` varchar(30) DEFAULT NULL,
  `BILL_DATE` datetime DEFAULT NULL,
  `PROJECT` varchar(1) DEFAULT NULL,
  `SERVICE` varchar(1) DEFAULT NULL,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `ADV_AMT` decimal(13,2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ADDRESS` varchar(200) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(10,5) DEFAULT NULL,
  `ADV_AMT_FC` decimal(13,2) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `DISCOUNT_FC` decimal(10,2) DEFAULT NULL,
  `DC_AMT_FC` decimal(13,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_po
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_podet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_podet`;
CREATE TABLE `sl_podet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) DEFAULT NULL,
  `PACK_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_QTY` decimal(10,3) DEFAULT NULL,
  `UNIT_RATE` decimal(13,5) DEFAULT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,2) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` text,
  `DISCP` decimal(6,2) DEFAULT NULL,
  `DISCOUNT` decimal(10,2) DEFAULT NULL,
  `S_DISCP` decimal(6,2) DEFAULT NULL,
  `S_DISCOUNT` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(15,6) DEFAULT NULL,
  `PACK_RATE` decimal(10,4) DEFAULT NULL,
  `INCLUSIVE` decimal(10,2) DEFAULT NULL,
  `PO_LINEITEM` varchar(2) DEFAULT NULL,
  `BRAND_ID` varchar(4) DEFAULT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `UNIT_RATE_FC` decimal(13,5) DEFAULT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `BONUS_QTY` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_podet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product`;
CREATE TABLE `sl_product` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `O_QTY` decimal(10,3) DEFAULT NULL,
  `O_RATE` decimal(10,2) DEFAULT NULL,
  `CAT_ID` varchar(6) NOT NULL,
  `TYPE_ID` varchar(10) NOT NULL,
  `BATCHWISE` varchar(1) NOT NULL,
  `REG_NO` varchar(10) DEFAULT NULL,
  `PACK_SIZE` varchar(10) DEFAULT NULL,
  `ACTIVE` varchar(1) NOT NULL,
  `P_RATE` decimal(10,2) DEFAULT NULL,
  `TYPE_GRP` varchar(1) NOT NULL,
  `PACK_RATE` decimal(10,2) DEFAULT NULL,
  `AVG_RATE` decimal(10,3) NOT NULL,
  `ALL_CUST` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `GRP_ID` varchar(2) NOT NULL,
  `MOL_QTY` decimal(10,3) DEFAULT NULL,
  `MOL` varchar(1) DEFAULT NULL,
  `OLD_CODE` varchar(9) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PART_NO` varchar(30) DEFAULT NULL,
  `SAMPL_ID` varchar(4) DEFAULT NULL,
  `SAMPLE_ID` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_products_log`
-- ----------------------------
DROP TABLE IF EXISTS `sl_products_log`;
CREATE TABLE `sl_products_log` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `UNIT` varchar(10) NOT NULL,
  `UNIT_RATE` decimal(10,2) DEFAULT NULL,
  `STAXP` decimal(6,2) NOT NULL,
  `POST_DATE` datetime NOT NULL,
  PRIMARY KEY (`PROD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_products_log
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product_brand`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product_brand`;
CREATE TABLE `sl_product_brand` (
  `PROD_ID` varchar(4) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `PROD_NAME` varchar(50) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product_brand
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_product_rm`
-- ----------------------------
DROP TABLE IF EXISTS `sl_product_rm`;
CREATE TABLE `sl_product_rm` (
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(13,6) NOT NULL,
  `LINEITEM` decimal(4,0) NOT NULL,
  `RM_ID` varchar(4) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`PROD_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_product_rm
-- ----------------------------
INSERT INTO `sl_product_rm` VALUES ('0356', '0.000310', '1', '0027', '01');

-- ----------------------------
-- Table structure for `sl_quote`
-- ----------------------------
DROP TABLE IF EXISTS `sl_quote`;
CREATE TABLE `sl_quote` (
  `INV_ID` varchar(5) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `INV_AMT` decimal(10,2) NOT NULL,
  `ST_AMT` decimal(10,2) DEFAULT NULL,
  `DC_AMT` decimal(10,2) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PO_NO` varchar(30) DEFAULT NULL,
  `PO_DATE` datetime DEFAULT NULL,
  `DISC_AMT` decimal(10,2) DEFAULT NULL,
  `DO_NO` varchar(5) DEFAULT NULL,
  `DO_DATE` datetime DEFAULT NULL,
  `SIN_NO` varchar(11) DEFAULT NULL,
  `SIN_DATE` datetime DEFAULT NULL,
  `DC_NO` varchar(5) DEFAULT NULL,
  `DC_DATE` datetime DEFAULT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `DO_DESC` varchar(50) DEFAULT NULL,
  `SIN_DESC` varchar(50) DEFAULT NULL,
  `DC_DESC` varchar(50) DEFAULT NULL,
  `ADD_ID` decimal(4,0) DEFAULT NULL,
  `UT` varchar(1) DEFAULT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `DC_ACCT_ID` char(10) DEFAULT NULL,
  `VEH_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_quote
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_quotedet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_quotedet`;
CREATE TABLE `sl_quotedet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PACK_NO` decimal(10,3) NOT NULL,
  `PACK_QTY` decimal(10,3) NOT NULL,
  `UNIT_QTY` decimal(10,3) NOT NULL,
  `UNIT_RATE` decimal(10,3) NOT NULL,
  `STAXP` decimal(6,2) DEFAULT NULL,
  `STAX` decimal(10,0) DEFAULT NULL,
  `ADD_STAXP` decimal(6,2) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `PUR_ID` varchar(7) DEFAULT NULL,
  `SALE_ID` decimal(4,0) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_quotedet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receipt`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receipt`;
CREATE TABLE `sl_receipt` (
  `REC_ID` varchar(5) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `PRODUCTION` varchar(1) NOT NULL,
  `SORT_ORDER` decimal(2,0) DEFAULT NULL,
  `CUR_ID` varchar(2) DEFAULT NULL,
  `CUR_RATE` decimal(15,5) DEFAULT NULL,
  `CUR_DETAIL` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet`;
CREATE TABLE `sl_receiptdet` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `R_NO` varchar(10) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `R_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `AMOUNT` decimal(10,2) DEFAULT NULL,
  `INV_NO` varchar(5) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet_acct`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet_acct`;
CREATE TABLE `sl_receiptdet_acct` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `SER_NO` varchar(2) NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `AMOUNT` decimal(13,2) DEFAULT NULL,
  `MODE_ID` varchar(2) DEFAULT NULL,
  `CHQ_NO` varchar(20) DEFAULT NULL,
  `CHQ_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `ACCT_DATE` datetime DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `SLIP_NO` varchar(30) DEFAULT NULL,
  `WO_ID` varchar(5) DEFAULT NULL,
  `O_BAL` decimal(10,2) DEFAULT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `CLEAR_DATE` datetime DEFAULT NULL,
  `INHAND_ACCT_ID` char(10) DEFAULT NULL,
  `COLLECT_ACCT_ID` char(10) DEFAULT NULL,
  `BOUNCE_DATE` datetime DEFAULT NULL,
  `RETURN_DATE` datetime DEFAULT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `AMOUNT_FC` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`SER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet_acct
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_receiptdet_inv`
-- ----------------------------
DROP TABLE IF EXISTS `sl_receiptdet_inv`;
CREATE TABLE `sl_receiptdet_inv` (
  `REC_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `INV_ID` varchar(7) NOT NULL,
  `AMOUNT` decimal(10,2) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LINE_ITEM` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`REC_ID`,`LINEITEM`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_receiptdet_inv
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_return`
-- ----------------------------
DROP TABLE IF EXISTS `sl_return`;
CREATE TABLE `sl_return` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(5) DEFAULT '',
  `inv_no` varchar(10) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `veh_no` varchar(50) DEFAULT NULL,
  `driver` varchar(50) DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `sms_no` varchar(15) DEFAULT NULL,
  `particulars` varchar(100) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `to_comp_id` varchar(2) DEFAULT NULL,
  `posted` char(2) DEFAULT NULL,
  `post_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `bill_no` varchar(10) NOT NULL,
  `outlet_percentage` decimal(10,0) DEFAULT NULL,
  `outlet_invoice` decimal(10,0) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL,
  `net_amt` decimal(10,2) NOT NULL,
  `adv_amt` decimal(10,2) NOT NULL,
  `disc_amt` decimal(10,2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_sl_return` (`voucher_id`,`bill_no`,`comp_id`,`year_id`) USING BTREE,
  KEY `sl_return_fk_loc_id` (`loc_id`),
  KEY `sl_return_fk_acct_id` (`acct_id`),
  KEY `sl_return_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_return
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_returndet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_returndet`;
CREATE TABLE `sl_returndet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` int(4) NOT NULL DEFAULT '0',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(13,2) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `avg_rate` decimal(10,0) NOT NULL,
  `year_id` varchar(2) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_sl_returndet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`),
  KEY `sl_returndet_fk_stock_code` (`stock_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_returndet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_sa`
-- ----------------------------
DROP TABLE IF EXISTS `sl_sa`;
CREATE TABLE `sl_sa` (
  `SA_ID` varchar(5) NOT NULL,
  `SA_DATE` datetime NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_sa
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_sadet`
-- ----------------------------
DROP TABLE IF EXISTS `sl_sadet`;
CREATE TABLE `sl_sadet` (
  `SA_ID` varchar(5) NOT NULL,
  `LINEITEM` decimal(3,0) NOT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `ACCT_ID` char(10) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `AMOUNT` decimal(10,0) NOT NULL,
  `SP_ID` varchar(4) NOT NULL,
  `DIV_ID` varchar(2) NOT NULL,
  `CITY_ID` varchar(2) NOT NULL,
  `WO_ID` varchar(5) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`SA_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_sadet
-- ----------------------------

-- ----------------------------
-- Table structure for `sl_wo`
-- ----------------------------
DROP TABLE IF EXISTS `sl_wo`;
CREATE TABLE `sl_wo` (
  `WO_ID` varchar(5) NOT NULL,
  `WO_DATE` datetime NOT NULL,
  `PARTICULARS` varchar(100) DEFAULT NULL,
  `PARTY_ID` varchar(4) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `O_BAL` decimal(13,2) DEFAULT NULL,
  `WO_NAME` varchar(50) DEFAULT NULL,
  `DIV_ID` varchar(2) DEFAULT NULL,
  `CITY_ID` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`WO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sl_wo
-- ----------------------------

-- ----------------------------
-- Table structure for `sp`
-- ----------------------------
DROP TABLE IF EXISTS `sp`;
CREATE TABLE `sp` (
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `acct_name` varchar(100) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sp
-- ----------------------------
INSERT INTO `sp` VALUES ('0016', 'ALI SHAN', null, '01');
INSERT INTO `sp` VALUES ('0002', 'Umer', null, '06');
INSERT INTO `sp` VALUES ('0003', 'Awais', null, '06');
INSERT INTO `sp` VALUES ('0004', 'Mohsin', null, '05');
INSERT INTO `sp` VALUES ('0005', 'Sikandar', null, '05');
INSERT INTO `sp` VALUES ('0006', 'Sikandar', null, '08');
INSERT INTO `sp` VALUES ('0007', 'Faisal', null, '08');
INSERT INTO `sp` VALUES ('0008', 'Talha', null, '08');
INSERT INTO `sp` VALUES ('0009', 'Khurram', null, '07');
INSERT INTO `sp` VALUES ('0010', 'Victor', null, '07');
INSERT INTO `sp` VALUES ('0011', 'Usman', null, '02');
INSERT INTO `sp` VALUES ('0012', 'Mohsin', null, '12');
INSERT INTO `sp` VALUES ('0013', 'Faisal', null, '12');
INSERT INTO `sp` VALUES ('0014', 'Ali Raza', null, '05');
INSERT INTO `sp` VALUES ('0015', 'Victor', '', '13');
INSERT INTO `sp` VALUES ('0017', 'zeshan', null, null);

-- ----------------------------
-- Table structure for `sp_party`
-- ----------------------------
DROP TABLE IF EXISTS `sp_party`;
CREATE TABLE `sp_party` (
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `lineitem` varchar(4) NOT NULL DEFAULT '',
  `party_id` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`sp_id`,`party_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of sp_party
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_cat`
-- ----------------------------
DROP TABLE IF EXISTS `stk_cat`;
CREATE TABLE `stk_cat` (
  `cat_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_cat
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_collection`
-- ----------------------------
DROP TABLE IF EXISTS `stk_collection`;
CREATE TABLE `stk_collection` (
  `col_id` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_collection
-- ----------------------------
INSERT INTO `stk_collection` VALUES ('010101', 'Men');
INSERT INTO `stk_collection` VALUES ('010102', 'Gold');

-- ----------------------------
-- Table structure for `stk_con`
-- ----------------------------
DROP TABLE IF EXISTS `stk_con`;
CREATE TABLE `stk_con` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(7) NOT NULL DEFAULT '',
  `disc_amt` decimal(10,2) DEFAULT NULL,
  `dc_amt` decimal(10,2) DEFAULT NULL,
  `net_amt` decimal(13,2) DEFAULT NULL,
  `po_no` varchar(10) DEFAULT NULL,
  `po_date` date DEFAULT NULL,
  `dc_no` varchar(10) DEFAULT NULL,
  `dc_date` date DEFAULT NULL,
  `igp_no` varchar(10) DEFAULT NULL,
  `igp_date` date DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `bilty_no` varchar(30) DEFAULT NULL,
  `adda_name` varchar(30) DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ut` char(2) NOT NULL DEFAULT '',
  `sp_id` varchar(7) NOT NULL DEFAULT '',
  `po_id` varchar(10) NOT NULL DEFAULT '',
  `discp` decimal(6,3) DEFAULT NULL,
  `project` char(2) NOT NULL DEFAULT '',
  `service` char(2) NOT NULL DEFAULT '',
  `adv_amt` decimal(13,2) DEFAULT NULL,
  `brand_id` varchar(4) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `sms_no` varchar(15) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_phone` bigint(10) DEFAULT NULL,
  `customer_cash` decimal(10,0) DEFAULT NULL,
  `return_cash` decimal(10,0) DEFAULT NULL,
  `bill_type` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`bill_no`),
  KEY `index_con` (`voucher_id`,`bill_no`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_con
-- ----------------------------

-- ----------------------------
-- Table structure for `stk_condet`
-- ----------------------------
DROP TABLE IF EXISTS `stk_condet`;
CREATE TABLE `stk_condet` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `lineitem` varchar(6) NOT NULL DEFAULT '',
  `stock_code` varchar(13) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT '',
  `qty` decimal(13,3) DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `itemtot` decimal(13,2) DEFAULT NULL,
  `user_id` varchar(8) NOT NULL DEFAULT '',
  `gp_qty` decimal(13,2) DEFAULT NULL,
  `rej_qty` decimal(13,2) DEFAULT NULL,
  `staxp` tinyint(4) DEFAULT NULL,
  `short_qty` decimal(13,2) DEFAULT NULL,
  `avg_rate` decimal(13,3) DEFAULT NULL,
  `stax_rate` decimal(13,2) DEFAULT NULL,
  `stax` decimal(13,2) DEFAULT NULL,
  `sed` decimal(13,2) DEFAULT NULL,
  `sedp` decimal(6,3) DEFAULT NULL,
  `fedp` decimal(6,3) DEFAULT NULL,
  `fed` decimal(15,2) DEFAULT NULL,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `discp` decimal(6,3) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`,`lineitem`),
  KEY `index_condet` (`voucher_id`,`lineitem`,`comp_id`,`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of stk_condet
-- ----------------------------

-- ----------------------------
-- Table structure for `system`
-- ----------------------------
DROP TABLE IF EXISTS `system`;
CREATE TABLE `system` (
  `comp_name` varchar(100) NOT NULL DEFAULT '',
  `cash_id` varchar(10) NOT NULL DEFAULT '',
  `bank_id` varchar(10) NOT NULL DEFAULT '',
  `creditor_id` varchar(10) DEFAULT '1601999',
  `stax_id` varchar(10) DEFAULT '2201001',
  `dc_id` varchar(10) DEFAULT '5302005',
  `disc_id` varchar(10) DEFAULT '5107001',
  `debtor_id` varchar(10) DEFAULT '4201999',
  `adv_id` varchar(10) DEFAULT '4201999',
  `db_id` varchar(10) DEFAULT '4201999',
  `ret_id` varchar(10) DEFAULT '4201999',
  `sec_id` varchar(10) DEFAULT '4201999',
  `stax_id_sl` varchar(10) DEFAULT '2201001',
  `dc_id_sl` varchar(10) DEFAULT '5302005',
  `disc_id_sl` varchar(10) DEFAULT '5107001',
  `adv_id_sl` varchar(10) DEFAULT '4201999',
  `db_id_sl` varchar(10) DEFAULT '4201999',
  `ret_id_sl` varchar(10) DEFAULT '4201999',
  `sec_id_sl` varchar(10) DEFAULT '4201999',
  `stock_id` varchar(10) DEFAULT '4201999',
  `turnover_id` varchar(10) DEFAULT '3010000001',
  `cogs_id` varchar(10) DEFAULT '3020000001',
  `sed_id` varchar(10) DEFAULT NULL,
  `sed_id_sl` varchar(10) DEFAULT NULL,
  `hide_taxes` char(1) DEFAULT NULL,
  `date_from` date DEFAULT '2009-07-01',
  `date_to` date DEFAULT '2010-06-30',
  `ait_id` varchar(10) DEFAULT NULL,
  `cdi_id` varchar(10) DEFAULT NULL,
  `date_close` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) DEFAULT 'support@clicksoft.org',
  `qty_decimal` int(11) DEFAULT '0',
  `fed_id` varchar(10) DEFAULT NULL,
  `fed_id_sl` varchar(10) DEFAULT NULL,
  `stock_transfer_id` varchar(10) DEFAULT NULL,
  `login_page` varchar(30) DEFAULT NULL,
  `sale_form` varchar(30) DEFAULT 'kt_sale_invoice',
  `qty_decimals` int(1) DEFAULT '0',
  PRIMARY KEY (`comp_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of system
-- ----------------------------
INSERT INTO `system` VALUES ('KAFEEL GROUP', '261000', '261000', '131000', '3011000001', '5010000001', '2210000004', '261000', '1001001', '5010000001', '1001001', '1001001', '3011000001', '3020000010', '3020000002', '4201', '3020000010', '4201', '4201', '2210000001', '3010000001', '3020000001', '3011000005', '3011000005', '', '2011-07-01', '2012-06-30', '2530000002', '4060000005', '2017-08-27', 'accounts@rakcorporation.com,support@clicksoft.com.pk', '3', '3011000004', '3011000004', '2210000002', 'kt', 'kt_sale_invoice', '0');

-- ----------------------------
-- Table structure for `tf`
-- ----------------------------
DROP TABLE IF EXISTS `tf`;
CREATE TABLE `tf` (
  `INV_ID` varchar(5) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `INV_DATE` datetime NOT NULL,
  `PACK_SIZE` varchar(30) DEFAULT NULL,
  `PACK_QTY` decimal(10,2) DEFAULT NULL,
  `UNIT_QTY` decimal(10,2) DEFAULT NULL,
  `STD_WT` decimal(15,5) DEFAULT NULL,
  `UNIT_WT` decimal(15,5) DEFAULT NULL,
  `BATCH_MONTH` varchar(10) DEFAULT NULL,
  `EXP_DATE` datetime DEFAULT NULL,
  `INACTIVE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tf
-- ----------------------------
INSERT INTO `tf` VALUES ('00140', null, '0001', '', '', '', '2015-12-28 00:00:00', '1*1', '1.00', '222.00', '0.00000', null, null, null, null);

-- ----------------------------
-- Table structure for `tfdet`
-- ----------------------------
DROP TABLE IF EXISTS `tfdet`;
CREATE TABLE `tfdet` (
  `INV_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(3) NOT NULL,
  `EMP_ID` varchar(8) DEFAULT NULL,
  `PROD_ID` varchar(4) NOT NULL,
  `PROD_FAC` decimal(15,5) DEFAULT NULL,
  `POSTED` varchar(1) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `DONT_INCLUDE` varchar(1) NOT NULL,
  `PROCESS_ID` decimal(4,0) DEFAULT NULL,
  `LL_P` decimal(6,3) DEFAULT NULL,
  `LL_QTY` decimal(15,5) DEFAULT NULL,
  `QTY` decimal(15,5) DEFAULT NULL,
  `REQ_QTY` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`INV_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tfdet
-- ----------------------------
INSERT INTO `tfdet` VALUES ('00141', '1', null, '0', null, '', '', '', '', null, null, null, '0.00000', null);

-- ----------------------------
-- Table structure for `tmp_stk`
-- ----------------------------
DROP TABLE IF EXISTS `tmp_stk`;
CREATE TABLE `tmp_stk` (
  `loc_id` char(2) NOT NULL DEFAULT '',
  `comp_id` varchar(2) DEFAULT NULL,
  `year_id` varchar(2) NOT NULL DEFAULT '',
  `voucher_id` varchar(12) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `party_id` varchar(10) NOT NULL DEFAULT '',
  `party_name` varchar(50) DEFAULT NULL,
  `lineitem` varchar(6) DEFAULT NULL,
  `stock_code` varchar(13) DEFAULT NULL,
  `stock_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `rate` decimal(15,5) DEFAULT NULL,
  `db_qty` decimal(18,3) DEFAULT NULL,
  `db_amt` decimal(18,2) DEFAULT NULL,
  `cr_qty` decimal(18,3) DEFAULT NULL,
  `cr_amt` decimal(18,2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tmp_stk
-- ----------------------------
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '002', '0002', '16kg Olien Cane', '2005.59000', '2.000', '4011.17', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '003', '0004', 'Daal Channa Supreem', '4887.81000', '53.000', '259053.86', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '004', '0006', 'Daal Moong', '4331.45000', '3.000', '12994.36', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '005', '0007', 'Flour 20 Kg. Bag', '689.57000', '92.000', '63440.02', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '006', '0008', 'Flour 40 Kg. Bag', '1395.90000', '10.000', '13959.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '007', '0009', 'Flour 49 Kg Bag', '1673.04000', '18.000', '30114.68', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '008', '0010', 'Gur 40kg Bag', '2119.36000', '51.000', '108087.47', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '009', '0011', 'Sultan 10 Liter Oil Carton', '1486.57000', '69.000', '102573.53', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '010', '0012', 'Sultan 16 Kg Bucket', '2359.33000', '35.000', '82576.61', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '011', '0013', 'Sultan 16 Kg. Tin', '2280.57000', '152.000', '346646.08', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '012', '0014', 'Sultan 16 Liter Oil Tin', '2408.22000', '77.000', '185432.73', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '013', '0015', 'Sultan 5 Kg Can', '691.84000', '106.000', '73334.61', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '014', '0016', 'Khal 18 Kg', '757.99000', '44.000', '33351.34', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '015', '0017', 'Maida 40 Kg Bag', '1499.66000', '76.000', '113974.25', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '016', '0018', 'Maqbool 10kg Bucket', '1216.65000', '18.000', '21899.66', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '017', '0019', 'Maqbool 16kg Bucket', '1955.08000', '18.000', '35191.52', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '018', '0020', 'Maqbool 2.5kg Bucket', '319.47000', '89.000', '28432.84', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '019', '0021', 'Maqbool 5kg Bucket', '628.48000', '1.000', '628.48', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '020', '0022', 'Maqbool Cortan(1kg)', '1866.26000', '100.000', '186625.59', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '021', '0023', 'Maqbool Tin', '1876.32000', '70.000', '131342.60', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '022', '0024', 'Meezan 1 Liter Bottle Carton', '745.23000', '17.000', '12668.86', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '023', '0025', 'Meezan 10 Kg Bucket', '1457.79000', '6.000', '8746.75', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '024', '0026', 'Meezan 2.5 Kg Bucket', '344.00000', '2.000', '687.99', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '025', '0027', 'Millat 10 Kg Bucket', '1219.34000', '82.000', '99986.23', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '026', '0028', 'Millat 2.5 Kg Can', '286.75000', '111.000', '31829.65', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '027', '0029', 'Millat 5 Kg Bucket', '623.49000', '144.000', '89783.05', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '028', '0031', 'Millat Tin', '1734.41000', '57.000', '98861.19', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '029', '0032', 'Rahat 2.5 Kg Can', '293.36000', '178.000', '52218.06', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '030', '0033', 'Rahat 5 Kg Can', '597.15000', '206.000', '123013.86', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '031', '0034', 'Rahat Carton 1kg', '1885.93000', '792.000', '1493656.13', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '032', '0035', 'Rahat Carton 250 Gm P', '1916.87000', '299.000', '573143.96', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '033', '0036', 'Rahat Cortan 1/2 Kg', '1895.87000', '409.000', '775411.09', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '034', '0037', 'Rahat Tin', '1900.96000', '572.000', '1087351.33', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '035', '0038', 'Rahat Washing Powder 20 Rs(36pack)', '505.12000', '261.000', '131836.54', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '036', '0039', 'Rahat Washing Powder Rs 10', '513.10000', '134.000', '68755.03', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '16', 'ST080001', '2017-08-13', '0021', 'STOCK TRANSFER', '63', '0040', 'Rice 25 Kg Kanyt', '2505.16000', '0.000', '0.00', '31.000', '77659.96');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '037', '0042', 'Rice Ks82/25kg', '1102.40000', '25.000', '27559.98', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '038', '0043', 'Salt Bundle', '41.29000', '225.000', '9290.76', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '039', '0044', 'Sarso Oil 26 Kg', '3585.89000', '82.000', '294043.09', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '040', '0046', 'Sooji 50 Kg Bag', '1908.16000', '20.000', '38163.13', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '041', '0047', 'Starch Bag', '0.00000', '0.000', '0.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '042', '0048', 'Sugar Bag', '2686.00000', '494.000', '1326978.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '043', '0049', 'Sultan 10kg Ghee Cortan', '1431.00000', '214.000', '306219.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '044', '0050', 'Maqbool Cortan(1/4kg)', '1922.00000', '13.000', '24987.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '045', '0052', 'Meezan 5 Ltr Bottal', '516.00000', '3.000', '1549.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '046', '0054', 'Rice 25 Kg IRRI 9', '1360.00000', '109.000', '148254.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '047', '0055', 'Sultan 10 Kg Bucket', '1425.00000', '29.000', '41323.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '048', '0056', 'Maqbool Cortan(1/2kg)', '1865.00000', '24.000', '44764.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '049', '0057', 'Rahat 100 Gram', '799.00000', '91.000', '72680.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '050', '0058', 'Meezan 3 Ltr Bottal', '419.00000', '7.000', '2936.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '051', '0059', 'Chashm Soap 13 Kg', '619.00000', '12.000', '7432.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '052', '0060', 'Saleem Dish Wash Bar', '291.00000', '16.000', '4655.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '053', '0062', 'Khal 10 Kg Bag', '433.00000', '64.000', '27713.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '16', 'ST080001', '2017-08-13', '0021', 'STOCK TRANSFER', '14', '0063', 'Meezan 5 Liter Bottle', '750.00000', '0.000', '0.00', '1.000', '750.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '054', '0064', null, '577.00000', '15.000', '8649.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '055', '0065', 'Latif 12 Liter Oil Carton', '1416.00000', '326.000', '461532.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '056', '0067', 'Meezan 3 Liter Bottle Carton', '2721.00000', '34.000', '92524.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '057', '0068', 'sultan 1000 ML sarso', '1573.00000', '1.000', '1573.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '058', '0069', 'Sultan 5 Liter Dispenser', '730.00000', '155.000', '113227.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '059', '0070', 'Meezan 5 Litre Dispenser', '699.00000', '17.000', '11876.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '060', '0071', 'Maida 80 Kg. Bag', '3083.00000', '12.000', '37001.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '061', '0072', 'Latif 16 Kg Tin', '2169.00000', '628.000', '1362230.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '062', '0074', 'Shopper 25 Kg', '5206.00000', '27.000', '140551.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '063', '0076', 'Millat Carton', '1732.00000', '23.000', '39828.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '064', '0077', 'Sultan 3 Litre Bottle Carton', '1783.00000', '25.000', '44563.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '065', '0078', 'Match Rs 2 Hook', '722.00000', '92.000', '66400.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '066', '0079', 'Meezan 5 Kg. Can', '700.00000', '9.000', '6297.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '067', '0080', 'Khal 40 Kg Bag', '1677.00000', '52.000', '87204.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '068', '0081', 'Millat 16 Kg Bucket', '1939.00000', '75.000', '145403.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '069', '0082', 'Sultan 5 Liter Bottle Carton', '1491.00000', '13.000', '19389.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '070', '0083', 'Rice 50 Kg Bag', '5444.00000', '5.000', '27221.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '071', '0084', 'Latif 16 Ltr Oil Tin', '2328.00000', '43.000', '100108.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '072', '0085', 'Rice Rahat 25 Kg Kainat', '2446.00000', '878.000', '2147710.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '073', '0086', 'Chashma Soap 10 Kg.', '568.00000', '50.000', '28393.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '074', '0087', 'Rahat Rice 50 Kg Super Karnala', '3784.00000', '67.000', '253501.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '075', '0091', 'Rice Rahat 25 Kg Super Karnal', '2052.00000', '94.000', '192919.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '16', 'ST080001', '2017-08-13', '0021', 'STOCK TRANSFER', '50', '0092', 'Chola 25 Kg 9mm', '3435.24000', '0.000', '0.00', '1.000', '3435.24');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '076', '0093', 'Rahat 16 Ltr Oil Tin', '2168.00000', '24.000', '52026.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '077', '0094', 'Chokar 30kg', '774.00000', '11.000', '8509.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '078', '0096', 'Sultan 5 Kg Bucket', '720.00000', '60.000', '43189.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '079', '0097', 'Rice 50 Kg. KS-82', '2190.00000', '44.000', '96380.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '080', '0098', 'Millat 2.5 Kg Bucket', '321.00000', '30.000', '9644.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '081', '0099', 'China Salt', '3992.00000', '4.000', '15970.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '082', '0101', 'Meezan 5 Kg Bucket', '684.00000', '6.000', '4101.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '083', '0102', 'Chokar 10 Kg Bag', '233.00000', '4.000', '933.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '084', '0104', 'Meezan 16 Liter Oil Tin', '2295.00000', '9.000', '20655.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '085', '0105', 'Rahat 10kg Bucket', '1274.00000', '11.000', '14010.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '086', '0109', 'Meezan 10 Liter Oil', '1414.00000', '38.000', '53736.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '087', '0110', 'Rahat 16 Kg Bucket', '2043.00000', '3.000', '6128.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '088', '0111', '17 KG SOAP', '802.00000', '7.000', '5617.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '089', '0116', 'Bath Soap(Rs20 )', '1086.00000', '21.000', '22800.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '090', '0117', 'Both Soap 48 Piece', '1629.00000', '16.000', '26057.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '091', '0118', 'Can Empty', '257.00000', '215.000', '55279.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '092', '0124', 'Chokar 15 Kg Bag', '409.00000', '32.000', '13076.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '093', '0125', 'Cholaa 25 Kg Bag', '2359.00000', '12.000', '28311.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '094', '0126', 'Cholaa 50 Kg Bag', '5902.00000', '25.000', '147545.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '095', '0129', 'Coca Cola 1.5 Ltr', '80.00000', '35.000', '2800.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '096', '0132', 'Daal Mong Halki', '5065.00000', '5.000', '25327.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '097', '0133', 'DAL CHANA HALKI', '5000.00000', '8.000', '40000.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '098', '0139', 'Empty 16kg Cane', '211.00000', '2.000', '422.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '099', '0159', 'sultan 2.5 Kg Bucket', '369.00000', '67.000', '24750.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '100', '0160', 'sultan 2.5 Kg Can', '358.00000', '48.000', '17177.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '101', '0162', 'Kachi Basmati Rice25 Kg', '2206.00000', '4.000', '8822.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '102', '0168', 'Maqbool 2.5kg Tin', '282.00000', '33.000', '9294.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '103', '0171', 'MEEZA 10LTR CANE', '1499.00000', '29.000', '43457.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '104', '0173', 'Meezan 16 Kg Tin', '2193.00000', '84.000', '184200.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '105', '0174', 'Meezan 2.5 Kg Can', '363.00000', '24.000', '8709.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '106', '0176', 'Milk 25 Kg USA', '8788.00000', '47.000', '413053.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '107', '0179', 'Olein Can 25 Kg', '2918.00000', '105.000', '306355.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'ST080003', '2017-08-13', '0021', 'STOCK TRANSFER', '5', '0180', 'Olein Oil Drum', '3037.00000', '0.000', '0.00', '83.000', '252079.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '108', '0185', 'RAHAT 2.5KG BUCKETS', '347.00000', '42.000', '14580.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '109', '0186', 'Rahat 5 Ltr Dispencer', '653.00000', '8.000', '5226.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '110', '0187', 'Rahat Washing Powder 1 Kg', '689.00000', '1.000', '689.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '16', 'ST080001', '2017-08-13', '0021', 'STOCK TRANSFER', '10', '0199', 'Starch 25kg Bag', '3294.33000', '0.000', '0.00', '1.000', '3294.33');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '111', '0203', 'Wanda Bag 40 Kg', '911.00000', '3.000', '2733.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '112', '0209', '1 LTR OIL BOTTAL', '212.00000', '2.000', '424.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '113', '0210', 'Basin 40 Kg', '3850.00000', '6.000', '23100.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '114', '0211', 'Chola 8mm 50 Kg', '6702.00000', '24.000', '160854.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '115', '0212', 'Chola 9mm 50 Kg', '8732.00000', '8.000', '69854.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '116', '0213', 'DAAL MASH 25 KG', '3160.00000', '20.000', '63207.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '117', '0214', 'Daal Matri', '2215.00000', '14.000', '31015.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '118', '0215', 'Daal Mong 25 Kg', '1858.00000', '85.000', '157908.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '119', '0217', 'Kashmir 10 Ltr Cane', '1613.00000', '14.000', '22588.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '120', '0218', 'Kashmir 12 Ltr Cortan', '1932.00000', '135.000', '260794.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '121', '0219', 'Kashmir Bottle 3 Ltr Cortan', '3053.00000', '8.000', '24425.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '122', '0221', 'Kashmir Bucket 10 Kg', '1622.00000', '22.000', '35691.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '123', '0222', 'Kashmir Bucket 2.5 Kg', '413.00000', '39.000', '16126.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '124', '0223', 'Kashmir Bucket 5 Kg', '821.00000', '38.000', '31180.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '125', '0224', 'Kashmir Dispenser Ghee 5kg', '803.00000', '118.000', '94807.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '126', '0225', 'Kashmir Dispenser Oil 5ltr', '812.00000', '160.000', '129982.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '127', '0226', 'Kashmir Ghee 16kg Tin', '2563.00000', '9.000', '23067.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '128', '0227', 'Latif 16kg Cortan', '2156.00000', '104.000', '224207.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '129', '0228', 'Latif 5 Kg Tin', '689.00000', '36.000', '24792.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '130', '0229', 'Latif 5 Ltr Tin', '726.00000', '144.000', '104510.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '131', '0230', 'Lobia 25 Kg B', '3259.00000', '15.000', '48885.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '132', '0231', 'Rice 25 Kg Kaiynat Multan', '2187.00000', '33.000', '72163.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '16', 'ST080001', '2017-08-13', '0021', 'STOCK TRANSFER', '47', '0233', null, '3062.30000', '0.000', '0.00', '58.000', '177613.40');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '16', 'ST080001', '2017-08-13', '0021', 'STOCK TRANSFER', '38', '0234', 'Millat 5kg Cane', '570.31000', '0.000', '0.00', '67.000', '38210.77');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '133', '0235', 'Achar 5kg Bucket', '210.00000', '2.000', '420.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '134', '0236', 'Chola 25 Kg 933', '4200.00000', '1.000', '4200.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '135', '0237', null, '3062.00000', '58.000', '177613.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '136', '0238', 'Daal Masoor 25 Kg', '1475.00000', '62.000', '91430.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '137', '0239', 'Hifazat Both Soap', '2081.00000', '28.000', '58265.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '138', '0240', 'Match RS 1', '380.00000', '1.000', '380.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '139', '0241', null, '576.00000', '182.000', '104795.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '140', '0242', 'Soda 25 kg Bag', '1160.00000', '18.000', '20880.00', '0.000', '0.00');
INSERT INTO `tmp_stk` VALUES ('01', 'KT', '17', 'PL080001', '2017-08-13', '9000010001', 'OPENING BALANCES', '141', '0243', 'Tea 190 Grm Pack', '85.00000', '1.000', '85.00', '0.000', '0.00');

-- ----------------------------
-- Table structure for `trans`
-- ----------------------------
DROP TABLE IF EXISTS `trans`;
CREATE TABLE `trans` (
  `P_ID` varchar(5) NOT NULL,
  `P_DATE` datetime NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `EMP_ID` varchar(8) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `POSTED` varchar(1) NOT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of trans
-- ----------------------------
INSERT INTO `trans` VALUES ('00001', '2015-08-08 00:00:00', '01', '15', 'inam', '01', 'N', null);

-- ----------------------------
-- Table structure for `transdet`
-- ----------------------------
DROP TABLE IF EXISTS `transdet`;
CREATE TABLE `transdet` (
  `P_ID` varchar(5) NOT NULL,
  `LINEITEM` varchar(2) NOT NULL,
  `PROD_ID` varchar(9) NOT NULL,
  `QTY` decimal(13,3) DEFAULT NULL,
  `RATE` decimal(13,6) DEFAULT NULL,
  `PARTICULARS` varchar(30) DEFAULT NULL,
  `ITEMTOT` decimal(13,2) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `LOC_ID` varchar(2) NOT NULL,
  `BATCH_NO` varchar(30) DEFAULT NULL,
  `REMARKS` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`P_ID`,`LINEITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of transdet
-- ----------------------------
INSERT INTO `transdet` VALUES ('00001', '1', '0394', '332.000', null, '15D523', null, '01', '15', '02', null, 'Nearest Exipry Date 30-09-15');

-- ----------------------------
-- Table structure for `tt`
-- ----------------------------
DROP TABLE IF EXISTS `tt`;
CREATE TABLE `tt` (
  `v_id` int(11) NOT NULL AUTO_INCREMENT,
  `v_date` date DEFAULT NULL,
  `comp_id` varchar(2) DEFAULT NULL,
  `comp_name` varchar(100) DEFAULT NULL,
  `debit_amount` int(15) DEFAULT NULL,
  `credit_amount` int(15) DEFAULT NULL,
  `ref_no` varchar(250) DEFAULT NULL,
  `acct_type` varchar(250) DEFAULT NULL,
  `remarks` text,
  `opening_balance` int(15) DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tt
-- ----------------------------

-- ----------------------------
-- Table structure for `type`
-- ----------------------------
DROP TABLE IF EXISTS `type`;
CREATE TABLE `type` (
  `type_id` varchar(6) NOT NULL DEFAULT '',
  `type_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of type
-- ----------------------------
INSERT INTO `type` VALUES ('0002', 'KHUSSA');
INSERT INTO `type` VALUES ('0003', 'SEMI FORMAL');
INSERT INTO `type` VALUES ('0004', 'FORMAL');
INSERT INTO `type` VALUES ('0005', 'CASUAL');

-- ----------------------------
-- Table structure for `units`
-- ----------------------------
DROP TABLE IF EXISTS `units`;
CREATE TABLE `units` (
  `unit` char(3) NOT NULL DEFAULT '',
  `unit_name` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of units
-- ----------------------------
INSERT INTO `units` VALUES ('Bag', 'Bags');
INSERT INTO `units` VALUES ('Bot', 'Bottle');
INSERT INTO `units` VALUES ('Bun', 'Bundle');
INSERT INTO `units` VALUES ('Coi', 'Coil');
INSERT INTO `units` VALUES ('Dru', 'Drum');
INSERT INTO `units` VALUES ('Dzn', 'Dzn');
INSERT INTO `units` VALUES ('Ft', 'Ft');
INSERT INTO `units` VALUES ('Gln', 'Gln');
INSERT INTO `units` VALUES ('Grm', 'Grams');
INSERT INTO `units` VALUES ('Kg', 'Kg');
INSERT INTO `units` VALUES ('Ltr', 'Liter');
INSERT INTO `units` VALUES ('Mtr', 'Mtr');
INSERT INTO `units` VALUES ('Nos', 'Nos');
INSERT INTO `units` VALUES ('Pai', 'Pairs');
INSERT INTO `units` VALUES ('Pcs', 'Pices');
INSERT INTO `units` VALUES ('Pkt', 'Pkt');
INSERT INTO `units` VALUES ('Qtr', 'Qtr');
INSERT INTO `units` VALUES ('Rft', 'Rft');
INSERT INTO `units` VALUES ('Rim', 'Rim');
INSERT INTO `units` VALUES ('Rol', 'Roll');
INSERT INTO `units` VALUES ('Set', 'Set');
INSERT INTO `units` VALUES ('Sqf', 'Sqft');
INSERT INTO `units` VALUES ('Tin', 'Tin');
INSERT INTO `units` VALUES ('Tro', 'Trolly');
INSERT INTO `units` VALUES ('Tru', 'Truck');
INSERT INTO `units` VALUES ('MT', 'M.Tons');
INSERT INTO `units` VALUES ('100', 'baggage');
INSERT INTO `units` VALUES ('Guz', 'GUZZ');

-- ----------------------------
-- Table structure for `users`
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `EMP_ID` varchar(20) NOT NULL,
  `EMP_NAME` varchar(40) NOT NULL,
  `PASSWORD` varchar(20) DEFAULT NULL,
  `AUTH_ID` varchar(1) NOT NULL,
  `USE_FORM` varchar(1) DEFAULT NULL,
  `USE_REP` varchar(1) DEFAULT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) DEFAULT NULL,
  `YEAR_ID` varchar(2) DEFAULT NULL,
  `DATE_FROM` datetime DEFAULT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `PK_BILL_NO_FROM` varchar(4) DEFAULT NULL,
  `PK_BILL_NO_TO` varchar(4) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `VOUCHER_TYPE` varchar(2) DEFAULT NULL,
  `POST` varchar(1) NOT NULL,
  `SP_ID` varchar(4) DEFAULT NULL,
  `u_session_id` decimal(65,30) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('ag', 'AG Malik', '123', '', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);
INSERT INTO `users` VALUES ('bt', 'BT', '123', '1', 'Y', 'Y', 'N', '01', '04', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '', '', '', '', 'N', '0007', '0.000000000000000000000000000000');
INSERT INTO `users` VALUES ('click', 'ClickSoft (Pvt) Ltd', '124', '9', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);
INSERT INTO `users` VALUES ('irfan', 'Irfan', '123', '', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);
INSERT INTO `users` VALUES ('it', 'IT', '123', '1', 'Y', 'Y', 'N', '01', '04', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '', '', '', '', 'N', '0007', '0.000000000000000000000000000000');
INSERT INTO `users` VALUES ('kafeel', 'Kafeel Ahmad', '123', '', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);
INSERT INTO `users` VALUES ('kt', 'Kafeel Trader', '123', '9', 'Y', 'Y', 'N', '01', '04', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '', '', '', '', 'N', '0007', '0.000000000000000000000000000000');
INSERT INTO `users` VALUES ('mattiullah', 'Mattiullah', '123', '', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);
INSERT INTO `users` VALUES ('sanaullah', 'Sanaullah', '123', '', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);
INSERT INTO `users` VALUES ('zeeshan', 'Zeeshan', '123', '', null, null, null, null, null, null, null, null, null, null, null, null, null, '', null, null);

-- ----------------------------
-- Table structure for `users_comp`
-- ----------------------------
DROP TABLE IF EXISTS `users_comp`;
CREATE TABLE `users_comp` (
  `EMP_ID` varchar(20) NOT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `LOGGED` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`EMP_ID`,`COMP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_comp
-- ----------------------------
INSERT INTO `users_comp` VALUES ('click', 'TT', null);
INSERT INTO `users_comp` VALUES ('kt', 'TT', null);

-- ----------------------------
-- Table structure for `users_menu`
-- ----------------------------
DROP TABLE IF EXISTS `users_menu`;
CREATE TABLE `users_menu` (
  `emp_id` varchar(20) NOT NULL DEFAULT '',
  `menu_id` varchar(20) NOT NULL DEFAULT '',
  `inactive` char(2) NOT NULL DEFAULT '',
  `insert_allowed` char(1) NOT NULL DEFAULT 'N',
  `update_allowed` char(1) NOT NULL DEFAULT 'N',
  `delete_allowed` char(1) NOT NULL DEFAULT 'N'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_menu
-- ----------------------------
INSERT INTO `users_menu` VALUES ('kt', '1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.4', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '1.7', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2.4', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '2.5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '3.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '3.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '4', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '4.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '4.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5.4', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5.5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '5.6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.4', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '6.7', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.4', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.5', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.6', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '7.7', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '8', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '8.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '8.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '9', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '9.1', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '9.2', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('kt', '9.3', 'N', 'N', 'N', 'N');
INSERT INTO `users_menu` VALUES ('click', '1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '1.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '2.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '3.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '4.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '5.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '6.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.3', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.4', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.5', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.6', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '7.7', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '8.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.1', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.2', 'N', 'Y', 'Y', 'Y');
INSERT INTO `users_menu` VALUES ('click', '9.3', 'N', 'Y', 'Y', 'Y');

-- ----------------------------
-- Table structure for `users_mod`
-- ----------------------------
DROP TABLE IF EXISTS `users_mod`;
CREATE TABLE `users_mod` (
  `EMP_ID` varchar(6) NOT NULL,
  `VOUCHER_TYPE` varchar(20) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`VOUCHER_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_mod
-- ----------------------------
INSERT INTO `users_mod` VALUES ('Abid', 'PL_INVOICE');

-- ----------------------------
-- Table structure for `users_rep`
-- ----------------------------
DROP TABLE IF EXISTS `users_rep`;
CREATE TABLE `users_rep` (
  `EMP_ID` varchar(6) NOT NULL,
  `REP_ID` varchar(3) NOT NULL,
  PRIMARY KEY (`EMP_ID`,`REP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of users_rep
-- ----------------------------
INSERT INTO `users_rep` VALUES ('abid', '068');

-- ----------------------------
-- Table structure for `user_mod`
-- ----------------------------
DROP TABLE IF EXISTS `user_mod`;
CREATE TABLE `user_mod` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_CP',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_mod
-- ----------------------------

-- ----------------------------
-- Table structure for `user_profile`
-- ----------------------------
DROP TABLE IF EXISTS `user_profile`;
CREATE TABLE `user_profile` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `user_name` varchar(50) DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '123',
  `desig_id` varchar(30) DEFAULT '',
  `div_name` varchar(30) DEFAULT '',
  `sec_lvl` char(1) DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_profile
-- ----------------------------
INSERT INTO `user_profile` VALUES ('HEAD OFFICE', 'HEAD OFFICE', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('02-admin', 'EQUATOR', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('03-admin', 'Wapda Town', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('04-admin', 'Studio Mir - Gujranwala', '123', '', '', '0');
INSERT INTO `user_profile` VALUES ('05-admin', 'Dreams - M.M.Alam', '123', '', '', '0');

-- ----------------------------
-- Table structure for `user_rep`
-- ----------------------------
DROP TABLE IF EXISTS `user_rep`;
CREATE TABLE `user_rep` (
  `user_id` varchar(20) NOT NULL DEFAULT '',
  `acct_id` varchar(10) NOT NULL DEFAULT 'AC_10',
  PRIMARY KEY (`user_id`,`acct_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_rep
-- ----------------------------

-- ----------------------------
-- Table structure for `vehicle_type`
-- ----------------------------
DROP TABLE IF EXISTS `vehicle_type`;
CREATE TABLE `vehicle_type` (
  `vehicle_id` varchar(4) NOT NULL,
  `vehicle_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`vehicle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of vehicle_type
-- ----------------------------
INSERT INTO `vehicle_type` VALUES ('0001', 'MAZDA');
INSERT INTO `vehicle_type` VALUES ('0002', 'PICK UP');

-- ----------------------------
-- Table structure for `voucher`
-- ----------------------------
DROP TABLE IF EXISTS `voucher`;
CREATE TABLE `voucher` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `VOUCHER_DATE` date DEFAULT NULL,
  `POST_DATE` datetime DEFAULT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `POSTED` char(2) DEFAULT NULL,
  `JV_NO` varchar(4) DEFAULT NULL,
  `EXPENSE` varchar(1) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `CHQ_NO` varchar(30) DEFAULT NULL,
  `UPD_DATE` datetime DEFAULT NULL,
  `UPD_EMP_ID` varchar(8) DEFAULT NULL,
  `ACCT_ID_CS_1` char(10) DEFAULT NULL,
  `ACCT_ID_CS_2` char(10) DEFAULT NULL,
  `BILTY_NO` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`),
  KEY `voucher_copy_ibfk_2` (`YEAR_ID`),
  KEY `VOUCHER_ID` (`VOUCHER_ID`,`COMP_ID`,`YEAR_ID`),
  CONSTRAINT `voucher_copy_ibfk_1` FOREIGN KEY (`COMP_ID`) REFERENCES `company` (`COMP_ID`),
  CONSTRAINT `voucher_copy_ibfk_2` FOREIGN KEY (`YEAR_ID`) REFERENCES `fin_years` (`year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucher
-- ----------------------------
INSERT INTO `voucher` VALUES ('JV070001', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('JV4', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, '', null, null);
INSERT INTO `voucher` VALUES ('PL090001', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090002', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090003', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090004', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090005', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090006', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090007', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090008', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);
INSERT INTO `voucher` VALUES ('PL090009', '2017-09-16', null, null, null, null, 'on', null, null, 'TT', '17', null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `voucherdet`
-- ----------------------------
DROP TABLE IF EXISTS `voucherdet`;
CREATE TABLE `voucherdet` (
  `VOUCHER_ID` varchar(13) NOT NULL,
  `LINEITEM` varchar(6) NOT NULL,
  `ACCT_ID` char(10) DEFAULT NULL,
  `PARTICULARS` varchar(200) DEFAULT NULL,
  `debit` decimal(20,2) DEFAULT NULL,
  `credit` decimal(20,2) DEFAULT NULL,
  `EMP_ID` varchar(20) DEFAULT NULL,
  `EXP_ID` varchar(7) DEFAULT NULL,
  `SP_EXP_ID` char(10) DEFAULT NULL,
  `COMP_ID` varchar(2) NOT NULL,
  `YEAR_ID` varchar(2) NOT NULL,
  `ACCT_ID_CS` char(10) DEFAULT NULL,
  `CHASIS_NO` varchar(50) DEFAULT NULL,
  `V_NO` varchar(10) DEFAULT NULL,
  `USD` varchar(1) DEFAULT NULL,
  `ER` decimal(65,30) DEFAULT NULL,
  `UNIT_RATE` decimal(65,30) DEFAULT NULL,
  `TT_NO` varchar(30) DEFAULT NULL,
  `REG_NO` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`COMP_ID`,`YEAR_ID`,`VOUCHER_ID`,`LINEITEM`),
  KEY `voucherdet_copy_ibfk_1` (`ACCT_ID`),
  KEY `voucherdet_copy_ibfk_2` (`VOUCHER_ID`,`COMP_ID`,`YEAR_ID`),
  CONSTRAINT `voucherdet_copy_ibfk_1` FOREIGN KEY (`ACCT_ID`) REFERENCES `nom` (`ACCT_ID`),
  CONSTRAINT `voucherdet_copy_ibfk_2` FOREIGN KEY (`VOUCHER_ID`, `COMP_ID`, `YEAR_ID`) REFERENCES `voucher` (`VOUCHER_ID`, `COMP_ID`, `YEAR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucherdet
-- ----------------------------
INSERT INTO `voucherdet` VALUES ('JV070001', '0002', '2610000001', null, '0.00', '2650400.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0003', '2610000002', null, '1599200.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0004', '2610000003', null, '31000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0005', '2610000004', null, '80.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0006', '2610000005', null, '0.00', '3000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0007', '2610000006', null, '4912047.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0008', '2610000007', null, '1200.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0009', '2610000008', null, '0.00', '2000000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0010', '2610000009', null, '4954874.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0011', '2610000010', null, '0.00', '20705851.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0012', '2610000011', null, '0.00', '0.40', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0013', '2610000012', null, '220200.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0014', '2610000013', null, '0.00', '891151.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0015', '2610000014', null, '0.00', '875790.50', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0016', '2610000015', null, '25943374.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0017', '2610000016', null, '115350.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0018', '2610000017', null, '4564.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0019', '2610000018', null, '0.00', '30450000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0020', '2610000019', null, '3657600.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0021', '2610000020', null, '0.00', '614400.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0022', '2610000021', null, '0.00', '747600.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0023', '2610000022', null, '3000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0024', '2610000023', null, '612000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0025', '2610000024', null, '0.00', '265000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0026', '2610000025', null, '0.00', '700.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0027', '2610000026', null, '0.00', '6108000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0028', '2610000027', null, '0.00', '1690000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0029', '2610000028', null, '0.00', '916000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0030', '2610000029', null, '0.00', '265000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0031', '2610000030', null, '100000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0032', '2610000031', null, '105949.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0033', '2610000032', null, '0.00', '307200.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0034', '2610000033', null, '0.00', '3060000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0035', '2610000034', null, '4060.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0036', '2610000035', null, '0.00', '6500000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0037', '2610000036', null, '0.00', '148950.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0038', '2610000037', null, '14730.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0039', '2610000038', null, '0.00', '1402800.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0040', '2610000039', null, '10256411.50', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0041', '2610000040', null, '0.00', '1258000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0042', '2610000041', null, '609400.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0043', '2610000042', null, '16563355.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0044', '2610000043', null, '199530.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0045', '2610000044', null, '614400.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0046', '2610000045', null, '0.00', '96147.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0047', '2610000046', null, '0.00', '4355629.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0048', '2610000047', null, '199.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0049', '2610000048', null, '591600.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0050', '2610000049', null, '617000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0051', '2610000050', null, '0.00', '1950000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0052', '2610000051', null, '0.00', '66400.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0053', '2610000052', null, '1971000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0054', '2610000053', null, '0.00', '1496400.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0055', '2610000054', null, '26316646.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0056', '2610000055', null, '719040.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0057', '2610000056', null, '0.00', '1000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0058', '2610000057', null, '0.00', '2800000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0059', '2610000058', null, '4033600.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0060', '2610000059', null, '833526.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0061', '2610000060', null, '1527787.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0062', '2610000061', null, '200000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0063', '2610000062', null, '10200.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0064', '2610000063', null, '88000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0065', '2610000064', null, '271604.50', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0066', '2610000065', null, '140.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0067', '2610000066', null, '0.00', '600.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0068', '2610000067', null, '200000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0069', '2610000068', null, '0.00', '160000.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0070', '2610000069', null, '470.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0071', '2610000070', null, '0.00', '403500.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0072', '2610000071', null, '0.00', '673200.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0073', '2610000072', null, '2950.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0074', '2610000073', null, '0.00', '40432.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0075', '2610000074', null, '0.00', '4873785.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0076', '2610000075', null, '0.00', '849174.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0077', '2610000076', null, '0.00', '92233.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV070001', '0078', '2610000077', null, '500000.00', '0.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '1', '2720000001', 'Opening Balance', '633143.00', '0.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '2', '2720000002', 'Opening Balance', '34968.00', '0.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '3', '2720000003', 'Opening Balance', '83217.00', '0.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '4', '2720000004', 'Opening Balance', '183930.00', '0.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '5', '2720000005', 'Opening Balance', '1741979.00', '0.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '6', '2720000006', 'Opening Balance', '99735.00', '0.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('JV4', '7', '0100100001', 'Bank Balances', '0.00', '2776972.00', null, null, null, 'TT', '17', null, null, '', null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090001', '1', '2210000001', 'Gulf Sugar', '27040216.00', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090001', '2', '1310000001', 'Bill#090001', null, '27040216.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090002', '1', '2210000001', 'Chashma', '6474925.80', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090002', '2', '1310000002', 'Bill#090002', null, '6474925.80', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090003', '1', '2210000001', 'Malik Faizan Guds', '6474925.80', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090003', '2', '1310000003', 'Bill#090003', null, '6474925.80', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090004', '1', '2210000001', 'Chashma 2', '2510665.00', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090004', '2', '1310000004', 'Bill#090004', null, '2510665.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090005', '1', '2210000001', 'Malik Faizan Guds', '2510665.00', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090005', '2', '1310000003', 'Bill#090005', null, '2510665.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090006', '1', '2210000001', 'Jdw Sugar', '8795969.60', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090006', '2', '1310000005', 'Bill#090006', null, '8795969.60', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090007', '1', '2210000001', 'Roktak Hasar', '8795969.60', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090007', '2', '1310000006', 'Bill#090007', null, '8795969.60', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090008', '1', '2210000001', 'Miran Sugar', '6708900.00', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090008', '2', '1310000007', 'Bill#090008', null, '6708900.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090009', '1', '2210000001', 'Sarhad Guds', '6708900.00', null, null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);
INSERT INTO `voucherdet` VALUES ('PL090009', '2', '1310000008', 'Bill#090009', null, '6708900.00', null, null, null, 'TT', '17', null, null, null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `voucher_id`
-- ----------------------------
DROP TABLE IF EXISTS `voucher_id`;
CREATE TABLE `voucher_id` (
  `v_id` int(11) NOT NULL DEFAULT '0',
  `v_type` varchar(2) NOT NULL DEFAULT '',
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`comp_id`,`v_type`,`v_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of voucher_id
-- ----------------------------
INSERT INTO `voucher_id` VALUES ('1', 'CP', '');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '');
INSERT INTO `voucher_id` VALUES ('3', 'CP', '');
INSERT INTO `voucher_id` VALUES ('1', 'JV', '');
INSERT INTO `voucher_id` VALUES ('1', 'SL', '');
INSERT INTO `voucher_id` VALUES ('1', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('2', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('3', 'CP', '01');
INSERT INTO `voucher_id` VALUES ('1', 'BR', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'CP', 'BT');
INSERT INTO `voucher_id` VALUES ('2', 'CP', 'BT');
INSERT INTO `voucher_id` VALUES ('3', 'CP', 'BT');
INSERT INTO `voucher_id` VALUES ('4', 'CP', 'BT');
INSERT INTO `voucher_id` VALUES ('5', 'CP', 'BT');
INSERT INTO `voucher_id` VALUES ('6', 'CP', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'CR', 'BT');
INSERT INTO `voucher_id` VALUES ('2', 'CR', 'BT');
INSERT INTO `voucher_id` VALUES ('3', 'CR', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'JV', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('4', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('5', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('6', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('7', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('8', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('9', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('10', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('11', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('12', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('13', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('14', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('15', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('16', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('17', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('18', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('19', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('20', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('21', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('22', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('23', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('24', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('25', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('26', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('27', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('28', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('29', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('30', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('31', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('32', 'PL', 'BT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('3', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('4', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('5', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('6', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('7', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('8', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('9', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('10', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('11', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('12', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('13', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('14', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('15', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('16', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('17', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('18', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('19', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('20', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('21', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('22', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('23', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('24', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('25', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('26', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('27', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('28', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('29', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('30', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('31', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('32', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('33', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('34', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('35', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('36', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('37', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('38', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('39', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('40', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('41', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('42', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('43', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('44', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('45', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('46', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('47', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('48', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('49', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('50', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('51', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('52', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('53', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('54', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('55', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('56', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('57', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('58', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('59', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('60', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('61', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('62', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('63', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('64', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('65', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('66', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('67', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('68', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('69', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('70', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('71', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('72', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('73', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('74', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('75', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('76', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('77', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('78', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('79', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('80', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('81', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('82', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('83', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('84', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('85', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('86', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('87', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('88', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('89', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('90', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('91', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('92', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('93', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('94', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('95', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('96', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('97', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('98', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('99', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('100', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('101', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('102', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('103', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('104', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('105', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('106', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('107', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('108', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('109', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('110', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('111', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('112', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('113', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('114', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('115', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('116', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('117', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('118', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('119', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('120', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('121', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('122', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('123', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('124', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('125', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('126', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('127', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('128', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('129', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('130', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('131', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('132', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('133', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('134', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('135', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('136', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('137', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('138', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('139', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('140', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('141', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('142', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('143', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('144', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('145', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('146', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('147', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('148', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('149', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('150', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('151', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('152', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('153', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('154', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('155', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('156', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('157', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('158', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('159', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('160', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('161', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('162', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('163', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('164', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('165', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('166', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('167', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('168', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('169', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('170', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('171', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('172', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('173', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('174', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('175', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('176', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('177', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('178', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('179', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('180', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('181', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('182', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('183', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('184', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('185', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('186', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('187', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('188', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('189', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('190', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('191', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('192', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('193', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('194', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('195', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('196', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('197', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('198', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('199', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('200', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('201', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('202', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('203', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('204', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('205', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('206', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('207', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('208', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('209', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('210', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('211', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('212', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('213', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('214', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('215', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('216', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('217', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('218', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('219', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('220', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('221', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('222', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('223', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('224', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('225', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('226', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('227', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('228', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('229', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('230', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('231', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('232', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('233', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('234', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('235', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('236', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('237', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('238', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('239', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('240', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('241', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('242', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('243', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('244', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('245', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('246', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('247', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('248', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('249', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('250', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('251', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('252', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('253', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('254', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('255', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('256', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('257', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('258', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('259', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('260', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('261', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('262', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('263', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('264', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('265', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('266', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('267', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('268', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('269', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('270', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('271', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('272', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('273', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('274', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('275', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('276', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('277', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('278', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('279', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('280', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('281', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('282', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('283', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('284', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('285', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('286', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('287', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('288', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('289', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('290', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('291', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('292', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('293', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('294', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('295', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('296', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('297', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('298', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('299', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('300', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('301', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('302', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('303', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('304', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('305', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('306', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('307', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('308', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('309', 'SL', 'BT');
INSERT INTO `voucher_id` VALUES ('1', '', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'BP', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('7', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('8', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('11', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('12', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('13', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('14', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('17', 'CP', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('7', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('8', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('11', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('12', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('13', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('14', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('15', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('16', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('17', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('18', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('19', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('20', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('21', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('23', 'CR', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('7', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('8', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('11', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('12', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('13', 'JV', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('7', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('8', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('11', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('12', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('13', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('14', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('15', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('16', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('17', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('18', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('19', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('20', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('21', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('22', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('23', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('24', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('25', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('26', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('27', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('28', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('29', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('30', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('31', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('32', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('33', 'PL', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'RT', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'RT', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'RT', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'RT', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('7', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('8', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('11', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('12', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('13', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('14', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('15', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('16', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('17', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('18', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('19', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('20', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('21', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('22', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('23', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('24', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('25', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('26', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('27', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('28', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('29', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('30', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('31', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('32', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('33', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('34', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('35', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('36', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('37', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('38', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('39', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('40', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('41', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('42', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('43', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('44', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('45', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('46', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('47', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('48', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('49', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('50', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('51', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('52', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('53', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('54', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('55', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('56', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('57', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('58', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('59', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('60', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('61', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('62', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('63', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('64', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('65', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('66', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('67', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('68', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('69', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('70', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('71', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('72', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('73', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('74', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('75', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('76', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('77', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('78', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('79', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('80', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('81', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('82', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('83', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('84', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('85', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('86', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('87', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('88', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('89', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('90', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('91', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('92', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('93', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('94', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('95', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('96', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('97', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('98', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('99', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('100', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('101', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('102', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('103', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('104', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('105', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('106', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('107', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('108', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('109', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('110', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('111', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('112', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('113', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('114', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('115', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('116', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('117', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('118', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('119', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('120', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('121', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('122', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('123', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('124', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('125', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('126', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('127', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('128', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('129', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('130', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('131', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('132', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('133', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('134', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('135', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('136', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('137', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('138', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('139', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('140', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('141', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('142', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('143', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('144', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('145', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('146', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('147', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('148', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('149', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('150', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('151', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('152', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('153', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('154', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('155', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('156', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('157', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('158', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('159', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('160', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('161', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('162', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('163', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('164', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('165', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('166', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('167', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('168', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('169', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('170', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('171', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('172', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('173', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('174', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('175', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('176', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('177', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('178', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('179', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('180', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('181', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('182', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('183', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('184', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('185', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('186', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('187', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('188', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('189', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('190', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('191', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('192', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('193', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('194', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('195', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('196', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('197', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('198', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('199', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('200', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('201', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('202', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('203', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('204', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('205', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('206', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('207', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('208', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('209', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('210', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('211', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('212', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('213', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('214', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('215', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('216', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('217', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('218', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('219', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('220', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('221', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('222', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('223', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('224', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('225', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('226', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('227', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('228', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('229', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('230', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('231', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('232', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('233', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('234', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('235', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('236', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('237', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('238', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('239', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('240', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('241', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('242', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('243', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('244', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('245', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('246', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('247', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('248', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('249', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('250', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('251', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('252', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('253', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('254', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('255', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('256', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('257', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('258', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('259', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('260', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('261', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('262', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('263', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('264', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('265', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('266', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('267', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('268', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('269', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('270', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('271', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('272', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('273', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('274', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('275', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('276', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('277', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('278', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('279', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('280', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('281', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('282', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('283', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('284', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('285', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('286', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('287', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('288', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('289', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('290', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('291', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('292', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('293', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('294', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('295', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('296', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('297', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('298', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('299', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('300', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('301', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('302', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('303', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('304', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('305', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('306', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('307', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('308', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('309', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('310', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('311', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('312', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('313', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('314', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('315', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('316', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('317', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('318', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('319', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('320', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('321', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('322', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('323', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('324', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('325', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('326', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('327', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('328', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('329', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('330', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('331', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('332', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('333', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('334', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('335', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('336', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('337', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('338', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('339', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('340', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('341', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('342', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('343', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('344', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('345', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('346', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('347', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('348', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('349', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('350', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('351', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('352', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('353', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('354', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('355', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('356', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('357', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('358', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('359', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('360', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('361', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('362', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('363', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('364', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('365', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('366', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('367', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('368', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('369', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('370', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('371', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('372', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('373', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('374', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('375', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('376', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('377', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('378', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('379', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('380', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('381', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('382', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('383', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('384', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('385', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('386', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('387', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('388', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('389', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('390', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('391', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('392', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('393', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('394', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('395', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('396', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('397', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('398', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('399', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('400', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('401', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('402', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('403', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('404', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('405', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('406', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('407', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('408', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('409', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('410', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('411', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('412', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('413', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('414', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('415', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('416', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('417', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('418', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('419', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('420', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('421', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('422', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('423', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('424', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('425', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('426', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('427', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('428', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('429', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('430', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('431', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('432', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('433', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('434', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('435', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('436', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('437', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('438', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('439', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('440', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('441', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('442', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('443', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('444', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('445', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('446', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('447', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('448', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('449', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('450', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('451', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('452', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('453', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('454', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('455', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('456', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('457', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('458', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('459', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('460', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('461', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('462', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('463', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('464', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('465', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('466', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('467', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('468', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('469', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('470', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('471', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('472', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('473', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('474', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('475', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('476', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('477', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('478', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('479', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('480', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('481', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('482', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('483', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('484', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('485', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('486', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('487', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('488', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('489', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('490', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('491', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('492', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('493', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('494', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('495', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('496', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('497', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('498', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('499', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('500', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('501', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('502', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('503', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('504', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('505', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('506', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('507', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('508', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('509', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('510', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('511', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('512', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('513', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('514', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('515', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('516', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('517', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('518', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('519', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('520', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('521', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('522', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('523', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('524', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('525', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('526', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('527', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('528', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('529', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('530', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('531', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('532', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('533', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('534', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('535', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('536', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('537', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('538', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('539', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('540', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('541', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('542', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('543', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('544', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('545', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('546', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('547', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('548', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('549', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('550', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('551', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('552', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('553', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('554', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('555', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('556', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('557', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('558', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('559', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('560', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('561', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('562', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('563', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('564', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('565', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('566', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('567', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('568', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('569', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('570', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('571', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('572', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('573', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('574', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('575', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('576', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('577', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('578', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('579', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('580', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('581', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('582', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('583', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('584', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('585', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('586', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('587', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('588', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('589', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('590', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('591', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('592', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('593', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('594', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('595', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('596', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('597', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('598', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('599', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('600', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('601', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('602', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('603', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('604', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('605', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('606', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('607', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('608', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('609', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('610', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('611', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('612', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('613', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('614', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('615', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('616', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('617', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('618', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('619', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('620', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('621', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('622', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('623', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('624', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('625', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('626', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('627', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('628', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('629', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('630', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('631', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('632', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('633', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('634', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('635', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('636', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('637', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('638', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('639', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('640', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('641', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('642', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('643', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('644', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('645', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('646', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('647', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('648', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('649', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('650', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('651', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('652', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('653', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('654', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('655', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('656', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('657', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('658', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('659', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('660', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('661', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('662', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('663', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('664', 'SL', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'SO', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'SO', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'SO', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'SO', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('2', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('3', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('4', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('5', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('6', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('7', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('8', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('9', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('10', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('11', 'ST', 'IT');
INSERT INTO `voucher_id` VALUES ('1', 'BP', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'BR', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'BR', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'BR', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('119', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('138', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('139', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('140', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('141', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('142', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('143', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('144', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('145', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('146', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('147', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('148', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('150', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('151', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('152', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('153', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('154', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('155', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('156', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('157', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('158', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('159', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('160', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('161', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('162', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('163', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('164', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('165', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('166', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('167', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('168', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('169', 'CP', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'CR', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'JV', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('119', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('138', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('139', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('140', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('141', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('142', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('143', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('144', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('145', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('146', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('147', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('148', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('149', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('150', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('151', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('152', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('153', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('154', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('155', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('156', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('157', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('158', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('159', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('160', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('161', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('162', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('163', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('164', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('165', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('166', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('167', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('168', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('169', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('170', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('171', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('172', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('173', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('174', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('175', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('176', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('177', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('178', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('179', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('180', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('181', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('182', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('183', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('184', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('185', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('186', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('187', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('188', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('189', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('190', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('191', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('192', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('193', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('194', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('195', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('196', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('197', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('198', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('199', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('200', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('201', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('202', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('203', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('204', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('205', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('206', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('207', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('208', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('209', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('210', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('211', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('212', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('213', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('214', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('215', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('216', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('217', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('218', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('219', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('220', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('221', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('222', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('223', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('224', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('225', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('226', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('227', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('228', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('229', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('230', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('231', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('232', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('233', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('234', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('235', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('236', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('237', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('238', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('239', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('240', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('241', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('242', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('243', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('244', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('245', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('246', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('247', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('248', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('249', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('250', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('251', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('252', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('253', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('254', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('255', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('256', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('257', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('258', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('259', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('260', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('261', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('262', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('263', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('264', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('265', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('266', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('267', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('268', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('269', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('270', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('271', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('272', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('273', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('274', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('275', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('276', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('277', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('278', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('279', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('280', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('281', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('282', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('283', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('284', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('285', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('286', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('287', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('288', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('289', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('290', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('291', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('292', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('293', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('294', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('295', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('296', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('297', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('298', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('299', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('300', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('301', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('302', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('303', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('304', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('305', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('306', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('307', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('308', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('309', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('310', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('311', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('312', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('313', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('314', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('315', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('316', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('317', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('318', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('319', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('320', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('321', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('322', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('323', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('324', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('325', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('326', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('327', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('328', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('329', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('330', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('331', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('332', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('333', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('334', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('335', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('336', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('337', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('338', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('339', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('340', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('341', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('342', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('343', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('344', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('345', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('346', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('347', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('348', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('349', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('350', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('351', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('352', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('353', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('354', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('355', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('356', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('357', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('358', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('359', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('360', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('361', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('362', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('363', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('364', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('365', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('366', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('367', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('368', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('369', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('370', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('371', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('372', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('373', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('374', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('375', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('376', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('377', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('378', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('379', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('380', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('381', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('382', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('383', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('384', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('385', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('386', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('387', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('388', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('389', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('390', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('391', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('392', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('393', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('394', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('395', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('396', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('397', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('398', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('399', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('400', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('401', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('402', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('403', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('404', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('405', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('406', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('407', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('408', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('409', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('410', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('411', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('412', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('413', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('414', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('415', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('416', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('417', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('418', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('419', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('420', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('421', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('422', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('423', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('424', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('425', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('426', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('427', 'PL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'RT', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('119', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('138', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('139', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('140', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('141', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('142', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('143', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('144', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('145', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('146', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('147', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('148', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('149', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('150', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('151', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('152', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('153', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('154', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('155', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('156', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('157', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('158', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('159', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('160', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('161', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('162', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('163', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('164', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('165', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('166', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('167', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('168', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('169', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('170', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('171', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('172', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('173', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('174', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('175', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('176', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('177', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('178', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('179', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('180', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('181', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('182', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('183', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('184', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('185', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('186', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('187', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('188', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('189', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('190', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('191', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('192', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('193', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('194', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('195', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('196', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('197', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('198', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('199', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('200', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('201', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('202', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('203', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('204', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('205', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('206', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('207', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('208', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('209', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('210', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('211', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('212', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('213', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('214', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('215', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('216', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('217', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('218', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('219', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('220', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('221', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('222', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('223', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('224', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('225', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('226', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('227', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('228', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('229', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('230', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('231', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('232', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('233', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('234', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('235', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('236', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('237', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('238', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('239', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('240', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('241', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('242', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('243', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('244', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('245', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('246', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('247', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('248', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('249', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('250', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('251', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('252', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('253', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('254', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('255', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('256', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('257', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('258', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('259', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('260', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('261', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('262', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('263', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('264', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('265', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('266', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('267', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('268', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('269', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('270', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('271', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('272', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('273', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('274', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('275', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('276', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('277', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('278', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('279', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('280', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('281', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('282', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('283', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('284', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('285', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('286', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('287', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('288', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('289', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('290', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('291', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('292', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('293', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('294', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('295', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('296', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('297', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('298', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('299', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('300', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('301', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('302', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('303', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('304', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('305', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('306', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('307', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('308', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('309', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('310', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('311', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('312', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('313', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('314', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('315', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('316', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('317', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('318', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('319', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('320', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('321', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('322', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('323', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('324', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('325', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('326', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('327', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('328', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('329', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('330', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('331', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('332', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('333', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('334', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('335', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('336', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('337', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('338', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('339', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('340', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('341', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('342', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('343', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('344', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('345', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('346', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('347', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('348', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('349', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('350', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('351', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('352', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('353', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('354', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('355', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('356', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('357', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('358', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('359', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('360', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('361', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('362', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('363', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('364', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('365', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('366', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('367', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('368', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('369', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('370', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('371', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('372', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('373', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('374', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('375', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('376', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('377', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('378', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('379', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('380', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('381', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('382', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('383', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('384', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('385', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('386', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('387', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('388', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('389', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('390', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('391', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('392', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('393', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('394', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('395', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('396', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('397', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('398', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('399', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('400', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('401', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('402', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('403', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('404', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('405', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('406', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('407', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('408', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('409', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('410', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('411', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('412', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('413', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('414', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('415', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('416', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('417', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('418', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('419', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('420', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('421', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('422', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('423', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('424', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('425', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('426', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('427', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('428', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('429', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('430', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('431', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('432', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('433', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('434', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('435', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('436', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('437', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('438', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('439', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('440', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('441', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('442', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('443', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('444', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('445', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('446', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('447', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('448', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('449', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('450', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('451', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('452', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('453', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('454', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('455', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('456', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('457', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('458', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('459', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('460', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('461', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('462', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('463', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('464', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('465', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('466', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('467', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('468', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('469', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('470', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('471', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('472', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('473', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('474', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('475', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('476', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('477', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('478', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('479', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('480', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('481', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('482', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('483', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('484', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('485', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('486', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('487', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('488', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('489', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('490', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('491', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('492', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('493', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('494', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('495', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('496', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('497', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('498', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('499', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('500', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('501', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('502', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('503', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('504', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('505', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('506', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('507', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('508', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('509', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('510', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('511', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('512', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('513', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('514', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('515', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('516', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('517', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('518', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('519', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('520', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('521', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('522', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('523', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('524', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('525', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('526', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('527', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('528', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('529', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('530', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('531', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('532', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('533', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('534', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('535', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('536', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('537', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('538', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('539', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('540', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('541', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('542', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('543', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('544', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('545', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('546', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('547', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('548', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('549', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('550', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('551', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('552', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('553', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('554', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('555', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('556', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('557', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('558', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('559', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('560', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('561', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('562', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('563', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('564', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('565', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('566', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('567', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('568', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('569', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('570', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('571', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('572', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('573', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('574', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('575', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('576', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('577', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('578', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('579', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('580', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('581', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('582', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('583', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('584', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('585', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('586', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('587', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('588', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('589', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('590', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('591', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('592', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('593', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('594', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('595', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('596', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('597', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('598', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('599', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('600', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('601', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('602', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('603', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('604', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('605', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('606', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('607', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('608', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('609', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('610', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('611', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('612', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('613', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('614', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('615', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('616', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('617', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('618', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('619', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('620', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('621', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('622', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('623', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('624', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('625', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('626', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('627', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('628', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('629', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('630', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('631', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('632', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('633', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('634', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('635', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('636', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('637', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('638', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('639', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('640', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('641', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('642', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('643', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('644', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('645', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('646', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('647', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('648', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('649', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('650', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('651', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('652', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('653', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('654', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('655', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('656', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('657', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('658', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('659', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('660', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('661', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('662', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('663', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('664', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('665', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('666', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('667', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('668', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('669', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('670', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('671', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('672', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('673', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('674', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('675', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('676', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('677', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('678', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('679', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('680', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('681', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('682', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('683', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('684', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('685', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('686', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('687', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('688', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('689', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('690', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('691', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('692', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('693', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('694', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('695', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('696', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('697', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('698', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('699', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('700', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('701', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('702', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('703', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('704', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('705', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('706', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('707', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('708', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('709', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('710', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('711', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('712', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('713', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('714', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('715', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('716', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('717', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('718', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('719', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('720', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('721', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('722', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('723', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('724', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('725', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('726', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('727', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('728', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('729', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('730', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('731', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('732', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('733', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('734', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('735', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('736', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('737', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('738', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('739', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('740', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('741', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('742', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('743', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('744', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('745', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('746', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('747', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('748', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('749', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('750', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('751', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('752', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('753', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('754', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('755', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('756', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('757', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('758', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('759', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('760', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('761', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('762', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('763', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('764', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('765', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('766', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('767', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('768', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('769', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('770', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('771', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('772', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('773', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('774', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('775', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('776', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('777', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('778', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('779', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('780', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('781', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('782', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('783', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('784', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('785', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('786', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('787', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('788', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('789', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('790', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('791', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('792', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('793', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('794', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('795', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('796', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('797', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('798', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('799', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('800', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('801', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('802', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('803', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('804', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('805', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('806', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('807', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('808', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('809', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('810', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('811', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('812', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('813', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('814', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('815', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('816', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('817', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('818', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('819', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('820', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('821', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('822', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('823', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('824', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('825', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('826', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('827', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('828', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('829', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('830', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('831', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('832', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('833', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('834', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('835', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('836', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('837', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('838', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('839', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('840', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('841', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('842', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('843', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('844', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('845', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('846', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('847', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('848', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('849', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('850', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('851', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('852', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('853', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('854', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('855', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('856', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('857', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('858', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('859', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('860', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('861', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('862', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('863', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('864', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('865', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('866', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('867', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('868', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('869', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('870', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('871', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('872', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('873', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('874', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('875', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('876', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('877', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('878', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('879', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('880', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('881', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('882', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('883', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('884', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('885', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('886', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('887', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('888', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('889', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('890', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('891', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('892', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('893', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('894', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('895', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('896', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('897', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('898', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('899', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('900', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('901', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('902', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('903', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('904', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('905', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('906', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('907', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('908', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('909', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('910', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('911', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('912', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('913', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('914', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('915', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('916', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('917', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('918', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('919', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('920', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('921', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('922', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('923', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('924', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('925', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('926', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('927', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('928', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('929', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('930', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('931', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('932', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('933', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('934', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('935', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('936', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('937', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('938', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('939', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('940', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('941', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('942', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('943', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('944', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('945', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('946', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('947', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('948', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('949', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('950', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('951', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('952', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('953', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('954', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('955', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('956', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('957', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('958', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('959', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('960', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('961', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('962', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('963', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('964', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('965', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('966', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('967', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('968', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('969', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('970', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('971', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('972', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('973', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('974', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('975', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('976', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('977', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('978', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('979', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('980', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('981', 'SL', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'SO', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('2', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('3', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('4', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('5', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('6', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('7', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('8', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('9', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('10', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('11', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('12', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('13', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('14', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('15', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('16', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('17', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('18', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('19', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('20', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('21', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('22', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('23', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('24', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('25', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('26', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('27', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('28', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('29', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('30', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('31', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('32', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('33', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('34', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('35', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('36', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('37', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('38', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('39', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('40', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('41', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('42', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('43', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('44', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('45', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('46', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('47', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('48', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('49', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('50', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('51', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('52', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('53', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('54', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('55', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('56', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('57', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('58', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('59', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('60', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('61', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('62', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('63', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('64', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('65', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('66', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('67', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('68', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('69', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('70', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('71', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('72', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('73', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('74', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('75', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('76', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('77', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('78', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('79', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('80', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('81', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('82', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('83', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('84', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('85', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('86', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('87', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('88', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('89', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('90', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('91', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('92', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('93', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('94', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('95', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('96', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('97', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('98', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('99', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('100', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('101', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('102', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('103', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('104', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('105', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('106', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('107', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('108', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('109', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('110', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('111', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('112', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('113', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('114', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('115', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('116', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('117', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('118', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('120', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('121', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('122', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('123', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('124', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('125', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('126', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('127', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('128', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('129', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('130', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('131', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('132', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('133', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('134', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('135', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('136', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('137', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('138', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('139', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('140', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('141', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('142', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('143', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('144', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('145', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('146', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('147', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('148', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('149', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('150', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('151', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('152', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('153', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('154', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('155', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('156', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('157', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('158', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('159', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('160', 'ST', 'KT');
INSERT INTO `voucher_id` VALUES ('1', 'JV', 'TT');
INSERT INTO `voucher_id` VALUES ('2', 'JV', 'TT');
INSERT INTO `voucher_id` VALUES ('3', 'JV', 'TT');
INSERT INTO `voucher_id` VALUES ('1', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('2', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('3', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('4', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('5', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('6', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('7', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('8', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('9', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('10', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('11', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('12', 'PL', 'TT');
INSERT INTO `voucher_id` VALUES ('1', 'SL', 'TT');
INSERT INTO `voucher_id` VALUES ('2', 'SL', 'TT');
INSERT INTO `voucher_id` VALUES ('3', 'SL', 'TT');
INSERT INTO `voucher_id` VALUES ('4', 'SL', 'TT');
INSERT INTO `voucher_id` VALUES ('5', 'SL', 'TT');

-- ----------------------------
-- Table structure for `web_title`
-- ----------------------------
DROP TABLE IF EXISTS `web_title`;
CREATE TABLE `web_title` (
  `acct_id` int(11) NOT NULL AUTO_INCREMENT,
  `acct_name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of web_title
-- ----------------------------
INSERT INTO `web_title` VALUES ('1', 'TAYYAB TRADER');

-- ----------------------------
-- Table structure for `xls_bank_bal`
-- ----------------------------
DROP TABLE IF EXISTS `xls_bank_bal`;
CREATE TABLE `xls_bank_bal` (
  `acct_name` varchar(255) DEFAULT NULL,
  `debit` varchar(255) DEFAULT NULL,
  `credit` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_bank_bal
-- ----------------------------
INSERT INTO `xls_bank_bal` VALUES ('1189-79000868-03', '5891', '');
INSERT INTO `xls_bank_bal` VALUES ('218174931 Ubl', '1149', '');
INSERT INTO `xls_bank_bal` VALUES ('ABL', '4500', '');
INSERT INTO `xls_bank_bal` VALUES ('ABL Faqeerni Gate', '1483', '');
INSERT INTO `xls_bank_bal` VALUES ('ABL Khalid Market', '155000', '');
INSERT INTO `xls_bank_bal` VALUES ('Al Habib Metro', '51655', '');
INSERT INTO `xls_bank_bal` VALUES ('Bank Alfalah', '86827', '');
INSERT INTO `xls_bank_bal` VALUES ('Bank Alfalah 106', '38734', '');
INSERT INTO `xls_bank_bal` VALUES ('Bank of Khyber 718', '29400', '');
INSERT INTO `xls_bank_bal` VALUES ('BOK 5393-5', '4072', '');
INSERT INTO `xls_bank_bal` VALUES ('BOK 8903', '80773', '');
INSERT INTO `xls_bank_bal` VALUES ('FAISAL BANK', '8275', '');
INSERT INTO `xls_bank_bal` VALUES ('HBL Bazar Kalan', '16100', '');
INSERT INTO `xls_bank_bal` VALUES ('HBL Dollar Account', '57267', '');
INSERT INTO `xls_bank_bal` VALUES ('Islamic Bank', '3149', '');
INSERT INTO `xls_bank_bal` VALUES ('MCB-2032', '115068', '');
INSERT INTO `xls_bank_bal` VALUES ('MCB-Tank Adda', '1370', '');
INSERT INTO `xls_bank_bal` VALUES ('UBL-Circular Road', '70540', '');
INSERT INTO `xls_bank_bal` VALUES ('UBL-Tank Adda', '27815', '');

-- ----------------------------
-- Table structure for `xls_cust_bal`
-- ----------------------------
DROP TABLE IF EXISTS `xls_cust_bal`;
CREATE TABLE `xls_cust_bal` (
  `acct_name` varchar(255) DEFAULT NULL,
  `debit` varchar(255) DEFAULT NULL,
  `credit` varchar(255) DEFAULT NULL,
  `reg_id` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_cust_bal
-- ----------------------------
INSERT INTO `xls_cust_bal` VALUES ('Abbas Khan Peshawar', '', '2650400', null);
INSERT INTO `xls_cust_bal` VALUES ('Akbar Zaman Kulachi', '1599200', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Al Habib Bank', '31000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Ameer Nawaz Sher Gar', '80', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Amir Family Ghee', '', '3000', null);
INSERT INTO `xls_cust_bal` VALUES ('Aqeel Traders Darya', '4912047', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Asghar Ali Pabi', '1200', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Aslam Mama', '', '2000000', null);
INSERT INTO `xls_cust_bal` VALUES ('Baho Flour Mills Dasti', '4954874', '', null);
INSERT INTO `xls_cust_bal` VALUES ('BAHOO RAHAT GARDAN DASTI KHATA', '', '20705851', null);
INSERT INTO `xls_cust_bal` VALUES ('Bahoo Rice Mill Kahta', '', '0.4', null);
INSERT INTO `xls_cust_bal` VALUES ('Bakht Niaz Sugar Broker', '220200', '', null);
INSERT INTO `xls_cust_bal` VALUES ('CHACHA ILYAS', '', '891151', null);
INSERT INTO `xls_cust_bal` VALUES ('Chashma Ghee Mills Sugar', '', '875790.5', null);
INSERT INTO `xls_cust_bal` VALUES ('Chashma Oil', '25943374', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Faizan Malik Adda', '115350', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Gogi Sugar Broker', '4564', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Gulf Sugar Mills', '', '30450000', null);
INSERT INTO `xls_cust_bal` VALUES ('Hahji Fazal Riaz Bannu', '3657600', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Abdul Rehman  Sheikh Yousaf', '', '614400', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Akbar Ali Pdsp', '', '747600', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Awal Khan Nourang', '3000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('HAJI AWAS DRABAN', '612000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Ehsan Atta Diler Tirjat Ganj', '', '265000', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Gullu Fayaz', '', '700', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Gul Shah Jahan Dera', '', '6108000', null);
INSERT INTO `xls_cust_bal` VALUES ('HAJI IMAM DIN', '', '1690000', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Mohammad Ghulam', '', '916000', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Sadiq Ghee', '', '265000', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Sharif Pezu', '100000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('HAJI SULTAN NOOR KOHAT', '105949', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Haji Taj Alil Khan Sheikh Yousaf', '', '307200', null);
INSERT INTO `xls_cust_bal` VALUES ('Hanif Bhatti', '', '3060000', null);
INSERT INTO `xls_cust_bal` VALUES ('Hikmat Ullah  Bannu', '4060', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Ibrahim Khalil Dasti Khata', '', '6500000', null);
INSERT INTO `xls_cust_bal` VALUES ('Imran Bannu', '', '148950', null);
INSERT INTO `xls_cust_bal` VALUES ('Imran Bhakkar', '14730', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Ismail Paroa', '', '1402800', null);
INSERT INTO `xls_cust_bal` VALUES ('Kafel Traders Shop', '10256411.5', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Kalan Bazar', '', '1258000', null);
INSERT INTO `xls_cust_bal` VALUES ('Khaki Shah Pezu', '609400', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Khaleel Traders', '16563355', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Khalid Bashir Fsd', '199530', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Khizar Kulachi', '614400', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Khwaja Imran Saroda', '', '96147', null);
INSERT INTO `xls_cust_bal` VALUES ('Laiq Zaheer Lahore', '', '4355629', null);
INSERT INTO `xls_cust_bal` VALUES ('Lal Zadah Kohat', '199', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Liaqat Ali Pezu', '591600', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Liaqat Harnoli', '617000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Malik Mithu Cheeni Khtta', '', '1950000', null);
INSERT INTO `xls_cust_bal` VALUES ('Munsif Doaba', '', '66400', null);
INSERT INTO `xls_cust_bal` VALUES ('Naseeb Shah Amberi Kaly', '1971000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Naveed Bahoo Mill', '', '1496400', null);
INSERT INTO `xls_cust_bal` VALUES ('NEW RAHAT GARDAN', '26316646', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Niaz Muhammad Pezu', '719040', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Rafeeq Kohat', '', '1000', null);
INSERT INTO `xls_cust_bal` VALUES ('Raja Nadeem', '', '2800000', null);
INSERT INTO `xls_cust_bal` VALUES ('Rana Shahid Multan', '4033600', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Rehman Ullah Amberi Kaly', '833526', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Rizwan Lakki Marwat', '1527787', '', null);
INSERT INTO `xls_cust_bal` VALUES ('SALAM TANK', '200000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Sami Ullah Mianwali', '10200', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Saqib Sahab', '88000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Shahid Zam Rice Mill', '271604.5', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Shakeel Pabi', '140', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Sheikh Safdar Piplan', '', '600', null);
INSERT INTO `xls_cust_bal` VALUES ('Sheryar Chashma Ghee Mill', '200000', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Shop Rent Incom Bannu Adda Shop', '', '160000', null);
INSERT INTO `xls_cust_bal` VALUES ('Sufi Umar Gul Lakki', '470', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Ustad Sahab C/o Malik Mithu', '', '403500', null);
INSERT INTO `xls_cust_bal` VALUES ('YAMEEN HALWI C/O HAJI MOBEEN', '', '673200', null);
INSERT INTO `xls_cust_bal` VALUES ('Zafar Iqbal Karak', '2950', '', null);
INSERT INTO `xls_cust_bal` VALUES ('Zam Rice Mill Rice  Khtta', '', '40432', null);
INSERT INTO `xls_cust_bal` VALUES ('Zam Traders Cash', '', '4873785', null);
INSERT INTO `xls_cust_bal` VALUES ('Zaqat', '', '849174', null);
INSERT INTO `xls_cust_bal` VALUES ('SUSPENSE AC', '', '92233', null);
INSERT INTO `xls_cust_bal` VALUES ('MALIK MAHI NAWAB ADDA', '500000', '', null);

-- ----------------------------
-- Table structure for `xls_cust_reg`
-- ----------------------------
DROP TABLE IF EXISTS `xls_cust_reg`;
CREATE TABLE `xls_cust_reg` (
  `acct_name` varchar(255) DEFAULT NULL,
  `reg_id` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_cust_reg
-- ----------------------------
INSERT INTO `xls_cust_reg` VALUES ('Aas Muhammad, Nawab Adda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Abid Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Aman Ullah Pahor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Ayaz Halwai', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Baloch Hotel, Nawab', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Feroaz Ara Road C/o Ayub Nawab Adda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Gulshan Bakers Multan Road', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Ghulam Rabani, Nawab Adda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Khan C/o Sami Bahoo Mill', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Saad Ullah, Muryali', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Sadiq Pakwan, Muryali', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Hakem Khan Qureshi Mor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Inayat Hotel Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Irshad Jhok Qureshi Mor ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Jabir Halwai', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Jamal Karyana Nawab Adda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Kaka Ustad Muryali', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Kala Khan, Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Kashif Muriali C/o Irfan', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Ayub, Nawab Adda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Shakeel, Muryali', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muneer Halwai ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Naseeb Fath Mor ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Nawaz Rice Qureshi Mor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Qureshi Mor Other Debtors', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Ramzan Kat Malana ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Rana Abdu Sattar, Chah Munshi Wala', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Riaz Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Saad Ullah Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Sabir Rice Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Saif Ur Rehman Nawab Adda ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Shafi Jhok Qureshi', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Shahnawaz Pakwan, Muryali', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Shamsher, Dajal', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Abrar Paroa C/o Shabbir Sb.', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Alamgir Khan Mara', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Allah Diwaya Adil Sipraa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Al Rehmat, Fateh Mor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Aziz Khan Triman', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Bashir-Lunda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Ghulam Nabi, Draban', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Habib Ramzan, Ramak', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Habib Ullah Kundi, Draban', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Hafiz Usman, Fateh Mor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Abdur Rauf, Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Abdu Salam, Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Anwar, Bachri', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Azam, Marah', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Bilal Lunda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Elahi Bakhsh Proa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Faiz Muhammad, Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Jafir Proa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Mushtaq, Bachri', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Sher Khan, Ramak', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Sultan, Mahra', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Haji Zahoor, Ramak', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Hameed Ullah, Lunda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Inayat Ullah, Ubhaya Pul', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Ismail Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Jameel Naiwela', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Khaleel Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Khuda Bakhsh Tibbi Qasrani', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Malik Sami Ullah Chashma Sugar Mills', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Maqbool Khan Mara ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Meer Daad, Naiwela', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Mithu Karyana, Naiwela', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Aslam, Bachri', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Imran Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Nawaz, Lunda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Qadeer, Fateh Mor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Suleman, Mahra', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhammad Tariq, Mahra', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muhibullah Lunda ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Mukhtiar Ahmad Draban', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muneer Ahmed, Naiwela', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Muzafar Khan Muriali ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Nasr Ullah Khan Mara', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Nazir Ubhya Pull', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Rasheed Draban ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Rauf Malana ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Razaullah Mara ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Rehmat Ullah Ramak', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Saeed Draban ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Saeed & Wahid Bakhsh, Ubhaya Pul', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Saif Ullah, Ubhaya Pul', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Sana Ullah Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Sarwar Khan Kundi Paroa', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Siddique, Fateh Mor', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Wahab Mara ', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Yaqoob, Ubhaya Pul', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Yousaf Lunda', '020114');
INSERT INTO `xls_cust_reg` VALUES ('Yousuf Mara ', '020114');

-- ----------------------------
-- Table structure for `xls_loan_bal`
-- ----------------------------
DROP TABLE IF EXISTS `xls_loan_bal`;
CREATE TABLE `xls_loan_bal` (
  `acct_name` varchar(255) DEFAULT NULL,
  `debit` varchar(255) DEFAULT NULL,
  `credit` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_loan_bal
-- ----------------------------
INSERT INTO `xls_loan_bal` VALUES ('Baloch Sahab, Bank Alfalah', '8730', '');
INSERT INTO `xls_loan_bal` VALUES ('BaNK ALF Insurance', '141148', '');
INSERT INTO `xls_loan_bal` VALUES ('Dera News', '40000', '');
INSERT INTO `xls_loan_bal` VALUES ('Dildar Munshi', '61180', '');
INSERT INTO `xls_loan_bal` VALUES ('Godam  Bahoo Traders', '20000', '');
INSERT INTO `xls_loan_bal` VALUES ('Gohar Zaman, Driver', '186815', '');
INSERT INTO `xls_loan_bal` VALUES ('Gulzar MCB', '25505', '');
INSERT INTO `xls_loan_bal` VALUES ('Habib Mushtaq Panter', '122000', '');
INSERT INTO `xls_loan_bal` VALUES ('Hafiz Ismail Makkah', '40000', '');
INSERT INTO `xls_loan_bal` VALUES ('Haifz Munir Cant', '50000', '');
INSERT INTO `xls_loan_bal` VALUES ('Haji Aslam Rose Hotel', '35840', '');
INSERT INTO `xls_loan_bal` VALUES ('Haji Jan Mohammad', '10000', '');
INSERT INTO `xls_loan_bal` VALUES ('Haji Saad Ullah, Ramak', '355730', '');
INSERT INTO `xls_loan_bal` VALUES ('Hasnain Kotex', '123366', '');
INSERT INTO `xls_loan_bal` VALUES ('Jamshed Bhai Bank Alfalah', '246960', '');
INSERT INTO `xls_loan_bal` VALUES ('KAPCO Shares', '15000', '');
INSERT INTO `xls_loan_bal` VALUES ('Mansoor Ahmed, Paharpur', '139604', '');
INSERT INTO `xls_loan_bal` VALUES ('Maqbool HBL', '22256', '');
INSERT INTO `xls_loan_bal` VALUES ('Maqbool UBL', '25000', '');
INSERT INTO `xls_loan_bal` VALUES ('Muhammad Aqeel Darya Khan', '3150543', '');
INSERT INTO `xls_loan_bal` VALUES ('Muhammad Aslam Lahori', '298820', '');
INSERT INTO `xls_loan_bal` VALUES ('Muhammad Ilyas, Tijarat Ganj', '1328331', '');
INSERT INTO `xls_loan_bal` VALUES ('Muhammad Khaleel, Madina Colony', '4924249', '');
INSERT INTO `xls_loan_bal` VALUES ('Najeeb Paracha Rawalpindi', '932020', '');
INSERT INTO `xls_loan_bal` VALUES ('Sad Rossal', '302000', '');
INSERT INTO `xls_loan_bal` VALUES ('Wasi Header Zadi Chahshma Gee Mii', '90000', '');

-- ----------------------------
-- Table structure for `xls_old_cust_bal`
-- ----------------------------
DROP TABLE IF EXISTS `xls_old_cust_bal`;
CREATE TABLE `xls_old_cust_bal` (
  `acct_name` varchar(255) DEFAULT NULL,
  `debit` varchar(255) DEFAULT NULL,
  `credit` varchar(255) DEFAULT NULL,
  `reg_id` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_old_cust_bal
-- ----------------------------
INSERT INTO `xls_old_cust_bal` VALUES ('Abdul Bari, Tijarat Ganj', '38335.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Abdul Hanan, Ramak', '11900.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Abdur Raheem, Soda Water Factory', '35000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Abdur Razaq, Madina Colony', '43890.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Abdur Rehman, Hayat Bochra', '10200.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Abdu Sattar, Tijarat Ganj', '6520.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Abudlraziq Quarshi Drabn', '42000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Adnan Tijarat Ganj', '46804.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ahmed Jan, Kulachi', '2950.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Al Asad Muryali Mor', '3000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Al Hassan Karyana, Misgran Bazar', '10990.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ali Super Store', '800.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Allah Nawaz Clerk', '11540.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Aqal Khan', '7550.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Arif Uncal Mahallah Gosi Wala', '28010.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Arshad, Madina Colony', '26940.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Asad, Bank Alfalah', '3720.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Asghar Lucknow Bakers', '9690.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Asif Loading Clerk', '113580.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Aslam Munshi', '10740.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Atiq Ahmed, Chaman Chowk', '5820.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ayaz Deen Pur', '18700.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ayub Baloch', '2600.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Azhair  C/o Zafir Wapda', '25410.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Babar Sewayan Chaman Chowk', '4400.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Basheer Hussain', '18800.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Basit-Cook', '7580.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Bismillah General Store', '180.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Bismillah Hotel, Bannu Adda', '2005.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Bismillah Karyana Store', '4310.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Chaudhry Ikram, Bazar Kalan', '5000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Chaudhry Yameen, Paharpur', '72080.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Doctor Ramzan, Muryali', '9780.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Faheem, Chah Syed Munawar Shah', '4920.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Falak Sher Proa', '3230.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ghar Kharcha Haji Imamdin', '50100.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ghar Kharcha Haji Nizam Din', '429066.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ghulam Baqir Shahani, Meeran', '24000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ghulam Hussain, Hotel', '3400.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ghulam Muhammad, City Police', '86760.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Gul Habib, Naiwela', '4567.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Gul Zaman Kulchi', '1860.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haji Abdullah, Gaba Karyana Tijarat Ganj', '6930.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haji Ghulam Subhani', '422970.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haji Ishfaq Police Lines', '16865.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haji Muhammad Ibrahim, Muryali', '53370.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haji Shaukat Mohallah Dewan Sahab', '9960.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haji Sher Muhammad', '3090.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Haq Nawaz, Draban Chungi', '47875.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Hashim Khan, Tank Adda', '10000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ibrahim  Mohallah Dewan Shaib', '1730.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Ibrahim Tank Adda', '10520.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Imran Bakhar (846)', '', '117891.47', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Inayat Dilawar, Paroa Adda', '101720.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Inayat Ullah, Tank Adda', '10100.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Iqra Bakers Nawab Adda', '13370.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Irfan Ahmed, Kotli Imam', '117860.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Irfan  Chotat BAZAR', '650.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Irfan Munshi, Mohallah Deewan Sahab', '131740.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Islam Ud Din Halwai', '67620.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Jamil Bahi C/o Usman Munshi', '194520.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Jamil NCN Cable', '66565.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Javed Ustaad', '52335.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Kashaf Bakers', '71575.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Khair Wali, Paroa Adda', '48003.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Khalid, Chaman Chowk', '11450.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Khalid, Paroa Adda', '38000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Khalil Hotel', '4000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Kifayat Munshi (706)', '8650.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Lal Behram, Naiwela', '1400.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Maani Super Store', '1180.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Maaz Karyna', '580.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Madni Gur Dealer', '171050.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('M Ali G Soter(894', '21600.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Malik Allah Nawaz, Misgran Bazar', '110648.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Malik Ellahi Bakhsh, Bazar Topanwala', '15220.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Malik Gul Muhammad, Misgran Bazar', '20955.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Mama Qayyum, TTC College', '12020.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Mamoon Peshwar', '5748.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Manzoor Hussain, Chairman', '51969.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Marhaba Sweets, Misgran Bazar', '9240.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Master  Mohllah Shibshah', '2640.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Mazhar Hameed, Madina Colony', '21050.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Mubeen Cannt.', '13500.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Afzal Bhakkar', '', '1.00', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Arif Khan, Khansama', '44380.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Faheem, Sadar Bazar', '119.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Ibrahim, Naiwela', '76736.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Irfan Parpur (892)', '20708.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Islam, Tank', '134000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Nawaz, Chodhwan', '11560.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Ramzan, CRBC', '51835.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Shakeel, Nawab Adda', '14980.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Suleman, Parosi Haji Imam Din', '25600.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhammad Zafar, Halwai', '46140.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muhmmad Imran Pathan, Madina Colony', '25000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Mukhtiyar Hussain, Kotla Saidan', '43210.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Multan Bakers, Chotta Bazar', '65770.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Muneer Halwai, Bazar Topanwala', '7030.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Nadeem Tank Adda', '81000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Nasar Ullah, Kotli Imam', '15580.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Naseer, Mohallah Hazrat Bilal', '1100.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Nasir Hussain Tank Adda', '7020.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Pasham Gul', '333000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Qari Irfan Madrsaa', '30480.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Qari Noor Rehman Tijarat Ganj', '422.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Rahat International Haj Umra', '92520.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Rana Faheem Mohallh Gosiyn Wala', '2340.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Rasheed, Maqbool Sweets', '', '11190.00', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Riaz General Store', '180.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Rizwan Mujahid Nagar', '1440.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Saif Ur Rehman', '880.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Sana Ullah Mohallah Ship Shah', '17860.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Saqib Saleem Mohallah Allaudin', '25165.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Sardar Naimat Kundi, Lunda', '19200.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Shahid & Fazal', '37060.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Shah Jee Palay Daar', '1140.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Shakeel Ahmed Muslim Bazar', '8480.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Shaukat Shah, Chah Syed Munawar Shah', '32065.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Shehzad Imtiaz, Basti Kanchkan Wali', '25530.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Sheikh Abdullah Quraishi Morr', '2750.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Sheikh Irfan, Bazar Kalan', '27260.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Siddique Cloth', '90000.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Sohail Ahmed Clerk', '135832.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Tanveer Ahmed, Ghala Mandi', '27160.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Tayyab Chota Baazar', '4420.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Umar Hayat Pehlwan', '320.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Waqqar Najm-U-Din (28)', '70600.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Yaseen Khan, Tijarat Ganj', '29550.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Zahir Shah, Paroa', '7600.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Zia Ur Rehman, Kulachi', '6950.00', '', '020108');
INSERT INTO `xls_old_cust_bal` VALUES ('Kashmir Bakers Circular Road', '77555.00', '', '020108');

-- ----------------------------
-- Table structure for `xls_stk_bal`
-- ----------------------------
DROP TABLE IF EXISTS `xls_stk_bal`;
CREATE TABLE `xls_stk_bal` (
  `description` varchar(255) DEFAULT NULL,
  `qty` varchar(255) DEFAULT NULL,
  `rate` varchar(255) DEFAULT NULL,
  `amount` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of xls_stk_bal
-- ----------------------------
INSERT INTO `xls_stk_bal` VALUES ('1*10 Ltr Sarso Oil', '1', '1573.46', '1573.46');
INSERT INTO `xls_stk_bal` VALUES ('16kg Olien Cane', '2', '2005.59', '4011.17');
INSERT INTO `xls_stk_bal` VALUES ('17 KG SOAP', '7', '802.49', '5617.45');
INSERT INTO `xls_stk_bal` VALUES ('1 LTR OIL BOTTAL', '2', '212.12', '424.24');
INSERT INTO `xls_stk_bal` VALUES ('Achar 5kg Bucket', '2', '210', '420');
INSERT INTO `xls_stk_bal` VALUES ('Basin 40 Kg', '6', '3850', '23100');
INSERT INTO `xls_stk_bal` VALUES ('Bath Soap(Rs20 )', '21', '1085.71', '22800');
INSERT INTO `xls_stk_bal` VALUES ('Both Soap 48 Piece', '16', '1628.57', '26057.14');
INSERT INTO `xls_stk_bal` VALUES ('Can Empty', '215', '257.11', '55279.41');
INSERT INTO `xls_stk_bal` VALUES ('Chashma Soap 10 Kg.', '50', '567.86', '28393.21');
INSERT INTO `xls_stk_bal` VALUES ('Chashm Soap 13 Kg', '12', '619.34', '7432.04');
INSERT INTO `xls_stk_bal` VALUES ('China Salt', '4', '3992.41', '15969.63');
INSERT INTO `xls_stk_bal` VALUES ('Chokar 10 Kg Bag', '4', '233.28', '933.1');
INSERT INTO `xls_stk_bal` VALUES ('Chokar 15 Kg Bag', '32', '408.62', '13075.95');
INSERT INTO `xls_stk_bal` VALUES ('Chokar 30kg', '11', '773.5', '8508.5');
INSERT INTO `xls_stk_bal` VALUES ('Chola 25 Kg 933', '1', '4200', '4200');
INSERT INTO `xls_stk_bal` VALUES ('Chola 25 Kg Barma', '58', '3062.3', '177613.33');
INSERT INTO `xls_stk_bal` VALUES ('Chola 8mm 50 Kg', '24', '6702.25', '160853.88');
INSERT INTO `xls_stk_bal` VALUES ('Chola 9mm 50 Kg', '8', '8731.81', '69854.44');
INSERT INTO `xls_stk_bal` VALUES ('Cholaa 25 Kg Bag', '12', '2359.29', '28311.43');
INSERT INTO `xls_stk_bal` VALUES ('Cholaa 50 Kg Bag', '25', '5901.79', '147544.85');
INSERT INTO `xls_stk_bal` VALUES ('Coca Cola 1.5 Ltr', '35', '80', '2800');
INSERT INTO `xls_stk_bal` VALUES ('Daal Channa Supreem', '53', '4887.81', '259053.86');
INSERT INTO `xls_stk_bal` VALUES ('DAAL MASH 25 KG', '20', '3160.33', '63206.67');
INSERT INTO `xls_stk_bal` VALUES ('Daal Masoor 25 Kg', '62', '1474.68', '91430.1');
INSERT INTO `xls_stk_bal` VALUES ('Daal Matri', '14', '2215.38', '31015.38');
INSERT INTO `xls_stk_bal` VALUES ('Daal Mong 25 Kg', '85', '1857.74', '157907.77');
INSERT INTO `xls_stk_bal` VALUES ('Daal Mong Halki', '5', '5065.48', '25327.38');
INSERT INTO `xls_stk_bal` VALUES ('Daal Moong', '3', '4331.45', '12994.36');
INSERT INTO `xls_stk_bal` VALUES ('DAL CHANA HALKI', '8', '5000', '40000');
INSERT INTO `xls_stk_bal` VALUES ('Empty 16kg Cane', '2', '211.1', '422.19');
INSERT INTO `xls_stk_bal` VALUES ('Flour 20 Kg. Bag', '92', '689.57', '63440.02');
INSERT INTO `xls_stk_bal` VALUES ('Flour 40 Kg. Bag', '10', '1395.9', '13959');
INSERT INTO `xls_stk_bal` VALUES ('Flour 49 Kg Bag', '18', '1673.04', '30114.68');
INSERT INTO `xls_stk_bal` VALUES ('Gur 40kg Bag', '51', '2119.36', '108087.47');
INSERT INTO `xls_stk_bal` VALUES ('Hifazat Both Soap', '28', '2080.9', '58265.13');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 10 Kg Bucket', '29', '1424.91', '41322.5');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 10 Liter Oil Carton', '69', '1486.57', '102573.53');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 16 Kg Bucket', '35', '2359.33', '82576.61');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 16 Kg. Tin', '152', '2280.57', '346646.08');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 16 Liter Oil Tin', '77', '2408.22', '185432.73');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 2.5 Kg Bucket', '67', '369.41', '24750.19');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 2.5 Kg Can', '48', '357.85', '17176.84');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 3 Litre Bottle Carton', '25', '1782.5', '44562.5');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 5 Kg Can', '106', '691.84', '73334.61');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 5 Liter Bottle Carton', '13', '1491.49', '19389.37');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 5 Liter Dispenser', '155', '730.49', '113226.68');
INSERT INTO `xls_stk_bal` VALUES ('Kachi Basmati Rice25 Kg', '4', '2205.53', '8822.13');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir 10 Ltr Cane', '14', '1613.41', '22587.74');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir 12 Ltr Cortan', '135', '1931.81', '260793.75');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Bottle 3 Ltr Cortan', '8', '3053.16', '24425.28');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Bucket 10 Kg', '22', '1622.33', '35691.26');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Bucket 2.5 Kg', '39', '413.48', '16125.83');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Bucket 5 Kg', '38', '820.53', '31180.14');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Dispenser Ghee 5kg', '118', '803.45', '94807.1');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Dispenser Oil 5ltr', '160', '812.39', '129982.4');
INSERT INTO `xls_stk_bal` VALUES ('Kashmir Ghee 16kg Tin', '9', '2563', '23067');
INSERT INTO `xls_stk_bal` VALUES ('Khal 10 Kg Bag', '64', '433.02', '27713.36');
INSERT INTO `xls_stk_bal` VALUES ('Khal 18 Kg', '44', '757.99', '33351.34');
INSERT INTO `xls_stk_bal` VALUES ('Khal 40 Kg Bag', '52', '1676.99', '87203.67');
INSERT INTO `xls_stk_bal` VALUES ('Latif 12 Liter Oil Carton', '326', '1415.74', '461532.16');
INSERT INTO `xls_stk_bal` VALUES ('Latif 16kg Cortan', '104', '2155.83', '224206.62');
INSERT INTO `xls_stk_bal` VALUES ('Latif 16 Kg Tin', '628', '2169.16', '1362229.84');
INSERT INTO `xls_stk_bal` VALUES ('Latif 16 Ltr Oil Tin', '43', '2328.09', '100107.86');
INSERT INTO `xls_stk_bal` VALUES ('Latif 5 Kg Tin', '36', '688.67', '24792');
INSERT INTO `xls_stk_bal` VALUES ('Latif 5 Ltr Tin', '144', '725.76', '104510.12');
INSERT INTO `xls_stk_bal` VALUES ('Lobia 25 Kg B', '15', '3259', '48885');
INSERT INTO `xls_stk_bal` VALUES ('Maida 40 Kg Bag', '76', '1499.66', '113974.25');
INSERT INTO `xls_stk_bal` VALUES ('Maida 80 Kg. Bag', '12', '3083.46', '37001.47');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool 10kg Bucket', '18', '1216.65', '21899.66');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool 16kg Bucket', '18', '1955.08', '35191.52');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool 2.5kg Bucket', '89', '319.47', '28432.84');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool 2.5kg Tin', '33', '281.63', '9293.79');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool 5kg Bucket', '1', '628.48', '628.48');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool 5kg Tin', '15', '576.59', '8648.89');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool Cortan(1/2kg)', '24', '1865.17', '44764.04');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool Cortan(1/4kg)', '13', '1922.08', '24987.08');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool Cortan(1kg)', '100', '1866.26', '186625.59');
INSERT INTO `xls_stk_bal` VALUES ('Maqbool Tin', '70', '1876.32', '131342.6');
INSERT INTO `xls_stk_bal` VALUES ('Match RS 1', '1', '380', '380');
INSERT INTO `xls_stk_bal` VALUES ('Match Rs 2 Hook', '92', '721.74', '66399.63');
INSERT INTO `xls_stk_bal` VALUES ('MEEZA 10LTR CANE', '29', '1498.5', '43456.5');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 10 Kg Bucket', '6', '1457.79', '8746.75');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 10 Liter Oil', '38', '1414.11', '53736.14');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 16 Kg Tin', '84', '2192.86', '184200.37');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 16 Liter Oil Tin', '9', '2295', '20655');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 1 Liter Bottle Carton', '17', '745.23', '12668.86');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 2.5 Kg Bucket', '2', '344', '687.99');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 2.5 Kg Can', '24', '362.86', '8708.66');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 3 Liter Bottle Carton', '34', '2721.29', '92523.97');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 3 Ltr Bottal', '7', '419.39', '2935.73');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 5 Kg Bucket', '6', '683.53', '4101.2');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 5 Kg. Can', '9', '699.66', '6296.98');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 5 Litre Dispenser', '17', '698.56', '11875.59');
INSERT INTO `xls_stk_bal` VALUES ('Meezan 5 Ltr Bottal', '3', '516.43', '1549.3');
INSERT INTO `xls_stk_bal` VALUES ('Milk 25 Kg USA', '47', '8788.37', '413053.46');
INSERT INTO `xls_stk_bal` VALUES ('Millat 10 Kg Bucket', '82', '1219.34', '99986.23');
INSERT INTO `xls_stk_bal` VALUES ('Millat 16 Kg Bucket', '75', '1938.7', '145402.58');
INSERT INTO `xls_stk_bal` VALUES ('Millat 2.5 Kg Bucket', '30', '321.48', '9644.28');
INSERT INTO `xls_stk_bal` VALUES ('Millat 2.5 Kg Can', '111', '286.75', '31829.65');
INSERT INTO `xls_stk_bal` VALUES ('Millat 5 Kg Bucket', '144', '623.49', '89783.05');
INSERT INTO `xls_stk_bal` VALUES ('Millat 5 Kg Can', '182', '575.8', '104795.45');
INSERT INTO `xls_stk_bal` VALUES ('Millat Carton', '23', '1731.66', '39828.25');
INSERT INTO `xls_stk_bal` VALUES ('Millat Tin', '57', '1734.41', '98861.19');
INSERT INTO `xls_stk_bal` VALUES ('Olein Can 25 Kg', '105', '2917.67', '306355.43');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 100 Gram', '91', '798.68', '72679.96');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 10kg Bucket', '11', '1273.61', '14009.69');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 16 Kg Bucket', '3', '2042.74', '6128.21');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 16 Ltr Oil Tin', '24', '2167.74', '52025.71');
INSERT INTO `xls_stk_bal` VALUES ('RAHAT 2.5KG BUCKETS', '42', '347.15', '14580.11');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 2.5 Kg Can', '178', '293.36', '52218.06');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 5 Kg Can', '206', '597.15', '123013.86');
INSERT INTO `xls_stk_bal` VALUES ('Rahat 5 Ltr Dispencer', '8', '653.28', '5226.23');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Carton 1kg', '792', '1885.93', '1493656.13');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Carton 250 Gm P', '299', '1916.87', '573143.96');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Cortan 1/2 Kg', '409', '1895.87', '775411.09');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Rice 50 Kg Super Karnala', '67', '3783.6', '253500.89');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Tin', '572', '1900.96', '1087351.33');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Washing Powder 1 Kg', '1', '689.19', '689.19');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Washing Powder 20 Rs(36pack)', '261', '505.12', '131836.54');
INSERT INTO `xls_stk_bal` VALUES ('Rahat Washing Powder Rs 10', '134', '513.1', '68755.03');
INSERT INTO `xls_stk_bal` VALUES ('Rice 25 Kg IRRI 9', '109', '1360.13', '148253.81');
INSERT INTO `xls_stk_bal` VALUES ('Rice 25 Kg Kaiynat Multan', '33', '2186.76', '72163.24');
INSERT INTO `xls_stk_bal` VALUES ('Rice 50 Kg Bag', '5', '5444.19', '27220.94');
INSERT INTO `xls_stk_bal` VALUES ('Rice 50 Kg. KS-82', '44', '2190.45', '96379.68');
INSERT INTO `xls_stk_bal` VALUES ('Rice Ks82/25kg', '25', '1102.4', '27559.98');
INSERT INTO `xls_stk_bal` VALUES ('Rice Rahat 25 Kg Kainat', '878', '2446.14', '2147709.96');
INSERT INTO `xls_stk_bal` VALUES ('Rice Rahat 25 Kg Super Karnal', '94', '2052.33', '192919.42');
INSERT INTO `xls_stk_bal` VALUES ('Saleem Dish Wash Bar', '16', '290.91', '4654.54');
INSERT INTO `xls_stk_bal` VALUES ('Salt Bundle', '225', '41.29', '9290.76');
INSERT INTO `xls_stk_bal` VALUES ('Sarso Oil 26 Kg', '82', '3585.89', '294043.09');
INSERT INTO `xls_stk_bal` VALUES ('Shopper 25 Kg', '27', '5205.6', '140551.2');
INSERT INTO `xls_stk_bal` VALUES ('Soda 25 kg Bag', '18', '1160', '20880');
INSERT INTO `xls_stk_bal` VALUES ('Sooji 50 Kg Bag', '20', '1908.16', '38163.13');
INSERT INTO `xls_stk_bal` VALUES ('Starch Bag', '116', '3281.72', '380679.8');
INSERT INTO `xls_stk_bal` VALUES ('Sugar Bag', '494', '2686.19', '1326977.5');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 10kg Ghee Cortan', '214', '1430.93', '306218.53');
INSERT INTO `xls_stk_bal` VALUES ('Sultan 5 Kg Bucket', '60', '719.82', '43189.17');
INSERT INTO `xls_stk_bal` VALUES ('Tea 190 Grm Pack', '1', '85', '85');
INSERT INTO `xls_stk_bal` VALUES ('Wanda Bag 40 Kg', '3', '911.11', '2733.33');

-- ----------------------------
-- View structure for `a_dup_voucher`
-- ----------------------------
DROP VIEW IF EXISTS `a_dup_voucher`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `a_dup_voucher` AS select `cnlxidtp_click_kt`.`voucher`.`COMP_ID` AS `comp_id`,`cnlxidtp_click_kt`.`voucher`.`YEAR_ID` AS `year_id`,`cnlxidtp_click_kt`.`voucher`.`VOUCHER_ID` AS `voucher_id`,count(0) AS `count(*)` from `cnlxidtp_click_kt`.`voucher` group by `cnlxidtp_click_kt`.`voucher`.`COMP_ID`,`cnlxidtp_click_kt`.`voucher`.`YEAR_ID`,`cnlxidtp_click_kt`.`voucher`.`VOUCHER_ID` having (count(0) > 1) ;

-- ----------------------------
-- View structure for `a_dup_voucherdet`
-- ----------------------------
DROP VIEW IF EXISTS `a_dup_voucherdet`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `a_dup_voucherdet` AS select `cnlxidtp_click_kt`.`voucherdet`.`COMP_ID` AS `comp_id`,`cnlxidtp_click_kt`.`voucherdet`.`YEAR_ID` AS `year_id`,`cnlxidtp_click_kt`.`voucherdet`.`VOUCHER_ID` AS `voucher_id`,`cnlxidtp_click_kt`.`voucherdet`.`LINEITEM` AS `lineitem`,count(0) AS `count(*)` from `cnlxidtp_click_kt`.`voucherdet` group by `cnlxidtp_click_kt`.`voucherdet`.`COMP_ID`,`cnlxidtp_click_kt`.`voucherdet`.`YEAR_ID`,`cnlxidtp_click_kt`.`voucherdet`.`VOUCHER_ID`,`cnlxidtp_click_kt`.`voucherdet`.`LINEITEM` having (count(0) > 1) ;

-- ----------------------------
-- View structure for `v_current_qty`
-- ----------------------------
DROP VIEW IF EXISTS `v_current_qty`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_current_qty` AS select `v`.`comp_id` AS `comp_id`,`v`.`stock_code` AS `stock_code`,`v`.`db_qty` AS `db_qty`,`v`.`cr_qty` AS `cr_qty`,sum((ifnull(`v`.`db_qty`,0) - ifnull(`v`.`cr_qty`,0))) AS `bal_qty` from `cnlxidtp_click_kt`.`v_stk` `v` where ((1 = 1) and ((`v`.`db_qty` is not null) or (`v`.`cr_qty` is not null))) group by `v`.`comp_id`,`v`.`stock_code` ;

-- ----------------------------
-- View structure for `v_grp_item`
-- ----------------------------
DROP VIEW IF EXISTS `v_grp_item`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_grp_item` AS select 'KT' AS `comp_id`,`cnlxidtp_click_kt`.`item`.`stock_code` AS `stock_code`,`cnlxidtp_click_kt`.`item`.`description` AS `description`,`cnlxidtp_click_kt`.`item`.`p_rate` AS `p_rate`,`cnlxidtp_click_kt`.`item`.`s_rate` AS `s_rate` from `cnlxidtp_click_kt`.`item` union all select 'BT' AS `comp_id`,`cnlxidtp_click_kt`.`item`.`stock_code` AS `stock_code`,`cnlxidtp_click_kt`.`item`.`description` AS `description`,`cnlxidtp_click_kt`.`item`.`p_rate` AS `p_rate`,`cnlxidtp_click_kt`.`item`.`s_rate` AS `s_rate` from `cnlxidtp_click_kt`.`item` union all select 'IT' AS `comp_id`,`cnlxidtp_click_kt`.`item`.`stock_code` AS `stock_code`,`cnlxidtp_click_kt`.`item`.`description` AS `description`,`cnlxidtp_click_kt`.`item`.`p_rate` AS `p_rate`,`cnlxidtp_click_kt`.`item`.`s_rate` AS `s_rate` from `cnlxidtp_click_kt`.`item` ;

-- ----------------------------
-- View structure for `v_item`
-- ----------------------------
DROP VIEW IF EXISTS `v_item`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_item` AS select `i`.`stock_code` AS `stock_code`,concat(`i`.`description`,' - ',convert(`c`.`CAT_NAME` using utf8)) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate` from (`cnlxidtp_click_kt`.`item` `i` left join `cnlxidtp_click_kt`.`prod_cat` `c` on((`i`.`cat_id` = `c`.`CAT_ID`))) ;

-- ----------------------------
-- View structure for `v_item_bal`
-- ----------------------------
DROP VIEW IF EXISTS `v_item_bal`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_item_bal` AS select `i`.`stock_code` AS `stock_code`,concat(`i`.`description`,'-',convert(`c`.`COMP_NAME` using utf8),'-',round(`v`.`bal_qty`,0)) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`v`.`bal_qty` AS `bal_qty` from ((`cnlxidtp_click_kt`.`item` `i` left join `cnlxidtp_click_kt`.`v_current_qty` `v` on((`i`.`stock_code` = `v`.`stock_code`))) left join `cnlxidtp_click_kt`.`company` `c` on((`v`.`comp_id` = `c`.`COMP_ID`))) ;

-- ----------------------------
-- View structure for `v_party`
-- ----------------------------
DROP VIEW IF EXISTS `v_party`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_party` AS select `n`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name`,if((convert(substr(1,6) using latin1) = `s`.`creditor_id`),'S','C') AS `party_type` from (`nom` `n` join `system` `s`) where ((substr(`n`.`ACCT_ID`,1,6) in (`s`.`creditor_id`,`s`.`debtor_id`)) and (length(`n`.`ACCT_ID`) = 10)) ;

-- ----------------------------
-- View structure for `v_party_bal`
-- ----------------------------
DROP VIEW IF EXISTS `v_party_bal`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_party_bal` AS select `v`.`party_id` AS `party_id`,sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) AS `bal_amt` from `cnlxidtp_click_kt`.`v_p_vouchers` `v` group by `v`.`party_id` having (sum((ifnull(`v`.`db_amt`,0) - ifnull(`v`.`cr_amt`,0))) <> 0) ;

-- ----------------------------
-- View structure for `v_p_vouchers`
-- ----------------------------
DROP VIEW IF EXISTS `v_p_vouchers`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_p_vouchers` AS select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,concat(`p`.`acct_name`,' / ',`l`.`loc_name`) AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('RT',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_return` `m` left join `sl_returndet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SD',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`acct_name` AS `party_name`,NULL AS `lineitem`,NULL AS `stock_code`,'Discount' AS `stock_name`,NULL AS `rate`,0 AS `db_qty`,0 AS `db_amt`,NULL AS `cr_qty`,`m`.`disc_amt` AS `cr_amt` from (`sl_invoice` `m` left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) where (`m`.`disc_amt` <> 0) union all select `m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `v_party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) ;

-- ----------------------------
-- View structure for `v_stk`
-- ----------------------------
DROP VIEW IF EXISTS `v_stk`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_stk` AS select `m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('PL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from ((((`pl_invoice` `m` left join `pl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) union all select `m`.`loc_id` AS `loc_id`,`l`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('SL',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,`m`.`acct_id` AS `party_id`,`p`.`ACCT_NAME` AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`avg_rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,(`d`.`avg_rate` * `d`.`qty`) AS `cr_amt` from ((((`sl_invoice` `m` left join `sl_invoicedet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) left join `location` `l` on((`m`.`loc_id` = `l`.`loc_id`))) where (`m`.`voucher_id` not in ('145','148','080002')) union all select `m`.`loc_id` AS `loc_id`,`m`.`comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,concat('ST',`m`.`voucher_id`) AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,0 AS `db_qty`,0 AS `db_amt`,`d`.`qty` AS `cr_qty`,`d`.`itemtot` AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `nom` `p` on((`m`.`acct_id` = `p`.`ACCT_ID`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) union all select `m`.`loc_id` AS `loc_id`,`m`.`to_comp_id` AS `comp_id`,`m`.`year_id` AS `year_id`,`m`.`voucher_id` AS `voucher_id`,`m`.`voucher_date` AS `voucher_date`,'0021' AS `party_id`,'STOCK TRANSFER' AS `party_name`,`d`.`lineitem` AS `lineitem`,`d`.`stock_code` AS `stock_code`,`i`.`description` AS `stock_name`,`d`.`rate` AS `rate`,`d`.`qty` AS `db_qty`,`d`.`itemtot` AS `db_amt`,0 AS `cr_qty`,0 AS `cr_amt` from (((`sl_gp` `m` left join `sl_gpdet` `d` on(((`m`.`comp_id` = `d`.`comp_id`) and (`m`.`year_id` = `d`.`year_id`) and (`m`.`voucher_id` = `d`.`voucher_id`)))) left join `party` `p` on((`m`.`acct_id` = `p`.`acct_id`))) left join `item` `i` on((`d`.`stock_code` = `i`.`stock_code`))) ;

-- ----------------------------
-- View structure for `v_vouchers`
-- ----------------------------
DROP VIEW IF EXISTS `v_vouchers`;
CREATE ALGORITHM=UNDEFINED DEFINER=`cnlxidtp`@`localhost` SQL SECURITY DEFINER VIEW `v_vouchers` AS select (case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then concat('Sales-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then concat('Purchase-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CP') then concat('Cash Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'CR') then concat('Cash Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BP') then concat('Bank Payment-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'BR') then concat('Bank Receipt-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then concat('Journal-',`v`.`COMP_ID`) when (substr(`v`.`VOUCHER_ID`,1,2) = 'ST') then concat('Stock Transfer-',`v`.`COMP_ID`) else '' end) AS `voucher_type`,(case when (substr(`v`.`VOUCHER_ID`,1,2) = 'SL') then 1 when (substr(`v`.`VOUCHER_ID`,2,1) = 'R') then 2 when (substr(`v`.`VOUCHER_ID`,2,1) = 'P') then 3 when (substr(`v`.`VOUCHER_ID`,1,2) = 'PL') then 4 when (substr(`v`.`VOUCHER_ID`,1,2) = 'JV') then 5 else 9 end) AS `voucher_order`,`v`.`COMP_ID` AS `comp_id`,concat(`v`.`COMP_ID`,`v`.`VOUCHER_ID`,'/',`vd`.`LINEITEM`) AS `voucher_id`,NULL AS `inv_no`,NULL AS `description`,`v`.`VOUCHER_DATE` AS `voucher_date`,`vd`.`LINEITEM` AS `lineitem`,`vd`.`ACCT_ID` AS `acct_id`,`v`.`ACCT_ID_CS_1` AS `acct_id_cs_1`,`v`.`ACCT_ID_CS_2` AS `acct_id_cs_2`,if((`vd`.`credit` < 0),-(`vd`.`credit`),if((`vd`.`debit` > 0),`vd`.`debit`,0)) AS `debit`,if((`vd`.`debit` < 0),-(`vd`.`debit`),if((`vd`.`credit` > 0),`vd`.`credit`,0)) AS `credit`,`n`.`ACCT_NAME` AS `acct_name`,`vd`.`PARTICULARS` AS `particulars`,`v`.`POSTED` AS `posted` from ((`voucher` `v` left join `voucherdet` `vd` on(((`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`) and (`v`.`COMP_ID` = `vd`.`COMP_ID`) and (`v`.`YEAR_ID` = `vd`.`YEAR_ID`)))) left join `nom` `n` on((`vd`.`ACCT_ID` = `n`.`ACCT_ID`))) where (`v`.`POSTED` = 'on') ;

-- ----------------------------
-- Function structure for `f_pl_invoice_products`
-- ----------------------------
DROP FUNCTION IF EXISTS `f_pl_invoice_products`;
DELIMITER ;;
CREATE DEFINER=`cnlxidtp`@`localhost` FUNCTION `f_pl_invoice_products`(`p_comp_id` VARCHAR(2), `p_voucher_id` VARCHAR(10)) RETURNS text CHARSET latin1
    NO SQL
    DETERMINISTIC
BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from pl_invoicedet d left join item i on 

d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.voucher_id=p_voucher_id order by d.itemtot desc;

DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
 
RETURN (substring(cProd_Name,3));
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for `f_sl_invoice_products`
-- ----------------------------
DROP FUNCTION IF EXISTS `f_sl_invoice_products`;
DELIMITER ;;
CREATE DEFINER=`cnlxidtp`@`localhost` FUNCTION `f_sl_invoice_products`(`p_comp_id` VARCHAR(2), `p_voucher_id` VARCHAR(10)) RETURNS text CHARSET latin1
    NO SQL
    DETERMINISTIC
BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from sl_invoicedet d left join item i on 

d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.voucher_id=p_voucher_id;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
 
RETURN (substring(cProd_Name,3));
END
;;
DELIMITER ;
