\\\ Update average rates from local server
UPDATE sl_invoicedet a
INNER JOIN cs_sl_invoicedet b ON a.comp_id=b.comp_id and a.year_id=b.year_id and a.voucher_id=b.voucher_id and a.lineitem=b.lineitem
SET a.avg_rate = b.avg_rate;

UPDATE sl_gpdet a
INNER JOIN cs_sl_gpdet b ON a.comp_id=b.comp_id and a.year_id=b.year_id and a.voucher_id=b.voucher_id and a.lineitem=b.lineitem
SET a.avg_rate = b.avg_rate;

\\\ Allow users reports
drop table user_rep;
create table user_rep select * from cnlxidtp_click_kt.user_rep;
\\\\\\ Delete accounts
delete from nom where acct_id in('1901000000','0520002003','0520002002');

\\\\\\ Add user menu rights
Delete from users_menu where emp_id ='wellcome';
Insert into users_menu(emp_id, menu_id) select 'wellcome', menu_id from users_menu 
where emp_id ='click';

\\\\\ Shift entries to new year_id
update sl_invoicedet set year_id='18' where concat(comp_id,year_id,voucher_id) in(select concat(comp_id,year_id,voucher_id) from sl_invoice where voucher_date='2018-01-01');
update sl_invoice set year_id='18' where voucher_date='2018-01-01';

update sl_gpdet set year_id='18' where concat(comp_id,year_id,voucher_id) in(select concat(comp_id,year_id,voucher_id) from sl_gp where voucher_date='2018-01-01');
update sl_gp set year_id='18' where voucher_date='2018-01-01';

update voucherdet set year_id='18' where concat(comp_id,year_id,voucher_id) in(select concat(comp_id,year_id,voucher_id) from voucher where voucher_date='2018-01-01');
update voucher set year_id='18' where voucher_date='2018-01-01';

\\\\\\\\
UPDATE nom v
INNER JOIN xls_distributors vd 
ON v.ACCT_NAME=vd.acct_name
SET v.page_no = vd.p_no;
\\\\\\\
update nom set acct_type='6101' where substr(acct_id,1,6)='200001';
update nom set acct_type='6101' where substr(acct_id,1,6)='200010';
update nom set acct_type='8101' where substr(acct_id,1,6)='400001';
insert into nom select * from cnlxidtp_click_origa.nom where substr(acct_id,1,2)='27';
\\\\ Acct Types
update acct_type set acct_name=substr(acct_name,8) where substr(acct_name,1,7)='LNCL - ';
update acct_type set acct_name=substr(acct_name,6) where substr(acct_name,1,5)='LCL - ';
update acct_type set acct_name=substr(acct_name,4) where substr(acct_name,1,3)='E - ';
update acct_type set acct_name=substr(acct_name,7) where substr(acct_name,1,7)='ANCA - ';
update acct_type set acct_name=substr(acct_name,7) where substr(acct_name,1,6)='ACA - ';
update acct_type set acct_name=trim(acct_name);

\\\\ Clear Negative Stock Balances
delete from pl_invoicedet where voucher_id='090002';
delete from pl_invoice where voucher_id='090002';
insert into pl_invoice(comp_id, year_id,voucher_id, voucher_date, acct_id, loc_id, posted) values('01','17','090002','2017-09-01','9000010001', '01', 'on');

set @ser:=0;
insert into pl_invoicedet(comp_id, year_id,voucher_id, lineitem, stock_code, qty, rate, itemtot)
select '01','17','090002',lpad(@ser := @ser +1,3,'0'), x.stock_code, -x.bal_qty, -x.bal_amt/x.bal_qty, -x.bal_amt
from xls_item_bal x;

insert into pl_invoicedet(comp_id, year_id,voucher_id, lineitem, stock_code, qty, rate, itemtot)
select '01','17','090002',lpad(@ser := @ser +1,3,'0'), '0650', -8, 5, -40

delete from pl_invoicedet where voucher_id='090003';
delete from pl_invoice where voucher_id='090003';
insert into pl_invoice(comp_id, year_id,voucher_id, voucher_date, acct_id, loc_id, posted) values('01','17','090003','2017-09-01','9000010001', '01', 'on');

set @ser:=0;
insert into pl_invoicedet(comp_id, year_id,voucher_id, lineitem, stock_code, qty, rate, itemtot)
select '01','17','090003',lpad(@ser := @ser +1,3,'0'), x.stock_code, -x.bal_qty, -x.bal_amt/x.bal_qty, -x.bal_amt
from xls_item_bal2 x;

set @ser:=44;
insert into pl_invoicedet(comp_id, year_id,voucher_id, lineitem, stock_code, qty, rate, itemtot)
select '01','17','090003',lpad(@ser := @ser +1,3,'0'), '0785', -4, 0, 0;
insert into pl_invoicedet(comp_id, year_id,voucher_id, lineitem, stock_code, qty, rate, itemtot)
select '01','17','090003',lpad(@ser := @ser +1,3,'0'), '0224', -2, 0, 0;


\\\\\\ Delete Vouchers
\\ Delete Orphin
delete
from voucherdet where concat(comp_id, year_id, voucher_id) not in
(
select v_id
from
(
(select concat(d.comp_id, d.year_id, d.voucher_id) v_id
from voucher d
)) v);

delete
from voucher where concat(comp_id, year_id, voucher_id) in
(
select v_id
from
(
(select concat(d.comp_id, d.year_id, d.voucher_id) v_id
from voucher d
left join voucherdet m on m.comp_id=d.comp_id and m.year_id=d.year_id and m.voucher_id=d.voucher_id
where m.voucher_id is null)) v);

delete from voucherdet
where concat(comp_id,year_id,voucher_id) not in(select concat(comp_id,year_id,voucher_id) from voucher);


delete from voucherdet where comp_id='02' and voucher_id in('CP17','JV14','JV20');


Delete from voucherdet where substr(voucher_id,1,2)='SL';
Delete from voucher where substr(voucher_id,1,2)='SL';

\\\\\\
UPDATE nom n
INNER JOIN regions o ON upper(trim(n.city)) = upper(trim(o.reg_name))
SET n.reg_id = o.reg_id;

update nom set city=substr(city,1,length(city)-1) where substr(city,-1)='.';

update nom set city='Islamabad' where city='Isalmabad';
update nom set city='Ali Pur Chatha' where city='Ali Pur Chattha';
update nom set city='Bhakkar' where city='Bhakkhar';
update nom set city='Burewala' where city='Borewala';
update nom set city='D.I.Khan' where city='D.I Khan';
update nom set city='D.I.Khan' where city='Dera Ismail Khan';
update nom set city='Jouharabad' where city='JoharAbad';
update nom set city='Nankana Sahib' where city='Nannkana Sahib';
update nom set city='Pir Mehal' where city='Pir Mehel';
update nom set city='Sargodha' where city='Sarghodha';
update nom set city='Wah Cantt' where city='Wah cant';

create table xls_city as select distinct city from nom;



\\\\\\\\\\\ Menu
Insert into menu(menu_id, menu_name) values(5.5, 'Category');

\\\\\\\\\\\ Allow User Menu
Delete from users_menu where emp_id='click';
INSERT INTO `users_menu` (`emp_id`, `menu_id`, `inactive`, `insert_allowed`, `update_allowed`, `delete_allowed`) select 'click', menu_id, 'N', 'Y', 'Y', 'Y' from menu;


INSERT INTO `users_menu` (`emp_id`, `menu_id`, `inactive`, `insert_allowed`, `update_allowed`, `delete_allowed`) VALUES ('kt', '5.3', 'N', 'Y', 'Y', 'Y');






\\\\\\\\\\\ Create new table
DROP TABLE prod;
CREATE TABLE `prod` (
  `voucher_id` varchar(10) NOT NULL DEFAULT '',
  `voucher_date` date DEFAULT NULL,
  `acct_id` varchar(10) NOT NULL DEFAULT '',
  `net_amt` decimal(13,2) DEFAULT NULL,
  `bill_no` varchar(10) NOT NULL,
  `bill_date` date DEFAULT NULL,
  `inv_no` varchar(10) DEFAULT NULL,
  `inv_date` date DEFAULT NULL,
  `loc_id` char(2) NOT NULL DEFAULT '',
  `particulars` varchar(200) DEFAULT NULL,
  `post_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `comp_id` varchar(2) NOT NULL DEFAULT '',
  `year_id` varchar(2) NOT NULL,
  `posted` char(2) DEFAULT NULL,
  `emp_id` varchar(20) NOT NULL,
  PRIMARY KEY (`comp_id`,`year_id`,`voucher_id`),
  KEY `index_prod` (`comp_id`,`year_id`,`voucher_id`) USING BTREE,
  KEY `sl_gp_fk_loc_id` (`loc_id`),
  KEY `sl_gp_fk_acct_id` (`acct_id`),
  KEY `sl_gp_fk_year_id` (`year_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

\\\\\\\\\\\ Update sale invoice net amount

UPDATE sl_invoice v
INNER JOIN (select concat(comp_id, year_id, voucher_id) v_id, sum(stax) stax, sum(itemtot) itemtot 
from sl_invoicedet group by concat(comp_id, year_id, voucher_id)) vd 
ON concat(v.comp_id, v.year_id, v.voucher_id) = vd.v_id
SET v.stax = vd.stax;

UPDATE sl_invoice v
INNER JOIN (select concat(comp_id, year_id, voucher_id) v_id, sum(stax) stax, sum(itemtot) itemtot 
from sl_invoicedet group by concat(comp_id, year_id, voucher_id)) vd 
ON concat(v.comp_id, v.year_id, v.voucher_id) = vd.v_id
SET v.net_amt = (ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0)+ifnull(v.dc_amt,0));

\\\\\\\\\\\ Update purchase invoice net amount
UPDATE pl_invoice v
INNER JOIN (select concat(comp_id, year_id, voucher_id) v_id, sum(itemtot) itemtot 
from pl_invoicedet group by concat(comp_id, year_id, voucher_id)) vd 
ON concat(v.comp_id, v.year_id, v.voucher_id) = vd.v_id
SET v.net_amt = (ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0)+ifnull(v.dc_amt,0));

\\\\\\\\\\\
ALTER TABLE cnlxidtp_click_bk.sl_return ADD `emp_id` VARCHAR(20) NOT NULL;
ALTER TABLE cnlxidtp_click_madni.sl_return ADD `emp_id` VARCHAR(20) NOT NULL;


\\\\\\\ Add Report
INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('rpt_sl', 'Sale Report By Product - Qty Wise', '2', 'Y', '047');

INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('cs_profit_loss', 'Cost Center - Profit & Loss', '1', 'Y', '045');
INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('cs_ledger', 'Cost Center - Ledger', '1', 'Y', '044');


INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('rpt_stock_balances_color_size', 'Stock Balances - Color/Size Wise', '4', 'Y', '043');
INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('rpt_stock_summary_color_size', 'Stock Summary - Color/Size Wise', '2', 'Y', '043');

INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('rpt_sl', 'Sale Report By Product - Qty Wise', '2', 'Y', '042');
INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('rpt_sl', 'Sale Report By Product - Amount Wise', '2', 'Y', '041');


INSERT INTO reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('party_balances', 'Customers Balances', '2', 'Y', '024');

Delete from cnlxidtp_click_bk.reports where rep_id='023';
INSERT INTO cnlxidtp_click_bk.reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('sp_sale_report', 'Sales Persons Sale Due Report', '2', 'Y', '023');


Delete from cnlxidtp_click_kt.reports where rep_id='019';
INSERT INTO cnlxidtp_click_madni.reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('report_sales', 'Sale Report', '3', 'Y', '019');

Delete from cnlxidtp_click_kt.reports where rep_id='019';
INSERT INTO cnlxidtp_click_kt.reports (`FILE_NAME`, `REPORT_NAME`, `CAT`, `LANDSCAPE`, `REP_ID`) VALUES ('report_sales', 'Sale Report', '3', 'Y', '019');


\\\\\\\\\
update cnlxidtp_click_kt.pl_invoice set emp_id='kt';
update cnlxidtp_click_kt.pl_invoice set emp_id='rashid';


create table backup_sl_invoice as select * from sl_invoice;
create table backup_sl_invoicedet as select * from sl_invoicedet;


\\\\\\\\\\\\\\\
delete from voucherdet where substring(voucher_id,1,2)='SL';
delete from voucher where substring(voucher_id,1,2)='SL';

create table bak_voucher as select * from voucher where year_id='16';
create table bak_voucherdet as select * from voucherdet where concat(comp_id,year_id,voucher_id) in(select concat(comp_id,year_id,voucher_id) from voucher where year_id='16');

delete from voucherdet where concat(comp_id,year_id,voucher_id) in(select concat(comp_id,year_id,voucher_id) from voucher where year_id='16');
delete from voucher where year_id='16';

delete from voucherdet where comp_id not in(select comp_id from company);
delete from voucher where comp_id not in(select comp_id from company);

\\\\\\\\\\\\\\\\\\
Insert into reports values('party_trial','Trial',2, '', '020');

update`sl_invoicedet` set rate=itemtot/qty WHERE rate<> itemtot/qty;


\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
CREATE OR REPLACE VIEW v_stk as

SELECT
	`m`.`loc_id` AS `loc_id`,
	`l`.`comp_id` AS `comp_id`,
	`m`.`year_id` AS `year_id`,
	concat('PL', `m`.`voucher_id`) AS `voucher_id`,
	`m`.`voucher_date` AS `voucher_date`,
	`m`.`acct_id` AS `party_id`,
	`p`.`ACCT_NAME` AS `party_name`,
	`d`.`lineitem` AS `lineitem`,
	`d`.`stock_code` AS `stock_code`,
	`i`.`description` AS `stock_name`,
	`d`.`rate` AS `rate`,
	`d`.`qty` AS `db_qty`,
	`d`.`itemtot` AS `db_amt`,
	0 AS `cr_qty`,
	0 AS `cr_amt`
FROM
	(
		(
			(
				`cnlxidtp_click_kt`.`pl_invoice` `m`
				LEFT JOIN `cnlxidtp_click_kt`.`pl_invoicedet` `d` ON (
					(
						(
							`m`.`comp_id` = `d`.`comp_id`
						)
						AND (
							`m`.`year_id` = `d`.`year_id`
						)
						AND (
							`m`.`voucher_id` = `d`.`voucher_id`
						)
					)
				)
			)
			LEFT JOIN `cnlxidtp_click_kt`.`nom` `p` ON (
				(
					`m`.`acct_id` = `p`.`ACCT_ID`
				)
			)
		)
		LEFT JOIN `cnlxidtp_click_kt`.`item` `i` ON (
			(
				`d`.`stock_code` = `i`.`stock_code`
			)
		)
	)
	LEFT JOIN location l on m.loc_id=l.loc_id
UNION ALL
	SELECT
		`m`.`loc_id` AS `loc_id`,
		`l`.`comp_id` AS `comp_id`,
		`m`.`year_id` AS `year_id`,
		concat('SL', `m`.`voucher_id`) AS `voucher_id`,
		`m`.`voucher_date` AS `voucher_date`,
		`m`.`acct_id` AS `party_id`,
		`p`.`ACCT_NAME` AS `party_name`,
		`d`.`lineitem` AS `lineitem`,
		`d`.`stock_code` AS `stock_code`,
		`i`.`description` AS `stock_name`,
		`d`.`rate` AS `rate`,
		0 AS `db_qty`,
		0 AS `db_amt`,
		`d`.`qty` AS `cr_qty`,
		`d`.`itemtot` AS `cr_amt`
	FROM
		(
			(
				(
					`cnlxidtp_click_kt`.`sl_invoice` `m`
					LEFT JOIN `cnlxidtp_click_kt`.`sl_invoicedet` `d` ON (
						(
							(
								`m`.`comp_id` = `d`.`comp_id`
							)
							AND (
								`m`.`year_id` = `d`.`year_id`
							)
							AND (
								`m`.`voucher_id` = `d`.`voucher_id`
							)
						)
					)
				)
				LEFT JOIN `cnlxidtp_click_kt`.`nom` `p` ON (
					(
						`m`.`acct_id` = `p`.`ACCT_ID`
					)
				)
			)
			LEFT JOIN `cnlxidtp_click_kt`.`item` `i` ON (
				(
					`d`.`stock_code` = `i`.`stock_code`
				)
			)
		)
	LEFT JOIN location l on m.loc_id=l.loc_id

	UNION ALL
		SELECT
			`m`.`loc_id` AS `loc_id`,
			`m`.`comp_id` AS `comp_id`,
			`m`.`year_id` AS `year_id`,
			concat('ST', `m`.`voucher_id`) AS `voucher_id`,
			`m`.`voucher_date` AS `voucher_date`,
			'0021' AS `party_id`,
			'STOCK TRANSFER' AS `party_name`,
			`d`.`lineitem` AS `lineitem`,
			`d`.`stock_code` AS `stock_code`,
			`i`.`description` AS `stock_name`,
			`d`.`rate` AS `rate`,
			0 AS `db_qty`,
			0 AS `db_amt`,
			`d`.`qty` AS `cr_qty`,
			`d`.`itemtot` AS `cr_amt`
		FROM
			(
				(
					(
						`cnlxidtp_click_kt`.`sl_gp` `m`
						LEFT JOIN `cnlxidtp_click_kt`.`sl_gpdet` `d` ON (
							(
								(
									`m`.`comp_id` = `d`.`comp_id`
								)
								AND (
									`m`.`year_id` = `d`.`year_id`
								)
								AND (
									`m`.`voucher_id` = `d`.`voucher_id`
								)
							)
						)
					)
					LEFT JOIN `cnlxidtp_click_kt`.`nom` `p` ON (
						(
							`m`.`acct_id` = `p`.`ACCT_ID`
						)
					)
				)
				LEFT JOIN `cnlxidtp_click_kt`.`item` `i` ON (
					(
						`d`.`stock_code` = `i`.`stock_code`
					)
				)
			)

		UNION ALL
			SELECT
				`m`.`loc_id` AS `loc_id`,
				`m`.`to_comp_id` AS `comp_id`,
				`m`.`year_id` AS `year_id`,
				`m`.`voucher_id` AS `voucher_id`,
				`m`.`voucher_date` AS `voucher_date`,
				'0021' AS `party_id`,
				'STOCK TRANSFER' AS `party_name`,
				`d`.`lineitem` AS `lineitem`,
				`d`.`stock_code` AS `stock_code`,
				`i`.`description` AS `stock_name`,
				`d`.`rate` AS `rate`,
				`d`.`qty` AS `db_qty`,
				`d`.`itemtot` AS `db_amt`,
				0 AS `cr_qty`,
				0 AS `cr_amt`
			FROM
				(
					(
						(
							`cnlxidtp_click_kt`.`sl_gp` `m`
							LEFT JOIN `cnlxidtp_click_kt`.`sl_gpdet` `d` ON (
								(
									(
										`m`.`comp_id` = `d`.`comp_id`
									)
									AND (
										`m`.`year_id` = `d`.`year_id`
									)
									AND (
										`m`.`voucher_id` = `d`.`voucher_id`
									)
								)
							)
						)
						LEFT JOIN `cnlxidtp_click_kt`.`party` `p` ON (
							(
								`m`.`acct_id` = `p`.`acct_id`
							)
						)
					)
					LEFT JOIN `cnlxidtp_click_kt`.`item` `i` ON (
						(
							`d`.`stock_code` = `i`.`stock_code`
						)
					)
				)	

\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
create or replace view v_item as
select `i`.`stock_code` AS `stock_code`,concat(`i`.`description`,' - ',`c`.`CAT_NAME`) AS `description`,`i`.`s_rate` AS `s_rate`,`i`.`p_rate` AS `p_rate`,`v`.`bal_qty` AS `bal_qty` from ((`cnlxidtp_click_kt`.`item` `i` left join `cnlxidtp_click_kt`.`prod_cat` `c` on((`i`.`cat_id` = `c`.`CAT_ID`))) left join `cnlxidtp_click_kt`.`v_current_qty` `v` on((`i`.`stock_code` = `v`.`stock_code`)))

\\\\\\\\\\
create or replace VIEW v_item as
SELECT
    i.stock_code,
	concat(i.description,' - ',c.cat_name) description,
	i.s_rate,
	i.p_rate,
	v.bal_qty
	
FROM
	item i
	 LEFT JOIN prod_cat c on i.cat_id=c.cat_id
	 LEFT JOIN v_current_qty v ON i.stock_code = v.stock_code

\\\\\\\\\\\\\\\
delete from voucherdet where substr(voucher_id,1,2)='PL';
delete from voucher where substr(voucher_id,1,2)='PL';

\\\\\\\\\\\\\\
create or replace view v_voucherdet_pay as
select `d`.`VOUCHER_ID` AS `voucher_id`,concat(`d`.`LINEITEM`,'.') AS `lineitem`,`d`.`ACCT_ID` AS `acct_id`,`n`.`ACCT_NAME` AS `acct_name` 
from (`cnlxidtp_click_kt`.`voucherdet` `d` 
left join `cnlxidtp_click_kt`.`nom` `n` on((`d`.`ACCT_ID` = `n`.`ACCT_ID`)))
 where (substr(`d`.`LINEITEM`,-(1)) <> '.');


\\\\\\\\\\\\\\\\
BEGIN

DECLARE done INT DEFAULT FALSE;
DECLARE cProd_Name text;
declare description text;

declare mycur cursor for select ifnull(i.description,'') description from sl_invoicedet d left join item i on d.stock_code=i.stock_code where d.comp_id=p_comp_id and d.voucher_id=p_voucher_id;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
set cProd_Name='';
set description='';

open mycur;

read_loop: loop
fetch mycur into description;
IF done THEN
   LEAVE read_loop;
END IF;
set cProd_Name=concat(cProd_Name , ', ',description);
end loop;
close mycur;
	
 RETURN (cProd_Name);
END

\\\\\\\\\\\\\\\\\
update item set type_id='99';
update item set type_id='01' where upper(description) like '%MAQBOOL%';
update item set type_id='02' where upper(description) like '%MEEZAN%';
update item set type_id='03' where upper(description) like '%Rahat%';
update item set type_id='04' where upper(description) like '%SULTAN%';

UPDATE item i
INNER JOIN (select stock_code, max(rate) rate from sl_invoicedet group by stock_code) s ON i.stock_code = s.stock_code
SET i.s_rate = s.rate;

UPDATE item i
INNER JOIN (select stock_code, max(rate) rate from pl_invoicedet group by stock_code) s ON i.stock_code = 

s.stock_code
SET i.p_rate = s.rate;

\\\\\\\ Allow Menu
\\\ copy user menu
insert into users_menu select 'admin', menu_id, inactive, insert_allowed, update_allowed, delete_allowed from users_menu where emp_id='click';

delete from users_menu where emp_id='Guest';
insert into users_menu(emp_id, menu_id) select 'Guest', menu_id from menu;


delete from users_menu where emp_id='admin';
insert into users_menu(emp_id, menu_id) select 'admin', menu_id from menu;
Delete from users_comp where emp_id='admin';
Insert into users_comp(emp_id, comp_id) select 'admin', comp_id from company;
Insert into users(emp_id, emp_name, password, auth_id) values('admin','Administrator','admin','9');