<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


/*****************START VARIABLES***************/
$_SESSION['voucher_type'] = clean_data($_GET['voucher_type']);
$voucher_type = clean_data($_SESSION['voucher_type']);
$comp_id = clean_data($_SESSION["comp_id"]);
$comp_name = clean_data($_SESSION["COMP_NAME"]);
$phone = clean_data($_SESSION["phone"]);
$address = clean_data($_SESSION["address"]);
$_SESSION['v_id']= $_GET['v_id'];
$v_id = clean_data($_SESSION['v_id']);
/*****************END VARIABLES***************/


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $_SESSION['voucher_type'] = clean_data($_GET['voucher_type']);
        $voucher_type = clean_data($_SESSION['voucher_type']);
        $comp_id = clean_data($_SESSION["comp_id"]);
        $comp_name = clean_data($_SESSION["COMP_NAME"]);
        $phone = clean_data($_SESSION["phone"]);
        $address = clean_data($_SESSION["address"]);
        $_SESSION['v_id']= $_GET['v_id'];
        $v_id = clean_data($_SESSION['v_id']);

        // Logo
        //$this->Image('assets/images/logo.png',10,6,20);
        $this->SetFont('Arial','B',12);
        // Move to the right
        $this->Cell(65);
        $this->Cell(60, 5, strtoupper($comp_name), 0,2, 'C');


        $this->SetFont('Arial','B',7);
        $this->Cell(60, 5, ($address), 0,1, 'C');

        $this->Cell(65);
        $this->Cell(60, 5, ($phone), 0,1, 'C');



        // Line break
        $this->Ln(10);




        /*****************START MASTER TABLE QUERY*****************/

        /*****************START VARIABLES***************/
        include("include/dbconnect.php");
        $_SESSION['voucher_type'] = clean_data($_GET['voucher_type']);
        $voucher_type = clean_data($_SESSION['voucher_type']);
        $comp_id = clean_data($_SESSION["comp_id"]);
        $comp_name = clean_data($_SESSION["COMP_NAME"]);
        $phone = clean_data($_SESSION["phone"]);
        $address = clean_data($_SESSION["address"]);
        $_SESSION['v_id']= $_GET['v_id'];
        $v_id = clean_data($_SESSION['v_id']);


        $and = " AND d.voucher_id = '$v_id'";
        $and .= " AND v.comp_id = '$comp_id'";

        try
        {
            $voucher_query =  "SELECT v.acct_id, v.voucher_id, v.voucher_date, d.particulars , c.comp_name,c.add_line1,c.phone,c.email, p.acct_name,  v.discp, v.adv_amt, v.net_amt
	FROM pl_invoice v 
	LEFT JOIN pl_invoicedet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id AND v.year_id = d.year_id
	LEFT JOIN company c ON c.comp_id = d.comp_id
	LEFT JOIN v_party p ON p.acct_id = v.acct_id
	
	WHERE 1=1  $and";
            $voucher_result = $dbcon->prepare($voucher_query);
            $voucher_result->execute(array());
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }





        $report_row = $voucher_result->fetch(PDO::FETCH_ASSOC);


        $discp = $report_row['discp'];
        $adv_amt = $report_row['adv_amt'];

        $this->SetFont('Arial', '', 10);


        $this->Cell(30, 0, 'Inv No: '. ($report_row['voucher_id']), 0, 0, 'L');
        $this->SetFont('Arial', '', 9);
        $this->Cell(100);
        $this->Cell(30, 5, 'Inv Date: '.format_date($report_row['voucher_date']), 0,0, 'L');
        $this->Ln(5);




        $this->Cell(50, 5, 'Party Name: '. ($report_row['acct_name']), 0, 0 , 'L');
        $this->SetFont('Arial', '', 9);


        $this->Cell(80);
        $this->Cell(30, 5, 'Balance: '.(0), 0,0, 'L');





        $this->Ln(10);




        /*****************END MASTER TABLE QUERY*****************/


        $this->SetFont('Arial', 'B', 8);
        $this->Cell(6, 8, 'Sr', 1);
        $this->Cell(130, 8, 'Particulars', 1);
        $this->Cell(20, 8, 'Qty', 1,0, 'C');
        $this->Cell(20, 8, 'Rate', 1,0,'C');
        $this->Cell(20, 8, 'Amount', 1, 1, 'R');

        $this->SetFont('Arial', '', 8);



    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

















$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");













$and = " AND d.voucher_id = '$v_id'";
$and .= " AND d.comp_id = '$comp_id'";





try
{
    $vd_query =  "SELECT
	i.description,
	p.acct_name,
	d.rate,
	sum(d.qty) qty,
	sum(itemtot) amount

FROM
	pl_invoice m
LEFT JOIN pl_invoicedet d ON m.voucher_id = d.voucher_id
AND m.comp_id = d.comp_id
LEFT JOIN item i ON i.stock_code = d.stock_code
LEFT JOIN party p ON p.acct_id = m.acct_id

 	
 	WHERE 1=1  $and
 	GROUP BY
	d.stock_code, d.rate
	ORDER BY d.stock_code, d.rate";
    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}
//echo $vd_query;

$sr = "";
$g_tot = "";
$tot_qty = "";
while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

    $g_tot += $rd_row['amount'];
    $tot_qty += $rd_row['qty'];


    $sr += 1;


    $pdf->Cell(6, 8, $sr, 1);
    $pdf->Cell(130, 8, $rd_row['description'], 1);
    $pdf->Cell(20, 8, round($rd_row['qty']), 1,0, 'C');
    $pdf->Cell(20, 8, number_format($rd_row['rate']), 1,0, 'C');
    $pdf->Cell(20, 8, number_format($rd_row['amount']), 1, 1, 'R');


}
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(95);
$pdf->Cell(15,8,'Total',0);
$pdf->Cell(25);
$pdf->Cell(20,8,$tot_qty,0,0, 'C');
$pdf->Cell(20);
$pdf->Cell(20,8,$g_tot,0,0, 'C');


$pdf->Ln(12);




$and = " AND d.voucher_id = '$v_id'";
$and .= " AND v.comp_id = '$comp_id'";

try
{
    $voucher_query =  "SELECT v.acct_id, v.voucher_id, v.voucher_date, d.particulars , c.comp_name,c.add_line1,c.phone,c.email, p.acct_name,  v.discp, v.adv_amt, v.net_amt, v.net_payable
	FROM pl_invoice v 
	LEFT JOIN pl_invoicedet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id AND v.year_id = d.year_id
	LEFT JOIN company c ON c.comp_id = d.comp_id
	LEFT JOIN party p ON p.acct_id = v.acct_id
	
	WHERE 1=1  $and";
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}





$report_row = $voucher_result->fetch(PDO::FETCH_ASSOC);


$discp = $report_row['discp'];
$adv_amt = $report_row['adv_amt'];
$net_payable = $report_row['net_payable'];












$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(140);
$pdf->Cell(15,8,'Discount',0, 0, 'C');
$pdf->Cell(20);
$pdf->Cell(20,8,round($discp),0,0, 'C');

$pdf->Ln(12);


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(140);
$pdf->Cell(15,8,'Advance',0, 0, 'C');
$pdf->Cell(20);
$pdf->Cell(20,8,round($adv_amt),0,0, 'C');




$pdf->Ln(12);


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(135);
$pdf->Cell(20,8,'Total Invoice',0, 0, 'C');
$pdf->Cell(20);
$pdf->Cell(20,8,round($net_payable),0,0, 'C');




$pdf->Ln(12);




$nw=new NumbersToWords();

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(10);
$pdf->Cell(15,8,'Amount in word:',0);
$pdf->Cell(10);
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(15,8,$nw->convert($net_payable),0);













$pdf->Output();