<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");


        $rep_id = clean_data($_GET['rep_id']);
        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {
            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }

        date_default_timezone_set('Asia/Karachi');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(190, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(190, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(5, 10, 'Report printed on : ' . date('d-m-Y h:i:s a'), 0);
        $this->SetFont('Arial', '', 8);
        $this->Cell(188, 10, 'As On Date : ' . ($to_date), 0, 0, 'R');

        $this->Ln(10);
        $this->SetFont('Arial', 'BU', 10);
        $this->Cell(188, 10, 'RS', 0, 0, 'R');
        /*****************END MASTER TABLE QUERY*****************/

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);


if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/



/*************START DATABASE VARIABLE***************/
$and = '';

$and .= " and (v.voucher_date <= '$new_to_date')";


if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
} else {
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

}

$g_tot_dbqty = 0;
$g_tot_crqty = 0;
$g_bal = 0;
$gp = 0;
$total = 0;
$a_gp = 0;
$a_total = 0;


/***********************START PAID UP CAPITAL************************/
$query = "SELECT n2.acct_name, sum(ifnull(v.credit,0)-ifnull(v.debit,0)) total
          from v_vouchers v
          left join nom  n on v.acct_id=n.acct_id 
          left join nom  n2 on substring(v.acct_id,1,6)=n2.acct_id 
          left join acct_type  t on n2.acct_type=t.acct_id 
          WHERE 1 = 1
           $and and substring(t.acct_id,1,1)='3'
          group by substring(v.acct_id,1,6)";

//echo $query;

$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(190, 8, 'CAPITAL & LIABILITIES', 0, 0, 'C');

$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(165, 8, 'SHARE CAPITAL & RESERVES', 1, 0, '');
$pdf->SetFont('Arial', '', 8);

$total = 0;
try {
    $q_result = $dbcon->prepare($query);
    $q_result->execute();

} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $acct_name = $row["acct_name"];
    $total += $row["total"];

    $pdf->Ln(8);
    $pdf->Cell(165, 8, $row["acct_name"], 1, 0, 'l');
    $pdf->Cell(25, 8, format_number_pdf($row["total"],0), 1, 0, 'R');
}
$pdf->SetFont('Arial', 'BU', 8);
$pdf->Ln(8);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($total,0), 0, 0, 'R');

    $gp += $total;
/***********************END PAID UP CAPITAL************************/

/***********************START CURRENT LIABLITES************************/
$query = "SELECT n2.acct_name, sum(ifnull(v.credit,0)-ifnull(v.debit,0)) total
 	  from v_vouchers v
	  left join nom  n on v.acct_id=n.acct_id 
          left join nom  n2 on substring(v.acct_id,1,6)=n2.acct_id 
          left join acct_type  t on n2.acct_type=t.acct_id 
	  WHERE 1 = 1 $and and substring(t.acct_id,1,2) in('28')
	   group by substring(v.acct_id,1,6)";


$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(165, 8, 'CURRENT LIABILITIES', 1, 0, '');
$pdf->SetFont('Arial', '', 8);

$total = 0;
try {
    $q_result = $dbcon->prepare($query);
    $q_result->execute();

} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $acct_name = $row["acct_name"];
    $total += $row["total"];

    $pdf->Ln(8);
    $pdf->Cell(165, 8, $row["acct_name"], 1, 0, 'l');
    $pdf->Cell(25, 8, format_number_pdf($row["total"],0), 1, 0, 'R');
}
$pdf->SetFont('Arial', 'BU', 8);
$pdf->Ln(8);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($total,0), 0, 0, 'R');
$gp += $total;
/***********************END CURRENT LIABLITES************************/

$pdf->Ln(8);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($gp,0), 0, 0, 'R');

/***********************START PROFIT AND LOSS************************/
$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(165, 8, 'PROFIT & LOSS A/C', 1, 0, '');
$pdf->SetFont('Arial', '', 8);

$total = 0;
$query = "SELECT n2.acct_name, sum(ifnull(v.credit,0)-ifnull(v.debit,0)) total
      from v_vouchers v
      left join nom  n on v.acct_id=n.acct_id 
          left join nom  n2 on substring(v.acct_id,1,6)=n2.acct_id 
          left join acct_type  t on n2.acct_type=t.acct_id 
      WHERE 1 = 1 $and and substring(t.acct_id,1,2) in('71')
       group by substring(v.acct_id,1,6)";


try {
    $q_result = $dbcon->prepare($query);
    $q_result->execute();

} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $acct_name = $row["acct_name"];
    $total += $row["total"];

    $pdf->Ln(8);
    $pdf->Cell(165, 8, $row["acct_name"], 1, 0, 'l');
    $pdf->Cell(25, 8, format_number_pdf($row["total"],0), 1, 0, 'R');
}
$pdf->SetFont('Arial', 'BU', 8);
$pdf->Ln(8);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($total,0), 0, 0, 'R');
$gp += $total;

/***********************START PROFIT AND LOSS FOR THE YEAR************************/
$total = 0;
$query = "SELECT 'Current Period' acct_name, sum(ifnull(v.credit,0)-ifnull(v.debit,0)) total
 	  from v_vouchers v
	      left join nom  n on v.acct_id=n.acct_id 
          left join nom  n2 on substring(v.acct_id,1,6)=n2.acct_id 
          left join acct_type  t on n2.acct_type=t.acct_id 
	   WHERE 1 = 1 $and and substring(t.acct_id,1,1) in('4','5','6','8')";


try {
    $q_result = $dbcon->prepare($query);
    $q_result->execute();

} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $acct_name = $row["acct_name"];
    $total += $row["total"];

    $pdf->Ln(8);
    $pdf->Cell(165, 8, $row["acct_name"], 1, 0, 'l');
    $pdf->Cell(25, 8, format_number_pdf($row["total"],0), 1, 0, 'R');
}
$pdf->SetFont('Arial', 'BU', 8);
$pdf->Ln(10);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($total,0), 0, 0, 'R');
$gp += $total;
/***********************START PROFIT AND LOSS FOR THE YEAR************************/

$pdf->Ln(8);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($gp,0), 0, 0, 'R');



$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(190, 8, 'ASSETS', 0, 0, 'C');


/***********************START FIXED ASSETS************************/
$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(165, 8, 'Fixed Assets', 1, 0, '');
$pdf->SetFont('Arial', '', 8);

$query = "SELECT n2.acct_name, sum(ifnull(v.debit,0)-ifnull(v.credit,0)) total
 	  from v_vouchers v
	  left join nom  n on v.acct_id=n.acct_id
            left join nom  n2 on substring(v.acct_id,1,6)=n2.acct_id
            left join acct_type  t on n2.acct_type=t.acct_id
	  WHERE 1 = 1 $and and substring(t.acct_id,1,2) in('11', '12', '13',  '16', '17')
	  group by substring(v.acct_id,1,6)";
try {
    $q_result = $dbcon->prepare($query);
    $q_result->execute();

} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

$total = 0;
while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $acct_name = $row["acct_name"];
    $total += $row["total"];

    $pdf->Ln(10);
    $pdf->Cell(165, 8, $row["acct_name"], 1, 0, 'l');
    $pdf->Cell(25, 8, format_number_pdf($row["total"],0), 1, 0, 'R');
}
$pdf->SetFont('Arial', 'BU', 8);
$pdf->Ln(8);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($total,0), 0, 0, 'R');
$gp += $total;
/***********************END FIXED ASSETS************************/

/***********************START CURRENT ASSETS************************/
$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(165, 8, 'Current Assets', 1, 0, '');
$pdf->SetFont('Arial', '', 8);

$a =" and (n.cash=if(t.acct_id='1902' and n.cash='Y','',n.cash))";
$query = "SELECT n2.acct_name, sum(ifnull(v.debit,0)-ifnull(v.credit,0)) total
 	  from v_vouchers v
	  left join nom  n on v.acct_id=n.acct_id
            left join nom  n2 on substring(v.acct_id,1,6)=n2.acct_id
            left join acct_type  t on n2.acct_type=t.acct_id
	  WHERE 1 = 1 $and $a and substring(t.acct_id,1,2) in('19')
	  group by substring(v.acct_id,1,6)";
try {
    $q_result = $dbcon->prepare($query);
    $q_result->execute();

} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

$total = 0;
while ($row = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $acct_name = $row["acct_name"];
    $total += $row["total"];

    $pdf->Ln(8);
    $pdf->Cell(165, 8, $row["acct_name"], 1, 0, 'l');
    $pdf->Cell(25, 8, format_number_pdf($row["total"],0), 1, 0, 'R');
}
$pdf->SetFont('Arial', 'BU', 8);
$pdf->Ln(10);
$pdf->Cell(165, 8, '', 0, 0, 'l');
$pdf->Cell(25, 8, format_number_pdf($total,0), 0, 0, 'R');
$gp += $total;
/***********************START CURRENT ASSETS************************/

$pdf->Output();
ob_end_flush();


?>