<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_id = clean_data($_GET['rep_id']);
        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

        $comp_id = $_GET['comp_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }


        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(48, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(206, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
#line        $this->Line(11,37,287,37);
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(1);
        $this->Cell(10, 8, 'Sr', 1, 0, '');
        $this->Cell(20, 8, 'VOUCHER ID', 1, 'C');
        $this->Cell(20, 8, 'ACCOUNT ID', 1, 'C');

        $this->Cell(100, 8, 'ACCOUNT NAME', 1, 0,'');
        $this->Cell(80, 8, 'PARTICULARS', 1, 0,'');
        $this->Cell(25, 8, 'DEBIT', 1, 0,'R');
        $this->Cell(25, 8, 'CREDIT', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);




    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

        $comp_id = $_GET['comp_id'];
        $emp_id = clean_data($_SESSION["VALID_USER_ID"]);

        
        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $acct_id = clean_data($_GET['acct_id']);

        /*************START FINDE COMPANY NAME***************/

/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/



$and = '';

$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";


if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
}else{
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

}



if ($acct_id != "All") {
    $and .= " and v.acct_id = '$acct_id'";
}


//group total variables
$g_tot_dbqty = 0;
$g_tot_crqty = 0;
$g_bal = 0;

//group query date
$g_voucher_Date = '';


try {
    $msqlquery = "SELECT DISTINCT v.voucher_date
		FROM
		v_vouchers v
		WHERE 1=1
		$and
		ORDER BY v.voucher_date";
//echo $msqlquery;

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

while($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {

$g_voucher_Date = $mrow['voucher_date'];

$pdf->SetFont('Arial', 'B', 8);
$pdf->Ln(8);

$pdf->Cell(1);
$pdf->Cell(20, 8, format_Date($g_voucher_Date), 0, 0, 'l');

    $pdf->SetFont('Arial', '', 8);

try {
    $d_query = "SELECT v.comp_id, v.voucher_id,v.voucher_date,v.acct_id, debit debit_amount, credit credit_amount, v.lineitem,concat(n1.acct_name,if(n1.acct_name = '','','/'),n2.acct_name,if(n2.acct_name = '','','/'),v.particulars) particulars, n.acct_name
				FROM v_vouchers v
				LEFT JOIN v_nom n ON  v.acct_id = n.acct_id
				LEFT JOIN nom n1 ON v.acct_id_cs_1 = n1.acct_id
				LEFT JOIN nom n2 ON v.acct_id_cs_2 = n2.acct_id
				LEFT JOIN company c ON v.comp_id = c.comp_id		
				WHERE (v.voucher_date = '$g_voucher_Date' )
					  $and 
				order by v.voucher_date, v.voucher_id,v.lineitem";
//echo $d_query;				
				
    $d_result = $dbcon->prepare($d_query);
    $d_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

    $bal = 0;
    $serno = 0;
    $debit_amount_tot = 0;
    $credit_amount_tot = 0;
    $link_voucher = "";
    while($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {
        $serno = $serno + 1;
        $debit_amount_tot += $report_row['debit_amount'];
        $credit_amount_tot += $report_row['credit_amount'];
        $bal = $bal + $report_row['debit_amount'] - $report_row['credit_amount'];


        $voucherID = substr($report_row['voucher_id'],0,8);

        $vouchertype = substr($report_row['voucher_id'],0,2);


$pdf->Ln(8);

$pdf->Cell(1);
$pdf->Cell(10, 8, $serno, 1, 0, 'l');
$pdf->Cell(20, 8, $report_row['voucher_id'], 1, 'C');

$pdf->Cell(20, 8, $report_row['acct_id'], 1, 0, 'C');
$pdf->Cell(100, 8, $report_row['acct_name'], 1, 0, '');
$pdf->Cell(80, 8, $report_row['particulars'], 1, 0, '');
$pdf->Cell(25, 8, format_number_pdf($report_row['debit_amount'],0), 1, 0, 'R');
$pdf->Cell(25, 8, format_number_pdf($report_row['credit_amount'],0), 1, 0, 'R');

    }

    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(10, 8, '', 1);
    $pdf->Cell(20, 8, '', 1);
    $pdf->Cell(20, 8, '', 1);
    $pdf->Cell(100, 8, '', 1);
    $pdf->Cell(80, 8, 'Date Total:', 1, 0,'R');
    $pdf->Cell(25, 8, format_number_pdf($debit_amount_tot,0), 1, 0, 'R');
    $pdf->Cell(25, 8, format_number_pdf($credit_amount_tot,0), 1, 0, 'R');
    $pdf->SetFont('Arial', '', 8);


    $g_tot_dbqty += $debit_amount_tot;
    $g_tot_crqty += $credit_amount_tot;

    }

$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(10, 8, '', 1);
$pdf->Cell(20, 8, '', 1);
$pdf->Cell(20, 8, '', 1);
$pdf->Cell(100, 8, '', 1);
$pdf->Cell(80, 8, 'Grand Total:', 1, 0,'R');
$pdf->Cell(25, 8, format_number_pdf($g_tot_dbqty,0), 1, 0, 'R');
$pdf->Cell(25, 8, format_number_pdf($g_tot_dbqty,0), 1, 0, 'R');


$pdf->Output();