<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'SALES TAX INVOICE';

        $this->SetFont('Arial', 'B', 18);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(0,10, $rep_name,0,0,'C');
        $this->Ln(10);
//        $this->Ln(10);

    }

}


$pdf = new PDF();

$pdf->AddPage("P");


$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
$phone=find_value('company','phone'," and comp_id='$comp_id'");
$address=find_value('company','add_line1'," and comp_id='$comp_id'");
$city=find_value('company','city'," and comp_id='$comp_id'");
$ntn=find_value('company','ntn'," and comp_id='$comp_id'");

$qty_decimals=find_value('system','qty_decimals',"");
$rate_decimals=find_value('system','rate_decimals',"");
$amt_decimals=find_value('system','amt_decimals',"");

$pdf->SetFont('Arial', 'BIU', 24);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$v_id = clean_data($_GET['v_id']);

$and ="";
$and .= " and v.comp_id = '$comp_id'";

if (!empty($v_id)) {
    $and .= " and v.voucher_id = '$v_id'";
    $and .= " and v.year_id = '$year_id'";
}else{
    $and .= " and v.voucher_date between '$new_from_date' and '$new_to_date'";
}

try
{
    $voucher_query =  "SELECT v.acct_id, v.voucher_id, v.bill_no, v.voucher_date, v.stax, v.disc_amt, v.dc_amt, v.net_amt, v.adv_amt, v.net_payable, c.comp_name, c.add_line1,c.phone,c.email,
                              c.stax_no, c.ntn, p.acct_name party_name, p.address add_line1, p.city, c.phone c_phone, p.phone, p.ntn party_ntn, p.stax_no party_stax_no, p.cnic, dc.bill_no dc_no, dc.voucher_date dc_date 
                        FROM sl_invoice v 
                        LEFT JOIN sl_dc dc ON concat(dc.comp_id,dc.year_id,dc.voucher_id)=v.base_voucher_id
                        LEFT JOIN company c ON c.comp_id = v.comp_id
                        LEFT JOIN v_party p ON p.acct_id = v.acct_id
                        WHERE 1=1  $and
                        ORDER BY v.bill_no
                       ";

//echo $voucher_query;
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$num_rows = $voucher_result->rowCount();
$_SESSION["num_rows"] = $num_rows;

while ($report_row = $voucher_result->fetch(PDO::FETCH_ASSOC)) {

    $voucher_id=$report_row['voucher_id'];
    $phone = $report_row['c_phone'];

    $ntn = $report_row['ntn'];
    $stax_no = $report_row['stax_no'];

    $party_name = $report_row['party_name'];
    $p_address = $report_row['add_line1'];
    $p_city = $report_row['city'];
    $p_phone = $report_row['phone'];
    $party_ntn = $report_row['party_ntn'];
    $party_stax_no = $report_row['party_stax_no'];
    $cnic = $report_row['cnic'];


    $pdf->Ln(5);

    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(150, 10, 'Inv No: '. ($report_row['bill_no']), 0);
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell(10);
    $pdf->Cell(5, 10, 'Inv Date: '.format_date($report_row['voucher_date']).'', 0);

    $pdf->Ln(5);

    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(150, 10, 'DC No: '. ($report_row['dc_no']), 0);
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell(10);
    $pdf->Cell(5, 10, 'DC Date: '.format_date($report_row['dc_date']).'', 0);

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Cell(70, 8, '', 0);
    $pdf->SetLeftMargin('10');
    $pdf->Ln(1);



    /***********************START SUPPLIER BLOCK******************/
    $pdf->SetFont('Arial', 'B', 14);

    $pdf->Cell(1);
    $pdf->setFillColor(230,230,230);
    $pdf->Cell(95, 10, 'SUPPLIER', 1,0,'C', true);
    $pdf->Cell(2);
    $pdf->setFillColor(230,230,230);
    $pdf->Cell(95, 10, 'BUYER', 1,1,'C', true);

    $pdf->SetFont('Arial', '', 8);
//SYPPLIER NAME
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Name:   ', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $comp_name, 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//BUYER NAME
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'Name:', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $party_name, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//SUPPLIER ADDRESS
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Address:', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $address, 0,1,'L');


    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'Address:', 0,1,'L');


    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_address, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'City:', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $city, 0,1,'L');


    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'City:', 0,1,'L');


    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_city, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


//BUYER ADDRESS


//SUPPLIER PHONE
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Phone:', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $phone, 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


//BUYER PHONE
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'Phone:', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_phone, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//SUPPLIER NTN
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'NTN:', 0,1,'L');

//BUYER NTN
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'NTN:', 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, $ntn, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $party_ntn, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');




//SUPPLIER SALE TAX
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'S TAX#:', 0,1,'L');
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'S TAX#:', 0,1,'L');


    $pdf->Cell(12);
    $pdf->Cell(95, 0, $stax_no, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $party_stax_no, 0,1,'L');



    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


    /***********************END SUPPLIER BLOCK******************/

    /*****************END MASTER TABLE QUERY*****************/

    $pdf->SetFont('Arial', 'B', 8);

    $pdf->Ln(5);
    $pdf->Cell(1);
    $pdf->Cell(8, 16, 'Sr', 1);
    $pdf->Cell(43, 16, 'Description', 1);
    $pdf->Cell(30, 16, 'Part No', 1);
    $pdf->Cell(20, 16, 'PO No', 1);
    $pdf->Cell(15, 16, 'Qty', 1, 0,'R');
    $pdf->Cell(10, 16, 'Rate', 1, 0,'R');


    $current_y = $pdf->GetY();
    $current_x = $pdf->GetX(20);

    $pdf->MultiCell(20, '8', 'Excluding Sales Tax', 1, 'R','');
    $pdf->SetXY($current_x + 20, $current_y);

    $pdf->Cell(25, 8, 'SALES TAX', 1, 0,'C');

    $current_y = $pdf->GetY();
    $current_x = $pdf->GetX(20);
    $pdf->MultiCell(20, 5.3, 'Value Inclusive Sales Tax', 1, 'R','');
    $pdf->SetXY($current_x + 60, $current_y + 8);


    $pdf->Cell(-85);

    $pdf->Cell(10, 8, '%', 1, 0,'C');
    $pdf->Cell(15, 8, 'Rs', 1, 0,'R');
    //$pdf->Cell(20, 8, '', 1, 0,'R');

    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);


    try
    {
        $vd_query =  "SELECT
	d.stock_code,
	d.particulars,
	d.qty,
	d.rate,
	d.voucher_id,
	i.description,
	d.qty*d.rate ex_value,
	d.itemtot,
	d.lineitem,
	d.discp,
	d.lineitem,
	d.discount,
	d.sharing,
	d.avg_rate,
	d.staxp,
	d.add_staxp,
	d.stax_rate,
	d.stax,
    ifnull(d.staxp,0)-ifnull(add_staxp,0) r_staxp,
    ifnull(d.stax,0)-ifnull((d.qty*d.rate)*d.add_staxp*.1,0) r_stax,
    ifnull((d.qty*d.rate)*d.add_staxp*.1,0) add_stax,
    d.stax,
    ip.part_no,
    ip.item_no,
    ip.po_no
 	FROM sl_invoice v 
 	LEFT JOIN sl_invoicedet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id and v.year_id=d.year_id
	LEFT JOIN item i ON d.stock_code = i.stock_code
    LEFT JOIN item_party ip on v.acct_id=ip.acct_id and d.stock_code=ip.stock_code
 	WHERE 1=1 $and and v.voucher_id='$voucher_id'";

//echo $vd_query;

        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $sr = "";
    $tot_ex_value=0;
    $tot_r_stax=0;
    $tot_add_stax=0;
    $tot_stax=0;
    $tot_r_stax=0;
    $tot_itemtot=0;
    $tot_qty=0;
    $total_stax = "";

    while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

        $tot_ex_value += $rd_row['ex_value'];
        $tot_r_stax += $rd_row['r_stax'];
        $tot_add_stax += $rd_row['add_stax'];
        $tot_stax += $rd_row['stax'];
        $tot_itemtot += $rd_row['itemtot'];
        $tot_qty += $rd_row['qty'];

        $total_stax = $rd_row['staxp'] + $rd_row['add_staxp'];

        $sr += 1;
        $_SESSION["sr"] = $sr;
        $pdf->Cell(1);
        $pdf->Cell(8, 8, $sr.'.', 1);
        $pdf->Cell(43, 8, $rd_row['description'], 1);
        $pdf->Cell(30, 8, $rd_row['part_no'], 1);
        $pdf->Cell(20, 8, $rd_row['po_no'], 1);
        $pdf->Cell(15, 8, format_number_pdf($rd_row['qty'], $qty_decimals), 1, 0,'R');
        $pdf->Cell(10, 8, format_number_pdf($rd_row['rate'],$rate_decimals), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($rd_row['ex_value'],$amt_decimals), 1, 0,'R');
        $pdf->Cell(10, 8, format_number_pdf($rd_row['staxp'],0), 1, 0,'C');
        $pdf->Cell(15, 8, format_number_pdf($rd_row['stax'],$amt_decimals), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($rd_row['itemtot'],$amt_decimals), 1, 0,'R');

        $pdf->Ln(8);
    }

    /*
    while ($sr<10){
        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(8, 8, $sr.'.', 1);
        $pdf->Cell(43, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Ln(8);
    }
*/
    
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(105);
    $pdf->Cell(15,8,'Total',0,0,'R');
    $pdf->Cell(10);
    $pdf->Cell(17,8,format_number_pdf($tot_ex_value,$amt_decimals),0,0, 'R');
    $pdf->Cell(10);
    $pdf->Cell(15,8,format_number_pdf($tot_stax,$amt_decimals),0,0, 'R');
    $pdf->Cell(20,8,format_number_pdf($tot_itemtot,$amt_decimals),0,0, 'R');


    $pdf->Ln(5);

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20);
    $pdf->Cell(15,8,'Sales Tax:',0,0,'R');
    $pdf->SetFont('Arial', 'BU', 8);
    $pdf->Cell(20,8,format_number_pdf($report_row['stax'],$amt_decimals),0,0, 'R');
    $pdf->Cell(117);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20,8,'Signatures:___________________________________',0,0, 'R');

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20);
    $pdf->Cell(15,8,'Net Tax Inclusive Value:',0,0,'R');
    $pdf->SetFont('Arial', 'BU', 8);
    $pdf->Cell(20,8,format_number_pdf($report_row['net_amt'],$amt_decimals),0,0, 'R');
    $pdf->Cell(117);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(20,8,'Name:___________________________________',0,0, 'R');


    if ($_SESSION["num_rows"]>1)
        $pdf->AddPage("P");

}

$pdf->Output();
