<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_id = clean_data($_GET['rep_id']);
        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

        $comp_id = $_GET['comp_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }


        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(50, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(195, 10, 'As On : ' . ($to_date), 0, 0, 'R');
#line        $this->Line(11,37,287,37);
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(1);
        $this->Cell(10, 8, 'Sr', 1, 0, '');
        $this->Cell(20, 8, 'ACCOUNT ID', 1, 0,'C');
        $this->Cell(60, 8, 'ACCOUNT NAME', 1, 0,'L');
        $this->Cell(90, 8, 'REGIONS', 1, 0,'L');
        $this->Cell(30, 8, 'PHONE', 1, 0,'L');
        $this->Cell(20, 8, 'DEBIT', 1, 0,'R');
        /*$this->Cell(25, 8, 'CREDIT', 1, 0,'R');*/
        $this->Cell(20, 8, 'DAYS', 1, 0,'R');
        $this->Cell(30, 8, 'Last Inv Days', 1, 0,'L');
        $this->SetFont('Arial', '', 8);
        $this->Ln(10);
    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

$comp_id = $_GET['comp_id'];
$emp_id = clean_data($_SESSION["VALID_USER_ID"]);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$acct_id = clean_data($_GET['acct_id']);
$reg_id = clean_data($_GET['reg_id']);

$days = clean_data($_GET['days']);
$days_filter = clean_data($_GET['days_filter']);

/*************START FINDE COMPANY NAME***************/

/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/
$and = '';
$and .= " and (v.voucher_date <= '$new_to_date')";

$n_and = " and (n.acct_id like '261000%' and length(n.acct_id)=10)";

if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
}else{
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

}


if ($acct_id != "All") {
    $and .= " and v.acct_id like '$acct_id%'";

    $n_and .= " and n.acct_id like '$acct_id%'";
}


if ($reg_id != "All") {
    $n_and .= " and n.reg_id like '$reg_id%'";
}



if($days != "") {
    if ($days_filter == "greater") {
        $having = " HAVING days > $days";
    }

    if ($days_filter == "less") {
        $having = " HAVING days < $days";
    }

    if ($days_filter == "greater_eq") {
        $having = " HAVING days => $days";
    }

    if ($days_filter == "less_eq") {
        $having = " HAVING days <= $days";
    }
}

$and .= " and (v.debit is not null or v.credit is not null)";

try {
    $msqlquery = "SELECT
                                n.acct_id, n.acct_name,v.balance, a.days, n.address,n.phone, r.reg_name, b.last_v_date, b.voucher_id
                          FROM nom n
                              LEFT JOIN regions r ON n.reg_id = r.reg_id
                          LEFT JOIN (SELECT v.acct_id, sum(ifnull(v.debit, 0) - ifnull(v.credit, 0)) balance FROM v_vouchers v WHERE 1=1 $and
                        GROUP BY
                            v.acct_id
                            having sum(
            ifnull(v.debit, 0) - ifnull(v.credit, 0)
        )>0) v on n.acct_id=v.acct_id
                          LEFT JOIN (SELECT v.acct_id, datediff( '$new_to_date', max( v.voucher_date ) ) days FROM v_vouchers v WHERE 1=1 $and group by v.acct_id) a on v.acct_id=a.acct_id
                        
                         LEFT JOIN (SELECT v.acct_id, max( v.voucher_date ) last_v_date, v.voucher_id FROM v_vouchers v WHERE 1=1 $and and substr(v.voucher_id,3,2) = 'SL' group by v.acct_id) b on v.acct_id=b.acct_id

                          
                          
                          where 1=1 $n_and
                       $having

order by 4 desc, 2 asc
";

//echo $msqlquery;

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}




$bal = 0;
$serno = 0;


$g1_o_bal_tot=0;
$g1_debit_tot=0;
$g1_credit_tot=0;
$g1_balance_tot=0;

$o_bal_amount_tot=0;
$debit_amount_tot=0;
$credit_amount_tot=0;
$balance_amount_tot=0;

while($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
        $serno = $serno + 1;


    $debit=0;
    if($report_row['balance']>0)
        $debit=$report_row['balance'];

    $credit=0;
    if($report_row['balance']<0)
        $credit=-$report_row['balance'];

    $debit_amount_tot += $report_row['debit'];
    $credit_amount_tot += $report_row['credit'];
    $balance_amount_tot += $report_row['balance'];

    $bold='';
    $bold_close='';

    $d_debit=($debit);
    $d_credit=($credit);
    $d_balance=format_number_drcr($report_row['balance'], 0);

    $g1_debit_tot +=$debit;
    $g1_credit_tot +=$credit;

    $acct_id=substr($report_row['acct_id'],-4);
    $v_id = $report_row['voucher_id'];


    $last_inv_days = '';

    if(substr($v_id,2,2) == 'SL')
    {
        $startTimeStamp = strtotime($report_row['last_v_date']);
        $endTimeStamp = strtotime($new_to_date);
        $timeDiff = abs($endTimeStamp - $startTimeStamp);
        $numberDays = $timeDiff/86400;
        $last_inv_days = intval($numberDays);
    }


if ($report_row['balance']<>0) {

    $pdf->Ln(8);

    $pdf->Cell(1);
    $pdf->Cell(10, 8, $serno, 1, 0, 'l');
    $pdf->Cell(20, 8, $report_row['acct_id'], 1, 0, 'C');
    $pdf->Cell(60, 8, $report_row['acct_name'], 1, 0, 'L');
    $pdf->Cell(90, 8, $report_row['reg_name'], 1, 0, 'L');
    $pdf->Cell(30, 8, $report_row['phone'], 1, 0, 'L');
    $pdf->Cell(20, 8, format_number_pdf($d_debit, 0), 1, 0, 'R');
    /*$pdf->Cell(25, 8, format_number_pdf($d_credit, 0), 1, 0, 'R');*/
    $pdf->Cell(20, 8, format_number_pdf($report_row['days'], 0), 1, 0, 'R');
    $pdf->Cell(30, 8, ($last_inv_days), 1, 0, 'R');
}

    }

    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);


    $pdf->Cell(10, 8, '', 1);
    $pdf->Cell(20, 8, '', 1);
    $pdf->Cell(180, 8, 'Date Total:', 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($g1_debit_tot,0), 1, 0, 'R');
    /*$pdf->Cell(25, 8, format_number_pdf($g1_credit_tot,0), 1, 0, 'R');*/

    $pdf->SetFont('Arial', '', 8);



$pdf->Output();