<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'Customer Trial';

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
        $comp_id = $_GET['comp_id'];
        $acct_id = $_GET['acct_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);


        if ($comp_id != "All") {
            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }


        $this->SetFont('Arial', 'B', 18);
        $this->Cell(178, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(178, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', '', 12);
        $this->Cell(110, 10, format_date($from_date) .' To ' . format_date($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/



    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
        $auth_id = find_value('users', 'auth_id', " and emp_id='$emp_id'");

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_GET['comp_id']);

        $acct_id = clean_data($_GET['acct_id']);
        $reg_id = clean_data($_GET['region_id']);

        $nums_array = explode(',', $reg_id);

$filter_type = clean_data($_GET['filter_type']);



$pdf->Ln(10);

$pdf->SetFont('Arial', 'B', 18);
$pdf->Cell(178, 10, 'DETAIL', 0, 0, 'C');



$pdf->Ln(10);
$pdf->Cell(1);
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(15, 8, 'ID', 1, 0,'C');
$pdf->Cell(90, 8, 'Account Name', 1);
$pdf->Cell(20, 8, 'Opening', 1, 0,'R');
$pdf->Cell(20, 8, 'Debit', 1, 0,'R');
$pdf->Cell(20, 8, 'Credit', 1, 0,'R');
$pdf->Cell(20, 8, 'Balance', 1, 0,'R');
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);






        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");

        }
        /*************END FINDE COMPANY NAME*****************/


        $and = '';
        $n_and = " and (n.acct_id like '261000%' and length(n.acct_id)=10)";
        $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

        if ($comp_id != "All") {
            $and .= " and v.comp_id = '$comp_id'";
        }else{
            $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

        }


        if ($acct_id != "All") {
            $and .= " and n.acct_id like '$acct_id%'";

            $n_and .= " and n.acct_id like '$acct_id%'";
        }


       /* if ($reg_id != "All") {
            $and .= " and n.reg_id like '$reg_id%'";

            $n_and .= " and n.reg_id like '$reg_id%'";
        }*/


if ($reg_id != "All" && ($filter_type == 'IN' || $filter_type == 'NOT IN')) {
    //$and .= " and n.reg_id $filter_type ($reg_id)";
    //$n_and .= " and n.reg_id $filter_type ($reg_id)";

    $and .= " and n.reg_id $filter_type(".implode(",", array_map('intval', $nums_array)).")";
    $n_and .= " and n.reg_id $filter_type(".implode(",", array_map('intval', $nums_array)).")";

}




$and .= " and (v.debit is not null or v.credit is not null)";

$and .= " and n.acct_id <> '2610000804'";


        try {
            $msqlquery = "SELECT n.reg_id, r.reg_name, sum(ifnull(o.o_bal,0)) o_bal, sum(ifnull(v.debit,0)) debit, sum(ifnull(v.credit,0)) credit
 
FROM nom n
LEFT JOIN regions r on n.reg_id=r.reg_id

LEFT JOIN (
    SELECT
        v.acct_id,
        
        sum(
            ifnull(v.debit, 0) - ifnull(v.credit, 0)
        ) o_bal
    FROM
        v_vouchers v
    LEFT JOIN nom n on v.acct_id=n.acct_id
    WHERE
        v.voucher_date < '$new_from_date'
    GROUP BY
        v.acct_id
) o ON n.acct_id = o.acct_id
LEFT JOIN (
    SELECT
        v.acct_id,
        sum(v.debit) debit,
        sum(v.credit) credit,
        v.voucher_date
    FROM
        v_vouchers v
    LEFT JOIN nom n on v.acct_id=n.acct_id
    WHERE
        1 = 1 $and $n_and
    GROUP BY
        v.acct_id
) v ON n.acct_id = v.acct_id
where n.reg_id <>'' and (n.acct_id like '261000%' and length(n.acct_id)=10) $n_and
group by n.reg_id, r.reg_name
order by sum(ifnull(o.o_bal,0))+sum(ifnull(v.debit,0))-sum(ifnull(v.credit,0)) desc
";
//echo $msqlquery;

            $v_result = $dbcon->prepare($msqlquery);
            $v_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }



$g_sr = 0;

$g_net_amt_tot = 0;
$g_disc_amt_tot = 0;
$g_rec_amt_tot = 0;
$g_rtn_amt_tot = 0;
$g_bal_amt_tot = 0;





        try {
            $msqlquery = "

SELECT reg_id acct_id, reg_name acct_name,  NULL ur_acct_name, null o_bal, null debit, null credit, null balance
FROM regions where reg_id in
(SELECT reg_id
FROM
    nom n
LEFT JOIN (
    SELECT
        v.acct_id,
        
        sum(
            ifnull(v.debit, 0) - ifnull(v.credit, 0)
        ) o_bal
    FROM
        v_vouchers v
    LEFT JOIN nom n on v.acct_id=n.acct_id
    WHERE
        v.voucher_date < '$new_from_date'
    GROUP BY
        v.acct_id
) o ON n.acct_id = o.acct_id
LEFT JOIN (
    SELECT
        v.acct_id,
        sum(v.debit) debit,
        sum(v.credit) credit,
        v.voucher_date
    FROM
        v_vouchers v
    LEFT JOIN nom n on v.acct_id=n.acct_id
    WHERE
        1 = 1  $and
    GROUP BY
        v.acct_id
) v ON n.acct_id = v.acct_id
WHERE
1 = 1 
$n_and
)

UNION ALL 

SELECT n.acct_id,
       n.acct_name,
       n.ur_acct_name,
       n.o_bal,
       n.debit,
       n.credit,
       n.balance
FROM
(



SELECT
    concat(n.reg_id,substring(n.acct_id,-4)) acct_id,
    concat(n.acct_name,if(n.phone<>'', concat(' / Phone#',n.phone),'')) acct_name,
    o.o_bal,
    v.debit,
    v.credit,
    ifnull(o.o_bal, 0) + ifnull(v.debit, 0) - ifnull(v.credit, 0) balance,
    n.ur_acct_name
FROM
    nom n
LEFT JOIN (
    SELECT
        v.acct_id,
        
        sum(
            ifnull(v.debit, 0) - ifnull(v.credit, 0)
        ) o_bal
    FROM
        v_vouchers v
    LEFT JOIN nom n on v.acct_id=n.acct_id
    WHERE
        v.voucher_date < '$new_from_date'
    GROUP BY
        v.acct_id
) o ON n.acct_id = o.acct_id
LEFT JOIN (
    SELECT
        v.acct_id,
        sum(v.debit) debit,
        sum(v.credit) credit,
        v.voucher_date
    FROM
        v_vouchers v
    LEFT JOIN nom n on v.acct_id=n.acct_id
    WHERE
        1 = 1  $and
    GROUP BY
        v.acct_id
) v ON n.acct_id = v.acct_id
WHERE
1 = 1 
$n_and  and n.acct_id <> '2610000804'
order by n.acct_id
) n

order by 1, 2
";

#echo $msqlquery;

            $vd_result = $dbcon->prepare($msqlquery);
            $vd_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }


$sr = 0;
                            $g1_o_bal_tot=0;
                            $g1_debit_tot=0;
                            $g1_credit_tot=0;
                            $g1_balance_tot=0;

        $o_bal_amount_tot=0;
        $debit_amount_tot=0;
        $credit_amount_tot=0;
        $balance_amount_tot=0;


while ($vd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {


                        $o_bal_amount_tot += $vd_row['o_bal'];
                        $debit_amount_tot += $vd_row['debit'];
                        $credit_amount_tot += $vd_row['credit'];
                        $balance_amount_tot += $vd_row['balance'];

                        $g1_o_bal_tot +=$vd_row['o_bal'];
                        $g1_debit_tot +=$vd_row['debit'];
                        $g1_credit_tot +=$vd_row['credit'];
                        $g1_balance_tot +=$vd_row['balance'];

                        $acct_id=substr($vd_row['acct_id'],-4);

    $sr += 1;
    $pad='';

                        $grp_label='';
                        if ($o_bal_amount_tot<>0 || $debit_amount_tot<>0 || $credit_amount_tot<>0 || $balance_amount_tot<>0)
                        $grp_label='Region Total:';

                        if (strlen($vd_row['acct_id'])<=6)
                        {

                        $serno = 0;
                        $acct_id = '';

                        $pdf->SetFont('Arial', 'B', 8);
                        $pdf->Cell(1);
                        $pdf->Cell(15, 8, '', 1);
                        $pdf->Cell(90, 8, $grp_label, 1, 0,'R');
                        $pdf->Cell(20, 8, format_number_drcr($o_bal_amount_tot,0), 1, 0,'R');
                        $pdf->Cell(20, 8, format_number_pdf($debit_amount_tot,0), 1, 0,'R');
                        $pdf->Cell(20, 8, format_number_pdf($credit_amount_tot,0), 1, 0,'R');
                        $pdf->Cell(20, 8, format_number_drcr($balance_amount_tot,0), 1, 0,'R');
                        $pdf->SetFont('Arial', '', 8);
                        $pdf->Ln(8);

                        $o_bal_amount_tot = 0;
                        $debit_amount_tot = 0;
                        $credit_amount_tot = 0;
                        $balance_amount_tot = 0;

                        }

        $pdf->SetFont('Arial', '', 8);
        if (strlen($vd_row['acct_id'])<=6)
           $pdf->SetFont('Arial', 'B', 12);


    if ($vd_row['o_bal']<>0 || $vd_row['debit']<>0 ||$vd_row['credit']<>0 ||$vd_row['balance']<>0 || strlen($vd_row['acct_id'])<10)
    {

        $pdf->Cell(1);
        $pdf->Cell(15, 8, $acct_id, 1, 0, 'C');
        $pdf->Cell(90, 8, $vd_row['acct_name'], 1);
        $pdf->Cell(20, 8, format_number_drcr($vd_row['o_bal'], 0), 1, 0, 'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['debit'], 0), 1, 0, 'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['credit'], 0), 1, 0, 'R');
        $pdf->Cell(20, 8, format_number_drcr($vd_row['balance'], 0), 1, 0, 'R');
        $pdf->Ln(8);

    }
    
}

    $g_sr += $sr;
    $g_net_amt_tot += $net_amt_tot;
    $g_disc_amt_tot += $disc_amt_tot;
    $g_rec_amt_tot += $rec_amt_tot;
    $g_bal_amt_tot += $bal_amt_tot;
    $g_rtn_amt_tot += $rtn_amt_tot;





$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(15, 8, '', 1);
$pdf->Cell(90, 8, 'Grand Total : ', 1, 0,'R');
$pdf->Cell(20, 8, format_number_drcr($g1_o_bal_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g1_debit_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g1_credit_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_drcr($g1_balance_tot,0), 1, 0,'R');

$pdf->Output();
ob_end_flush();