<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once("tcpdf/tcpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends TCPDF
{

    //Page header
    public function Header()
    {




        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }





    }


}




// create new PDF document
$pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'PDF_PAGE_FORMAT', true, 'UTF-8', false);




// Start First Page Group
$pdf->startPageGroup();

$pdf->AddPage('P', 'A4');

$pdf->setFontSubsetting(false);

$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins


$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


$font_cal = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Regular.ttf', 'TrueTypeUnicode', '', 32);
$font_cal_bold = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Bold.TTF', 'TrueTypeUnicode', '', 32);
$arial_fontname = TCPDF_FONTS::addTTFfont('tcpdf/fonts/ARIALBD.TTF', 'TrueTypeUnicode', '', 32);

$comp_id = $_GET['comp_id'];

$rep_name = 'Recovery Report';
$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);


$acct_id = clean_data($_GET['acct_id']);
$emp_id = clean_data($_SESSION["VALID_USER_ID"]);
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('system', 'comp_name', "");
}
$reg_id = clean_data($_GET['regg_id']);

$font_cal = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Regular.ttf', 'TrueTypeUnicode', '', 32);
$font_cal_bold = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Bold.TTF', 'TrueTypeUnicode', '', 32);
$arial_fontname = TCPDF_FONTS::addTTFfont('tcpdf/fonts/ARIALBD.TTF', 'TrueTypeUnicode', '', 32);
// Logo


$run_time =date('l, F jS, Y H:i:s A');

$pdf->SetFont($font_cal, 'B', 18);
$pdf->Cell(0, 10, strtoupper($comp_name), 0, 0, 'C');
$pdf->Ln(10);
$pdf->SetFont($font_cal, 'U', 18);
$pdf->Cell(0, 10, $rep_name, 0, 0, 'C');
$pdf->Ln(10);
$pdf->SetFont($font_cal, 'I', 8);
$pdf->Cell(28);
$pdf->Cell(52, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
$pdf->SetFont($font_cal, 'B', 8);
$pdf->Cell(197, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
#line        $this->Line(11,37,287,37);




$and = "";
//$and .= " and (v.voucher_date BETWEEN '$new_from_date' and '$new_to_date')";
$pdf->ln(11);



$and = '';

$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";


if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
}else{
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

}


if ($acct_id != "All") {
    $and .= " and v.acct_id like '$acct_id%'";


}


if ($reg_id != "All") {
    $and .= " and n.reg_id like '$reg_id%'";


}


$month = date("m",strtotime($new_from_date));
$curr_month_from_date = date('Y-'.$month.'-01');



$pdf->SetFont($font_cal, '', 8);
$a = '
  <table  border="1" id="table-1"  style="text-align: center; " cellpadding="1">
                                <thead>
                                <tr>
                    <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 5%;">Sr</th>
                    <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">Account ID</th>
                   <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 15%;">Customers</th>
                   
               <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">CompID</th>
                   <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 12%;">Pre Balance</th>

                   <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">Sale</th>
                    <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">Return</th>
                    <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">Recovery</th>
                     <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">Balance</th>
                     <th  style="text-align: center; font-size: 10px; font-weight: bold; width: 10%;">Recovery %</th>

               
                </tr>

              
                                </thead>
                                <tbody style="color: #000000;">' ;
try {
    $d_query = "SELECT
	v.acct_id,
	SUM( v.credit ) cash_received ,
       n.acct_name,
	  v.comp_id,
	( SELECT sum(ifnull( c.debit, 0 ) - ifnull( c.credit, 0 )) balance FROM v_vouchers c WHERE 1 = 1 and c.acct_id = v.acct_id and c.voucher_date < '$new_from_date'   GROUP BY c.acct_id HAVING
	sum( ifnull( c.debit, 0 ) - ifnull( c.credit, 0 ) )> 0 ) AS balance,
    
( SELECT sum(ifnull( c.debit, 0 ) - ifnull( c.credit, 0 )) balance FROM v_vouchers c WHERE 1 = 1 and c.acct_id = v.acct_id  $and   GROUP BY c.acct_id HAVING
	sum( ifnull( c.debit, 0 ) - ifnull( c.credit, 0 ) )> 0 ) AS cur_balance,

( SELECT sum(ifnull( s.net_amt, 0 )) sale_amt FROM sl_invoice s WHERE 1 = 1 and s.acct_id = v.acct_id  and s.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date'   GROUP BY s.acct_id ) AS sale_amt,
	
	( SELECT sum(ifnull( r.net_amt, 0 )) rt_sale_amt FROM sl_return r WHERE 1 = 1 and r.acct_id = v.acct_id  and r.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date'   GROUP BY r.acct_id ) AS rt_sale_amt

FROM
	v_vouchers v
    LEFT JOIN nom n ON v.acct_id = n.acct_id
WHERE
	1 = 1
	AND substr( v.voucher_id, 3, 2 ) IN ( 'CR', 'JV' ) 
	AND v.acct_id NOT IN ( '2610000463', '2610000804', '2610000790', '2610000464', '2610000462', '2610001116', '2610000886', '2610000789', '2610001164', '2610001191' ) 
	$and
	AND v.acct_id LIKE '261000%'
GROUP BY
	v.acct_id ";
//echo $d_query;
    $d_result = $dbcon->prepare($d_query);
    $d_result->execute();
} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}

$serno = "";

while ($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {
    $serno += 1;
    $debit_amount_tot += $report_row['debit_amount'];
    $credit_amount_tot += $report_row['credit_amount'];


    $acct_id = $report_row['party_id'];;

    $final_bal = $report_row['cur_balance'];
    $f_comp_id = $report_row['comp_id'];
    $g_tot_pre += $report_row['balance'];
    $g_tot_cash += $report_row['cash_received'];
    $g_tot_sale += $report_row['sale_amt'];
    $g_totfinal += $final_bal;

    if($report_row['sale_amt'] != 0)
    {
        $recp = $report_row['balance'] + $report_row['sale_amt'];
        $final_rec_p = ($report_row['cash_received']*100)/$recp;

    }
    else
    {
        $recp = $report_row['balance'] + $report_row['sale_amt'];
        $final_rec_p = ($report_row['cash_received']*100)/$recp;
    }




    $b .=
        '
                    <tr>
                        <td style="width: 5%;" >'.$serno.'</td>
                        <td style="width: 10%;">'.$report_row['acct_id'].'</td>
                        <td style="width: 15%;">'.($report_row['acct_name']).'</td>
                        <td style="width: 10%;">'.($f_comp_id).'</td>
                        <td style="width: 12%;">'.format_number_pdf($report_row['balance'],0).'</td>
                        <td style="width: 10%;">'. format_number_pdf($report_row['sale_amt'],0).'</td>
                          <td style="width: 10%;">'. format_number_pdf($report_row['rt_sale_amt'],0).'</td>
               

                       <td style="width: 10%;">'.format_number_pdf($report_row['cash_received'],0).'</td>
                        <td style="width: 10%;">'. format_number_pdf($final_bal,0).'</td>
                        <td style="width: 10%;">'.round($final_rec_p,0).'</td>
                       


                    </tr>';

}



$c .=
    '
                    <tr>
                    
                      <td></td>
                    <td></td>
                        <td ><b>Total</b></td>
                    <td ><b>'.format_number_pdf( $g_tot_pre , 0).'</b></td>
                    <td ><b>'.format_number_pdf( $g_tot_sale , 0).'</b></td>
                    <td ><b>'. format_number_pdf( $g_tot_cash , 0).'</b></td>
                    <td ><b>'. format_number_pdf( $g_totfinal , 0).'</b></td>
                     <td></td>
                  

                    </tr>';

$d = '</tbody>
                            </table>';

$pdf->writeHTML($a.$b.$c.$d, true, false, true, false, '');


ob_end_clean();
$pdf->Output('Recovery Report'. $from_date.'.pdf');
