<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'Sale Report';

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {
            $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");

        }

        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(52, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(190, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(10);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(15, 8, 'Date', 1,'C');
        $this->Cell(15, 8, 'Bill No', 1,'C');
        $this->Cell(60, 8, 'Customer Name', 1);
        $this->Cell(90, 8, 'Items', 1);

        $this->Cell(20, 8, 'Amount', 1, 0,'R');
        $this->Cell(20, 8, 'Discount', 1, 0,'R');
        $this->Cell(20, 8, 'Received', 1, 0,'R');
        $this->Cell(20, 8, 'Balance', 1, 0,'R');
        $this->Cell(20, 8, 'Return', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

#$comp_id = '01';
        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
        $comp_id = $_GET['comp_id'];

        
        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);


            $and = '';
            $and .= " and (m.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

            if ($comp_id != "All") {

                $and .= " and m.comp_id = '$comp_id'";
            } else {
                $and .= " and m.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";
            }


try
{
    $vd_query =  "SELECT DISTINCT m.voucher_id, m.voucher_date,  m.bill_no, 
                                  substring(concat(p.acct_name,concat(if(m.customer_name='','',' / ')), m.customer_name),1,30) party_name,
                                    ifnull(m.net_amt,0)+ifnull(m.disc_amt,0) net_amt, 
                                    m.disc_amt, 
                                    ifnull(m.adv_amt,0)+ifnull(r.rec_amt,0) rec_amt,
                                    r2.rtn_amt, 
                                    ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(r.rec_amt,0) bal_amt, 
                                    m.comp_id,  m.posted, m.disc_amt, f_sl_invoice_products(m.comp_id,m.year_id,m.voucher_id) items, sp.acct_name sp_name
FROM sl_invoice m
LEFT JOIN (select v_no, sum(credit) rec_amt from voucherdet where v_no<>'' group by v_no) r on m.bill_no=r.v_no
LEFT JOIN (select bill_no, sum(net_amt) rtn_amt from sl_return group by bill_no) r2 on m.bill_no=r2.bill_no
LEFT JOIN v_party p on m.acct_id=p.acct_id
LEFT JOIN sp on m.sp_id=sp.acct_id
WHERE 1=1  $and  ORDER BY m.voucher_date, m.bill_no";

//echo $vd_query;

    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = "";
            $net_amt_tot = '';
            $disc_amt_tot = '';
            $rec_amt_tot = '';
            $rtn_amt_tot = '';
            $bal_amt_tot = '';


while ($report_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {


                    $net_amt_tot += $report_row['net_amt'];
                    $disc_amt_tot += $report_row['disc_amt'];
                    $rec_amt_tot += $report_row['rec_amt'];
                    $bal_amt_tot += $report_row['bal_amt'];
                    $rtn_amt_tot += $report_row['rtn_amt'];

    $sr += 1;
    $pad='';

        if (strlen($report_row['items'])>50)
            $pad='...';

        $pdf->Cell(1);
        $pdf->Cell(15, 8, format_date($report_row['voucher_date']), 1);
        $pdf->Cell(15, 8, $report_row['bill_no'], 1);
        $pdf->Cell(60, 8, $report_row['party_name'], 1);
        $pdf->Cell(90, 8, substr($report_row['items'],0,50).$pad, 1);
        $pdf->Cell(20, 8, format_number_pdf($report_row['net_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($report_row['disc_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($report_row['rec_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($report_row['bal_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($report_row['rtn_amt'],0), 1, 0,'R');


    $pdf->Ln(8);
    
}

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(1);
$pdf->Cell(15, 8, '', 1);
$pdf->Cell(15, 8, '', 1);
$pdf->Cell(60, 8, '', 1);
$pdf->Cell(90, 8, 'Total : ' . $sr . ' Invoices', 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($net_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($disc_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($rec_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($bal_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($rtn_amt_tot,0), 1, 0,'R');

$pdf->Output();
ob_end_flush();