<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_id = clean_data($_GET['rep_id']);
        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

        $comp_id = $_GET['comp_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }

        if ($rep_id=='047' ||$rep_id=='052'){
            $x_period=113;
            $x_report=200;
        }else{
            $x_period=206;
            $x_report=278;
        }    

        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell($x_report, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell($x_report, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(42, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);



        $this->Cell($x, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
#line        $this->Line(11,37,287,37);
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/




    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF();

$pdf->AliasNbPages();

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$rep_id = clean_data($_GET['rep_id']);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);

$acct_id = clean_data($_GET['acct_id']);
$sp_id = clean_data($_GET['sp_id']);
$reg_id = clean_data($_GET['reg_id']);
$stock_code = clean_data($_GET['stock_code']);

$color_id = clean_data($_GET['color_id']);
$size_id = clean_data($_GET['size_id']);
$sale_days = clean_data($_GET['sale_days']);
$recovery_days = clean_data($_GET['recovery_days']);
$order_by = clean_data($_GET['order_by']);

if ($rep_id=='047' ||$rep_id=='052'){
    $pdf->AddPage("P");
}else{
    $pdf->AddPage("L");
}    
    
$and = " and (p.party_type='C')";

switch ($rep_id)
{
    case '028':
        $f_grp_name="r.reg_name";
                $f_acct_name="f_last_sr_amt(p.acct_id, $new_to_date)";
                $f_grp_3_name="f_last_sr_amt(p.acct_id, $new_to_date)";
                $h_grp_2_name="Last Recovery";
        $h_grp_3_name="";

        $f1="substr(p.acct_name,1,93)";
        $f2="concat(f_last_sl_amt(p.acct_id, '$new_to_date'), ' / ',f_last_sl_date(p.acct_id, '$new_to_date'), ' / ',datediff('$new_to_date', f_last_sl_date(p.acct_id, '$new_to_date')), ' days ')";
        $f3="concat(f_last_sr_amt(p.acct_id, '$new_to_date'), ' / ',f_last_sr_date(p.acct_id, '$new_to_date'), ' / ',datediff('$new_to_date', f_last_sr_date(p.acct_id, '$new_to_date')), ' days ')";
        $f5="s.acct_name";
        $f6="datediff('$new_to_date', f_last_sr_date(p.acct_id, '$new_to_date'))/1";

        $h_c1_width="148";
        $h_c2_width="50";

        $h_1_name='Party';
                $h_2_name="Last Sale";
                $h_3_name='Last Recovery';
        $h_4_name="Balance";
        $h_5_name="";

        $order_by='v.amt';
        $asc='desc';

        break;
    case '029':
        $f_grp_name="s.acct_name";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="r.reg_name";
        $h_grp_2_name="City";
        $h_grp_3_name="";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="r.reg_name";
        $f5="s.acct_name";

        $h_c1_width="195";
        $h_c2_width="50";

        $h_1_name='Party';
        $h_2_name='City';
        $h_3_name="";
        $h_4_name="Balance";
        $h_5_name="";

        $order_by='v.amt';
        $asc='desc';

        break;
    case '030':
        $f_grp_name="c.comp_name";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="s.acct_name";
        $h_grp_2_name="City";
        $h_grp_3_name="Agent";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="s.acct_name";
        $f5="s.acct_name";

        $h_c1_width="145";
        $h_c2_width="50";

        $h_1_name='Party';
        $h_2_name='City';
        $h_3_name="Agent";
        $h_4_name="Balance";
        $h_5_name="";

        $order_by='v.amt';
        $asc='desc';

        break;
    case '031':
        $f_grp_name="v.voucher_date";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="s.acct_name";
        $h_grp_2_name="City";
        $h_grp_3_name="Agent";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="s.acct_name";
        $f4="IF(substr(ifnull(v.particulars,''),1,8)<>'Discount',v.credit,0)";
        $f5="s.acct_name";
        $f6="IF(substr(ifnull(v.particulars,''),1,8)='Discount',v.credit,0)";

        $and=" and (substr(v.voucher_type,1,11)<>'Sale Return')";

        $h_c1_width="120";
        $h_c2_width="50";

        $h_1_name='Party';
        $h_2_name='City';
        $h_3_name="Agent";
        $h_4_name="Amount";
        $h_5_name="";
        $h_6_name="Discount";

        $order_by='5';
        $asc='desc';

        break;
    case '032':
        $f_grp_name="s.acct_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f3="r.reg_name";
        $f4="IF(substr(ifnull(v.particulars,''),1,8)<>'Discount',v.credit,0)";
        $f5="s.acct_name";
        $f6="IF(substr(ifnull(v.particulars,''),1,8)='Discount',v.credit,0)";

        $h_c1_width="50";
        $h_c2_width="120";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="City";
        $h_4_name="Amount";
        $h_5_name="";
        $h_6_name="Discount";

        $order_by=$f1;
        $asc='asc';

        $and=" and (substr(v.voucher_type,1,11)<>'Sale Return')";

        break;
    case '033':
        $f_grp_name="c.comp_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f3="r.reg_name";
        $f4="IF(substr(ifnull(v.particulars,''),1,8)<>'Discount',v.credit,0)";
        $f5="s.acct_name";
        $f6="IF(substr(ifnull(v.particulars,''),1,8)='Discount',v.credit,0)";

        $h_c1_width="20";
        $h_c2_width="95";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="City";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="Discount";

        $order_by=$f1;
        $asc='asc';

        $and=" and (substr(v.voucher_type,1,11)<>'Sale Return')";

        break;
    case '034':
        $f_grp_name="r.reg_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f3="r.reg_name";
        $f4="IF(substr(ifnull(v.particulars,''),1,8)<>'Discount',v.credit,0)";
        $f5="s.acct_name";
        $f6="IF(substr(ifnull(v.particulars,''),1,8)='Discount',v.credit,0)";

        $h_c1_width="20";
        $h_c2_width="150";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="Discount";

        $order_by=$f1;
        $asc='asc';

        $and=" and (substr(v.voucher_type,1,11)<>'Sale Return')";

        break;
    case '035':
        $f_grp_name="c.comp_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="r.reg_name";
        $f4="IF(substr(ifnull(v.particulars,''),1,8)<>'Discount',v.credit,0)";
        $f5="s.acct_name";
        $f6="IF(substr(ifnull(v.particulars,''),1,8)='Discount',v.credit,0)";

        $h_c1_width="150";
        $h_c2_width="20";

        $h_1_name='Party';
        $h_2_name="City";
        $h_3_name="";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="Discount";

        $order_by=$f4;
        $asc='desc';

        $and=" and (substr(v.voucher_type,1,11)<>'Sale Return')";

        break;
    case '036':
        $f_grp_name="c.comp_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f4="IF(substr(v.voucher_type,1,5)='Sales',v.debit,0)";
        $f3="r.reg_name";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="20";
        $h_c2_width="125";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="City";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="";

        $order_by=$f1;
        $asc='asc';
        break;
    case '037':
        $f_grp_name="s.acct_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f4="IF(substr(v.voucher_type,1,5)='Sales',v.debit,0)";
        $f3="r.reg_name";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="20";
        $h_c2_width="175";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="City";
        $h_4_name="Amount";
        $h_5_name="";
        $h_6_name="";

        $order_by=$f1;
        $asc='asc';
        break;
    case '038':
        $f_grp_name="r.reg_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f4="IF(substr(v.voucher_type,1,5)='Sales',v.debit,0)";
        $f3="r.reg_name";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="20";
        $h_c2_width="175";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="";

        $order_by=$f4;
        $asc='desc';
        break;
    case '039':
        $f_grp_name="c.comp_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="r.reg_name";
        $f4="IF(substr(v.voucher_type,1,5)='Sales',v.debit,0)";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="145";
        $h_c2_width="50";

        $h_1_name='Party';
        $h_2_name="City";
        $h_3_name="";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="";

        $order_by=$f4;
        $asc='desc';
        break;

    case '040':
        $f_grp_name="c.comp_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="p.acct_name";
        $f4="IF(substr(v.voucher_type,1,11)='Sale Return',v.credit,0)";
        $f3="r.reg_name";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="20";
        $h_c2_width="125";

        $h_1_name='Date';
        $h_2_name='Party';
        $h_3_name="City";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="";

        $order_by=$f1;
        $asc='asc';
        break;

    case '041':
        $f_grp_name="v.stock_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="r.reg_name";
        $f4="v.cr_amt";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="145";
        $h_c2_width="50";

        $h_1_name='Party';
        $h_2_name="City";
        $h_3_name="";
        $h_4_name="Amount";
        $h_5_name="Agent";
        $h_6_name="";

        $order_by=$f4;
        $asc='desc';
        break;

    case '042':
        $f_grp_name="v.stock_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="p.acct_name";
        $f2="r.reg_name";
        $f3="r.reg_name";
        $f4="v.cr_qty";
        $f5="s.acct_name";
        $f6="0";

        $h_c1_width="145";
        $h_c2_width="50";

        $h_1_name='Party';
        $h_2_name="City";
        $h_3_name="";
        $h_4_name="Qty";
        $h_5_name="Agent";
        $h_6_name="";

        $order_by=$f4;
        $asc='desc';
        break;

            case '047':
                $f_grp_name="c.comp_name";
                $f_grp="voucher_date";
                $f_acct_name="null";
                $f_grp_3_name="v.voucher_date";
                $h_grp_2_name="City";

                $f1="v.stock_name";
                $f2="null";
                $f3="null";
                $f4="v.cr_qty";
                $f5="s.acct_name";
                $f6="0";

                $h_c1_width="50";
                $h_c2_width="20";

                $h_1_name='Product';
                $h_2_name="";
                $h_3_name="";
                $h_4_name="Amount";
                $h_5_name="";
                $h_6_name="";

                $order_by=$f4;
                $asc='desc';
                break;

    case '052':
        $f_grp_name="pc.cat_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.stock_name";
        $f2="i.unit";
        $f3="i.party_stock_code";

        $f4="v.cr_qty";
        $f5="round(v.cr_amt)";
        $f6="round(b.bal_qty)";

        $h_c1_width="50";
        $h_c2_width="20";

        $h_1_name='Item';
        $h_2_name="Unit";
        $h_3_name="Part No";

        $h_4_name="Qty";
        $h_5_name="Amount";
        $h_6_name="Balance Qty";

        $order='sum(v.cr_qty)';
        if ($order_by=='Amount')
            $order='sum(v.cr_amt)';
        $asc='desc';
        break;
    case '054':
        $f_grp_name="t.type_name";
        $f_grp="voucher_date";
        $f_acct_name="r.reg_name";
        $f_grp_3_name="v.voucher_date";
        $h_grp_2_name="City";

        $f1="v.voucher_date";
        $f2="i.description";
        $f3="s.acct_name";
        $f4="IF(substr(v.voucher_type,1,5)='Sales',v.cr_amt,0)";
        $f5="null";
        $f6="0";

        $h_c1_width="10";
        $h_c2_width="50";

        $h_1_name='Date';
        $h_2_name='Item';
        $h_3_name="Sale Person";
        $h_4_name="Amount";
        $h_5_name="";
        $h_6_name="";

        $order_by=$f1;
        $asc='asc';
        break;

}


$and = " and p.acct_name is not null";
$and .= " and p.party_type='C'";


if ($rep_id == "040") {
    $and .= " and substr(v.voucher_id,3,2)='RT'";
}elseif ($rep_id != "028" && $rep_id != "029" && $rep_id != "030"){
    $and .= " and substr(v.voucher_id,3,2)<>'RT'";
}

if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}else{
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";
    $comp_name = find_value('system', 'comp_name', "");
}

if ($acct_id != "All")
    $and .= " and p.acct_id = '$acct_id'";

$sp_name='';
if ($sp_id != "All"){
    $and .= " and p.sp_id = '$sp_id'";
    $sp_name=find_value('sp','acct_name'," and acct_id='$sp_id'");
}

if ($reg_id != "All")
    $and .= " and p.reg_id = '$reg_id'";

if ($stock_code != "All")
    $and .= " and v.stock_code = '$stock_code'";

//group total variables
$f4_gtot = 0;
$f5_gtot = 0;
$f6_gtot = 0;


if ($rep_id=="028" || $rep_id=="029" || $rep_id=="030") {
    $and .= " and (v.voucher_date <= '$new_to_date')";


    if ($rep_id=="028"){


        if ($recovery_days>0){
            $and .= " and (datediff('$new_to_date', f_last_sr_date(p.acct_id, '$new_to_date')) >= $recovery_days)";
        }

        if ($sale_days>0)
            $and .= " and (datediff('$new_to_date', f_last_sl_date(p.acct_id, '$new_to_date')) >= $sale_days)";
    }

    $msqlquery = "SELECT DISTINCT $f_grp_name grp_name
            FROM
                 (select v.comp_id, v.acct_id, sum(v.debit-v.credit) amt 
                     from v_vouchers v 
                     LEFT JOIN v_party p on v.acct_id=p.acct_id
                     where 1=1 $and 
                     group by v.comp_id, v.acct_id having sum(v.debit-v.credit)<>0) v
            LEFT JOIN v_party p on v.acct_id=p.acct_id
            LEFT JOIN sp s on p.sp_id=s.acct_id
            LEFT JOIN regions r on p.reg_id=r.reg_id
            LEFT JOIN company c on v.comp_id=c.comp_id
            WHERE $f_grp_name is not null
            ORDER BY 1";
}


if ($rep_id=="031" || $rep_id=="032" || $rep_id=="033" || $rep_id=="034" || $rep_id=="035" || $rep_id=="036" || $rep_id=="037" || $rep_id=="038" || $rep_id=="039" || $rep_id=="040") {
    $and .= " and (v.voucher_date between '$new_from_date' and '$new_to_date')";
    $msqlquery = "SELECT DISTINCT $f_grp_name grp_name
            FROM v_vouchers v
            LEFT JOIN v_party p on v.acct_id=p.acct_id
            LEFT JOIN sp s on p.sp_id=s.acct_id
            LEFT JOIN regions r on p.reg_id=r.reg_id
            LEFT JOIN company c on v.comp_id=c.comp_id
            WHERE $f4<>0 $and
            ORDER BY 1";
}

if ($rep_id=="041" || $rep_id=="042" || $rep_id=="047") {
    $and .= " and (v.voucher_date between '$new_from_date' and '$new_to_date')";
    $msqlquery = "SELECT DISTINCT $f_grp_name grp_name
            FROM v_p_vouchers v
            LEFT JOIN v_party p on v.party_id=p.acct_id
            LEFT JOIN sp s on p.sp_id=s.acct_id
            LEFT JOIN regions r on p.reg_id=r.reg_id
            LEFT JOIN company c on v.comp_id=c.comp_id
            WHERE $f4<>0 $and
            ORDER BY 1";
}

if ($rep_id=="052") {
    $and .= " and (v.voucher_date between '$new_from_date' and '$new_to_date')";

    $msqlquery = "SELECT DISTINCT $f_grp_name grp_name
            FROM v_p_vouchers v
            LEFT JOIN v_party p on v.party_id=p.acct_id
                            LEFT JOIN item i on v.stock_code=i.stock_code
                            LEFT JOIN prod_cat pc on i.cat_id=pc.cat_id
            LEFT JOIN sp s on p.sp_id=s.acct_id
            LEFT JOIN regions r on p.reg_id=r.reg_id
            LEFT JOIN company c on v.comp_id=c.comp_id
            WHERE $f4<>0 $and
            ORDER BY 1";
}

if ($rep_id=="054") {
    $and .= " and (v.voucher_date between '$new_from_date' and '$new_to_date')";

    $msqlquery = "SELECT DISTINCT $f_grp_name grp_name
            FROM v_p_vouchers v
            LEFT JOIN v_party p on v.party_id=p.acct_id
            LEFT JOIN item i on v.stock_code=i.stock_code
            LEFT JOIN prod_cat pc on i.cat_id=pc.cat_id
            LEFT JOIN prod_type t on i.type_id=t.type_id
            LEFT JOIN sp s on p.sp_id=s.acct_id
            LEFT JOIN regions r on p.reg_id=r.reg_id
            LEFT JOIN company c on v.comp_id=c.comp_id
            WHERE $f4<>0 $and
            ORDER BY 1";
}

//   echo $msqlquery;

try {
    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

while($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {

$grp_name = $mrow['grp_name'];
$d_grp_name = $mrow['grp_name'];

if ($rep_id==("031"))
    $d_grp_name = format_date($grp_name);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Ln(8);

$pdf->Cell(1);
$pdf->Cell(20, 8, $d_grp_name, 0, 0, 'l');

$pdf->SetFont('Arial', '', 8);

if ($rep_id=="028" || $rep_id=="029" || $rep_id=="030")
                $d_query = "SELECT $f1 f1, $f2 f2, $f3 f3, v.amt f4, $f5 f5, $f6 f6
                            FROM
                             (select v.comp_id, v.acct_id, sum(v.debit-v.credit) amt 
                                 from v_vouchers v 
                                 LEFT JOIN v_party p on v.acct_id=p.acct_id
                                 where 1=1 $and 
                                 group by v.comp_id, v.acct_id having sum(v.debit-v.credit)<>0) v
                            LEFT JOIN v_party p on v.acct_id=p.acct_id
                            LEFT JOIN sp s on p.sp_id=s.acct_id
                            LEFT JOIN regions r on p.reg_id=r.reg_id
                            LEFT JOIN company c on v.comp_id=c.comp_id
                            WHERE $f_grp_name='$grp_name'
                            ORDER BY v.amt desc";

if ($rep_id=="031" || $rep_id=="032" || $rep_id=="033" || $rep_id=="034" || $rep_id=="036" || $rep_id=="037" || $rep_id=="038" || $rep_id=="040")
    $d_query = "SELECT $f1 f1, $f2 f2, $f3 f3, $f5 f5, $f4 f4, $f6 f6
                            FROM v_vouchers v
                            LEFT JOIN v_party p on v.acct_id=p.acct_id
                            LEFT JOIN sp s on p.sp_id=s.acct_id
                            LEFT JOIN regions r on p.reg_id=r.reg_id
                            LEFT JOIN company c on v.comp_id=c.comp_id
                            WHERE ($f4<>0 or $f6<>0) $and and $f_grp_name='$grp_name'
                            ORDER BY $order_by $asc";

if ($rep_id=="035" || $rep_id=="039")
    $d_query = "SELECT $f1 f1, $f2 f2, $f3 f3, $f5 f5, sum($f4) f4, sum($f6) f6
                            FROM v_vouchers v
                            LEFT JOIN v_party p on v.acct_id=p.acct_id
                            LEFT JOIN sp s on p.sp_id=s.acct_id
                            LEFT JOIN regions r on p.reg_id=r.reg_id
                            LEFT JOIN company c on v.comp_id=c.comp_id
                            WHERE ($f4<>0 or $f6<>0) $and and $f_grp_name='$grp_name'
                            GROUP BY $f1
                            ORDER BY sum($f4) $asc";

if ($rep_id=="041" || $rep_id=="042" || $rep_id=="047")
    $d_query = "SELECT $f1 f1, $f2 f2, $f3 f3, $f5 f5, sum($f4) f4, sum($f6) f6
                            FROM v_p_vouchers v
                            LEFT JOIN v_party p on v.party_id=p.acct_id
                            LEFT JOIN sp s on p.sp_id=s.acct_id
                            LEFT JOIN regions r on p.reg_id=r.reg_id
                            LEFT JOIN company c on v.comp_id=c.comp_id
                            WHERE ($f4<>0 or $f6<>0) $and and $f_grp_name='$grp_name'
                            GROUP BY $f1
                            ORDER BY sum($f4) $asc";

    if ($rep_id=="052"){

        $d_query = "SELECT $f1 f1, $f2 f2, $f3 f3, $f6 f6, sum($f4) f4, sum($f5) f5
                            FROM v_p_vouchers v
                            LEFT JOIN v_party p on v.party_id=p.acct_id
                            LEFT JOIN item i on v.stock_code=i.stock_code
                            LEFT JOIN (select stock_code, sum(db_qty-cr_qty) bal_qty from v_stk where voucher_date<='$new_to_date' group by stock_code) b on i.stock_code=b.stock_code
                            LEFT JOIN prod_cat pc on i.cat_id=pc.cat_id
                            LEFT JOIN sp s on p.sp_id=s.acct_id
                            LEFT JOIN regions r on p.reg_id=r.reg_id
                            LEFT JOIN company c on v.comp_id=c.comp_id
                            LEFT JOIN color on v.color_id=color.color_id
                            WHERE ($f5<>0 or $f6<>0) $and and $f_grp_name='$grp_name'
                            GROUP BY $f1
                            ORDER BY $order $asc";
    }

    if ($rep_id=="054"){

        $d_query = "SELECT $f1 f1, $f2 f2, $f3 f3, $f6 f6, sum($f4) f4, sum($f5) f5
                            FROM v_p_vouchers v
                            LEFT JOIN v_party p on v.party_id=p.acct_id
                            LEFT JOIN item i on v.stock_code=i.stock_code
                            LEFT JOIN prod_cat pc on i.cat_id=pc.cat_id
                            LEFT JOIN prod_type t on i.type_id=t.type_id
                            LEFT JOIN sp s on p.sp_id=s.acct_id
                            LEFT JOIN regions r on p.reg_id=r.reg_id
                            LEFT JOIN company c on v.comp_id=c.comp_id
                            WHERE ($f4<>0) $and and $f_grp_name='$grp_name'
                            GROUP BY $f1
                            ORDER BY $order_by $asc";
    }

//    echo $d_query;



try {
    $d_result = $dbcon->prepare($d_query);
    $d_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}




    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(10, 8, 'Sr', 1, 0, '');
    $pdf->Cell($h_c1_width, 8, $h_1_name, 1, 'C');
    $pdf->Cell($h_c2_width, 8, $h_2_name, 1, 'C');

    if ($h_3_name<>''){
        $pdf->Cell(45, 8, $h_3_name, 1, 0,'');
    }

    $pdf->Cell(25, 8, $h_4_name, 1, 0,'R');

    if ($h_5_name<>''){
        $pdf->Cell(25, 8, $h_5_name, 1, 0,'R');
    }


    if ($h_6_name<>''){
        $pdf->Cell(25, 8, $h_6_name, 1, 0,'R');
    }
    $pdf->SetFont('Arial', '', 8);



    $serno = 0;
    $f4_tot = 0;
    $f5_tot = 0;
    $f6_tot = 0;
    while($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {
        $serno = $serno + 1;

        $f4_tot += $report_row['f4'];
        $f5_tot += $report_row['f5'];
        $f6_tot += $report_row['f6'];

        $f1_value=$report_row['f1'];
        if ($f1=='v.voucher_date')
            $f1_value=format_date($report_row['f1']);

        $f2_Value=$report_row['f2'];
        $f3_Value=$report_row['f3'];
        $f5_Value=$report_row['f5'];
        $f6_Value=$report_row['f6'];

        $pdf->Ln(8);

        $pdf->Cell(1);
        $pdf->Cell(10, 8, $serno, 1, 0, 'l');
        $pdf->Cell($h_c1_width, 8, $f1_value, 1, '');

        $pdf->Cell($h_c2_width, 8, $f2_Value, 1, 0, '');

        if ($h_3_name<>''){
        $pdf->Cell(45, 8, $f3_Value, 1, 0, '');
        };

        if($h_4_name=='Balance'){
            $pdf->Cell(25, 8, format_number_drcr($report_row['f4'],0), 1, 0, 'R');
        }else{
            $pdf->Cell(25, 8, format_number_pdf($report_row['f4'],0), 1, 0, 'R');
        }

        if ($h_5_name<>''){
            $pdf->Cell(25, 8, $f5_Value, 1, 0, 'R');
        };


        if ($h_6_name<>''){
            $pdf->Cell(25, 8, format_number_pdf($f6_Value,0), 1, 0, 'R');
        };

    }

    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 8);

    $pdf->Cell(1);
    $pdf->Cell(10, 8, '', 1, 0, 'l');
    $pdf->Cell($h_c1_width, 8, '', 1, 0, 'R');
    $pdf->Cell($h_c2_width, 8, 'Total', 1, 0, 'R');

    if ($h_3_name<>''){
        $pdf->Cell(45, 8, '', 1, 0, '');
    };

    if($h_4_name=='Balance'){
        $pdf->Cell(25, 8, format_number_drcr($f4_tot,0), 1, 0, 'R');
    }else{
        $pdf->Cell(25, 8, format_number_pdf($f4_tot,0), 1, 0, 'R');
    }


    if ($h_5_name<>''){
        $pdf->Cell(25, 8, format_number_pdf($f5_tot,0), 1, 0, 'R');
    };

    if ($h_6_name<>''){
        $pdf->Cell(25, 8, format_number_pdf($f6_tot,0), 1, 0, 'R');
    };

    $f4_gtot += $f4_tot;
    $f5_gtot += $f5_tot;
    $f6_gtot += $f6_tot;

}

$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(1);
$pdf->Cell(10, 8, '', 1, 0, 'l');
$pdf->Cell($h_c1_width, 8, '', 1, 0, 'R');
$pdf->Cell($h_c2_width, 8, 'Grand Total', 1, 0, 'R');

        if ($h_3_name<>''){
            $pdf->Cell(45, 8, '', 1, 0, '');
       };


if($h_4_name=='Balance'){
    $pdf->Cell(25, 8, format_number_drcr($f4_gtot,0), 1, 0, 'R');
}else{
    $pdf->Cell(25, 8, format_number_pdf($f4_gtot,0), 1, 0, 'R');
}

if ($h_5_name<>''){
    $pdf->Cell(25, 8, format_number_pdf($f5_gtot,0), 1, 0, 'R');
};

if ($h_6_name<>''){
    $pdf->Cell(25, 8, format_number_pdf($f6_gtot,0), 1, 0, 'R');
};

$pdf->Output();