<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $comp_id = clean_data($_SESSION["comp_id"]);
        $year_id = clean_data($_SESSION["year_id"]);

        $_SESSION['v_id']= $_GET['v_id'];
        $v_id = clean_data($_SESSION['v_id']);

        $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
        $phone=find_value('company','phone'," and comp_id='$comp_id'");
        $address=find_value('company','add_line1'," and comp_id='$comp_id'");
        $add_line2=find_value('company','add_line2'," and comp_id='$comp_id'");
        $ntn=find_value('company','ntn'," and comp_id='$comp_id'");

#        $this->Image('img/agm/header.GIF',10,6,195);

        $this->SetFont('Arial', 'BIU', 24);

        $this->Ln(10);
        $this->Cell(0,10, 'SALES TAX INVOICE',0,0,'C');
//        $this->Cell(0,10, strtoupper($comp_name),0,0,'C');

        $this->Ln(10);
        $this->Ln(10);

        $and = " AND d.voucher_id = '$v_id'";
        $and .= " AND v.comp_id = '$comp_id'";
        $and .= " AND v.year_id = '$year_id'";

        try
        {
            $voucher_query =  "SELECT v.acct_id, v.voucher_id, v.voucher_date, d.particulars , c.comp_name, c.add_line1,c.phone,c.email,
c.stax_no, c.ntn, p.acct_name party_name, p.address add_line1, p.city, c.phone c_phone, p.phone, p.ntn party_ntn, p.stax_no party_stax_no, p.cnic
	FROM sl_invoice v 
	LEFT JOIN sl_invoicedet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id AND v.year_id = d.year_id
	LEFT JOIN company c ON c.comp_id = d.comp_id
	LEFT JOIN v_party p ON p.acct_id = v.acct_id
	WHERE 1=1  $and";
            $voucher_result = $dbcon->prepare($voucher_query);
            $voucher_result->execute(array());
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }





        $report_row = $voucher_result->fetch(PDO::FETCH_ASSOC);

        $phone = $report_row['c_phone'];

        $ntn = $report_row['ntn'];
        $stax_no = $report_row['stax_no'];

        $party_name = $report_row['party_name'];
        $p_address = $report_row['add_line1'];
        $p_city = $report_row['city'];
        $p_phone = $report_row['phone'];
        $party_ntn = $report_row['party_ntn'];
        $party_stax_no = $report_row['party_stax_no'];
        $cnic = $report_row['cnic'];



        $this->SetFont('Arial', '', 10);

        $this->Ln(10);

        $this->Cell(150, 10, 'Inv No: '. ($report_row['voucher_id']), 0);
        $this->SetFont('Arial', '', 9);
        $this->Cell(10);
        $this->Cell(5, 10, 'Inv Date: '.format_date($report_row['voucher_date']).'', 0);
        $this->Ln(15);
        $this->SetFont('Arial', 'B', 11);
        $this->Cell(70, 8, '', 0);
        $this->SetLeftMargin('10');
        $this->Ln(1);



        /***********************START SUPPLIER BLOCK******************/
        $this->SetFont('Arial', 'B', 14);

        $this->Cell(1);
        $this->setFillColor(230,230,230);
        $this->Cell(95, 10, 'SUPPLIER', 1,0,'C', true);
        $this->Cell(2);
        $this->setFillColor(230,230,230);
        $this->Cell(95, 10, 'BUYER', 1,1,'C', true);

        $this->SetFont('Arial', '', 8);
        //SYPPLIER NAME
        $this->Ln(10);
        $this->Cell(95, 0, 'Name:   ', 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, $comp_name, 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');

        //BUYER NAME
        $this->Cell(97);
        $this->Cell(95, 0, 'Name:', 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, $party_name, 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');


        $this->Ln(2);

        //SUPPLIER ADDRESS
        $this->Ln(10);
        $this->Cell(95, 0, 'Address:', 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, substr($address,0,50), 0,1,'L');


        $this->Cell(97);
        $this->Cell(95, 0, 'Address:', 0,1,'L');

 
        $this->Cell(110);
        $this->Cell(95, 0, $p_address, 0,1,'L');

        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');

        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');

 
        $this->Ln(10);
        $this->Cell(95, 0, 'City:', 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, substr($add_line2,0,50), 0,1,'L');


        $this->Cell(97);
        $this->Cell(95, 0, 'City:', 0,1,'L');

 
        $this->Cell(110);
        $this->Cell(95, 0, $p_city, 0,1,'L');

        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');

        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');


        //BUYER ADDRESS
 

        $this->Ln(2);

        //SUPPLIER PHONE
        $this->Ln(10);
        $this->Cell(95, 0, 'Phone:', 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, $phone, 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');


        //BUYER PHONE
        $this->Cell(97);
        $this->Cell(95, 0, 'Phone:', 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, $p_phone, 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');



        $this->Ln(2);

        //SUPPLIER NTN
        $this->Ln(10);
        $this->Cell(95, 0, 'NTN:', 0,1,'L');

        //BUYER NTN
        $this->Cell(97);
        $this->Cell(95, 0, 'NTN:', 0,1,'L');

        $this->Cell(12);
        $this->Cell(95, 0, $ntn, 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, $party_ntn, 0,1,'L');

        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');

        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');




        //SUPPLIER SALE TAX
        $this->Ln(10);
        $this->Cell(95, 0, 'S TAX#:', 0,1,'L');
        $this->Cell(97);
        $this->Cell(95, 0, 'S TAX#:', 0,1,'L');


        $this->Cell(12);
        $this->Cell(95, 0, $stax_no, 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, $party_stax_no, 0,1,'L');



        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');




        $this->Ln(2);

        //SUPPLIER CNIC
        $this->Ln(10);
        $this->Cell(95, 0, '', 0,1,'L');
        $this->Cell(12);
        $this->Cell(95, 0, '', 0,1,'L');
        $this->Cell(14);
        $this->Cell(95, 0, '', 0,1,'L');


        //BUYER CNIC
        $this->Cell(95, 0, 'CNIC:', 0,1,'L');


        $this->Cell(97);
        $this->Cell(95, 0, 'CNIC:', 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, $cnic, 0,1,'L');

        $this->Cell(12);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');
        $this->Cell(110);
        $this->Cell(95, 0, '____________________________________________________', 0,1,'L');

        $this->Ln(5);


        /***********************END SUPPLIER BLOCK******************/




        /*****************END MASTER TABLE QUERY*****************/

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(8, 8, 'Sr', 1);
        $this->Cell(43, 8, 'Particulars', 1);
        $this->Cell(15, 8, 'Qty', 1, 0,'R');
        $this->Cell(20, 8, 'Rate', 1, 0,'R');
        $this->Cell(20, 8, 'Value', 1, 0,'R');
        $this->Cell(15, 8, 'Reg', 1, 0,'R');
        $this->Cell(15, 8, 'Add', 1, 0,'R');
        $this->Cell(15, 8, 'Stax %', 1, 0,'R');
        $this->Cell(20, 8, 'Stax', 1, 0,'R');
        $this->Cell(20, 8, 'Amount', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");

$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$_SESSION['v_id']= $_GET['v_id'];
$v_id = clean_data($_SESSION['v_id']);

$and = " AND d.voucher_id = '$v_id'";
$and .= " AND d.comp_id = '$comp_id'";
$and .= " AND d.year_id = '$year_id'";


try
{
    $vd_query =  "SELECT
	d.stock_code,
	d.particulars,
	d.qty,
	d.rate,
	d.voucher_id,
	i.description,
	d.qty*d.rate ex_value,
	d.itemtot,
	d.lineitem,
	c.comp_name,
	d.comp_id,
	d.discp,
	d.lineitem,
	d.discount,
	d.sharing,
	d.avg_rate,
	d.staxp,
	d.add_staxp,
	d.stax_rate,
	d.stax,
    ifnull(d.staxp,0)-ifnull(add_staxp,0) r_staxp,
    ifnull(d.stax,0)-ifnull((d.qty*d.rate)*d.add_staxp*.1,0) r_stax,
    ifnull((d.qty*d.rate)*d.add_staxp*.1,0) add_stax,
    d.stax
 	FROM sl_invoice m 
 	LEFT JOIN sl_invoicedet d ON m.voucher_id = d.voucher_id and m.comp_id = d.comp_id and m.year_id=d.year_id
	LEFT JOIN item i ON d.stock_code = i.stock_code

	LEFT JOIN company c ON c.comp_id = m.comp_id  
 	
 	WHERE 1=1  $and";
    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = "";
$tot_ex_value=0;
$tot_r_stax=0;
$tot_add_stax=0;
$tot_stax=0;
$tot_r_stax=0;
$tot_itemtot=0;
$tot_qty=0;
$total_stax = "";

while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

    $tot_ex_value += $rd_row['ex_value'];
    $tot_r_stax += $rd_row['r_stax'];
    $tot_add_stax += $rd_row['add_stax'];
    $tot_stax += $rd_row['stax'];
    $tot_itemtot += $rd_row['itemtot'];
    $tot_qty += $rd_row['qty'];

    $sale_tax = $rd_row->staxp - $rd_row->add_staxp;

    $total_stax = $rd_row['staxp'] + $rd_row['add_staxp'];


    $sr += 1;
    $pdf->Cell(1);
    $pdf->Cell(8, 8, $sr.'.', 1);
    $pdf->Cell(43, 8, $rd_row['description'], 1);
    $pdf->Cell(15, 8, $rd_row['qty'], 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rd_row['rate'],2), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rd_row['ex_value'],2), 1, 0,'R');
    $pdf->Cell(15, 8, format_number_pdf($rd_row['r_staxp'],2), 1, 0,'R');
    $pdf->Cell(15, 8, format_number_pdf($rd_row['add_staxp'],2), 1, 0,'R');
    $pdf->Cell(15, 8, format_number_pdf($rd_row['staxp'],2), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rd_row['stax'],2), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rd_row['itemtot'],2), 1, 0,'R');

    $pdf->Ln(8);
}

    while ($sr<10){
        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(8, 8, $sr.'.', 1);
        $pdf->Cell(43, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(15, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Ln(8);
    }

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(30);
$pdf->Cell(15,8,'Total',0,0,'R');
$pdf->Cell(10);
$pdf->Cell(15,8,format_number_pdf($tot_qty,3),0,0, 'C');
$pdf->Cell(20);
$pdf->Cell(17,8,format_number_pdf($tot_ex_value,2),0,0, 'R');
$pdf->Cell(20);
$pdf->Cell(25);
$pdf->Cell(20,8,format_number_pdf($tot_stax,2),0,0, 'R');
$pdf->Cell(20,8,format_number_pdf($tot_itemtot,2),0,0, 'R');


$pdf->Ln(12);

$nw=new NumbersToWords();

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(15,8,'Amount : Rs. ',0);
$pdf->SetFont('Arial', 'U', 8);
$pdf->Cell(3);
$pdf->Cell(50,8,strtoupper($nw->convert($tot_itemtot)).' ONLY',0);

$pdf->Output();