<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'Sale Persons Invoices Report';

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
        $comp_id = $_GET['comp_id'];
        $acct_id = $_GET['acct_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);


        if ($comp_id != "All") {
            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('system', 'comp_name', "");
        }


        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', '', 8);
        $this->Cell(278, 10, format_date($from_date) .' To ' . format_date($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/



    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
        $comp_id = $_GET['comp_id'];
        $acct_id = $_GET['acct_id'];
        $rpt_type = clean_data($_GET['rpt_type']);

        
        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);


            $and = '';
            $and .= " and (m.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

            if ($comp_id != "All") {

                $and .= " and m.comp_id = '$comp_id'";
            } else {
                $and .= " and m.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";
            }

            if ($acct_id != "All") {
                $and .= " and m.sp_id = '$acct_id'";
            }

            if ($rpt_type == "Due")
                $and .= " and (ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(rec.rec_amt,0)>0)";
            if ($rpt_type == "Clear")
                $and .= " and (ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(rec.rec_amt,0)=0)";
            if ($rpt_type == "Excess")
                $and .= " and (ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(rec.rec_amt,0)<0)";


$pdf->SetFont('Arial', 'B', 18);
$pdf->Ln(10);
$pdf->Cell(1);
$pdf->Cell(278, 10, 'SUMMARY', 0, 0, 'C');

$pdf->SetFont('Arial', 'B', 8);

$pdf->Ln(10);

$pdf->Cell(1);
$pdf->Cell(90, 8, 'SALE PERSON', 1);

$pdf->Cell(20, 8, 'INVOICES', 1, 0,'R');
$pdf->Cell(20, 8, 'AMOUNT', 1, 0,'R');
$pdf->Cell(20, 8, 'DISCOUNT', 1, 0,'R');
$pdf->Cell(20, 8, 'RECEIVED', 1, 0,'R');
$pdf->Cell(20, 8, 'BALANCE', 1, 0,'R');
$pdf->Cell(20, 8, 'RETURN', 1, 0,'R');
$pdf->Cell(20, 8, 'PROFIT', 1, 0,'R');
$pdf->Cell(20, 8, '%', 1, 0,'R');
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

$profittot = 0;

try {
    $msqlquery = "SELECT    sum(p.profit) profit 
                            FROM sl_invoice m
                            LEFT JOIN (select v_no, sum(credit) rec_amt from voucherdet where v_no<>'' group by v_no) rec on m.bill_no=rec.v_no
                            LEFT JOIN (select bill_no, sum(net_amt) rtn_amt from sl_return group by bill_no) r2 on m.bill_no=r2.bill_no
                            LEFT JOIN v_party p on m.acct_id=p.acct_id
                            LEFT JOIN sp on m.sp_id=sp.acct_id
                            LEFT JOIN (select concat(comp_id,year_id,voucher_id) voucher_id, sum(if(ifnull(avg_rate,0)=0,0, itemtot-(avg_rate*qty))) profit  from sl_invoicedet group by concat(comp_id,year_id,voucher_id)) p on concat(m.comp_id,m.year_id,m.voucher_id)=p.voucher_id
                          WHERE 1=1 $and  
                          ";
#echo $msqlquery;

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}
while($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {
$profittot = $mrow['profit'];
    
}



try {
    $msqlquery = "SELECT m.sp_id, sp.acct_name sp_name,
                                    count(m.voucher_id) invoices,
                                    sum(ifnull(m.net_amt,0)+ifnull(m.disc_amt,0)) net_amt, 
                                    sum(m.disc_amt) disc_amt, 
                                    sum(ifnull(m.adv_amt,0)+ifnull(rec.rec_amt,0)) rec_amt,
                                    sum(r2.rtn_amt) rtn_amt, 
                                    sum(ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(rec.rec_amt,0)) bal_amt,
                                    sum(p.profit) profit 
                            FROM sl_invoice m
                            LEFT JOIN (select v_no, sum(credit) rec_amt from voucherdet where v_no<>'' group by v_no) rec on m.bill_no=rec.v_no
                            LEFT JOIN (select bill_no, sum(net_amt) rtn_amt from sl_return group by bill_no) r2 on m.bill_no=r2.bill_no
                            LEFT JOIN v_party p on m.acct_id=p.acct_id
                            LEFT JOIN sp on m.sp_id=sp.acct_id
                            LEFT JOIN (select concat(comp_id,year_id,voucher_id) voucher_id, sum(if(ifnull(avg_rate,0)=0,0, itemtot-(avg_rate*qty))) profit  from sl_invoicedet group by concat(comp_id,year_id,voucher_id)) p on concat(m.comp_id,m.year_id,m.voucher_id)=p.voucher_id
                          WHERE 1=1 $and  
                          GROUP BY m.sp_id, sp.acct_name
                          ORDER BY 9 desc";
#echo $msqlquery;

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$invoices_tot =0;
$net_amt_tot =0;
$disc_amt_tot=0;
$rec_amt_tot=0;
$bal_amt_tot=0;
$rtn_amt_tot=0;
$profit_tot = 0;

while($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {

    $invoices_tot += $mrow['invoices'];
    $net_amt_tot += $mrow['net_amt'];
    $disc_amt_tot += $mrow['disc_amt'];
    $rec_amt_tot += $mrow['rec_amt'];
    $bal_amt_tot += $mrow['bal_amt'];
    $rtn_amt_tot += $mrow['rtn_amt'];
    $profit_tot += $mrow['profit'];

    $pdf->Cell(1);
    $pdf->Cell(90, 8, substr($mrow['sp_name'],0,50).$pad, 1);
    $pdf->Cell(20, 8, format_number_pdf($mrow['invoices'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($mrow['net_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($mrow['disc_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($mrow['rec_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($mrow['bal_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($mrow['rtn_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($mrow['profit'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf(($mrow['profit']/$profittot)*100,0), 1, 0,'R');
    $pdf->Ln(8);


}

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(90, 8, 'Total:', 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($invoices_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($net_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($disc_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($rec_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($bal_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($rtn_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($profit_tot,0), 1, 0,'R');
$pdf->Ln(8);


$pdf->Ln(10);

$pdf->SetFont('Arial', 'B', 18);
$pdf->Cell(278, 10, 'DETAIL', 0, 0, 'C');



$pdf->Ln(10);
$pdf->Cell(1);
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(15, 8, 'Date', 1,'C');
$pdf->Cell(15, 8, 'Bill No', 1,'C');
$pdf->Cell(60, 8, 'Customer Name', 1);
$pdf->Cell(70, 8, 'Items', 1);

$pdf->Cell(20, 8, 'Amount', 1, 0,'R');
$pdf->Cell(20, 8, 'Discount', 1, 0,'R');
$pdf->Cell(20, 8, 'Received', 1, 0,'R');
$pdf->Cell(20, 8, 'Balance', 1, 0,'R');
$pdf->Cell(20, 8, 'Return', 1, 0,'R');
$pdf->Cell(20, 8, 'Profit', 1, 0,'R');
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);

try
{
    $v_query =  "SELECT DISTINCT m.sp_id, sp.acct_name sp_name
                            FROM sl_invoice m
                            LEFT JOIN (select v_no, sum(credit) rec_amt from voucherdet where v_no<>'' group by v_no) rec on m.bill_no=rec.v_no
                            LEFT JOIN (select bill_no, sum(net_amt) rtn_amt from sl_return group by bill_no) r2 on m.bill_no=r2.bill_no
                            LEFT JOIN v_party p on m.acct_id=p.acct_id
                            LEFT JOIN sp on m.sp_id=sp.acct_id
                            LEFT JOIN (select concat(comp_id,year_id,voucher_id) voucher_id, sum(if(ifnull(avg_rate,0)=0,0, itemtot-(avg_rate*qty))) profit  from sl_invoicedet group by concat(comp_id,year_id,voucher_id)) p on concat(m.comp_id,m.year_id,m.voucher_id)=p.voucher_id
                          WHERE 1=1  $and  ORDER BY 2";

#echo $v_query;

    $v_result = $dbcon->prepare($v_query);
    $v_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$g_sr = '';

$g_net_amt_tot = '';
$g_disc_amt_tot = '';
$g_rec_amt_tot = '';
$g_rtn_amt_tot = '';
$g_bal_amt_tot = '';
$g_profit_tot=0;


while ($v_row = $v_result->fetch(PDO::FETCH_ASSOC)) {

    $sp_id = $v_row['sp_id'];
    $sp_name = $v_row['sp_name'];

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(90, 8, $sp_name, 1);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(8);

    try
    {
        $vd_query =  "SELECT DISTINCT m.voucher_id, m.voucher_date,  m.bill_no, 
                                  concat(p.acct_name,concat(if(m.customer_name='','',' / ')), m.customer_name) party_name,
                                    ifnull(m.net_amt,0)+ifnull(m.disc_amt,0) net_amt, 
                                    m.disc_amt, 
                                    ifnull(m.adv_amt,0)+ifnull(rec.rec_amt,0) rec_amt,
                                    r2.rtn_amt, 
                                    ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(rec.rec_amt,0) bal_amt, 
                                    m.comp_id,  m.posted, m.disc_amt, f_sl_invoice_products(m.comp_id,m.year_id,m.voucher_id) items, sp.acct_name sp_name,
                                    p.profit
                    FROM sl_invoice m
                    LEFT JOIN (select v_no, sum(credit) rec_amt from voucherdet where v_no<>'' group by v_no) rec on m.bill_no=rec.v_no
                    LEFT JOIN (select bill_no, sum(net_amt) rtn_amt from sl_return group by bill_no) r2 on m.bill_no=r2.bill_no
                    LEFT JOIN v_party p on m.acct_id=p.acct_id
                    LEFT JOIN sp on m.sp_id=sp.acct_id
                    LEFT JOIN (select concat(comp_id,year_id,voucher_id) voucher_id, sum(if(ifnull(avg_rate,0)=0,0, itemtot-(avg_rate*qty))) profit  from sl_invoicedet group by concat(comp_id,year_id,voucher_id)) p on concat(m.comp_id,m.year_id,m.voucher_id)=p.voucher_id
                    WHERE 1=1  $and and m.sp_id='$sp_id'
                    ORDER BY m.voucher_date, m.bill_no";

#echo $vd_query;

        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }



$sr = "";
            $net_amt_tot = '';
            $disc_amt_tot = '';
            $rec_amt_tot = '';
            $rtn_amt_tot = '';
            $bal_amt_tot = '';
            $profit_tot = '';


while ($vd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {


                    $net_amt_tot += $vd_row['net_amt'];
                    $disc_amt_tot += $vd_row['disc_amt'];
                    $rec_amt_tot += $vd_row['rec_amt'];
                    $bal_amt_tot += $vd_row['bal_amt'];
                    $rtn_amt_tot += $vd_row['rtn_amt'];
                    $profit_tot += $vd_row['profit'];

    $sr += 1;
    $pad='';

        if (strlen($report_row['items'])>50)
            $pad='...';

        $pdf->Cell(1);
        $pdf->Cell(15, 8, format_date($vd_row['voucher_date']), 1);
        $pdf->Cell(15, 8, $vd_row['bill_no'], 1);
        $pdf->Cell(60, 8, $vd_row['party_name'], 1);
        $pdf->Cell(70, 8, substr($vd_row['items'],0,40).$pad, 1);
        $pdf->Cell(20, 8, format_number_pdf($vd_row['net_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['disc_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['rec_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['bal_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['rtn_amt'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($vd_row['profit'],0), 1, 0,'R');
        $pdf->Ln(8);
    
}

    $g_sr += $sr;
    $g_net_amt_tot += $net_amt_tot;
    $g_disc_amt_tot += $disc_amt_tot;
    $g_rec_amt_tot += $rec_amt_tot;
    $g_bal_amt_tot += $bal_amt_tot;
    $g_rtn_amt_tot += $rtn_amt_tot;
    $g_profit_tot += $profit_tot;

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(160, 8, 'Total : ' . $sr . ' Invoices', 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($net_amt_tot), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($disc_amt_tot), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rec_amt_tot), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($bal_amt_tot), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rtn_amt_tot), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($profit_tot), 1, 0,'R');
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(8);

}


$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(1);
$pdf->Cell(160, 8, 'Grand Total : ' . $g_sr . ' Invoices', 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_net_amt_tot), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_disc_amt_tot), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_rec_amt_tot), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_bal_amt_tot), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_rtn_amt_tot), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_profit_tot), 1, 0,'R');

$pdf->Output();
ob_end_flush();