<?php

session_start();

ob_start();

include("include/dbconnect.php");

include("include/functions.php");

require_once ("tcpdf/tcpdf.php");

if($_SESSION['VALID_USER_NAME'] == false)

{

    header("location: login");

}





class PDF extends TCPDF

{

    /************START PAGE HEADER*********/

    function Header()

    {

        $font_cal = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Regular.ttf', 'TrueTypeUnicode', '', 32);
        $font_cal_bold = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Bold.TTF', 'TrueTypeUnicode', '', 32);


        include("include/dbconnect.php");



        $rep_id = clean_data($_GET['rep_id']);

        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");



        $comp_id = $_GET['comp_id'];



        $from_date = clean_data($_GET['from_date']);

        $change_from_date = strtotime($from_date);

        $new_from_date = date('Y-m-d', $change_from_date);



        $to_date = clean_data($_GET['to_date']);

        $change_to_date = strtotime($to_date);

        $new_to_date = date('Y-m-d', $change_to_date);



        if ($comp_id != "All") {



            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");

        }

        else

        {

            $comp_name = find_value('system', 'comp_name', "");

        }



        if ($this->page == 1) {

            $run_time = date('l, F jS, Y H:i:s A');


            $this->SetFont($font_cal, 'B', 18);

            $this->Cell(0, 10, strtoupper($comp_name), 0, 0, 'C');

            $this->Ln(10);

            $this->SetFont($font_cal, 'U', 18);

            $this->Cell(0, 10, $rep_name, 0, 0, 'C');

            $this->Ln(10);


            $this->SetFont($font_cal, 'I', 7);

            $this->SetLeftMargin(5);
            $this->Cell(0, 5, 'Report Run on : ' . $run_time, 0, 0, 'L');

            $this->SetFont($font_cal, 'B', 8);


            //$this->Cell(0, 10, 'Date : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');

        }

        $this->Ln(30);



        //$this->Image('images/StockSummaryHeader.jpg',10,47,336);










    }




}



$pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'PDF_PAGE_FORMAT', true, 'UTF-8', false);


$font_cal = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Regular.ttf', 'TrueTypeUnicode', '', 32);
$font_cal_bold = TCPDF_FONTS::addTTFfont('tcpdf/fonts/Calibri/Calibri Bold.TTF', 'TrueTypeUnicode', '', 32);




$pdf->AddPage("P", 'A4');
$pdf->SetAutoPageBreak(true);
$pdf->SetPrintFooter(false);



$comp_id = $_GET['comp_id'];

$emp_id = clean_data($_SESSION["VALID_USER_ID"]);





$from_date = clean_data($_GET['from_date']);

$change_from_date = strtotime($from_date);

$new_from_date = date('Y-m-d', $change_from_date);



$to_date = clean_data($_GET['to_date']);

$change_to_date = strtotime($to_date);

$new_to_date = date('Y-m-d', $change_to_date);



$acct_id = clean_data($_GET['acct_id']);

$cat_id = clean_data($_GET['cat_id']);

$loc_id = clean_data($_GET['loc_id']);



/*************START FINDE COMPANY NAME***************/

if ($comp_id != "All") {



    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");

}

else

{

    $comp_name = find_value('system', 'comp_name', "");



}

/*************END FINDE COMPANY NAME*****************/



$and = "";

$and_comp = "";



if ($comp_id != "All") {

    $and_comp .= " and v.comp_id = '$comp_id'";

}

else

{

    $and_comp .= " and v.comp_id in(SELECT c.comp_id FROM company c

				LEFT JOIN users_comp uc on c.comp_id=uc.comp_id

				WHERE uc.emp_id = '$emp_id' )";

}



if ($acct_id != "All") {

    $and .= " and v.stock_code = '$acct_id'";

}



if ($cat_id != "All") {

    $and .= " and i.cat_id = '$cat_id'";

}

$and .= " and (v.db_qty is not null or v.cr_qty is not null)";
if ($loc_id != "All") {

    $and .= " and v.loc_id = '$loc_id'";

}





/*****************START GRAND TOTAL VARIABLES**************/

$g_tot_dbqty = 0;

$g_tot_crqty = 0;

$g_bal = 0;

$g_acct_id = '';

/*****************END GRAND TOTAL VARIABLES**************/

$pdf->Ln(20);

//group query date

$g_voucher_Date = '';
$pdf->SetFont($font_cal, 'B', 14);
$pdf->Cell(150, 8, 'Item Name', 1, 0, 'L');
$pdf->Cell(30, 8, 'Qty', 1, 0, 'R');

try {

    $msqlquery = "CREATE TEMPORARY TABLE `tmp_stock_summary` (

  `cat_id` varchar(2) DEFAULT NULL,

  `cat_name` varchar(100),

  `stock_code` varchar(50) NOT NULL,

  `description` varchar(100) CHARACTER SET utf8 NOT NULL,

  `item_code` varchar(81) NOT NULL DEFAULT '',

  `o_qty` decimal(41,3) DEFAULT NULL,

  `o_amt` decimal(49,6) DEFAULT NULL,

  `db_qty` decimal(40,3) DEFAULT NULL,

  `cr_qty` decimal(40,3) DEFAULT NULL,

  `db_amt` decimal(40,2) DEFAULT NULL,

  `cr_amt` decimal(48,6) DEFAULT NULL,

  `bal_qty` decimal(43,3) NOT NULL DEFAULT '0.000',

  `bal_amt` decimal(51,6) NOT NULL DEFAULT '0.000000'

) ENGINE=InnoDB DEFAULT CHARSET=latin1;";

    $q_result = $dbcon->prepare($msqlquery);

    $q_result->execute();

}

catch(PDOException $e)

{

    echo "Error : ". $e->getMessage();

}





try {

    $d_query = "Insert into tmp_stock_summary

    SELECT   



    substr(c.cat_id,1,2) cat_id, 



    c.cat_name,   



    i.stock_code,



    i.description,



    i.item_code,



    o.o_qty,



    o.o_amt,



    v.db_qty,



    v.cr_qty,



    v.db_amt,



    v.cr_amt,



    ifnull(o.o_qty, 0) + ifnull(v.db_qty, 0) - ifnull(v.cr_qty, 0) bal_qty,



    ifnull(o.o_amt, 0) + ifnull(v.db_amt, 0) - ifnull(v.cr_amt, 0) bal_amt



FROM



    v_item i



LEFT JOIN (



    SELECT



        v.stock_code,   



        sum(ifnull(v.db_qty, 0) - ifnull(v.cr_qty, 0)) o_qty,



        sum(ifnull(v.db_amt, 0) - ifnull(v.cr_amt, 0)) o_amt



    FROM



        v_stk v



         LEFT JOIN item i ON v.stock_code = i.stock_code



    WHERE



        v.voucher_date < '$new_from_date' $and $and_comp



    GROUP BY



        stock_code



) o ON i.stock_code = o.stock_code



LEFT JOIN (



    SELECT



        v.stock_code,



        sum(v.db_qty) db_qty,



        sum(v.db_amt) db_amt,



        sum(v.cr_qty) cr_qty,



        sum(v.cr_amt) cr_amt



    FROM



        v_stk v



        LEFT JOIN item i ON v.stock_code = i.stock_code



    WHERE



        v.voucher_date between '$new_from_date' and '$new_to_date' $and $and_comp



    GROUP BY



        stock_code



) v ON i.stock_code = v.stock_code



    LEFT JOIN prod_cat c ON substr(i.cat_id,1,2) = c.cat_id



    WHERE (o.o_qty<>0 or v.db_qty<>0 or v.cr_qty<>0)



    order by substr(c.cat_id,1,2), i.description



";



    // echo $msqlquery;

    $q_result = $dbcon->prepare($d_query);

    $q_result->execute();

}

catch(PDOException $e)

{

    echo "Error : ". $e->getMessage();

}















/***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/

try {

    $msqlquery = "SELECT DISTINCT v.cat_id acct_id, v.cat_name acct_name

FROM

	tmp_stock_summary v

	WHERE 1=1 

    ORDER BY substr(v.cat_id,1,2)";



    //  echo $msqlquery;

    $q_result = $dbcon->prepare($msqlquery);

    $q_result->execute();

}

catch(PDOException $e)

{

    echo "Error : ". $e->getMessage();

}





$g_o_qty_tot = 0;

$g_o_amt_tot = 0;



$g_db_qty_tot = 0;

$g_db_amt_tot = 0;



$g_cr_qty_tot = 0;

$g_cr_amt_tot = 0;



$g_bal_qty_tot = 0;

$g_bal_amt_tot = 0;



while($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {

    $g_acct_id = $mrow['acct_id'];

    $g_acct_name = $mrow['acct_name'];

    $bal = 0;

    /***************END MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/








    try {



        $d_query = "SELECT      

    v.stock_code,

    concat(v.stock_code,'-',v.description) description,

    v.item_code,

    v.cat_id,

    v.o_qty,

    v.o_amt,

    v.db_qty,

    v.cr_qty,

    v.db_amt,

    v.cr_amt,

    v.bal_qty,

    v.bal_amt

FROM

    tmp_stock_summary v

    WHERE (v.o_qty<>0 or v.db_qty<>0 or v.cr_qty<>0)

    AND v.cat_id = '$g_acct_id'

    order by v.stock_code

";



//echo $d_query;

//                exit();



        $d_result = $dbcon->prepare($d_query);

        $d_result->execute();

    } catch (PDOException $e) {

        echo "Error : " . $e->getMessage();

    }



    // echo $d_query;





    $no_row = $d_result->rowCount();





    if ($bal != 0 or $no_row != 0) {



        $pdf->SetFont($font_cal, 'B', 12);

        $pdf->Ln(10);



        $pdf->Cell(1);

        $pdf->Cell(20, 8, $g_acct_name, 0, 0, 'l');



        $pdf->SetFont($font_cal, '', 8);





        $serno = 0;

        $o_qty_tot = 0;

        $o_amt_tot = 0;



        $db_qty_tot = 0;

        $db_amt_tot = 0;



        $cr_qty_tot = 0;

        $cr_amt_tot = 0;



        $bal_qty_tot = 0;

        $bal_amt_tot = 0;



        while ($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {



            $serno = $serno + 1;



            $o_qty_tot += $report_row['o_qty'];

            $o_amt_tot += $report_row['o_amt'];



            $db_qty_tot += $report_row['db_qty'];

            $db_amt_tot += $report_row['db_amt'];



            $cr_qty_tot += $report_row['cr_qty'];

            $cr_amt_tot += $report_row['cr_amt'];



            $bal_qty_tot += $report_row['bal_qty'];

            $bal_amt_tot += $report_row['bal_amt'];



            $o_rate='';

            if ($report_row['o_qty']<>0)

                $o_rate=$report_row['o_amt']/$report_row['o_qty'];



            $db_rate=0;

            if ($report_row['db_qty']<>0)

                $db_rate=$report_row['db_amt']/$report_row['db_qty'];



            $cr_rate=0;

            if ($report_row['cr_qty']<>0)

                $cr_rate=$report_row['cr_amt']/$report_row['cr_qty'];



            $bal_rate=0;

            if ($report_row['bal_qty']<>0)

                $bal_rate=$report_row['bal_amt']/$report_row['bal_qty'];





            $pdf->Ln(8);



            $pdf->Cell(1);


            $pdf->SetFont($font_cal, '', 11);


            $current_y = $pdf->GetY();

            $current_x = $pdf->GetX(200);

            $pdf->MultiCell(150, 8, $report_row['description'], 1, '','');

            $pdf->SetXY($current_x + 150, $current_y);



            //$pdf->Cell(24, 8, $report_row['item_code'], 1, 0, 'C');

            /*  $pdf->Cell(15, 8, format_number_pdf($report_row['o_qty'],0), 1, 0, 'R');

              $pdf->Cell(21, 8, format_number_pdf($o_rate,0), 1, 0, 'R');

              $pdf->Cell(24, 8, format_number_pdf($report_row['o_amt'],0), 1, 0, 'R');

              $pdf->Cell(15, 8, format_number_pdf($report_row['db_qty'],0), 1, 0, 'R');

              $pdf->Cell(21, 8, format_number_pdf($db_rate,0), 1, 0, 'R');

              $pdf->Cell(24, 8, format_number_pdf($report_row['db_amt'],0), 1, 0, 'R');

              $pdf->Cell(15, 8, format_number_pdf($report_row['cr_qty'],0), 1, 0, 'R');

              $pdf->Cell(21, 8, format_number_pdf($cr_rate,0), 1, 0, 'R');

              $pdf->Cell(24, 8, format_number_pdf($report_row['cr_amt'],0), 1, 0, 'R');*/

            $pdf->Cell(30, 8, format_number_pdf($report_row['bal_qty'],0), 1, 0, 'R');

            //$pdf->Cell(21, 8, format_number_pdf($bal_rate,0), 1, 0, 'R');

            //$pdf->Cell(24,8, format_number_pdf($report_row['bal_amt'],0), 1, 0, 'R');



        }



        $pdf->SetFont($font_cal, 'B', 11);



        $pdf->Ln(8);


        $pdf->Cell(1);
        $pdf->Cell(150, 8, 'Total:', 1, 0, 'R');

        /* $pdf->Cell(15, 8, format_number_pdf($o_qty_tot,0), 1, 0, 'R');

         $pdf->Cell(21, 8, '', 1, 0, 'R');

         $pdf->Cell(24, 8, format_number_pdf($o_amt_tot,0), 1, 0, 'R');

         $pdf->Cell(15, 8, format_number_pdf($db_qty_tot,0), 1, 0, 'R');

         $pdf->Cell(21, 8, '', 1, 0, 'R');

         $pdf->Cell(24, 8, format_number_pdf($db_amt_tot,0), 1, 0, 'R');

         $pdf->Cell(15, 8, format_number_pdf($cr_qty_tot,0), 1, 0, 'R');

         $pdf->Cell(21, 8, '', 1, 0, 'R');

         $pdf->Cell(24, 8, format_number_pdf($cr_amt_tot,0), 1, 0, 'R');*/

        $pdf->Cell(30, 8, format_number_pdf($bal_qty_tot,0), 1, 0, 'R');

        //$pdf->Cell(21, 8, '', 1, 0, 'R');

        //$pdf->Cell(24, 8, format_number_pdf($bal_amt_tot,0), 1, 0, 'R');





        $g_o_qty_tot += $o_qty_tot;

        $g_o_amt_tot += $o_amt_tot;



        $g_db_qty_tot += $db_qty_tot;

        $g_db_amt_tot += $db_amt_tot;



        $g_cr_qty_tot += $cr_qty_tot;

        $g_cr_amt_tot += $cr_amt_tot;



        $g_bal_qty_tot += $bal_qty_tot;

        $g_bal_amt_tot += $bal_amt_tot;





    }



}



$pdf->SetFont($font_cal, 'B', 11);



$pdf->Ln(10);

$pdf->Cell(1);





$pdf->Cell(150, 8, 'Grand Total:', 1, 0, 'R');
/*
$pdf->Cell(15, 8, format_number_pdf($g_o_qty_tot,0), 1, 0, 'R');

$pdf->Cell(21, 8, '', 1, 0, 'R');

$pdf->Cell(24, 8, format_number_pdf($g_o_amt_tot,0), 1, 0, 'R');

$pdf->Cell(15, 8, format_number_pdf($g_db_qty_tot,0), 1, 0, 'R');

$pdf->Cell(21, 8, '', 1, 0, 'R');

$pdf->Cell(24, 8, format_number_pdf($g_db_amt_tot,0), 1, 0, 'R');

$pdf->Cell(15, 8, format_number_pdf($g_cr_qty_tot,0), 1, 0, 'R');

$pdf->Cell(21, 8, '', 1, 0, 'R');

$pdf->Cell(24, 8, format_number_pdf($g_cr_amt_tot,0), 1, 0, 'R');*/

$pdf->Cell(30, 8, format_number_pdf($g_bal_qty_tot,0), 1, 0, 'R');

//$pdf->Cell(21, 8, '', 1, 0, 'R');

//$pdf->Cell(24, 8, format_number_pdf($g_bal_amt_tot,0), 1, 0, 'R');


ob_end_clean();
$pdf->Output();

