<?php
session_start();
ob_start();

include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $comp_id = clean_data($_GET["comp_id"]);
        $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");

        $voucher_type = clean_data($_GET['voucher_type']);

        if($voucher_type == 'CP')
        {
            $_SESSION["f1"]='d.debit';
            $rep_name = 'CASH PAYMENT VOUCHER';
        }
        if($voucher_type == 'BP')
        {
            $_SESSION["f1"]='d.debit';
            $rep_name = 'BANK PAYMENT VOUCHER';
        }
        if($voucher_type == 'CR')
        {
            $_SESSION["f1"]='d.credit';
            $rep_name = 'CASH RECEIPT VOUCHER';
        }
        if($voucher_type == 'BR')
        {
            $_SESSION["f1"]='d.credit';
            $rep_name = 'BANK RECEIPT VOUCHER';
        }


        $this->SetFont('Arial', 'B', 14);

        $this->Cell(190, 10, strtoupper($comp_name), 0, 0, 'C');

        $this->Ln(6);
        $this->SetFont('Arial', 'U', 12);
        $this->Cell(0,10, $rep_name,0,0,'C');
        $this->Ln(10);

    }

}


$pdf = new PDF();

$pdf->AddPage("P");


$comp_id = clean_data($_GET["comp_id"]);
$year_id = clean_data($_GET["year_id"]);

$pdf->SetFont('Arial', 'BIU', 24);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$v_id = clean_data($_GET['v_id']);

$and ="";
$and .= " and v.comp_id = '$comp_id'";

if (!empty($v_id)) {
    $and .= " and v.voucher_id = '$v_id'";
    $and .= " and v.year_id = '$year_id'";
}else{
    $and .= " and v.voucher_date between '$new_from_date' and '$new_to_date'";
}

try
{
    $voucher_query =    "SELECT v.acct_id, v.voucher_id, v.voucher_date, v.acct_id, v.particulars, n.acct_name
                        FROM voucher v 
                        LEFT JOIN nom n ON v.acct_id = n.acct_id
                        WHERE 1=1  $and
                        ";
//echo $voucher_query;
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}
//echo $voucher_query;

$pdf->Ln(1);
while ($report_row = $voucher_result->fetch(PDO::FETCH_ASSOC)) {

    $voucher_id=$report_row['voucher_id'];


    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Account ID', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $report_row['acct_id'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(109, 8, 'Voucher ID', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, $report_row['voucher_id'], 0, 0, 'L');
    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Account Name', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $report_row['acct_name'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(109, 8, 'Date', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, format_date($report_row['voucher_date']), 0, 0, 'L');

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Particulars', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $report_row['particulars'], 0);

    $f1=$_SESSION["f1"];
    try
    {

        $vd_query =    "SELECT d.acct_id, d.particulars, $f1 amount, n.acct_name, n2.acct_name cs_name
                        FROM voucher v 
                        LEFT JOIN voucherdet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id AND v.year_id = d.year_id
                        LEFT JOIN nom n ON d.acct_id = n.acct_id
                        LEFT JOIN nom n2 ON d.acct_id_cs = n2.acct_id
                        WHERE substr(d.lineitem,-1)<>'.'  $and and v.voucher_id='$voucher_id'
                        ";

        //echo $vd_query;

        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(10, 8, 'Ser', 1);
    $pdf->Cell(20, 8, 'Account ID', 1, 0, 'C');
    $pdf->Cell(60, 8, 'Account Name', 1, 0, 'L');
    $pdf->Cell(50, 8, 'Particulars', 1);
    $pdf->Cell(20, 8, 'Cost Center', 1);
    $pdf->Cell(25, 8, 'Amount', 1,0,'R');
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(8);

    $sr = "";

    $amount_tot=0;
    while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

        $amount_tot +=$rd_row['amount'];

        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(10, 8, $sr.'.', 1);
        $pdf->Cell(20, 8, $rd_row['acct_id'], 1);
        $pdf->Cell(60, 8, substr($rd_row['acct_name'],0,40), 1);
        $pdf->Cell(50, 8, substr($rd_row['particulars'],0,29), 1);
        $pdf->Cell(20, 8, $rd_row['cs_name'], 1);
        $pdf->Cell(25, 8, format_number_pdf($rd_row['amount'],2), 1, 0,'R');

        $pdf->Ln(8);
    }

    while ($sr<10){
        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(10, 8, $sr.'.', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(60, 8, '', 1);
        $pdf->Cell(50, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(25, 8, '', 1);
        $pdf->Ln(8);
    }

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(130);
    $pdf->Cell(30,8,'Total',0,0,'R');
    $pdf->Cell(1);
    $pdf->Cell(25,8,format_number_pdf($amount_tot,2),0,0, 'R');


    $pdf->Ln(5);

    $nw=new NumbersToWords();

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(15,8,'Amount : Rs. ',0);
    $pdf->SetFont('Arial', 'U', 8);
    $pdf->Cell(3);
    $pdf->Cell(50,8,strtoupper($nw->convert($amount_tot)).' ONLY',0);
    $pdf->SetFont('Arial', '', 8);


    $pdf->Ln(25);
    $pdf->Cell(50, 0, '____________________________', 0,1,'L');
    $pdf->Cell(60);
    $pdf->Cell(95, 0, '____________________________', 0,1,'L');
    $pdf->Cell(130);
    $pdf->Cell(50, 0, '____________________________', 0,1,'L');
    $pdf->Ln(1);
    $pdf->Cell(15,8,'Received By',0);
    $pdf->Cell(60);
    $pdf->Cell(15,8,'Prepared By',0);
    $pdf->Cell(50);
    $pdf->Cell(15,8,'Approved By',0);

}
$pdf->Output();
