<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $comp_id = clean_data($_SESSION["comp_id"]);
        $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");

        $voucher_type = clean_data($_GET['voucher_type']);

        $rep_name = 'JOURNAL VOUCHER';

        $this->SetFont('Arial', 'B', 18);

        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');

        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(0,10, $rep_name,0,0,'C');
        $this->Ln(10);

    }

}


$pdf = new PDF();

$pdf->AddPage("L");


$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$pdf->SetFont('Arial', 'BIU', 24);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$v_id = clean_data($_GET['v_id']);

$and =" and substr(v.voucher_id,1,2)='JV'";
$and .= " and v.comp_id = '$comp_id'";

if (!empty($v_id)) {
    $and .= " and v.voucher_id = '$v_id'";
    $and .= " and v.year_id = '$year_id'";
}else{
    $and .= " and v.voucher_date between '$new_from_date' and '$new_to_date'";
}

try
{
    $voucher_query =    "SELECT v.acct_id, v.voucher_id, v.voucher_date, v.acct_id, v.particulars, n.acct_name
                        FROM voucher v 
                        LEFT JOIN nom n ON v.acct_id = n.acct_id
                        WHERE 1=1  $and
                        ";

//echo $voucher_query;
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$pdf->Ln(8);
while ($report_row = $voucher_result->fetch(PDO::FETCH_ASSOC)) {

    $voucher_id=$report_row['voucher_id'];


    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(234, 8, 'Voucher ID', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, $report_row['voucher_id'], 0, 0, 'R');
    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Particulars', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $report_row['particulars'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(182, 8, 'Date', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, format_date($report_row['voucher_date']), 0, 0, 'R');

    $f1=$_SESSION["f1"];
    try
    {

        $vd_query =    "SELECT d.acct_id, d.particulars, d.debit, d.credit, n.acct_name
                        FROM voucher v 
                        LEFT JOIN voucherdet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id AND v.year_id = d.year_id
                        LEFT JOIN nom n ON d.acct_id = n.acct_id
                        WHERE 1=1  $and and v.voucher_id='$voucher_id'
                        ";

        //echo $vd_query;

        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(15, 8, 'Ser', 1);
    $pdf->Cell(20, 8, 'Account ID', 1, 0, 'C');
    $pdf->Cell(80, 8, 'Account Name', 1, 0, 'L');
    $pdf->Cell(90, 8, 'Particulars', 1);
    $pdf->Cell(30, 8, 'Debit', 1,0,'R');
    $pdf->Cell(30, 8, 'Credit', 1,0,'R');
    $pdf->SetFont('Arial', '', 8);
    $pdf->Ln(8);

    $sr = "";

    $debit_tot=0;
    $credit_tot=0;
    while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

        $debit_tot +=$rd_row['debit'];
        $credit_tot +=$rd_row['credit'];

        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(15, 8, $sr.'.', 1);
        $pdf->Cell(20, 8, $rd_row['acct_id'], 1);
        $pdf->Cell(80, 8, $rd_row['acct_name'], 1);
        $pdf->Cell(90, 8, $rd_row['particulars'], 1);
        $pdf->Cell(30, 8, format_number_pdf($rd_row['debit'],2), 1, 0,'R');
        $pdf->Cell(30, 8, format_number_pdf($rd_row['credit'],2), 1, 0,'R');

        $pdf->Ln(8);
    }

    while ($sr<10){
        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(15, 8, $sr.'.', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Cell(80, 8, '', 1);
        $pdf->Cell(90, 8, '', 1);
        $pdf->Cell(30, 8, '', 1);
        $pdf->Cell(30, 8, '', 1);
        $pdf->Ln(8);
    }

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(170);
    $pdf->Cell(30,8,'Total',0,0,'R');
    $pdf->Cell(5);
    $pdf->Cell(30,8,format_number_pdf($debit_tot,2),0,0, 'R');
    $pdf->Cell(30,8,format_number_pdf($credit_tot,2),0,0, 'R');


    $pdf->Ln(8);

    $pdf->Ln(20);
    $pdf->Cell(95, 0, '____________________________', 0,1,'L');
    $pdf->Cell(220);
    $pdf->Cell(95, 0, '____________________________', 0,1,'L');
    $pdf->Ln(1);
    $pdf->Cell(15,8,'Prepared By',0);
    $pdf->Cell(205);
    $pdf->Cell(15,8,'Approved By',0);

}
$pdf->Output();
