<?php
session_start();
include("../../include/dbconnect.php");
include("../../include/functions.php");


if(isset($_POST['action']) && !empty($_POST['action'])) {
    if ($_POST['action'] == "search") {
        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $date_from = date('Y-m-d', $change_from_date);
        $_SESSION['from_date'] = $date_from;

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $date_to = date('Y-m-d', $change_to_date);
        $_SESSION['to_date'] = $date_to;

        $comp_id = clean_data($_POST['comp_id']);
        $cat_id = clean_data($_POST['cat_id']);
        $col_id = clean_data($_POST['col_id']);
        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
        $outlet_margin = $_SESSION["outlet_margin"];


        $and = '';


        if ($comp_id != "All")
        {
            $and .= " and v.comp_id = '$comp_id'";
        }
        else
        {
            $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

        }


        if ($cat_id != "All")
        {
            $and .= " and ct.cat_id = '$cat_id'";
        }

        if ($col_id != "All")
        {
            $and .= " and cl.col_id = '$col_id'";
        }


        $and .= " and v.voucher_date BETWEEN '$date_from' AND '$date_to'";




        try {
            $sqlquery = "SELECT
	v.voucher_id,
	v.voucher_date,
	c.comp_name,
	v.stock_code,
	ct.description cat_name,
	cl.description cl_name,
	ct.cat_id,
	cl.col_id,
	v.sl_qty + v.ex_qty + v.dc_qty qty,
	v.rate,
	v.discp,
	v.discount,
	s.size,
	v.bill_no,
	v.comp_id,
	b.acct_name,
	c.outlet_margin,
	v.sharing

FROM
	v_daily_sale v
LEFT JOIN item i ON i.stock_code = v.stock_code
LEFT JOIN code_cat ct ON ct.cat_id = i.cat_id
LEFT JOIN code_collection cl ON cl.col_id = i.col_id
LEFT JOIN company c ON c.comp_id = v.comp_id
LEFT JOIN size s ON s.size_id = i.size
LEFT JOIN bill_type b ON b.acct_id = v.bill_type
WHERE 1=1  $and  ORDER BY v.voucher_date DESC";
            $q = $dbcon->prepare($sqlquery);
            $q->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }



        $and2 = '';
        if ($comp_id != "All")
        {
            $and2 .= " and v.comp_id = '$comp_id'";
        }

        try {
            $name_query = "SELECT
			v.comp_name,
			u.emp_id
			FROM
	users u
LEFT JOIN users_comp uc ON u.emp_id = uc.emp_id
LEFT JOIN company v ON v.comp_id = uc.comp_id
WHERE 1=1 $and2";

            $name_result = $dbcon->prepare($name_query);
            $name_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }
        $name_row = $name_result->fetch(PDO::FETCH_OBJ);


        ?>

        <h4 style="text-align: center; font-family: 'Bookman Old Style'">OUTLET SHARING REPORT
            <p><?php

                $name = "";
                if ($comp_id == "All")
                {
                    $name = "All Sale";
                }
                else
                {
                    $name = $name_row->comp_name;
                }


                echo $name;?></p>
            <p><?php echo format_date($date_from); ?>  - <?php echo format_date($date_to); ?></p>
        </h4>








        <div class="table-responsive">






            <table class="table table-bordered table-striped table-responsive" id="datatable">
                <thead>
                <tr>
                    <th>SR</th>
                    <th>VOUCHER DATE</th>
                    <th>STOCK CODE</th>
                    <th>MARGIN</th>
                    <th>QTY</th>
                    <th>OLD MRP</th>
                    <th>OLD MRP AMOUNT</th>
                    <th>OLD WHOLE SALE</th>
                    <th>DISCOUNT</th>
                    <th>NEW MRP</th>
                    <th>FRANCHISEE SHARING</th>
                    <th>NEW WHOLE SALE</th>
                </tr>
                </thead>
                <tbody>
                <?php
                $serno = 0;
                while($report_row = $q->fetch(PDO::FETCH_OBJ))
                {
                    $serno = $serno + 1;

                    $old_mrp_amount = $report_row->qty * $report_row->rate;

                    $outletmargin =  $report_row->outlet_margin .'%';
                    $old_wholesale = ($old_mrp_amount * $outletmargin / 100 );
                    $final_old_wholesale_amount = $old_mrp_amount - $old_wholesale;

                    $discp = $report_row->discp .'%';
                    $discp_amt = $old_mrp_amount * $discp / 100;
                    $new_mrp = $old_mrp_amount - $discp_amt;


                    $f_sharing = $report_row->sharing .'%';
                    $shareing = ($outletmargin - $f_sharing);
                    $share_p = $shareing . '%';
                    $outlet_sahreing = $final_old_wholesale_amount * $share_p / 100;
                    $final_sahreing = $final_old_wholesale_amount - $outlet_sahreing




                    ?>

                    <tr>
                        <td><?php echo $serno; ?></td>
                        <td><?php echo format_date($report_row->voucher_date); ?></td>
                        <td><?php echo $report_row->stock_code ?></td>
                        <td><?php echo $report_row->outlet_margin ?></td>
                        <td><?php echo $report_row->qty ?></td>
                        <td><?php echo round($report_row->rate) ?></td>
                        <td><?php echo round($old_mrp_amount) ?></td>
                        <td><?php echo round($final_old_wholesale_amount) ?></td>
                        <td><?php echo round($report_row->discp) ?></td>
                        <td><?php echo round($new_mrp) ?></td>
                        <td><?php echo round($report_row->sharing) ?></td>
                        <td><?php echo round($final_sahreing) ?></td>




                    </tr>

                    <?php


                }



                ?>

                </tbody>
            </table>

        </div>


        <?php
    }
}
?>
































</section><!-- /.content -->
</aside><!-- /.right-side -->
</div><!-- ./wrapper -->





<script>
    $(document).ready(function() {
        jQuery.extend( jQuery.fn.dataTableExt.oSort, {
            "date-dmy-pre": function ( a ) {
                if (a == null || a == "") {
                    return 0;
                }
                var date = a.split('-');
                return (date[2] + date[1] + date[0]) * 1;
            },

            "date-dmy-asc": function ( a, b ) {
                return ((a < b) ? -1 : ((a > b) ? 1 : 0));
            },

            "date-dmy-desc": function ( a, b ) {
                return ((a < b) ? 1 : ((a > b) ? -1 : 0));
            }
        } );
        $('#datatable').DataTable( {
//lengthChange: true,
            "bLengthChange": true,
            "order": [[ 0, "asc" ]],
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
            "pageLength": 200,
            dom: 'Bfrtip',
            buttons: [
//'copy', 'csv', 'excel', 'pdf', 'print', 'colvis',
                'copy', 'csv', 'excel',

                {
                    extend: 'pdfHtml5',
                    title: 'Sale Report',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                },





                {
                    extend: 'print',
                    title: 'Sale Report',


                    customize: function ( win ) {
                        $(win.document.body)
                            .css( 'font-size', '10pt' )
                            .prepend(
//'<img src="http://santoshkumar.com.pk/images/10296594_1476738859239315_6002297598686057218_n.png" style="position:absolute; top:0; left:0;" />'
                            );

                        $(win.document.body).find( 'table' )
                            .addClass( 'compact' )
                            .css( 'font-size', 'inherit' );
                    },






                    exportOptions: {
                        columns: ':visible'
                    }
                },
                'colvis'
            ],
            columnDefs: [ {
//targets: 0,
                visible: false
            }












            ]
        } );


    } );

</script>




