<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}
//variables
$voucher_type = clean_data($_POST['voucher_type']);
$login_page = find_value('system', 'login_page', '');

$qty_decimals = $_SESSION["qty_decimals"];
$rate_decimals = $_SESSION["rate_decimals"];

$add = clean_data($_POST['add']);
$emp_id = $_SESSION["VALID_USER_ID"];
$loc_id =  $_SESSION["short_name"];


$p_year_id = clean_data($_POST['year_id']);
if(empty($p_year_id))
{
    $year_id = clean_data($_SESSION["year_id"]);
}
else{

    $year_id =  $p_year_id;
}



$p_comp_id = clean_data($_POST['comp_id']);

if(empty($p_comp_id))
{
    $comp_id = clean_data($_SESSION["comp_id"]);
}
else{

    $comp_id =  $p_comp_id;

}



if($add == "Y")
{
    $lineitem = 0;
    $acct_id = '';
    $voucher_date = date('d-m-Y');
    $voucher_type = clean_data($_POST['voucher_type']);



    $close_date = find_value('system', 'date_close', '');
    $v_date = date('d-m-Y', strtotime($close_date . ' +1 day'));



    //MAXIMUM VOUCHER ID CHK QUERY
    try
    {
        $Maxquery =  "SELECT max(v.v_id) + 1 v_id FROM voucher_id v
		WHERE v_type = ? and comp_id = ? ";
        $max_query = $dbcon->prepare($Maxquery);
        $max_query->execute(array($voucher_type, $comp_id ));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $row_max = $max_query->fetch(PDO::FETCH_OBJ);
    $v_id = $row_max->v_id;
    if(empty($v_id))
    {
        $v_id = 1;
    }


//MAXIMUM VOUCHER ID INSERT NEW ID QUERY
    try
    {
        $InserMaxquery =  "INSERT INTO voucher_id (v_id, v_type,comp_id) VALUES (?, ?, ? )";
        $insert_max = $dbcon->prepare($InserMaxquery);
        $insert_max->execute(array($v_id, $voucher_type, $comp_id ));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $v_id =  $v_id;



    // END MAXIMUM VOUCHER ID CHK QUERY



    $customer_name = '';
    $customer_phone = '';
    $customer_cash = '';





    //MAXIMUM INVOICE ID CHK QUERY
    try
    {
        $Maxquery_invoice =  "SELECT LPAD(IFNULL(max(substr(v.bill_no,-4)),0)+1,4,'0') v_id FROM pl_gp v
		WHERE v.comp_id = ? ";
        $max_query_inv = $dbcon->prepare($Maxquery_invoice);
        $max_query_inv->execute(array($comp_id ));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $row_max_invoice = $max_query_inv->fetch(PDO::FETCH_OBJ);
    $invoiceNo = $row_max_invoice->v_id;
    $invoice_no = $loc_id.$invoiceNo;







    $discount_voucher_id = "";
    $return_cash = "";
    $bill_type = '';
    $sp = "";
    $invoice_no = "";
    $discp_m = "";
    $disc_amt_m = "";
    $net_amt = "";
    $net_payable = "";
    $adv_amt = "";
    $dc_amt = "";
    $bill_date = "";



}
else //EDIT
{
    $voucher_type = clean_data($_POST['voucher_type']);
    $v_id = clean_data($_POST['v_id']);


    try
    {
        $edit_query =  "SELECT * FROM pl_gp m  WHERE m.voucher_id = ? AND m.comp_id = ? AND m.year_id = ?";
        $edit_result = $dbcon->prepare($edit_query);
        $edit_result->execute(array($v_id, $comp_id, $year_id));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $rowm = $edit_result->fetch(PDO::FETCH_OBJ);


    $voucherdate = $rowm->voucher_date;
    $v_date = date('d-m-Y', strtotime($voucherdate));
    $acct_id = $rowm->acct_id;
    $customer_name = $rowm->customer_name;
    $customer_phone = $rowm->customer_phone;
    $customer_cash = $rowm->customer_cash;
    $return_cash = $rowm->return_cash;
    $bill_type = $rowm->bill_type;
    $invoice_no = $rowm->bill_no;
    $sp = $rowm->sp_id;
    $discount_voucher_id = $rowm->discount_voucher_no;
    $discp_m = $rowm->discp;
    $disc_amt_m = $rowm->disc_amt;
    $net_amt = $rowm->net_amt;
    $net_payable = $rowm->net_payable;
    $adv_amt = $rowm->adv_amt;
    $dc_amt = $rowm->dc_amt;
    $location_id = $rowm->loc_id;
    $acct_id_cs_1 = $rowm->acct_id_cs_1;

    $v_bill_date = $rowm->bill_date;
    if(!empty($v_bill_date))
        $bill_date = date('d-m-Y', strtotime($v_bill_date));





}




?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $row->acct_name;?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="Thu, 19 Nov 1900 08:52:00 GMT">
    <link rel="shortcut icon" href="images/icons/favicon.html">
    <link rel="apple-touch-icon" href="images/icons/favicon-2.html">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.html">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.html"><!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet"
          href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet"
          href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/select2/select2-madmin.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-select/bootstrap-select.min.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-notific8/jquery.notific8.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-daterangepicker/daterangepicker-bs3.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-datepicker/css/datepicker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" class="default-style">
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" id="theme-change"
          class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sidebar-icons">
<div>

    <a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP--><!--BEGIN TOPBAR-->



    <!--BEGIN TOPBAR-->
    <?php include ('header.php'); ?>
    <!--END TOPBAR-->




    <div id="wrapper"><!--BEGIN SIDEBAR MENU-->
        <!--BEGIN SIDEBAR MENU-->
        <?php include ('left.php'); ?>
        <!--END SIDEBAR MENU-->

        <!--BEGIN PAGE WRAPPER-->
        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->
            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
                <div class="page-header pull-left">
                    <div class="page-title">PURCHASE INWORD GATEPASS INVOICE</div>
                </div>

                <div class="clearfix"></div>
            </div>
            <!--END TITLE & BREADCRUMB PAGE-->



            <!--BEGIN CONTENT-->
            <div class="page-content">

                <form class="form-horizontal"  name="sale_invoice"  id="sale_invoice">

                    <div class='row'>
                        <div class='col-xl-12 col-sm-3 col-md-3 col-lg-12'>

                            <button class="btn btn-danger delete_sale" type="button">- Delete</button>




                            <button class="btn btn-success addmore_sale" type="button">+ Add More</button>
                            <input type="button" class="btn btn-primary" name="savedata" id="savedata" value="Save" onClick="sale_invoice_add()"/>


                        </div>
                    </div>

                    <br clear="all">

                    <!------------------------START MASTER TABLE---------------------------->

                    <input type="hidden" class="form-control" name="voucher_type" id="voucher_type"
                           value="<?php echo $voucher_type; ?>">

                    <input type="hidden" class="form-control" name="add" id="add"
                           value="<?php echo $add; ?>">

                    <input type="hidden" class="form-control" name="p_comp_id" id="p_comp_id"
                           value="<?php echo $comp_id; ?>">


                    <input type="hidden" class="form-control" name="p_year_id" id="p_year_id"
                           value="<?php echo $year_id; ?>">

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-block">
                                    <div class="table-responsive">

                                        <table class="table dt-responsive  table-bordered nowrap">
                                            <thead>
                                            <tr>

                                                <!-- VOUCHER ID -->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Voucher ID:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="voucher_id"id="voucher_id" placeholder="voucher id" value="<?php echo $v_id;?>" readonly style="width: 150px;">
                                                </td>

                                                <!-- DATE -->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Date:</label>
                                                </td>
                                                <td style="width: 150px;">
                                                    <input type="text" class="form-control v_date" name="v_date" id="v_date" placeholder="Date" readonly value="<?php echo $v_date;?>" style="width: 150px;">
                                                </td>



                                                <!-- SALE TYPE-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Supplier</label>
                                                </td>
                                                <?php

                                                $and = " and p.party_type = 'S'";
                                                if($login_page == 'kt' or $login_page == 'tt' )
                                                {
                                                    $and = "";
                                                }

                                                try
                                                {
                                                    $p_query =  "SELECT p.acct_id, p.acct_name FROM v_party p WHERE 1 = 1 $and   ORDER BY p.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select   name="acct_id" id="acct_id" class="form-control acct_id">


                                                        <option value="">Select Party</option>

                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {

                                                            if ($acct_id == $p_row->acct_id)
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';

                                                            }
                                                            else
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                    <input type="text" class="form-control"  id="party_bal" readonly placeholder="Party Balance">

                                                </td>
                                            </tr>


                                            <tr>

                                                <!-- CUSTOMER NAME-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Supplier Name:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="customer_name"id="customer_name" autocomplete="on" value="<?php echo $customer_name;?>" style="width: 150px;">
                                                </td>

                                                <!-- CUSTOMER PHONE NO-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Supplier Phone No:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="customer_phone"id="customer_phone" value="<?php echo $customer_phone;?>" autocomplete="on" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" style="width: 150px;">
                                                </td>


                                                <th>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Location</label>
                                                </th>
                                                <?php
                                                try
                                                {
                                                    $p_query =  "SELECT l.loc_id, l.loc_name FROM location l ORDER BY l.loc_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select   name="loc_id" id="loc_id" class=" form-control acct_id">




                                                        <?php
                                                        $loc_id = find_value('location', 'loc_id', " AND comp_id = '$comp_id'");
                                                        ?>

                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {
                                                            if($add == 'Y')
                                                            {
                                                                if ($loc_id == $p_row->loc_id) {
                                                                    echo '<option  value="' . $p_row->loc_id . '" selected>' . $p_row->loc_name . '</option>';

                                                                } else {

                                                                    echo '<option  value="' . $p_row->loc_id . '">' . $p_row->loc_name . '</option>';

                                                                }
                                                            }
                                                            else {
                                                                if ($location_id == $p_row->loc_id) {
                                                                    echo '<option  value="' . $p_row->loc_id . '"selected>' . $p_row->loc_name . '</option>';

                                                                }

                                                                echo '<option  value="' . $p_row->loc_id . '">' . $p_row->loc_name . '</option>';

                                                            }



                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                            </tr>

                                            <tr>

                                                <!-- INVOICE NO-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;"> Inv No:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="inv_no"id="inv_no" autocomplete="on"  style="width: 150px;" value="<?php echo $invoice_no;?>">
                                                </td>

                                                <!-- BIL DATE-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;"> Bill Date:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control v_date"  name="bill_date"id="bill_date" readonly value="<?php echo $bill_date;?>">
                                                </td>




                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Salesman</label>
                                                </td>
                                                <?php
                                                try
                                                {
                                                    $p_query =  "SELECT s.acct_id, s.acct_name FROM sp s  ORDER BY s.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select   name="sp_id" id="sp_id" class=" form-control acct_id">




                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {

                                                            if ($acct_id == $p_row->acct_id)
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';

                                                            }
                                                            else
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                            </tr>


                                            <!-- <tr>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>

                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Departments</label>
                                                </td>
                                                <?php
                                            /*                                                try
                                                                                            {
                                                                                                $p_query =  "SELECT s.acct_id, s.acct_name FROM v_cost_centre s ORDER BY s.acct_id ASC ";

                                                                                                $p_result = $dbcon->prepare($p_query);
                                                                                                $p_result->execute(array());
                                                                                            }
                                                                                            catch(PDOException $e)
                                                                                            {
                                                                                                echo "Error : ". $e->getMessage();
                                                                                            }

                                                                                            */?>

                                                <td>
                                                    <select  name="acct_id_cs_1" id="acct_id_cs_1" class=" form-control acct_id">




                                                        <?php
                                            /*                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                                                                    {

                                                                                                        if ($acct_id_cs_1 == $p_row->acct_id)
                                                                                                        {
                                                                                                            echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';

                                                                                                        }
                                                                                                        else
                                                                                                        {
                                                                                                            echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                                                                        }
                                                                                                    }
                                                                                                    */?>
                                                    </select>
                                                </td>




                                            </tr>-->
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!------------------------END MASTER TABLE---------------------------->


                    <!------------------------START DETAIL TABLE---------------------------->

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-block">


                                    <table class="table table-bordered table-responsive table-hover addrow_sale" id="addrow">
                                        <thead >
                                        <tr>
                                            <th width="2%"><input id="check_all" class="formcontrol" type="checkbox"/></th>
                                            <th width="8%" style="text-align: center;">SR</th>
                                            <th width="12%" style="text-align: center;">STOCK CODE</th>
                                            <th width="12%" style="text-align: center;">PARTY STOCK CODE</th>
                                            <th width="22%" style="text-align: center;">ITEM NAME</th>
                                            <th width="15%" style="text-align: center;">PARTICULARS</th>
                                            <th  style="text-align: center;">QTY</th>
                                            <th width="10%" style="text-align: center;">RATE</th>
                                            <th width="10%" style="text-align: center;">DISC %</th>
                                            <th width="15%" style="text-align: center;">DISC AMOUNT</th>
                                            <th width="10%" style="text-align: center;">AMOUNT</th>
                                        </tr>

                                        </thead>




                                        <?php

                                        try
                                        {
                                            $edit_query =  "SELECT
	d.*,
	 i.size,
	i.description,
	i.party_stock_code

FROM
	pl_gpdet d
LEFT JOIN item i ON d.stock_code = i.stock_code


   WHERE d.voucher_id = ? and d.comp_id = ? AND d.year_id = ?
 order by d.lineitem/1 ";
                                            $resultd = $dbcon->prepare($edit_query);
                                            $resultd->execute(array($v_id, $comp_id, $year_id ));
                                        }
                                        catch(PDOException $e)
                                        {
                                            echo "Error : ". $e->getMessage();
                                        }

                                        $cnt = 0;
                                        $itemtot = '';
                                        $tot_qty = '';
                                        while($rowd = $resultd->fetch(PDO::FETCH_OBJ))
                                        {
                                            $lineitem = $rowd->lineitem;
                                            $cnt = $lineitem;
                                            $itemtot += $rowd->itemtot;

                                            $tot_qty += $rowd->qty;

                                            $party_stock_code = $rowd->party_stock_code;


                                            ?>

                                            <!----------------------------------------------------------------------------------------------------------------------
                                            ------------------------------------------------------------------------------------------------------------------------
                                            ----------------------------------------------------SALE INVOICE DETAIL EDIT FORM---------------------------------------
                                            ------------------------------------------------------------------------------------------------------------------------
                                            ----------------------------------------------------------------------------------------------------------------------->
                                            <tr class="addrow_sale">
                                                <td><input class="case" type="checkbox"/></td>
                                                <td> <input type="text" class="form-control" name="lineitem[]" size="1" value="<?php echo $lineitem;?>" readonly /></td>


                                                <!-- STOCK CODE -->
                                                <td style="width: 130px;">
                                                    <input type="text" data-type="stock_code" name="stock_code[]" class="form-control  autocomplete_txt stock_code" id="stockcode_<?php echo $cnt;?>" value="<?php echo $rowd->stock_code;?>" maxlength="11">
                                                </td>


                                                <!-- PARTY CODE -->
                                                <td>
                                                    <input type="text" data-type="party_stock_code" name="party_stock_code[]"  class="form-control party_stock_code autocomplete_txt " id="partystockcode_<?php echo $cnt;?>" autocomplete="off"  size="30"  value="<?php echo $rowd->party_stock_code ;?>">
                                                </td>


                                                <!-- DESCRIPTION -->
                                                <td>
                                                    <input type="text" data-type="description" name="description[]"  class="form-control description autocomplete_txt " id="description_<?php echo $cnt;?>" autocomplete="off"  size="30"  value="<?php echo $rowd->description ;?>">
                                                </td>

                                                <!-- PARTICULARS -->

                                                <td>
                                                    <input type="text" class="form-control particulars" name="particulars[]"  id="particulars_<?php echo $cnt;?>" size="50"  value="<?php echo $rowd->particulars;?>" />
                                                </td>
                                                <input type="hidden" class="form-control available_qty " name="available_qty[]" id="availableqty_<?php echo $cnt;?>" value="<?php echo $o_qty;?>" />

                                                <!-- QUANTITY -->
                                                <td>
                                                    <input type="number" class="form-control qty changesNo qty grand_tot_qty" name="qty[]" id="qty_<?php echo $cnt;?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" value="<?php echo round($rowd->qty);?>" />
                                                </td>

                                                <!-- RATE -->
                                                <td>
                                                    <input type="text" class="form-control  changesNo orate" name="rate[]" id="orate_<?php echo $cnt;?>"  value="<?php echo round($rowd->rate, $rate_decimals);?>"/>
                                                </td>

                                                <!-- DISCOUNT -->
                                                <td>
                                                    <input type="text" class="form-control rate changesNo discp" name="discp[]" id="discp_<?php echo $cnt;?>" value="<?php echo round($rowd->discp);?>" />
                                                </td>
                                                <!-- DISCOUNT VALUE -->
                                                <td>
                                                    <input type="text" class="form-control  changesNo disc_amt" name="disc_amt[]" id="discamt_<?php echo $cnt;?>" value="<?php echo round($rowd->disc_amt);?>" readonly/>
                                                </td>

                                                <!-- TOTAL AMOUNT -->
                                                <td>
                                                    <input type="text" class="form-control itemtot totalLinePrice" name="itemtot[]" id="itemtot_<?php echo $cnt;?>" readonly value="<?php echo round($rowd->itemtot, $rate_decimals);?>"/>
                                                </td>
                                            </tr>

                                            <?php
                                        }
                                        $_SESSION['cnt'] = $cnt;
                                        ?>



                                        <!----------------------------------------------------------------------------------------------------------------------
                                        ------------------------------------------------------------------------------------------------------------------------
                                        ----------------------------------------------------SALE INVOICE DETAIL ADD FORM---------------------------------------
                                        ------------------------------------------------------------------------------------------------------------------------
                                        ----------------------------------------------------------------------------------------------------------------------->


                                        <?php  $numberofrow = 1; ?>  <?php for($counter = 1;$counter<=$numberofrow;$counter++){ ?>

                                            <tr class="addrow_sale">
                                                <!-- CHECKBOX FOR ADD NEW FORM FIELD -->
                                                <td>
                                                    <input class="case" type="checkbox" id="disable_<?php echo $counter;?>"/>
                                                </td>

                                                <!-- LINEITEM -->
                                                <td style="width: 60px;">
                                                    <?php $lineitem += 1;?>
                                                    <input type="text" class="form-control " name="lineitem[]<?php echo $counter;?>"  id="lineitem_1" value="<?php echo $lineitem;?>" readonly  />
                                                </td>

                                                <!-- STOCK CODE -->
                                                <td style="width: 130px;">
                                                    <input  type="text"  data-type="stock_code" name="stock_code[]"  class="form-control   autocomplete_txt stock_code" id="stockcode_<?php

                                                    if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }


                                                    ?>" autocomplete="off" maxlength="11" autofocus >
                                                </td>


                                                <!-- STOCK CODE -->
                                                <td style="width: 130px;">
                                                    <input  type="text"  data-type="party_stock_code" name="party_stock_code[]"  class="form-control   autocomplete_txt party_stock_code" id="partystockcode_<?php

                                                    if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }


                                                    ?>" autocomplete="off">
                                                </td>

                                                <!-- DESCRIPTION -->
                                                <td>
                                                    <input type="text" data-type="description" name="description[]"  class="form-control description autocomplete_txt " id="description_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" autocomplete="off"  size="30">
                                                </td>

                                                <!-- PARTICULARS -->

                                                <td>
                                                    <input type="text" class="form-control particulars"  name="particulars[]<?php echo $counter;?>"  id="particulars_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" size="50" />
                                                </td>
                                                <input type="hidden" class="form-control available_qty " name="available_qty[]<?php echo $counter;?>" id="availableqty_<?php if($add == "Y") {
                                                    echo $counter;
                                                }

                                                else
                                                {
                                                    echo $lineitem;
                                                }
                                                ?>" />

                                                <!-- QUANTITY -->
                                                <td>
                                                    <input style="width: 90px;" type="number"  class="form-control qty  changesNo qty grand_tot_qty"  name="qty[]<?php echo $counter;?>" id="qty_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;"   />
                                                </td>

                                                <!-- RATE -->
                                                <td>
                                                    <input type="text" class="form-control  changesNo orate" name="rate[]<?php echo $counter;?>" id="orate_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>"  />
                                                </td>


                                                <!-- DISCOUNT -->
                                                <td>
                                                    <input type="text" class="form-control rate changesNo discp" name="discp[]<?php echo $counter;?>" id="discp_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>"   />

                                                </td>


                                                <!-- DISCOUNT AMOUNT -->
                                                <td>
                                                    <input type="text" class="form-control rate changesNo disc_amt" name="disc_amt[]<?php echo $counter;?>" id="discamt_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" readonly  />

                                                </td>








                                                <!-- TOTAL AMOUNT -->
                                                <td>
                                                    <input type="text" class="form-control itemtot totalLinePrice" name="itemtot[]<?php echo $counter;?>" id="itemtot_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" readonly/>
                                                </td>
                                            </tr>
                                        <?php } ?>


                                        <thead>
                                        <tr>



                                            <td></td>
                                            <td></td>

                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td   align="right" >

                                                <input type="text" class="form-control  grandtot_qty" name="grandtot_qty" id="grandtot_qty" autocomplete="off"  readonly value="<?php

                                                if($add == "Y") {
                                                    $_SESSION['tot_qty'] = 0;

                                                }

                                                else
                                                {
                                                    $_SESSION['tot_qty'] = $tot_qty;
                                                }

                                                echo round($_SESSION['tot_qty']);?>" style="width: 100px;  font-weight: bold;" /></td>


                                            <td >


                                            </td>
                                            <td></td>



                                            <td width="10%" colspan="1" align="right">
                                                <input type="text" class="form-control  grandtot " name="grandtot" id="grandtot" autocomplete="off" readonly   value="<?php

                                                if($add == "Y") {
                                                    $_SESSION['itemtot'] = 0;

                                                }

                                                else
                                                {
                                                    $_SESSION['itemtot'] = $itemtot;
                                                }

                                                echo round($_SESSION['itemtot'], $rate_decimals);?>" style="width: 100px;  font-weight: bold;" />
                                            </td>
                                        </tr>


                                        <tr>


                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>

                                            <td align="right">
                                                <b>Discount %</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  discp_m" name="discp_m" id="discp_m" value="<?php echo round($discp_m); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;"/>
                                            </td>
                                            <td align="right">
                                                <b>Amount</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  disc_amt_m" name="disc_amt_m" id="disc_amt_m" value="<?php echo round($disc_amt_m); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>
                                        </tr>



                                        <tr>


                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Freight</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  dc_amt" name="dc_amt" id="dc_amt" value="<?php echo round($dc_amt); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>
                                        </tr>








                                        <tr>


                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Invoice Amount</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  net_amt" name="net_amt" id="net_amt" value="<?php echo round($net_amt); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" readonly/>
                                            </td>
                                        </tr>









                                        <tr>


                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Advance</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  adv_amt" name="adv_amt" id="adv_amt" value="<?php echo round($adv_amt); ?>" autocomplete="off"  />
                                            </td>
                                        </tr>



                                        <tr>


                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Total</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  invoice_tot" name="invoice_tot" id="invoice_tot" value="<?php echo round($net_payable); ?>" autocomplete="off"  readonly value="<?php echo $return_cash;?>" />
                                            </td>
                                        </tr>

                                        </thead>

                                    </table>


                                    <div id="view"></div>
                                    <div class='row'>
                                        <div class='col-xl-12 col-sm-3 col-md-3 col-lg-12'>

                                            <button class="btn btn-danger delete_sale" type="button">- Delete</button>




                                            <button class="btn btn-success addmore_sale" type="button">+ Add More</button>
                                            <input type="button" class="btn btn-primary" name="savedata" id="savedata" value="Save" onClick="sale_invoice_add()"/>


                                        </div>
                                    </div>


                </form>





            </div>

        </div>
    </div>
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/jquery-ui.js"></script><!--loading bootstrap js-->
    <script src="vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
    <script src="js/html5shiv.js"></script>
    <script src="js/respond.min.js"></script>
    <script src="vendors/metisMenu/jquery.metisMenu.js"></script>
    <script src="vendors/slimScroll/jquery.slimscroll.js"></script>
    <script src="vendors/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendors/iCheck/icheck.min.js"></script>
    <script src="vendors/iCheck/custom.min.js"></script>
    <script src="vendors/jquery-notific8/jquery.notific8.min.js"></script>
    <script src="vendors/jquery-highcharts/highcharts.js"></script>
    <script src="js/jquery.menu.js"></script>
    <script src="vendors/jquery-pace/pace.min.js"></script>
    <script src="vendors/holder/holder.js"></script>
    <script src="vendors/responsive-tabs/responsive-tabs.js"></script>
    <script src="vendors/jquery-news-ticker/jquery.newsTicker.min.js"></script>
    <script src="vendors/moment/moment.js"></script>
    <script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="vendors/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="js/main.js"></script><!--LOADING SCRIPTS FOR PAGE-->
    <script src="vendors/select2/select2.min.js"></script>
    <script src="vendors/bootstrap-select/bootstrap-select.min.js"></script>



    <!---------------------------START JAVASCRIPT-------------------------------->
    <script type="text/javascript">






        //autocomplete script sale invoice select stock code
        $(document).on('focus','.autocomplete_txt',function(){
            type = $(this).data('type');

            if(type =='stock_code' )autoTypeNo=0;
            if(type =='description' )autoTypeNo=1;
            if(type =='party_stock_code' )autoTypeNo=2;


            $(this).autocomplete({
                source: function( request, response ) {
                    $.ajax({
                        url : 'kt_pl_select_stock.php',
                        dataType: "json",
                        method: 'post',
                        data: {
                            name_startsWith: request.term,
                            type: type
                        },
                        success: function( data ) {
                            response( $.map( data, function( item ) {
                                var code = item.split("|");
                                return {
                                    label: code[autoTypeNo],
                                    value: code[autoTypeNo],
                                    data : item
                                }
                            }));
                        }
                    });
                },
                autoFocus: true,
                minLength: 1,

                select: function( event, ui ) {
                    var names = ui.item.data.split("|");
                    id_arr = $(this).attr('id');
                    id = id_arr.split("_");
                    $('#stockcode_'+id[1]).val(names[0]);
                    $('#description_'+id[1]).val(names[1]);
                    $('#partystockcode_'+id[1]).val(names[2]);
                    $('#orate_'+id[1]).val(names[3]);

                    s_rate =  $('#orate_'+id[1]).val();
                    s_qty =  $('#qty_'+id[1]).val(1);

                    $('#qty_' + id[1]).focus();

                    $('#itemtot_' + id[1]).val(1 * names[2]);

                    calculateTotal();
                    calculateTotal_qty();
                    calculateInvoiceTotal();
                    calculateNetAmount();

                }
            });
            press_enter();



        });








        function sale_invoice_add()
        {

            //declare variables master form
            var v_date = $('#v_date').val();
            var v_id = $('#voucher_id').val();
            var acct_id = $('#acct_id').val();
            var customer_name = $('#customer_name').val();
            var customer_phone = $('#customer_phone').val();
            var customer_cash = $('#customer_cash').val();
            var return_cash = $('#return_cash').val();
            var sp = $('#sp_id').val();
            var acct_id_cs_1 = $('#acct_id_cs_1').val();

            // var p_comp_id = '<?php echo $comp_id; ?>';
            //var p_year_id = '<?php echo $year_id; ?>';

            //declare variables detail form
            var stock_code = $('#stockcode_1').val();







            var particulars = $('#particulars').val();
            var qty = $('#qty_1').val();
            var rate = $('#rate').val();
            var discp = $('#discp').val();
            var itemtot = $('#itemtot').val();
            var grand_tot = $('#grandtot').val();





            //check condition
            if(v_id == "")
            {
                alert("Please Enter Voucher ID");
                $('#v_id').focus();
            }

            else if(v_date == "")
            {
                alert("Please Enter Date");
                $('#v_date').focus();
            }



            else if(acct_id == "")
            {
                alert("Please Select Party");
                $('#acct_id').focus();
            }


            /* else if(sp == "Select SalePerson")
             {
             alert("Please Select Sale Person");
             $('#sp_id').focus();
             }*/


            else if(stock_code == "")
            {
                alert("Please Select Stock Code");
                $('#stockcode_1').focus();
            }







            else if(qty == "" || qty == '0' )
            {
                alert("Please Enter Quantity");
                $('#qty_1').focus();
            }

            else if(rate == "")
            {
                alert("Please Enter Rate");
                $('#rate').focus();
            }








            else
            {
                var formdata = $('#sale_invoice').serializeArray()

                $.ajax({
                    type:"POST",
                    url:"process/purchase_inword_process.php",
                    data:$.param(formdata),
                    beforeSend: function()
                    {
                        $("#view").html('<div class="loader-block"> <svg id="loader2" viewBox="0 0 100 100"> <circle id="circle-loader2" cx="50" cy="50" r="45"></circle></svg></div><br clear="all">');
                    },
                    success: function(result)
                    {
                        //alert(result);
                        //alert('Voucher has been successfully submitted.');
                        //window.location = "sl_inv_detail.php?v_id=<?php echo $v_id;?>&voucher_type=<?php echo $voucher_type;?>&posted=''"

                        window.location = "pl_inword_detail?v_id=<?php echo $v_id;?>&voucher_type=<?php echo $voucher_type;?>&posted=''&p_comp_id=<?php echo $comp_id;?>&p_year_id=<?php echo $year_id;?>";
                    }
                });
                $('#savedata').addClass("disabled");
            }




        }


        $(document).on('change', '#check_all', function () {
            $('input[class = case]:checkbox').prop("checked", $(this).is(':checked'))
        });



        //delete the selected table row

        $(".delete_sale").on('click', function () {
            $('.case:checkbox:checked').parents("tr").remove();
            $("#check_all").prop("checked", false);
            calculateTotal();
            calculateTotal_qty();
        });







        //add table rows

        var i = $('.addrow_sale').length;



        $(".addmore_sale").on('click',function(){

            html = '<tr>';
            html += '<td><input class="case" type="checkbox"/></td>';
            html += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_'+i+'" class="form-control" readonly size="1" value="'+i+'"/></td>';
            html += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_'+i+'" class="form-control autocomplete_txt stock_code" autocomplete="off" maxlength="11"></td>';
            html += '<td><input type="text" data-type="party_stock_code" name="party_stock_code[]" id="partystockcode_'+i+'" class="form-control autocomplete_txt party_stock_code" autocomplete="off"></td>';

            html += '<td><input type="text" data-type="description" name="discription[]" id="description_'+i+'" class="form-control autocomplete_txt" autocomplete="off" ></td>';
            html += '<td><input type="text"  name="particulars[]" id="particulars_'+i+'" class="form-control" autocomplete="off"></td>';
            html += '<input type="hidden" name="available_qty[]" id="availableqty_'+i+'" class="form-control available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;">';
            html += '<td><input type="number" name="qty[]" id="qty_'+i+'" class="form-control qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
            html += '<td><input type="text" name="rate[]" id="orate_'+i+'" class="form-control rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
            html += '<td><input type="text" name="discp[]" id="discp_' + i + '" class="form-control discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
            html += '<td><input type="text" name="disc_amt[]" id="discamt_' + i + '" class="form-control discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';

            html += '<td><input type="text" name="itemtot[]" id="itemtot_'+i+'" class="form-control totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';

            html += '</tr>';
            $('#addrow').append(html);
            i++;

            press_enter();

        });







        //date picker
        $('.v_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true
        });


        //dropdown with search
        $(".acct_id").select2();


        //price change
        $(document).on('change keyup blur','.changesNo',function() {
            id_arr = $(this).attr('id');
            id = id_arr.split("_");
            avqty = $('#availableqty_' + id[1]).val();
            qty = $('#qty_' + id[1]).val();
            orate = $('#orate_' + id[1]).val();
            discp = $('#discp_' + id[1]).val();

            if(orate != '') {

                $('#itemtot_' + id[1]).val(parseFloat(orate) * parseFloat(qty) * (1 - discp / 100));
            }


            $('#discamt_' + id[1]).val((parseFloat(orate) * parseFloat(qty) * discp) / 100);





            //if( qty!='' && orate !='' && discp !='' ) $('#itemtot_'+id[1]).val( (parseFloat(orate)*parseFloat(qty)).toFixed(2)*(1-discp/100) );

            calculateTotal();
            calculateTotal_qty();
            calculateInvoiceTotal();
            calculateNetAmount();

        });




        /*****************START DISCOUNT PERCENTAGE**************/
        $(document).on('change keyup blur', '.changesdiscp', function () {
            grandtot = $('#grandtot').val();
            qty = $('#qty_' + id[1]).val();
            orate = $('#orate_' + id[1]).val();
            discp = $('#discp_' + id[1]).val();


            $('#itemtot_'+id[1]).val( parseFloat(orate)*parseFloat(qty) * (1 - discp / 100) );




        });
        /*****************END DISCOUNT PERCENTAGE**************/




        /****************START INVOICE TOTAL****************/
        function calculateInvoiceTotal() {
            grandtot = 0;
            itemtot = 0;
            $('.totalLinePrice').each(function () {
                if ($(this).val() != '') grandtot += parseFloat($(this).val());
            });
            $('#invoice_tot').val(grandtot);
            itemtot += grandtot;
        }
        /****************END INVOICE TOTAL****************/



        /****************START NET AMOUNT AFTER DISCOUNT****************/
        function calculateNetAmount() {
            grandtot = 0;
            itemtot = 0;
            $('.totalLinePrice').each(function () {
                if ($(this).val() != '') grandtot += parseFloat($(this).val());
            });
            $('#net_amt').val(grandtot);
            itemtot += grandtot;
        }
        /****************END NET AMOUNT AFTER DISCOUNT****************/



        /*****************START MASTER DISCOUNT PERCENTAGE**************/
        $(document).on('change keyup blur', '#discp_m', function () {
            grandtot = $('#grandtot').val();
            discp_m = $('#discp_m').val();
            net_amt = $('#net_amt').val();

            $('#net_amt').val(parseFloat(grandtot) * (1 - discp_m / 100));

            $('#invoice_tot').val(parseFloat(grandtot) * (1 - discp_m / 100));

            $('#disc_amt_m').val( (parseFloat(grandtot)* discp_m) / 100  );

        });
        /*****************END MASTER DISCOUNT PERCENTAGE**************/


        /*****************START MASTER DISCOUNT AMOUNT MANNUL TYPE PERCENTAGE**************/
        $(document).on('change keyup blur', '#disc_amt_m', function () {
            grandtot = $('#grandtot').val();
            disc_amt_m = $('#disc_amt_m').val();






            $('#net_amt').val(parseFloat(grandtot) - parseFloat(disc_amt_m));

            $('#invoice_tot').val(parseFloat(grandtot) - parseFloat(disc_amt_m));

        });
        /*****************END MASTER DISCOUNT AMOUNT MANNUL TYPE PERCENTAGE**************/




        /*****************START FREIGHT AMOUNT*************/
        $(document).on('change keyup blur', '#dc_amt', function () {
            grandtot = $('#grandtot').val();
            dc_amt = $('#dc_amt').val();
            disc_amt_m = $('#disc_amt_m').val();


            if(disc_amt_m == '')
            {
                $('#net_amt').val(parseFloat(grandtot) + parseFloat(dc_amt));

                $('#invoice_tot').val(parseFloat(grandtot) + parseFloat(dc_amt));

            }
            else
            {
                $('#net_amt').val(parseFloat(grandtot) - parseFloat(disc_amt_m) + parseFloat(dc_amt));

                $('#invoice_tot').val(parseFloat(grandtot) - parseFloat(disc_amt_m) + parseFloat(dc_amt));
            }




        });
        /*****************END FREIGHT AMOUNT*************/







        /*****************START MASTER DISCOUNT PERCENTAGE**************/
        /*$(document).on('change keyup blur', '#discp_m', function () {
         grandtot = $('#grandtot').val();
         discp_m = $('#discp_m').val();
         adv_amt = $('#adv_amt').val();

         if ($('#adv_amt').val() != '') {
         $('#invoice_tot').val(parseFloat(grandtot) * (1 - discp_m / 100) - parseFloat(adv_amt));
         }
         else
         {
         $('#invoice_tot').val(parseFloat(grandtot) * (1 - discp_m / 100));
         }

         });*/
        /*****************END MASTER DISCOUNT PERCENTAGE**************/



        /*****************START ADVANCE AMOUNT**************/
        $(document).on('change keyup blur', '#adv_amt', function () {
            grandtot = $('#grandtot').val();
            adv_amt = $('#adv_amt').val();
            discp_m = $('#discp_m').val();
            net_amt = $('#net_amt').val();

            disc_amt_m = $('#disc_amt_m').val();


            // $('#invoice_tot').val(Math.round(parseFloat(net_amt) * (1 - discp_m / 100) - parseFloat(adv_amt)) );

            $('#invoice_tot').val(Math.round(parseFloat(net_amt)  - parseFloat(adv_amt)) );




        });
        /*****************END ADVANCE AMOUNT**************/







        //total price calculation
        function calculateTotal() {
            grandtot = 0;
            itemtot = 0;
            $('.totalLinePrice').each(function () {
                if ($(this).val() != '')grandtot += parseFloat($(this).val());
            });
            $('#grandtot').val(grandtot);
            itemtot += grandtot;

            var grand_tot = $('#grandtot').val();

            //alert(grand_tot);


            var freight_tot = $('#freight').val();

            var inv_tot = parseFloat(grand_tot) - parseFloat(freight_tot);

            $('#invoice_tot').val(inv_tot);


        }

        //total pqty calculation
        function calculateTotal_qty() {
            grandtot_qty = 0;
            qty = 0;
            $('.grand_tot_qty').each(function () {
                if ($(this).val() != '')grandtot_qty += parseFloat($(this).val());
            });
            $('#grandtot_qty').val(grandtot_qty);
            qty += grandtot_qty;
        }




        //customer cash calculate
        $(document).on('change keyup blur', '#customer_cash', function () {

            grandtot = $('#grandtot').val();
            customer_cash = $('#customer_cash').val();
            //invoice_tot = $('#invoice_tot').val();


            $('#return_cash').val(parseFloat(customer_cash) - parseFloat(grandtot));

        });
























        function press_enter() {
            $('input').keypress(function (event) {
                if (event.which == '13')	//ENTER
                {
                    var tabIndex = $(this).attr('tabIndex');

                    var all_inputs = $(this).closest('table').find('input:visible');
                    var inputs = all_inputs.filter(function () {
                        return $(this).attr("tabIndex") > tabIndex;
                    })

                    if (inputs.length != 0) {
                        inputs = $(inputs).sort(function (a, b) {
                            return $(a).attr('tabIndex') - $(b).attr('tabIndex');
                        });
                    }
                    else {
                        inputs = $(all_inputs).sort(function (a, b) {
                            return $(a).attr('tabIndex') - $(b).attr('tabIndex');
                        });
                    }


                    var elem = inputs.eq(inputs.index(this) + 1);
                    if (elem.length == 0)
                        elem = inputs.eq(0);

                    elem.focus();
                    event.preventDefault();
                }
            });
        }











        var i = $('.addrow_sale').length;

        $(document).on('keyup', '.discp', function(e) {
            var code = (e.keyCode ? e.keyCode : e.which);
            if (code == 13) {

                html = '<tr>';
                html += '<td><input class="case" type="checkbox"/></td>';
                html += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_'+i+'" class="form-control" readonly size="1" value="'+i+'"/></td>';
                html += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_'+i+'" class="form-control autocomplete_txt stock_code" autocomplete="off" maxlength="11"></td>';
                html += '<td><input type="text" data-type="party_stock_code" name="party_stock_code[]" id="partystockcode_'+i+'" class="form-control autocomplete_txt party_stock_code" autocomplete="off"></td>';

                html += '<td><input type="text" data-type="description" name="discription[]" id="description_'+i+'" class="form-control autocomplete_txt" autocomplete="off" ></td>';
                html += '<td><input type="text"  name="particulars[]" id="particulars_'+i+'" class="form-control" autocomplete="off"></td>';
                html += '<input type="hidden" name="available_qty[]" id="availableqty_'+i+'" class="form-control available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;">';
                html += '<td><input type="number" name="qty[]" id="qty_'+i+'" class="form-control qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                html += '<td><input type="text" name="rate[]" id="orate_'+i+'" class="form-control rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                html += '<td><input type="text" name="discp[]" id="discp_' + i + '" class="form-control discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                html += '<td><input type="text" name="disc_amt[]" id="discamt_' + i + '" class="form-control discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';

                html += '<td><input type="text" name="itemtot[]" id="itemtot_'+i+'" class="form-control totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';

                html += '</tr>';

                $('#addrow').append(html);
                //$(this).focus().select();
                i++;



            }

            press_enter();




        });





        $("#party_bal").hide();
        $("#credit_limit").hide();
        $("#acct_id").change(function ()
        {
            var acct_id = $('#acct_id').val();
            var action = 'party_bal';

            var dataString = 'acct_id=' + acct_id + '&action=' + action;
            $.ajax({
                type: "POST",
                url: "ajax/get_party_bal.php",
                data: dataString,
                success: function (data, status) {
                    // PARSE json data
                    var user = JSON.parse(data);
                    // Assing existing values to the modal popup fields

                    $("#party_bal").show();
                    $("#credit_limit").show();

                    $("#party_bal").val(format_number_drcr(user.bal_amt));
                    $("#credit_limit").val(user.credit_limit);


                }
            });
        });










    </script>
    <!---------------------------START JAVASCRIPT-------------------------------->








</body>
</html>