<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}

$comp_id = clean_data($_SESSION["comp_id"]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $row->acct_name;?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="Thu, 19 Nov 1900 08:52:00 GMT">
    <link rel="shortcut icon" href="images/icons/favicon.html">
    <link rel="apple-touch-icon" href="images/icons/favicon-2.html">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.html">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.html"><!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet"
          href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet"
          href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/select2/select2-madmin.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-select/bootstrap-select.min.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-notific8/jquery.notific8.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-daterangepicker/daterangepicker-bs3.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-datepicker/css/datepicker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" class="default-style">
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" id="theme-change"
          class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
    <link href="vendors/bootstrap-editable/css/bootstrap-editable.css" rel="stylesheet" type="text/css" />
</head>
<body class="sidebar-icons">



<a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP-->



<!--BEGIN TOPBAR-->
<?php include ('header.php'); ?>
<!--END TOPBAR-->


<div id="wrapper">
    <!--BEGIN SIDEBAR MENU-->
    <?php include('left.php'); ?>
    <!--END SIDEBAR MENU-->


    <!--BEGIN PAGE WRAPPER-->
    <div id="page-wrapper">
        <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
            <div class="page-header pull-left">
                <div class="page-title">REGIONS</div>
            </div>
            <ol class="breadcrumb page-breadcrumb pull-right">
                <li><i class="fa fa-home"></i>&nbsp;<a href="index">Home</a>&nbsp;&nbsp;<i
                        class="fa fa-angle-right"></i>&nbsp;&nbsp;
                </li>

                <li class="active">Regions</li>
            </ol>
            <div class="clearfix"></div>
        </div>
        <!--END TITLE & BREADCRUMB PAGE-->


        <!--BEGIN CONTENT-->
        <div class="page-content">


            <!-------------------------------START FIRST LEVEL------------------------------------>
            <button type="button" data-target="#modal-default" data-toggle="modal" class="btn btn-blue pull-right">Add</button>

            <div class="chat-scroller">
                <table class="table table-bordered table-responsive table-striped table-advanced tablesorter tb-sticky-header"
                       id="datatable_one">
                    <caption><h3><b>Province</b></h3></caption>
                    <thead>
                    <tr>
                        <th>REGION ID</th>
                        <th>REGION NAME</th>
                        <th>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    try {
                        $nom_query = "SELECT r.reg_id, r.reg_name FROM regions r WHERE length(r.reg_id) = 2  ORDER BY r.reg_id ";
                        $nom_result = $dbcon->prepare($nom_query);
                        $nom_result->execute(array($comp_id));
                    } catch (PDOException $e) {
                        echo "Error : " . $e->getMessage();
                    }

                    while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {
                        ?>
                        <tr>
                            <td class="btnSelect"><?php echo $nom_row->reg_id; ?></td>
                            <td class="btnSelect"><?php echo $nom_row->reg_name; ?></a></td>
                            <td>
                                <a href="#!" class="text-muted"
                                   onclick="GetDetails('<?php echo $nom_row->reg_id; ?>')"><i
                                        class="glyphicon glyphicon-edit"></i></a>

                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>
            </div>





            <!--------------------------------------START SECOND LEVEL ACCOUNT------------------------------------>

            <div id="level2"></div>
            <div class="level2-scroller">
                <table id="datatable_second"
                       class="table table-bordered table-responsive table-striped">
                    <caption><h3><b>Second Level City</b></h3></caption>
                    <thead>
                    <tr>
                        <th>REGION ID</th>
                        <th>REGION NAME</th>
                        <th>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    try {
                        $nom_query = "SELECT r.reg_id, r.reg_name FROM regions r WHERE length(r.reg_id) = 4  ORDER BY r.reg_id ";
                        $nom_result = $dbcon->prepare($nom_query);
                        $nom_result->execute(array($comp_id));
                    } catch (PDOException $e) {
                        echo "Error : " . $e->getMessage();
                    }
                    $sr = 0;
                    while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {
                        $sr += 1;

                        ?>
                        <tr>
                            <td class="level_second_cell"><?php echo $nom_row->reg_id; ?></td>
                            <td><?php echo $nom_row->reg_name; ?></td>
                            <td>
                                <a href="#!" class="text-muted"
                                   onclick="GetDetails('<?php echo $nom_row->reg_id; ?>')"><i
                                        class="glyphicon glyphicon-edit"></i></a>
                            </td>

                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>

                </table>
            </div>


            <!--------------------------------------END SECOND LEVEL ACCOUNT------------------------------------>






            <!---------------START THIRED LEVEL ACCOUNT---------------->

            <div id="level3"></div>

            <div class="level3-scroller">
                <table id="datatable_thired"
                       class="table table-bordered table-responsive table-striped">
                    <caption><h3><b>Thired Level Area</b></h3></caption>
                    <thead>
                    <tr>
                        <th>REGION ID</th>
                        <th>REGION NAME</th>
                        <th>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>


                    <?php
                    try {
                        $nom_query = "SELECT r.reg_id, r.reg_name FROM regions r WHERE length(r.reg_id) = 6  ORDER BY r.reg_id";
                        $nom_result = $dbcon->prepare($nom_query);
                        $nom_result->execute(array($comp_id));
                    } catch (PDOException $e) {
                        echo "Error : " . $e->getMessage();
                    }

                    $sr = 0;
                    while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {

                        $sr += 1;

                        ?>
                        <tr>

                            <td><?php echo $nom_row->reg_id; ?></td>
                            <td><?php echo $nom_row->reg_name; ?></td>
                            <td>
                                <a href="#!" class="text-muted" onclick="GetDetails('<?php echo $nom_row->reg_id;?>')"><i class="glyphicon glyphicon-edit"></i></a>


                                    <a  class="text-muted delete_product" data-id="<?php echo $nom_row->reg_id; ?>" href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="glyphicon glyphicon-trash"></i></a>

                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>

                </table>
            </div>
            <!---------------END THIRED LEVEL ACCOUNT---------------->







            <!---------------START ADD MODEL--------------->

            <div id="modal-default" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                            <h4 id="modal-default-label" class="modal-title">ADD NEW</h4></div>
                        <div class="modal-body">
                            <div class="form-body pal">
                                <div class="form-group"><label for="inputEmail" class="control-label">Region ID: <span class='require'>*</span></label>
                                    <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_id" id="acct_id"  class="form-control check_acct_id"  /></div>
                                </div>
                                <span class="result_acct_id"></span>

                                <div class="form-group"><label for="inputEmail" class="control-label">Region Name: <span class='require'>*</span></label>
                                    <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_name" id="acct_name"  class="form-control check_acct_name" /></div>
                                    <span class="result_acctname"></span>
                                </div>
                            </div>
                        </div>


                        <div class="modal-footer">
                            <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                            <button type="button" class="btn btn-primary" onClick="chartofacct_add()">Save changes</button>
                        </div>


                    </div>
                </div>
            </div>
            <!---------------END ADD MODEL--------------->

            <!---------------START EDIT MODEL--------------->
            <div id="update_user_modal" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade"  >
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                            <h4 id="modal-default-label" class="modal-title">UPDATE</h4></div>
                        <div class="modal-body">
                            <div class="form-body pal">

                                <div class="form-group"><label for="inputEmail" class="control-label">Region ID: <span class='require'>*</span></label>
                                    <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="first_acct_id" id="update_acct_id"  class="form-control" readonly value="<?php echo $v_id; ?>"/></div>
                                </div>

                                <div class="form-group"><label for="inputEmail" class="control-label">Region Name: <span class='require'>*</span></label>
                                    <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="first_acct_name" id="update_acct_name"  class="form-control check_acct_name" /></div>
                                    <span class="result_acctname"></span>
                                </div>

                            </div>
                        </div>


                        <div class="modal-footer">
                            <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                            <button type="button" class="btn btn-primary" onClick="UpdateDetails()">Save changes</button>
                            <input type="hidden" id="hidden_user_id">
                        </div>
                    </div>
                </div>
            </div>
            <!---------------END EDIT MODEL--------------->



        </div>
    </div>
</div>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/jquery-ui.js"></script><!--loading bootstrap js-->
<script src="vendors/bootstrap/js/bootstrap.min.js"></script>
<script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
<script src="js/html5shiv.js"></script>
<script src="js/respond.min.js"></script>
<script src="vendors/metisMenu/jquery.metisMenu.js"></script>
<script src="vendors/slimScroll/jquery.slimscroll.js"></script>
<script src="vendors/jquery-cookie/jquery.cookie.js"></script>
<script src="vendors/iCheck/icheck.min.js"></script>
<script src="vendors/iCheck/custom.min.js"></script>
<script src="vendors/jquery-notific8/jquery.notific8.min.js"></script>
<script src="vendors/jquery-highcharts/highcharts.js"></script>
<script src="js/jquery.menu.js"></script>
<script src="vendors/jquery-pace/pace.min.js"></script>
<script src="vendors/holder/holder.js"></script>
<script src="vendors/responsive-tabs/responsive-tabs.js"></script>
<script src="vendors/jquery-news-ticker/jquery.newsTicker.min.js"></script>
<script src="vendors/moment/moment.js"></script>
<script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script src="vendors/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="js/main.js"></script><!--LOADING SCRIPTS FOR PAGE-->
<script src="vendors/select2/select2.min.js"></script>
<script src="vendors/bootstrap-select/bootstrap-select.min.js"></script>
<script src="vendors/bootstrap-editable/js/bootstrap-editable.min.js"></script>
<!-- BOOT BOX ALERT -->
<script src="js/bootbox.min.js" type="text/javascript"></script>

<!---------------------------START JAVASCRIPT-------------------------------->
<script type="text/javascript">

    /*************START LEVEL ONE SCROLL*********/
    $('.chat-scroller').slimScroll({
        "width": '100%',
        "height": '270px',
        "wheelStep": 5,
        "scrollTo": "100px"
    });
    /*************END LEVEL ONE SCROLL*********/


    /*************START LEVEL TWO SCROLL*********/
    $('.level2-scroller').slimScroll({
        "width": '100%',
        "height": '200px',
        "wheelStep": 5,
        "scrollTo": "100px"
    });
    /*************END LEVEL TWO SCROLL*********/




    /*************START LEVEL THREE SCROLL*********/
    $('.level3-scroller').slimScroll({
        "width": '100%',
        "height": '150px',
        "wheelStep": 5,
        "scrollTo": "100px"
    });
    /*************END LEVEL THREE SCROLL*********/



    $(".acct_id").select2();

    /****************START FIRST LEVEL ACCOUNT SUBMIT FROM AJAX***************/
    function chartofacct_add() {
        var acct_id = $('#acct_id').val();
        var acct_name = $('#acct_name').val();

        var action = 'add_reg';


        if (acct_id == "") {
            alert("Please Enter Region Id");
            $('#acct_id').focus();
        }
        else if (acct_name == "") {
            alert("Please Enter Region Name");
            $('#acct_name').focus();
        }


        else {
            var dataString = '&acct_id=' + acct_id + '&acct_name=' + acct_name + '&action=' + action;

            $.ajax({
                type: "POST",
                url: "process/master_process.php",
                data: dataString,
                success: function (result) {
                    //alert(result);
                    window.location = "regions"
                }
            });

        }

    }
    /****************END FIRST LEVEL ACCOUNT SUBMIT FROM AJAX***************/




    /****************START SECOND LEVEL ACCOUNT SUBMIT FROM AJAX***************/
    function chartofacct_second_add() {
        var second_level_first_acct_id = $('#second_level_first_acct_id').val();
        var second_acct_name = $('#second_acct_name').val();

        var action = "second_level_form";

        if (second_level_first_acct_id == "") {
            alert("Please Select First Level Account");
            $('#first_acct_id').focus();
        }

        else if (second_acct_name == "") {
            alert("Please Enter Account Name");
            $('#second_acct_name').focus();

        }


        else {
            var dataString = 'second_level_first_acct_id=' + second_level_first_acct_id + '&second_acct_name=' + second_acct_name + '&action=' + action;

            $.ajax({
                type: "POST",
                url: "process/chartofacct_process.php",
                data: dataString,
                success: function (result) {
                    //alert(result);
                    window.location = "show_chart_of_accounts.php"

                }
            });

        }

    }
    /****************END SECOND LEVEL ACCOUNT SUBMIT FROM AJAX***************/





    /****************START FIRST LEVEL ACCOUNT ID IS AVAILBALE OR NOT***************/

    $(".check_acct_id").keyup(function ()
    {
        var check_acct_id = $(this).val();
        if (check_acct_id.length > 2) {
            $(".check_acct_id").html('checking...');

            var dataString = 'check_acct_id=' + check_acct_id + '&action=acct_id';

            $.ajax({
                type: 'POST',
                url: 'ajax/live_check.php',
                data: dataString,
                success: function (data) {
                    $(".result_acct_id").html(data);
                }
            });
            return false;

        }
        else {
            $(".result_acct_id").html('');
        }
    });
    /****************END FIRST LEVEL ACCOUNT ID IS AVAILBALE OR NOT***************/








    /****************START FIRST LEVEL ACCOUNT NAME IS AVAILBALE OR NOT***************/

    $(".check_acct_name").keyup(function ()
    {
        var first_acct_name = $(this).val();


        if (first_acct_name.length > 2) {
            $(".result_acctname").html('checking...');

            var dataString = 'first_acct_name=' + first_acct_name + '&action=acct_name_one';

            $.ajax({
                type: 'POST',
                url: 'ajax/live_check.php',
                data: dataString,
                success: function (data) {
                    $(".result_acctname").html(data);
                }
            });
            return false;

        }
        else {
            $(".result_acctname").html('');
        }
    });


    /****************END FIRST LEVEL ACCOUNT NAME IS AVAILBALE OR NOT***************/






    /*******************START GETDETAIL EDIT ID*****************/
    function GetDetails(id) {
        // Add User ID to the hidden field for furture usage
        $("#hidden_user_id").val(id);

        var action = 'edit_reg';


        var dataString = 'id=' + id +
            '&action=' + action;

        $.ajax({
            type: "POST",
            url: "ajax/get_details.php",
            data: dataString,
            success: function (data, status) {

                // PARSE json data
                var user = JSON.parse(data);
                // Assing existing values to the modal popup fields
                $("#update_acct_id").val(user.reg_id);
                $("#update_acct_name").val(user.reg_name);

            }
        });

        // Open modal popup
        $("#update_user_modal").modal("show");
    }
    /*******************END GETDETAIL EDIT ID*****************/


    /*******************START UPDATE DETAIL EDIT ID*****************/
    function UpdateDetails() {
        // get values
        var update_acct_id = $("#update_acct_id").val();
        var update_acct_name = $("#update_acct_name").val();
        // get hidden field value
        var id = $("#hidden_user_id").val();

        var action = 'edit_reg';

        // Update the details by requesting to the server using ajax
        var dataString = 'id=' + id +
            '&update_acct_id=' + update_acct_id +
            '&update_acct_name=' + update_acct_name +
            '&action=' + action;
        $.ajax({
            type: "POST",
            url: "ajax/update_details.php",
            data: dataString,
            success: function (data, status) {
                //alert(data);
                // hide modal popup
                $("#update_user_modal").modal("hide");
                window.location = "regions"
            }
        });
    }
    /*******************END UPDATE DETAIL EDIT ID*****************/




    /*******************START SECOND LEVEL GETDETAIL EDIT ID*****************/
    function GetDetails_second(id) {
        // Add User ID to the hidden field for furture usage
        $("#hidden_second_level").val(id);
        var action = 'second_edit_chart_of_account';

        var dataString = 'id=' + id +
            '&action=' + action;

        $.ajax({
            type: "POST",
            url: "ajax/get_details.php",
            data: dataString,
            success: function (data, status) {



                // PARSE json data
                var user = JSON.parse(data);
                // Assing existing values to the modal popup fields
                $("#update_second_level_first_acct_id").val(user.acct_id);
                $("#update_second_acct_name").val(user.acct_name);

            }
        });

        // Open modal popup
        $("#update_second_level_modal").modal("show");
    }
    /*******************END SECOND LEVEL GETDETAIL EDIT ID*****************/


    /*******************START UPDATE DETAIL EDIT ID*****************/
    function UpdateDetails_second() {
        // get values
        var update_second_acct_name = $("#update_second_acct_name").val();
        // get hidden field value
        var id = $("#hidden_second_level").val();

        var action = 'second_edit_chart_of_account';

        // Update the details by requesting to the server using ajax
        var dataString = 'id=' + id +
            '&update_second_acct_name=' + update_second_acct_name +
            '&action=' + action;
        $.ajax({
            type: "POST",
            url: "ajax/update_details.php",
            data: dataString,
            success: function (data, status) {
                //alert(data);
                // hide modal popup
                $("#update_second_level_modal").modal("hide");
                window.location = "show_chart_of_accounts"
            }
        });
    }
    /*******************END UPDATE DETAIL EDIT ID*****************/

























    /*******************START DELETE ITEM*****************/
    $(document).ready(function () {
        $('.delete_product').click(function (e) {
            e.preventDefault();
            var pid = $(this).attr('data-id');
            var parent = $(this).parent("td").parent("tr");
            bootbox.dialog({
                message: "Are you sure you want to Delete ?",
                title: "<i class='glyphicon glyphicon-trash'></i> Delete !",
                buttons: {
                    success: {
                        label: "No",
                        className: "btn-success",
                        callback: function () {
                            $('.bootbox').modal('hide');
                        }
                    },
                    danger: {
                        label: "Delete!",
                        className: "btn-danger",
                        callback: function () {
                            $.post('del_master.php', {'reg_delete': pid})
                                .done(function (response) {
                                    bootbox.alert(response);
                                    parent.fadeOut('slow');
                                })
                                .fail(function () {
                                    bootbox.alert('Something Went Wrog ....');
                                })
                            window.location = "regions.php"
                        }
                    }
                }
            });


        });

    });
    /*******************END DELETE ITEM*****************/


























































    /**********************START GET SECOND LEVEL FROM FIRST LEVEL*********************/
    $(document).ready(function(){
        // code to read selected table row cell data (values).
        $("#datatable_one").on('click','.btnSelect',function(){
            // get the current row
            var currentRow=$(this).closest("tr");
            var first_level_acct_id = currentRow.find("td:eq(0)").text(); // get current row 2nd TD



            var action = 'first_level';

            var datastring = 'first_level_acct_id=' + first_level_acct_id  + '&action=' + action;

            $.ajax({
                type: "POST",
                url: "get_second_level_reg.php",
                data: datastring,
                beforeSend: function () {
                    $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
                },
                success: function (result) {
                    //alert(result)
                    $('#datatable_second').hide();
                    $('#level2').html(result);
                }
            });
        });
    });
    /**********************END GET SECOND LEVEL FROM FIRST LEVEL*********************/





    /**********************START GET THIRED LEVEL FROM FIRST LEVEL*********************/
    $(document).ready(function(){
        // code to read selected table row cell data (values).
        $("#datatable_one").on('click','.btnSelect',function(){
            // get the current row
            var currentRow=$(this).closest("tr");
            var first_level_acct_id = currentRow.find("td:eq(0)").text(); // get current row 2nd TD
            var action = 'get_thired';

            var datastring = 'first_level_acct_id=' + first_level_acct_id  + '&action=' + action;

            $.ajax({
                type: "POST",
                url: "get_second_level_reg.php",
                data: datastring,
                beforeSend: function () {
                    $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
                },
                success: function (result) {
                    //alert(result)
                    $('#datatable_thired').hide();
                    $('#level3').html(result);
                }
            });
        });
    });
    /**********************END GET THIRED LEVEL FROM FIRST LEVEL*********************/
















</script>
<!---------------------------END JAVASCRIPT-------------------------------->




</body>
</html>
