<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

if(isset($_POST['action']) && !empty($_POST['action']))
{
    if($_POST['action'] == "search") {

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_POST['comp_id']);

        $acct_id = clean_data($_POST['acct_id']);

        $rpt_type = clean_data($_POST['rpt_type']);
        $filter_type = clean_data($_POST['filter_type']);
        $voucher_id = clean_data($_POST['voucher_id']);

        $stock_code = clean_data($_POST['stock_code']);

        $type_id = clean_data($_POST['type_id']);
        $cat_id = clean_data($_POST['cat_id']);

        /*****************START MYSQL VARIABLES**************/
        $rate_decimals = find_value('system','rate_decimals','');

        $comp_name = '';
        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        } else {
            $comp_name = find_value('system', 'comp_name', "");

        }
        /*************END FINDE COMPANY NAME*****************/


        $and = '';
        $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

        if ($comp_id != "All") {

            $and .= " and v.comp_id = '$comp_id'";


        } else {
            $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";


        }

        if ($acct_id != "All") {
            $and .= " and v.party_id = '$acct_id'";
        }

        if ($rpt_type != "All") {
            $and .= " and v.voucher_type = '$rpt_type'";
        }

        if ($cat_id != "All") {
            $and .= " and (i.cat_id = '$cat_id')";
        }

        if ($type_id != "All") {
            $and .= " and (v.type_id = '$type_id')";
        }

        /*
        if ($voucher_id != "")
                $and .= " and v.voucher_id = '$voucher_id'";

        if ($stock_code != "All") {
            $and .= " and (i.stock_code = '$stock_code')";
        }

*/

        $report_name = '';
        if ($rpt_type == "All") {

            $report_name = "Daily Report";

        }

        if ($rpt_type == "SL") {

            $report_name = "Sale Report";

        }

        if ($rpt_type == "SR") {

            $report_name = "Sale Recovery";

        }

        if ($rpt_type == "RT") {

            $report_name = "Sale Retrun";

        }

        if ($rpt_type == "PL") {

            $report_name = "Purchase Report";

        }


        if ($rpt_type == "ST") {

            $report_name = "Stock Report";

        }





        /*****************END MYSQL VARIABLES**************/


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/
        try {
            $msqlquery = "SELECT

v.comp_id,
`v`.`voucher_id` AS `voucher_id`,
v.voucher_type,
v.voucher_date,
v.party_name,
v.to_party_name,
p.address,
v.stock_code,
v.stock_name,
v.type_name,
v.rate,
v.bill_no,
v.gadi_no,
v.qty,
v.sl_v_id,
v.pl_v_id

FROM v_loading v
LEFT JOIN v_item i on v.stock_code=i.stock_code
LEFT JOIN v_party p on v.to_party_id=p.acct_id
WHERE
		1 = 1 $and order by v.voucher_date, v.voucher_type desc, v.voucher_id, v.lineitem";
//echo $msqlquery;

            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }

        ?>


        <h1 style="text-align: center; font-size: 35px; font-weight: bold;"><?php echo $comp_name ; ?></h1>
        <h1 style="text-align: center; font-size: 35px; font-weight: bold;"><?php echo $report_name; ?></h1>

        <a href="pdf_loading_daybook?from_date=<?php echo $new_from_date; ?>&to_date=<?php echo $new_to_date;?>&comp_id=<?php echo $comp_id;?>&acct_id=<?php echo $acct_id;?>&stock_code=<?php echo $stock_code;?>&cat_id=<?php echo $cat_id;?>&type_id=<?php echo $type_id;?>&rpt_type=<?php echo $rpt_type;?>"
           target="_blank" style="text-decoration:none; color:#FFF" class="btn btn-success" data-toggle="tooltip"
           data-placement="top" title="PDF">PDF</a>

        <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <tr>
                <th>V Type</th>
                <td align="center"><b>Date</td>
                <td align="center"><b>Voucher No</td>
                <td align="center"><b>Sale Bill No</td>
                <td align="center"><b>Purchase Bill No</td>
                <th>Gadi No</th>
                <th>From</th>
                <th>Item</th>
                <th>Brand</th>
                <td align=right><b>Bori</td>
                <td align=right><b>Rate</td>
                <td><b>To</td>
                <td><b>Address</td>

            </tr>
            <?php

            $serno = 0;
            $g_q_tot = '';
            $g_amt = '';
            $g_disc_amt = '';
            $g_profit = '';

            while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
                $serno = $serno + 1;

                    $g_q_tot += $report_row['qty'];



                ?>

                <tr>
                    <td><?php echo $report_row['voucher_type']; ?></td>
                    <td><?php echo format_date($report_row['voucher_date']); ?></td>
                    <td align="center"><?php echo $report_row['bill_no']; ?></td>
                    <td align="center"><?php echo $report_row['sl_v_id']; ?></td>
                    <td align="center"><?php echo $report_row['pl_v_id']; ?></td>
                    <td><?php echo $report_row['gadi_no']; ?></td>
                    <td><?php echo ($report_row['party_name']); ?></td>
                    <td><?php echo ($report_row['stock_name']); ?></td>
                    <td><?php echo ($report_row['type_name']); ?></td>
                    <td align=right><?php echo format_number($report_row['qty'],0); ?></td>
                    <td align=right><?php echo format_number($report_row['rate'],0); ?></td>
                    <td><?php echo ($report_row['to_party_name']); ?></td>
                    <td><?php echo ($report_row['address']); ?></td>

                </tr>
                <?php

            }
            ?>
            <tr>


                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td align="right"><b>Total</b></td>
                <td align=right><b><?php echo format_number($g_q_tot,0); ?></b></td>
                <td></td>
                <td></td>
                <td></td>

            </tr>



        </table>
        </div>


        <?php
    }



}



?>