<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

if(isset($_POST['action']) && !empty($_POST['action']))
{
    if($_POST['action'] == "search") {

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_POST['comp_id']);

        $rpt_type = clean_data($_POST['rpt_type']);
        $filter_type = clean_data($_POST['filter_type']);
        $voucher_id = clean_data($_POST['voucher_id']);

        $stock_code = clean_data($_POST['stock_code']);

        $type_id = clean_data($_POST['type_id']);
        $cat_id = clean_data($_POST['cat_id']);
        $loc_id = clean_data($_POST['loc_id']);
        $acct_id = clean_data($_POST['acct_id']);
        $sale_type = clean_data($_POST['sale_type']);
        $reg_id = clean_data($_POST['reg_id']);

        /*****************START MYSQL VARIABLES**************/
        $rate_decimals = find_value('system','rate_decimals','');

        $comp_name = '';
        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        } else {
            $comp_name = find_value('system', 'comp_name', "");

        }
        /*************END FINDE COMPANY NAME*****************/


        $and = " and substr(v.voucher_id,1,2) in('SL','PL','ST','DC', 'CO', 'RT')";
        $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

        if ($comp_id != "All") {

            $and .= " and v.comp_id = '$comp_id'";

        } else {
            $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";
        }


        if ($rpt_type != "All") {
            $and .= " and substring(v.voucher_id,1,2) = '$rpt_type'";
        }

        if ($filter_type == "ZERO_COST") {
            $and .= " and ((v.cost_amt/v.cr_qty)=0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL','ST'))";
        } else if ($filter_type == "DISCOUNT") {
            $and .= " and (v.disc_amt<>0)";
        } else if ($filter_type == "PROFIT") {
                $and .= " and ((v.cr_amt-v.cost_amt)>0)";
                $and .= " and (substring(v.voucher_id,1,2) IN('SL','ST'))";
        } else if ($filter_type == "LOSS") {
            $and .= " and ((v.cr_amt-v.cost_amt)<0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL','ST'))";
        } else if ($filter_type == "ZERO_PROFIT") {
            $and .= " and ((v.cr_amt-v.cost_amt)=0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL'))";
        } else if ($filter_type == "ADVANCE_SALE") {
            $and .= " and ((v.cr_amt-v.cost_amt)=0)";
        }
        else if ($filter_type == "MSRPL") {
            $and .= " and v.rate < v.limit_rate";
        }
        else if ($filter_type == "MSRPG") {
            $and .= " and v.rate > v.limit_rate";
        }
        else if ($filter_type == "dealerl") {
            $and .= " and v.rate < v.limit_rate";
        }
        else if ($filter_type == "dealerg") {
            $and .= " and v.rate > v.limit_rate";
        }

        if ($cat_id != "All") {
            $and .= " and (i.cat_id = '$cat_id')";
        }

        if ($type_id != "All") {
            $and .= " and (i.type_id = '$type_id')";
        }

        if ($stock_code != "All") {
            $and .= " and (i.stock_code = '$stock_code')";
        }

        /*
        if ($voucher_id != "")
                $and .= " and v.voucher_id = '$voucher_id'";


*/

        $report_name = '';
        if ($rpt_type == "All") {

            $report_name = "Daily Report";

        }

        if ($rpt_type == "SL") {

            $report_name = "Sale Report";

        }

        if ($rpt_type == "DC") {

            $report_name = "Delivery Challan Report";

        }

        if ($rpt_type == "SR") {

            $report_name = "Sale Recovery";

        }

        if ($rpt_type == "RT") {

            $report_name = "Sale Retrun";

        }

        if ($rpt_type == "PL") {

            $report_name = "Purchase Report";

        }


        if ($rpt_type == "ST") {

            $report_name = "Stock Report";

        }


        if ($rpt_type == "MO") {

            $report_name = "Production";

        }



        if ($loc_id != "All") {
            $and .= " and v.loc_id = '$loc_id'";
        }

        if ($acct_id != "All") {
            $and .= " and v.party_id = '$acct_id'";
        }

        if ($sale_type == "Credit") {

            $and .= " and  n.cash<>'Y'";

        }

        if ($sale_type == "Cash") {

            $and .= "  and n.cash='Y'";

        }


        if ($reg_id != "All") {
           $and .= " and n.reg_id like '$reg_id%'";

       }




        /*****************END MYSQL VARIABLES**************/


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/

        if (($rpt_type == "CO")) {
            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
null bill_no,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
null cost_price,

null profit,
null disc_amt,
i.unit_name


FROM v_stk v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and order by v.voucher_date, v.voucher_id";

        }


if (($rpt_type == "ST")) {
            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
null bill_no,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
null cost_price,

null profit,
null disc_amt,
i.unit_name


FROM v_stk v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and order by v.voucher_date, v.voucher_id";

        }

        if (($rpt_type == "SL")) {

            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
v.bill_no,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cost_amt/v.cr_qty) ,0) cost_price,

if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cr_amt-v.cost_amt) ,0) profit,
v.disc_amt,
i.unit_name,
       date_format(v.post_date, \"%h:%i %p\") post_date,
       v.limit_rate,
       v.bouns_qty


FROM v_p_vouchers v
LEFT JOIN v_item i on v.stock_code=i.stock_code
LEFT JOIN nom n ON v.party_id = n.acct_id 
	
	
	WHERE
		1 = 1 $and  and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
		order by v.voucher_date, v.voucher_id,v.lineitem/1";

    }



        if (($rpt_type == "RT")) {

            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
v.bill_no,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
if(substring(v.voucher_id,1,2) in('SL','ST', 'RT'),if(ifnull(v.cost_amt,0)=0,0,v.cost_amt/v.db_qty) ,0) cost_price,

if(substring(v.voucher_id,1,2) in('SL','ST', 'RT'),if(ifnull(v.cost_amt,0)=0,0,v.db_amt-v.cost_amt) ,0) profit,
v.disc_amt,
i.unit_name


FROM v_p_vouchers v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and  
		order by v.voucher_date, v.voucher_id,v.lineitem/1";

        }



try{
            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }






        ?>


        <h1 style="text-align: center; font-size: 35px; font-weight: bold;"><?php echo $comp_name ; ?></h1>
        <h1 style="text-align: center; font-size: 35px; font-weight: bold;"><?php echo $report_name; ?></h1>

        <a href="pdf_report_sale?from_date=<?php echo $new_from_date; ?>&to_date=<?php echo $new_to_date;?>&comp_id=<?php echo $comp_id;?>&stock_code=<?php echo $stock_code;?>&rpt_type=<?php echo $rpt_type;?>&filter_type=<?php echo $filter_type;?>"
           target="_blank" style="text-decoration:none; color:#FFF" class="btn btn-success" data-toggle="tooltip"
           data-placement="top" title="PDF">PDF</a>

        <i class="fa fa-file-excel pull-right exportToExcel ml-2" data-toggle="tooltip"
           data-placement="top" title="Export to Excel"><button class="btn btn-green">Export To Excel</button> </i>
        <div class="table-responsive">
        <table class="table table-bordered table-striped table2excel">
            <tr>
                <th>Sr</th>
                <th>VOUCHER ID</th>
                <th>TIME</th>
                <th>VOUCHER DATE</th>
                <th>PARTY NAME</th>
                <th>STOCK CODE</th>
                <th>STOCK NAME</th>

                <td align=right><b>QTY</td>
                <td align=right><b>SCHEME</td>
                <td align=right><b>MSRP/DEALER</td>
                <td align=right><b>RATE</td>
                <td align=right><b>DISCOUNT</td>
                <td align=right><b>AMOUNT</td>
                <td align=right><b>COST PRICE</td>
                <td align=right><b>PROFIT</td>

            </tr>
            <?php





            $serno = 0;
            $g_q_tot = 0;
            $g_amt = 0;
            $g_disc_amt = 0;
            $g_profit = 0;

            while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
                $serno = $serno + 1;

                    $g_q_tot += $report_row['qty'];
                $tot_bouns_qty += $report_row['bouns_qty'];

                    $g_disc_amt += $report_row['disc_amt'];
                    $g_amt += $report_row['amt'];
                    $g_profit += $report_row['profit'];
                $vouchertype = substr($report_row['voucher_id'],2,2);
                $d_comp_id = substr($report_row['voucher_id'],0,2);
                $v_comp_id = substr( $report_row['voucher_id'],0,2);

                if (substr($report_row['voucher_id'], 2, 2) == 'SL') {
                    $voucherID = substr($report_row['voucher_id'], 4, 6);
                    $link_voucher = 'kt_sl_inv_detail';
                    $p_compId = 'comp_id';
                    $menu_id='1.1';
                }

              /*
                if($report_row['rate'] < $report_row['msrp'] )
                {
                    $bg_color = '#F41111';
                }
                else
                {
                    $bg_color = '';
                }*/



                ?>

                <tr>
                    <td><?php echo($serno); ?></td>
                    <td><a href="<?php echo $link_voucher;?>?v_id=<?php echo $voucherID;?>&voucher_type=<?php echo $vouchertype;?>&posted='on'&comp_id=<?php echo $v_comp_id;?>&year_id=<?php echo $p_year_id;?>&menu_id=<?php echo $menu_id;?>" target="_blank"><?php echo $report_row['voucher_id']; ?></a></td>
                    <td><?php echo $report_row['post_date']; ?></td>
                    <td><?php echo $report_row['voucher_date']; ?></td>
                    <td><?php echo ($report_row['party_name']); ?></td>
                    <td><?php echo ($report_row['stock_code']); ?></td>
                    <td><?php echo ($report_row['stock_name']); ?></td>

                    <td align=right><?php echo format_number($report_row['qty'],0); ?></td>
                    <td align=right><?php echo format_number($report_row['bouns_qty'],0); ?></td>
                    <td align=right>

                        <?php

                            echo format_number($report_row['limit_rate'], $rate_decimals);


                        ?>
                    </td>
                    <td align=right bgcolor="<?php echo $bg_color;?>"><?php echo format_number($report_row['rate'], $rate_decimals); ?></td>
                    <td align=right><?php echo format_number($report_row['disc_amt'],0); ?></td>
                    <td align=right><?php echo format_number($report_row['amt'],0); ?></td>
                    <td align=right><?php echo format_number($report_row['cost_price'], $rate_decimals); ?></td>
                    <td align=right><?php echo format_number($report_row['profit'],0); ?></td>

                </tr>
                <?php

            }
            ?>
            <tr>



                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td align="right"><b>Total</b></td>
                <td align=right><b><?php echo format_number($g_q_tot,0); ?></b></td>
                <td align=right><b><?php echo format_number($tot_bouns_qty,0); ?></b></td>

                <td></td>
                <td align=right><b><?php echo format_number($g_disc_amt,0); ?></b></td>
                <td align=right><b><?php echo format_number($g_amt,0); ?></b></td>
                <td></td>
                <td align=right><b><?php echo format_number($g_profit,0); ?></b></td>
            </tr>



        </table>
        </div>


        <?php
    }



}



?>


<script type="text/javascript">
    $(".exportToExcel").click(function(){
        $(".table2excel").table2excel({
            exclude: ".noExl",
            name: "<?php echo $from_date . ' - ' . $to_date . ' - '. $comp_name; ?>",
            filename: "<?php echo $from_date . ' - ' . $to_date . ' - '. $comp_name; ?>"+ ".xls",
            fileext: ".xls",
            exclude_img: true,
            exclude_links: true,
            exclude_inputs: true
        });
    });
</script>
