<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

if (isset($_POST['action']) && !empty($_POST['action'])) {
    if ($_POST['action'] == "search") {

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_POST['comp_id']);

        $bill_type = clean_data($_POST['bill_type']);


        /*****************START MYSQL VARIABLES**************/
        $rate_decimals = find_value('system', 'rate_decimals', '');

        $comp_name = '';
        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        } else {
            $comp_name = find_value('system', 'comp_name', "");
        }
        /*************END FINDE COMPANY NAME*****************/


        $and = "";
        //$and .= " and (v.voucher_date BETWEEN '$new_from_date' and '$new_to_date')";


        $month = date("m",strtotime($new_from_date));
        $curr_month_from_date = date('Y-'.$month.'-01');


        /*****************END MYSQL VARIABLES**************/


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/


        $msqlquery = "SELECT DISTINCT
	n.comp_id,
	n.cash_sale,
	n.credit_sale,
	n.cash_received,
	n.cash_payment,
	n.cash_purchase,
	n.sale_return,
    n.voucher_date,
    n.month_cash_sale,
    n.month_credit_sale,
    n.comp_id
	
FROM
	(
	SELECT
		v.comp_id,
	    v.voucher_date,
		c.cash_sale,
		c2.credit_sale,
		c3.cash_received,
		c4.cash_payment,
		c5.cash_purchase,
		c6.sale_return,
	    c7.month_cash_sale,
	    c8.month_credit_sale
		
	FROM
		v_vouchers v
		LEFT JOIN (
		SELECT
			v2.comp_id,
			SUM( v2.debit ) cash_sale 
		FROM
			v_vouchers v2 
		WHERE
			1 = 1 
			AND substr( v2.voucher_id, 3, 2 ) = 'SL' 
			AND v2.cash = 'Y' 
			and v2.voucher_date BETWEEN '$new_from_date' and '$new_to_date'
		GROUP BY
			v2.comp_id 
		) c ON v.comp_id = c.comp_id
		LEFT JOIN (
		SELECT
			v3.comp_id,
			SUM( v3.debit ) credit_sale 
		FROM
			v_vouchers v3 
		WHERE
			1 = 1 
			AND substr( v3.voucher_id, 3, 2 ) = 'SL' 
			AND v3.cash <> 'Y' 
			and v3.voucher_date BETWEEN '$new_from_date' and '$new_to_date' 
		AND
		IF
			(
				substring( v3.voucher_id, 3, 2 ) IN ( 'SL', 'PL' ),
				substring( v3.voucher_id,- 1 )= 1,
				1 = 1 
			) 
		GROUP BY
			v3.comp_id 
		) c2 ON v.comp_id = c2.comp_id
		LEFT JOIN (
		SELECT
			v4.comp_id,
			SUM( v4.debit ) cash_received 
		FROM
			v_vouchers v4 
		WHERE
			1 = 1 
			AND substr( v4.voucher_id, 3, 2 ) IN ( 'CR', 'JV' ) 
			AND v4.acct_id IN ( '2710000001') 
			and v4.voucher_date BETWEEN '$new_from_date' and '$new_to_date'
		GROUP BY
			v4.comp_id 
		) c3 ON v.comp_id = c3.comp_id
		LEFT JOIN (
		SELECT
			v5.comp_id,
			SUM( v5.credit ) cash_payment 
		FROM
			v_vouchers v5 
		WHERE
			1 = 1 
			AND substr( v5.voucher_id, 3, 2 ) IN ( 'CP', 'JV' ) 
			AND v5.acct_id IN ( '2710000001' ) 
			and v5.voucher_date BETWEEN '$new_from_date' and '$new_to_date'
		GROUP BY
			v5.comp_id 
		) c4 ON v.comp_id = c4.comp_id
		LEFT JOIN (
		SELECT
			v6.comp_id,
			SUM( v6.credit ) cash_purchase 
		FROM
			v_vouchers v6 
		WHERE
			1 = 1 
			AND substr( v6.voucher_id, 3, 2 ) = 'PL' 
			AND v6.acct_id IN ( '2710000001' ) 
			and v6.voucher_date BETWEEN '$new_from_date' and '$new_to_date' 
		GROUP BY
			v6.comp_id 
		) c5 ON v.comp_id = c5.comp_id
		LEFT JOIN (
		SELECT
			v7.comp_id,
			SUM( v7.credit ) sale_return 
		FROM
			v_vouchers v7 
		WHERE
			1 = 1 
			AND substr( v7.voucher_id, 3, 2 )= 'RT' 
			AND v7.acct_id IN ( '2710000001') 
			and v7.voucher_date BETWEEN '$new_from_date' and '$new_to_date'
		GROUP BY
			v7.comp_id 
		) c6 ON v.comp_id = c6.comp_id
	    
	    
	    	LEFT JOIN (
		SELECT
			v8.comp_id,
			SUM(v8.net_amt) month_cash_sale 
		FROM
			sl_invoice v8
		LEFT JOIN nom n ON v8.acct_id=n.acct_id
		WHERE
			1 = 1 
			AND n.cash = 'Y'  and v8.voucher_date BETWEEN '$curr_month_from_date' and '$new_to_date'
		GROUP BY
			v8.comp_id 
		) c7 ON v.comp_id = c7.comp_id
	    
	    
	    	LEFT JOIN (
		SELECT
			v9.comp_id,
			SUM(v9.net_amt) month_credit_sale 
		FROM
			sl_invoice v9
		LEFT JOIN nom n ON v9.acct_id=n.acct_id
		WHERE
			1 = 1 
			AND n.cash<> 'Y' and v9.voucher_date BETWEEN '$curr_month_from_date' and '$new_to_date'
		GROUP BY
			v9.comp_id 
		) c8 ON v.comp_id = c8.comp_id

	) n 
WHERE n.voucher_date BETWEEN '$new_from_date' and '$new_to_date' GROUP BY n.comp_id";


        try {

            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }


        //echo $msqlquery;


        ?>


        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">

                        <h1 style="text-align: center; font-size: 40px; font-weight: bold;"><?php echo $comp_name; ?></h1>
                        <h1 style="text-align: center; font-size: 30px; font-weight: bold;">Daily Summary</h1>
                        <h1 style="text-align: center; font-size: 12px; font-weight: bold;">Date <?php echo $from_date . ' - '. $to_date;?></h1>

                        <!--        <a href="pdf_sale_status?from_date=<?php /*echo $new_from_date; */?>&to_date=<?php /*echo $new_to_date; */?>&comp_id=<?php /*echo $comp_id; */?>&bill_type=<?php /*echo $bill_type; */?>" target="_blank" style="text-decoration:none; color:#FFF" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="PDF">PDF</a>
-->

                        <table class="table table-bordered table-striped">

                            <tr>
                                <th colspan="6" style="text-align: center; font-size: 20px;">Receipts</th>
                                <th colspan="6" style="text-align: center; font-size: 20px;">Payments</th>
                                <th colspan="2"> <?php echo format_date($curr_month_from_date) . '-' . $to_date ?></th>
                            </tr>

                            <tr>
                                <th>Company</th>
                                <th>OB</th>
                                <th>Cash Sale</th>
                                <th>Credit Sale </th>
                                <th>Receiving</th>
                                <th>Total</th>


                                <th>Cash Payment</th>
                                <th>Credit Sale </th>
                                <th>Cash In Hand</th>
                                <th>Cash Purchase</th>
                                <th>Sale Return</th>
                                <th>Total</th>


                                <th>Cash Sale</th>
                                <th>Credit Sale </th>


                            </tr>
                            <?php





                            $serno = 0;
                            $g_q_tot = 0;
                            $g_amt = 0;


                            while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
                                $serno = $serno + 1;

                                $g_amt += $report_row['amt'];

                                $day_name = $report_row['day_name'];
                                $tot_cash += $report_row['CashSale'];
                                $OnlineSale += $report_row['OnlineSale'];
                                $CreditSale += $report_row['CreditSale'];

                                $row_tot = $report_row['CashSale'] + $report_row['OnlineSale'] + $report_row['CreditSale'];

                                $g_row_tot += $row_tot;


                                $f_comp_id =  $report_row['comp_id'];



                                if($f_comp_id == 'NG')
                                {
                                    $ob  = round(find_value("(SELECT sum(ifnull(v.debit,0) - ifnull(v.credit,0)) bal_amt
                                                FROM v_vouchers v where  v.voucher_date < '$new_from_date' and  v.acct_id = '2710000001') v ", 'bal_amt', ''));


                                }


                                if($f_comp_id == 'FJ')
                                {
                                    $ob  = round(find_value("(SELECT sum(ifnull(v.debit,0) - ifnull(v.credit,0)) bal_amt
                                                FROM v_vouchers v where  v.voucher_date < '$new_from_date' and  v.acct_id = '2710000005') v ", 'bal_amt', ''));


                                }








                                $row_tot = $ob + $report_row['cash_sale'] + $report_row['credit_sale']+ $report_row['cash_received'];

                                $g_row_tot += $row_tot;


                                $cal_cash_in_hand = $ob + $report_row['cash_sale'] + $report_row['cash_received'] - $report_row['cash_payment'] - $report_row['cash_purchase'] - $report_row['sale_return'];


                                $row_tot_payment = $report_row['cash_payment'] + $report_row['credit_sale']+ $cal_cash_in_hand + $report_row['cash_purchase'] + $report_row['sale_return'];

                                $g_row_tot_pay += $row_tot_payment;




                                $g_ob_tot += $ob;

                                $g_cash_sale_tot += $report_row['cash_sale'];
                                $g_tot_credit_sale += $report_row['credit_sale'];
                                $g_tot_cash_rec += $report_row['cash_received'];
                                $g_tot_cash_payment += $report_row['cash_payment'];
                                $g_tot_cash_purchase += $report_row['cash_purchase'];
                                $g_tot_sale_return += $report_row['sale_return'];
                                $g_tot_cash_hand += $cal_cash_in_hand;
                                $g_cash_month_cash_sale += $report_row['month_cash_sale'];
                                $g_tot_month_credit_sale += $report_row['month_credit_sale'];s

                                ?>

                                <tr>
                                    <td><?php echo ($report_row['comp_id']); ?></td>
                                    <td><?php echo format_number($ob,0); ?></td>
                                    <td><?php echo format_number($report_row['cash_sale'],0); ?></td>
                                    <td><?php echo format_number($report_row['credit_sale'],0); ?></td>
                                    <td><?php echo format_number($report_row['cash_received'],0); ?></td>
                                    <td style="font-weight: bold;"><?php echo format_number($row_tot,0); ?></td>

                                    <td><?php echo format_number($report_row['cash_payment'],0); ?></td>
                                    <td><?php echo format_number($report_row['credit_sale'],0); ?></td>
                                    <td><?php echo format_number($cal_cash_in_hand,0); ?></td>
                                    <td><?php echo format_number($report_row['cash_purchase'],0); ?></td>
                                    <td><?php echo format_number($report_row['sale_return'],0); ?></td>

                                    <td style="font-weight: bold;"><?php echo format_number($row_tot_payment,0); ?></td>

                                    <td><?php echo format_number($report_row['month_cash_sale'],0); ?></td>
                                    <td><?php echo format_number($report_row['month_credit_sale'],0); ?></td>


                                </tr>
                                <?php

                            }
                            ?>
                            <tr>




                                <td ><b>Total</b></td>
                                <td ><b><?php echo format_number( $g_ob_tot , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_cash_sale_tot , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_tot_credit_sale , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_tot_cash_rec , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_row_tot , 0); ?></b></td>




                                <td ><b><?php echo format_number( $g_tot_cash_payment , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_tot_credit_sale , 0); ?></b></td>

                                <td ><b><?php echo format_number( $g_tot_cash_hand , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_tot_cash_purchase , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_tot_sale_return , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_row_tot_pay , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_cash_month_cash_sale , 0); ?></b></td>
                                <td ><b><?php echo format_number( $g_tot_month_credit_sale , 0); ?></b></td>


                            </tr>



                        </table>

                    </div>
                </div>
            </div>
        </div>



        <?php
    }
}



?>