<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

if(isset($_POST['action']) && !empty($_POST['action']))
{
    if($_POST['action'] == "search") {

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_POST['comp_id']);

        $rpt_type = clean_data($_POST['rpt_type']);
        $filter_type = clean_data($_POST['filter_type']);
        $voucher_id = clean_data($_POST['voucher_id']);

        $stock_code = clean_data($_POST['stock_code']);

        $cat_id = clean_data($_POST['cat_id']);

        /*****************START MYSQL VARIABLES**************/
        $rate_decimals = find_value('system','rate_decimals','');

        $comp_name = '';
        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        } else {
            $comp_name = find_value('system', 'comp_name', "");

        }
        /*************END FINDE COMPANY NAME*****************/

        $and =" and (if(substring(v.voucher_id,1,2) in('FG','PL'),v.db_qty,v.cr_qty)<>0)";

        $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

        if ($comp_id != "All") {

            $and .= " and v.comp_id = '$comp_id'";

        } else {
            $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";
        }


        if ($rpt_type != "All") {
            $and .= " and substring(v.voucher_id,1,2) = '$rpt_type'";
        }


        if ($cat_id != "All") {
            $and .= " and (i.cat_id = '$cat_id')";
        }

        if ($stock_code != "All") {
            $and .= " and (i.stock_code = '$stock_code')";
        }

        $report_name = '';
        if ($rpt_type == "All") {

            $report_name = "Daily Report";

        }

        if ($rpt_type == "SL") {

            $report_name = "Sale Report";

        }

        if ($rpt_type == "SR") {

            $report_name = "Sale Recovery";

        }

        if ($rpt_type == "RT") {

            $report_name = "Sale Retrun";

        }

        if ($rpt_type == "PL") {

            $report_name = "Purchase Report";

        }


        if ($rpt_type == "ST") {

            $report_name = "Stock Report";

        }

        if ($rpt_type == "FG") {

            $report_name = "Production Report";

        }

        if ($rpt_type == "CO") {

            $report_name = "Consumption Report";

        }



        /*****************END MYSQL VARIABLES**************/


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/

            $msqlquery = "SELECT
                            v.comp_id,
                            v.voucher_id,
                            v.voucher_date,
                            v.party_name,
                            v.stock_code,
                            v.stock_name,
                            v.rate,
                            if(substring(v.voucher_id,1,2) in('FG','PL'),v.db_qty,v.cr_qty) qty,
                            if(substring(v.voucher_id,1,2) in('FG','PL'),v.db_amt,v.cr_amt) amt,
                            i.unit_name
                            
                            FROM v_stk v
                            LEFT JOIN v_item i on v.stock_code=i.stock_code
                                
                                
                                WHERE
                                    1 = 1 $and order by v.voucher_date, v.voucher_id";



            //echo $msqlquery;
try{
            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }






        ?>


        <h1 style="text-align: center; font-size: 35px; font-weight: bold;"><?php echo $comp_name ; ?></h1>
        <h1 style="text-align: center; font-size: 35px; font-weight: bold;"><?php echo $report_name; ?></h1>

        <a href="pdf_report_sale?from_date=<?php echo $new_from_date; ?>&to_date=<?php echo $new_to_date;?>&comp_id=<?php echo $comp_id;?>&stock_code=<?php echo $stock_code;?>&rpt_type=<?php echo $rpt_type;?>"
           target="_blank" style="text-decoration:none; color:#FFF" class="btn btn-success" data-toggle="tooltip"
           data-placement="top" title="PDF">PDF</a>

        <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <tr>
                <th>Sr</th>
                <th>VOUCHER DATE</th>
                <th>VOUCHER ID</th>
                <th>STOCK CODE</th>
                <th>STOCK NAME</th>
                <th>UNIT</th>
                <th>PARTICULARS</th>
                <td align=right><b>QTY</td>
                <td align=right><b>RATE</td>
                <td align=right><b>AMOUNT</td>

            </tr>
            <?php





            $serno = 0;
            $g_q_tot = '';
            $g_amt = '';
            $g_disc_amt = '';
            $g_profit = '';

            while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
                $serno = $serno + 1;

                    $g_q_tot += $report_row['qty'];

                    $g_disc_amt += $report_row['disc_amt'];
                    $g_amt += $report_row['amt'];
                    $g_profit += $report_row['profit'];


                ?>

                <tr>
                    <td><?php echo($serno); ?></td>
                    <td><?php echo format_date($report_row['voucher_date']); ?></td>
                    <td><?php echo $report_row['voucher_id']; ?></td>
                    <td><?php echo ($report_row['stock_code']); ?></td>
                    <td><?php echo ($report_row['stock_name']); ?></td>
                    <td><?php echo ($report_row['unit_name']); ?></td>
                    <td><?php echo ($report_row['party_name']); ?></td>
                    <td align=right><?php echo format_number($report_row['qty'],3); ?></td>
                    <td align=right><?php echo format_number($report_row['rate'], $rate_decimals); ?></td>
                    <td align=right><?php echo format_number($report_row['amt'],0); ?></td>

                </tr>
                <?php

            }
            ?>
            <tr>


                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td align="right"><b>Total</b></td>
                <td align=right><b><?php echo format_number($g_q_tot,3); ?></b></td>

                <td></td>
                <td align=right><b><?php echo format_number($g_amt,0); ?></b></td>
            </tr>



        </table>
        </div>


        <?php
    }



}



?>