<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

$comp_id = $_SESSION["comp_id"];


if (!empty($_POST['type'])) {
    $type = $_POST['type'];
    $name = $_POST['name_startsWith'];

    try
    {
        $query =  "SELECT
	v.comp_id,
	v.stock_code,
	sum(v.ig_qty - v.rt_qty- v.sl_qty - v.ad_rt_qty + v.audit_qty - exchange_qty - sl_rt_qty) o_qty,
	i.description,

	i.o_rate,
	t.discount,
	s.size,
	ct.description cat_name,
	cl.description collection
FROM
	v_outlet_ledger v
LEFT JOIN item i ON v.stock_code = i.stock_code
LEFT JOIN code_cat ct ON ct.cat_id = i.cat_id
LEFT JOIN code_collection cl ON cl.col_id = i.col_id
LEFT JOIN discount t ON t.stock_code = v.stock_code and t.comp_id = v.comp_id
LEFT JOIN size s ON s.size_id = i.size
where  UPPER(v.$type) LIKE '%" . strtoupper($name) . "%'
		AND v.comp_id = '$comp_id'
		
		GROUP BY
	v.comp_id,
	v.stock_code";

        $result = $dbcon->prepare($query);
        $result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }


    $data = array();
    while($row = $result->fetch(PDO::FETCH_OBJ))
    {
        $name = $row->stock_code .
            '|' . $row->cat_name . '/' . $row->collection . '/' . $row->size .
            '|' . number_format($row->o_qty) .
            '|' . round($row->o_rate) .
            '|' . number_format($row->discount);

        array_push($data, $name);
    }
    echo json_encode($data);
    exit;
}





?>