<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}

$comp_id = clean_data($_SESSION["comp_id"]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $row->acct_name;?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="images/icons/favicon.ico">
    <link rel="apple-touch-icon" href="images/icons/favicon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.png">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.png">
    <!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/jquery-tablesorter/themes/blue/style-custom.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-news-ticker/jquery.news-ticker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style3/pink-blue.css" id="theme-change" class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
</head>
<body>

<div>

    <a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP-->



    <!--BEGIN TOPBAR-->
    <?php include ('header.php'); ?>
    <!--END TOPBAR-->


    <div id="wrapper">
        <!--BEGIN SIDEBAR MENU-->
        <?php include('left.php'); ?>
        <!--END SIDEBAR MENU-->


        <!--BEGIN PAGE WRAPPER-->
        <div id="page-wrapper">
            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
                <div class="page-header pull-left">
                    <div class="page-title">SHOW COLORS</div>
                </div>
                <ol class="breadcrumb page-breadcrumb pull-right">
                    <li><i class="fa fa-home"></i>&nbsp;<a href="index">Home</a>&nbsp;&nbsp;<i
                                class="fa fa-angle-right"></i>&nbsp;&nbsp;
                    </li>
                    <li class="active">Show Color</li>
                </ol>
                <div class="clearfix"></div>
            </div>
            <!--END TITLE & BREADCRUMB PAGE-->


            <!--BEGIN CONTENT-->
            <div class="page-content">
                <!-----------------START ADD NEW VOUCHER------------->
                <button type="button" data-target="#modal-default" data-toggle="modal" class="btn btn-blue pull-right">Add</button>
                <!-----------------END ADD NEW VOUCHER------------->

                <table class="table table-hover table-striped table-bordered table-advanced tablesorter tb-sticky-header">
                    <thead>
                    <tr>
                        <th>COLOR ID</th>
                        <th>COLOR NAME</th>
                        <th>ACTION</th>
                    </tr>
                    </thead>

                    <tbody>

                    <?php
                    try
                    {
                        $v_query =  "SELECT c.color_id, c.description FROM color c order by c.color_id";
                        $v_result = $dbcon->prepare($v_query);
                        $v_result->execute(array());
                    }
                    catch(PDOException $e)
                    {
                        echo "Error : ". $e->getMessage();
                    }


                    while($v_row = $v_result->fetch(PDO::FETCH_OBJ))
                    {
                        ?>
                        <tr>
                            <td><?php echo ($v_row->color_id);?></td>
                            <td><?php echo ($v_row->description);?></td>
                            <td>
                                <a href="#!" class="text-muted" onclick="GetDetails('<?php echo $v_row->color_id;?>')"><i class="glyphicon glyphicon-edit"></i></a>

                                <a  class="text-muted delete_product" data-id="<?php echo $v_row->color_id; ?>" href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="glyphicon glyphicon-trash"></i></a>
                            </td>

                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>


                <!-------------------------START ADD MODEL--------------->
                <div id="modal-default" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                                <h4 id="modal-default-label" class="modal-title">ADD NEW</h4></div>
                            <div class="modal-body">
                                <div class="form-body pal">

                                    <div class="form-group"><label for="inputUsername" class="control-label">Color ID: <span class='require'>*</span></label>
                                        <div class="input-icon"><i class="fa fa-plus"></i><input id="color_id" name="color_id"  type="text" placeholder="Color ID" class="form-control" maxlength="2"/></div>
                                    </div>
                                    <span id="result"></span>


                                    <div class="form-group"><label for="inputEmail" class="control-label">Color Name <span class='require'>*</span></label>
                                        <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="color_name" id="color_name" placeholder="Coloe Name" class="form-control"/></div>
                                    </div>
                                    <span id="result1"></span>

                                </div>
                            </div>


                            <div class="modal-footer">
                                <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                                <button type="button" class="btn btn-primary" onClick="item_add()">Save changes</button>
                            </div>


                        </div>
                    </div>
                </div>
                    <!-------------------------END ADD MODEL--------------->







                <!-------------------------START EDIT MODEL--------------->
                <div id="update_user_modal" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade"  >
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                                <h4 id="modal-default-label" class="modal-title">UPDATE</h4></div>
                            <div class="modal-body">
                                <div class="form-body pal">



                                    <div class="form-group"><label for="inputUsername" class="control-label">Color ID: <span class='require'>*</span></label>
                                        <div class="input-icon"><i class="fa fa-plus"></i><input id="update_color_id" name="color_id"  type="text" placeholder="Color ID" class="form-control" maxlength="2"/></div>
                                    </div>
                                    <span id="result"></span>


                                    <div class="form-group"><label for="inputEmail" class="control-label">Color Name <span class='require'>*</span></label>
                                        <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="color_name" id="update_color_name" placeholder="Coloe Name" class="form-control"/></div>
                                    </div>
                                    <span id="result1"></span>


                                </div>
                            </div>


                            <div class="modal-footer">
                                <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                                <button type="button" class="btn btn-orange" onClick="UpdateDetails()">Save changes</button>
                                <input type="hidden" id="hidden_user_id">
                            </div>
                        </div>
                    </div>
                </div>
                <!---------------END FIRST LEVEL ACCOUNT---------------->


            </div>
        </div>
    </div>

    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/jquery-ui.js"></script>
    <!--loading bootstrap js-->
    <script src="vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
    <script src="js/html5shiv.js"></script>
    <script src="js/respond.min.js"></script>
    <script src="vendors/metisMenu/jquery.metisMenu.js"></script>
    <script src="vendors/slimScroll/jquery.slimscroll.js"></script>
    <script src="vendors/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendors/iCheck/icheck.min.js"></script>
    <script src="vendors/iCheck/custom.min.js"></script>
    <script src="vendors/jquery-news-ticker/jquery.news-ticker.js"></script>
    <script src="js/jquery.menu.js"></script>
    <script src="vendors/jquery-pace/pace.min.js"></script>
    <script src="vendors/holder/holder.js"></script>
    <script src="vendors/responsive-tabs/responsive-tabs.js"></script>
    <!--LOADING SCRIPTS FOR PAGE-->
    <script src="vendors/jquery-tablesorter/jquery.tablesorter.js"></script>
    <script src="js/table-advanced.js"></script>
    <!--CORE JAVASCRIPT-->
    <script src="js/main.js"></script>
        <!-- BOOT BOX ALERT -->
        <script src="js/bootbox.min.js" type="text/javascript"></script>


        <!----------------------------START JAVA SCRIPT---------------------------->
        <script type="text/javascript">

            /*******************START LIVE CHECK COLOR ID AVAILABLE*****************/
            $("#color_id").keyup(function () {
                var color_id = $(this).val();
                if (color_id.length > 1) {
                    $("#result").html('checking...');


                    var dataString = 'color_id=' + color_id + '&action=colorID';

                    $.ajax({
                        type: 'POST',
                        url: 'ajax/live_check_color.php',
                        data: dataString,
                        success: function (data) {
                            $("#result").html(data);
                        }
                    });
                    return false;
                }
                else {
                    $("#result").html('');
                }
            });
            /*******************END LIVE CHECK COLOR ID AVAILABLE*****************/



            /*******************START LIVE CHECK COLOR NAME AVAILABLE*****************/
            $("#color_name").keyup(function () {
                var color_name = $(this).val();
                if (color_name.length > 1) {
                    $("#result1").html('checking...');

                    var dataString = 'color_name=' + color_name + '&action=colorName';

                    $.ajax({
                        type: 'POST',
                        url: 'ajax/live_check_color.php',
                        data: dataString,
                        success: function (data) {
                            $("#result1").html(data);
                        }
                    });
                    return false;
                }
                else {
                    $("#result1").html('');
                }
            });
            /*******************START LIVE CHECK COLOR NAME AVAILABLE*****************/



            /*******************START ADD NEW ENTERY*****************/
            function item_add() {
                var color_id = $('#color_id').val();
                var color_name = $('#color_name').val();
                var action = 'add_color';


                if (color_id == "") {
                    alert("Please Enter The Color ID");
                    $('#color_id').focus();
                }
                else if (color_name == "") {
                    alert("Please Enter The Color Name");
                    $('#color_name').focus();
                }


                else {
                    var dataString = 'color_id=' + color_id + '&color_name=' + color_name + '&action=' + action ;

                    $.ajax({
                        type: "POST",
                        url: "process/master_process.php",
                        data: dataString,
                        success: function () {
                            //alert(result);
                            window.location = "show_color.php"

                        }
                    });

                }
            }
            /*******************END ADD NEW ENTERY*****************/











            /*******************START GETDETAIL EDIT ID*****************/
            function GetDetails(id) {
                // Add User ID to the hidden field for furture usage
                $("#hidden_user_id").val(id);

                var action = 'edit_color';


                var dataString = 'id=' + id +
                    '&action=' + action;

                $.ajax({
                    type: "POST",
                    url: "ajax/get_details.php",
                    data: dataString,
                    success: function (data, status) {
                        // PARSE json data
                        var user = JSON.parse(data);
                        // Assing existing values to the modal popup fields
                        $("#update_color_id").val(user.color_id);
                        $("#update_color_name").val(user.description);
                    }
                });

                // Open modal popup
                $("#update_user_modal").modal("show");
            }
            /*******************END GETDETAIL EDIT ID*****************/


            /*******************START UPDATE DETAIL EDIT ID*****************/
            function UpdateDetails() {

                var color_id = $('#update_color_id').val();
                var color_name = $('#update_color_name').val();
                // get hidden field value
                var id = $("#hidden_user_id").val();

                var action = 'edit_color';


                // Update the details by requesting to the server using ajax
                var dataString = 'id=' + id +
                    '&color_id=' + color_id +
                    '&color_name=' + color_name +
                    '&action=' + action;
                $.ajax({
                    type: "POST",
                    url: "ajax/update_details.php",
                    data: dataString,
                    success: function (data, status) {
                        // hide modal popup
                        $("#update_user_modal").modal("hide");

                        window.location = "show_color.php"

                    }
                });

            }
            /*******************END UPDATE DETAIL EDIT ID*****************/




            /*******************START DELETE ITEM*****************/
            $(document).ready(function () {
                $('.delete_product').click(function (e) {
                    e.preventDefault();
                    var pid = $(this).attr('data-id');
                    var parent = $(this).parent("td").parent("tr");
                    bootbox.dialog({
                        message: "Are you sure you want to Delete ?",
                        title: "<i class='glyphicon glyphicon-trash'></i> Delete !",
                        buttons: {
                            success: {
                                label: "No",
                                className: "btn-success",
                                callback: function () {
                                    $('.bootbox').modal('hide');
                                }
                            },
                            danger: {
                                label: "Delete!",
                                className: "btn-danger",
                                callback: function () {
                                    $.post('del_master.php', {'color_delete': pid})
                                        .done(function (response) {
                                            bootbox.alert(response);
                                            parent.fadeOut('slow');
                                        })
                                        .fail(function () {
                                            bootbox.alert('Something Went Wrog ....');
                                        })

                                    //window.location = "show_item_description.php"

                                }
                            }
                        }
                    });


                });

            });
            /*******************END DELETE ITEM*****************/




        </script>
        <!----------------------------END JAVA SCRIPT---------------------------->












</body>
</html>