<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <link rel="shortcut icon" href="dist/img/favicon.ico">
    <title><?php echo $row->acct_name;?></title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.4 -->
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- FontAwesome 4.3.0 -->
    <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <!-- Ionicons 2.0.0 -->
    <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
    <!-- iCheck -->
    <link href="plugins/iCheck/flat/blue.css" rel="stylesheet" type="text/css" />
    <!-- Morris chart -->
    <link href="plugins/morris/morris.css" rel="stylesheet" type="text/css" />
    <!-- jvectormap -->
    <link href="plugins/jvectormap/jquery-jvectormap-1.2.2.css" rel="stylesheet" type="text/css" />
    <!-- Date Picker -->
    <link href="plugins/datepicker/datepicker3.css" rel="stylesheet" type="text/css" />
    <!-- Daterange picker -->
    <link href="plugins/daterangepicker/daterangepicker-bs3.css" rel="stylesheet" type="text/css" />
    <!-- bootstrap wysihtml5 - text editor -->
    <link href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css" rel="stylesheet" type="text/css" />
    <!-- Data table -->
    <link href="plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
    <link href="plugins/datatables/buttons.bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="plugins/datatables/jquery.dataTables_themeroller.css" rel="stylesheet" type="text/css" />
    <!-- Jquery UI -->
    <link href="plugins/jQueryUI/jquery-ui.css" rel="stylesheet" type="text/css" />
    <!-- custom css -->
    <link href="dist/css/custom.css" rel="stylesheet" type="text/css" />
    <!-- Editable -->
    <link href="plugins/bootstrap-editable/css/bootstrap-editable.css" rel="stylesheet" type="text/css" />
    <!-- Select Search -->
    <link href="plugins/select_search/select2.css" rel="stylesheet" type="text/css" />



    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="skin-purple sidebar-mini">
<div class="wrapper">

    <header class="main-header">
        <!-- Start Include header file -->
        <?php include("header.php");?>
        <!-- End Include header file -->
    </header>
    <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
            <?php include("left.php");?>
        </section>
        <!-- /.sidebar -->
    </aside>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>SHOW NEWS</h1>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row">
                <div class="col-lg-12">
                    <a href="new_news">
                        <button class="btn btn-success">New News <span class="glyphicon glyphicon-plus"></span></button>
                    </a>
                </div>
            </div>

            <br clear="all">


            <table id="datatable_color" class="table table-bordered">
                <thead style="background-color: black; color: gold;">
                <tr>
                    <th>SR</th>
                    <th>NEWS</th>
                    <th>POST DATE</th>
                    <th>EXPIRY DATE</th>
                    <th>EDIT</th>
                    <th>DELETE</th>
                </tr>
                </thead>
                <tbody>
                <?php
                try {
                    $v_query = "SELECT a.id,  a.announcement, a.post_date, a.expiry_date FROM announcement a order by a.post_date desc";
                    $v_result = $dbcon->prepare($v_query);
                    $v_result->execute(array());
                } catch (PDOException $e) {
                    echo "Error : " . $e->getMessage();
                }

                $sr = "";
                while ($v_row = $v_result->fetch(PDO::FETCH_OBJ)) {
                    $sr += 1;
                    ?>
                    <tr>
                        <td><?php echo($sr); ?></td>
                        <td><?php echo($v_row->announcement); ?></td>
                        <td><?php echo $v_row->post_date; ?></td>
                        <td><?php echo $v_row->expiry_date; ?></td>

                        <td>
                            <a  href="edit_news?edit_id=<?php echo $v_row->id;?>"><i class="glyphicon glyphicon-pencil"></i></a>
                        </td>


                        <td>
                            <a class="delete_product" data-id="<?php echo $v_row->id; ?>" href="javascript:void(0)">
                                <i class="glyphicon glyphicon-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>


        </section><!-- /.content -->
    </div><!-- /.content-wrapper -->
    <footer class="main-footer">
        <?php include("footer.php");?>
    </footer>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <?php //include("right_sidebar.php");?>
    </aside><!-- /.control-sidebar -->
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class='control-sidebar-bg'></div>
</div><!-- ./wrapper -->

<!-- jQuery 2.1.4 -->
<script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
<!-- jQuery UI 1.11.2 -->
<script src="plugins/jQueryUI/jquery-ui-1.10.3.min.js" type="text/javascript"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->

<!-- Bootstrap 3.3.2 JS -->
<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<!-- Morris.js charts -->
<script src="plugins/raphael-min.js"></script>
<script src="plugins/morris/morris.min.js" type="text/javascript"></script>
<!-- Sparkline -->
<script src="plugins/sparkline/jquery.sparkline.min.js" type="text/javascript"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js" type="text/javascript"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js" type="text/javascript"></script>
<!-- jQuery Knob Chart -->
<script src="plugins/knob/jquery.knob.js" type="text/javascript"></script>
<!-- daterangepicker -->
<script src="plugins/moment.js" type="text/javascript"></script>
<script src="plugins/daterangepicker/daterangepicker.js" type="text/javascript"></script>
<!-- datepicker -->
<script src="plugins/datepicker/bootstrap-datepicker.js" type="text/javascript"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js" type="text/javascript"></script>
<!-- Slimscroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<!-- FastClick -->
<script src='plugins/fastclick/fastclick.min.js'></script>
<!-- News Slide -->
<script src="plugins/jquery.easy-ticker.js" type="text/javascript"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js" type="text/javascript"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js" type="text/javascript"></script>
<!-- DataTable -->
<script src="plugins/datatables/jquery.dataTables.js" type="text/javascript"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
<script src="plugins/datatables/dataTables.buttons.min.js" type="text/javascript"></script>
<script src="plugins/datatables/buttons.bootstrap.min.js" type="text/javascript"></script>
<script src="plugins/datatables/jszip.min.js" type="text/javascript"></script>
<script src="plugins/datatables/pdfmake.min.js" type="text/javascript"></script>
<script src="plugins/datatables/vfs_fonts.js" type="text/javascript"></script>
<script src="plugins/datatables/buttons.html5.min.js" type="text/javascript"></script>
<script src="plugins/datatables/buttons.print.min.js" type="text/javascript"></script>
<script src="plugins/datatables/buttons.colVis.min.js" type="text/javascript"></script>
<!-- Editable -->
<script type="text/javascript" src="plugins/bootstrap-editable/js/bootstrap-editable.min.js"></script>
<!-- Select Search -->
<script type="text/javascript" src="plugins/select_search/select2.js"></script>
<!-- custom JS -->
<script src="dist/js/custom.js" type="text/javascript"></script>
<!-- custom JS -->
<script src="dist/js/bootbox.min.js" type="text/javascript"></script>




<script>
    $(document).ready(function () {

        $('.delete_product').click(function (e) {

            e.preventDefault();

            var pid = $(this).attr('data-id');
            var parent = $(this).parent("td").parent("tr");

            bootbox.dialog({
                message: "Are you sure you want to Delete ?",
                title: "<i class='glyphicon glyphicon-trash'></i> Delete !",
                buttons: {
                    success: {
                        label: "No",
                        className: "btn-success",
                        callback: function () {
                            $('.bootbox').modal('hide');
                        }
                    },
                    danger: {
                        label: "Delete!",
                        className: "btn-danger",
                        callback: function () {

                            /*

                             using $.ajax();

                             $.ajax({

                             type: 'POST',
                             url: 'delete.php',
                             data: 'delete='+pid

                             })
                             .done(function(response){

                             bootbox.alert(response);
                             parent.fadeOut('slow');

                             })
                             .fail(function(){

                             bootbox.alert('Something Went Wrog ....');

                             })
                             */


                            $.post('delete_sp.php', {'news_delete': pid})
                                .done(function (response) {
                                    bootbox.alert(response);
                                    parent.fadeOut('slow');
                                })
                                .fail(function () {
                                    bootbox.alert('Something Went Wrog ....');
                                })

                            window.location = "show_news"

                        }
                    }
                }
            });


        });

    });


    $('.news').editable();
    $('.p_date').editable();
    $('.exp_date').editable();


</script>

</body>
</html>