<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}
//variables
$emp_id = $_SESSION['VALID_USER_NAME'];

$menu_id = $_GET['menu_id'];
$menu_cmd = find_value("menu", 'menu_cmd', " and menu_id = '$menu_id'");
$menu_detail = find_value("menu", 'menu_detail', " and menu_id = '$menu_id'");
$menu_link = find_value("menu", 'menu_link', " and menu_id = '$menu_id'") . '?menu_id=' . $menu_id;
$table = find_value("menu", 'menu_table', " and menu_id = '$menu_id'");

$title = find_value("(select concat(ifnull(m1.menu_name,''), ' ', m.menu_name) menu_name
                      from menu m left join menu m1 on m1.menu_id=substr(m.menu_id,1,instr('$menu_id','.')-1)
                      where m.menu_id='$menu_id') v", 'menu_name', "");

$add = clean_data($_GET['add']);
$_SESSION['add'] = $add;

$comp_id = clean_data($_GET["comp_id"]);
$year_id = clean_data($_GET["year_id"]);
$v_id = clean_data($_GET["v_id"]);

if($add == "Y")
{
    $lineitem = 0;
    $acct_id = '';
    $voucher_date = date('d-m-Y');
    $comp_id = clean_data($_SESSION["comp_id"]);

    //MAXIMUM VOUCHER ID CHK QUERY
    try
    {
        $Maxquery =  "SELECT max(v.v_id) + 1 v_id FROM voucher_id v
		WHERE comp_id = ?";
        $max_query = $dbcon->prepare($Maxquery);
        $max_query->execute(array($comp_id));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $row_max = $max_query->fetch(PDO::FETCH_OBJ);
    $v_id = $row_max->v_id;
    if(empty($v_id))
    {
        $v_id = 1;
    }


//MAXIMUM VOUCHER ID INSERT NEW ID QUERY
    try
    {
        $InserMaxquery =  "INSERT INTO voucher_id (v_id, comp_id) VALUES (?, ? )";
        $insert_max = $dbcon->prepare($InserMaxquery);
        $insert_max->execute(array($v_id, $comp_id ));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $v_id =  $v_id;

    $customer_name = '';
    $customer_phone = '';

    //MAXIMUM INVOICE ID CHK QUERY
    try
    {
        $Maxquery_invoice =  "SELECT LPAD(IFNULL(max(substr(v.bill_no,-4)),0)+1,4,'0') v_id FROM sl_quote v
		WHERE v.comp_id = ? ";
        $max_query_inv = $dbcon->prepare($Maxquery_invoice);
        $max_query_inv->execute(array($comp_id ));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }
    $row_max_invoice = $max_query_inv->fetch(PDO::FETCH_OBJ);
    $invoiceNo = $row_max_invoice->v_id;

    $v_date = date('d-m-Y');

    $bill_type = '';
    $sp = "";
    $invoice_no = "";
    $discp_m = "";
    $disc_amt_m = "";
    $net_amt = "";
    $net_payable = "";
    $adv_amt = "";
    $dc_amt = "";
}
else //EDIT
{

    try
    {
        $edit_query =  "SELECT * FROM sl_quote m  WHERE m.voucher_id = ? AND m.comp_id = ? AND year_id = ?";
        $edit_result = $dbcon->prepare($edit_query);
        $edit_result->execute(array($v_id, $comp_id, $year_id));
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $rowm = $edit_result->fetch(PDO::FETCH_OBJ);


    $voucher_date = $rowm->voucher_date;
    $change_date =date_create($voucher_date);
    $v_date = date_format($change_date,'d-m-Y');
    $acct_id = $rowm->acct_id;
    $customer_name = $rowm->customer_name;
    $customer_phone = $rowm->customer_phone;
    $bill_type = $rowm->bill_type;
    $invoice_no = $rowm->bill_no;
    $sp = $rowm->sp_id;
    $discount_voucher_id = $rowm->discount_voucher_no;
    $discp_m = $rowm->discp;
    $disc_amt_m = $rowm->disc_amt;
    $net_amt = $rowm->net_amt;
    $net_payable = $rowm->net_payable;
    $adv_amt = $rowm->adv_amt;
    $dc_amt = $rowm->dc_amt;
    $cont_id = $rowm->cont_id;
}

$sale_form = find_value("system", "sale_form", '');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $title;?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="Thu, 19 Nov 1900 08:52:00 GMT">
    <link rel="shortcut icon" href="images/icons/favicon.html">
    <link rel="apple-touch-icon" href="images/icons/favicon-2.html">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.html">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.html"><!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet"
          href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet"
          href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/select2/select2-madmin.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-select/bootstrap-select.min.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-notific8/jquery.notific8.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-daterangepicker/daterangepicker-bs3.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap-datepicker/css/datepicker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" class="default-style">
    <link type="text/css" rel="stylesheet" href="css/themes/style1/orange-blue.css" id="theme-change"
          class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sidebar-icons">
<div>

    <a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP--><!--BEGIN TOPBAR-->



    <!--BEGIN TOPBAR-->
    <?php include ('header.php'); ?>
    <!--END TOPBAR-->




    <div id="wrapper"><!--BEGIN SIDEBAR MENU-->
        <!--BEGIN SIDEBAR MENU-->
        <?php include ('left.php'); ?>
        <!--END SIDEBAR MENU-->

        <!--BEGIN PAGE WRAPPER-->
        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->
            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
                <div class="page-header pull-left">
                    <div class="page-title"><?php echo $title;?></div>
                </div>
                <ol class="breadcrumb page-breadcrumb pull-right">
                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>
                    <li><a href="<?php echo $menu_link;?>"><?php echo $title;?> Showcase</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>
                    <li class="active"><?php echo $title;?></li>
                </ol>
                <div class="clearfix"></div>
            </div>
            <!--END TITLE & BREADCRUMB PAGE-->



            <!--BEGIN CONTENT-->
            <div class="page-content">

                <form class="form-horizontal"  name="sale_invoice"  id="sale_invoice">

                    <div class='row'>
                        <div class='col-xl-12 col-sm-3 col-md-3 col-lg-3'>
                            <button class="btn btn-danger delete_sale" type="button">- Delete</button>
                            <button class="btn btn-success addmore_sale" type="button">+ Add More</button>
                            <input type="hidden" name="table" id="table" value="<?php echo $table?>"/>
                            <input type="button" class="btn btn-primary" name="savedata" id="savedata" value="Save" onClick="sale_invoice_add()"/>
                        </div>
                    </div>

                    <br clear="all">

                    <!------------------------START MASTER TABLE---------------------------->
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-block">
                                    <div class="table-responsive">

                                        <table class="table dt-responsive  table-bordered nowrap">
                                            <thead>
                                            <tr>

                                                <!-- VOUCHER ID -->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Voucher ID:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="voucher_id"id="voucher_id" placeholder="voucher id" value="<?php echo $v_id;?>" readonly style="width: 150px;">
                                                </td>

                                                <!-- DATE -->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Date:</label>
                                                </td>
                                                <td style="width: 150px;">
                                                    <input type="text" class="form-control" name="v_date" id="v_date" placeholder="Date" readonly value="<?php echo $v_date;?>" style="width: 150px;">
                                                </td>



                                                <!-- SALE TYPE-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Customer</label>
                                                </td>
                                                <?php
                                                try
                                                {
                                                    $p_query =  "SELECT p.acct_id, p.acct_name FROM v_party p  ORDER BY p.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array('0001',  '0019'));
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select   name="acct_id" id="acct_id" class=" form-control acct_id">




                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {

                                                            if ($acct_id == $p_row->acct_id)
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';

                                                            }
                                                            else
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td >
                                                    <div id="loaderc"></div>
                                                    <?php
                                                    if($add == 'Y')
                                                    {
                                                        ?>
                                                        <select   name="cont_id" id="cont_id" class="form-control acct_id">

                                                            <option value=""></option>

                                                        </select>
                                                    <?php }
                                                    else

                                                    {
                                                        ?>

                                                        <select   name="cont_id" id="cont_id" class="form-control">
                                                            <?php

                                                            try
                                                            {
                                                                $p_query =  "SELECT s.cont_id, concat(s.cont_id, ' - ', s.name) acct_name FROM nom_cont s WHERE acct_id = '$acct_id' ORDER BY s.acct_id ASC ";

                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            }
                                                            catch(PDOException $e)
                                                            {
                                                                echo "Error : ". $e->getMessage();
                                                            }
                                                            while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                            {

                                                                if ($cont_id == $p_row->cont_id)
                                                                {
                                                                    echo '<option  value="' . $p_row->cont_id . '"selected>' . $p_row->acct_name . '</option>';

                                                                }
                                                                else
                                                                {
                                                                    echo '<option  value="' . $p_row->cont_id . '">' . $p_row->acct_name . '</option>';
                                                                }

                                                            }
                                                            ?>
                                                        </select>

                                                    <?php } ?>


                                                </td>

                                            </tr>


                                            <tr>

                                                <!-- CUSTOMER NAME-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Customer Name:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="customer_name"id="customer_name" autocomplete="on" value="<?php echo $customer_name;?>" style="width: 150px;">
                                                </td>

                                                <!-- CUSTOMER PHONE NO-->
                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Customer Phone No:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"  name="customer_phone"id="customer_phone" value="<?php echo $customer_phone;?>" autocomplete="on" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" style="width: 150px;">
                                                </td>


                                                <th>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;"> Location</label>
                                                </th>
                                                <?php
                                                try
                                                {
                                                    $p_query =  "SELECT l.loc_id, l.loc_name FROM location l ORDER BY l.loc_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select   name="loc_id" id="loc_id" class=" form-control acct_id">




                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {

                                                            if ($acct_id == $p_row->loc_id)
                                                            {
                                                                echo '<option  value="' . $p_row->loc_id . '"selected>' . $p_row->loc_name . '</option>';

                                                            }
                                                            else
                                                            {
                                                                echo '<option  value="' . $p_row->loc_id . '">' . $p_row->loc_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                            </tr>

                                            <tr>

                                                <!-- INVOICE NO-->
                                                <th>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;"> Inv No:</label>
                                                </th>
                                                <td>
                                                    <input type="text" class="form-control"  name="inv_no"id="inv_no" autocomplete="on"  style="width: 150px;" value="<?php echo $invoice_no;?>">
                                                </td>




                                                <th>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Salesman</label>
                                                </th>
                                                <?php
                                                try
                                                {
                                                    $p_query =  "SELECT s.acct_id, s.acct_name FROM sp s  ORDER BY s.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select style="width:150px;"  name="sp_id" id="sp_id" class="acct_id">




                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {

                                                            if ($acct_id == $p_row->acct_id)
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';

                                                            }
                                                            else
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>

                                                <td>
                                                    <label  class="control-label pull-right" style="font-weight: bold; color: black;">Department (Cost Center)</label>
                                                </td>
                                                <?php
                                                try
                                                {
                                                    $p_query =  "SELECT s.acct_id, s.acct_name FROM v_cost_centre s ORDER BY s.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                }
                                                catch(PDOException $e)
                                                {
                                                    echo "Error : ". $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select  name="acct_id_cs_1" id="acct_id_cs_1" class=" form-control acct_id">




                                                        <?php
                                                        while($p_row = $p_result->fetch(PDO::FETCH_OBJ))
                                                        {

                                                            if ($acct_id_cs_1 == $p_row->acct_id)
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';

                                                            }
                                                            else
                                                            {
                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>





                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!------------------------END MASTER TABLE---------------------------->


                    <!------------------------START DETAIL TABLE---------------------------->

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-block">


                                    <table class="table table-bordered table-responsive table-hover addrow_sale" id="addrow">
                                        <thead >
                                        <tr>
                                            <th width="2%"><input id="check_all" class="formcontrol" type="checkbox"/></th>
                                            <th width="8%" style="text-align: center;">SR</th>
                                            <th width="12%" style="text-align: center;">STOCK CODE</th>
                                            <th width="22%" style="text-align: center;">ITEM NAME</th>
                                            <?php
                                            if($sale_form == 'mli_sale_invoice')
                                            {
                                            ?>
                                            <th   style="text-align: center; width: 10%">COLOR</th>
                                            <th  style="text-align: center;  width: 10%">SIZE</th>
                                            <?php } ?>

                                            <th width="5%" style="text-align: center;">PARTICULARS</th>
                                            <th width="10%" style="text-align: center;">QTY</th>
                                            <th width="10%" style="text-align: center;">RATE</th>
                                            <th width="10%" style="text-align: center;">DISC %</th>
                                            <th width="15%" style="text-align: center;">DISC AMOUNT</th>
                                            <th width="10%" style="text-align: center;">AMOUNT</th>
                                        </tr>

                                        </thead>




                                        <?php

                                        try
                                        {
                                            $edit_query =  "SELECT
	d.*,
	 i.size,
    i.description,
	r.description color_name,
	r.color_id,
	s.size,
	s.size_id

FROM
	sl_quotedet d
LEFT JOIN item i ON d.stock_code = i.stock_code
LEFT JOIN color r ON d.color_id = r.color_id
	LEFT JOIN size s ON d.size_id = s.size_id

   WHERE d.voucher_id = ? and d.comp_id = ? and year_id = ? 
  ORDER BY d.lineitem/1";
                                            $resultd = $dbcon->prepare($edit_query);
                                            $resultd->execute(array($v_id, $comp_id, $year_id ));
                                        }
                                        catch(PDOException $e)
                                        {
                                            echo "Error : ". $e->getMessage();
                                        }

                                        $cnt = 0;
                                        $itemtot = '';
                                        $tot_qty = '';
                                        while($rowd = $resultd->fetch(PDO::FETCH_OBJ))
                                        {
                                            $lineitem = $rowd->lineitem;
                                            $cnt = $lineitem;
                                            $itemtot += $rowd->itemtot;

                                            $tot_qty += $rowd->qty;


                                            ?>

                                            <!----------------------------------------------------------------------------------------------------------------------
                                            ------------------------------------------------------------------------------------------------------------------------
                                            ----------------------------------------------------SALE INVOICE DETAIL EDIT FORM---------------------------------------
                                            ------------------------------------------------------------------------------------------------------------------------
                                            ----------------------------------------------------------------------------------------------------------------------->
                                            <tr class="addrow_sale">
                                                <td><input class="case" type="checkbox"/></td>
                                                <td> <input type="text" class="form-control" name="lineitem[]" size="1" value="<?php echo $lineitem;?>" readonly /></td>


                                                <!-- STOCK CODE -->
                                                <td style="width: 130px;">
                                                    <input type="text" data-type="stock_code" name="stock_code[]" class="form-control  autocomplete_txt stock_code" id="stockcode_<?php echo $cnt;?>" value="<?php echo $rowd->stock_code;?>" maxlength="11">
                                                </td>

                                                <!-- DESCRIPTION -->
                                                <td>
                                                    <input type="text" data-type="description" name="description[]"  class="form-control description autocomplete_txt " id="description_<?php echo $cnt;?>" autocomplete="off"  size="30"  value="<?php echo $rowd->description ;?>">
                                                </td>


                                                <!-- PARTICULARS -->

                                                <td>
                                                    <input type="text" class="form-control particulars" name="particulars[]"  id="particulars_<?php echo $cnt;?>" size="50"  value="<?php echo $rowd->particulars;?>" />
                                                </td>
                                                <input type="hidden" class="form-control available_qty " name="available_qty[]" id="availableqty_<?php echo $cnt;?>" value="<?php echo $o_qty;?>" />

                                                <!-- QUANTITY -->
                                                <td>
                                                    <input type="number" class="form-control qty changesNo qty grand_tot_qty" name="qty[]" id="qty_<?php echo $cnt;?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" value="<?php echo ($rowd->qty);?>" />
                                                </td>

                                                <!-- RATE -->
                                                <td>
                                                    <input type="text" class="form-control  changesNo orate" name="rate[]" id="orate_<?php echo $cnt;?>"  value="<?php echo ($rowd->rate);?>"/>
                                                </td>

                                                <!-- DISCOUNT -->
                                                <td>
                                                    <input type="text" class="form-control rate changesNo discp" name="discp[]" id="discp_<?php echo $cnt;?>" value="<?php echo ($rowd->discp);?>" />
                                                </td>
                                                <!-- DISCOUNT VALUE -->
                                                <td>
                                                    <input type="text" class="form-control  changesNo disc_amt" name="disc_amt[]" id="discamt_<?php echo $cnt;?>" value="<?php echo ($rowd->disc_amt);?>" readonly/>
                                                </td>

                                                <!-- TOTAL AMOUNT -->
                                                <td>
                                                    <input type="text" class="form-control itemtot totalLinePrice" name="itemtot[]" id="itemtot_<?php echo $cnt;?>" readonly value="<?php echo ($rowd->itemtot);?>"/>
                                                </td>
                                            </tr>

                                            <?php
                                        }
                                        $_SESSION['cnt'] = $cnt;
                                        ?>



                                        <!----------------------------------------------------------------------------------------------------------------------
                                        ------------------------------------------------------------------------------------------------------------------------
                                        ----------------------------------------------------SALE INVOICE DETAIL ADD FORM---------------------------------------
                                        ------------------------------------------------------------------------------------------------------------------------
                                        ----------------------------------------------------------------------------------------------------------------------->


                                        <?php  $numberofrow = 5; ?>  <?php for($counter = 1;$counter<=$numberofrow;$counter++){ ?>

                                            <tr class="addrow_sale">
                                                <!-- CHECKBOX FOR ADD NEW FORM FIELD -->
                                                <td>
                                                    <input class="case" type="checkbox" id="disable_<?php echo $counter;?>"/>
                                                </td>

                                                <!-- LINEITEM -->
                                                <td style="width: 60px;">
                                                    <?php $lineitem += 1;?>
                                                    <input type="text" class="form-control " name="lineitem[]<?php echo $counter;?>"  id="lineitem_1" value="<?php echo $lineitem;?>" readonly  />
                                                </td>

                                                <!-- STOCK CODE -->
                                                <td style="width: 130px;">
                                                    <input  type="text"  data-type="stock_code" name="stock_code[]"  class="form-control   autocomplete_txt changesNo stock_code" id="stockcode_<?php

                                                    if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }


                                                    ?>" autocomplete="off" maxlength="11" autofocus >
                                                </td>

                                                <!-- DESCRIPTION -->
                                                <td>
                                                    <input type="text" data-type="description" name="description[]"  class="form-control autocomplete_txt changesNo" id="description_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" autocomplete="off"  size="30">
                                                </td>

                                                <!-- PARTICULARS -->
                                                <td>
                                                    <input type="text" class="form-control particulars"  name="particulars[]<?php echo $counter;?>"  id="particulars" size="50" />
                                                </td>
                                                <input type="hidden" class="form-control available_qty " name="available_qty[]<?php echo $counter;?>" id="availableqty_<?php if($add == "Y") {
                                                    echo $counter;
                                                }

                                                else
                                                {
                                                    echo $lineitem;
                                                }
                                                ?>" />

                                                <!-- QUANTITY -->
                                                <td>
                                                    <input type="number"  class="form-control qty  changesNo qty grand_tot_qty" maxlength="2" name="qty[]<?php echo $counter;?>" id="qty_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;"   />
                                                </td>

                                                <!-- RATE -->
                                                <td>
                                                    <input type="text" class="form-control  changesNo orate" name="rate[]<?php echo $counter;?>" id="orate_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>"  />
                                                </td>


                                                <!-- DISCOUNT -->
                                                <td>
                                                    <input type="text" class="form-control rate changesNo discp" name="discp[]<?php echo $counter;?>" id="discp_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>"   />

                                                </td>


                                                <!-- DISCOUNT AMOUNT -->
                                                <td>
                                                    <input type="text" class="form-control rate changesNo disc_amt" name="disc_amt[]<?php echo $counter;?>" id="discamt_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" readonly  />

                                                </td>








                                                <!-- TOTAL AMOUNT -->
                                                <td>
                                                    <input type="text" class="form-control itemtot totalLinePrice" name="itemtot[]<?php echo $counter;?>" id="itemtot_<?php if($add == "Y") {
                                                        echo $counter;
                                                    }

                                                    else
                                                    {
                                                        echo $lineitem;
                                                    }
                                                    ?>" readonly/>
                                                </td>
                                            </tr>
                                        <?php } ?>


                                        <thead>
                                        <tr>


                                            <?php
                                            if($sale_form == 'mli_sale_invoice')
                                            {
                                            ?>
                                            <td></td>
                                            <td></td>
                                            <?php } ?>

                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>

                                            <td   align="right" >

                                                <input type="text" class="form-control  grandtot_qty" name="grandtot_qty" id="grandtot_qty" autocomplete="off"  readonly value="<?php

                                                if($add == "Y") {
                                                    $_SESSION['tot_qty'] = 0;

                                                }

                                                else
                                                {
                                                    $_SESSION['tot_qty'] = $tot_qty;
                                                }

                                                echo ($_SESSION['tot_qty']);?>" style="width: 100px;  font-weight: bold;" /></td>


                                            <td >


                                            </td>
                                            <td></td>
                                            <td></td>



                                            <td width="10%" colspan="1" align="right">
                                                <input type="text" class="form-control  grandtot " name="grandtot" id="grandtot" autocomplete="off" readonly   value="<?php

                                                if($add == "Y") {
                                                    $_SESSION['itemtot'] = 0;

                                                }

                                                else
                                                {
                                                    $_SESSION['itemtot'] = $itemtot;
                                                }

                                                echo ($_SESSION['itemtot']);?>" style="width: 100px;  font-weight: bold;" />
                                            </td>
                                        </tr>


                                        <tr>

                                            <?php
                                            if($sale_form == 'mli_sale_invoice')
                                            {
                                                ?>
                                                <td></td>
                                                <td></td>
                                            <?php } ?>

                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>

                                            <td align="right">
                                                <b>Discount %</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control ReCalculateNetAmount" name="discp_m" id="discp_m" value="<?php echo ($discp_m); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;"/>
                                            </td>
                                            <td align="right">
                                                <b>Amount</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  disc_amt_m" name="disc_amt_m" id="disc_amt_m" value="<?php echo ($disc_amt_m); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>
                                        </tr>



                                        <tr>

                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Freight</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control ReCalculateNetAmount" name="dc_amt" id="dc_amt" value="<?php echo ($dc_amt); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Invoice Amount</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  net_amt" name="net_amt" id="net_amt" value="<?php echo ($net_amt); ?>" autocomplete="off"  onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" readonly/>
                                            </td>
                                        </tr>

                                        <tr>

                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Advance</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control ReCalculateNetAmount" name="adv_amt" id="adv_amt" value="<?php echo ($adv_amt); ?>" autocomplete="off"  />
                                            </td>
                                        </tr>

                                        <tr>

                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">
                                                <b>Net Payable</b>
                                            </td>
                                            <td width="10%">
                                                <input type="text" class="form-control  net_payable" name="net_payable" id="net_payable" value="<?php echo ($net_payable); ?>" autocomplete="off"  readonly  />
                                            </td>
                                        </tr>

                                        </thead>

                                    </table>

                                    <div id="view"></div>
                                    <div class='row'>
                                        <div class='col-xl-12 col-sm-3 col-md-3 col-lg-3'>
                                            <button class="btn btn-danger delete_sale" type="button">- Delete</button>
                                            <button class="btn btn-success addmore_sale" type="button">+ Add More</button>
                                            <input type="hidden" name="table" id="table" value="<?php echo $table?>"/>
                                            <input type="button" class="btn btn-primary" name="savedata" id="savedata" value="Save" onClick="sale_invoice_add()"/>
                                        </div>
                                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/jquery-ui.js"></script><!--loading bootstrap js-->
    <script src="vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
    <script src="js/html5shiv.js"></script>
    <script src="js/respond.min.js"></script>
    <script src="vendors/metisMenu/jquery.metisMenu.js"></script>
    <script src="vendors/slimScroll/jquery.slimscroll.js"></script>
    <script src="vendors/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendors/iCheck/icheck.min.js"></script>
    <script src="vendors/iCheck/custom.min.js"></script>
    <script src="vendors/jquery-notific8/jquery.notific8.min.js"></script>
    <script src="vendors/jquery-highcharts/highcharts.js"></script>
    <script src="js/jquery.menu.js"></script>
    <script src="vendors/jquery-pace/pace.min.js"></script>
    <script src="vendors/holder/holder.js"></script>
    <script src="vendors/responsive-tabs/responsive-tabs.js"></script>
    <script src="vendors/jquery-news-ticker/jquery.newsTicker.min.js"></script>
    <script src="vendors/moment/moment.js"></script>
    <script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="vendors/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="vendors/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="js/main.js"></script><!--LOADING SCRIPTS FOR PAGE-->
    <script src="vendors/select2/select2.min.js"></script>
    <script src="vendors/bootstrap-select/bootstrap-select.min.js"></script>

    <!---------------------------START JAVASCRIPT-------------------------------->
    <script type="text/javascript">

        //date picker
        $('#v_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true
        });

        //dropdown with search
        $(".acct_id").select2();

        //autocomplete script sale invoice select stock code
        $(document).on('focus','.autocomplete_txt',function(){
            type = $(this).data('type');
            if(type =='stock_code' )autoTypeNo=0;
            if(type =='description' )autoTypeNo=1;
            $(this).autocomplete({
                source: function( request, response ) {
                    $.ajax({
                        url : 'select_stock.php',
                        dataType: "json",
                        method: 'post',
                        data: {
                            name_startsWith: request.term,
                            type: type
                        },
                        success: function( data ) {
                            response( $.map( data, function( item ) {
                                var code = item.split("|");
                                return {
                                    label: code[autoTypeNo],
                                    value: code[autoTypeNo],
                                    data : item
                                }
                            }));
                        }
                    });
                },
                autoFocus: true,
                minLength: 1,

                select: function( event, ui ) {
                    var names = ui.item.data.split("|");
                    id_arr = $(this).attr('id');
                    id = id_arr.split("_");
                    $('#stockcode_'+id[1]).val(names[0]);
                    $('#description_'+id[1]).val(names[1]);
                    $('#orate_'+id[1]).val(names[3]);

                    s_rate =  $('#orate_'+id[1]).val();
                    s_qty =  $('#qty_'+id[1]).val(1);

                    $('#itemtot_' + id[1]).val(1 * names[3]);
                }
            });
        });

        //price change
        $(document).on('change keyup blur','.changesNo',function() {

            id_arr = $(this).attr('id');
            id = id_arr.split("_");
            avqty = $('#availableqty_' + id[1]).val();
            qty = $('#qty_' + id[1]).val();
            orate = $('#orate_' + id[1]).val();
            discp = $('#discp_' + id[1]).val();

            if(orate != '') {
                var final_disc = $('#discamt_' + id[1]).val((parseFloat(orate) * parseFloat(qty) * discp) / 100);
                var final_amt = $('#itemtot_' + id[1]).val(parseFloat(orate) * parseFloat(qty) * (1 - discp / 100));
            }

            grandtot_qty = 0;
            qty = 0;
            $('.grand_tot_qty').each(function () {
                if ($(this).val() != '')grandtot_qty += parseFloat($(this).val());
            });
            $('#grandtot_qty').val(grandtot_qty);
            qty += grandtot_qty;

            grandtot = 0;
            itemtot = 0;
            $('.totalLinePrice').each(function () {
                if ($(this).val() != '')grandtot += parseFloat($(this).val());
            });
            $('#grandtot').val(grandtot);
            itemtot += grandtot;

            ReCalculateNetAmount();
        });

        /****************START NET AMOUNT AFTER DISCOUNT****************/
        function ReCalculateNetAmount() {

            grandtot = $('#grandtot').val();
            discp_m = $('#discp_m').val();

            $('#disc_amt_m').val((parseFloat(grandtot* discp_m)/100).toFixed(0));
            disc_amt_m = $('#disc_amt_m').val();

            if (disc_amt_m == '')
                disc_amt_m=0;

            dc_amt = $('#dc_amt').val();
            if (dc_amt == '')
                dc_amt=0;

            $('#net_amt').val(parseFloat(grandtot) - parseFloat(disc_amt_m) + parseFloat(dc_amt));

            adv_amt = $('#adv_amt').val();
            if (adv_amt == '')
                adv_amt=0;

            $('#net_payable').val(parseFloat(grandtot) - parseFloat(disc_amt_m) + parseFloat(dc_amt) - parseFloat(adv_amt));

        }
        /****************END NET AMOUNT AFTER DISCOUNT****************/


        /*****************START DISCOUNT PERCENTAGE**************/
        $(document).on('change keyup blur', '.changesdiscp', function () {
            grandtot = $('#grandtot').val();
            qty = $('#qty_' + id[1]).val();
            orate = $('#orate_' + id[1]).val();
            discp = $('#discp_' + id[1]).val();
            $('#itemtot_'+id[1]).val( parseFloat(orate)*parseFloat(qty) * (1 - discp / 100) );
        });
        /*****************END DISCOUNT PERCENTAGE**************/


        $(document).on('change keyup blur','.ReCalculateNetAmount',function() {
            ReCalculateNetAmount()
        });

        function sale_invoice_add()
        {
            //declare variables master form
            var v_date = $('#v_date').val();
            var v_id = $('#v_id').val();
            var acct_id = $('#acct_id').val();
            var customer_name = $('#customer_name').val();
            var customer_phone = $('#customer_phone').val();
            var sp = $('#sp_id').val();
            var inv_no = $('#inv_no').val();

            //declare variables detail form
            var stock_code = $('#stockcode_1').val();
            var particulars = $('#particulars').val();
            var qty = $('#qty_1').val();
            var rate = $('#rate').val();
            var discp = $('#discp').val();
            var itemtot = $('#itemtot').val();
            var grand_tot = $('#grandtot').val();

            //check condition
            if(v_date == "")
            {
                alert("Please Enter Date");
                $('#v_date').focus();
            }

            /* else if(sp == "Select SalePerson")
             {
             alert("Please Select Sale Person");
             $('#sp_id').focus();
             }*/

            else if(stock_code == "")
            {
                alert("Please Select Stock Code");
                $('#stockcode_1').focus();
            }

            else if(qty == "" || qty == '0' )
            {
                alert("Please Enter Quantity");
                $('#qty_1').focus();
            }

            else if(rate == "")
            {
                alert("Please Enter Rate");
                $('#rate').focus();
            }

            else
            {
                var formdata = $('#sale_invoice').serializeArray()

                $.ajax({
                    type:"POST",
                    url:"process/process_voucher",
                    data:$.param(formdata),
                    beforeSend: function()
                    {
                        $("#view").html('<div class="loader-block"> <svg id="loader2" viewBox="0 0 100 100"> <circle id="circle-loader2" cx="50" cy="50" r="45"></circle></svg></div><br clear="all">');
                    },
                    success: function(result)
                    {
                        //alert(result);
                        //alert('Voucher has been successfully submitted.');
                        window.location = "<?php echo $menu_detail;?>?v_id=<?php echo $v_id;?>&comp_id=<?php echo $comp_id;?>&year_id=<?php echo $year_id;?>&menu_id=<?php echo $menu_id;?>";
                    }
                });
                $('#savedata').addClass("disabled");
            }
        }

        $(document).on('keydown', function(e){
            if(e.ctrlKey && e.which === 83){ // Check for the Ctrl key being pressed, and if the key = [S] (83)
                //declare variables master form
                var v_date = $('#v_date').val();
                var v_id = $('#v_id').val();
                var acct_id = $('#acct_id').val();
                var customer_name = $('#customer_name').val();
                var customer_phone = $('#customer_phone').val();
                var sp = $('#sp_id').val();

                //declare variables detail form
                var stock_code = $('#stockcode_1').val();
                var StockCode2 = $('#stockcode_2').val();
                var StockCode3 = $('#stockcode_3').val();
                var StockCode4 = $('#stockcode_4').val();
                var StockCode5 = $('#stockcode_5').val();
                var StockCode6 = $('#stockcode_6').val();
                var StockCode7 = $('#stockcode_7').val();
                var StockCode8 = $('#stockcode_8').val();
                var StockCode9 = $('#stockcode_9').val();
                var StockCode10 = $('#stockcode_10').val();
                var particulars = $('#particulars').val();
                var qty = $('#qty_1').val();
                var rate = $('#rate').val();
                var discp = $('#discp').val();
                var itemtot = $('#itemtot').val();
                var grand_tot = $('#grandtot').val();

                //check condition
                if(v_date == "")
                {
                    alert("Please Enter Date");
                    $('#v_date').focus();
                }

                else if(acct_id == "Select Sale Type")
                {
                    alert("Please Select Sale Type");
                    $('#acct_id').focus();
                }

                else if(stock_code == "")
                {
                    alert("Please Select Stock Code");
                    $('#stockcode_1').focus();
                }

                else if(stock_code.length > 11)
                {
                    alert("Please Select Correct Code");
                    $('#stockcode_1').focus();
                }

                else if(stock_code == StockCode2 ||  stock_code == StockCode3 ||  stock_code == StockCode4 ||  stock_code == StockCode5 ||  stock_code == StockCode6
                    ||  stock_code == StockCode7 ||  stock_code == StockCode8 ||  stock_code == StockCode9 ||  stock_code == StockCode10

                )
                {
                    alert("Same Code Not Allowd To Save");

                    $('#stockcode_1').focus();
                }

                else if(qty == "" || qty == '0' )
                {
                    alert("Please Enter Quantity");
                    $('#qty_1').focus();
                }

                else if(rate == "")
                {
                    alert("Please Enter Rate");
                    $('#rate').focus();
                }

                else
                {
                    var formdata = $('#sale_invoice').serializeArray()

                    $.ajax({
                        type:"POST",
                        url:"process/sale_inv_process.php",
                        data:$.param(formdata),
                        beforeSend: function()
                        {
                            $("#view").html('<div class="loader-block"> <svg id="loader2" viewBox="0 0 100 100"> <circle id="circle-loader2" cx="50" cy="50" r="45"></circle></svg></div><br clear="all">');
                        },
                        success: function()
                        {
                            //alert(result);
                            //alert('Voucher has been successfully submitted.');
                            var voucher_id = result;

                            window.location = "sl_inv_detail?v_id=<?php echo $_SESSION['v_id'];?>";
                        }
                    });
                    $('#savedata').addClass("disabled");
                }

                console.log('Ctrl+S!');
                e.preventDefault();
                return false;
            }
        });

        $('#acct_id').change(function(){
            var acct_id = $('#acct_id').val();

            var datasend = 'acct_id='+acct_id ;

            $('#loaderc').fadeIn(400).html('<img src="images/ajax-loader.gif" align="absmiddle">');

            $.ajax({

                type:"POST",
                data:datasend,
                url:'ajax/select_party_contact.php',
                cache:false,
                success:function(msg){

                    // alert(msg);

                    $('#cont_id').html(msg);

                    $('#loaderc').fadeOut("slow");

                }

            });

        });

        $(document).on('change', '#check_all', function () {
            $('input[class = case]:checkbox').prop("checked", $(this).is(':checked'))
        });

        //delete the selected table row
        $(".delete_sale").on('click', function () {
            $('.case:checkbox:checked').parents("tr").remove();
            $("#check_all").prop("checked", false);
            calculateTotal();
            calculateTotal_qty();
        });

        //add table rows
        var i = $('.addrow_sale').length;
        $(".addmore_sale").on('click',function(){
            html = '<tr>';
            html += '<td><input class="case" type="checkbox"/></td>';
            html += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_'+i+'" class="form-control" readonly size="1" value="'+i+'"/></td>';
            html += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_'+i+'" class="form-control autocomplete_txt stock_code" autocomplete="off" maxlength="11"></td>';
            html += '<td><input type="text" data-type="description" name="discription[]" id="description_'+i+'" class="form-control autocomplete_txt" autocomplete="off" ></td>';
            html += '<td><input type="text"  name="particulars[]" id="particulars_'+i+'" class="form-control" autocomplete="off"></td>';
            html += '<input type="hidden" name="available_qty[]" id="availableqty_'+i+'" class="form-control available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;">';
            html += '<td><input type="number" name="qty[]" id="qty_'+i+'" class="form-control qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
            html += '<td><input type="text" name="rate[]" id="orate_'+i+'" class="form-control rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
            html += '<td><input type="text" name="discp[]" id="discp_' + i + '" class="form-control discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
            html += '<td><input type="text" name="disc_amt[]" id="discamt_' + i + '" class="form-control discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';
            html += '<td><input type="text" name="itemtot[]" id="itemtot_'+i+'" class="form-control totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';
            html += '</tr>';
            $('#addrow').append(html);
            i++;
        });
    </script>
    <!---------------------------END JAVASCRIPT-------------------------------->
</body>
</html>