<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'DELIVERY CHALLAN';

        $this->SetFont('Arial', 'B', 18);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(0,10, $rep_name,0,0,'C');
        $this->Ln(10);
//        $this->Ln(10);

    }

}


$pdf = new PDF();

$pdf->AddPage("P");


$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
$vendor_code=find_value('company','vendor_code'," and comp_id='$comp_id'");
if (!empty($vendor_code))
    $vendor_code=' Vendor Code:'.$vendor_code;

$phone=find_value('company','phone'," and comp_id='$comp_id'");
$address=find_value('company','add_line1'," and comp_id='$comp_id'");
$city=find_value('company','city'," and comp_id='$comp_id'");
$ntn=find_value('company','ntn'," and comp_id='$comp_id'");

$pdf->SetFont('Arial', 'BIU', 24);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$v_id = clean_data($_GET['v_id']);

$and ="";
$and .= " and v.comp_id = '$comp_id'";

if (!empty($v_id)) {
    $and .= " and v.voucher_id = '$v_id'";
    $and .= " and v.year_id = '$year_id'";
}else{
    $and .= " and v.voucher_date between '$new_from_date' and '$new_to_date'";
}

try
{
    $voucher_query =  "SELECT v.acct_id, v.voucher_id, v.bill_no, v.voucher_date, c.comp_name, c.add_line1,c.phone,c.email,
                              c.stax_no, c.ntn, p.acct_name party_name, p.address add_line1, p.city, c.phone c_phone, p.phone, p.ntn party_ntn, p.stax_no party_stax_no, p.cnic
                        FROM sl_dc v 
                        LEFT JOIN company c ON c.comp_id = v.comp_id
                        LEFT JOIN v_party p ON p.acct_id = v.acct_id
                        WHERE 1=1  $and
                        ORDER BY v.bill_no
                       ";

//echo $voucher_query;
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}
$num_rows = $voucher_result->rowCount();
$_SESSION["num_rows"] = $num_rows;


while ($report_row = $voucher_result->fetch(PDO::FETCH_ASSOC)) {

$voucher_id=$report_row['voucher_id'];
$phone = $report_row['c_phone'];

$ntn = $report_row['ntn'];
$stax_no = $report_row['stax_no'];

$party_name = $report_row['party_name'];
$p_address = $report_row['add_line1'];
$p_city = $report_row['city'];
$p_phone = $report_row['phone'];
$party_stax_no = $report_row['party_stax_no'];


$pdf->Ln(10);

$pdf->SetFont('Arial', '', 10);
$pdf->Cell(150, 10, 'DC No: '. ($report_row['bill_no']), 0);
$pdf->SetFont('Arial', '', 9);
$pdf->Cell(10);
$pdf->Cell(5, 10, 'DC Date: '.format_date($report_row['voucher_date']).'', 0);
$pdf->Ln(15);
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(70, 8, '', 0);
$pdf->SetLeftMargin('10');
$pdf->Ln(1);



/***********************START SUPPLIER BLOCK******************/
$pdf->SetFont('Arial', 'B', 14);

$pdf->Cell(1);
$pdf->setFillColor(230,230,230);
$pdf->Cell(95, 10, 'SUPPLIER', 1,0,'C', true);
$pdf->Cell(2);
$pdf->setFillColor(230,230,230);
$pdf->Cell(95, 10, 'BUYER', 1,1,'C', true);

$pdf->SetFont('Arial', '', 8);
//SYPPLIER NAME
$pdf->Ln(10);
$pdf->Cell(95, 0, 'Name:   ', 0,1,'L');
$pdf->Cell(12);
$pdf->Cell(95, 0, $comp_name.' '.$vendor_code, 0,1,'L');
$pdf->Cell(12);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//BUYER NAME
$pdf->Cell(97);
$pdf->Cell(95, 0, 'Name:', 0,1,'L');
$pdf->Cell(110);
$pdf->Cell(95, 0, $party_name, 0,1,'L');
$pdf->Cell(110);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


$pdf->Ln(2);

//SUPPLIER ADDRESS
$pdf->Ln(10);
$pdf->Cell(95, 0, 'Address:', 0,1,'L');
$pdf->Cell(12);
$pdf->Cell(95, 0, substr($address,0,50), 0,1,'L');


$pdf->Cell(97);
$pdf->Cell(95, 0, 'Address:', 0,1,'L');


$pdf->Cell(110);
$pdf->Cell(95, 0, $p_address, 0,1,'L');

$pdf->Cell(12);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

$pdf->Cell(110);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


$pdf->Ln(10);
$pdf->Cell(95, 0, 'City:', 0,1,'L');
$pdf->Cell(12);
$pdf->Cell(95, 0, substr($city,0,50), 0,1,'L');


$pdf->Cell(97);
$pdf->Cell(95, 0, 'City:', 0,1,'L');


$pdf->Cell(110);
$pdf->Cell(95, 0, $p_city, 0,1,'L');

$pdf->Cell(12);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

$pdf->Cell(110);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


//BUYER ADDRESS


$pdf->Ln(2);

//SUPPLIER PHONE
$pdf->Ln(10);
$pdf->Cell(95, 0, 'Phone:', 0,1,'L');
$pdf->Cell(12);
$pdf->Cell(95, 0, $phone, 0,1,'L');
$pdf->Cell(12);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


//BUYER PHONE
$pdf->Cell(97);
$pdf->Cell(95, 0, 'Phone:', 0,1,'L');
$pdf->Cell(110);
$pdf->Cell(95, 0, $p_phone, 0,1,'L');
$pdf->Cell(110);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');



$pdf->Ln(2);

//SUPPLIER SALE TAX
$pdf->Ln(10);
$pdf->Cell(95, 0, 'S TAX#:', 0,1,'L');
$pdf->Cell(97);
$pdf->Cell(95, 0, 'S TAX#:', 0,1,'L');


$pdf->Cell(12);
$pdf->Cell(95, 0, $stax_no, 0,1,'L');
$pdf->Cell(110);
$pdf->Cell(95, 0, $party_stax_no, 0,1,'L');



$pdf->Cell(12);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');
$pdf->Cell(110);
$pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


$pdf->Ln(5);


/***********************END SUPPLIER BLOCK******************/

/*****************END MASTER TABLE QUERY*****************/

    $pdf->Cell(1);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(7, 8, 'Sr', 1);
    $pdf->Cell(22, 8, 'D I #', 1, 0, 'C');
    $pdf->Cell(18, 8, 'Item Code', 1, 0, 'C');
    $pdf->Cell(22, 8, 'Part No', 1, 0, 'C');
    $pdf->Cell(55, 8, 'Part Description', 1);
    $pdf->Cell(17, 8, 'Qty/Pack', 1, 0,'R');
    $pdf->Cell(17, 8, 'No of Pack', 1, 0,'R');
    $pdf->Cell(17, 8, 'Total Qty', 1, 0,'R');
    $pdf->Cell(20, 8, 'Remarks', 1, 0,'R');
    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);



try
{
    $vd_query =  "SELECT
	d.stock_code,
	d.qty,
	d.pack_no,
	d.qty/d.pack_no pack_qty,
	d.voucher_id,
	i.description,
    d.di_no,
    ip.part_no,
    ip.item_no
    
 	FROM sl_dc v 
 	LEFT JOIN sl_dcdet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id and v.year_id=d.year_id
	LEFT JOIN item i ON d.stock_code = i.stock_code
    LEFT JOIN item_party ip on v.acct_id=ip.acct_id and d.stock_code=ip.stock_code
 	WHERE 1=1 $and and v.voucher_id='$voucher_id'
 	ORDER BY d.lineitem";

//echo $vd_query;

    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$sr = "";
$tot_ex_value=0;
$tot_r_stax=0;
$tot_add_stax=0;
$tot_stax=0;
$tot_r_stax=0;
$tot_itemtot=0;
$tot_qty=0;
$total_stax = "";

while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

    $tot_ex_value += $rd_row['ex_value'];
    $tot_itemtot += $rd_row['itemtot'];
    $tot_qty += $rd_row['qty'];

    $sr += 1;
    $pdf->Cell(1);
    $pdf->Cell(7, 8, $sr.'.', 1);
    $pdf->Cell(22, 8, $rd_row['di_no'], 1, 0, 'C');
    $pdf->Cell(18, 8, $rd_row['item_no'], 1, 0, 'C');
    $pdf->Cell(22, 8, $rd_row['part_no'], 1, 0, 'C');
    $pdf->Cell(55, 8, $rd_row['description'], 1);
    $pdf->Cell(17, 8, format_number_pdf($rd_row['pack_qty'],0), 1, 0,'R');
    $pdf->Cell(17, 8, format_number_pdf($rd_row['pack_no'],0), 1, 0,'R');
    $pdf->Cell(17, 8, format_number_pdf($rd_row['qty'],0), 1, 0,'R');
    $pdf->Cell(20, 8, '', 1);

    $pdf->Ln(8);
}

    while ($sr<10){
        $sr += 1;
        $pdf->Cell(1);
        $pdf->Cell(7, 8, $sr.'.', 1);
        $pdf->Cell(22, 8, '', 1);
        $pdf->Cell(18, 8, '', 1);
        $pdf->Cell(22, 8, '', 1);
        $pdf->Cell(55, 8, '', 1);
        $pdf->Cell(17, 8, '', 1);
        $pdf->Cell(17, 8, '', 1);
        $pdf->Cell(17, 8, '', 1);
        $pdf->Cell(20, 8, '', 1);
        $pdf->Ln(8);
    }

$pdf->Ln(12);









    if( $report_row['acct_id'] === '2610000014') {

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(55, 5, 'Signature', 1, 0, 'C');


        $pdf->Ln(5);

        $pdf->Cell(55, 20, '', 1, 0, 'C');

    }
    else
    {
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(55, 5, 'Dispatch Stamp', 1, 0, 'C');
        $pdf->Cell(15);
        $pdf->Cell(55, 5, 'PSMCL Security Stamp', 1, 0, 'C');
        $pdf->Cell(15);
        $pdf->Cell(55, 5, 'MHD Receiving Stamp', 1, 0, 'C');

        $pdf->Ln(5);

        $pdf->Cell(55, 20, '', 1, 0, 'C');
        $pdf->Cell(15);
        $pdf->Cell(55, 20, '', 1, 0, 'C');
        $pdf->Cell(15);
        $pdf->Cell(55, 20, '', 1, 0, 'C');

    }






    if ($_SESSION["num_rows"]>1)
        $pdf->AddPage("P");

}
$pdf->Output();
